/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.AbstractTeXObject;
import com.dickimawbooks.texparserlib.SingleToken;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import java.io.IOException;

public abstract class CharObject
extends AbstractTeXObject
implements SingleToken {
    protected int charCode;

    public CharObject(int n) {
        this.setCharCode(n);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CharObject) || object == null) {
            return false;
        }
        return ((CharObject)object).getCharCode() == this.getCharCode();
    }

    @Override
    public abstract Object clone();

    @Override
    public String toString(TeXParser teXParser) {
        return teXParser.getSettings().getCharString(this.charCode);
    }

    public String toString() {
        return String.format("%s[%s]", this.getClass().getSimpleName(), this.format());
    }

    @Override
    public String format() {
        return new String(Character.toChars(this.getCharCode()));
    }

    @Override
    public String purified() {
        return this.format();
    }

    @Override
    public TeXObjectList string(TeXParser teXParser) throws IOException {
        TeXObjectList teXObjectList = new TeXObjectList();
        teXObjectList.add(this);
        return teXObjectList;
    }

    @Override
    public int getCharCode() {
        return this.charCode;
    }

    public void setCharCode(int n) {
        this.charCode = n;
    }

    public int getMappedCharCode(TeXParser teXParser) {
        int n = teXParser.getSettings().getCharCode(this.charCode);
        return n == -1 ? this.charCode : n;
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        teXParser.getListener().getWriteable().writeCodePoint(this.getMappedCharCode(teXParser));
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this.process(teXParser);
    }
}

