/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyGlobalStatement;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.impl.ParamHelper;
import com.jetbrains.python.validation.PyAnnotationHolder;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class PyGlobalAnnotatorVisitor
extends PyElementVisitor {
    @NotNull
    private final PyAnnotationHolder myHolder;

    public PyGlobalAnnotatorVisitor(@NotNull PyAnnotationHolder holder) {
        if (holder == null) {
            PyGlobalAnnotatorVisitor.$$$reportNull$$$0(0);
        }
        this.myHolder = holder;
    }

    public void visitPyGlobalStatement(@NotNull PyGlobalStatement node) {
        PyFunction function;
        if (node == null) {
            PyGlobalAnnotatorVisitor.$$$reportNull$$$0(1);
        }
        if ((function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)node, PyFunction.class)) != null) {
            PyParameterList paramList = function.getParameterList();
            final HashSet paramNames = new HashSet();
            ParamHelper.walkDownParamArray(paramList.getParameters(), new ParamHelper.ParamVisitor(this){

                @Override
                public void visitNamedParameter(PyNamedParameter param, boolean first, boolean last) {
                    paramNames.add(param.getName());
                }
            });
            for (PyTargetExpression expr : node.getGlobals()) {
                String expr_name = expr.getReferencedName();
                if (!paramNames.contains(expr_name)) continue;
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, PyPsiBundle.message("ANN.name.used.both.as.global.and.param", expr_name)).range((PsiElement)expr).create();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/validation/PyGlobalAnnotatorVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPyGlobalStatement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

