/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import org.jooq.Clause;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.Param;
import org.jooq.SortField;
import org.jooq.SortOrder;
import org.jooq.impl.AbstractQueryPart;
import org.jooq.impl.DSL;
import org.jooq.impl.Keywords;

final class SortFieldImpl<T>
extends AbstractQueryPart
implements SortField<T> {
    private static final long serialVersionUID = 1223739398544155873L;
    private final Field<T> field;
    private final SortOrder order;
    private boolean nullsFirst;
    private boolean nullsLast;

    SortFieldImpl(Field<T> field, SortOrder order) {
        this.field = field;
        this.order = order;
    }

    @Override
    public final String getName() {
        return this.field.getName();
    }

    @Override
    public final SortOrder getOrder() {
        return this.order;
    }

    final Field<T> getField() {
        return this.field;
    }

    final boolean getNullsFirst() {
        return this.nullsFirst;
    }

    final boolean getNullsLast() {
        return this.nullsLast;
    }

    @Override
    public final SortField<T> nullsFirst() {
        this.nullsFirst = true;
        this.nullsLast = false;
        return this;
    }

    @Override
    public final SortField<T> nullsLast() {
        this.nullsFirst = false;
        this.nullsLast = true;
        return this;
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.nullsFirst || this.nullsLast) {
            switch (ctx.family()) {
                case CUBRID: 
                case MARIADB: 
                case MYSQL: 
                case SQLITE: {
                    Param<Integer> ifNull = this.nullsFirst ? DSL.zero() : DSL.one();
                    Param<Integer> ifNotNull = this.nullsFirst ? DSL.one() : DSL.zero();
                    ctx.visit(DSL.nvl2(this.field, ifNotNull, ifNull)).sql(", ");
                    this.acceptFieldAndOrder(ctx);
                    break;
                }
                default: {
                    this.acceptFieldAndOrder(ctx);
                    if (this.nullsFirst) {
                        ctx.sql(' ').visit(Keywords.K_NULLS_FIRST);
                        break;
                    }
                    ctx.sql(' ').visit(Keywords.K_NULLS_LAST);
                    break;
                }
            }
        } else {
            this.acceptFieldAndOrder(ctx);
        }
    }

    private final void acceptFieldAndOrder(Context<?> ctx) {
        ctx.visit(this.field);
        if (this.order != SortOrder.DEFAULT) {
            ctx.sql(' ').visit(this.order.toKeyword());
        }
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return null;
    }
}

