/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.util;

import io.grpc.Status;
import org.opensearch.core.rest.RestStatus;

public class RestToGrpcStatusConverter {
    private RestToGrpcStatusConverter() {
    }

    public static int getGrpcStatusCode(RestStatus restStatus) {
        return RestToGrpcStatusConverter.convertRestToGrpcStatus(restStatus).getCode().value();
    }

    protected static Status convertRestToGrpcStatus(RestStatus restStatus) {
        switch (restStatus) {
            case CONTINUE: 
            case SWITCHING_PROTOCOLS: {
                return Status.OK;
            }
            case OK: 
            case CREATED: 
            case ACCEPTED: 
            case NON_AUTHORITATIVE_INFORMATION: 
            case NO_CONTENT: 
            case RESET_CONTENT: 
            case PARTIAL_CONTENT: 
            case MULTI_STATUS: {
                return Status.OK;
            }
            case MULTIPLE_CHOICES: 
            case MOVED_PERMANENTLY: 
            case FOUND: 
            case SEE_OTHER: 
            case NOT_MODIFIED: 
            case USE_PROXY: 
            case TEMPORARY_REDIRECT: {
                return Status.FAILED_PRECONDITION;
            }
            case BAD_REQUEST: 
            case REQUEST_URI_TOO_LONG: 
            case UNPROCESSABLE_ENTITY: {
                return Status.INVALID_ARGUMENT;
            }
            case UNAUTHORIZED: 
            case PAYMENT_REQUIRED: 
            case FORBIDDEN: {
                return Status.PERMISSION_DENIED;
            }
            case NOT_FOUND: 
            case GONE: {
                return Status.NOT_FOUND;
            }
            case METHOD_NOT_ALLOWED: {
                return Status.UNIMPLEMENTED;
            }
            case NOT_ACCEPTABLE: 
            case UNSUPPORTED_MEDIA_TYPE: {
                return Status.INVALID_ARGUMENT;
            }
            case PROXY_AUTHENTICATION: {
                return Status.UNAUTHENTICATED;
            }
            case REQUEST_TIMEOUT: 
            case GATEWAY_TIMEOUT: {
                return Status.DEADLINE_EXCEEDED;
            }
            case CONFLICT: {
                return Status.ABORTED;
            }
            case LENGTH_REQUIRED: 
            case PRECONDITION_FAILED: 
            case EXPECTATION_FAILED: {
                return Status.FAILED_PRECONDITION;
            }
            case REQUEST_ENTITY_TOO_LARGE: 
            case REQUESTED_RANGE_NOT_SATISFIED: {
                return Status.OUT_OF_RANGE;
            }
            case MISDIRECTED_REQUEST: {
                return Status.INVALID_ARGUMENT;
            }
            case LOCKED: 
            case FAILED_DEPENDENCY: {
                return Status.FAILED_PRECONDITION;
            }
            case TOO_MANY_REQUESTS: {
                return Status.RESOURCE_EXHAUSTED;
            }
            case INTERNAL_SERVER_ERROR: {
                return Status.INTERNAL;
            }
            case NOT_IMPLEMENTED: 
            case HTTP_VERSION_NOT_SUPPORTED: {
                return Status.UNIMPLEMENTED;
            }
            case BAD_GATEWAY: 
            case SERVICE_UNAVAILABLE: {
                return Status.UNAVAILABLE;
            }
            case INSUFFICIENT_STORAGE: {
                return Status.RESOURCE_EXHAUSTED;
            }
        }
        return Status.UNKNOWN;
    }
}

