/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl.function.hmap;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.multimap.impl.ExternalizerIds;
import org.infinispan.multimap.impl.HashMapBucket;
import org.infinispan.multimap.impl.function.hmap.HashMapBucketBaseFunction;

public class HashMapPutFunction<K, HK, HV>
extends HashMapBucketBaseFunction<K, HK, HV, Integer> {
    public static final AdvancedExternalizer<HashMapPutFunction> EXTERNALIZER = new Externalizer();
    private final Collection<Map.Entry<HK, HV>> entries;
    private final boolean putIfAbsent;

    public HashMapPutFunction(Collection<Map.Entry<HK, HV>> entries) {
        this(entries, false);
    }

    public HashMapPutFunction(Collection<Map.Entry<HK, HV>> entries, boolean putIfAbsent) {
        this.entries = entries;
        this.putIfAbsent = putIfAbsent;
    }

    public Integer apply(EntryView.ReadWriteEntryView<K, HashMapBucket<HK, HV>> view) {
        Map<Object, Object> values = this.entries.stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Optional existing = view.peek();
        if (existing.isEmpty()) {
            view.set(HashMapBucket.create(values), new MetaParam.Writable[0]);
            return values.size();
        }
        HashMapBucket bucket = (HashMapBucket)existing.get();
        HashMapBucket.HashMapBucketResponse<Integer, Object, Object> res = this.putIfAbsent ? bucket.putIfAbsent(values) : bucket.putAll(values);
        view.set(res.bucket(), new MetaParam.Writable[0]);
        return res.response();
    }

    public static class Externalizer
    implements AdvancedExternalizer<HashMapPutFunction> {
        public Set<Class<? extends HashMapPutFunction>> getTypeClasses() {
            return Collections.singleton(HashMapPutFunction.class);
        }

        public Integer getId() {
            return ExternalizerIds.HASH_MAP_PUT_FUNCTION;
        }

        public void writeObject(ObjectOutput output, HashMapPutFunction object) throws IOException {
            output.writeInt(object.entries.size());
            Collection e = object.entries;
            for (Map.Entry entry : e) {
                output.writeObject(entry.getKey());
                output.writeObject(entry.getValue());
            }
            output.writeBoolean(object.putIfAbsent);
        }

        public HashMapPutFunction<?, ?, ?> readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            int size = input.readInt();
            HashMap<Object, Object> values = new HashMap<Object, Object>(size);
            for (int i = 0; i < size; ++i) {
                values.put(input.readObject(), input.readObject());
            }
            return new HashMapPutFunction(values.entrySet(), input.readBoolean());
        }
    }
}

