/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.util.Escape;
import org.jmol.util.Logger;

public class TlsDataOnlyReader
extends AtomSetCollectionReader {
    private Lst<Map<String, Object>> vTlsModels;
    private SB sbTlsErrors;
    private int tlsGroupID;
    private static final String[] TLnn = new String[]{"11", "22", "33", "12", "13", "23"};
    private static final String[] Snn = new String[]{"22", "11", "12", "13", "23", "21", "31", "32"};

    @Override
    protected void initializeReader() throws Exception {
        this.readTlsData();
        this.continuing = false;
    }

    private void readTlsData() throws Exception {
        this.vTlsModels = new Lst();
        Hashtable<String, Object> tlsGroup = null;
        Lst ranges = null;
        Hashtable<String, Object> range = null;
        Lst tlsGroups = new Lst();
        while (this.rd() != null) {
            int i;
            String[] tokens = PT.getTokens(this.line.replace('\'', ' '));
            if (tokens.length == 0) continue;
            if (tokens[0].equals("TLS")) {
                tlsGroup = new Hashtable<String, Object>();
                ranges = new Lst();
                tlsGroup.put("ranges", ranges);
                tlsGroups.addLast(tlsGroup);
                tlsGroup.put("id", ++this.tlsGroupID);
                continue;
            }
            if (tokens[0].equals("RANGE")) {
                range = new Hashtable<String, Object>();
                char chain1 = tokens[1].charAt(0);
                char chain2 = tokens[3].charAt(0);
                int res1 = PT.parseInt(tokens[2]);
                int res2 = PT.parseInt(tokens[4]);
                if (chain1 == chain2) {
                    range.put("chains", "" + chain1 + chain2);
                    if (res1 <= res2) {
                        range.put("residues", new int[]{res1, res2});
                        ranges.addLast(range);
                        continue;
                    }
                    this.tlsAddError(" TLS group residues are not in order (range ignored)");
                    continue;
                }
                this.tlsAddError(" TLS group chains are different (range ignored)");
                continue;
            }
            if (tokens[0].equals("ORIGIN")) {
                P3 origin = new P3();
                tlsGroup.put("origin", origin);
                origin.set(this.parseFloatStr(tokens[1]), this.parseFloatStr(tokens[2]), this.parseFloatStr(tokens[3]));
                if (!Float.isNaN(origin.x) && !Float.isNaN(origin.y) && !Float.isNaN(origin.z)) continue;
                origin.set(Float.NaN, Float.NaN, Float.NaN);
                this.tlsAddError("invalid origin: " + this.line);
                continue;
            }
            if (!tokens[0].equals("T") && !tokens[0].equals("L") && !tokens[0].equals("S")) continue;
            char tensorType = tokens[0].charAt(0);
            String[] nn = tensorType == 'S' ? Snn : TLnn;
            float[][] tensor = new float[3][3];
            tlsGroup.put("t" + tensorType, tensor);
            for (i = 1; i < tokens.length; ++i) {
                int ti = nn[i].charAt(0) - 49;
                int tj = nn[i].charAt(1) - 49;
                tensor[ti][tj] = this.parseFloatStr(tokens[++i]);
                if (ti >= tj) continue;
                tensor[tj][ti] = tensor[ti][tj];
            }
            if (tensorType == 'S') {
                tensor[0][0] = -tensor[0][0];
            }
            for (i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    if (!Float.isNaN(tensor[i][j])) continue;
                    this.tlsAddError("invalid tensor: " + Escape.escapeFloatAA(tensor, false));
                }
            }
        }
        Logger.info(this.tlsGroupID + " TLS groups read");
        Hashtable<String, Serializable> groups = new Hashtable<String, Serializable>();
        groups.put("groupCount", Integer.valueOf(this.tlsGroupID));
        groups.put("groups", tlsGroups);
        this.vTlsModels.addLast((Map<String, Object>)groups);
        this.htParams.put("vTlsModels", this.vTlsModels);
    }

    private void tlsAddError(String error) {
        if (this.sbTlsErrors == null) {
            this.sbTlsErrors = new SB();
        }
        this.sbTlsErrors.append(this.fileName).appendC('\t').append("TLS group ").appendI(this.tlsGroupID).appendC('\t').append(error).appendC('\n');
    }
}

