/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Fills in holes and cavities by iteratively applying a voting
operation.


This filter uses internally the VotingBinaryHoleFillingImageFilter , and runs it iteratively until no pixels are being changed or until
it reaches the maximum number of iterations. The purpose of the filter
is to fill in holes of medium size (tens of pixels in radius). In
principle the number of iterations is related to the size of the holes
to be filled in. The larger the holes, the more iteration must be run
with this filter in order to fill in the full hole. The size of the
neighborhood is also related to the curvature of the hole borders and
therefore the hole size. Note that as a collateral effect this filter
may also fill in cavities in the external side of structures.

This filter is templated over a single image type because the output
image type must be the same as the input image type. This is required
in order to make the iterations possible, since the output image of
one iteration is taken as the input image for the next iteration.


See:
 Image

 VotingBinaryImageFilter

 VotingBinaryHoleFillingImageFilter

 Neighborhood

 NeighborhoodOperator

 NeighborhoodIterator

 itk::simple::VotingBinaryIterativeHoleFilling for the procedural interface

 itk::VotingBinaryIterativeHoleFillingImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkVotingBinaryIterativeHoleFillingImageFilter.h
*/
public class VotingBinaryIterativeHoleFillingImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected VotingBinaryIterativeHoleFillingImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.VotingBinaryIterativeHoleFillingImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(VotingBinaryIterativeHoleFillingImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(VotingBinaryIterativeHoleFillingImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::VotingBinaryIterativeHoleFillingImageFilter::~VotingBinaryIterativeHoleFillingImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_VotingBinaryIterativeHoleFillingImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::VotingBinaryIterativeHoleFillingImageFilter::VotingBinaryIterativeHoleFillingImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  VotingBinaryIterativeHoleFillingImageFilter() {
    this(SimpleITKJNI.new_VotingBinaryIterativeHoleFillingImageFilter(), true);
  }

  /**
Self&amp; itk::simple::VotingBinaryIterativeHoleFillingImageFilter::SetRadius(unsigned int value)

Set the values of the Radius vector all to value

*/
public  void setRadius(VectorUInt32 Radius) {
    SimpleITKJNI.VotingBinaryIterativeHoleFillingImageFilter_setRadius__SWIG_0(swigCPtr, this, VectorUInt32.getCPtr(Radius), Radius);
  }

  /**
Self&amp; itk::simple::VotingBinaryIterativeHoleFillingImageFilter::SetRadius(unsigned int value)

Set the values of the Radius vector all to value

*/
public  void setRadius(long value) {
    SimpleITKJNI.VotingBinaryIterativeHoleFillingImageFilter_setRadius__SWIG_1(swigCPtr, this, value);
  }

  /**
std::vector&lt;unsigned int&gt; itk::simple::VotingBinaryIterativeHoleFillingImageFilter::GetRadius() const

Get the radius of the neighborhood used to compute the median

*/
public  VectorUInt32 getRadius() {
    return new VectorUInt32(SimpleITKJNI.VotingBinaryIterativeHoleFillingImageFilter_getRadius(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::VotingBinaryIterativeHoleFillingImageFilter::SetMaximumNumberOfIterations(unsigned int MaximumNumberOfIterations)

Maximum number of iterations. This filter is executed iteratively as
long as at least one pixel has changed in a previous iteration, or
until the maximum number of iterations has been reached.

*/
public  void setMaximumNumberOfIterations(long MaximumNumberOfIterations) {
    SimpleITKJNI.VotingBinaryIterativeHoleFillingImageFilter_setMaximumNumberOfIterations(swigCPtr, this, MaximumNumberOfIterations);
  }

  /**
unsigned int itk::simple::VotingBinaryIterativeHoleFillingImageFilter::GetMaximumNumberOfIterations() const

Maximum number of iterations. This filter is executed iteratively as
long as at least one pixel has changed in a previous iteration, or
until the maximum number of iterations has been reached.

*/
public  long getMaximumNumberOfIterations() {
    return SimpleITKJNI.VotingBinaryIterativeHoleFillingImageFilter_getMaximumNumberOfIterations(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::VotingBinaryIterativeHoleFillingImageFilter::SetMajorityThreshold(unsigned int MajorityThreshold)

Majority threshold. It is the number of pixels over 50% that will
decide whether an OFF pixel will become ON or not. For example, if the
neighborhood of a pixel has 124 pixels (excluding itself), the 50%
will be 62, and if you set up a Majority threshold of 5, that means
that the filter will require 67 or more neighbor pixels to be ON in
order to switch the current OFF pixel to ON. The default value is 1.

*/
public  void setMajorityThreshold(long MajorityThreshold) {
    SimpleITKJNI.VotingBinaryIterativeHoleFillingImageFilter_setMajorityThreshold(swigCPtr, this, MajorityThreshold);
  }

  /**
unsigned int itk::simple::VotingBinaryIterativeHoleFillingImageFilter::GetMajorityThreshold() const

Majority threshold. It is the number of pixels over 50% that will
decide whether an OFF pixel will become ON or not. For example, if the
neighborhood of a pixel has 124 pixels (excluding itself), the 50%
will be 62, and if you set up a Majority threshold of 5, that means
that the filter will require 67 or more neighbor pixels to be ON in
order to switch the current OFF pixel to ON. The default value is 1.

*/
public  long getMajorityThreshold() {
    return SimpleITKJNI.VotingBinaryIterativeHoleFillingImageFilter_getMajorityThreshold(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::VotingBinaryIterativeHoleFillingImageFilter::SetForegroundValue(double ForegroundValue)

Set the value associated with the Foreground (or the object) on the
binary input image and the Background .

*/
public  void setForegroundValue(double ForegroundValue) {
    SimpleITKJNI.VotingBinaryIterativeHoleFillingImageFilter_setForegroundValue(swigCPtr, this, ForegroundValue);
  }

  /**
double itk::simple::VotingBinaryIterativeHoleFillingImageFilter::GetForegroundValue() const

Get the value associated with the Foreground (or the object) on the
binary input image and the Background .

*/
public  double getForegroundValue() {
    return SimpleITKJNI.VotingBinaryIterativeHoleFillingImageFilter_getForegroundValue(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::VotingBinaryIterativeHoleFillingImageFilter::SetBackgroundValue(double BackgroundValue)

Set the value associated with the Foreground (or the object) on the
binary input image and the Background .

*/
public  void setBackgroundValue(double BackgroundValue) {
    SimpleITKJNI.VotingBinaryIterativeHoleFillingImageFilter_setBackgroundValue(swigCPtr, this, BackgroundValue);
  }

  /**
double itk::simple::VotingBinaryIterativeHoleFillingImageFilter::GetBackgroundValue() const

Get the value associated with the Foreground (or the object) on the
binary input image and the Background .

*/
public  double getBackgroundValue() {
    return SimpleITKJNI.VotingBinaryIterativeHoleFillingImageFilter_getBackgroundValue(swigCPtr, this);
  }

  /**
std::string itk::simple::VotingBinaryIterativeHoleFillingImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.VotingBinaryIterativeHoleFillingImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::VotingBinaryIterativeHoleFillingImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.VotingBinaryIterativeHoleFillingImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::VotingBinaryIterativeHoleFillingImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.VotingBinaryIterativeHoleFillingImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
