/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.provider.annotate;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.AnnotationProviderEx;
import com.intellij.vcsUtil.VcsUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgBundle;
import org.zmlx.hg4idea.HgFile;
import org.zmlx.hg4idea.HgFileRevision;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.command.HgAnnotateCommand;
import org.zmlx.hg4idea.command.HgWorkingCopyRevisionsCommand;
import org.zmlx.hg4idea.provider.HgHistoryProvider;
import org.zmlx.hg4idea.provider.annotate.HgAnnotation;
import org.zmlx.hg4idea.provider.annotate.HgAnnotationLine;
import org.zmlx.hg4idea.util.HgUtil;

public class HgAnnotationProvider
implements AnnotationProviderEx {
    @NotNull
    private final Project myProject;

    public HgAnnotationProvider(@NotNull Project project) {
        if (project == null) {
            HgAnnotationProvider.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    public boolean isAnnotationValid(@NotNull FilePath path, @NotNull VcsRevisionNumber revisionNumber) {
        if (path == null) {
            HgAnnotationProvider.$$$reportNull$$$0(1);
        }
        if (revisionNumber == null) {
            HgAnnotationProvider.$$$reportNull$$$0(2);
        }
        return revisionNumber instanceof HgRevisionNumber;
    }

    @NotNull
    public FileAnnotation annotate(@NotNull VirtualFile file) throws VcsException {
        if (file == null) {
            HgAnnotationProvider.$$$reportNull$$$0(3);
        }
        FileAnnotation fileAnnotation = this.annotate(file, null);
        if (fileAnnotation == null) {
            HgAnnotationProvider.$$$reportNull$$$0(4);
        }
        return fileAnnotation;
    }

    @NotNull
    public FileAnnotation annotate(@NotNull VirtualFile file, VcsFileRevision revision) throws VcsException {
        VirtualFile vcsRoot;
        if (file == null) {
            HgAnnotationProvider.$$$reportNull$$$0(5);
        }
        if ((vcsRoot = VcsUtil.getVcsRootFor((Project)this.myProject, (FilePath)VcsUtil.getFilePath((String)file.getPath()))) == null) {
            throw new VcsException(HgBundle.message("error.cannot.find.repository.for.file", file.getPresentableUrl()));
        }
        HgRevisionNumber revisionNumber = revision != null ? (HgRevisionNumber)revision.getRevisionNumber() : null;
        HgFile hgFile = new HgFile(vcsRoot, VfsUtilCore.virtualToIoFile((VirtualFile)file));
        HgFile fileToAnnotate = revision instanceof HgFileRevision ? HgUtil.getFileNameInTargetRevision(this.myProject, revisionNumber, hgFile) : new HgFile(vcsRoot, HgUtil.getOriginalFileName(hgFile.toFilePath(), ChangeListManager.getInstance((Project)this.myProject)));
        List<HgAnnotationLine> annotationResult = new HgAnnotateCommand(this.myProject).execute(fileToAnnotate, revisionNumber);
        List<HgFileRevision> logResult = HgHistoryProvider.getHistoryOrFail(revision == null ? hgFile.toFilePath() : fileToAnnotate.toFilePath(), vcsRoot, this.myProject, null, -1);
        return new HgAnnotation(this.myProject, hgFile, annotationResult, logResult, revisionNumber != null ? revisionNumber : new HgWorkingCopyRevisionsCommand(this.myProject).tip(vcsRoot));
    }

    @NotNull
    public FileAnnotation annotate(@NotNull FilePath path, @NotNull VcsRevisionNumber revision) throws VcsException {
        VirtualFile vcsRoot;
        if (path == null) {
            HgAnnotationProvider.$$$reportNull$$$0(6);
        }
        if (revision == null) {
            HgAnnotationProvider.$$$reportNull$$$0(7);
        }
        if ((vcsRoot = VcsUtil.getVcsRootFor((Project)this.myProject, (FilePath)path)) == null) {
            throw new VcsException(HgBundle.message("error.cannot.find.repository.for.file", path.getPresentableUrl()));
        }
        HgFile hgFile = new HgFile(vcsRoot, path);
        List<HgAnnotationLine> annotationResult = new HgAnnotateCommand(this.myProject).execute(hgFile, (HgRevisionNumber)revision);
        List<HgFileRevision> logResult = HgHistoryProvider.getHistoryOrFail(hgFile.toFilePath(), vcsRoot, this.myProject, (HgRevisionNumber)revision, -1);
        return new HgAnnotation(this.myProject, hgFile, annotationResult, logResult, revision);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revisionNumber";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/zmlx/hg4idea/provider/annotate/HgAnnotationProvider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/zmlx/hg4idea/provider/annotate/HgAnnotationProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "annotate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAnnotationValid";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

