/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server.indexer;

import java.util.Arrays;
import java.util.Collection;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.IndexerField;
import org.apache.maven.index.IndexerFieldVersion;
import org.apache.maven.index.MAVEN;
import org.apache.maven.index.creator.MinimalArtifactInfoIndexCreator;

@Singleton
@Named(value="idea-tiny")
public class TinyArtifactInfoIndexCreator
extends MinimalArtifactInfoIndexCreator {
    public static final String ID = "idea-tiny";
    private static final FieldType STORED_NOT_INDEXED = new FieldType();
    private static final IndexerField FLD_PACKAGING_NOT_INDEXED;
    private static final IndexerField FLD_DESCRIPTION_NOT_INDEXED;

    public void updateDocument(ArtifactInfo ai, Document doc) {
        if (ai.getPackaging() != null) {
            doc.add((IndexableField)FLD_PACKAGING_NOT_INDEXED.toField(ai.getPackaging()));
        }
        if ("maven-archetype".equals(ai.getPackaging()) && ai.getDescription() != null) {
            doc.add((IndexableField)FLD_DESCRIPTION_NOT_INDEXED.toField(ai.getDescription()));
        }
    }

    public Collection<IndexerField> getIndexerFields() {
        return Arrays.asList(FLD_PACKAGING_NOT_INDEXED, FLD_DESCRIPTION_NOT_INDEXED);
    }

    static {
        STORED_NOT_INDEXED.setIndexOptions(IndexOptions.NONE);
        STORED_NOT_INDEXED.setStored(true);
        STORED_NOT_INDEXED.setTokenized(false);
        STORED_NOT_INDEXED.freeze();
        FLD_PACKAGING_NOT_INDEXED = new IndexerField(MAVEN.PACKAGING, IndexerFieldVersion.V1, ArtifactInfo.PACKAGING, "Artifact Packaging (not indexed, stored)", STORED_NOT_INDEXED);
        FLD_DESCRIPTION_NOT_INDEXED = new IndexerField(MAVEN.DESCRIPTION, IndexerFieldVersion.V1, ArtifactInfo.DESCRIPTION, "Artifact description (not indexed, stored)", STORED_NOT_INDEXED);
    }
}

