/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import java.io.File;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.server.DownloadArtifactEvent;
import org.jetbrains.idea.maven.server.MavenArtifactEvent;
import org.jetbrains.idea.maven.server.MavenRemotePullUtil;
import org.jetbrains.idea.maven.server.MavenServerConsoleEvent;
import org.jetbrains.idea.maven.server.MavenServerConsoleIndicator;

public class MavenServerConsoleIndicatorImpl
implements MavenServerConsoleIndicator {
    private final ConcurrentLinkedQueue<MavenArtifactEvent> myPullingQueue = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<MavenServerConsoleEvent> myConsoleEventsQueue = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<DownloadArtifactEvent> myDowLoadArtifactEventsQueue = new ConcurrentLinkedQueue();
    private boolean myCancelled = false;

    @Override
    public void startedDownload(MavenServerConsoleIndicator.ResolveType type, String dependencyId) {
        this.myPullingQueue.add(new MavenArtifactEvent(type, MavenArtifactEvent.ArtifactEventType.DOWNLOAD_STARTED, dependencyId, null, null));
    }

    @Override
    public void completedDownload(MavenServerConsoleIndicator.ResolveType type, String dependencyId) {
        this.myPullingQueue.add(new MavenArtifactEvent(type, MavenArtifactEvent.ArtifactEventType.DOWNLOAD_COMPLETED, dependencyId, null, null));
    }

    @Override
    public void failedDownload(MavenServerConsoleIndicator.ResolveType type, String dependencyId, String errorMessage, String stackTrace) {
        this.myPullingQueue.add(new MavenArtifactEvent(type, MavenArtifactEvent.ArtifactEventType.DOWNLOAD_FAILED, dependencyId, errorMessage, stackTrace));
    }

    @Override
    public boolean isCanceled() {
        return this.myCancelled;
    }

    @Override
    public void cancel() {
        this.myCancelled = true;
    }

    @Override
    @NotNull
    public List<MavenArtifactEvent> pullDownloadEvents() {
        List<MavenArtifactEvent> list = MavenRemotePullUtil.pull(this.myPullingQueue);
        if (list == null) {
            MavenServerConsoleIndicatorImpl.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Override
    @NotNull
    public List<DownloadArtifactEvent> pullDownloadArtifactEvents() {
        List<DownloadArtifactEvent> list = MavenRemotePullUtil.pull(this.myDowLoadArtifactEventsQueue);
        if (list == null) {
            MavenServerConsoleIndicatorImpl.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @NotNull
    public List<MavenServerConsoleEvent> pullConsoleEvents() {
        List<MavenServerConsoleEvent> list = MavenRemotePullUtil.pull(this.myConsoleEventsQueue);
        if (list == null) {
            MavenServerConsoleIndicatorImpl.$$$reportNull$$$0(2);
        }
        return list;
    }

    public void printMessage(int level, String message, Throwable throwable) {
        this.myConsoleEventsQueue.add(new MavenServerConsoleEvent(level, message, throwable));
    }

    private void printMessage(int level, String message) {
        this.printMessage(level, message, null);
    }

    public void debug(String message) {
        this.printMessage(0, message);
    }

    public void info(String message) {
        this.printMessage(1, message);
    }

    public void warn(String message) {
        this.printMessage(2, message);
    }

    public void error(String message) {
        this.printMessage(3, message);
    }

    public void artifactDownloaded(File file) {
        this.myDowLoadArtifactEventsQueue.add(new DownloadArtifactEvent(file.getAbsolutePath()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/idea/maven/server/MavenServerConsoleIndicatorImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "pullDownloadEvents";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "pullDownloadArtifactEvents";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "pullConsoleEvents";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

