/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.maven.internal.artifact;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.DefaultDomainObjectSet;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.collections.MinimalFileSet;
import org.gradle.api.publish.internal.PublicationArtifactSet;
import org.gradle.api.publish.maven.MavenArtifact;
import org.gradle.api.publish.maven.MavenArtifactSet;
import org.gradle.internal.typeconversion.NotationParser;

public class DefaultMavenArtifactSet
extends DefaultDomainObjectSet<MavenArtifact>
implements MavenArtifactSet,
PublicationArtifactSet<MavenArtifact> {
    private final String publicationName;
    private final FileCollection files;
    private final NotationParser<Object, MavenArtifact> mavenArtifactParser;

    @Inject
    public DefaultMavenArtifactSet(String publicationName, NotationParser<Object, MavenArtifact> mavenArtifactParser, FileCollectionFactory fileCollectionFactory, CollectionCallbackActionDecorator collectionCallbackActionDecorator) {
        super(MavenArtifact.class, collectionCallbackActionDecorator);
        this.publicationName = publicationName;
        this.mavenArtifactParser = mavenArtifactParser;
        this.files = fileCollectionFactory.create((MinimalFileSet)new ArtifactsFileCollection(), context -> {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                MavenArtifact mavenArtifact = (MavenArtifact)iterator.next();
                context.add((Object)mavenArtifact);
            }
        });
    }

    @Override
    public MavenArtifact artifact(Object source) {
        MavenArtifact artifact = (MavenArtifact)this.mavenArtifactParser.parseNotation(source);
        this.add(artifact);
        return artifact;
    }

    @Override
    public MavenArtifact artifact(Object source, Action<? super MavenArtifact> config) {
        MavenArtifact artifact = this.artifact(source);
        config.execute((Object)artifact);
        return artifact;
    }

    public FileCollection getFiles() {
        return this.files;
    }

    private class ArtifactsFileCollection
    implements MinimalFileSet {
        private ArtifactsFileCollection() {
        }

        public String getDisplayName() {
            return "artifacts for Maven publication '" + DefaultMavenArtifactSet.this.publicationName + "'";
        }

        public Set<File> getFiles() {
            LinkedHashSet<File> files = new LinkedHashSet<File>();
            Iterator iterator = DefaultMavenArtifactSet.this.iterator();
            while (iterator.hasNext()) {
                MavenArtifact artifact = (MavenArtifact)iterator.next();
                files.add(artifact.getFile());
            }
            return files;
        }
    }
}

