/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.resources.bookmarks;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBIconBinary;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.Base64;
import org.jkiss.utils.xml.XMLBuilder;
import org.jkiss.utils.xml.XMLException;
import org.jkiss.utils.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BookmarkStorage {
    public static final String ATTR_TITLE = "title";
    public static final String ATTR_DESCRIPTION = "description";
    public static final String ATTR_DATA_SOURCE = "data-source";
    public static final String TAG_PATH = "path";
    public static final String TAG_IMAGE = "image";
    public static final String TAG_BOOKMARK = "bookmark";
    private String title;
    private String description;
    private DBPImage image;
    private String dataSourceId;
    private List<String> dataSourcePath;

    public BookmarkStorage(IFile file, boolean loadImage) throws DBException, CoreException {
        this.title = file.getFullPath().removeFileExtension().lastSegment();
        try {
            Throwable throwable = null;
            Object var4_7 = null;
            try (InputStream contents = file.getContents(true);){
                Element imgElement;
                Document document = XMLUtils.parseDocument((InputStream)contents);
                Element root = document.getDocumentElement();
                this.title = root.getAttribute(ATTR_TITLE);
                this.description = root.getAttribute(ATTR_DESCRIPTION);
                this.dataSourceId = root.getAttribute(ATTR_DATA_SOURCE);
                if (this.dataSourceId == null) {
                    throw new DBException("Data source ID missing in bookmark definition");
                }
                this.dataSourcePath = new ArrayList<String>();
                for (Element elem : XMLUtils.getChildElementList((Element)root, (String)TAG_PATH)) {
                    this.dataSourcePath.add(XMLUtils.getElementBody((Element)elem));
                }
                if (loadImage && (imgElement = XMLUtils.getChildElement((Element)root, (String)TAG_IMAGE)) != null) {
                    String imgString = XMLUtils.getElementBody((Element)imgElement);
                    byte[] imgBytes = Base64.decode((String)imgString);
                    ImageLoader loader = new ImageLoader();
                    this.image = new DBIconBinary(this.dataSourcePath.toString(), loader.load((InputStream)new ByteArrayInputStream(imgBytes))[0]);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (XMLException e) {
            throw new DBException("Error reading bookmarks storage", (Throwable)e);
        }
        catch (IOException e) {
            throw new DBException("IO Error reading bookmarks storage", (Throwable)e);
        }
    }

    BookmarkStorage(String title, String description, DBPImage image, String dataSourceId, List<String> dataSourcePath) {
        this.title = title;
        this.description = description;
        this.image = image;
        this.dataSourceId = dataSourceId;
        this.dataSourcePath = dataSourcePath;
    }

    public void dispose() {
        if (this.image != null) {
            this.image.dispose();
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public DBPImage getImage() {
        return this.image;
    }

    public void setImage(DBPImage image) {
        this.image = image;
    }

    public String getDataSourceId() {
        return this.dataSourceId;
    }

    public List<String> getDataSourcePath() {
        return this.dataSourcePath;
    }

    public ByteArrayInputStream serialize() throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(5000);
        XMLBuilder xml = new XMLBuilder((OutputStream)buffer, GeneralUtils.getDefaultFileEncoding());
        xml.startElement(TAG_BOOKMARK);
        xml.addAttribute(ATTR_TITLE, this.title);
        if (this.description != null) {
            xml.addAttribute(ATTR_DESCRIPTION, this.description);
        }
        xml.addAttribute(ATTR_DATA_SOURCE, this.dataSourceId);
        for (String path : this.dataSourcePath) {
            xml.startElement(TAG_PATH);
            xml.addText((CharSequence)path);
            xml.endElement();
        }
        xml.startElement(TAG_IMAGE);
        Image realImage = DBeaverIcons.getImage((DBPImage)this.image);
        ImageLoader loader = new ImageLoader();
        loader.data = new ImageData[]{realImage.getImageData()};
        ByteArrayOutputStream imageBuffer = new ByteArrayOutputStream(5000);
        loader.save((OutputStream)imageBuffer, 5);
        xml.addText((CharSequence)Base64.encode((byte[])imageBuffer.toByteArray()));
        xml.endElement();
        xml.endElement();
        xml.flush();
        return new ByteArrayInputStream(buffer.toByteArray());
    }
}

