/** @file
 * USB device vendor and product ID database - Autogenerated by /build/virtualbox/src/VirtualBox-7.2.2/out/linux.amd64/release/obj/USBIdDatabaseGenerator/USBIdDatabaseGenerator
 */

/*
 * Copyright (C) 2015-2025 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#include "USBIdDatabase.h"

#include <iprt/bldprog-strtab.h>

static const char g_achStrTabStrTab[] =
{
/* 0x00000 = "Argus DC-1610/DC-1620/Emprex PCD3600/Philips P44417B keychain camera/Precision Mini,Model HA513A/Vivitar Vivicam 55" */
    'A','r','g','u','s',' ','D','C','-','1','6','1','0','/','D','C','-','1','6','2','0','/','E','m','p','r','e','x',' ','P','C','D','3','6','0','0','/','P','h','i','l','i','p','s',' ','P','4','4','4','1','7','B',' ','k','e','y','c','h','a','i','n',' ','c','a','m','e','r','a','/','P','r','e','c','i','s','i','o','n',' ','M','i','n','i',',','M','o','d','e','l',' ','H','A','5','1','3','A','/','V','i','v','i','t','a','r',' ','V','i','v','i','c','a','m',' ','5','5',
/* 0x00073 = "HP 39g+ [F2224A], 39gs [F2223A], 40gs [F2225A], 48gII [F2226A], 49g+ [F2228A], 50g [F2229A, NW240AA]" */
    'H','P',' ','3','9','g','+',' ','[','F','2','2','2','4','A',']',',',' ','3','9','g','s',' ','[','F','2','2','2','3','A',']',',',' ','4','0','g','s',' ','[','F','2','2','2','5','A',']',',',' ','4','8','g','I','I',' ','[','F','2','2','2','6','A',']',',',' ','4','9','g','+',' ','[','F','2','2','2','8','A',']',',',' ','5','0','g',' ','[','F','2','2','2','9','A',',',' ','N','W','2','4','0','A','A',']',
/* 0x000d7 = "FinePix 30i/40i/50i, A101/201, 1300/2200, 1400/2400/2600/2800/4500/4700/4800/4900/6800/6900 Zoom" */
    '\xca','i','x',' ','3','0','i','/','4','0','i','/','5','0','i',',',' ','A','1','0','1','/','2','0','1',',',' ','1','3','0','0','/','2','2','0','0',',',' ','1','4','0','0','/','2','4','0','0','/','2','6','0','0','/','2','8','0','0','/','4','5','0','0','/','4','7','0','0','/','4','8','0','0','/','4','9','0','0','/','6','8','0','0','/','6','9','0','0',' ','Z','o','o','m',
/* 0x00133 = "My Passport Essential (WDBAAA), My Passport for Mac (WDBAAB), My Passport Essential SE (WDBABM), My Passport SE for Mac (WDBABW)" */
    'M','y',' ','\xd5','E','s','s','e','n','t','i','a','l',' ','(','W','D','B','A','A','A',')',',',' ','M','y',' ','\xd5','\xcc','M','a','c',' ','(','W','D','B','A','A','B',')',',',' ','M','y',' ','\xd5','E','s','s','e','n','t','i','a','l',' ','S','E',' ','(','W','D','B','A','B','M',')',',',' ','M','y',' ','\xd5','S','E',' ','\xcc','M','a','c',' ','(','W','D','B','A','B','W',')',
/* 0x0018d = "Digital IXUS 700 (normal mode) / Digital IXUS 700 (PTP mode) / IXY Digital 600 (normal mode) / PowerShot SD500 (normal mode) / PowerShot SD500 (PTP mode)" */
    '\x09','\xfd','7','0','0',' ','(','n','o','r','m','a','l',' ','\x1a',' ','/',' ','\x09','\xfd','7','0','0',' ','(','P','T','P',' ','\x1a',' ','/',' ','I','X','Y',' ','\x09','6','0','0',' ','(','n','o','r','m','a','l',' ','\x1a',' ','/',' ','\x24','\x84','S','D','5','0','0',' ','(','n','o','r','m','a','l',' ','\x1a',' ','/',' ','\x24','\x84','S','D','5','0','0',' ','(','P','T','P',' ','\x1a',
/* 0x001e5 = "PC Camera (SN9C201 + MI0360/MT9V011 or MI0360SOC/MT9V111) U-CAM PC Camera NE878, Whitcom WHC017, ..." */
    '\x1f','\x04',' ','(','S','N','9','C','2','0','1',' ','+',' ','M','I','0','3','6','0','/','M','T','9','V','0','1','1',' ','o','r',' ','M','I','0','3','6','0','S','O','C','/','M','T','9','V','1','1','1',')',' ','U','-','C','A','M',' ','\x1f','\x04',' ','N','E','8','7','8',',',' ','W','h','i','t','c','o','m',' ','W','H','C','0','1','7',',',' ','.','.','.',
/* 0x0023b = "ASM1051E SATA 6Gb/s bridge, ASM1053E SATA 6Gb/s bridge, ASM1153 SATA 3Gb/s bridge" */
    'A','S','M','1','0','5','1','E',' ','S','A','T','A',' ','6','G','b','/','s',' ','b','r','i','d','g','e',',',' ','A','S','M','1','0','5','3','E',' ','S','A','T','A',' ','6','G','b','/','s',' ','b','r','i','d','g','e',',',' ','A','S','M','1','1','5','3',' ','S','A','T','A',' ','3','G','b','/','s',' ','b','r','i','d','g','e',
/* 0x0028c = "Camedia C-310Z/C-700/C-750UZ/C-755/C-765UZ/C-3040/C-4000/C-5050Z/D-560/C-3020Z Zoom Camera" */
    'C','a','m','e','d','i','a',' ','C','-','3','1','0','Z','/','C','-','7','0','0','/','C','-','7','5','0','U','Z','/','C','-','7','5','5','/','C','-','7','6','5','U','Z','/','C','-','3','0','4','0','/','C','-','4','0','0','0','/','C','-','5','0','5','0','Z','/','D','-','5','6','0','/','C','-','3','0','2','0','Z',' ','\xe6','\x04',
/* 0x002dd = "Tanic S110-SG1 + ISSC IS1002N [Slow Infra-Red (SIR) & Bluetooth 1.2 (Class 2) Adapter]" */
    'T','a','n','i','c',' ','S','1','1','0','-','S','G','1',' ','+',' ','I','S','S','C',' ','I','S','1','0','0','2','N',' ','[','S','l','o','w',' ','I','n','f','r','a','-','R','e','d',' ','(','S','I','R',')',' ','&',' ','\x06',' ','1','.','2',' ','(','C','l','a','s','s',' ','2',')',' ','A','d','a','p','t','e','r',']',
/* 0x0032b = "Lifedrive / Treo 650/680 / Tunsten E2/T5/TX / Centro / Zire 21/31/72 / Z22" */
    'L','i','f','e','d','r','i','v','e',' ','/',' ','T','r','e','o',' ','6','5','0','/','6','8','0',' ','/',' ','T','u','n','s','t','e','n',' ','E','2','/','T','5','/','T','X',' ','/',' ','C','e','n','t','r','o',' ','/',' ','Z','i','r','e',' ','2','1','/','3','1','/','7','2',' ','/',' ','Z','2','2',
/* 0x00375 = "MHS291LVW LTE Modem [Verizon Jetpack 4G LTE Mobile Hotspot MHS291L] (Zero CD Mode)" */
    'M','H','S','2','9','1','L','V','W',' ','L','T','E',' ','\x1c',' ','[','V','e','r','i','z','o','n',' ','J','e','t','p','a','c','k',' ','4','G',' ','L','T','E',' ','\x96',' ','H','o','t','s','p','o','t',' ','M','H','S','2','9','1','L',']',' ','(','Z','e','r','o',' ','C','D',' ','M','o','d','e',')',
/* 0x003be = "Typhoon Easycam USB 330K (newer)/Typhoon Easycam USB 2.0 VGA 1.3M/Sansun SN-508" */
    'T','y','p','h','o','o','n',' ','E','a','s','y','c','a','m',' ','\x0a',' ','3','3','0','K',' ','(','n','e','w','e','r',')','/','T','y','p','h','o','o','n',' ','E','a','s','y','c','a','m',' ','\x0a',' ','\xc1','V','G','A',' ','1','.','3','M','/','S','a','n','s','u','n',' ','S','N','-','5','0','8',
/* 0x00406 = "Black Knight PRO / WOW Uninterruptible Power Supply (Cypress HID->COM RS232)" */
    'B','l','a','c','k',' ','K','n','i','g','h','t',' ','P','R','O',' ','/',' ','W','O','W',' ','U','n','i','n','t','e','r','r','u','p','t','i','b','l','e',' ','\x24',' ','S','u','p','p','l','y',' ','(','C','y','p','r','e','s','s',' ','H','I','D','-','>','C','O','M',' ','R','S','2','3','2',')',
/* 0x0044e = "1.3MPixel Web Cam - Asus A3A, A6J, A6K, A6M, A6R, A6T, A6V, A7T, A7sv, A7U" */
    '1','.','3','M','P','i','x','e','l',' ','W','e','b',' ','\x9a','-',' ','A','s','u','s',' ','A','3','A',',',' ','A','6','J',',',' ','A','6','K',',',' ','A','6','M',',',' ','A','6','R',',',' ','A','6','T',',',' ','A','6','V',',',' ','A','7','T',',',' ','A','7','s','v',',',' ','A','7','U',
/* 0x00495 = "Digital IXUS 50 (normal mode) / IXY Digital 55 (normal mode) / PowerShot A520 (PTP mode) / PowerShot SD400 (normal mode)" */
    '\x09','\xfd','5','0',' ','(','n','o','r','m','a','l',' ','\x1a',' ','/',' ','I','X','Y',' ','\x09','5','5',' ','(','n','o','r','m','a','l',' ','\x1a',' ','/',' ','\x24','\x84','A','5','2','0',' ','(','P','T','P',' ','\x1a',' ','/',' ','\x24','\x84','S','D','4','0','0',' ','(','n','o','r','m','a','l',' ','\x1a',
/* 0x004db = "Artec Ultima 2000 (GT6801 based)/Lifetec LT9385/ScanMagic 1200 UB Plus Scanner" */
    'A','r','t','e','c',' ','U','l','t','i','m','a',' ','2','0','0','0',' ','(','G','T','6','8','0','1',' ','b','a','s','e','d',')','/','L','i','f','e','t','e','c',' ','L','T','9','3','8','5','/','\x8a','M','a','g','i','c',' ','1','2','0','0',' ','U','B',' ','P','l','u','s',' ','\x25',
/* 0x00520 = "Maxell WS30 Slim Digital Camera, or Pandigital PI8004W01 digital photo frame" */
    'M','a','x','e','l','l',' ','W','S','3','0',' ','S','l','i','m',' ','\x09','C','a','m','e','r','a',',',' ','o','r',' ','P','a','n','d','i','g','i','t','a','l',' ','P','I','8','0','0','4','W','0','1',' ','d','i','g','i','t','a','l',' ','p','h','o','t','o',' ','f','r','a','m','e',
/* 0x00565 = "PIC18F2550 (32K Flashable 10 Channel, 10 Bit A/D USB Microcontroller)" */
    'P','I','C','1','8','F','2','5','5','0',' ','(','3','2','K',' ','F','l','a','s','h','a','b','l','e',' ','1','0',' ','C','h','a','n','n','e','l',',',' ','1','0',' ','B','i','t',' ','A','/','D',' ','\x0a',' ','M','i','c','r','o','c','o','n','t','r','o','l','l','e','r',')',
/* 0x005a8 = "SMSC USB20H04 3-Port Hub [ThinkPad X4 UltraBase, Wistron S Note-3 Media Slice]" */
    'S','M','S','C',' ','U','S','B','2','0','H','0','4',' ','3','-','\x87',' ','\xa4',' ','[','T','h','i','n','k','\xfa',' ','X','4',' ','U','l','t','r','a','B','a','s','e',',',' ','W','i','s','t','r','o','n',' ','S',' ','N','o','t','e','-','3',' ','\xa1',' ','S','l','i','c','e',']',
/* 0x005eb = "MHS291LVW LTE Modem [Verizon Jetpack 4G LTE Mobile Hotspot MHS291L] (Modem Mode)" */
    'M','H','S','2','9','1','L','V','W',' ','L','T','E',' ','\x1c',' ','[','V','e','r','i','z','o','n',' ','J','e','t','p','a','c','k',' ','4','G',' ','L','T','E',' ','\x96',' ','H','o','t','s','p','o','t',' ','M','H','S','2','9','1','L',']',' ','(','\x1c',' ','M','o','d','e',')',
/* 0x0062e = "GT-I9500 [Galaxy S4] / GT-I9250 [Galaxy Nexus] (network tethering)" */
    'G','T','-','I','9','5','0','0',' ','[','G','a','l','a','x','y',' ','S','4',']',' ','/',' ','G','T','-','I','9','2','5','0',' ','[','G','a','l','a','x','y',' ','N','e','x','u','s',']',' ','(','n','e','t','w','o','r','k',' ','t','e','t','h','e','r','i','n','g',')',
/* 0x00670 = "card reader SD/MS DEMO board with Generic brand name (MaskROM version)" */
    'c','a','r','d',' ','r','e','a','d','e','r',' ','S','D','/','M','S',' ','D','E','M','O',' ','b','o','a','r','d',' ','\x98','G','e','n','e','r','i','c',' ','b','r','a','n','d',' ','n','a','m','e',' ','(','M','a','s','k','R','O','M',' ','v','e','r','s','i','o','n',')',
/* 0x006b2 = "Kodak Digital Product Center, Japan Ltd. (formerly Chinon Industries Inc.)" */
    'K','o','d','a','k',' ','\x09','P','r','o','d','u','c','t',' ','C','e','n','t','e','r',',',' ','J','a','p','a','n',' ','\xab',' ','(','f','o','r','m','e','r','l','y',' ','C','h','i','n','o','n',' ','I','n','d','u','s','t','r','i','e','s',' ','I','n','c','.',')',
/* 0x006f2 = "SpeedLink Vicious And Devine Laplace webcam, white (VD-1504-SWT)" */
    'S','p','e','e','d','L','i','n','k',' ','V','i','c','i','o','u','s',' ','A','n','d',' ','D','e','v','i','n','e',' ','L','a','p','l','a','c','e',' ','w','e','b','c','a','m',',',' ','w','h','i','t','e',' ','(','V','D','-','1','5','0','4','-','S','W','T',')',
/* 0x00732 = "SpeedLink Vicious And Devine Laplace webcam, black (VD-1504-SBK)" */
    'S','p','e','e','d','L','i','n','k',' ','V','i','c','i','o','u','s',' ','A','n','d',' ','D','e','v','i','n','e',' ','L','a','p','l','a','c','e',' ','w','e','b','c','a','m',',',' ','b','l','a','c','k',' ','(','V','D','-','1','5','0','4','-','S','B','K',')',
/* 0x00772 = "PowerShot SD950 IS DIGITAL ELPH / DIGITAL IXUS 960 IS / IXY DIGITAL 2000 IS" */
    '\x24','\x84','S','D','9','5','0',' ','I','S',' ','D','I','G','I','T','A','L',' ','E','L','P','H',' ','/',' ','D','I','G','I','T','A','L',' ','\xfd','9','6','0',' ','I','S',' ','/',' ','I','X','Y',' ','D','I','G','I','T','A','L',' ','2','0','0','0',' ','I','S',
/* 0x007b1 = "BCM5880 Secure Applications Processor with fingerprint swipe sensor" */
    'B','C','M','5','8','8','0',' ','S','e','c','u','r','e',' ','A','p','p','l','i','c','a','t','i','o','n','s',' ','P','r','o','c','e','s','s','o','r',' ','\x98','f','i','n','g','e','r','p','r','i','n','t',' ','s','w','i','p','e',' ','s','e','n','s','o','r',
/* 0x007f0 = "card reader SD/MS DEMO board with ICSI brand name (MaskROM version)" */
    'c','a','r','d',' ','r','e','a','d','e','r',' ','S','D','/','M','S',' ','D','E','M','O',' ','b','o','a','r','d',' ','\x98','I','C','S','I',' ','b','r','a','n','d',' ','n','a','m','e',' ','(','M','a','s','k','R','O','M',' ','v','e','r','s','i','o','n',')',
/* 0x0082f = "BCM5880 Secure Applications Processor with fingerprint touch sensor" */
    'B','C','M','5','8','8','0',' ','S','e','c','u','r','e',' ','A','p','p','l','i','c','a','t','i','o','n','s',' ','P','r','o','c','e','s','s','o','r',' ','\x98','f','i','n','g','e','r','p','r','i','n','t',' ','t','o','u','c','h',' ','s','e','n','s','o','r',
/* 0x0086e = "Kingston DataTraveler 102/2.0 / HEMA Flash Drive 2 GB / PNY Attache 4GB Stick" */
    'K','i','n','g','s','t','o','n',' ','\xe7','T','r','a','v','e','l','e','r',' ','1','0','2','/','2','.','0',' ','/',' ','H','E','M','A',' ','\x3c',' ','\x14',' ','2',' ','G','B',' ','/',' ','P','N','Y',' ','A','t','t','a','c','h','e',' ','4','G','B',' ','\xb3',
/* 0x008ac = "PC Camera with Microphone (SN9C202 + MI0360/MT9V011 or MI0360SOC/MT9V111)" */
    '\x1f','\x04',' ','\x98','M','i','c','r','o','p','h','o','n','e',' ','(','S','N','9','C','2','0','2',' ','+',' ','M','I','0','3','6','0','/','M','T','9','V','0','1','1',' ','o','r',' ','M','I','0','3','6','0','S','O','C','/','M','T','9','V','1','1','1',')',
/* 0x008ea = "Neo1973/FreeRunner kernel usbnet (g_ether, CDC Ethernet) mode" */
    'N','e','o','1','9','7','3','/','F','r','e','e','R','u','n','n','e','r',' ','k','e','r','n','e','l',' ','u','s','b','n','e','t',' ','(','g','_','e','t','h','e','r',',',' ','C','D','C',' ','E','t','h','e','r','n','e','t',')',' ','m','o','d','e',
/* 0x00927 = "PX-603F [ME OFFICE 960FWD Series/Stylus Office BX625FWD/TX620FWD Series]" */
    'P','X','-','6','0','3','F',' ','[','M','E',' ','O','F','F','I','C','E',' ','9','6','0','F','W','D',' ','S','e','r','i','e','s','/','\xb1','\xd3',' ','B','X','6','2','5','F','W','D','/','T','X','6','2','0','F','W','D',' ','S','e','r','i','e','s',']',
/* 0x00964 = "HWUN1 Hi-Gain Wireless-300N Adapter w/ Upgradable Antenna [Ralink RT2870]" */
    'H','W','U','N','1',' ','H','i','-','G','a','i','n',' ','W','i','r','e','l','e','s','s','-','3','0','0','N',' ','\x02',' ','w','/',' ','U','p','g','r','a','d','a','b','l','e',' ','A','n','t','e','n','n','a',' ','[','\x93','R','T','2','8','7','0',']',
/* 0x009a1 = "HWUN2 Hi-Gain Wireless-150N Adapter w/ Upgradable Antenna [Ralink RT2770]" */
    'H','W','U','N','2',' ','H','i','-','G','a','i','n',' ','W','i','r','e','l','e','s','s','-','1','5','0','N',' ','\x02',' ','w','/',' ','U','p','g','r','a','d','a','b','l','e',' ','A','n','t','e','n','n','a',' ','[','\x93','R','T','2','7','7','0',']',
/* 0x009de = "BrewBit Model-T pOSHW temperature controller for homebrewers (bootloader)" */
    'B','r','e','w','B','i','t',' ','M','o','d','e','l','-','T',' ','p','O','S','H','W',' ','t','e','m','p','e','r','a','t','u','r','e',' ','\x9e',' ','\xcc','h','o','m','e','b','r','e','w','e','r','s',' ','(','b','o','o','t','l','o','a','d','e','r',')',
/* 0x00a1b = "SMC2662W v2 / SMC2662W-AR / Belkin F5D6050 [Atmel at76c503a]" */
    'S','M','C','2','6','6','2','W',' ','v','2',' ','/',' ','S','M','C','2','6','6','2','W','-','A','R',' ','/',' ','B','e','l','k','i','n',' ','F','5','D','6','0','5','0',' ','[','A','t','m','e','l',' ','a','t','7','6','c','5','0','3','a',']',
/* 0x00a57 = "OpenMoko Neo1973 / Neo Freerunner kernel cdc_ether USB network" */
    'O','p','e','n','M','o','k','o',' ','N','e','o','1','9','7','3',' ','/',' ','N','e','o',' ','F','r','e','e','r','u','n','n','e','r',' ','k','e','r','n','e','l',' ','c','d','c','_','e','t','h','e','r',' ','\x0a',' ','n','e','t','w','o','r','k',
/* 0x00a93 = "DTV-DVB UDTT704F -(MiniCard) DVBT/NTSC/PAL Driver(Without HID)" */
    'D','T','V','-','D','V','B',' ','U','D','T','T','7','0','4','F',' ','-','(','\xb9','C','a','r','d',')',' ','D','V','B','T','/','N','T','S','C','/','P','A','L',' ','D','r','i','v','e','r','(','W','i','t','h','o','u','t',' ','H','I','D',')',
/* 0x00ace = "Epsilon 1.3/Jenoptik JD C1.3/UMAX AstraPix 470 (mass storage mode)" */
    'E','p','s','i','l','o','n',' ','1','.','3','/','J','e','n','o','p','t','i','k',' ','J','D',' ','C','1','.','3','/','U','M','A','X',' ','A','s','t','r','a','\xd8','4','7','0',' ','(','m','a','s','s',' ','s','t','o','r','a','g','e',' ','\x1a',
/* 0x00b09 = "wireless multimedia keyboard with trackball [Trust ADURA 17911]" */
    'w','i','r','e','l','e','s','s',' ','m','u','l','t','i','m','e','d','i','a',' ','k','e','y','b','o','a','r','d',' ','\x98','t','r','a','c','k','b','a','l','l',' ','[','T','r','u','s','t',' ','A','D','U','R','A',' ','1','7','9','1','1',']',
/* 0x00b44 = "CL1356T / CL1356T5 / CL1356A smartcard readers (DFU + CCID)" */
    'C','L','1','3','5','6','T',' ','/',' ','C','L','1','3','5','6','T','5',' ','/',' ','C','L','1','3','5','6','A',' ','s','m','a','r','t','c','a','r','d',' ','r','e','a','d','e','r','s',' ','(','D','F','U',' ','+',' ','C','C','I','D',')',
/* 0x00b7f = "FusionHDTV DVB-T Dual Digital 4 (ZL10353+xc2028/xc3028) (initialized)" */
    'F','u','s','i','o','n','H','D','T','V',' ','\xa7','T',' ','D','u','a','l',' ','\x09','4',' ','(','Z','L','1','0','3','5','3','+','x','c','2','0','2','8','/','x','c','3','0','2','8',')',' ','(','i','n','i','t','i','a','l','i','z','e','d',')',
/* 0x00bba = "OpenMoko Neo1973 kernel usbnet (g_ether, CDC Ethernet) mode" */
    'O','p','e','n','M','o','k','o',' ','N','e','o','1','9','7','3',' ','k','e','r','n','e','l',' ','u','s','b','n','e','t',' ','(','g','_','e','t','h','e','r',',',' ','C','D','C',' ','E','t','h','e','r','n','e','t',')',' ','m','o','d','e',
/* 0x00bf5 = "HAWNU1 Hi-Gain Wireless-150N Network Adapter with Range Amplifier [Ralink RT3070]" */
    'H','A','W','N','U','1',' ','H','i','-','G','a','i','n',' ','W','i','r','e','l','e','s','s','-','1','5','0','N',' ','\x8d','\x02',' ','\x98','R','a','n','g','e',' ','A','m','p','l','i','f','i','e','r',' ','[','\x93','R','T','3','0','7','0',']',
/* 0x00c2f = "PAC7311 Gigaware VGA PC Camera:Trust WB-3350p:SIGMA cam 2350" */
    'P','A','C','7','3','1','1',' ','G','i','g','a','w','a','r','e',' ','V','G','A',' ','\x1f','C','a','m','e','r','a',':','T','r','u','s','t',' ','W','B','-','3','3','5','0','p',':','S','I','G','M','A',' ','c','a','m',' ','2','3','5','0',
/* 0x00c69 = "e.dentifier2 (ABN AMRO electronic banking card reader NL)" */
    'e','.','d','e','n','t','i','f','i','e','r','2',' ','(','A','B','N',' ','A','M','R','O',' ','e','l','e','c','t','r','o','n','i','c',' ','b','a','n','k','i','n','g',' ','c','a','r','d',' ','r','e','a','d','e','r',' ','N','L',')',
/* 0x00ca2 = "EP-804A/EP-804AR/EP-804AW [Stylus Photo PX730WD/Artisan 730 Series]" */
    'E','P','-','8','0','4','A','/','E','P','-','8','0','4','A','R','/','E','P','-','8','0','4','A','W',' ','[','\xb1','\x86',' ','P','X','7','3','0','W','D','/','A','r','t','i','s','a','n',' ','7','3','0',' ','S','e','r','i','e','s',']',
/* 0x00cdb = "Foxconn T77H114 BCM2070 [Single-Chip Bluetooth 2.1 + EDR Adapter]" */
    'F','o','x','c','o','n','n',' ','T','7','7','H','1','1','4',' ','B','C','M','2','0','7','0',' ','[','S','i','n','g','l','e','-','C','h','i','p',' ','\x06',' ','2','.','1',' ','+',' ','E','D','R',' ','A','d','a','p','t','e','r',']',
/* 0x00d14 = "Aashima Technology Trust Sight Fighter Vibration Feedback Joystick" */
    'A','a','s','h','i','m','a',' ','\x0d',' ','T','r','u','s','t',' ','S','i','g','h','t',' ','F','i','g','h','t','e','r',' ','V','i','b','r','a','t','i','o','n',' ','F','e','e','d','b','a','c','k',' ','J','o','y','s','t','i','c','k',
/* 0x00d4d = "RTL2838 DVB-T COFDM Demodulator [TerraTec Cinergy T Stick Black]" */
    'R','T','L','2','8','3','8',' ','\xa7','T',' ','C','O','F','D','M',' ','D','e','m','o','d','u','l','a','t','o','r',' ','[','T','e','r','r','a','T','e','c',' ','C','i','n','e','r','g','y',' ','T',' ','\xb3',' ','B','l','a','c','k',']',
/* 0x00d86 = "EP-803A/EP-803AW [Artisan 725/Stylus Photo PX720WD/TX720WD Series]" */
    'E','P','-','8','0','3','A','/','E','P','-','8','0','3','A','W',' ','[','A','r','t','i','s','a','n',' ','7','2','5','/','\xb1','\x86',' ','P','X','7','2','0','W','D','/','T','X','7','2','0','W','D',' ','S','e','r','i','e','s',']',
/* 0x00dbe = "PowerShot SD990 IS DIGITAL ELPH / Digital IXUS 980 IS / IXY DIGITAL 3000 IS" */
    '\x24','\x84','S','D','9','9','0',' ','I','S',' ','D','I','G','I','T','A','L',' ','E','L','P','H',' ','/',' ','\x09','\xfd','9','8','0',' ','I','S',' ','/',' ','I','X','Y',' ','D','I','G','I','T','A','L',' ','3','0','0','0',' ','I','S',
/* 0x00df6 = "ITE it9503 feature-limited DVB-T transmission chip [ccHDtv]" */
    'I','T','E',' ','i','t','9','5','0','3',' ','f','e','a','t','u','r','e','-','l','i','m','i','t','e','d',' ','\xa7','T',' ','t','r','a','n','s','m','i','s','s','i','o','n',' ','c','h','i','p',' ','[','c','c','H','D','t','v',']',
/* 0x00e2e = "ARC AM-VM Mono Airpath/Vacuum Monochromator/Spectrograph" */
    'A','R','C',' ','A','M','-','V','M',' ','M','o','n','o',' ','A','i','r','p','a','t','h','/','V','a','c','u','u','m',' ','M','o','n','o','c','h','r','o','m','a','t','o','r','/','S','p','e','c','t','r','o','g','r','a','p','h',
/* 0x00e66 = "FV M1 (normal mode) / MVX 3i (normal mode) / Optura Xi (normal mode)" */
    'F','V',' ','M','1',' ','(','n','o','r','m','a','l',' ','\x1a',' ','/',' ','M','V','X',' ','3','i',' ','(','n','o','r','m','a','l',' ','\x1a',' ','/',' ','O','p','t','u','r','a',' ','X','i',' ','(','n','o','r','m','a','l',' ','\x1a',
/* 0x00e9e = "Tessel JavaScript enabled Microcontroller with built-in WiFi" */
    'T','e','s','s','e','l',' ','J','a','v','a','S','c','r','i','p','t',' ','e','n','a','b','l','e','d',' ','M','i','c','r','o','c','o','n','t','r','o','l','l','e','r',' ','\x98','b','u','i','l','t','-','i','n',' ','W','i','F','i',
/* 0x00ed6 = "cyberJack RFID standard dual interface smartcard reader" */
    'c','y','b','e','r','J','a','c','k',' ','R','F','I','D',' ','s','t','a','n','d','a','r','d',' ','d','u','a','l',' ','i','n','t','e','r','f','a','c','e',' ','s','m','a','r','t','c','a','r','d',' ','r','e','a','d','e','r',
/* 0x00f0d = "PowerShot SD850 IS DIGITAL ELPH / Digital IXUS 950 IS / IXY DIGITAL 810 IS" */
    '\x24','\x84','S','D','8','5','0',' ','I','S',' ','D','I','G','I','T','A','L',' ','E','L','P','H',' ','/',' ','\x09','\xfd','9','5','0',' ','I','S',' ','/',' ','I','X','Y',' ','D','I','G','I','T','A','L',' ','8','1','0',' ','I','S',
/* 0x00f44 = "PowerShot SD880 IS DIGITAL ELPH / Digital IXUS 870 IS / IXY DIGITAL 920 IS" */
    '\x24','\x84','S','D','8','8','0',' ','I','S',' ','D','I','G','I','T','A','L',' ','E','L','P','H',' ','/',' ','\x09','\xfd','8','7','0',' ','I','S',' ','/',' ','I','X','Y',' ','D','I','G','I','T','A','L',' ','9','2','0',' ','I','S',
/* 0x00f7b = "USB, Vibration ,4-axis, 8-button joystick w/view finder" */
    'U','S','B',',',' ','V','i','b','r','a','t','i','o','n',' ',',','4','-','a','x','i','s',',',' ','8','-','b','u','t','t','o','n',' ','j','o','y','s','t','i','c','k',' ','w','/','v','i','e','w',' ','f','i','n','d','e','r',
/* 0x00fb2 = "PowerShot SD890 IS DIGITAL ELPH / Digital IXUS 970 IS / IXY DIGITAL 820 IS" */
    '\x24','\x84','S','D','8','9','0',' ','I','S',' ','D','I','G','I','T','A','L',' ','E','L','P','H',' ','/',' ','\x09','\xfd','9','7','0',' ','I','S',' ','/',' ','I','X','Y',' ','D','I','G','I','T','A','L',' ','8','2','0',' ','I','S',
/* 0x00fe9 = "PowerShot SD1200 IS DIGITAL ELPH / Digital IXUS 95 IS / IXY DIGITAL 110 IS" */
    '\x24','\x84','S','D','1','2','0','0',' ','I','S',' ','D','I','G','I','T','A','L',' ','E','L','P','H',' ','/',' ','\x09','\xfd','9','5',' ','I','S',' ','/',' ','I','X','Y',' ','D','I','G','I','T','A','L',' ','1','1','0',' ','I','S',
/* 0x01020 = "PowerShot SD960 IS DIGITAL ELPH / Digital IXUS 110 IS / IXY DIGITAL 510 IS" */
    '\x24','\x84','S','D','9','6','0',' ','I','S',' ','D','I','G','I','T','A','L',' ','E','L','P','H',' ','/',' ','\x09','\xfd','1','1','0',' ','I','S',' ','/',' ','I','X','Y',' ','D','I','G','I','T','A','L',' ','5','1','0',' ','I','S',
/* 0x01057 = "Neo1973/FreeRunner kernel mass storage (g_storage) mode" */
    'N','e','o','1','9','7','3','/','F','r','e','e','R','u','n','n','e','r',' ','k','e','r','n','e','l',' ','m','a','s','s',' ','s','t','o','r','a','g','e',' ','(','g','_','s','t','o','r','a','g','e',')',' ','m','o','d','e',
/* 0x0108e = "PowerShot SD970 IS DIGITAL ELPH / Digital IXUS 990 IS / IXY DIGITAL 830 IS" */
    '\x24','\x84','S','D','9','7','0',' ','I','S',' ','D','I','G','I','T','A','L',' ','E','L','P','H',' ','/',' ','\x09','\xfd','9','9','0',' ','I','S',' ','/',' ','I','X','Y',' ','D','I','G','I','T','A','L',' ','8','3','0',' ','I','S',
/* 0x010c5 = "HM-CFG-USB/HM-CFG-USB-2 [HomeMatic Configuration adapter]" */
    'H','M','-','C','F','G','-','U','S','B','/','H','M','-','C','F','G','-','\x0a','-','2',' ','[','H','o','m','e','M','a','t','i','c',' ','C','o','n','f','i','g','u','r','a','t','i','o','n',' ','a','d','a','p','t','e','r',']',
/* 0x010fc = "PowerShot SD780 IS DIGITAL ELPH / Digital IXUS 100 IS / IXY DIGITAL 210 IS" */
    '\x24','\x84','S','D','7','8','0',' ','I','S',' ','D','I','G','I','T','A','L',' ','E','L','P','H',' ','/',' ','\x09','\xfd','1','0','0',' ','I','S',' ','/',' ','I','X','Y',' ','D','I','G','I','T','A','L',' ','2','1','0',' ','I','S',
/* 0x01133 = "PowerShot SD940 IS DIGITAL ELPH / Digital IXUS 120 IS / IXY DIGITAL 220 IS" */
    '\x24','\x84','S','D','9','4','0',' ','I','S',' ','D','I','G','I','T','A','L',' ','E','L','P','H',' ','/',' ','\x09','\xfd','1','2','0',' ','I','S',' ','/',' ','I','X','Y',' ','D','I','G','I','T','A','L',' ','2','2','0',' ','I','S',
/* 0X0116a = "Spectrum III Mag-Only Insert Reader (SPT3-355 Series) USB-CDC" */
    'p','e','c','t','r','u','m',' ','I','I','I',' ','M','a','g','-','O','n','l','y',' ','I','n','s','e','r','t',' ','\x08',' ','(','S','P','T','3','-','3','5','5',' ','S','e','r','i','e','s',')',' ','\x0a','-','C','D','C',
/* 0x0119f = "Open Source control interface for multimedia applications" */
    'O','p','e','n',' ','S','o','u','r','c','e',' ','c','o','n','t','r','o','l',' ','i','n','t','e','r','f','a','c','e',' ','\xcc','m','u','l','t','i','m','e','d','i','a',' ','a','p','p','l','i','c','a','t','i','o','n','s',
/* 0x011d5 = "Pacific Image Electronics PrimeFilm 1800u slide/negative scanner" */
    'P','a','c','i','f','i','c',' ','I','m','a','g','e',' ','\x1b',' ','P','r','i','m','e','F','i','l','m',' ','1','8','0','0','u',' ','s','l','i','d','e','/','n','e','g','a','t','i','v','e',' ','s','c','a','n','n','e','r',
/* 0x0120b = "DSC-S30/S70/S75/F505V/F505/FD92/W1 Cybershot/Mavica Digital Camera" */
    'D','S','C','-','S','3','0','/','S','7','0','/','S','7','5','/','F','5','0','5','V','/','F','5','0','5','/','F','D','9','2','/','W','1',' ','C','y','b','e','r','s','h','o','t','/','M','a','v','i','c','a',' ','\x09','\x04',
/* 0x01241 = "K016: USB-MSR ISO 3-track MSR: POS Standard (See HID pages)" */
    'K','0','1','6',':',' ','\x0a','-','M','S','R',' ','I','S','O',' ','3','-','t','r','a','c','k',' ','M','S','R',':',' ','P','O','S',' ','S','t','a','n','d','a','r','d',' ','(','S','e','e',' ','\xf2','p','a','g','e','s',')',
/* 0x01277 = "ITE it9507 full featured DVB-T transmission chip [ccHDtv]" */
    'I','T','E',' ','i','t','9','5','0','7',' ','f','u','l','l',' ','f','e','a','t','u','r','e','d',' ','\xa7','T',' ','t','r','a','n','s','m','i','s','s','i','o','n',' ','c','h','i','p',' ','[','c','c','H','D','t','v',']',
/* 0x012ad = "Cordless 2.4 GHz Presenter Presentation remote control" */
    'C','o','r','d','l','e','s','s',' ','2','.','4',' ','G','H','z',' ','P','r','e','s','e','n','t','e','r',' ','P','r','e','s','e','n','t','a','t','i','o','n',' ','r','e','m','o','t','e',' ','c','o','n','t','r','o','l',
/* 0x012e3 = "cyberJack RFID comfort dual interface smartcard reader" */
    'c','y','b','e','r','J','a','c','k',' ','R','F','I','D',' ','c','o','m','f','o','r','t',' ','d','u','a','l',' ','i','n','t','e','r','f','a','c','e',' ','s','m','a','r','t','c','a','r','d',' ','r','e','a','d','e','r',
/* 0x01319 = "Spark Core Arduino-compatible board with WiFi (bootloader)" */
    'S','p','a','r','k',' ','C','o','r','e',' ','A','r','d','u','i','n','o','-','c','o','m','p','a','t','i','b','l','e',' ','b','o','a','r','d',' ','\x98','W','i','F','i',' ','(','b','o','o','t','l','o','a','d','e','r',')',
/* 0x0134f = "Digital IXUS II2  / Digital IXUS II2 (PTP mode) / PowerShot SD110 (PTP mode) / PowerShot SD110 Digital ELPH" */
    '\x09','\xfd','I','I','2',' ',' ','/',' ','\x09','\xfd','I','I','2',' ','(','P','T','P',' ','\x1a',' ','/',' ','\x24','\x84','S','D','1','1','0',' ','(','P','T','P',' ','\x1a',' ','/',' ','\x24','\x84','S','D','1','1','0',' ','\x09','E','L','P','H',
/* 0x01385 = "BCM5880 Secure Applications Processor with secure keyboard" */
    'B','C','M','5','8','8','0',' ','S','e','c','u','r','e',' ','A','p','p','l','i','c','a','t','i','o','n','s',' ','P','r','o','c','e','s','s','o','r',' ','\x98','s','e','c','u','r','e',' ','k','e','y','b','o','a','r','d',
/* 0x013bb = "DTV-DVB UDAT7240LP - ATSC/NTSC/PAL Driver(Without HID)" */
    'D','T','V','-','D','V','B',' ','U','D','A','T','7','2','4','0','L','P',' ','-',' ','A','T','S','C','/','N','T','S','C','/','P','A','L',' ','D','r','i','v','e','r','(','W','i','t','h','o','u','t',' ','H','I','D',')',
/* 0x013f1 = "HWDN2 Rev. E Hi-Gain Wireless-150N Dish Adapter [Realtek RTL8191SU]" */
    'H','W','D','N','2',' ','R','e','v','.',' ','E',' ','H','i','-','G','a','i','n',' ','W','i','r','e','l','e','s','s','-','1','5','0','N',' ','D','i','s','h',' ','\x02',' ','[','\xbe','R','T','L','8','1','9','1','S','U',']',
/* 0x01427 = "PowerShot SD790 IS DIGITAL ELPH / Digital IXUS 90 IS / IXY DIGITAL 95 IS" */
    '\x24','\x84','S','D','7','9','0',' ','I','S',' ','D','I','G','I','T','A','L',' ','E','L','P','H',' ','/',' ','\x09','\xfd','9','0',' ','I','S',' ','/',' ','I','X','Y',' ','D','I','G','I','T','A','L',' ','9','5',' ','I','S',
/* 0x0145c = "Digital IXUS i5 (normal mode) / IXY Digital L2 (normal mode) / PowerShot SD20 (normal mode)" */
    '\x09','\xfd','i','5',' ','(','n','o','r','m','a','l',' ','\x1a',' ','/',' ','I','X','Y',' ','\x09','L','2',' ','(','n','o','r','m','a','l',' ','\x1a',' ','/',' ','\x24','\x84','S','D','2','0',' ','(','n','o','r','m','a','l',' ','\x1a',
/* 0x01491 = "Desire / Desire HD / Hero / Thunderbolt (Charge Mode)" */
    'D','e','s','i','r','e',' ','/',' ','D','e','s','i','r','e',' ','H','D',' ','/',' ','H','e','r','o',' ','/',' ','T','h','u','n','d','e','r','b','o','l','t',' ','(','C','h','a','r','g','e',' ','M','o','d','e',')',
/* 0x014c6 = "IRKit for controlloing home electronics from iOS devices" */
    'I','R','K','i','t',' ','\xcc','c','o','n','t','r','o','l','l','o','i','n','g',' ','h','o','m','e',' ','e','l','e','c','t','r','o','n','i','c','s',' ','f','r','o','m',' ','i','O','S',' ','d','e','v','i','c','e','s',
/* 0x014fb = "AboCom Systems Inc [WN2001 Prolink Wireless-N Nano Adapter]" */
    'A','b','o','C','o','m',' ','\xa6',' ','I','n','c',' ','[','W','N','2','0','0','1',' ','P','r','o','l','i','n','k',' ','W','i','r','e','l','e','s','s','-','N',' ','N','a','n','o',' ','A','d','a','p','t','e','r',']',
/* 0x01530 = "LDHD-UPS [Professional Desktop Hard Drive eSATA / USB2.0]" */
    'L','D','H','D','-','U','P','S',' ','[','P','r','o','f','e','s','s','i','o','n','a','l',' ','D','e','s','k','t','o','p',' ','H','a','r','d',' ','\x14',' ','e','S','A','T','A',' ','/',' ','U','S','B','2','.','0',']',
/* 0x01565 = "PieKey "beta" 4GB model 4E4F41482E4F5247 (SM3251Q BB)" */
    'P','i','e','K','e','y',' ','"','b','e','t','a','"',' ','4','G','B',' ','m','o','d','e','l',' ','4','E','4','F','4','1','4','8','2','E','4','F','5','2','4','7',' ','(','S','M','3','2','5','1','Q',' ','B','B',')',
/* 0x0159a = "OpenMoko Neo1973 kernel mass storage (g_storage) mode" */
    'O','p','e','n','M','o','k','o',' ','N','e','o','1','9','7','3',' ','k','e','r','n','e','l',' ','m','a','s','s',' ','s','t','o','r','a','g','e',' ','(','g','_','s','t','o','r','a','g','e',')',' ','m','o','d','e',
/* 0x015cf = "SMI Grabber (EasyCAP DC60+ clone) (no firmware) [SMI-2021CBE]" */
    'S','M','I',' ','G','r','a','b','b','e','r',' ','(','E','a','s','y','C','A','P',' ','D','C','6','0','+',' ','c','l','o','n','e',')',' ','(','n','o',' ','\xdb',' ','[','S','M','I','-','2','0','2','1','C','B','E',']',
/* 0x01604 = "Metrologic MS7120 Barcode Scanner (uni-directional serial mode)" */
    'M','e','t','r','o','l','o','g','i','c',' ','M','S','7','1','2','0',' ','B','a','r','c','o','d','e',' ','\x25',' ','(','u','n','i','-','d','i','r','e','c','t','i','o','n','a','l',' ','s','e','r','i','a','l',' ','\x1a',
/* 0x01639 = "CL1356T / CL1356T5 / CL1356A smartcard readers (CCID)" */
    'C','L','1','3','5','6','T',' ','/',' ','C','L','1','3','5','6','T','5',' ','/',' ','C','L','1','3','5','6','A',' ','s','m','a','r','t','c','a','r','d',' ','r','e','a','d','e','r','s',' ','(','C','C','I','D',')',
/* 0x0166e = "TP-Link TL-WN821N v3 / TL-WN822N v2 802.11n [Atheros AR7010+AR9287]" */
    'T','P','-','L','i','n','k',' ','T','L','-','W','N','8','2','1','N',' ','v','3',' ','/',' ','T','L','-','W','N','8','2','2','N',' ','v','2',' ','\x99','[','\xaf','A','R','7','0','1','0','+','A','R','9','2','8','7',']',
/* 0x016a3 = "CH341 in parallel mode, usb to printer port converter" */
    'C','H','3','4','1',' ','i','n',' ','p','a','r','a','l','l','e','l',' ','m','o','d','e',',',' ','u','s','b',' ','t','o',' ','p','r','i','n','t','e','r',' ','p','o','r','t',' ','c','o','n','v','e','r','t','e','r',
/* 0x016d8 = "PowerShot SD1000 DIGITAL ELPH / DIGITAL IXUS 70 / IXY DIGITAL 10" */
    '\x24','\x84','S','D','1','0','0','0',' ','D','I','G','I','T','A','L',' ','E','L','P','H',' ','/',' ','D','I','G','I','T','A','L',' ','\xfd','7','0',' ','/',' ','I','X','Y',' ','D','I','G','I','T','A','L',' ','1','0',
/* 0x0170c = "Metrologic MS7120 Barcode Scanner (bi-directional serial mode)" */
    'M','e','t','r','o','l','o','g','i','c',' ','M','S','7','1','2','0',' ','B','a','r','c','o','d','e',' ','\x25',' ','(','b','i','-','d','i','r','e','c','t','i','o','n','a','l',' ','s','e','r','i','a','l',' ','\x1a',
/* 0x01740 = "Elf / Touch / P3450 / T-Mobile MDA Touch / O2 Xda Nova / Dopod S1" */
    'E','l','f',' ','/',' ','\x9d',' ','/',' ','P','3','4','5','0',' ','/',' ','T','-','\x96',' ','M','D','A',' ','\x9d',' ','/',' ','O','2',' ','X','d','a',' ','N','o','v','a',' ','/',' ','D','o','p','o','d',' ','S','1',
/* 0x01774 = "EA101 10 Mbps 10BASE-T Ethernet [Kawasaki LSI KL5KLUSB101B]" */
    'E','A','1','0','1',' ','1','0',' ','M','b','p','s',' ','1','0','B','A','S','E','-','T',' ','\x7f',' ','[','K','a','w','a','s','a','k','i',' ','L','S','I',' ','K','L','5','K','L','U','S','B','1','0','1','B',']',
/* 0x017a8 = "GW-USHyper300 / GW-USH300N 802.11bgn Wireless Adapter [Realtek RTL8191SU]" */
    'G','W','-','U','S','H','y','p','e','r','3','0','0',' ','/',' ','G','W','-','U','S','H','3','0','0','N',' ','8','0','2','.','1','1','b','g','n',' ','\x01','\x02',' ','[','\xbe','R','T','L','8','1','9','1','S','U',']',
/* 0x017dc = "DTV-DVB UDTT704D - DVBT/NTSC/PAL Driver(Without HID)" */
    'D','T','V','-','D','V','B',' ','U','D','T','T','7','0','4','D',' ','-',' ','D','V','B','T','/','N','T','S','C','/','P','A','L',' ','D','r','i','v','e','r','(','W','i','t','h','o','u','t',' ','H','I','D',')',
/* 0x01810 = "OnlyKey Two-factor Authentication and Password Solution" */
    'O','n','l','y','K','e','y',' ','T','w','o','-','f','a','c','t','o','r',' ','A','u','t','h','e','n','t','i','c','a','t','i','o','n',' ','\xe4','P','a','s','s','w','o','r','d',' ','S','o','l','u','t','i','o','n',
/* 0x01844 = "Sony 1.3MP 1/3" ICX445 IIDC video camera [Chameleon]" */
    'S','o','n','y',' ','1','.','3','M','P',' ','1','/','3','"',' ','I','C','X','4','4','5',' ','I','I','D','C',' ','v','i','d','e','o',' ','c','a','m','e','r','a',' ','[','C','h','a','m','e','l','e','o','n',']',
/* 0x01878 = "EP-802A [Artisan 710 Series/Stylus Photo PX710W/TX720W Series]" */
    'E','P','-','8','0','2','A',' ','[','A','r','t','i','s','a','n',' ','7','1','0',' ','S','e','r','i','e','s','/','\xb1','\x86',' ','P','X','7','1','0','W','/','T','X','7','2','0','W',' ','S','e','r','i','e','s',']',
/* 0x018ac = "Globetrotter HSUPA Modem (icon 411 aka "Vodafone K3760")" */
    'G','l','o','b','e','t','r','o','t','t','e','r',' ','H','S','U','P','A',' ','\x1c',' ','(','i','c','o','n',' ','4','1','1',' ','a','k','a',' ','"','V','o','d','a','f','o','n','e',' ','K','3','7','6','0','"',')',
/* 0x018e0 = "PowerShot SD600 DIGITAL ELPH / DIGITAL IXUS 60 / IXY DIGITAL 70" */
    '\x24','\x84','S','D','6','0','0',' ','D','I','G','I','T','A','L',' ','E','L','P','H',' ','/',' ','D','I','G','I','T','A','L',' ','\xfd','6','0',' ','/',' ','I','X','Y',' ','D','I','G','I','T','A','L',' ','7','0',
/* 0x01913 = "Wireless 5520 Cingular Mobile Broadband (3G HSDPA) Minicard Diagnostics Port" */
    '\x01','5','5','2','0',' ','C','i','n','g','u','l','a','r',' ','\x96',' ','\xb7','(','3','G',' ','H','S','D','P','A',')',' ','M','i','n','i','c','a','r','d',' ','D','i','a','g','n','o','s','t','i','c','s',' ','\x87',
/* 0x01946 = "PteroDAQ Data Acquisition on FRDM-KL25Z and future boards" */
    'P','t','e','r','o','D','A','Q',' ','\xe7',' ','A','c','q','u','i','s','i','t','i','o','n',' ','o','n',' ','F','R','D','M','-','K','L','2','5','Z',' ','\xe4','f','u','t','u','r','e',' ','b','o','a','r','d','s',
/* 0x01979 = "My Book Studio (WDBAAJ), My Book Studio LX (WDBACH)" */
    'M','y',' ','B','o','o','k',' ','S','t','u','d','i','o',' ','(','W','D','B','A','A','J',')',',',' ','M','y',' ','B','o','o','k',' ','S','t','u','d','i','o',' ','L','X',' ','(','W','D','B','A','C','H',')',
/* 0x019ac = "Linux-USB "CDC Subset" Device, or Itsy (experimental)" */
    'L','i','n','u','x','-','\x0a',' ','"','C','D','C',' ','S','u','b','s','e','t','"',' ','D','e','v','i','c','e',',',' ','o','r',' ','I','t','s','y',' ','(','e','x','p','e','r','i','m','e','n','t','a','l',')',
/* 0x019df = "Silicon Motion, Inc. - Taiwan (formerly Feiya Technology Corp.)" */
    'S','i','l','i','c','o','n',' ','M','o','t','i','o','n',',',' ','\x07',' ','-',' ','T','a','i','w','a','n',' ','(','f','o','r','m','e','r','l','y',' ','F','e','i','y','a',' ','\x0d',' ','C','o','r','p','.',')',
/* 0x01a12 = "WG111U (no firmware) Double 108 Mbps Wireless [Atheros AR5004X / AR5005UX]" */
    'W','G','1','1','1','U',' ','(','n','o',' ','\xdb',' ','D','o','u','b','l','e',' ','1','0','8',' ','M','b','p','s',' ','\x01','[','\xaf','A','R','5','0','0','4','X',' ','/',' ','A','R','5','0','0','5','U','X',']',
/* 0x01a45 = "China Huada Integrated Circuit Design (Group) Co., Ltd. (CIDC Group)" */
    'C','h','i','n','a',' ','H','u','a','d','a',' ','\x18','C','i','r','c','u','i','t',' ','D','e','s','i','g','n',' ','(','G','r','o','u','p',')',' ','\x0e','\xab',' ','(','C','I','D','C',' ','G','r','o','u','p',')',
/* 0x01a78 = "DiBcom USB2.0 DVB-T reference design (MOD3000P) (warm)" */
    'D','i','B','c','o','m',' ','U','S','B','2','.','0',' ','\xa7','T',' ','r','e','f','e','r','e','n','c','e',' ','d','e','s','i','g','n',' ','(','M','O','D','3','0','0','0','P',')',' ','(','w','a','r','m',')',
/* 0x01aab = "H4SMK 7 Port Hub / Bricked Counterfeit FT232 Serial (UART) IC" */
    'H','4','S','M','K',' ','7',' ','\x87',' ','\xa4',' ','/',' ','B','r','i','c','k','e','d',' ','C','o','u','n','t','e','r','f','e','i','t',' ','F','T','2','3','2',' ','\x90',' ','(','U','A','R','T',')',' ','I','C',
/* 0x01ade = "DiBcom USB2.0 DVB-T reference design (MOD3000P) (cold)" */
    'D','i','B','c','o','m',' ','U','S','B','2','.','0',' ','\xa7','T',' ','r','e','f','e','r','e','n','c','e',' ','d','e','s','i','g','n',' ','(','M','O','D','3','0','0','0','P',')',' ','(','c','o','l','d',')',
/* 0x01b11 = "PowerShot SD750 DIGITAL ELPH / DIGITAL IXUS 75 / IXY DIGITAL 90" */
    '\x24','\x84','S','D','7','5','0',' ','D','I','G','I','T','A','L',' ','E','L','P','H',' ','/',' ','D','I','G','I','T','A','L',' ','\xfd','7','5',' ','/',' ','I','X','Y',' ','D','I','G','I','T','A','L',' ','9','0',
/* 0x01b44 = "Wireless 5720 TELUS Mobile Broadband (EVDO Rev-A) Minicard Diagnostics Port" */
    '\x01','5','7','2','0',' ','T','E','L','U','S',' ','\x96',' ','\xb7','(','E','V','D','O',' ','R','e','v','-','A',')',' ','M','i','n','i','c','a','r','d',' ','D','i','a','g','n','o','s','t','i','c','s',' ','\x87',
/* 0x01b76 = "DWA-142 RangeBooster N Adapter [Marvell 88W8362+88W8060]" */
    'D','W','A','-','1','4','2',' ','R','a','n','g','e','B','o','o','s','t','e','r',' ','N',' ','\x02',' ','[','M','a','r','v','e','l','l',' ','8','8','W','8','3','6','2','+','8','8','W','8','0','6','0',']',
/* 0x01ba8 = "Xlink data transfer and control system for Commodore C64" */
    'X','l','i','n','k',' ','d','a','t','a',' ','t','r','a','n','s','f','e','r',' ','\xe4','c','o','n','t','r','o','l',' ','s','y','s','t','e','m',' ','\xcc','C','o','m','m','o','d','o','r','e',' ','C','6','4',
/* 0x01bda = "Samsung SE-S084 Super WriteMaster Slim External DVD writer" */
    'S','a','m','s','u','n','g',' ','S','E','-','S','0','8','4',' ','S','u','p','e','r',' ','W','r','i','t','e','M','a','s','t','e','r',' ','S','l','i','m',' ','\xe3','D','V','D',' ','w','r','i','t','e','r',
/* 0x01c0c = "DTV-DVB Hybrid Analog/Capture / Pinnacle PCTV 310e" */
    'D','T','V','-','D','V','B',' ','H','y','b','r','i','d',' ','A','n','a','l','o','g','/','C','a','p','t','u','r','e',' ','/',' ','P','i','n','n','a','c','l','e',' ','P','C','T','V',' ','3','1','0','e',
/* 0x01c3e = "3D printed racing game - (Catalina CDC bootloader)" */
    '3','D',' ','p','r','i','n','t','e','d',' ','r','a','c','i','n','g',' ','g','a','m','e',' ','-',' ','(','C','a','t','a','l','i','n','a',' ','C','D','C',' ','b','o','o','t','l','o','a','d','e','r',')',
/* 0x01c70 = "TimVideos\' HDMI2USB (Soft+UTMI) - HDMI/DVI Capture Device" */
    'T','i','m','V','i','d','e','o','s','\'',' ','H','D','M','I','2','\x0a',' ','(','S','o','f','t','+','U','T','M','I',')',' ','-',' ','H','D','M','I','/','D','V','I',' ','C','a','p','t','u','r','e',' ','\x03',
/* 0x01ca2 = "LTE4G O2 ZTE MF821D LTE/UMTS/GSM Modem/Networkcard" */
    'L','T','E','4','G',' ','O','2',' ','Z','T','E',' ','M','F','8','2','1','D',' ','L','T','E','/','U','M','T','S','/','G','S','M',' ','M','o','d','e','m','/','N','e','t','w','o','r','k','c','a','r','d',
/* 0x01cd4 = "Managed Switch M4100 series, M5300 series, M7100 series" */
    'M','a','n','a','g','e','d',' ','S','w','i','t','c','h',' ','M','4','1','0','0',' ','s','e','r','i','e','s',',',' ','M','5','3','0','0',' ','s','e','r','i','e','s',',',' ','M','7','1','0','0',' ','\x1d',
/* 0x01d06 = "CH341 in serial mode, usb to serial port converter" */
    'C','H','3','4','1',' ','i','n',' ','s','e','r','i','a','l',' ','m','o','d','e',',',' ','u','s','b',' ','t','o',' ','s','e','r','i','a','l',' ','p','o','r','t',' ','c','o','n','v','e','r','t','e','r',
/* 0x01d38 = "1.3M WebCam (notebook emachines E730, Acer sub-brand)" */
    '1','.','3','M',' ','W','e','b','\x9a','(','n','o','t','e','b','o','o','k',' ','e','m','a','c','h','i','n','e','s',' ','E','7','3','0',',',' ','A','c','e','r',' ','s','u','b','-','b','r','a','n','d',')',
/* 0x01d6a = "AC51 802.11a/b/g/n/ac Wireless Adapter [Mediatek MT7610/Ralink RT2870]" */
    'A','C','5','1',' ','8','0','2','.','1','1','a','/','b','/','g','/','n','/','a','c',' ','\x01','\x02',' ','[','M','e','d','i','a','t','e','k',' ','M','T','7','6','1','0','/','\x93','R','T','2','8','7','0',']',
/* 0x01d9c = "Todos C400 smartcard controller (Handelsbanken card reader)" */
    'T','o','d','o','s',' ','C','4','0','0',' ','s','m','a','r','t','c','a','r','d',' ','\x9e',' ','(','H','a','n','d','e','l','s','b','a','n','k','e','n',' ','c','a','r','d',' ','r','e','a','d','e','r',')',
/* 0x01dce = "Waterott Arduino based Clock (caterina bootloader)" */
    'W','a','t','e','r','o','t','t',' ','A','r','d','u','i','n','o',' ','b','a','s','e','d',' ','C','l','o','c','k',' ','(','c','a','t','e','r','i','n','a',' ','b','o','o','t','l','o','a','d','e','r',')',
/* 0x01e00 = "WN111(v1) RangeMax Next Wireless [Marvell 88W8362+88W8060]" */
    'W','N','1','1','1','(','v','1',')',' ','R','a','n','g','e','M','a','x',' ','N','e','x','t',' ','\x01','[','M','a','r','v','e','l','l',' ','8','8','W','8','3','6','2','+','8','8','W','8','0','6','0',']',
/* 0x01e32 = "Biothentic II smartcard reader with fingerprint sensor" */
    'B','i','o','t','h','e','n','t','i','c',' ','I','I',' ','s','m','a','r','t','c','a','r','d',' ','r','e','a','d','e','r',' ','\x98','f','i','n','g','e','r','p','r','i','n','t',' ','s','e','n','s','o','r',
/* 0x01e64 = "FusionHDTV DVB-T (MT352+Thomson7579) (uninitialized)" */
    'F','u','s','i','o','n','H','D','T','V',' ','\xa7','T',' ','(','M','T','3','5','2','+','T','h','o','m','s','o','n','7','5','7','9',')',' ','(','u','n','i','n','i','t','i','a','l','i','z','e','d',')',
/* 0x01e95 = "ARC SpectraPro UV/VIS/IR Monochromator/Spectrograph" */
    'A','R','C',' ','S','p','e','c','t','r','a','\x8f',' ','U','V','/','V','I','S','/','I','R',' ','M','o','n','o','c','h','r','o','m','a','t','o','r','/','S','p','e','c','t','r','o','g','r','a','p','h',
/* 0x01ec6 = "replacement for GoodFET/FaceDancer - GreatFet target" */
    'r','e','p','l','a','c','e','m','e','n','t',' ','\xcc','G','o','o','d','F','E','T','/','F','a','c','e','D','a','n','c','e','r',' ','-',' ','G','r','e','a','t','F','e','t',' ','t','a','r','g','e','t',
/* 0x01ef7 = "VTG-5xxx Special (update) mode of VTG-5xxx family" */
    'V','T','G','-','5','x','x','x',' ','S','p','e','c','i','a','l',' ','(','u','p','d','a','t','e',')',' ','m','o','d','e',' ','o','f',' ','V','T','G','-','5','x','x','x',' ','f','a','m','i','l','y',
/* 0x01f28 = "DWA-160 802.11abgn Xtreme N Dual Band Adapter(rev.A1) [Atheros AR9170+AR9104]" */
    'D','W','A','-','1','6','0',' ','\xea','X','t','r','e','m','e',' ','N',' ','D','u','a','l',' ','B','a','n','d',' ','\xbb','A','1',')',' ','[','\xaf','A','R','9','1','7','0','+','A','R','9','1','0','4',']',
/* 0x01f59 = "i.MX 6Solo/6DualLite SystemOnChip in RecoveryMode" */
    'i','.','M','X',' ','6','S','o','l','o','/','6','D','u','a','l','L','i','t','e',' ','S','y','s','t','e','m','O','n','C','h','i','p',' ','i','n',' ','R','e','c','o','v','e','r','y','M','o','d','e',
/* 0x01f8a = "DWA-160 802.11abgn Xtreme N Dual Band Adapter(rev.A2) [Atheros AR9170+AR9104]" */
    'D','W','A','-','1','6','0',' ','\xea','X','t','r','e','m','e',' ','N',' ','D','u','a','l',' ','B','a','n','d',' ','\xbb','A','2',')',' ','[','\xaf','A','R','9','1','7','0','+','A','R','9','1','0','4',']',
/* 0x01fbb = "1.3M pixel Microscope Camera (colour, with capture button)" */
    '1','.','3','M',' ','p','i','x','e','l',' ','M','i','c','r','o','s','c','o','p','e',' ','\x04',' ','(','c','o','l','o','u','r',',',' ','\x98','c','a','p','t','u','r','e',' ','b','u','t','t','o','n',')',
/* 0x01fec = "Athena / Advantage x7500 / Dopod U1000 / T-Mobile AMEO" */
    'A','t','h','e','n','a',' ','/',' ','A','d','v','a','n','t','a','g','e',' ','x','7','5','0','0',' ','/',' ','D','o','p','o','d',' ','U','1','0','0','0',' ','/',' ','T','-','\x96',' ','A','M','E','O',
/* 0x0201d = "cyberJack RFID basis contactless smartcard reader" */
    'c','y','b','e','r','J','a','c','k',' ','R','F','I','D',' ','b','a','s','i','s',' ','c','o','n','t','a','c','t','l','e','s','s',' ','s','m','a','r','t','c','a','r','d',' ','r','e','a','d','e','r',
/* 0x0204e = "Gateway DC-M42/Labtec DC-505/Vivitar Vivicam 3705" */
    'G','a','t','e','w','a','y',' ','D','C','-','M','4','2','/','L','a','b','t','e','c',' ','D','C','-','5','0','5','/','V','i','v','i','t','a','r',' ','V','i','v','i','c','a','m',' ','3','7','0','5',
/* 0x0207f = "My Book Essential (WDBAAF), My Book for Mac (WDBAAG)" */
    'M','y',' ','B','o','o','k',' ','E','s','s','e','n','t','i','a','l',' ','(','W','D','B','A','A','F',')',',',' ','M','y',' ','B','o','o','k',' ','\xcc','M','a','c',' ','(','W','D','B','A','A','G',')',
/* 0x020b0 = "West Mountain Radio Computerized Battery Analyzer" */
    'W','e','s','t',' ','M','o','u','n','t','a','i','n',' ','R','a','d','i','o',' ','C','o','m','p','u','t','e','r','i','z','e','d',' ','B','a','t','t','e','r','y',' ','A','n','a','l','y','z','e','r',
/* 0x020e1 = "Liquid Gallant Duo E350 (debug mode, USB tethering)" */
    'L','i','q','u','i','d',' ','G','a','l','l','a','n','t',' ','D','u','o',' ','E','3','5','0',' ','(','d','e','b','u','g',' ','m','o','d','e',',',' ','\x0a',' ','t','e','t','h','e','r','i','n','g',')',
/* 0x02112 = "Dangerous Prototypes BusPirate v4 Bootloader mode" */
    'D','a','n','g','e','r','o','u','s',' ','P','r','o','t','o','t','y','p','e','s',' ','B','u','s','P','i','r','a','t','e',' ','v','4',' ','B','o','o','t','l','o','a','d','e','r',' ','m','o','d','e',
/* 0x02143 = "AVM Fritz!WLAN v1.1 [Texas Instruments TNETW1450]" */
    'A','V','M',' ','F','r','i','t','z','!','W','L','A','N',' ','v','1','.','1',' ','[','T','e','x','a','s',' ','I','n','s','t','r','u','m','e','n','t','s',' ','T','N','E','T','W','1','4','5','0',']',
/* 0x02174 = "Numato Opsis HDMI2USB board (JTAG Programming Mode)" */
    'N','u','m','a','t','o',' ','O','p','s','i','s',' ','H','D','M','I','2','\x0a',' ','b','o','a','r','d',' ','(','J','T','A','G',' ','P','r','o','g','r','a','m','m','i','n','g',' ','M','o','d','e',')',
/* 0x021a5 = "SDE3273FC/97 2.5" SATA HDD Enclosure [INIC-1608L]" */
    'S','D','E','3','2','7','3','F','C','/','9','7',' ','2','.','5','"',' ','S','A','T','A',' ','H','D','D',' ','E','n','c','l','o','s','u','r','e',' ','[','I','N','I','C','-','1','6','0','8','L',']',
/* 0x021d6 = "AirPlus DWL-120+ Wireless Adapter [Texas Instruments ACX100USB]" */
    'A','i','r','P','l','u','s',' ','D','W','L','-','1','2','0','+',' ','\x01','\x02',' ','[','T','e','x','a','s',' ','I','n','s','t','r','u','m','e','n','t','s',' ','A','C','X','1','0','0','U','S','B',']',
/* 0x02207 = "GT-I9070 (network tethering, USB debugging enabled)" */
    'G','T','-','I','9','0','7','0',' ','(','n','e','t','w','o','r','k',' ','t','e','t','h','e','r','i','n','g',',',' ','\x0a',' ','d','e','b','u','g','g','i','n','g',' ','e','n','a','b','l','e','d',')',
/* 0x02238 = "Gobi 9x15 Multimode 3G/4G LTE Modem (IP passthrough mode)" */
    'G','o','b','i',' ','9','x','1','5',' ','M','u','l','t','i','m','o','d','e',' ','3','G','/','4','G',' ','L','T','E',' ','\x1c',' ','(','I','P',' ','p','a','s','s','t','h','r','o','u','g','h',' ','\x1a',
/* 0x02269 = "STMicroelectronics Imaging Division (VLSI Vision)" */
    'S','T','M','i','c','r','o','e','l','e','c','t','r','o','n','i','c','s',' ','I','m','a','g','i','n','g',' ','D','i','v','i','s','i','o','n',' ','(','V','L','S','I',' ','V','i','s','i','o','n',')',
/* 0x0229a = "AirPlus G DWL-G122 Wireless Adapter(rev.D) [Marvell 88W8338+88W8010]" */
    'A','i','r','P','l','u','s',' ','G',' ','D','W','L','-','G','1','2','2',' ','\x01','\xbb','D',')',' ','[','M','a','r','v','e','l','l',' ','8','8','W','8','3','3','8','+','8','8','W','8','0','1','0',']',
/* 0x022cb = "EP-904A/EP-904F [Artisan 837/Stylus Photo PX830FWD Series]" */
    'E','P','-','9','0','4','A','/','E','P','-','9','0','4','F',' ','[','A','r','t','i','s','a','n',' ','8','3','7','/','\xb1','\x86',' ','P','X','8','3','0','F','W','D',' ','S','e','r','i','e','s',']',
/* 0x022fb = "Black Knight PRO Uninterruptible Power Supply (HID PDC)" */
    'B','l','a','c','k',' ','K','n','i','g','h','t',' ','P','R','O',' ','U','n','i','n','t','e','r','r','u','p','t','i','b','l','e',' ','\x24',' ','S','u','p','p','l','y',' ','(','\xf2','P','D','C',')',
/* 0x0232b = "Johnson Controls, Inc. The Automotive Business Unit" */
    'J','o','h','n','s','o','n',' ','C','o','n','t','r','o','l','s',',',' ','\x07',' ','T','h','e',' ','A','u','t','o','m','o','t','i','v','e',' ','B','u','s','i','n','e','s','s',' ','U','n','i','t',
/* 0x0235b = "BM-USBD1 BlueRobin RF heart rate sensor receiver" */
    'B','M','-','U','S','B','D','1',' ','B','l','u','e','R','o','b','i','n',' ','R','F',' ','h','e','a','r','t',' ','r','a','t','e',' ','s','e','n','s','o','r',' ','r','e','c','e','i','v','e','r',
/* 0x0238b = "CY8CKIT-002 PSoC MiniProg3 Rev A Program and debug kit" */
    'C','Y','8','C','K','I','T','-','0','0','2',' ','P','S','o','C',' ','\xb9','P','r','o','g','3',' ','R','e','v',' ','A',' ','P','r','o','g','r','a','m',' ','\xe4','d','e','b','u','g',' ','k','i','t',
/* 0x023bb = "LUXSHARE PRECISION INDUSTRY (SHENZHEN) CO., LTD." */
    'L','U','X','S','H','A','R','E',' ','P','R','E','C','I','S','I','O','N',' ','I','N','D','U','S','T','R','Y',' ','(','S','H','E','N','Z','H','E','N',')',' ','C','O','.',',',' ','L','T','D','.',
/* 0x023eb = "WN121T RangeMax Next Wireless-N [Marvell TopDog]" */
    'W','N','1','2','1','T',' ','R','a','n','g','e','M','a','x',' ','N','e','x','t',' ','W','i','r','e','l','e','s','s','-','N',' ','[','M','a','r','v','e','l','l',' ','T','o','p','D','o','g',']',
/* 0x0241b = "Transcend JetFlash 2.0 / Astone USB Drive / Intellegent Stick 2.0" */
    'T','r','a','n','s','c','e','n','d',' ','J','e','t','\x3c',' ','\xc1','/',' ','A','s','t','o','n','e',' ','\x0a',' ','\x14',' ','/',' ','I','n','t','e','l','l','e','g','e','n','t',' ','\xb3',' ','2','.','0',
/* 0x0244b = "Epsilon 1.3/Jenoptik JD C1.3/UMAX AstraPix 470 (PC Cam mode)" */
    'E','p','s','i','l','o','n',' ','1','.','3','/','J','e','n','o','p','t','i','k',' ','J','D',' ','C','1','.','3','/','U','M','A','X',' ','A','s','t','r','a','\xd8','4','7','0',' ','(','\x1f','\x9a','\x1a',
/* 0x0247b = "ISOUSB.SYS Intel 82930 Isochronous IO Test Board" */
    'I','S','O','U','S','B','.','S','Y','S',' ','I','n','t','e','l',' ','8','2','9','3','0',' ','I','s','o','c','h','r','o','n','o','u','s',' ','I','O',' ','T','e','s','t',' ','B','o','a','r','d',
/* 0x024ab = "Belkin F5D8051 v2 802.11bgn Wireless Adapter [Marvell 88W8362]" */
    'B','e','l','k','i','n',' ','F','5','D','8','0','5','1',' ','v','2',' ','8','0','2','.','1','1','b','g','n',' ','\x01','\x02',' ','[','M','a','r','v','e','l','l',' ','8','8','W','8','3','6','2',']',
/* 0x024db = "EP-903A/EP-903F [Artisan 835/Stylus Photo PX820FWD Series]" */
    'E','P','-','9','0','3','A','/','E','P','-','9','0','3','F',' ','[','A','r','t','i','s','a','n',' ','8','3','5','/','\xb1','\x86',' ','P','X','8','2','0','F','W','D',' ','S','e','r','i','e','s',']',
/* 0x0250b = "DataTraveler 2.0 1GB/4GB Flash Drive / Patriot Xporter 4GB Flash Drive" */
    '\xe7','T','r','a','v','e','l','e','r',' ','\xc1','1','G','B','/','4','G','B',' ','\x3c',' ','\x14',' ','/',' ','P','a','t','r','i','o','t',' ','X','p','o','r','t','e','r',' ','4','G','B',' ','\x3c',' ','\x14',
/* 0x0253b = "Android-powered device in accessory mode with ADB support" */
    'A','n','d','r','o','i','d','-','p','o','w','e','r','e','d',' ','\xf9',' ','i','n',' ','a','c','c','e','s','s','o','r','y',' ','m','o','d','e',' ','\x98','A','D','B',' ','s','u','p','p','o','r','t',
/* 0x0256b = "Zubax GNSS positioning module for light UAV systems" */
    'Z','u','b','a','x',' ','G','N','S','S',' ','p','o','s','i','t','i','o','n','i','n','g',' ','m','o','d','u','l','e',' ','\xcc','l','i','g','h','t',' ','U','A','V',' ','s','y','s','t','e','m','s',
/* 0x0259b = "Recording Industry Association of America (RIAA)" */
    'R','e','c','o','r','d','i','n','g',' ','I','n','d','u','s','t','r','y',' ','A','s','s','o','c','i','a','t','i','o','n',' ','o','f',' ','A','m','e','r','i','c','a',' ','(','R','I','A','A',')',
/* 0x025cb = "HAN HUA CABLE & WIRE TECHNOLOGY (J.X.) CO., LTD." */
    'H','A','N',' ','H','U','A',' ','C','A','B','L','E',' ','&',' ','W','I','R','E',' ','T','E','C','H','N','O','L','O','G','Y',' ','(','J','.','X','.',')',' ','C','O','.',',',' ','L','T','D','.',
/* 0x025fb = "Dino-Lite Digital Microscope (SN9C201 + MI1310/MT9M111)" */
    'D','i','n','o','-','L','i','t','e',' ','\x09','M','i','c','r','o','s','c','o','p','e',' ','(','S','N','9','C','2','0','1',' ','+',' ','M','I','1','3','1','0','/','M','T','9','M','1','1','1',')',
/* 0x0262b = "TimVideos\' HDMI2USB (Soft+UTMI) - Firmware upgrade" */
    'T','i','m','V','i','d','e','o','s','\'',' ','H','D','M','I','2','\x0a',' ','(','S','o','f','t','+','U','T','M','I',')',' ','-',' ','F','i','r','m','w','a','r','e',' ','u','p','g','r','a','d','e',
/* 0x0265b = "Web Cam - Packard Bell BU45, PB Easynote MX66-208W" */
    'W','e','b',' ','\x9a','-',' ','P','a','c','k','a','r','d',' ','B','e','l','l',' ','B','U','4','5',',',' ','P','B',' ','E','a','s','y','n','o','t','e',' ','M','X','6','6','-','2','0','8','W',
/* 0x0268a = "TimVideos\' HDMI2USB (FX2) - Firmware load/upgrade" */
    'T','i','m','V','i','d','e','o','s','\'',' ','H','D','M','I','2','\x0a',' ','(','F','X','2',')',' ','-',' ','F','i','r','m','w','a','r','e',' ','l','o','a','d','/','u','p','g','r','a','d','e',
/* 0x026b9 = "FusionHDTV DVB-T (MT352+Thomson7579) (initialized)" */
    'F','u','s','i','o','n','H','D','T','V',' ','\xa7','T',' ','(','M','T','3','5','2','+','T','h','o','m','s','o','n','7','5','7','9',')',' ','(','i','n','i','t','i','a','l','i','z','e','d',')',
/* 0x026e8 = "SMI Grabber (EasyCAP DC60+ clone) [SMI-2021CBE]" */
    'S','M','I',' ','G','r','a','b','b','e','r',' ','(','E','a','s','y','C','A','P',' ','D','C','6','0','+',' ','c','l','o','n','e',')',' ','[','S','M','I','-','2','0','2','1','C','B','E',']',
/* 0x02717 = "WUSB300N 802.11bgn Wireless Adapter [Marvell 88W8362+88W8060]" */
    'W','U','S','B','3','0','0','N',' ','8','0','2','.','1','1','b','g','n',' ','\x01','\x02',' ','[','M','a','r','v','e','l','l',' ','8','8','W','8','3','6','2','+','8','8','W','8','0','6','0',']',
/* 0x02746 = "Touch Sensitive Intelligent Control Keypad STICK2B Firmware download" */
    '\x9d',' ','S','e','n','s','i','t','i','v','e',' ','\xe0','\xc9',' ','K','e','y','p','a','d',' ','S','T','I','C','K','2','B',' ','F','i','r','m','w','a','r','e',' ','d','o','w','n','l','o','a','d',
/* 0x02775 = "K5006-Z vodafone LTE/UMTS/GSM Modem/Networkcard" */
    'K','5','0','0','6','-','Z',' ','v','o','d','a','f','o','n','e',' ','L','T','E','/','U','M','T','S','/','G','S','M',' ','M','o','d','e','m','/','N','e','t','w','o','r','k','c','a','r','d',
/* 0x027a4 = "Hermes / TyTN / T-Mobile MDA Vario II / O2 Xda Trion" */
    'H','e','r','m','e','s',' ','/',' ','T','y','T','N',' ','/',' ','T','-','\x96',' ','M','D','A',' ','V','a','r','i','o',' ','I','I',' ','/',' ','O','2',' ','X','d','a',' ','T','r','i','o','n',
/* 0x027d3 = "DiscFerret Magnetic Disc Analyser (bootloader mode)" */
    'D','i','s','c','F','e','r','r','e','t',' ','M','a','g','n','e','t','i','c',' ','D','i','s','c',' ','A','n','a','l','y','s','e','r',' ','(','b','o','o','t','l','o','a','d','e','r',' ','\x1a',
/* 0x02802 = "Alcatel One Touch L100V / Telekom Speedstick LTE II" */
    'A','l','c','a','t','e','l',' ','O','n','e',' ','\x9d',' ','L','1','0','0','V',' ','/',' ','T','e','l','e','k','o','m',' ','S','p','e','e','d','s','t','i','c','k',' ','L','T','E',' ','I','I',
/* 0x02831 = "NI MIO (data acquisition card) firmware updater" */
    'N','I',' ','M','I','O',' ','(','d','a','t','a',' ','a','c','q','u','i','s','i','t','i','o','n',' ','c','a','r','d',')',' ','f','i','r','m','w','a','r','e',' ','u','p','d','a','t','e','r',
/* 0x02860 = "Touch Sensitive Intelligent Control Keypad STICK1B Firmware download" */
    '\x9d',' ','S','e','n','s','i','t','i','v','e',' ','\xe0','\xc9',' ','K','e','y','p','a','d',' ','S','T','I','C','K','1','B',' ','F','i','r','m','w','a','r','e',' ','d','o','w','n','l','o','a','d',
/* 0x0288f = "DTH-A1300 [Cintiq Companion Hybrid] touchscreen" */
    'D','T','H','-','A','1','3','0','0',' ','[','C','i','n','t','i','q',' ','C','o','m','p','a','n','i','o','n',' ','H','y','b','r','i','d',']',' ','t','o','u','c','h','s','c','r','e','e','n',
/* 0x028be = "Canvio Alu 2TB 2.5" Black External Disk Model HDTH320EK3CA" */
    'C','a','n','v','i','o',' ','A','l','u',' ','2','T','B',' ','2','.','5','"',' ','B','l','a','c','k',' ','\xe3','\xe8',' ','M','o','d','e','l',' ','H','D','T','H','3','2','0','E','K','3','C','A',
/* 0x028ed = "CHUSB Duo Charger (NiMH AA/AAA USB smart charger)" */
    'C','H','U','S','B',' ','D','u','o',' ','C','h','a','r','g','e','r',' ','(','N','i','M','H',' ','A','A','/','A','A','A',' ','\x0a',' ','s','m','a','r','t',' ','c','h','a','r','g','e','r',')',
/* 0x0291c = "Neo1973/FreeRunner u-boot usbtty generic serial" */
    'N','e','o','1','9','7','3','/','F','r','e','e','R','u','n','n','e','r',' ','u','-','b','o','o','t',' ','u','s','b','t','t','y',' ','g','e','n','e','r','i','c',' ','s','e','r','i','a','l',
/* 0x0294b = "Texas Instruments XDS100v2 JTAG / BeagleBone A3" */
    'T','e','x','a','s',' ','I','n','s','t','r','u','m','e','n','t','s',' ','X','D','S','1','0','0','v','2',' ','J','T','A','G',' ','/',' ','B','e','a','g','l','e','B','o','n','e',' ','A','3',
/* 0x0297a = "ISP 1581 Hi-Speed USB MPEG2 Encoder Reference Kit" */
    'I','S','P',' ','1','5','8','1',' ','H','i','-','S','p','e','e','d',' ','\x0a',' ','M','P','E','G','2',' ','E','n','c','o','d','e','r',' ','R','e','f','e','r','e','n','c','e',' ','K','i','t',
/* 0x029a9 = "CNUSB-611AR Wireless Adapter-G [AT76C503] (FiberLine WL-240U)" */
    'C','N','U','S','B','-','6','1','1','A','R',' ','\x01','\x02','-','G',' ','[','A','T','7','6','C','5','0','3',']',' ','(','F','i','b','e','r','L','i','n','e',' ','W','L','-','2','4','0','U',')',
/* 0x029d8 = "FM Radio Receiver/Instant FM Music (RDX-155-EF)" */
    'F','M',' ','R','a','d','i','o',' ','R','e','c','e','i','v','e','r','/','I','n','s','t','a','n','t',' ','F','M',' ','M','u','s','i','c',' ','(','R','D','X','-','1','5','5','-','E','F',')',
/* 0x02a07 = "PV-D231U(RN)-F [PixelView PlayTV SBTVD Full-Seg]" */
    'P','V','-','D','2','3','1','U','(','R','N',')','-','F',' ','[','P','i','x','e','l','V','i','e','w',' ','P','l','a','y','\xda','S','B','T','V','D',' ','F','u','l','l','-','S','e','g',']',
/* 0x02a35 = "TP-Link TL-WN322G v3 / TL-WN422G v2 802.11g [Atheros AR9271]" */
    'T','P','-','L','i','n','k',' ','T','L','-','W','N','3','2','2','G',' ','v','3',' ','/',' ','T','L','-','W','N','4','2','2','G',' ','v','2',' ','\x94','[','\xaf','A','R','9','2','7','1',']',
/* 0x02a63 = "AVermedia/Yakumo/Hama/Typhoon DVB-T USB2.0 (cold)" */
    'A','V','e','r','m','e','d','i','a','/','Y','a','k','u','m','o','/','H','a','m','a','/','T','y','p','h','o','o','n',' ','\xa7','T',' ','U','S','B','2','.','0',' ','(','c','o','l','d',')',
/* 0x02a91 = "MorphoAccess SIGMA Biometric Access Control Terminal" */
    'M','o','r','p','h','o','A','c','c','e','s','s',' ','S','I','G','M','A',' ','B','i','o','m','e','t','r','i','c',' ','A','c','c','e','s','s',' ','\xc9',' ','T','e','r','m','i','n','a','l',
/* 0x02abf = "TP-Link TL-WN821N v2 / TL-WN822N v1 802.11n [Atheros AR9170]" */
    'T','P','-','L','i','n','k',' ','T','L','-','W','N','8','2','1','N',' ','v','2',' ','/',' ','T','L','-','W','N','8','2','2','N',' ','v','1',' ','\x99','[','\xaf','A','R','9','1','7','0',']',
/* 0x02aed = "Touch Sensitive Intelligent Control Keypad STICK3 Firmware download" */
    '\x9d',' ','S','e','n','s','i','t','i','v','e',' ','\xe0','\xc9',' ','K','e','y','p','a','d',' ','S','T','I','C','K','3',' ','F','i','r','m','w','a','r','e',' ','d','o','w','n','l','o','a','d',
/* 0x02b1b = "Touch Sensitive Intelligent Control Keypad STICK2 Firmware download" */
    '\x9d',' ','S','e','n','s','i','t','i','v','e',' ','\xe0','\xc9',' ','K','e','y','p','a','d',' ','S','T','I','C','K','2',' ','F','i','r','m','w','a','r','e',' ','d','o','w','n','l','o','a','d',
/* 0x02b49 = "CTH-661SE [Bamboo Pen & Touch Special Edition (M)]" */
    'C','T','H','-','6','6','1','S','E',' ','[','B','a','m','b','o','o',' ','P','e','n',' ','&',' ','\x9d',' ','S','p','e','c','i','a','l',' ','E','d','i','t','i','o','n',' ','(','M',')',']',
/* 0x02b77 = "ME OFFICE 620F Series/Stylus Office BX305F/BX305FW/TX320F" */
    'M','E',' ','O','F','F','I','C','E',' ','6','2','0','F',' ','S','e','r','i','e','s','/','\xb1','\xd3',' ','B','X','3','0','5','F','/','B','X','3','0','5','F','W','/','T','X','3','2','0','F',
/* 0x02ba5 = "TimVideos\' HDMI2USB (Soft+UTMI) - Unconfigured device" */
    'T','i','m','V','i','d','e','o','s','\'',' ','H','D','M','I','2','\x0a',' ','(','S','o','f','t','+','U','T','M','I',')',' ','-',' ','U','n','c','o','n','f','i','g','u','r','e','d',' ','\xf9',
/* 0x02bd3 = "CTH-461SE [Bamboo Pen & Touch Special Edition (S)]" */
    'C','T','H','-','4','6','1','S','E',' ','[','B','a','m','b','o','o',' ','P','e','n',' ','&',' ','\x9d',' ','S','p','e','c','i','a','l',' ','E','d','i','t','i','o','n',' ','(','S',')',']',
/* 0x02c01 = "My Book Essential Edition (Green Ring) (WDG1U)" */
    'M','y',' ','B','o','o','k',' ','E','s','s','e','n','t','i','a','l',' ','E','d','i','t','i','o','n',' ','(','G','r','e','e','n',' ','R','i','n','g',')',' ','(','W','D','G','1','U',')',
/* 0x02c2f = "Duosense Transparent Electromagnetic Digitizer" */
    'D','u','o','s','e','n','s','e',' ','T','r','a','n','s','p','a','r','e','n','t',' ','E','l','e','c','t','r','o','m','a','g','n','e','t','i','c',' ','D','i','g','i','t','i','z','e','r',
/* 0x02c5d = "Controller Board for Projected Capacitive Touch Screen DUS3000" */
    '\x13',' ','B','o','a','r','d',' ','\xcc','P','r','o','j','e','c','t','e','d',' ','C','a','p','a','c','i','t','i','v','e',' ','\x9d',' ','S','c','r','e','e','n',' ','D','U','S','3','0','0','0',
/* 0x02c8b = "DiscFerret magnetic disc analyser (bootloader)" */
    'D','i','s','c','F','e','r','r','e','t',' ','m','a','g','n','e','t','i','c',' ','d','i','s','c',' ','a','n','a','l','y','s','e','r',' ','(','b','o','o','t','l','o','a','d','e','r',')',
/* 0x02cb9 = "Eye Movement Recorder [Visagraph]/[ReadAlyzer]" */
    'E','y','e',' ','M','o','v','e','m','e','n','t',' ','R','e','c','o','r','d','e','r',' ','[','V','i','s','a','g','r','a','p','h',']','/','[','R','e','a','d','A','l','y','z','e','r',']',
/* 0x02ce7 = "FT-0405 [Volito, PenPartner, PenStation (4x5)]" */
    'F','T','-','0','4','0','5',' ','[','V','o','l','i','t','o',',',' ','P','e','n','P','a','r','t','n','e','r',',',' ','P','e','n','S','t','a','t','i','o','n',' ','(','4','x','5',')',']',
/* 0x02d15 = "AVermedia/Yakumo/Hama/Typhoon DVB-T USB2.0 (warm)" */
    'A','V','e','r','m','e','d','i','a','/','Y','a','k','u','m','o','/','H','a','m','a','/','T','y','p','h','o','o','n',' ','\xa7','T',' ','U','S','B','2','.','0',' ','(','w','a','r','m',')',
/* 0x02d43 = "EP-902A [Artisan 810 Series/Stylus Photo PX810FW Series]" */
    'E','P','-','9','0','2','A',' ','[','A','r','t','i','s','a','n',' ','8','1','0',' ','S','e','r','i','e','s','/','\xb1','\x86',' ','P','X','8','1','0','F','W',' ','S','e','r','i','e','s',']',
/* 0x02d71 = "Wireless 5720 Sprint Mobile Broadband (EVDO Rev-A) Minicard Status Port" */
    '\x01','5','7','2','0',' ','S','p','r','i','n','t',' ','\x96',' ','\xb7','(','E','V','D','O',' ','R','e','v','-','A',')',' ','M','i','n','i','c','a','r','d',' ','S','t','a','t','u','s',' ','\x87',
/* 0x02d9f = "FT-0203 [Volito, PenPartner, PenStation (2x3)]" */
    'F','T','-','0','2','0','3',' ','[','V','o','l','i','t','o',',',' ','P','e','n','P','a','r','t','n','e','r',',',' ','P','e','n','S','t','a','t','i','o','n',' ','(','2','x','3',')',']',
/* 0x02dcd = "WG111U Double 108 Mbps Wireless [Atheros AR5004X / AR5005UX]" */
    'W','G','1','1','1','U',' ','D','o','u','b','l','e',' ','1','0','8',' ','M','b','p','s',' ','\x01','[','\xaf','A','R','5','0','0','4','X',' ','/',' ','A','R','5','0','0','5','U','X',']',
/* 0x02dfa = "OpenMoko Neo1973 u-boot usbtty generic serial" */
    'O','p','e','n','M','o','k','o',' ','N','e','o','1','9','7','3',' ','u','-','b','o','o','t',' ','u','s','b','t','t','y',' ','g','e','n','e','r','i','c',' ','s','e','r','i','a','l',
/* 0x02e27 = "WUSB600N v1 Dual-Band Wireless-N Network Adapter [Ralink RT2870]" */
    'W','U','S','B','6','0','0','N',' ','v','1',' ','D','u','a','l','-','B','a','n','d',' ','W','i','r','e','l','e','s','s','-','N',' ','\x8d','\x02',' ','[','\x93','R','T','2','8','7','0',']',
/* 0x02e54 = "Afilias Optical Mouse H3003 / Trust Optical USB MultiColour Mouse MI-2330" */
    'A','f','i','l','i','a','s',' ','\x7b','\x0b',' ','H','3','0','0','3',' ','/',' ','T','r','u','s','t',' ','\x7b','\x0a',' ','\xd6','C','o','l','o','u','r',' ','\x0b',' ','M','I','-','2','3','3','0',
/* 0x02e81 = "JMS539/567 SuperSpeed SATA II/III 3.0G/6.0G Bridge" */
    'J','M','S','5','3','9','/','5','6','7',' ','S','u','p','e','r','S','p','e','e','d',' ','S','A','T','A',' ','I','I','/','I','I','I',' ','3','.','0','G','/','6','.','0','G',' ','\x9f',
/* 0x02eae = "Zoran Co. PMD (Nogatech) AV-grabber Manhattan" */
    'Z','o','r','a','n',' ','C','o','.',' ','P','M','D',' ','(','N','o','g','a','t','e','c','h',')',' ','A','V','-','g','r','a','b','b','e','r',' ','M','a','n','h','a','t','t','a','n',
/* 0x02edb = "DTV-DVB UDAT7240 - ATSC/NTSC/PAL Driver(PCM4)" */
    'D','T','V','-','D','V','B',' ','U','D','A','T','7','2','4','0',' ','-',' ','A','T','S','C','/','N','T','S','C','/','P','A','L',' ','D','r','i','v','e','r','(','P','C','M','4',')',
/* 0x02f08 = "Neo1973/FreeRunner u-boot cdc_acm serial port" */
    'N','e','o','1','9','7','3','/','F','r','e','e','R','u','n','n','e','r',' ','u','-','b','o','o','t',' ','c','d','c','_','a','c','m',' ','s','e','r','i','a','l',' ','p','o','r','t',
/* 0x02f35 = "WUSB600N v2 Dual-Band Wireless-N Network Adapter [Ralink RT3572]" */
    'W','U','S','B','6','0','0','N',' ','v','2',' ','D','u','a','l','-','B','a','n','d',' ','W','i','r','e','l','e','s','s','-','N',' ','\x8d','\x02',' ','[','\x93','R','T','3','5','7','2',']',
/* 0x02f62 = "Neo1973/FreeRunner kernel cdc_ether USB network" */
    'N','e','o','1','9','7','3','/','F','r','e','e','R','u','n','n','e','r',' ','k','e','r','n','e','l',' ','c','d','c','_','e','t','h','e','r',' ','\x0a',' ','n','e','t','w','o','r','k',
/* 0x02f8f = "K5005 Vodafone LTE/UMTS/GSM MOdem/Networkcard" */
    'K','5','0','0','5',' ','V','o','d','a','f','o','n','e',' ','L','T','E','/','U','M','T','S','/','G','S','M',' ','M','O','d','e','m','/','N','e','t','w','o','r','k','c','a','r','d',
/* 0x02fbc = "5932-USB Enhanced Keyboard, Flash-Recovery/Download" */
    '5','9','3','2','-','\x0a',' ','E','n','h','a','n','c','e','d',' ','K','e','y','b','o','a','r','d',',',' ','\x3c','-','R','e','c','o','v','e','r','y','/','D','o','w','n','l','o','a','d',
/* 0x02fe9 = "at90usbkey sample firmware (composite device)" */
    'a','t','9','0','u','s','b','k','e','y',' ','s','a','m','p','l','e',' ','f','i','r','m','w','a','r','e',' ','(','c','o','m','p','o','s','i','t','e',' ','d','e','v','i','c','e',')',
/* 0x03016 = "Welland ME-740PS USB2 3.5" Power Saving Enclosure" */
    'W','e','l','l','a','n','d',' ','M','E','-','7','4','0','P','S',' ','U','S','B','2',' ','3','.','5','"',' ','\x24',' ','S','a','v','i','n','g',' ','E','n','c','l','o','s','u','r','e',
/* 0x03043 = "Wireless 5520 Voda I Mobile Broadband (3G HSDPA) Minicard EAP-SIM Port" */
    '\x01','5','5','2','0',' ','V','o','d','a',' ','I',' ','\x96',' ','\xb7','(','3','G',' ','H','S','D','P','A',')',' ','M','i','n','i','c','a','r','d',' ','E','A','P','-','S','I','M',' ','\x87',
/* 0x03070 = "K5005 Vodafone LTE/UMTS/GSM Modem/Networkcard" */
    'K','5','0','0','5',' ','V','o','d','a','f','o','n','e',' ','L','T','E','/','U','M','T','S','/','G','S','M',' ','M','o','d','e','m','/','N','e','t','w','o','r','k','c','a','r','d',
/* 0x0309d = "Conceptronic C300RU v1 802.11bgn Wireless Adapter [Ralink RT2870]" */
    'C','o','n','c','e','p','t','r','o','n','i','c',' ','C','3','0','0','R','U',' ','v','1',' ','8','0','2','.','1','1','b','g','n',' ','\x01','\x02',' ','[','\x93','R','T','2','8','7','0',']',
/* 0x030ca = "Onboard Emulator on SAUModule development kit" */
    'O','n','b','o','a','r','d',' ','E','m','u','l','a','t','o','r',' ','o','n',' ','S','A','U','M','o','d','u','l','e',' ','d','e','v','e','l','o','p','m','e','n','t',' ','k','i','t',
/* 0x030f7 = "Conceptronic C300RU v2 802.11bgn Wireless Adapter [Ralink RT2770]" */
    'C','o','n','c','e','p','t','r','o','n','i','c',' ','C','3','0','0','R','U',' ','v','2',' ','8','0','2','.','1','1','b','g','n',' ','\x01','\x02',' ','[','\x93','R','T','2','7','7','0',']',
/* 0x03124 = "DTV-DVB UDTT704C - DVBT/NTSC/PAL Driver(PCM4)" */
    'D','T','V','-','D','V','B',' ','U','D','T','T','7','0','4','C',' ','-',' ','D','V','B','T','/','N','T','S','C','/','P','A','L',' ','D','r','i','v','e','r','(','P','C','M','4',')',
/* 0x03151 = "WUSB200: Wireless-G Business Network Adapter with Rangebooster" */
    'W','U','S','B','2','0','0',':',' ','W','i','r','e','l','e','s','s','-','G',' ','B','u','s','i','n','e','s','s',' ','\x8d','\x02',' ','\x98','R','a','n','g','e','b','o','o','s','t','e','r',
/* 0x0317e = "DashDrive Durable HD710 portable HDD various size" */
    'D','a','s','h','\x14',' ','D','u','r','a','b','l','e',' ','H','D','7','1','0',' ','p','o','r','t','a','b','l','e',' ','H','D','D',' ','v','a','r','i','o','u','s',' ','s','i','z','e',
/* 0x031ab = "i.MX 6Dual/6Quad SystemOnChip in RecoveryMode" */
    'i','.','M','X',' ','6','D','u','a','l','/','6','Q','u','a','d',' ','S','y','s','t','e','m','O','n','C','h','i','p',' ','i','n',' ','R','e','c','o','v','e','r','y','M','o','d','e',
/* 0x031d8 = "NetScroll+ Mini Traveler / Genius NetScroll 120" */
    'N','e','t','S','c','r','o','l','l','+',' ','\xb9',' ','T','r','a','v','e','l','e','r',' ','/',' ','G','e','n','i','u','s',' ','N','e','t','S','c','r','o','l','l',' ','1','2','0',
/* 0x03204 = "HSUPA Modem FLYING-LARK46-VER0.07 [Flying Angel]" */
    'H','S','U','P','A',' ','\x1c',' ','F','L','Y','I','N','G','-','L','A','R','K','4','6','-','V','E','R','0','.','0','7',' ','[','F','l','y','i','n','g',' ','A','n','g','e','l',']',
/* 0x03230 = "mvBlueLYNX-X intelligent camera (bootloader)" */
    'm','v','B','l','u','e','L','Y','N','X','-','X',' ','i','n','t','e','l','l','i','g','e','n','t',' ','c','a','m','e','r','a',' ','(','b','o','o','t','l','o','a','d','e','r',')',
/* 0x0325c = "DTV-DVB UDXTTM6010 - A/D Driver(Without HID)" */
    'D','T','V','-','D','V','B',' ','U','D','X','T','T','M','6','0','1','0',' ','-',' ','A','/','D',' ','D','r','i','v','e','r','(','W','i','t','h','o','u','t',' ','H','I','D',')',
/* 0x03288 = "AVM Fritz!WLAN [Texas Instruments TNETW1450]" */
    'A','V','M',' ','F','r','i','t','z','!','W','L','A','N',' ','[','T','e','x','a','s',' ','I','n','s','t','r','u','m','e','n','t','s',' ','T','N','E','T','W','1','4','5','0',']',
/* 0x032b4 = "PCR330A RFID Reader (125 kHz, keyboard emulation)" */
    'P','C','R','3','3','0','A',' ','R','F','I','D',' ','\x08',' ','(','1','2','5',' ','k','H','z',',',' ','k','e','y','b','o','a','r','d',' ','e','m','u','l','a','t','i','o','n',')',
/* 0x032e0 = "CTH-461 [Bamboo Fun/Craft/Comic Pen & Touch (S)]" */
    'C','T','H','-','4','6','1',' ','[','B','a','m','b','o','o',' ','F','u','n','/','C','r','a','f','t','/','C','o','m','i','c',' ','P','e','n',' ','&',' ','\x9d',' ','(','S',')',']',
/* 0x0330c = "RZ06-0063 Motion Sensing Controllers [Hydra]" */
    'R','Z','0','6','-','0','0','6','3',' ','M','o','t','i','o','n',' ','S','e','n','s','i','n','g',' ','C','o','n','t','r','o','l','l','e','r','s',' ','[','H','y','d','r','a',']',
/* 0x03338 = "HWDN1 Hi-Gain Wireless-300N Dish Adapter [Ralink RT2870]" */
    'H','W','D','N','1',' ','H','i','-','G','a','i','n',' ','W','i','r','e','l','e','s','s','-','3','0','0','N',' ','D','i','s','h',' ','\x02',' ','[','\x93','R','T','2','8','7','0',']',
/* 0x03364 = "USB, 4-axis, 6-button joystick w/view finder" */
    'U','S','B',',',' ','4','-','a','x','i','s',',',' ','6','-','b','u','t','t','o','n',' ','j','o','y','s','t','i','c','k',' ','w','/','v','i','e','w',' ','f','i','n','d','e','r',
/* 0x03390 = "STMP3780/i.MX23 SystemOnChip in RecoveryMode" */
    'S','T','M','P','3','7','8','0','/','i','.','M','X','2','3',' ','S','y','s','t','e','m','O','n','C','h','i','p',' ','i','n',' ','R','e','c','o','v','e','r','y','M','o','d','e',
/* 0x033bc = "DiBcom USB DVB-T reference design (MOD300) (cold)" */
    'D','i','B','c','o','m',' ','\x0a',' ','\xa7','T',' ','r','e','f','e','r','e','n','c','e',' ','d','e','s','i','g','n',' ','(','M','O','D','3','0','0',')',' ','(','c','o','l','d',')',
/* 0x033e8 = "Loctronix ASR-2300 SDR/motion sensing module" */
    'L','o','c','t','r','o','n','i','x',' ','A','S','R','-','2','3','0','0',' ','S','D','R','/','m','o','t','i','o','n',' ','s','e','n','s','i','n','g',' ','m','o','d','u','l','e',
/* 0x03414 = "HWDN2 Hi-Gain Wireless-150N Dish Adapter [Ralink RT2770]" */
    'H','W','D','N','2',' ','H','i','-','G','a','i','n',' ','W','i','r','e','l','e','s','s','-','1','5','0','N',' ','D','i','s','h',' ','\x02',' ','[','\x93','R','T','2','7','7','0',']',
/* 0x03440 = "Teensy 2.0 Development Board [ErgoDox Keyboard]" */
    'T','e','e','n','s','y',' ','\xc1','D','e','v','e','l','o','p','m','e','n','t',' ','B','o','a','r','d',' ','[','E','r','g','o','D','o','x',' ','K','e','y','b','o','a','r','d',']',
/* 0x0346c = "DiBcom USB DVB-T reference design (MOD300) (warm)" */
    'D','i','B','c','o','m',' ','\x0a',' ','\xa7','T',' ','r','e','f','e','r','e','n','c','e',' ','d','e','s','i','g','n',' ','(','M','O','D','3','0','0',')',' ','(','w','a','r','m',')',
/* 0x03498 = "TimVideos\' HDMI2USB (FX2) - HDMI/DVI Capture Device" */
    'T','i','m','V','i','d','e','o','s','\'',' ','H','D','M','I','2','\x0a',' ','(','F','X','2',')',' ','-',' ','H','D','M','I','/','D','V','I',' ','C','a','p','t','u','r','e',' ','\x03',
/* 0x034c4 = "Targa Silvercrest OMC807-C optische Funkmaus" */
    'T','a','r','g','a',' ','S','i','l','v','e','r','c','r','e','s','t',' ','O','M','C','8','0','7','-','C',' ','o','p','t','i','s','c','h','e',' ','F','u','n','k','m','a','u','s',
/* 0x034f0 = "Hantek DDS-3X25 Arbitrary Waveform Generator" */
    'H','a','n','t','e','k',' ','D','D','S','-','3','X','2','5',' ','A','r','b','i','t','r','a','r','y',' ','W','a','v','e','f','o','r','m',' ','G','e','n','e','r','a','t','o','r',
/* 0x0351c = "FusionHDTV DVB-T (MT352+LgZ201) (uninitialized)" */
    'F','u','s','i','o','n','H','D','T','V',' ','\xa7','T',' ','(','M','T','3','5','2','+','L','g','Z','2','0','1',')',' ','(','u','n','i','n','i','t','i','a','l','i','z','e','d',')',
/* 0x03548 = "Programmable Magnetic Swipe Card Reader, MSRP-USB" */
    'P','r','o','g','r','a','m','m','a','b','l','e',' ','M','a','g','n','e','t','i','c',' ','S','w','i','p','e',' ','\x15',' ','R','e','a','d','e','r',',',' ','M','S','R','P','-','\x0a',
/* 0x03574 = "Shenzhen Bao Hing Electric Wire & Cable Mfr. Co." */
    'S','h','e','n','z','h','e','n',' ','B','a','o',' ','H','i','n','g',' ','E','l','e','c','t','r','i','c',' ','W','i','r','e',' ','&',' ','\xa5',' ','M','f','r','.',' ','C','o','.',
/* 0x035a0 = "Hantek DDS-3005 Arbitrary Waveform Generator" */
    'H','a','n','t','e','k',' ','D','D','S','-','3','0','0','5',' ','A','r','b','i','t','r','a','r','y',' ','W','a','v','e','f','o','r','m',' ','G','e','n','e','r','a','t','o','r',
/* 0x035cc = "AnyPoint(TM) Wireless II Network 11Mbps Adapter [Atmel AT76C503A]" */
    'A','n','y','P','o','i','n','t','(','T','M',')',' ','\x01','I','I',' ','\x8d','1','1','M','b','p','s',' ','\x02',' ','[','A','t','m','e','l',' ','A','T','7','6','C','5','0','3','A',']',
/* 0x035f8 = "Wireless 5520 Voda L Mobile Broadband (3G HSDPA) Minicard Status Port" */
    '\x01','5','5','2','0',' ','V','o','d','a',' ','L',' ','\x96',' ','\xb7','(','3','G',' ','H','S','D','P','A',')',' ','M','i','n','i','c','a','r','d',' ','S','t','a','t','u','s',' ','\x87',
/* 0x03624 = "USB2LPT with 3 interfaces (native, HID, printer)" */
    'U','S','B','2','L','P','T',' ','\x98','3',' ','i','n','t','e','r','f','a','c','e','s',' ','(','n','a','t','i','v','e',',',' ','H','I','D',',',' ','p','r','i','n','t','e','r',')',
/* 0x03650 = "QV-8000SX/5700/3000EX Digicam; Exilim EX-M20" */
    'Q','V','-','8','0','0','0','S','X','/','5','7','0','0','/','3','0','0','0','E','X',' ','D','i','g','i','c','a','m',';',' ','E','x','i','l','i','m',' ','E','X','-','M','2','0',
/* 0x0367c = "Seiko Instruments InkLink Handwriting System" */
    'S','e','i','k','o',' ','I','n','s','t','r','u','m','e','n','t','s',' ','I','n','k','L','i','n','k',' ','H','a','n','d','w','r','i','t','i','n','g',' ','S','y','s','t','e','m',
/* 0x036a8 = "OpenBLT generic microcontroller (bootloader)" */
    'O','p','e','n','B','L','T',' ','g','e','n','e','r','i','c',' ','m','i','c','r','o','c','o','n','t','r','o','l','l','e','r',' ','(','b','o','o','t','l','o','a','d','e','r',')',
/* 0x036d4 = "Institut of Microelectronic & Mechatronic Systems" */
    'I','n','s','t','i','t','u','t',' ','o','f',' ','M','i','c','r','o','e','l','e','c','t','r','o','n','i','c',' ','&',' ','M','e','c','h','a','t','r','o','n','i','c',' ','\xa6',
/* 0x036ff = "CNUSB-611 Wireless Adapter [AT76C505] (FiberLine WL-240U)" */
    'C','N','U','S','B','-','6','1','1',' ','\x01','\x02',' ','[','A','T','7','6','C','5','0','5',']',' ','(','F','i','b','e','r','L','i','n','e',' ','W','L','-','2','4','0','U',')',
/* 0x0372a = "SPCA1527A/SPCA1528 SD card camera (webcam mode)" */
    'S','P','C','A','1','5','2','7','A','/','S','P','C','A','1','5','2','8',' ','S','D',' ','c','a','r','d',' ','c','a','m','e','r','a',' ','(','w','e','b','c','a','m',' ','\x1a',
/* 0x03755 = "Neural Impulse Actuator Prototype 1.0 [NIA]" */
    'N','e','u','r','a','l',' ','I','m','p','u','l','s','e',' ','A','c','t','u','a','t','o','r',' ','P','r','o','t','o','t','y','p','e',' ','1','.','0',' ','[','N','I','A',']',
/* 0x03780 = "PLX Technology, Inc. (formerly Oxford Semiconductor, Ltd)" */
    'P','L','X',' ','\x95','\x07',' ','(','f','o','r','m','e','r','l','y',' ','O','x','f','o','r','d',' ','S','e','m','i','c','o','n','d','u','c','t','o','r',',',' ','L','t','d',')',
/* 0x037ab = "Rigol Technologies DG1022 Arbitrary Waveform Generator" */
    'R','i','g','o','l',' ','\x88',' ','D','G','1','0','2','2',' ','A','r','b','i','t','r','a','r','y',' ','W','a','v','e','f','o','r','m',' ','G','e','n','e','r','a','t','o','r',
/* 0x037d6 = "5953-USB Enhanced Dynakey Flash-Recovery/Download" */
    '5','9','5','3','-','\x0a',' ','E','n','h','a','n','c','e','d',' ','D','y','n','a','k','e','y',' ','\x3c','-','R','e','c','o','v','e','r','y','/','D','o','w','n','l','o','a','d',
/* 0x03801 = "Che-Ez Snap SNAP-U/Digigr8/Soundstar TDC-35" */
    'C','h','e','-','E','z',' ','S','n','a','p',' ','S','N','A','P','-','U','/','D','i','g','i','g','r','8','/','S','o','u','n','d','s','t','a','r',' ','T','D','C','-','3','5',
/* 0x0382c = "CL1356A FFPJP smartcard reader (CCID + HID)" */
    'C','L','1','3','5','6','A',' ','F','F','P','J','P',' ','s','m','a','r','t','c','a','r','d',' ','r','e','a','d','e','r',' ','(','C','C','I','D',' ','+',' ','H','I','D',')',
/* 0x03857 = "AlDiga AL-11U Quad-band GSM/GPRS/EDGE modem" */
    'A','l','D','i','g','a',' ','A','L','-','1','1','U',' ','Q','u','a','d','-','b','a','n','d',' ','G','S','M','/','G','P','R','S','/','E','D','G','E',' ','m','o','d','e','m',
/* 0x03882 = "PX-503A [ME OFFICE 900WD Series/Stylus Office BX525WD]" */
    'P','X','-','5','0','3','A',' ','[','M','E',' ','O','F','F','I','C','E',' ','9','0','0','W','D',' ','S','e','r','i','e','s','/','\xb1','\xd3',' ','B','X','5','2','5','W','D',']',
/* 0x038ad = "ME OFFICE 650FN Series/Stylus Office BX310FN/TX520FN Series" */
    'M','E',' ','O','F','F','I','C','E',' ','6','5','0','F','N',' ','S','e','r','i','e','s','/','\xb1','\xd3',' ','B','X','3','1','0','F','N','/','T','X','5','2','0','F','N',' ','\xbf',
/* 0x038d8 = "3M pixel Microscope Camera (with capture button)" */
    '3','M',' ','p','i','x','e','l',' ','M','i','c','r','o','s','c','o','p','e',' ','\x04',' ','(','w','i','t','h',' ','c','a','p','t','u','r','e',' ','b','u','t','t','o','n',')',
/* 0x03903 = "OpenMoko Neo1973 u-boot cdc_acm serial port" */
    'O','p','e','n','M','o','k','o',' ','N','e','o','1','9','7','3',' ','u','-','b','o','o','t',' ','c','d','c','_','a','c','m',' ','s','e','r','i','a','l',' ','p','o','r','t',
/* 0x0392e = "SDR-H85 Camcorder (recorder mode - SD card)" */
    'S','D','R','-','H','8','5',' ','C','a','m','c','o','r','d','e','r',' ','(','r','e','c','o','r','d','e','r',' ','m','o','d','e',' ','-',' ','S','D',' ','c','a','r','d',')',
/* 0x03959 = "WUA-2340 RangeBooster G Adapter(rev.A) (no firmware) [Atheros AR5523]" */
    'W','U','A','-','2','3','4','0',' ','R','a','n','g','e','B','o','o','s','t','e','r',' ','G',' ','\xbb','A',')',' ','(','n','o',' ','\xdb',' ','[','\xaf','A','R','5','5','2','3',']',
/* 0x03984 = "F7D2101 802.11n Surf & Share Wireless Adapter v1000 [Realtek RTL8192SU]" */
    'F','7','D','2','1','0','1',' ','\x99','S','u','r','f',' ','&',' ','S','h','a','r','e',' ','\x01','\x02',' ','v','1','0','0','0',' ','[','\xbe','R','T','L','8','1','9','2','S','U',']',
/* 0x039af = "Digital camera, CD302N/Elta Medi@ digi-cam/HE-501A" */
    '\x09','c','a','m','e','r','a',',',' ','C','D','3','0','2','N','/','E','l','t','a',' ','M','e','d','i','@',' ','d','i','g','i','-','c','a','m','/','H','E','-','5','0','1','A',
/* 0x039da = "2M pixel Microscope Camera (with capture button)" */
    '2','M',' ','p','i','x','e','l',' ','M','i','c','r','o','s','c','o','p','e',' ','\x04',' ','(','w','i','t','h',' ','c','a','p','t','u','r','e',' ','b','u','t','t','o','n',')',
/* 0x03a05 = "E220 HSDPA Modem / E230/E270/E870 HSDPA/HSUPA Modem" */
    'E','2','2','0',' ','H','S','D','P','A',' ','\x1c',' ','/',' ','E','2','3','0','/','E','2','7','0','/','E','8','7','0',' ','H','S','D','P','A','/','H','S','U','P','A',' ','\x1c',
/* 0x03a30 = "ILCE-6000 (aka Alpha-6000) in charging mode" */
    'I','L','C','E','-','6','0','0','0',' ','(','a','k','a',' ','A','l','p','h','a','-','6','0','0','0',')',' ','i','n',' ','c','h','a','r','g','i','n','g',' ','m','o','d','e',
/* 0x03a5b = "DiscFerret Magnetic Disc Analyser (active mode)" */
    'D','i','s','c','F','e','r','r','e','t',' ','M','a','g','n','e','t','i','c',' ','D','i','s','c',' ','A','n','a','l','y','s','e','r',' ','(','a','c','t','i','v','e',' ','\x1a',
/* 0x03a86 = "WH1080 Weather Station / USB Missile Launcher" */
    'W','H','1','0','8','0',' ','W','e','a','t','h','e','r',' ','S','t','a','t','i','o','n',' ','/',' ','\x0a',' ','M','i','s','s','i','l','e',' ','L','a','u','n','c','h','e','r',
/* 0x03ab1 = "SBAC-US10 SxS PRO memory card reader/writer" */
    'S','B','A','C','-','U','S','1','0',' ','S','x','S',' ','P','R','O',' ','m','e','m','o','r','y',' ','c','a','r','d',' ','r','e','a','d','e','r','/','w','r','i','t','e','r',
/* 0x03adc = "CL1356A smartcard reader (DFU + CCID + HID)" */
    'C','L','1','3','5','6','A',' ','s','m','a','r','t','c','a','r','d',' ','r','e','a','d','e','r',' ','(','D','F','U',' ','+',' ','C','C','I','D',' ','+',' ','H','I','D',')',
/* 0x03b07 = "picp PIC16F145x based PIC16F145x programmer" */
    'p','i','c','p',' ','P','I','C','1','6','F','1','4','5','x',' ','b','a','s','e','d',' ','P','I','C','1','6','F','1','4','5','x',' ','p','r','o','g','r','a','m','m','e','r',
/* 0x03b32 = "Unicorn II (ST70138B + MTC-20174TQ chipset)" */
    'U','n','i','c','o','r','n',' ','I','I',' ','(','S','T','7','0','1','3','8','B',' ','+',' ','M','T','C','-','2','0','1','7','4','T','Q',' ','c','h','i','p','s','e','t',')',
/* 0x03b5d = "Scientific Atlanta WebSTAR 100 & 200 series Cable Modem" */
    'S','c','i','e','n','t','i','f','i','c',' ','A','t','l','a','n','t','a',' ','W','e','b','S','T','A','R',' ','1','0','0',' ','&',' ','2','0','0',' ','\x1d',' ','\xa5',' ','\x1c',
/* 0x03b87 = "NINGBO HENTEK DRAGON ELECTRONICS CO., LTD." */
    'N','I','N','G','B','O',' ','H','E','N','T','E','K',' ','D','R','A','G','O','N',' ','E','L','E','C','T','R','O','N','I','C','S',' ','C','O','.',',',' ','L','T','D','.',
/* 0x03bb1 = "SMC SMCWUSB-N 802.11bgn 2x2:2 Wireless Adapter [Ralink RT2870]" */
    'S','M','C',' ','S','M','C','W','U','S','B','-','N',' ','8','0','2','.','1','1','b','g','n',' ','2','x','2',':','2',' ','\x01','\x02',' ','[','\x93','R','T','2','8','7','0',']',
/* 0x03bdb = "Stylus CX4300/CX4400/CX5500/CX5600/DX4400/DX4450" */
    '\xb1','C','X','4','3','0','0','/','C','X','4','4','0','0','/','C','X','5','5','0','0','/','C','X','5','6','0','0','/','D','X','4','4','0','0','/','D','X','4','4','5','0',
/* 0x03c05 = "Sitecom bluetooth2.0 class 1 dongle CN-521" */
    'S','i','t','e','c','o','m',' ','b','l','u','e','t','o','o','t','h','2','.','0',' ','c','l','a','s','s',' ','1',' ','d','o','n','g','l','e',' ','C','N','-','5','2','1',
/* 0x03c2f = "USB2CAN Application for ColdFire DEMOJM board" */
    'U','S','B','2','C','A','N',' ','A','p','p','l','i','c','a','t','i','o','n',' ','\xcc','C','o','l','d','F','i','r','e',' ','D','E','M','O','J','M',' ','b','o','a','r','d',
/* 0x03c59 = "DTH-A1300 [Cintiq Companion Hybrid] tablet" */
    'D','T','H','-','A','1','3','0','0',' ','[','C','i','n','t','i','q',' ','C','o','m','p','a','n','i','o','n',' ','H','y','b','r','i','d',']',' ','t','a','b','l','e','t',
/* 0x03c83 = "Digitrex DSC-1300/DSC-2100 (mass storage mode)" */
    'D','i','g','i','t','r','e','x',' ','D','S','C','-','1','3','0','0','/','D','S','C','-','2','1','0','0',' ','(','m','a','s','s',' ','s','t','o','r','a','g','e',' ','\x1a',
/* 0x03cad = "F9L1109v1 802.11a/b/g/n/ac Wireless Adapter [Realtek RTL8812AU]" */
    'F','9','L','1','1','0','9','v','1',' ','8','0','2','.','1','1','a','/','b','/','g','/','n','/','a','c',' ','\x01','\x02',' ','[','\xbe','R','T','L','8','8','1','2','A','U',']',
/* 0x03cd7 = "Sitecom bluetooth2.0 class 2 dongle CN-520" */
    'S','i','t','e','c','o','m',' ','b','l','u','e','t','o','o','t','h','2','.','0',' ','c','l','a','s','s',' ','2',' ','d','o','n','g','l','e',' ','C','N','-','5','2','0',
/* 0x03d01 = "BCM2046B1 USB 2.0 Hub (part of BCM2046 Bluetooth)" */
    'B','C','M','2','0','4','6','B','1',' ','\x0a',' ','\xc1','\xa4',' ','(','p','a','r','t',' ','o','f',' ','B','C','M','2','0','4','6',' ','B','l','u','e','t','o','o','t','h',')',
/* 0x03d2b = "F7D1102 N150/Surf Micro Wireless Adapter v1000 [Realtek RTL8188CUS]" */
    'F','7','D','1','1','0','2',' ','N','1','5','0','/','S','u','r','f',' ','\xc4',' ','\x01','\x02',' ','v','1','0','0','0',' ','[','\xbe','R','T','L','8','1','8','8','C','U','S',']',
/* 0x03d55 = "DWA-160 802.11abgn Xtreme N Dual Band Adapter(rev.B2) [Ralink RT5572]" */
    'D','W','A','-','1','6','0',' ','\xea','X','t','r','e','m','e',' ','N',' ','D','u','a','l',' ','B','a','n','d',' ','\xbb','B','2',')',' ','[','\x93','R','T','5','5','7','2',']',
/* 0x03d7f = "IR receiver [VRC-1100 Vista MCE Remote Control]" */
    'I','R',' ','r','e','c','e','i','v','e','r',' ','[','V','R','C','-','1','1','0','0',' ','V','i','s','t','a',' ','M','C','E',' ','\xcb',' ','C','o','n','t','r','o','l',']',
/* 0x03da9 = "Metrologic MS7120 Barcode Scanner (IBM SurePOS mode)" */
    'M','e','t','r','o','l','o','g','i','c',' ','M','S','7','1','2','0',' ','B','a','r','c','o','d','e',' ','\x25',' ','(','I','B','M',' ','S','u','r','e','P','O','S',' ','\x1a',
/* 0x03dd3 = "KAOSSILATOR PRO Dynamic Phrase Synthesizer" */
    'K','A','O','S','S','I','L','A','T','O','R',' ','P','R','O',' ','D','y','n','a','m','i','c',' ','P','h','r','a','s','e',' ','S','y','n','t','h','e','s','i','z','e','r',
/* 0x03dfd = "Airlink101 AWLL6070 802.11bgn Wireless Adapter [Ralink RT2770]" */
    'A','i','r','l','i','n','k','1','0','1',' ','A','W','L','L','6','0','7','0',' ','8','0','2','.','1','1','b','g','n',' ','\x01','\x02',' ','[','\x93','R','T','2','7','7','0',']',
/* 0x03e27 = "Dacal CD/DVD Library D-101/DC-300/DC-016RW" */
    'D','a','c','a','l',' ','C','D','/','D','V','D',' ','L','i','b','r','a','r','y',' ','D','-','1','0','1','/','D','C','-','3','0','0','/','D','C','-','0','1','6','R','W',
/* 0x03e51 = "NWD6505 802.11a/b/g/n/ac Wireless Adapter [MediaTek MT7610U]" */
    'N','W','D','6','5','0','5',' ','8','0','2','.','1','1','a','/','b','/','g','/','n','/','a','c',' ','\x01','\x02',' ','[','\xa1','T','e','k',' ','M','T','7','6','1','0','U',']',
/* 0x03e7b = "Raisonance S.A. STM32 ARM evaluation board" */
    'R','a','i','s','o','n','a','n','c','e',' ','S','.','A','.',' ','S','T','M','3','2',' ','A','R','M',' ','e','v','a','l','u','a','t','i','o','n',' ','b','o','a','r','d',
/* 0x03ea5 = "mIDentity Basic/Classic (installationless)" */
    'm','I','D','e','n','t','i','t','y',' ','B','a','s','i','c','/','C','l','a','s','s','i','c',' ','(','i','n','s','t','a','l','l','a','t','i','o','n','l','e','s','s',')',
/* 0x03ecf = "MCPPro - Airliner Mode Control Panel (Autopilot)" */
    'M','C','P','P','r','o',' ','-',' ','A','i','r','l','i','n','e','r',' ','M','o','d','e',' ','\xc9',' ','P','a','n','e','l',' ','(','A','u','t','o','p','i','l','o','t',')',
/* 0x03ef9 = "FusionHDTV DVB-T (MT352+LgZ201) (initialized)" */
    'F','u','s','i','o','n','H','D','T','V',' ','\xa7','T',' ','(','M','T','3','5','2','+','L','g','Z','2','0','1',')',' ','(','i','n','i','t','i','a','l','i','z','e','d',')',
/* 0x03f23 = "Wireless 1450 Dual-band (802.11a/b/g) Adapter [Intersil ISL3887]" */
    '\x01','1','4','5','0',' ','D','u','a','l','-','b','a','n','d',' ','(','8','0','2','.','1','1','a','/','b','/','g',')',' ','\x02',' ','[','\xb0','I','S','L','3','8','8','7',']',
/* 0x03f4d = "Smart King PRO Uninterruptible Power Supply (HID PDC)" */
    '\x12',' ','K','i','n','g',' ','P','R','O',' ','U','n','i','n','t','e','r','r','u','p','t','i','b','l','e',' ','\x24',' ','S','u','p','p','l','y',' ','(','\xf2','P','D','C',')',
/* 0x03f77 = "On Networks N150MA 802.11bgn [Realtek RTL8188CUS]" */
    'O','n',' ','N','e','t','w','o','r','k','s',' ','N','1','5','0','M','A',' ','8','0','2','.','1','1','b','g','n',' ','[','\xbe','R','T','L','8','1','8','8','C','U','S',']',
/* 0x03fa1 = "Sitecom bluetooth2.0 class 2 dongle CN-512" */
    'S','i','t','e','c','o','m',' ','b','l','u','e','t','o','o','t','h','2','.','0',' ','c','l','a','s','s',' ','2',' ','d','o','n','g','l','e',' ','C','N','-','5','1','2',
/* 0x03fcb = "DWA-160 Xtreme N Dual Band USB Adapter(rev.B) [Ralink RT2870]" */
    'D','W','A','-','1','6','0',' ','X','t','r','e','m','e',' ','N',' ','D','u','a','l',' ','B','a','n','d',' ','\x0a',' ','\xbb','B',')',' ','[','\x93','R','T','2','8','7','0',']',
/* 0x03ff5 = "Airlink101 AWLL6080 802.11bgn Wireless Adapter [Ralink RT2870]" */
    'A','i','r','l','i','n','k','1','0','1',' ','A','W','L','L','6','0','8','0',' ','8','0','2','.','1','1','b','g','n',' ','\x01','\x02',' ','[','\x93','R','T','2','8','7','0',']',
/* 0x0401f = "CML Control, Measurement and Data Logging System" */
    'C','M','L',' ','C','o','n','t','r','o','l',',',' ','M','e','a','s','u','r','e','m','e','n','t',' ','\xe4','\xe7',' ','L','o','g','g','i','n','g',' ','S','y','s','t','e','m',
/* 0x04049 = "GreenPak Universal Dev Board (Active Mode)" */
    'G','r','e','e','n','P','a','k',' ','U','n','i','v','e','r','s','a','l',' ','D','e','v',' ','B','o','a','r','d',' ','(','A','c','t','i','v','e',' ','M','o','d','e',')',
/* 0x04073 = "Jabra PRO 9450, Type 9400BS (DECT Headset)" */
    'J','a','b','r','a',' ','P','R','O',' ','9','4','5','0',',',' ','T','y','p','e',' ','9','4','0','0','B','S',' ','(','D','E','C','T',' ','H','e','a','d','s','e','t',')',
/* 0x0409d = "AX88179 Gigabit Ethernet [ThinkPad OneLink GigaLAN]" */
    'A','X','8','8','1','7','9',' ','G','i','g','a','b','i','t',' ','\x7f',' ','[','T','h','i','n','k','\xfa',' ','O','n','e','L','i','n','k',' ','G','i','g','a','L','A','N',']',
/* 0x040c7 = "DWA-130 802.11n Wireless N Adapter(rev.A1) [Marvell 88W8362+88W8060]" */
    'D','W','A','-','1','3','0',' ','\x99','\x01','N',' ','\xbb','A','1',')',' ','[','M','a','r','v','e','l','l',' ','8','8','W','8','3','6','2','+','8','8','W','8','0','6','0',']',
/* 0x040f1 = "S08-245, urJtag compatible firmware for S08JS" */
    'S','0','8','-','2','4','5',',',' ','u','r','J','t','a','g',' ','c','o','m','p','a','t','i','b','l','e',' ','f','i','r','m','w','a','r','e',' ','\xcc','S','0','8','J','S',
/* 0x0411b = "TT-connect S-2400 DVB-S receiver (8kB EEPROM)" */
    'T','T','-','c','o','n','n','e','c','t',' ','S','-','2','4','0','0',' ','\xa7','S',' ','r','e','c','e','i','v','e','r',' ','(','8','k','B',' ','E','E','P','R','O','M',')',
/* 0x04145 = "mIDentity Basic/Classic (composite device)" */
    'm','I','D','e','n','t','i','t','y',' ','B','a','s','i','c','/','C','l','a','s','s','i','c',' ','(','c','o','m','p','o','s','i','t','e',' ','d','e','v','i','c','e',')',
/* 0x0416f = "Dream / ADP1 / G1 / Magic / Tattoo (Debug)" */
    'D','r','e','a','m',' ','/',' ','A','D','P','1',' ','/',' ','G','1',' ','/',' ','M','a','g','i','c',' ','/',' ','T','a','t','t','o','o',' ','(','D','e','b','u','g',')',
/* 0x04199 = "PowerShot SD800 IS / Digital IXUS 850 IS / IXY DIGITAL 900 IS" */
    '\x24','\x84','S','D','8','0','0',' ','I','S',' ','/',' ','\x09','\xfd','8','5','0',' ','I','S',' ','/',' ','I','X','Y',' ','D','I','G','I','T','A','L',' ','9','0','0',' ','I','S',
/* 0X041c3 = "Siemens S30863-S1016-R107-2 802.11g Wireless Adapter [Intersil ISL3887]" */
    'i','e','m','e','n','s',' ','S','3','0','8','6','3','-','S','1','0','1','6','-','R','1','0','7','-','2',' ','\x94','\x01','\x02',' ','[','\xb0','I','S','L','3','8','8','7',']',
/* 0x041ec = "F5U120-PC Dual PS/2 Ports / F5U118-UNV ADB Adapter" */
    'F','5','U','1','2','0','-','\x1f','D','u','a','l',' ','P','S','/','2',' ','P','o','r','t','s',' ','/',' ','F','5','U','1','1','8','-','U','N','V',' ','A','D','B',' ','\x02',
/* 0x04216 = "RF Sythesizer 250-4200MHz model SSG-4000LH" */
    'R','F',' ','S','y','t','h','e','s','i','z','e','r',' ','2','5','0','-','4','2','0','0','M','H','z',' ','m','o','d','e','l',' ','S','S','G','-','4','0','0','0','L','H',
/* 0x04240 = "WUG2400 802.11g Wireless Adapter [Texas Instruments TNETW1450]" */
    'W','U','G','2','4','0','0',' ','\x94','\x01','\x02',' ','[','T','e','x','a','s',' ','I','n','s','t','r','u','m','e','n','t','s',' ','T','N','E','T','W','1','4','5','0',']',
/* 0x04269 = "F9L1106v1 802.11a/b/g/n/ac Wireless Adapter [Broadcom BCM43526]" */
    'F','9','L','1','1','0','6','v','1',' ','8','0','2','.','1','1','a','/','b','/','g','/','n','/','a','c',' ','\x01','\x02',' ','[','\xeb','B','C','M','4','3','5','2','6',']',
/* 0x04292 = "Broadband (3G HSDPA) SM-Bus Minicard Diagnostics Port" */
    '\xb7','(','3','G',' ','H','S','D','P','A',')',' ','S','M','-','B','u','s',' ','M','i','n','i','c','a','r','d',' ','D','i','a','g','n','o','s','t','i','c','s',' ','\x87',
/* 0x042bb = "Jens of Sweden / I-BEAD 150M/150H MP3 player" */
    'J','e','n','s',' ','o','f',' ','S','w','e','d','e','n',' ','/',' ','I','-','B','E','A','D',' ','1','5','0','M','/','1','5','0','H',' ','\x8e','p','l','a','y','e','r',
/* 0x042e4 = "WN111(v2) RangeMax Next Wireless [Atheros AR9170+AR9101]" */
    'W','N','1','1','1','(','v','2',')',' ','R','a','n','g','e','M','a','x',' ','N','e','x','t',' ','\x01','[','\xaf','A','R','9','1','7','0','+','A','R','9','1','0','1',']',
/* 0x0430d = "Aiptek Mega PockerCam 1.3/Maxell MaxPocket LE 1.3" */
    'A','i','p','t','e','k',' ','M','e','g','a',' ','P','o','c','k','e','r','\x9a','1','.','3','/','M','a','x','e','l','l',' ','M','a','x','\x17',' ','L','E',' ','1','.','3',
/* 0x04336 = "Cheng Uei Precision Industry Co., Ltd (Foxlink)" */
    'C','h','e','n','g',' ','U','e','i',' ','P','r','e','c','i','s','i','o','n',' ','I','n','d','u','s','t','r','y',' ','\x0e','\x16',' ','(','F','o','x','l','i','n','k',')',
/* 0x0435f = "M-R0017 [G700s Rechargeable Gaming Mouse]" */
    'M','-','R','0','0','1','7',' ','[','G','7','0','0','s',' ','R','e','c','h','a','r','g','e','a','b','l','e',' ','G','a','m','i','n','g',' ','M','o','u','s','e',']',
/* 0x04388 = "Handy Steno/AH123 / Handy Steno 2.0/HT203" */
    'H','a','n','d','y',' ','S','t','e','n','o','/','A','H','1','2','3',' ','/',' ','H','a','n','d','y',' ','S','t','e','n','o',' ','2','.','0','/','H','T','2','0','3',
/* 0x043b1 = "Hercules HWNUp-150 802.11n Wireless N Pico [Realtek RTL8188CUS]" */
    'H','e','r','c','u','l','e','s',' ','H','W','N','U','p','-','1','5','0',' ','\x99','\x01','N',' ','P','i','c','o',' ','[','\xbe','R','T','L','8','1','8','8','C','U','S',']',
/* 0x043da = "Sound Blaster Tactic(3D) Sigma sound card" */
    'S','o','u','n','d',' ','B','l','a','s','t','e','r',' ','T','a','c','t','i','c','(','3','D',')',' ','S','i','g','m','a',' ','s','o','u','n','d',' ','c','a','r','d',
/* 0x04403 = "DTV-DVB UDST7020BDA DVB-S Box(DVBS for MCE2005)" */
    'D','T','V','-','D','V','B',' ','U','D','S','T','7','0','2','0','B','D','A',' ','\xa7','S',' ','B','o','x','(','D','V','B','S',' ','\xcc','M','C','E','2','0','0','5',')',
/* 0x0442c = "CTL-471 [Bamboo Splash, One by Wacom (S)]" */
    'C','T','L','-','4','7','1',' ','[','B','a','m','b','o','o',' ','S','p','l','a','s','h',',',' ','O','n','e',' ','b','y',' ','W','a','c','o','m',' ','(','S',')',']',
/* 0x04455 = "Neo1973/FreeRunner internal USB CSR4 module" */
    'N','e','o','1','9','7','3','/','F','r','e','e','R','u','n','n','e','r',' ','i','n','t','e','r','n','a','l',' ','\x0a',' ','C','S','R','4',' ','m','o','d','u','l','e',
/* 0x0447e = "UPort 1450I 4-Port RS-232/422/485 with Isolation" */
    'U','P','o','r','t',' ','1','4','5','0','I',' ','4','-','\x87',' ','R','S','-','2','3','2','/','4','2','2','/','4','8','5',' ','\x98','I','s','o','l','a','t','i','o','n',
/* 0x044a7 = "X-Keys Switch Interface, Programming Mode" */
    'X','-','K','e','y','s',' ','S','w','i','t','c','h',' ','I','n','t','e','r','f','a','c','e',',',' ','P','r','o','g','r','a','m','m','i','n','g',' ','M','o','d','e',
/* 0x044d0 = "X1110/X1130/X1140/X1150/X1170/X1180/X1185" */
    'X','1','1','1','0','/','X','1','1','3','0','/','X','1','1','4','0','/','X','1','1','5','0','/','X','1','1','7','0','/','X','1','1','8','0','/','X','1','1','8','5',
/* 0x044f9 = "GW Instek GSP-830 Spectrum Analyzer (HID)" */
    'G','W',' ','I','n','s','t','e','k',' ','G','S','P','-','8','3','0',' ','S','p','e','c','t','r','u','m',' ','A','n','a','l','y','z','e','r',' ','(','H','I','D',')',
/* 0x04522 = "Ci25m Notebook Optical Mouse [Diamond Eye Precision]" */
    'C','i','2','5','m',' ','N','o','t','e','b','o','o','k',' ','\x7b','\x0b',' ','[','D','i','a','m','o','n','d',' ','E','y','e',' ','P','r','e','c','i','s','i','o','n',']',
/* 0x0454b = "USB flash drive (32 GB SHARKOON Accelerate)" */
    '\x0a',' ','f','l','a','s','h',' ','d','r','i','v','e',' ','(','3','2',' ','G','B',' ','S','H','A','R','K','O','O','N',' ','A','c','c','e','l','e','r','a','t','e',')',
/* 0x04574 = "F6D4050 N150 Enhanced Wireless Network Adapter v2000 [Ralink RT3070]" */
    'F','6','D','4','0','5','0',' ','N','1','5','0',' ','E','n','h','a','n','c','e','d',' ','\x01','\x8d','\x02',' ','v','2','0','0','0',' ','[','\x93','R','T','3','0','7','0',']',
/* 0x0459d = "GT-I9100 / GT-C3350 Phones (USB Debugging mode)" */
    'G','T','-','I','9','1','0','0',' ','/',' ','G','T','-','C','3','3','5','0',' ','P','h','o','n','e','s',' ','(','\x0a',' ','D','e','b','u','g','g','i','n','g',' ','\x1a',
/* 0x045c6 = "Wireless 5700-Sprint Mobile Broadband (CDMA EV-DO) Mini-Card Status Port" */
    '\x01','5','7','0','0','-','S','p','r','i','n','t',' ','\x96',' ','\xb7','(','C','D','M','A',' ','E','V','-','D','O',')',' ','\xb9','-','\x15',' ','S','t','a','t','u','s',' ','\x87',
/* 0x045ef = "Linux-USB user-mode isochronous source/sink" */
    'L','i','n','u','x','-','\x0a',' ','u','s','e','r','-','m','o','d','e',' ','i','s','o','c','h','r','o','n','o','u','s',' ','s','o','u','r','c','e','/','s','i','n','k',
/* 0x04618 = "F6D4050 N150 Enhanced Wireless Network Adapter v1000 [Ralink RT3070]" */
    'F','6','D','4','0','5','0',' ','N','1','5','0',' ','E','n','h','a','n','c','e','d',' ','\x01','\x8d','\x02',' ','v','1','0','0','0',' ','[','\x93','R','T','3','0','7','0',']',
/* 0x04641 = "Dino-Lite Digital Microscope (SN9C120 + HV7131R)" */
    'D','i','n','o','-','L','i','t','e',' ','\x09','M','i','c','r','o','s','c','o','p','e',' ','(','S','N','9','C','1','2','0',' ','+',' ','H','V','7','1','3','1','R',')',
/* 0x0466a = "The Hong Kong Standards and Testing Centre Ltd." */
    'T','h','e',' ','H','o','n','g',' ','K','o','n','g',' ','S','t','a','n','d','a','r','d','s',' ','\xe4','T','e','s','t','i','n','g',' ','C','e','n','t','r','e',' ','\xab',
/* 0x04693 = "K018: USB-MSR JIS 2-Track MSR: POS Standard" */
    'K','0','1','8',':',' ','\x0a','-','M','S','R',' ','J','I','S',' ','2','-','T','r','a','c','k',' ','M','S','R',':',' ','P','O','S',' ','S','t','a','n','d','a','r','d',
/* 0x046bc = "AE6000 802.11a/b/g/n/ac Wireless Adapter [MediaTek MT7610U]" */
    'A','E','6','0','0','0',' ','8','0','2','.','1','1','a','/','b','/','g','/','n','/','a','c',' ','\x01','\x02',' ','[','\xa1','T','e','k',' ','M','T','7','6','1','0','U',']',
/* 0x046e5 = "Vigor530 IEEE 802.11G Adapter (ISL3880+NET2280)" */
    'V','i','g','o','r','5','3','0',' ','I','E','E','E',' ','8','0','2','.','1','1','G',' ','\x02',' ','(','I','S','L','3','8','8','0','+','N','E','T','2','2','8','0',')',
/* 0x0470e = "Analog Devices Canada, Ltd (Allied Telesyn)" */
    'A','n','a','l','o','g',' ','D','e','v','i','c','e','s',' ','C','a','n','a','d','a',',',' ','\x16',' ','(','A','l','l','i','e','d',' ','T','e','l','e','s','y','n',')',
/* 0x04737 = "WUSB6300 802.11a/b/g/n/ac Wireless Adapter [Realtek RTL8812AU]" */
    'W','U','S','B','6','3','0','0',' ','8','0','2','.','1','1','a','/','b','/','g','/','n','/','a','c',' ','\x01','\x02',' ','[','\xbe','R','T','L','8','8','1','2','A','U',']',
/* 0x04760 = "SpeedLink Snappy Mic webcam (SL-6825-SBK)" */
    'S','p','e','e','d','L','i','n','k',' ','S','n','a','p','p','y',' ','M','i','c',' ','w','e','b','c','a','m',' ','(','S','L','-','6','8','2','5','-','S','B','K',')',
/* 0x04789 = "OpenRISC Ordb2a-ep4ce22 development board" */
    'O','p','e','n','R','I','S','C',' ','O','r','d','b','2','a','-','e','p','4','c','e','2','2',' ','d','e','v','e','l','o','p','m','e','n','t',' ','b','o','a','r','d',
/* 0x047b2 = "ASUS Zenfone GO (ZB500KL) (Debug, RNDIS mode)" */
    'A','S','U','S',' ','Z','e','n','f','o','n','e',' ','G','O',' ','(','Z','B','5','0','0','K','L',')',' ','(','D','e','b','u','g',',',' ','R','N','D','I','S',' ','\x1a',
/* 0x047db = "Escape Composite driver for Android Phones: Modem+Diagnostic+ADB" */
    'E','s','c','a','p','e',' ','\x60','d','r','i','v','e','r',' ','\xcc','\xce','P','h','o','n','e','s',':',' ','\x1c','+','D','i','a','g','n','o','s','t','i','c','+','A','D','B',
/* 0x04804 = "JM20337 Hi-Speed USB to SATA & PATA Combo Bridge" */
    'J','M','2','0','3','3','7',' ','H','i','-','S','p','e','e','d',' ','\x0a',' ','t','o',' ','S','A','T','A',' ','&',' ','P','A','T','A',' ','C','o','m','b','o',' ','\x9f',
/* 0x0482d = "Phidgets, Inc., 1-Motor PhidgetServo v2.0" */
    'P','h','i','d','g','e','t','s',',',' ','I','n','c','.',',',' ','1','-','M','o','t','o','r',' ','P','h','i','d','g','e','t','S','e','r','v','o',' ','v','2','.','0',
/* 0x04856 = "GreenPak Universal Dev Board (Reset Mode)" */
    'G','r','e','e','n','P','a','k',' ','U','n','i','v','e','r','s','a','l',' ','D','e','v',' ','B','o','a','r','d',' ','(','R','e','s','e','t',' ','M','o','d','e',')',
/* 0x0487f = "Phidgets, Inc., 4-Motor PhidgetServo v2.0" */
    'P','h','i','d','g','e','t','s',',',' ','I','n','c','.',',',' ','4','-','M','o','t','o','r',' ','P','h','i','d','g','e','t','S','e','r','v','o',' ','v','2','.','0',
/* 0x048a8 = "Keyboardio Keyboardio Model 01 Bootloader" */
    'K','e','y','b','o','a','r','d','i','o',' ','K','e','y','b','o','a','r','d','i','o',' ','M','o','d','e','l',' ','0','1',' ','B','o','o','t','l','o','a','d','e','r',
/* 0x048d1 = "Cyberpix S-210S / Little Tikes My Real Digital Camera" */
    'C','y','b','e','r','p','i','x',' ','S','-','2','1','0','S',' ','/',' ','L','i','t','t','l','e',' ','T','i','k','e','s',' ','M','y',' ','R','e','a','l',' ','\x09','\x04',
/* 0x048fa = "Primascan Colorado 2600u/Visioneer 4400 Scanner" */
    'P','r','i','m','a','s','c','a','n',' ','C','o','l','o','r','a','d','o',' ','2','6','0','0','u','/','V','i','s','i','o','n','e','e','r',' ','4','4','0','0',' ','\x25',
/* 0x04923 = "Dino-Lite Digital Microscope (SN9C201 + HV7131R)" */
    'D','i','n','o','-','L','i','t','e',' ','\x09','M','i','c','r','o','s','c','o','p','e',' ','(','S','N','9','C','2','0','1',' ','+',' ','H','V','7','1','3','1','R',')',
/* 0x0494c = "On Networks N300MA 802.11bgn [Realtek RTL8192CU]" */
    'O','n',' ','N','e','t','w','o','r','k','s',' ','N','3','0','0','M','A',' ','8','0','2','.','1','1','b','g','n',' ','[','\xbe','R','T','L','8','1','9','2','C','U',']',
/* 0x04975 = "OpenPICC 13.56MHz RFID Simulator (native)" */
    'O','p','e','n','P','I','C','C',' ','1','3','.','5','6','M','H','z',' ','R','F','I','D',' ','S','i','m','u','l','a','t','o','r',' ','(','n','a','t','i','v','e',')',
/* 0x0499e = "UPort 1250I 2-Port RS-232/422/485 with Isolation" */
    'U','P','o','r','t',' ','1','2','5','0','I',' ','2','-','\x87',' ','R','S','-','2','3','2','/','4','2','2','/','4','8','5',' ','\x98','I','s','o','l','a','t','i','o','n',
/* 0x049c7 = "DTV-DVB UDTT7049 - DVB-T Driver(Without HID)" */
    'D','T','V','-','D','V','B',' ','U','D','T','T','7','0','4','9',' ','-',' ','\xa7','T',' ','D','r','i','v','e','r','(','W','i','t','h','o','u','t',' ','H','I','D',')',
/* 0x049f0 = "Qualcomm Flarion Technologies, Inc. / Leadtek Research, Inc." */
    'Q','u','a','l','c','o','m','m',' ','F','l','a','r','i','o','n',' ','\x89','\x07',' ','/',' ','L','e','a','d','t','e','k',' ','R','e','s','e','a','r','c','h',',',' ','\x07',
/* 0x04a19 = "DTV-DVB UDTT704D - DVBT/NTSC/PAL Driver (PCM4)" */
    'D','T','V','-','D','V','B',' ','U','D','T','T','7','0','4','D',' ','-',' ','D','V','B','T','/','N','T','S','C','/','P','A','L',' ','\xde',' ','(','P','C','M','4',')',
/* 0x04a42 = "MT9234ZBA-USB-CDC-ACM-XR MultiModem ZBA CDC-ACM-XR" */
    'M','T','9','2','3','4','Z','B','A','-','\x0a','-','C','D','C','-','A','C','M','-','X','R',' ','\xd6','\x1c',' ','Z','B','A',' ','C','D','C','-','A','C','M','-','X','R',
/* 0x04a6a = "DTH-2200 [Cintiq 22HD Touch] touchscreen" */
    'D','T','H','-','2','2','0','0',' ','[','C','i','n','t','i','q',' ','2','2','H','D',' ','T','o','u','c','h',']',' ','t','o','u','c','h','s','c','r','e','e','n',
/* 0x04a92 = "Minolta Dimage Scan Elite II AF-2920 (2888)" */
    'M','i','n','o','l','t','a',' ','D','i','m','a','g','e',' ','\x8a',' ','E','l','i','t','e',' ','I','I',' ','A','F','-','2','9','2','0',' ','(','2','8','8','8',')',
/* 0x04aba = "Free shared USB VID/PID pair for MIDI devices" */
    'F','r','e','e',' ','s','h','a','r','e','d',' ','\x0a',' ','V','I','D','/','P','I','D',' ','p','a','i','r',' ','\xcc','M','I','D','I',' ','d','e','v','i','c','e','s',
/* 0x04ae2 = "Vodafone VDA GPS / Toschiba Protege G710" */
    'V','o','d','a','f','o','n','e',' ','V','D','A',' ','G','P','S',' ','/',' ','T','o','s','c','h','i','b','a',' ','P','r','o','t','e','g','e',' ','G','7','1','0',
/* 0x04b0a = "External Hard Drive HD-PF32OU2 [Buffalo Ministation]" */
    '\xe3','H','a','r','d',' ','\x14',' ','H','D','-','P','F','3','2','O','U','2',' ','[','B','u','f','f','a','l','o',' ','M','i','n','i','s','t','a','t','i','o','n',']',
/* 0x04b32 = "ShipModul MiniPlex-4xUSB-AIS NMEA Multiplexer" */
    'S','h','i','p','M','o','d','u','l',' ','\xb9','P','l','e','x','-','4','x','\x0a','-','A','I','S',' ','N','M','E','A',' ','M','u','l','t','i','p','l','e','x','e','r',
/* 0x04b5a = "Xbox360 Wireless N Networking Adapter [Atheros AR7010+AR9280]" */
    'X','b','o','x','3','6','0',' ','\x01','N',' ','N','e','t','w','o','r','k','i','n','g',' ','\x02',' ','[','\xaf','A','R','7','0','1','0','+','A','R','9','2','8','0',']',
/* 0x04b82 = "TEW-648UBM 802.11n 150Mbps Micro Wireless N Adapter [Realtek RTL8188CUS]" */
    'T','E','W','-','6','4','8','U','B','M',' ','\x99','1','5','0','M','b','p','s',' ','\xc4',' ','\x01','N',' ','\x02',' ','[','\xbe','R','T','L','8','1','8','8','C','U','S',']',
/* 0x04baa = "Pole Display (SPC505-3415 2 x 20 Line Display)" */
    'P','o','l','e',' ','\xcf',' ','(','S','P','C','5','0','5','-','3','4','1','5',' ','2',' ','x',' ','2','0',' ','L','i','n','e',' ','D','i','s','p','l','a','y',')',
/* 0x04bd2 = "TimVideos\' HDMI2USB (FX2) - Unconfigured device" */
    'T','i','m','V','i','d','e','o','s','\'',' ','H','D','M','I','2','\x0a',' ','(','F','X','2',')',' ','-',' ','U','n','c','o','n','f','i','g','u','r','e','d',' ','\xf9',
/* 0x04bfa = "Wireless 5700-Telus Mobile Broadband (CDMA EV-DO) Mini-Card Status Port" */
    '\x01','5','7','0','0','-','T','e','l','u','s',' ','\x96',' ','\xb7','(','C','D','M','A',' ','E','V','-','D','O',')',' ','\xb9','-','\x15',' ','S','t','a','t','u','s',' ','\x87',
/* 0x04c22 = "Siemens S30853-S1016-R107 802.11g Wireless Adapter [Intersil ISL3886]" */
    'S','i','e','m','e','n','s',' ','S','3','0','8','5','3','-','S','1','0','1','6','-','R','1','0','7',' ','\x94','\x01','\x02',' ','[','\xb0','I','S','L','3','8','8','6',']',
/* 0x04c4a = "Wireless 5510 Mobile Broadband (3G HSDPA) Expresscard Status Port" */
    '\x01','5','5','1','0',' ','\x96',' ','\xb7','(','3','G',' ','H','S','D','P','A',')',' ','E','x','p','r','e','s','s','c','a','r','d',' ','S','t','a','t','u','s',' ','\x87',
/* 0x04c72 = "GSM modem [Medion Surfstick Model:S4222]" */
    'G','S','M',' ','m','o','d','e','m',' ','[','M','e','d','i','o','n',' ','S','u','r','f','s','t','i','c','k',' ','M','o','d','e','l',':','S','4','2','2','2',']',
/* 0x04c9a = "Numato Opsis HDMI2USB board (unconfigured)" */
    'N','u','m','a','t','o',' ','O','p','s','i','s',' ','H','D','M','I','2','\x0a',' ','b','o','a','r','d',' ','(','u','n','c','o','n','f','i','g','u','r','e','d',')',
/* 0x04cc2 = "Pole Display (SPC522-3415 2 x 20 Line Display)" */
    'P','o','l','e',' ','\xcf',' ','(','S','P','C','5','2','2','-','3','4','1','5',' ','2',' ','x',' ','2','0',' ','L','i','n','e',' ','D','i','s','p','l','a','y',')',
/* 0x04cea = "Minolta Dimage Scan Dual II AF-2820U (2886)" */
    'M','i','n','o','l','t','a',' ','D','i','m','a','g','e',' ','\x8a',' ','D','u','a','l',' ','I','I',' ','A','F','-','2','8','2','0','U',' ','(','2','8','8','6',')',
/* 0x04d12 = "DrayTek Vigor N61 802.11bgn Wireless Adapter [Ralink RT2870]" */
    'D','r','a','y','T','e','k',' ','V','i','g','o','r',' ','N','6','1',' ','8','0','2','.','1','1','b','g','n',' ','\x01','\x02',' ','[','\x93','R','T','2','8','7','0',']',
/* 0x04d3a = "HackRF Jawbreaker Software-Defined Radio" */
    'H','a','c','k','R','F',' ','J','a','w','b','r','e','a','k','e','r',' ','S','o','f','t','w','a','r','e','-','D','e','f','i','n','e','d',' ','R','a','d','i','o',
/* 0x04d62 = "EP-901A/EP-901F [Artisan 800/Stylus Photo PX800FW]" */
    'E','P','-','9','0','1','A','/','E','P','-','9','0','1','F',' ','[','A','r','t','i','s','a','n',' ','8','0','0','/','\xb1','\x86',' ','P','X','8','0','0','F','W',']',
/* 0x04d8a = "Pole Display (PC322-3415  2 x 20 Line Display)" */
    'P','o','l','e',' ','\xcf',' ','(','P','C','3','2','2','-','3','4','1','5',' ',' ','2',' ','x',' ','2','0',' ','L','i','n','e',' ','D','i','s','p','l','a','y',')',
/* 0x04db2 = "cardio NFC/RFID card reader (bootloader)" */
    'c','a','r','d','i','o',' ','N','F','C','/','R','F','I','D',' ','c','a','r','d',' ','r','e','a','d','e','r',' ','(','b','o','o','t','l','o','a','d','e','r',')',
/* 0x04dda = "Pole Display (SP324-4415  4 x 20 Line Display)" */
    'P','o','l','e',' ','\xcf',' ','(','S','P','3','2','4','-','4','4','1','5',' ',' ','4',' ','x',' ','2','0',' ','L','i','n','e',' ','D','i','s','p','l','a','y',')',
/* 0x04e02 = "Vanguard Uninterruptible Power Supply (HID PDC)" */
    'V','a','n','g','u','a','r','d',' ','U','n','i','n','t','e','r','r','u','p','t','i','b','l','e',' ','\x24',' ','S','u','p','p','l','y',' ','(','\xf2','P','D','C',')',
/* 0x04e2a = "USBtrng hardware random number generator" */
    'U','S','B','t','r','n','g',' ','h','a','r','d','w','a','r','e',' ','r','a','n','d','o','m',' ','n','u','m','b','e','r',' ','g','e','n','e','r','a','t','o','r',
/* 0x04e52 = "Trust 735S POWERC@M ZOOM, WDM DSC Bulk Driver" */
    'T','r','u','s','t',' ','7','3','5','S',' ','P','O','W','E','R','C','@','M',' ','Z','O','O','M',',',' ','W','D','M',' ','D','S','C',' ','B','u','l','k',' ','\xde',
/* 0x04e7a = "HCP HIT GSM/GPRS modem [Cinterion MC55i]" */
    'H','C','P',' ','H','I','T',' ','G','S','M','/','G','P','R','S',' ','m','o','d','e','m',' ','[','C','i','n','t','e','r','i','o','n',' ','M','C','5','5','i',']',
/* 0x04ea2 = "saa7114H video input card (Instant VideoMPX)" */
    's','a','a','7','1','1','4','H',' ','v','i','d','e','o',' ','i','n','p','u','t',' ','c','a','r','d',' ','(','I','n','s','t','a','n','t',' ','\xa3','M','P','X',')',
/* 0x04eca = "Wireless 5720 VZW Mobile Broadband (EVDO Rev-A) Minicard GPS Port" */
    '\x01','5','7','2','0',' ','V','Z','W',' ','\x96',' ','\xb7','(','E','V','D','O',' ','R','e','v','-','A',')',' ','M','i','n','i','c','a','r','d',' ','G','P','S',' ','\x87',
/* 0x04ef2 = "WNA3100M(v1) Wireless-N 300 [Realtek RTL8192CU]" */
    'W','N','A','3','1','0','0','M','(','v','1',')',' ','W','i','r','e','l','e','s','s','-','N',' ','3','0','0',' ','[','\xbe','R','T','L','8','1','9','2','C','U',']',
/* 0x04f1a = "TEW-509UB A1 802.11abg Wireless Adapter [ZyDAS ZD1211]" */
    'T','E','W','-','5','0','9','U','B',' ','A','1',' ','8','0','2','.','1','1','a','b','g',' ','\x01','\x02',' ','[','Z','y','D','A','S',' ','Z','D','1','2','1','1',']',
/* 0x04f42 = "NetVolante RTW65i Broadband&ISDN Wireless Router" */
    'N','e','t','V','o','l','a','n','t','e',' ','R','T','W','6','5','i',' ','B','r','o','a','d','b','a','n','d','&','I','S','D','N',' ','\x01','R','o','u','t','e','r',
/* 0x04f6a = "Powershot SD4500 IS / IXUS 1000 HS / IXY 50S" */
    'P','o','w','e','r','s','h','o','t',' ','S','D','4','5','0','0',' ','I','S',' ','/',' ','\xfd','1','0','0','0',' ','H','S',' ','/',' ','I','X','Y',' ','5','0','S',
/* 0x04f92 = "TRENDnet TEW-224UB 802.11b Wireless Adapter [Atmel AT76C503A]" */
    'T','R','E','N','D','n','e','t',' ','T','E','W','-','2','2','4','U','B',' ','\x9b','\x01','\x02',' ','[','A','t','m','e','l',' ','A','T','7','6','C','5','0','3','A',']',
/* 0x04fba = "Zoran Co. Personal Media Division (Nogatech)" */
    'Z','o','r','a','n',' ','C','o','.',' ','P','e','r','s','o','n','a','l',' ','\xa1',' ','D','i','v','i','s','i','o','n',' ','(','N','o','g','a','t','e','c','h',')',
/* 0x04fe2 = "AVR JTAGICE3 (v3.x) Debugger and Programmer" */
    'A','V','R',' ','J','T','A','G','I','C','E','3',' ','(','v','3','.','x',')',' ','D','e','b','u','g','g','e','r',' ','\xe4','P','r','o','g','r','a','m','m','e','r',
/* 0x0500a = "Xbox One Controller (Covert Forces/Firmware 2015)" */
    'X','b','o','x',' ','O','n','e',' ','\x13',' ','(','C','o','v','e','r','t',' ','F','o','r','c','e','s','/','F','i','r','m','w','a','r','e',' ','2','0','1','5',')',
/* 0x05032 = "Prodikeys PC-MIDI multifunction keyboard" */
    'P','r','o','d','i','k','e','y','s',' ','P','C','-','M','I','D','I',' ','m','u','l','t','i','f','u','n','c','t','i','o','n',' ','k','e','y','b','o','a','r','d',
/* 0x0505a = "Serial Converter 422/485 [Vardaan VEUSB422R3]" */
    '\x90',' ','C','o','n','v','e','r','t','e','r',' ','4','2','2','/','4','8','5',' ','[','V','a','r','d','a','a','n',' ','V','E','U','S','B','4','2','2','R','3',']',
/* 0x05082 = "Pole Display (P330-3415   2 x 20 Line Display)" */
    'P','o','l','e',' ','\xcf',' ','(','P','3','3','0','-','3','4','1','5',' ',' ',' ','2',' ','x',' ','2','0',' ','L','i','n','e',' ','D','i','s','p','l','a','y',')',
/* 0x050aa = "Dong Guan Humen Wonderful Wire Cable Factory" */
    'D','o','n','g',' ','G','u','a','n',' ','H','u','m','e','n',' ','W','o','n','d','e','r','f','u','l',' ','W','i','r','e',' ','\xa5',' ','F','a','c','t','o','r','y',
/* 0x050d2 = "Pole Display (PC305-3415  2 x 20 Line Display)" */
    'P','o','l','e',' ','\xcf',' ','(','P','C','3','0','5','-','3','4','1','5',' ',' ','2',' ','x',' ','2','0',' ','L','i','n','e',' ','D','i','s','p','l','a','y',')',
/* 0x050fa = "GT-I9100 Phone [Galaxy S II] (mass storage mode)" */
    'G','T','-','I','9','1','0','0',' ','\x19',' ','[','G','a','l','a','x','y',' ','S',' ','I','I',']',' ','(','m','a','s','s',' ','s','t','o','r','a','g','e',' ','\x1a',
/* 0x05122 = "DeTeWe - Deutsche Telephonwerke AG & Co." */
    'D','e','T','e','W','e',' ','-',' ','D','e','u','t','s','c','h','e',' ','T','e','l','e','p','h','o','n','w','e','r','k','e',' ','A','G',' ','&',' ','C','o','.',
/* 0x0514a = "Imperial Uninterruptible Power Supply (HID PDC)" */
    'I','m','p','e','r','i','a','l',' ','U','n','i','n','t','e','r','r','u','p','t','i','b','l','e',' ','\x24',' ','S','u','p','p','l','y',' ','(','\xf2','P','D','C',')',
/* 0x05172 = "Toshiba Information & Industrial Sys. And Services" */
    'T','o','s','h','i','b','a',' ','I','n','f','o','r','m','a','t','i','o','n',' ','&',' ','\xef','S','y','s','.',' ','A','n','d',' ','S','e','r','v','i','c','e','s',
/* 0x0519a = "DTH-2400 [Cintiq 24HD touch] touchscreen" */
    'D','T','H','-','2','4','0','0',' ','[','C','i','n','t','i','q',' ','2','4','H','D',' ','t','o','u','c','h',']',' ','t','o','u','c','h','s','c','r','e','e','n',
/* 0x051c2 = "Philips & Lite-ON Digital Solutions Corporation" */
    'P','h','i','l','i','p','s',' ','&',' ','L','i','t','e','-','O','N',' ','\x09','S','o','l','u','t','i','o','n','s',' ','C','o','r','p','o','r','a','t','i','o','n',
/* 0x051ea = "Pole Display (SP324-3415  4 x 20 Line Display)" */
    'P','o','l','e',' ','\xcf',' ','(','S','P','3','2','4','-','3','4','1','5',' ',' ','4',' ','x',' ','2','0',' ','L','i','n','e',' ','D','i','s','p','l','a','y',')',
/* 0x05212 = "AirLive WN-200USB wireless 11b/g/n dongle" */
    'A','i','r','L','i','v','e',' ','W','N','-','2','0','0','\x0a',' ','w','i','r','e','l','e','s','s',' ','1','1','b','/','g','/','n',' ','d','o','n','g','l','e',
/* 0x05239 = "A-Max Technology Macao Commercial Offshore Co. Ltd." */
    'A','-','M','a','x',' ','\x0d',' ','M','a','c','a','o',' ','C','o','m','m','e','r','c','i','a','l',' ','O','f','f','s','h','o','r','e',' ','C','o','.',' ','\xab',
/* 0x05260 = "MMT-7305WW [Medtronic Minimed CareLink]" */
    'M','M','T','-','7','3','0','5','W','W',' ','[','M','e','d','t','r','o','n','i','c',' ','M','i','n','i','m','e','d',' ','C','a','r','e','L','i','n','k',']',
/* 0x05287 = "Siemens S30853-S1038-R351 802.11g Wireless Adapter [Atheros AR5523]" */
    'S','i','e','m','e','n','s',' ','S','3','0','8','5','3','-','S','1','0','3','8','-','R','3','5','1',' ','\x94','\x01','\x02',' ','[','\xaf','A','R','5','5','2','3',']',
/* 0x052ae = "ASUS Zenfone GO (ZB500KL) (Debug, PTP mode)" */
    'A','S','U','S',' ','Z','e','n','f','o','n','e',' ','G','O',' ','(','Z','B','5','0','0','K','L',')',' ','(','D','e','b','u','g',',',' ','P','T','P',' ','\x1a',
/* 0x052d5 = "GW-USMicroN2W 802.11bgn Wireless Adapter [Realtek RTL8188SU]" */
    'G','W','-','U','S','M','i','c','r','o','N','2','W',' ','8','0','2','.','1','1','b','g','n',' ','\x01','\x02',' ','[','\xbe','R','T','L','8','1','8','8','S','U',']',
/* 0x052fc = "GT-8700/GT-8700F [Perfection 1640SU/1640SU PHOTO]" */
    'G','T','-','8','7','0','0','/','G','T','-','8','7','0','0','F',' ','[','\xf0','1','6','4','0','S','U','/','1','6','4','0','S','U',' ','P','H','O','T','O',']',
/* 0x05323 = "Subminiature 5Mpix B/W Camera, MU9PM-MH" */
    'S','u','b','m','i','n','i','a','t','u','r','e',' ','5','M','p','i','x',' ','B','/','W',' ','C','a','m','e','r','a',',',' ','M','U','9','P','M','-','M','H',
/* 0x0534a = "Licensed by Sony Computer Entertainment America" */
    'L','i','c','e','n','s','e','d',' ','b','y',' ','S','o','n','y',' ','\xcd','E','n','t','e','r','t','a','i','n','m','e','n','t',' ','A','m','e','r','i','c','a',
/* 0x05371 = "Siemens S30853-S1031-R351 802.11g Wireless Adapter [Atheros AR5523]" */
    'S','i','e','m','e','n','s',' ','S','3','0','8','5','3','-','S','1','0','3','1','-','R','3','5','1',' ','\x94','\x01','\x02',' ','[','\xaf','A','R','5','5','2','3',']',
/* 0x05398 = "NLV-1001 (serial mode) / OPN-2001 [Opticon]" */
    'N','L','V','-','1','0','0','1',' ','(','s','e','r','i','a','l',' ','\x1a',' ','/',' ','O','P','N','-','2','0','0','1',' ','[','O','p','t','i','c','o','n',']',
/* 0x053bf = "Opticon OPR-2001 / NLV-1001 (keyboard mode)" */
    'O','p','t','i','c','o','n',' ','O','P','R','-','2','0','0','1',' ','/',' ','N','L','V','-','1','0','0','1',' ','(','k','e','y','b','o','a','r','d',' ','\x1a',
/* 0x053e6 = "NetVolante RTA54i Broadband&ISDN Router" */
    'N','e','t','V','o','l','a','n','t','e',' ','R','T','A','5','4','i',' ','B','r','o','a','d','b','a','n','d','&','I','S','D','N',' ','R','o','u','t','e','r',
/* 0x0540d = "LW154 802.11bgn (1x1:1) Wireless Adapter [Realtek RTL8188SU]" */
    'L','W','1','5','4',' ','8','0','2','.','1','1','b','g','n',' ','(','1','x','1',':','1',')',' ','\x01','\x02',' ','[','\xbe','R','T','L','8','1','8','8','S','U',']',
/* 0x05434 = "Powershot SD4000 IS / IXUS 300 HS / IXY 30S" */
    'P','o','w','e','r','s','h','o','t',' ','S','D','4','0','0','0',' ','I','S',' ','/',' ','\xfd','3','0','0',' ','H','S',' ','/',' ','I','X','Y',' ','3','0','S',
/* 0X0545b = "SMCWUSBS-N EZ Connect N Draft 11n Wireless Adapter [Ralink RT2870]" */
    'M','C','W','U','S','B','S','-','N',' ','E','Z',' ','\xee','N',' ','D','r','a','f','t',' ','1','1','n',' ','\x01','\x02',' ','[','\x93','R','T','2','8','7','0',']',
/* 0x05481 = "SMC2662W (v1) EZ Connect 802.11b Wireless Adapter [Atmel AT76C503A]" */
    'S','M','C','2','6','6','2','W',' ','(','v','1',')',' ','E','Z',' ','\xee','\x9b','\x01','\x02',' ','[','A','t','m','e','l',' ','A','T','7','6','C','5','0','3','A',']',
/* 0x054a8 = "109 Japanese Keyboard with One-touch start buttons" */
    '1','0','9',' ','J','a','p','a','n','e','s','e',' ','\x05',' ','\x98','O','n','e','-','t','o','u','c','h',' ','s','t','a','r','t',' ','b','u','t','t','o','n','s',
/* 0x054cf = "Connect2Air E-5400 D1700 802.11g Wireless Adapter [Intersil ISL3887]" */
    'C','o','n','n','e','c','t','2','A','i','r',' ','E','-','5','4','0','0',' ','D','1','7','0','0',' ','\x94','\x01','\x02',' ','[','\xb0','I','S','L','3','8','8','7',']',
/* 0x054f6 = "Transformer Pad Infinity TF700 (Fastboot)" */
    'T','r','a','n','s','f','o','r','m','e','r',' ','\xfa',' ','I','n','f','i','n','i','t','y',' ','T','F','7','0','0',' ','(','F','a','s','t','b','o','o','t',')',
/* 0x0551d = "AirPCAP Classic 802.11 packet capture adapter" */
    'A','i','r','P','C','A','P',' ','C','l','a','s','s','i','c',' ','8','0','2','.','1','1',' ','p','a','c','k','e','t',' ','c','a','p','t','u','r','e',' ','\xd0',
/* 0x05544 = "C8051F34x Extender & EDID MGR [EMX-DVI]" */
    'C','8','0','5','1','F','3','4','x',' ','E','x','t','e','n','d','e','r',' ','&',' ','E','D','I','D',' ','M','G','R',' ','[','E','M','X','-','D','V','I',']',
/* 0x0556b = "Nam Tai E&E Products Ltd. or OmniVision Technologies, Inc." */
    'N','a','m',' ','T','a','i',' ','E','&','E',' ','P','r','o','d','u','c','t','s',' ','\xab',' ','o','r',' ','O','m','n','i','V','i','s','i','o','n',' ','\x89','\x07',
/* 0x05592 = "WNA1000 Wireless-N 150 [Atheros AR9170+AR9101]" */
    'W','N','A','1','0','0','0',' ','W','i','r','e','l','e','s','s','-','N',' ','1','5','0',' ','[','\xaf','A','R','9','1','7','0','+','A','R','9','1','0','1',']',
/* 0x055b9 = "Hong Ji Electric Wire & Cable (Dongguan) Co., Ltd" */
    'H','o','n','g',' ','J','i',' ','E','l','e','c','t','r','i','c',' ','W','i','r','e',' ','&',' ','\xa5',' ','(','D','o','n','g','g','u','a','n',')',' ','\x0e','\x16',
/* 0x055e0 = "Linksys WUSB11 v2.8 802.11b Adapter [Atmel AT76C505]" */
    'L','i','n','k','s','y','s',' ','W','U','S','B','1','1',' ','v','2','.','8',' ','\x9b','\x02',' ','[','A','t','m','e','l',' ','A','T','7','6','C','5','0','5',']',
/* 0x05607 = "Free shared USB VID/PID pair for CDC devices" */
    'F','r','e','e',' ','s','h','a','r','e','d',' ','\x0a',' ','V','I','D','/','P','I','D',' ','p','a','i','r',' ','\xcc','C','D','C',' ','d','e','v','i','c','e','s',
/* 0x0562e = "ASUS Zenfone GO (ZB500KL) (Debug, MTP mode)" */
    'A','S','U','S',' ','Z','e','n','f','o','n','e',' ','G','O',' ','(','Z','B','5','0','0','K','L',')',' ','(','D','e','b','u','g',',',' ','M','T','P',' ','\x1a',
/* 0x05655 = "DWA-127 Wireless N 150 High-Gain Adapter(rev.A1) [Ralink RT3070]" */
    'D','W','A','-','1','2','7',' ','\x01','N',' ','1','5','0',' ','H','i','g','h','-','G','a','i','n',' ','\xbb','A','1',')',' ','[','\x93','R','T','3','0','7','0',']',
/* 0x0567c = "Simple CC25xx programmer / serial board" */
    'S','i','m','p','l','e',' ','C','C','2','5','x','x',' ','p','r','o','g','r','a','m','m','e','r',' ','/',' ','s','e','r','i','a','l',' ','b','o','a','r','d',
/* 0x056a3 = "Globetrotter HSUPA Modem (aka iCON HSUPA E)" */
    'G','l','o','b','e','t','r','o','t','t','e','r',' ','H','S','U','P','A',' ','\x1c',' ','(','a','k','a',' ','i','C','O','N',' ','H','S','U','P','A',' ','E',')',
/* 0x056ca = "LUFA Test and Measurement Demo Application" */
    'L','U','F','A',' ','T','e','s','t',' ','\xe4','M','e','a','s','u','r','e','m','e','n','t',' ','D','e','m','o',' ','A','p','p','l','i','c','a','t','i','o','n',
/* 0x056f1 = "Truly Ergonomic Computer Keyboard (Device Firmware Update mode)" */
    'T','r','u','l','y',' ','E','r','g','o','n','o','m','i','c',' ','\xcd','\x05',' ','(','\x03',' ','F','i','r','m','w','a','r','e',' ','U','p','d','a','t','e',' ','\x1a',
/* 0x05718 = "HC-X920K (3MOS Full HD video camcorder)" */
    'H','C','-','X','9','2','0','K',' ','(','3','M','O','S',' ','F','u','l','l',' ','H','D',' ','v','i','d','e','o',' ','c','a','m','c','o','r','d','e','r',')',
/* 0x0573f = "SPC 900NC PC Camera / ORITE CCD Webcam(PC370R)" */
    'S','P','C',' ','9','0','0','N','C',' ','\x1f','\x04',' ','/',' ','O','R','I','T','E',' ','C','C','D',' ','W','e','b','c','a','m','(','P','C','3','7','0','R',')',
/* 0x05766 = "DTV-DVB UDST7022BDA DVB-S Box(Without HID)" */
    'D','T','V','-','D','V','B',' ','U','D','S','T','7','0','2','2','B','D','A',' ','\xa7','S',' ','B','o','x','(','W','i','t','h','o','u','t',' ','H','I','D',')',
/* 0x0578d = "calc.pw password generator device (standard)" */
    'c','a','l','c','.','p','w',' ','p','a','s','s','w','o','r','d',' ','g','e','n','e','r','a','t','o','r',' ','\xf9',' ','(','s','t','a','n','d','a','r','d',')',
/* 0x057b4 = "Amptek DP4 multichannel signal analyzer" */
    'A','m','p','t','e','k',' ','D','P','4',' ','m','u','l','t','i','c','h','a','n','n','e','l',' ','s','i','g','n','a','l',' ','a','n','a','l','y','z','e','r',
/* 0x057db = "Metrologic MS7120 Barcode Scanner (keyboard mode)" */
    'M','e','t','r','o','l','o','g','i','c',' ','M','S','7','1','2','0',' ','B','a','r','c','o','d','e',' ','\x25',' ','(','k','e','y','b','o','a','r','d',' ','\x1a',
/* 0x05802 = "Wireless Broadband (CDMA EV-DO) SM-Bus Minicard Status Port" */
    '\x01','\xb7','(','C','D','M','A',' ','E','V','-','D','O',')',' ','S','M','-','B','u','s',' ','M','i','n','i','c','a','r','d',' ','S','t','a','t','u','s',' ','\x87',
/* 0x05829 = "Android-powered device using AllWinner Technology SoC" */
    'A','n','d','r','o','i','d','-','p','o','w','e','r','e','d',' ','\xf9',' ','u','s','i','n','g',' ','A','l','l','W','i','n','n','e','r',' ','\x0d',' ','S','o','C',
/* 0x05850 = "IXY DV M2 (normal mode) / MVX 10i (normal mode)" */
    'I','X','Y',' ','D','V',' ','M','2',' ','(','n','o','r','m','a','l',' ','\x1a',' ','/',' ','M','V','X',' ','1','0','i',' ','(','n','o','r','m','a','l',' ','\x1a',
/* 0x05877 = "Smoothiepanel robotic control interface" */
    'S','m','o','o','t','h','i','e','p','a','n','e','l',' ','r','o','b','o','t','i','c',' ','c','o','n','t','r','o','l',' ','i','n','t','e','r','f','a','c','e',
/* 0x0589e = "802.11n Network Adapter (wrong ID - swapped vendor and device)" */
    '\x99','\x8d','\x02',' ','(','w','r','o','n','g',' ','I','D',' ','-',' ','s','w','a','p','p','e','d',' ','v','e','n','d','o','r',' ','\xe4','d','e','v','i','c','e',')',
/* 0x058c5 = "GW-USSuper300 802.11bgn Wireless Adapter [Realtek RTL8191SU]" */
    'G','W','-','U','S','S','u','p','e','r','3','0','0',' ','8','0','2','.','1','1','b','g','n',' ','\x01','\x02',' ','[','\xbe','R','T','L','8','1','9','1','S','U',']',
/* 0x058ec = "MVX150i (normal mode) / Optura 20 (normal mode)" */
    'M','V','X','1','5','0','i',' ','(','n','o','r','m','a','l',' ','\x1a',' ','/',' ','O','p','t','u','r','a',' ','2','0',' ','(','n','o','r','m','a','l',' ','\x1a',
/* 0x05913 = "OpenMoko Neo1973 internal USB CSR4 module" */
    'O','p','e','n','M','o','k','o',' ','N','e','o','1','9','7','3',' ','i','n','t','e','r','n','a','l',' ','\x0a',' ','C','S','R','4',' ','m','o','d','u','l','e',
/* 0x0593a = "F71610A or F71612A Consumer Infrared Receiver/Transceiver" */
    'F','7','1','6','1','0','A',' ','o','r',' ','F','7','1','6','1','2','A',' ','C','o','n','s','u','m','e','r',' ','\xa8','R','e','c','e','i','v','e','r','/','\xc8',
/* 0x05961 = "PX-601F [ME Office 700FW/Stylus Office BX600FW/TX600FW]" */
    'P','X','-','6','0','1','F',' ','[','M','E',' ','\xd3',' ','7','0','0','F','W','/','\xb1','\xd3',' ','B','X','6','0','0','F','W','/','T','X','6','0','0','F','W',']',
/* 0x05988 = "RTL8151 Adapteon Business Mobile Networks BV" */
    'R','T','L','8','1','5','1',' ','A','d','a','p','t','e','o','n',' ','B','u','s','i','n','e','s','s',' ','\x96',' ','N','e','t','w','o','r','k','s',' ','B','V',
/* 0x059af = "Generic 10K Universal Protocol Analyzer" */
    'G','e','n','e','r','i','c',' ','1','0','K',' ','U','n','i','v','e','r','s','a','l',' ','P','r','o','t','o','c','o','l',' ','A','n','a','l','y','z','e','r',
/* 0x059d6 = "SDR-H85 Camcorder (recorder mode - HDD)" */
    'S','D','R','-','H','8','5',' ','C','a','m','c','o','r','d','e','r',' ','(','r','e','c','o','r','d','e','r',' ','m','o','d','e',' ','-',' ','H','D','D',')',
/* 0x059fd = "Turbolink UB801RE Wireless 802.11g 54Mbps Network Adapter [RTL8187]" */
    'T','u','r','b','o','l','i','n','k',' ','U','B','8','0','1','R','E',' ','\x01','\x94','5','4','M','b','p','s',' ','\x8d','\x02',' ','[','R','T','L','8','1','8','7',']',
/* 0x05a24 = "calc.pw password generator device (enhanced)" */
    'c','a','l','c','.','p','w',' ','p','a','s','s','w','o','r','d',' ','g','e','n','e','r','a','t','o','r',' ','\xf9',' ','(','e','n','h','a','n','c','e','d',')',
/* 0x05a4b = "Hercules HWNUm-300 Wireless N mini [Realtek RTL8191SU]" */
    'H','e','r','c','u','l','e','s',' ','H','W','N','U','m','-','3','0','0',' ','\x01','N',' ','m','i','n','i',' ','[','\xbe','R','T','L','8','1','9','1','S','U',']',
/* 0x05a72 = "Datagraphix, a business unit of Anacomp" */
    'D','a','t','a','g','r','a','p','h','i','x',',',' ','a',' ','b','u','s','i','n','e','s','s',' ','u','n','i','t',' ','o','f',' ','A','n','a','c','o','m','p',
/* 0x05a99 = "EOS Rebel T5 / EOS 1200D / EOS Kiss X70" */
    'E','O','S',' ','R','e','b','e','l',' ','T','5',' ','/',' ','E','O','S',' ','1','2','0','0','D',' ','/',' ','E','O','S',' ','K','i','s','s',' ','X','7','0',
/* 0x05ac0 = "4axis,12button vibrition audio gamepad" */
    '4','a','x','i','s',',','1','2','b','u','t','t','o','n',' ','v','i','b','r','i','t','i','o','n',' ','a','u','d','i','o',' ','g','a','m','e','p','a','d',
/* 0x05ae6 = "Inspectrum 256x1024 F VIS Spectrograph" */
    'I','n','s','p','e','c','t','r','u','m',' ','2','5','6','x','1','0','2','4',' ','F',' ','V','I','S',' ','S','p','e','c','t','r','o','g','r','a','p','h',
/* 0x05b0c = "3CRUSB20075 OfficeConnect Wireless 108Mbps 11g Adapter [Atheros AR5523]" */
    '3','C','R','U','S','B','2','0','0','7','5',' ','\xd3','\xee','\x01','1','0','8','M','b','p','s',' ','1','1','g',' ','\x02',' ','[','\xaf','A','R','5','5','2','3',']',
/* 0x05b32 = "SAU510-USB and SAU510-USB plus JTAG Emulators" */
    'S','A','U','5','1','0','-','\x0a',' ','\xe4','S','A','U','5','1','0','-','\x0a',' ','p','l','u','s',' ','J','T','A','G',' ','E','m','u','l','a','t','o','r','s',
/* 0x05b58 = "Antonio Precise Products Manufactory Ltd." */
    'A','n','t','o','n','i','o',' ','P','r','e','c','i','s','e',' ','P','r','o','d','u','c','t','s',' ','M','a','n','u','f','a','c','t','o','r','y',' ','\xab',
/* 0x05b7e = "MCS7717 3-port hub with serial and parallel adapter" */
    'M','C','S','7','7','1','7',' ','3','-','p','o','r','t',' ','h','u','b',' ','\x98','s','e','r','i','a','l',' ','\xe4','p','a','r','a','l','l','e','l',' ','\xd0',
/* 0x05ba4 = "EOS Rebel T1i / EOS 500D / EOS Kiss X3" */
    'E','O','S',' ','R','e','b','e','l',' ','T','1','i',' ','/',' ','E','O','S',' ','5','0','0','D',' ','/',' ','E','O','S',' ','K','i','s','s',' ','X','3',
/* 0x05bca = "CTH-661 [Bamboo Fun/Comic Pen & Touch (M)]" */
    'C','T','H','-','6','6','1',' ','[','B','a','m','b','o','o',' ','F','u','n','/','C','o','m','i','c',' ','P','e','n',' ','&',' ','\x9d',' ','(','M',')',']',
/* 0x05bf0 = "Analog Devices, Inc. (White Mountain DSP)" */
    'A','n','a','l','o','g',' ','D','e','v','i','c','e','s',',',' ','\x07',' ','(','W','h','i','t','e',' ','M','o','u','n','t','a','i','n',' ','D','S','P',')',
/* 0x05c16 = "Silicon Labs FM Radio Reference Design" */
    'S','i','l','i','c','o','n',' ','L','a','b','s',' ','F','M',' ','R','a','d','i','o',' ','R','e','f','e','r','e','n','c','e',' ','D','e','s','i','g','n',
/* 0x05c3c = "GT-B3710 Standalone LTE device (Commercial)" */
    'G','T','-','B','3','7','1','0',' ','S','t','a','n','d','a','l','o','n','e',' ','L','T','E',' ','\xf9',' ','(','C','o','m','m','e','r','c','i','a','l',')',
/* 0x05c62 = "Gobi 9x15 Multimode 3G/4G LTE Modem (NAT mode)" */
    'G','o','b','i',' ','9','x','1','5',' ','M','u','l','t','i','m','o','d','e',' ','3','G','/','4','G',' ','L','T','E',' ','\x1c',' ','(','N','A','T',' ','\x1a',
/* 0x05c88 = "J-UH16 (Freedom 2.4 Cordless Joystick)" */
    'J','-','U','H','1','6',' ','(','F','r','e','e','d','o','m',' ','2','.','4',' ','C','o','r','d','l','e','s','s',' ','J','o','y','s','t','i','c','k',')',
/* 0x05cae = "8x Slim DVD Multi-Format Recorder External" */
    '8','x',' ','S','l','i','m',' ','D','V','D',' ','\xd6','-','F','o','r','m','a','t',' ','R','e','c','o','r','d','e','r',' ','E','x','t','e','r','n','a','l',
/* 0x05cd4 = "Macareux-labs Hygrometry Temperature Sensor" */
    'M','a','c','a','r','e','u','x','-','l','a','b','s',' ','H','y','g','r','o','m','e','t','r','y',' ','T','e','m','p','e','r','a','t','u','r','e',' ','\xac',
/* 0x05cfa = "Inspectrum 256x1024 B VIS Spectrograph" */
    'I','n','s','p','e','c','t','r','u','m',' ','2','5','6','x','1','0','2','4',' ','B',' ','V','I','S',' ','S','p','e','c','t','r','o','g','r','a','p','h',
/* 0x05d20 = "Dynex DX-NUSB 802.11bgn Wireless Adapter [Broadcom BCM43231]" */
    'D','y','n','e','x',' ','D','X','-','N','U','S','B',' ','8','0','2','.','1','1','b','g','n',' ','\x01','\x02',' ','[','\xeb','B','C','M','4','3','2','3','1',']',
/* 0x05d46 = "3Dconnexion Space Navigator for Notebooks" */
    '3','D','c','o','n','n','e','x','i','o','n',' ','S','p','a','c','e',' ','N','a','v','i','g','a','t','o','r',' ','\xcc','N','o','t','e','b','o','o','k','s',
/* 0x05d6c = "MVX25i (normal mode) / Optura 40 (normal mode)" */
    'M','V','X','2','5','i',' ','(','n','o','r','m','a','l',' ','\x1a',' ','/',' ','O','p','t','u','r','a',' ','4','0',' ','(','n','o','r','m','a','l',' ','\x1a',
/* 0x05d92 = "Pole Display (LB324-USB   4 x 20 Line Display)" */
    'P','o','l','e',' ','\xcf',' ','(','L','B','3','2','4','-','\x0a',' ',' ',' ','4',' ','x',' ','2','0',' ','L','i','n','e',' ','D','i','s','p','l','a','y',')',
/* 0x05db8 = "PX-A650 [Stylus CX4700/CX4800/DX4800/DX4850]" */
    'P','X','-','A','6','5','0',' ','[','\xb1','C','X','4','7','0','0','/','C','X','4','8','0','0','/','D','X','4','8','0','0','/','D','X','4','8','5','0',']',
/* 0x05dde = "ILCE-6000 (aka Alpha-6000) in MTP mode" */
    'I','L','C','E','-','6','0','0','0',' ','(','a','k','a',' ','A','l','p','h','a','-','6','0','0','0',')',' ','i','n',' ','M','T','P',' ','m','o','d','e',
/* 0x05e04 = "2.0MPixel Web Cam - Asus Z96J, Z96S, S96S" */
    '2','.','0','M','P','i','x','e','l',' ','W','e','b',' ','\x9a','-',' ','A','s','u','s',' ','Z','9','6','J',',',' ','Z','9','6','S',',',' ','S','9','6','S',
/* 0x05e2a = "WL-140 / Hawking HWU36D 802.11b Wireless Adapter [Intersil PRISM 3]" */
    'W','L','-','1','4','0',' ','/',' ','H','a','w','k','i','n','g',' ','H','W','U','3','6','D',' ','\x9b','\x01','\x02',' ','[','\xb0','P','R','I','S','M',' ','3',']',
/* 0x05e50 = "My Book Pro Edition II (WD10000C033-001)" */
    'M','y',' ','B','o','o','k',' ','\x8f',' ','E','d','i','t','i','o','n',' ','I','I',' ','(','W','D','1','0','0','0','0','C','0','3','3','-','0','0','1',')',
/* 0x05e76 = "Triton Handheld GPS Receiver (300/400/500/1500/2000)" */
    'T','r','i','t','o','n',' ','\xc5',' ','G','P','S',' ','\x8c',' ','(','3','0','0','/','4','0','0','/','5','0','0','/','1','5','0','0','/','2','0','0','0',')',
/* 0x05e9c = "LM9832 - PA570 Mini Business Card Scanner [Targus]" */
    'L','M','9','8','3','2',' ','-',' ','P','A','5','7','0',' ','\xb9',' ','B','u','s','i','n','e','s','s',' ','\x15',' ','\x25',' ','[','T','a','r','g','u','s',']',
/* 0x05ec2 = "Qtek 8310 mobile phone [Tornado Noble]" */
    'Q','t','e','k',' ','8','3','1','0',' ','m','o','b','i','l','e',' ','p','h','o','n','e',' ','[','T','o','r','n','a','d','o',' ','N','o','b','l','e',']',
/* 0x05ee8 = "ODU-Steckverbindungssysteme GmbH & Co. KG" */
    'O','D','U','-','S','t','e','c','k','v','e','r','b','i','n','d','u','n','g','s','s','y','s','t','e','m','e',' ','\xfc',' ','&',' ','C','o','.',' ','K','G',
/* 0x05f0e = "EOS Rebel T2i / EOS 550D / EOS Kiss X4" */
    'E','O','S',' ','R','e','b','e','l',' ','T','2','i',' ','/',' ','E','O','S',' ','5','5','0','D',' ','/',' ','E','O','S',' ','K','i','s','s',' ','X','4',
/* 0x05f34 = "5010 Surface Capacitive Touchmonitor Interface" */
    '5','0','1','0',' ','S','u','r','f','a','c','e',' ','C','a','p','a','c','i','t','i','v','e',' ','T','o','u','c','h','m','o','n','i','t','o','r',' ','\x81',
/* 0x05f5a = "PA101 10 Mbps HPNA Home Phoneline RJ-1" */
    'P','A','1','0','1',' ','1','0',' ','M','b','p','s',' ','H','P','N','A',' ','H','o','m','e',' ','P','h','o','n','e','l','i','n','e',' ','R','J','-','1',
/* 0x05f80 = "VIA VNT-6656 [WiFi 802.11b/g USB Dongle]" */
    'V','I','A',' ','V','N','T','-','6','6','5','6',' ','[','W','i','F','i',' ','8','0','2','.','1','1','b','/','g',' ','\x0a',' ','D','o','n','g','l','e',']',
/* 0x05fa6 = "RASDR Radio Astronomy SDR (bootloader)" */
    'R','A','S','D','R',' ','R','a','d','i','o',' ','A','s','t','r','o','n','o','m','y',' ','S','D','R',' ','(','b','o','o','t','l','o','a','d','e','r',')',
/* 0x05fcc = "Inspectrum 128x1024 F VIS Spectrograph" */
    'I','n','s','p','e','c','t','r','u','m',' ','1','2','8','x','1','0','2','4',' ','F',' ','V','I','S',' ','S','p','e','c','t','r','o','g','r','a','p','h',
/* 0x05ff2 = "Pole Display (L450-USB   Graphic Line Display)" */
    'P','o','l','e',' ','\xcf',' ','(','L','4','5','0','-','\x0a',' ',' ',' ','G','r','a','p','h','i','c',' ','L','i','n','e',' ','D','i','s','p','l','a','y',')',
/* 0x06018 = "EP-801A [Artisan 700/Stylus Photo PX700W/TX700W]" */
    'E','P','-','8','0','1','A',' ','[','A','r','t','i','s','a','n',' ','7','0','0','/','\xb1','\x86',' ','P','X','7','0','0','W','/','T','X','7','0','0','W',']',
/* 0x0603e = "SPCA1527A/SPCA1528 SD card camera (Mass Storage mode)" */
    'S','P','C','A','1','5','2','7','A','/','S','P','C','A','1','5','2','8',' ','S','D',' ','c','a','r','d',' ','c','a','m','e','r','a',' ','(','\x7c','\x0f','\x1a',
/* 0x06064 = "Model 2250 MPEG and JPEG Capture Card (cold)" */
    'M','o','d','e','l',' ','2','2','5','0',' ','M','P','E','G',' ','\xe4','J','P','E','G',' ','C','a','p','t','u','r','e',' ','\x15',' ','(','c','o','l','d',')',
/* 0x0608a = "Hand Held Products (Welch Allyn, Inc.)" */
    'H','a','n','d',' ','H','e','l','d',' ','P','r','o','d','u','c','t','s',' ','(','W','e','l','c','h',' ','A','l','l','y','n',',',' ','I','n','c','.',')',
/* 0x060b0 = "RGT Force Feedback Clutch Racing Wheel" */
    'R','G','T',' ','F','o','r','c','e',' ','F','e','e','d','b','a','c','k',' ','C','l','u','t','c','h',' ','R','a','c','i','n','g',' ','W','h','e','e','l',
/* 0x060d6 = "Bi-directional to Parallel Printer Converter" */
    'B','i','-','d','i','r','e','c','t','i','o','n','a','l',' ','t','o',' ','P','a','r','a','l','l','e','l',' ','\x0c',' ','C','o','n','v','e','r','t','e','r',
/* 0x060fc = "C8051F34x HDMI Audio Extractor [EMX-HD-AUD]" */
    'C','8','0','5','1','F','3','4','x',' ','H','D','M','I',' ','\x8b','E','x','t','r','a','c','t','o','r',' ','[','E','M','X','-','H','D','-','A','U','D',']',
/* 0x06122 = "Analog/ISDN Converter (Line converter)" */
    'A','n','a','l','o','g','/','I','S','D','N',' ','C','o','n','v','e','r','t','e','r',' ','(','L','i','n','e',' ','c','o','n','v','e','r','t','e','r',')',
/* 0x06148 = "WNA3100(v1) Wireless-N 300 [Broadcom BCM43231]" */
    'W','N','A','3','1','0','0','(','v','1',')',' ','W','i','r','e','l','e','s','s','-','N',' ','3','0','0',' ','[','\xeb','B','C','M','4','3','2','3','1',']',
/* 0x0616e = "CANON IMAGING SYSTEM TECHNOLOGIES INC." */
    'C','A','N','O','N',' ','I','M','A','G','I','N','G',' ','S','Y','S','T','E','M',' ','T','E','C','H','N','O','L','O','G','I','E','S',' ','I','N','C','.',
/* 0x06194 = "GEMBIRD Flexible keyboard KB-109F-B-DE" */
    'G','E','M','B','I','R','D',' ','F','l','e','x','i','b','l','e',' ','k','e','y','b','o','a','r','d',' ','K','B','-','1','0','9','F','-','B','-','D','E',
/* 0x061ba = "Inspectrum 128x1024 B VIS Spectrograph" */
    'I','n','s','p','e','c','t','r','u','m',' ','1','2','8','x','1','0','2','4',' ','B',' ','V','I','S',' ','S','p','e','c','t','r','o','g','r','a','p','h',
/* 0x061e0 = "CDMA 1xRTT USB Modem (U-100/105/200/300/520)" */
    'C','D','M','A',' ','1','x','R','T','T',' ','\x0a',' ','\x1c',' ','(','U','-','1','0','0','/','1','0','5','/','2','0','0','/','3','0','0','/','5','2','0',')',
/* 0x06206 = "AnyPoint(TM) Home Network 10 Mbps Phoneline Adapter" */
    'A','n','y','P','o','i','n','t','(','T','M',')',' ','H','o','m','e',' ','\x8d','1','0',' ','M','b','p','s',' ','P','h','o','n','e','l','i','n','e',' ','\x02',
/* 0x0622c = "Telecommunications Technology Association (TTA)" */
    'T','e','l','e','c','o','m','m','u','n','i','c','a','t','i','o','n','s',' ','\x0d',' ','A','s','s','o','c','i','a','t','i','o','n',' ','(','T','T','A',')',
/* 0x06252 = "at90usbkey sample firmware (HID keyboard)" */
    'a','t','9','0','u','s','b','k','e','y',' ','s','a','m','p','l','e',' ','f','i','r','m','w','a','r','e',' ','(','\xf2','k','e','y','b','o','a','r','d',')',
/* 0x06278 = "Thesycon Systemsoftware & Consulting GmbH" */
    'T','h','e','s','y','c','o','n',' ','S','y','s','t','e','m','s','o','f','t','w','a','r','e',' ','&',' ','C','o','n','s','u','l','t','i','n','g',' ','\xfc',
/* 0x0629e = "TEW-645UB 802.11bgn 1x2:2 Wireless Adapter [Ralink RT2770]" */
    'T','E','W','-','6','4','5','U','B',' ','8','0','2','.','1','1','b','g','n',' ','1','x','2',':','2',' ','\x01','\x02',' ','[','\x93','R','T','2','7','7','0',']',
/* 0x062c4 = "ZHONGSHAN CHIANG YU ELECTRIC CO., LTD." */
    'Z','H','O','N','G','S','H','A','N',' ','C','H','I','A','N','G',' ','Y','U',' ','E','L','E','C','T','R','I','C',' ','C','O','.',',',' ','L','T','D','.',
/* 0x062ea = "Android Phone via mass storage [Wiko Cink Peax 2]" */
    '\xce','\x19',' ','v','i','a',' ','m','a','s','s',' ','s','t','o','r','a','g','e',' ','[','W','i','k','o',' ','C','i','n','k',' ','P','e','a','x',' ','2',']',
/* 0x06310 = "ATV Turbo / Rally2 Dual Channel USB 2.0 Flash Drive" */
    'A','T','V',' ','T','u','r','b','o',' ','/',' ','R','a','l','l','y','2',' ','D','u','a','l',' ','C','h','a','n','n','e','l',' ','\x0a',' ','\xc1','\x3c',' ','\x14',
/* 0x06336 = "Hauppauge WinTV-USB III (PAL) with FM radio Model 568" */
    '\xfb','W','i','n','T','V','-','\x0a',' ','I','I','I',' ','(','P','A','L',')',' ','\x98','F','M',' ','r','a','d','i','o',' ','M','o','d','e','l',' ','5','6','8',
/* 0x0635c = "Aiwa AM-NX9 Net MD Music Recorder MDLP" */
    'A','i','w','a',' ','A','M','-','N','X','9',' ','N','e','t',' ','M','D',' ','M','u','s','i','c',' ','R','e','c','o','r','d','e','r',' ','M','D','L','P',
/* 0x06382 = "USB-AC53 802.11a/b/g/n/ac Wireless Adapter [Broadcom BCM43526]" */
    '\x0a','-','A','C','5','3',' ','8','0','2','.','1','1','a','/','b','/','g','/','n','/','a','c',' ','\x01','\x02',' ','[','\xeb','B','C','M','4','3','5','2','6',']',
/* 0x063a8 = "Black Magic Debug Probe (Application)" */
    'B','l','a','c','k',' ','M','a','g','i','c',' ','D','e','b','u','g',' ','P','r','o','b','e',' ','(','A','p','p','l','i','c','a','t','i','o','n',')',
/* 0x063cd = "KWorld V-Stream XPERT DTV - DVB-T USB warm" */
    'K','W','o','r','l','d',' ','V','-','S','t','r','e','a','m',' ','X','P','E','R','T',' ','D','T','V',' ','-',' ','\xa7','T',' ','\x0a',' ','w','a','r','m',
/* 0x063f2 = "Aaronia AG Spectran Spectrum Analyzer" */
    'A','a','r','o','n','i','a',' ','A','G',' ','S','p','e','c','t','r','a','n',' ','S','p','e','c','t','r','u','m',' ','A','n','a','l','y','z','e','r',
/* 0x06417 = "SDDR-05b (CF II) ImageMate CompactFlash Reader" */
    'S','D','D','R','-','0','5','b',' ','(','C','F',' ','I','I',')',' ','I','m','a','g','e','M','a','t','e',' ','C','o','m','p','a','c','t','\x3c',' ','\x08',
/* 0x0643c = "CY7C68013 EZ-USB FX2 USB 2.0 Development Kit" */
    'C','Y','7','C','6','8','0','1','3',' ','E','Z','-','\x0a',' ','F','X','2',' ','\x0a',' ','\xc1','D','e','v','e','l','o','p','m','e','n','t',' ','K','i','t',
/* 0x06461 = "Numato Opsis HDMI2USB board (User Mode)" */
    'N','u','m','a','t','o',' ','O','p','s','i','s',' ','H','D','M','I','2','\x0a',' ','b','o','a','r','d',' ','(','U','s','e','r',' ','M','o','d','e',')',
/* 0x06486 = "4000U CarrollTouch\u00ae  Touchmonitor Interface" */
    '4','0','0','0','U',' ','C','a','r','r','o','l','l','T','o','u','c','h','\xff','\xc2','\xae',' ',' ','T','o','u','c','h','m','o','n','i','t','o','r',' ','\x81',
/* 0x064ab = "Multimedia Headset [Gigaware by Ignition L.P.]" */
    '\xe2',' ','H','e','a','d','s','e','t',' ','[','G','i','g','a','w','a','r','e',' ','b','y',' ','I','g','n','i','t','i','o','n',' ','L','.','P','.',']',
/* 0x064d0 = "A6200 802.11a/b/g/n/ac Wireless Adapter [Broadcom BCM43526]" */
    'A','6','2','0','0',' ','8','0','2','.','1','1','a','/','b','/','g','/','n','/','a','c',' ','\x01','\x02',' ','[','\xeb','B','C','M','4','3','5','2','6',']',
/* 0x064f5 = "WUA-2340 RangeBooster G Adapter(rev.A) [Atheros AR5523]" */
    'W','U','A','-','2','3','4','0',' ','R','a','n','g','e','B','o','o','s','t','e','r',' ','G',' ','\xbb','A',')',' ','[','\xaf','A','R','5','5','2','3',']',
/* 0x0651a = "F9L1004 802.11n Surf N300 XR Wireless Adapter [Realtek RTL8192CU]" */
    'F','9','L','1','0','0','4',' ','\x99','S','u','r','f',' ','N','3','0','0',' ','X','R',' ','\x01','\x02',' ','[','\xbe','R','T','L','8','1','9','2','C','U',']',
/* 0x0653f = "C8051F38x HDMI Audio Extractor [VSA-HA-DP]" */
    'C','8','0','5','1','F','3','8','x',' ','H','D','M','I',' ','\x8b','E','x','t','r','a','c','t','o','r',' ','[','V','S','A','-','H','A','-','D','P',']',
/* 0x06564 = "Linksys WUSB54GP v1 OEM 802.11g Adapter [Intersil ISL3886]" */
    'L','i','n','k','s','y','s',' ','W','U','S','B','5','4','G','P',' ','v','1',' ','O','E','M',' ','\x94','\x02',' ','[','\xb0','I','S','L','3','8','8','6',']',
/* 0x06589 = "4500U CarrollTouch\u00ae  Touchmonitor Interface" */
    '4','5','0','0','U',' ','C','a','r','r','o','l','l','T','o','u','c','h','\xff','\xc2','\xae',' ',' ','T','o','u','c','h','m','o','n','i','t','o','r',' ','\x81',
/* 0x065ae = "Street Fighter IV Arcade FightStick (PS3)" */
    'S','t','r','e','e','t',' ','F','i','g','h','t','e','r',' ','I','V',' ','A','r','c','a','d','e',' ','F','i','g','h','t','\xb3',' ','(','P','S','3',')',
/* 0x065d3 = "LUFA Combined CDC and Mouse Demo Application" */
    'L','U','F','A',' ','C','o','m','b','i','n','e','d',' ','C','D','C',' ','\xe4','\x0b',' ','D','e','m','o',' ','A','p','p','l','i','c','a','t','i','o','n',
/* 0x065f8 = "NW-3100 802.11b/g 54Mbps Wireless Network Adapter [zd1211]" */
    'N','W','-','3','1','0','0',' ','8','0','2','.','1','1','b','/','g',' ','5','4','M','b','p','s',' ','\x01','\x8d','\x02',' ','[','z','d','1','2','1','1',']',
/* 0x0661d = "Liquid Gallant Duo E350 (USB tethering)" */
    'L','i','q','u','i','d',' ','G','a','l','l','a','n','t',' ','D','u','o',' ','E','3','5','0',' ','(','\x0a',' ','t','e','t','h','e','r','i','n','g',')',
/* 0x06642 = "RP-48 Combination Pushbutton-Rotary Module" */
    'R','P','-','4','8',' ','C','o','m','b','i','n','a','t','i','o','n',' ','P','u','s','h','b','u','t','t','o','n','-','R','o','t','a','r','y',' ','\xe5',
/* 0x06667 = "Segway Robotic Mobility Platforms 200" */
    'S','e','g','w','a','y',' ','R','o','b','o','t','i','c',' ','M','o','b','i','l','i','t','y',' ','P','l','a','t','f','o','r','m','s',' ','2','0','0',
/* 0x0668c = "Defender Office Keyboard (K7310) S Zodiak KM-9010" */
    'D','e','f','e','n','d','e','r',' ','\xd3',' ','\x05',' ','(','K','7','3','1','0',')',' ','S',' ','Z','o','d','i','a','k',' ','K','M','-','9','0','1','0',
/* 0x066b1 = "Scientific-Atlanta WebSTAR 2000 series Cable Modem" */
    'S','c','i','e','n','t','i','f','i','c','-','A','t','l','a','n','t','a',' ','W','e','b','S','T','A','R',' ','2','0','0','0',' ','\x1d',' ','\xa5',' ','\x1c',
/* 0x066d6 = "NWD-210N 802.11b/g/n-draft wireless adapter" */
    'N','W','D','-','2','1','0','N',' ','8','0','2','.','1','1','b','/','g','/','n','-','d','r','a','f','t',' ','w','i','r','e','l','e','s','s',' ','\xd0',
/* 0x066fb = "DWA-140 RangeBooster N Adapter(rev.B3) [Ralink RT2870]" */
    'D','W','A','-','1','4','0',' ','R','a','n','g','e','B','o','o','s','t','e','r',' ','N',' ','\xbb','B','3',')',' ','[','\x93','R','T','2','8','7','0',']',
/* 0x06720 = "PhotoSmart 635/715/720/735/935/E337 (storage)" */
    '\x86','\x12',' ','6','3','5','/','7','1','5','/','7','2','0','/','7','3','5','/','9','3','5','/','E','3','3','7',' ','(','s','t','o','r','a','g','e',')',
/* 0x06745 = "F71610 or F71612 Consumer Infrared Receiver/Transceiver" */
    'F','7','1','6','1','0',' ','o','r',' ','F','7','1','6','1','2',' ','C','o','n','s','u','m','e','r',' ','\xa8','R','e','c','e','i','v','e','r','/','\xc8',
/* 0x0676a = "Code Mercenaries Hard- und Software GmbH" */
    'C','o','d','e',' ','M','e','r','c','e','n','a','r','i','e','s',' ','H','a','r','d','-',' ','u','n','d',' ','S','o','f','t','w','a','r','e',' ','\xfc',
/* 0x0678f = "Iron Logic Z-397 RS-485/422 converter" */
    'I','r','o','n',' ','L','o','g','i','c',' ','Z','-','3','9','7',' ','R','S','-','4','8','5','/','4','2','2',' ','c','o','n','v','e','r','t','e','r',
/* 0x067b4 = "Zaurus C-750/C-760/C-860/SL-C3000 PDA" */
    'Z','a','u','r','u','s',' ','C','-','7','5','0','/','C','-','7','6','0','/','C','-','8','6','0','/','S','L','-','C','3','0','0','0',' ','P','D','A',
/* 0x067d9 = "2500U IntelliTouch\u00ae  Touchmonitor Interface" */
    '2','5','0','0','U',' ','I','n','t','e','l','l','i','T','o','u','c','h','\xff','\xc2','\xae',' ',' ','T','o','u','c','h','m','o','n','i','t','o','r',' ','\x81',
/* 0x067fe = "MF627/MF628/MF628+/MF636+ HSDPA/HSUPA" */
    'M','F','6','2','7','/','M','F','6','2','8','/','M','F','6','2','8','+','/','M','F','6','3','6','+',' ','H','S','D','P','A','/','H','S','U','P','A',
/* 0x06823 = "FinePix A101, 2600/2800/4800/6800 Zoom (PC CAM)" */
    '\xca','i','x',' ','A','1','0','1',',',' ','2','6','0','0','/','2','8','0','0','/','4','8','0','0','/','6','8','0','0',' ','\xe6','(','\x1f','C','A','M',')',
/* 0x06848 = "C8051F38x HDMI Extender [UHBX-SW3-WP]" */
    'C','8','0','5','1','F','3','8','x',' ','H','D','M','I',' ','E','x','t','e','n','d','e','r',' ','[','U','H','B','X','-','S','W','3','-','W','P',']',
/* 0x0686d = "KWorld V-Stream XPERT DTV - DVB-T USB cold" */
    'K','W','o','r','l','d',' ','V','-','S','t','r','e','a','m',' ','X','P','E','R','T',' ','D','T','V',' ','-',' ','\xa7','T',' ','\x0a',' ','c','o','l','d',
/* 0x06892 = "WL-210 / WU210P 802.11b Wireless Adapter [Atmel AT76C503A]" */
    'W','L','-','2','1','0',' ','/',' ','W','U','2','1','0','P',' ','\x9b','\x01','\x02',' ','[','A','t','m','e','l',' ','A','T','7','6','C','5','0','3','A',']',
/* 0x068b7 = "EL-610 Super Mini Electron luminescent Keyboard" */
    'E','L','-','6','1','0',' ','S','u','p','e','r',' ','\xb9',' ','E','l','e','c','t','r','o','n',' ','l','u','m','i','n','e','s','c','e','n','t',' ','\x05',
/* 0x068dc = "B8T017 Bluetooth+EDR 2.1 / F4U017 USB 2.0 7-port Hub" */
    'B','8','T','0','1','7',' ','\x06','+','E','D','R',' ','2','.','1',' ','/',' ','F','4','U','0','1','7',' ','\x0a',' ','\xc1','7','-','p','o','r','t',' ','\xa4',
/* 0x06901 = "KAAN Standard Plus (Smartcard reader)" */
    'K','A','A','N',' ','S','t','a','n','d','a','r','d',' ','P','l','u','s',' ','(','S','m','a','r','t','c','a','r','d',' ','r','e','a','d','e','r',')',
/* 0x06926 = "C200 smartcard controller (Nordea card reader)" */
    'C','2','0','0',' ','s','m','a','r','t','c','a','r','d',' ','\x9e',' ','(','N','o','r','d','e','a',' ','c','a','r','d',' ','r','e','a','d','e','r',')',
/* 0x0694b = "DWA-140 RangeBooster N Adapter(rev.B3) [Ralink RT5372]" */
    'D','W','A','-','1','4','0',' ','R','a','n','g','e','B','o','o','s','t','e','r',' ','N',' ','\xbb','B','3',')',' ','[','\x93','R','T','5','3','7','2',']',
/* 0x06970 = "RE-BL PlayStation 3 IR-to-Bluetooth converter" */
    'R','E','-','B','L',' ','P','l','a','y','S','t','a','t','i','o','n',' ','3',' ','I','R','-','t','o','-','\x06',' ','c','o','n','v','e','r','t','e','r',
/* 0x06995 = "C2005 (Xperia M dual) in service mode" */
    'C','2','0','0','5',' ','(','X','p','e','r','i','a',' ','M',' ','d','u','a','l',')',' ','i','n',' ','s','e','r','v','i','c','e',' ','m','o','d','e',
/* 0x069ba = "Xaxero Marine Software Engineering, Ltd." */
    'X','a','x','e','r','o',' ','M','a','r','i','n','e',' ','S','o','f','t','w','a','r','e',' ','E','n','g','i','n','e','e','r','i','n','g',',',' ','\xab',
/* 0x069df = "Model-52 LED Light Source Power Supply and Driver" */
    'M','o','d','e','l','-','5','2',' ','L','E','D',' ','L','i','g','h','t',' ','S','o','u','r','c','e',' ','\x24',' ','S','u','p','p','l','y',' ','\xe4','\xde',
/* 0x06a04 = "Ubee PXU1900 WiMAX Adapter [Beceem BCSM250]" */
    'U','b','e','e',' ','P','X','U','1','9','0','0',' ','W','i','M','A','X',' ','\x02',' ','[','B','e','c','e','e','m',' ','B','C','S','M','2','5','0',']',
/* 0x06a29 = "USB->RS 232 adapter with Prolifec PL 2303 chipset" */
    '\x0a','-','>','R','S',' ','2','3','2',' ','\xd0',' ','\x98','P','r','o','l','i','f','e','c',' ','P','L',' ','2','3','0','3',' ','c','h','i','p','s','e','t',
/* 0x06a4e = "DWA-140 RangeBooster N Adapter(rev.B2) [Ralink RT3072]" */
    'D','W','A','-','1','4','0',' ','R','a','n','g','e','B','o','o','s','t','e','r',' ','N',' ','\xbb','B','2',')',' ','[','\x93','R','T','3','0','7','2',']',
/* 0x06a73 = "Transformer Pad Infinity TF700 (Debug mode)" */
    'T','r','a','n','s','f','o','r','m','e','r',' ','\xfa',' ','I','n','f','i','n','i','t','y',' ','T','F','7','0','0',' ','(','D','e','b','u','g',' ','\x1a',
/* 0x06a98 = "at90usbkey sample firmware (HID generic)" */
    'a','t','9','0','u','s','b','k','e','y',' ','s','a','m','p','l','e',' ','f','i','r','m','w','a','r','e',' ','(','\xf2','g','e','n','e','r','i','c',')',
/* 0x06abd = "0Y357C PMX-MMOCZUL (B) [Dell Laser Mouse]" */
    '0','Y','3','5','7','C',' ','P','M','X','-','M','M','O','C','Z','U','L',' ','(','B',')',' ','[','D','e','l','l',' ','\x82',' ','M','o','u','s','e',']',
/* 0x06ae2 = "GW-USEco300 802.11bgn Wireless Adapter [Realtek RTL8192CU]" */
    'G','W','-','U','S','E','c','o','3','0','0',' ','8','0','2','.','1','1','b','g','n',' ','\x01','\x02',' ','[','\xbe','R','T','L','8','1','9','2','C','U',']',
/* 0x06b07 = "Scientific Atlanta WebSTAR 2000 series Cable Modem" */
    'S','c','i','e','n','t','i','f','i','c',' ','A','t','l','a','n','t','a',' ','W','e','b','S','T','A','R',' ','2','0','0','0',' ','\x1d',' ','\xa5',' ','\x1c',
/* 0x06b2c = "Conceptronic C54RU v3 802.11bg Wireless Adapter [Ralink RT2571W]" */
    'C','o','n','c','e','p','t','r','o','n','i','c',' ','C','5','4','R','U',' ','v','3',' ','\xad',' ','\x01','\x02',' ','[','\x93','R','T','2','5','7','1','W',']',
/* 0x06b51 = "G7 Solutions (formerly Great Notions)" */
    'G','7',' ','S','o','l','u','t','i','o','n','s',' ','(','f','o','r','m','e','r','l','y',' ','G','r','e','a','t',' ','N','o','t','i','o','n','s',')',
/* 0x06b76 = "WLM-20U2/GN-1080 802.11abgn Wireless Adapter [Atheros AR7010+AR9280]" */
    'W','L','M','-','2','0','U','2','/','G','N','-','1','0','8','0',' ','\xea','\x01','\x02',' ','[','\xaf','A','R','7','0','1','0','+','A','R','9','2','8','0',']',
/* 0x06b9b = "GT-8200U/GT-8200UF [Perfection 1650/1650 PHOTO]" */
    'G','T','-','8','2','0','0','U','/','G','T','-','8','2','0','0','U','F',' ','[','\xf0','1','6','5','0','/','1','6','5','0',' ','P','H','O','T','O',']',
/* 0x06bc0 = "PowerShot SD900 / Digital IXUS 900 Ti / IXY DIGITAL 1000" */
    '\x24','\x84','S','D','9','0','0',' ','/',' ','\x09','\xfd','9','0','0',' ','T','i',' ','/',' ','I','X','Y',' ','D','I','G','I','T','A','L',' ','1','0','0','0',
/* 0x06be5 = "SDDR-09 (SSFDC) ImageMate SmartMedia Reader [eusb]" */
    'S','D','D','R','-','0','9',' ','(','S','S','F','D','C',')',' ','I','m','a','g','e','M','a','t','e',' ','\x12','\xa1',' ','\x08',' ','[','e','u','s','b',']',
/* 0x06c0a = "ILCE-6000 (aka Alpha-6000) in PC Remote mode" */
    'I','L','C','E','-','6','0','0','0',' ','(','a','k','a',' ','A','l','p','h','a','-','6','0','0','0',')',' ','i','n',' ','\x1f','\xcb',' ','m','o','d','e',
/* 0x06c2f = "CameraMate SmartMedia and CompactFlash Card Reader [eusb/shuttle]" */
    '\x04','M','a','t','e',' ','\x12','\xa1',' ','\xe4','C','o','m','p','a','c','t','\x3c',' ','\x15',' ','\x08',' ','[','e','u','s','b','/','s','h','u','t','t','l','e',']',
/* 0x06c54 = "DWA-140 RangeBooster N Adapter(rev.B1) [Ralink RT2870]" */
    'D','W','A','-','1','4','0',' ','R','a','n','g','e','B','o','o','s','t','e','r',' ','N',' ','\xbb','B','1',')',' ','[','\x93','R','T','2','8','7','0',']',
/* 0x06c79 = "WUP-005 [Nintendo Wii U Pro Controller]" */
    'W','U','P','-','0','0','5',' ','[','N','i','n','t','e','n','d','o',' ','W','i','i',' ','U',' ','\x8f',' ','C','o','n','t','r','o','l','l','e','r',']',
/* 0x06c9e = "WUA-2340 RangeBooster G Adapter(rev.B) [Ralink RT2070]" */
    'W','U','A','-','2','3','4','0',' ','R','a','n','g','e','B','o','o','s','t','e','r',' ','G',' ','\xbb','B',')',' ','[','\x93','R','T','2','0','7','0',']',
/* 0x06cc3 = "F7D2102 802.11n N300 Micro Wireless Adapter v3000 [Realtek RTL8192CU]" */
    'F','7','D','2','1','0','2',' ','\x99','N','3','0','0',' ','\xc4',' ','\x01','\x02',' ','v','3','0','0','0',' ','[','\xbe','R','T','L','8','1','9','2','C','U',']',
/* 0x06ce8 = "HID device except mice, keyboards, and joysticks" */
    '\xf2','\xf9',' ','e','x','c','e','p','t',' ','m','i','c','e',',',' ','k','e','y','b','o','a','r','d','s',',',' ','\xe4','j','o','y','s','t','i','c','k','s',
/* 0x06d0d = "Wireless Broadband (3G HSDPA) SM-Bus Minicard Status Port" */
    '\x01','\xb7','(','3','G',' ','H','S','D','P','A',')',' ','S','M','-','B','u','s',' ','M','i','n','i','c','a','r','d',' ','S','t','a','t','u','s',' ','\x87',
/* 0x06d32 = "Zygmunt Krynicki Lantern Brightness Sensor" */
    'Z','y','g','m','u','n','t',' ','K','r','y','n','i','c','k','i',' ','L','a','n','t','e','r','n',' ','B','r','i','g','h','t','n','e','s','s',' ','\xac',
/* 0x06d57 = "Xplained Pro board debugger and programmer" */
    'X','p','l','a','i','n','e','d',' ','\x8f',' ','b','o','a','r','d',' ','d','e','b','u','g','g','e','r',' ','\xe4','p','r','o','g','r','a','m','m','e','r',
/* 0x06d7c = "Shian Hwi Plug Parts, Plastic Factory" */
    'S','h','i','a','n',' ','H','w','i',' ','P','l','u','g',' ','P','a','r','t','s',',',' ','P','l','a','s','t','i','c',' ','F','a','c','t','o','r','y',
/* 0x06da1 = "GT-I9250 Phone [Galaxy Nexus] (Mass storage mode)" */
    'G','T','-','I','9','2','5','0',' ','\x19',' ','[','G','a','l','a','x','y',' ','N','e','x','u','s',']',' ','(','\x7c','s','t','o','r','a','g','e',' ','\x1a',
/* 0x06dc6 = "ET302s TD-SCDMA/TD-HSDPA Mobile Broadband" */
    'E','T','3','0','2','s',' ','T','D','-','S','C','D','M','A','/','T','D','-','H','S','D','P','A',' ','\x96',' ','B','r','o','a','d','b','a','n','d',
/* 0x06dea = "Name: Voyager 1055 Laptop 802.11g Adapter [Broadcom 4320]" */
    'N','a','m','e',':',' ','V','o','y','a','g','e','r',' ','1','0','5','5',' ','L','a','p','t','o','p',' ','\x94','\x02',' ','[','\xeb','4','3','2','0',']',
/* 0x06e0e = "ORGA 6000 Smart Card Terminal Virtual Com Port" */
    'O','R','G','A',' ','6','0','0','0',' ','\x12',' ','\x15',' ','T','e','r','m','i','n','a','l',' ','V','i','r','t','u','a','l',' ','C','o','m',' ','\x87',
/* 0x06e32 = "K016: USB-MSR ISO 3-Track MSR: HID Keyboard Mode" */
    'K','0','1','6',':',' ','\x0a','-','M','S','R',' ','I','S','O',' ','3','-','T','r','a','c','k',' ','M','S','R',':',' ','\xf2','\x05',' ','M','o','d','e',
/* 0x06e56 = "Medion/Lifetec/Tevion/Cytron MD 6190" */
    'M','e','d','i','o','n','/','L','i','f','e','t','e','c','/','T','e','v','i','o','n','/','C','y','t','r','o','n',' ','M','D',' ','6','1','9','0',
/* 0x06e7a = "Eumex 220 Version 2 ISDN TA (Flash-Mode)" */
    'E','u','m','e','x',' ','2','2','0',' ','V','e','r','s','i','o','n',' ','2',' ','I','S','D','N',' ','T','A',' ','(','\x3c','-','M','o','d','e',')',
/* 0x06e9e = "Compact Flash storage memory card reader" */
    'C','o','m','p','a','c','t',' ','\x3c',' ','s','t','o','r','a','g','e',' ','m','e','m','o','r','y',' ','c','a','r','d',' ','r','e','a','d','e','r',
/* 0x06ec2 = "Neo1973/FreeRunner Debug board (V2+)" */
    'N','e','o','1','9','7','3','/','F','r','e','e','R','u','n','n','e','r',' ','D','e','b','u','g',' ','b','o','a','r','d',' ','(','V','2','+',')',
/* 0x06ee6 = "Intelligent Usb Dmx Interface SIUDI9D Firmware Download" */
    '\xe0','U','s','b',' ','D','m','x',' ','\x81',' ','S','I','U','D','I','9','D',' ','F','i','r','m','w','a','r','e',' ','D','o','w','n','l','o','a','d',
/* 0x06f0a = "DTH-W1320 [MobileStudio Pro 13] touchscreen" */
    'D','T','H','-','W','1','3','2','0',' ','[','\x96','S','t','u','d','i','o',' ','\x8f',' ','1','3',']',' ','t','o','u','c','h','s','c','r','e','e','n',
/* 0x06f2e = "ShipModul MiniPlex-4xUSB NMEA Multiplexer" */
    'S','h','i','p','M','o','d','u','l',' ','\xb9','P','l','e','x','-','4','x','\x0a',' ','N','M','E','A',' ','M','u','l','t','i','p','l','e','x','e','r',
/* 0x06f52 = "Dell HyperVisor internal flash drive" */
    'D','e','l','l',' ','H','y','p','e','r','V','i','s','o','r',' ','i','n','t','e','r','n','a','l',' ','f','l','a','s','h',' ','d','r','i','v','e',
/* 0x06f76 = "MPC-C30 AnyCam Premium for Notebooks [pwc]" */
    'M','P','C','-','C','3','0',' ','A','n','y','\x9a','P','r','e','m','i','u','m',' ','\xcc','N','o','t','e','b','o','o','k','s',' ','[','p','w','c',']',
/* 0x06f9a = "Intelligent Usb Dmx Interface SIUDI9C Firmware Download" */
    '\xe0','U','s','b',' ','D','m','x',' ','\x81',' ','S','I','U','D','I','9','C',' ','F','i','r','m','w','a','r','e',' ','D','o','w','n','l','o','a','d',
/* 0x06fbe = "ShenZhen SANZHAI Technology Co.,Ltd Spy Pen VGA" */
    'S','h','e','n','Z','h','e','n',' ','S','A','N','Z','H','A','I',' ','\x0d',' ','C','o','.',',','\x16',' ','S','p','y',' ','P','e','n',' ','V','G','A',
/* 0x06fe2 = "Web Cam - Asus A8J, F3S, F5R, VX2S, V1S" */
    'W','e','b',' ','\x9a','-',' ','A','s','u','s',' ','A','8','J',',',' ','F','3','S',',',' ','F','5','R',',',' ','V','X','2','S',',',' ','V','1','S',
/* 0x07006 = "PC Camera with Microphone (SN9C202 + OV7670ISP)" */
    '\x1f','\x04',' ','\x98','M','i','c','r','o','p','h','o','n','e',' ','(','S','N','9','C','2','0','2',' ','+',' ','O','V','7','6','7','0','I','S','P',')',
/* 0x0702a = "SideWinder Force Feedback 2 Joystick" */
    'S','i','d','e','W','i','n','d','e','r',' ','F','o','r','c','e',' ','F','e','e','d','b','a','c','k',' ','2',' ','J','o','y','s','t','i','c','k',
/* 0x0704e = "Becker Traffic Assist Highspeed 7934" */
    'B','e','c','k','e','r',' ','T','r','a','f','f','i','c',' ','A','s','s','i','s','t',' ','H','i','g','h','s','p','e','e','d',' ','7','9','3','4',
/* 0x07072 = "PM-A820 [Stylus Photo RX560/RX580/RX585/RX590]" */
    'P','M','-','A','8','2','0',' ','[','\xb1','\x86',' ','R','X','5','6','0','/','R','X','5','8','0','/','R','X','5','8','5','/','R','X','5','9','0',']',
/* 0x07096 = "AG-760A 802.11abg Wireless Adapter [ZyDAS ZD1211B]" */
    'A','G','-','7','6','0','A',' ','8','0','2','.','1','1','a','b','g',' ','\x01','\x02',' ','[','Z','y','D','A','S',' ','Z','D','1','2','1','1','B',']',
/* 0x070ba = "US Interface Navigator (RS232 and CONFIG lines)" */
    'U','S',' ','\x81',' ','N','a','v','i','g','a','t','o','r',' ','(','R','S','2','3','2',' ','\xe4','C','O','N','F','I','G',' ','l','i','n','e','s',')',
/* 0x070de = "Scientific Atlanta WebSTAR 300 series Cable Modem" */
    'S','c','i','e','n','t','i','f','i','c',' ','A','t','l','a','n','t','a',' ','W','e','b','S','T','A','R',' ','3','0','0',' ','\x1d',' ','\xa5',' ','\x1c',
/* 0x07102 = "microSD RDR UHS-I Card Reader [LRWM03U-7000]" */
    'm','i','c','r','o','S','D',' ','R','D','R',' ','U','H','S','-','I',' ','\x15',' ','\x08',' ','[','L','R','W','M','0','3','U','-','7','0','0','0',']',
/* 0x07126 = "Shenzhen Tongyuan Network-Communication Cables Co., Ltd" */
    'S','h','e','n','z','h','e','n',' ','T','o','n','g','y','u','a','n',' ','N','e','t','w','o','r','k','-','\xe9','C','a','b','l','e','s',' ','\x0e','\x16',
/* 0x0714a = "NetScroll + Traveler / NetScroll 110" */
    'N','e','t','S','c','r','o','l','l',' ','+',' ','T','r','a','v','e','l','e','r',' ','/',' ','N','e','t','S','c','r','o','l','l',' ','1','1','0',
/* 0x0716e = "DNTV Live! Tiny USB2 BDA (No Remote)" */
    'D','N','T','V',' ','L','i','v','e','!',' ','T','i','n','y',' ','U','S','B','2',' ','B','D','A',' ','(','N','o',' ','R','e','m','o','t','e',')',
/* 0x07192 = "Clie PEG-N7x0C/PEG-T425 PalmOS PDA Serial" */
    'C','l','i','e',' ','P','E','G','-','N','7','x','0','C','/','P','E','G','-','T','4','2','5',' ','P','a','l','m','O','S',' ','P','D','A',' ','\x90',
/* 0x071b6 = "RTL 8153 USB 3.0 hub with gigabit ethernet" */
    'R','T','L',' ','8','1','5','3',' ','\x0a',' ','3','.','0',' ','h','u','b',' ','\x98','g','i','g','a','b','i','t',' ','e','t','h','e','r','n','e','t',
/* 0x071da = "PX-FA700 [CX9300F/CX9400Fax/DX9400F]" */
    'P','X','-','F','A','7','0','0',' ','[','C','X','9','3','0','0','F','/','C','X','9','4','0','0','F','a','x','/','D','X','9','4','0','0','F',']',
/* 0x071fe = "Alpermann+Velte SAM7S MT Boot Loader" */
    'A','l','p','e','r','m','a','n','n','+','V','e','l','t','e',' ','S','A','M','7','S',' ','M','T',' ','B','o','o','t',' ','L','o','a','d','e','r',
/* 0x07222 = "Genius Look 320s (SN9C201 + HV7131R)" */
    'G','e','n','i','u','s',' ','L','o','o','k',' ','3','2','0','s',' ','(','S','N','9','C','2','0','1',' ','+',' ','H','V','7','1','3','1','R',')',
/* 0x07246 = "D-Link DWL-120 802.11b Wireless Adapter [Atmel at76c503a]" */
    'D','-','L','i','n','k',' ','D','W','L','-','1','2','0',' ','\x9b','\x01','\x02',' ','[','A','t','m','e','l',' ','a','t','7','6','c','5','0','3','a',']',
/* 0x0726a = "Interactive Whiteboard Controller (SB6) (HID)" */
    'I','n','t','e','r','a','c','t','i','v','e',' ','W','h','i','t','e','b','o','a','r','d',' ','\x13',' ','(','S','B','6',')',' ','(','H','I','D',')',
/* 0x0728e = "HWUN3 Hi-Gain Wireless-N Adapter [Ralink RT3070]" */
    'H','W','U','N','3',' ','H','i','-','G','a','i','n',' ','W','i','r','e','l','e','s','s','-','N',' ','\x02',' ','[','\x93','R','T','3','0','7','0',']',
/* 0x072b2 = "GT-I9100 Phone [Galaxy S II] (Download mode)" */
    'G','T','-','I','9','1','0','0',' ','\x19',' ','[','G','a','l','a','x','y',' ','S',' ','I','I',']',' ','(','D','o','w','n','l','o','a','d',' ','\x1a',
/* 0x072d6 = "at90usbkey sample firmware (CDC ACM)" */
    'a','t','9','0','u','s','b','k','e','y',' ','s','a','m','p','l','e',' ','f','i','r','m','w','a','r','e',' ','(','C','D','C',' ','A','C','M',')',
/* 0x072fa = "Pocket PC 300 GPS SL / Typhoon MyGuide 3500" */
    '\x17',' ','\x1f','3','0','0',' ','G','P','S',' ','S','L',' ','/',' ','T','y','p','h','o','o','n',' ','M','y','G','u','i','d','e',' ','3','5','0','0',
/* 0x0731e = "Mirion Technologies Dosimetry Services Division" */
    'M','i','r','i','o','n',' ','\x88',' ','D','o','s','i','m','e','t','r','y',' ','S','e','r','v','i','c','e','s',' ','D','i','v','i','s','i','o','n',
/* 0x07342 = "ILCE-6000 (aka Alpha-6000) in Mass Storage mode" */
    'I','L','C','E','-','6','0','0','0',' ','(','a','k','a',' ','A','l','p','h','a','-','6','0','0','0',')',' ','i','n',' ','\x7c','\x0f','m','o','d','e',
/* 0x07366 = "DTH-W1620 [MobileStudio Pro 16] touchscreen" */
    'D','T','H','-','W','1','6','2','0',' ','[','\x96','S','t','u','d','i','o',' ','\x8f',' ','1','6',']',' ','t','o','u','c','h','s','c','r','e','e','n',
/* 0x0738a = "Sphairon Homelink 1202 802.11n Wireless Adapter [Atheros AR9170]" */
    'S','p','h','a','i','r','o','n',' ','H','o','m','e','l','i','n','k',' ','1','2','0','2',' ','\x99','\x01','\x02',' ','[','\xaf','A','R','9','1','7','0',']',
/* 0x073ae = "Kodak Personal Picture Maker 200 Card Reader" */
    'K','o','d','a','k',' ','P','e','r','s','o','n','a','l',' ','P','i','c','t','u','r','e',' ','M','a','k','e','r',' ','2','0','0',' ','\x15',' ','\x08',
/* 0x073d2 = "1866 802.11bg [Texas Instruments TNETW1450]" */
    '1','8','6','6',' ','\xad',' ','[','T','e','x','a','s',' ','I','n','s','t','r','u','m','e','n','t','s',' ','T','N','E','T','W','1','4','5','0',']',
/* 0x073f6 = "Intelligent Usb Dmx Interface SIUDI9A Firmware Download" */
    '\xe0','U','s','b',' ','D','m','x',' ','\x81',' ','S','I','U','D','I','9','A',' ','F','i','r','m','w','a','r','e',' ','D','o','w','n','l','o','a','d',
/* 0x0741a = "PV8630 interface (scanners, webcams)" */
    'P','V','8','6','3','0',' ','i','n','t','e','r','f','a','c','e',' ','(','s','c','a','n','n','e','r','s',',',' ','w','e','b','c','a','m','s',')',
/* 0x0743e = "Elite Keyboard Y-RP20 + Mouse MX900 (Bluetooth)" */
    'E','l','i','t','e',' ','\x05',' ','Y','-','R','P','2','0',' ','+',' ','\x0b',' ','M','X','9','0','0',' ','(','B','l','u','e','t','o','o','t','h',')',
/* 0x07462 = "Hauppague WinTV-USB Model 602 Rev B282" */
    'H','a','u','p','p','a','g','u','e',' ','W','i','n','T','V','-','\x0a',' ','M','o','d','e','l',' ','6','0','2',' ','R','e','v',' ','B','2','8','2',
/* 0x07486 = "E173s 3G broadband stick (modem off)" */
    'E','1','7','3','s',' ','3','G',' ','b','r','o','a','d','b','a','n','d',' ','s','t','i','c','k',' ','(','m','o','d','e','m',' ','o','f','f',')',
/* 0x074aa = "Furui Precise Component (Kunshan) Co., Ltd" */
    'F','u','r','u','i',' ','P','r','e','c','i','s','e',' ','C','o','m','p','o','n','e','n','t',' ','(','K','u','n','s','h','a','n',')',' ','\x0e','\x16',
/* 0x074ce = "Keebox W150NU 802.11bgn Wireless Adapter [Ralink RT3070]" */
    'K','e','e','b','o','x',' ','W','1','5','0','N','U',' ','8','0','2','.','1','1','b','g','n',' ','\x01','\x02',' ','[','\x93','R','T','3','0','7','0',']',
/* 0x074f2 = "Hauppague WinTV-USB Model 602 Rev B285" */
    'H','a','u','p','p','a','g','u','e',' ','W','i','n','T','V','-','\x0a',' ','M','o','d','e','l',' ','6','0','2',' ','R','e','v',' ','B','2','8','5',
/* 0x07516 = "CH341 in EPP/MEM/I2C mode, EPP/I2C adapter" */
    'C','H','3','4','1',' ','i','n',' ','E','P','P','/','M','E','M','/','I','2','C',' ','m','o','d','e',',',' ','E','P','P','/','I','2','C',' ','\xd0',
/* 0x0753a = "Intelligent Usb Dmx Interface SIUDI8C Firmware Download" */
    '\xe0','U','s','b',' ','D','m','x',' ','\x81',' ','S','I','U','D','I','8','C',' ','F','i','r','m','w','a','r','e',' ','D','o','w','n','l','o','a','d',
/* 0x0755e = "Fashion Cam 01 Dual-Mode DSC (Video Camera)" */
    'F','a','s','h','i','o','n',' ','\x9a','0','1',' ','D','u','a','l','-','M','o','d','e',' ','D','S','C',' ','(','\xa3',' ','C','a','m','e','r','a',')',
/* 0x07582 = "DWA-121 802.11n Wireless N 150 Pico Adapter [Realtek RTL8188CUS]" */
    'D','W','A','-','1','2','1',' ','\x99','\x01','N',' ','1','5','0',' ','P','i','c','o',' ','\x02',' ','[','\xbe','R','T','L','8','1','8','8','C','U','S',']',
/* 0x075a6 = "HYUNDAI GDS30C6001 SSFDC / MMC I/F Controller" */
    'H','Y','U','N','D','A','I',' ','G','D','S','3','0','C','6','0','0','1',' ','S','S','F','D','C',' ','/',' ','M','M','C',' ','I','/','F',' ','\x13',
/* 0x075ca = "ULS PLS Series Laser Engraver Firmware Loader" */
    'U','L','S',' ','P','L','S',' ','\xbf',' ','\x82',' ','E','n','g','r','a','v','e','r',' ','F','i','r','m','w','a','r','e',' ','L','o','a','d','e','r',
/* 0x075ee = "Func MS-3 gaming mouse [WT6573F MCU]" */
    'F','u','n','c',' ','M','S','-','3',' ','g','a','m','i','n','g',' ','m','o','u','s','e',' ','[','W','T','6','5','7','3','F',' ','M','C','U',']',
/* 0x07612 = "Laneed 100Mbps Ethernet LD-USB/TX [pegasus]" */
    'L','a','n','e','e','d',' ','1','0','0','M','b','p','s',' ','\x7f',' ','L','D','-','U','S','B','/','T','X',' ','[','p','e','g','a','s','u','s',']',
/* 0x07636 = "Kingston DataTraveler / Patriot Xporter" */
    'K','i','n','g','s','t','o','n',' ','\xe7','T','r','a','v','e','l','e','r',' ','/',' ','P','a','t','r','i','o','t',' ','X','p','o','r','t','e','r',
/* 0x0765a = "Conceptronic C54RU v2 802.11bg Wireless Adapter [Ralink RT2571]" */
    'C','o','n','c','e','p','t','r','o','n','i','c',' ','C','5','4','R','U',' ','v','2',' ','\xad',' ','\x01','\x02',' ','[','\x93','R','T','2','5','7','1',']',
/* 0x0767e = "Alpermann+Velte SAM7X MT Boot Loader" */
    'A','l','p','e','r','m','a','n','n','+','V','e','l','t','e',' ','S','A','M','7','X',' ','M','T',' ','B','o','o','t',' ','L','o','a','d','e','r',
/* 0x076a2 = "X-Rite DTP94 [Quato Silver Haze Pro]" */
    'X','-','R','i','t','e',' ','D','T','P','9','4',' ','[','Q','u','a','t','o',' ','S','i','l','v','e','r',' ','H','a','z','e',' ','P','r','o',']',
/* 0x076c6 = "OneTouch 4800 USB/Microtek Scanport 3000" */
    'O','n','e','\x9d',' ','4','8','0','0',' ','U','S','B','/','M','i','c','r','o','t','e','k',' ','S','c','a','n','p','o','r','t',' ','3','0','0','0',
/* 0x076ea = "AX226 WIMAX MODEM (After Modeswitch)" */
    'A','X','2','2','6',' ','W','I','M','A','X',' ','M','O','D','E','M',' ','(','A','f','t','e','r',' ','M','o','d','e','s','w','i','t','c','h',')',
/* 0x0770e = "F5D8053 N Wireless USB Adapter v1000/v4000 [Ralink RT2870]" */
    'F','5','D','8','0','5','3',' ','N',' ','\x01','\x0a',' ','\x02',' ','v','1','0','0','0','/','v','4','0','0','0',' ','[','\x93','R','T','2','8','7','0',']',
/* 0x07732 = "ScopeFun open source instrumentation" */
    'S','c','o','p','e','F','u','n',' ','o','p','e','n',' ','s','o','u','r','c','e',' ','i','n','s','t','r','u','m','e','n','t','a','t','i','o','n',
/* 0x07756 = "FA120 Fast Ethernet USB 2.0 [Asix AX88172 / AX8817x]" */
    'F','A','1','2','0',' ','\xec','\x7f',' ','\x0a',' ','\xc1','[','A','s','i','x',' ','A','X','8','8','1','7','2',' ','/',' ','A','X','8','8','1','7','x',']',
/* 0x0777a = "K016/K018: USB-MSR Flash-Recovery/Download" */
    'K','0','1','6','/','K','0','1','8',':',' ','\x0a','-','M','S','R',' ','\x3c','-','R','e','c','o','v','e','r','y','/','D','o','w','n','l','o','a','d',
/* 0x0779e = "Built-in iSight (no firmware loaded)" */
    'B','u','i','l','t','-','i','n',' ','i','S','i','g','h','t',' ','(','n','o',' ','f','i','r','m','w','a','r','e',' ','l','o','a','d','e','d',')',
/* 0x077c2 = "IntelliMouse Explorer 4.0 (IntelliPoint)" */
    'I','n','t','e','l','l','i','\x0b',' ','E','x','p','l','o','r','e','r',' ','4','.','0',' ','(','I','n','t','e','l','l','i','P','o','i','n','t',')',
/* 0x077e6 = "WUSB54GX4 802.11g 240Mbps Wireless Adapter [Airgo AGN300]" */
    'W','U','S','B','5','4','G','X','4',' ','\x94','2','4','0','M','b','p','s',' ','\x01','\x02',' ','[','A','i','r','g','o',' ','A','G','N','3','0','0',']',
/* 0x0780a = "DSC-HX100V [Cybershot Digital Still Camera]" */
    'D','S','C','-','H','X','1','0','0','V',' ','[','C','y','b','e','r','s','h','o','t',' ','\x09','S','t','i','l','l',' ','C','a','m','e','r','a',']',
/* 0x0782e = "Medion MDPNA1500 in card reader mode" */
    'M','e','d','i','o','n',' ','M','D','P','N','A','1','5','0','0',' ','i','n',' ','c','a','r','d',' ','r','e','a','d','e','r',' ','m','o','d','e',
/* 0x07852 = "Intelligent Usb Dmx Interface SIUDI8A Firmware Download" */
    '\xe0','U','s','b',' ','D','m','x',' ','\x81',' ','S','I','U','D','I','8','A',' ','F','i','r','m','w','a','r','e',' ','D','o','w','n','l','o','a','d',
/* 0x07876 = "Linksys WUSB54G v1 OEM 802.11g Adapter [Intersil ISL3886]" */
    'L','i','n','k','s','y','s',' ','W','U','S','B','5','4','G',' ','v','1',' ','O','E','M',' ','\x94','\x02',' ','[','\xb0','I','S','L','3','8','8','6',']',
/* 0x0789a = "Option Beemo (GI0801) LTE surfstick" */
    'O','p','t','i','o','n',' ','B','e','e','m','o',' ','(','G','I','0','8','0','1',')',' ','L','T','E',' ','s','u','r','f','s','t','i','c','k',
/* 0x078bd = "RG-0618U Wireless HID Receiver & KG-0609 Wireless Keyboard with Touchpad" */
    'R','G','-','0','6','1','8','U',' ','\x01','\xf2','\x8c',' ','&',' ','K','G','-','0','6','0','9',' ','\x01','\x05',' ','\x98','T','o','u','c','h','p','a','d',
/* 0x078e0 = "BioPAD biometric module (DFU + CDC)" */
    'B','i','o','P','A','D',' ','b','i','o','m','e','t','r','i','c',' ','m','o','d','u','l','e',' ','(','D','F','U',' ','+',' ','C','D','C',')',
/* 0x07903 = "Camtel Technology USB TV Genie Pro FM Model TVB330" */
    'C','a','m','t','e','l',' ','\x0d',' ','\x0a',' ','\xda','G','e','n','i','e',' ','\x8f',' ','F','M',' ','M','o','d','e','l',' ','T','V','B','3','3','0',
/* 0x07926 = "F5D6050 802.11b Wireless Adapter v2000 [Atmel at76c503a]" */
    'F','5','D','6','0','5','0',' ','\x9b','\x01','\x02',' ','v','2','0','0','0',' ','[','A','t','m','e','l',' ','a','t','7','6','c','5','0','3','a',']',
/* 0x07949 = "Maxell module with BlueCore in DFU mode" */
    'M','a','x','e','l','l',' ','m','o','d','u','l','e',' ','\x98','B','l','u','e','C','o','r','e',' ','i','n',' ','D','F','U',' ','m','o','d','e',
/* 0x0796c = "Globetrotter HSUPA Modem (aka icon 451)" */
    'G','l','o','b','e','t','r','o','t','t','e','r',' ','H','S','U','P','A',' ','\x1c',' ','(','a','k','a',' ','i','c','o','n',' ','4','5','1',')',
/* 0x0798f = "stk525 sample firmware (microphone)" */
    's','t','k','5','2','5',' ','s','a','m','p','l','e',' ','f','i','r','m','w','a','r','e',' ','(','m','i','c','r','o','p','h','o','n','e',')',
/* 0x079b2 = "DTH-2200 [Cintiq 22HD Touch] tablet" */
    'D','T','H','-','2','2','0','0',' ','[','C','i','n','t','i','q',' ','2','2','H','D',' ','T','o','u','c','h',']',' ','t','a','b','l','e','t',
/* 0x079d5 = "AirPlus G DWL-G122 Wireless Adapter(rev.A2) [Intersil ISL3887]" */
    'A','i','r','P','l','u','s',' ','G',' ','D','W','L','-','G','1','2','2',' ','\x01','\xbb','A','2',')',' ','[','\xb0','I','S','L','3','8','8','7',']',
/* 0x079f8 = "Intelligent Usb Dmx Interface SIUDI6 Firmware download" */
    '\xe0','U','s','b',' ','D','m','x',' ','\x81',' ','S','I','U','D','I','6',' ','F','i','r','m','w','a','r','e',' ','d','o','w','n','l','o','a','d',
/* 0x07a1b = "8055 Experiment Interface Board (address=3)" */
    '8','0','5','5',' ','E','x','p','e','r','i','m','e','n','t',' ','\x81',' ','B','o','a','r','d',' ','(','a','d','d','r','e','s','s','=','3',')',
/* 0x07a3e = "M110 corded optical mouse (M-B0001)" */
    'M','1','1','0',' ','c','o','r','d','e','d',' ','o','p','t','i','c','a','l',' ','m','o','u','s','e',' ','(','M','-','B','0','0','0','1',')',
/* 0x07a61 = "Compro Videomate DVB-U2000 - DVB-T USB cold" */
    'C','o','m','p','r','o',' ','V','i','d','e','o','m','a','t','e',' ','\xa7','U','2','0','0','0',' ','-',' ','\xa7','T',' ','\x0a',' ','c','o','l','d',
/* 0x07a84 = "Housedillon.com MRF49XA Transciever" */
    'H','o','u','s','e','d','i','l','l','o','n','.','c','o','m',' ','M','R','F','4','9','X','A',' ','T','r','a','n','s','c','i','e','v','e','r',
/* 0x07aa7 = "US Interface Navigator (CAT and 2nd PTT lines)" */
    'U','S',' ','\x81',' ','N','a','v','i','g','a','t','o','r',' ','(','C','A','T',' ','\xe4','2','n','d',' ','P','T','T',' ','l','i','n','e','s',')',
/* 0x07aca = "RZ07-0074 Gaming Keypad [Orbweaver]" */
    'R','Z','0','7','-','0','0','7','4',' ','G','a','m','i','n','g',' ','K','e','y','p','a','d',' ','[','O','r','b','w','e','a','v','e','r',']',
/* 0x07aed = "My Cinema U3000 Mini [DiBcom DiB7700P]" */
    'M','y',' ','C','i','n','e','m','a',' ','U','3','0','0','0',' ','\xb9',' ','[','D','i','B','c','o','m',' ','D','i','B','7','7','0','0','P',']',
/* 0x07b10 = "CY7C68300A EZ-USB AT2 USB 2.0 to ATA/ATAPI" */
    'C','Y','7','C','6','8','3','0','0','A',' ','E','Z','-','\x0a',' ','A','T','2',' ','\x0a',' ','\xc1','t','o',' ','A','T','A','/','A','T','A','P','I',
/* 0x07b33 = "External Hard Drive HD-PCTU3 [Buffalo MiniStation]" */
    '\xe3','H','a','r','d',' ','\x14',' ','H','D','-','P','C','T','U','3',' ','[','B','u','f','f','a','l','o',' ','\xb9','S','t','a','t','i','o','n',']',
/* 0x07b56 = "EntropyKing Random Number Generator" */
    'E','n','t','r','o','p','y','K','i','n','g',' ','R','a','n','d','o','m',' ','N','u','m','b','e','r',' ','G','e','n','e','r','a','t','o','r',
/* 0x07b79 = "8055 Experiment Interface Board (address=0)" */
    '8','0','5','5',' ','E','x','p','e','r','i','m','e','n','t',' ','\x81',' ','B','o','a','r','d',' ','(','a','d','d','r','e','s','s','=','0',')',
/* 0x07b9c = "PICkit 2 Microcontroller Programmer" */
    'P','I','C','k','i','t',' ','2',' ','M','i','c','r','o','c','o','n','t','r','o','l','l','e','r',' ','P','r','o','g','r','a','m','m','e','r',
/* 0x07bbf = "Generic Universal Protocol Analyzer" */
    'G','e','n','e','r','i','c',' ','U','n','i','v','e','r','s','a','l',' ','P','r','o','t','o','c','o','l',' ','A','n','a','l','y','z','e','r',
/* 0x07be2 = "ViperBoard I2C, SPI, GPIO interface" */
    'V','i','p','e','r','B','o','a','r','d',' ','I','2','C',',',' ','S','P','I',',',' ','G','P','I','O',' ','i','n','t','e','r','f','a','c','e',
/* 0x07c05 = "OfficeJet Pro L7300 / Compaq LA2405 series monitor" */
    '\xd3','\x80','\x8f',' ','L','7','3','0','0',' ','/',' ','C','o','m','p','a','q',' ','L','A','2','4','0','5',' ','\x1d',' ','m','o','n','i','t','o','r',
/* 0x07c28 = "LPHD250-U [Portable Hard Drive Silver Series 250 Go]" */
    'L','P','H','D','2','5','0','-','U',' ','[','\xa9','H','a','r','d',' ','\x14',' ','S','i','l','v','e','r',' ','\xbf',' ','2','5','0',' ','G','o',']',
/* 0x07c4b = "AirPlus G DWL-G122 Wireless Adapter(rev.C1) [Ralink RT2571W]" */
    'A','i','r','P','l','u','s',' ','G',' ','D','W','L','-','G','1','2','2',' ','\x01','\xbb','C','1',')',' ','[','\x93','R','T','2','5','7','1','W',']',
/* 0x07c6e = "X-Keys Switch Interface, SPLAT Mode" */
    'X','-','K','e','y','s',' ','S','w','i','t','c','h',' ','I','n','t','e','r','f','a','c','e',',',' ','S','P','L','A','T',' ','M','o','d','e',
/* 0x07c91 = "dilitronics ESoLUX solar lighting controller" */
    'd','i','l','i','t','r','o','n','i','c','s',' ','E','S','o','L','U','X',' ','s','o','l','a','r',' ','l','i','g','h','t','i','n','g',' ','\x9e',
/* 0x07cb4 = "Liquid Gallant Duo E350 (preloader)" */
    'L','i','q','u','i','d',' ','G','a','l','l','a','n','t',' ','D','u','o',' ','E','3','5','0',' ','(','p','r','e','l','o','a','d','e','r',')',
/* 0x07cd7 = "iPAQ Networking 10/100 Ethernet [pegasus2]" */
    'i','P','A','Q',' ','N','e','t','w','o','r','k','i','n','g',' ','1','0','/','1','0','0',' ','\x7f',' ','[','p','e','g','a','s','u','s','2',']',
/* 0x07cfa = "Lite Metals & Plastic (Shenzhen) Co., Ltd." */
    'L','i','t','e',' ','M','e','t','a','l','s',' ','&',' ','P','l','a','s','t','i','c',' ','(','S','h','e','n','z','h','e','n',')',' ','\x0e','\xab',
/* 0x07d1d = "Wireless 5700 Mobile Broadband (CDMA EV-DO) Expresscard Modem" */
    '\x01','5','7','0','0',' ','\x96',' ','\xb7','(','C','D','M','A',' ','E','V','-','D','O',')',' ','E','x','p','r','e','s','s','c','a','r','d',' ','\x1c',
/* 0x07d40 = "PC Camera with Microphone (SN9C202 + S5K53BEB)" */
    '\x1f','\x04',' ','\x98','M','i','c','r','o','p','h','o','n','e',' ','(','S','N','9','C','2','0','2',' ','+',' ','S','5','K','5','3','B','E','B',')',
/* 0x07d63 = "at90usbkey sample firmware (HID mouse)" */
    'a','t','9','0','u','s','b','k','e','y',' ','s','a','m','p','l','e',' ','f','i','r','m','w','a','r','e',' ','(','\xf2','m','o','u','s','e',')',
/* 0x07d86 = "ReMOTE Audio/XStation First Edition" */
    'R','e','M','O','T','E',' ','A','u','d','i','o','/','X','S','t','a','t','i','o','n',' ','F','i','r','s','t',' ','E','d','i','t','i','o','n',
/* 0x07da9 = "Werlisa Sport PX 100 / JVC GC-A33 Camera" */
    'W','e','r','l','i','s','a',' ','S','p','o','r','t',' ','P','X',' ','1','0','0',' ','/',' ','J','V','C',' ','G','C','-','A','3','3',' ','\x04',
/* 0x07dcc = "WOW Uninterruptible Power Supply (HID PDC)" */
    'W','O','W',' ','U','n','i','n','t','e','r','r','u','p','t','i','b','l','e',' ','\x24',' ','S','u','p','p','l','y',' ','(','\xf2','P','D','C',')',
/* 0x07def = "Psion WaveFinder DAB radio receiver" */
    'P','s','i','o','n',' ','W','a','v','e','F','i','n','d','e','r',' ','D','A','B',' ','r','a','d','i','o',' ','r','e','c','e','i','v','e','r',
/* 0x07e12 = "PX-602F [Stylus Office BX610FW/TX620FW Series]" */
    'P','X','-','6','0','2','F',' ','[','\xb1','\xd3',' ','B','X','6','1','0','F','W','/','T','X','6','2','0','F','W',' ','S','e','r','i','e','s',']',
/* 0x07e35 = "i.MX50 SystemOnChip in RecoveryMode" */
    'i','.','M','X','5','0',' ','S','y','s','t','e','m','O','n','C','h','i','p',' ','i','n',' ','R','e','c','o','v','e','r','y','M','o','d','e',
/* 0x07e58 = "Acer Peripherals Inc. (now BenQ Corp.)" */
    'A','c','e','r',' ','P','e','r','i','p','h','e','r','a','l','s',' ','\x07',' ','(','n','o','w',' ','B','e','n','Q',' ','C','o','r','p','.',')',
/* 0x07e7b = "MM004V5 Photo Key Chain (Digital Photo Frame) 1.5"" */
    'M','M','0','0','4','V','5',' ','\x86',' ','K','e','y',' ','C','h','a','i','n',' ','(','\x09','\x86',' ','F','r','a','m','e',')',' ','1','.','5','"',
/* 0x07e9e = "Total Phase Aardvark I2C/SPI Host Adapter" */
    'T','o','t','a','l',' ','P','h','a','s','e',' ','A','a','r','d','v','a','r','k',' ','I','2','C','/','S','P','I',' ','H','o','s','t',' ','\x02',
/* 0x07ec1 = "LAN-TX/U1H2 10/100 Ethernet Adapter [pegasus II]" */
    'L','A','N','-','T','X','/','U','1','H','2',' ','1','0','/','1','0','0',' ','\x7f',' ','\x02',' ','[','p','e','g','a','s','u','s',' ','I','I',']',
/* 0x07ee4 = "PowerShot SD700 IS / Digital IXUS 800 IS / IXY Digital 800 IS" */
    '\x24','\x84','S','D','7','0','0',' ','I','S',' ','/',' ','\x09','\xfd','8','0','0',' ','I','S',' ','/',' ','I','X','Y',' ','\x09','8','0','0',' ','I','S',
/* 0X07f07 = "SMDK2443 u-boot usbtty CDC ACM mode" */
    'M','D','K','2','4','4','3',' ','u','-','b','o','o','t',' ','u','s','b','t','t','y',' ','C','D','C',' ','A','C','M',' ','m','o','d','e',
/* 0x07f29 = "AirPlus G DWL-G122 Wireless Adapter(rev.A1) [Intersil ISL3880]" */
    'A','i','r','P','l','u','s',' ','G',' ','D','W','L','-','G','1','2','2',' ','\x01','\xbb','A','1',')',' ','[','\xb0','I','S','L','3','8','8','0',']',
/* 0x07f4c = "WG111(v1) rev 2 54 Mbps Wireless [Intersil ISL3887]" */
    'W','G','1','1','1','(','v','1',')',' ','r','e','v',' ','2',' ','5','4',' ','M','b','p','s',' ','\x01','[','\xb0','I','S','L','3','8','8','7',']',
/* 0x07f6f = "RedOctane Drum Kit for PlayStation(R)3" */
    'R','e','d','O','c','t','a','n','e',' ','D','r','u','m',' ','K','i','t',' ','\xcc','P','l','a','y','S','t','a','t','i','o','n','(','R',')','3',
/* 0x07f92 = "Intelligent Usb Dmx Interface SIUDI7 Firmware Download" */
    '\xe0','U','s','b',' ','D','m','x',' ','\x81',' ','S','I','U','D','I','7',' ','F','i','r','m','w','a','r','e',' ','D','o','w','n','l','o','a','d',
/* 0x07fb5 = "LUFA Combined Mass Storage and Keyboard Demo Application" */
    'L','U','F','A',' ','C','o','m','b','i','n','e','d',' ','\x7c','\x0f','\xe4','\x05',' ','D','e','m','o',' ','A','p','p','l','i','c','a','t','i','o','n',
/* 0x07fd8 = "I.A.C. Geometrische Ingenieurs B.V." */
    'I','.','A','.','C','.',' ','G','e','o','m','e','t','r','i','s','c','h','e',' ','I','n','g','e','n','i','e','u','r','s',' ','B','.','V','.',
/* 0x07ffb = "Sony UWA-BR100 802.11abgn Wireless Adapter [Atheros AR7010+AR9280]" */
    'S','o','n','y',' ','U','W','A','-','B','R','1','0','0',' ','\xea','\x01','\x02',' ','[','\xaf','A','R','7','0','1','0','+','A','R','9','2','8','0',']',
/* 0x0801e = "Alea I True Random Number Generator" */
    'A','l','e','a',' ','I',' ','T','r','u','e',' ','R','a','n','d','o','m',' ','N','u','m','b','e','r',' ','G','e','n','e','r','a','t','o','r',
/* 0x08041 = "ORGA 900 Smart Card Terminal Virtual Com Port" */
    'O','R','G','A',' ','9','0','0',' ','\x12',' ','\x15',' ','T','e','r','m','i','n','a','l',' ','V','i','r','t','u','a','l',' ','C','o','m',' ','\x87',
/* 0x08064 = "Fashion Cam Dual-Mode DSC (Controller)" */
    'F','a','s','h','i','o','n',' ','\x9a','D','u','a','l','-','M','o','d','e',' ','D','S','C',' ','(','C','o','n','t','r','o','l','l','e','r',')',
/* 0x08087 = "Fujitsu F01/ Lifebook U810 [R5U870]" */
    'F','u','j','i','t','s','u',' ','F','0','1','/',' ','L','i','f','e','b','o','o','k',' ','U','8','1','0',' ','[','R','5','U','8','7','0',']',
/* 0x080aa = "Welch Allyn, Inc - Medical Division" */
    'W','e','l','c','h',' ','A','l','l','y','n',',',' ','I','n','c',' ','-',' ','M','e','d','i','c','a','l',' ','D','i','v','i','s','i','o','n',
/* 0x080cd = "DT9816 ECON data acquisition module" */
    'D','T','9','8','1','6',' ','E','C','O','N',' ','d','a','t','a',' ','a','c','q','u','i','s','i','t','i','o','n',' ','m','o','d','u','l','e',
/* 0x080f0 = "LUFA Combined Mouse and Keyboard Demo Application" */
    'L','U','F','A',' ','C','o','m','b','i','n','e','d',' ','\x0b',' ','\xe4','\x05',' ','D','e','m','o',' ','A','p','p','l','i','c','a','t','i','o','n',
/* 0x08113 = "Cryptech.is random number generator" */
    'C','r','y','p','t','e','c','h','.','i','s',' ','r','a','n','d','o','m',' ','n','u','m','b','e','r',' ','g','e','n','e','r','a','t','o','r',
/* 0x08136 = "8055 Experiment Interface Board (address=2)" */
    '8','0','5','5',' ','E','x','p','e','r','i','m','e','n','t',' ','\x81',' ','B','o','a','r','d',' ','(','a','d','d','r','e','s','s','=','2',')',
/* 0x08159 = "TigerBird BMP837 USB2.0 WDM Encoder" */
    'T','i','g','e','r','B','i','r','d',' ','B','M','P','8','3','7',' ','U','S','B','2','.','0',' ','W','D','M',' ','E','n','c','o','d','e','r',
/* 0x0817c = "E2530 / GT-C3350 Phones (Mass storage mode)" */
    'E','2','5','3','0',' ','/',' ','G','T','-','C','3','3','5','0',' ','P','h','o','n','e','s',' ','(','\x7c','s','t','o','r','a','g','e',' ','\x1a',
/* 0x0819f = "ME OFFICE 940FW Series/Stylus Office BX630FW Series" */
    'M','E',' ','O','F','F','I','C','E',' ','9','4','0','F','W',' ','S','e','r','i','e','s','/','\xb1','\xd3',' ','B','X','6','3','0','F','W',' ','\xbf',
/* 0x081c2 = "DTH-2400 [Cintiq 24HD touch] tablet" */
    'D','T','H','-','2','4','0','0',' ','[','C','i','n','t','i','q',' ','2','4','H','D',' ','t','o','u','c','h',']',' ','t','a','b','l','e','t',
/* 0x081e5 = "F5D9050 Wireless G+ MIMO Network Adapter v3000 [Ralink RT2573]" */
    'F','5','D','9','0','5','0',' ','\x01','G','+',' ','M','I','M','O',' ','\x8d','\x02',' ','v','3','0','0','0',' ','[','\x93','R','T','2','5','7','3',']',
/* 0x08208 = "D-Wave 2GB MP4 Player / AK1025 MP3/MP4 Player" */
    'D','-','W','a','v','e',' ','2','G','B',' ','M','P','4',' ','\x1e',' ','/',' ','A','K','1','0','2','5',' ','M','P','3','/','M','P','4',' ','\x1e',
/* 0x0822b = "F5D9050 Wireless G+ MIMO Network Adapter v4000 [Ralink RT2573]" */
    'F','5','D','9','0','5','0',' ','\x01','G','+',' ','M','I','M','O',' ','\x8d','\x02',' ','v','4','0','0','0',' ','[','\x93','R','T','2','5','7','3',']',
/* 0x0824e = "EUB1200AC AC1200 DB Wireless Adapter [Realtek RTL8812AU]" */
    'E','U','B','1','2','0','0','A','C',' ','A','C','1','2','0','0',' ','D','B',' ','\x01','\x02',' ','[','\xbe','R','T','L','8','8','1','2','A','U',']',
/* 0x08271 = "SMDK2440 u-boot usbtty CDC ACM mode" */
    'S','M','D','K','2','4','4','0',' ','u','-','b','o','o','t',' ','u','s','b','t','t','y',' ','C','D','C',' ','A','C','M',' ','m','o','d','e',
/* 0x08294 = "Macareux-labs Usbce Bootloader mode" */
    'M','a','c','a','r','e','u','x','-','l','a','b','s',' ','U','s','b','c','e',' ','B','o','o','t','l','o','a','d','e','r',' ','m','o','d','e',
/* 0x082b7 = "PC Camera with Microphone (SN9C202 + S5K4AAFX)" */
    '\x1f','\x04',' ','\x98','M','i','c','r','o','p','h','o','n','e',' ','(','S','N','9','C','2','0','2',' ','+',' ','S','5','K','4','A','A','F','X',')',
/* 0x082da = "License Management and Copy Protection" */
    'L','i','c','e','n','s','e',' ','M','a','n','a','g','e','m','e','n','t',' ','\xe4','C','o','p','y',' ','P','r','o','t','e','c','t','i','o','n',
/* 0x082fd = "Compro Videomate DVB-U2000 - DVB-T USB warm" */
    'C','o','m','p','r','o',' ','V','i','d','e','o','m','a','t','e',' ','\xa7','U','2','0','0','0',' ','-',' ','\xa7','T',' ','\x0a',' ','w','a','r','m',
/* 0x08320 = "E398 LTE/UMTS/GSM Modem/Networkcard" */
    'E','3','9','8',' ','L','T','E','/','U','M','T','S','/','G','S','M',' ','M','o','d','e','m','/','N','e','t','w','o','r','k','c','a','r','d',
/* 0x08343 = "Chipsbrand Microelectronics (HK) Co., Ltd." */
    'C','h','i','p','s','b','r','a','n','d',' ','M','i','c','r','o','e','l','e','c','t','r','o','n','i','c','s',' ','(','H','K',')',' ','\x0e','\xab',
/* 0x08366 = "WG111v3 54 Mbps Wireless [realtek RTL8187B]" */
    'W','G','1','1','1','v','3',' ','5','4',' ','M','b','p','s',' ','\x01','[','r','e','a','l','t','e','k',' ','R','T','L','8','1','8','7','B',']',
/* 0x08389 = "BOSS GT-10 Guitar Effects Processor" */
    'B','O','S','S',' ','G','T','-','1','0',' ','G','u','i','t','a','r',' ','E','f','f','e','c','t','s',' ','P','r','o','c','e','s','s','o','r',
/* 0x083ac = "Datalogic Gryphon GFS4170 (config mode)" */
    'D','a','t','a','l','o','g','i','c',' ','G','r','y','p','h','o','n',' ','G','F','S','4','1','7','0',' ','(','c','o','n','f','i','g',' ','\x1a',
/* 0x083cf = "F5D7050 Wireless G Adapter v1000/v2000 [Intersil ISL3887]" */
    'F','5','D','7','0','5','0',' ','\x01','G',' ','\x02',' ','v','1','0','0','0','/','v','2','0','0','0',' ','[','\xb0','I','S','L','3','8','8','7',']',
/* 0x083f2 = "i.MX28 SystemOnChip in RecoveryMode" */
    'i','.','M','X','2','8',' ','S','y','s','t','e','m','O','n','C','h','i','p',' ','i','n',' ','R','e','c','o','v','e','r','y','M','o','d','e',
/* 0x08415 = "SG3WA1/74 802.11b WLAN Adapter [Atmel AT76C503A]" */
    'S','G','3','W','A','1','/','7','4',' ','\x9b','W','L','A','N',' ','\x02',' ','[','A','t','m','e','l',' ','A','T','7','6','C','5','0','3','A',']',
/* 0x08438 = "Teleprompter Two-button Hand Control (v1)" */
    'T','e','l','e','p','r','o','m','p','t','e','r',' ','T','w','o','-','b','u','t','t','o','n',' ','H','a','n','d',' ','\xc9',' ','(','v','1',')',
/* 0x0845b = "WG111v2 54 Mbps Wireless [RealTek RTL8187L]" */
    'W','G','1','1','1','v','2',' ','5','4',' ','M','b','p','s',' ','\x01','[','R','e','a','l','T','e','k',' ','R','T','L','8','1','8','7','L',']',
/* 0x0847e = "FRITZ WLAN N v2 [RT5572/rt2870.bin]" */
    'F','R','I','T','Z',' ','W','L','A','N',' ','N',' ','v','2',' ','[','R','T','5','5','7','2','/','r','t','2','8','7','0','.','b','i','n',']',
/* 0x084a1 = "8055 Experiment Interface Board (address=1)" */
    '8','0','5','5',' ','E','x','p','e','r','i','m','e','n','t',' ','\x81',' ','B','o','a','r','d',' ','(','a','d','d','r','e','s','s','=','1',')',
/* 0x084c4 = "WNA1000Mv2 802.11bgn [Realtek RTL8188CUS?]" */
    'W','N','A','1','0','0','0','M','v','2',' ','8','0','2','.','1','1','b','g','n',' ','[','\xbe','R','T','L','8','1','8','8','C','U','S','?',']',
/* 0x084e7 = "HJ-720IT / HEM-7080IT-E / HEM-790IT" */
    'H','J','-','7','2','0','I','T',' ','/',' ','H','E','M','-','7','0','8','0','I','T','-','E',' ','/',' ','H','E','M','-','7','9','0','I','T',
/* 0x0850a = "Bestmedia CD Recordable GmbH & Co. KG" */
    'B','e','s','t','m','e','d','i','a',' ','C','D',' ','R','e','c','o','r','d','a','b','l','e',' ','\xfc',' ','&',' ','C','o','.',' ','K','G',
/* 0x0852c = "NEC NP01LM 802.11abg Wireless Adapter [Ralink RT2571W]" */
    'N','E','C',' ','N','P','0','1','L','M',' ','8','0','2','.','1','1','a','b','g',' ','\x01','\x02',' ','[','\x93','R','T','2','5','7','1','W',']',
/* 0x0854e = "Mju Mini Digital/Mju Digital 500 Camera / Stylus 850 SW" */
    'M','j','u',' ','\xb9',' ','D','i','g','i','t','a','l','/','M','j','u',' ','\x09','5','0','0',' ','\x04',' ','/',' ','\xb1','8','5','0',' ','S','W',
/* 0x08570 = "Great Scott Gadgets HackRF One SDR" */
    'G','r','e','a','t',' ','S','c','o','t','t',' ','G','a','d','g','e','t','s',' ','H','a','c','k','R','F',' ','O','n','e',' ','S','D','R',
/* 0x08592 = "TEMPerHUM Temperature & Humidity Sensor" */
    'T','E','M','P','e','r','H','U','M',' ','T','e','m','p','e','r','a','t','u','r','e',' ','&',' ','H','u','m','i','d','i','t','y',' ','\xac',
/* 0x085b4 = "Harmonix Drum Kit for PlayStation(R)3" */
    'H','a','r','m','o','n','i','x',' ','D','r','u','m',' ','K','i','t',' ','\xcc','P','l','a','y','S','t','a','t','i','o','n','(','R',')','3',
/* 0x085d6 = "D60 digital camera (mass storage mode)" */
    'D','6','0',' ','d','i','g','i','t','a','l',' ','c','a','m','e','r','a',' ','(','m','a','s','s',' ','s','t','o','r','a','g','e',' ','\x1a',
/* 0x085f8 = "Kodak Personal Picture Maker 200 Printer" */
    'K','o','d','a','k',' ','P','e','r','s','o','n','a','l',' ','P','i','c','t','u','r','e',' ','M','a','k','e','r',' ','2','0','0',' ','\x0c',
/* 0x0861a = "G430 Surround Sound Gaming Headset" */
    'G','4','3','0',' ','S','u','r','r','o','u','n','d',' ','S','o','u','n','d',' ','G','a','m','i','n','g',' ','H','e','a','d','s','e','t',
/* 0x0863c = "Fujitsu Laboratories of America, Inc." */
    'F','u','j','i','t','s','u',' ','L','a','b','o','r','a','t','o','r','i','e','s',' ','o','f',' ','A','m','e','r','i','c','a',',',' ','\x07',
/* 0x0865e = "CDRW64892EXT3-C CD-RW 52x24x52x External Drive" */
    'C','D','R','W','6','4','8','9','2','E','X','T','3','-','C',' ','C','D','-','R','W',' ','5','2','x','2','4','x','5','2','x',' ','\xe3','\x14',
/* 0x08680 = "Linux-USB user-mode bulk source/sink" */
    'L','i','n','u','x','-','\x0a',' ','u','s','e','r','-','m','o','d','e',' ','b','u','l','k',' ','s','o','u','r','c','e','/','s','i','n','k',
/* 0x086a2 = "OnlyDisk U208 1G flash drive [U-SAFE]" */
    'O','n','l','y','\xe8',' ','U','2','0','8',' ','1','G',' ','f','l','a','s','h',' ','d','r','i','v','e',' ','[','U','-','S','A','F','E',']',
/* 0x086c4 = "SXV interface for paraller MX cameras" */
    'S','X','V',' ','i','n','t','e','r','f','a','c','e',' ','\xcc','p','a','r','a','l','l','e','r',' ','M','X',' ','c','a','m','e','r','a','s',
/* 0x086e6 = "Memory Stick PRO-HG Duo Adaptor (MSAC-UAH1)" */
    '\xd2',' ','\xb3',' ','P','R','O','-','H','G',' ','D','u','o',' ','A','d','a','p','t','o','r',' ','(','M','S','A','C','-','U','A','H','1',')',
/* 0x08708 = "GT-F500/GT-F550 [Perfection 2480/2580 PHOTO]" */
    'G','T','-','F','5','0','0','/','G','T','-','F','5','5','0',' ','[','\xf0','2','4','8','0','/','2','5','8','0',' ','P','H','O','T','O',']',
/* 0x0872a = "Nanosira4-EDR WHQL Reference Radio" */
    'N','a','n','o','s','i','r','a','4','-','E','D','R',' ','W','H','Q','L',' ','R','e','f','e','r','e','n','c','e',' ','R','a','d','i','o',
/* 0x0874c = "West Mountain Radio RIGblaster P&P" */
    'W','e','s','t',' ','M','o','u','n','t','a','i','n',' ','R','a','d','i','o',' ','R','I','G','b','l','a','s','t','e','r',' ','P','&','P',
/* 0x0876e = "T-Com Sinus 154 data II [Intersil ISL3887]" */
    'T','-','C','o','m',' ','S','i','n','u','s',' ','1','5','4',' ','d','a','t','a',' ','I','I',' ','[','\xb0','I','S','L','3','8','8','7',']',
/* 0x08790 = "ASUS Zenfone GO (ZB500KL) (RNDIS mode)" */
    'A','S','U','S',' ','Z','e','n','f','o','n','e',' ','G','O',' ','(','Z','B','5','0','0','K','L',')',' ','(','R','N','D','I','S',' ','\x1a',
/* 0x087b2 = "Dynalink WLL013 / Compex WLU11A 802.11b Adapter" */
    'D','y','n','a','l','i','n','k',' ','W','L','L','0','1','3',' ','/',' ','C','o','m','p','e','x',' ','W','L','U','1','1','A',' ','\x9b','\x02',
/* 0x087d4 = "OpenMoko Neo1973 Debug board (V2+)" */
    'O','p','e','n','M','o','k','o',' ','N','e','o','1','9','7','3',' ','D','e','b','u','g',' ','b','o','a','r','d',' ','(','V','2','+',')',
/* 0x087f6 = "FT2232D - Dual UART/FIFO IC - FTDI" */
    'F','T','2','2','3','2','D',' ','-',' ','D','u','a','l',' ','U','A','R','T','/','F','I','F','O',' ','I','C',' ','-',' ','F','T','D','I',
/* 0x08818 = "FT2232H Hi-Speed JTAG ICE [gnICE+]" */
    'F','T','2','2','3','2','H',' ','H','i','-','S','p','e','e','d',' ','J','T','A','G',' ','I','C','E',' ','[','g','n','I','C','E','+',']',
/* 0x0883a = "PC Camera with Microphone (SN9C202 + HV7131R)" */
    '\x1f','\x04',' ','\x98','M','i','c','r','o','p','h','o','n','e',' ','(','S','N','9','C','2','0','2',' ','+',' ','H','V','7','1','3','1','R',')',
/* 0x0885c = "Counterfeit flash drive [Kingston]" */
    'C','o','u','n','t','e','r','f','e','i','t',' ','f','l','a','s','h',' ','d','r','i','v','e',' ','[','K','i','n','g','s','t','o','n',']',
/* 0x0887e = "HP PR1101U / Primax PMX-KPR1101U Keyboard" */
    'H','P',' ','P','R','1','1','0','1','U',' ','/',' ','P','r','i','m','a','x',' ','P','M','X','-','K','P','R','1','1','0','1','U',' ','\x05',
/* 0x088a0 = "Airlink101 AWLL4130 802.11bg Wireless Adapter [Atheros AR5523]" */
    'A','i','r','l','i','n','k','1','0','1',' ','A','W','L','L','4','1','3','0',' ','\xad',' ','\x01','\x02',' ','[','\xaf','A','R','5','5','2','3',']',
/* 0x088c2 = "Audiotrak DR.DAC2 DX [GYROCOM C&C]" */
    'A','u','d','i','o','t','r','a','k',' ','D','R','.','D','A','C','2',' ','D','X',' ','[','G','Y','R','O','C','O','M',' ','C','&','C',']',
/* 0x088e4 = "DWA-131 802.11n Wireless N Nano Adapter(rev.A1) [Realtek RTL8192SU]" */
    'D','W','A','-','1','3','1',' ','\x99','\x01','N',' ','N','a','n','o',' ','\xbb','A','1',')',' ','[','\xbe','R','T','L','8','1','9','2','S','U',']',
/* 0x08906 = "M-U0004 810-001317 [B110 Optical USB Mouse]" */
    'M','-','U','0','0','0','4',' ','8','1','0','-','0','0','1','3','1','7',' ','[','B','1','1','0',' ','\x7b','\x0a',' ','M','o','u','s','e',']',
/* 0x08928 = "Logicool HID-Compliant Keyboard (106 key)" */
    'L','o','g','i','c','o','o','l',' ','H','I','D','-','C','o','m','p','l','i','a','n','t',' ','\x05',' ','(','1','0','6',' ','k','e','y',')',
/* 0x0894a = "WPNT121 802.11g 240Mbps Wireless Adapter [Airgo AGN300]" */
    'W','P','N','T','1','2','1',' ','\x94','2','4','0','M','b','p','s',' ','\x01','\x02',' ','[','A','i','r','g','o',' ','A','G','N','3','0','0',']',
/* 0x0896c = "WiseGroup Ltd, MP-8800 Quad Joypad" */
    'W','i','s','e','G','r','o','u','p',' ','L','t','d',',',' ','M','P','-','8','8','0','0',' ','Q','u','a','d',' ','J','o','y','p','a','d',
/* 0x0898e = "PT-P700 P-touch Label Printer RemovableDisk" */
    'P','T','-','P','7','0','0',' ','P','-','t','o','u','c','h',' ','L','a','b','e','l',' ','\x0c',' ','R','e','m','o','v','a','b','l','e','\xe8',
/* 0x089b0 = "T20 series mp3/ogg vorbis player (ums firmware)" */
    'T','2','0',' ','\x1d',' ','m','p','3','/','o','g','g',' ','v','o','r','b','i','s',' ','p','l','a','y','e','r',' ','(','u','m','s',' ','\xdb',
/* 0x089d2 = "5 button optical mouse model M873U" */
    '5',' ','b','u','t','t','o','n',' ','o','p','t','i','c','a','l',' ','m','o','u','s','e',' ','m','o','d','e','l',' ','M','8','7','3','U',
/* 0x089f4 = "Eye Movement Recorder [ReadAlyzer]" */
    'E','y','e',' ','M','o','v','e','m','e','n','t',' ','R','e','c','o','r','d','e','r',' ','[','R','e','a','d','A','l','y','z','e','r',']',
/* 0x08a16 = "ZeitControl Cardsystems TagTracer MIFARE" */
    'Z','e','i','t','\xc9',' ','C','a','r','d','s','y','s','t','e','m','s',' ','T','a','g','T','r','a','c','e','r',' ','M','I','F','A','R','E',
/* 0x08a38 = "TouchChip Fingerprint Coprocessor (WBF advanced mode)" */
    '\x9d','C','h','i','p',' ','\x92','C','o','p','r','o','c','e','s','s','o','r',' ','(','W','B','F',' ','a','d','v','a','n','c','e','d',' ','\x1a',
/* 0x08a5a = "WL-349v3 Wireless Micro Adapter 150N X1 [Realtek RTL8192SU]" */
    'W','L','-','3','4','9','v','3',' ','\x01','\xc4',' ','\x02',' ','1','5','0','N',' ','X','1',' ','[','\xbe','R','T','L','8','1','9','2','S','U',']',
/* 0x08a7c = "Pole Display (HP522 2 x 20 Line Display)" */
    'P','o','l','e',' ','\xcf',' ','(','H','P','5','2','2',' ','2',' ','x',' ','2','0',' ','L','i','n','e',' ','D','i','s','p','l','a','y',')',
/* 0x08a9e = "WiseGroup Ltd, MP-8866 Dual Joypad" */
    'W','i','s','e','G','r','o','u','p',' ','L','t','d',',',' ','M','P','-','8','8','6','6',' ','D','u','a','l',' ','J','o','y','p','a','d',
/* 0x08ac0 = "4410b Wireless-G Adapter [ZyDAS ZD1211B]" */
    '4','4','1','0','b',' ','W','i','r','e','l','e','s','s','-','G',' ','\x02',' ','[','Z','y','D','A','S',' ','Z','D','1','2','1','1','B',']',
/* 0x08ae2 = "Camera with CMOS sensor in Vision mode [MQ]" */
    '\x04',' ','\x98','C','M','O','S',' ','s','e','n','s','o','r',' ','i','n',' ','V','i','s','i','o','n',' ','m','o','d','e',' ','[','M','Q',']',
/* 0x08b04 = "USB-6251 (OEM) data acquisition card" */
    '\x0a','-','6','2','5','1',' ','(','O','E','M',')',' ','d','a','t','a',' ','a','c','q','u','i','s','i','t','i','o','n',' ','c','a','r','d',
/* 0x08b26 = "WUSB100 v2 RangePlus Wireless Network Adapter [Ralink RT3070]" */
    'W','U','S','B','1','0','0',' ','v','2',' ','R','a','n','g','e','P','l','u','s',' ','\x01','\x8d','\x02',' ','[','\x93','R','T','3','0','7','0',']',
/* 0x08b48 = "FreeAgent GoFlex Upgrade Cable STAE104" */
    'F','r','e','e','A','g','e','n','t',' ','G','o','F','l','e','x',' ','U','p','g','r','a','d','e',' ','\xa5',' ','S','T','A','E','1','0','4',
/* 0x08b6a = "AirPlus G DWL-G120 Wireless Adapter(rev.C) [Intersil ISL3887]" */
    'A','i','r','P','l','u','s',' ','G',' ','D','W','L','-','G','1','2','0',' ','\x01','\xbb','C',')',' ','[','\xb0','I','S','L','3','8','8','7',']',
/* 0x08b8c = "AUVIO Universal Remote Receiver for PlayStation 3" */
    'A','U','V','I','O',' ','U','n','i','v','e','r','s','a','l',' ','\xcb',' ','\x8c',' ','\xcc','P','l','a','y','S','t','a','t','i','o','n',' ','3',
/* 0x08bae = "Oyen Digital MiniPro 2.5" hard drive enclosure" */
    'O','y','e','n',' ','\x09','\xb9','\x8f',' ','2','.','5','"',' ','h','a','r','d',' ','d','r','i','v','e',' ','e','n','c','l','o','s','u','r','e',
/* 0x08bd0 = "AirPlus G DWL-G122 Wireless Adapter(rev.B1) [Ralink RT2571]" */
    'A','i','r','P','l','u','s',' ','G',' ','D','W','L','-','G','1','2','2',' ','\x01','\xbb','B','1',')',' ','[','\x93','R','T','2','5','7','1',']',
/* 0x08bf2 = "StudioDock monitors (internal hub)" */
    'S','t','u','d','i','o','D','o','c','k',' ','m','o','n','i','t','o','r','s',' ','(','i','n','t','e','r','n','a','l',' ','h','u','b',')',
/* 0x08c14 = "SupraMax 2890 56K Modem [Lucent Atlas]" */
    'S','u','p','r','a','M','a','x',' ','2','8','9','0',' ','5','6','K',' ','\x1c',' ','[','L','u','c','e','n','t',' ','A','t','l','a','s',']',
/* 0x08c36 = "My Book Essential Edition 2.0 (WDH1U)" */
    'M','y',' ','B','o','o','k',' ','E','s','s','e','n','t','i','a','l',' ','E','d','i','t','i','o','n',' ','\xc1','(','W','D','H','1','U',')',
/* 0x08c58 = "Operator Display & Scanner, XiCheck-BA63" */
    'O','p','e','r','a','t','o','r',' ','\xcf',' ','&',' ','S','c','a','n','n','e','r',',',' ','X','i','C','h','e','c','k','-','B','A','6','3',
/* 0x08c7a = "Pro Flight Backlit Information Panel" */
    '\x8f',' ','F','l','i','g','h','t',' ','B','a','c','k','l','i','t',' ','I','n','f','o','r','m','a','t','i','o','n',' ','P','a','n','e','l',
/* 0x08c9c = "AirPlus G DWL-G122 Wireless Adapter(rev.E1) [Ralink RT2070]" */
    'A','i','r','P','l','u','s',' ','G',' ','D','W','L','-','G','1','2','2',' ','\x01','\xbb','E','1',')',' ','[','\x93','R','T','2','0','7','0',']',
/* 0x08cbe = "APB Team Robotic Development Board" */
    'A','P','B',' ','T','e','a','m',' ','R','o','b','o','t','i','c',' ','D','e','v','e','l','o','p','m','e','n','t',' ','B','o','a','r','d',
/* 0x08ce0 = "WUSB100 v1 RangePlus Wireless Network Adapter [Ralink RT2870]" */
    'W','U','S','B','1','0','0',' ','v','1',' ','R','a','n','g','e','P','l','u','s',' ','\x01','\x8d','\x02',' ','[','\x93','R','T','2','8','7','0',']',
/* 0x08d02 = "F5D7050 Wireless G Adapter v4000 [Zydas ZD1211B]" */
    'F','5','D','7','0','5','0',' ','\x01','G',' ','\x02',' ','v','4','0','0','0',' ','[','Z','y','d','a','s',' ','Z','D','1','2','1','1','B',']',
/* 0x08d24 = "Datalogic Magellan 1100i Barcode Scanner" */
    'D','a','t','a','l','o','g','i','c',' ','M','a','g','e','l','l','a','n',' ','1','1','0','0','i',' ','B','a','r','c','o','d','e',' ','\x25',
/* 0x08d46 = "KAOSS Pad KP3 Dynamic Effect/Sampler" */
    'K','A','O','S','S',' ','\xfa',' ','K','P','3',' ','D','y','n','a','m','i','c',' ','E','f','f','e','c','t','/','S','a','m','p','l','e','r',
/* 0x08d68 = "Portable secure storage for software licenses" */
    '\xa9','s','e','c','u','r','e',' ','s','t','o','r','a','g','e',' ','\xcc','s','o','f','t','w','a','r','e',' ','l','i','c','e','n','s','e','s',
/* 0x08d8a = "PowerShot A610 (normal mode)/PowerShot A610 (PTP mode)" */
    '\x24','\x84','A','6','1','0',' ','(','n','o','r','m','a','l',' ','m','o','d','e',')','/','\x24','\x84','A','6','1','0',' ','(','P','T','P',' ','\x1a',
/* 0x08dac = "Datalogic Magellan 1000i Barcode Scanner" */
    'D','a','t','a','l','o','g','i','c',' ','M','a','g','e','l','l','a','n',' ','1','0','0','0','i',' ','B','a','r','c','o','d','e',' ','\x25',
/* 0x08dce = "3000U AccuTouch\u00ae  Touchmonitor Interface" */
    '3','0','0','0','U',' ','A','c','c','u','T','o','u','c','h','\xff','\xc2','\xae',' ',' ','T','o','u','c','h','m','o','n','i','t','o','r',' ','\x81',
/* 0x08df0 = "IT9137FN Dual DVB-T [KWorld UB499-2T]" */
    'I','T','9','1','3','7','F','N',' ','D','u','a','l',' ','\xa7','T',' ','[','K','W','o','r','l','d',' ','U','B','4','9','9','-','2','T',']',
/* 0x08e12 = "SRD00F2 Expansion Desktop Drive (STBV)" */
    'S','R','D','0','0','F','2',' ','E','x','p','a','n','s','i','o','n',' ','D','e','s','k','t','o','p',' ','\x14',' ','(','S','T','B','V',')',
/* 0x08e34 = "LAN9512/LAN9514 Ethernet 10/100 Adapter (SAL10)" */
    'L','A','N','9','5','1','2','/','L','A','N','9','5','1','4',' ','\x7f',' ','1','0','/','1','0','0',' ','\x02',' ','(','S','A','L','1','0',')',
/* 0x08e56 = "Efficient Networks Virtual Bus for ADSL Modem" */
    'E','f','f','i','c','i','e','n','t',' ','N','e','t','w','o','r','k','s',' ','V','i','r','t','u','a','l',' ','B','u','s',' ','\xcc','\xf1','\x1c',
/* 0x08e78 = "Audio4-5410 DSP Data Acquisition Unit" */
    'A','u','d','i','o','4','-','5','4','1','0',' ','D','S','P',' ','\xe7',' ','A','c','q','u','i','s','i','t','i','o','n',' ','U','n','i','t',
/* 0x08e9a = "Clie PEG-N7x0C PalmOS PDA Mass Storage" */
    'C','l','i','e',' ','P','E','G','-','N','7','x','0','C',' ','P','a','l','m','O','S',' ','P','D','A',' ','\x7c','S','t','o','r','a','g','e',
/* 0x08ebc = "ActivIdentity ActivKey SIM USB Token" */
    'A','c','t','i','v','I','d','e','n','t','i','t','y',' ','A','c','t','i','v','K','e','y',' ','S','I','M',' ','\x0a',' ','T','o','k','e','n',
/* 0x08ede = "SDKM Fibres, Wires & Cables Berhad" */
    'S','D','K','M',' ','F','i','b','r','e','s',',',' ','W','i','r','e','s',' ','&',' ','C','a','b','l','e','s',' ','B','e','r','h','a','d',
/* 0x08f00 = "Ubiquiti WiFiStationEXT 802.11n [Atheros AR9271]" */
    'U','b','i','q','u','i','t','i',' ','W','i','F','i','S','t','a','t','i','o','n','E','X','T',' ','\x99','[','\xaf','A','R','9','2','7','1',']',
/* 0x08f22 = "MGTimer - MGCC (Vic) Timing System" */
    'M','G','T','i','m','e','r',' ','-',' ','M','G','C','C',' ','(','V','i','c',')',' ','T','i','m','i','n','g',' ','S','y','s','t','e','m',
/* 0x08f44 = "Android Phone [Fairphone First Edition (FP1)]" */
    '\xce','\x19',' ','[','F','a','i','r','p','h','o','n','e',' ','F','i','r','s','t',' ','E','d','i','t','i','o','n',' ','(','F','P','1',')',']',
/* 0x08f66 = "Sound Blaster Audigy 2 ZS External" */
    'S','o','u','n','d',' ','B','l','a','s','t','e','r',' ','A','u','d','i','g','y',' ','2',' ','Z','S',' ','E','x','t','e','r','n','a','l',
/* 0x08f88 = "HWGUm-54 [Hercules Wireless G Ultra Mini Key]" */
    'H','W','G','U','m','-','5','4',' ','[','H','e','r','c','u','l','e','s',' ','\x01','G',' ','U','l','t','r','a',' ','\xb9',' ','K','e','y',']',
/* 0x08faa = "PhidgetStepper (Under Development)" */
    'P','h','i','d','g','e','t','S','t','e','p','p','e','r',' ','(','U','n','d','e','r',' ','D','e','v','e','l','o','p','m','e','n','t',')',
/* 0x08fcc = "Operator Display & Scanner, XiCheck-BA66" */
    'O','p','e','r','a','t','o','r',' ','\xcf',' ','&',' ','S','c','a','n','n','e','r',',',' ','X','i','C','h','e','c','k','-','B','A','6','6',
/* 0x08fee = "Toshiba WUS-G06G-JT 802.11bg Wireless Adapter [Atheros AR5523]" */
    'T','o','s','h','i','b','a',' ','W','U','S','-','G','0','6','G','-','J','T',' ','\xad',' ','\x01','\x02',' ','[','\xaf','A','R','5','5','2','3',']',
/* 0x09010 = "TA310 - ATSC/NTSC/PAL Driver(PCM4)" */
    'T','A','3','1','0',' ','-',' ','A','T','S','C','/','N','T','S','C','/','P','A','L',' ','D','r','i','v','e','r','(','P','C','M','4',')',
/* 0x09032 = "F7D4101 / F9L1101v1 802.11abgn Wireless Adapter [Broadcom BCM4323]" */
    'F','7','D','4','1','0','1',' ','/',' ','F','9','L','1','1','0','1','v','1',' ','\xea','\x01','\x02',' ','[','\xeb','B','C','M','4','3','2','3',']',
/* 0x09054 = "Dream Cheeky Mailbox Friends Alert" */
    'D','r','e','a','m',' ','C','h','e','e','k','y',' ','M','a','i','l','b','o','x',' ','F','r','i','e','n','d','s',' ','A','l','e','r','t',
/* 0x09076 = "Konig Electronic CMP-KEYPAD12 Numeric Keypad" */
    'K','o','n','i','g',' ','\xba','C','M','P','-','K','E','Y','P','A','D','1','2',' ','N','u','m','e','r','i','c',' ','K','e','y','p','a','d',
/* 0x09098 = "WingMan Extreme Joystick with Throttle" */
    'W','i','n','g','M','a','n',' ','E','x','t','r','e','m','e',' ','J','o','y','s','t','i','c','k',' ','\x98','T','h','r','o','t','t','l','e',
/* 0x090ba = "Ultra-Stik Ultimarc Ultra-Stik Player 1" */
    'U','l','t','r','a','-','S','t','i','k',' ','U','l','t','i','m','a','r','c',' ','U','l','t','r','a','-','S','t','i','k',' ','\x1e',' ','1',
/* 0x090dc = "Trigger UV-002BD[Startech USBVGAE]" */
    'T','r','i','g','g','e','r',' ','U','V','-','0','0','2','B','D','[','S','t','a','r','t','e','c','h',' ','U','S','B','V','G','A','E',']',
/* 0x090fe = "XL-730K / XL-750BK / XL-755BK Mice" */
    'X','L','-','7','3','0','K',' ','/',' ','X','L','-','7','5','0','B','K',' ','/',' ','X','L','-','7','5','5','B','K',' ','M','i','c','e',
/* 0x09120 = "GoMic compact condenser microphone" */
    'G','o','M','i','c',' ','c','o','m','p','a','c','t',' ','c','o','n','d','e','n','s','e','r',' ','m','i','c','r','o','p','h','o','n','e',
/* 0x09142 = "PC Camera with Microphone (SN9C202 + SOI968)" */
    '\x1f','\x04',' ','\x98','M','i','c','r','o','p','h','o','n','e',' ','(','S','N','9','C','2','0','2',' ','+',' ','S','O','I','9','6','8',')',
/* 0x09163 = "Lumidigm Venus fingerprint sensor" */
    'L','u','m','i','d','i','g','m',' ','V','e','n','u','s',' ','f','i','n','g','e','r','p','r','i','n','t',' ','s','e','n','s','o','r',
/* 0x09184 = "2216 AccuTouch\u00ae  Touchmonitor Interface" */
    '2','2','1','6',' ','A','c','c','u','T','o','u','c','h','\xff','\xc2','\xae',' ',' ','T','o','u','c','h','m','o','n','i','t','o','r',' ','\x81',
/* 0x091a5 = "at89c5132/c51snd1c DFU bootloader" */
    'a','t','8','9','c','5','1','3','2','/','c','5','1','s','n','d','1','c',' ','D','F','U',' ','b','o','o','t','l','o','a','d','e','r',
/* 0X091c6 = "remote key/mouse/storage for P3 chip" */
    'e','m','o','t','e',' ','k','e','y','/','m','o','u','s','e','/','s','t','o','r','a','g','e',' ','\xcc','P','3',' ','c','h','i','p',
/* 0x091e6 = "P-W1G1F12 VER:1 [Macally MegaCam]" */
    'P','-','W','1','G','1','F','1','2',' ','V','E','R',':','1',' ','[','M','a','c','a','l','l','y',' ','M','e','g','a','C','a','m',']',
/* 0x09207 = "RTL8812AU 802.11a/b/g/n/ac WLAN Adapter" */
    'R','T','L','8','8','1','2','A','U',' ','8','0','2','.','1','1','a','/','b','/','g','/','n','/','a','c',' ','W','L','A','N',' ','\x02',
/* 0x09228 = "MCS7820/MCS7840 2/4 port serial adapter" */
    'M','C','S','7','8','2','0','/','M','C','S','7','8','4','0',' ','2','/','4',' ','p','o','r','t',' ','s','e','r','i','a','l',' ','\xd0',
/* 0x09249 = "SRD00F2 [Expansion Desktop Drive]" */
    'S','R','D','0','0','F','2',' ','[','E','x','p','a','n','s','i','o','n',' ','D','e','s','k','t','o','p',' ','D','r','i','v','e',']',
/* 0x0926a = "Kawai Musical Instruments Mfg. Co., Ltd" */
    'K','a','w','a','i',' ','M','u','s','i','c','a','l',' ','I','n','s','t','r','u','m','e','n','t','s',' ','M','f','g','.',' ','\x0e','\x16',
/* 0x0928b = "Blackhawk USB560-BP JTAG Emulator" */
    'B','l','a','c','k','h','a','w','k',' ','U','S','B','5','6','0','-','B','P',' ','J','T','A','G',' ','E','m','u','l','a','t','o','r',
/* 0x092ac = "Cambridge Electronic Devices Power1401 mk 2" */
    'C','a','m','b','r','i','d','g','e',' ','\xba','D','e','v','i','c','e','s',' ','P','o','w','e','r','1','4','0','1',' ','m','k',' ','2',
/* 0x092cd = "Live! Cam Socialize HD 1080 [VF0680]" */
    'L','i','v','e','!',' ','\x9a','S','o','c','i','a','l','i','z','e',' ','H','D',' ','1','0','8','0',' ','[','V','F','0','6','8','0',']',
/* 0x092ee = "UPort 1650-16 16-Port RS-232/422/485" */
    'U','P','o','r','t',' ','1','6','5','0','-','1','6',' ','1','6','-','\x87',' ','R','S','-','2','3','2','/','4','2','2','/','4','8','5',
/* 0x0930f = "Toshiba Corp., Digital Media Equipment [hex]" */
    'T','o','s','h','i','b','a',' ','C','o','r','p','.',',',' ','\x09','\xa1',' ','E','q','u','i','p','m','e','n','t',' ','[','h','e','x',']',
/* 0x09330 = "Ningbo Broad Telecommunication Co., Ltd." */
    'N','i','n','g','b','o',' ','B','r','o','a','d',' ','T','e','l','e','c','o','m','m','u','n','i','c','a','t','i','o','n',' ','\x0e','\xab',
/* 0x09351 = "GrauTec ReelBox OLED Display (external)" */
    'G','r','a','u','T','e','c',' ','R','e','e','l','B','o','x',' ','O','L','E','D',' ','\xcf',' ','(','e','x','t','e','r','n','a','l',')',
/* 0x09372 = "XMEGA-A1 Explained evaluation kit" */
    'X','M','E','G','A','-','A','1',' ','E','x','p','l','a','i','n','e','d',' ','e','v','a','l','u','a','t','i','o','n',' ','k','i','t',
/* 0x09393 = "PC Camera with Microphone (SN9C202 + MI1320)" */
    '\x1f','\x04',' ','\x98','M','i','c','r','o','p','h','o','n','e',' ','(','S','N','9','C','2','0','2',' ','+',' ','M','I','1','3','2','0',')',
/* 0x093b4 = "SDCZ2 Cruzer Mini Flash Drive (older, thick)" */
    'S','D','C','Z','2',' ','C','r','u','z','e','r',' ','\xb9',' ','\x3c',' ','\x14',' ','(','o','l','d','e','r',',',' ','t','h','i','c','k',')',
/* 0x093d5 = "CY30700 Licorice evaluation board" */
    'C','Y','3','0','7','0','0',' ','L','i','c','o','r','i','c','e',' ','e','v','a','l','u','a','t','i','o','n',' ','b','o','a','r','d',
/* 0x093f6 = "Avermedia AverTV DVBT USB1.1 (warm)" */
    'A','v','e','r','m','e','d','i','a',' ','A','v','e','r','\xda','D','V','B','T',' ','U','S','B','1','.','1',' ','(','w','a','r','m',')',
/* 0x09417 = "GT-F720 [GT-S620/Perfection V30/V300 Photo]" */
    'G','T','-','F','7','2','0',' ','[','G','T','-','S','6','2','0','/','\xf0','V','3','0','/','V','3','0','0',' ','P','h','o','t','o',']',
/* 0x09438 = "Globetrotter MO40x 3G Modem (GTM 382)" */
    'G','l','o','b','e','t','r','o','t','t','e','r',' ','M','O','4','0','x',' ','3','G',' ','\x1c',' ','(','G','T','M',' ','3','8','2',')',
/* 0x09459 = "Productivity Enhancement Products" */
    'P','r','o','d','u','c','t','i','v','i','t','y',' ','E','n','h','a','n','c','e','m','e','n','t',' ','P','r','o','d','u','c','t','s',
/* 0x0947a = "LPC2378 [Robotino-Arm Bootloader]" */
    'L','P','C','2','3','7','8',' ','[','R','o','b','o','t','i','n','o','-','A','r','m',' ','B','o','o','t','l','o','a','d','e','r',']',
/* 0x0949b = "Che-ez! Snap / iClick Tiny VGA Digital Camera" */
    'C','h','e','-','e','z','!',' ','S','n','a','p',' ','/',' ','i','C','l','i','c','k',' ','T','i','n','y',' ','V','G','A',' ','\x09','\x04',
/* 0x094bc = "SoundBlaster Audigy 2 ZS Video Editor" */
    'S','o','u','n','d','B','l','a','s','t','e','r',' ','A','u','d','i','g','y',' ','2',' ','Z','S',' ','\xa3',' ','E','d','i','t','o','r',
/* 0x094dd = "POS Printer (printer class mode), TH420" */
    'P','O','S',' ','\x0c',' ','(','p','r','i','n','t','e','r',' ','c','l','a','s','s',' ','m','o','d','e',')',',',' ','T','H','4','2','0',
/* 0x094fe = "V20 portable speakers (USB powered)" */
    'V','2','0',' ','p','o','r','t','a','b','l','e',' ','s','p','e','a','k','e','r','s',' ','(','\x0a',' ','p','o','w','e','r','e','d',')',
/* 0x0951f = "PC Camera with Microphone (SN9C202 + ICM107)" */
    '\x1f','\x04',' ','\x98','M','i','c','r','o','p','h','o','n','e',' ','(','S','N','9','C','2','0','2',' ','+',' ','I','C','M','1','0','7',')',
/* 0x09540 = "N5HBZ0000055 802.11abgn Wireless Adapter [Atheros AR7010+AR9280]" */
    'N','5','H','B','Z','0','0','0','0','0','5','5',' ','\xea','\x01','\x02',' ','[','\xaf','A','R','7','0','1','0','+','A','R','9','2','8','0',']',
/* 0x09561 = "PC Camera with Microphone (SN9C202 + OV7663)" */
    '\x1f','\x04',' ','\x98','M','i','c','r','o','p','h','o','n','e',' ','(','S','N','9','C','2','0','2',' ','+',' ','O','V','7','6','6','3',')',
/* 0x09582 = "GT-F730 [GT-S630/Perfection V33/V330 Photo]" */
    'G','T','-','F','7','3','0',' ','[','G','T','-','S','6','3','0','/','\xf0','V','3','3','/','V','3','3','0',' ','P','h','o','t','o',']',
/* 0x095a3 = "Didj UK/France (Leapster Advance)" */
    'D','i','d','j',' ','U','K','/','F','r','a','n','c','e',' ','(','L','e','a','p','s','t','e','r',' ','A','d','v','a','n','c','e',')',
/* 0x095c4 = "40 Character Vacuum Fluorescent Display" */
    '4','0',' ','C','h','a','r','a','c','t','e','r',' ','V','a','c','u','u','m',' ','F','l','u','o','r','e','s','c','e','n','t',' ','\xcf',
/* 0x095e5 = "Thrustmaster Firestorm Digital 3 Gamepad" */
    'T','h','r','u','s','t','m','a','s','t','e','r',' ','F','i','r','e','s','t','o','r','m',' ','\x09','3',' ','G','a','m','e','p','a','d',
/* 0x09606 = "RedOctane Guitar for PlayStation(R)3" */
    'R','e','d','O','c','t','a','n','e',' ','G','u','i','t','a','r',' ','\xcc','P','l','a','y','S','t','a','t','i','o','n','(','R',')','3',
/* 0x09627 = "ADL Flashing Engine AVALON Parent" */
    'A','D','L',' ','F','l','a','s','h','i','n','g',' ','E','n','g','i','n','e',' ','A','V','A','L','O','N',' ','P','a','r','e','n','t',
/* 0x09648 = "PC Camera with Microphone (SN9C202 + MI1300)" */
    '\x1f','\x04',' ','\x98','M','i','c','r','o','p','h','o','n','e',' ','(','S','N','9','C','2','0','2',' ','+',' ','M','I','1','3','0','0',')',
/* 0x09669 = "xu1541 c64 floppy drive interface" */
    'x','u','1','5','4','1',' ','c','6','4',' ','f','l','o','p','p','y',' ','d','r','i','v','e',' ','i','n','t','e','r','f','a','c','e',
/* 0x0968a = "Audio Adapter (Planet UP-100, Genius G-Talk)" */
    '\x8b','\x02',' ','(','P','l','a','n','e','t',' ','U','P','-','1','0','0',',',' ','G','e','n','i','u','s',' ','G','-','T','a','l','k',')',
/* 0x096ab = "EFIS - Electronic Flight Information System" */
    'E','F','I','S',' ','-',' ','\xba','F','l','i','g','h','t',' ','I','n','f','o','r','m','a','t','i','o','n',' ','S','y','s','t','e','m',
/* 0x096cc = "TEW-429UF A1 802.11bg Wireless Adapter [ZyDAS ZD1211B]" */
    'T','E','W','-','4','2','9','U','F',' ','A','1',' ','\xad',' ','\x01','\x02',' ','[','Z','y','D','A','S',' ','Z','D','1','2','1','1','B',']',
/* 0x096ed = "PC Camera with Microphone (SN9C202 + OV9650)" */
    '\x1f','\x04',' ','\x98','M','i','c','r','o','p','h','o','n','e',' ','(','S','N','9','C','2','0','2',' ','+',' ','O','V','9','6','5','0',')',
/* 0x0970e = "Optimus (Various Models) MTP Mode" */
    'O','p','t','i','m','u','s',' ','(','V','a','r','i','o','u','s',' ','M','o','d','e','l','s',')',' ','M','T','P',' ','M','o','d','e',
/* 0x0972f = "Trust 710 LCD POWERC@M ZOOM - MSD" */
    'T','r','u','s','t',' ','7','1','0',' ','L','C','D',' ','P','O','W','E','R','C','@','M',' ','Z','O','O','M',' ','-',' ','M','S','D',
/* 0x09750 = "Van Ooijen Technische Informatica" */
    'V','a','n',' ','O','o','i','j','e','n',' ','T','e','c','h','n','i','s','c','h','e',' ','I','n','f','o','r','m','a','t','i','c','a',
/* 0x09771 = "NVX-P1 Personal Navigation System" */
    'N','V','X','-','P','1',' ','P','e','r','s','o','n','a','l',' ','N','a','v','i','g','a','t','i','o','n',' ','S','y','s','t','e','m',
/* 0x09792 = "SATA 3.0 6Gbit/s Adaptor [GROOVY]" */
    'S','A','T','A',' ','3','.','0',' ','6','G','b','i','t','/','s',' ','A','d','a','p','t','o','r',' ','[','G','R','O','O','V','Y',']',
/* 0x097b3 = "SunplusIT INC. HP Truevision HD Webcam" */
    'S','u','n','p','l','u','s','I','T',' ','I','N','C','.',' ','H','P',' ','T','r','u','e','v','i','s','i','o','n',' ','H','D',' ','\x11',
/* 0x097d4 = "North Shore Circuit Design L.L.P." */
    'N','o','r','t','h',' ','S','h','o','r','e',' ','C','i','r','c','u','i','t',' ','D','e','s','i','g','n',' ','L','.','L','.','P','.',
/* 0x097f5 = "USB-UIRT (Universal Infrared Receiver+Transmitter)" */
    '\x0a','-','U','I','R','T',' ','(','U','n','i','v','e','r','s','a','l',' ','\xa8','\x8c','+','T','r','a','n','s','m','i','t','t','e','r',')',
/* 0x09816 = "PS/2 Keyboard, Mouse & Joystick Ports" */
    'P','S','/','2',' ','K','e','y','b','o','a','r','d',',',' ','\x0b',' ','&',' ','J','o','y','s','t','i','c','k',' ','P','o','r','t','s',
/* 0x09837 = "POS Printer (printer class mode), TH220" */
    'P','O','S',' ','\x0c',' ','(','p','r','i','n','t','e','r',' ','c','l','a','s','s',' ','m','o','d','e',')',',',' ','T','H','2','2','0',
/* 0x09858 = "Avermedia AverTV DVBT USB1.1 (cold)" */
    'A','v','e','r','m','e','d','i','a',' ','A','v','e','r','\xda','D','V','B','T',' ','U','S','B','1','.','1',' ','(','c','o','l','d',')',
/* 0x09879 = "GPS Sport Watch [Runner, Multi-Sport]" */
    'G','P','S',' ','S','p','o','r','t',' ','W','a','t','c','h',' ','[','R','u','n','n','e','r',',',' ','\xd6','-','S','p','o','r','t',']',
/* 0x0989a = "LW313 802.11n Adapter [ralink rt2770 + rt2720]" */
    'L','W','3','1','3',' ','\x99','\x02',' ','[','r','a','l','i','n','k',' ','r','t','2','7','7','0',' ','+',' ','r','t','2','7','2','0',']',
/* 0x098bb = "AVR JTAGICE3 Debugger and Programmer" */
    'A','V','R',' ','J','T','A','G','I','C','E','3',' ','D','e','b','u','g','g','e','r',' ','\xe4','P','r','o','g','r','a','m','m','e','r',
/* 0x098dc = "FORTAT SKYMARK INDUSTRIAL COMPANY" */
    'F','O','R','T','A','T',' ','S','K','Y','M','A','R','K',' ','I','N','D','U','S','T','R','I','A','L',' ','C','O','M','P','A','N','Y',
/* 0x098fd = "QT2410 u-boot usbtty CDC ACM mode" */
    'Q','T','2','4','1','0',' ','u','-','b','o','o','t',' ','u','s','b','t','t','y',' ','C','D','C',' ','A','C','M',' ','m','o','d','e',
/* 0x0991e = "Simple_Way Printer/Scanner/Copier" */
    'S','i','m','p','l','e','_','W','a','y',' ','P','r','i','n','t','e','r','/','S','c','a','n','n','e','r','/','C','o','p','i','e','r',
/* 0x0993f = "Neo1973/FreeRunner Bluetooth Device ID service" */
    'N','e','o','1','9','7','3','/','F','r','e','e','R','u','n','n','e','r',' ','\x06',' ','\x03',' ','I','D',' ','s','e','r','v','i','c','e',
/* 0x09960 = "F5D8053 N Wireless USB Adapter v6000 [Realtek RTL8192SU]" */
    'F','5','D','8','0','5','3',' ','N',' ','\x01','\x0a',' ','\x02',' ','v','6','0','0','0',' ','[','\xbe','R','T','L','8','1','9','2','S','U',']',
/* 0x09981 = "WN-370USB 802.11bgn Wireless Adapter [Realtek RTL8188SU]" */
    'W','N','-','3','7','0','\x0a',' ','8','0','2','.','1','1','b','g','n',' ','\x01','\x02',' ','[','\xbe','R','T','L','8','1','8','8','S','U',']',
/* 0x099a2 = "PL2507 Hi-speed USB to IDE bridge controller" */
    'P','L','2','5','0','7',' ','H','i','-','s','p','e','e','d',' ','\x0a',' ','t','o',' ','I','D','E',' ','b','r','i','d','g','e',' ','\x9e',
/* 0x099c3 = "PC Camera with Microphone (SN9C202 + OV7660)" */
    '\x1f','\x04',' ','\x98','M','i','c','r','o','p','h','o','n','e',' ','(','S','N','9','C','2','0','2',' ','+',' ','O','V','7','6','6','0',')',
/* 0x099e4 = "Biometric Touchchip/Touchstrip Fingerprint Sensor" */
    'B','i','o','m','e','t','r','i','c',' ','T','o','u','c','h','c','h','i','p','/','T','o','u','c','h','s','t','r','i','p',' ','\x92','\xac',
/* 0x09a05 = "wireless receiver for skylanders wii" */
    'w','i','r','e','l','e','s','s',' ','r','e','c','e','i','v','e','r',' ','\xcc','s','k','y','l','a','n','d','e','r','s',' ','w','i','i',
/* 0x09a26 = "Interfaceless Control-Only LUFA Devices" */
    'I','n','t','e','r','f','a','c','e','l','e','s','s',' ','\xc9','-','O','n','l','y',' ','L','U','F','A',' ','D','e','v','i','c','e','s',
/* 0x09a47 = "CDMA 2000 1xRTT USB modem (HX-550C)" */
    'C','D','M','A',' ','2','0','0','0',' ','1','x','R','T','T',' ','\x0a',' ','m','o','d','e','m',' ','(','H','X','-','5','5','0','C',')',
/* 0x09a68 = "Firefly X10i I/O Board (without firmware)" */
    'F','i','r','e','f','l','y',' ','X','1','0','i',' ','I','/','O',' ','B','o','a','r','d',' ','(','w','i','t','h','o','u','t',' ','\xdb',
/* 0x09a89 = "Dongguan White Horse Cable Factory, Ltd" */
    'D','o','n','g','g','u','a','n',' ','W','h','i','t','e',' ','H','o','r','s','e',' ','\xa5',' ','F','a','c','t','o','r','y',',',' ','\x16',
/* 0x09aaa = "Sitecom Internal Multi Memory reader/writer MD-005" */
    'S','i','t','e','c','o','m',' ','\xb4','\xd6',' ','\xd2',' ','r','e','a','d','e','r','/','w','r','i','t','e','r',' ','M','D','-','0','0','5',
/* 0x09acb = "Goldfull Electronics & Telecommunications Corp." */
    'G','o','l','d','f','u','l','l',' ','\x1b',' ','&',' ','T','e','l','e','c','o','m','m','u','n','i','c','a','t','i','o','n','s',' ','\x10',
/* 0x09aec = "AtermITX80D 128K Support Standard" */
    'A','t','e','r','m','I','T','X','8','0','D',' ','1','2','8','K',' ','S','u','p','p','o','r','t',' ','S','t','a','n','d','a','r','d',
/* 0x09b0d = "SideWinder Precision Racing Wheel" */
    'S','i','d','e','W','i','n','d','e','r',' ','P','r','e','c','i','s','i','o','n',' ','R','a','c','i','n','g',' ','W','h','e','e','l',
/* 0x09b2e = "C8051F38x HDMI Extender [UHBX-8X]" */
    'C','8','0','5','1','F','3','8','x',' ','H','D','M','I',' ','E','x','t','e','n','d','e','r',' ','[','U','H','B','X','-','8','X',']',
/* 0x09b4f = "PC Camera with Microphone (SN9C202 + OV9655)" */
    '\x1f','\x04',' ','\x98','M','i','c','r','o','p','h','o','n','e',' ','(','S','N','9','C','2','0','2',' ','+',' ','O','V','9','6','5','5',')',
/* 0x09b70 = "Graphics Operator Display, BA63GV" */
    'G','r','a','p','h','i','c','s',' ','O','p','e','r','a','t','o','r',' ','D','i','s','p','l','a','y',',',' ','B','A','6','3','G','V',
/* 0x09b91 = "SoundBlaster Live! 24-bit External SB0490" */
    'S','o','u','n','d','B','l','a','s','t','e','r',' ','L','i','v','e','!',' ','2','4','-','b','i','t',' ','\xe3','S','B','0','4','9','0',
/* 0x09bb2 = "Clyde Lamp by Fabule (bootloader)" */
    'C','l','y','d','e',' ','L','a','m','p',' ','b','y',' ','F','a','b','u','l','e',' ','(','b','o','o','t','l','o','a','d','e','r',')',
/* 0x09bd3 = "SWISSONIC EasyKeys61 Midikeyboard" */
    'S','W','I','S','S','O','N','I','C',' ','E','a','s','y','K','e','y','s','6','1',' ','M','i','d','i','k','e','y','b','o','a','r','d',
/* 0x09bf4 = "POS Printer (printer class mode), TH210" */
    'P','O','S',' ','\x0c',' ','(','p','r','i','n','t','e','r',' ','c','l','a','s','s',' ','m','o','d','e',')',',',' ','T','H','2','1','0',
/* 0x09c15 = "Model 2253 Audio/Video Codec Card (cold)" */
    'M','o','d','e','l',' ','2','2','5','3',' ','A','u','d','i','o','/','\xa3',' ','C','o','d','e','c',' ','\x15',' ','(','c','o','l','d',')',
/* 0x09c36 = "Realtek Semiconductor Corp., CPP Div. (Avance Logic)" */
    '\xbe','\xc0',' ','C','o','r','p','.',',',' ','C','P','P',' ','D','i','v','.',' ','(','A','v','a','n','c','e',' ','L','o','g','i','c',')',
/* 0x09c57 = "generic (firmware not loaded yet)" */
    'g','e','n','e','r','i','c',' ','(','f','i','r','m','w','a','r','e',' ','n','o','t',' ','l','o','a','d','e','d',' ','y','e','t',')',
/* 0x09c78 = "POS Printer (printer class mode), TH320" */
    'P','O','S',' ','\x0c',' ','(','p','r','i','n','t','e','r',' ','c','l','a','s','s',' ','m','o','d','e',')',',',' ','T','H','3','2','0',
/* 0x09c99 = "PC Camera with Microphone (SN9C202 + OM6802)" */
    '\x1f','\x04',' ','\x98','M','i','c','r','o','p','h','o','n','e',' ','(','S','N','9','C','2','0','2',' ','+',' ','O','M','6','8','0','2',')',
/* 0x09cba = "Exilim EX-Z350 Digital Camera (mass storage mode)" */
    'E','x','i','l','i','m',' ','E','X','-','Z','3','5','0',' ','\x09','\x04',' ','(','m','a','s','s',' ','s','t','o','r','a','g','e',' ','\x1a',
/* 0x09cdb = "PC Camera with Microphone (SN9C202 + MI1310)" */
    '\x1f','\x04',' ','\x98','M','i','c','r','o','p','h','o','n','e',' ','(','S','N','9','C','2','0','2',' ','+',' ','M','I','1','3','1','0',')',
/* 0x09cfc = "Shenzhen LogoTech 2.4GHz receiver" */
    'S','h','e','n','z','h','e','n',' ','L','o','g','o','T','e','c','h',' ','2','.','4','G','H','z',' ','r','e','c','e','i','v','e','r',
/* 0x09d1d = "NEC NP02LM 802.11bgn Wireless Adapter [Ralink RT3072]" */
    'N','E','C',' ','N','P','0','2','L','M',' ','8','0','2','.','1','1','b','g','n',' ','\x01','\x02',' ','[','\x93','R','T','3','0','7','2',']',
/* 0x09d3e = "CR-75: 51-in-1 Card Reader/Writer [Sakar]" */
    'C','R','-','7','5',':',' ','5','1','-','i','n','-','1',' ','\x15',' ','R','e','a','d','e','r','/','\xdf',' ','[','S','a','k','a','r',']',
/* 0x09d5f = "COMfortel 2500 (System telephone)" */
    'C','O','M','f','o','r','t','e','l',' ','2','5','0','0',' ','(','S','y','s','t','e','m',' ','t','e','l','e','p','h','o','n','e',')',
/* 0x09d80 = "ACT-WNP-UA-005 802.11b/g/n WLAN Adapter" */
    'A','C','T','-','W','N','P','-','U','A','-','0','0','5',' ','8','0','2','.','1','1','b','/','g','/','n',' ','W','L','A','N',' ','\x02',
/* 0x09da1 = "Elite Panaboard Pen Adaptor (HID)" */
    'E','l','i','t','e',' ','P','a','n','a','b','o','a','r','d',' ','P','e','n',' ','A','d','a','p','t','o','r',' ','(','H','I','D',')',
/* 0x09dc2 = "Mercury 2.1MEG Deluxe Classic Cam" */
    'M','e','r','c','u','r','y',' ','2','.','1','M','E','G',' ','D','e','l','u','x','e',' ','C','l','a','s','s','i','c',' ','C','a','m',
/* 0x09de3 = "BCM2045B (BDC-2.1) [Bluetooth Controller]" */
    'B','C','M','2','0','4','5','B',' ','(','B','D','C','-','2','.','1',')',' ','[','\x06',' ','C','o','n','t','r','o','l','l','e','r',']',
/* 0x09e04 = "PC Camera with Microphone (SN9C202 + CX1332)" */
    '\x1f','\x04',' ','\x98','M','i','c','r','o','p','h','o','n','e',' ','(','S','N','9','C','2','0','2',' ','+',' ','C','X','1','3','3','2',')',
/* 0x09e25 = "Linksys WUSB11 v3.0 802.11b Adapter [Intersil PRISM 3]" */
    'L','i','n','k','s','y','s',' ','W','U','S','B','1','1',' ','v','3','.','0',' ','\x9b','\x02',' ','[','\xb0','P','R','I','S','M',' ','3',']',
/* 0x09e46 = "HONGKONG WEIDIDA ELECTRON LIMITED" */
    'H','O','N','G','K','O','N','G',' ','W','E','I','D','I','D','A',' ','E','L','E','C','T','R','O','N',' ','L','I','M','I','T','E','D',
/* 0x09e67 = "SDG1010 Waveform Generator (TMC mode)" */
    'S','D','G','1','0','1','0',' ','W','a','v','e','f','o','r','m',' ','G','e','n','e','r','a','t','o','r',' ','(','T','M','C',' ','\x1a',
/* 0x09e88 = "ConvertX AV100U A/V Capture Audio" */
    'C','o','n','v','e','r','t','X',' ','A','V','1','0','0','U',' ','A','/','V',' ','C','a','p','t','u','r','e',' ','A','u','d','i','o',
/* 0x09ea9 = "CTH-470 [Bamboo Fun Pen & Touch]" */
    'C','T','H','-','4','7','0',' ','[','B','a','m','b','o','o',' ','F','u','n',' ','P','e','n',' ','&',' ','T','o','u','c','h',']',
/* 0x09ec9 = "PSC-750xi Printer/Scanner/Copier" */
    'P','S','C','-','7','5','0','x','i',' ','P','r','i','n','t','e','r','/','S','c','a','n','n','e','r','/','C','o','p','i','e','r',
/* 0x09ee9 = "UDAD-T2 data aquisition device (boot)" */
    'U','D','A','D','-','T','2',' ','d','a','t','a',' ','a','q','u','i','s','i','t','i','o','n',' ','\xf9',' ','(','b','o','o','t',')',
/* 0x09f09 = "NeoVI Blue vehicle bus interface" */
    'N','e','o','V','I',' ','B','l','u','e',' ','v','e','h','i','c','l','e',' ','b','u','s',' ','i','n','t','e','r','f','a','c','e',
/* 0x09f29 = "FINGER VP Multimodal Biometric Sensor" */
    'F','I','N','G','E','R',' ','V','P',' ','M','u','l','t','i','m','o','d','a','l',' ','B','i','o','m','e','t','r','i','c',' ','\xac',
/* 0x09f49 = "F9L1103 N750 DB 802.11abgn 2x3:3 [Ralink RT3573]" */
    'F','9','L','1','1','0','3',' ','N','7','5','0',' ','D','B',' ','\xea','2','x','3',':','3',' ','[','\x93','R','T','3','5','7','3',']',
/* 0x09f69 = "DWA-130 802.11n Wireless N Adapter(rev.D) [Atheros AR9170+AR9102]" */
    'D','W','A','-','1','3','0',' ','\x99','\x01','N',' ','\xbb','D',')',' ','[','\xaf','A','R','9','1','7','0','+','A','R','9','1','0','2',']',
/* 0x09f89 = "US-224 Audio/Midi Controller (without fw)" */
    'U','S','-','2','2','4',' ','A','u','d','i','o','/','M','i','d','i',' ','\x13',' ','(','w','i','t','h','o','u','t',' ','f','w',')',
/* 0x09fa9 = "Ralink RT2770/2720 802.11b/g/n Wireless LAN Mini-USB Device" */
    '\x93','R','T','2','7','7','0','/','2','7','2','0',' ','8','0','2','.','1','1','b','/','g','/','n',' ','\x01','\xf3','\xb9','-','\x0a',' ','\x03',
/* 0x09fc9 = "Ritronics Components (S) Pte., Ltd" */
    'R','i','t','r','o','n','i','c','s',' ','C','o','m','p','o','n','e','n','t','s',' ','(','S',')',' ','P','t','e','.',',',' ','\x16',
/* 0x09fe9 = "Broadcom BCM20702 Single-Chip Bluetooth 4.0 + LE" */
    '\xeb','B','C','M','2','0','7','0','2',' ','S','i','n','g','l','e','-','C','h','i','p',' ','\x06',' ','4','.','0',' ','+',' ','L','E',
/* 0x0a009 = "Liquid Gallant Duo E350 (debug mode)" */
    'L','i','q','u','i','d',' ','G','a','l','l','a','n','t',' ','D','u','o',' ','E','3','5','0',' ','(','d','e','b','u','g',' ','\x1a',
/* 0x0a029 = "WNA1100 Wireless-N 150 [Atheros AR9271]" */
    'W','N','A','1','1','0','0',' ','W','i','r','e','l','e','s','s','-','N',' ','1','5','0',' ','[','\xaf','A','R','9','2','7','1',']',
/* 0x0a049 = "Exilim EX-H10 Digital Camera (mass storage mode)" */
    'E','x','i','l','i','m',' ','E','X','-','H','1','0',' ','\x09','\x04',' ','(','m','a','s','s',' ','s','t','o','r','a','g','e',' ','\x1a',
/* 0x0a069 = "DWL-120 802.11b Wireless Adapter(rev.E1) [Atmel at76c503a]" */
    'D','W','L','-','1','2','0',' ','\x9b','\x01','\xbb','E','1',')',' ','[','A','t','m','e','l',' ','a','t','7','6','c','5','0','3','a',']',
/* 0x0a089 = "Magnetic Stripe Reader IDRA-334133-HP" */
    'M','a','g','n','e','t','i','c',' ','S','t','r','i','p','e',' ','\x08',' ','I','D','R','A','-','3','3','4','1','3','3','-','H','P',
/* 0x0a0a9 = "MPMan MP-Ki 128 MP3 Player/Recorder" */
    'M','P','M','a','n',' ','M','P','-','K','i',' ','1','2','8',' ','\x8e','P','l','a','y','e','r','/','R','e','c','o','r','d','e','r',
/* 0x0a0c9 = "RZ01-0035 Laser Gaming Mouse [Imperator]" */
    'R','Z','0','1','-','0','0','3','5',' ','\x82',' ','G','a','m','i','n','g',' ','\x0b',' ','[','I','m','p','e','r','a','t','o','r',']',
/* 0x0a0e9 = "US-122 Audio/Midi Interface (without fw)" */
    'U','S','-','1','2','2',' ','A','u','d','i','o','/','M','i','d','i',' ','\x81',' ','(','w','i','t','h','o','u','t',' ','f','w',')',
/* 0x0a109 = "Good Way Technology Co., Ltd & GWC technology Inc." */
    'G','o','o','d',' ','W','a','y',' ','\x0d',' ','\x0e','\x16',' ','&',' ','G','W','C',' ','t','e','c','h','n','o','l','o','g','y',' ','\x07',
/* 0x0a129 = "HanfTek UMT-010 USB2.0 DVB-T (cold)" */
    'H','a','n','f','T','e','k',' ','U','M','T','-','0','1','0',' ','U','S','B','2','.','0',' ','\xa7','T',' ','(','c','o','l','d',')',
/* 0x0a149 = "USA-49Wlc serial adapter [no firmware]" */
    'U','S','A','-','4','9','W','l','c',' ','s','e','r','i','a','l',' ','\xd0',' ','[','n','o',' ','f','i','r','m','w','a','r','e',']',
/* 0x0a169 = "AtermITX62 128K Support Standard" */
    'A','t','e','r','m','I','T','X','6','2',' ','1','2','8','K',' ','S','u','p','p','o','r','t',' ','S','t','a','n','d','a','r','d',
/* 0x0a189 = "ASUS Zenfone GO (ZB500KL) (MTP mode)" */
    'A','S','U','S',' ','Z','e','n','f','o','n','e',' ','G','O',' ','(','Z','B','5','0','0','K','L',')',' ','(','M','T','P',' ','\x1a',
/* 0x0a1a9 = "Wireless 5700 Mobile Broadband (CDMA EV-DO) Minicard Modem" */
    '\x01','5','7','0','0',' ','\x96',' ','\xb7','(','C','D','M','A',' ','E','V','-','D','O',')',' ','M','i','n','i','c','a','r','d',' ','\x1c',
/* 0x0a1c9 = "Mood Lighting (Microchip Technology Inc.)" */
    'M','o','o','d',' ','L','i','g','h','t','i','n','g',' ','(','M','i','c','r','o','c','h','i','p',' ','\x0d',' ','I','n','c','.',')',
/* 0x0a1e9 = "SERI E02 SCOM 6200 Virtual UARTs" */
    'S','E','R','I',' ','E','0','2',' ','S','C','O','M',' ','6','2','0','0',' ','V','i','r','t','u','a','l',' ','U','A','R','T','s',
/* 0x0a209 = "SiS-184-ASUS-4352.17 touch panel" */
    'S','i','S','-','1','8','4','-','A','S','U','S','-','4','3','5','2','.','1','7',' ','t','o','u','c','h',' ','p','a','n','e','l',
/* 0x0a229 = "Dimage Scan Dual III AF-2840 (2889)" */
    'D','i','m','a','g','e',' ','\x8a',' ','D','u','a','l',' ','I','I','I',' ','A','F','-','2','8','4','0',' ','(','2','8','8','9',')',
/* 0x0a249 = "RP255 Guitar Multi-Effects Processor" */
    'R','P','2','5','5',' ','G','u','i','t','a','r',' ','\xd6','-','E','f','f','e','c','t','s',' ','P','r','o','c','e','s','s','o','r',
/* 0x0a269 = "Advanced Peripheral Laboratories" */
    'A','d','v','a','n','c','e','d',' ','P','e','r','i','p','h','e','r','a','l',' ','L','a','b','o','r','a','t','o','r','i','e','s',
/* 0x0a289 = "IST-2 chronograph for bullet speeds" */
    'I','S','T','-','2',' ','c','h','r','o','n','o','g','r','a','p','h',' ','\xcc','b','u','l','l','e','t',' ','s','p','e','e','d','s',
/* 0x0a2a9 = "AtermIT21L 128K Support Standard" */
    'A','t','e','r','m','I','T','2','1','L',' ','1','2','8','K',' ','S','u','p','p','o','r','t',' ','S','t','a','n','d','a','r','d',
/* 0x0a2c9 = "RTL8192CU 802.11n WLAN Adapter [ISY IWL 4000]" */
    'R','T','L','8','1','9','2','C','U',' ','\x99','W','L','A','N',' ','\x02',' ','[','I','S','Y',' ','I','W','L',' ','4','0','0','0',']',
/* 0x0a2e9 = "Gigabyte U7200 DVB-T tuner [AF9035]" */
    'G','i','g','a','b','y','t','e',' ','U','7','2','0','0',' ','\xa7','T',' ','t','u','n','e','r',' ','[','A','F','9','0','3','5',']',
/* 0x0a309 = "VisionDTV USB-Ter/HAMA USB DVB-T device warm" */
    'V','i','s','i','o','n','D','T','V',' ','\x0a','-','T','e','r','/','H','A','M','A',' ','\x0a',' ','\xa7','T',' ','\xf9',' ','w','a','r','m',
/* 0x0a329 = "HanfTek UMT-010 USB2.0 DVB-T (warm)" */
    'H','a','n','f','T','e','k',' ','U','M','T','-','0','1','0',' ','U','S','B','2','.','0',' ','\xa7','T',' ','(','w','a','r','m',')',
/* 0x0a349 = "VTG-5xxx Video Test Generator family" */
    'V','T','G','-','5','x','x','x',' ','\xa3',' ','T','e','s','t',' ','G','e','n','e','r','a','t','o','r',' ','f','a','m','i','l','y',
/* 0x0a369 = "CC-600PX [Stylus CX5200/CX5400/CX6600]" */
    'C','C','-','6','0','0','P','X',' ','[','\xb1','C','X','5','2','0','0','/','C','X','5','4','0','0','/','C','X','6','6','0','0',']',
/* 0x0a389 = "MCE IR Receiver with ALS- Spinel plus for ASUS" */
    'M','C','E',' ','I','R',' ','\x8c',' ','\x98','A','L','S','-',' ','S','p','i','n','e','l',' ','p','l','u','s',' ','\xcc','A','S','U','S',
/* 0x0a3a9 = "PSX Vibration Feedback Converter" */
    'P','S','X',' ','V','i','b','r','a','t','i','o','n',' ','F','e','e','d','b','a','c','k',' ','C','o','n','v','e','r','t','e','r',
/* 0x0a3c9 = "Vultureprog BIOS chip programmer" */
    'V','u','l','t','u','r','e','p','r','o','g',' ','B','I','O','S',' ','c','h','i','p',' ','p','r','o','g','r','a','m','m','e','r',
/* 0x0a3e9 = "PowerShot A510 (normal mode) / PowerShot A510 (PTP mode)" */
    '\x24','\x84','A','5','1','0',' ','(','n','o','r','m','a','l',' ','\x1a',' ','/',' ','\x24','\x84','A','5','1','0',' ','(','P','T','P',' ','\x1a',
/* 0x0a409 = "Cinergy T XE (Version 1, AF9005)" */
    'C','i','n','e','r','g','y',' ','T',' ','X','E',' ','(','V','e','r','s','i','o','n',' ','1',',',' ','A','F','9','0','0','5',')',
/* 0x0a429 = "ShipModul MiniPlex NMEA Multiplexer" */
    'S','h','i','p','M','o','d','u','l',' ','\xb9','P','l','e','x',' ','N','M','E','A',' ','M','u','l','t','i','p','l','e','x','e','r',
/* 0x0a449 = "Fusion Model DVC-50 Rev 1 (NTSC)" */
    'F','u','s','i','o','n',' ','M','o','d','e','l',' ','D','V','C','-','5','0',' ','R','e','v',' ','1',' ','(','N','T','S','C',')',
/* 0x0a469 = "Invensense Embedded MotionApp HID Sensor" */
    'I','n','v','e','n','s','e','n','s','e',' ','E','m','b','e','d','d','e','d',' ','M','o','t','i','o','n','A','p','p',' ','\xf2','\xac',
/* 0x0a489 = "Broadcom BCM2045A Bluetooth Radio [Nintendo Wii]" */
    '\xeb','B','C','M','2','0','4','5','A',' ','\x06',' ','R','a','d','i','o',' ','[','N','i','n','t','e','n','d','o',' ','W','i','i',']',
/* 0x0a4a9 = "ASUS Zenfone GO (ZB500KL) (PTP mode)" */
    'A','S','U','S',' ','Z','e','n','f','o','n','e',' ','G','O',' ','(','Z','B','5','0','0','K','L',')',' ','(','P','T','P',' ','\x1a',
/* 0x0a4c9 = "AtermITX72 128K Support Standard" */
    'A','t','e','r','m','I','T','X','7','2',' ','1','2','8','K',' ','S','u','p','p','o','r','t',' ','S','t','a','n','d','a','r','d',
/* 0x0a4e9 = "JMS539 SuperSpeed SATA II 3.0G Bridge" */
    'J','M','S','5','3','9',' ','S','u','p','e','r','S','p','e','e','d',' ','S','A','T','A',' ','I','I',' ','3','.','0','G',' ','\x9f',
/* 0x0a509 = "TL866CS EEPROM Programmer [MiniPRO]" */
    'T','L','8','6','6','C','S',' ','E','E','P','R','O','M',' ','P','r','o','g','r','a','m','m','e','r',' ','[','\xb9','P','R','O',']',
/* 0x0a529 = "Hitachi Video and Information System, Inc." */
    'H','i','t','a','c','h','i',' ','\xa3',' ','\xe4','I','n','f','o','r','m','a','t','i','o','n',' ','S','y','s','t','e','m',',',' ','\x07',
/* 0x0a549 = "ENUWI-N3 [802.11n Wireless N150 Adapter]" */
    'E','N','U','W','I','-','N','3',' ','[','8','0','2','.','1','1','n',' ','\x01','N','1','5','0',' ','A','d','a','p','t','e','r',']',
/* 0x0a569 = "AtermITX80 128K Support Standard" */
    'A','t','e','r','m','I','T','X','8','0',' ','1','2','8','K',' ','S','u','p','p','o','r','t',' ','S','t','a','n','d','a','r','d',
/* 0x0a589 = "Feature Integration Technology Inc. (Fintek)" */
    'F','e','a','t','u','r','e',' ','I','n','t','e','g','r','a','t','i','o','n',' ','\x0d',' ','\x07',' ','(','F','i','n','t','e','k',')',
/* 0x0a5a9 = "N48/M-BB48/M-UK96A [FirstMouse Plus]" */
    'N','4','8','/','M','-','B','B','4','8','/','M','-','U','K','9','6','A',' ','[','F','i','r','s','t','\x0b',' ','P','l','u','s',']',
/* 0x0a5c9 = "F7D1101 v1 Basic Wireless Adapter [Realtek RTL8188SU]" */
    'F','7','D','1','1','0','1',' ','v','1',' ','B','a','s','i','c',' ','\x01','\x02',' ','[','\xbe','R','T','L','8','1','8','8','S','U',']',
/* 0x0a5e9 = "Dream Cheeky Stress/Panic Button" */
    'D','r','e','a','m',' ','C','h','e','e','k','y',' ','S','t','r','e','s','s','/','P','a','n','i','c',' ','B','u','t','t','o','n',
/* 0x0a609 = "FM Radio SnapMusic Mobile 700 (FM700)" */
    'F','M',' ','R','a','d','i','o',' ','S','n','a','p','M','u','s','i','c',' ','\x96',' ','7','0','0',' ','(','F','M','7','0','0',')',
/* 0x0a629 = "M-Audio RunTime DFU / Fast Track Ultra 8R" */
    'M','-','\x8b','R','u','n','T','i','m','e',' ','D','F','U',' ','/',' ','\xec','T','r','a','c','k',' ','U','l','t','r','a',' ','8','R',
/* 0x0a649 = "Ally/Optimus One/Vortex (debug mode)" */
    'A','l','l','y','/','O','p','t','i','m','u','s',' ','O','n','e','/','V','o','r','t','e','x',' ','(','d','e','b','u','g',' ','\x1a',
/* 0x0a669 = "Arduino Robot Motor (bootloader)" */
    'A','r','d','u','i','n','o',' ','R','o','b','o','t',' ','M','o','t','o','r',' ','(','b','o','o','t','l','o','a','d','e','r',')',
/* 0x0a689 = "Cassidian RIU CSMU/BSD Simulator" */
    'C','a','s','s','i','d','i','a','n',' ','R','I','U',' ','C','S','M','U','/','B','S','D',' ','S','i','m','u','l','a','t','o','r',
/* 0x0a6a9 = "Nippon Electro-Sensory Devices Corp." */
    'N','i','p','p','o','n',' ','E','l','e','c','t','r','o','-','S','e','n','s','o','r','y',' ','D','e','v','i','c','e','s',' ','\x10',
/* 0x0a6c9 = "TransMemory-Mini / Kingston DataTraveler 2.0 Stick" */
    'T','r','a','n','s','\xd2','-','\xb9',' ','/',' ','K','i','n','g','s','t','o','n',' ','\xe7','T','r','a','v','e','l','e','r',' ','\xc1','\xb3',
/* 0x0a6e9 = "VTG-4xxx Video Test Generator family" */
    'V','T','G','-','4','x','x','x',' ','\xa3',' ','T','e','s','t',' ','G','e','n','e','r','a','t','o','r',' ','f','a','m','i','l','y',
/* 0x0a709 = "Pandigital / B&N Novel 9" tablet" */
    'P','a','n','d','i','g','i','t','a','l',' ','/',' ','B','&','N',' ','N','o','v','e','l',' ','9','"',' ','t','a','b','l','e','t',
/* 0x0a729 = "PowerShot SD30 / Ixus iZoom / IXY DIGITAL L3" */
    '\x24','\x84','S','D','3','0',' ','/',' ','I','x','u','s',' ','i','\xe6','/',' ','I','X','Y',' ','D','I','G','I','T','A','L',' ','L','3',
/* 0x0a749 = "Kaufmann Automotive GmbH, RKS+CAN Interface" */
    'K','a','u','f','m','a','n','n',' ','A','u','t','o','m','o','t','i','v','e',' ','\xfc',',',' ','R','K','S','+','C','A','N',' ','\x81',
/* 0x0a769 = "WNDA3100v3 802.11abgn 2x2:2 [MediaTek MT7632U]" */
    'W','N','D','A','3','1','0','0','v','3',' ','\xea','2','x','2',':','2',' ','[','\xa1','T','e','k',' ','M','T','7','6','3','2','U',']',
/* 0x0a789 = "Wireless Broadband (CDMA EV-DO) Minicard Status Port" */
    '\x01','\xb7','(','C','D','M','A',' ','E','V','-','D','O',')',' ','M','i','n','i','c','a','r','d',' ','S','t','a','t','u','s',' ','\x87',
/* 0x0a7a9 = "RP155 Guitar Multi-Effects Processor" */
    'R','P','1','5','5',' ','G','u','i','t','a','r',' ','\xd6','-','E','f','f','e','c','t','s',' ','P','r','o','c','e','s','s','o','r',
/* 0x0a7c9 = "US Interface Navigator (WKEY and FSK lines)" */
    'U','S',' ','\x81',' ','N','a','v','i','g','a','t','o','r',' ','(','W','K','E','Y',' ','\xe4','F','S','K',' ','l','i','n','e','s',')',
/* 0x0a7e9 = "HP "Truevision HD" laptop camera" */
    'H','P',' ','"','T','r','u','e','v','i','s','i','o','n',' ','H','D','"',' ','l','a','p','t','o','p',' ','c','a','m','e','r','a',
/* 0x0a809 = "USB-N13 802.11n Network Adapter (rev. B1) [Realtek RTL8192CU]" */
    '\x0a','-','N','1','3',' ','\x99','\x8d','\x02',' ','(','r','e','v','.',' ','B','1',')',' ','[','\xbe','R','T','L','8','1','9','2','C','U',']',
/* 0x0a829 = "SMART TECHNOLOGY INDUSTRIAL LTD." */
    'S','M','A','R','T',' ','T','E','C','H','N','O','L','O','G','Y',' ','I','N','D','U','S','T','R','I','A','L',' ','L','T','D','.',
/* 0x0a849 = "Marvell 88W8388 802.11a/b/g WLAN" */
    'M','a','r','v','e','l','l',' ','8','8','W','8','3','8','8',' ','8','0','2','.','1','1','a','/','b','/','g',' ','W','L','A','N',
/* 0x0a869 = "Shenzhen Sinote Tech-Electron Co., Ltd" */
    'S','h','e','n','z','h','e','n',' ','S','i','n','o','t','e',' ','T','e','c','h','-','E','l','e','c','t','r','o','n',' ','\x0e','\x16',
/* 0x0a889 = "CP210x UART Bridge / myAVR mySmartUSB light" */
    'C','P','2','1','0','x',' ','U','A','R','T',' ','\x9f',' ','/',' ','m','y','A','V','R',' ','m','y','\x12','\x0a',' ','l','i','g','h','t',
/* 0x0a8a9 = "Northern Embedded Science/CAVNEX" */
    'N','o','r','t','h','e','r','n',' ','E','m','b','e','d','d','e','d',' ','S','c','i','e','n','c','e','/','C','A','V','N','E','X',
/* 0x0a8c9 = "300LC Series Fingerprint Scanner (Before ReNumeration)" */
    '3','0','0','L','C',' ','\xbf',' ','\x92','\x25',' ','(','B','e','f','o','r','e',' ','R','e','N','u','m','e','r','a','t','i','o','n',')',
/* 0x0a8e9 = "US-428 Audio/Midi Controller (without fw)" */
    'U','S','-','4','2','8',' ','A','u','d','i','o','/','M','i','d','i',' ','\x13',' ','(','w','i','t','h','o','u','t',' ','f','w',')',
/* 0x0a909 = "ECS Elitegroup G220 integrated Webcam" */
    'E','C','S',' ','E','l','i','t','e','g','r','o','u','p',' ','G','2','2','0',' ','i','n','t','e','g','r','a','t','e','d',' ','\x11',
/* 0x0a929 = "America Kotobuki Electronics Industries, Inc." */
    'A','m','e','r','i','c','a',' ','K','o','t','o','b','u','k','i',' ','\x1b',' ','I','n','d','u','s','t','r','i','e','s',',',' ','\x07',
/* 0x0a949 = "iFP-1000 series mp3/ogg vorbis player" */
    'i','F','P','-','1','0','0','0',' ','\x1d',' ','m','p','3','/','o','g','g',' ','v','o','r','b','i','s',' ','p','l','a','y','e','r',
/* 0x0a969 = "24.1" LCD Monitor v4 / FID-638 Mouse" */
    '2','4','.','1','"',' ','L','C','D',' ','M','o','n','i','t','o','r',' ','v','4',' ','/',' ','F','I','D','-','6','3','8',' ','\x0b',
/* 0x0a989 = "IOGear GWU513 v2 802.11bg Wireless Adapter [Intersil ISL3887]" */
    'I','O','G','e','a','r',' ','G','W','U','5','1','3',' ','v','2',' ','\xad',' ','\x01','\x02',' ','[','\xb0','I','S','L','3','8','8','7',']',
/* 0x0a9a9 = "C2005 [Xperia M dual] (Mass Storage)" */
    'C','2','0','0','5',' ','[','X','p','e','r','i','a',' ','M',' ','d','u','a','l',']',' ','(','\x7c','S','t','o','r','a','g','e',')',
/* 0x0a9c9 = "3Dconnexion Space Traveller 3D Mouse" */
    '3','D','c','o','n','n','e','x','i','o','n',' ','S','p','a','c','e',' ','T','r','a','v','e','l','l','e','r',' ','3','D',' ','\x0b',
/* 0x0a9e9 = "Expert Key - Data aquisition system" */
    'E','x','p','e','r','t',' ','K','e','y',' ','-',' ','\xe7',' ','a','q','u','i','s','i','t','i','o','n',' ','s','y','s','t','e','m',
/* 0x0aa09 = "My Cinema U3100 Mini Plus [AF9035A]" */
    'M','y',' ','C','i','n','e','m','a',' ','U','3','1','0','0',' ','\xb9',' ','P','l','u','s',' ','[','A','F','9','0','3','5','A',']',
/* 0x0aa29 = "ShenMing Electron (Dong Guan) Co., Ltd." */
    'S','h','e','n','M','i','n','g',' ','E','l','e','c','t','r','o','n',' ','(','D','o','n','g',' ','G','u','a','n',')',' ','\x0e','\xab',
/* 0x0aa49 = "VTG-3xxx Video Test Generator family" */
    'V','T','G','-','3','x','x','x',' ','\xa3',' ','T','e','s','t',' ','G','e','n','e','r','a','t','o','r',' ','f','a','m','i','l','y',
/* 0x0aa69 = "WNA1000M 802.11bgn [Realtek RTL8188CUS]" */
    'W','N','A','1','0','0','0','M',' ','8','0','2','.','1','1','b','g','n',' ','[','\xbe','R','T','L','8','1','8','8','C','U','S',']',
/* 0x0aa89 = "DSS330 Digital Speaker System [uda1321]" */
    'D','S','S','3','3','0',' ','\x09','S','p','e','a','k','e','r',' ','S','y','s','t','e','m',' ','[','u','d','a','1','3','2','1',']',
/* 0x0aaa9 = "WLA-2000 v1.001 WLAN [RTL8191SU]" */
    'W','L','A','-','2','0','0','0',' ','v','1','.','0','0','1',' ','W','L','A','N',' ','[','R','T','L','8','1','9','1','S','U',']',
/* 0x0aac9 = "D5803 [Xperia Z3 Compact] (MTP mode)" */
    'D','5','8','0','3',' ','[','X','p','e','r','i','a',' ','Z','3',' ','C','o','m','p','a','c','t',']',' ','(','M','T','P',' ','\x1a',
/* 0x0aae9 = "CatNip LPC1343 development board" */
    'C','a','t','N','i','p',' ','L','P','C','1','3','4','3',' ','d','e','v','e','l','o','p','m','e','n','t',' ','b','o','a','r','d',
/* 0x0ab09 = "Hauppauge WinTV-USB FM Model 40211 Rev B123" */
    '\xfb','W','i','n','T','V','-','\x0a',' ','F','M',' ','M','o','d','e','l',' ','4','0','2','1','1',' ','R','e','v',' ','B','1','2','3',
/* 0x0ab29 = "1.3M pixel Microscope Camera (colour)" */
    '1','.','3','M',' ','p','i','x','e','l',' ','M','i','c','r','o','s','c','o','p','e',' ','\x04',' ','(','c','o','l','o','u','r',')',
/* 0x0ab49 = "660i/6600i Slide Phone (Still Image)" */
    '6','6','0','i','/','6','6','0','0','i',' ','S','l','i','d','e',' ','\x19',' ','(','S','t','i','l','l',' ','I','m','a','g','e',')',
/* 0x0ab69 = "Gigabyte U6000 DVB-T tuner [em2863]" */
    'G','i','g','a','b','y','t','e',' ','U','6','0','0','0',' ','\xa7','T',' ','t','u','n','e','r',' ','[','e','m','2','8','6','3',']',
/* 0x0ab89 = "3Dconnexion Space Navigator 3D Mouse" */
    '3','D','c','o','n','n','e','x','i','o','n',' ','S','p','a','c','e',' ','N','a','v','i','g','a','t','o','r',' ','3','D',' ','\x0b',
/* 0x0aba9 = "SD/SDHC Card Reader (SG365 / FlexiDrive XC+)" */
    'S','D','/','S','D','H','C',' ','\x15',' ','\x08',' ','(','S','G','3','6','5',' ','/',' ','F','l','e','x','i','\x14',' ','X','C','+',')',
/* 0x0abc9 = "Cinergy T XE (Version 2, AF9015)" */
    'C','i','n','e','r','g','y',' ','T',' ','X','E',' ','(','V','e','r','s','i','o','n',' ','2',',',' ','A','F','9','0','1','5',')',
/* 0x0abe9 = "RP500 Guitar Multi-Effects Processor" */
    'R','P','5','0','0',' ','G','u','i','t','a','r',' ','\xd6','-','E','f','f','e','c','t','s',' ','P','r','o','c','e','s','s','o','r',
/* 0x0ac09 = "F5D8053 N Wireless USB Adapter v5000 [Realtek RTL8192U]" */
    'F','5','D','8','0','5','3',' ','N',' ','\x01','\x0a',' ','\x02',' ','v','5','0','0','0',' ','[','\xbe','R','T','L','8','1','9','2','U',']',
/* 0x0ac29 = "Formula Vibration Feedback Wheel" */
    'F','o','r','m','u','l','a',' ','V','i','b','r','a','t','i','o','n',' ','F','e','e','d','b','a','c','k',' ','W','h','e','e','l',
/* 0x0ac49 = "Transformer Prime TF201 (debug mode)" */
    'T','r','a','n','s','f','o','r','m','e','r',' ','P','r','i','m','e',' ','T','F','2','0','1',' ','(','d','e','b','u','g',' ','\x1a',
/* 0x0ac69 = "SpeedStream 4060 Miniport ATM/ADSL Adapter" */
    'S','p','e','e','d','S','t','r','e','a','m',' ','4','0','6','0',' ','M','i','n','i','p','o','r','t',' ','A','T','M','/','\xf1','\x02',
/* 0x0ac89 = "AtermITX70 128K Support Standard" */
    'A','t','e','r','m','I','T','X','7','0',' ','1','2','8','K',' ','S','u','p','p','o','r','t',' ','S','t','a','n','d','a','r','d',
/* 0x0aca9 = "SL11DEMO, VID: 0x4ce, PID: 0x4ce" */
    'S','L','1','1','D','E','M','O',',',' ','V','I','D',':',' ','0','x','4','c','e',',',' ','P','I','D',':',' ','0','x','4','c','e',
/* 0x0acc9 = "Thermaltake MEKA G-Unit Gaming Keyboard" */
    'T','h','e','r','m','a','l','t','a','k','e',' ','M','E','K','A',' ','G','-','U','n','i','t',' ','G','a','m','i','n','g',' ','\x05',
/* 0x0ace9 = "Staples 12416 7 port desktop hub" */
    'S','t','a','p','l','e','s',' ','1','2','4','1','6',' ','7',' ','p','o','r','t',' ','d','e','s','k','t','o','p',' ','h','u','b',
/* 0x0ad09 = "UDAD-T1 data aquisition device (boot)" */
    'U','D','A','D','-','T','1',' ','d','a','t','a',' ','a','q','u','i','s','i','t','i','o','n',' ','\xf9',' ','(','b','o','o','t',')',
/* 0x0ad29 = "Jiuh Shiuh Precision Industry Co., Ltd" */
    'J','i','u','h',' ','S','h','i','u','h',' ','P','r','e','c','i','s','i','o','n',' ','I','n','d','u','s','t','r','y',' ','\x0e','\x16',
/* 0x0ad49 = "VisionDTV USB-Ter/HAMA USB DVB-T device cold" */
    'V','i','s','i','o','n','D','T','V',' ','\x0a','-','T','e','r','/','H','A','M','A',' ','\x0a',' ','\xa7','T',' ','\xf9',' ','c','o','l','d',
/* 0x0ad69 = "Z-U130 [Value Solid State Drive]" */
    'Z','-','U','1','3','0',' ','[','V','a','l','u','e',' ','S','o','l','i','d',' ','S','t','a','t','e',' ','D','r','i','v','e',']',
/* 0x0ad89 = "SPV C400 / T-Mobile SDA GSM/GPRS Pocket PC" */
    'S','P','V',' ','C','4','0','0',' ','/',' ','T','-','\x96',' ','S','D','A',' ','G','S','M','/','G','P','R','S',' ','\x17',' ','P','C',
/* 0x0ada9 = "Studio Linx Video input cable (NTSC)" */
    'S','t','u','d','i','o',' ','L','i','n','x',' ','\xa3',' ','i','n','p','u','t',' ','c','a','b','l','e',' ','(','N','T','S','C',')',
/* 0x0adc9 = "BUFFALO INC. (formerly MelCo., Inc.)" */
    'B','U','F','F','A','L','O',' ','I','N','C','.',' ','(','f','o','r','m','e','r','l','y',' ','M','e','l','\x0e','I','n','c','.',')',
/* 0x0ade9 = "LPC2378 [Robotino XT Bootloader]" */
    'L','P','C','2','3','7','8',' ','[','R','o','b','o','t','i','n','o',' ','X','T',' ','B','o','o','t','l','o','a','d','e','r',']',
/* 0x0ae09 = "X3650 (Printer, Scanner, Copier)" */
    'X','3','6','5','0',' ','(','P','r','i','n','t','e','r',',',' ','S','c','a','n','n','e','r',',',' ','C','o','p','i','e','r',')',
/* 0x0ae29 = "Emotiv EPOC Developer Headset Wireless Dongle" */
    'E','m','o','t','i','v',' ','E','P','O','C',' ','D','e','v','e','l','o','p','e','r',' ','H','e','a','d','s','e','t',' ','\x01','\xf4',
/* 0x0ae49 = "Blinkytape full-color light tape" */
    'B','l','i','n','k','y','t','a','p','e',' ','f','u','l','l','-','c','o','l','o','r',' ','l','i','g','h','t',' ','t','a','p','e',
/* 0x0ae69 = "Digital Media Player MP3/WMA [The Sharper Image]" */
    '\x09','\xa1',' ','\x1e',' ','M','P','3','/','W','M','A',' ','[','T','h','e',' ','S','h','a','r','p','e','r',' ','I','m','a','g','e',']',
/* 0x0ae89 = "Actisense NGT-1 NMEA2000 Gateway" */
    'A','c','t','i','s','e','n','s','e',' ','N','G','T','-','1',' ','N','M','E','A','2','0','0','0',' ','G','a','t','e','w','a','y',
/* 0x0aea9 = "Top Shot Force Feedback Racing Wheel" */
    'T','o','p',' ','\x84','F','o','r','c','e',' ','F','e','e','d','b','a','c','k',' ','R','a','c','i','n','g',' ','W','h','e','e','l',
/* 0x0aec9 = "Harmonix Guitar for PlayStation(R)3" */
    'H','a','r','m','o','n','i','x',' ','G','u','i','t','a','r',' ','\xcc','P','l','a','y','S','t','a','t','i','o','n','(','R',')','3',
/* 0x0aee9 = "Ultra-Slim Portable DVD Writer (DVSM-PC58U2V)" */
    'U','l','t','r','a','-','S','l','i','m',' ','\xa9','D','V','D',' ','\xdf',' ','(','D','V','S','M','-','P','C','5','8','U','2','V',')',
/* 0x0af09 = "G2/G3 Android Phone [MTP/PTP/Download mode]" */
    'G','2','/','G','3',' ','\xce','\x19',' ','[','M','T','P','/','P','T','P','/','D','o','w','n','l','o','a','d',' ','m','o','d','e',']',
/* 0x0af29 = "SoundLink Wireless Mobile speaker in DFU mode" */
    'S','o','u','n','d','L','i','n','k',' ','\x01','\x96',' ','s','p','e','a','k','e','r',' ','i','n',' ','D','F','U',' ','m','o','d','e',
/* 0x0af49 = "at76c510 rfmd2948 802.11b Access Point" */
    'a','t','7','6','c','5','1','0',' ','r','f','m','d','2','9','4','8',' ','\x9b','A','c','c','e','s','s',' ','P','o','i','n','t',
/* 0x0af68 = "Fujifilm IX-30 Camera [storage mode]" */
    'F','u','j','i','f','i','l','m',' ','I','X','-','3','0',' ','\x04',' ','[','s','t','o','r','a','g','e',' ','m','o','d','e',']',
/* 0x0af87 = "DTH-W1320 [MobileStudio Pro 13] tablet" */
    'D','T','H','-','W','1','3','2','0',' ','[','\x96','S','t','u','d','i','o',' ','\x8f',' ','1','3',']',' ','t','a','b','l','e','t',
/* 0x0afa6 = "Hauppauge WinTV-USB III (PAL) FM Model 597" */
    '\xfb','W','i','n','T','V','-','\x0a',' ','I','I','I',' ','(','P','A','L',')',' ','F','M',' ','M','o','d','e','l',' ','5','9','7',
/* 0x0afc5 = "Studio Linx Video input cable (PAL)" */
    'S','t','u','d','i','o',' ','L','i','n','x',' ','\xa3',' ','i','n','p','u','t',' ','c','a','b','l','e',' ','(','P','A','L',')',
/* 0x0afe4 = "UPort 1650-8 8-Port RS-232/422/485" */
    'U','P','o','r','t',' ','1','6','5','0','-','8',' ','8','-','\x87',' ','R','S','-','2','3','2','/','4','2','2','/','4','8','5',
/* 0x0b003 = "STK541 ZigBee Development Board" */
    'S','T','K','5','4','1',' ','Z','i','g','B','e','e',' ','D','e','v','e','l','o','p','m','e','n','t',' ','B','o','a','r','d',
/* 0x0b022 = "My Passport (WDBBEP), My Passport for Mac (WDBLUZ)" */
    'M','y',' ','\xd5','(','W','D','B','B','E','P',')',',',' ','M','y',' ','\xd5','\xcc','M','a','c',' ','(','W','D','B','L','U','Z',')',
/* 0x0b041 = "ScanLogic/Century Corporation uATA" */
    '\x8a','L','o','g','i','c','/','C','e','n','t','u','r','y',' ','C','o','r','p','o','r','a','t','i','o','n',' ','u','A','T','A',
/* 0x0b060 = "JDS Uniphase Corporation (JDSU)" */
    'J','D','S',' ','U','n','i','p','h','a','s','e',' ','C','o','r','p','o','r','a','t','i','o','n',' ','(','J','D','S','U',')',
/* 0x0b07f = "PX-A550 [CX-3500/3600/3650 MFP]" */
    'P','X','-','A','5','5','0',' ','[','C','X','-','3','5','0','0','/','3','6','0','0','/','3','6','5','0',' ','M','F','P',']',
/* 0x0b09e = "Lockheed Martin Energy Research" */
    'L','o','c','k','h','e','e','d',' ','M','a','r','t','i','n',' ','E','n','e','r','g','y',' ','R','e','s','e','a','r','c','h',
/* 0x0b0bd = "Artec T1 USB TVBOX with AN2235 (warm)" */
    'A','r','t','e','c',' ','T','1',' ','\x0a',' ','T','V','B','O','X',' ','\x98','A','N','2','2','3','5',' ','(','w','a','r','m',')',
/* 0x0b0dc = "TRUST 782AV LCD P. V. Video Capture" */
    'T','R','U','S','T',' ','7','8','2','A','V',' ','L','C','D',' ','P','.',' ','V','.',' ','\xa3',' ','C','a','p','t','u','r','e',
/* 0x0b0fb = "WiseGroup Smart Joy PSX, PS-PC Smart JoyPad" */
    'W','i','s','e','G','r','o','u','p',' ','\x12',' ','J','o','y',' ','P','S','X',',',' ','P','S','-','\x1f','\x12',' ','J','o','y','\xfa',
/* 0x0b11a = "FT232H Single HS USB-UART/FIFO IC" */
    'F','T','2','3','2','H',' ','S','i','n','g','l','e',' ','H','S',' ','\x0a','-','U','A','R','T','/','F','I','F','O',' ','I','C',
/* 0x0b139 = "U.S.Robotics 56000 Voice FaxModem Pro" */
    'U','.','S','.','R','o','b','o','t','i','c','s',' ','5','6','0','0','0',' ','V','o','i','c','e',' ','F','a','x','\x1c',' ','\x8f',
/* 0x0b158 = "Spectrum III Hybrid Smartcard Reader" */
    'S','p','e','c','t','r','u','m',' ','I','I','I',' ','H','y','b','r','i','d',' ','S','m','a','r','t','c','a','r','d',' ','\x08',
/* 0x0b177 = "Technical Marketing Research, Inc." */
    'T','e','c','h','n','i','c','a','l',' ','M','a','r','k','e','t','i','n','g',' ','R','e','s','e','a','r','c','h',',',' ','\x07',
/* 0x0b196 = "Relisys/Teco Information System" */
    'R','e','l','i','s','y','s','/','T','e','c','o',' ','I','n','f','o','r','m','a','t','i','o','n',' ','S','y','s','t','e','m',
/* 0x0b1b5 = "NEC uPD720121/130 USB-ATA/ATAPI Bridge" */
    'N','E','C',' ','u','P','D','7','2','0','1','2','1','/','1','3','0',' ','\x0a','-','A','T','A','/','A','T','A','P','I',' ','\x9f',
/* 0x0b1d4 = "WL-349v4 Wireless Micro Adapter 150N X1 [Ralink RT3370]" */
    'W','L','-','3','4','9','v','4',' ','\x01','\xc4',' ','\x02',' ','1','5','0','N',' ','X','1',' ','[','\x93','R','T','3','3','7','0',']',
/* 0x0b1f3 = "JINQ CHERN ENTERPRISE CO., LTD." */
    'J','I','N','Q',' ','C','H','E','R','N',' ','E','N','T','E','R','P','R','I','S','E',' ','C','O','.',',',' ','L','T','D','.',
/* 0x0b212 = "GW-US11S WLAN [Atmel AT76C503A]" */
    'G','W','-','U','S','1','1','S',' ','W','L','A','N',' ','[','A','t','m','e','l',' ','A','T','7','6','C','5','0','3','A',']',
/* 0x0b231 = "GN Netcom / Jabra REVO Wireless" */
    'G','N',' ','N','e','t','c','o','m',' ','/',' ','J','a','b','r','a',' ','R','E','V','O',' ','W','i','r','e','l','e','s','s',
/* 0x0b250 = "Hauppauge WinTV-USB III (PAL) FM Model 573" */
    '\xfb','W','i','n','T','V','-','\x0a',' ','I','I','I',' ','(','P','A','L',')',' ','F','M',' ','M','o','d','e','l',' ','5','7','3',
/* 0x0b26f = "at76c510 Prism-II 802.11b Access Point" */
    'a','t','7','6','c','5','1','0',' ','P','r','i','s','m','-','I','I',' ','\x9b','A','c','c','e','s','s',' ','P','o','i','n','t',
/* 0x0b28e = "SPRF2413A [2.4GHz Wireless Keyboard/Mouse Receiver]" */
    'S','P','R','F','2','4','1','3','A',' ','[','2','.','4','G','H','z',' ','\x01','\xc6','\x0b',' ','R','e','c','e','i','v','e','r',']',
/* 0x0b2ad = "Audio4-USB DSP Data Acquisition Unit" */
    'A','u','d','i','o','4','-','\x0a',' ','D','S','P',' ','\xe7',' ','A','c','q','u','i','s','i','t','i','o','n',' ','U','n','i','t',
/* 0x0b2cc = "Ultra Traveldrive 160G 2.5" HDD" */
    'U','l','t','r','a',' ','T','r','a','v','e','l','d','r','i','v','e',' ','1','6','0','G',' ','2','.','5','"',' ','H','D','D',
/* 0x0b2eb = "iFP-700 series mp3/ogg vorbis player" */
    'i','F','P','-','7','0','0',' ','\x1d',' ','m','p','3','/','o','g','g',' ','v','o','r','b','i','s',' ','p','l','a','y','e','r',
/* 0x0b30a = "ePass2000 (G&D STARCOS SPK 2.4)" */
    'e','P','a','s','s','2','0','0','0',' ','(','G','&','D',' ','S','T','A','R','C','O','S',' ','S','P','K',' ','2','.','4',')',
/* 0x0b329 = "CY7C63x0x Zoltrix Z-Boxer GamePad" */
    'C','Y','7','C','6','3','x','0','x',' ','Z','o','l','t','r','i','x',' ','Z','-','B','o','x','e','r',' ','G','a','m','e','\xfa',
/* 0x0b348 = "EP-702A [Stylus Photo PX650/TX650 Series]" */
    'E','P','-','7','0','2','A',' ','[','\xb1','\x86',' ','P','X','6','5','0','/','T','X','6','5','0',' ','S','e','r','i','e','s',']',
/* 0x0b367 = "Acer 640 \u00d7  480 laptop camera" */
    'A','c','e','r',' ','6','4','0',' ','\xff','\xc3','\x97',' ',' ','4','8','0',' ','l','a','p','t','o','p',' ','c','a','m','e','r','a',
/* 0x0b386 = "COMfort 1200 (System telephone)" */
    'C','O','M','f','o','r','t',' ','1','2','0','0',' ','(','S','y','s','t','e','m',' ','t','e','l','e','p','h','o','n','e',')',
/* 0x0b3a5 = "AnyPoint (TM) Home Network 1.6 Mbps Wireless Adapter" */
    'A','n','y','P','o','i','n','t',' ','(','T','M',')',' ','H','o','m','e',' ','\x8d','1','.','6',' ','M','b','p','s',' ','\x01','\x02',
/* 0x0b3c4 = "D&M Holdings, Inc. (Denon/Marantz)" */
    'D','&','M',' ','H','o','l','d','i','n','g','s',',',' ','\x07',' ','(','D','e','n','o','n','/','M','a','r','a','n','t','z',')',
/* 0x0b3e3 = "Ericsson Business Mobile Networks BV" */
    'E','r','i','c','s','s','o','n',' ','B','u','s','i','n','e','s','s',' ','\x96',' ','N','e','t','w','o','r','k','s',' ','B','V',
/* 0x0b402 = "PS/2 Mouse on Semiconductors CICT Keyboard" */
    'P','S','/','2',' ','\x0b',' ','o','n',' ','S','e','m','i','c','o','n','d','u','c','t','o','r','s',' ','C','I','C','T',' ','\x05',
/* 0x0b421 = "WG-640 (Automatic event dialer)" */
    'W','G','-','6','4','0',' ','(','A','u','t','o','m','a','t','i','c',' ','e','v','e','n','t',' ','d','i','a','l','e','r',')',
/* 0x0b440 = "M-Any Premium DAH-610 MP3/WMA Player" */
    'M','-','A','n','y',' ','P','r','e','m','i','u','m',' ','D','A','H','-','6','1','0',' ','M','P','3','/','W','M','A',' ','\x1e',
/* 0x0b45f = "NB 802.11a/b/g Wireless LAN Adapter(3887A)" */
    'N','B',' ','8','0','2','.','1','1','a','/','b','/','g',' ','\x01','\xf3','A','d','a','p','t','e','r','(','3','8','8','7','A',')',
/* 0x0b47e = "Torex Retail (formerly Logware)" */
    'T','o','r','e','x',' ','R','e','t','a','i','l',' ','(','f','o','r','m','e','r','l','y',' ','L','o','g','w','a','r','e',')',
/* 0x0b49d = "Gryphon series (keyboard emulation mode)" */
    'G','r','y','p','h','o','n',' ','\x1d',' ','(','k','e','y','b','o','a','r','d',' ','e','m','u','l','a','t','i','o','n',' ','\x1a',
/* 0x0b4bc = "Signality System Engineering Co., Ltd" */
    'S','i','g','n','a','l','i','t','y',' ','S','y','s','t','e','m',' ','E','n','g','i','n','e','e','r','i','n','g',' ','\x0e','\x16',
/* 0x0b4db = "AE1200 802.11bgn Wireless Adapter [Broadcom BCM43235]" */
    'A','E','1','2','0','0',' ','8','0','2','.','1','1','b','g','n',' ','\x01','\x02',' ','[','\xeb','B','C','M','4','3','2','3','5',']',
/* 0x0b4fa = "Canvio Basics 2TB USB 3.0 Portable Hard Drive" */
    'C','a','n','v','i','o',' ','B','a','s','i','c','s',' ','2','T','B',' ','\x0a',' ','3','.','0',' ','\xa9','H','a','r','d',' ','\x14',
/* 0x0b519 = "CRW2200UX Lightspeed 2 External CD-RW Drive" */
    'C','R','W','2','2','0','0','U','X',' ','L','i','g','h','t','s','p','e','e','d',' ','2',' ','\xe3','C','D','-','R','W',' ','\x14',
/* 0x0b538 = "PX-A620 [Stylus CX3900/DX4000/DX4050]" */
    'P','X','-','A','6','2','0',' ','[','\xb1','C','X','3','9','0','0','/','D','X','4','0','0','0','/','D','X','4','0','5','0',']',
/* 0x0b557 = "WUSB54AG 802.11a/g Adapter [Intersil ISL3887]" */
    'W','U','S','B','5','4','A','G',' ','8','0','2','.','1','1','a','/','g',' ','\x02',' ','[','\xb0','I','S','L','3','8','8','7',']',
/* 0x0b576 = "Master Hill Electric Wire and Cable Co., Ltd" */
    'M','a','s','t','e','r',' ','H','i','l','l',' ','E','l','e','c','t','r','i','c',' ','W','i','r','e',' ','\xe4','\xa5',' ','\x0e','\x16',
/* 0x0b595 = "Wiggleport FPGA-based I/O board" */
    'W','i','g','g','l','e','p','o','r','t',' ','F','P','G','A','-','b','a','s','e','d',' ','I','/','O',' ','b','o','a','r','d',
/* 0x0b5b4 = "Tinius Olsen Testing Machine Co., Inc." */
    'T','i','n','i','u','s',' ','O','l','s','e','n',' ','T','e','s','t','i','n','g',' ','M','a','c','h','i','n','e',' ','\x0e','\x07',
/* 0x0b5d3 = "Gamecube/N64 controller v2.9 (Joystick mode)" */
    'G','a','m','e','c','u','b','e','/','N','6','4',' ','\x9e',' ','v','2','.','9',' ','(','J','o','y','s','t','i','c','k',' ','\x1a',
/* 0x0b5f2 = "DUB-E100 Fast Ethernet Adapter(rev.C1) [ASIX AX88772]" */
    'D','U','B','-','E','1','0','0',' ','\xec','\x7f',' ','\xbb','C','1',')',' ','[','A','S','I','X',' ','A','X','8','8','7','7','2',']',
/* 0x0b611 = "AVM Fritz!WLAN USB N (in CD-ROM-mode)" */
    'A','V','M',' ','F','r','i','t','z','!','W','L','A','N',' ','\x0a',' ','N',' ','(','i','n',' ','C','D','-','R','O','M','-','\x1a',
/* 0x0b630 = "Thomson TG121N [Atheros AR9001U-(2)NG]" */
    'T','h','o','m','s','o','n',' ','T','G','1','2','1','N',' ','[','\xaf','A','R','9','0','0','1','U','-','(','2',')','N','G',']',
/* 0x0b64f = "Teensyduino Flight Sim Controls" */
    'T','e','e','n','s','y','d','u','i','n','o',' ','F','l','i','g','h','t',' ','S','i','m',' ','C','o','n','t','r','o','l','s',
/* 0x0b66e = "Sin Sheng Terminal & Machine, Inc." */
    'S','i','n',' ','S','h','e','n','g',' ','T','e','r','m','i','n','a','l',' ','&',' ','M','a','c','h','i','n','e',',',' ','\x07',
/* 0x0b68d = "EZ Cart II GameBoy Flash Programmer" */
    'E','Z',' ','C','a','r','t',' ','I','I',' ','G','a','m','e','B','o','y',' ','\x3c',' ','P','r','o','g','r','a','m','m','e','r',
/* 0x0b6ac = "Lumanate Wave NTSC/ATSC Combo Device" */
    'L','u','m','a','n','a','t','e',' ','W','a','v','e',' ','N','T','S','C','/','A','T','S','C',' ','C','o','m','b','o',' ','\x03',
/* 0x0b6cb = "AN2235 EZUSB-FX Microcontroller" */
    'A','N','2','2','3','5',' ','E','Z','U','S','B','-','F','X',' ','M','i','c','r','o','c','o','n','t','r','o','l','l','e','r',
/* 0x0b6ea = "SIS3150 USB2.0 to VME interface" */
    'S','I','S','3','1','5','0',' ','U','S','B','2','.','0',' ','t','o',' ','V','M','E',' ','i','n','t','e','r','f','a','c','e',
/* 0x0b709 = "DVB-T FTA Half Minicard [RTL2832U]" */
    '\xa7','T',' ','F','T','A',' ','H','a','l','f',' ','M','i','n','i','c','a','r','d',' ','[','R','T','L','2','8','3','2','U',']',
/* 0x0b728 = "MCS7715 Parallel and serial port adapter" */
    'M','C','S','7','7','1','5',' ','P','a','r','a','l','l','e','l',' ','\xe4','s','e','r','i','a','l',' ','p','o','r','t',' ','\xd0',
/* 0x0b747 = "Belkin F5D7051 802.11g Adapter v1000 [Broadcom 4320]" */
    'B','e','l','k','i','n',' ','F','5','D','7','0','5','1',' ','\x94','\x02',' ','v','1','0','0','0',' ','[','\xeb','4','3','2','0',']',
/* 0x0b766 = "Flextronics Digital Design Japan, LTD." */
    'F','l','e','x','t','r','o','n','i','c','s',' ','\x09','D','e','s','i','g','n',' ','J','a','p','a','n',',',' ','L','T','D','.',
/* 0x0b785 = "Guardant System Firmware Update" */
    'G','u','a','r','d','a','n','t',' ','S','y','s','t','e','m',' ','F','i','r','m','w','a','r','e',' ','U','p','d','a','t','e',
/* 0x0b7a4 = "Trust PowerC@m 770Z (mass storage mode)" */
    'T','r','u','s','t',' ','\x24','C','@','m',' ','7','7','0','Z',' ','(','m','a','s','s',' ','s','t','o','r','a','g','e',' ','\x1a',
/* 0x0b7c3 = "Cyborg 3D Rumble Force Joystick" */
    'C','y','b','o','r','g',' ','3','D',' ','R','u','m','b','l','e',' ','F','o','r','c','e',' ','J','o','y','s','t','i','c','k',
/* 0x0b7e2 = "SMC2862W-G v3 EZ Connect 802.11g Adapter [Intersil ISL3887]" */
    'S','M','C','2','8','6','2','W','-','G',' ','v','3',' ','E','Z',' ','\xee','\x94','\x02',' ','[','\xb0','I','S','L','3','8','8','7',']',
/* 0x0b801 = "DTH-W1620 [MobileStudio Pro 16] tablet" */
    'D','T','H','-','W','1','6','2','0',' ','[','\x96','S','t','u','d','i','o',' ','\x8f',' ','1','6',']',' ','t','a','b','l','e','t',
/* 0x0b820 = "EightByEight Blinky Badge (DFU)" */
    'E','i','g','h','t','B','y','E','i','g','h','t',' ','B','l','i','n','k','y',' ','B','a','d','g','e',' ','(','D','F','U',')',
/* 0x0b83f = "GW-USValue-EZ 802.11n Wireless Adapter [Realtek RTL8188CUS]" */
    'G','W','-','U','S','V','a','l','u','e','-','E','Z',' ','\x99','\x01','\x02',' ','[','\xbe','R','T','L','8','1','8','8','C','U','S',']',
/* 0x0b85e = "USA-19Qi serial adapter [no firmware]" */
    'U','S','A','-','1','9','Q','i',' ','s','e','r','i','a','l',' ','\xd0',' ','[','n','o',' ','f','i','r','m','w','a','r','e',']',
/* 0x0b87d = "OpenMoko Neo1973 Bluetooth Device ID service" */
    'O','p','e','n','M','o','k','o',' ','N','e','o','1','9','7','3',' ','\x06',' ','\x03',' ','I','D',' ','s','e','r','v','i','c','e',
/* 0x0b89c = "PX-A720 [Stylus CX5900/CX6000/DX6000]" */
    'P','X','-','A','7','2','0',' ','[','\xb1','C','X','5','9','0','0','/','C','X','6','0','0','0','/','D','X','6','0','0','0',']',
/* 0x0b8bb = "COMfort 2000 (System telephone)" */
    'C','O','M','f','o','r','t',' ','2','0','0','0',' ','(','S','y','s','t','e','m',' ','t','e','l','e','p','h','o','n','e',')',
/* 0x0b8da = "IOData AirPort WN-B11/USBS 802.11b" */
    'I','O','D','a','t','a',' ','A','i','r','\x87',' ','W','N','-','B','1','1','/','U','S','B','S',' ','8','0','2','.','1','1','b',
/* 0x0b8f9 = "Barcode scanner Voyager 1400g Series" */
    'B','a','r','c','o','d','e',' ','s','c','a','n','n','e','r',' ','V','o','y','a','g','e','r',' ','1','4','0','0','g',' ','\xbf',
/* 0x0b918 = "DUB-E100 Fast Ethernet Adapter(rev.B1) [ASIX AX88772]" */
    'D','U','B','-','E','1','0','0',' ','\xec','\x7f',' ','\xbb','B','1',')',' ','[','A','S','I','X',' ','A','X','8','8','7','7','2',']',
/* 0x0b937 = "USB 3.0 bridge [Portable Expansion Drive]" */
    '\x0a',' ','3','.','0',' ','b','r','i','d','g','e',' ','[','\xa9','E','x','p','a','n','s','i','o','n',' ','D','r','i','v','e',']',
/* 0x0b956 = "iFP-800 series mp3/ogg vorbis player" */
    'i','F','P','-','8','0','0',' ','\x1d',' ','m','p','3','/','o','g','g',' ','v','o','r','b','i','s',' ','p','l','a','y','e','r',
/* 0x0b975 = "AtermIT42 128K Support Standard" */
    'A','t','e','r','m','I','T','4','2',' ','1','2','8','K',' ','S','u','p','p','o','r','t',' ','S','t','a','n','d','a','r','d',
/* 0x0b994 = "Ericsson, Inc., Blue Ridge Labs" */
    'E','r','i','c','s','s','o','n',',',' ','I','n','c','.',',',' ','B','l','u','e',' ','R','i','d','g','e',' ','L','a','b','s',
/* 0x0b9b3 = "Chipidea-Microelectronica, S.A." */
    'C','h','i','p','i','d','e','a','-','M','i','c','r','o','e','l','e','c','t','r','o','n','i','c','a',',',' ','S','.','A','.',
/* 0x0b9d2 = "PixelView PlayTv-USB PRO (PAL) FM" */
    'P','i','x','e','l','V','i','e','w',' ','P','l','a','y','T','v','-','\x0a',' ','P','R','O',' ','(','P','A','L',')',' ','F','M',
/* 0X0b9f1 = "Magic Mouse 2 (Lightning connector)" */
    'a','g','i','c',' ','\x0b',' ','2',' ','(','L','i','g','h','t','n','i','n','g',' ','c','o','n','n','e','c','t','o','r',')',
/* 0x0ba0f = "SideWinder Force Feedback Wheel" */
    'S','i','d','e','W','i','n','d','e','r',' ','F','o','r','c','e',' ','F','e','e','d','b','a','c','k',' ','W','h','e','e','l',
/* 0x0ba2e = "E709n [Officejet 6500 Wireless]" */
    'E','7','0','9','n',' ','[','O','f','f','i','c','e','j','e','t',' ','6','5','0','0',' ','W','i','r','e','l','e','s','s',']',
/* 0x0ba4d = "XPLAIN evaluation kit (CDC ACM)" */
    'X','P','L','A','I','N',' ','e','v','a','l','u','a','t','i','o','n',' ','k','i','t',' ','(','C','D','C',' ','A','C','M',')',
/* 0x0ba6c = "Artec T1 USB TVBOX with AN2235 (cold)" */
    'A','r','t','e','c',' ','T','1',' ','\x0a',' ','T','V','B','O','X',' ','\x98','A','N','2','2','3','5',' ','(','c','o','l','d',')',
/* 0x0ba8b = "SMC2862W-G v2 EZ Connect 802.11g Adapter [Intersil ISL3887]" */
    'S','M','C','2','8','6','2','W','-','G',' ','v','2',' ','E','Z',' ','\xee','\x94','\x02',' ','[','\xb0','I','S','L','3','8','8','7',']',
/* 0x0baaa = "SMC2862W-G v1 EZ Connect 802.11g Adapter [Intersil ISL3886]" */
    'S','M','C','2','8','6','2','W','-','G',' ','v','1',' ','E','Z',' ','\xee','\x94','\x02',' ','[','\xb0','I','S','L','3','8','8','6',']',
/* 0x0bac9 = "Dimage Scan Dual IV AF-3200 (2891)" */
    'D','i','m','a','g','e',' ','\x8a',' ','D','u','a','l',' ','I','V',' ','A','F','-','3','2','0','0',' ','(','2','8','9','1',')',
/* 0x0bae8 = "SAU510-USB Iso Plus JTAG Emulator" */
    'S','A','U','5','1','0','-','\x0a',' ','I','s','o',' ','P','l','u','s',' ','J','T','A','G',' ','E','m','u','l','a','t','o','r',
/* 0x0bb07 = "MagicXpress V.90 Pocket Modem [conexant]" */
    'M','a','g','i','c','X','p','r','e','s','s',' ','V','.','9','0',' ','\x17',' ','\x1c',' ','[','c','o','n','e','x','a','n','t',']',
/* 0x0bb26 = "Nexus 4/5/7/10 (debug + tether)" */
    'N','e','x','u','s',' ','4','/','5','/','7','/','1','0',' ','(','d','e','b','u','g',' ','+',' ','t','e','t','h','e','r',')',
/* 0x0bb45 = "ST Micro/Ergenic ERG BT-002 Bluetooth Adapter" */
    'S','T',' ','M','i','c','r','o','/','E','r','g','e','n','i','c',' ','E','R','G',' ','B','T','-','0','0','2',' ','\x06',' ','\x02',
/* 0x0bb64 = "SDDR-31 ImageMate II CompactFlash Reader" */
    'S','D','D','R','-','3','1',' ','I','m','a','g','e','M','a','t','e',' ','I','I',' ','C','o','m','p','a','c','t','\x3c',' ','\x08',
/* 0x0bb83 = "Trust 610/710 LCD POWERC@M ZOOM" */
    'T','r','u','s','t',' ','6','1','0','/','7','1','0',' ','L','C','D',' ','P','O','W','E','R','C','@','M',' ','Z','O','O','M',
/* 0x0bba2 = "HXD8 u-boot usbtty CDC ACM Mode" */
    'H','X','D','8',' ','u','-','b','o','o','t',' ','u','s','b','t','t','y',' ','C','D','C',' ','A','C','M',' ','M','o','d','e',
/* 0x0bbc1 = "Maxwise Production Enterprise Ltd." */
    'M','a','x','w','i','s','e',' ','P','r','o','d','u','c','t','i','o','n',' ','E','n','t','e','r','p','r','i','s','e',' ','\xab',
/* 0x0bbe0 = "BCM2045B (BDC-2) [Bluetooth Controller]" */
    'B','C','M','2','0','4','5','B',' ','(','B','D','C','-','2',')',' ','[','\x06',' ','C','o','n','t','r','o','l','l','e','r',']',
/* 0x0bbff = "CG-WLUSB300N rev A2 [Realtek RTL8192U]" */
    'C','G','-','W','L','U','S','B','3','0','0','N',' ','r','e','v',' ','A','2',' ','[','\xbe','R','T','L','8','1','9','2','U',']',
/* 0x0bc1e = "X Antenna Tracker arduino board" */
    'X',' ','A','n','t','e','n','n','a',' ','T','r','a','c','k','e','r',' ','a','r','d','u','i','n','o',' ','b','o','a','r','d',
/* 0x0bc3d = "Ferrari GT Force Feedback Wheel" */
    'F','e','r','r','a','r','i',' ','G','T',' ','F','o','r','c','e',' ','F','e','e','d','b','a','c','k',' ','W','h','e','e','l',
/* 0x0bc5c = "Nanosira-Multimedia WHQL Reference Radio" */
    'N','a','n','o','s','i','r','a','-','\xe2',' ','W','H','Q','L',' ','R','e','f','e','r','e','n','c','e',' ','R','a','d','i','o',
/* 0x0bc7b = "Ubiquiti WiFiStation 802.11n [Atheros AR9271]" */
    'U','b','i','q','u','i','t','i',' ','W','i','F','i','S','t','a','t','i','o','n',' ','\x99','[','\xaf','A','R','9','2','7','1',']',
/* 0x0bc9a = "Institute for Information Industry" */
    'I','n','s','t','i','t','u','t','e',' ','\xcc','I','n','f','o','r','m','a','t','i','o','n',' ','I','n','d','u','s','t','r','y',
/* 0x0bcb9 = "SpeedStream 4031 ATM/ADSL Installer" */
    'S','p','e','e','d','S','t','r','e','a','m',' ','4','0','3','1',' ','A','T','M','/','\xf1','I','n','s','t','a','l','l','e','r',
/* 0x0bcd8 = "Pro Keyboard [Mitsumi, A1048/JIS layout]" */
    '\x8f',' ','\x05',' ','[','M','i','t','s','u','m','i',',',' ','A','1','0','4','8','/','J','I','S',' ','l','a','y','o','u','t',']',
/* 0x0bcf7 = "3Dconnexion Space Explorer 3D Mouse" */
    '3','D','c','o','n','n','e','x','i','o','n',' ','S','p','a','c','e',' ','E','x','p','l','o','r','e','r',' ','3','D',' ','\x0b',
/* 0x0bd16 = "Arduino Micro ADK rev3 (bootloader)" */
    'A','r','d','u','i','n','o',' ','\xc4',' ','A','D','K',' ','r','e','v','3',' ','(','b','o','o','t','l','o','a','d','e','r',')',
/* 0x0bd35 = "AfaTech 9015 [Cinergy T Stick Dual]" */
    'A','f','a','T','e','c','h',' ','9','0','1','5',' ','[','C','i','n','e','r','g','y',' ','T',' ','\xb3',' ','D','u','a','l',']',
/* 0x0bd54 = "DSP-Weuffen USB2-HPI-Programmer" */
    'D','S','P','-','W','e','u','f','f','e','n',' ','U','S','B','2','-','H','P','I','-','P','r','o','g','r','a','m','m','e','r',
/* 0x0bd73 = "PCM2702 16-bit stereo audio DAC" */
    'P','C','M','2','7','0','2',' ','1','6','-','b','i','t',' ','s','t','e','r','e','o',' ','a','u','d','i','o',' ','D','A','C',
/* 0x0bd92 = "uLan2USB Converter - PS1 protocol" */
    'u','L','a','n','2','\x0a',' ','C','o','n','v','e','r','t','e','r',' ','-',' ','P','S','1',' ','p','r','o','t','o','c','o','l',
/* 0x0bdb1 = "AirLive WL-1600USB 802.11g Adapter [Realtek RTL8187L]" */
    'A','i','r','L','i','v','e',' ','W','L','-','1','6','0','0','\x0a',' ','\x94','\x02',' ','[','\xbe','R','T','L','8','1','8','7','L',']',
/* 0x0bdd0 = "10-Button USB Joystick with Vibration" */
    '1','0','-','B','u','t','t','o','n',' ','\x0a',' ','J','o','y','s','t','i','c','k',' ','\x98','V','i','b','r','a','t','i','o','n',
/* 0x0bdef = "Gigabeat F/X (HDD audio player)" */
    'G','i','g','a','b','e','a','t',' ','F','/','X',' ','(','H','D','D',' ','a','u','d','i','o',' ','p','l','a','y','e','r',')',
/* 0x0be0e = "Imaginative Design Operation Co., Ltd" */
    'I','m','a','g','i','n','a','t','i','v','e',' ','D','e','s','i','g','n',' ','O','p','e','r','a','t','i','o','n',' ','\x0e','\x16',
/* 0x0be2d = "UVC camera (Bresser microscope)" */
    'U','V','C',' ','c','a','m','e','r','a',' ','(','B','r','e','s','s','e','r',' ','m','i','c','r','o','s','c','o','p','e',')',
/* 0x0be4c = "CSL Wire & Plug (Shen Zhen) Co." */
    'C','S','L',' ','W','i','r','e',' ','&',' ','P','l','u','g',' ','(','S','h','e','n',' ','Z','h','e','n',')',' ','C','o','.',
/* 0x0be6b = "Multiple Frames Film Scanner-36series" */
    'M','u','l','t','i','p','l','e',' ','F','r','a','m','e','s',' ','F','i','l','m',' ','\x25','-','3','6','s','e','r','i','e','s',
/* 0x0be8a = "PCM2704 16-bit stereo audio DAC" */
    'P','C','M','2','7','0','4',' ','1','6','-','b','i','t',' ','s','t','e','r','e','o',' ','a','u','d','i','o',' ','D','A','C',
/* 0X0bea9 = "C-UV35 [Bluetooth Mini-Receiver] (HID proxy mode)" */
    '-','U','V','3','5',' ','[','\x06',' ','\xb9','-','R','e','c','e','i','v','e','r',']',' ','(','\xf2','p','r','o','x','y',' ','\x1a',
/* 0x0bec7 = "LifeCam VX-6000 (SN9C20x + OV9650)" */
    'L','i','f','e','\x9a','V','X','-','6','0','0','0',' ','(','S','N','9','C','2','0','x',' ','+',' ','O','V','9','6','5','0',')',
/* 0x0bee6 = "LPC2378 [Robotino 3 Bootloader]" */
    'L','P','C','2','3','7','8',' ','[','R','o','b','o','t','i','n','o',' ','3',' ','B','o','o','t','l','o','a','d','e','r',']',
/* 0x0bf05 = "SpeedStream 4020 ATM/ADSL Installer" */
    'S','p','e','e','d','S','t','r','e','a','m',' ','4','0','2','0',' ','A','T','M','/','\xf1','I','n','s','t','a','l','l','e','r',
/* 0x0bf24 = "G2/Optimus Android Phone [Camera/PTP mode]" */
    'G','2','/','O','p','t','i','m','u','s',' ','\xce','\x19',' ','[','C','a','m','e','r','a','/','P','T','P',' ','m','o','d','e',']',
/* 0x0bf43 = "NWD2105 802.11bgn Wireless Adapter [Ralink RT3070]" */
    'N','W','D','2','1','0','5',' ','8','0','2','.','1','1','b','g','n',' ','\x01','\x02',' ','[','\x93','R','T','3','0','7','0',']',
/* 0x0bf61 = "EC168 (v5) based USB DVB-T receiver" */
    'E','C','1','6','8',' ','(','v','5',')',' ','b','a','s','e','d',' ','\x0a',' ','\xa7','T',' ','r','e','c','e','i','v','e','r',
/* 0x0bf7f = "Camedia C-2100/C-3000 Ultra Zoom Camera" */
    'C','a','m','e','d','i','a',' ','C','-','2','1','0','0','/','C','-','3','0','0','0',' ','U','l','t','r','a',' ','\xe6','\x04',
/* 0x0bf9d = "ORGA 6000 Smart Card Terminal USB RNDIS" */
    'O','R','G','A',' ','6','0','0','0',' ','\x12',' ','\x15',' ','T','e','r','m','i','n','a','l',' ','\x0a',' ','R','N','D','I','S',
/* 0x0bfbb = "Lumanate Wave PAL SECAM DVBT Device" */
    'L','u','m','a','n','a','t','e',' ','W','a','v','e',' ','P','A','L',' ','S','E','C','A','M',' ','D','V','B','T',' ','\x03',
/* 0x0bfd9 = "SKYCABLE ENTERPRISE. CO., LTD." */
    'S','K','Y','C','A','B','L','E',' ','E','N','T','E','R','P','R','I','S','E','.',' ','C','O','.',',',' ','L','T','D','.',
/* 0x0bff7 = "ORGA 900/6000 Smart Card Terminal DFU" */
    'O','R','G','A',' ','9','0','0','/','6','0','0','0',' ','\x12',' ','\x15',' ','T','e','r','m','i','n','a','l',' ','D','F','U',
/* 0x0c015 = "PX-402A [Stylus SX115/Stylus NX110 Series]" */
    'P','X','-','4','0','2','A',' ','[','\xb1','S','X','1','1','5','/','\xb1','N','X','1','1','0',' ','S','e','r','i','e','s',']',
/* 0x0c033 = "3Dconnexion Spacemouse Plus XT" */
    '3','D','c','o','n','n','e','x','i','o','n',' ','S','p','a','c','e','m','o','u','s','e',' ','P','l','u','s',' ','X','T',
/* 0x0c051 = "IrDA Remote Controller / Creative Cordless Mouse" */
    'I','r','D','A',' ','\xcb',' ','\x13',' ','/',' ','C','r','e','a','t','i','v','e',' ','C','o','r','d','l','e','s','s',' ','\x0b',
/* 0x0c06f = "Blackberry Playbook (Connect to Mac mode)" */
    'B','l','a','c','k','b','e','r','r','y',' ','P','l','a','y','b','o','o','k',' ','(','\xee','t','o',' ','M','a','c',' ','\x1a',
/* 0x0c08d = "Studio PCTV USB (NTSC) with FM radio" */
    'S','t','u','d','i','o',' ','P','C','T','V',' ','\x0a',' ','(','N','T','S','C',')',' ','\x98','F','M',' ','r','a','d','i','o',
/* 0x0c0ab = "ES-10000G [Expression 10000XL]" */
    'E','S','-','1','0','0','0','0','G',' ','[','E','x','p','r','e','s','s','i','o','n',' ','1','0','0','0','0','X','L',']',
/* 0x0c0c9 = "SMCWUSBS-N2 EZ Connect N Wireless Adapter [Ralink RT2870]" */
    'S','M','C','W','U','S','B','S','-','N','2',' ','E','Z',' ','\xee','N',' ','\x01','\x02',' ','[','\x93','R','T','2','8','7','0',']',
/* 0x0c0e7 = "X-Keys Switch Interface, Composite Mode" */
    'X','-','K','e','y','s',' ','S','w','i','t','c','h',' ','I','n','t','e','r','f','a','c','e',',',' ','\x60','M','o','d','e',
/* 0x0c105 = "F5D8053 N Wireless USB Adapter v3000 [Ralink RT2870]" */
    'F','5','D','8','0','5','3',' ','N',' ','\x01','\x0a',' ','\x02',' ','v','3','0','0','0',' ','[','\x93','R','T','2','8','7','0',']',
/* 0x0c123 = "SMCWUSBS-N3 EZ Connect N Wireless Adapter [Ralink RT3070]" */
    'S','M','C','W','U','S','B','S','-','N','3',' ','E','Z',' ','\xee','N',' ','\x01','\x02',' ','[','\x93','R','T','3','0','7','0',']',
/* 0x0c141 = "Bluetooth module with BlueCore in DFU mode" */
    '\x06',' ','m','o','d','u','l','e',' ','\x98','B','l','u','e','C','o','r','e',' ','i','n',' ','D','F','U',' ','m','o','d','e',
/* 0x0c15f = "HDReye (before firmware loads)" */
    'H','D','R','e','y','e',' ','(','b','e','f','o','r','e',' ','f','i','r','m','w','a','r','e',' ','l','o','a','d','s',')',
/* 0x0c17d = "Ever Great Electric Wire and Cable Co., Ltd" */
    'E','v','e','r',' ','G','r','e','a','t',' ','E','l','e','c','t','r','i','c',' ','W','i','r','e',' ','\xe4','\xa5',' ','\x0e','\x16',
/* 0x0c19b = "I/O-Magic/Transcend 6-in-1 Card Reader" */
    'I','/','O','-','M','a','g','i','c','/','T','r','a','n','s','c','e','n','d',' ','6','-','i','n','-','1',' ','\x15',' ','\x08',
/* 0x0c1b9 = "KU-0133 Easy Access Interner Keyboard" */
    'K','U','-','0','1','3','3',' ','E','a','s','y',' ','A','c','c','e','s','s',' ','I','n','t','e','r','n','e','r',' ','\x05',
/* 0x0c1d7 = "Pixelmatix Aurora (bootloader)" */
    'P','i','x','e','l','m','a','t','i','x',' ','A','u','r','o','r','a',' ','(','b','o','o','t','l','o','a','d','e','r',')',
/* 0x0c1f5 = "EC168 (v3) based USB DVB-T receiver" */
    'E','C','1','6','8',' ','(','v','3',')',' ','b','a','s','e','d',' ','\x0a',' ','\xa7','T',' ','r','e','c','e','i','v','e','r',
/* 0x0c213 = "Rollei dr5 / Rollei dr5 (PTP mode)" */
    'R','o','l','l','e','i',' ','d','r','5',' ','/',' ','R','o','l','l','e','i',' ','d','r','5',' ','(','P','T','P',' ','\x1a',
/* 0x0c231 = "Dongguan ChingLung Wire & Cable Co., Ltd." */
    'D','o','n','g','g','u','a','n',' ','C','h','i','n','g','L','u','n','g',' ','W','i','r','e',' ','&',' ','\xa5',' ','\x0e','\xab',
/* 0x0c24f = "Santa Barbara Instrument Group" */
    'S','a','n','t','a',' ','B','a','r','b','a','r','a',' ','I','n','s','t','r','u','m','e','n','t',' ','G','r','o','u','p',
/* 0x0c26d = "Spectrum Digital XDS510 JTAG Debugger" */
    'S','p','e','c','t','r','u','m',' ','\x09','X','D','S','5','1','0',' ','J','T','A','G',' ','D','e','b','u','g','g','e','r',
/* 0x0c28b = "ic-design Reinhard Gottinger GmbH" */
    'i','c','-','d','e','s','i','g','n',' ','R','e','i','n','h','a','r','d',' ','G','o','t','t','i','n','g','e','r',' ','\xfc',
/* 0x0c2a9 = "OpenPipe: OSHW Bagpipes MIDI controller" */
    'O','p','e','n','P','i','p','e',':',' ','O','S','H','W',' ','B','a','g','p','i','p','e','s',' ','M','I','D','I',' ','\x9e',
/* 0x0c2c7 = "F5D7050 Wireless G Adapter v5000 [Realtek RTL8187B]" */
    'F','5','D','7','0','5','0',' ','\x01','G',' ','\x02',' ','v','5','0','0','0',' ','[','\xbe','R','T','L','8','1','8','7','B',']',
/* 0x0c2e5 = "Imagistics 2500 (MFC-8640D clone)" */
    'I','m','a','g','i','s','t','i','c','s',' ','2','5','0','0',' ','(','\x7d','8','6','4','0','D',' ','c','l','o','n','e',')',
/* 0x0c303 = "SBE Tech Ultrasonic Anemometer" */
    'S','B','E',' ','T','e','c','h',' ','U','l','t','r','a','s','o','n','i','c',' ','A','n','e','m','o','m','e','t','e','r',
/* 0x0c321 = "overlay64 video overlay module" */
    'o','v','e','r','l','a','y','6','4',' ','v','i','d','e','o',' ','o','v','e','r','l','a','y',' ','m','o','d','u','l','e',
/* 0x0c33f = "MSO1350 Fingerprint Sensor & SmartCard Reader [MSO1350-V3]" */
    'M','S','O','1','3','5','0',' ','\x92','\xac',' ','&',' ','\x12','\x15',' ','\x08',' ','[','M','S','O','1','3','5','0','-','V','3',']',
/* 0x0c35d = "EASYSHARE M1033 digital camera" */
    'E','A','S','Y','S','H','A','R','E',' ','M','1','0','3','3',' ','d','i','g','i','t','a','l',' ','c','a','m','e','r','a',
/* 0x0c37b = "Dual Trigger 3-in-1 (PS3 Mode)" */
    'D','u','a','l',' ','T','r','i','g','g','e','r',' ','3','-','i','n','-','1',' ','(','P','S','3',' ','M','o','d','e',')',
/* 0x0c399 = "RASDR Radio Astronomy SDR Tx Interface" */
    'R','A','S','D','R',' ','R','a','d','i','o',' ','A','s','t','r','o','n','o','m','y',' ','S','D','R',' ','T','x',' ','\x81',
/* 0x0c3b7 = "PX-A740 [CX8300/CX8400/DX8400]" */
    'P','X','-','A','7','4','0',' ','[','C','X','8','3','0','0','/','C','X','8','4','0','0','/','D','X','8','4','0','0',']',
/* 0x0c3d5 = "Chung Fu Chen Yeh Enterprise Corp." */
    'C','h','u','n','g',' ','F','u',' ','C','h','e','n',' ','Y','e','h',' ','E','n','t','e','r','p','r','i','s','e',' ','\x10',
/* 0x0c3f3 = "Chao Zhou Kai Yuan Electric Co., Ltd." */
    'C','h','a','o',' ','Z','h','o','u',' ','K','a','i',' ','Y','u','a','n',' ','E','l','e','c','t','r','i','c',' ','\x0e','\xab',
/* 0x0c411 = "LUFA Joystick Demo Application" */
    'L','U','F','A',' ','J','o','y','s','t','i','c','k',' ','D','e','m','o',' ','A','p','p','l','i','c','a','t','i','o','n',
/* 0x0c42f = "3Dconnexion Spacemouse Classic" */
    '3','D','c','o','n','n','e','x','i','o','n',' ','S','p','a','c','e','m','o','u','s','e',' ','C','l','a','s','s','i','c',
/* 0x0c44d = "C1605 [Xperia E dual] MSC mode" */
    'C','1','6','0','5',' ','[','X','p','e','r','i','a',' ','E',' ','d','u','a','l',']',' ','M','S','C',' ','m','o','d','e',
/* 0x0c46b = "Mindstorms EV3 Firmware Update" */
    'M','i','n','d','s','t','o','r','m','s',' ','E','V','3',' ','F','i','r','m','w','a','r','e',' ','U','p','d','a','t','e',
/* 0x0c489 = "C8051F38x HDMI Splitter [UHBX]" */
    'C','8','0','5','1','F','3','8','x',' ','H','D','M','I',' ','S','p','l','i','t','t','e','r',' ','[','U','H','B','X',']',
/* 0x0c4a7 = "Tungsten C/E/T/T2/T3 / Zire 71" */
    'T','u','n','g','s','t','e','n',' ','C','/','E','/','T','/','T','2','/','T','3',' ','/',' ','Z','i','r','e',' ','7','1',
/* 0x0c4c5 = "UIA-10 Digital Media Remote [Cypress AN2131SC]" */
    'U','I','A','-','1','0',' ','\x09','\xa1',' ','\xcb',' ','[','C','y','p','r','e','s','s',' ','A','N','2','1','3','1','S','C',']',
/* 0x0c4e3 = "ISY Wireless Micro Adapter IWL 2000 [RTL8188CUS]" */
    'I','S','Y',' ','\x01','\xc4',' ','\x02',' ','I','W','L',' ','2','0','0','0',' ','[','R','T','L','8','1','8','8','C','U','S',']',
/* 0x0c501 = "Xbox360 Performance Pipe (PIX)" */
    'X','b','o','x','3','6','0',' ','P','e','r','f','o','r','m','a','n','c','e',' ','P','i','p','e',' ','(','P','I','X',')',
/* 0x0c51f = "Matrix Orbital VK/LK204 Family" */
    'M','a','t','r','i','x',' ','O','r','b','i','t','a','l',' ','V','K','/','L','K','2','0','4',' ','F','a','m','i','l','y',
/* 0x0c53d = "Globetrotter GI0505 [iCON 505]" */
    'G','l','o','b','e','t','r','o','t','t','e','r',' ','G','I','0','5','0','5',' ','[','i','C','O','N',' ','5','0','5',']',
/* 0x0c55b = "Stripe Snoop Magnetic Stripe Reader" */
    'S','t','r','i','p','e',' ','S','n','o','o','p',' ','M','a','g','n','e','t','i','c',' ','S','t','r','i','p','e',' ','\x08',
/* 0x0c579 = "SpeedStream 10/100 Ethernet [pegasus]" */
    'S','p','e','e','d','S','t','r','e','a','m',' ','1','0','/','1','0','0',' ','\x7f',' ','[','p','e','g','a','s','u','s',']',
/* 0x0c597 = "DUB-E100 Fast Ethernet Adapter(rev.A) [ASIX AX88172]" */
    'D','U','B','-','E','1','0','0',' ','\xec','\x7f',' ','\xbb','A',')',' ','[','A','S','I','X',' ','A','X','8','8','1','7','2',']',
/* 0x0c5b5 = "RASDR Radio Astronomy SDR Rx Interface" */
    'R','A','S','D','R',' ','R','a','d','i','o',' ','A','s','t','r','o','n','o','m','y',' ','S','D','R',' ','R','x',' ','\x81',
/* 0x0c5d3 = "Leaguer Microelectronics (LME)" */
    'L','e','a','g','u','e','r',' ','M','i','c','r','o','e','l','e','c','t','r','o','n','i','c','s',' ','(','L','M','E',')',
/* 0x0c5f1 = "China Telecommunication Technology Labs" */
    'C','h','i','n','a',' ','T','e','l','e','c','o','m','m','u','n','i','c','a','t','i','o','n',' ','\x0d',' ','L','a','b','s',
/* 0x0c60f = "Keyboard (Labtec Ultra Flat Keyboard)" */
    '\x05',' ','(','L','a','b','t','e','c',' ','U','l','t','r','a',' ','F','l','a','t',' ','K','e','y','b','o','a','r','d',')',
/* 0x0c62d = "Targus Number Keypad (Composite Device)" */
    'T','a','r','g','u','s',' ','N','u','m','b','e','r',' ','K','e','y','p','a','d',' ','(','\x60','D','e','v','i','c','e',')',
/* 0x0c64b = "A6100 AC600 DB Wireless Adapter [Realtek RTL8811AU]" */
    'A','6','1','0','0',' ','A','C','6','0','0',' ','D','B',' ','\x01','\x02',' ','[','\xbe','R','T','L','8','8','1','1','A','U',']',
/* 0x0c669 = "EC168 (v2) based USB DVB-T receiver" */
    'E','C','1','6','8',' ','(','v','2',')',' ','b','a','s','e','d',' ','\x0a',' ','\xa7','T',' ','r','e','c','e','i','v','e','r',
/* 0x0c687 = "Lifeview LV5TDLX DVB-T [RTL2832U]" */
    'L','i','f','e','v','i','e','w',' ','L','V','5','T','D','L','X',' ','\xa7','T',' ','[','R','T','L','2','8','3','2','U',']',
/* 0x0c6a5 = "1.3M pixel Microscope Camera (mono)" */
    '1','.','3','M',' ','p','i','x','e','l',' ','M','i','c','r','o','s','c','o','p','e',' ','\x04',' ','(','m','o','n','o',')',
/* 0x0c6c3 = "Antec Veris Multimedia Station E-Z IR Receiver" */
    'A','n','t','e','c',' ','V','e','r','i','s',' ','\xe2',' ','S','t','a','t','i','o','n',' ','E','-','Z',' ','I','R',' ','\x8c',
/* 0x0c6e1 = "USB Camera device, 1.3 MPixel Web Cam" */
    '\x0a',' ','\x04',' ','d','e','v','i','c','e',',',' ','1','.','3',' ','M','P','i','x','e','l',' ','W','e','b',' ','C','a','m',
/* 0x0c6ff = "Conntech Electronic (Suzhou) Corporation" */
    'C','o','n','n','t','e','c','h',' ','\xba','(','S','u','z','h','o','u',')',' ','C','o','r','p','o','r','a','t','i','o','n',
/* 0x0c71d = "CDC-ACM class devices (modems)" */
    'C','D','C','-','A','C','M',' ','c','l','a','s','s',' ','d','e','v','i','c','e','s',' ','(','m','o','d','e','m','s',')',
/* 0x0c73b = "Data logger using the Cypress FX2" */
    '\xe7',' ','l','o','g','g','e','r',' ','u','s','i','n','g',' ','t','h','e',' ','C','y','p','r','e','s','s',' ','F','X','2',
/* 0x0c759 = "MPOD Multi Channel Power Supply System" */
    'M','P','O','D',' ','\xd6',' ','C','h','a','n','n','e','l',' ','\x24',' ','S','u','p','p','l','y',' ','S','y','s','t','e','m',
/* 0x0c777 = "Ching Tai Electric Wire & Cable Co., Ltd" */
    'C','h','i','n','g',' ','T','a','i',' ','E','l','e','c','t','r','i','c',' ','W','i','r','e',' ','&',' ','\xa5',' ','\x0e','\x16',
/* 0x0c795 = "C330/C350L/C450/EZX GSM Phone (AT)" */
    'C','3','3','0','/','C','3','5','0','L','/','C','4','5','0','/','E','Z','X',' ','G','S','M',' ','\x19',' ','(','A','T',')',
/* 0x0c7b3 = "Meteorite condenser microphone" */
    'M','e','t','e','o','r','i','t','e',' ','c','o','n','d','e','n','s','e','r',' ','m','i','c','r','o','p','h','o','n','e',
/* 0x0c7d1 = "DWL-G120 Spinnaker 802.11g [Intersil ISL3886]" */
    'D','W','L','-','G','1','2','0',' ','S','p','i','n','n','a','k','e','r',' ','\x94','[','\xb0','I','S','L','3','8','8','6',']',
/* 0x0c7ef = "My Book Mirror Edition (WDH2U)" */
    'M','y',' ','B','o','o','k',' ','M','i','r','r','o','r',' ','E','d','i','t','i','o','n',' ','(','W','D','H','2','U',')',
/* 0x0c80d = "Caplio RR30 / Medion MD 6126 Camera" */
    'C','a','p','l','i','o',' ','R','R','3','0',' ','/',' ','M','e','d','i','o','n',' ','M','D',' ','6','1','2','6',' ','\x04',
/* 0x0c82b = "Rainforest Automation ZigBee Controller" */
    'R','a','i','n','f','o','r','e','s','t',' ','A','u','t','o','m','a','t','i','o','n',' ','Z','i','g','B','e','e',' ','\x13',
/* 0x0c849 = "PX-A640 [CX7300/CX7400/DX7400]" */
    'P','X','-','A','6','4','0',' ','[','C','X','7','3','0','0','/','C','X','7','4','0','0','/','D','X','7','4','0','0',']',
/* 0x0c867 = "at89c5130/c5131 DFU bootloader" */
    'a','t','8','9','c','5','1','3','0','/','c','5','1','3','1',' ','D','F','U',' ','b','o','o','t','l','o','a','d','e','r',
/* 0x0c885 = "SecurePIN (IDPA-506100Y) PIN Pad" */
    'S','e','c','u','r','e','P','I','N',' ','(','I','D','P','A','-','5','0','6','1','0','0','Y',')',' ','P','I','N',' ','\xfa',
/* 0x0c8a3 = "eUSB ATA Bridge (Sony Spressa USB CDRW)" */
    'e','\x0a',' ','A','T','A',' ','\x9f',' ','(','S','o','n','y',' ','S','p','r','e','s','s','a',' ','\x0a',' ','C','D','R','W',')',
/* 0x0c8c1 = "ASUSTek Computer, Inc. (wrong ID)" */
    'A','S','U','S','T','e','k',' ','C','o','m','p','u','t','e','r',',',' ','\x07',' ','(','w','r','o','n','g',' ','I','D',')',
/* 0x0c8df = "VW100 series CDMA EV-DO Rev.A modem" */
    'V','W','1','0','0',' ','\x1d',' ','C','D','M','A',' ','E','V','-','D','O',' ','R','e','v','.','A',' ','m','o','d','e','m',
/* 0x0c8fd = "Tornado Speakerphone FaxModem 56.0" */
    'T','o','r','n','a','d','o',' ','S','p','e','a','k','e','r','p','h','o','n','e',' ','F','a','x','\x1c',' ','5','6','.','0',
/* 0x0c91b = "Top Global Gobi 2000 Wireless Modem (QDL mode)" */
    'T','o','p',' ','G','l','o','b','a','l',' ','G','o','b','i',' ','2','0','0','0',' ','\x01','\x1c',' ','(','Q','D','L',' ','\x1a',
/* 0x0c939 = "F5U228 Hi-Speed USB 2.0 DVD Creator" */
    'F','5','U','2','2','8',' ','H','i','-','S','p','e','e','d',' ','\x0a',' ','\xc1','D','V','D',' ','C','r','e','a','t','o','r',
/* 0x0c957 = "LUFA Dual CDC Demo Application" */
    'L','U','F','A',' ','D','u','a','l',' ','C','D','C',' ','D','e','m','o',' ','A','p','p','l','i','c','a','t','i','o','n',
/* 0x0c975 = "Conceptronic DVB-T CTVDIGRCU V3.0" */
    'C','o','n','c','e','p','t','r','o','n','i','c',' ','\xa7','T',' ','C','T','V','D','I','G','R','C','U',' ','V','3','.','0',
/* 0x0c993 = "Explorer 200 Protocol Analyzer" */
    'E','x','p','l','o','r','e','r',' ','2','0','0',' ','P','r','o','t','o','c','o','l',' ','A','n','a','l','y','z','e','r',
/* 0x0c9b1 = "C1605 [Xperia E dual] MTD mode" */
    'C','1','6','0','5',' ','[','X','p','e','r','i','a',' ','E',' ','d','u','a','l',']',' ','M','T','D',' ','m','o','d','e',
/* 0x0c9cf = "Heidelberger Druckmaschinen AG" */
    'H','e','i','d','e','l','b','e','r','g','e','r',' ','D','r','u','c','k','m','a','s','c','h','i','n','e','n',' ','A','G',
/* 0x0c9ed = "Portable SSD T3 (MU-PT250B, MU-PT500B)" */
    '\xa9','S','S','D',' ','T','3',' ','(','M','U','-','P','T','2','5','0','B',',',' ','M','U','-','P','T','5','0','0','B',')',
/* 0x0ca0b = "R-Engine MPEG2 encoder/decoder" */
    'R','-','E','n','g','i','n','e',' ','M','P','E','G','2',' ','e','n','c','o','d','e','r','/','d','e','c','o','d','e','r',
/* 0x0ca29 = "ADU218 Solid-State Relay I/O Interface" */
    'A','D','U','2','1','8',' ','S','o','l','i','d','-','S','t','a','t','e',' ','R','e','l','a','y',' ','I','/','O',' ','\x81',
/* 0x0ca47 = "Xperia arc S [Adb-Enable Mode]" */
    'X','p','e','r','i','a',' ','a','r','c',' ','S',' ','[','A','d','b','-','E','n','a','b','l','e',' ','M','o','d','e',']',
/* 0x0ca65 = "Eee Note EA800 (mass storage mode)" */
    'E','e','e',' ','N','o','t','e',' ','E','A','8','0','0',' ','(','m','a','s','s',' ','s','t','o','r','a','g','e',' ','\x1a',
/* 0x0ca83 = "internal USB Hub of E-Port Replicator" */
    'i','n','t','e','r','n','a','l',' ','\x0a',' ','\xa4',' ','o','f',' ','E','-','\x87',' ','R','e','p','l','i','c','a','t','o','r',
/* 0x0caa1 = "Dream Cheeky LED Message Board" */
    'D','r','e','a','m',' ','C','h','e','e','k','y',' ','L','E','D',' ','M','e','s','s','a','g','e',' ','B','o','a','r','d',
/* 0x0cabf = "GW-USUltra300 802.11abgn Wireless Adapter [Realtek RTL8192DU]" */
    'G','W','-','U','S','U','l','t','r','a','3','0','0',' ','\xea','\x01','\x02',' ','[','\xbe','R','T','L','8','1','9','2','D','U',']',
/* 0x0cadd = "2 port KVM switch model 60652K" */
    '2',' ','p','o','r','t',' ','K','V','M',' ','s','w','i','t','c','h',' ','m','o','d','e','l',' ','6','0','6','5','2','K',
/* 0x0cafb = "raphnet.net Megadrive multitap" */
    'r','a','p','h','n','e','t','.','n','e','t',' ','M','e','g','a','d','r','i','v','e',' ','m','u','l','t','i','t','a','p',
/* 0x0cb19 = "Wireless Broadband (3G HSDPA) Minicard Status Port" */
    '\x01','\xb7','(','3','G',' ','H','S','D','P','A',')',' ','M','i','n','i','c','a','r','d',' ','S','t','a','t','u','s',' ','\x87',
/* 0x0cb37 = "Firecracker Interface (ACPI-compliant)" */
    'F','i','r','e','c','r','a','c','k','e','r',' ','\x81',' ','(','A','C','P','I','-','c','o','m','p','l','i','a','n','t',')',
/* 0x0cb55 = "SDHC/MicroSD/MMC/MS/M2/CF/XD Flash Card Reader" */
    'S','D','H','C','/','\xc4','S','D','/','M','M','C','/','M','S','/','M','2','/','C','F','/','X','D',' ','\x3c',' ','\x15',' ','\x08',
/* 0x0cb73 = "Nano Receiver [Sandstrom Laser Mouse SMWLL11]" */
    'N','a','n','o',' ','\x8c',' ','[','S','a','n','d','s','t','r','o','m',' ','\x82',' ','\x0b',' ','S','M','W','L','L','1','1',']',
/* 0x0cb91 = "LUFA Generic HID Demo Application" */
    'L','U','F','A',' ','G','e','n','e','r','i','c',' ','\xf2','D','e','m','o',' ','A','p','p','l','i','c','a','t','i','o','n',
/* 0x0cbaf = "Matrix Orbital VK/LK202 Family" */
    'M','a','t','r','i','x',' ','O','r','b','i','t','a','l',' ','V','K','/','L','K','2','0','2',' ','F','a','m','i','l','y',
/* 0x0cbcd = "Actisense USG-1 NMEA Serial Gateway" */
    'A','c','t','i','s','e','n','s','e',' ','U','S','G','-','1',' ','N','M','E','A',' ','\x90',' ','G','a','t','e','w','a','y',
/* 0x0cbeb = "E3131 3G/UMTS/HSPA+ Modem (Mass Storage Mode)" */
    'E','3','1','3','1',' ','3','G','/','U','M','T','S','/','H','S','P','A','+',' ','\x1c',' ','(','\x7c','\x0f','M','o','d','e',')',
/* 0x0cc09 = "Elitegroup Computer Systems WLAN card WL-162" */
    'E','l','i','t','e','g','r','o','u','p',' ','\xcd','\xa6',' ','W','L','A','N',' ','c','a','r','d',' ','W','L','-','1','6','2',
/* 0x0cc27 = "Digital IXUS 55 (PTP mode)/PowerShot SD450 (PTP mode)" */
    '\x09','\xfd','5','5',' ','(','P','T','P',' ','m','o','d','e',')','/','\x24','\x84','S','D','4','5','0',' ','(','P','T','P',' ','\x1a',
/* 0x0cc45 = "GT-7600UF [Perfection 1200U/1200U Photo]" */
    'G','T','-','7','6','0','0','U','F',' ','[','\xf0','1','2','0','0','U','/','1','2','0','0','U',' ','P','h','o','t','o',']',
/* 0x0cc63 = "NetVolante RTA55i Broadband VoIP Router" */
    'N','e','t','V','o','l','a','n','t','e',' ','R','T','A','5','5','i',' ','\xb7','V','o','I','P',' ','R','o','u','t','e','r',
/* 0x0cc81 = "FT4232H Quad HS USB-UART/FIFO IC" */
    'F','T','4','2','3','2','H',' ','Q','u','a','d',' ','H','S',' ','\x0a','-','U','A','R','T','/','F','I','F','O',' ','I','C',
/* 0x0cc9f = "Firefly X10i I/O Board (with firmware)" */
    'F','i','r','e','f','l','y',' ','X','1','0','i',' ','I','/','O',' ','B','o','a','r','d',' ','(','w','i','t','h',' ','\xdb',
/* 0x0ccbd = "Mouse*in*a*Box Optical Elite Wireless" */
    'M','o','u','s','e','*','i','n','*','a','*','B','o','x',' ','\x7b','E','l','i','t','e',' ','W','i','r','e','l','e','s','s',
/* 0x0ccdb = "Wireless 5505 Mobile Broadband (3G HSDPA) Minicard Modem" */
    '\x01','5','5','0','5',' ','\x96',' ','\xb7','(','3','G',' ','H','S','D','P','A',')',' ','M','i','n','i','c','a','r','d',' ','\x1c',
/* 0x0ccf9 = "RZ01-0075, Gaming Mouse [Naga Hex]" */
    'R','Z','0','1','-','0','0','7','5',',',' ','G','a','m','i','n','g',' ','\x0b',' ','[','N','a','g','a',' ','H','e','x',']',
/* 0x0cd17 = "EWI electronic wind instrument" */
    'E','W','I',' ','e','l','e','c','t','r','o','n','i','c',' ','w','i','n','d',' ','i','n','s','t','r','u','m','e','n','t',
/* 0x0cd35 = "Xperia Pro [Media Transfer Protocol]" */
    'X','p','e','r','i','a',' ','\x8f',' ','[','\xa1',' ','T','r','a','n','s','f','e','r',' ','P','r','o','t','o','c','o','l',']',
/* 0x0cd53 = "rad1o badge for CCC congress 2015" */
    'r','a','d','1','o',' ','b','a','d','g','e',' ','\xcc','C','C','C',' ','c','o','n','g','r','e','s','s',' ','2','0','1','5',
/* 0x0cd71 = "mIDentity Light / KAAN SIM III" */
    'm','I','D','e','n','t','i','t','y',' ','L','i','g','h','t',' ','/',' ','K','A','A','N',' ','S','I','M',' ','I','I','I',
/* 0x0cd8f = "PC Camera (SN9C202 + OV7663 + EEPROM)" */
    '\x1f','\x04',' ','(','S','N','9','C','2','0','2',' ','+',' ','O','V','7','6','6','3',' ','+',' ','E','E','P','R','O','M',')',
/* 0x0cdad = "2.0Mpixel Web Cam - Eurocom D900C" */
    '2','.','0','M','p','i','x','e','l',' ','W','e','b',' ','\x9a','-',' ','E','u','r','o','c','o','m',' ','D','9','0','0','C',
/* 0x0cdcb = "PowerShot S60 (normal mode) / PowerShot S60 (PTP mode)" */
    '\x24','\x84','S','6','0',' ','(','n','o','r','m','a','l',' ','\x1a',' ','/',' ','\x24','\x84','S','6','0',' ','(','P','T','P',' ','\x1a',
/* 0x0cde9 = "Siemens Information and Communication Products" */
    'S','i','e','m','e','n','s',' ','I','n','f','o','r','m','a','t','i','o','n',' ','\xe4','\xe9','P','r','o','d','u','c','t','s',
/* 0x0ce07 = "USB Phone CM109 (aka CT2000,VPT1000)" */
    '\x0a',' ','\x19',' ','C','M','1','0','9',' ','(','a','k','a',' ','C','T','2','0','0','0',',','V','P','T','1','0','0','0',')',
/* 0x0ce25 = "WL-349v1 Wireless Adapter 150N 002 [Ralink RT3070]" */
    'W','L','-','3','4','9','v','1',' ','\x01','\x02',' ','1','5','0','N',' ','0','0','2',' ','[','\x93','R','T','3','0','7','0',']',
/* 0x0ce43 = "MCE IR Receiver - Spinel plusf0r ASUS" */
    'M','C','E',' ','I','R',' ','\x8c',' ','-',' ','S','p','i','n','e','l',' ','p','l','u','s','f','0','r',' ','A','S','U','S',
/* 0x0ce61 = "Model 2257 4 Channel Capture Card" */
    'M','o','d','e','l',' ','2','2','5','7',' ','4',' ','C','h','a','n','n','e','l',' ','C','a','p','t','u','r','e',' ','\x15',
/* 0x0ce7f = "LGTII - Landing Gear and Trim Control Module" */
    'L','G','T','I','I',' ','-',' ','L','a','n','d','i','n','g',' ','G','e','a','r',' ','\xe4','T','r','i','m',' ','\xc9',' ','\xe5',
/* 0x0ce9d = "LINE TECH INDUSTRIAL CO., LTD." */
    'L','I','N','E',' ','T','E','C','H',' ','I','N','D','U','S','T','R','I','A','L',' ','C','O','.',',',' ','L','T','D','.',
/* 0x0cebb = "TCC780X-based player (USB Boot mode)" */
    'T','C','C','7','8','0','X','-','b','a','s','e','d',' ','p','l','a','y','e','r',' ','(','\x0a',' ','B','o','o','t',' ','\x1a',
/* 0x0ced9 = "PC Camera (SN9C201 + OV965x + EEPROM)" */
    '\x1f','\x04',' ','(','S','N','9','C','2','0','1',' ','+',' ','O','V','9','6','5','x',' ','+',' ','E','E','P','R','O','M',')',
/* 0x0cef7 = "Red Octane Ignition Xbox DDR Pad" */
    'R','e','d',' ','O','c','t','a','n','e',' ','I','g','n','i','t','i','o','n',' ','X','b','o','x',' ','D','D','R',' ','\xfa',
/* 0x0cf15 = "PowerSpec MCE460 Front Panel LED Display" */
    '\x24','S','p','e','c',' ','M','C','E','4','6','0',' ','F','r','o','n','t',' ','P','a','n','e','l',' ','L','E','D',' ','\xcf',
/* 0x0cf33 = "Model 2255 4 Channel Capture Card" */
    'M','o','d','e','l',' ','2','2','5','5',' ','4',' ','C','h','a','n','n','e','l',' ','C','a','p','t','u','r','e',' ','\x15',
/* 0x0cf51 = "TCC77X-based players (USB Boot mode)" */
    'T','C','C','7','7','X','-','b','a','s','e','d',' ','p','l','a','y','e','r','s',' ','(','\x0a',' ','B','o','o','t',' ','\x1a',
/* 0x0cf6f = "3873 Manual Insert card reader" */
    '3','8','7','3',' ','M','a','n','u','a','l',' ','I','n','s','e','r','t',' ','c','a','r','d',' ','r','e','a','d','e','r',
/* 0x0cf8d = "SDDR-89 V4 ImageMate 12-in-1 Reader" */
    'S','D','D','R','-','8','9',' ','V','4',' ','I','m','a','g','e','M','a','t','e',' ','1','2','-','i','n','-','1',' ','\x08',
/* 0x0cfab = "Fujifilm IX-30 Camera [webcam mode]" */
    'F','u','j','i','f','i','l','m',' ','I','X','-','3','0',' ','\x04',' ','[','w','e','b','c','a','m',' ','m','o','d','e',']',
/* 0x0cfc9 = "HydraBus/HydraNFC (bootloader)" */
    'H','y','d','r','a','B','u','s','/','H','y','d','r','a','N','F','C',' ','(','b','o','o','t','l','o','a','d','e','r',')',
/* 0x0cfe7 = "iPod Classic/Nano 3.Gen (DFU mode)" */
    'i','P','o','d',' ','C','l','a','s','s','i','c','/','N','a','n','o',' ','3','.','G','e','n',' ','(','D','F','U',' ','\x1a',
/* 0x0d005 = "WLI-U2-KG54L 802.11bg [ZyDAS ZD1211B]" */
    'W','L','I','-','U','2','-','K','G','5','4','L',' ','\xad',' ','[','Z','y','D','A','S',' ','Z','D','1','2','1','1','B',']',
/* 0x0d023 = "Nostromo SpeedPad n52te Gaming Keyboard" */
    'N','o','s','t','r','o','m','o',' ','S','p','e','e','d','\xfa',' ','n','5','2','t','e',' ','G','a','m','i','n','g',' ','\x05',
/* 0x0d041 = "CD-RW + 6in1 Card Reader Digital Storage / Converter" */
    'C','D','-','R','W',' ','+',' ','6','i','n','1',' ','\x15',' ','\x08',' ','\x09','\x0f','/',' ','C','o','n','v','e','r','t','e','r',
/* 0x0d05f = "SL11R, VID: 0x4ce, PID: 0x07D1" */
    'S','L','1','1','R',',',' ','V','I','D',':',' ','0','x','4','c','e',',',' ','P','I','D',':',' ','0','x','0','7','D','1',
/* 0x0d07d = "Composite Device, Mass Storage Device (Flash Drive) amd HID" */
    '\x60','D','e','v','i','c','e',',',' ','\x7c','\x0f','\x03',' ','(','\x3c',' ','D','r','i','v','e',')',' ','a','m','d',' ','H','I','D',
/* 0x0d09b = "SMSC USB97C202 "HD-HB300V2-EU"" */
    'S','M','S','C',' ','U','S','B','9','7','C','2','0','2',' ','"','H','D','-','H','B','3','0','0','V','2','-','E','U','"',
/* 0x0d0b9 = "WinFast WalkieTV WDM Capture Driver." */
    'W','i','n','\xec','W','a','l','k','i','e','\xda','W','D','M',' ','C','a','p','t','u','r','e',' ','D','r','i','v','e','r','.',
/* 0x0d0d7 = "USA-49W serial adapter [no firmware]" */
    'U','S','A','-','4','9','W',' ','s','e','r','i','a','l',' ','\xd0',' ','[','n','o',' ','f','i','r','m','w','a','r','e',']',
/* 0x0d0f5 = "PM-A940 [Stylus Photo RX680/RX685/RX690]" */
    'P','M','-','A','9','4','0',' ','[','\xb1','\x86',' ','R','X','6','8','0','/','R','X','6','8','5','/','R','X','6','9','0',']',
/* 0x0d113 = "Stamps.com Model 510 5LB Scale" */
    'S','t','a','m','p','s','.','c','o','m',' ','M','o','d','e','l',' ','5','1','0',' ','5','L','B',' ','S','c','a','l','e',
/* 0x0d131 = "Efficient Networks 4060 Loader" */
    'E','f','f','i','c','i','e','n','t',' ','N','e','t','w','o','r','k','s',' ','4','0','6','0',' ','L','o','a','d','e','r',
/* 0x0d14f = "Surface Pro 3 Docking Station Audio Device" */
    'S','u','r','f','a','c','e',' ','\x8f',' ','3',' ','D','o','c','k','i','n','g',' ','S','t','a','t','i','o','n',' ','\x8b','\x03',
/* 0x0d16d = "Wireless 5500 Mobile Broadband (3G HSDPA) Minicard Modem" */
    '\x01','5','5','0','0',' ','\x96',' ','\xb7','(','3','G',' ','H','S','D','P','A',')',' ','M','i','n','i','c','a','r','d',' ','\x1c',
/* 0x0d18b = "PowerShot S70 (normal mode) / PowerShot S70 (PTP mode)" */
    '\x24','\x84','S','7','0',' ','(','n','o','r','m','a','l',' ','\x1a',' ','/',' ','\x24','\x84','S','7','0',' ','(','P','T','P',' ','\x1a',
/* 0x0d1a9 = "Sidewinder Strategic Commander" */
    'S','i','d','e','w','i','n','d','e','r',' ','S','t','r','a','t','e','g','i','c',' ','C','o','m','m','a','n','d','e','r',
/* 0x0d1c7 = "EasyShare SV811 Digital Picture Frame" */
    'E','a','s','y','S','h','a','r','e',' ','S','V','8','1','1',' ','\x09','P','i','c','t','u','r','e',' ','F','r','a','m','e',
/* 0x0d1e5 = "Typhoon Easycam USB 330K (older)" */
    'T','y','p','h','o','o','n',' ','E','a','s','y','c','a','m',' ','\x0a',' ','3','3','0','K',' ','(','o','l','d','e','r',')',
/* 0x0d203 = "Pro Keyboard [Mitsumi, A1048/US layout]" */
    '\x8f',' ','\x05',' ','[','M','i','t','s','u','m','i',',',' ','A','1','0','4','8','/','U','S',' ','l','a','y','o','u','t',']',
/* 0x0d221 = "PowerShot SD40 / Digital IXUS i7 IXY / DIGITAL L4" */
    '\x24','\x84','S','D','4','0',' ','/',' ','\x09','\xfd','i','7',' ','I','X','Y',' ','/',' ','D','I','G','I','T','A','L',' ','L','4',
/* 0x0d23f = "Triple Talk Speech Synthesizer" */
    'T','r','i','p','l','e',' ','T','a','l','k',' ','S','p','e','e','c','h',' ','S','y','n','t','h','e','s','i','z','e','r',
/* 0x0d25d = "Jornada 548 / iPAQ HW6515 Pocket PC" */
    'J','o','r','n','a','d','a',' ','5','4','8',' ','/',' ','i','P','A','Q',' ','H','W','6','5','1','5',' ','\x17',' ','P','C',
/* 0x0d27b = "Digital IXUS 65 (PTP mode)/PowerShot SD630 (PTP mode)" */
    '\x09','\xfd','6','5',' ','(','P','T','P',' ','m','o','d','e',')','/','\x24','\x84','S','D','6','3','0',' ','(','P','T','P',' ','\x1a',
/* 0x0d299 = "NovAtel FlexPack GPS receiver" */
    'N','o','v','A','t','e','l',' ','F','l','e','x','P','a','c','k',' ','G','P','S',' ','r','e','c','e','i','v','e','r',
/* 0x0d2b6 = "USB-N13 802.11n Network Adapter (rev. A1) [Ralink RT3072]" */
    '\x0a','-','N','1','3',' ','\x99','\x8d','\x02',' ','(','r','e','v','.',' ','A','1',')',' ','[','\x93','R','T','3','0','7','2',']',
/* 0x0d2d3 = "microSDXC Card Reader [Hama 00091047]" */
    'm','i','c','r','o','S','D','X','C',' ','\x15',' ','\x08',' ','[','H','a','m','a',' ','0','0','0','9','1','0','4','7',']',
/* 0x0d2f0 = "ST3250824A [Barracuda 7200.9]" */
    'S','T','3','2','5','0','8','2','4','A',' ','[','B','a','r','r','a','c','u','d','a',' ','7','2','0','0','.','9',']',
/* 0x0d30d = "QF-688uv Windstorm Pro Joystick" */
    'Q','F','-','6','8','8','u','v',' ','W','i','n','d','s','t','o','r','m',' ','\x8f',' ','J','o','y','s','t','i','c','k',
/* 0x0d32a = "JMicron Technology Corp. / JMicron USA Technology Corp." */
    'J','M','i','c','r','o','n',' ','\x0d',' ','\x10',' ','/',' ','J','M','i','c','r','o','n',' ','U','S','A',' ','\x0d',' ','\x10',
/* 0x0d347 = "Sansa C200 series in recovery mode" */
    'S','a','n','s','a',' ','C','2','0','0',' ','\x1d',' ','i','n',' ','r','e','c','o','v','e','r','y',' ','m','o','d','e',
/* 0x0d364 = "Transformer Pad TF701T (Debug mode)" */
    'T','r','a','n','s','f','o','r','m','e','r',' ','\xfa',' ','T','F','7','0','1','T',' ','(','D','e','b','u','g',' ','\x1a',
/* 0x0d381 = "Portable Keyboard 86+9 keys (Model 6100C US)" */
    '\xa9','\x05',' ','8','6','+','9',' ','k','e','y','s',' ','(','M','o','d','e','l',' ','6','1','0','0','C',' ','U','S',')',
/* 0x0d39e = "Nanosira WHQL Reference Radio" */
    'N','a','n','o','s','i','r','a',' ','W','H','Q','L',' ','R','e','f','e','r','e','n','c','e',' ','R','a','d','i','o',
/* 0x0d3bb = "F5D8055 N+ Wireless Adapter v1000 [Ralink RT2870]" */
    'F','5','D','8','0','5','5',' ','N','+',' ','\x01','\x02',' ','v','1','0','0','0',' ','[','\x93','R','T','2','8','7','0',']',
/* 0x0d3d8 = "Dimage Scan Elite 5400 II (2892)" */
    'D','i','m','a','g','e',' ','\x8a',' ','E','l','i','t','e',' ','5','4','0','0',' ','I','I',' ','(','2','8','9','2',')',
/* 0x0d3f5 = "Blackfin 535 [ADZS HPUSB ICE]" */
    'B','l','a','c','k','f','i','n',' ','5','3','5',' ','[','A','D','Z','S',' ','H','P','U','S','B',' ','I','C','E',']',
/* 0x0d412 = "Gigabyte K8100 Aivia Gaming Keyboard" */
    'G','i','g','a','b','y','t','e',' ','K','8','1','0','0',' ','A','i','v','i','a',' ','G','a','m','i','n','g',' ','\x05',
/* 0x0d42f = "telos EDV Systementwicklung GmbH" */
    't','e','l','o','s',' ','E','D','V',' ','S','y','s','t','e','m','e','n','t','w','i','c','k','l','u','n','g',' ','\xfc',
/* 0x0d44c = "Athena Smartcard Solutions, Inc." */
    'A','t','h','e','n','a',' ','S','m','a','r','t','c','a','r','d',' ','S','o','l','u','t','i','o','n','s',',',' ','\x07',
/* 0x0d469 = "Small DIP package Cypress FX2" */
    'S','m','a','l','l',' ','D','I','P',' ','p','a','c','k','a','g','e',' ','C','y','p','r','e','s','s',' ','F','X','2',
/* 0x0d486 = "Android Phone via MTP [Wiko Cink Peax 2]" */
    '\xce','\x19',' ','v','i','a',' ','M','T','P',' ','[','W','i','k','o',' ','C','i','n','k',' ','P','e','a','x',' ','2',']',
/* 0x0d4a3 = "Hauppauge WinTV-USB Model 40219 rev E189" */
    '\xfb','W','i','n','T','V','-','\x0a',' ','M','o','d','e','l',' ','4','0','2','1','9',' ','r','e','v',' ','E','1','8','9',
/* 0x0d4c0 = "RSA SecurID (R) Authenticator" */
    'R','S','A',' ','S','e','c','u','r','I','D',' ','(','R',')',' ','A','u','t','h','e','n','t','i','c','a','t','o','r',
/* 0x0d4dd = "Covidien Energy-based Devices" */
    'C','o','v','i','d','i','e','n',' ','E','n','e','r','g','y','-','b','a','s','e','d',' ','D','e','v','i','c','e','s',
/* 0x0d4fa = "Ferrari GT Rumble Force Wheel" */
    'F','e','r','r','a','r','i',' ','G','T',' ','R','u','m','b','l','e',' ','F','o','r','c','e',' ','W','h','e','e','l',
/* 0x0d517 = "USB Keyboard [Alps or Logitech, M2452]" */
    '\x0a',' ','\x05',' ','[','A','l','p','s',' ','o','r',' ','L','o','g','i','t','e','c','h',',',' ','M','2','4','5','2',']',
/* 0x0d534 = "EW-7711UTn nLite Wireless Adapter [Ralink RT2870]" */
    'E','W','-','7','7','1','1','U','T','n',' ','n','L','i','t','e',' ','\x01','\x02',' ','[','\x93','R','T','2','8','7','0',']',
/* 0x0d551 = "UF5/UF6/UF7/UF8 MIDI Master Keyboard" */
    'U','F','5','/','U','F','6','/','U','F','7','/','U','F','8',' ','M','I','D','I',' ','M','a','s','t','e','r',' ','\x05',
/* 0x0d56e = "Hauppauge WinTV-USB Model 40204 Rev B281" */
    '\xfb','W','i','n','T','V','-','\x0a',' ','M','o','d','e','l',' ','4','0','2','0','4',' ','R','e','v',' ','B','2','8','1',
/* 0x0d58b = "SCR3340 - ExpressCard54 Smart Card Reader" */
    'S','C','R','3','3','4','0',' ','-',' ','E','x','p','r','e','s','s','C','a','r','d','5','4',' ','\x12',' ','\x15',' ','\x08',
/* 0x0d5a8 = "WD Elements Desktop (WDE1UBK)" */
    'W','D',' ','E','l','e','m','e','n','t','s',' ','D','e','s','k','t','o','p',' ','(','W','D','E','1','U','B','K',')',
/* 0x0d5c5 = "J108i Cedar (Windows-driver mode)" */
    'J','1','0','8','i',' ','C','e','d','a','r',' ','(','W','i','n','d','o','w','s','-','d','r','i','v','e','r',' ','\x1a',
/* 0x0d5e2 = "2045 Bluetooth 2.0 USB-UHE Device with trace filter" */
    '2','0','4','5',' ','\x06',' ','\xc1','\x0a','-','U','H','E',' ','\x03',' ','\x98','t','r','a','c','e',' ','f','i','l','t','e','r',
/* 0x0d5ff = "DWA-135 802.11n Wireless N Adapter(rev.A1) [Realtek RTL8192CU]" */
    'D','W','A','-','1','3','5',' ','\x99','\x01','N',' ','\xbb','A','1',')',' ','[','\xbe','R','T','L','8','1','9','2','C','U',']',
/* 0x0d61c = "DTV-DVB UDTT 704J - dual DVB-T Driver" */
    'D','T','V','-','D','V','B',' ','U','D','T','T',' ','7','0','4','J',' ','-',' ','d','u','a','l',' ','\xa7','T',' ','\xde',
/* 0x0d639 = "Elite Panaboard UB-T880 (HID)" */
    'E','l','i','t','e',' ','P','a','n','a','b','o','a','r','d',' ','U','B','-','T','8','8','0',' ','(','H','I','D',')',
/* 0x0d656 = "USBLP-100 HomePNA Ethernet [pegasus]" */
    'U','S','B','L','P','-','1','0','0',' ','H','o','m','e','P','N','A',' ','\x7f',' ','[','p','e','g','a','s','u','s',']',
/* 0x0d673 = "DTK-2200 [Cintiq 22HD] tablet" */
    'D','T','K','-','2','2','0','0',' ','[','C','i','n','t','i','q',' ','2','2','H','D',']',' ','t','a','b','l','e','t',
/* 0x0d690 = "Defender G-Lens 2577 HD720p Camera" */
    'D','e','f','e','n','d','e','r',' ','G','-','L','e','n','s',' ','2','5','7','7',' ','H','D','7','2','0','p',' ','\x04',
/* 0x0d6ad = "UPort 1250 2-Port RS-232/422/485" */
    'U','P','o','r','t',' ','1','2','5','0',' ','2','-','\x87',' ','R','S','-','2','3','2','/','4','2','2','/','4','8','5',
/* 0x0d6ca = "CanoScan LiDE 50/LiDE 35/LiDE 40" */
    'C','a','n','o','\x8a',' ','L','i','D','E',' ','5','0','/','L','i','D','E',' ','3','5','/','L','i','D','E',' ','4','0',
/* 0x0d6e7 = "WG121(v1) 54 Mbps Wireless [Intersil ISL3886]" */
    'W','G','1','2','1','(','v','1',')',' ','5','4',' ','M','b','p','s',' ','\x01','[','\xb0','I','S','L','3','8','8','6',']',
/* 0x0d704 = "F5D8055 N+ Wireless Adapter v2000 [Ralink RT3072]" */
    'F','5','D','8','0','5','5',' ','N','+',' ','\x01','\x02',' ','v','2','0','0','0',' ','[','\x93','R','T','3','0','7','2',']',
/* 0x0d721 = "Powershot SD3500 IS / IXUS 210 IS" */
    'P','o','w','e','r','s','h','o','t',' ','S','D','3','5','0','0',' ','I','S',' ','/',' ','\xfd','2','1','0',' ','I','S',
/* 0x0d73e = "Mega Sky 580 DVB-T Tuner [GL861]" */
    'M','e','g','a',' ','S','k','y',' ','5','8','0',' ','\xa7','T',' ','T','u','n','e','r',' ','[','G','L','8','6','1',']',
/* 0x0d75b = "Sanyo Information Business Co., Ltd" */
    'S','a','n','y','o',' ','I','n','f','o','r','m','a','t','i','o','n',' ','B','u','s','i','n','e','s','s',' ','\x0e','\x16',
/* 0x0d778 = "Colorvision, Inc. Monitor Spyder" */
    'C','o','l','o','r','v','i','s','i','o','n',',',' ','\x07',' ','M','o','n','i','t','o','r',' ','S','p','y','d','e','r',
/* 0x0d795 = "Optimus Android Phone [LG Software mode]" */
    'O','p','t','i','m','u','s',' ','\xce','\x19',' ','[','L','G',' ','S','o','f','t','w','a','r','e',' ','m','o','d','e',']',
/* 0x0d7b2 = "Dev board JTAG (FT232H based)" */
    'D','e','v',' ','b','o','a','r','d',' ','J','T','A','G',' ','(','F','T','2','3','2','H',' ','b','a','s','e','d',')',
/* 0x0d7cf = "Hi-Speed 16-in-1 Flash Card Reader/Writer" */
    'H','i','-','S','p','e','e','d',' ','1','6','-','i','n','-','1',' ','\x3c',' ','\x15',' ','R','e','a','d','e','r','/','\xdf',
/* 0x0d7ec = "FT2232C/D/H Dual UART/FIFO IC" */
    'F','T','2','2','3','2','C','/','D','/','H',' ','D','u','a','l',' ','U','A','R','T','/','F','I','F','O',' ','I','C',
/* 0x0d809 = "TXP-Series Slot (TXP5001, TXP5004)" */
    'T','X','P','-','\xbf',' ','S','l','o','t',' ','(','T','X','P','5','0','0','1',',',' ','T','X','P','5','0','0','4',')',
/* 0x0d826 = "Clyde Lamp by Fabule (sketch)" */
    'C','l','y','d','e',' ','L','a','m','p',' ','b','y',' ','F','a','b','u','l','e',' ','(','s','k','e','t','c','h',')',
/* 0x0d843 = "Visual Frontier Enterprise Co., Ltd" */
    'V','i','s','u','a','l',' ','F','r','o','n','t','i','e','r',' ','E','n','t','e','r','p','r','i','s','e',' ','\x0e','\x16',
/* 0x0d860 = "at90usb646/647 DFU bootloader" */
    'a','t','9','0','u','s','b','6','4','6','/','6','4','7',' ','D','F','U',' ','b','o','o','t','l','o','a','d','e','r',
/* 0x0d87d = "Liberty (firmware not loaded)" */
    'L','i','b','e','r','t','y',' ','(','f','i','r','m','w','a','r','e',' ','n','o','t',' ','l','o','a','d','e','d',')',
/* 0x0d89a = "DWA-125 Wireless N 150 Adapter(rev.A1) [Ralink RT3070]" */
    'D','W','A','-','1','2','5',' ','\x01','N',' ','1','5','0',' ','\xbb','A','1',')',' ','[','\x93','R','T','3','0','7','0',']',
/* 0x0d8b7 = "ST3300601CB-RK 300 GB External Hard Drive" */
    'S','T','3','3','0','0','6','0','1','C','B','-','R','K',' ','3','0','0',' ','G','B',' ','\xe3','H','a','r','d',' ','\x14',
/* 0x0d8d4 = "PCTV Bungee USB (PAL) with FM radio" */
    'P','C','T','V',' ','B','u','n','g','e','e',' ','\x0a',' ','(','P','A','L',')',' ','\x98','F','M',' ','r','a','d','i','o',
/* 0x0d8f1 = "SkyScout Personal Planetarium" */
    'S','k','y','S','c','o','u','t',' ','P','e','r','s','o','n','a','l',' ','P','l','a','n','e','t','a','r','i','u','m',
/* 0x0d90e = "YUAN High-Tech Development Co., Ltd" */
    'Y','U','A','N',' ','H','i','g','h','-','T','e','c','h',' ','D','e','v','e','l','o','p','m','e','n','t',' ','\x0e','\x16',
/* 0x0d92b = "Tracker 110 Protocol Analyzer" */
    'T','r','a','c','k','e','r',' ','1','1','0',' ','P','r','o','t','o','c','o','l',' ','A','n','a','l','y','z','e','r',
/* 0x0d948 = "WG111(v1) 54 Mbps Wireless [Intersil ISL3886]" */
    'W','G','1','1','1','(','v','1',')',' ','5','4',' ','M','b','p','s',' ','\x01','[','\xb0','I','S','L','3','8','8','6',']',
/* 0x0d965 = "USB-ML-12 HCS08/HCS12 Multilink" */
    '\x0a','-','M','L','-','1','2',' ','H','C','S','0','8','/','H','C','S','1','2',' ','M','u','l','t','i','l','i','n','k',
/* 0x0d982 = "Taiwan Tai-Hao Enterprises Co., Ltd" */
    'T','a','i','w','a','n',' ','T','a','i','-','H','a','o',' ','E','n','t','e','r','p','r','i','s','e','s',' ','\x0e','\x16',
/* 0x0d99f = "Studio PCTV USB (PAL) with FM radio" */
    'S','t','u','d','i','o',' ','P','C','T','V',' ','\x0a',' ','(','P','A','L',')',' ','\x98','F','M',' ','r','a','d','i','o',
/* 0x0d9bc = "GT-F520/GT-F570 [Perfection 3590 PHOTO]" */
    'G','T','-','F','5','2','0','/','G','T','-','F','5','7','0',' ','[','\xf0','3','5','9','0',' ','P','H','O','T','O',']',
/* 0x0d9d9 = "Spectrum Signal Processing, Inc." */
    'S','p','e','c','t','r','u','m',' ','S','i','g','n','a','l',' ','P','r','o','c','e','s','s','i','n','g',',',' ','\x07',
/* 0x0d9f6 = "LUFA Audio Output Demo Application" */
    'L','U','F','A',' ','\x8b','O','u','t','p','u','t',' ','D','e','m','o',' ','A','p','p','l','i','c','a','t','i','o','n',
/* 0x0da13 = "SafeNet Sentinel Hardware Key" */
    'S','a','f','e','N','e','t',' ','S','e','n','t','i','n','e','l',' ','H','a','r','d','w','a','r','e',' ','K','e','y',
/* 0x0da30 = "Rhythmedics 6 BioData Integrator" */
    'R','h','y','t','h','m','e','d','i','c','s',' ','6',' ','B','i','o','\xe7',' ','I','n','t','e','g','r','a','t','o','r',
/* 0x0da4d = "C-Bus Multi-room Audio Matrix Switcher" */
    'C','-','B','u','s',' ','\xd6','-','r','o','o','m',' ','\x8b','M','a','t','r','i','x',' ','S','w','i','t','c','h','e','r',
/* 0x0da6a = "Chipsbank Microelectronics Co., Ltd" */
    'C','h','i','p','s','b','a','n','k',' ','M','i','c','r','o','e','l','e','c','t','r','o','n','i','c','s',' ','\x0e','\x16',
/* 0x0da87 = "miniVigor 128 ISDN TA [HFC-S]" */
    'm','i','n','i','V','i','g','o','r',' ','1','2','8',' ','I','S','D','N',' ','T','A',' ','[','H','F','C','-','S',']',
/* 0x0daa4 = "DWA-123 Wireless N 150 Adapter(rev.A1) [Ralink RT3370]" */
    'D','W','A','-','1','2','3',' ','\x01','N',' ','1','5','0',' ','\xbb','A','1',')',' ','[','\x93','R','T','3','3','7','0',']',
/* 0x0dac1 = "JETI Technische Instrumente GmbH" */
    'J','E','T','I',' ','T','e','c','h','n','i','s','c','h','e',' ','I','n','s','t','r','u','m','e','n','t','e',' ','\xfc',
/* 0x0dade = "Siemens Telecommunications Systems, Ltd" */
    'S','i','e','m','e','n','s',' ','T','e','l','e','c','o','m','m','u','n','i','c','a','t','i','o','n','s',' ','\xb8','\x16',
/* 0x0dafb = "DirecTV Broadband, Inc. (Telocity)" */
    'D','i','r','e','c','\xda','B','r','o','a','d','b','a','n','d',',',' ','\x07',' ','(','T','e','l','o','c','i','t','y',')',
/* 0x0db18 = "Arduino Robot Motor (CDC ACM)" */
    'A','r','d','u','i','n','o',' ','R','o','b','o','t',' ','M','o','t','o','r',' ','(','C','D','C',' ','A','C','M',')',
/* 0x0db35 = "Sansa E200 series in recovery mode" */
    'S','a','n','s','a',' ','E','2','0','0',' ','\x1d',' ','i','n',' ','r','e','c','o','v','e','r','y',' ','m','o','d','e',
/* 0x0db52 = "Keyboard [Diatec Filco Majestouch 1]" */
    '\x05',' ','[','D','i','a','t','e','c',' ','F','i','l','c','o',' ','M','a','j','e','s','t','o','u','c','h',' ','1',']',
/* 0x0db6f = "Samsung SE-506 Portable BluRay Disc Writer" */
    'S','a','m','s','u','n','g',' ','S','E','-','5','0','6',' ','\xa9','B','l','u','R','a','y',' ','D','i','s','c',' ','\xdf',
/* 0x0db8c = "VGA Video Sender (ACPI-compliant)" */
    'V','G','A',' ','\xa3',' ','S','e','n','d','e','r',' ','(','A','C','P','I','-','c','o','m','p','l','i','a','n','t',')',
/* 0x0dba9 = "Motorola Semiconductors HK, Ltd" */
    'M','o','t','o','r','o','l','a',' ','S','e','m','i','c','o','n','d','u','c','t','o','r','s',' ','H','K',',',' ','\x16',
/* 0x0dbc6 = "Aolynk WUB300g [ZyDAS ZD1211]" */
    'A','o','l','y','n','k',' ','W','U','B','3','0','0','g',' ','[','Z','y','D','A','S',' ','Z','D','1','2','1','1',']',
/* 0x0dbe3 = "VQ630 Dual Mode Digital Camera(Bulk)" */
    'V','Q','6','3','0',' ','D','u','a','l',' ','M','o','d','e',' ','\x09','C','a','m','e','r','a','(','B','u','l','k',')',
/* 0x0dc00 = "UPort 1450 4-Port RS-232/422/485" */
    'U','P','o','r','t',' ','1','4','5','0',' ','4','-','\x87',' ','R','S','-','2','3','2','/','4','2','2','/','4','8','5',
/* 0x0dc1d = "Gryphon series (RS-232 emulation mode)" */
    'G','r','y','p','h','o','n',' ','\x1d',' ','(','R','S','-','2','3','2',' ','e','m','u','l','a','t','i','o','n',' ','\x1a',
/* 0x0dc3a = "Combined audio and video input device" */
    'C','o','m','b','i','n','e','d',' ','a','u','d','i','o',' ','\xe4','v','i','d','e','o',' ','i','n','p','u','t',' ','\xf9',
/* 0x0dc57 = "Linux-USB Ethernet/RNDIS Gadget" */
    'L','i','n','u','x','-','\x0a',' ','E','t','h','e','r','n','e','t','/','R','N','D','I','S',' ','G','a','d','g','e','t',
/* 0x0dc74 = "Philips Research Laboratories" */
    'P','h','i','l','i','p','s',' ','R','e','s','e','a','r','c','h',' ','L','a','b','o','r','a','t','o','r','i','e','s',
/* 0x0dc91 = "Android Phone via PTP [Wiko Cink Peax 2]" */
    '\xce','\x19',' ','v','i','a',' ','P','T','P',' ','[','W','i','k','o',' ','C','i','n','k',' ','P','e','a','x',' ','2',']',
/* 0x0dcae = "AXiS-49 Harmonic Table MIDI Keyboard" */
    'A','X','i','S','-','4','9',' ','H','a','r','m','o','n','i','c',' ','T','a','b','l','e',' ','M','I','D','I',' ','\x05',
/* 0x0dccb = "Hauppauge WinTV-USB Model 40209 rev B243" */
    '\xfb','W','i','n','T','V','-','\x0a',' ','M','o','d','e','l',' ','4','0','2','0','9',' ','r','e','v',' ','B','2','4','3',
/* 0x0dce8 = "Compact Flash and Microdrive Reader (TPP)" */
    'C','o','m','p','a','c','t',' ','\x3c',' ','\xe4','M','i','c','r','o','d','r','i','v','e',' ','\x08',' ','(','T','P','P',')',
/* 0x0dd05 = "ADL Re-Flashing Engine Parent" */
    'A','D','L',' ','R','e','-','F','l','a','s','h','i','n','g',' ','E','n','g','i','n','e',' ','P','a','r','e','n','t',
/* 0x0dd22 = "Tt eSPORTS BLACK Gaming mouse" */
    'T','t',' ','e','S','P','O','R','T','S',' ','B','L','A','C','K',' ','G','a','m','i','n','g',' ','m','o','u','s','e',
/* 0x0dd3f = "DWA-130 802.11n Wireless N Adapter(rev.C2) [Realtek RTL8191SU]" */
    'D','W','A','-','1','3','0',' ','\x99','\x01','N',' ','\xbb','C','2',')',' ','[','\xbe','R','T','L','8','1','9','1','S','U',']',
/* 0x0dd5c = "Instant Video-To-Go RDX-160 (no firmware)" */
    'I','n','s','t','a','n','t',' ','\xa3','-','T','o','-','G','o',' ','R','D','X','-','1','6','0',' ','(','n','o',' ','\xdb',
/* 0x0dd79 = "SDDR-05a ImageMate CompactFlash Reader" */
    'S','D','D','R','-','0','5','a',' ','I','m','a','g','e','M','a','t','e',' ','C','o','m','p','a','c','t','\x3c',' ','\x08',
/* 0x0dd96 = "Natural Ergonomic Keyboard 4000 V1.0" */
    'N','a','t','u','r','a','l',' ','E','r','g','o','n','o','m','i','c',' ','\x05',' ','4','0','0','0',' ','V','1','.','0',
/* 0x0ddb3 = "U.S. Robotics USR5425 Wireless MAXg Adapter" */
    'U','.','S','.',' ','R','o','b','o','t','i','c','s',' ','U','S','R','5','4','2','5',' ','\x01','M','A','X','g',' ','\x02',
/* 0x0ddd0 = "Metronic 495257 wifi 802.11ng" */
    'M','e','t','r','o','n','i','c',' ','4','9','5','2','5','7',' ','w','i','f','i',' ','8','0','2','.','1','1','n','g',
/* 0x0dded = "OpenVizsla USB sniffer/analyzer" */
    'O','p','e','n','V','i','z','s','l','a',' ','\x0a',' ','s','n','i','f','f','e','r','/','a','n','a','l','y','z','e','r',
/* 0x0de0a = "WG121(v2) 54 Mbps Wireless [Intersil ISL3886]" */
    'W','G','1','2','1','(','v','2',')',' ','5','4',' ','M','b','p','s',' ','\x01','[','\xb0','I','S','L','3','8','8','6',']',
/* 0x0de27 = "Microcomputer Applications, Inc." */
    'M','i','c','r','o','c','o','m','p','u','t','e','r',' ','A','p','p','l','i','c','a','t','i','o','n','s',',',' ','\x07',
/* 0x0de44 = "WNDA3200 802.11abgn Wireless Adapter [Atheros AR7010+AR9280]" */
    'W','N','D','A','3','2','0','0',' ','\xea','\x01','\x02',' ','[','\xaf','A','R','7','0','1','0','+','A','R','9','2','8','0',']',
/* 0x0de61 = "Drinkbot (OTG-tablet support)" */
    'D','r','i','n','k','b','o','t',' ','(','O','T','G','-','t','a','b','l','e','t',' ','s','u','p','p','o','r','t',')',
/* 0x0de7e = "Kinesis Advantage PRO MPC/USB Keyboard" */
    'K','i','n','e','s','i','s',' ','A','d','v','a','n','t','a','g','e',' ','P','R','O',' ','M','P','C','/','\x0a',' ','\x05',
/* 0x0de9b = "Blackberry Playbook (CD-Rom mode)" */
    'B','l','a','c','k','b','e','r','r','y',' ','P','l','a','y','b','o','o','k',' ','(','C','D','-','R','o','m',' ','\x1a',
/* 0x0deb8 = "9500 GSM Communicator (RNDIS)" */
    '9','5','0','0',' ','G','S','M',' ','C','o','m','m','u','n','i','c','a','t','o','r',' ','(','R','N','D','I','S',')',
/* 0x0ded5 = "T-Mobile MyTouch 4G Slide [Doubleshot]" */
    'T','-','\x96',' ','M','y','\x9d',' ','4','G',' ','S','l','i','d','e',' ','[','D','o','u','b','l','e','s','h','o','t',']',
/* 0x0def2 = "AVM Fritz!WLAN USB (in CD-ROM-mode)" */
    'A','V','M',' ','F','r','i','t','z','!','W','L','A','N',' ','\x0a',' ','(','i','n',' ','C','D','-','R','O','M','-','\x1a',
/* 0x0df0f = "AG-200 802.11abg Wireless Adapter [Atheros AR5523]" */
    'A','G','-','2','0','0',' ','8','0','2','.','1','1','a','b','g',' ','\x01','\x02',' ','[','\xaf','A','R','5','5','2','3',']',
/* 0x0df2c = "Hauppauge WinTV-USB Model 40204 rev B283" */
    '\xfb','W','i','n','T','V','-','\x0a',' ','M','o','d','e','l',' ','4','0','2','0','4',' ','r','e','v',' ','B','2','8','3',
/* 0x0df49 = "Perfect Technic Enterprise Co., Ltd" */
    'P','e','r','f','e','c','t',' ','T','e','c','h','n','i','c',' ','E','n','t','e','r','p','r','i','s','e',' ','\x0e','\x16',
/* 0x0df66 = "CWD-854 Wireless 802.11g 54Mbps Network Adapter [RTL8187]" */
    'C','W','D','-','8','5','4',' ','\x01','\x94','5','4','M','b','p','s',' ','\x8d','\x02',' ','[','R','T','L','8','1','8','7',']',
/* 0x0df83 = "G-220 v3 802.11bg Wireless Adapter [ZyDAS ZD1211B]" */
    'G','-','2','2','0',' ','v','3',' ','\xad',' ','\x01','\x02',' ','[','Z','y','D','A','S',' ','Z','D','1','2','1','1','B',']',
/* 0x0dfa0 = "130 [RM-1035] (Charging only)" */
    '1','3','0',' ','[','R','M','-','1','0','3','5',']',' ','(','C','h','a','r','g','i','n','g',' ','o','n','l','y',')',
/* 0x0dfbd = "Expedite EU850D/EU860D/EU870D" */
    'E','x','p','e','d','i','t','e',' ','E','U','8','5','0','D','/','E','U','8','6','0','D','/','E','U','8','7','0','D',
/* 0x0dfda = "Hottinger Baldwin Measurement" */
    'H','o','t','t','i','n','g','e','r',' ','B','a','l','d','w','i','n',' ','M','e','a','s','u','r','e','m','e','n','t',
/* 0x0dff7 = "Siemens SpeedStream 100MBps Ethernet" */
    'S','i','e','m','e','n','s',' ','S','p','e','e','d','S','t','r','e','a','m',' ','1','0','0','M','B','p','s',' ','\x7f',
/* 0x0e014 = "GN 2000 Stereo Corded Headset" */
    'G','N',' ','2','0','0','0',' ','S','t','e','r','e','o',' ','C','o','r','d','e','d',' ','H','e','a','d','s','e','t',
/* 0x0e031 = "G3 (VS985) Android Phone (MTP/Download mode)" */
    'G','3',' ','(','V','S','9','8','5',')',' ','\xce','\x19',' ','(','M','T','P','/','D','o','w','n','l','o','a','d',' ','\x1a',
/* 0x0e04e = "ConnectCounty Holdings Berhad" */
    'C','o','n','n','e','c','t','C','o','u','n','t','y',' ','H','o','l','d','i','n','g','s',' ','B','e','r','h','a','d',
/* 0x0e06b = "GW-USDual300 802.11abgn Wireless Adapter [Realtek RTL8192DU]" */
    'G','W','-','U','S','D','u','a','l','3','0','0',' ','\xea','\x01','\x02',' ','[','\xbe','R','T','L','8','1','9','2','D','U',']',
/* 0x0e088 = "Touch Sensitive Intelligent Control Keypad STICK1A" */
    '\x9d',' ','S','e','n','s','i','t','i','v','e',' ','\xe0','\xc9',' ','K','e','y','p','a','d',' ','S','T','I','C','K','1','A',
/* 0x0e0a5 = "WUSB54GP v4.0 802.11g Adapter [Ralink RT2500USB]" */
    'W','U','S','B','5','4','G','P',' ','v','4','.','0',' ','\x94','\x02',' ','[','\x93','R','T','2','5','0','0','U','S','B',']',
/* 0x0e0c2 = "Loyalty Founder Enterprise Co., Ltd" */
    'L','o','y','a','l','t','y',' ','F','o','u','n','d','e','r',' ','E','n','t','e','r','p','r','i','s','e',' ','\x0e','\x16',
/* 0x0e0df = "Card Reader Controller RTS5101/RTS5111/RTS5116" */
    '\x15',' ','\x08',' ','\x13',' ','R','T','S','5','1','0','1','/','R','T','S','5','1','1','1','/','R','T','S','5','1','1','6',
/* 0x0e0fc = "Mega Sky 580 DVB-T Tuner [M902x]" */
    'M','e','g','a',' ','S','k','y',' ','5','8','0',' ','\xa7','T',' ','T','u','n','e','r',' ','[','M','9','0','2','x',']',
/* 0x0e119 = "ETS2252+ CDMA Fixed Wireless Terminal" */
    'E','T','S','2','2','5','2','+',' ','C','D','M','A',' ','F','i','x','e','d',' ','\x01','T','e','r','m','i','n','a','l',
/* 0x0e136 = "Hauppauge WinTV-USB Model 40205 rev B298" */
    '\xfb','W','i','n','T','V','-','\x0a',' ','M','o','d','e','l',' ','4','0','2','0','5',' ','r','e','v',' ','B','2','9','8',
/* 0x0e153 = "C03U multi-pattern microphone" */
    'C','0','3','U',' ','m','u','l','t','i','-','p','a','t','t','e','r','n',' ','m','i','c','r','o','p','h','o','n','e',
/* 0x0e170 = "Shenzhen Yuanchuan Electronic" */
    'S','h','e','n','z','h','e','n',' ','Y','u','a','n','c','h','u','a','n',' ','E','l','e','c','t','r','o','n','i','c',
/* 0x0e18d = "Dongguan Guneetal Wire & Cable Co., Ltd." */
    'D','o','n','g','g','u','a','n',' ','G','u','n','e','e','t','a','l',' ','W','i','r','e',' ','&',' ','\xa5',' ','\x0e','\xab',
/* 0x0e1aa = "RZ01-0036 Optical Gaming Mouse [Abyssus]" */
    'R','Z','0','1','-','0','0','3','6',' ','\x7b','G','a','m','i','n','g',' ','\x0b',' ','[','A','b','y','s','s','u','s',']',
/* 0x0e1c7 = "LDW-411SX DVD/CD Rewritable Drive" */
    'L','D','W','-','4','1','1','S','X',' ','D','V','D','/','C','D',' ','R','e','w','r','i','t','a','b','l','e',' ','\x14',
/* 0x0e1e4 = "Meinberg Funkuhren GmbH & Co. KG" */
    'M','e','i','n','b','e','r','g',' ','F','u','n','k','u','h','r','e','n',' ','\xfc',' ','&',' ','C','o','.',' ','K','G',
/* 0x0e201 = "BCM92046DG-CL1ROM Bluetooth 2.1 UHE Dongle" */
    'B','C','M','9','2','0','4','6','D','G','-','C','L','1','R','O','M',' ','\x06',' ','2','.','1',' ','U','H','E',' ','\xf4',
/* 0x0e21e = "PlayStation Move navigation controller" */
    'P','l','a','y','S','t','a','t','i','o','n',' ','M','o','v','e',' ','n','a','v','i','g','a','t','i','o','n',' ','\x9e',
/* 0x0e23b = "Optimus Android Phone [USB tethering mode]" */
    'O','p','t','i','m','u','s',' ','\xce','\x19',' ','[','\x0a',' ','t','e','t','h','e','r','i','n','g',' ','m','o','d','e',']',
/* 0x0e258 = "Zolix Omni 1509 monochromator" */
    'Z','o','l','i','x',' ','O','m','n','i',' ','1','5','0','9',' ','m','o','n','o','c','h','r','o','m','a','t','o','r',
/* 0x0e275 = "C8051F34x AudioDelay [AD-340]" */
    'C','8','0','5','1','F','3','4','x',' ','A','u','d','i','o','D','e','l','a','y',' ','[','A','D','-','3','4','0',']',
/* 0x0e292 = "Hauppauge WinTV-USB Model 40209 rev B234" */
    '\xfb','W','i','n','T','V','-','\x0a',' ','M','o','d','e','l',' ','4','0','2','0','9',' ','r','e','v',' ','B','2','3','4',
/* 0x0e2af = "CS124U Miniview II KVM Switch" */
    'C','S','1','2','4','U',' ','M','i','n','i','v','i','e','w',' ','I','I',' ','K','V','M',' ','S','w','i','t','c','h',
/* 0x0e2cc = "HTC42606 0G9AT00 [Iomega HDD]" */
    'H','T','C','4','2','6','0','6',' ','0','G','9','A','T','0','0',' ','[','I','o','m','e','g','a',' ','H','D','D',']',
/* 0x0e2e9 = "Steinberg Soft-und Hardware GmbH" */
    'S','t','e','i','n','b','e','r','g',' ','S','o','f','t','-','u','n','d',' ','H','a','r','d','w','a','r','e',' ','\xfc',
/* 0x0e306 = "Samsung Electro-Mechanics Co." */
    'S','a','m','s','u','n','g',' ','E','l','e','c','t','r','o','-','M','e','c','h','a','n','i','c','s',' ','C','o','.',
/* 0x0e323 = "My Book Home Edition (WDH1CS)" */
    'M','y',' ','B','o','o','k',' ','H','o','m','e',' ','E','d','i','t','i','o','n',' ','(','W','D','H','1','C','S',')',
/* 0x0e340 = "Scanjet Professional 1000 Mobile Scanner" */
    'S','c','a','n','j','e','t',' ','P','r','o','f','e','s','s','i','o','n','a','l',' ','1','0','0','0',' ','\x96',' ','\x25',
/* 0x0e35d = "Traveler TV 6500 SF Dia-scanner" */
    'T','r','a','v','e','l','e','r',' ','\xda','6','5','0','0',' ','S','F',' ','D','i','a','-','s','c','a','n','n','e','r',
/* 0x0e37a = "Professional Multimedia Testing Centre" */
    'P','r','o','f','e','s','s','i','o','n','a','l',' ','\xe2',' ','T','e','s','t','i','n','g',' ','C','e','n','t','r','e',
/* 0x0e397 = "GW-USFang300 802.11abgn Wireless Adapter [Realtek RTL8192DU]" */
    'G','W','-','U','S','F','a','n','g','3','0','0',' ','\xea','\x01','\x02',' ','[','\xbe','R','T','L','8','1','9','2','D','U',']',
/* 0x0e3b4 = "DWA-125 Wireless N 150 Adapter(rev.A2) [Ralink RT3070]" */
    'D','W','A','-','1','2','5',' ','\x01','N',' ','1','5','0',' ','\xbb','A','2',')',' ','[','\x93','R','T','3','0','7','0',']',
/* 0x0e3d1 = "Patriot (firmware not loaded)" */
    'P','a','t','r','i','o','t',' ','(','f','i','r','m','w','a','r','e',' ','n','o','t',' ','l','o','a','d','e','d',')',
/* 0x0e3ee = "BETTER WIRE FACTORY CO., LTD." */
    'B','E','T','T','E','R',' ','W','I','R','E',' ','F','A','C','T','O','R','Y',' ','C','O','.',',',' ','L','T','D','.',
/* 0x0e40b = "CTE-650 [Bamboo Fun (medium)]" */
    'C','T','E','-','6','5','0',' ','[','B','a','m','b','o','o',' ','F','u','n',' ','(','m','e','d','i','u','m',')',']',
/* 0x0e428 = "Color 320 x 240 LCD Display Terminal with Touchscreen" */
    '\xa2',' ','3','2','0',' ','x',' ','2','4','0',' ','L','C','D',' ','\xcf',' ','T','e','r','m','i','n','a','l',' ','\x98','\xb5',
/* 0x0e445 = "EZ-Link Loader (EZLNKLDR.SYS)" */
    'E','Z','-','L','i','n','k',' ','L','o','a','d','e','r',' ','(','E','Z','L','N','K','L','D','R','.','S','Y','S',')',
/* 0x0e462 = "GERTEC Telecomunicacoes Ltda." */
    'G','E','R','T','E','C',' ','T','e','l','e','c','o','m','u','n','i','c','a','c','o','e','s',' ','L','t','d','a','.',
/* 0x0e47f = "802AIN Wireless N Network Adapter [Atheros AR9170+AR9101]" */
    '8','0','2','A','I','N',' ','\x01','N',' ','\x8d','\x02',' ','[','\xaf','A','R','9','1','7','0','+','A','R','9','1','0','1',']',
/* 0x0e49c = "4410a Wireless-G Adapter [Intersil ISL3887]" */
    '4','4','1','0','a',' ','W','i','r','e','l','e','s','s','-','G',' ','\x02',' ','[','\xb0','I','S','L','3','8','8','7',']',
/* 0x0e4b9 = "LPC2378 [Robotino Bootloader]" */
    'L','P','C','2','3','7','8',' ','[','R','o','b','o','t','i','n','o',' ','B','o','o','t','l','o','a','d','e','r',']',
/* 0x0e4d6 = "DTK-2400 [Cintiq 24HD] tablet" */
    'D','T','K','-','2','4','0','0',' ','[','C','i','n','t','i','q',' ','2','4','H','D',']',' ','t','a','b','l','e','t',
/* 0x0e4f3 = "AirLive X.USB 802.11abgn [Atheros AR9170+AR9104]" */
    'A','i','r','L','i','v','e',' ','X','.','\x0a',' ','\xea','[','\xaf','A','R','9','1','7','0','+','A','R','9','1','0','4',']',
/* 0x0e510 = "F7D1101 v2 Basic Wireless Adapter [Ralink RT3370]" */
    'F','7','D','1','1','0','1',' ','v','2',' ','B','a','s','i','c',' ','\x01','\x02',' ','[','\x93','R','T','3','3','7','0',']',
/* 0x0e52d = "660i/6600i Slide Phone (Mass Storage)" */
    '6','6','0','i','/','6','6','0','0','i',' ','S','l','i','d','e',' ','\x19',' ','(','\x7c','S','t','o','r','a','g','e',')',
/* 0x0e54a = "RocketFish SATA Bridge [INIC-1611]" */
    'R','o','c','k','e','t','F','i','s','h',' ','S','A','T','A',' ','\x9f',' ','[','I','N','I','C','-','1','6','1','1',']',
/* 0x0e567 = "DHN-120 10Mb Home Phoneline Adapter" */
    'D','H','N','-','1','2','0',' ','1','0','M','b',' ','H','o','m','e',' ','P','h','o','n','e','l','i','n','e',' ','\x02',
/* 0x0e584 = "3Com 3CRUSBN275 802.11abgn Wireless Adapter [Atheros AR9170]" */
    '3','C','o','m',' ','3','C','R','U','S','B','N','2','7','5',' ','\xea','\x01','\x02',' ','[','\xaf','A','R','9','1','7','0',']',
/* 0x0e5a1 = "Supercomal Wire & Cable SDN. BHD." */
    'S','u','p','e','r','c','o','m','a','l',' ','W','i','r','e',' ','&',' ','\xa5',' ','S','D','N','.',' ','B','H','D','.',
/* 0x0e5be = "Typhoon Webshot II Webcam [zc0301]" */
    'T','y','p','h','o','o','n',' ','W','e','b','s','h','o','t',' ','I','I',' ','\x11',' ','[','z','c','0','3','0','1',']',
/* 0x0e5db = "DWA-125 Wireless N 150 Adapter(rev.A3) [Ralink RT5370]" */
    'D','W','A','-','1','2','5',' ','\x01','N',' ','1','5','0',' ','\xbb','A','3',')',' ','[','\x93','R','T','5','3','7','0',']',
/* 0x0e5f8 = "Black Magic Debug Probe (DFU)" */
    'B','l','a','c','k',' ','M','a','g','i','c',' ','D','e','b','u','g',' ','P','r','o','b','e',' ','(','D','F','U',')',
/* 0x0e615 = "Arduino Leonardo (bootloader)" */
    'A','r','d','u','i','n','o',' ','L','e','o','n','a','r','d','o',' ','(','b','o','o','t','l','o','a','d','e','r',')',
/* 0x0e632 = "Enhanced RoboBrrd Brain board" */
    'E','n','h','a','n','c','e','d',' ','R','o','b','o','B','r','r','d',' ','B','r','a','i','n',' ','b','o','a','r','d',
/* 0x0e64f = "Nippon Telegraph and Telephone Corp." */
    'N','i','p','p','o','n',' ','T','e','l','e','g','r','a','p','h',' ','\xe4','T','e','l','e','p','h','o','n','e',' ','\x10',
/* 0x0e66c = "Keyboard [Diatec Filco Majestouch 2]" */
    '\x05',' ','[','D','i','a','t','e','c',' ','F','i','l','c','o',' ','M','a','j','e','s','t','o','u','c','h',' ','2',']',
/* 0x0e689 = "3Dconnexion SpacePilot Pro 3D Mouse" */
    '3','D','c','o','n','n','e','x','i','o','n',' ','S','p','a','c','e','P','i','l','o','t',' ','\x8f',' ','3','D',' ','\x0b',
/* 0x0e6a6 = "Dream Cheeky Webmail Notifier" */
    'D','r','e','a','m',' ','C','h','e','e','k','y',' ','W','e','b','m','a','i','l',' ','N','o','t','i','f','i','e','r',
/* 0x0e6c3 = "Flex-P Industries, Snd., Bhd." */
    'F','l','e','x','-','P',' ','I','n','d','u','s','t','r','i','e','s',',',' ','S','n','d','.',',',' ','B','h','d','.',
/* 0x0e6e0 = "F5D7050 Wireless G Adapter v3000 [Ralink RT2571W]" */
    'F','5','D','7','0','5','0',' ','\x01','G',' ','\x02',' ','v','3','0','0','0',' ','[','\x93','R','T','2','5','7','1','W',']',
/* 0x0e6fd = "Guardant Stealth 3 Sign/Time" */
    'G','u','a','r','d','a','n','t',' ','S','t','e','a','l','t','h',' ','3',' ','S','i','g','n','/','T','i','m','e',
/* 0x0e719 = "GemProx-PU Contactless Smart Card Reader" */
    'G','e','m','P','r','o','x','-','P','U',' ','C','o','n','t','a','c','t','l','e','s','s',' ','\x12',' ','\x15',' ','\x08',
/* 0x0e735 = "Japan Aviation Electronics Industry, Ltd" */
    'J','a','p','a','n',' ','A','v','i','a','t','i','o','n',' ','\x1b',' ','I','n','d','u','s','t','r','y',',',' ','\x16',
/* 0x0e751 = "Finger Lakes Instrumentation" */
    'F','i','n','g','e','r',' ','L','a','k','e','s',' ','I','n','s','t','r','u','m','e','n','t','a','t','i','o','n',
/* 0x0e76d = "WU830G 802.11bg Wireless Adapter [Envara WiND512]" */
    'W','U','8','3','0','G',' ','\xad',' ','\x01','\x02',' ','[','E','n','v','a','r','a',' ','W','i','N','D','5','1','2',']',
/* 0x0e789 = "5 MegaPixel Digital Still Camera [DSC5M]" */
    '5',' ','M','e','g','a','P','i','x','e','l',' ','\x09','S','t','i','l','l',' ','\x04',' ','[','D','S','C','5','M',']',
/* 0x0e7a5 = "NOMAD Jukebox Zen Xtra (mtp)" */
    'N','O','M','A','D',' ','J','u','k','e','b','o','x',' ','Z','e','n',' ','X','t','r','a',' ','(','m','t','p',')',
/* 0x0e7c1 = "TI-84 Plus Silver Calculator" */
    'T','I','-','8','4',' ','P','l','u','s',' ','S','i','l','v','e','r',' ','C','a','l','c','u','l','a','t','o','r',
/* 0x0e7dd = "CTE-450 [Bamboo Fun (small)]" */
    'C','T','E','-','4','5','0',' ','[','B','a','m','b','o','o',' ','F','u','n',' ','(','s','m','a','l','l',')',']',
/* 0x0e7f9 = "OEM 3 axis 5 button joystick" */
    'O','E','M',' ','3',' ','a','x','i','s',' ','5',' ','b','u','t','t','o','n',' ','j','o','y','s','t','i','c','k',
/* 0x0e815 = "AT91SAM CDC Demo Application" */
    'A','T','9','1','S','A','M',' ','C','D','C',' ','D','e','m','o',' ','A','p','p','l','i','c','a','t','i','o','n',
/* 0x0e831 = "SparkLAN WL-682 802.11bg Wireless Adapter [Intersil ISL3887]" */
    'S','p','a','r','k','\xf3','W','L','-','6','8','2',' ','\xad',' ','\x01','\x02',' ','[','\xb0','I','S','L','3','8','8','7',']',
/* 0x0e84d = "Docking Station Topline 2009" */
    'D','o','c','k','i','n','g',' ','S','t','a','t','i','o','n',' ','T','o','p','l','i','n','e',' ','2','0','0','9',
/* 0x0e869 = "CTH-480 [Intuos Pen & Touch (S)]" */
    'C','T','H','-','4','8','0',' ','[','I','n','t','u','o','s',' ','P','e','n',' ','&',' ','\x9d',' ','(','S',')',']',
/* 0x0e885 = "Certis V2 fingerprint reader" */
    'C','e','r','t','i','s',' ','V','2',' ','f','i','n','g','e','r','p','r','i','n','t',' ','r','e','a','d','e','r',
/* 0x0e8a1 = "COMpact 2104 DSL (DSL modem)" */
    'C','O','M','p','a','c','t',' ','2','1','0','4',' ','D','S','L',' ','(','D','S','L',' ','m','o','d','e','m',')',
/* 0x0e8bd = "Hayes Microcomputer Products" */
    'H','a','y','e','s',' ','M','i','c','r','o','c','o','m','p','u','t','e','r',' ','P','r','o','d','u','c','t','s',
/* 0x0e8d9 = "CTH-460 [Bamboo Pen & Touch]" */
    'C','T','H','-','4','6','0',' ','[','B','a','m','b','o','o',' ','P','e','n',' ','&',' ','T','o','u','c','h',']',
/* 0x0e8f5 = "LevelOne WUA-0615 N_Max Wireless USB Adapter" */
    'L','e','v','e','l','O','n','e',' ','W','U','A','-','0','6','1','5',' ','N','_','M','a','x',' ','\x01','\x0a',' ','\x02',
/* 0x0e911 = "AFG Function Generator (CDC)" */
    'A','F','G',' ','F','u','n','c','t','i','o','n',' ','G','e','n','e','r','a','t','o','r',' ','(','C','D','C',')',
/* 0x0e92d = "GT-8400UF [Perfection 1670/1670 PHOTO]" */
    'G','T','-','8','4','0','0','U','F',' ','[','\xf0','1','6','7','0','/','1','6','7','0',' ','P','H','O','T','O',']',
/* 0x0e949 = "WeiDuan Electronic Accessory (S.Z.) Co., Ltd." */
    'W','e','i','D','u','a','n',' ','\xba','A','c','c','e','s','s','o','r','y',' ','(','S','.','Z','.',')',' ','\x0e','\xab',
/* 0x0e965 = "WL-160g 802.11g Wireless Adapter [Envara WiND512]" */
    'W','L','-','1','6','0','g',' ','\x94','\x01','\x02',' ','[','E','n','v','a','r','a',' ','W','i','N','D','5','1','2',']',
/* 0x0e981 = "CTH-680 [Intuos Pen & Touch (M)]" */
    'C','T','H','-','6','8','0',' ','[','I','n','t','u','o','s',' ','P','e','n',' ','&',' ','\x9d',' ','(','M',')',']',
/* 0x0e99d = "Saitek X52 Pro Flight Control System" */
    'S','a','i','t','e','k',' ','X','5','2',' ','\x8f',' ','F','l','i','g','h','t',' ','\xc9',' ','S','y','s','t','e','m',
/* 0x0e9b9 = "GT-B3730 Composite LTE device (Commercial)" */
    'G','T','-','B','3','7','3','0',' ','\x60','L','T','E',' ','\xf9',' ','(','C','o','m','m','e','r','c','i','a','l',')',
/* 0x0e9d5 = "SurfBoard SB5120 Cable Modem (RNDIS)" */
    'S','u','r','f','B','o','a','r','d',' ','S','B','5','1','2','0',' ','\xa5',' ','\x1c',' ','(','R','N','D','I','S',')',
/* 0x0e9f1 = "2M pixel Microscope Camera (Mk 2)" */
    '2','M',' ','p','i','x','e','l',' ','M','i','c','r','o','s','c','o','p','e',' ','\x04',' ','(','M','k',' ','2',')',
/* 0x0ea0d = "Orbit Trackball with Scroll Ring" */
    'O','r','b','i','t',' ','T','r','a','c','k','b','a','l','l',' ','\x98','S','c','r','o','l','l',' ','R','i','n','g',
/* 0x0ea29 = "Complex Micro Interconnection Co., Ltd" */
    'C','o','m','p','l','e','x',' ','\xc4',' ','I','n','t','e','r','c','o','n','n','e','c','t','i','o','n',' ','\x0e','\x16',
/* 0x0ea45 = "Earthmate GPS (LT-20, LT-40)" */
    'E','a','r','t','h','m','a','t','e',' ','G','P','S',' ','(','L','T','-','2','0',',',' ','L','T','-','4','0',')',
/* 0x0ea61 = "Philips Semiconductors, CICT" */
    'P','h','i','l','i','p','s',' ','S','e','m','i','c','o','n','d','u','c','t','o','r','s',',',' ','C','I','C','T',
/* 0x0ea7d = "Nintendo Game Boy Advance SP" */
    'N','i','n','t','e','n','d','o',' ','G','a','m','e',' ','B','o','y',' ','A','d','v','a','n','c','e',' ','S','P',
/* 0x0ea99 = "COMpact 4406 DSL (DSL modem)" */
    'C','O','M','p','a','c','t',' ','4','4','0','6',' ','D','S','L',' ','(','D','S','L',' ','m','o','d','e','m',')',
/* 0x0eab5 = "CTE-460 [Bamboo One Pen (S)]" */
    'C','T','E','-','4','6','0',' ','[','B','a','m','b','o','o',' ','O','n','e',' ','P','e','n',' ','(','S',')',']',
/* 0x0ead1 = "USBTV007 Video Grabber [EasyCAP]" */
    'U','S','B','T','V','0','0','7',' ','\xa3',' ','G','r','a','b','b','e','r',' ','[','E','a','s','y','C','A','P',']',
/* 0x0eaed = "F5D7051 802.11g Adapter v1000 [Broadcom 4320 USB]" */
    'F','5','D','7','0','5','1',' ','\x94','\x02',' ','v','1','0','0','0',' ','[','\xeb','4','3','2','0',' ','U','S','B',']',
/* 0x0eb09 = "V972 tablet in flashing mode" */
    'V','9','7','2',' ','t','a','b','l','e','t',' ','i','n',' ','f','l','a','s','h','i','n','g',' ','m','o','d','e',
/* 0x0eb25 = "Generic Controller - Single interface" */
    'G','e','n','e','r','i','c',' ','\x13',' ','-',' ','S','i','n','g','l','e',' ','i','n','t','e','r','f','a','c','e',
/* 0x0eb41 = "Arduino Explora (bootloader)" */
    'A','r','d','u','i','n','o',' ','E','x','p','l','o','r','a',' ','(','b','o','o','t','l','o','a','d','e','r',')',
/* 0x0eb5d = "Q2U handheld microphone with XLR" */
    'Q','2','U',' ','h','a','n','d','h','e','l','d',' ','m','i','c','r','o','p','h','o','n','e',' ','\x98','X','L','R',
/* 0x0eb79 = "Eee PC 701 SD Card Reader [ENE UB6225]" */
    'E','e','e',' ','\x1f','7','0','1',' ','S','D',' ','\x15',' ','\x08',' ','[','E','N','E',' ','U','B','6','2','2','5',']',
/* 0x0eb95 = "Optimus Android Phone [Virtual CD mode]" */
    'O','p','t','i','m','u','s',' ','\xce','\x19',' ','[','V','i','r','t','u','a','l',' ','C','D',' ','m','o','d','e',']',
/* 0x0ebb1 = "Fujitsu Computer Products of America" */
    'F','u','j','i','t','s','u',' ','\xcd','P','r','o','d','u','c','t','s',' ','o','f',' ','A','m','e','r','i','c','a',
/* 0x0ebcd = "F5D8053 N Wireless Adapter v3000 [Ralink RT2870]" */
    'F','5','D','8','0','5','3',' ','N',' ','\x01','\x02',' ','v','3','0','0','0',' ','[','\x93','R','T','2','8','7','0',']',
/* 0x0ebe9 = "PRS-300/PRS-505 eBook reader" */
    'P','R','S','-','3','0','0','/','P','R','S','-','5','0','5',' ','e','B','o','o','k',' ','r','e','a','d','e','r',
/* 0x0ec05 = "Andrew Pargeter & Associates" */
    'A','n','d','r','e','w',' ','P','a','r','g','e','t','e','r',' ','&',' ','A','s','s','o','c','i','a','t','e','s',
/* 0x0ec21 = "Matsushita Electric Works, Ltd." */
    'M','a','t','s','u','s','h','i','t','a',' ','E','l','e','c','t','r','i','c',' ','W','o','r','k','s',',',' ','\xab',
/* 0x0ec3d = "LevelOne WUA-0605 N_Max Wireless USB Adapter" */
    'L','e','v','e','l','O','n','e',' ','W','U','A','-','0','6','0','5',' ','N','_','M','a','x',' ','\x01','\x0a',' ','\x02',
/* 0x0ec59 = "Software Bisque Paramount ME" */
    'S','o','f','t','w','a','r','e',' ','B','i','s','q','u','e',' ','P','a','r','a','m','o','u','n','t',' ','M','E',
/* 0x0ec75 = "Philips Creative Display Solutions" */
    'P','h','i','l','i','p','s',' ','C','r','e','a','t','i','v','e',' ','\xcf',' ','S','o','l','u','t','i','o','n','s',
/* 0x0ec91 = "LUFA Audio Input Demo Application" */
    'L','U','F','A',' ','\x8b','I','n','p','u','t',' ','D','e','m','o',' ','A','p','p','l','i','c','a','t','i','o','n',
/* 0x0ecad = "Premium Stereo USB Headset 350" */
    'P','r','e','m','i','u','m',' ','S','t','e','r','e','o',' ','\x0a',' ','H','e','a','d','s','e','t',' ','3','5','0',
/* 0x0ecc9 = "Axiohm Transaction Solutions" */
    'A','x','i','o','h','m',' ','T','r','a','n','s','a','c','t','i','o','n',' ','S','o','l','u','t','i','o','n','s',
/* 0x0ece5 = "Innovative Semiconductors, Inc." */
    'I','n','n','o','v','a','t','i','v','e',' ','S','e','m','i','c','o','n','d','u','c','t','o','r','s',',',' ','\x07',
/* 0x0ed01 = "Yubikey NEO(-N) OTP+U2F+CCID" */
    'Y','u','b','i','k','e','y',' ','N','E','O','(','-','N',')',' ','O','T','P','+','U','2','F','+','C','C','I','D',
/* 0x0ed1d = "Tactrix OpenPort 1.3 Mitsubishi" */
    'T','a','c','t','r','i','x',' ','O','p','e','n','\x87',' ','1','.','3',' ','M','i','t','s','u','b','i','s','h','i',
/* 0x0ed39 = "Ralink RT3070 802.11b/g/n Wireless Lan USB Device" */
    '\x93','R','T','3','0','7','0',' ','8','0','2','.','1','1','b','/','g','/','n',' ','\x01','L','a','n',' ','\x0a',' ','\x03',
/* 0x0ed55 = "Y-BF37 [Internet Navigator Keyboard]" */
    'Y','-','B','F','3','7',' ','[','\xb6','N','a','v','i','g','a','t','o','r',' ','K','e','y','b','o','a','r','d',']',
/* 0x0ed71 = "Ir reciver f. remote control" */
    'I','r',' ','r','e','c','i','v','e','r',' ','f','.',' ','r','e','m','o','t','e',' ','c','o','n','t','r','o','l',
/* 0x0ed8d = "SNIkey Keyboard, SNIKey-KB-USB" */
    'S','N','I','k','e','y',' ','K','e','y','b','o','a','r','d',',',' ','S','N','I','K','e','y','-','K','B','-','\x0a',
/* 0x0eda9 = "AirPlus Xtreme G DWL-G132 Wireless Adapter" */
    'A','i','r','P','l','u','s',' ','X','t','r','e','m','e',' ','G',' ','D','W','L','-','G','1','3','2',' ','\x01','\x02',
/* 0x0edc5 = "Memorex Optical ScrollPro Mouse SE MX4600" */
    'M','e','m','o','r','e','x',' ','\x7b','S','c','r','o','l','l','\x8f',' ','\x0b',' ','S','E',' ','M','X','4','6','0','0',
/* 0x0ede1 = "Gravis Eliminator AfterShock" */
    'G','r','a','v','i','s',' ','E','l','i','m','i','n','a','t','o','r',' ','A','f','t','e','r','S','h','o','c','k',
/* 0x0edfd = "LapLink Gold USB-USB Bridge [net1080]" */
    'L','a','p','L','i','n','k',' ','G','o','l','d',' ','\x0a','-','\x0a',' ','\x9f',' ','[','n','e','t','1','0','8','0',']',
/* 0x0ee19 = "QuickCam Communicate Deluxe/S7500" */
    '\xc7','a','m',' ','C','o','m','m','u','n','i','c','a','t','e',' ','D','e','l','u','x','e','/','S','7','5','0','0',
/* 0x0ee35 = "LifeCam NX-3000 (UVC-compliant)" */
    'L','i','f','e','\x9a','N','X','-','3','0','0','0',' ','(','U','V','C','-','c','o','m','p','l','i','a','n','t',')',
/* 0x0ee51 = "Digby\'s Bitpile, Inc. DBA D Bit" */
    'D','i','g','b','y','\'','s',' ','B','i','t','p','i','l','e',',',' ','\x07',' ','D','B','A',' ','D',' ','B','i','t',
/* 0x0ee6d = "DWA-130 802.11n Wireless N Adapter(rev.E) [Realtek RTL8191SU]" */
    'D','W','A','-','1','3','0',' ','\x99','\x01','N',' ','\xbb','E',')',' ','[','\xbe','R','T','L','8','1','9','1','S','U',']',
/* 0x0ee89 = "USB100TX HomePNA Ethernet [pegasus]" */
    'U','S','B','1','0','0','T','X',' ','H','o','m','e','P','N','A',' ','\x7f',' ','[','p','e','g','a','s','u','s',']',
/* 0x0eea5 = "ABILITY ENTERPRISE CO., LTD." */
    'A','B','I','L','I','T','Y',' ','E','N','T','E','R','P','R','I','S','E',' ','C','O','.',',',' ','L','T','D','.',
/* 0x0eec1 = "microSD card reader (SY-T18)" */
    'm','i','c','r','o','S','D',' ','c','a','r','d',' ','r','e','a','d','e','r',' ','(','S','Y','-','T','1','8',')',
/* 0x0eedd = "Aaronia AG UBBV Preamplifier" */
    'A','a','r','o','n','i','a',' ','A','G',' ','U','B','B','V',' ','P','r','e','a','m','p','l','i','f','i','e','r',
/* 0x0eef9 = "Deck 82-key backlit keyboard" */
    'D','e','c','k',' ','8','2','-','k','e','y',' ','b','a','c','k','l','i','t',' ','k','e','y','b','o','a','r','d',
/* 0x0ef15 = "Connectivity Cable (CA-42 clone)" */
    'C','o','n','n','e','c','t','i','v','i','t','y',' ','\xa5',' ','(','C','A','-','4','2',' ','c','l','o','n','e',')',
/* 0x0ef31 = "Digital IXUS 30 (PTP mode) / PowerShot SD200 (PTP mode)" */
    '\x09','\xfd','3','0',' ','(','P','T','P',' ','\x1a',' ','/',' ','\x24','\x84','S','D','2','0','0',' ','(','P','T','P',' ','\x1a',
/* 0x0ef4d = "Actions Microelectronics Co." */
    'A','c','t','i','o','n','s',' ','M','i','c','r','o','e','l','e','c','t','r','o','n','i','c','s',' ','C','o','.',
/* 0x0ef69 = "PowerShot G6 (normal mode) / PowerShot G6 (PTP mode)" */
    '\x24','\x84','G','6',' ','(','n','o','r','m','a','l',' ','\x1a',' ','/',' ','\x24','\x84','G','6',' ','(','P','T','P',' ','\x1a',
/* 0x0ef85 = "QL-500 P-touch label printer" */
    'Q','L','-','5','0','0',' ','P','-','t','o','u','c','h',' ','l','a','b','e','l',' ','p','r','i','n','t','e','r',
/* 0x0efa1 = "USR5423 802.11bg Wireless Adapter [ZyDAS ZD1211B]" */
    'U','S','R','5','4','2','3',' ','\xad',' ','\x01','\x02',' ','[','Z','y','D','A','S',' ','Z','D','1','2','1','1','B',']',
/* 0x0efbd = "Nostromo n52 HID SpeedPad Mouse Wheel" */
    'N','o','s','t','r','o','m','o',' ','n','5','2',' ','\xf2','S','p','e','e','d','\xfa',' ','\x0b',' ','W','h','e','e','l',
/* 0x0efd9 = "NWD271N 802.11n Wireless Adapter [Atheros AR9001U-(2)NG]" */
    'N','W','D','2','7','1','N',' ','\x99','\x01','\x02',' ','[','\xaf','A','R','9','0','0','1','U','-','(','2',')','N','G',']',
/* 0x0eff5 = "PhidgetAccelerometer Ver 1.0" */
    'P','h','i','d','g','e','t','A','c','c','e','l','e','r','o','m','e','t','e','r',' ','V','e','r',' ','1','.','0',
/* 0x0f011 = "Stylus CX5900/CX5000/DX5000/DX5050" */
    '\xb1','C','X','5','9','0','0','/','C','X','5','0','0','0','/','D','X','5','0','0','0','/','D','X','5','0','5','0',
/* 0x0f02d = "ALPHA-SAT TECHNOLOGY LIMITED" */
    'A','L','P','H','A','-','S','A','T',' ','T','E','C','H','N','O','L','O','G','Y',' ','L','I','M','I','T','E','D',
/* 0x0f049 = "Pro Flight Yoke integrated hub" */
    '\x8f',' ','F','l','i','g','h','t',' ','Y','o','k','e',' ','i','n','t','e','g','r','a','t','e','d',' ','h','u','b',
/* 0x0f065 = "Powershot ELPH 120 IS / IXUS 135" */
    'P','o','w','e','r','s','h','o','t',' ','E','L','P','H',' ','1','2','0',' ','I','S',' ','/',' ','\xfd','1','3','5',
/* 0x0f081 = "keyman64 keyboard itercepter" */
    'k','e','y','m','a','n','6','4',' ','k','e','y','b','o','a','r','d',' ','i','t','e','r','c','e','p','t','e','r',
/* 0x0f09d = "SpeechMike II Pro Plus LFH5276" */
    'S','p','e','e','c','h','M','i','k','e',' ','I','I',' ','\x8f',' ','P','l','u','s',' ','L','F','H','5','2','7','6',
/* 0x0f0b9 = "CTE-660 [Bamboo One Pen (M)]" */
    'C','T','E','-','6','6','0',' ','[','B','a','m','b','o','o',' ','O','n','e',' ','P','e','n',' ','(','M',')',']',
/* 0x0f0d5 = "Tegra 2 AC100 developer mode" */
    'T','e','g','r','a',' ','2',' ','A','C','1','0','0',' ','d','e','v','e','l','o','p','e','r',' ','m','o','d','e',
/* 0x0f0f1 = "LifeCam VX-7000 (UVC-compliant)" */
    'L','i','f','e','\x9a','V','X','-','7','0','0','0',' ','(','U','V','C','-','c','o','m','p','l','i','a','n','t',')',
/* 0x0f10d = "DT9836 data acquisition card" */
    'D','T','9','8','3','6',' ','d','a','t','a',' ','a','c','q','u','i','s','i','t','i','o','n',' ','c','a','r','d',
/* 0x0f129 = "AN2131 EZUSB Microcontroller" */
    'A','N','2','1','3','1',' ','E','Z','U','S','B',' ','M','i','c','r','o','c','o','n','t','r','o','l','l','e','r',
/* 0x0f145 = "Frontline Test Equipment Bluetooth Device" */
    'F','r','o','n','t','l','i','n','e',' ','T','e','s','t',' ','E','q','u','i','p','m','e','n','t',' ','\x06',' ','\x03',
/* 0x0f161 = "WLI-U2-KG125S 802.11g Adapter [Broadcom 4320 USB]" */
    'W','L','I','-','U','2','-','K','G','1','2','5','S',' ','\x94','\x02',' ','[','\xeb','4','3','2','0',' ','U','S','B',']',
/* 0x0f17d = "3M pixel Microscope Camera (Mk 2)" */
    '3','M',' ','p','i','x','e','l',' ','M','i','c','r','o','s','c','o','p','e',' ','\x04',' ','(','M','k',' ','2',')',
/* 0x0f199 = "Alpermann+Velte Studio Clock" */
    'A','l','p','e','r','m','a','n','n','+','V','e','l','t','e',' ','S','t','u','d','i','o',' ','C','l','o','c','k',
/* 0x0f1b5 = "KwikLink Host-Host Connector" */
    'K','w','i','k','L','i','n','k',' ','H','o','s','t','-','H','o','s','t',' ','C','o','n','n','e','c','t','o','r',
/* 0x0f1d1 = "Nital Consulting Services, Inc." */
    'N','i','t','a','l',' ','C','o','n','s','u','l','t','i','n','g',' ','S','e','r','v','i','c','e','s',',',' ','\x07',
/* 0x0f1ed = "SuperDisk 120MB (Authenticated)" */
    'S','u','p','e','r','\xe8',' ','1','2','0','M','B',' ','(','A','u','t','h','e','n','t','i','c','a','t','e','d',')',
/* 0x0f209 = "CG-WLUSB2GTST 802.11g Wireless Adapter [Intersil ISL3887]" */
    'C','G','-','W','L','U','S','B','2','G','T','S','T',' ','\x94','\x01','\x02',' ','[','\xb0','I','S','L','3','8','8','7',']',
/* 0x0f225 = "FX-USB-AW/-BD RS482 Converters" */
    'F','X','-','\x0a','-','A','W','/','-','B','D',' ','R','S','4','8','2',' ','C','o','n','v','e','r','t','e','r','s',
/* 0x0f241 = "F5D5055 Gigabit Network Adapter [AX88xxx]" */
    'F','5','D','5','0','5','5',' ','G','i','g','a','b','i','t',' ','\x8d','\x02',' ','[','A','X','8','8','x','x','x',']',
/* 0x0f25d = "Wireless 355 Module with Bluetooth 2.0 + EDR Technology." */
    '\x01','3','5','5',' ','\xe5',' ','\x98','\x06',' ','\xc1','+',' ','E','D','R',' ','T','e','c','h','n','o','l','o','g','y','.',
/* 0x0f279 = "Pencam SD 2M (mass storage mode)" */
    'P','e','n','c','a','m',' ','S','D',' ','2','M',' ','(','m','a','s','s',' ','s','t','o','r','a','g','e',' ','\x1a',
/* 0x0f295 = "Speedport W 102 Stick IEEE 802.11n USB 2.0 Adapter" */
    'S','p','e','e','d','p','o','r','t',' ','W',' ','1','0','2',' ','\xb3',' ','I','E','E','E',' ','\x99','\x0a',' ','\xc1','\x02',
/* 0x0f2b1 = "QL-550 P-touch label printer" */
    'Q','L','-','5','5','0',' ','P','-','t','o','u','c','h',' ','l','a','b','e','l',' ','p','r','i','n','t','e','r',
/* 0x0f2cd = "CDMA 2000 1xRTT/1xEVDO modem" */
    'C','D','M','A',' ','2','0','0','0',' ','1','x','R','T','T','/','1','x','E','V','D','O',' ','m','o','d','e','m',
/* 0x0f2e9 = "XI-750 802.11b Wireless Adapter [Atmel AT76C503A]" */
    'X','I','-','7','5','0',' ','\x9b','\x01','\x02',' ','[','A','t','m','e','l',' ','A','T','7','6','C','5','0','3','A',']',
/* 0x0f305 = "Intelligent ISDN (Ver. 3.60.04) [HFC-S]" */
    '\xe0','I','S','D','N',' ','(','V','e','r','.',' ','3','.','6','0','.','0','4',')',' ','[','H','F','C','-','S',']',
/* 0x0f321 = "Hub in A1082 [Cinema HD Display 23"]" */
    '\xa4',' ','i','n',' ','A','1','0','8','2',' ','[','C','i','n','e','m','a',' ','H','D',' ','\xcf',' ','2','3','"',']',
/* 0x0f33d = "Blinkiverse Analog LED Fader" */
    'B','l','i','n','k','i','v','e','r','s','e',' ','A','n','a','l','o','g',' ','L','E','D',' ','F','a','d','e','r',
/* 0x0f359 = "ARCTIC Sound P261 Headphones" */
    'A','R','C','T','I','C',' ','S','o','u','n','d',' ','P','2','6','1',' ','H','e','a','d','p','h','o','n','e','s',
/* 0x0f375 = "Stellaris ROM DFU Bootloader" */
    'S','t','e','l','l','a','r','i','s',' ','R','O','M',' ','D','F','U',' ','B','o','o','t','l','o','a','d','e','r',
/* 0x0f391 = "ANDES TECHNOLOGY CORPORATION" */
    'A','N','D','E','S',' ','T','E','C','H','N','O','L','O','G','Y',' ','C','O','R','P','O','R','A','T','I','O','N',
/* 0x0f3ad = "Kaibo Wire & Cable (Shenzhen) Co., Ltd." */
    'K','a','i','b','o',' ','W','i','r','e',' ','&',' ','\xa5',' ','(','S','h','e','n','z','h','e','n',')',' ','\x0e','\xab',
/* 0x0f3c9 = "Manhattan Magnetic Card Strip Reader" */
    'M','a','n','h','a','t','t','a','n',' ','M','a','g','n','e','t','i','c',' ','\x15',' ','S','t','r','i','p',' ','\x08',
/* 0x0f3e5 = "CmStick/M (article no. 1010)" */
    'C','m','S','t','i','c','k','/','M',' ','(','a','r','t','i','c','l','e',' ','n','o','.',' ','1','0','1','0',')',
/* 0x0f401 = "Kingston DataTraveler 2.0 Stick (512M)" */
    'K','i','n','g','s','t','o','n',' ','\xe7','T','r','a','v','e','l','e','r',' ','\xc1','\xb3',' ','(','5','1','2','M',')',
/* 0x0f41d = "Kawasaki Microelectronics, Inc." */
    'K','a','w','a','s','a','k','i',' ','M','i','c','r','o','e','l','e','c','t','r','o','n','i','c','s',',',' ','\x07',
/* 0x0f439 = "Clear Chat Comfort USB Headset" */
    'C','l','e','a','r',' ','C','h','a','t',' ','C','o','m','f','o','r','t',' ','\x0a',' ','H','e','a','d','s','e','t',
/* 0x0f455 = "Leo Hui Electric Wire & Cable Co., Ltd" */
    'L','e','o',' ','H','u','i',' ','E','l','e','c','t','r','i','c',' ','W','i','r','e',' ','&',' ','\xa5',' ','\x0e','\x16',
/* 0x0f471 = "VideoBlaster Webcam Go Plus [W9967CF]" */
    '\xa3','B','l','a','s','t','e','r',' ','\x11',' ','G','o',' ','P','l','u','s',' ','[','W','9','9','6','7','C','F',']',
/* 0x0f48d = "ER100 Extinction Ratio Meter" */
    'E','R','1','0','0',' ','E','x','t','i','n','c','t','i','o','n',' ','R','a','t','i','o',' ','M','e','t','e','r',
/* 0x0f4a9 = "Powershot ELPH 115 IS / IXUS 132" */
    'P','o','w','e','r','s','h','o','t',' ','E','L','P','H',' ','1','1','5',' ','I','S',' ','/',' ','\xfd','1','3','2',
/* 0x0f4c5 = "Apple Internal Keyboard / Trackpad (MacBook Retina)" */
    'A','p','p','l','e',' ','\xb4','\x05',' ','/',' ','\xf6','(','M','a','c','B','o','o','k',' ','R','e','t','i','n','a',')',
/* 0x0f4e1 = "RZ01-020300 Optical Mouse [Diamondback]" */
    'R','Z','0','1','-','0','2','0','3','0','0',' ','\x7b','\x0b',' ','[','D','i','a','m','o','n','d','b','a','c','k',']',
/* 0x0f4fd = "3Dconnexion Space Pilot 3D Mouse" */
    '3','D','c','o','n','n','e','x','i','o','n',' ','S','p','a','c','e',' ','P','i','l','o','t',' ','3','D',' ','\x0b',
/* 0x0f519 = "Psion Dacom Home Networks, Ltd" */
    'P','s','i','o','n',' ','D','a','c','o','m',' ','H','o','m','e',' ','N','e','t','w','o','r','k','s',',',' ','\x16',
/* 0x0f535 = "3CRUSB10075 802.11bg [ZyDAS ZD1211]" */
    '3','C','R','U','S','B','1','0','0','7','5',' ','\xad',' ','[','Z','y','D','A','S',' ','Z','D','1','2','1','1',']',
/* 0x0f551 = "Broadxent BritePort DSL Bridge 8010U" */
    'B','r','o','a','d','x','e','n','t',' ','B','r','i','t','e','\x87',' ','D','S','L',' ','\x9f',' ','8','0','1','0','U',
/* 0x0f56d = "Global Village Communication" */
    'G','l','o','b','a','l',' ','V','i','l','l','a','g','e',' ','C','o','m','m','u','n','i','c','a','t','i','o','n',
/* 0x0f589 = "Lottery Printer, XiPrintPlus" */
    'L','o','t','t','e','r','y',' ','P','r','i','n','t','e','r',',',' ','X','i','P','r','i','n','t','P','l','u','s',
/* 0x0f5a5 = "DWA-130 802.11n Wireless N Adapter(rev.C1) [Realtek RTL8192U]" */
    'D','W','A','-','1','3','0',' ','\x99','\x01','N',' ','\xbb','C','1',')',' ','[','\xbe','R','T','L','8','1','9','2','U',']',
/* 0x0f5c1 = "HX-MU064DA portable harddisk" */
    'H','X','-','M','U','0','6','4','D','A',' ','p','o','r','t','a','b','l','e',' ','h','a','r','d','d','i','s','k',
/* 0x0f5dd = "DualHead2Go [Analog Edition]" */
    'D','u','a','l','H','e','a','d','2','G','o',' ','[','A','n','a','l','o','g',' ','E','d','i','t','i','o','n',']',
/* 0x0f5f9 = "IT9135 BDA Afatech DVB-T HDTV Dongle" */
    'I','T','9','1','3','5',' ','B','D','A',' ','A','f','a','t','e','c','h',' ','\xa7','T',' ','H','D','T','V',' ','\xf4',
/* 0x0f615 = "Belkin F5D7051 v3000 802.11g" */
    'B','e','l','k','i','n',' ','F','5','D','7','0','5','1',' ','v','3','0','0','0',' ','8','0','2','.','1','1','g',
/* 0x0f631 = "USB, 2-axis 8-button gamepad" */
    'U','S','B',',',' ','2','-','a','x','i','s',' ','8','-','b','u','t','t','o','n',' ','g','a','m','e','p','a','d',
/* 0x0f64d = "Pentel Co., Ltd (Electronics Equipment Div.)" */
    'P','e','n','t','e','l',' ','\x0e','\x16',' ','(','\x1b',' ','E','q','u','i','p','m','e','n','t',' ','D','i','v','.',')',
/* 0x0f669 = "CmStick/M (article no. 1011)" */
    'C','m','S','t','i','c','k','/','M',' ','(','a','r','t','i','c','l','e',' ','n','o','.',' ','1','0','1','1',')',
/* 0x0f685 = "Optimus Android Phone (Camera/PTP Mode)" */
    'O','p','t','i','m','u','s',' ','\xce','\x19',' ','(','C','a','m','e','r','a','/','P','T','P',' ','M','o','d','e',')',
/* 0x0f6a1 = "WLA-4000 802.11bgn [Ralink RT3072]" */
    'W','L','A','-','4','0','0','0',' ','8','0','2','.','1','1','b','g','n',' ','[','\x93','R','T','3','0','7','2',']',
/* 0x0f6bd = "PT-18R P-touch label printer" */
    'P','T','-','1','8','R',' ','P','-','t','o','u','c','h',' ','l','a','b','e','l',' ','p','r','i','n','t','e','r',
/* 0x0f6d9 = "Amazon Kindle 3/4/Paperwhite" */
    'A','m','a','z','o','n',' ','K','i','n','d','l','e',' ','3','/','4','/','P','a','p','e','r','w','h','i','t','e',
/* 0x0f6f5 = "Veridicom 5thSense Fingerprint Sensor and eUSB SmartCard" */
    'V','e','r','i','d','i','c','o','m',' ','5','t','h','S','e','n','s','e',' ','\x92','\xac',' ','\xe4','e','\x0a',' ','\x12','\x15',
/* 0x0f711 = "FRITZ!Box Fon WLAN (Annex A)" */
    'F','R','I','T','Z','!','B','o','x',' ','F','o','n',' ','W','L','A','N',' ','(','A','n','n','e','x',' ','A',')',
/* 0x0f72d = "DS1490F 2-in-1 Fob, 1-Wire adapter" */
    'D','S','1','4','9','0','F',' ','2','-','i','n','-','1',' ','F','o','b',',',' ','1','-','W','i','r','e',' ','\xd0',
/* 0x0f749 = "GW-USNano2 802.11n Wireless Adapter [Realtek RTL8188CUS]" */
    'G','W','-','U','S','N','a','n','o','2',' ','\x99','\x01','\x02',' ','[','\xbe','R','T','L','8','1','8','8','C','U','S',']',
/* 0x0f765 = "Logic Analyzer (LAP-C-16032)" */
    'L','o','g','i','c',' ','A','n','a','l','y','z','e','r',' ','(','L','A','P','-','C','-','1','6','0','3','2',')',
/* 0x0f781 = "Melco MCR-U2 SmartMedia / CompactFlash Reader" */
    'M','e','l','c','o',' ','M','C','R','-','U','2',' ','\x12','\xa1',' ','/',' ','C','o','m','p','a','c','t','\x3c',' ','\x08',
/* 0x0f79d = "Medion 9801/Novatech SX-410z" */
    'M','e','d','i','o','n',' ','9','8','0','1','/','N','o','v','a','t','e','c','h',' ','S','X','-','4','1','0','z',
/* 0x0f7b9 = "XScale PXA27x Bulverde flash" */
    'X','S','c','a','l','e',' ','P','X','A','2','7','x',' ','B','u','l','v','e','r','d','e',' ','f','l','a','s','h',
/* 0x0f7d5 = "Arduino Robot Control (bootloader)" */
    'A','r','d','u','i','n','o',' ','R','o','b','o','t',' ','\xc9',' ','(','b','o','o','t','l','o','a','d','e','r',')',
/* 0x0f7f1 = "DSP-Weuffen USB-HPI-Programmer" */
    'D','S','P','-','W','e','u','f','f','e','n',' ','\x0a','-','H','P','I','-','P','r','o','g','r','a','m','m','e','r',
/* 0x0f80d = "RETRO Innovations ZoomFloppy" */
    'R','E','T','R','O',' ','I','n','n','o','v','a','t','i','o','n','s',' ','Z','o','o','m','F','l','o','p','p','y',
/* 0x0f829 = "WNDA3100v1 802.11abgn [Atheros AR9170+AR9104]" */
    'W','N','D','A','3','1','0','0','v','1',' ','\xea','[','\xaf','A','R','9','1','7','0','+','A','R','9','1','0','4',']',
/* 0x0f845 = "SiLabs Cypress FW downloader" */
    'S','i','L','a','b','s',' ','C','y','p','r','e','s','s',' ','F','W',' ','d','o','w','n','l','o','a','d','e','r',
/* 0x0f861 = "TRUST 240H EASY WEBSCAN GOLD" */
    'T','R','U','S','T',' ','2','4','0','H',' ','E','A','S','Y',' ','W','E','B','S','C','A','N',' ','G','O','L','D',
/* 0x0f87d = "Paella Pulse height analyzer" */
    'P','a','e','l','l','a',' ','P','u','l','s','e',' ','h','e','i','g','h','t',' ','a','n','a','l','y','z','e','r',
/* 0x0f899 = "DAP-HD0014 [Zen Touch] (MTP)" */
    'D','A','P','-','H','D','0','0','1','4',' ','[','Z','e','n',' ','T','o','u','c','h',']',' ','(','M','T','P',')',
/* 0x0f8b5 = "CyMotion Master Linux Keyboard G230" */
    'C','y','M','o','t','i','o','n',' ','M','a','s','t','e','r',' ','L','i','n','u','x',' ','\x05',' ','G','2','3','0',
/* 0x0f8d1 = "TU25 WiMAX Adapter [Beceem BCS200]" */
    'T','U','2','5',' ','W','i','M','A','X',' ','\x02',' ','[','B','e','c','e','e','m',' ','B','C','S','2','0','0',']',
/* 0x0f8ed = "Allnet ALL0283 [AR5523](no firmware)" */
    'A','l','l','n','e','t',' ','A','L','L','0','2','8','3',' ','[','A','R','5','5','2','3',']','(','n','o',' ','\xdb',
/* 0x0f909 = "Future Techno Designs PVT, Ltd" */
    'F','u','t','u','r','e',' ','T','e','c','h','n','o',' ','D','e','s','i','g','n','s',' ','P','V','T',',',' ','\x16',
/* 0x0f925 = "DVB-T + GPS Minicard [RTL2832U]" */
    '\xa7','T',' ','+',' ','G','P','S',' ','M','i','n','i','c','a','r','d',' ','[','R','T','L','2','8','3','2','U',']',
/* 0x0f941 = "G55xi Printer/Scanner/Copier" */
    'G','5','5','x','i',' ','P','r','i','n','t','e','r','/','S','c','a','n','n','e','r','/','C','o','p','i','e','r',
/* 0x0f95d = "iVina FB1600/UMAX Astra 4500" */
    'i','V','i','n','a',' ','F','B','1','6','0','0','/','U','M','A','X',' ','A','s','t','r','a',' ','4','5','0','0',
/* 0x0f979 = "cab Produkttechnik GmbH & Co KG" */
    'c','a','b',' ','P','r','o','d','u','k','t','t','e','c','h','n','i','k',' ','\xfc',' ','&',' ','C','o',' ','K','G',
/* 0x0f995 = "Certis V1 fingerprint reader" */
    'C','e','r','t','i','s',' ','V','1',' ','f','i','n','g','e','r','p','r','i','n','t',' ','r','e','a','d','e','r',
/* 0x0f9b1 = "Trumpion Microelectronics, Inc." */
    'T','r','u','m','p','i','o','n',' ','M','i','c','r','o','e','l','e','c','t','r','o','n','i','c','s',',',' ','\x07',
/* 0x0f9cd = "City University of Hong Kong" */
    'C','i','t','y',' ','U','n','i','v','e','r','s','i','t','y',' ','o','f',' ','H','o','n','g',' ','K','o','n','g',
/* 0x0f9e9 = "SmartJoy Dual Plus PS2 converter" */
    '\x12','J','o','y',' ','D','u','a','l',' ','P','l','u','s',' ','P','S','2',' ','c','o','n','v','e','r','t','e','r',
/* 0x0fa05 = "Mio A701 DigiWalker PPCPhone" */
    'M','i','o',' ','A','7','0','1',' ','D','i','g','i','W','a','l','k','e','r',' ','P','P','C','P','h','o','n','e',
/* 0x0fa21 = "LI-7000 CO2/H2O Gas Analyzer" */
    'L','I','-','7','0','0','0',' ','C','O','2','/','H','2','O',' ','G','a','s',' ','A','n','a','l','y','z','e','r',
/* 0x0fa3d = "FSC Storagebird XL hard disk" */
    'F','S','C',' ','S','t','o','r','a','g','e','b','i','r','d',' ','X','L',' ','h','a','r','d',' ','d','i','s','k',
/* 0x0fa59 = "WUG2200 802.11g Wireless Adapter [Envara WiND512]" */
    'W','U','G','2','2','0','0',' ','\x94','\x01','\x02',' ','[','E','n','v','a','r','a',' ','W','i','N','D','5','1','2',']',
/* 0x0fa75 = "Powershot ELPH 130 IS / IXUS 140" */
    'P','o','w','e','r','s','h','o','t',' ','E','L','P','H',' ','1','3','0',' ','I','S',' ','/',' ','\xfd','1','4','0',
/* 0x0fa91 = "predator Bootloader Download" */
    'p','r','e','d','a','t','o','r',' ','B','o','o','t','l','o','a','d','e','r',' ','D','o','w','n','l','o','a','d',
/* 0x0faad = "Flash Reader, Desknote UCR-61S2B" */
    '\x3c',' ','R','e','a','d','e','r',',',' ','D','e','s','k','n','o','t','e',' ','U','C','R','-','6','1','S','2','B',
/* 0x0fac9 = "ES-8500 [Expression 1640 XL]" */
    'E','S','-','8','5','0','0',' ','[','E','x','p','r','e','s','s','i','o','n',' ','1','6','4','0',' ','X','L',']',
/* 0x0fae5 = "Magic Control Technology Corp. (USB2VGA dongle)" */
    'M','a','g','i','c',' ','\xc9',' ','\x0d',' ','\x10',' ','(','U','S','B','2','V','G','A',' ','d','o','n','g','l','e',')',
/* 0x0fb01 = "DVB-T KWorld PlusTV 399U [af9015]" */
    '\xa7','T',' ','K','W','o','r','l','d',' ','P','l','u','s','\xda','3','9','9','U',' ','[','a','f','9','0','1','5',']',
/* 0x0fb1d = "Arduino Micro ADK rev3 (CDC ACM)" */
    'A','r','d','u','i','n','o',' ','\xc4',' ','A','D','K',' ','r','e','v','3',' ','(','C','D','C',' ','A','C','M',')',
/* 0x0fb39 = "Docking Station Topline 2012" */
    'D','o','c','k','i','n','g',' ','S','t','a','t','i','o','n',' ','T','o','p','l','i','n','e',' ','2','0','1','2',
/* 0x0fb55 = "ChunghwaTL USB02 Smartcard Reader" */
    'C','h','u','n','g','h','w','a','T','L',' ','U','S','B','0','2',' ','S','m','a','r','t','c','a','r','d',' ','\x08',
/* 0x0fb71 = "Data capturing and control module" */
    '\xe7',' ','c','a','p','t','u','r','i','n','g',' ','\xe4','c','o','n','t','r','o','l',' ','m','o','d','u','l','e',
/* 0x0fb8c = "Alpermann+Velte Rubidium D1" */
    'A','l','p','e','r','m','a','n','n','+','V','e','l','t','e',' ','R','u','b','i','d','i','u','m',' ','D','1',
/* 0x0fba7 = "EDIMAX TECHNOLOGY CO., LTD." */
    'E','D','I','M','A','X',' ','T','E','C','H','N','O','L','O','G','Y',' ','C','O','.',',',' ','L','T','D','.',
/* 0x0fbc2 = "CS682 2-Port USB 2.0 DVI KVM Switch" */
    'C','S','6','8','2',' ','2','-','\x87',' ','\x0a',' ','\xc1','D','V','I',' ','K','V','M',' ','S','w','i','t','c','h',
/* 0x0fbdd = "KC2190 USB Host-to-Host cable" */
    'K','C','2','1','9','0',' ','\x0a',' ','H','o','s','t','-','t','o','-','H','o','s','t',' ','c','a','b','l','e',
/* 0x0fbf8 = "Metrologic MS4980 Barcode Scanner" */
    'M','e','t','r','o','l','o','g','i','c',' ','M','S','4','9','8','0',' ','B','a','r','c','o','d','e',' ','\x25',
/* 0x0fc13 = "Visual Communication Camera VGP-VCC4 [R5U870]" */
    'V','i','s','u','a','l',' ','\xe9','\x04',' ','V','G','P','-','V','C','C','4',' ','[','R','5','U','8','7','0',']',
/* 0x0fc2e = "SURFboard Voice over IP Cable Modem" */
    'S','U','R','F','b','o','a','r','d',' ','V','o','i','c','e',' ','o','v','e','r',' ','I','P',' ','\xa5',' ','\x1c',
/* 0x0fc49 = "V220 Cordless Optical Mouse for Notebooks" */
    'V','2','2','0',' ','C','o','r','d','l','e','s','s',' ','\x7b','\x0b',' ','\xcc','N','o','t','e','b','o','o','k','s',
/* 0x0fc64 = "AX88179 Gigabit Ethernet [Toshiba]" */
    'A','X','8','8','1','7','9',' ','G','i','g','a','b','i','t',' ','\x7f',' ','[','T','o','s','h','i','b','a',']',
/* 0x0fc7f = "Struck Innovative Systeme GmbH" */
    'S','t','r','u','c','k',' ','I','n','n','o','v','a','t','i','v','e',' ','S','y','s','t','e','m','e',' ','\xfc',
/* 0x0fc9a = "Vuquest 3310 Area-Imaging Scanner" */
    'V','u','q','u','e','s','t',' ','3','3','1','0',' ','A','r','e','a','-','I','m','a','g','i','n','g',' ','\x25',
/* 0x0fcb5 = "Dream Cheeky Big Red Button" */
    'D','r','e','a','m',' ','C','h','e','e','k','y',' ','B','i','g',' ','R','e','d',' ','B','u','t','t','o','n',
/* 0x0fcd0 = "KX-MB2030 Multifunction Laser Printer" */
    'K','X','-','M','B','2','0','3','0',' ','M','u','l','t','i','f','u','n','c','t','i','o','n',' ','\x82',' ','\x0c',
/* 0x0fceb = "ConvertX TV100U A/V Capture" */
    'C','o','n','v','e','r','t','X',' ','T','V','1','0','0','U',' ','A','/','V',' ','C','a','p','t','u','r','e',
/* 0x0fd06 = "Maui Innovative Peripherals" */
    'M','a','u','i',' ','I','n','n','o','v','a','t','i','v','e',' ','P','e','r','i','p','h','e','r','a','l','s',
/* 0x0fd21 = "Linux-USB Serial Gadget (CDC ACM mode)" */
    'L','i','n','u','x','-','\x0a',' ','\x90',' ','G','a','d','g','e','t',' ','(','C','D','C',' ','A','C','M',' ','\x1a',
/* 0x0fd3c = "SiPix Stylecam/UMAX AstraPix 320s" */
    'S','i','\xd8','S','t','y','l','e','c','a','m','/','U','M','A','X',' ','A','s','t','r','a','\xd8','3','2','0','s',
/* 0x0fd57 = "MX Revolution/G7 Cordless Mouse" */
    'M','X',' ','R','e','v','o','l','u','t','i','o','n','/','G','7',' ','C','o','r','d','l','e','s','s',' ','\x0b',
/* 0x0fd72 = "MN800 / Smartwatch 2 (DFU mode)" */
    'M','N','8','0','0',' ','/',' ','S','m','a','r','t','w','a','t','c','h',' ','2',' ','(','D','F','U',' ','\x1a',
/* 0x0fd8d = "Kingston DataTraveler 2.0 Stick (1GB)" */
    'K','i','n','g','s','t','o','n',' ','\xe7','T','r','a','v','e','l','e','r',' ','\xc1','\xb3',' ','(','1','G','B',')',
/* 0x0fda8 = "Fujitsu SK-16FX-100PMC V1.1" */
    'F','u','j','i','t','s','u',' ','S','K','-','1','6','F','X','-','1','0','0','P','M','C',' ','V','1','.','1',
/* 0x0fdc3 = "Ion Quick Play LP turntable" */
    'I','o','n',' ','Q','u','i','c','k',' ','P','l','a','y',' ','L','P',' ','t','u','r','n','t','a','b','l','e',
/* 0x0fdde = "AVerTV Volar Video Capture (H830)" */
    'A','V','e','r','\xda','V','o','l','a','r',' ','\xa3',' ','C','a','p','t','u','r','e',' ','(','H','8','3','0',')',
/* 0x0fdf9 = "omni.net II ISDN TA [HFC-S]" */
    'o','m','n','i','.','n','e','t',' ','I','I',' ','I','S','D','N',' ','T','A',' ','[','H','F','C','-','S',']',
/* 0x0fe14 = "Fritz!WLAN N 2.4 [Atheros AR9001U]" */
    'F','r','i','t','z','!','W','L','A','N',' ','N',' ','2','.','4',' ','[','\xaf','A','R','9','0','0','1','U',']',
/* 0x0fe2f = "Swiss Federal Insitute of Technology" */
    'S','w','i','s','s',' ','F','e','d','e','r','a','l',' ','I','n','s','i','t','u','t','e',' ','o','f',' ','\x0d',
/* 0x0fe4a = "STORAGE ADAPTER (FirePower)" */
    'S','T','O','R','A','G','E',' ','A','D','A','P','T','E','R',' ','(','F','i','r','e','P','o','w','e','r',')',
/* 0x0fe65 = "Storm HP-USB500 5.1 Headset" */
    'S','t','o','r','m',' ','H','P','-','U','S','B','5','0','0',' ','5','.','1',' ','H','e','a','d','s','e','t',
/* 0x0fe80 = "Frontline Test Equipment, Inc." */
    'F','r','o','n','t','l','i','n','e',' ','T','e','s','t',' ','E','q','u','i','p','m','e','n','t',',',' ','\x07',
/* 0x0fe9b = "Visual Communication Camera VGP-VCC8 [R5U870]" */
    'V','i','s','u','a','l',' ','\xe9','\x04',' ','V','G','P','-','V','C','C','8',' ','[','R','5','U','8','7','0',']',
/* 0x0feb6 = "FreeAgent GoFlex Desk USB 3.0" */
    'F','r','e','e','A','g','e','n','t',' ','G','o','F','l','e','x',' ','D','e','s','k',' ','\x0a',' ','3','.','0',
/* 0x0fed1 = "Dracal/Raphnet technologies" */
    'D','r','a','c','a','l','/','R','a','p','h','n','e','t',' ','t','e','c','h','n','o','l','o','g','i','e','s',
/* 0x0feec = "Coby 4GB Go Video MP3 Player [MP620-4G]" */
    'C','o','b','y',' ','4','G','B',' ','G','o',' ','\xa3',' ','\x8e','\x1e',' ','[','M','P','6','2','0','-','4','G',']',
/* 0x0ff07 = "The Imaging Source Europe GmbH" */
    'T','h','e',' ','I','m','a','g','i','n','g',' ','S','o','u','r','c','e',' ','E','u','r','o','p','e',' ','\xfc',
/* 0x0ff22 = "ActiveHome (ACPI-compliant)" */
    'A','c','t','i','v','e','H','o','m','e',' ','(','A','C','P','I','-','c','o','m','p','l','i','a','n','t',')',
/* 0x0ff3d = "Centor USB RACIA-ALVAR USB PORT" */
    'C','e','n','t','o','r',' ','\x0a',' ','R','A','C','I','A','-','A','L','V','A','R',' ','\x0a',' ','P','O','R','T',
/* 0x0ff58 = "PTH-850 [Intuos5 touch (L)]" */
    'P','T','H','-','8','5','0',' ','[','I','n','t','u','o','s','5',' ','t','o','u','c','h',' ','(','L',')',']',
/* 0x0ff73 = "Toshiba America Electronic Components" */
    'T','o','s','h','i','b','a',' ','A','m','e','r','i','c','a',' ','\xba','C','o','m','p','o','n','e','n','t','s',
/* 0x0ff8e = "USB,Wiress  2.4GHZ Joystick" */
    'U','S','B',',','W','i','r','e','s','s',' ',' ','2','.','4','G','H','Z',' ','J','o','y','s','t','i','c','k',
/* 0x0ffa9 = "Wireless Keyboard with One-touch start buttons" */
    '\x01','\x05',' ','\x98','O','n','e','-','t','o','u','c','h',' ','s','t','a','r','t',' ','b','u','t','t','o','n','s',
/* 0x0ffc4 = "GCUSB-nStep stepper motor controller" */
    'G','C','U','S','B','-','n','S','t','e','p',' ','s','t','e','p','p','e','r',' ','m','o','t','o','r',' ','\x9e',
/* 0x0ffdf = "AcuLaser MX20DN/MX20DNF/MX21DNF" */
    'A','c','u','\x82',' ','M','X','2','0','D','N','/','M','X','2','0','D','N','F','/','M','X','2','1','D','N','F',
/* 0x0fffa = "RCDongle for IR remote control" */
    'R','C','D','o','n','g','l','e',' ','\xcc','I','R',' ','r','e','m','o','t','e',' ','c','o','n','t','r','o','l',
/* 0x10015 = "Prototype product Vendor ID" */
    'P','r','o','t','o','t','y','p','e',' ','p','r','o','d','u','c','t',' ','V','e','n','d','o','r',' ','I','D',
/* 0x10030 = "Emagic Soft- und Hardware GmbH" */
    'E','m','a','g','i','c',' ','S','o','f','t','-',' ','u','n','d',' ','H','a','r','d','w','a','r','e',' ','\xfc',
/* 0x1004b = "00052486 / Laser Mouse M1052 [hama]" */
    '0','0','0','5','2','4','8','6',' ','/',' ','\x82',' ','\x0b',' ','M','1','0','5','2',' ','[','h','a','m','a',']',
/* 0x10066 = "VTech Engineering Canada, Ltd" */
    'V','T','e','c','h',' ','E','n','g','i','n','e','e','r','i','n','g',' ','C','a','n','a','d','a',',',' ','\x16',
/* 0x10081 = "Trust 738AV LCD PV Mass Storage" */
    'T','r','u','s','t',' ','7','3','8','A','V',' ','L','C','D',' ','P','V',' ','\x7c','S','t','o','r','a','g','e',
/* 0x1009c = "ALLTOP TECHNOLOGY CO., LTD." */
    'A','L','L','T','O','P',' ','T','E','C','H','N','O','L','O','G','Y',' ','C','O','.',',',' ','L','T','D','.',
/* 0x100b7 = "Alpermann+Velte Rubidium Q1" */
    'A','l','p','e','r','m','a','n','n','+','V','e','l','t','e',' ','R','u','b','i','d','i','u','m',' ','Q','1',
/* 0x100d2 = "Japan System Development Co., Ltd" */
    'J','a','p','a','n',' ','S','y','s','t','e','m',' ','D','e','v','e','l','o','p','m','e','n','t',' ','\x0e','\x16',
/* 0x100ed = "GT-7200U [Perfection 1250/1250 PHOTO]" */
    'G','T','-','7','2','0','0','U',' ','[','\xf0','1','2','5','0','/','1','2','5','0',' ','P','H','O','T','O',']',
/* 0x10108 = "STORAGE ADAPTER (CrossFire)" */
    'S','T','O','R','A','G','E',' ','A','D','A','P','T','E','R',' ','(','C','r','o','s','s','F','i','r','e',')',
/* 0x10123 = "WeatherFax 2000 Demodulator" */
    'W','e','a','t','h','e','r','F','a','x',' ','2','0','0','0',' ','D','e','m','o','d','u','l','a','t','o','r',
/* 0x1013e = "GO 520 T/GO 630/ONE XL (v9)" */
    'G','O',' ','5','2','0',' ','T','/','G','O',' ','6','3','0','/','O','N','E',' ','X','L',' ','(','v','9',')',
/* 0x10159 = "Leader Tech Manufacturer Co., Ltd" */
    'L','e','a','d','e','r',' ','T','e','c','h',' ','M','a','n','u','f','a','c','t','u','r','e','r',' ','\x0e','\x16',
/* 0x10174 = "CM1092 / Wintech CM-5098 Optical Mouse" */
    'C','M','1','0','9','2',' ','/',' ','W','i','n','t','e','c','h',' ','C','M','-','5','0','9','8',' ','\x7b','\x0b',
/* 0x1018f = "J108i Cedar (mass-storage mode)" */
    'J','1','0','8','i',' ','C','e','d','a','r',' ','(','m','a','s','s','-','s','t','o','r','a','g','e',' ','\x1a',
/* 0x101aa = "UC-2324 4xSerial Ports [mos7840]" */
    'U','C','-','2','3','2','4',' ','4','x','\x90',' ','P','o','r','t','s',' ','[','m','o','s','7','8','4','0',']',
/* 0x101c5 = "Visual Communication Camera VGP-VCC6 [R5U870]" */
    'V','i','s','u','a','l',' ','\xe9','\x04',' ','V','G','P','-','V','C','C','6',' ','[','R','5','U','8','7','0',']',
/* 0x101e0 = "WKB-1000S Wireless Ergo Keyboard with Touchpad" */
    'W','K','B','-','1','0','0','0','S',' ','\x01','E','r','g','o',' ','\x05',' ','\x98','T','o','u','c','h','p','a','d',
/* 0x101fb = "Merlin U730/U740 (Vodafone)" */
    'M','e','r','l','i','n',' ','U','7','3','0','/','U','7','4','0',' ','(','V','o','d','a','f','o','n','e',')',
/* 0x10216 = "Visual Communication Camera VGP-VCC9 [R5U870]" */
    'V','i','s','u','a','l',' ','\xe9','\x04',' ','V','G','P','-','V','C','C','9',' ','[','R','5','U','8','7','0',']',
/* 0x10231 = "Gilat Satellite Networks, Ltd" */
    'G','i','l','a','t',' ','S','a','t','e','l','l','i','t','e',' ','N','e','t','w','o','r','k','s',',',' ','\x16',
/* 0x1024c = "G510 Gaming Keyboard onboard audio" */
    'G','5','1','0',' ','G','a','m','i','n','g',' ','\x05',' ','o','n','b','o','a','r','d',' ','a','u','d','i','o',
/* 0x10267 = "Mio LINK Heart Rate Monitor" */
    'M','i','o',' ','L','I','N','K',' ','H','e','a','r','t',' ','R','a','t','e',' ','M','o','n','i','t','o','r',
/* 0x10282 = "PCTV 73e [DiBcom DiB7000PC]" */
    'P','C','T','V',' ','7','3','e',' ','[','D','i','B','c','o','m',' ','D','i','B','7','0','0','0','P','C',']',
/* 0x1029d = "ATERGI TECHNOLOGY CO., LTD." */
    'A','T','E','R','G','I',' ','T','E','C','H','N','O','L','O','G','Y',' ','C','O','.',',',' ','L','T','D','.',
/* 0x102b8 = "Conceptronic USB Harddisk Box" */
    'C','o','n','c','e','p','t','r','o','n','i','c',' ','\x0a',' ','H','a','r','d','d','i','s','k',' ','B','o','x',
/* 0x102d3 = "PTH-650 [Intuos5 touch (M)]" */
    'P','T','H','-','6','5','0',' ','[','I','n','t','u','o','s','5',' ','t','o','u','c','h',' ','(','M',')',']',
/* 0x102ee = "tm5600 Video & Audio Grabber Capture" */
    't','m','5','6','0','0',' ','\xa3',' ','&',' ','\x8b','G','r','a','b','b','e','r',' ','C','a','p','t','u','r','e',
/* 0x10309 = "PerkinElmer Optoelectronics" */
    'P','e','r','k','i','n','E','l','m','e','r',' ','O','p','t','o','e','l','e','c','t','r','o','n','i','c','s',
/* 0x10324 = "BeWAN ADSL USB ST (blue or green)" */
    'B','e','W','A','N',' ','\xf1','\x0a',' ','S','T',' ','(','b','l','u','e',' ','o','r',' ','g','r','e','e','n',')',
/* 0x1033f = "Rockfire USB RacingStar Vibra" */
    'R','o','c','k','f','i','r','e',' ','\x0a',' ','R','a','c','i','n','g','S','t','a','r',' ','V','i','b','r','a',
/* 0x1035a = "free for internal lab use 1009" */
    'f','r','e','e',' ','\xcc','i','n','t','e','r','n','a','l',' ','l','a','b',' ','u','s','e',' ','1','0','0','9',
/* 0x10375 = "Tactrix OpenPort 1.3 Universal" */
    'T','a','c','t','r','i','x',' ','O','p','e','n','\x87',' ','1','.','3',' ','U','n','i','v','e','r','s','a','l',
/* 0x10390 = "Samsung Gobi 2000 Wireless Modem (QDL mode)" */
    'S','a','m','s','u','n','g',' ','G','o','b','i',' ','2','0','0','0',' ','\x01','\x1c',' ','(','Q','D','L',' ','\x1a',
/* 0x103ab = "Actisense NGT-1 NMEA2000 PC Interface" */
    'A','c','t','i','s','e','n','s','e',' ','N','G','T','-','1',' ','N','M','E','A','2','0','0','0',' ','\x1f','\x81',
/* 0x103c6 = "HID UNIKEY dongle [F-Response]" */
    '\xf2','U','N','I','K','E','Y',' ','d','o','n','g','l','e',' ','[','F','-','R','e','s','p','o','n','s','e',']',
/* 0x103e1 = "Fujitsu Siemens Mouse Esprimo Q" */
    'F','u','j','i','t','s','u',' ','S','i','e','m','e','n','s',' ','\x0b',' ','E','s','p','r','i','m','o',' ','Q',
/* 0x103fc = "Aterm WL54SU2 802.11g Wireless Adapter [Atheros AR5523]" */
    'A','t','e','r','m',' ','W','L','5','4','S','U','2',' ','\x94','\x01','\x02',' ','[','\xaf','A','R','5','5','2','3',']',
/* 0x10417 = "Visual Communication Camera VGP-VCC5 [R5U870]" */
    'V','i','s','u','a','l',' ','\xe9','\x04',' ','V','G','P','-','V','C','C','5',' ','[','R','5','U','8','7','0',']',
/* 0x10432 = "AT91SAM HID Keyboard Demo Application" */
    'A','T','9','1','S','A','M',' ','\xf2','\x05',' ','D','e','m','o',' ','A','p','p','l','i','c','a','t','i','o','n',
/* 0x1044d = "Harting, Inc. of North America" */
    'H','a','r','t','i','n','g',',',' ','\x07',' ','o','f',' ','N','o','r','t','h',' ','A','m','e','r','i','c','a',
/* 0x10468 = "DVD-CAM DZ-MV100A Camcorder" */
    'D','V','D','-','C','A','M',' ','D','Z','-','M','V','1','0','0','A',' ','C','a','m','c','o','r','d','e','r',
/* 0x10483 = "Der An Electric Wire & Cable Co., Ltd" */
    'D','e','r',' ','A','n',' ','E','l','e','c','t','r','i','c',' ','W','i','r','e',' ','&',' ','\xa5',' ','\x0e','\x16',
/* 0x1049e = "Alpermann+Velte Rubidium T1" */
    'A','l','p','e','r','m','a','n','n','+','V','e','l','t','e',' ','R','u','b','i','d','i','u','m',' ','T','1',
/* 0x104b9 = "PL2303 Serial Adapter (IODATA USB-RSAQ3)" */
    'P','L','2','3','0','3',' ','\x90',' ','\x02',' ','(','I','O','D','A','T','A',' ','\x0a','-','R','S','A','Q','3',')',
/* 0x104d4 = "ATxmega32A4U DFU bootloader" */
    'A','T','x','m','e','g','a','3','2','A','4','U',' ','D','F','U',' ','b','o','o','t','l','o','a','d','e','r',
/* 0x104ef = "AirH PHONE AH-J3001V/J3002V" */
    'A','i','r','H',' ','P','H','O','N','E',' ','A','H','-','J','3','0','0','1','V','/','J','3','0','0','2','V',
/* 0x1050a = "E60 (IP Passthrough/RNDIS mode)" */
    'E','6','0',' ','(','I','P',' ','P','a','s','s','t','h','r','o','u','g','h','/','R','N','D','I','S',' ','\x1a',
/* 0x10525 = "iFP-500 series mp3 player (ums firmware)" */
    'i','F','P','-','5','0','0',' ','\x1d',' ','m','p','3',' ','p','l','a','y','e','r',' ','(','u','m','s',' ','\xdb',
/* 0x10540 = "K95 RGB Mechanical Gaming Keyboard" */
    'K','9','5',' ','R','G','B',' ','M','e','c','h','a','n','i','c','a','l',' ','G','a','m','i','n','g',' ','\x05',
/* 0x1055b = "Nokia Firmware Upgrade Mode" */
    'N','o','k','i','a',' ','F','i','r','m','w','a','r','e',' ','U','p','g','r','a','d','e',' ','M','o','d','e',
/* 0x10576 = "Meteor condenser microphone" */
    'M','e','t','e','o','r',' ','c','o','n','d','e','n','s','e','r',' ','m','i','c','r','o','p','h','o','n','e',
/* 0x10591 = "EI2000 Camera powered by Digita!" */
    'E','I','2','0','0','0',' ','\x04',' ','p','o','w','e','r','e','d',' ','b','y',' ','D','i','g','i','t','a','!',
/* 0x105ac = "CNUSB-611 (D) Wireless Adapter [AT76C503]" */
    'C','N','U','S','B','-','6','1','1',' ','(','D',')',' ','\x01','\x02',' ','[','A','T','7','6','C','5','0','3',']',
/* 0x105c7 = "TriTech Microelectronics, Ltd" */
    'T','r','i','T','e','c','h',' ','M','i','c','r','o','e','l','e','c','t','r','o','n','i','c','s',',',' ','\x16',
/* 0x105e2 = "Vibration,12-Button USB Wheel" */
    'V','i','b','r','a','t','i','o','n',',','1','2','-','B','u','t','t','o','n',' ','\x0a',' ','W','h','e','e','l',
/* 0x105fd = "Rollei Compactline (Video Mode)" */
    'R','o','l','l','e','i',' ','C','o','m','p','a','c','t','l','i','n','e',' ','(','\xa3',' ','M','o','d','e',')',
/* 0x10618 = "PTZ-1231W [Intuos3 (12x19)]" */
    'P','T','Z','-','1','2','3','1','W',' ','[','I','n','t','u','o','s','3',' ','(','1','2','x','1','9',')',']',
/* 0x10633 = "Hitachi Semiconductor and Devices Sales Co., Ltd" */
    'H','i','t','a','c','h','i',' ','\xc0',' ','\xe4','D','e','v','i','c','e','s',' ','S','a','l','e','s',' ','\x0e','\x16',
/* 0x1064e = "C01U Pro condenser microphone" */
    'C','0','1','U',' ','\x8f',' ','c','o','n','d','e','n','s','e','r',' ','m','i','c','r','o','p','h','o','n','e',
/* 0x10669 = "free for internal lab use 1004" */
    'f','r','e','e',' ','\xcc','i','n','t','e','r','n','a','l',' ','l','a','b',' ','u','s','e',' ','1','0','0','4',
/* 0x10684 = "GT-F650 [GT-S600/Perfection V10/V100]" */
    'G','T','-','F','6','5','0',' ','[','G','T','-','S','6','0','0','/','\xf0','V','1','0','/','V','1','0','0',']',
/* 0x1069f = "free for internal lab use 1000" */
    'f','r','e','e',' ','\xcc','i','n','t','e','r','n','a','l',' ','l','a','b',' ','u','s','e',' ','1','0','0','0',
/* 0x106ba = "free for internal lab use 1001" */
    'f','r','e','e',' ','\xcc','i','n','t','e','r','n','a','l',' ','l','a','b',' ','u','s','e',' ','1','0','0','1',
/* 0x106d5 = "E70 (IP Passthrough/RNDIS mode)" */
    'E','7','0',' ','(','I','P',' ','P','a','s','s','t','h','r','o','u','g','h','/','R','N','D','I','S',' ','\x1a',
/* 0x106f0 = "free for internal lab use 1002" */
    'f','r','e','e',' ','\xcc','i','n','t','e','r','n','a','l',' ','l','a','b',' ','u','s','e',' ','1','0','0','2',
/* 0x1070b = "free for internal lab use 1003" */
    'f','r','e','e',' ','\xcc','i','n','t','e','r','n','a','l',' ','l','a','b',' ','u','s','e',' ','1','0','0','3',
/* 0x10726 = "free for internal lab use 1008" */
    'f','r','e','e',' ','\xcc','i','n','t','e','r','n','a','l',' ','l','a','b',' ','u','s','e',' ','1','0','0','8',
/* 0x10741 = "Gravis Xterminator Digital Gamepad" */
    'G','r','a','v','i','s',' ','X','t','e','r','m','i','n','a','t','o','r',' ','\x09','G','a','m','e','p','a','d',
/* 0x1075c = "free for internal lab use 1005" */
    'f','r','e','e',' ','\xcc','i','n','t','e','r','n','a','l',' ','l','a','b',' ','u','s','e',' ','1','0','0','5',
/* 0x10777 = "Kisbee 802.15.4 transceiver" */
    'K','i','s','b','e','e',' ','8','0','2','.','1','5','.','4',' ','t','r','a','n','s','c','e','i','v','e','r',
/* 0x10792 = "UC-2322 2xSerial Ports [mos7820]" */
    'U','C','-','2','3','2','2',' ','2','x','\x90',' ','P','o','r','t','s',' ','[','m','o','s','7','8','2','0',']',
/* 0x107ad = "CTH-670 [Bamboo Create/Fun]" */
    'C','T','H','-','6','7','0',' ','[','B','a','m','b','o','o',' ','C','r','e','a','t','e','/','F','u','n',']',
/* 0x107c8 = "Fujitsu Microelectronics, Inc." */
    'F','u','j','i','t','s','u',' ','M','i','c','r','o','e','l','e','c','t','r','o','n','i','c','s',',',' ','\x07',
/* 0x107e3 = "free for internal lab use 1006" */
    'f','r','e','e',' ','\xcc','i','n','t','e','r','n','a','l',' ','l','a','b',' ','u','s','e',' ','1','0','0','6',
/* 0x107fe = "HDReye High Dynamic Range Camera" */
    'H','D','R','e','y','e',' ','H','i','g','h',' ','D','y','n','a','m','i','c',' ','R','a','n','g','e',' ','\x04',
/* 0x10819 = "Linux-USB CDC Composite Gadge (Ethernet and ACM)" */
    'L','i','n','u','x','-','\x0a',' ','C','D','C',' ','\x60','G','a','d','g','e',' ','(','\x7f',' ','\xe4','A','C','M',')',
/* 0x10834 = "8-Motor PhidgetAvancedServo" */
    '8','-','M','o','t','o','r',' ','P','h','i','d','g','e','t','A','v','a','n','c','e','d','S','e','r','v','o',
/* 0x1084f = "Alpermann+Velte MTD TCU 1HE" */
    'A','l','p','e','r','m','a','n','n','+','V','e','l','t','e',' ','M','T','D',' ','T','C','U',' ','1','H','E',
/* 0x1086a = "iFP-300 series mp3 player (ums firmware)" */
    'i','F','P','-','3','0','0',' ','\x1d',' ','m','p','3',' ','p','l','a','y','e','r',' ','(','u','m','s',' ','\xdb',
/* 0x10885 = "5800 XpressMusic (Imaging mode)" */
    '5','8','0','0',' ','X','p','r','e','s','s','M','u','s','i','c',' ','(','I','m','a','g','i','n','g',' ','\x1a',
/* 0x108a0 = "Centor-P RACIA-ALVAR USB PORT" */
    'C','e','n','t','o','r','-','P',' ','R','A','C','I','A','-','A','L','V','A','R',' ','\x0a',' ','P','O','R','T',
/* 0x108bb = "Hauppauge WinTV-USB II (PAL) with FM radio" */
    '\xfb','W','i','n','T','V','-','\x0a',' ','I','I',' ','(','P','A','L',')',' ','\x98','F','M',' ','r','a','d','i','o',
/* 0x108d6 = "West Mountain Radio RIGtalk" */
    'W','e','s','t',' ','M','o','u','n','t','a','i','n',' ','R','a','d','i','o',' ','R','I','G','t','a','l','k',
/* 0x108f1 = "GT-7300U [Perfection 1260/1260 PHOTO]" */
    'G','T','-','7','3','0','0','U',' ','[','\xf0','1','2','6','0','/','1','2','6','0',' ','P','H','O','T','O',']',
/* 0x1090c = "G2/Optimus Android Phone [Charge mode]" */
    'G','2','/','O','p','t','i','m','u','s',' ','\xce','\x19',' ','[','C','h','a','r','g','e',' ','m','o','d','e',']',
/* 0x10927 = "Olympia Telecom Vertriebs GmbH" */
    'O','l','y','m','p','i','a',' ','T','e','l','e','c','o','m',' ','V','e','r','t','r','i','e','b','s',' ','\xfc',
/* 0x10942 = "SERI E02 SCOM 6200 Flash Load Disk" */
    'S','E','R','I',' ','E','0','2',' ','S','C','O','M',' ','6','2','0','0',' ','\x3c',' ','L','o','a','d',' ','\xe8',
/* 0x1095d = "Allnet Wireless Network Adapter [Envara WiND512]" */
    'A','l','l','n','e','t',' ','\x01','\x8d','\x02',' ','[','E','n','v','a','r','a',' ','W','i','N','D','5','1','2',']',
/* 0x10978 = "Alpermann+Velte Universal Display" */
    'A','l','p','e','r','m','a','n','n','+','V','e','l','t','e',' ','U','n','i','v','e','r','s','a','l',' ','\xcf',
/* 0x10993 = "free for internal lab use 1007" */
    'f','r','e','e',' ','\xcc','i','n','t','e','r','n','a','l',' ','l','a','b',' ','u','s','e',' ','1','0','0','7',
/* 0x109ae = "Brilliance Semiconductor, Inc." */
    'B','r','i','l','l','i','a','n','c','e',' ','S','e','m','i','c','o','n','d','u','c','t','o','r',',',' ','\x07',
/* 0x109c9 = "force feedback Racing Wheel" */
    'f','o','r','c','e',' ','f','e','e','d','b','a','c','k',' ','R','a','c','i','n','g',' ','W','h','e','e','l',
/* 0x109e4 = "Genius PenSketch 6x8 Tablet" */
    'G','e','n','i','u','s',' ','P','e','n','S','k','e','t','c','h',' ','6','x','8',' ','T','a','b','l','e','t',
/* 0x109ff = "5610 XpressMusic (Imaging mode)" */
    '5','6','1','0',' ','X','p','r','e','s','s','M','u','s','i','c',' ','(','I','m','a','g','i','n','g',' ','\x1a',
/* 0x10a1a = "TS58xxA/TC56xxA [CoolTouch]" */
    'T','S','5','8','x','x','A','/','T','C','5','6','x','x','A',' ','[','C','o','o','l','T','o','u','c','h',']',
/* 0x10a35 = "F710 Wireless Gamepad [XInput Mode]" */
    'F','7','1','0',' ','\x01','G','a','m','e','p','a','d',' ','[','X','I','n','p','u','t',' ','M','o','d','e',']',
/* 0x10a50 = "WL-358v1 Wireless Micro USB Adapter 300N X3 002" */
    'W','L','-','3','5','8','v','1',' ','\x01','\xc4',' ','\x0a',' ','\x02',' ','3','0','0','N',' ','X','3',' ','0','0','2',
/* 0x10a6b = "AVerTV Volar Green HD (A835B)" */
    'A','V','e','r','\xda','V','o','l','a','r',' ','G','r','e','e','n',' ','H','D',' ','(','A','8','3','5','B',')',
/* 0x10a86 = "iFP-100 series mp3 player (ums firmware)" */
    'i','F','P','-','1','0','0',' ','\x1d',' ','m','p','3',' ','p','l','a','y','e','r',' ','(','u','m','s',' ','\xdb',
/* 0x10aa1 = "Xperia X10 mini pro (Debug)" */
    'X','p','e','r','i','a',' ','X','1','0',' ','m','i','n','i',' ','p','r','o',' ','(','D','e','b','u','g',')',
/* 0x10abc = "EUB-3701 EXT 802.11g Wireless Adapter [Ralink RT2571W]" */
    'E','U','B','-','3','7','0','1',' ','E','X','T',' ','\x94','\x01','\x02',' ','[','\x93','R','T','2','5','7','1','W',']',
/* 0x10ad7 = "5x5 STM32 prototyping board" */
    '5','x','5',' ','S','T','M','3','2',' ','p','r','o','t','o','t','y','p','i','n','g',' ','b','o','a','r','d',
/* 0x10af2 = "Compaq Computer Corp. [hex] (Digital Dream ??)" */
    'C','o','m','p','a','q',' ','\xcd','\x10',' ','[','h','e','x',']',' ','(','\x09','D','r','e','a','m',' ','?','?',')',
/* 0x10b0d = "Micro keyboard & mouse receiver" */
    '\xc4',' ','k','e','y','b','o','a','r','d',' ','&',' ','m','o','u','s','e',' ','r','e','c','e','i','v','e','r',
/* 0x10b28 = "DWL-G122 Wireless Adapter(rev.F1) [Realtek RTL8188SU]" */
    'D','W','L','-','G','1','2','2',' ','\x01','\xbb','F','1',')',' ','[','\xbe','R','T','L','8','1','8','8','S','U',']',
/* 0x10b43 = "Backup Plus Desktop Drive (5TB)" */
    'B','a','c','k','u','p',' ','P','l','u','s',' ','D','e','s','k','t','o','p',' ','\x14',' ','(','5','T','B',')',
/* 0x10b5e = "PhidgetTemperatureSensor Ver 1.0" */
    'P','h','i','d','g','e','t','T','e','m','p','e','r','a','t','u','r','e','\xac',' ','V','e','r',' ','1','.','0',
/* 0x10b79 = "5310 Xpress Music (PC Suite mode)" */
    '5','3','1','0',' ','X','p','r','e','s','s',' ','M','u','s','i','c',' ','(','\x1f','S','u','i','t','e',' ','\x1a',
/* 0x10b94 = "802.11b Wireless Adapter [Lucent/Agere Hermes I]" */
    '\x9b','\x01','\x02',' ','[','L','u','c','e','n','t','/','A','g','e','r','e',' ','H','e','r','m','e','s',' ','I',']',
/* 0x10baf = "PTH-450 [Intuos5 touch (S)]" */
    'P','T','H','-','4','5','0',' ','[','I','n','t','u','o','s','5',' ','t','o','u','c','h',' ','(','S',')',']',
/* 0x10bca = "AX88179 Gigabit Ethernet [Sitecom]" */
    'A','X','8','8','1','7','9',' ','G','i','g','a','b','i','t',' ','\x7f',' ','[','S','i','t','e','c','o','m',']',
/* 0x10be5 = "AT91SAM HID Mouse Demo Application" */
    'A','T','9','1','S','A','M',' ','\xf2','\x0b',' ','D','e','m','o',' ','A','p','p','l','i','c','a','t','i','o','n',
/* 0x10c00 = "Artec T1 USB2.0 TVBOX (cold" */
    'A','r','t','e','c',' ','T','1',' ','U','S','B','2','.','0',' ','T','V','B','O','X',' ','(','c','o','l','d',
/* 0x10c1b = "Xiamen Hung\'s Enterprise Co., Ltd" */
    'X','i','a','m','e','n',' ','H','u','n','g','\'','s',' ','E','n','t','e','r','p','r','i','s','e',' ','\x0e','\x16',
/* 0x10c36 = "miniCard D2301 802.11bg Wireless Module [SiS 163U]" */
    'm','i','n','i','\x15',' ','D','2','3','0','1',' ','\xad',' ','\x01','\xe5',' ','[','S','i','S',' ','1','6','3','U',']',
/* 0x10c51 = "StudioDock monitors (audio)" */
    'S','t','u','d','i','o','D','o','c','k',' ','m','o','n','i','t','o','r','s',' ','(','a','u','d','i','o',')',
/* 0x10c6c = "CTE-630BT [Graphire Wireless (6x8)]" */
    'C','T','E','-','6','3','0','B','T',' ','[','G','r','a','p','h','i','r','e',' ','\x01','(','6','x','8',')',']',
/* 0x10c87 = "Hauppauge WinTV-USB II (PAL) Model 566" */
    '\xfb','W','i','n','T','V','-','\x0a',' ','I','I',' ','(','P','A','L',')',' ','M','o','d','e','l',' ','5','6','6',
/* 0x10ca2 = "Pixma MP640 Multifunction device" */
    'P','i','x','m','a',' ','M','P','6','4','0',' ','M','u','l','t','i','f','u','n','c','t','i','o','n',' ','\xf9',
/* 0x10cbd = "EW-7811Un 802.11n Wireless Adapter [Realtek RTL8188CUS]" */
    'E','W','-','7','8','1','1','U','n',' ','\x99','\x01','\x02',' ','[','\xbe','R','T','L','8','1','8','8','C','U','S',']',
/* 0x10cd8 = "IDS Imaging Development Systems GmbH" */
    'I','D','S',' ','I','m','a','g','i','n','g',' ','D','e','v','e','l','o','p','m','e','n','t',' ','\xa6',' ','\xfc',
/* 0x10cf3 = "omni.net LCD Plus - ISDN TA" */
    'o','m','n','i','.','n','e','t',' ','L','C','D',' ','P','l','u','s',' ','-',' ','I','S','D','N',' ','T','A',
/* 0x10d0e = "Visual Communication Camera VGP-VCC7 [R5U870]" */
    'V','i','s','u','a','l',' ','\xe9','\x04',' ','V','G','P','-','V','C','C','7',' ','[','R','5','U','8','7','0',']',
/* 0x10d29 = "TEW-509UB 1.1R 802.11abg Wireless Adapter" */
    'T','E','W','-','5','0','9','U','B',' ','1','.','1','R',' ','8','0','2','.','1','1','a','b','g',' ','\x01','\x02',
/* 0x10d44 = "CBM2080 / CBM2090 Flash drive controller" */
    'C','B','M','2','0','8','0',' ','/',' ','C','B','M','2','0','9','0',' ','\x3c',' ','d','r','i','v','e',' ','\x9e',
/* 0x10d5f = "PCTV 72e [DiBcom DiB7000PC]" */
    'P','C','T','V',' ','7','2','e',' ','[','D','i','B','c','o','m',' ','D','i','B','7','0','0','0','P','C',']',
/* 0x10d7a = "Blackberry Playbook (Connect to Windows mode)" */
    'B','l','a','c','k','b','e','r','r','y',' ','P','l','a','y','b','o','o','k',' ','(','\xee','t','o',' ','\x83','\x1a',
/* 0x10d95 = "ARM-USB-TINY-H JTAG interface" */
    'A','R','M','-','\x0a','-','T','I','N','Y','-','H',' ','J','T','A','G',' ','i','n','t','e','r','f','a','c','e',
/* 0x10db0 = "Visual Communication Camera VGP-VCC2 [R5U870]" */
    'V','i','s','u','a','l',' ','\xe9','\x04',' ','V','G','P','-','V','C','C','2',' ','[','R','5','U','8','7','0',']',
/* 0x10dcb = "HASP copy protection dongle" */
    'H','A','S','P',' ','c','o','p','y',' ','p','r','o','t','e','c','t','i','o','n',' ','d','o','n','g','l','e',
/* 0x10de6 = "JCOP BlueZ Smartcard reader" */
    'J','C','O','P',' ','B','l','u','e','Z',' ','S','m','a','r','t','c','a','r','d',' ','r','e','a','d','e','r',
/* 0x10e01 = "WUSB54GSC v1 802.11g Adapter [Broadcom 4320 USB]" */
    'W','U','S','B','5','4','G','S','C',' ','v','1',' ','\x94','\x02',' ','[','\xeb','4','3','2','0',' ','U','S','B',']',
/* 0x10e1c = "Rockfire USB SkyShuttle Vibra" */
    'R','o','c','k','f','i','r','e',' ','\x0a',' ','S','k','y','S','h','u','t','t','l','e',' ','V','i','b','r','a',
/* 0x10e37 = "AirPcap NX [Atheros AR9001U-(2)NG]" */
    'A','i','r','P','c','a','p',' ','N','X',' ','[','\xaf','A','R','9','0','0','1','U','-','(','2',')','N','G',']',
/* 0x10e52 = "6288 GSM Smartphone (file transfer mode)" */
    '6','2','8','8',' ','G','S','M',' ','\xd4',' ','(','f','i','l','e',' ','t','r','a','n','s','f','e','r',' ','\x1a',
/* 0x10e6d = "MF691 [ T-Mobile webConnect Rocket 2.0]" */
    'M','F','6','9','1',' ','[',' ','T','-','\x96',' ','w','e','b','\xee','R','o','c','k','e','t',' ','2','.','0',']',
/* 0x10e88 = "Qualcomm Kyocera CDMA Technologies MSM" */
    'Q','u','a','l','c','o','m','m',' ','K','y','o','c','e','r','a',' ','C','D','M','A',' ','\x88',' ','M','S','M',
/* 0x10ea3 = "SAU510-USB Nano JTAG Emulator" */
    'S','A','U','5','1','0','-','\x0a',' ','N','a','n','o',' ','J','T','A','G',' ','E','m','u','l','a','t','o','r',
/* 0x10ebe = "UC-110T 100Mbps Ethernet [pegasus]" */
    'U','C','-','1','1','0','T',' ','1','0','0','M','b','p','s',' ','\x7f',' ','[','p','e','g','a','s','u','s',']',
/* 0x10ed9 = "AVerTV Hybrid Volar HX (A827)" */
    'A','V','e','r','\xda','H','y','b','r','i','d',' ','V','o','l','a','r',' ','H','X',' ','(','A','8','2','7',')',
/* 0x10ef4 = "External Hard Drive HD-CEU2 [Drive Station]" */
    '\xe3','H','a','r','d',' ','\x14',' ','H','D','-','C','E','U','2',' ','[','\x14',' ','S','t','a','t','i','o','n',']',
/* 0x10f0f = "Alpermann+Velte Rubidium S1" */
    'A','l','p','e','r','m','a','n','n','+','V','e','l','t','e',' ','R','u','b','i','d','i','u','m',' ','S','1',
/* 0x10f2a = "PhidgetInterface Kit 0-5-7 (Custom)" */
    'P','h','i','d','g','e','t','\x81',' ','K','i','t',' ','0','-','5','-','7',' ','(','C','u','s','t','o','m',')',
/* 0x10f45 = "Stellaris Development Board" */
    'S','t','e','l','l','a','r','i','s',' ','D','e','v','e','l','o','p','m','e','n','t',' ','B','o','a','r','d',
/* 0x10f60 = "Visual Communication Camera VGP-VCC3 [R5U870]" */
    'V','i','s','u','a','l',' ','\xe9','\x04',' ','V','G','P','-','V','C','C','3',' ','[','R','5','U','8','7','0',']',
/* 0x10f7b = "Asahi Kasei Microsystems Co., Ltd" */
    'A','s','a','h','i',' ','K','a','s','e','i',' ','M','i','c','r','o','s','y','s','t','e','m','s',' ','\x0e','\x16',
/* 0x10f96 = "DVD Multi-plus unit LDR-H443SU2" */
    'D','V','D',' ','\xd6','-','p','l','u','s',' ','u','n','i','t',' ','L','D','R','-','H','4','4','3','S','U','2',
/* 0x10fb1 = "Ascom Telecommunications, Ltd" */
    'A','s','c','o','m',' ','T','e','l','e','c','o','m','m','u','n','i','c','a','t','i','o','n','s',',',' ','\x16',
/* 0x10fcc = "Alcatel Speedstream 4060 ADSL Modem" */
    'A','l','c','a','t','e','l',' ','S','p','e','e','d','s','t','r','e','a','m',' ','4','0','6','0',' ','\xf1','\x1c',
/* 0x10fe7 = "F5D6051 802.11b Wireless Network Adapter [ZyDAS ZD1201]" */
    'F','5','D','6','0','5','1',' ','\x9b','\x01','\x8d','\x02',' ','[','Z','y','D','A','S',' ','Z','D','1','2','0','1',']',
/* 0x11002 = "WL-344 Wireless Adapter 300N X2 [Ralink RT3071]" */
    'W','L','-','3','4','4',' ','\x01','\x02',' ','3','0','0','N',' ','X','2',' ','[','\x93','R','T','3','0','7','1',']',
/* 0x1101d = "LUFA RNDIS Demo Application" */
    'L','U','F','A',' ','R','N','D','I','S',' ','D','e','m','o',' ','A','p','p','l','i','c','a','t','i','o','n',
/* 0x11038 = "XD-1218-U [Intuos2 (12x18)]" */
    'X','D','-','1','2','1','8','-','U',' ','[','I','n','t','u','o','s','2',' ','(','1','2','x','1','8',')',']',
/* 0x11053 = "2Wire PC Port Phoneline 10Mbps Adapter" */
    '2','W','i','r','e',' ','\x1f','\x87',' ','P','h','o','n','e','l','i','n','e',' ','1','0','M','b','p','s',' ','\x02',
/* 0x1106e = "GlobeTrotter Express 7.2 v2" */
    'G','l','o','b','e','T','r','o','t','t','e','r',' ','E','x','p','r','e','s','s',' ','7','.','2',' ','v','2',
/* 0x11089 = "EMP-21 Universal Programmer" */
    'E','M','P','-','2','1',' ','U','n','i','v','e','r','s','a','l',' ','P','r','o','g','r','a','m','m','e','r',
/* 0x110a4 = "Zaurus SL-5000D/SL-5500 PDA" */
    'Z','a','u','r','u','s',' ','S','L','-','5','0','0','0','D','/','S','L','-','5','5','0','0',' ','P','D','A',
/* 0x110bf = "Flash Update for TerraTec PHASE 26" */
    '\x3c',' ','U','p','d','a','t','e',' ','\xcc','T','e','r','r','a','T','e','c',' ','P','H','A','S','E',' ','2','6',
/* 0x110da = "Dual Trigger 3-in-1 (PC Mode)" */
    'D','u','a','l',' ','T','r','i','g','g','e','r',' ','3','-','i','n','-','1',' ','(','\x1f','M','o','d','e',')',
/* 0x110f5 = "Alpermann+Velte Rubidium H1" */
    'A','l','p','e','r','m','a','n','n','+','V','e','l','t','e',' ','R','u','b','i','d','i','u','m',' ','H','1',
/* 0x11110 = "Hercules Dualpix Chat and Show" */
    'H','e','r','c','u','l','e','s',' ','D','u','a','l','p','i','x',' ','C','h','a','t',' ','\xe4','S','h','o','w',
/* 0x1112b = "Siemens SpeedStream 1022 802.11b Adapter" */
    'S','i','e','m','e','n','s',' ','S','p','e','e','d','S','t','r','e','a','m',' ','1','0','2','2',' ','\x9b','\x02',
/* 0x11146 = "Alpermann+Velte Rubidium H3" */
    'A','l','p','e','r','m','a','n','n','+','V','e','l','t','e',' ','R','u','b','i','d','i','u','m',' ','H','3',
/* 0x11161 = "CDMA 1xEVDO PC Card, AirCard 580" */
    'C','D','M','A',' ','1','x','E','V','D','O',' ','\x1f','C','a','r','d',',',' ','A','i','r','\x15',' ','5','8','0',
/* 0x1117c = "E61 (IP Passthrough/RNDIS mode)" */
    'E','6','1',' ','(','I','P',' ','P','a','s','s','t','h','r','o','u','g','h','/','R','N','D','I','S',' ','\x1a',
/* 0x11197 = "WaveRider Communications, Inc." */
    'W','a','v','e','R','i','d','e','r',' ','C','o','m','m','u','n','i','c','a','t','i','o','n','s',',',' ','\x07',
/* 0x111b2 = "Zoom 4410 Wireless-G [Intersil ISL3887]" */
    '\xe6','4','4','1','0',' ','W','i','r','e','l','e','s','s','-','G',' ','[','\xb0','I','S','L','3','8','8','7',']',
/* 0x111cd = "IO Systems (Elite Electronics), Inc." */
    'I','O',' ','\xa6',' ','(','E','l','i','t','e',' ','E','l','e','c','t','r','o','n','i','c','s',')',',',' ','\x07',
/* 0x111e8 = "XD-1212-U [Intuos2 (12x12)]" */
    'X','D','-','1','2','1','2','-','U',' ','[','I','n','t','u','o','s','2',' ','(','1','2','x','1','2',')',']',
/* 0x11203 = "Arduino Zero Pro (bootloader)" */
    'A','r','d','u','i','n','o',' ','Z','e','r','o',' ','\x8f',' ','(','b','o','o','t','l','o','a','d','e','r',')',
/* 0x1121e = "TiVo AG0100 802.11bg Wireless Adapter [Broadcom BCM4320]" */
    'T','i','V','o',' ','A','G','0','1','0','0',' ','\xad',' ','\x01','\x02',' ','[','\xeb','B','C','M','4','3','2','0',']',
/* 0x11239 = "C-U0007 [Unifying Receiver]" */
    'C','-','U','0','0','0','7',' ','[','U','n','i','f','y','i','n','g',' ','R','e','c','e','i','v','e','r',']',
/* 0x11254 = "SBIG Astronomy Camera (without firmware)" */
    'S','B','I','G',' ','A','s','t','r','o','n','o','m','y',' ','\x04',' ','(','w','i','t','h','o','u','t',' ','\xdb',
/* 0x1126f = "SEMC DSS-20/DSS-25 SyncStation" */
    'S','E','M','C',' ','D','S','S','-','2','0','/','D','S','S','-','2','5',' ','\x91','S','t','a','t','i','o','n',
/* 0x1128a = "Super Flash 1GB / GXT  64MB Flash Drive" */
    'S','u','p','e','r',' ','\x3c',' ','1','G','B',' ','/',' ','G','X','T',' ',' ','6','4','M','B',' ','\x3c',' ','\x14',
/* 0x112a5 = "Minolta DiMAGE Z2 (PictBridge mode)" */
    'M','i','n','o','l','t','a',' ','D','i','M','A','G','E',' ','Z','2',' ','(','P','i','c','t','\x9f',' ','\x1a',
/* 0x112bf = "POS Printer (native mode), TH210" */
    'P','O','S',' ','\x0c',' ','(','n','a','t','i','v','e',' ','m','o','d','e',')',',',' ','T','H','2','1','0',
/* 0x112d9 = "SDDR-86 Imagemate 6-in-1 Reader" */
    'S','D','D','R','-','8','6',' ','I','m','a','g','e','m','a','t','e',' ','6','-','i','n','-','1',' ','\x08',
/* 0x112f3 = "Mobile Broadband 3G/UMTS (MC8790 Device)" */
    '\x96',' ','\xb7','3','G','/','U','M','T','S',' ','(','M','C','8','7','9','0',' ','D','e','v','i','c','e',')',
/* 0x1130d = "AE3000 802.11abgn (3x3) Wireless Adapter [Ralink RT3573]" */
    'A','E','3','0','0','0',' ','\xea','(','3','x','3',')',' ','\x01','\x02',' ','[','\x93','R','T','3','5','7','3',']',
/* 0x11327 = "LR7F06/LR7F14 Flash-OFDM modem" */
    'L','R','7','F','0','6','/','L','R','7','F','1','4',' ','\x3c','-','O','F','D','M',' ','m','o','d','e','m',
/* 0x11341 = "Speed Dragon Multimedia, Ltd" */
    'S','p','e','e','d',' ','D','r','a','g','o','n',' ','M','u','l','t','i','m','e','d','i','a',',',' ','\x16',
/* 0x1135b = "ValueMag Magnetic Stripe Reader" */
    'V','a','l','u','e','M','a','g',' ','M','a','g','n','e','t','i','c',' ','S','t','r','i','p','e',' ','\x08',
/* 0x11375 = "Yubikey Touch U2F Security Key" */
    'Y','u','b','i','k','e','y',' ','\x9d',' ','U','2','F',' ','S','e','c','u','r','i','t','y',' ','K','e','y',
/* 0x1138f = "Hi-Speed Flash Disk with TruePrint AES3500" */
    'H','i','-','S','p','e','e','d',' ','\x3c',' ','\xe8',' ','\x98','T','r','u','e','\xbd','A','E','S','3','5','0','0',
/* 0x113a9 = "GL620USB Host-Host interface" */
    'G','L','6','2','0','\x0a',' ','H','o','s','t','-','H','o','s','t',' ','i','n','t','e','r','f','a','c','e',
/* 0x113c3 = "USB1000 Gigabit Notebook Adapter" */
    'U','S','B','1','0','0','0',' ','G','i','g','a','b','i','t',' ','N','o','t','e','b','o','o','k',' ','\x02',
/* 0x113dd = "FinePix F6000fd/S6500fd Zoom (PTP)" */
    '\xca','i','x',' ','F','6','0','0','0','f','d','/','S','6','5','0','0','f','d',' ','\xe6','(','P','T','P',')',
/* 0x113f7 = "ES-2000 [Expression 1600U]" */
    'E','S','-','2','0','0','0',' ','[','E','x','p','r','e','s','s','i','o','n',' ','1','6','0','0','U',']',
/* 0x11411 = "TinyG open source motion controller" */
    'T','i','n','y','G',' ','o','p','e','n',' ','s','o','u','r','c','e',' ','m','o','t','i','o','n',' ','\x9e',
/* 0x1142b = "ME Office 600F/Stylus Office BX300F/TX300F" */
    'M','E',' ','\xd3',' ','6','0','0','F','/','\xb1','\xd3',' ','B','X','3','0','0','F','/','T','X','3','0','0','F',
/* 0x11445 = "GT-X900 [Perfection V700/V750 Photo]" */
    'G','T','-','X','9','0','0',' ','[','\xf0','V','7','0','0','/','V','7','5','0',' ','P','h','o','t','o',']',
/* 0x1145f = "Live! Cam Notebook Pro [VF0400]" */
    'L','i','v','e','!',' ','\x9a','N','o','t','e','b','o','o','k',' ','\x8f',' ','[','V','F','0','4','0','0',']',
/* 0x11479 = "Freescale Semiconductor, Inc." */
    'F','r','e','e','s','c','a','l','e',' ','S','e','m','i','c','o','n','d','u','c','t','o','r',',',' ','\x07',
/* 0x11493 = "ATK3 (Attack III Joystick)" */
    'A','T','K','3',' ','(','A','t','t','a','c','k',' ','I','I','I',' ','J','o','y','s','t','i','c','k',')',
/* 0x114ad = "Patriot 1.0 (TDMA) chipset" */
    'P','a','t','r','i','o','t',' ','1','.','0',' ','(','T','D','M','A',')',' ','c','h','i','p','s','e','t',
/* 0x114c7 = "Samsung Info. Systems America, Inc." */
    'S','a','m','s','u','n','g',' ','I','n','f','o','.',' ','\xa6',' ','A','m','e','r','i','c','a',',',' ','\x07',
/* 0x114e1 = "Taiyo Electric Wire & Cable Co., Ltd" */
    'T','a','i','y','o',' ','E','l','e','c','t','r','i','c',' ','W','i','r','e',' ','&',' ','\xa5',' ','\x0e','\x16',
/* 0x114fb = "at32uc3a0/1 DFU bootloader" */
    'a','t','3','2','u','c','3','a','0','/','1',' ','D','F','U',' ','b','o','o','t','l','o','a','d','e','r',
/* 0x11515 = "Crystalfontz CFA-631 USB LCD" */
    'C','r','y','s','t','a','l','f','o','n','t','z',' ','C','F','A','-','6','3','1',' ','\x0a',' ','L','C','D',
/* 0x1152f = "WinFast TV - SECAM DK + TXT + FM" */
    'W','i','n','\xec','\xda','-',' ','S','E','C','A','M',' ','D','K',' ','+',' ','T','X','T',' ','+',' ','F','M',
/* 0x11549 = "POS Printer (native mode), TH420" */
    'P','O','S',' ','\x0c',' ','(','n','a','t','i','v','e',' ','m','o','d','e',')',',',' ','T','H','4','2','0',
/* 0x11563 = "Exilim EX-Z350 Digital Camera (PictBridge mode)" */
    'E','x','i','l','i','m',' ','E','X','-','Z','3','5','0',' ','\x09','\x04',' ','(','P','i','c','t','\x9f',' ','\x1a',
/* 0x1157d = "Promptus Communications, Inc." */
    'P','r','o','m','p','t','u','s',' ','C','o','m','m','u','n','i','c','a','t','i','o','n','s',',',' ','\x07',
/* 0x11597 = "7167 Printer, Receipt/Slip" */
    '7','1','6','7',' ','P','r','i','n','t','e','r',',',' ','R','e','c','e','i','p','t','/','S','l','i','p',
/* 0x115b1 = "MF632/ONDA ET502HS/MT505UP" */
    'M','F','6','3','2','/','O','N','D','A',' ','E','T','5','0','2','H','S','/','M','T','5','0','5','U','P',
/* 0x115cb = "FTDI232 [MotorPr\u00fcfstand]" */
    'F','T','D','I','2','3','2',' ','[','M','o','t','o','r','P','r','\xff','\xc3','\xbc','f','s','t','a','n','d',']',
/* 0x115e5 = "Scorpius wireless keyboard" */
    'S','c','o','r','p','i','u','s',' ','w','i','r','e','l','e','s','s',' ','k','e','y','b','o','a','r','d',
/* 0x115ff = "WUSB54GC v2 802.11g Adapter [Realtek RTL8187B]" */
    'W','U','S','B','5','4','G','C',' ','v','2',' ','\x94','\x02',' ','[','\xbe','R','T','L','8','1','8','7','B',']',
/* 0x11619 = "eVision 123 digital camera" */
    'e','V','i','s','i','o','n',' ','1','2','3',' ','d','i','g','i','t','a','l',' ','c','a','m','e','r','a',
/* 0x11633 = "3Dconnexion Spaceball 5000" */
    '3','D','c','o','n','n','e','x','i','o','n',' ','S','p','a','c','e','b','a','l','l',' ','5','0','0','0',
/* 0x1164d = "Xperia S [Adb-Enable Mode]" */
    'X','p','e','r','i','a',' ','S',' ','[','A','d','b','-','E','n','a','b','l','e',' ','M','o','d','e',']',
/* 0x11667 = "WUSB54GS v2 802.11g Adapter [Broadcom 4320 USB]" */
    'W','U','S','B','5','4','G','S',' ','v','2',' ','\x94','\x02',' ','[','\xeb','4','3','2','0',' ','U','S','B',']',
/* 0x11681 = "Touchscreen Controller(Professional)" */
    '\xb5',' ','C','o','n','t','r','o','l','l','e','r','(','P','r','o','f','e','s','s','i','o','n','a','l',')',
/* 0x1169b = "Crystalfontz CFA-635 USB LCD" */
    'C','r','y','s','t','a','l','f','o','n','t','z',' ','C','F','A','-','6','3','5',' ','\x0a',' ','L','C','D',
/* 0x116b5 = "Macally (Mace Group, Inc.)" */
    'M','a','c','a','l','l','y',' ','(','M','a','c','e',' ','G','r','o','u','p',',',' ','I','n','c','.',')',
/* 0x116cf = "Eminent EM4045 [Broadcom 4320 USB]" */
    'E','m','i','n','e','n','t',' ','E','M','4','0','4','5',' ','[','\xeb','4','3','2','0',' ','U','S','B',']',
/* 0x116e9 = "DTV-DVB UDTT 7047M-USB 2.0 DVB-T Driver" */
    'D','T','V','-','D','V','B',' ','U','D','T','T',' ','7','0','4','7','M','-','\x0a',' ','\xc1','\xa7','T',' ','\xde',
/* 0x11703 = "LUFA Virtual Serial/Mass Storage Demo" */
    'L','U','F','A',' ','V','i','r','t','u','a','l',' ','S','e','r','i','a','l','/','\x7c','\x0f','D','e','m','o',
/* 0x1171d = "at32uc3b0/1 DFU bootloader" */
    'a','t','3','2','u','c','3','b','0','/','1',' ','D','F','U',' ','b','o','o','t','l','o','a','d','e','r',
/* 0x11737 = "NetVolante RTW65b Broadband Wireless Router" */
    'N','e','t','V','o','l','a','n','t','e',' ','R','T','W','6','5','b',' ','\xb7','\x01','R','o','u','t','e','r',
/* 0x11751 = "IronLogic RFID Adapter [Z-2 USB]" */
    'I','r','o','n','L','o','g','i','c',' ','R','F','I','D',' ','\x02',' ','[','Z','-','2',' ','U','S','B',']',
/* 0x1176b = "Novatek Microelectronics Corp." */
    'N','o','v','a','t','e','k',' ','M','i','c','r','o','e','l','e','c','t','r','o','n','i','c','s',' ','\x10',
/* 0x11785 = "Reflecta CrystalScan 7200 Photo-Scanner" */
    'R','e','f','l','e','c','t','a',' ','C','r','y','s','t','a','l','\x8a',' ','7','2','0','0',' ','\x86','-','\x25',
/* 0x1179f = "Phidgets Inc. (formerly GLAB)" */
    'P','h','i','d','g','e','t','s',' ','\x07',' ','(','f','o','r','m','e','r','l','y',' ','G','L','A','B',')',
/* 0x117b9 = "Stellaris Evaluation Board" */
    'S','t','e','l','l','a','r','i','s',' ','E','v','a','l','u','a','t','i','o','n',' ','B','o','a','r','d',
/* 0x117d3 = "Quickcam 3000 For Business" */
    'Q','u','i','c','k','c','a','m',' ','3','0','0','0',' ','F','o','r',' ','B','u','s','i','n','e','s','s',
/* 0x117ed = "DWA-110 Wireless G Adapter(rev.A1) [Ralink RT2571W]" */
    'D','W','A','-','1','1','0',' ','\x01','G',' ','\xbb','A','1',')',' ','[','\x93','R','T','2','5','7','1','W',']',
/* 0x11807 = "EOS 600D / Rebel T3i (ptp)" */
    'E','O','S',' ','6','0','0','D',' ','/',' ','R','e','b','e','l',' ','T','3','i',' ','(','p','t','p',')',
/* 0x11821 = "ASTRON INTERNATIONAL CORP." */
    'A','S','T','R','O','N',' ','I','N','T','E','R','N','A','T','I','O','N','A','L',' ','C','O','R','P','.',
/* 0x1183b = "WL-167G v3 802.11n Adapter [Realtek RTL8188SU]" */
    'W','L','-','1','6','7','G',' ','v','3',' ','\x99','\x02',' ','[','\xbe','R','T','L','8','1','8','8','S','U',']',
/* 0x11855 = "Marvell OpenRD Base/Client" */
    'M','a','r','v','e','l','l',' ','O','p','e','n','R','D',' ','B','a','s','e','/','C','l','i','e','n','t',
/* 0x1186f = "Suzhou Peter\'s Precise Industrial Co., Ltd" */
    'S','u','z','h','o','u',' ','P','e','t','e','r','\'','s',' ','P','r','e','c','i','s','e',' ','\xef','\x0e','\x16',
/* 0x11889 = "Optio 43WR (mass storage mode)" */
    'O','p','t','i','o',' ','4','3','W','R',' ','(','m','a','s','s',' ','s','t','o','r','a','g','e',' ','\x1a',
/* 0x118a3 = "WLI-UC-G300N Wireless LAN Adapter [Ralink RT2870]" */
    'W','L','I','-','U','C','-','G','3','0','0','N',' ','\x01','\xf3','\x02',' ','[','\x93','R','T','2','8','7','0',']',
/* 0x118bd = "Motorola Electronics Taiwan, Ltd [hex]" */
    'M','o','t','o','r','o','l','a',' ','\x1b',' ','T','a','i','w','a','n',',',' ','\x16',' ','[','h','e','x',']',
/* 0x118d7 = "Ut190 8 GB Flash Drive with MicroSD reader" */
    'U','t','1','9','0',' ','8',' ','G','B',' ','\x3c',' ','\x14',' ','\x98','\xc4','S','D',' ','r','e','a','d','e','r',
/* 0x118f1 = "15 inch Detachable Monitor" */
    '1','5',' ','i','n','c','h',' ','D','e','t','a','c','h','a','b','l','e',' ','M','o','n','i','t','o','r',
/* 0x1190b = "TASCAM Portastudio DP-01FX" */
    'T','A','S','C','A','M',' ','P','o','r','t','a','s','t','u','d','i','o',' ','D','P','-','0','1','F','X',
/* 0x11925 = "Compact Optical Mouse, model 1016" */
    'C','o','m','p','a','c','t',' ','\x7b','M','o','u','s','e',',',' ','m','o','d','e','l',' ','1','0','1','6',
/* 0x1193f = "Clie PEG-S300/D PalmOS PDA" */
    'C','l','i','e',' ','P','E','G','-','S','3','0','0','/','D',' ','P','a','l','m','O','S',' ','P','D','A',
/* 0x11959 = "LUFA MIDI Demo Application" */
    'L','U','F','A',' ','M','I','D','I',' ','D','e','m','o',' ','A','p','p','l','i','c','a','t','i','o','n',
/* 0x11973 = "Emerge Uni-retractable Laser Mouse" */
    'E','m','e','r','g','e',' ','U','n','i','-','r','e','t','r','a','c','t','a','b','l','e',' ','\x82',' ','\x0b',
/* 0x1198d = "DTV-DVB UDTT 7047Z-USB 2.0 DVB-T Driver" */
    'D','T','V','-','D','V','B',' ','U','D','T','T',' ','7','0','4','7','Z','-','\x0a',' ','\xc1','\xa7','T',' ','\xde',
/* 0x119a7 = "JAMER INDUSTRIES CO., LTD." */
    'J','A','M','E','R',' ','I','N','D','U','S','T','R','I','E','S',' ','C','O','.',',',' ','L','T','D','.',
/* 0x119c1 = "BCM92045DG-Flash with trace filter" */
    'B','C','M','9','2','0','4','5','D','G','-','\x3c',' ','\x98','t','r','a','c','e',' ','f','i','l','t','e','r',
/* 0x119db = "SmartJoy Frag Xpad/PS2 adaptor" */
    '\x12','J','o','y',' ','F','r','a','g',' ','X','p','a','d','/','P','S','2',' ','a','d','a','p','t','o','r',
/* 0x119f5 = "SPZ2000 Webcam [PixArt PAC7332]" */
    'S','P','Z','2','0','0','0',' ','\x11',' ','[','P','i','x','A','r','t',' ','P','A','C','7','3','3','2',']',
/* 0x11a0f = "Tapwave Handheld [Tapwave Zodiac]" */
    'T','a','p','w','a','v','e',' ','\xc5',' ','[','T','a','p','w','a','v','e',' ','Z','o','d','i','a','c',']',
/* 0x11a29 = "Spectrograph - Renumerated" */
    'S','p','e','c','t','r','o','g','r','a','p','h',' ','-',' ','R','e','n','u','m','e','r','a','t','e','d',
/* 0x11a43 = "EDIROL UM-880 MIDI I/F (generic)" */
    '\xf8','U','M','-','8','8','0',' ','M','I','D','I',' ','I','/','F',' ','(','g','e','n','e','r','i','c',')',
/* 0x11a5d = "Xytronix Research & Design" */
    'X','y','t','r','o','n','i','x',' ','R','e','s','e','a','r','c','h',' ','&',' ','D','e','s','i','g','n',
/* 0x11a77 = "Taiwan Semiconductor Manufacturing Co." */
    'T','a','i','w','a','n',' ','\xc0',' ','M','a','n','u','f','a','c','t','u','r','i','n','g',' ','C','o','.',
/* 0x11a91 = "F5U002 Parallel Port [uss720]" */
    'F','5','U','0','0','2',' ','P','a','r','a','l','l','e','l',' ','\x87',' ','[','u','s','s','7','2','0',']',
/* 0x11aab = "HM230d Virtual Bus for Helium" */
    'H','M','2','3','0','d',' ','V','i','r','t','u','a','l',' ','B','u','s',' ','\xcc','H','e','l','i','u','m',
/* 0x11ac5 = "SpeedTouch 120g 802.11g Wireless Adapter [Intersil ISL3886]" */
    'S','p','e','e','d','\x9d',' ','1','2','0','g',' ','\x94','\x01','\x02',' ','[','\xb0','I','S','L','3','8','8','6',']',
/* 0x11adf = "Celestix Networks, Pte., Ltd" */
    'C','e','l','e','s','t','i','x',' ','N','e','t','w','o','r','k','s',',',' ','P','t','e','.',',',' ','\x16',
/* 0x11af9 = "All-In-One Multi-Card Reader CA200/B/S" */
    'A','l','l','-','I','n','-','O','n','e',' ','\xd6','-','\x15',' ','\x08',' ','C','A','2','0','0','/','B','/','S',
/* 0x11b13 = "F9L1101v2 802.11abgn Wireless Adapter [Realtek RTL8192DU]" */
    'F','9','L','1','1','0','1','v','2',' ','\xea','\x01','\x02',' ','[','\xbe','R','T','L','8','1','9','2','D','U',']',
/* 0x11b2d = "Merlin U740 (non-Vodafone)" */
    'M','e','r','l','i','n',' ','U','7','4','0',' ','(','n','o','n','-','V','o','d','a','f','o','n','e',')',
/* 0x11b47 = "Flatron 795FT Plus Monitor" */
    'F','l','a','t','r','o','n',' ','7','9','5','F','T',' ','P','l','u','s',' ','M','o','n','i','t','o','r',
/* 0x11b61 = "Minolta DiMAGE Z5 (PictBridge mode)" */
    'M','i','n','o','l','t','a',' ','D','i','M','A','G','E',' ','Z','5',' ','(','P','i','c','t','\x9f',' ','\x1a',
/* 0x11b7b = "Clie PEG-TJ35 PDA Mass Storage" */
    'C','l','i','e',' ','P','E','G','-','T','J','3','5',' ','P','D','A',' ','\x7c','S','t','o','r','a','g','e',
/* 0x11b95 = "C-Bus Architectural Dimmer" */
    'C','-','B','u','s',' ','A','r','c','h','i','t','e','c','t','u','r','a','l',' ','D','i','m','m','e','r',
/* 0x11baf = "3M TL20 Temperature Logger" */
    '3','M',' ','T','L','2','0',' ','T','e','m','p','e','r','a','t','u','r','e',' ','L','o','g','g','e','r',
/* 0x11bc9 = "HID Keyboard, Barcode scanner" */
    '\xf2','K','e','y','b','o','a','r','d',',',' ','B','a','r','c','o','d','e',' ','s','c','a','n','n','e','r',
/* 0x11be3 = "6303 classic Phone (Mass storage mode)" */
    '6','3','0','3',' ','c','l','a','s','s','i','c',' ','\x19',' ','(','\x7c','s','t','o','r','a','g','e',' ','\x1a',
/* 0x11bfd = "My Book Essential (WDBACW)" */
    'M','y',' ','B','o','o','k',' ','E','s','s','e','n','t','i','a','l',' ','(','W','D','B','A','C','W',')',
/* 0x11c17 = "CitiDISK Jr. IDE Enclosure" */
    'C','i','t','i','D','I','S','K',' ','J','r','.',' ','I','D','E',' ','E','n','c','l','o','s','u','r','e',
/* 0x11c31 = "mobiBLU DAH-1200 MP3/Ogg Player" */
    'm','o','b','i','B','L','U',' ','D','A','H','-','1','2','0','0',' ','M','P','3','/','O','g','g',' ','\x1e',
/* 0x11c4b = "Mouse-Trak 3-button Track Ball" */
    '\x0b','-','T','r','a','k',' ','3','-','b','u','t','t','o','n',' ','T','r','a','c','k',' ','B','a','l','l',
/* 0x11c65 = "Sony-Ericsson / Samsung DataCable" */
    'S','o','n','y','-','E','r','i','c','s','s','o','n',' ','/',' ','S','a','m','s','u','n','g',' ','\xe7','\xa5',
/* 0x11c7f = "AWN-8020 WLAN [Intersil PRISM 2.5]" */
    'A','W','N','-','8','0','2','0',' ','W','L','A','N',' ','[','\xb0','P','R','I','S','M',' ','2','.','5',']',
/* 0x11c99 = "AverTV Volar Black HD (A850)" */
    'A','v','e','r','\xda','V','o','l','a','r',' ','B','l','a','c','k',' ','H','D',' ','(','A','8','5','0',')',
/* 0x11cb3 = "WinTV PVR USB2 (Model 24019)" */
    'W','i','n','\xda','P','V','R',' ','U','S','B','2',' ','(','M','o','d','e','l',' ','2','4','0','1','9',')',
/* 0x11ccd = "Cambridge Silicon Radio, Ltd" */
    'C','a','m','b','r','i','d','g','e',' ','S','i','l','i','c','o','n',' ','R','a','d','i','o',',',' ','\x16',
/* 0x11ce7 = "Kaser 8gB micro hard drive" */
    'K','a','s','e','r',' ','8','g','B',' ','m','i','c','r','o',' ','h','a','r','d',' ','d','r','i','v','e',
/* 0x11d01 = "Crystalfontz CFA-634 USB LCD" */
    'C','r','y','s','t','a','l','f','o','n','t','z',' ','C','F','A','-','6','3','4',' ','\x0a',' ','L','C','D',
/* 0x11d1b = "CG-WLUSB2GT 802.11g Wireless Adapter [Intersil ISL3880]" */
    'C','G','-','W','L','U','S','B','2','G','T',' ','\x94','\x01','\x02',' ','[','\xb0','I','S','L','3','8','8','0',']',
/* 0x11d35 = "ET-0507A [Graphire2 (5x7)]" */
    'E','T','-','0','5','0','7','A',' ','[','G','r','a','p','h','i','r','e','2',' ','(','5','x','7',')',']',
/* 0x11d4f = "Expert mouseCLOCK USB II HBG" */
    'E','x','p','e','r','t',' ','m','o','u','s','e','C','L','O','C','K',' ','\x0a',' ','I','I',' ','H','B','G',
/* 0x11d69 = "PTZ-1230 [Intuos3 (12x12)]" */
    'P','T','Z','-','1','2','3','0',' ','[','I','n','t','u','o','s','3',' ','(','1','2','x','1','2',')',']',
/* 0x11d83 = "XIRING Smart Card Terminal LEO V2" */
    'X','I','R','I','N','G',' ','\x12',' ','\x15',' ','T','e','r','m','i','n','a','l',' ','L','E','O',' ','V','2',
/* 0x11d9d = "XD-0912-U [Intuos2 (9x12)]" */
    'X','D','-','0','9','1','2','-','U',' ','[','I','n','t','u','o','s','2',' ','(','9','x','1','2',')',']',
/* 0x11db7 = "DWA-133 802.11n Wireless N Adapter [Realtek RTL8192CU]" */
    'D','W','A','-','1','3','3',' ','\x99','\x01','N',' ','\x02',' ','[','\xbe','R','T','L','8','1','9','2','C','U',']',
/* 0x11dd1 = "WinFast DTV Dongle (STK7700P based)" */
    'W','i','n','\xec','D','T','V',' ','\xf4',' ','(','S','T','K','7','7','0','0','P',' ','b','a','s','e','d',')',
/* 0x11deb = "Teensyduino Serial+Keyboard+Mouse+Joystick" */
    'T','e','e','n','s','y','d','u','i','n','o',' ','\x90','+','\x05','+','\x0b','+','J','o','y','s','t','i','c','k',
/* 0x11e05 = "LUFA Multiple Report HID Demo" */
    'L','U','F','A',' ','M','u','l','t','i','p','l','e',' ','R','e','p','o','r','t',' ','\xf2','D','e','m','o',
/* 0x11e1f = "Thermaltake eSPORTS Meka Keyboard" */
    'T','h','e','r','m','a','l','t','a','k','e',' ','e','S','P','O','R','T','S',' ','M','e','k','a',' ','\x05',
/* 0x11e39 = "SideWinder\u00ae  Freestyle Pro" */
    'S','i','d','e','W','i','n','d','e','r','\xff','\xc2','\xae',' ',' ','F','r','e','e','s','t','y','l','e',' ','\x8f',
/* 0x11e53 = "MCS7720 Dual serial port adapter" */
    'M','C','S','7','7','2','0',' ','D','u','a','l',' ','s','e','r','i','a','l',' ','p','o','r','t',' ','\xd0',
/* 0x11e6d = "PRO/Wireless 2011B 802.11b Adapter [Intersil PRISM 2.5]" */
    'P','R','O','/','\x01','2','0','1','1','B',' ','\x9b','\x02',' ','[','\xb0','P','R','I','S','M',' ','2','.','5',']',
/* 0x11e87 = "Web Cam - Asus F3SA, F9J, F9S" */
    'W','e','b',' ','\x9a','-',' ','A','s','u','s',' ','F','3','S','A',',',' ','F','9','J',',',' ','F','9','S',
/* 0X11ea1 = "San Chieh Manufacturing, Ltd" */
    'a','n',' ','C','h','i','e','h',' ','M','a','n','u','f','a','c','t','u','r','i','n','g',',',' ','\x16',
/* 0x11eba = "Creative Labs VoIP Blaster" */
    'C','r','e','a','t','i','v','e',' ','L','a','b','s',' ','V','o','I','P',' ','B','l','a','s','t','e','r',
/* 0x11ed4 = "Lenovo Vc0323+MI1310_SOC Camera" */
    'L','e','n','o','v','o',' ','V','c','0','3','2','3','+','M','I','1','3','1','0','_','S','O','C',' ','\x04',
/* 0x11eee = "netMod Driver Ver 2.4.17 (CAPI)" */
    'n','e','t','M','o','d',' ','\xde',' ','V','e','r',' ','2','.','4','.','1','7',' ','(','C','A','P','I',')',
/* 0x11f08 = "Sirius Battery Free Tablet" */
    'S','i','r','i','u','s',' ','B','a','t','t','e','r','y',' ','F','r','e','e',' ','T','a','b','l','e','t',
/* 0x11f22 = "AT91SAM Mass Storage Demo Application" */
    'A','T','9','1','S','A','M',' ','\x7c','\x0f','D','e','m','o',' ','A','p','p','l','i','c','a','t','i','o','n',
/* 0x11f3c = "MSP430 USB HID Bootstrap Loader" */
    'M','S','P','4','3','0',' ','\x0a',' ','\xf2','B','o','o','t','s','t','r','a','p',' ','L','o','a','d','e','r',
/* 0x11f56 = "Onda H600/N501HS ZTE MF330" */
    'O','n','d','a',' ','H','6','0','0','/','N','5','0','1','H','S',' ','Z','T','E',' ','M','F','3','3','0',
/* 0x11f70 = "Dimage Scan Elite 5400 (2890)" */
    'D','i','m','a','g','e',' ','\x8a',' ','E','l','i','t','e',' ','5','4','0','0',' ','(','2','8','9','0',')',
/* 0x11f8a = "88W8338 [Libertas] 802.11g" */
    '8','8','W','8','3','3','8',' ','[','L','i','b','e','r','t','a','s',']',' ','8','0','2','.','1','1','g',
/* 0x11fa4 = "Crystalfontz CFA-633 USB LCD" */
    'C','r','y','s','t','a','l','f','o','n','t','z',' ','C','F','A','-','6','3','3',' ','\x0a',' ','L','C','D',
/* 0x11fbe = "5800 XpressMusic (PC Suite mode)" */
    '5','8','0','0',' ','X','p','r','e','s','s','M','u','s','i','c',' ','(','\x1f','S','u','i','t','e',' ','\x1a',
/* 0x11fd8 = "STORAGE ADAPTER (FireLite)" */
    'S','T','O','R','A','G','E',' ','A','D','A','P','T','E','R',' ','(','F','i','r','e','L','i','t','e',')',
/* 0x11ff2 = "DWA-120 802.11g Wireless 108G Adapter [Atheros AR5523]" */
    'D','W','A','-','1','2','0',' ','\x94','\x01','1','0','8','G',' ','\x02',' ','[','\xaf','A','R','5','5','2','3',']',
/* 0x1200c = "DTV-DVB UDTT 7047A-USB 2.0 DVB-T Driver" */
    'D','T','V','-','D','V','B',' ','U','D','T','T',' ','7','0','4','7','A','-','\x0a',' ','\xc1','\xa7','T',' ','\xde',
/* 0x12026 = "SkyEye Weather Satellite Receiver" */
    'S','k','y','E','y','e',' ','W','e','a','t','h','e','r',' ','S','a','t','e','l','l','i','t','e',' ','\x8c',
/* 0x12040 = "iRex Technologies Gobi 2000 Wireless Modem (QDL mode)" */
    'i','R','e','x',' ','\x88',' ','G','o','b','i',' ','2','0','0','0',' ','\x01','\x1c',' ','(','Q','D','L',' ','\x1a',
/* 0x1205a = "WUSB54GS v1 802.11g Adapter [Broadcom 4320 USB]" */
    'W','U','S','B','5','4','G','S',' ','v','1',' ','\x94','\x02',' ','[','\xeb','4','3','2','0',' ','U','S','B',']',
/* 0x12074 = "SCSI-HD50 SCSI Bridge [shuttle]" */
    'S','C','S','I','-','H','D','5','0',' ','S','C','S','I',' ','\x9f',' ','[','s','h','u','t','t','l','e',']',
/* 0x1208e = "5610 XpressMusic (PC Suite mode)" */
    '5','6','1','0',' ','X','p','r','e','s','s','M','u','s','i','c',' ','(','\x1f','S','u','i','t','e',' ','\x1a',
/* 0x120a8 = "CTL-671 [One by Wacom (M)]" */
    'C','T','L','-','6','7','1',' ','[','O','n','e',' ','b','y',' ','W','a','c','o','m',' ','(','M',')',']',
/* 0x120c2 = "WLI-UC-G301N Wireless LAN Adapter [Ralink RT3072]" */
    'W','L','I','-','U','C','-','G','3','0','1','N',' ','\x01','\xf3','\x02',' ','[','\x93','R','T','3','0','7','2',']',
/* 0x120dc = "WUSB11 v4.0 802.11b Adapter [ALi M4301]" */
    'W','U','S','B','1','1',' ','v','4','.','0',' ','\x9b','\x02',' ','[','A','L','i',' ','M','4','3','0','1',']',
/* 0x120f6 = "Elitegroup ECS-C11 Storage" */
    'E','l','i','t','e','g','r','o','u','p',' ','E','C','S','-','C','1','1',' ','S','t','o','r','a','g','e',
/* 0x12110 = "My Passport Ultra (WDBMWV, WDBZFP)" */
    'M','y',' ','\xd5','U','l','t','r','a',' ','(','W','D','B','M','W','V',',',' ','W','D','B','Z','F','P',')',
/* 0x1212a = "Disc Stakka CD/DVD Manager" */
    'D','i','s','c',' ','S','t','a','k','k','a',' ','C','D','/','D','V','D',' ','M','a','n','a','g','e','r',
/* 0x12144 = "ConvertX M402U A/V Capture" */
    'C','o','n','v','e','r','t','X',' ','M','4','0','2','U',' ','A','/','V',' ','C','a','p','t','u','r','e',
/* 0x1215e = "Smooth Cord & Connector Co., Ltd" */
    'S','m','o','o','t','h',' ','C','o','r','d',' ','&',' ','C','o','n','n','e','c','t','o','r',' ','\x0e','\x16',
/* 0x12178 = "F1DF102U/F1DG102U Flip KVM" */
    'F','1','D','F','1','0','2','U','/','F','1','D','G','1','0','2','U',' ','F','l','i','p',' ','K','V','M',
/* 0x12192 = "DataTraveler 100 G3/G4/SE9 G2" */
    '\xe7','T','r','a','v','e','l','e','r',' ','1','0','0',' ','G','3','/','G','4','/','S','E','9',' ','G','2',
/* 0x121ac = "Worthington Data Solutions, Inc." */
    'W','o','r','t','h','i','n','g','t','o','n',' ','\xe7',' ','S','o','l','u','t','i','o','n','s',',',' ','\x07',
/* 0x121c6 = "Syntek 0.3MPixel USB 2.0 UVC PC Camera" */
    'S','y','n','t','e','k',' ','0','.','3','M','P','i','x','e','l',' ','\x0a',' ','\xc1','U','V','C',' ','\x1f','\x04',
/* 0x121e0 = "VCP + UVC, Barcode scanner" */
    'V','C','P',' ','+',' ','U','V','C',',',' ','B','a','r','c','o','d','e',' ','s','c','a','n','n','e','r',
/* 0x121fa = "Victor Company of Japan, Ltd" */
    'V','i','c','t','o','r',' ','C','o','m','p','a','n','y',' ','o','f',' ','J','a','p','a','n',',',' ','\x16',
/* 0x12214 = "Zaurus SL-B500/SL-5600 PDA" */
    'Z','a','u','r','u','s',' ','S','L','-','B','5','0','0','/','S','L','-','5','6','0','0',' ','P','D','A',
/* 0X1222e = "Arduino Leonardo (CDC ACM)" */
    'r','d','u','i','n','o',' ','L','e','o','n','a','r','d','o',' ','(','C','D','C',' ','A','C','M',')',
/* 0x12247 = "Xiamen Doowell Electron Co., Ltd" */
    'X','i','a','m','e','n',' ','D','o','o','w','e','l','l',' ','E','l','e','c','t','r','o','n',' ','\x0e','\x16',
/* 0x12261 = "Mini 256MB/512MB Flash Drive [IOM2D5]" */
    '\xb9',' ','2','5','6','M','B','/','5','1','2','M','B',' ','\x3c',' ','\x14',' ','[','I','O','M','2','D','5',']',
/* 0x1227b = "Minolta DiMAGE Z3 (PictBridge mode)" */
    'M','i','n','o','l','t','a',' ','D','i','M','A','G','E',' ','Z','3',' ','(','P','i','c','t','\x9f',' ','\x1a',
/* 0x12295 = "SCSI-DB25 SCSI Bridge [shuttle]" */
    'S','C','S','I','-','D','B','2','5',' ','S','C','S','I',' ','\x9f',' ','[','s','h','u','t','t','l','e',']',
/* 0x122af = "B2500MFP (printer+scanner)" */
    'B','2','5','0','0','M','F','P',' ','(','p','r','i','n','t','e','r','+','s','c','a','n','n','e','r',')',
/* 0x122c9 = "Kingston Data Traveler2.0 Disk Driver" */
    'K','i','n','g','s','t','o','n',' ','\xe7',' ','T','r','a','v','e','l','e','r','2','.','0',' ','\xe8',' ','\xde',
/* 0x122e3 = "HP 2.0MP High Definition Webcam" */
    'H','P',' ','2','.','0','M','P',' ','H','i','g','h',' ','D','e','f','i','n','i','t','i','o','n',' ','\x11',
/* 0x122fd = "Samsung SE-208 Slim Portable DVD Writer" */
    'S','a','m','s','u','n','g',' ','S','E','-','2','0','8',' ','S','l','i','m',' ','\xa9','D','V','D',' ','\xdf',
/* 0x12317 = "Phantom 336CX - C3 scanner" */
    'P','h','a','n','t','o','m',' ','3','3','6','C','X',' ','-',' ','C','3',' ','s','c','a','n','n','e','r',
/* 0x12331 = "USA-28Xa PDA [no firmware]" */
    'U','S','A','-','2','8','X','a',' ','P','D','A',' ','[','n','o',' ','f','i','r','m','w','a','r','e',']',
/* 0x1234b = "X-F710F Optical Mouse 3xFire Gaming Mouse" */
    'X','-','F','7','1','0','F',' ','\x7b','\x0b',' ','3','x','F','i','r','e',' ','G','a','m','i','n','g',' ','\x0b',
/* 0x12365 = "Rollei Compactline (Storage Mode)" */
    'R','o','l','l','e','i',' ','C','o','m','p','a','c','t','l','i','n','e',' ','(','\x0f','M','o','d','e',')',
/* 0x1237f = "Rohde & Schwarz GmbH & Co. KG" */
    'R','o','h','d','e',' ','&',' ','S','c','h','w','a','r','z',' ','\xfc',' ','&',' ','C','o','.',' ','K','G',
/* 0x12399 = "Information Systems Laboratories" */
    'I','n','f','o','r','m','a','t','i','o','n',' ','\xa6',' ','L','a','b','o','r','a','t','o','r','i','e','s',
/* 0x123b3 = "Motorola Semiconductor Products Sector" */
    'M','o','t','o','r','o','l','a',' ','\xc0',' ','P','r','o','d','u','c','t','s',' ','S','e','c','t','o','r',
/* 0x123cd = "Sky Love Actually IM-U460K" */
    'S','k','y',' ','L','o','v','e',' ','A','c','t','u','a','l','l','y',' ','I','M','-','U','4','6','0','K',
/* 0x123e7 = "Central System Research Co., Ltd" */
    'C','e','n','t','r','a','l',' ','S','y','s','t','e','m',' ','R','e','s','e','a','r','c','h',' ','\x0e','\x16',
/* 0x12401 = "Diamond Pro 900u CRT Monitor" */
    'D','i','a','m','o','n','d',' ','\x8f',' ','9','0','0','u',' ','C','R','T',' ','M','o','n','i','t','o','r',
/* 0x1241b = "F510 Gamepad [XInput Mode]" */
    'F','5','1','0',' ','G','a','m','e','p','a','d',' ','[','X','I','n','p','u','t',' ','M','o','d','e',']',
/* 0x12435 = "Wireless Intellimouse Explorer 2.0" */
    '\x01','I','n','t','e','l','l','i','m','o','u','s','e',' ','E','x','p','l','o','r','e','r',' ','2','.','0',
/* 0x1244f = "ISDN TA / Light Rider 128K" */
    'I','S','D','N',' ','T','A',' ','/',' ','L','i','g','h','t',' ','R','i','d','e','r',' ','1','2','8','K',
/* 0x12469 = "Clie PEG-T425 PDA Mass Storage" */
    'C','l','i','e',' ','P','E','G','-','T','4','2','5',' ','P','D','A',' ','\x7c','S','t','o','r','a','g','e',
/* 0x12483 = "AirPremier AG DWL-AG132 Wireless Adapter" */
    'A','i','r','P','r','e','m','i','e','r',' ','A','G',' ','D','W','L','-','A','G','1','3','2',' ','\x01','\x02',
/* 0x1249d = "Trust 350FS POWERC@M FLASH" */
    'T','r','u','s','t',' ','3','5','0','F','S',' ','P','O','W','E','R','C','@','M',' ','F','L','A','S','H',
/* 0x124b7 = "Crystalfontz CFA-632 USB LCD" */
    'C','r','y','s','t','a','l','f','o','n','t','z',' ','C','F','A','-','6','3','2',' ','\x0a',' ','L','C','D',
/* 0x124d1 = "ATMEGA328P-XMINI (CDC ACM)" */
    'A','T','M','E','G','A','3','2','8','P','-','X','M','I','N','I',' ','(','C','D','C',' ','A','C','M',')',
/* 0x124eb = "DVD Multi-plus unit LDR-H443U2" */
    'D','V','D',' ','\xd6','-','p','l','u','s',' ','u','n','i','t',' ','L','D','R','-','H','4','4','3','U','2',
/* 0x12505 = "Hi-Speed Flash Disk with TruePrint AES3400" */
    'H','i','-','S','p','e','e','d',' ','\x3c',' ','\xe8',' ','\x98','T','r','u','e','\xbd','A','E','S','3','4','0','0',
/* 0x1251f = "U2SCX-LVD (SCSI Converter)" */
    'U','2','S','C','X','-','L','V','D',' ','(','S','C','S','I',' ','C','o','n','v','e','r','t','e','r',')',
/* 0x12539 = "Onda V972 (storage access)" */
    'O','n','d','a',' ','V','9','7','2',' ','(','s','t','o','r','a','g','e',' ','a','c','c','e','s','s',')',
/* 0x12553 = "A90-211WG-01 802.11g Adapter [Intersil ISL3887]" */
    'A','9','0','-','2','1','1','W','G','-','0','1',' ','\x94','\x02',' ','[','\xb0','I','S','L','3','8','8','7',']',
/* 0x1256d = "USA-28Xb PDA [no firmware]" */
    'U','S','A','-','2','8','X','b',' ','P','D','A',' ','[','n','o',' ','f','i','r','m','w','a','r','e',']',
/* 0x12587 = "NWD2205 802.11n Wireless N Adapter [Realtek RTL8192CU]" */
    'N','W','D','2','2','0','5',' ','\x99','\x01','N',' ','\x02',' ','[','\xbe','R','T','L','8','1','9','2','C','U',']',
/* 0x125a1 = "WUSB54G v4 802.11g Adapter [Ralink RT2500USB]" */
    'W','U','S','B','5','4','G',' ','v','4',' ','\x94','\x02',' ','[','\x93','R','T','2','5','0','0','U','S','B',']',
/* 0x125bb = "SDDR-88 Imagemate 8-in-1 Reader" */
    'S','D','D','R','-','8','8',' ','I','m','a','g','e','m','a','t','e',' ','8','-','i','n','-','1',' ','\x08',
/* 0x125d5 = "at90usb AVR DFU bootloader" */
    'a','t','9','0','u','s','b',' ','A','V','R',' ','D','F','U',' ','b','o','o','t','l','o','a','d','e','r',
/* 0x125ef = "Flatron 915FT Plus Monitor" */
    'F','l','a','t','r','o','n',' ','9','1','5','F','T',' ','P','l','u','s',' ','M','o','n','i','t','o','r',
/* 0x12609 = "C-370Z/C-500Z/D-535Z/X-450" */
    'C','-','3','7','0','Z','/','C','-','5','0','0','Z','/','D','-','5','3','5','Z','/','X','-','4','5','0',
/* 0x12623 = "Mouse Scanner LSM-150 [LG Smart Scan Mouse]" */
    '\x0b',' ','\x25',' ','L','S','M','-','1','5','0',' ','[','L','G',' ','\x12',' ','\x8a',' ','M','o','u','s','e',']',
/* 0x1263d = "Samsung Opto-Electroncs Co., Ltd." */
    'S','a','m','s','u','n','g',' ','O','p','t','o','-','E','l','e','c','t','r','o','n','c','s',' ','\x0e','\xab',
/* 0x12657 = "Desire HD (Tethering Mode)" */
    'D','e','s','i','r','e',' ','H','D',' ','(','T','e','t','h','e','r','i','n','g',' ','M','o','d','e',')',
/* 0x12671 = "Global Village VideoFX Grabber" */
    'G','l','o','b','a','l',' ','V','i','l','l','a','g','e',' ','\xa3','F','X',' ','G','r','a','b','b','e','r',
/* 0x1268b = "F310 Gamepad [XInput Mode]" */
    'F','3','1','0',' ','G','a','m','e','p','a','d',' ','[','X','I','n','p','u','t',' ','M','o','d','e',']',
/* 0x126a5 = "raphnet.net Gamecube/N64 controller" */
    'r','a','p','h','n','e','t','.','n','e','t',' ','G','a','m','e','c','u','b','e','/','N','6','4',' ','\x9e',
/* 0x126bf = "Amazon Kindle Fire HD 8.9"" */
    'A','m','a','z','o','n',' ','K','i','n','d','l','e',' ','F','i','r','e',' ','H','D',' ','8','.','9','"',
/* 0x126d9 = "Datalux DLX-1611 16in1 Card Reader" */
    'D','a','t','a','l','u','x',' ','D','L','X','-','1','6','1','1',' ','1','6','i','n','1',' ','\x15',' ','\x08',
/* 0x126f3 = "Guitar Hero MIDI interface" */
    'G','u','i','t','a','r',' ','H','e','r','o',' ','M','I','D','I',' ','i','n','t','e','r','f','a','c','e',
/* 0x1270d = "RFC Distribution(s) PTE, Ltd" */
    'R','F','C',' ','D','i','s','t','r','i','b','u','t','i','o','n','(','s',')',' ','P','T','E',',',' ','\x16',
/* 0x12727 = "Ballracing Developments, Ltd" */
    'B','a','l','l','r','a','c','i','n','g',' ','D','e','v','e','l','o','p','m','e','n','t','s',',',' ','\x16',
/* 0x12741 = "ET-0405A [Graphire2 (4x5)]" */
    'E','T','-','0','4','0','5','A',' ','[','G','r','a','p','h','i','r','e','2',' ','(','4','x','5',')',']',
/* 0x1275b = "Elements Portable (WDBU6Y, WDBUZG)" */
    'E','l','e','m','e','n','t','s',' ','\xa9','(','W','D','B','U','6','Y',',',' ','W','D','B','U','Z','G',')',
/* 0x12775 = "Live! Cam Notebook Pro [VF0250]" */
    'L','i','v','e','!',' ','\x9a','N','o','t','e','b','o','o','k',' ','\x8f',' ','[','V','F','0','2','5','0',']',
/* 0x1278f = "USA-19QW PDA [no firmware]" */
    'U','S','A','-','1','9','Q','W',' ','P','D','A',' ','[','n','o',' ','f','i','r','m','w','a','r','e',']',
/* 0x127a9 = "Reiner SCT Kartensysteme GmbH" */
    'R','e','i','n','e','r',' ','S','C','T',' ','K','a','r','t','e','n','s','y','s','t','e','m','e',' ','\xfc',
/* 0x127c3 = "ProxMark-3 RFID Instrument" */
    'P','r','o','x','M','a','r','k','-','3',' ','R','F','I','D',' ','I','n','s','t','r','u','m','e','n','t',
/* 0x127dd = "DIGITAL STILL CAMERA 6M 4X" */
    'D','I','G','I','T','A','L',' ','S','T','I','L','L',' ','C','A','M','E','R','A',' ','6','M',' ','4','X',
/* 0x127f7 = "POS Printer (native mode), TH320" */
    'P','O','S',' ','\x0c',' ','(','n','a','t','i','v','e',' ','m','o','d','e',')',',',' ','T','H','3','2','0',
/* 0x12811 = "POS Printer (native mode), TH220" */
    'P','O','S',' ','\x0c',' ','(','n','a','t','i','v','e',' ','m','o','d','e',')',',',' ','T','H','2','2','0',
/* 0x1282b = "PTK-1240 [Intuos4 (12x19)]" */
    'P','T','K','-','1','2','4','0',' ','[','I','n','t','u','o','s','4',' ','(','1','2','x','1','9',')',']',
/* 0x12845 = "Groovy Technology Corp. GTouch Touch Screen" */
    'G','r','o','o','v','y',' ','\x0d',' ','\x10',' ','G','T','o','u','c','h',' ','\x9d',' ','S','c','r','e','e','n',
/* 0x1285f = "E90 Communicator (PC Suite mode)" */
    'E','9','0',' ','C','o','m','m','u','n','i','c','a','t','o','r',' ','(','\x1f','S','u','i','t','e',' ','\x1a',
/* 0x12879 = "Dimage A1 Camera [remote mode]" */
    'D','i','m','a','g','e',' ','A','1',' ','\x04',' ','[','r','e','m','o','t','e',' ','m','o','d','e',']',
/* 0x12892 = "Powershot ELPH 160 / IXUS 160" */
    'P','o','w','e','r','s','h','o','t',' ','E','L','P','H',' ','1','6','0',' ','/',' ','\xfd','1','6','0',
/* 0x128ab = "Observator Instruments BV" */
    'O','b','s','e','r','v','a','t','o','r',' ','I','n','s','t','r','u','m','e','n','t','s',' ','B','V',
/* 0x128c4 = "Curitel Communications, Inc." */
    'C','u','r','i','t','e','l',' ','C','o','m','m','u','n','i','c','a','t','i','o','n','s',',',' ','\x07',
/* 0x128dd = "Methode Electronics Far East PTE, Ltd" */
    'M','e','t','h','o','d','e',' ','\x1b',' ','F','a','r',' ','E','a','s','t',' ','P','T','E',',',' ','\x16',
/* 0x128f6 = "Ex-Series RNDIS and MSD interface" */
    'E','x','-','\xbf',' ','R','N','D','I','S',' ','\xe4','M','S','D',' ','i','n','t','e','r','f','a','c','e',
/* 0x1290f = "ADNS-5700 Optical Mouse Controller (5-button)" */
    'A','D','N','S','-','5','7','0','0',' ','\x7b','\x0b',' ','\x13',' ','(','5','-','b','u','t','t','o','n',')',
/* 0x12928 = "USB,4-Axis,16-Button with POV" */
    'U','S','B',',','4','-','A','x','i','s',',','1','6','-','B','u','t','t','o','n',' ','\x98','P','O','V',
/* 0x12941 = "D5503 (Xperia Z1 Compact)" */
    'D','5','5','0','3',' ','(','X','p','e','r','i','a',' ','Z','1',' ','C','o','m','p','a','c','t',')',
/* 0x1295a = "CTE-440 [Graphire4 (4x5)]" */
    'C','T','E','-','4','4','0',' ','[','G','r','a','p','h','i','r','e','4',' ','(','4','x','5',')',']',
/* 0x12973 = "SCR331-LC1 / SCR3310 SmartCard Reader" */
    'S','C','R','3','3','1','-','L','C','1',' ','/',' ','S','C','R','3','3','1','0',' ','\x12','\x15',' ','\x08',
/* 0x1298c = "Lottery Scanner, Xiscan S" */
    'L','o','t','t','e','r','y',' ','S','c','a','n','n','e','r',',',' ','X','i','s','c','a','n',' ','S',
/* 0x129a5 = "CTE-630 [Graphire3 (6x8)]" */
    'C','T','E','-','6','3','0',' ','[','G','r','a','p','h','i','r','e','3',' ','(','6','x','8',')',']',
/* 0x129be = "atmega32u4 DFU bootloader" */
    'a','t','m','e','g','a','3','2','u','4',' ','D','F','U',' ','b','o','o','t','l','o','a','d','e','r',
/* 0x129d7 = "atmega32u2 DFU bootloader" */
    'a','t','m','e','g','a','3','2','u','2',' ','D','F','U',' ','b','o','o','t','l','o','a','d','e','r',
/* 0x129f0 = "802UIG-1 802.11g Wireless Mini Adapter [Intersil ISL3887]" */
    '8','0','2','U','I','G','-','1',' ','\x94','\x01','\xb9',' ','\x02',' ','[','\xb0','I','S','L','3','8','8','7',']',
/* 0x12a09 = "U451 relay interface card" */
    'U','4','5','1',' ','r','e','l','a','y',' ','i','n','t','e','r','f','a','c','e',' ','c','a','r','d',
/* 0x12a22 = "Powershot ELPH 135 / IXUS 145" */
    'P','o','w','e','r','s','h','o','t',' ','E','L','P','H',' ','1','3','5',' ','/',' ','\xfd','1','4','5',
/* 0x12a3b = "Fritz!WLAN N v2 [Atheros AR9271]" */
    'F','r','i','t','z','!','W','L','A','N',' ','N',' ','v','2',' ','[','\xaf','A','R','9','2','7','1',']',
/* 0x12a54 = "MZ-DN430 Minidisc Walkman" */
    'M','Z','-','D','N','4','3','0',' ','M','i','n','i','d','i','s','c',' ','W','a','l','k','m','a','n',
/* 0x12a6d = "USB CP210x UART Bridge Controller [DW700]" */
    '\x0a',' ','C','P','2','1','0','x',' ','U','A','R','T',' ','\x9f',' ','\x13',' ','[','D','W','7','0','0',']',
/* 0x12a86 = "Lottery Scanner, Xiscan 3" */
    'L','o','t','t','e','r','y',' ','S','c','a','n','n','e','r',',',' ','X','i','s','c','a','n',' ','3',
/* 0x12a9f = "DTV-DVB UDTT 7047-USB 2.0 DVB-T Driver" */
    'D','T','V','-','D','V','B',' ','U','D','T','T',' ','7','0','4','7','-','\x0a',' ','\xc1','\xa7','T',' ','\xde',
/* 0x12ab8 = "MA111(v2) 802.11b Wireless [SIS SIS 162]" */
    'M','A','1','1','1','(','v','2',')',' ','\x9b','\x01','[','S','I','S',' ','S','I','S',' ','1','6','2',']',
/* 0x12ad1 = "Benito Programmer Project" */
    'B','e','n','i','t','o',' ','P','r','o','g','r','a','m','m','e','r',' ','P','r','o','j','e','c','t',
/* 0x12aea = "Elements Desktop (WDBAAU)" */
    'E','l','e','m','e','n','t','s',' ','D','e','s','k','t','o','p',' ','(','W','D','B','A','A','U',')',
/* 0x12b03 = "System Level Solutions, Inc." */
    'S','y','s','t','e','m',' ','L','e','v','e','l',' ','S','o','l','u','t','i','o','n','s',',',' ','\x07',
/* 0x12b1c = "TrueMobile 1300 802.11g Wireless Adapter [Intersil ISL3880]" */
    'T','r','u','e','\x96',' ','1','3','0','0',' ','\x94','\x01','\x02',' ','[','\xb0','I','S','L','3','8','8','0',']',
/* 0x12b35 = "Mass Storage (UISDMC10S & UISDMC11S)" */
    '\x7c','\x0f','(','U','I','S','D','M','C','1','0','S',' ','&',' ','U','I','S','D','M','C','1','1','S',')',
/* 0x12b4e = "XD-0608-U [Intuos2 (6x8)]" */
    'X','D','-','0','6','0','8','-','U',' ','[','I','n','t','u','o','s','2',' ','(','6','x','8',')',']',
/* 0x12b67 = "Bridge(I2C/SPI/UART/FIFO)" */
    'B','r','i','d','g','e','(','I','2','C','/','S','P','I','/','U','A','R','T','/','F','I','F','O',')',
/* 0x12b80 = "Inside Out Networks [hex]" */
    'I','n','s','i','d','e',' ','O','u','t',' ','N','e','t','w','o','r','k','s',' ','[','h','e','x',']',
/* 0x12b99 = "My Passport Essential SE (WDBGYS)" */
    'M','y',' ','\xd5','E','s','s','e','n','t','i','a','l',' ','S','E',' ','(','W','D','B','G','Y','S',')',
/* 0x12bb2 = "TCS1C EIM/Cypress Fingerprint sensor" */
    'T','C','S','1','C',' ','E','I','M','/','C','y','p','r','e','s','s',' ','\x92','s','e','n','s','o','r',
/* 0x12bcb = "WLI-UC-GNM2 Wireless LAN Adapter [Ralink RT3070]" */
    'W','L','I','-','U','C','-','G','N','M','2',' ','\x01','\xf3','\x02',' ','[','\x93','R','T','3','0','7','0',']',
/* 0x12be4 = "QuickCam Messenger Communicate" */
    '\xc7','a','m',' ','M','e','s','s','e','n','g','e','r',' ','C','o','m','m','u','n','i','c','a','t','e',
/* 0x12bfd = "Neptune ULS chipset flash" */
    'N','e','p','t','u','n','e',' ','U','L','S',' ','c','h','i','p','s','e','t',' ','f','l','a','s','h',
/* 0x12c16 = "BCM20702 Bluetooth 4.0 [ThinkPad]" */
    'B','C','M','2','0','7','0','2',' ','\x06',' ','4','.','0',' ','[','T','h','i','n','k','P','a','d',']',
/* 0x12c2f = "Integrated Intellectual Property, Inc." */
    '\x18','I','n','t','e','l','l','e','c','t','u','a','l',' ','P','r','o','p','e','r','t','y',',',' ','\x07',
/* 0x12c48 = "Take-it DSC Camera Device(536)" */
    'T','a','k','e','-','i','t',' ','D','S','C',' ','\x04',' ','D','e','v','i','c','e','(','5','3','6',')',
/* 0x12c61 = "Edirol UA-5 Sound Capture" */
    'E','d','i','r','o','l',' ','U','A','-','5',' ','S','o','u','n','d',' ','C','a','p','t','u','r','e',
/* 0x12c7a = "GW-USMini2N 802.11n Wireless Adapter [Ralink RT2870]" */
    'G','W','-','U','S','M','i','n','i','2','N',' ','\x99','\x01','\x02',' ','[','\x93','R','T','2','8','7','0',']',
/* 0x12c93 = "WNDA4100 802.11abgn 3x3:3 [Ralink RT3573]" */
    'W','N','D','A','4','1','0','0',' ','\xea','3','x','3',':','3',' ','[','\x93','R','T','3','5','7','3',']',
/* 0x12cac = "Momo Force Steering Wheel" */
    'M','o','m','o',' ','F','o','r','c','e',' ','S','t','e','e','r','i','n','g',' ','W','h','e','e','l',
/* 0x12cc5 = "iPod Classic 3.Gen (WTF mode)" */
    'i','P','o','d',' ','C','l','a','s','s','i','c',' ','3','.','G','e','n',' ','(','W','T','F',' ','\x1a',
/* 0x12cde = "Programmable power socket" */
    'P','r','o','g','r','a','m','m','a','b','l','e',' ','p','o','w','e','r',' ','s','o','c','k','e','t',
/* 0x12cf7 = "Medianix Semiconductor, Inc." */
    'M','e','d','i','a','n','i','x',' ','S','e','m','i','c','o','n','d','u','c','t','o','r',',',' ','\x07',
/* 0x12d10 = "Konami ParaParaParadise Controller" */
    'K','o','n','a','m','i',' ','P','a','r','a','P','a','r','a','P','a','r','a','d','i','s','e',' ','\x13',
/* 0x12d29 = "at90usb162 DFU bootloader" */
    'a','t','9','0','u','s','b','1','6','2',' ','D','F','U',' ','b','o','o','t','l','o','a','d','e','r',
/* 0x12d42 = "NEC infrontia Corp. (Nitsuko)" */
    'N','E','C',' ','i','n','f','r','o','n','t','i','a',' ','\x10',' ','(','N','i','t','s','u','k','o',')',
/* 0x12d5b = "PCM2706C stereo audio DAC" */
    'P','C','M','2','7','0','6','C',' ','s','t','e','r','e','o',' ','a','u','d','i','o',' ','D','A','C',
/* 0x12d74 = "ASM1051 SATA 3Gb/s bridge" */
    'A','S','M','1','0','5','1',' ','S','A','T','A',' ','3','G','b','/','s',' ','b','r','i','d','g','e',
/* 0x12d8d = "Wireless Desktop nRF24L01 CX-1766" */
    '\x01','D','e','s','k','t','o','p',' ','n','R','F','2','4','L','0','1',' ','C','X','-','1','7','6','6',
/* 0x12da6 = "Jawbone Jambox - Updating" */
    'J','a','w','b','o','n','e',' ','J','a','m','b','o','x',' ','-',' ','U','p','d','a','t','i','n','g',
/* 0x12dbf = "2 GB 2 Go Video MP3 Player [MP601-2G]" */
    '2',' ','G','B',' ','2',' ','G','o',' ','\xa3',' ','\x8e','\x1e',' ','[','M','P','6','0','1','-','2','G',']',
/* 0x12dd8 = "Apple Mobile Device [Recovery Mode]" */
    'A','p','p','l','e',' ','\x96',' ','\x03',' ','[','R','e','c','o','v','e','r','y',' ','M','o','d','e',']',
/* 0x12df1 = "PlayStation Move motion controller" */
    'P','l','a','y','S','t','a','t','i','o','n',' ','M','o','v','e',' ','m','o','t','i','o','n',' ','\x9e',
/* 0x12e0a = "ANYCOM Blue USB-UHE 200/250" */
    'A','N','Y','C','O','M',' ','B','l','u','e',' ','\x0a','-','U','H','E',' ','2','0','0','/','2','5','0',
/* 0x12e23 = "Camedia E-10/C-220/C-50 Camera" */
    'C','a','m','e','d','i','a',' ','E','-','1','0','/','C','-','2','2','0','/','C','-','5','0',' ','\x04',
/* 0x12e3c = "AnyPoint\u00ae  3240 Modem - WAN" */
    'A','n','y','P','o','i','n','t','\xff','\xc2','\xae',' ',' ','3','2','4','0',' ','\x1c',' ','-',' ','W','A','N',
/* 0x12e55 = "Zoran Microelectronics, Ltd" */
    'Z','o','r','a','n',' ','M','i','c','r','o','e','l','e','c','t','r','o','n','i','c','s',',',' ','\x16',
/* 0x12e6e = "3-in-1 (SD/SDHC/SDXC) Card Reader" */
    '3','-','i','n','-','1',' ','(','S','D','/','S','D','H','C','/','S','D','X','C',')',' ','\x15',' ','\x08',
/* 0x12e87 = "UPort 1610-16 16-Port RS-232" */
    'U','P','o','r','t',' ','1','6','1','0','-','1','6',' ','1','6','-','\x87',' ','R','S','-','2','3','2',
/* 0x12ea0 = "Sigma Koki Co., Ltd, Technology Center" */
    'S','i','g','m','a',' ','K','o','k','i',' ','\x0e','L','t','d',',',' ','\x0d',' ','C','e','n','t','e','r',
/* 0x12eb9 = "HID-based serial adapater" */
    'H','I','D','-','b','a','s','e','d',' ','s','e','r','i','a','l',' ','a','d','a','p','a','t','e','r',
/* 0x12ed2 = "F5U258 Host to Host cable" */
    'F','5','U','2','5','8',' ','H','o','s','t',' ','t','o',' ','H','o','s','t',' ','c','a','b','l','e',
/* 0x12eeb = "Onza Tournament Edition controller" */
    'O','n','z','a',' ','T','o','u','r','n','a','m','e','n','t',' ','E','d','i','t','i','o','n',' ','\x9e',
/* 0x12f04 = "4800-2xx Hub w/ Cash Drawer" */
    '4','8','0','0','-','2','x','x',' ','\xa4',' ','w','/',' ','C','a','s','h',' ','D','r','a','w','e','r',
/* 0x12f1d = "Batoh Device / PlayStation 3 Controller" */
    'B','a','t','o','h',' ','\x03',' ','/',' ','P','l','a','y','S','t','a','t','i','o','n',' ','3',' ','\x13',
/* 0x12f36 = "Arduino Explora (CDC ACM)" */
    'A','r','d','u','i','n','o',' ','E','x','p','l','o','r','a',' ','(','C','D','C',' ','A','C','M',')',
/* 0x12f4f = "CDC RS-232 Emulation Demo" */
    'C','D','C',' ','R','S','-','2','3','2',' ','E','m','u','l','a','t','i','o','n',' ','D','e','m','o',
/* 0x12f68 = "Touchmonitor Interface 2600 Rev 2" */
    'T','o','u','c','h','m','o','n','i','t','o','r',' ','\x81',' ','2','6','0','0',' ','R','e','v',' ','2',
/* 0x12f81 = "MC380Z/A [Magic Trackpad]" */
    'M','C','3','8','0','Z','/','A',' ','[','M','a','g','i','c',' ','T','r','a','c','k','p','a','d',']',
/* 0x12f9a = "Creative Webcam Vista [VF0010]" */
    'C','r','e','a','t','i','v','e',' ','\x11',' ','V','i','s','t','a',' ','[','V','F','0','0','1','0',']',
/* 0x12fb3 = "33210A Waveform Generator" */
    '3','3','2','1','0','A',' ','W','a','v','e','f','o','r','m',' ','G','e','n','e','r','a','t','o','r',
/* 0x12fcc = "C-Bus Pascal Automation Controller" */
    'C','-','B','u','s',' ','P','a','s','c','a','l',' ','A','u','t','o','m','a','t','i','o','n',' ','\x13',
/* 0x12fe5 = "WPN111 RangeMax(TM) Wireless USB 2.0 Adapter" */
    'W','P','N','1','1','1',' ','R','a','n','g','e','M','a','x','(','T','M',')',' ','\x01','\x0a',' ','\xc1','\x02',
/* 0x12ffe = "USB 2.0 Hub / D-Link DUB-H4 USB 2.0 Hub" */
    '\x0a',' ','\xc1','\xa4',' ','/',' ','D','-','L','i','n','k',' ','D','U','B','-','H','4',' ','\x0a',' ','\xc1','\xa4',
/* 0x13017 = "Optical Mouse WOP-35 / Trust 450L Optical Mouse" */
    '\x7b','\x0b',' ','W','O','P','-','3','5',' ','/',' ','T','r','u','s','t',' ','4','5','0','L',' ','\x7b','\x0b',
/* 0x13030 = "800dpi Optical Mouse w/ Scroll Point" */
    '8','0','0','d','p','i',' ','\x7b','\x0b',' ','w','/',' ','S','c','r','o','l','l',' ','P','o','i','n','t',
/* 0x13049 = "Hitachi Shin Din Cable, Ltd" */
    'H','i','t','a','c','h','i',' ','S','h','i','n',' ','D','i','n',' ','C','a','b','l','e',',',' ','\x16',
/* 0x13062 = "Vengeance K70RGB keyboard" */
    'V','e','n','g','e','a','n','c','e',' ','K','7','0','R','G','B',' ','k','e','y','b','o','a','r','d',
/* 0x1307b = "1-Motor PhidgetServo v3.0" */
    '1','-','M','o','t','o','r',' ','P','h','i','d','g','e','t','S','e','r','v','o',' ','v','3','.','0',
/* 0x13094 = "Eee Note EA800 (network mode)" */
    'E','e','e',' ','N','o','t','e',' ','E','A','8','0','0',' ','(','n','e','t','w','o','r','k',' ','\x1a',
/* 0x130ad = "WiQuest Communications, Inc." */
    'W','i','Q','u','e','s','t',' ','C','o','m','m','u','n','i','c','a','t','i','o','n','s',',',' ','\x07',
/* 0x130c6 = "Intel Play QX3 Microscope" */
    'I','n','t','e','l',' ','P','l','a','y',' ','Q','X','3',' ','M','i','c','r','o','s','c','o','p','e',
/* 0x130df = "Eumex 604PC HomeNet (FlashLoad)" */
    'E','u','m','e','x',' ','6','0','4','\x1f','H','o','m','e','N','e','t',' ','(','\x3c','L','o','a','d',')',
/* 0x130f8 = "My Book Pro Edition (WDG1T)" */
    'M','y',' ','B','o','o','k',' ','\x8f',' ','E','d','i','t','i','o','n',' ','(','W','D','G','1','T',')',
/* 0x13111 = "RZ01-0058 Gaming Mouse [Naga]" */
    'R','Z','0','1','-','0','0','5','8',' ','G','a','m','i','n','g',' ','\x0b',' ','[','N','a','g','a',']',
/* 0x1312a = "Elura 60E/Optura 40 (ptp)" */
    'E','l','u','r','a',' ','6','0','E','/','O','p','t','u','r','a',' ','4','0',' ','(','p','t','p',')',
/* 0x13143 = "Hub in Pro Keyboard [Mitsumi, A1048]" */
    '\xa4',' ','i','n',' ','\x8f',' ','\x05',' ','[','M','i','t','s','u','m','i',',',' ','A','1','0','4','8',']',
/* 0x1315c = "Cyborg Evo Force Joystick" */
    'C','y','b','o','r','g',' ','E','v','o',' ','F','o','r','c','e',' ','J','o','y','s','t','i','c','k',
/* 0x13175 = "P3200 Rumble Force Game Pad" */
    'P','3','2','0','0',' ','R','u','m','b','l','e',' ','F','o','r','c','e',' ','G','a','m','e',' ','\xfa',
/* 0x1318e = "Frontier Labs NEX IA+ Digital Audio Player" */
    'F','r','o','n','t','i','e','r',' ','L','a','b','s',' ','N','E','X',' ','I','A','+',' ','\x09','\x8b','\x1e',
/* 0x131a7 = "Planon System Solutions Inc." */
    'P','l','a','n','o','n',' ','S','y','s','t','e','m',' ','S','o','l','u','t','i','o','n','s',' ','\x07',
/* 0x131c0 = "VS-DVB-T 380U (af9015 based)" */
    'V','S','-','\xa7','T',' ','3','8','0','U',' ','(','a','f','9','0','1','5',' ','b','a','s','e','d',')',
/* 0x131d9 = "4-Motor PhidgetServo v3.0" */
    '4','-','M','o','t','o','r',' ','P','h','i','d','g','e','t','S','e','r','v','o',' ','v','3','.','0',
/* 0x131f2 = "V One Multimedia, Pte., Ltd" */
    'V',' ','O','n','e',' ','M','u','l','t','i','m','e','d','i','a',',',' ','P','t','e','.',',',' ','\x16',
/* 0x1320b = "PCM2707C stereo audio DAC" */
    'P','C','M','2','7','0','7','C',' ','s','t','e','r','e','o',' ','a','u','d','i','o',' ','D','A','C',
/* 0x13224 = "OCZ Alchemy Series Elixir II Keyboard" */
    'O','C','Z',' ','A','l','c','h','e','m','y',' ','\xbf',' ','E','l','i','x','i','r',' ','I','I',' ','\x05',
/* 0x1323d = "Matrix Orbital MX2 or MX3" */
    'M','a','t','r','i','x',' ','O','r','b','i','t','a','l',' ','M','X','2',' ','o','r',' ','M','X','3',
/* 0x13256 = "Fiberbyte USB-inSync DAQ-2500X" */
    'F','i','b','e','r','b','y','t','e',' ','\x0a','-','i','n','\x91',' ','D','A','Q','-','2','5','0','0','X',
/* 0x1326f = "atmega16u4 DFU bootloader" */
    'a','t','m','e','g','a','1','6','u','4',' ','D','F','U',' ','b','o','o','t','l','o','a','d','e','r',
/* 0x13288 = "Sophisticated Circuits, Inc." */
    'S','o','p','h','i','s','t','i','c','a','t','e','d',' ','C','i','r','c','u','i','t','s',',',' ','\x07',
/* 0x132a1 = "Kronauer music in digital" */
    'K','r','o','n','a','u','e','r',' ','m','u','s','i','c',' ','i','n',' ','d','i','g','i','t','a','l',
/* 0x132ba = "CHI SHING Computer Accessories Co., Ltd" */
    'C','H','I',' ','S','H','I','N','G',' ','\xcd','A','c','c','e','s','s','o','r','i','e','s',' ','\x0e','\x16',
/* 0x132d3 = "Digital Voice Recorder VN-8500PC" */
    '\x09','V','o','i','c','e',' ','R','e','c','o','r','d','e','r',' ','V','N','-','8','5','0','0','P','C',
/* 0x132ec = "LX-700 Cordless Desktop Receiver" */
    'L','X','-','7','0','0',' ','C','o','r','d','l','e','s','s',' ','D','e','s','k','t','o','p',' ','\x8c',
/* 0x13305 = "Test and Measurement Device (IVI)" */
    'T','e','s','t',' ','\xe4','M','e','a','s','u','r','e','m','e','n','t',' ','\x03',' ','(','I','V','I',')',
/* 0x1331e = "Bluetooth Headset Series 2 in DFU mode" */
    '\x06',' ','H','e','a','d','s','e','t',' ','\xbf',' ','2',' ','i','n',' ','D','F','U',' ','m','o','d','e',
/* 0x13337 = "SURFboard SBG1000 Gateway" */
    'S','U','R','F','b','o','a','r','d',' ','S','B','G','1','0','0','0',' ','G','a','t','e','w','a','y',
/* 0x13350 = "Harman/Kardon SoundSticks" */
    'H','a','r','m','a','n','/','K','a','r','d','o','n',' ','S','o','u','n','d','S','t','i','c','k','s',
/* 0x13369 = "DWL-AG122 (no firmware) [Atheros AR5523]" */
    'D','W','L','-','A','G','1','2','2',' ','(','n','o',' ','\xdb',' ','[','\xaf','A','R','5','5','2','3',']',
/* 0x13382 = "XD-0405-U [Intuos2 (4x5)]" */
    'X','D','-','0','4','0','5','-','U',' ','[','I','n','t','u','o','s','2',' ','(','4','x','5',')',']',
/* 0x1339b = "Mighty Mouse [Mitsumi, M1152]" */
    'M','i','g','h','t','y',' ','\x0b',' ','[','M','i','t','s','u','m','i',',',' ','M','1','1','5','2',']',
/* 0x133b4 = "EP-703A [Stylus Photo PX660 Series]" */
    'E','P','-','7','0','3','A',' ','[','\xb1','\x86',' ','P','X','6','6','0',' ','S','e','r','i','e','s',']',
/* 0x133cd = "LR802UA 802.11b Wireless Adapter [ALi M4301AU]" */
    'L','R','8','0','2','U','A',' ','\x9b','\x01','\x02',' ','[','A','L','i',' ','M','4','3','0','1','A','U',']',
/* 0x133e6 = "Siemens Electromechanical" */
    'S','i','e','m','e','n','s',' ','E','l','e','c','t','r','o','m','e','c','h','a','n','i','c','a','l',
/* 0x133ff = "uDART In-Circuit Debugger" */
    'u','D','A','R','T',' ','I','n','-','C','i','r','c','u','i','t',' ','D','e','b','u','g','g','e','r',
/* 0x13418 = "AudioLink plus 4x4 2.9.28" */
    'A','u','d','i','o','L','i','n','k',' ','p','l','u','s',' ','4','x','4',' ','2','.','9','.','2','8',
/* 0x13431 = "atmega16u2 DFU bootloader" */
    'a','t','m','e','g','a','1','6','u','2',' ','D','F','U',' ','b','o','o','t','l','o','a','d','e','r',
/* 0x1344a = "Hub (in 1905FP LCD Monitor)" */
    '\xa4',' ','(','i','n',' ','1','9','0','5','F','P',' ','L','C','D',' ','M','o','n','i','t','o','r',')',
/* 0x13463 = "HomeLink Phoneline 10M Network Adapter" */
    'H','o','m','e','L','i','n','k',' ','P','h','o','n','e','l','i','n','e',' ','1','0','M',' ','\x8d','\x02',
/* 0x1347c = "remote receive and control device" */
    'r','e','m','o','t','e',' ','r','e','c','e','i','v','e',' ','\xe4','c','o','n','t','r','o','l',' ','\xf9',
/* 0x13495 = "Gravis Eliminator GamePad Pro" */
    'G','r','a','v','i','s',' ','E','l','i','m','i','n','a','t','o','r',' ','G','a','m','e','\xfa',' ','\x8f',
/* 0x134ae = "Dimage XT Camera [remote mode]" */
    'D','i','m','a','g','e',' ','X','T',' ','\x04',' ','[','r','e','m','o','t','e',' ','m','o','d','e',']',
/* 0x134c7 = "T-Flight Hotas X Flight Stick" */
    'T','-','F','l','i','g','h','t',' ','H','o','t','a','s',' ','X',' ','F','l','i','g','h','t',' ','\xb3',
/* 0x134e0 = "KVM Human Interface Composite Device (Keyboard/Mouse ports)" */
    'K','V','M',' ','H','u','m','a','n',' ','\x81',' ','\x60','\x03',' ','(','\xc6','\x0b',' ','p','o','r','t','s',')',
/* 0x134f9 = "USB,4-Axis,12-Button with POV" */
    'U','S','B',',','4','-','A','x','i','s',',','1','2','-','B','u','t','t','o','n',' ','\x98','P','O','V',
/* 0x13512 = "MOTO Development Group, Inc." */
    'M','O','T','O',' ','D','e','v','e','l','o','p','m','e','n','t',' ','G','r','o','u','p',',',' ','\x07',
/* 0x1352b = "Ex-Series RNDIS and UVC interface" */
    'E','x','-','\xbf',' ','R','N','D','I','S',' ','\xe4','U','V','C',' ','i','n','t','e','r','f','a','c','e',
/* 0x13544 = "Hercules Dualpix Exchange" */
    'H','e','r','c','u','l','e','s',' ','D','u','a','l','p','i','x',' ','E','x','c','h','a','n','g','e',
/* 0x1355d = "Comjet Information System" */
    'C','o','m','j','e','t',' ','I','n','f','o','r','m','a','t','i','o','n',' ','S','y','s','t','e','m',
/* 0x13576 = "CanoScan N670U/N676U/LiDE 20" */
    'C','a','n','o','\x8a',' ','N','6','7','0','U','/','N','6','7','6','U','/','L','i','D','E',' ','2','0',
/* 0x1358f = "StarSign Bio Token 3.0 EU" */
    'S','t','a','r','S','i','g','n',' ','B','i','o',' ','T','o','k','e','n',' ','3','.','0',' ','E','U',
/* 0x135a8 = "Seismic recorder [Tellus]" */
    'S','e','i','s','m','i','c',' ','r','e','c','o','r','d','e','r',' ','[','T','e','l','l','u','s',']',
/* 0x135c1 = "V1456 VQE-R2 Modem [conexant]" */
    'V','1','4','5','6',' ','V','Q','E','-','R','2',' ','\x1c',' ','[','c','o','n','e','x','a','n','t',']',
/* 0x135da = "PlayStation 3 Memory Card Adaptor" */
    'P','l','a','y','S','t','a','t','i','o','n',' ','3',' ','\xd2',' ','\x15',' ','A','d','a','p','t','o','r',
/* 0x135f3 = "ben-wpan, AT86RF230-based" */
    'b','e','n','-','w','p','a','n',',',' ','A','T','8','6','R','F','2','3','0','-','b','a','s','e','d',
/* 0x1360c = "DIGIVOX mini III [af9015]" */
    'D','I','G','I','V','O','X',' ','m','i','n','i',' ','I','I','I',' ','[','a','f','9','0','1','5',']',
/* 0x13625 = "Arcadyan WN4501 802.11b/g" */
    'A','r','c','a','d','y','a','n',' ','W','N','4','5','0','1',' ','8','0','2','.','1','1','b','/','g',
/* 0x1363e = "Shimane SANYO Electric Co., Ltd." */
    'S','h','i','m','a','n','e',' ','S','A','N','Y','O',' ','E','l','e','c','t','r','i','c',' ','\x0e','\xab',
/* 0x13657 = "Live! Cam Socialize [VF0640]" */
    'L','i','v','e','!',' ','\x9a','S','o','c','i','a','l','i','z','e',' ','[','V','F','0','6','4','0',']',
/* 0x13670 = "United Microelectronics Corp." */
    'U','n','i','t','e','d',' ','M','i','c','r','o','e','l','e','c','t','r','o','n','i','c','s',' ','\x10',
/* 0x13689 = "Creative Modem Blaster DE5670" */
    'C','r','e','a','t','i','v','e',' ','\x1c',' ','B','l','a','s','t','e','r',' ','D','E','5','6','7','0',
/* 0x136a2 = "ProgramGyar AVR-IR Sender" */
    'P','r','o','g','r','a','m','G','y','a','r',' ','A','V','R','-','I','R',' ','S','e','n','d','e','r',
/* 0x136bb = "DSB-650TX-PNA Ethernet [pegasus]" */
    'D','S','B','-','6','5','0','T','X','-','P','N','A',' ','\x7f',' ','[','p','e','g','a','s','u','s',']',
/* 0x136d4 = "CTE-430 [Graphire3 (4x5)]" */
    'C','T','E','-','4','3','0',' ','[','G','r','a','p','h','i','r','e','3',' ','(','4','x','5',')',']',
/* 0x136ed = "Game Cube USB Memory Adaptor 64M" */
    'G','a','m','e',' ','C','u','b','e',' ','\x0a',' ','\xd2',' ','A','d','a','p','t','o','r',' ','6','4','M',
/* 0x13706 = "33220A Waveform Generator" */
    '3','3','2','2','0','A',' ','W','a','v','e','f','o','r','m',' ','G','e','n','e','r','a','t','o','r',
/* 0x1371f = "SRD0NF1 Expansion Portable (STEA)" */
    'S','R','D','0','N','F','1',' ','E','x','p','a','n','s','i','o','n',' ','\xa9','(','S','T','E','A',')',
/* 0x13738 = "MX3000 Cordless Desktop Receiver" */
    'M','X','3','0','0','0',' ','C','o','r','d','l','e','s','s',' ','D','e','s','k','t','o','p',' ','\x8c',
/* 0x13751 = "Exilim EX-H10 Digital Camera (PictBridge mode)" */
    'E','x','i','l','i','m',' ','E','X','-','H','1','0',' ','\x09','\x04',' ','(','P','i','c','t','\x9f',' ','\x1a',
/* 0x1376a = "Dynastream Innovations, Inc." */
    'D','y','n','a','s','t','r','e','a','m',' ','I','n','n','o','v','a','t','i','o','n','s',',',' ','\x07',
/* 0x13783 = "Grandtec USB1.1 DVB-T (warm)" */
    'G','r','a','n','d','t','e','c',' ','U','S','B','1','.','1',' ','\xa7','T',' ','(','w','a','r','m',')',
/* 0x1379c = "Fujitsu Siemens Computers" */
    'F','u','j','i','t','s','u',' ','S','i','e','m','e','n','s',' ','C','o','m','p','u','t','e','r','s',
/* 0x137b5 = "Pro Flight Instrument Panel" */
    '\x8f',' ','F','l','i','g','h','t',' ','I','n','s','t','r','u','m','e','n','t',' ','P','a','n','e','l',
/* 0x137ce = "Speedy Industrial Supplies, Pte., Ltd" */
    'S','p','e','e','d','y',' ','\xef','S','u','p','p','l','i','e','s',',',' ','P','t','e','.',',',' ','\x16',
/* 0x137e7 = "PL2303 Serial (IODATA USB-RSAQ2)" */
    'P','L','2','3','0','3',' ','\x90',' ','(','I','O','D','A','T','A',' ','\x0a','-','R','S','A','Q','2',')',
/* 0x13800 = "IDE/SATA Combo Adapter [CN-330]" */
    'I','D','E','/','S','A','T','A',' ','C','o','m','b','o',' ','\x02',' ','[','C','N','-','3','3','0',']',
/* 0x13819 = "FinePix NX-500/NX-700 printer" */
    '\xca','i','x',' ','N','X','-','5','0','0','/','N','X','-','7','0','0',' ','p','r','i','n','t','e','r',
/* 0x13832 = "Hualon Microelectronics Corp." */
    'H','u','a','l','o','n',' ','M','i','c','r','o','e','l','e','c','t','r','o','n','i','c','s',' ','\x10',
/* 0x1384b = "XHCI Root Hub USB 2.0 Simulation" */
    'X','H','C','I',' ','R','o','o','t',' ','\xa4',' ','\x0a',' ','\xc1','S','i','m','u','l','a','t','i','o','n',
/* 0x13864 = "F5U211 USB 2.0 15-in-1 Media Reader & Writer" */
    'F','5','U','2','1','1',' ','\x0a',' ','\xc1','1','5','-','i','n','-','1',' ','\xa1',' ','\x08',' ','&',' ','\xdf',
/* 0x1387d = "Mitsumi FA402M 8-in-2 Card Reader" */
    'M','i','t','s','u','m','i',' ','F','A','4','0','2','M',' ','8','-','i','n','-','2',' ','\x15',' ','\x08',
/* 0x13896 = "DWA-130 802.11n Wireless N Adapter(rev.B) [Ralink RT2870]" */
    'D','W','A','-','1','3','0',' ','\x99','\x01','N',' ','\xbb','B',')',' ','[','\x93','R','T','2','8','7','0',']',
/* 0x138af = "USB To keyboard/Mouse Converter" */
    '\x0a',' ','T','o',' ','k','e','y','b','o','a','r','d','/','\x0b',' ','C','o','n','v','e','r','t','e','r',
/* 0x138c8 = "Comfort Curve Keyboard 2000 V1.0" */
    'C','o','m','f','o','r','t',' ','C','u','r','v','e',' ','\x05',' ','2','0','0','0',' ','V','1','.','0',
/* 0x138e1 = "Veo Mobile/Advanced Web Camera" */
    'V','e','o',' ','M','o','b','i','l','e','/','A','d','v','a','n','c','e','d',' ','W','e','b',' ','\x04',
/* 0x138fa = "LUA-U2-GT 10/100/1000 Ethernet Adapter" */
    'L','U','A','-','U','2','-','G','T',' ','1','0','/','1','0','0','/','1','0','0','0',' ','\x7f',' ','\x02',
/* 0x13913 = "SafeNet USB SuperPro/UltraPro" */
    'S','a','f','e','N','e','t',' ','\x0a',' ','S','u','p','e','r','P','r','o','/','U','l','t','r','a','\x8f',
/* 0x1392c = "PCM2704C stereo audio DAC" */
    'P','C','M','2','7','0','4','C',' ','s','t','e','r','e','o',' ','a','u','d','i','o',' ','D','A','C',
/* 0x13945 = "SMCWUSBT-G2 802.11g Wireless Adapter [Atheros AR5523]" */
    'S','M','C','W','U','S','B','T','-','G','2',' ','\x94','\x01','\x02',' ','[','\xaf','A','R','5','5','2','3',']',
/* 0x1395e = "BLOB boot loader firmware" */
    'B','L','O','B',' ','b','o','o','t',' ','l','o','a','d','e','r',' ','f','i','r','m','w','a','r','e',
/* 0x13977 = "Philips Speech Processing" */
    'P','h','i','l','i','p','s',' ','S','p','e','e','c','h',' ','P','r','o','c','e','s','s','i','n','g',
/* 0x13990 = "Shinko/Sinfonia CHC-S2145" */
    'S','h','i','n','k','o','/','S','i','n','f','o','n','i','a',' ','C','H','C','-','S','2','1','4','5',
/* 0x139a9 = "pokey9000 Tiny Bit Dingus" */
    'p','o','k','e','y','9','0','0','0',' ','T','i','n','y',' ','B','i','t',' ','D','i','n','g','u','s',
/* 0x139c2 = "FAX4100e IntelliFax 4100e" */
    'F','A','X','4','1','0','0','e',' ','I','n','t','e','l','l','i','F','a','x',' ','4','1','0','0','e',
/* 0x139db = "PCTV 71e [Afatech AF9015]" */
    'P','C','T','V',' ','7','1','e',' ','[','A','f','a','t','e','c','h',' ','A','F','9','0','1','5',']',
/* 0x139f4 = "Banknote validator NV-150" */
    'B','a','n','k','n','o','t','e',' ','v','a','l','i','d','a','t','o','r',' ','N','V','-','1','5','0',
/* 0x13a0d = "ViewMate Desktop Mouse CC2201" */
    'V','i','e','w','M','a','t','e',' ','D','e','s','k','t','o','p',' ','\x0b',' ','C','C','2','2','0','1',
/* 0x13a26 = "ONDA COMMUNICATION S.p.a." */
    'O','N','D','A',' ','C','O','M','M','U','N','I','C','A','T','I','O','N',' ','S','.','p','.','a','.',
/* 0x13a3f = "Neptune LTX chipset flash" */
    'N','e','p','t','u','n','e',' ','L','T','X',' ','c','h','i','p','s','e','t',' ','f','l','a','s','h',
/* 0x13a58 = "PTZ-631W [Intuos3 (6x11)]" */
    'P','T','Z','-','6','3','1','W',' ','[','I','n','t','u','o','s','3',' ','(','6','x','1','1',')',']',
/* 0x13a71 = "Fuji Film Microdevices Co., Ltd" */
    'F','u','j','i',' ','F','i','l','m',' ','M','i','c','r','o','d','e','v','i','c','e','s',' ','\x0e','\x16',
/* 0x13a8a = "Grandtec USB1.1 DVB-T (cold)" */
    'G','r','a','n','d','t','e','c',' ','U','S','B','1','.','1',' ','\xa7','T',' ','(','c','o','l','d',')',
/* 0x13aa3 = "USB,5-Axis,10-Button with POV" */
    'U','S','B',',','5','-','A','x','i','s',',','1','0','-','B','u','t','t','o','n',' ','\x98','P','O','V',
/* 0x13abc = "Matrix Orbital MX4 or MX5" */
    'M','a','t','r','i','x',' ','O','r','b','i','t','a','l',' ','M','X','4',' ','o','r',' ','M','X','5',
/* 0x13ad5 = "C01U condenser microphone" */
    'C','0','1','U',' ','c','o','n','d','e','n','s','e','r',' ','m','i','c','r','o','p','h','o','n','e',
/* 0x13aee = "AKAI  Professional M.I. Corp." */
    'A','K','A','I',' ',' ','P','r','o','f','e','s','s','i','o','n','a','l',' ','M','.','I','.',' ','\x10',
/* 0x13b07 = "Neptune VLT chipset flash" */
    'N','e','p','t','u','n','e',' ','V','L','T',' ','c','h','i','p','s','e','t',' ','f','l','a','s','h',
/* 0x13b20 = "DAQPad-6020E (68 pin I/O)" */
    'D','A','Q','P','a','d','-','6','0','2','0','E',' ','(','6','8',' ','p','i','n',' ','I','/','O',')',
/* 0x13b39 = "SAC - Software Assigned Controller" */
    'S','A','C',' ','-',' ','S','o','f','t','w','a','r','e',' ','A','s','s','i','g','n','e','d',' ','\x13',
/* 0x13b52 = "USA-28X PDA [no firmware]" */
    'U','S','A','-','2','8','X',' ','P','D','A',' ','[','n','o',' ','f','i','r','m','w','a','r','e',']',
/* 0x13b6b = "TRUST Digital PCTV and Movie Editor" */
    'T','R','U','S','T',' ','\x09','P','C','T','V',' ','\xe4','M','o','v','i','e',' ','E','d','i','t','o','r',
/* 0x13b84 = "R700 Remote Presenter receiver" */
    'R','7','0','0',' ','\xcb',' ','P','r','e','s','e','n','t','e','r',' ','r','e','c','e','i','v','e','r',
/* 0x13b9d = "EDIROL UM-880 MIDI I/F (native)" */
    '\xf8','U','M','-','8','8','0',' ','M','I','D','I',' ','I','/','F',' ','(','n','a','t','i','v','e',')',
/* 0x13bb6 = "WUSB54GC v3 802.11g Adapter [Ralink RT2070L]" */
    'W','U','S','B','5','4','G','C',' ','v','3',' ','\x94','\x02',' ','[','\x93','R','T','2','0','7','0','L',']',
/* 0x13bcf = "Fastweb DRG A226M ADSL Router" */
    'F','a','s','t','w','e','b',' ','D','R','G',' ','A','2','2','6','M',' ','\xf1','R','o','u','t','e','r',
/* 0x13be8 = "SV-239 HammerHead Digital" */
    'S','V','-','2','3','9',' ','H','a','m','m','e','r','H','e','a','d',' ','D','i','g','i','t','a','l',
/* 0x13c01 = "SERI E02 SCOM 6200 UMTS Phone" */
    'S','E','R','I',' ','E','0','2',' ','S','C','O','M',' ','6','2','0','0',' ','U','M','T','S',' ','\x19',
/* 0x13c1a = "Visioneer Onetouch 8920 Scanner" */
    'V','i','s','i','o','n','e','e','r',' ','O','n','e','t','o','u','c','h',' ','8','9','2','0',' ','\x25',
/* 0x13c33 = "USA-19W PDA [no firmware]" */
    'U','S','A','-','1','9','W',' ','P','D','A',' ','[','n','o',' ','f','i','r','m','w','a','r','e',']',
/* 0x13c4c = "Teensy Halfkay Bootloader" */
    'T','e','e','n','s','y',' ','H','a','l','f','k','a','y',' ','B','o','o','t','l','o','a','d','e','r',
/* 0x13c65 = "WLI-U2-AMG54HP Bootloader" */
    'W','L','I','-','U','2','-','A','M','G','5','4','H','P',' ','B','o','o','t','l','o','a','d','e','r',
/* 0x13c7e = "RTL8192DU 802.11an WLAN Adapter" */
    'R','T','L','8','1','9','2','D','U',' ','8','0','2','.','1','1','a','n',' ','W','L','A','N',' ','\x02',
/* 0x13c97 = "WL-329 Wireless Dualband USB adapter 300N" */
    'W','L','-','3','2','9',' ','\x01','D','u','a','l','b','a','n','d',' ','\x0a',' ','\xd0',' ','3','0','0','N',
/* 0x13cb0 = "Seagate Branded Solutions" */
    'S','e','a','g','a','t','e',' ','B','r','a','n','d','e','d',' ','S','o','l','u','t','i','o','n','s',
/* 0x13cc9 = "Patriot 1.0 (GSM) chipset" */
    'P','a','t','r','i','o','t',' ','1','.','0',' ','(','G','S','M',')',' ','c','h','i','p','s','e','t',
/* 0x13ce2 = "Neptune LTE chipset flash" */
    'N','e','p','t','u','n','e',' ','L','T','E',' ','c','h','i','p','s','e','t',' ','f','l','a','s','h',
/* 0x13cfb = "DWL-AG132 (no firmware) [Atheros AR5523]" */
    'D','W','L','-','A','G','1','3','2',' ','(','n','o',' ','\xdb',' ','[','\xaf','A','R','5','5','2','3',']',
/* 0x13d14 = "Super Coolscan LS-5000 ED" */
    'S','u','p','e','r',' ','C','o','o','l','s','c','a','n',' ','L','S','-','5','0','0','0',' ','E','D',
/* 0x13d2d = "remote key/mouse for P3 chip" */
    'r','e','m','o','t','e',' ','k','e','y','/','m','o','u','s','e',' ','\xcc','P','3',' ','c','h','i','p',
/* 0x13d46 = "HP Port Replicator (Composite Device)" */
    'H','P',' ','\x87',' ','R','e','p','l','i','c','a','t','o','r',' ','(','\x60','D','e','v','i','c','e',')',
/* 0x13d5f = "Action Star Enterprise Co., Ltd" */
    'A','c','t','i','o','n',' ','S','t','a','r',' ','E','n','t','e','r','p','r','i','s','e',' ','\x0e','\x16',
/* 0x13d78 = "PS1001/1011/1006/1026 Flash Disk" */
    'P','S','1','0','0','1','/','1','0','1','1','/','1','0','0','6','/','1','0','2','6',' ','\x3c',' ','\xe8',
/* 0x13d91 = "Gigaset 3075 Passive ISDN" */
    'G','i','g','a','s','e','t',' ','3','0','7','5',' ','P','a','s','s','i','v','e',' ','I','S','D','N',
/* 0x13daa = "Farallon Home Phoneline Adapter" */
    'F','a','r','a','l','l','o','n',' ','H','o','m','e',' ','P','h','o','n','e','l','i','n','e',' ','\x02',
/* 0x13dc3 = "FinalKey password manager" */
    'F','i','n','a','l','K','e','y',' ','p','a','s','s','w','o','r','d',' ','m','a','n','a','g','e','r',
/* 0x13ddc = "GlobeTrotter 3G+ datacard" */
    'G','l','o','b','e','T','r','o','t','t','e','r',' ','3','G','+',' ','d','a','t','a','c','a','r','d',
/* 0x13df5 = "Mediao 802.11n WLAN [Realtek RTL8191SU]" */
    'M','e','d','i','a','o',' ','\x99','W','L','A','N',' ','[','\xbe','R','T','L','8','1','9','1','S','U',']',
/* 0x13e0e = "Premium Optical Wheel Mouse (M-BT58)" */
    'P','r','e','m','i','u','m',' ','\x7b','W','h','e','e','l',' ','\x0b',' ','(','M','-','B','T','5','8',')',
/* 0x13e27 = "Ca508A HP1020 Camera v.1.3.1.6" */
    'C','a','5','0','8','A',' ','H','P','1','0','2','0',' ','\x04',' ','v','.','1','.','3','.','1','.','6',
/* 0x13e40 = "Elements Desktop (WDBWLG)" */
    'E','l','e','m','e','n','t','s',' ','D','e','s','k','t','o','p',' ','(','W','D','B','W','L','G',')',
/* 0x13e59 = "6303 classic Phone (Printing and media mode)" */
    '6','3','0','3',' ','c','l','a','s','s','i','c',' ','\x19',' ','(','\xf5','\xe4','m','e','d','i','a',' ','\x1a',
/* 0x13e72 = "Sangoma Wanpipe VoiceTime" */
    'S','a','n','g','o','m','a',' ','W','a','n','p','i','p','e',' ','V','o','i','c','e','T','i','m','e',
/* 0x13e8b = "ASM2115 SATA 6Gb/s bridge" */
    'A','S','M','2','1','1','5',' ','S','A','T','A',' ','6','G','b','/','s',' ','b','r','i','d','g','e',
/* 0x13ea4 = "USB,4-Axis,14-Button with POV" */
    'U','S','B',',','4','-','A','x','i','s',',','1','4','-','B','u','t','t','o','n',' ','\x98','P','O','V',
/* 0X13ebd = "VoIP Conference Hub (A16GH)" */
    'o','I','P',' ','C','o','n','f','e','r','e','n','c','e',' ','\xa4',' ','(','A','1','6','G','H',')',
/* 0x13ed5 = "Arduino Robot Control (CDC ACM)" */
    'A','r','d','u','i','n','o',' ','R','o','b','o','t',' ','\xc9',' ','(','C','D','C',' ','A','C','M',')',
/* 0x13eee = "uLinks USOTL4 RS422/485 Adapter" */
    'u','L','i','n','k','s',' ','U','S','O','T','L','4',' ','R','S','4','2','2','/','4','8','5',' ','\x02',
/* 0x13f07 = "TI-89 Titanium Calculator" */
    'T','I','-','8','9',' ','T','i','t','a','n','i','u','m',' ','C','a','l','c','u','l','a','t','o','r',
/* 0x13f20 = "Eumex 604PC HomeNet [FlashLoad]" */
    'E','u','m','e','x',' ','6','0','4','\x1f','H','o','m','e','N','e','t',' ','[','\x3c','L','o','a','d',']',
/* 0x13f39 = "SDCZ2 Cruzer Mini Flash Drive (thin)" */
    'S','D','C','Z','2',' ','C','r','u','z','e','r',' ','\xb9',' ','\x3c',' ','\x14',' ','(','t','h','i','n',')',
/* 0x13f52 = "Cable Television Laboratories" */
    '\xa5',' ','T','e','l','e','v','i','s','i','o','n',' ','L','a','b','o','r','a','t','o','r','i','e','s',
/* 0x13f6b = "ILX Lightwave Corporation" */
    'I','L','X',' ','L','i','g','h','t','w','a','v','e',' ','C','o','r','p','o','r','a','t','i','o','n',
/* 0x13f84 = "Neptune LTS chipset flash" */
    'N','e','p','t','u','n','e',' ','L','T','S',' ','c','h','i','p','s','e','t',' ','f','l','a','s','h',
/* 0x13f9d = "BCM92046DG-CL1ROM Bluetooth 2.1 Adapter" */
    'B','C','M','9','2','0','4','6','D','G','-','C','L','1','R','O','M',' ','\x06',' ','2','.','1',' ','\x02',
/* 0x13fb6 = "DFU-Enabled Devices (DFU)" */
    'D','F','U','-','E','n','a','b','l','e','d',' ','D','e','v','i','c','e','s',' ','(','D','F','U',')',
/* 0x13fcf = "ASM1053 SATA 6Gb/s bridge" */
    'A','S','M','1','0','5','3',' ','S','A','T','A',' ','6','G','b','/','s',' ','b','r','i','d','g','e',
/* 0x13fe8 = "NV-GS11/230/250 (webcam mode)" */
    'N','V','-','G','S','1','1','/','2','3','0','/','2','5','0',' ','(','w','e','b','c','a','m',' ','\x1a',
/* 0x14001 = "CTE-640 [Graphire4 (6x8)]" */
    'C','T','E','-','6','4','0',' ','[','G','r','a','p','h','i','r','e','4',' ','(','6','x','8',')',']',
/* 0x1401a = "ADNS-5700 Optical Mouse Controller (3-button)" */
    'A','D','N','S','-','5','7','0','0',' ','\x7b','\x0b',' ','\x13',' ','(','3','-','b','u','t','t','o','n',')',
/* 0x14033 = "USA-18X PDA [no firmware]" */
    'U','S','A','-','1','8','X',' ','P','D','A',' ','[','n','o',' ','f','i','r','m','w','a','r','e',']',
/* 0x1404c = "Trust PowerC@m 770Z (webcam mode)" */
    'T','r','u','s','t',' ','\x24','C','@','m',' ','7','7','0','Z',' ','(','w','e','b','c','a','m',' ','\x1a',
/* 0x14065 = "WUSB54GP v1 802.11g Adapter [Intersil ISL3886]" */
    'W','U','S','B','5','4','G','P',' ','v','1',' ','\x94','\x02',' ','[','\xb0','I','S','L','3','8','8','6',']',
/* 0x1407e = "Z-Star Microelectronics Corp." */
    'Z','-','S','t','a','r',' ','M','i','c','r','o','e','l','e','c','t','r','o','n','i','c','s',' ','\x10',
/* 0x14097 = "SDDR-75 ImageMate CF-SM Reader" */
    'S','D','D','R','-','7','5',' ','I','m','a','g','e','M','a','t','e',' ','C','F','-','S','M',' ','\x08',
/* 0x140b0 = "BAFO/Quality Computer Accessories" */
    'B','A','F','O','/','Q','u','a','l','i','t','y',' ','\xcd','A','c','c','e','s','s','o','r','i','e','s',
/* 0x140c9 = "USB,4-Axis,10-Button with POV" */
    'U','S','B',',','4','-','A','x','i','s',',','1','0','-','B','u','t','t','o','n',' ','\x98','P','O','V',
/* 0x140e2 = "raphnet.net Intellivision" */
    'r','a','p','h','n','e','t','.','n','e','t',' ','I','n','t','e','l','l','i','v','i','s','i','o','n',
/* 0x140fb = "N10 Nano 802.11n Network Adapter [Realtek RTL8192CU]" */
    'N','1','0',' ','N','a','n','o',' ','\x99','\x8d','\x02',' ','[','\xbe','R','T','L','8','1','9','2','C','U',']',
/* 0x14114 = "LUFA CDC Class Bootloader" */
    'L','U','F','A',' ','C','D','C',' ','C','l','a','s','s',' ','B','o','o','t','l','o','a','d','e','r',
/* 0x1412d = "PCM2705C stereo audio DAC" */
    'P','C','M','2','7','0','5','C',' ','s','t','e','r','e','o',' ','a','u','d','i','o',' ','D','A','C',
/* 0x14146 = "Internal Keyboard/Trackpad (MacBook Pro 4,1) (ANSI)" */
    '\xb4','\xc6','\xf6','(','M','a','c','B','o','o','k',' ','\x8f',' ','4',',','1',')',' ','(','A','N','S','I',')',
/* 0x1415f = "PM-A840S [Stylus Photo RX595/RX610]" */
    'P','M','-','A','8','4','0','S',' ','[','\xb1','\x86',' ','R','X','5','9','5','/','R','X','6','1','0',']',
/* 0x14178 = "LUFA CDC Demo Application" */
    'L','U','F','A',' ','C','D','C',' ','D','e','m','o',' ','A','p','p','l','i','c','a','t','i','o','n',
/* 0x14191 = "Xperia X10 mini (USB debug)" */
    'X','p','e','r','i','a',' ','X','1','0',' ','m','i','n','i',' ','(','\x0a',' ','d','e','b','u','g',')',
/* 0x141aa = "PX1396E-3T01 External hard drive" */
    'P','X','1','3','9','6','E','-','3','T','0','1',' ','\xe3','h','a','r','d',' ','d','r','i','v','e',
/* 0x141c2 = "WUSB54G v2 802.11g Adapter [Intersil ISL3887]" */
    'W','U','S','B','5','4','G',' ','v','2',' ','\x94','\x02',' ','[','\xb0','I','S','L','3','8','8','7',']',
/* 0x141da = "InnoVISION Multimedia, Ltd" */
    'I','n','n','o','V','I','S','I','O','N',' ','M','u','l','t','i','m','e','d','i','a',',',' ','\x16',
/* 0x141f2 = "AnMo Electronics Corp. / Dino-Lite (?)" */
    'A','n','M','o',' ','\x1b',' ','\x10',' ','/',' ','D','i','n','o','-','L','i','t','e',' ','(','?',')',
/* 0x1420a = "TrueMobile 1180 802.11b Adapter [Intersil PRISM 3]" */
    'T','r','u','e','\x96',' ','1','1','8','0',' ','\x9b','\x02',' ','[','\xb0','P','R','I','S','M',' ','3',']',
/* 0x14222 = "Advanced Gravis Computer Tech, Ltd" */
    'A','d','v','a','n','c','e','d',' ','G','r','a','v','i','s',' ','\xcd','T','e','c','h',',',' ','\x16',
/* 0x1423a = "RTL2832 [WinFast DTV Dongle Mini]" */
    'R','T','L','2','8','3','2',' ','[','W','i','n','\xec','D','T','V',' ','\xf4',' ','M','i','n','i',']',
/* 0x14252 = "Micolink USB2Ethernet [pegasus]" */
    'M','i','c','o','l','i','n','k',' ','U','S','B','2','\x7f',' ','[','p','e','g','a','s','u','s',']',
/* 0x1426a = "802UI3(B) 802.11b Wireless Adapter [Intersil PRISM 3]" */
    '8','0','2','U','I','3','(','B',')',' ','\x9b','\x01','\x02',' ','[','\xb0','P','R','I','S','M',' ','3',']',
/* 0x14282 = "AN2131 uninitialized (?)" */
    'A','N','2','1','3','1',' ','u','n','i','n','i','t','i','a','l','i','z','e','d',' ','(','?',')',
/* 0x1429a = "Electronics Testing Center, Taiwan" */
    '\x1b',' ','T','e','s','t','i','n','g',' ','C','e','n','t','e','r',',',' ','T','a','i','w','a','n',
/* 0x142b2 = "PCM2706 stereo audio DAC" */
    'P','C','M','2','7','0','6',' ','s','t','e','r','e','o',' ','a','u','d','i','o',' ','D','A','C',
/* 0x142ca = "1456 VQE-R3 Modem [conexant]" */
    '1','4','5','6',' ','V','Q','E','-','R','3',' ','\x1c',' ','[','c','o','n','e','x','a','n','t',']',
/* 0x142e2 = "WLI-USB-G54 802.11g Adapter [Broadcom 4320 USB]" */
    'W','L','I','-','\x0a','-','G','5','4',' ','\x94','\x02',' ','[','\xeb','4','3','2','0',' ','U','S','B',']',
/* 0x142fa = "MZ-N710 Minidisc Walkman" */
    'M','Z','-','N','7','1','0',' ','M','i','n','i','d','i','s','c',' ','W','a','l','k','m','a','n',
/* 0x14312 = "Turbo TrackMan Marble FX" */
    'T','u','r','b','o',' ','T','r','a','c','k','M','a','n',' ','M','a','r','b','l','e',' ','F','X',
/* 0x1432a = "DigitalDream l\'espion XS" */
    'D','i','g','i','t','a','l','D','r','e','a','m',' ','l','\'','e','s','p','i','o','n',' ','X','S',
/* 0x14342 = "Handyscope HS4-DIFF (br)" */
    'H','a','n','d','y','s','c','o','p','e',' ','H','S','4','-','D','I','F','F',' ','(','b','r',')',
/* 0x1435a = "Sony Gobi 2000 Wireless Modem (QDL mode)" */
    'S','o','n','y',' ','G','o','b','i',' ','2','0','0','0',' ','\x01','\x1c',' ','(','Q','D','L',' ','\x1a',
/* 0x14372 = "WUSB54G v1 802.11g Adapter [Intersil ISL3886]" */
    'W','U','S','B','5','4','G',' ','v','1',' ','\x94','\x02',' ','[','\xb0','I','S','L','3','8','8','6',']',
/* 0x1438a = "Handmade GSM GPS tracker" */
    'H','a','n','d','m','a','d','e',' ','G','S','M',' ','G','P','S',' ','t','r','a','c','k','e','r',
/* 0x143a2 = "Kingston FCR-HS2/ATA Card Reader" */
    'K','i','n','g','s','t','o','n',' ','F','C','R','-','H','S','2','/','A','T','A',' ','\x15',' ','\x08',
/* 0x143ba = "K5150 LTE modem (Mass Storage Mode)" */
    'K','5','1','5','0',' ','L','T','E',' ','m','o','d','e','m',' ','(','\x7c','\x0f','M','o','d','e',')',
/* 0x143d2 = "MX Revolution Cordless Mouse" */
    'M','X',' ','R','e','v','o','l','u','t','i','o','n',' ','C','o','r','d','l','e','s','s',' ','\x0b',
/* 0x143ea = "WLI-U2-KAMG54 Bootloader" */
    'W','L','I','-','U','2','-','K','A','M','G','5','4',' ','B','o','o','t','l','o','a','d','e','r',
/* 0x14402 = "PTH-451 [Intuos pro (S)]" */
    'P','T','H','-','4','5','1',' ','[','I','n','t','u','o','s',' ','p','r','o',' ','(','S',')',']',
/* 0x1441a = "PTH-651 [Intuos pro (M)]" */
    'P','T','H','-','6','5','1',' ','[','I','n','t','u','o','s',' ','p','r','o',' ','(','M',')',']',
/* 0x14432 = "Plug and Jack Industrial, Inc." */
    'P','l','u','g',' ','\xe4','J','a','c','k',' ','I','n','d','u','s','t','r','i','a','l',',',' ','\x07',
/* 0x1444a = "TrackIR 4 Pro Head Tracker" */
    'T','r','a','c','k','I','R',' ','4',' ','\x8f',' ','H','e','a','d',' ','T','r','a','c','k','e','r',
/* 0x14462 = "Winmate Communication, Inc." */
    'W','i','n','m','a','t','e',' ','C','o','m','m','u','n','i','c','a','t','i','o','n',',',' ','\x07',
/* 0x1447a = "Inventio Software MSP430" */
    'I','n','v','e','n','t','i','o',' ','S','o','f','t','w','a','r','e',' ','M','S','P','4','3','0',
/* 0x14492 = "Personal Digital Assistant P6M+" */
    'P','e','r','s','o','n','a','l',' ','\x09','A','s','s','i','s','t','a','n','t',' ','P','6','M','+',
/* 0x144aa = "Digital Voice Recorder & Camera W-10" */
    '\x09','V','o','i','c','e',' ','R','e','c','o','r','d','e','r',' ','&',' ','\x04',' ','W','-','1','0',
/* 0x144c2 = "DWL-120 WIRELESS ADAPTER" */
    'D','W','L','-','1','2','0',' ','W','I','R','E','L','E','S','S',' ','A','D','A','P','T','E','R',
/* 0x144da = "802.11n/b/g Mini Wireless LAN USB2.0 Adapter" */
    '8','0','2','.','1','1','n','/','b','/','g',' ','\xb9',' ','\x01','\xf3','U','S','B','2','.','0',' ','\x02',
/* 0x144f2 = "FaceTime HD Camera (Built-in)" */
    'F','a','c','e','T','i','m','e',' ','H','D',' ','\x04',' ','(','B','u','i','l','t','-','i','n',')',
/* 0x1450a = "Yubikey NEO(-N) U2F+CCID" */
    'Y','u','b','i','k','e','y',' ','N','E','O','(','-','N',')',' ','U','2','F','+','C','C','I','D',
/* 0x14522 = "Ming Fortune Industry Co., Ltd" */
    'M','i','n','g',' ','F','o','r','t','u','n','e',' ','I','n','d','u','s','t','r','y',' ','\x0e','\x16',
/* 0x1453a = "PT-2300/2310 p-Touch Laber Printer" */
    'P','T','-','2','3','0','0','/','2','3','1','0',' ','p','-','\x9d',' ','L','a','b','e','r',' ','\x0c',
/* 0x14552 = "Tactrix OpenPort 1.3 Subaru" */
    'T','a','c','t','r','i','x',' ','O','p','e','n','\x87',' ','1','.','3',' ','S','u','b','a','r','u',
/* 0x1456a = "Oki Electric Industry Co., Ltd" */
    'O','k','i',' ','E','l','e','c','t','r','i','c',' ','I','n','d','u','s','t','r','y',' ','\x0e','\x16',
/* 0x14582 = "PowerShot ELPH 510 HS / IXUS 1100 HS" */
    '\x24','\x84','E','L','P','H',' ','5','1','0',' ','H','S',' ','/',' ','\xfd','1','1','0','0',' ','H','S',
/* 0x1459a = "Planex Communications, Inc." */
    'P','l','a','n','e','x',' ','C','o','m','m','u','n','i','c','a','t','i','o','n','s',',',' ','\x07',
/* 0x145b2 = "Diva 2.01 S/T [PSB2115F]" */
    'D','i','v','a',' ','2','.','0','1',' ','S','/','T',' ','[','P','S','B','2','1','1','5','F',']',
/* 0x145ca = "FlashGate ME (Authenticated)" */
    '\x3c','G','a','t','e',' ','M','E',' ','(','A','u','t','h','e','n','t','i','c','a','t','e','d',')',
/* 0x145e2 = "D2CIM-VUSB KVM connector" */
    'D','2','C','I','M','-','V','U','S','B',' ','K','V','M',' ','c','o','n','n','e','c','t','o','r',
/* 0x145fa = "DVBSky T680C DVB-T2/C tuner" */
    'D','V','B','S','k','y',' ','T','6','8','0','C',' ','\xa7','T','2','/','C',' ','t','u','n','e','r',
/* 0x14612 = "Data Card Programmer (install)" */
    '\xe7',' ','\x15',' ','P','r','o','g','r','a','m','m','e','r',' ','(','i','n','s','t','a','l','l',')',
/* 0x1462a = "DWL-G132 (no firmware) [Atheros AR5523]" */
    'D','W','L','-','G','1','3','2',' ','(','n','o',' ','\xdb',' ','[','\xaf','A','R','5','5','2','3',']',
/* 0x14642 = "LX710 Cordless Desktop Laser" */
    'L','X','7','1','0',' ','C','o','r','d','l','e','s','s',' ','D','e','s','k','t','o','p',' ','\x82',
/* 0x1465a = "Speed-Link Competition Pro" */
    'S','p','e','e','d','-','L','i','n','k',' ','C','o','m','p','e','t','i','t','i','o','n',' ','\x8f',
/* 0x14672 = "G502 Proteus Spectrum Optical Mouse" */
    'G','5','0','2',' ','P','r','o','t','e','u','s',' ','S','p','e','c','t','r','u','m',' ','\x7b','\x0b',
/* 0x1468a = "LW153 802.11n Adapter [ralink rt3070]" */
    'L','W','1','5','3',' ','\x99','\x02',' ','[','r','a','l','i','n','k',' ','r','t','3','0','7','0',']',
/* 0x146a2 = "U.S. Robotics USR5426 802.11g Adapter" */
    'U','.','S','.',' ','R','o','b','o','t','i','c','s',' ','U','S','R','5','4','2','6',' ','\x94','\x02',
/* 0x146ba = "ACR38 AC1038-based Smart Card Reader" */
    'A','C','R','3','8',' ','A','C','1','0','3','8','-','b','a','s','e','d',' ','\x12',' ','\x15',' ','\x08',
/* 0x146d2 = "Thermo Fisher Scientific" */
    'T','h','e','r','m','o',' ','F','i','s','h','e','r',' ','S','c','i','e','n','t','i','f','i','c',
/* 0x146ea = "Neptune LT chipset flash" */
    'N','e','p','t','u','n','e',' ','L','T',' ','c','h','i','p','s','e','t',' ','f','l','a','s','h',
/* 0x14702 = "CC-570L [Stylus CX3100/CX3200]" */
    'C','C','-','5','7','0','L',' ','[','\xb1','C','X','3','1','0','0','/','C','X','3','2','0','0',']',
/* 0x1471a = "Wired Keyboard 600 (model 1576)" */
    'W','i','r','e','d',' ','\x05',' ','6','0','0',' ','(','m','o','d','e','l',' ','1','5','7','6',')',
/* 0x14732 = "Asus Gobi 2000 Wireless Modem (QDL mode)" */
    'A','s','u','s',' ','G','o','b','i',' ','2','0','0','0',' ','\x01','\x1c',' ','(','Q','D','L',' ','\x1a',
/* 0x1474a = "PCM2705 stereo audio DAC" */
    'P','C','M','2','7','0','5',' ','s','t','e','r','e','o',' ','a','u','d','i','o',' ','D','A','C',
/* 0x14762 = "Dura Micro, Inc. (Acomdata)" */
    'D','u','r','a',' ','M','i','c','r','o',',',' ','\x07',' ','(','A','c','o','m','d','a','t','a',')',
/* 0x1477a = "AK5370 I/F A/D Converter" */
    'A','K','5','3','7','0',' ','I','/','F',' ','A','/','D',' ','C','o','n','v','e','r','t','e','r',
/* 0x14792 = "XIOSynth [First Edition]" */
    'X','I','O','S','y','n','t','h',' ','[','F','i','r','s','t',' ','E','d','i','t','i','o','n',']',
/* 0x147aa = "GameBoy Advance Flash Gang Writer" */
    'G','a','m','e','B','o','y',' ','A','d','v','a','n','c','e',' ','\x3c',' ','G','a','n','g',' ','\xdf',
/* 0x147c2 = "Marvell Semiconductor, Inc." */
    'M','a','r','v','e','l','l',' ','S','e','m','i','c','o','n','d','u','c','t','o','r',',',' ','\x07',
/* 0x147da = "DWA-110 Wireless G Adapter(rev.B) [Ralink RT2870]" */
    'D','W','A','-','1','1','0',' ','\x01','G',' ','\xbb','B',')',' ','[','\x93','R','T','2','8','7','0',']',
/* 0x147f2 = "TrackIR 3 Pro Head Tracker" */
    'T','r','a','c','k','I','R',' ','3',' ','\x8f',' ','H','e','a','d',' ','T','r','a','c','k','e','r',
/* 0x1480a = "LifeChat LX-6000 Headset" */
    'L','i','f','e','C','h','a','t',' ','L','X','-','6','0','0','0',' ','H','e','a','d','s','e','t',
/* 0x14822 = "Space Shuttle Hi-Tech Co., Ltd" */
    'S','p','a','c','e',' ','S','h','u','t','t','l','e',' ','H','i','-','T','e','c','h',' ','\x0e','\x16',
/* 0x1483a = "Beagle Protocol Analyzer" */
    'B','e','a','g','l','e',' ','P','r','o','t','o','c','o','l',' ','A','n','a','l','y','z','e','r',
/* 0x14852 = "E-861 PiezoWalk NEXACT Controller" */
    'E','-','8','6','1',' ','P','i','e','z','o','W','a','l','k',' ','N','E','X','A','C','T',' ','\x13',
/* 0x1486a = "SURFboard SBG950 Gateway" */
    'S','U','R','F','b','o','a','r','d',' ','S','B','G','9','5','0',' ','G','a','t','e','w','a','y',
/* 0x14882 = "PTU-600 [Cintiq Partner]" */
    'P','T','U','-','6','0','0',' ','[','C','i','n','t','i','q',' ','P','a','r','t','n','e','r',']',
/* 0x1489a = "Tat Shing Electrical Co." */
    'T','a','t',' ','S','h','i','n','g',' ','E','l','e','c','t','r','i','c','a','l',' ','C','o','.',
/* 0x148b2 = "Dual Receiver Wireless Mouse (IntelliPoint)" */
    'D','u','a','l',' ','\x8c',' ','\x01','\x0b',' ','(','I','n','t','e','l','l','i','P','o','i','n','t',')',
/* 0x148ca = "USA-28 PDA [no firmware]" */
    'U','S','A','-','2','8',' ','P','D','A',' ','[','n','o',' ','f','i','r','m','w','a','r','e',']',
/* 0x148e2 = "PM-A870 [Stylus Photo RX620/RX630]" */
    'P','M','-','A','8','7','0',' ','[','\xb1','\x86',' ','R','X','6','2','0','/','R','X','6','3','0',']',
/* 0x148fa = "Framatome Connectors USA" */
    'F','r','a','m','a','t','o','m','e',' ','C','o','n','n','e','c','t','o','r','s',' ','U','S','A',
/* 0x14912 = "VTPlayer VTP-1 Braille Mouse" */
    'V','T','P','l','a','y','e','r',' ','V','T','P','-','1',' ','B','r','a','i','l','l','e',' ','\x0b',
/* 0x1492a = "Vosonic X\'s-Drive II+ VP2160" */
    'V','o','s','o','n','i','c',' ','X','\'','s','-','\x14',' ','I','I','+',' ','V','P','2','1','6','0',
/* 0x14942 = "VKI-B Fingerprint Sensor/Flash Storage (smart)" */
    'V','K','I','-','B',' ','\x92','S','e','n','s','o','r','/','\x3c',' ','\x0f','(','s','m','a','r','t',')',
/* 0x1495a = "Vimicro generic vc0321 Camera" */
    'V','i','m','i','c','r','o',' ','g','e','n','e','r','i','c',' ','v','c','0','3','2','1',' ','\x04',
/* 0x14972 = "Network Computing Devices (NCD)" */
    '\x8d','C','o','m','p','u','t','i','n','g',' ','D','e','v','i','c','e','s',' ','(','N','C','D',')',
/* 0x1498a = "Elster Unicom III Optical Probe" */
    'E','l','s','t','e','r',' ','U','n','i','c','o','m',' ','I','I','I',' ','\x7b','P','r','o','b','e',
/* 0x149a2 = "YFC-BonEagle Electric Co., Ltd" */
    'Y','F','C','-','B','o','n','E','a','g','l','e',' ','E','l','e','c','t','r','i','c',' ','\x0e','\x16',
/* 0x149ba = "CG-WLUSB2GNR Corega Wireless USB Adapter" */
    'C','G','-','W','L','U','S','B','2','G','N','R',' ','C','o','r','e','g','a',' ','\x01','\x0a',' ','\x02',
/* 0x149d2 = "Mainsuper Enterprises Co., Ltd" */
    'M','a','i','n','s','u','p','e','r',' ','E','n','t','e','r','p','r','i','s','e','s',' ','\x0e','\x16',
/* 0x149ea = "WUSB54GSC v2 802.11g Adapter [Broadcom 4326U]" */
    'W','U','S','B','5','4','G','S','C',' ','v','2',' ','\x94','\x02',' ','[','\xeb','4','3','2','6','U',']',
/* 0x14a02 = "WinTV MiniCard [Dell Digital TV Receiver]" */
    'W','i','n','\xda','\xb9','\x15',' ','[','D','e','l','l',' ','\x09','\xda','R','e','c','e','i','v','e','r',']',
/* 0x14a1a = "PCM2707 stereo audio DAC" */
    'P','C','M','2','7','0','7',' ','s','t','e','r','e','o',' ','a','u','d','i','o',' ','D','A','C',
/* 0x14a32 = "Optic Film 7200i scanner" */
    'O','p','t','i','c',' ','F','i','l','m',' ','7','2','0','0','i',' ','s','c','a','n','n','e','r',
/* 0x14a4a = "2-N-1 7-Port Hub (Upper half)" */
    '2','-','N','-','1',' ','7','-','\x87',' ','\xa4',' ','(','U','p','p','e','r',' ','h','a','l','f',')',
/* 0x14a62 = "UMTS-TDD (TD-CDMA) modem" */
    'U','M','T','S','-','T','D','D',' ','(','T','D','-','C','D','M','A',')',' ','m','o','d','e','m',
/* 0x14a7a = "(ZD1211)IEEE 802.11b+g Adapter" */
    '(','Z','D','1','2','1','1',')','I','E','E','E',' ','8','0','2','.','1','1','b','+','g',' ','\x02',
/* 0x14a92 = "Plug Computer Basic [SheevaPlug]" */
    'P','l','u','g',' ','\xcd','B','a','s','i','c',' ','[','S','h','e','e','v','a','P','l','u','g',']',
/* 0x14aaa = "Samsung SemiConductor, Inc." */
    'S','a','m','s','u','n','g',' ','S','e','m','i','C','o','n','d','u','c','t','o','r',',',' ','\x07',
/* 0x14ac2 = "Davicom Semiconductor, Inc." */
    'D','a','v','i','c','o','m',' ','S','e','m','i','c','o','n','d','u','c','t','o','r',',',' ','\x07',
/* 0x14ada = "TRUST AUDIO VIDEO EDITOR" */
    'T','R','U','S','T',' ','A','U','D','I','O',' ','V','I','D','E','O',' ','E','D','I','T','O','R',
/* 0x14af2 = "CM8060 Color MFP with Edgeline Technology" */
    'C','M','8','0','6','0',' ','\xa2',' ','M','F','P',' ','\x98','E','d','g','e','l','i','n','e',' ','\x0d',
/* 0x14b0a = "Keen Top International Enterprise Co., Ltd" */
    'K','e','e','n',' ','T','o','p',' ','\x9c',' ','E','n','t','e','r','p','r','i','s','e',' ','\x0e','\x16',
/* 0x14b22 = "Teleprompter Foot Control (v1)" */
    'T','e','l','e','p','r','o','m','p','t','e','r',' ','F','o','o','t',' ','\xc9',' ','(','v','1',')',
/* 0x14b3a = "SIIG US2256 CompactFlash Card Reader" */
    'S','I','I','G',' ','U','S','2','2','5','6',' ','C','o','m','p','a','c','t','\x3c',' ','\x15',' ','\x08',
/* 0x14b52 = "Arowana Optical Wheel Mouse MSOP-01" */
    'A','r','o','w','a','n','a',' ','\x7b','W','h','e','e','l',' ','\x0b',' ','M','S','O','P','-','0','1',
/* 0x14b6a = "E-Mail Optical Wheel Mouse (OMS3CE)" */
    'E','-','M','a','i','l',' ','\x7b','W','h','e','e','l',' ','\x0b',' ','(','O','M','S','3','C','E',')',
/* 0x14b82 = "M262x/M282x Xpress Series Laser Printer" */
    'M','2','6','2','x','/','M','2','8','2','x',' ','X','p','r','e','s','s',' ','\xbf',' ','\x82',' ','\x0c',
/* 0x14b9a = "2-N-1 7-Port Hub (Lower half)" */
    '2','-','N','-','1',' ','7','-','\x87',' ','\xa4',' ','(','L','o','w','e','r',' ','h','a','l','f',')',
/* 0x14bb2 = "MC3090 Rugged Mobile Computer" */
    'M','C','3','0','9','0',' ','R','u','g','g','e','d',' ','\x96',' ','C','o','m','p','u','t','e','r',
/* 0x14bca = "TPaq21/MPaq21 Datalogger" */
    'T','P','a','q','2','1','/','M','P','a','q','2','1',' ','D','a','t','a','l','o','g','g','e','r',
/* 0x14be2 = "PX1220E-1G25 External hard drive" */
    'P','X','1','2','2','0','E','-','1','G','2','5',' ','\xe3','h','a','r','d',' ','d','r','i','v','e',
/* 0x14bfa = "SlimBlade Media Notebook Set" */
    'S','l','i','m','B','l','a','d','e',' ','\xa1',' ','N','o','t','e','b','o','o','k',' ','S','e','t',
/* 0x14c12 = "Webcam SPC 6000 NC (Webcam w/ mic)" */
    '\x11',' ','S','P','C',' ','6','0','0','0',' ','N','C',' ','(','\x11',' ','w','/',' ','m','i','c',')',
/* 0x14c2a = "CC2400EB 2.0 ZigBee Sniffer" */
    'C','C','2','4','0','0','E','B',' ','\xc1','Z','i','g','B','e','e',' ','S','n','i','f','f','e','r',
/* 0X14c42 = "raphnet.net SNES mouse adapter" */
    'a','p','h','n','e','t','.','n','e','t',' ','S','N','E','S',' ','m','o','u','s','e',' ','\xd0',
/* 0x14c59 = "3DM-GX3-25 Orientation Sensor" */
    '3','D','M','-','G','X','3','-','2','5',' ','O','r','i','e','n','t','a','t','i','o','n',' ','\xac',
/* 0x14c71 = "Bodatong Technology (Shenzhen) Co., Ltd." */
    'B','o','d','a','t','o','n','g',' ','\x0d',' ','(','S','h','e','n','z','h','e','n',')',' ','\x0e','\xab',
/* 0x14c89 = "Optimus Android Phone (Charge Mode)" */
    'O','p','t','i','m','u','s',' ','\xce','\x19',' ','(','C','h','a','r','g','e',' ','M','o','d','e',')',
/* 0x14ca1 = "Lenovo ThinkCentre Web Camera" */
    'L','e','n','o','v','o',' ','T','h','i','n','k','C','e','n','t','r','e',' ','W','e','b',' ','\x04',
/* 0x14cb9 = "Dong Guan Shinko Wire Co., Ltd" */
    'D','o','n','g',' ','G','u','a','n',' ','S','h','i','n','k','o',' ','W','i','r','e',' ','\x0e','\x16',
/* 0x14cd1 = "WingMan Formula Force GP" */
    'W','i','n','g','M','a','n',' ','F','o','r','m','u','l','a',' ','F','o','r','c','e',' ','G','P',
/* 0x14ce9 = "Live! Cam Notebook [VF0470]" */
    'L','i','v','e','!',' ','\x9a','N','o','t','e','b','o','o','k',' ','[','V','F','0','4','7','0',']',
/* 0x14d01 = "Internal Keyboard/Trackpad (MacBook Pro 4,1) (JIS)" */
    '\xb4','\xc6','\xf6','(','M','a','c','B','o','o','k',' ','\x8f',' ','4',',','1',')',' ','(','J','I','S',')',
/* 0x14d19 = "Talon integrated chipset" */
    'T','a','l','o','n',' ','i','n','t','e','g','r','a','t','e','d',' ','c','h','i','p','s','e','t',
/* 0x14d31 = "China Resource Semico Co., Ltd" */
    'C','h','i','n','a',' ','R','e','s','o','u','r','c','e',' ','S','e','m','i','c','o',' ','\x0e','\x16',
/* 0x14d49 = "Filter Driver For JAE XMC R/W" */
    'F','i','l','t','e','r',' ','\xde',' ','F','o','r',' ','J','A','E',' ','X','M','C',' ','R','/','W',
/* 0x14d61 = "Yubikey NEO(-N) OTP+CCID" */
    'Y','u','b','i','k','e','y',' ','N','E','O','(','-','N',')',' ','O','T','P','+','C','C','I','D',
/* 0x14d79 = "atmega8u2 DFU bootloader" */
    'a','t','m','e','g','a','8','u','2',' ','D','F','U',' ','b','o','o','t','l','o','a','d','e','r',
/* 0x14d91 = "GlobeTrotter 3G datacard" */
    'G','l','o','b','e','T','r','o','t','t','e','r',' ','3','G',' ','d','a','t','a','c','a','r','d',
/* 0x14da9 = "OVU1020 IR Dongle (Kbd+Mouse)" */
    'O','V','U','1','0','2','0',' ','I','R',' ','\xf4',' ','(','K','b','d','+','M','o','u','s','e',')',
/* 0x14dc1 = "PM-A890 [Stylus Photo RX640/RX650]" */
    'P','M','-','A','8','9','0',' ','[','\xb1','\x86',' ','R','X','6','4','0','/','R','X','6','5','0',']',
/* 0x14dd9 = "MC521A mini Card ATSC Tuner" */
    'M','C','5','2','1','A',' ','m','i','n','i',' ','\x15',' ','A','T','S','C',' ','T','u','n','e','r',
/* 0x14df1 = "Hauppauge WinTV-USB (PAL) with FM radio" */
    '\xfb','W','i','n','T','V','-','\x0a',' ','(','P','A','L',')',' ','\x98','F','M',' ','r','a','d','i','o',
/* 0x14e09 = "JMS551 SATA 3Gb/s bridge" */
    'J','M','S','5','5','1',' ','S','A','T','A',' ','3','G','b','/','s',' ','b','r','i','d','g','e',
/* 0x14e21 = "Suunto Sports Instrument" */
    'S','u','u','n','t','o',' ','S','p','o','r','t','s',' ','I','n','s','t','r','u','m','e','n','t',
/* 0x14e39 = "AVerTV PVR USB/EZMaker Pro Device" */
    'A','V','e','r','\xda','P','V','R',' ','U','S','B','/','E','Z','M','a','k','e','r',' ','\x8f',' ','\x03',
/* 0x14e51 = "Capetronic (Kaohsiung) Corp." */
    'C','a','p','e','t','r','o','n','i','c',' ','(','K','a','o','h','s','i','u','n','g',')',' ','\x10',
/* 0x14e69 = "HCF V.90 Data,Fax,RTAD Modem" */
    'H','C','F',' ','V','.','9','0',' ','D','a','t','a',',','F','a','x',',','R','T','A','D',' ','\x1c',
/* 0x14e81 = "Open Bench Logic Sniffer" */
    'O','p','e','n',' ','B','e','n','c','h',' ','L','o','g','i','c',' ','S','n','i','f','f','e','r',
/* 0x14e99 = "DVD Creation Station 200" */
    'D','V','D',' ','C','r','e','a','t','i','o','n',' ','S','t','a','t','i','o','n',' ','2','0','0',
/* 0x14eb1 = "PM-A750 [Stylus Photo RX520/RX530]" */
    'P','M','-','A','7','5','0',' ','[','\xb1','\x86',' ','R','X','5','2','0','/','R','X','5','3','0',']',
/* 0x14ec9 = "JMS566 SATA 3Gb/s bridge" */
    'J','M','S','5','6','6',' ','S','A','T','A',' ','3','G','b','/','s',' ','b','r','i','d','g','e',
/* 0x14ee1 = "SoundBlaster Audigy 2 NX" */
    'S','o','u','n','d','B','l','a','s','t','e','r',' ','A','u','d','i','g','y',' ','2',' ','N','X',
/* 0x14ef9 = "28Cxxx EEPROM Programmer" */
    '2','8','C','x','x','x',' ','E','E','P','R','O','M',' ','P','r','o','g','r','a','m','m','e','r',
/* 0x14f11 = "Osmocom SIMtrace 2 (DFU)" */
    'O','s','m','o','c','o','m',' ','S','I','M','t','r','a','c','e',' ','2',' ','(','D','F','U',')',
/* 0x14f29 = "Internal Keyboard/Trackpad (MacBook Pro 4,1) (ISO)" */
    '\xb4','\xc6','\xf6','(','M','a','c','B','o','o','k',' ','\x8f',' ','4',',','1',')',' ','(','I','S','O',')',
/* 0x14f41 = "G2CCD-S with Sony ICX285 CCD" */
    'G','2','C','C','D','-','S',' ','\x98','S','o','n','y',' ','I','C','X','2','8','5',' ','C','C','D',
/* 0x14f59 = "PIXMA MP270 All-In-One Printer" */
    'P','I','X','M','A',' ','M','P','2','7','0',' ','A','l','l','-','I','n','-','O','n','e',' ','\x0c',
/* 0x14f71 = "LU150 LTE Modem [Yota LU150]" */
    'L','U','1','5','0',' ','L','T','E',' ','\x1c',' ','[','Y','o','t','a',' ','L','U','1','5','0',']',
/* 0x14f89 = "ALPINE ELECTRONICS, INC." */
    'A','L','P','I','N','E',' ','E','L','E','C','T','R','O','N','I','C','S',',',' ','I','N','C','.',
/* 0x14fa1 = "WiseGroup SuperJoy Box 5" */
    'W','i','s','e','G','r','o','u','p',' ','S','u','p','e','r','J','o','y',' ','B','o','x',' ','5',
/* 0x14fb9 = "Operator Display, BA66-USB" */
    'O','p','e','r','a','t','o','r',' ','D','i','s','p','l','a','y',',',' ','B','A','6','6','-','\x0a',
/* 0x14fd1 = "Optio 50 (mass storage mode)" */
    'O','p','t','i','o',' ','5','0',' ','(','m','a','s','s',' ','s','t','o','r','a','g','e',' ','\x1a',
/* 0x14fe9 = "DWL-120 802.11b Wireless Adapter(rev.F) [Intersil ISL3871]" */
    'D','W','L','-','1','2','0',' ','\x9b','\x01','\xbb','F',')',' ','[','\xb0','I','S','L','3','8','7','1',']',
/* 0x15001 = "COMpact 2104 (Rev.2 PBX)" */
    'C','O','M','p','a','c','t',' ','2','1','0','4',' ','(','R','e','v','.','2',' ','P','B','X',')',
/* 0x15019 = "PTH-851 [Intuos pro (L)]" */
    'P','T','H','-','8','5','1',' ','[','I','n','t','u','o','s',' ','p','r','o',' ','(','L',')',']',
/* 0x15031 = "Eee Note EA800 (tablet mode)" */
    'E','e','e',' ','N','o','t','e',' ','E','A','8','0','0',' ','(','t','a','b','l','e','t',' ','\x1a',
/* 0x15049 = "Pro-Image Manufacturing Co., Ltd" */
    '\x8f','-','I','m','a','g','e',' ','M','a','n','u','f','a','c','t','u','r','i','n','g',' ','\x0e','\x16',
/* 0x15061 = "Gearway Electronics (Dong Guan) Co., Ltd." */
    'G','e','a','r','w','a','y',' ','\x1b',' ','(','D','o','n','g',' ','G','u','a','n',')',' ','\x0e','\xab',
/* 0x15079 = "eHealth Terminal ST 1503" */
    'e','H','e','a','l','t','h',' ','T','e','r','m','i','n','a','l',' ','S','T',' ','1','5','0','3',
/* 0x15091 = "Kingston DataTraveler ELITE" */
    'K','i','n','g','s','t','o','n',' ','\xe7','T','r','a','v','e','l','e','r',' ','E','L','I','T','E',
/* 0x150a9 = "Typhoon Stream Optical Mouse USB+PS/2" */
    'T','y','p','h','o','o','n',' ','S','t','r','e','a','m',' ','\x7b','\x0b',' ','\x0a','+','P','S','/','2',
/* 0x150c1 = "Gamecube/N64 controller v2.9 (Keyboard mode)" */
    'G','a','m','e','c','u','b','e','/','N','6','4',' ','\x9e',' ','v','2','.','9',' ','(','\x05',' ','\x1a',
/* 0x150d9 = "USB-Serial Controller [Icom Inc. OPC-478UC]" */
    '\x0a','-','\x90',' ','\x13',' ','[','I','c','o','m',' ','\x07',' ','O','P','C','-','4','7','8','U','C',']',
/* 0x150f1 = "WL-167G v2 802.11g Adapter [Ralink RT2571W]" */
    'W','L','-','1','6','7','G',' ','v','2',' ','\x94','\x02',' ','[','\x93','R','T','2','5','7','1','W',']',
/* 0x15109 = "S90XS Keyboard/Music Synthesizer" */
    'S','9','0','X','S',' ','\xc6','M','u','s','i','c',' ','S','y','n','t','h','e','s','i','z','e','r',
/* 0x15121 = "G2/Optimus Android Phone [MTP mode]" */
    'G','2','/','O','p','t','i','m','u','s',' ','\xce','\x19',' ','[','M','T','P',' ','m','o','d','e',']',
/* 0x15139 = "Pak Heng Technology (Shenzhen) Co., Ltd." */
    'P','a','k',' ','H','e','n','g',' ','\x0d',' ','(','S','h','e','n','z','h','e','n',')',' ','\x0e','\xab',
/* 0x15151 = "TUSB3410 Microcontroller" */
    'T','U','S','B','3','4','1','0',' ','M','i','c','r','o','c','o','n','t','r','o','l','l','e','r',
/* 0x15169 = "PC Camera (SN9C201 + OV7670ISP)" */
    '\x1f','\x04',' ','(','S','N','9','C','2','0','1',' ','+',' ','O','V','7','6','7','0','I','S','P',')',
/* 0x15181 = "ViewSonic 1.3M, USB2.0 Webcam" */
    'V','i','e','w','S','o','n','i','c',' ','1','.','3','M',',',' ','U','S','B','2','.','0',' ','\x11',
/* 0x15199 = "SBIG Astronomy Camera (with firmware)" */
    'S','B','I','G',' ','A','s','t','r','o','n','o','m','y',' ','\x04',' ','(','w','i','t','h',' ','\xdb',
/* 0x151b1 = "GD-1218 [Intuos (12x18)]" */
    'G','D','-','1','2','1','8',' ','[','I','n','t','u','o','s',' ','(','1','2','x','1','8',')',']',
/* 0x151c9 = "F1DF102U/F1DG102U Flip Hub" */
    'F','1','D','F','1','0','2','U','/','F','1','D','G','1','0','2','U',' ','F','l','i','p',' ','\xa4',
/* 0x151e1 = "Transcend Information, Inc." */
    'T','r','a','n','s','c','e','n','d',' ','I','n','f','o','r','m','a','t','i','o','n',',',' ','\x07',
/* 0x151f9 = "TV Wonder, Edition (NTSC+)" */
    '\xda','W','o','n','d','e','r',',',' ','E','d','i','t','i','o','n',' ','(','N','T','S','C','+',')',
/* 0x15211 = "leadtek USBVision (1006)" */
    'l','e','a','d','t','e','k',' ','U','S','B','V','i','s','i','o','n',' ','(','1','0','0','6',')',
/* 0x15229 = "Droid/Milestone (Debug mode)" */
    'D','r','o','i','d','/','M','i','l','e','s','t','o','n','e',' ','(','D','e','b','u','g',' ','\x1a',
/* 0x15241 = "USA-19 PDA [no firmware]" */
    'U','S','A','-','1','9',' ','P','D','A',' ','[','n','o',' ','f','i','r','m','w','a','r','e',']',
/* 0x15259 = "Genius NetScroll Optical" */
    'G','e','n','i','u','s',' ','N','e','t','S','c','r','o','l','l',' ','O','p','t','i','c','a','l',
/* 0x15271 = "A3/200 or A3/300 Label Printer" */
    'A','3','/','2','0','0',' ','o','r',' ','A','3','/','3','0','0',' ','L','a','b','e','l',' ','\x0c',
/* 0x15289 = "Volkswagen of America, Inc." */
    'V','o','l','k','s','w','a','g','e','n',' ','o','f',' ','A','m','e','r','i','c','a',',',' ','\x07',
/* 0x152a1 = "Copartner Wire and Cable Mfg. Corp." */
    'C','o','p','a','r','t','n','e','r',' ','W','i','r','e',' ','\xe4','\xa5',' ','M','f','g','.',' ','\x10',
/* 0x152b9 = "CTL-480 [Intuos Pen (S)]" */
    'C','T','L','-','4','8','0',' ','[','I','n','t','u','o','s',' ','P','e','n',' ','(','S',')',']',
/* 0x152d1 = "Porsche Design Desktop Drive" */
    'P','o','r','s','c','h','e',' ','D','e','s','i','g','n',' ','D','e','s','k','t','o','p',' ','\x14',
/* 0x152e9 = "Adjacent Reality Tracker" */
    'A','d','j','a','c','e','n','t',' ','R','e','a','l','i','t','y',' ','T','r','a','c','k','e','r',
/* 0x15301 = "UVC 1.00 device HD UVC WebCam" */
    'U','V','C',' ','1','.','0','0',' ','\xf9',' ','H','D',' ','U','V','C',' ','W','e','b','C','a','m',
/* 0x15319 = "DigitalNow TinyTwin DVB-T Receiver" */
    'D','i','g','i','t','a','l','N','o','w',' ','T','i','n','y','T','w','i','n',' ','\xa7','T',' ','\x8c',
/* 0x15331 = "CTL-660 [Bamboo Pen (M)]" */
    'C','T','L','-','6','6','0',' ','[','B','a','m','b','o','o',' ','P','e','n',' ','(','M',')',']',
/* 0x15349 = "Gravis Xterminator Force" */
    'G','r','a','v','i','s',' ','X','t','e','r','m','i','n','a','t','o','r',' ','F','o','r','c','e',
/* 0x15361 = "Electronic Warfare Assoc., Inc. (EWA)" */
    '\xba','W','a','r','f','a','r','e',' ','A','s','s','o','c','.',',',' ','\x07',' ','(','E','W','A',')',
/* 0x15379 = "PTZ-930 [Intuos3 (9x12)]" */
    'P','T','Z','-','9','3','0',' ','[','I','n','t','u','o','s','3',' ','(','9','x','1','2',')',']',
/* 0x15391 = "PTZ-431W [Intuos3 (4x6)]" */
    'P','T','Z','-','4','3','1','W',' ','[','I','n','t','u','o','s','3',' ','(','4','x','6',')',']',
/* 0x153a9 = "Conexant Systems (Rockwell), Inc." */
    'C','o','n','e','x','a','n','t',' ','\xa6',' ','(','R','o','c','k','w','e','l','l',')',',',' ','\x07',
/* 0x153c1 = "808 Camera #9 (mass storage mode)" */
    '8','0','8',' ','\x04',' ','#','9',' ','(','m','a','s','s',' ','s','t','o','r','a','g','e',' ','\x1a',
/* 0x153d9 = "QL-650TD P-touch Label Printer" */
    'Q','L','-','6','5','0','T','D',' ','P','-','t','o','u','c','h',' ','L','a','b','e','l',' ','\x0c',
/* 0x153f1 = "Stylus CX6900F/CX7000F/DX7000F" */
    '\xb1','C','X','6','9','0','0','F','/','C','X','7','0','0','0','F','/','D','X','7','0','0','0','F',
/* 0x15409 = "CTL-460 [Bamboo Pen (S)]" */
    'C','T','L','-','4','6','0',' ','[','B','a','m','b','o','o',' ','P','e','n',' ','(','S',')',']',
/* 0x15421 = "Datalogic Gryphon GD4430" */
    'D','a','t','a','l','o','g','i','c',' ','G','r','y','p','h','o','n',' ','G','D','4','4','3','0',
/* 0x15439 = "JMS567 SATA 6Gb/s bridge" */
    'J','M','S','5','6','7',' ','S','A','T','A',' ','6','G','b','/','s',' ','b','r','i','d','g','e',
/* 0x15451 = "CCU-550 CDMA EV-DO modem" */
    'C','C','U','-','5','5','0',' ','C','D','M','A',' ','E','V','-','D','O',' ','m','o','d','e','m',
/* 0x15469 = "Araneus Information Systems Oy" */
    'A','r','a','n','e','u','s',' ','I','n','f','o','r','m','a','t','i','o','n',' ','\xa6',' ','O','y',
/* 0x15481 = "CDMA 1xEVDO PC Card, PC 5220" */
    'C','D','M','A',' ','1','x','E','V','D','O',' ','\x1f','C','a','r','d',',',' ','\x1f','5','2','2','0',
/* 0x15499 = "WLI-UC-GNM Wireless LAN Adapter [Ralink RT8070]" */
    'W','L','I','-','U','C','-','G','N','M',' ','\x01','\xf3','\x02',' ','[','\x93','R','T','8','0','7','0',']',
/* 0x154b1 = "CPX Adapter >=HW10.09 [CP2102]" */
    'C','P','X',' ','\x02',' ','>','=','H','W','1','0','.','0','9',' ','[','C','P','2','1','0','2',']',
/* 0x154c9 = "TEW-604UB 802.11bg Wireless Adapter [Atheros AR5523]" */
    'T','E','W','-','6','0','4','U','B',' ','\xad',' ','\x01','\x02',' ','[','\xaf','A','R','5','5','2','3',']',
/* 0x154e1 = "ICD2 in-circuit debugger" */
    'I','C','D','2',' ','i','n','-','c','i','r','c','u','i','t',' ','d','e','b','u','g','g','e','r',
/* 0x154f9 = "SP1 Spectrometer (Jungo)" */
    'S','P','1',' ','S','p','e','c','t','r','o','m','e','t','e','r',' ','(','J','u','n','g','o',')',
/* 0x15511 = "Alpermann+Velte TC60 RLV" */
    'A','l','p','e','r','m','a','n','n','+','V','e','l','t','e',' ','T','C','6','0',' ','R','L','V',
/* 0x15529 = "Cordless Desktop Optical" */
    'C','o','r','d','l','e','s','s',' ','D','e','s','k','t','o','p',' ','O','p','t','i','c','a','l',
/* 0x15541 = "Acer Gobi 2000 Wireless Modem (QDL mode)" */
    'A','c','e','r',' ','G','o','b','i',' ','2','0','0','0',' ','\x01','\x1c',' ','(','Q','D','L',' ','\x1a',
/* 0x15559 = "SPROG Decoder Programmer" */
    'S','P','R','O','G',' ','D','e','c','o','d','e','r',' ','P','r','o','g','r','a','m','m','e','r',
/* 0x15571 = "Alpermann+Velte TC60 CLS" */
    'A','l','p','e','r','m','a','n','n','+','V','e','l','t','e',' ','T','C','6','0',' ','C','L','S',
/* 0x15589 = "QF-707u Bazooka Joystick" */
    'Q','F','-','7','0','7','u',' ','B','a','z','o','o','k','a',' ','J','o','y','s','t','i','c','k',
/* 0x155a1 = "CM8050 Color MFP with Edgeline Technology" */
    'C','M','8','0','5','0',' ','\xa2',' ','M','F','P',' ','\x98','E','d','g','e','l','i','n','e',' ','\x0d',
/* 0x155b9 = "Ewert Energy Systems CANdapter" */
    'E','w','e','r','t',' ','E','n','e','r','g','y',' ','\xa6',' ','C','A','N','d','a','p','t','e','r',
/* 0x155d1 = "Typhoon Redfun Modem V90 56k" */
    'T','y','p','h','o','o','n',' ','R','e','d','f','u','n',' ','\x1c',' ','V','9','0',' ','5','6','k',
/* 0x155e9 = "Glory Mark Electronic, Ltd" */
    'G','l','o','r','y',' ','M','a','r','k',' ','E','l','e','c','t','r','o','n','i','c',',',' ','\x16',
/* 0x15601 = "Standalone LTE device (Trial)" */
    'S','t','a','n','d','a','l','o','n','e',' ','L','T','E',' ','\xf9',' ','(','T','r','i','a','l',')',
/* 0x15619 = "Technology Innovation Holdings, Ltd" */
    '\x0d',' ','I','n','n','o','v','a','t','i','o','n',' ','H','o','l','d','i','n','g','s',',',' ','\x16',
/* 0x15631 = "mIDentity (mass storage)" */
    'm','I','D','e','n','t','i','t','y',' ','(','m','a','s','s',' ','s','t','o','r','a','g','e',')',
/* 0x15649 = "Yield Microelectronics Corp." */
    'Y','i','e','l','d',' ','M','i','c','r','o','e','l','e','c','t','r','o','n','i','c','s',' ','\x10',
/* 0x15661 = "AlphaSphere (bootloader)" */
    'A','l','p','h','a','S','p','h','e','r','e',' ','(','b','o','o','t','l','o','a','d','e','r',')',
/* 0x15679 = "GD01 MX LCD Display/IR Receiver" */
    'G','D','0','1',' ','M','X',' ','L','C','D',' ','D','i','s','p','l','a','y','/','I','R',' ','\x8c',
/* 0x15691 = "Cayman 3341 Ethernet DSL Router" */
    'C','a','y','m','a','n',' ','3','3','4','1',' ','\x7f',' ','D','S','L',' ','R','o','u','t','e','r',
/* 0x156a9 = "BP2 Multi Slit Beam Profiler" */
    'B','P','2',' ','\xd6',' ','S','l','i','t',' ','B','e','a','m',' ','P','r','o','f','i','l','e','r',
/* 0x156c1 = "PTK-840 [Intuos4 (8x13)]" */
    'P','T','K','-','8','4','0',' ','[','I','n','t','u','o','s','4',' ','(','8','x','1','3',')',']',
/* 0x156d9 = "iPod 4.Gen Grayscale 40G" */
    'i','P','o','d',' ','4','.','G','e','n',' ','G','r','a','y','s','c','a','l','e',' ','4','0','G',
/* 0x156f1 = "TRUST EASY WEBSCAN 19200" */
    'T','R','U','S','T',' ','E','A','S','Y',' ','W','E','B','S','C','A','N',' ','1','9','2','0','0',
/* 0x15709 = "EW-7722UTn 802.11n Wireless Adapter [Ralink RT307x]" */
    'E','W','-','7','7','2','2','U','T','n',' ','\x99','\x01','\x02',' ','[','\x93','R','T','3','0','7','x',']',
/* 0x15721 = "Rugged Triple Interface Mobile Hard Drive" */
    'R','u','g','g','e','d',' ','T','r','i','p','l','e',' ','\x81',' ','\x96',' ','H','a','r','d',' ','\x14',
/* 0x15739 = "PJB-100 Personal Jukebox" */
    'P','J','B','-','1','0','0',' ','P','e','r','s','o','n','a','l',' ','J','u','k','e','b','o','x',
/* 0x15751 = "DTZ-2000W [Cintiq 20WSX]" */
    'D','T','Z','-','2','0','0','0','W',' ','[','C','i','n','t','i','q',' ','2','0','W','S','X',']',
/* 0x15769 = "DYMO Endicia 75lb Digital Scale" */
    'D','Y','M','O',' ','E','n','d','i','c','i','a',' ','7','5','l','b',' ','\x09','S','c','a','l','e',
/* 0x15781 = "CTL-470 [Bamboo Connect]" */
    'C','T','L','-','4','7','0',' ','[','B','a','m','b','o','o',' ','C','o','n','n','e','c','t',']',
/* 0x15799 = "Bitland Information Technology Co., Ltd" */
    'B','i','t','l','a','n','d',' ','I','n','f','o','r','m','a','t','i','o','n',' ','\x0d',' ','\x0e','\x16',
/* 0x157b1 = "TL203 MP3 Player and Voice Recorder" */
    'T','L','2','0','3',' ','\x8e','\x1e',' ','\xe4','V','o','i','c','e',' ','R','e','c','o','r','d','e','r',
/* 0x157c9 = "EVK11xx evaluation board" */
    'E','V','K','1','1','x','x',' ','e','v','a','l','u','a','t','i','o','n',' ','b','o','a','r','d',
/* 0x157e1 = "Trust Easy Webscan 19200" */
    'T','r','u','s','t',' ','E','a','s','y',' ','W','e','b','s','c','a','n',' ','1','9','2','0','0',
/* 0x157f9 = "MA111(v1) 802.11b Wireless [Intersil Prism 3.0]" */
    'M','A','1','1','1','(','v','1',')',' ','\x9b','\x01','[','\xb0','P','r','i','s','m',' ','3','.','0',']',
/* 0x15811 = "Egnite GmbH - JTAG/RS-232 adapter" */
    'E','g','n','i','t','e',' ','\xfc',' ','-',' ','J','T','A','G','/','R','S','-','2','3','2',' ','\xd0',
/* 0x15829 = "WinFast TV Audio - PHP SECAM LL+TXT" */
    'W','i','n','\xec','\xda','\x8b','-',' ','P','H','P',' ','S','E','C','A','M',' ','L','L','+','T','X','T',
/* 0x15841 = "SoftK56 Data Fax Voice CARP" */
    'S','o','f','t','K','5','6',' ','\xe7',' ','F','a','x',' ','V','o','i','c','e',' ','C','A','R','P',
/* 0x15859 = "Arduino Due (usb2serial)" */
    'A','r','d','u','i','n','o',' ','D','u','e',' ','(','u','s','b','2','s','e','r','i','a','l',')',
/* 0x15871 = "Built-in iSight [Micron]" */
    'B','u','i','l','t','-','i','n',' ','i','S','i','g','h','t',' ','[','M','i','c','r','o','n',']',
/* 0x15889 = "WLTUBA-107 [Yota 4G LTE]" */
    'W','L','T','U','B','A','-','1','0','7',' ','[','Y','o','t','a',' ','4','G',' ','L','T','E',']',
/* 0x158a1 = "Cinergy S2 PCIe Dual Port 1" */
    'C','i','n','e','r','g','y',' ','S','2',' ','P','C','I','e',' ','D','u','a','l',' ','\x87',' ','1',
/* 0x158b9 = "Cinergy S2 PCIe Dual Port 2" */
    'C','i','n','e','r','g','y',' ','S','2',' ','P','C','I','e',' ','D','u','a','l',' ','\x87',' ','2',
/* 0x158d1 = "SCS Position-Tracker/TNC" */
    'S','C','S',' ','P','o','s','i','t','i','o','n','-','T','r','a','c','k','e','r','/','T','N','C',
/* 0x158e9 = "Alps Electric Ireland, Ltd" */
    'A','l','p','s',' ','E','l','e','c','t','r','i','c',' ','I','r','e','l','a','n','d',',',' ','\x16',
/* 0x15901 = "Digital Voice Recorder VN-240PC" */
    '\x09','V','o','i','c','e',' ','R','e','c','o','r','d','e','r',' ','V','N','-','2','4','0','P','C',
/* 0x15919 = "Alesis Photon X25 MIDI Controller" */
    'A','l','e','s','i','s',' ','P','h','o','t','o','n',' ','X','2','5',' ','M','I','D','I',' ','\x13',
/* 0x15931 = "COMmander Business (PBX)" */
    'C','O','M','m','a','n','d','e','r',' ','B','u','s','i','n','e','s','s',' ','(','P','B','X',')',
/* 0x15949 = "American Microsystems, Inc." */
    'A','m','e','r','i','c','a','n',' ','M','i','c','r','o','s','y','s','t','e','m','s',',',' ','\x07',
/* 0x15961 = "Harmony Touch/Ultimate Remote" */
    'H','a','r','m','o','n','y',' ','T','o','u','c','h','/','U','l','t','i','m','a','t','e',' ','\xcb',
/* 0x15979 = "Lin Shiung Enterprise Co., Ltd" */
    'L','i','n',' ','S','h','i','u','n','g',' ','E','n','t','e','r','p','r','i','s','e',' ','\x0e','\x16',
/* 0x15991 = "flash drive (4GB, EMTEC)" */
    'f','l','a','s','h',' ','d','r','i','v','e',' ','(','4','G','B',',',' ','E','M','T','E','C',')',
/* 0x159a9 = "Elements Desktop (WDE1U)" */
    'E','l','e','m','e','n','t','s',' ','D','e','s','k','t','o','p',' ','(','W','D','E','1','U',')',
/* 0x159c1 = "Strong Man Enterprise Co., Ltd" */
    'S','t','r','o','n','g',' ','M','a','n',' ','E','n','t','e','r','p','r','i','s','e',' ','\x0e','\x16',
/* 0x159d9 = "32GB Micro Slide Attache Flash Drive" */
    '3','2','G','B',' ','\xc4',' ','S','l','i','d','e',' ','A','t','t','a','c','h','e',' ','\x3c',' ','\x14',
/* 0x159f1 = "Hamamatsu Photonics K.K." */
    'H','a','m','a','m','a','t','s','u',' ','P','h','o','t','o','n','i','c','s',' ','K','.','K','.',
/* 0x15a09 = "Operator Display, BA63-USB" */
    'O','p','e','r','a','t','o','r',' ','D','i','s','p','l','a','y',',',' ','B','A','6','3','-','\x0a',
/* 0x15a21 = "QuickCam Communicate MP/S5500" */
    '\xc7','a','m',' ','C','o','m','m','u','n','i','c','a','t','e',' ','M','P','/','S','5','5','0','0',
/* 0x15a39 = "IXI Ogo CT-17 handheld device" */
    'I','X','I',' ','O','g','o',' ','C','T','-','1','7',' ','h','a','n','d','h','e','l','d',' ','\xf9',
/* 0x15a51 = "FRITZ!Box WLAN (Annex A)" */
    'F','R','I','T','Z','!','B','o','x',' ','W','L','A','N',' ','(','A','n','n','e','x',' ','A',')',
/* 0x15a69 = "Prime [NW280AA, G8X92AA]" */
    'P','r','i','m','e',' ','[','N','W','2','8','0','A','A',',',' ','G','8','X','9','2','A','A',']',
/* 0x15a81 = "WingMan Force Feedback Mouse" */
    'W','i','n','g','M','a','n',' ','F','o','r','c','e',' ','F','e','e','d','b','a','c','k',' ','\x0b',
/* 0x15a99 = "SP2 Spectrometer (Jungo)" */
    'S','P','2',' ','S','p','e','c','t','r','o','m','e','t','e','r',' ','(','J','u','n','g','o',')',
/* 0x15ab1 = "at91sam SAMBA bootloader" */
    'a','t','9','1','s','a','m',' ','S','A','M','B','A',' ','b','o','o','t','l','o','a','d','e','r',
/* 0x15ac9 = "EPOC Consumer Headset Wireless Dongle" */
    'E','P','O','C',' ','C','o','n','s','u','m','e','r',' ','H','e','a','d','s','e','t',' ','\x01','\xf4',
/* 0x15ae1 = "SPEEDLINK SNAPPY Wireless Mouse Nano" */
    'S','P','E','E','D','L','I','N','K',' ','S','N','A','P','P','Y',' ','\x01','\x0b',' ','N','a','n','o',
/* 0x15af9 = "78XX Scanner - Embedded System" */
    '7','8','X','X',' ','\x25',' ','-',' ','E','m','b','e','d','d','e','d',' ','S','y','s','t','e','m',
/* 0x15b11 = "GT Information System Co., Ltd" */
    'G','T',' ','I','n','f','o','r','m','a','t','i','o','n',' ','S','y','s','t','e','m',' ','\x0e','\x16',
/* 0x15b29 = "STK600 development board" */
    'S','T','K','6','0','0',' ','d','e','v','e','l','o','p','m','e','n','t',' ','b','o','a','r','d',
/* 0x15b41 = "V.92 56K Mini External Modem Model 3095" */
    'V','.','9','2',' ','5','6','K',' ','\xb9',' ','\xe3','\x1c',' ','M','o','d','e','l',' ','3','0','9','5',
/* 0x15b59 = "LifeChat LX-3000 Headset" */
    'L','i','f','e','C','h','a','t',' ','L','X','-','3','0','0','0',' ','H','e','a','d','s','e','t',
/* 0x15b71 = "DVD Multi-plus unit DVR-UEH8" */
    'D','V','D',' ','\xd6','-','p','l','u','s',' ','u','n','i','t',' ','D','V','R','-','U','E','H','8',
/* 0x15b89 = "Starline International Group Limited" */
    'S','t','a','r','l','i','n','e',' ','\x9c',' ','G','r','o','u','p',' ','L','i','m','i','t','e','d',
/* 0x15ba1 = "ZyXEL Omni FaxModem 56K Plus" */
    'Z','y','X','E','L',' ','O','m','n','i',' ','F','a','x','\x1c',' ','5','6','K',' ','P','l','u','s',
/* 0x15bb9 = "6303 classic Phone (PC Suite mode)" */
    '6','3','0','3',' ','c','l','a','s','s','i','c',' ','\x19',' ','(','\x1f','S','u','i','t','e',' ','\x1a',
/* 0x15bd1 = "Optical Wheel Mouse (OMS3CB/OMGB30)" */
    '\x7b','W','h','e','e','l',' ','\x0b',' ','(','O','M','S','3','C','B','/','O','M','G','B','3','0',')',
/* 0x15be9 = "Arduino Yun (bootloader)" */
    'A','r','d','u','i','n','o',' ','Y','u','n',' ','(','b','o','o','t','l','o','a','d','e','r',')',
/* 0x15c01 = "Teensyduino Keyboard+Mouse+Joystick" */
    'T','e','e','n','s','y','d','u','i','n','o',' ','\x05','+','\x0b','+','J','o','y','s','t','i','c','k',
/* 0x15c19 = "Alcatel Microelectronics" */
    'A','l','c','a','t','e','l',' ','M','i','c','r','o','e','l','e','c','t','r','o','n','i','c','s',
/* 0x15c31 = "at32uc3a3 DFU bootloader" */
    'a','t','3','2','u','c','3','a','3',' ','D','F','U',' ','b','o','o','t','l','o','a','d','e','r',
/* 0x15c49 = "at90usb82 DFU bootloader" */
    'a','t','9','0','u','s','b','8','2',' ','D','F','U',' ','b','o','o','t','l','o','a','d','e','r',
/* 0x15c61 = "Minton Optic Industry Co., Inc." */
    'M','i','n','t','o','n',' ','O','p','t','i','c',' ','I','n','d','u','s','t','r','y',' ','\x0e','\x07',
/* 0x15c79 = "AU6375 4-LUN card reader" */
    'A','U','6','3','7','5',' ','4','-','L','U','N',' ','c','a','r','d',' ','r','e','a','d','e','r',
/* 0x15c91 = "Flight2000 F-23 Joystick" */
    'F','l','i','g','h','t','2','0','0','0',' ','F','-','2','3',' ','J','o','y','s','t','i','c','k',
/* 0x15ca9 = "T30 series mp3/ogg/wma player" */
    'T','3','0',' ','\x1d',' ','m','p','3','/','o','g','g','/','w','m','a',' ','p','l','a','y','e','r',
/* 0x15cc1 = "Rocketfish RF-FLBTAD Bluetooth Adapter" */
    'R','o','c','k','e','t','f','i','s','h',' ','R','F','-','F','L','B','T','A','D',' ','\x06',' ','\x02',
/* 0x15cd9 = "SCM Miniature Card Reader/Writer" */
    'S','C','M',' ','M','i','n','i','a','t','u','r','e',' ','\x15',' ','R','e','a','d','e','r','/','\xdf',
/* 0x15cf1 = "CompactFlash & SmartMedia Card Reader [eusb]" */
    'C','o','m','p','a','c','t','\x3c',' ','&',' ','\x12','\xa1',' ','\x15',' ','\x08',' ','[','e','u','s','b',']',
/* 0x15d09 = "1TB SimpleDrive II USB External Hard Drive" */
    '1','T','B',' ','S','i','m','p','l','e','\x14',' ','I','I',' ','\x0a',' ','\xe3','H','a','r','d',' ','\x14',
/* 0x15d21 = "Sundtek SkyTV Ultimate III" */
    'S','u','n','d','t','e','k',' ','S','k','y','\xda','U','l','t','i','m','a','t','e',' ','I','I','I',
/* 0x15d39 = "GD-1212 [Intuos (12x12)]" */
    'G','D','-','1','2','1','2',' ','[','I','n','t','u','o','s',' ','(','1','2','x','1','2',')',']',
/* 0x15d51 = "Liou Yuane Enterprise Co., Ltd" */
    'L','i','o','u',' ','Y','u','a','n','e',' ','E','n','t','e','r','p','r','i','s','e',' ','\x0e','\x16',
/* 0x15d69 = "TripleHead2Go [Digital Edition]" */
    'T','r','i','p','l','e','H','e','a','d','2','G','o',' ','[','\x09','E','d','i','t','i','o','n',']',
/* 0x15d81 = "Arduino Zero Pro (CDC ACM)" */
    'A','r','d','u','i','n','o',' ','Z','e','r','o',' ','\x8f',' ','(','C','D','C',' ','A','C','M',')',
/* 0x15d99 = "CNU-680 CDMA EV-DO modem" */
    'C','N','U','-','6','8','0',' ','C','D','M','A',' ','E','V','-','D','O',' ','m','o','d','e','m',
/* 0x15db1 = "INSMATEV70G-MAX Standard" */
    'I','N','S','M','A','T','E','V','7','0','G','-','M','A','X',' ','S','t','a','n','d','a','r','d',
/* 0x15dc9 = "Chin Shong Enterprise Co., Ltd" */
    'C','h','i','n',' ','S','h','o','n','g',' ','E','n','t','e','r','p','r','i','s','e',' ','\x0e','\x16',
/* 0x15de1 = "Wingman Force Feedback Mouse" */
    'W','i','n','g','m','a','n',' ','F','o','r','c','e',' ','F','e','e','d','b','a','c','k',' ','\x0b',
/* 0x15df9 = "Hip Hing Cable & Plug Mfy. Ltd." */
    'H','i','p',' ','H','i','n','g',' ','\xa5',' ','&',' ','P','l','u','g',' ','M','f','y','.',' ','\xab',
/* 0x15e11 = "Tokyo Electron Device, Ltd" */
    'T','o','k','y','o',' ','E','l','e','c','t','r','o','n',' ','D','e','v','i','c','e',',',' ','\x16',
/* 0x15e29 = "RfCat Chronos bootloader" */
    'R','f','C','a','t',' ','C','h','r','o','n','o','s',' ','b','o','o','t','l','o','a','d','e','r',
/* 0x15e41 = "Jazz Blood Glucose Meter" */
    'J','a','z','z',' ','B','l','o','o','d',' ','G','l','u','c','o','s','e',' ','M','e','t','e','r',
/* 0x15e59 = "GSM module MC35/ES75 USB Modem" */
    'G','S','M',' ','m','o','d','u','l','e',' ','M','C','3','5','/','E','S','7','5',' ','\x0a',' ','\x1c',
/* 0x15e71 = "Dual Analog Leader GamePad" */
    'D','u','a','l',' ','A','n','a','l','o','g',' ','L','e','a','d','e','r',' ','G','a','m','e','\xfa',
/* 0x15e89 = "Optical Wheel Mouse (OMA3CB/OMGI30)" */
    '\x7b','W','h','e','e','l',' ','\x0b',' ','(','O','M','A','3','C','B','/','O','M','G','I','3','0',')',
/* 0x15ea1 = "Rockfire USB SkyShuttle Pro" */
    'R','o','c','k','f','i','r','e',' ','\x0a',' ','S','k','y','S','h','u','t','t','l','e',' ','\x8f',
/* 0x15eb8 = "Sony 10Mbps Ethernet [pegasus]" */
    'S','o','n','y',' ','1','0','M','b','p','s',' ','\x7f',' ','[','p','e','g','a','s','u','s',']',
/* 0x15ecf = "FriendlyNET AeroLAN AL2011" */
    'F','r','i','e','n','d','l','y','N','E','T',' ','A','e','r','o','\xf3','A','L','2','0','1','1',
/* 0x15ee6 = "QuickCam for Dell Notebooks Mic" */
    '\xc7','a','m',' ','\xcc','D','e','l','l',' ','N','o','t','e','b','o','o','k','s',' ','M','i','c',
/* 0x15efd = "DVBSky T330 DVB-T2/C tuner" */
    'D','V','B','S','k','y',' ','T','3','3','0',' ','\xa7','T','2','/','C',' ','t','u','n','e','r',
/* 0x15f14 = "USB 2.0 - 7 ports Hub [FSU307]" */
    '\x0a',' ','\xc1','-',' ','7',' ','p','o','r','t','s',' ','\xa4',' ','[','F','S','U','3','0','7',']',
/* 0x15f2b = "CDMA 2000 1xRTT/EV-DO Modem" */
    'C','D','M','A',' ','2','0','0','0',' ','1','x','R','T','T','/','E','V','-','D','O',' ','\x1c',
/* 0x15f42 = "IFU-WLM2 USB Wireless LAN Module (Memory Mode)" */
    'I','F','U','-','W','L','M','2',' ','\x0a',' ','\x01','\xf3','\xe5',' ','(','\xd2',' ','M','o','d','e',')',
/* 0x15f59 = "SAIN Information & Communications Co., Ltd." */
    'S','A','I','N',' ','I','n','f','o','r','m','a','t','i','o','n',' ','&',' ','\xd1',' ','\x0e','\xab',
/* 0x15f70 = "Hercules Classic Silver" */
    'H','e','r','c','u','l','e','s',' ','C','l','a','s','s','i','c',' ','S','i','l','v','e','r',
/* 0x15f87 = "Kuan Tech Enterprise Co., Ltd" */
    'K','u','a','n',' ','T','e','c','h',' ','E','n','t','e','r','p','r','i','s','e',' ','\x0e','\x16',
/* 0x15f9e = "Standard Microsystems Corp." */
    'S','t','a','n','d','a','r','d',' ','M','i','c','r','o','s','y','s','t','e','m','s',' ','\x10',
/* 0x15fb5 = "USB08 Development board" */
    'U','S','B','0','8',' ','D','e','v','e','l','o','p','m','e','n','t',' ','b','o','a','r','d',
/* 0x15fcc = "Elan Microelectronics Corp." */
    'E','l','a','n',' ','M','i','c','r','o','e','l','e','c','t','r','o','n','i','c','s',' ','\x10',
/* 0x15fe3 = "PlayStation Portable [Mass Storage]" */
    'P','l','a','y','S','t','a','t','i','o','n',' ','\xa9','[','\x7c','S','t','o','r','a','g','e',']',
/* 0x15ffa = "Typhoon Webcam 100k [nw8000]" */
    'T','y','p','h','o','o','n',' ','\x11',' ','1','0','0','k',' ','[','n','w','8','0','0','0',']',
/* 0x16011 = "SlimBlade Presenter Media Mouse" */
    'S','l','i','m','B','l','a','d','e',' ','P','r','e','s','e','n','t','e','r',' ','\xa1',' ','\x0b',
/* 0x16028 = "Arcadyan WN7512 802.11n" */
    'A','r','c','a','d','y','a','n',' ','W','N','7','5','1','2',' ','8','0','2','.','1','1','n',
/* 0x1603f = "Murata Manufacturing Co., Ltd" */
    'M','u','r','a','t','a',' ','M','a','n','u','f','a','c','t','u','r','i','n','g',' ','\x0e','\x16',
/* 0x16056 = "Measurement Computing Corp." */
    'M','e','a','s','u','r','e','m','e','n','t',' ','C','o','m','p','u','t','i','n','g',' ','\x10',
/* 0x1606d = "PTK-440 [Intuos4 (4x6)]" */
    'P','T','K','-','4','4','0',' ','[','I','n','t','u','o','s','4',' ','(','4','x','6',')',']',
/* 0x16084 = "RR-CirKits LocoBuffer-USB" */
    'R','R','-','C','i','r','K','i','t','s',' ','L','o','c','o','B','u','f','f','e','r','-','\x0a',
/* 0x1609b = "Motorola BC4 Bluetooth 3.0+HS Adapter" */
    'M','o','t','o','r','o','l','a',' ','B','C','4',' ','\x06',' ','3','.','0','+','H','S',' ','\x02',
/* 0x160b2 = "Advanced Connection Technology Inc." */
    'A','d','v','a','n','c','e','d',' ','C','o','n','n','e','c','t','i','o','n',' ','\x0d',' ','\x07',
/* 0x160c9 = "EW-7717UN 802.11n Wireless Adapter [Ralink RT2870]" */
    'E','W','-','7','7','1','7','U','N',' ','\x99','\x01','\x02',' ','[','\x93','R','T','2','8','7','0',']',
/* 0x160e0 = "CanoScan 3000/3000F/3000ex" */
    'C','a','n','o','\x8a',' ','3','0','0','0','/','3','0','0','0','F','/','3','0','0','0','e','x',
/* 0x160f7 = "UA SECURE STORAGE TOKEN" */
    'U','A',' ','S','E','C','U','R','E',' ','S','T','O','R','A','G','E',' ','T','O','K','E','N',
/* 0x1610e = "Linino ONE (bootloader)" */
    'L','i','n','i','n','o',' ','O','N','E',' ','(','b','o','o','t','l','o','a','d','e','r',')',
/* 0x16125 = "Top Gun Joystick (rev2)" */
    'T','o','p',' ','G','u','n',' ','J','o','y','s','t','i','c','k',' ','(','r','e','v','2',')',
/* 0x1613c = "LUFA Keyboard Demo Application" */
    'L','U','F','A',' ','\x05',' ','D','e','m','o',' ','A','p','p','l','i','c','a','t','i','o','n',
/* 0x16153 = "Genesys Logic Scanner Controller NT5.0" */
    'G','e','n','e','s','y','s',' ','L','o','g','i','c',' ','\x25',' ','\x13',' ','N','T','5','.','0',
/* 0x1616a = "WiND 802.11abg / 802.11bg WLAN" */
    'W','i','N','D',' ','8','0','2','.','1','1','a','b','g',' ','/',' ','\xad',' ','W','L','A','N',
/* 0x16181 = "MaxFire G-12U Vibration" */
    'M','a','x','F','i','r','e',' ','G','-','1','2','U',' ','V','i','b','r','a','t','i','o','n',
/* 0x16198 = "REC-A-ADPT-USB (recorder)" */
    'R','E','C','-','A','-','A','D','P','T','-','\x0a',' ','(','r','e','c','o','r','d','e','r',')',
/* 0x161af = "ZyXEL Omni FaxModem 56K UNO" */
    'Z','y','X','E','L',' ','O','m','n','i',' ','F','a','x','\x1c',' ','5','6','K',' ','U','N','O',
/* 0x161c6 = "BeeTel Home 100 (FlashLoad)" */
    'B','e','e','T','e','l',' ','H','o','m','e',' ','1','0','0',' ','(','\x3c','L','o','a','d',')',
/* 0x161dd = "ScienceScope Logbook LS" */
    'S','c','i','e','n','c','e','S','c','o','p','e',' ','L','o','g','b','o','o','k',' ','L','S',
/* 0x161f4 = "VR920 Immersive Eyewear" */
    'V','R','9','2','0',' ','I','m','m','e','r','s','i','v','e',' ','E','y','e','w','e','a','r',
/* 0x1620b = "Verbatim STORE N GO 4GB" */
    'V','e','r','b','a','t','i','m',' ','S','T','O','R','E',' ','N',' ','G','O',' ','4','G','B',
/* 0x16222 = "Digital Voice Recorder DS-4000" */
    '\x09','V','o','i','c','e',' ','R','e','c','o','r','d','e','r',' ','D','S','-','4','0','0','0',
/* 0x16239 = "C-Bus Spectrum Colour Touchscreen" */
    'C','-','B','u','s',' ','S','p','e','c','t','r','u','m',' ','C','o','l','o','u','r',' ','\xb5',
/* 0x16250 = "PX-401A [ME 300/Stylus NX100]" */
    'P','X','-','4','0','1','A',' ','[','M','E',' ','3','0','0','/','\xb1','N','X','1','0','0',']',
/* 0x16267 = "USB OTG Compliance test device" */
    '\x0a',' ','O','T','G',' ','C','o','m','p','l','i','a','n','c','e',' ','t','e','s','t',' ','\xf9',
/* 0x1627e = "My Book Premium Edition" */
    'M','y',' ','B','o','o','k',' ','P','r','e','m','i','u','m',' ','E','d','i','t','i','o','n',
/* 0x16295 = "ZTV ZT-721 2.4GHz A/V Receiver" */
    'Z','T','V',' ','Z','T','-','7','2','1',' ','2','.','4','G','H','z',' ','A','/','V',' ','\x8c',
/* 0x162ac = "Mass Storage (UISDMC1S & UISDMC3S)" */
    '\x7c','\x0f','(','U','I','S','D','M','C','1','S',' ','&',' ','U','I','S','D','M','C','3','S',')',
/* 0x162c3 = "Xperia Mini Pro (Tethering mode)" */
    'X','p','e','r','i','a',' ','\xb9',' ','\x8f',' ','(','T','e','t','h','e','r','i','n','g',' ','\x1a',
/* 0x162da = "WMRS200 weather station" */
    'W','M','R','S','2','0','0',' ','w','e','a','t','h','e','r',' ','s','t','a','t','i','o','n',
/* 0x162f1 = "OpenCom 30 plus (FlashLoad)" */
    'O','p','e','n','C','o','m',' ','3','0',' ','p','l','u','s',' ','(','\x3c','L','o','a','d',')',
/* 0x16308 = "Viewmaster 4D Browser Mouse" */
    'V','i','e','w','m','a','s','t','e','r',' ','4','D',' ','B','r','o','w','s','e','r',' ','\x0b',
/* 0x1631f = "WingMan Strike Force 3D" */
    'W','i','n','g','M','a','n',' ','S','t','r','i','k','e',' ','F','o','r','c','e',' ','3','D',
/* 0x16336 = "PX-434A [Stylus NX330 Series]" */
    'P','X','-','4','3','4','A',' ','[','\xb1','N','X','3','3','0',' ','S','e','r','i','e','s',']',
/* 0x1634d = "MPEG-2 Capture Device (E880)" */
    'M','P','E','G','-','2',' ','C','a','p','t','u','r','e',' ','\x03',' ','(','E','8','8','0',')',
/* 0x16364 = "M5632 Host-to-Host Link" */
    'M','5','6','3','2',' ','H','o','s','t','-','t','o','-','H','o','s','t',' ','L','i','n','k',
/* 0x1637b = "Cohiba 802.11g Wireless Mini adapter [Intersil ISL3887]" */
    'C','o','h','i','b','a',' ','\x94','\x01','\xb9',' ','\xd0',' ','[','\xb0','I','S','L','3','8','8','7',']',
/* 0x16392 = "Nomad Jukebox Zen USB 2.0" */
    'N','o','m','a','d',' ','J','u','k','e','b','o','x',' ','Z','e','n',' ','\x0a',' ','2','.','0',
/* 0x163a9 = "LUFA Mass Storage Demo Application" */
    'L','U','F','A',' ','\x7c','\x0f','D','e','m','o',' ','A','p','p','l','i','c','a','t','i','o','n',
/* 0x163c0 = "MCS7730 10/100 Mbps Ethernet adapter" */
    'M','C','S','7','7','3','0',' ','1','0','/','1','0','0',' ','M','b','p','s',' ','\x7f',' ','\xd0',
/* 0x163d7 = "Avision AM3000/MF3000 Series" */
    'A','v','i','s','i','o','n',' ','A','M','3','0','0','0','/','M','F','3','0','0','0',' ','\xbf',
/* 0x163ee = "S-Cam F5/D-Link DSC-350 Digital Camera" */
    'S','-','\x9a','F','5','/','D','-','L','i','n','k',' ','D','S','C','-','3','5','0',' ','\x09','\x04',
/* 0x16405 = "Data Traveler 100 G2 8 GiB" */
    '\xe7',' ','T','r','a','v','e','l','e','r',' ','1','0','0',' ','G','2',' ','8',' ','G','i','B',
/* 0x1641c = "PC Camera (SN9C201 + S5K4AAFX)" */
    '\x1f','\x04',' ','(','S','N','9','C','2','0','1',' ','+',' ','S','5','K','4','A','A','F','X',')',
/* 0x16433 = "Speedlink Programming Interface" */
    'S','p','e','e','d','l','i','n','k',' ','P','r','o','g','r','a','m','m','i','n','g',' ','\x81',
/* 0x1644a = "PowerShot ELPH 530 HS / IXUS 510 HS" */
    '\x24','\x84','E','L','P','H',' ','5','3','0',' ','H','S',' ','/',' ','\xfd','5','1','0',' ','H','S',
/* 0x16461 = "Ethernet (RNDIS and CDC ethernet)" */
    '\x7f',' ','(','R','N','D','I','S',' ','\xe4','C','D','C',' ','e','t','h','e','r','n','e','t',')',
/* 0x16478 = "Gigabyte U7000 DVB-T tuner" */
    'G','i','g','a','b','y','t','e',' ','U','7','0','0','0',' ','\xa7','T',' ','t','u','n','e','r',
/* 0x1648f = "PowerShot ELPH 300 HS / IXUS 220 HS" */
    '\x24','\x84','E','L','P','H',' ','3','0','0',' ','H','S',' ','/',' ','\xfd','2','2','0',' ','H','S',
/* 0x164a6 = "PANTECH USB MODEM [UM175]" */
    'P','A','N','T','E','C','H',' ','\x0a',' ','M','O','D','E','M',' ','[','U','M','1','7','5',']',
/* 0x164bd = "iCON 210 UMTS Surfstick" */
    'i','C','O','N',' ','2','1','0',' ','U','M','T','S',' ','S','u','r','f','s','t','i','c','k',
/* 0x164d4 = "WLI-UC-GN Wireless LAN Adapter [Ralink RT3070]" */
    'W','L','I','-','U','C','-','G','N',' ','\x01','\xf3','\x02',' ','[','\x93','R','T','3','0','7','0',']',
/* 0x164eb = "Triplet GSM Phone (storage)" */
    'T','r','i','p','l','e','t',' ','G','S','M',' ','\x19',' ','(','s','t','o','r','a','g','e',')',
/* 0x16502 = "Bitcoin hardware wallet" */
    'B','i','t','c','o','i','n',' ','h','a','r','d','w','a','r','e',' ','w','a','l','l','e','t',
/* 0x16519 = "VCON Telecommunications" */
    'V','C','O','N',' ','T','e','l','e','c','o','m','m','u','n','i','c','a','t','i','o','n','s',
/* 0x16530 = "ASYST electronic d.o.o." */
    'A','S','Y','S','T',' ','e','l','e','c','t','r','o','n','i','c',' ','d','.','o','.','o','.',
/* 0x16547 = "Flash drive 16GB [Nano Pro]" */
    '\x3c',' ','d','r','i','v','e',' ','1','6','G','B',' ','[','N','a','n','o',' ','P','r','o',']',
/* 0x1655e = "MX5000 Cordless Desktop" */
    'M','X','5','0','0','0',' ','C','o','r','d','l','e','s','s',' ','D','e','s','k','t','o','p',
/* 0x16575 = "Jenoptik JD350 entrance" */
    'J','e','n','o','p','t','i','k',' ','J','D','3','5','0',' ','e','n','t','r','a','n','c','e',
/* 0x1658c = "American Computer & Digital Components" */
    'A','m','e','r','i','c','a','n',' ','\xcd','&',' ','\x09','C','o','m','p','o','n','e','n','t','s',
/* 0x165a3 = "VL700 SATA 3Gb/s bridge" */
    'V','L','7','0','0',' ','S','A','T','A',' ','3','G','b','/','s',' ','b','r','i','d','g','e',
/* 0x165ba = "PowerShot A3100 IS / PowerShot A3150 IS" */
    '\x24','\x84','A','3','1','0','0',' ','I','S',' ','/',' ','\x24','\x84','A','3','1','5','0',' ','I','S',
/* 0x165d1 = "Dipl.-Ing. Stefan Kunde" */
    'D','i','p','l','.','-','I','n','g','.',' ','S','t','e','f','a','n',' ','K','u','n','d','e',
/* 0x165e8 = "LAN7500 Ethernet 10/100/1000 Adapter" */
    'L','A','N','7','5','0','0',' ','\x7f',' ','1','0','/','1','0','0','/','1','0','0','0',' ','\x02',
/* 0x165ff = "FaceTime HD Camera (Display)" */
    'F','a','c','e','T','i','m','e',' ','H','D',' ','\x04',' ','(','D','i','s','p','l','a','y',')',
/* 0x16616 = "OpenPCD 13.56MHz RFID Reader" */
    'O','p','e','n','P','C','D',' ','1','3','.','5','6','M','H','z',' ','R','F','I','D',' ','\x08',
/* 0x1662d = "Well Excellent & Most Corp." */
    'W','e','l','l',' ','E','x','c','e','l','l','e','n','t',' ','&',' ','M','o','s','t',' ','\x10',
/* 0x16644 = "Eumex 5520PC (WinXP/2000)" */
    'E','u','m','e','x',' ','5','5','2','0','\x1f','(','W','i','n','X','P','/','2','0','0','0',')',
/* 0x1665b = "Hit\'s Communications, Inc." */
    'H','i','t','\'','s',' ','C','o','m','m','u','n','i','c','a','t','i','o','n','s',',',' ','\x07',
/* 0x16672 = "Ux500 serial debug port" */
    'U','x','5','0','0',' ','s','e','r','i','a','l',' ','d','e','b','u','g',' ','p','o','r','t',
/* 0x16689 = "Clas Ohlson TWC-30XOP Webcam" */
    'C','l','a','s',' ','O','h','l','s','o','n',' ','T','W','C','-','3','0','X','O','P',' ','\x11',
/* 0x166a0 = "ScienceScope Logbook ML" */
    'S','c','i','e','n','c','e','S','c','o','p','e',' ','L','o','g','b','o','o','k',' ','M','L',
/* 0x166b7 = "USBView II Video Adapter [nt1004]" */
    'U','S','B','V','i','e','w',' ','I','I',' ','\xa3',' ','\x02',' ','[','n','t','1','0','0','4',']',
/* 0x166ce = "DC-1100 Video Enhamcement Device" */
    'D','C','-','1','1','0','0',' ','\xa3',' ','E','n','h','a','m','c','e','m','e','n','t',' ','\x03',
/* 0x166e5 = "EMS Dr. Thomas Wuensche" */
    'E','M','S',' ','D','r','.',' ','T','h','o','m','a','s',' ','W','u','e','n','s','c','h','e',
/* 0x166fc = "WL-302 Wireless Network 300N USB dongle " */
    'W','L','-','3','0','2',' ','\x01','\x8d','3','0','0','N',' ','\x0a',' ','d','o','n','g','l','e',' ',
/* 0x16713 = "GameCom 777 5.1 Headset" */
    'G','a','m','e','C','o','m',' ','7','7','7',' ','5','.','1',' ','H','e','a','d','s','e','t',
/* 0x1672a = "My Book (WDBFJK0040HBK)" */
    'M','y',' ','B','o','o','k',' ','(','W','D','B','F','J','K','0','0','4','0','H','B','K',')',
/* 0x16741 = "3G Green Green Globe Co., Ltd" */
    '3','G',' ','G','r','e','e','n',' ','G','r','e','e','n',' ','G','l','o','b','e',' ','\x0e','\x16',
/* 0x16758 = "Wireless Natural MultiMedia Keyboard (106/109)" */
    '\x01','N','a','t','u','r','a','l',' ','\xd6','\xa1',' ','\x05',' ','(','1','0','6','/','1','0','9',')',
/* 0x1676f = "Iiyama North America, Inc." */
    'I','i','y','a','m','a',' ','N','o','r','t','h',' ','A','m','e','r','i','c','a',',',' ','\x07',
/* 0x16786 = "Huawei MT-882 Remote NDIS Network Device" */
    'H','u','a','w','e','i',' ','M','T','-','8','8','2',' ','\xcb',' ','N','D','I','S',' ','\x8d','\x03',
/* 0x1679d = "Katsuragawa Electric Co., Ltd." */
    'K','a','t','s','u','r','a','g','a','w','a',' ','E','l','e','c','t','r','i','c',' ','\x0e','\xab',
/* 0x167b4 = "A789 (MTP mode, with debug)" */
    'A','7','8','9',' ','(','M','T','P',' ','m','o','d','e',',',' ','\x98','d','e','b','u','g',')',
/* 0x167cb = "Flash RAM Downloader/miniOS" */
    '\x3c',' ','R','A','M',' ','D','o','w','n','l','o','a','d','e','r','/','m','i','n','i','O','S',
/* 0x167e2 = "WL-167G v1 802.11g Adapter [Ralink RT2571]" */
    'W','L','-','1','6','7','G',' ','v','1',' ','\x94','\x02',' ','[','\x93','R','T','2','5','7','1',']',
/* 0x167f9 = "M-Audio MidiSport 2x4 Loader" */
    'M','-','\x8b','M','i','d','i','S','p','o','r','t',' ','2','x','4',' ','L','o','a','d','e','r',
/* 0x16810 = "Generic Display Device (Mass storage mode)" */
    'G','e','n','e','r','i','c',' ','\xcf',' ','\x03',' ','(','\x7c','s','t','o','r','a','g','e',' ','\x1a',
/* 0x16827 = "Kowa Bs888e Microcamera" */
    'K','o','w','a',' ','B','s','8','8','8','e',' ','M','i','c','r','o','c','a','m','e','r','a',
/* 0x1683e = "Kingston DataTraveler 2.0 USB Stick" */
    'K','i','n','g','s','t','o','n',' ','\xe7','T','r','a','v','e','l','e','r',' ','\xc1','\x0a',' ','\xb3',
/* 0x16855 = "Holtek Semiconductor, Inc." */
    'H','o','l','t','e','k',' ','S','e','m','i','c','o','n','d','u','c','t','o','r',',',' ','\x07',
/* 0x1686c = "TalkTalk SNU5630NS/05 802.11bg" */
    'T','a','l','k','T','a','l','k',' ','S','N','U','5','6','3','0','N','S','/','0','5',' ','\xad',
/* 0x16883 = "SP1 Spectrometer (VISA)" */
    'S','P','1',' ','S','p','e','c','t','r','o','m','e','t','e','r',' ','(','V','I','S','A',')',
/* 0x1689a = "Speed Force Wireless Wheel for Wii" */
    'S','p','e','e','d',' ','F','o','r','c','e',' ','\x01','W','h','e','e','l',' ','\xcc','W','i','i',
/* 0x168b1 = "DataTraveler 1GB/2GB Pen Drive" */
    '\xe7','T','r','a','v','e','l','e','r',' ','1','G','B','/','2','G','B',' ','P','e','n',' ','\x14',
/* 0x168c8 = "infrared dongle for remote" */
    'i','n','f','r','a','r','e','d',' ','d','o','n','g','l','e',' ','\xcc','r','e','m','o','t','e',
/* 0x168df = "AN-WF100 802.11abgn Wireless Adapter [Broadcom BCM4323]" */
    'A','N','-','W','F','1','0','0',' ','\xea','\x01','\x02',' ','[','\xeb','B','C','M','4','3','2','3',']',
/* 0x168f6 = "CME (Central Music Co.)" */
    'C','M','E',' ','(','C','e','n','t','r','a','l',' ','M','u','s','i','c',' ','C','o','.',')',
/* 0x1690d = "Franklin Electronic Publishers, Inc." */
    'F','r','a','n','k','l','i','n',' ','\xba','P','u','b','l','i','s','h','e','r','s',',',' ','\x07',
/* 0x16924 = "Hitex Development Tools" */
    'H','i','t','e','x',' ','D','e','v','e','l','o','p','m','e','n','t',' ','T','o','o','l','s',
/* 0x1693b = "Take-It 1300 DSC Bulk Driver" */
    'T','a','k','e','-','I','t',' ','1','3','0','0',' ','D','S','C',' ','B','u','l','k',' ','\xde',
/* 0x16952 = "SP550 Pad and Joystick Combo" */
    'S','P','5','5','0',' ','\xfa',' ','\xe4','J','o','y','s','t','i','c','k',' ','C','o','m','b','o',
/* 0x16969 = "Nogatech USBVision (SY)" */
    'N','o','g','a','t','e','c','h',' ','U','S','B','V','i','s','i','o','n',' ','(','S','Y',')',
/* 0x16980 = "@Home Networks Ethernet [klsi]" */
    '@','H','o','m','e',' ','N','e','t','w','o','r','k','s',' ','\x7f',' ','[','k','l','s','i',']',
/* 0x16997 = "Galaxy Nexus (fastboot)" */
    'G','a','l','a','x','y',' ','N','e','x','u','s',' ','(','f','a','s','t','b','o','o','t',')',
/* 0x169ae = "frobiac / adnw keyboard" */
    'f','r','o','b','i','a','c',' ','/',' ','a','d','n','w',' ','k','e','y','b','o','a','r','d',
/* 0x169c5 = "DataTraveler 112 4GB Pen Drive" */
    '\xe7','T','r','a','v','e','l','e','r',' ','1','1','2',' ','4','G','B',' ','P','e','n',' ','\x14',
/* 0x169dc = "Nebraska Furniture Mart" */
    'N','e','b','r','a','s','k','a',' ','F','u','r','n','i','t','u','r','e',' ','M','a','r','t',
/* 0x169f3 = "Digital Voice Recorder DS-2300" */
    '\x09','V','o','i','c','e',' ','R','e','c','o','r','d','e','r',' ','D','S','-','2','3','0','0',
/* 0x16a0a = "FP-L170/MF350/L380/L398" */
    'F','P','-','L','1','7','0','/','M','F','3','5','0','/','L','3','8','0','/','L','3','9','8',
/* 0x16a21 = "XBurst Jz4740 boot mode" */
    'X','B','u','r','s','t',' ','J','z','4','7','4','0',' ','b','o','o','t',' ','m','o','d','e',
/* 0x16a38 = "Shyh Shiun Terminals Co., Ltd" */
    'S','h','y','h',' ','S','h','i','u','n',' ','T','e','r','m','i','n','a','l','s',' ','\x0e','\x16',
/* 0x16a4f = "Union Power Information Industrial Co., Ltd" */
    'U','n','i','o','n',' ','\x24',' ','I','n','f','o','r','m','a','t','i','o','n',' ','\xef','\x0e','\x16',
/* 0x16a66 = "CG-WLUSB2GPX [Ralink RT2571W]" */
    'C','G','-','W','L','U','S','B','2','G','P','X',' ','[','\x93','R','T','2','5','7','1','W',']',
/* 0x16a7d = "EW-7718UN 802.11n Wireless Adapter [Ralink RT2870]" */
    'E','W','-','7','7','1','8','U','N',' ','\x99','\x01','\x02',' ','[','\x93','R','T','2','8','7','0',']',
/* 0x16a94 = "Reefangel Evolution 1.0" */
    'R','e','e','f','a','n','g','e','l',' ','E','v','o','l','u','t','i','o','n',' ','1','.','0',
/* 0x16aab = "USB Wireless 2.4GHz Wheel&Gamepad" */
    '\x0a',' ','\x01','2','.','4','G','H','z',' ','W','h','e','e','l','&','G','a','m','e','p','a','d',
/* 0x16ac2 = "Skywalker-CW3K DVB-S tuner" */
    'S','k','y','w','a','l','k','e','r','-','C','W','3','K',' ','\xa7','S',' ','t','u','n','e','r',
/* 0x16ad9 = "SuperPen WP3325U Tablet" */
    'S','u','p','e','r','P','e','n',' ','W','P','3','3','2','5','U',' ','T','a','b','l','e','t',
/* 0x16af0 = "DataTraveler Vault Privacy" */
    '\xe7','T','r','a','v','e','l','e','r',' ','V','a','u','l','t',' ','P','r','i','v','a','c','y',
/* 0x16b07 = "Granite Microsystems, Inc." */
    'G','r','a','n','i','t','e',' ','M','i','c','r','o','s','y','s','t','e','m','s',',',' ','\x07',
/* 0x16b1e = "DWA-111 802.11bg Wireless Adapter [Ralink RT2571W]" */
    'D','W','A','-','1','1','1',' ','\xad',' ','\x01','\x02',' ','[','\x93','R','T','2','5','7','1','W',']',
/* 0x16b35 = "Bluetooth 2.0 adapter 100m CN-521v2 001 " */
    '\x06',' ','\xc1','\xd0',' ','1','0','0','m',' ','C','N','-','5','2','1','v','2',' ','0','0','1',' ',
/* 0x16b4c = "Pelican Eclipse PL-2023" */
    'P','e','l','i','c','a','n',' ','E','c','l','i','p','s','e',' ','P','L','-','2','0','2','3',
/* 0x16b63 = "PX-404A [ME OFFICE 535]" */
    'P','X','-','4','0','4','A',' ','[','M','E',' ','O','F','F','I','C','E',' ','5','3','5',']',
/* 0x16b7a = "Aplux Communications, Ltd" */
    'A','p','l','u','x',' ','C','o','m','m','u','n','i','c','a','t','i','o','n','s',',',' ','\x16',
/* 0x16b91 = "PortGear to SCSI Converter" */
    '\x87','G','e','a','r',' ','t','o',' ','S','C','S','I',' ','C','o','n','v','e','r','t','e','r',
/* 0X16ba8 = "remote storage for P3 chip" */
    'e','m','o','t','e',' ','s','t','o','r','a','g','e',' ','\xcc','P','3',' ','c','h','i','p',
/* 0x16bbe = "Crescent Heart Software" */
    'C','r','e','s','c','e','n','t',' ','H','e','a','r','t',' ','S','o','f','t','w','a','r','e',
/* 0x16bd5 = "Genius Traveler 1000 Wireless Mouse" */
    'G','e','n','i','u','s',' ','T','r','a','v','e','l','e','r',' ','1','0','0','0',' ','\x01','\x0b',
/* 0x16bec = "PTZ-430 [Intuos3 (4x5)]" */
    'P','T','Z','-','4','3','0',' ','[','I','n','t','u','o','s','3',' ','(','4','x','5',')',']',
/* 0x16c03 = "GL620USB-A GeneLink USB-USB Bridge" */
    'G','L','6','2','0','\x0a','-','A',' ','G','e','n','e','L','i','n','k',' ','\x0a','-','\x0a',' ','\x9f',
/* 0x16c1a = "DSB-650 10Mbps Ethernet [klsi]" */
    'D','S','B','-','6','5','0',' ','1','0','M','b','p','s',' ','\x7f',' ','[','k','l','s','i',']',
/* 0x16c31 = "BTC 7932 mouse+keyboard" */
    'B','T','C',' ','7','9','3','2',' ','m','o','u','s','e','+','k','e','y','b','o','a','r','d',
/* 0x16c48 = "VNT VT6656 USB-802.11 Wireless LAN Adapter" */
    'V','N','T',' ','V','T','6','6','5','6',' ','\x0a','-','8','0','2','.','1','1',' ','\x01','\xf3','\x02',
/* 0x16c5f = "Singatron Enterprise Co., Ltd" */
    'S','i','n','g','a','t','r','o','n',' ','E','n','t','e','r','p','r','i','s','e',' ','\x0e','\x16',
/* 0x16c76 = "External Disk 2TB Model DT01ABA200" */
    '\xe3','\xe8',' ','2','T','B',' ','M','o','d','e','l',' ','D','T','0','1','A','B','A','2','0','0',
/* 0x16c8d = "MCS7830 10/100 Mbps Ethernet adapter" */
    'M','C','S','7','8','3','0',' ','1','0','/','1','0','0',' ','M','b','p','s',' ','\x7f',' ','\xd0',
/* 0x16ca4 = "PTZ-630 [Intuos3 (6x8)]" */
    'P','T','Z','-','6','3','0',' ','[','I','n','t','u','o','s','3',' ','(','6','x','8',')',']',
/* 0x16cbb = "Sony embedded vimicro Camera" */
    'S','o','n','y',' ','e','m','b','e','d','d','e','d',' ','v','i','m','i','c','r','o',' ','\x04',
/* 0x16cd2 = "Gigabyte U7100 DVB-T tuner" */
    'G','i','g','a','b','y','t','e',' ','U','7','1','0','0',' ','\xa7','T',' ','t','u','n','e','r',
/* 0x16ce9 = "Wing-Tech Enterprise Co., Ltd" */
    'W','i','n','g','-','T','e','c','h',' ','E','n','t','e','r','p','r','i','s','e',' ','\x0e','\x16',
/* 0x16d00 = "KONICA MINOLTA DG-4Wide" */
    'K','O','N','I','C','A',' ','M','I','N','O','L','T','A',' ','D','G','-','4','W','i','d','e',
/* 0x16d17 = "Prolink Winscan Pro 2448U" */
    'P','r','o','l','i','n','k',' ','W','i','n','s','c','a','n',' ','\x8f',' ','2','4','4','8','U',
/* 0x16d2e = "GoGear RaGa (SA1942/02)" */
    'G','o','G','e','a','r',' ','R','a','G','a',' ','(','S','A','1','9','4','2','/','0','2',')',
/* 0x16d45 = "Dimage X50 Camera [storage?]" */
    'D','i','m','a','g','e',' ','X','5','0',' ','\x04',' ','[','s','t','o','r','a','g','e','?',']',
/* 0x16d5c = "WUBR-208N 802.11abgn Wireless Adapter [Ralink RT2870]" */
    'W','U','B','R','-','2','0','8','N',' ','\xea','\x01','\x02',' ','[','\x93','R','T','2','8','7','0',']',
/* 0x16d73 = "PT-7600 P-touch Label Printer" */
    'P','T','-','7','6','0','0',' ','P','-','t','o','u','c','h',' ','L','a','b','e','l',' ','\x0c',
/* 0x16d8a = "Nogatech TV! (NTSC) (A)" */
    'N','o','g','a','t','e','c','h',' ','T','V','!',' ','(','N','T','S','C',')',' ','(','A',')',
/* 0x16da1 = "Artec T1 USB TVBOX (warm)" */
    'A','r','t','e','c',' ','T','1',' ','\x0a',' ','T','V','B','O','X',' ','(','w','a','r','m',')',
/* 0x16db8 = "CY7C65640 USB-2.0 "TetraHub"" */
    'C','Y','7','C','6','5','6','4','0',' ','\x0a','-','\xc1','"','T','e','t','r','a','H','u','b','"',
/* 0x16dcf = "COMmander Basic.2 (PBX)" */
    'C','O','M','m','a','n','d','e','r',' ','B','a','s','i','c','.','2',' ','(','P','B','X',')',
/* 0x16de6 = "2045 Bluetooth 2.0 Device with trace filter" */
    '2','0','4','5',' ','\x06',' ','\xc1','\x03',' ','\x98','t','r','a','c','e',' ','f','i','l','t','e','r',
/* 0x16dfd = "WL-321 Wireless USB Gaming Adapter 300N" */
    'W','L','-','3','2','1',' ','\x01','\x0a',' ','G','a','m','i','n','g',' ','\x02',' ','3','0','0','N',
/* 0x16e14 = "DOME imaging systems, Inc." */
    'D','O','M','E',' ','i','m','a','g','i','n','g',' ','s','y','s','t','e','m','s',',',' ','\x07',
/* 0x16e2b = "Mass Storage Controller(0D8C,5200)" */
    '\x7c','\x0f','C','o','n','t','r','o','l','l','e','r','(','0','D','8','C',',','5','2','0','0',')',
/* 0x16e42 = "Argos Mini II Smart Card Reader (CCID)" */
    'A','r','g','o','s',' ','\xb9',' ','I','I',' ','\x12',' ','\x15',' ','\x08',' ','(','C','C','I','D',')',
/* 0x16e59 = "PowerShot ELPH 110 HS / IXUS 125 HS" */
    '\x24','\x84','E','L','P','H',' ','1','1','0',' ','H','S',' ','/',' ','\xfd','1','2','5',' ','H','S',
/* 0x16e70 = "CG-WLUSB2GS 802.11bg [Atheros AR5523]" */
    'C','G','-','W','L','U','S','B','2','G','S',' ','\xad',' ','[','\xaf','A','R','5','5','2','3',']',
/* 0x16e87 = "MPEG-2 Capture Device (E882)" */
    'M','P','E','G','-','2',' ','C','a','p','t','u','r','e',' ','\x03',' ','(','E','8','8','2',')',
/* 0x16e9e = "Bluetooth Multiport Module by Compaq" */
    '\x06',' ','M','u','l','t','i','p','o','r','t',' ','\xe5',' ','b','y',' ','C','o','m','p','a','q',
/* 0x16eb5 = "PCVC740K ToUcam Pro [pwc]" */
    'P','C','V','C','7','4','0','K',' ','T','o','U','c','a','m',' ','\x8f',' ','[','p','w','c',']',
/* 0x16ecc = "K4JRG Ham Radio devices" */
    'K','4','J','R','G',' ','H','a','m',' ','R','a','d','i','o',' ','d','e','v','i','c','e','s',
/* 0x16ee3 = "Asus Integrated Bluetooth module [AR3011]" */
    'A','s','u','s',' ','\x18','\x06',' ','m','o','d','u','l','e',' ','[','A','R','3','0','1','1',']',
/* 0x16efa = "Vista Plus cam [VF0090]" */
    'V','i','s','t','a',' ','P','l','u','s',' ','c','a','m',' ','[','V','F','0','0','9','0',']',
/* 0x16f11 = "Digital Voice Recorder DS-7000" */
    '\x09','V','o','i','c','e',' ','R','e','c','o','r','d','e','r',' ','D','S','-','7','0','0','0',
/* 0x16f28 = "Jing-Mold Enterprise Co., Ltd" */
    'J','i','n','g','-','M','o','l','d',' ','E','n','t','e','r','p','r','i','s','e',' ','\x0e','\x16',
/* 0x16f3f = "SPEED WHEEL 3 Vibration" */
    'S','P','E','E','D',' ','W','H','E','E','L',' ','3',' ','V','i','b','r','a','t','i','o','n',
/* 0x16f56 = "model 01 WiFi interface" */
    'm','o','d','e','l',' ','0','1',' ','W','i','F','i',' ','i','n','t','e','r','f','a','c','e',
/* 0x16f6d = "Palladia 300/400 Adsl Modem" */
    'P','a','l','l','a','d','i','a',' ','3','0','0','/','4','0','0',' ','A','d','s','l',' ','\x1c',
/* 0x16f84 = "PowerShot ELPH 320 HS / IXUS 240 HS" */
    '\x24','\x84','E','L','P','H',' ','3','2','0',' ','H','S',' ','/',' ','\xfd','2','4','0',' ','H','S',
/* 0x16f9b = "A789 (PTP mode, with debug)" */
    'A','7','8','9',' ','(','P','T','P',' ','m','o','d','e',',',' ','\x98','d','e','b','u','g',')',
/* 0x16fb2 = "Sony Ericsson XPERIA X1" */
    'S','o','n','y',' ','E','r','i','c','s','s','o','n',' ','X','P','E','R','I','A',' ','X','1',
/* 0x16fc9 = "LUFA Mouse Demo Application" */
    'L','U','F','A',' ','\x0b',' ','D','e','m','o',' ','A','p','p','l','i','c','a','t','i','o','n',
/* 0x16fe0 = "ATI Remote Wonder II Input Device" */
    'A','T','I',' ','\xcb',' ','W','o','n','d','e','r',' ','I','I',' ','I','n','p','u','t',' ','\x03',
/* 0x16ff7 = "GD-0912 [Intuos (9x12)]" */
    'G','D','-','0','9','1','2',' ','[','I','n','t','u','o','s',' ','(','9','x','1','2',')',']',
/* 0x1700e = "TT-3750 BGAN-XL Radio Module" */
    'T','T','-','3','7','5','0',' ','B','G','A','N','-','X','L',' ','R','a','d','i','o',' ','\xe5',
/* 0x17025 = "Mitsubishi Electronics America, Inc." */
    'M','i','t','s','u','b','i','s','h','i',' ','\x1b',' ','A','m','e','r','i','c','a',',',' ','\x07',
/* 0x1703c = "FT2232 JTAG ICE [gnICE]" */
    'F','T','2','2','3','2',' ','J','T','A','G',' ','I','C','E',' ','[','g','n','I','C','E',']',
/* 0x17053 = "Bluetooth Device(BC04-External)" */
    '\x06',' ','D','e','v','i','c','e','(','B','C','0','4','-','E','x','t','e','r','n','a','l',')',
/* 0x1706a = "301 Dual SIM (Mass Storage)" */
    '3','0','1',' ','D','u','a','l',' ','S','I','M',' ','(','\x7c','S','t','o','r','a','g','e',')',
/* 0x17081 = "X-718BK Oscar Optical Gaming Mouse" */
    'X','-','7','1','8','B','K',' ','O','s','c','a','r',' ','\x7b','G','a','m','i','n','g',' ','\x0b',
/* 0x17098 = "CompactFlash & Microdrive Reader" */
    'C','o','m','p','a','c','t','\x3c',' ','&',' ','M','i','c','r','o','d','r','i','v','e',' ','\x08',
/* 0x170af = "DK2108SZ Keyboard [Ducky Zero]" */
    'D','K','2','1','0','8','S','Z',' ','\x05',' ','[','D','u','c','k','y',' ','Z','e','r','o',']',
/* 0x170c6 = "Vengeance K70R keyboard" */
    'V','e','n','g','e','a','n','c','e',' ','K','7','0','R',' ','k','e','y','b','o','a','r','d',
/* 0x170dd = "VKI-A Fingerprint Sensor/Flash Storage (dumb)" */
    'V','K','I','-','A',' ','\x92','S','e','n','s','o','r','/','\x3c',' ','\x0f','(','d','u','m','b',')',
/* 0x170f4 = "Serial cable (v2) for TD-10 Mobile Phone" */
    '\x90',' ','c','a','b','l','e',' ','(','v','2',')',' ','\xcc','T','D','-','1','0',' ','\x96',' ','\x19',
/* 0x1710b = "TSAM-004 Presentation Remote" */
    'T','S','A','M','-','0','0','4',' ','P','r','e','s','e','n','t','a','t','i','o','n',' ','\xcb',
/* 0x17122 = "Fritz!WLAN N [Atheros AR9001U]" */
    'F','r','i','t','z','!','W','L','A','N',' ','N',' ','[','\xaf','A','R','9','0','0','1','U',']',
/* 0x17139 = "Optronic Laboratories Inc." */
    'O','p','t','r','o','n','i','c',' ','L','a','b','o','r','a','t','o','r','i','e','s',' ','\x07',
/* 0x17150 = "Ex-Series UVC and MSD interface" */
    'E','x','-','\xbf',' ','U','V','C',' ','\xe4','M','S','D',' ','i','n','t','e','r','f','a','c','e',
/* 0x17167 = "tibounise ADB converter" */
    't','i','b','o','u','n','i','s','e',' ','A','D','B',' ','c','o','n','v','e','r','t','e','r',
/* 0x1717e = "MCS7832 10/100 Mbps Ethernet adapter" */
    'M','C','S','7','8','3','2',' ','1','0','/','1','0','0',' ','M','b','p','s',' ','\x7f',' ','\xd0',
/* 0x17195 = "X70/X73 Scan/Print/Copy" */
    'X','7','0','/','X','7','3',' ','S','c','a','n','/','P','r','i','n','t','/','C','o','p','y',
/* 0x171ac = "Meyer Instruments (MIS)" */
    'M','e','y','e','r',' ','I','n','s','t','r','u','m','e','n','t','s',' ','(','M','I','S',')',
/* 0x171c3 = "Nippon Systems Development Co., Ltd" */
    'N','i','p','p','o','n',' ','\xa6',' ','D','e','v','e','l','o','p','m','e','n','t',' ','\x0e','\x16',
/* 0x171da = "Catalyst Enterprises, Inc." */
    'C','a','t','a','l','y','s','t',' ','E','n','t','e','r','p','r','i','s','e','s',',',' ','\x07',
/* 0x171f1 = "Crossam2+USB IR commander" */
    'C','r','o','s','s','a','m','2','+','\x0a',' ','I','R',' ','c','o','m','m','a','n','d','e','r',
/* 0x17208 = "FRITZ!Box Fon (Annex A)" */
    'F','R','I','T','Z','!','B','o','x',' ','F','o','n',' ','(','A','n','n','e','x',' ','A',')',
/* 0x1721f = "TEW-444UB EU [TRENDnet]" */
    'T','E','W','-','4','4','4','U','B',' ','E','U',' ','[','T','R','E','N','D','n','e','t',']',
/* 0x17236 = "Belkin Components [hex]" */
    'B','e','l','k','i','n',' ','C','o','m','p','o','n','e','n','t','s',' ','[','h','e','x',']',
/* 0x1724d = "chaosfield.at AVR-Ruler" */
    'c','h','a','o','s','f','i','e','l','d','.','a','t',' ','A','V','R','-','R','u','l','e','r',
/* 0x17264 = "USB-4761 Portable Data Acquisition Module" */
    '\x0a','-','4','7','6','1',' ','\xa9','\xe7',' ','A','c','q','u','i','s','i','t','i','o','n',' ','\xe5',
/* 0x1727b = "FireStorm Dual Analog 2" */
    'F','i','r','e','S','t','o','r','m',' ','D','u','a','l',' ','A','n','a','l','o','g',' ','2',
/* 0x17292 = "MSP-FET430UIF JTAG Tool" */
    'M','S','P','-','F','E','T','4','3','0','U','I','F',' ','J','T','A','G',' ','T','o','o','l',
/* 0x172a9 = "Portstation Dual PS/2 Port" */
    'P','o','r','t','s','t','a','t','i','o','n',' ','D','u','a','l',' ','P','S','/','2',' ','\x87',
/* 0x172c0 = "Bitcoin Wallet [TREZOR]" */
    'B','i','t','c','o','i','n',' ','W','a','l','l','e','t',' ','[','T','R','E','Z','O','R',']',
/* 0x172d7 = "Motorola 802.11n Dualband USB Wireless Adapter" */
    'M','o','t','o','r','o','l','a',' ','\x99','D','u','a','l','b','a','n','d',' ','\x0a',' ','\x01','\x02',
/* 0x172ee = "C\'s Glory Enterprise Co., Ltd" */
    'C','\'','s',' ','G','l','o','r','y',' ','E','n','t','e','r','p','r','i','s','e',' ','\x0e','\x16',
/* 0x17305 = "ConvertX TV402U XLOADER" */
    'C','o','n','v','e','r','t','X',' ','T','V','4','0','2','U',' ','X','L','O','A','D','E','R',
/* 0x1731c = "JT-P100MR-20 [ePassport Reader]" */
    'J','T','-','P','1','0','0','M','R','-','2','0',' ','[','e','\xd5','R','e','a','d','e','r',']',
/* 0x17333 = "MPR Serial Preloader (MPRQI)" */
    'M','P','R',' ','\x90',' ','P','r','e','l','o','a','d','e','r',' ','(','M','P','R','Q','I',')',
/* 0x1734a = "Nogatech TV! Pro (PAL-I+)" */
    'N','o','g','a','t','e','c','h',' ','T','V','!',' ','\x8f',' ','(','P','A','L','-','I','+',')',
/* 0x17361 = "Supra Express 56K modem" */
    'S','u','p','r','a',' ','E','x','p','r','e','s','s',' ','5','6','K',' ','m','o','d','e','m',
/* 0x17378 = "counterfeit flash drive" */
    'c','o','u','n','t','e','r','f','e','i','t',' ','f','l','a','s','h',' ','d','r','i','v','e',
/* 0x1738f = "Uni-Trend Group Limited" */
    'U','n','i','-','T','r','e','n','d',' ','G','r','o','u','p',' ','L','i','m','i','t','e','d',
/* 0x173a6 = "USB 2.0 Multislot Card Reader/Writer" */
    '\x0a',' ','\xc1','M','u','l','t','i','s','l','o','t',' ','\x15',' ','R','e','a','d','e','r','/','\xdf',
/* 0x173bd = "WingMan Gamepad Extreme" */
    'W','i','n','g','M','a','n',' ','G','a','m','e','p','a','d',' ','E','x','t','r','e','m','e',
/* 0x173d4 = "Leonardo (CDC ACM, HID)" */
    'L','e','o','n','a','r','d','o',' ','(','C','D','C',' ','A','C','M',',',' ','H','I','D',')',
/* 0x173eb = "GM360/GD510/GW520/KP501" */
    'G','M','3','6','0','/','G','D','5','1','0','/','G','W','5','2','0','/','K','P','5','0','1',
/* 0x17402 = "FT232RL [RTS05 Serial Cable]" */
    'F','T','2','3','2','R','L',' ','[','R','T','S','0','5',' ','\x90',' ','C','a','b','l','e',']',
/* 0x17419 = "Predator TH 400 Gamepad" */
    'P','r','e','d','a','t','o','r',' ','T','H',' ','4','0','0',' ','G','a','m','e','p','a','d',
/* 0x17430 = "Samsung SE-T084M DVD-RW" */
    'S','a','m','s','u','n','g',' ','S','E','-','T','0','8','4','M',' ','D','V','D','-','R','W',
/* 0x17447 = "CY7C63001 R100 FM Radio" */
    'C','Y','7','C','6','3','0','0','1',' ','R','1','0','0',' ','F','M',' ','R','a','d','i','o',
/* 0x1745e = "PC Camera (SN9C201 + S5K53BEB)" */
    '\x1f','\x04',' ','(','S','N','9','C','2','0','1',' ','+',' ','S','5','K','5','3','B','E','B',')',
/* 0x17475 = "Dazzle USBVision (1006)" */
    'D','a','z','z','l','e',' ','U','S','B','V','i','s','i','o','n',' ','(','1','0','0','6',')',
/* 0x1748c = "Nogatech TV! (NTSC) (T)" */
    'N','o','g','a','t','e','c','h',' ','T','V','!',' ','(','N','T','S','C',')',' ','(','T',')',
/* 0x174a3 = "PowerShot ELPH 330 HS / IXUS 255 HS" */
    '\x24','\x84','E','L','P','H',' ','3','3','0',' ','H','S',' ','/',' ','\xfd','2','5','5',' ','H','S',
/* 0x174ba = "ME 200 [Stylus CX2800/CX2900]" */
    'M','E',' ','2','0','0',' ','[','\xb1','C','X','2','8','0','0','/','C','X','2','9','0','0',']',
/* 0x174d1 = "PowerShot ELPH 520 HS / IXUS 500 HS" */
    '\x24','\x84','E','L','P','H',' ','5','2','0',' ','H','S',' ','/',' ','\xfd','5','0','0',' ','H','S',
/* 0x174e8 = "Adesso/Kbtek America, Inc." */
    'A','d','e','s','s','o','/','K','b','t','e','k',' ','A','m','e','r','i','c','a',',',' ','\x07',
/* 0x174ff = "Minolta DiMAGE A2 (ptp)" */
    'M','i','n','o','l','t','a',' ','D','i','M','A','G','E',' ','A','2',' ','(','p','t','p',')',
/* 0x17516 = "ECON Data acquisition unit" */
    'E','C','O','N',' ','\xe7',' ','a','c','q','u','i','s','i','t','i','o','n',' ','u','n','i','t',
/* 0x1752d = "SP2 Spectrometer (VISA)" */
    'S','P','2',' ','S','p','e','c','t','r','o','m','e','t','e','r',' ','(','V','I','S','A',')',
/* 0x17544 = "SD card reader (UB6225)" */
    'S','D',' ','c','a','r','d',' ','r','e','a','d','e','r',' ','(','U','B','6','2','2','5',')',
/* 0x1755b = "T5 PATA forensic bridge" */
    'T','5',' ','P','A','T','A',' ','f','o','r','e','n','s','i','c',' ','b','r','i','d','g','e',
/* 0x17572 = "HP Truevision HD camera" */
    'H','P',' ','T','r','u','e','v','i','s','i','o','n',' ','H','D',' ','c','a','m','e','r','a',
/* 0x17589 = "Live! Cam Chat HD [VF0700]" */
    'L','i','v','e','!',' ','\x9a','C','h','a','t',' ','H','D',' ','[','V','F','0','7','0','0',']',
/* 0x175a0 = "GW-US300MiniW 802.11bgn Wireless Adapter" */
    'G','W','-','U','S','3','0','0','\xb9','W',' ','8','0','2','.','1','1','b','g','n',' ','\x01','\x02',
/* 0x175b7 = "Personal Jukebox PJB100" */
    'P','e','r','s','o','n','a','l',' ','J','u','k','e','b','o','x',' ','P','J','B','1','0','0',
/* 0x175ce = "Sveon STV22 DVB-T [af9015]" */
    'S','v','e','o','n',' ','S','T','V','2','2',' ','\xa7','T',' ','[','a','f','9','0','1','5',']',
/* 0x175e5 = "GT-9300UF [Perfection 2400 PHOTO]" */
    'G','T','-','9','3','0','0','U','F',' ','[','\xf0','2','4','0','0',' ','P','H','O','T','O',']',
/* 0x175fc = "FEther USB-TX Ethernet [pegasus]" */
    'F','E','t','h','e','r',' ','\x0a','-','T','X',' ','\x7f',' ','[','p','e','g','a','s','u','s',']',
/* 0x17613 = "SD card reader (UB6250)" */
    'S','D',' ','c','a','r','d',' ','r','e','a','d','e','r',' ','(','U','B','6','2','5','0',')',
/* 0x1762a = "IO-Warrior 24 Power Vampire" */
    'I','O','-','W','a','r','r','i','o','r',' ','2','4',' ','\x24',' ','V','a','m','p','i','r','e',
/* 0x17641 = "Rhythmedics HID Bootloader" */
    'R','h','y','t','h','m','e','d','i','c','s',' ','\xf2','B','o','o','t','l','o','a','d','e','r',
/* 0x17658 = "TCR51USB IRIG Time Code Reader" */
    'T','C','R','5','1','\x0a',' ','I','R','I','G',' ','T','i','m','e',' ','C','o','d','e',' ','\x08',
/* 0x1766f = "CVA122E Cable Voice Adapter (WDM)" */
    'C','V','A','1','2','2','E',' ','\xa5',' ','V','o','i','c','e',' ','\x02',' ','(','W','D','M',')',
/* 0x17686 = "E2530 Phone (Samsung Kies mode)" */
    'E','2','5','3','0',' ','\x19',' ','(','S','a','m','s','u','n','g',' ','K','i','e','s',' ','\x1a',
/* 0x1769d = "Artec T1 USB TVBOX (cold)" */
    'A','r','t','e','c',' ','T','1',' ','\x0a',' ','T','V','B','O','X',' ','(','c','o','l','d',')',
/* 0x176b4 = "UPort 1610-8 8-Port RS-232" */
    'U','P','o','r','t',' ','1','6','1','0','-','8',' ','8','-','\x87',' ','R','S','-','2','3','2',
/* 0x176cb = "Concord 3045 spca536a Camera" */
    'C','o','n','c','o','r','d',' ','3','0','4','5',' ','s','p','c','a','5','3','6','a',' ','\x04',
/* 0x176e2 = "Fingerprint Scanner (After ReNumeration)" */
    '\x92','\x25',' ','(','A','f','t','e','r',' ','R','e','N','u','m','e','r','a','t','i','o','n',')',
/* 0x176f9 = "Photosmart Premium C309" */
    'P','h','o','t','o','s','m','a','r','t',' ','P','r','e','m','i','u','m',' ','C','3','0','9',
/* 0x17710 = "Man Boon Manufactory, Ltd" */
    'M','a','n',' ','B','o','o','n',' ','M','a','n','u','f','a','c','t','o','r','y',',',' ','\x16',
/* 0x17727 = "GT-8300UF [Perfection 1660 PHOTO]" */
    'G','T','-','8','3','0','0','U','F',' ','[','\xf0','1','6','6','0',' ','P','H','O','T','O',']',
/* 0x1773e = "ChipKit Pro MX7 (PIC32MX)" */
    'C','h','i','p','K','i','t',' ','\x8f',' ','M','X','7',' ','(','P','I','C','3','2','M','X',')',
/* 0x17755 = "MSO1300 Fingerprint Sensor [MSO1300-V3]" */
    'M','S','O','1','3','0','0',' ','\x92','\xac',' ','[','M','S','O','1','3','0','0','-','V','3',']',
/* 0x1776c = "GameBoy Advance Capture" */
    'G','a','m','e','B','o','y',' ','A','d','v','a','n','c','e',' ','C','a','p','t','u','r','e',
/* 0x17783 = "MPEG-2 Capture Device (M038)" */
    'M','P','E','G','-','2',' ','C','a','p','t','u','r','e',' ','\x03',' ','(','M','0','3','8',')',
/* 0x1779a = "Dongguan Guanshang Electronics Co., Ltd." */
    'D','o','n','g','g','u','a','n',' ','G','u','a','n','s','h','a','n','g',' ','\x1b',' ','\x0e','\xab',
/* 0x177b1 = "Lenovo IdeaCentre Web Camera" */
    'L','e','n','o','v','o',' ','I','d','e','a','C','e','n','t','r','e',' ','W','e','b',' ','\x04',
/* 0x177c8 = "Firestorm Dual Analog 3" */
    'F','i','r','e','s','t','o','r','m',' ','D','u','a','l',' ','A','n','a','l','o','g',' ','3',
/* 0x177df = "Fastrack Xtend FXT001 Modem" */
    'F','a','s','t','r','a','c','k',' ','X','t','e','n','d',' ','F','X','T','0','0','1',' ','\x1c',
/* 0x177f6 = "CVA124E Cable Voice Adapter (WDM)" */
    'C','V','A','1','2','4','E',' ','\xa5',' ','V','o','i','c','e',' ','\x02',' ','(','W','D','M',')',
/* 0x1780d = "Bluetooth Adapter class 1 [BlueLight]" */
    '\x06',' ','\x02',' ','c','l','a','s','s',' ','1',' ','[','B','l','u','e','L','i','g','h','t',']',
/* 0x17824 = "PTK-640 [Intuos4 (6x9)]" */
    'P','T','K','-','6','4','0',' ','[','I','n','t','u','o','s','4',' ','(','6','x','9',')',']',
/* 0x1783b = "WDM Still Image Capture" */
    'W','D','M',' ','S','t','i','l','l',' ','I','m','a','g','e',' ','C','a','p','t','u','r','e',
/* 0x17852 = "Media Phonics (Suisse) S.A." */
    '\xa1',' ','P','h','o','n','i','c','s',' ','(','S','u','i','s','s','e',')',' ','S','.','A','.',
/* 0x17869 = "Xperia Ion [Debug Mode]" */
    'X','p','e','r','i','a',' ','I','o','n',' ','[','D','e','b','u','g',' ','M','o','d','e',']',
/* 0x17880 = "PowerShot ELPH 310 HS / IXUS 230 HS" */
    '\x24','\x84','E','L','P','H',' ','3','1','0',' ','H','S',' ','/',' ','\xfd','2','3','0',' ','H','S',
/* 0x17897 = "Bluetooth Controller from (Ericsson P4A)" */
    '\x06',' ','\x13',' ','f','r','o','m',' ','(','E','r','i','c','s','s','o','n',' ','P','4','A',')',
/* 0x178ae = "Dino-Lite Pro Digital Microscope" */
    'D','i','n','o','-','L','i','t','e',' ','\x8f',' ','\x09','M','i','c','r','o','s','c','o','p','e',
/* 0x178c5 = "Dongle with BlueCore in DFU mode" */
    '\xf4',' ','\x98','B','l','u','e','C','o','r','e',' ','i','n',' ','D','F','U',' ','m','o','d','e',
/* 0x178dc = "SureConnect ADSL Ethernet/USB Router" */
    'S','u','r','e','\xee','\xf1','E','t','h','e','r','n','e','t','/','\x0a',' ','R','o','u','t','e','r',
/* 0x178f3 = "DashDrive Elite HE720 500GB" */
    'D','a','s','h','\x14',' ','E','l','i','t','e',' ','H','E','7','2','0',' ','5','0','0','G','B',
/* 0x1790a = "Turbolink UB801R WLAN Adapter" */
    'T','u','r','b','o','l','i','n','k',' ','U','B','8','0','1','R',' ','W','L','A','N',' ','\x02',
/* 0x17921 = "Nexus 4/5/7/10 (tether)" */
    'N','e','x','u','s',' ','4','/','5','/','7','/','1','0',' ','(','t','e','t','h','e','r',')',
/* 0x17938 = "CyMotion Master Solar Keyboard" */
    'C','y','M','o','t','i','o','n',' ','M','a','s','t','e','r',' ','S','o','l','a','r',' ','\x05',
/* 0x1794f = "Thesys Microelectronics" */
    'T','h','e','s','y','s',' ','M','i','c','r','o','e','l','e','c','t','r','o','n','i','c','s',
/* 0x17966 = "UB1 boundary microphone" */
    'U','B','1',' ','b','o','u','n','d','a','r','y',' ','m','i','c','r','o','p','h','o','n','e',
/* 0x1797d = "Telex Communications, Inc." */
    'T','e','l','e','x',' ','C','o','m','m','u','n','i','c','a','t','i','o','n','s',',',' ','\x07',
/* 0x17994 = "Mini DisplayPort to Dual-Link DVI Adapter" */
    '\xb9',' ','\xcf','\x87',' ','t','o',' ','D','u','a','l','-','L','i','n','k',' ','D','V','I',' ','\x02',
/* 0x179ab = "ITRAN Communications, Ltd" */
    'I','T','R','A','N',' ','C','o','m','m','u','n','i','c','a','t','i','o','n','s',',',' ','\x16',
/* 0x179c2 = "Mini Swipe Reader (Keyboard Emulation)" */
    '\xb9',' ','S','w','i','p','e',' ','\x08',' ','(','\x05',' ','E','m','u','l','a','t','i','o','n',')',
/* 0x179d9 = "MassWorks ID-75 TouchScreen" */
    'M','a','s','s','W','o','r','k','s',' ','I','D','-','7','5',' ','\x9d','S','c','r','e','e','n',
/* 0x179f0 = "Trident Microsystems, Inc." */
    'T','r','i','d','e','n','t',' ','M','i','c','r','o','s','y','s','t','e','m','s',',',' ','\x07',
/* 0x17a07 = "PC98 Series Layout Keyboard with Bus-Powered Hub" */
    'P','C','9','8',' ','\xbf',' ','L','a','y','o','u','t',' ','\x05',' ','\x98','B','u','s','-','\x85','\xa4',
/* 0x17a1e = "Swissmemory cirrusWHITE" */
    'S','w','i','s','s','m','e','m','o','r','y',' ','c','i','r','r','u','s','W','H','I','T','E',
/* 0x17a35 = "MSO350/MSO351 Fingerprint Sensor & SmartCard Reader" */
    'M','S','O','3','5','0','/','M','S','O','3','5','1',' ','\x92','\xac',' ','&',' ','\x12','\x15',' ','\x08',
/* 0x17a4c = "netMod Driver Ver 2.4 (CAPI)" */
    'n','e','t','M','o','d',' ','\xde',' ','V','e','r',' ','2','.','4',' ','(','C','A','P','I',')',
/* 0x17a63 = "PowerShot ELPH 340 HS / IXUS 265 HS" */
    '\x24','\x84','E','L','P','H',' ','3','4','0',' ','H','S',' ','/',' ','\xfd','2','6','5',' ','H','S',
/* 0x17a7a = "PM320E Optical Power and Energy Meter" */
    'P','M','3','2','0','E',' ','\x7b','\x24',' ','\xe4','E','n','e','r','g','y',' ','M','e','t','e','r',
/* 0x17a91 = "Nexus 4/5 (PTP + debug)" */
    'N','e','x','u','s',' ','4','/','5',' ','(','P','T','P',' ','+',' ','d','e','b','u','g',')',
/* 0x17aa8 = "Virtual keyboard and mouse" */
    'V','i','r','t','u','a','l',' ','k','e','y','b','o','a','r','d',' ','\xe4','m','o','u','s','e',
/* 0x17abf = "MCS7705 Parallel port adapter" */
    'M','C','S','7','7','0','5',' ','P','a','r','a','l','l','e','l',' ','p','o','r','t',' ','\xd0',
/* 0x17ad6 = "United Technologies Research Cntr." */
    'U','n','i','t','e','d',' ','\x88',' ','R','e','s','e','a','r','c','h',' ','C','n','t','r','.',
/* 0x17aed = "PowerShot ELPH 500 HS / IXUS 310 HS" */
    '\x24','\x84','E','L','P','H',' ','5','0','0',' ','H','S',' ','/',' ','\xfd','3','1','0',' ','H','S',
/* 0x17b04 = "CX82310 ROM Boot Loader" */
    'C','X','8','2','3','1','0',' ','R','O','M',' ','B','o','o','t',' ','L','o','a','d','e','r',
/* 0x17b1b = "TCS1C EIM/STM32 Fingerprint sensor" */
    'T','C','S','1','C',' ','E','I','M','/','S','T','M','3','2',' ','\x92','s','e','n','s','o','r',
/* 0x17b32 = "jbmedia Light-Manager Pro" */
    'j','b','m','e','d','i','a',' ','L','i','g','h','t','-','M','a','n','a','g','e','r',' ','\x8f',
/* 0x17b49 = "ScienceScope Logbook HS" */
    'S','c','i','e','n','c','e','S','c','o','p','e',' ','L','o','g','b','o','o','k',' ','H','S',
/* 0x17b60 = "Wing-Span Enterprise Co., Ltd" */
    'W','i','n','g','-','S','p','a','n',' ','E','n','t','e','r','p','r','i','s','e',' ','\x0e','\x16',
/* 0x17b77 = "PowerShot ELPH 100 HS / IXUS 115 HS" */
    '\x24','\x84','E','L','P','H',' ','1','0','0',' ','H','S',' ','/',' ','\xfd','1','1','5',' ','H','S',
/* 0x17b8e = "AirPlus AG DWL-AG122 Wireless Adapter" */
    'A','i','r','P','l','u','s',' ','A','G',' ','D','W','L','-','A','G','1','2','2',' ','\x01','\x02',
/* 0x17ba5 = "M-U0007 [Corded Mouse M500]" */
    'M','-','U','0','0','0','7',' ','[','C','o','r','d','e','d',' ','\x0b',' ','M','5','0','0',']',
/* 0x17bbc = "Shenzhen Zhengerya Cable Co., Ltd." */
    'S','h','e','n','z','h','e','n',' ','Z','h','e','n','g','e','r','y','a',' ','\xa5',' ','\x0e','\xab',
/* 0x17bd3 = "VL701 SATA 3Gb/s bridge" */
    'V','L','7','0','1',' ','S','A','T','A',' ','3','G','b','/','s',' ','b','r','i','d','g','e',
/* 0x17bea = "Sound Blaster Digital Music SX" */
    'S','o','u','n','d',' ','B','l','a','s','t','e','r',' ','\x09','M','u','s','i','c',' ','S','X',
/* 0x17c01 = "Packet Service Diagnostic Serial Port (WDM)" */
    '\xe1','\xd7',' ','D','i','a','g','n','o','s','t','i','c',' ','\x90',' ','\x87',' ','(','W','D','M',')',
/* 0x17c18 = "Gigabyte U8000 DVB-T tuner" */
    'G','i','g','a','b','y','t','e',' ','U','8','0','0','0',' ','\xa7','T',' ','t','u','n','e','r',
/* 0x17c2f = "Pathway Connectivity, Inc." */
    'P','a','t','h','w','a','y',' ','C','o','n','n','e','c','t','i','v','i','t','y',',',' ','\x07',
/* 0x17c46 = "4 port USB 1.1 hub UH-174" */
    '4',' ','p','o','r','t',' ','\x0a',' ','1','.','1',' ','h','u','b',' ','U','H','-','1','7','4',
/* 0x17c5d = "TRUST 380 USB2 SPACEC@M" */
    'T','R','U','S','T',' ','3','8','0',' ','U','S','B','2',' ','S','P','A','C','E','C','@','M',
/* 0X17c74 = "MARATON Power Supply System" */
    'A','R','A','T','O','N',' ','\x24',' ','S','u','p','p','l','y',' ','S','y','s','t','e','m',
/* 0x17c8a = "USA-18XA serial Adapter (no firmware)" */
    'U','S','A','-','1','8','X','A',' ','s','e','r','i','a','l',' ','\x02',' ','(','n','o',' ','\xdb',
/* 0x17ca1 = "PM300E Optical Power and Energy Meter" */
    'P','M','3','0','0','E',' ','\x7b','\x24',' ','\xe4','E','n','e','r','g','y',' ','M','e','t','e','r',
/* 0x17cb8 = "DC-104v2 ISDN Adapter [HFC-S]" */
    'D','C','-','1','0','4','v','2',' ','I','S','D','N',' ','\x02',' ','[','H','F','C','-','S',']',
/* 0x17ccf = "DTZ-1200W [Cintiq 12WX]" */
    'D','T','Z','-','1','2','0','0','W',' ','[','C','i','n','t','i','q',' ','1','2','W','X',']',
/* 0x17ce6 = "PC1267 [Powershot A470]" */
    'P','C','1','2','6','7',' ','[','P','o','w','e','r','s','h','o','t',' ','A','4','7','0',']',
/* 0x17cfd = "CX861xx ROM Boot Loader" */
    'C','X','8','6','1','x','x',' ','R','O','M',' ','B','o','o','t',' ','L','o','a','d','e','r',
/* 0x17d14 = "Xerox WorkCentre XK50cx" */
    'X','e','r','o','x',' ','W','o','r','k','C','e','n','t','r','e',' ','X','K','5','0','c','x',
/* 0x17d2b = "Creative Rhomba MP3 player" */
    'C','r','e','a','t','i','v','e',' ','R','h','o','m','b','a',' ','\x8e','p','l','a','y','e','r',
/* 0x17d42 = "Sound Blaster Digital Music LX" */
    'S','o','u','n','d',' ','B','l','a','s','t','e','r',' ','\x09','M','u','s','i','c',' ','L','X',
/* 0x17d59 = "PS/2 keyboard + mouse controller" */
    'P','S','/','2',' ','k','e','y','b','o','a','r','d',' ','+',' ','m','o','u','s','e',' ','\x9e',
/* 0x17d70 = "C5 Digital Media Camera (mass storage mode)" */
    'C','5',' ','\x09','\xa1',' ','\x04',' ','(','m','a','s','s',' ','s','t','o','r','a','g','e',' ','\x1a',
/* 0x17d87 = "Minolta Systems Laboratory, Inc." */
    'M','i','n','o','l','t','a',' ','\xa6',' ','L','a','b','o','r','a','t','o','r','y',',',' ','\x07',
/* 0x17d9e = "Minolta DiMAGE E201 Mass Storage Device" */
    'M','i','n','o','l','t','a',' ','D','i','M','A','G','E',' ','E','2','0','1',' ','\x7c','\x0f','\x03',
/* 0x17db5 = "Universal C64 Cartridge" */
    'U','n','i','v','e','r','s','a','l',' ','C','6','4',' ','C','a','r','t','r','i','d','g','e',
/* 0x17dcc = "OHCI Root Hub Simulation" */
    'O','H','C','I',' ','R','o','o','t',' ','\xa4',' ','S','i','m','u','l','a','t','i','o','n',
/* 0x17de2 = "Senselock SenseIV v2.x" */
    'S','e','n','s','e','l','o','c','k',' ','S','e','n','s','e','I','V',' ','v','2','.','x',
/* 0x17df8 = "Yakumo MegaImage 47 SL" */
    'Y','a','k','u','m','o',' ','M','e','g','a','I','m','a','g','e',' ','4','7',' ','S','L',
/* 0x17e0e = "Optical Mouse Opto 510D / OP-620D" */
    '\x7b','\x0b',' ','O','p','t','o',' ','5','1','0','D',' ','/',' ','O','P','-','6','2','0','D',
/* 0x17e24 = "WinFast DTV Dongle (cold state)" */
    'W','i','n','\xec','D','T','V',' ','\xf4',' ','(','c','o','l','d',' ','s','t','a','t','e',')',
/* 0x17e3a = "Acer/Lenovo Webcam [CN0316]" */
    'A','c','e','r','/','L','e','n','o','v','o',' ','\x11',' ','[','C','N','0','3','1','6',']',
/* 0x17e50 = "BMDC-2 IBM Bluetooth III w.56k" */
    'B','M','D','C','-','2',' ','I','B','M',' ','\x06',' ','I','I','I',' ','w','.','5','6','k',
/* 0x17e66 = "M-BT85 [UltraX Optical Mouse]" */
    'M','-','B','T','8','5',' ','[','U','l','t','r','a','X',' ','\x7b','M','o','u','s','e',']',
/* 0x17e7c = "iPod Nano 3.Gen (WTF mode)" */
    'i','P','o','d',' ','N','a','n','o',' ','3','.','G','e','n',' ','(','W','T','F',' ','\x1a',
/* 0x17e92 = "CTT-470 [Bamboo Touch]" */
    'C','T','T','-','4','7','0',' ','[','B','a','m','b','o','o',' ','T','o','u','c','h',']',
/* 0x17ea8 = "M-BJ58/M-BJ69 Optical Wheel Mouse" */
    'M','-','B','J','5','8','/','M','-','B','J','6','9',' ','\x7b','W','h','e','e','l',' ','\x0b',
/* 0x17ebe = "DepthSense 311 (Color)" */
    'D','e','p','t','h','S','e','n','s','e',' ','3','1','1',' ','(','C','o','l','o','r',')',
/* 0x17ed4 = "MT5634ZBA-USB MultiModemUSB (new firmware)" */
    'M','T','5','6','3','4','Z','B','A','-','\x0a',' ','\xd6','\x1c','\x0a',' ','(','n','e','w',' ','\xdb',
/* 0x17eea = "GraphLink [SilverLink]" */
    'G','r','a','p','h','L','i','n','k',' ','[','S','i','l','v','e','r','L','i','n','k',']',
/* 0x17f00 = "Gemstar eBook Group, Ltd" */
    'G','e','m','s','t','a','r',' ','e','B','o','o','k',' ','G','r','o','u','p',',',' ','\x16',
/* 0x17f16 = "NUB-350 802.11g Wireless Adapter [Intersil ISL3887]" */
    'N','U','B','-','3','5','0',' ','\x94','\x01','\x02',' ','[','\xb0','I','S','L','3','8','8','7',']',
/* 0x17f2c = "deRFusbSniffer Sub-GHz" */
    'd','e','R','F','u','s','b','S','n','i','f','f','e','r',' ','S','u','b','-','G','H','z',
/* 0x17f42 = "PC Camera (SN9C120 + SP80708)" */
    '\x1f','\x04',' ','(','S','N','9','C','1','2','0',' ','+',' ','S','P','8','0','7','0','8',')',
/* 0x17f58 = "OnSpec MMC/SD Reader/Writer" */
    'O','n','S','p','e','c',' ','M','M','C','/','S','D',' ','R','e','a','d','e','r','/','\xdf',
/* 0x17f6e = "Magician PocketPC SmartPhone / O2 XDA" */
    'M','a','g','i','c','i','a','n',' ','\x17','\x1f','\x12','\x19',' ','/',' ','O','2',' ','X','D','A',
/* 0X17f84 = "AE2500 802.11abgn Wireless Adapter [Broadcom BCM43236]" */
    'E','2','5','0','0',' ','\xea','\x01','\x02',' ','[','\xeb','B','C','M','4','3','2','3','6',']',
/* 0x17f99 = "Airlink Wireless Programming Interface" */
    'A','i','r','l','i','n','k',' ','\x01','P','r','o','g','r','a','m','m','i','n','g',' ','\x81',
/* 0x17faf = "Gryphon M100 Barcode Scanner" */
    'G','r','y','p','h','o','n',' ','M','1','0','0',' ','B','a','r','c','o','d','e',' ','\x25',
/* 0x17fc5 = "LCS1040 Speaker System" */
    'L','C','S','1','0','4','0',' ','S','p','e','a','k','e','r',' ','S','y','s','t','e','m',
/* 0x17fdb = "Yeti Stereo Microphone" */
    'Y','e','t','i',' ','S','t','e','r','e','o',' ','M','i','c','r','o','p','h','o','n','e',
/* 0x17ff1 = "Cheshire Engineering Corp." */
    'C','h','e','s','h','i','r','e',' ','E','n','g','i','n','e','e','r','i','n','g',' ','\x10',
/* 0x18007 = "XG-703A 802.11g Wireless Adapter [Intersil ISL3887]" */
    'X','G','-','7','0','3','A',' ','\x94','\x01','\x02',' ','[','\xb0','I','S','L','3','8','8','7',']',
/* 0x1801d = "Wing Key Electrical Co., Ltd" */
    'W','i','n','g',' ','K','e','y',' ','E','l','e','c','t','r','i','c','a','l',' ','\x0e','\x16',
/* 0x18033 = "CS780 Microphone Input" */
    'C','S','7','8','0',' ','M','i','c','r','o','p','h','o','n','e',' ','I','n','p','u','t',
/* 0x18049 = "PowerShot A310 / PowerShot A310 (PTP mode)" */
    '\x24','\x84','A','3','1','0',' ','/',' ','\x24','\x84','A','3','1','0',' ','(','P','T','P',' ','\x1a',
/* 0x1805f = "Foot Pedal/Thermometer" */
    'F','o','o','t',' ','P','e','d','a','l','/','T','h','e','r','m','o','m','e','t','e','r',
/* 0x18075 = "Satlab/AAUSAT3 BlueBox" */
    'S','a','t','l','a','b','/','A','A','U','S','A','T','3',' ','B','l','u','e','B','o','x',
/* 0x1808b = "Xsens serial converter" */
    'X','s','e','n','s',' ','s','e','r','i','a','l',' ','c','o','n','v','e','r','t','e','r',
/* 0x180a1 = "TS2GJF210 JetFlash 210 2GB" */
    'T','S','2','G','J','F','2','1','0',' ','J','e','t','\x3c',' ','2','1','0',' ','2','G','B',
/* 0x180b7 = "E353/E3131 (Mass storage mode)" */
    'E','3','5','3','/','E','3','1','3','1',' ','(','\x7c','s','t','o','r','a','g','e',' ','\x1a',
/* 0x180cd = "AT&T Go Phone U2800A phone" */
    'A','T','&','T',' ','G','o',' ','\x19',' ','U','2','8','0','0','A',' ','p','h','o','n','e',
/* 0x180e3 = "USB to PS2 Adaptor v1.09" */
    '\x0a',' ','t','o',' ','P','S','2',' ','A','d','a','p','t','o','r',' ','v','1','.','0','9',
/* 0x180f9 = "Sonix 1.3 MP Laptop Integrated Webcam" */
    'S','o','n','i','x',' ','1','.','3',' ','M','P',' ','L','a','p','t','o','p',' ','\x18','\x11',
/* 0x1810f = "WinFast TV - PAL BG+TXT + FM" */
    'W','i','n','\xec','\xda','-',' ','P','A','L',' ','B','G','+','T','X','T',' ','+',' ','F','M',
/* 0x18125 = "Plugable USB2-HDMI-165" */
    'P','l','u','g','a','b','l','e',' ','U','S','B','2','-','H','D','M','I','-','1','6','5',
/* 0x1813b = "DTZ-2100 [Cintiq 21UX]" */
    'D','T','Z','-','2','1','0','0',' ','[','C','i','n','t','i','q',' ','2','1','U','X',']',
/* 0x18151 = "Gryphon D120 Barcode Scanner" */
    'G','r','y','p','h','o','n',' ','D','1','2','0',' ','B','a','r','c','o','d','e',' ','\x25',
/* 0x18167 = "CTT-460 [Bamboo Touch]" */
    'C','T','T','-','4','6','0',' ','[','B','a','m','b','o','o',' ','T','o','u','c','h',']',
/* 0x1817d = "PPC900 Pinpad Terminal" */
    'P','P','C','9','0','0',' ','P','i','n','p','a','d',' ','T','e','r','m','i','n','a','l',
/* 0x18193 = "ADU120 Data Acquisition Interface" */
    'A','D','U','1','2','0',' ','\xe7',' ','A','c','q','u','i','s','i','t','i','o','n',' ','\x81',
/* 0x181a9 = "Xbox Adrenalin Gamepad" */
    'X','b','o','x',' ','A','d','r','e','n','a','l','i','n',' ','G','a','m','e','p','a','d',
/* 0x181bf = "RM-203 USB Nest [mode 1]" */
    'R','M','-','2','0','3',' ','\x0a',' ','N','e','s','t',' ','[','m','o','d','e',' ','1',']',
/* 0x181d5 = "Startek Engineering, Inc." */
    'S','t','a','r','t','e','k',' ','E','n','g','i','n','e','e','r','i','n','g',',',' ','\x07',
/* 0x181eb = "Technotrend/Hauppauge DEC2000-t" */
    'T','e','c','h','n','o','t','r','e','n','d','/','\xfb','D','E','C','2','0','0','0','-','t',
/* 0x18201 = "WinFast DTV Dongle (warm state)" */
    'W','i','n','\xec','D','T','V',' ','\xf4',' ','(','w','a','r','m',' ','s','t','a','t','e',')',
/* 0x18217 = "USA-19Q serial Adapter (no firmware)" */
    'U','S','A','-','1','9','Q',' ','s','e','r','i','a','l',' ','\x02',' ','(','n','o',' ','\xdb',
/* 0x1822d = "MFC9700 Port(FaxModem)" */
    'M','F','C','9','7','0','0',' ','P','o','r','t','(','F','a','x','M','o','d','e','m',')',
/* 0x18243 = "DVBSky S960C DVB-S2 tuner" */
    'D','V','B','S','k','y',' ','S','9','6','0','C',' ','\xa7','S','2',' ','t','u','n','e','r',
/* 0x18259 = "iPod Nano 3.Gen (DFU mode)" */
    'i','P','o','d',' ','N','a','n','o',' ','3','.','G','e','n',' ','(','D','F','U',' ','\x1a',
/* 0x1826f = "FreeAgent GoFlex USB 3.0" */
    'F','r','e','e','A','g','e','n','t',' ','G','o','F','l','e','x',' ','\x0a',' ','3','.','0',
/* 0x18285 = "Sierra MC5725 [ev2210]" */
    'S','i','e','r','r','a',' ','M','C','5','7','2','5',' ','[','e','v','2','2','1','0',']',
/* 0x1829b = "OZ776 CCID Smartcard Reader" */
    'O','Z','7','7','6',' ','C','C','I','D',' ','S','m','a','r','t','c','a','r','d',' ','\x08',
/* 0x182b1 = "USB-N10 802.11n Network Adapter [Realtek RTL8188SU]" */
    '\x0a','-','N','1','0',' ','\x99','\x8d','\x02',' ','[','\xbe','R','T','L','8','1','8','8','S','U',']',
/* 0x182c7 = "PhidgetWeightSensor Ver 1.0" */
    'P','h','i','d','g','e','t','W','e','i','g','h','t','\xac',' ','V','e','r',' ','1','.','0',
/* 0x182dd = "Panasonic (Matsushita)" */
    'P','a','n','a','s','o','n','i','c',' ','(','M','a','t','s','u','s','h','i','t','a',')',
/* 0x182f3 = "TiePieSCOPE HS805 (br)" */
    'T','i','e','P','i','e','S','C','O','P','E',' ','H','S','8','0','5',' ','(','b','r',')',
/* 0x18309 = "CmStick (article no. 1001)" */
    'C','m','\xb3',' ','(','a','r','t','i','c','l','e',' ','n','o','.',' ','1','0','0','1',')',
/* 0x1831f = "EM770W miniPCI WCDMA Modem" */
    'E','M','7','7','0','W',' ','m','i','n','i','P','C','I',' ','W','C','D','M','A',' ','\x1c',
/* 0x18335 = "Q1U dynamic microphone" */
    'Q','1','U',' ','d','y','n','a','m','i','c',' ','m','i','c','r','o','p','h','o','n','e',
/* 0x1834b = "ADU100 Data Acquisition Interface" */
    'A','D','U','1','0','0',' ','\xe7',' ','A','c','q','u','i','s','i','t','i','o','n',' ','\x81',
/* 0x18361 = "U10H010 802.11b Wireless Adapter [Intersil PRISM 3]" */
    'U','1','0','H','0','1','0',' ','\x9b','\x01','\x02',' ','[','\xb0','P','R','I','S','M',' ','3',']',
/* 0x18377 = "WinTV NOVA-T USB2 (cold)" */
    'W','i','n','\xda','N','O','V','A','-','T',' ','U','S','B','2',' ','(','c','o','l','d',')',
/* 0x1838d = "ShenZhen Litkconn Technology Co., Ltd." */
    'S','h','e','n','Z','h','e','n',' ','L','i','t','k','c','o','n','n',' ','\x0d',' ','\x0e','\xab',
/* 0x183a3 = "USR5420 802.11g Adapter [Broadcom 4320 USB]" */
    'U','S','R','5','4','2','0',' ','\x94','\x02',' ','[','\xeb','4','3','2','0',' ','U','S','B',']',
/* 0x183b9 = "MC70 Rugged Mobile Computer" */
    'M','C','7','0',' ','R','u','g','g','e','d',' ','\x96',' ','C','o','m','p','u','t','e','r',
/* 0x183cf = "Visual Communication Camera (PCGA-UVC10)" */
    'V','i','s','u','a','l',' ','\xe9','\x04',' ','(','P','C','G','A','-','U','V','C','1','0',')',
/* 0x183e5 = "SAM Axioquick recorder" */
    'S','A','M',' ','A','x','i','o','q','u','i','c','k',' ','r','e','c','o','r','d','e','r',
/* 0x183fb = "MStar Semiconductor, Inc." */
    'M','S','t','a','r',' ','S','e','m','i','c','o','n','d','u','c','t','o','r',',',' ','\x07',
/* 0x18411 = "eZ430 Development Tool" */
    'e','Z','4','3','0',' ','D','e','v','e','l','o','p','m','e','n','t',' ','T','o','o','l',
/* 0x18427 = "WL-182 Wireless-N Network USB Card" */
    'W','L','-','1','8','2',' ','W','i','r','e','l','e','s','s','-','N',' ','\x8d','\x0a',' ','\x15',
/* 0x1843d = "Arduino Mega 2560 Rev3" */
    'A','r','d','u','i','n','o',' ','M','e','g','a',' ','2','5','6','0',' ','R','e','v','3',
/* 0x18453 = "HD2-14 [Hero 2 Camera]" */
    'H','D','2','-','1','4',' ','[','H','e','r','o',' ','2',' ','C','a','m','e','r','a',']',
/* 0x18469 = "WL-172 Wireless Network USB Adapter 54g Turbo" */
    'W','L','-','1','7','2',' ','\x01','\x8d','\x0a',' ','\x02',' ','5','4','g',' ','T','u','r','b','o',
/* 0x1847f = "ScreenCoder UR7HCTS2-USB" */
    'S','c','r','e','e','n','C','o','d','e','r',' ','U','R','7','H','C','T','S','2','-','\x0a',
/* 0x18495 = "Innostor Technology Corporation" */
    'I','n','n','o','s','t','o','r',' ','\x0d',' ','C','o','r','p','o','r','a','t','i','o','n',
/* 0x184ab = "WL-352 802.11n Adapter [Realtek RTL8191SU]" */
    'W','L','-','3','5','2',' ','\x99','\x02',' ','[','\xbe','R','T','L','8','1','9','1','S','U',']',
/* 0x184c1 = "Onda V972 PTP (camera)" */
    'O','n','d','a',' ','V','9','7','2',' ','P','T','P',' ','(','c','a','m','e','r','a',')',
/* 0x184d7 = "Flight Pro Combat Rudder" */
    'F','l','i','g','h','t',' ','\x8f',' ','C','o','m','b','a','t',' ','R','u','d','d','e','r',
/* 0x184ed = "Multiport Computer Vertriebs GmbH" */
    'M','u','l','t','i','p','o','r','t',' ','\xcd','V','e','r','t','r','i','e','b','s',' ','\xfc',
/* 0x18503 = "G2/G3/G4 CCD-F KAF CCD" */
    'G','2','/','G','3','/','G','4',' ','C','C','D','-','F',' ','K','A','F',' ','C','C','D',
/* 0x18519 = "Xperia Ion [Tethering]" */
    'X','p','e','r','i','a',' ','I','o','n',' ','[','T','e','t','h','e','r','i','n','g',']',
/* 0x1852f = "SideWinder Dual Strike" */
    'S','i','d','e','W','i','n','d','e','r',' ','D','u','a','l',' ','S','t','r','i','k','e',
/* 0x18545 = "G13 Advanced Gameboard" */
    'G','1','3',' ','A','d','v','a','n','c','e','d',' ','G','a','m','e','b','o','a','r','d',
/* 0x1855b = "FinePix S5200/S5600 Zoom (DSC)" */
    '\xca','i','x',' ','S','5','2','0','0','/','S','5','6','0','0',' ','\xe6','(','D','S','C',')',
/* 0x18571 = "Microphone (Messenger)" */
    'M','i','c','r','o','p','h','o','n','e',' ','(','M','e','s','s','e','n','g','e','r',')',
/* 0x18587 = "SideWinder Precision Pro" */
    'S','i','d','e','W','i','n','d','e','r',' ','P','r','e','c','i','s','i','o','n',' ','\x8f',
/* 0x1859d = "LC16M VFD Display/IR Receiver" */
    'L','C','1','6','M',' ','V','F','D',' ','D','i','s','p','l','a','y','/','I','R',' ','\x8c',
/* 0x185b3 = "OL\'E Communications, Inc." */
    'O','L','\'','E',' ','C','o','m','m','u','n','i','c','a','t','i','o','n','s',',',' ','\x07',
/* 0x185c9 = "MediaTV Analog/FM/ATSC MiniPCIe" */
    '\xa1','\xda','A','n','a','l','o','g','/','F','M','/','A','T','S','C',' ','\xb9','P','C','I','e',
/* 0x185df = "MSR90 MagStripe reader" */
    'M','S','R','9','0',' ','M','a','g','S','t','r','i','p','e',' ','r','e','a','d','e','r',
/* 0x185f5 = "American Biometric Co." */
    'A','m','e','r','i','c','a','n',' ','B','i','o','m','e','t','r','i','c',' ','C','o','.',
/* 0x1860b = "ScanExpress A3 USB 1200 PRO" */
    '\x8a','E','x','p','r','e','s','s',' ','A','3',' ','\x0a',' ','1','2','0','0',' ','P','R','O',
/* 0x18621 = "PXR4 4-Track Digital Recorder" */
    'P','X','R','4',' ','4','-','T','r','a','c','k',' ','\x09','R','e','c','o','r','d','e','r',
/* 0x18637 = "Sandisk SDDR-55 SmartMedia Card Reader" */
    'S','a','n','d','i','s','k',' ','S','D','D','R','-','5','5',' ','\x12','\xa1',' ','\x15',' ','\x08',
/* 0x1864d = "HOTAS Warthog Joystick" */
    'H','O','T','A','S',' ','W','a','r','t','h','o','g',' ','J','o','y','s','t','i','c','k',
/* 0x18663 = "Wireless LAN MultiPort W100 [Intersil PRISM 2.5]" */
    '\x01','\xf3','\xd6','\x87',' ','W','1','0','0',' ','[','\xb0','P','R','I','S','M',' ','2','.','5',']',
/* 0x18679 = "Dual Compatible Game Pad" */
    'D','u','a','l',' ','C','o','m','p','a','t','i','b','l','e',' ','G','a','m','e',' ','\xfa',
/* 0x1868f = "Prolink Microsystems Corp." */
    'P','r','o','l','i','n','k',' ','M','i','c','r','o','s','y','s','t','e','m','s',' ','\x10',
/* 0x186a5 = "Vobis Microcomputer AG" */
    'V','o','b','i','s',' ','M','i','c','r','o','c','o','m','p','u','t','e','r',' ','A','G',
/* 0x186bb = "A835/E1000 GSM Phone (P2K)" */
    'A','8','3','5','/','E','1','0','0','0',' ','G','S','M',' ','\x19',' ','(','P','2','K',')',
/* 0x186d1 = "Knudsen Engineering, Ltd" */
    'K','n','u','d','s','e','n',' ','E','n','g','i','n','e','e','r','i','n','g',',',' ','\x16',
/* 0x186e7 = "WUSB54GC v1 802.11g Adapter [Ralink RT73]" */
    'W','U','S','B','5','4','G','C',' ','v','1',' ','\x94','\x02',' ','[','\x93','R','T','7','3',']',
/* 0x186fd = "deRFusbSniffer 2.4 GHz" */
    'd','e','R','F','u','s','b','S','n','i','f','f','e','r',' ','2','.','4',' ','G','H','z',
/* 0x18713 = "iPod Nano 5.Gen (WTF mode)" */
    'i','P','o','d',' ','N','a','n','o',' ','5','.','G','e','n',' ','(','W','T','F',' ','\x1a',
/* 0x18729 = "Microtek Take-it MV500" */
    'M','i','c','r','o','t','e','k',' ','T','a','k','e','-','i','t',' ','M','V','5','0','0',
/* 0x1873f = "ARM-USB-OCD-H JTAG+RS232" */
    'A','R','M','-','\x0a','-','O','C','D','-','H',' ','J','T','A','G','+','R','S','2','3','2',
/* 0x18755 = "Digital Voice Recorder DS-330" */
    '\x09','V','o','i','c','e',' ','R','e','c','o','r','d','e','r',' ','D','S','-','3','3','0',
/* 0x1876b = "Digital IXUS 750 / PowerShot SD550 (PTP mode)" */
    '\x09','\xfd','7','5','0',' ','/',' ','\x24','\x84','S','D','5','5','0',' ','(','P','T','P',' ','\x1a',
/* 0x18781 = "Micortek ScanMaker X12USL" */
    'M','i','c','o','r','t','e','k',' ','\x8a','M','a','k','e','r',' ','X','1','2','U','S','L',
/* 0x18797 = "Pine-Tum Enterprise Co., Ltd." */
    'P','i','n','e','-','T','u','m',' ','E','n','t','e','r','p','r','i','s','e',' ','\x0e','\xab',
/* 0x187ad = "FreeAgent GoFlex USB 2.0" */
    'F','r','e','e','A','g','e','n','t',' ','G','o','F','l','e','x',' ','\x0a',' ','2','.','0',
/* 0x187c3 = "M5621 High-Speed IDE Controller" */
    'M','5','6','2','1',' ','H','i','g','h','-','S','p','e','e','d',' ','I','D','E',' ','\x13',
/* 0x187d9 = "Rockwell Automation, Inc." */
    'R','o','c','k','w','e','l','l',' ','A','u','t','o','m','a','t','i','o','n',',',' ','\x07',
/* 0x187ef = "Royal Information Electronics Co., Ltd" */
    'R','o','y','a','l',' ','I','n','f','o','r','m','a','t','i','o','n',' ','\x1b',' ','\x0e','\x16',
/* 0x18805 = "Digital Photo viewer [Wallet Pix]" */
    '\x09','\x86',' ','v','i','e','w','e','r',' ','[','W','a','l','l','e','t',' ','P','i','x',']',
/* 0x1881b = "WL-352v1 Wireless USB Adapter 300N 002" */
    'W','L','-','3','5','2','v','1',' ','\x01','\x0a',' ','\x02',' ','3','0','0','N',' ','0','0','2',
/* 0x18831 = "eFilm Reader-11 (Class/PDR)" */
    'e','F','i','l','m',' ','\x08','-','1','1',' ','(','C','l','a','s','s','/','P','D','R',')',
/* 0x18847 = "TopSpeed Cyberlink Remote Control" */
    'T','o','p','S','p','e','e','d',' ','C','y','b','e','r','l','i','n','k',' ','\xcb',' ','\xc9',
/* 0x1885d = "MidiSport 8x8/s Loader" */
    'M','i','d','i','S','p','o','r','t',' ','8','x','8','/','s',' ','L','o','a','d','e','r',
/* 0x18873 = "Gwo Jinn Industries Co., Ltd." */
    'G','w','o',' ','J','i','n','n',' ','I','n','d','u','s','t','r','i','e','s',' ','\x0e','\xab',
/* 0x18889 = "Divio NW801/DVC-V6+ Digital Camera" */
    'D','i','v','i','o',' ','N','W','8','0','1','/','D','V','C','-','V','6','+',' ','\x09','\x04',
/* 0x1889f = "Osterhout Design Group" */
    'O','s','t','e','r','h','o','u','t',' ','D','e','s','i','g','n',' ','G','r','o','u','p',
/* 0x188b5 = "GT-9700F [Perfection 2450 PHOTO]" */
    'G','T','-','9','7','0','0','F',' ','[','\xf0','2','4','5','0',' ','P','H','O','T','O',']',
/* 0x188cb = "M-UAS144 [LS1 Laser Mouse]" */
    'M','-','U','A','S','1','4','4',' ','[','L','S','1',' ','\x82',' ','M','o','u','s','e',']',
/* 0x188e1 = "Point Grey Research, Inc." */
    'P','o','i','n','t',' ','G','r','e','y',' ','R','e','s','e','a','r','c','h',',',' ','\x07',
/* 0x188f7 = "Kanda Tsushin Kogyo Co., Ltd" */
    'K','a','n','d','a',' ','T','s','u','s','h','i','n',' ','K','o','g','y','o',' ','\x0e','\x16',
/* 0x1890d = "Nogatech TV! (PAL) (T)" */
    'N','o','g','a','t','e','c','h',' ','T','V','!',' ','(','P','A','L',')',' ','(','T',')',
/* 0x18923 = "DVD Writer Slimtype eTAU108" */
    'D','V','D',' ','\xdf',' ','S','l','i','m','t','y','p','e',' ','e','T','A','U','1','0','8',
/* 0x18939 = "Clie NR70 PDA Mass Storage" */
    'C','l','i','e',' ','N','R','7','0',' ','P','D','A',' ','\x7c','S','t','o','r','a','g','e',
/* 0x1894f = "PhidgetEncoder Ver 1.0" */
    'P','h','i','d','g','e','t','E','n','c','o','d','e','r',' ','V','e','r',' ','1','.','0',
/* 0x18965 = "TV Wonder, Edition (FN5)" */
    '\xda','W','o','n','d','e','r',',',' ','E','d','i','t','i','o','n',' ','(','F','N','5',')',
/* 0x1897b = "Otto driving companion" */
    'O','t','t','o',' ','d','r','i','v','i','n','g',' ','c','o','m','p','a','n','i','o','n',
/* 0x18991 = "XG-705A 802.11g Wireless Adapter [Intersil ISL3887]" */
    'X','G','-','7','0','5','A',' ','\x94','\x01','\x02',' ','[','\xb0','I','S','L','3','8','8','7',']',
/* 0x189a7 = "Micro Innovations Web Cam 320" */
    '\xc4',' ','I','n','n','o','v','a','t','i','o','n','s',' ','W','e','b',' ','\x9a','3','2','0',
/* 0x189bd = "Digitizer (Whiteboard)" */
    'D','i','g','i','t','i','z','e','r',' ','(','W','h','i','t','e','b','o','a','r','d',')',
/* 0x189d3 = "American Megatrends, Inc." */
    'A','m','e','r','i','c','a','n',' ','M','e','g','a','t','r','e','n','d','s',',',' ','\x07',
/* 0x189e9 = "Atlantic Coast Telesys" */
    'A','t','l','a','n','t','i','c',' ','C','o','a','s','t',' ','T','e','l','e','s','y','s',
/* 0x189ff = "Quanta Microsystems, Inc." */
    'Q','u','a','n','t','a',' ','M','i','c','r','o','s','y','s','t','e','m','s',',',' ','\x07',
/* 0x18a15 = "RM-203 USB Nest [mode 2]" */
    'R','M','-','2','0','3',' ','\x0a',' ','N','e','s','t',' ','[','m','o','d','e',' ','2',']',
/* 0x18a2b = "SV-286 Cyclone Digital" */
    'S','V','-','2','8','6',' ','C','y','c','l','o','n','e',' ','D','i','g','i','t','a','l',
/* 0x18a41 = "iPod Nano 5.Gen (DFU mode)" */
    'i','P','o','d',' ','N','a','n','o',' ','5','.','G','e','n',' ','(','D','F','U',' ','\x1a',
/* 0x18a57 = "PL2773 SATAII bridge controller" */
    'P','L','2','7','7','3',' ','S','A','T','A','I','I',' ','b','r','i','d','g','e',' ','\x9e',
/* 0x18a6d = "Aiptek HyperPen 10000U" */
    'A','i','p','t','e','k',' ','H','y','p','e','r','P','e','n',' ','1','0','0','0','0','U',
/* 0x18a83 = "P-TWO INDUSTRIES, INC." */
    'P','-','T','W','O',' ','I','N','D','U','S','T','R','I','E','S',',',' ','I','N','C','.',
/* 0x18a99 = "ASM1074 High-Speed hub" */
    'A','S','M','1','0','7','4',' ','H','i','g','h','-','S','p','e','e','d',' ','h','u','b',
/* 0x18aaf = "Key Nice Enterprise Co., Ltd" */
    'K','e','y',' ','N','i','c','e',' ','E','n','t','e','r','p','r','i','s','e',' ','\x0e','\x16',
/* 0x18ac5 = "Advanced Digital Broadcast, Ltd" */
    'A','d','v','a','n','c','e','d',' ','\x09','B','r','o','a','d','c','a','s','t',',',' ','\x16',
/* 0x18adb = "MPR Serial Preloader (MPRQ)" */
    'M','P','R',' ','\x90',' ','P','r','e','l','o','a','d','e','r',' ','(','M','P','R','Q',')',
/* 0x18af1 = "CVA122 Cable Voice Adapter (WDM)" */
    'C','V','A','1','2','2',' ','\xa5',' ','V','o','i','c','e',' ','\x02',' ','(','W','D','M',')',
/* 0x18b07 = "AirVast W-Buddie WN210" */
    'A','i','r','V','a','s','t',' ','W','-','B','u','d','d','i','e',' ','W','N','2','1','0',
/* 0x18b1d = "High Top Precision Electronic Co., Ltd." */
    'H','i','g','h',' ','T','o','p',' ','P','r','e','c','i','s','i','o','n',' ','\xba','\x0e','\xab',
/* 0x18b33 = "TT-connect CT2-4650 CI" */
    'T','T','-','c','o','n','n','e','c','t',' ','C','T','2','-','4','6','5','0',' ','C','I',
/* 0x18b49 = "F6D6050 802.11abgn Wireless Adapter [Broadcom BCM4323]" */
    'F','6','D','6','0','5','0',' ','\xea','\x01','\x02',' ','[','\xeb','B','C','M','4','3','2','3',']',
/* 0x18b5f = "ASM1074 SuperSpeed hub" */
    'A','S','M','1','0','7','4',' ','S','u','p','e','r','S','p','e','e','d',' ','h','u','b',
/* 0x18b75 = "My Passport Essential (WDBACY)" */
    'M','y',' ','\xd5','E','s','s','e','n','t','i','a','l',' ','(','W','D','B','A','C','Y',')',
/* 0x18b8b = "EUB600v1 802.11abgn Wireless Adapter [Ralink RT3572]" */
    'E','U','B','6','0','0','v','1',' ','\xea','\x01','\x02',' ','[','\x93','R','T','3','5','7','2',']',
/* 0x18ba1 = "iPod Nano 2.Gen (DFU mode)" */
    'i','P','o','d',' ','N','a','n','o',' ','2','.','G','e','n',' ','(','D','F','U',' ','\x1a',
/* 0x18bb7 = "SmartMedia+CompactFlash+MMC/SD Card Reader" */
    '\x12','\xa1','+','C','o','m','p','a','c','t','\x3c','+','M','M','C','/','S','D',' ','\x15',' ','\x08',
/* 0x18bcd = "Infotech Logistic, LLC" */
    'I','n','f','o','t','e','c','h',' ','L','o','g','i','s','t','i','c',',',' ','L','L','C',
/* 0x18be3 = "My Book Elite (WDBAAH)" */
    'M','y',' ','B','o','o','k',' ','E','l','i','t','e',' ','(','W','D','B','A','A','H',')',
/* 0x18bf9 = "DVB-T receiver [RTL2832U]" */
    '\xa7','T',' ','r','e','c','e','i','v','e','r',' ','[','R','T','L','2','8','3','2','U',']',
/* 0x18c0f = "Genius LuxeMate i200 Keyboard" */
    'G','e','n','i','u','s',' ','L','u','x','e','M','a','t','e',' ','i','2','0','0',' ','\x05',
/* 0x18c25 = "Asix PRESTO Programmer" */
    'A','s','i','x',' ','P','R','E','S','T','O',' ','P','r','o','g','r','a','m','m','e','r',
/* 0x18c3b = "Receipt Printer M129C/TM-T70" */
    'R','e','c','e','i','p','t',' ','\x0c',' ','M','1','2','9','C','/','T','M','-','T','7','0',
/* 0x18c51 = "Yamaichi Electronics Co., Ltd (Sakura)" */
    'Y','a','m','a','i','c','h','i',' ','\x1b',' ','\x0e','\x16',' ','(','S','a','k','u','r','a',')',
/* 0x18c67 = "NWD211AN 802.11abgn Wireless Adapter [Ralink RT2870]" */
    'N','W','D','2','1','1','A','N',' ','\xea','\x01','\x02',' ','[','\x93','R','T','2','8','7','0',']',
/* 0x18c7d = "Epson Imaging Technology Center" */
    'E','p','s','o','n',' ','I','m','a','g','i','n','g',' ','\x0d',' ','C','e','n','t','e','r',
/* 0x18c93 = "Internal Keyboard/Trackpad (MacBook Air) (ISO)" */
    '\xb4','\xc6','\xf6','(','M','a','c','B','o','o','k',' ','A','i','r',')',' ','(','I','S','O',')',
/* 0x18ca9 = "AES2510 Sensor (USB Emulator)" */
    'A','E','S','2','5','1','0',' ','\xac',' ','(','\x0a',' ','E','m','u','l','a','t','o','r',')',
/* 0x18cbf = "WiMAX Connection 2400m" */
    'W','i','M','A','X',' ','C','o','n','n','e','c','t','i','o','n',' ','2','4','0','0','m',
/* 0x18cd5 = "16gB flash thumb drive" */
    '1','6','g','B',' ','f','l','a','s','h',' ','t','h','u','m','b',' ','d','r','i','v','e',
/* 0x18ceb = "Xerox WorkCentre Pro 412" */
    'X','e','r','o','x',' ','W','o','r','k','C','e','n','t','r','e',' ','\x8f',' ','4','1','2',
/* 0x18d01 = "FinePix S5200/S5600 Zoom (PTP)" */
    '\xca','i','x',' ','S','5','2','0','0','/','S','5','6','0','0',' ','\xe6','(','P','T','P',')',
/* 0x18d17 = "NetCom Roadster II 56k" */
    'N','e','t','C','o','m',' ','R','o','a','d','s','t','e','r',' ','I','I',' ','5','6','k',
/* 0x18d2d = "Development board JTAG" */
    'D','e','v','e','l','o','p','m','e','n','t',' ','b','o','a','r','d',' ','J','T','A','G',
/* 0x18d43 = "IFU-WLM2 USB Wireless LAN Module (Wireless Mode)" */
    'I','F','U','-','W','L','M','2',' ','\x0a',' ','\x01','\xf3','\xe5',' ','(','\x01','M','o','d','e',')',
/* 0x18d59 = "Scorpion-980N keyboard" */
    'S','c','o','r','p','i','o','n','-','9','8','0','N',' ','k','e','y','b','o','a','r','d',
/* 0x18d6f = "eUSB SmartMedia/CompactFlash Card Reader" */
    'e','\x0a',' ','\x12','M','e','d','i','a','/','C','o','m','p','a','c','t','\x3c',' ','\x15',' ','\x08',
/* 0x18d85 = "Geniatech T220A DVB-T2 TV Stick" */
    'G','e','n','i','a','t','e','c','h',' ','T','2','2','0','A',' ','\xa7','T','2',' ','\xda','\xb3',
/* 0x18d9b = "Mono embedded computer" */
    'M','o','n','o',' ','e','m','b','e','d','d','e','d',' ','c','o','m','p','u','t','e','r',
/* 0x18db1 = "AF9015/AF9035 DVB-T stick" */
    'A','F','9','0','1','5','/','A','F','9','0','3','5',' ','\xa7','T',' ','s','t','i','c','k',
/* 0x18dc7 = "Eminence Enterprise Co., Ltd" */
    'E','m','i','n','e','n','c','e',' ','E','n','t','e','r','p','r','i','s','e',' ','\x0e','\x16',
/* 0x18ddd = "SpeedTouch ISDN or ADSL router" */
    'S','p','e','e','d','\x9d',' ','I','S','D','N',' ','o','r',' ','\xf1','r','o','u','t','e','r',
/* 0x18df3 = "LS 50 ED/Coolscan V ED" */
    'L','S',' ','5','0',' ','E','D','/','C','o','o','l','s','c','a','n',' ','V',' ','E','D',
/* 0x18e09 = "Integrated Touchpad / Trackstick" */
    '\x18','T','o','u','c','h','p','a','d',' ','/',' ','T','r','a','c','k','s','t','i','c','k',
/* 0x18e1f = "USB to serial cable (v2)" */
    '\x0a',' ','t','o',' ','s','e','r','i','a','l',' ','c','a','b','l','e',' ','(','v','2',')',
/* 0x18e35 = "Sunplus Innovation Technology Inc." */
    'S','u','n','p','l','u','s',' ','I','n','n','o','v','a','t','i','o','n',' ','\x0d',' ','\x07',
/* 0x18e4b = "R205 Mobile WiFi (Charging)" */
    'R','2','0','5',' ','\x96',' ','W','i','F','i',' ','(','C','h','a','r','g','i','n','g',')',
/* 0x18e61 = "Sure-Fire Electrical Corp." */
    'S','u','r','e','-','F','i','r','e',' ','E','l','e','c','t','r','i','c','a','l',' ','\x10',
/* 0x18e77 = "PK-GP301 Driving Wheel" */
    'P','K','-','G','P','3','0','1',' ','D','r','i','v','i','n','g',' ','W','h','e','e','l',
/* 0x18e8d = "GT 3G Quad UMTS/GPRS Card" */
    'G','T',' ','3','G',' ','Q','u','a','d',' ','U','M','T','S','/','G','P','R','S',' ','\x15',
/* 0x18ea3 = "Hauppauge WinTV-USB with FM USA radio" */
    '\xfb','W','i','n','T','V','-','\x0a',' ','\x98','F','M',' ','U','S','A',' ','r','a','d','i','o',
/* 0x18eb9 = "109 Japanese Keyboard with Bus-Powered Hub" */
    '1','0','9',' ','J','a','p','a','n','e','s','e',' ','\x05',' ','\x98','B','u','s','-','\x85','\xa4',
/* 0x18ecf = "PC-Gamepad "Greystorm"" */
    'P','C','-','G','a','m','e','p','a','d',' ','"','G','r','e','y','s','t','o','r','m','"',
/* 0x18ee5 = "GAIA Sensor FPGA Demo Board" */
    'G','A','I','A',' ','\xac',' ','F','P','G','A',' ','D','e','m','o',' ','B','o','a','r','d',
/* 0x18efb = "Enhanced Performance Keyboard" */
    'E','n','h','a','n','c','e','d',' ','P','e','r','f','o','r','m','a','n','c','e',' ','\x05',
/* 0x18f11 = "HP webcam [dv6-1190en]" */
    'H','P',' ','w','e','b','c','a','m',' ','[','d','v','6','-','1','1','9','0','e','n',']',
/* 0x18f27 = "COMpact 4410/2206 ISDN" */
    'C','O','M','p','a','c','t',' ','4','4','1','0','/','2','2','0','6',' ','I','S','D','N',
/* 0x18f3d = "INIC-1610P SATA bridge" */
    'I','N','I','C','-','1','6','1','0','P',' ','S','A','T','A',' ','b','r','i','d','g','e',
/* 0x18f53 = "Internal Keyboard/Trackpad (MacBook Pro) (ISO)" */
    '\xb4','\xc6','\xf6','(','M','a','c','B','o','o','k',' ','P','r','o',')',' ','(','I','S','O',')',
/* 0x18f69 = "TrendNet TFM-561 modem" */
    'T','r','e','n','d','N','e','t',' ','T','F','M','-','5','6','1',' ','m','o','d','e','m',
/* 0x18f7f = "E169/E620/E800 HSDPA Modem" */
    'E','1','6','9','/','E','6','2','0','/','E','8','0','0',' ','H','S','D','P','A',' ','\x1c',
/* 0x18f95 = "Opera1 DVB-S (cold state)" */
    'O','p','e','r','a','1',' ','\xa7','S',' ','(','c','o','l','d',' ','s','t','a','t','e',')',
/* 0x18fab = "iPod Nano 4.Gen (WTF mode)" */
    'i','P','o','d',' ','N','a','n','o',' ','4','.','G','e','n',' ','(','W','T','F',' ','\x1a',
/* 0x18fc1 = "Genius iSlim 1300AF V2" */
    'G','e','n','i','u','s',' ','i','S','l','i','m',' ','1','3','0','0','A','F',' ','V','2',
/* 0x18fd7 = "Custom Engineering SPA" */
    'C','u','s','t','o','m',' ','E','n','g','i','n','e','e','r','i','n','g',' ','S','P','A',
/* 0X18fed = "PAC7311 Trust WB-3300p" */
    'C','7','3','1','1',' ','T','r','u','s','t',' ','W','B','-','3','3','0','0','p',
/* 0x19001 = "MX Phone (MTP & ACM & ADB)" */
    'M','X',' ','\x19',' ','(','M','T','P',' ','&',' ','A','C','M',' ','&',' ','A','D','B',')',
/* 0x19017 = "GD-0405 [Intuos (4x5)]" */
    'G','D','-','0','4','0','5',' ','[','I','n','t','u','o','s',' ','(','4','x','5',')',']',
/* 0x1902d = "CT10x Coin Transaction" */
    'C','T','1','0','x',' ','C','o','i','n',' ','T','r','a','n','s','a','c','t','i','o','n',
/* 0x19043 = "Shengyih Steel Mold Co., Ltd" */
    'S','h','e','n','g','y','i','h',' ','S','t','e','e','l',' ','M','o','l','d',' ','\x0e','\x16',
/* 0x19059 = "Internet Security Co., Ltd. SecureKey" */
    '\xb6','S','e','c','u','r','i','t','y',' ','\x0e','\xab',' ','S','e','c','u','r','e','K','e','y',
/* 0x1906f = "EHCI Root Hub Simulation" */
    'E','H','C','I',' ','R','o','o','t',' ','\xa4',' ','S','i','m','u','l','a','t','i','o','n',
/* 0x19085 = "JPD Shockforce gamepad" */
    'J','P','D',' ','S','h','o','c','k','f','o','r','c','e',' ','g','a','m','e','p','a','d',
/* 0x1909b = "Mitsubishi Materials Corp." */
    'M','i','t','s','u','b','i','s','h','i',' ','M','a','t','e','r','i','a','l','s',' ','\x10',
/* 0x190b1 = "MaxFire G-08XU Gamepad" */
    'M','a','x','F','i','r','e',' ','G','-','0','8','X','U',' ','G','a','m','e','p','a','d',
/* 0x190c7 = "mvBlueFOX camera (no firmware)" */
    'm','v','B','l','u','e','F','O','X',' ','c','a','m','e','r','a',' ','(','n','o',' ','\xdb',
/* 0x190dd = "RM-203 USB Nest [mode 3]" */
    'R','M','-','2','0','3',' ','\x0a',' ','N','e','s','t',' ','[','m','o','d','e',' ','3',']',
/* 0x190f3 = "Embedded Mass Storage Drive [RealSSD]" */
    'E','m','b','e','d','d','e','d',' ','\x7c','\x0f','\x14',' ','[','R','e','a','l','S','S','D',']',
/* 0x19109 = "Lego Mindstorms NXTCam" */
    'L','e','g','o',' ','M','i','n','d','s','t','o','r','m','s',' ','N','X','T','C','a','m',
/* 0x1911f = "My Passport Edge for Mac (WDBJBH)" */
    'M','y',' ','\xd5','E','d','g','e',' ','\xcc','M','a','c',' ','(','W','D','B','J','B','H',')',
/* 0x19135 = "VRM Box Audio Class (2-out)" */
    'V','R','M',' ','B','o','x',' ','\x8b','C','l','a','s','s',' ','(','2','-','o','u','t',')',
/* 0x1914b = "CVA124 Cable Voice Adapter (WDM)" */
    'C','V','A','1','2','4',' ','\xa5',' ','V','o','i','c','e',' ','\x02',' ','(','W','D','M',')',
/* 0x19161 = "Galaxy Portal/Spica Android Phone" */
    'G','a','l','a','x','y',' ','P','o','r','t','a','l','/','S','p','i','c','a',' ','\xce','\x19',
/* 0x19177 = "Extended Keyboard Hub [Mitsumi]" */
    'E','x','t','e','n','d','e','d',' ','\x05',' ','\xa4',' ','[','M','i','t','s','u','m','i',']',
/* 0x1918d = "Advanced Input Devices" */
    'A','d','v','a','n','c','e','d',' ','I','n','p','u','t',' ','D','e','v','i','c','e','s',
/* 0x191a3 = "WingMan Gaming Wheel Mouse" */
    'W','i','n','g','M','a','n',' ','G','a','m','i','n','g',' ','W','h','e','e','l',' ','\x0b',
/* 0x191b9 = "EZ-Link (EZLNKUSB.SYS)" */
    'E','Z','-','L','i','n','k',' ','(','E','Z','L','N','K','U','S','B','.','S','Y','S',')',
/* 0x191cf = "WBU-110 802.11b Wireless Adapter [Intersil PRISM 3]" */
    'W','B','U','-','1','1','0',' ','\x9b','\x01','\x02',' ','[','\xb0','P','R','I','S','M',' ','3',']',
/* 0x191e5 = "PEL-2000 Series Electronic Load (CDC)" */
    'P','E','L','-','2','0','0','0',' ','\xbf',' ','\xba','L','o','a','d',' ','(','C','D','C',')',
/* 0x191fb = "Eumex 400 (WinXP/2000)" */
    'E','u','m','e','x',' ','4','0','0',' ','(','W','i','n','X','P','/','2','0','0','0',')',
/* 0x19211 = "Yubikey 4 OTP+U2F+CCID" */
    'Y','u','b','i','k','e','y',' ','4',' ','O','T','P','+','U','2','F','+','C','C','I','D',
/* 0x19227 = "Mega 2560 R3 (CDC ACM)" */
    'M','e','g','a',' ','2','5','6','0',' ','R','3',' ','(','C','D','C',' ','A','C','M',')',
/* 0x1923d = "Phaser 6115MFP TWAIN Scanner" */
    'P','h','a','s','e','r',' ','6','1','1','5','M','F','P',' ','T','W','A','I','N',' ','\x25',
/* 0x19253 = "PC Camera (SN9C201 + HV7131R)" */
    '\x1f','\x04',' ','(','S','N','9','C','2','0','1',' ','+',' ','H','V','7','1','3','1','R',')',
/* 0x19269 = "Barcode Module - CDC serial" */
    'B','a','r','c','o','d','e',' ','\xe5',' ','-',' ','C','D','C',' ','s','e','r','i','a','l',
/* 0x1927f = "Farallon Comunications" */
    'F','a','r','a','l','l','o','n',' ','C','o','m','u','n','i','c','a','t','i','o','n','s',
/* 0x19295 = "Internal Keyboard/Trackpad (MacBook Pro) (JIS)" */
    '\xb4','\xc6','\xf6','(','M','a','c','B','o','o','k',' ','P','r','o',')',' ','(','J','I','S',')',
/* 0x192ab = "Hi-MD MZ-NH600 WALKMAN" */
    'H','i','-','M','D',' ','M','Z','-','N','H','6','0','0',' ','W','A','L','K','M','A','N',
/* 0x192c1 = "XI-725/726 Prism2.5 802.11b Adapter" */
    'X','I','-','7','2','5','/','7','2','6',' ','P','r','i','s','m','2','.','5',' ','\x9b','\x02',
/* 0x192d7 = "WinFast TV - NTSC + MTS + FM" */
    'W','i','n','\xec','\xda','-',' ','N','T','S','C',' ','+',' ','M','T','S',' ','+',' ','F','M',
/* 0x192ed = "P!cty 920 [HP DJ 812c]" */
    'P','!','c','t','y',' ','9','2','0',' ','[','H','P',' ','D','J',' ','8','1','2','c',']',
/* 0x19303 = "WL169gE 802.11g Adapter [Broadcom 4320 USB]" */
    'W','L','1','6','9','g','E',' ','\x94','\x02',' ','[','\xeb','4','3','2','0',' ','U','S','B',']',
/* 0x19319 = "FinePix S602 (Pro) Zoom (PC CAM)" */
    '\xca','i','x',' ','S','6','0','2',' ','(','P','r','o',')',' ','\xe6','(','\x1f','C','A','M',')',
/* 0x1932f = "OMAP 1.0 chipset flash" */
    'O','M','A','P',' ','1','.','0',' ','c','h','i','p','s','e','t',' ','f','l','a','s','h',
/* 0x19345 = "LUFA Webserver Project" */
    'L','U','F','A',' ','W','e','b','s','e','r','v','e','r',' ','P','r','o','j','e','c','t',
/* 0x1935b = "PSoC FirstTouch Programmer" */
    'P','S','o','C',' ','F','i','r','s','t','\x9d',' ','P','r','o','g','r','a','m','m','e','r',
/* 0x19371 = "FingerLoc Sensor Module (Anchor)" */
    'F','i','n','g','e','r','L','o','c',' ','\xac',' ','\xe5',' ','(','A','n','c','h','o','r',')',
/* 0x19387 = "Multiple Slides Scanner-3600" */
    'M','u','l','t','i','p','l','e',' ','S','l','i','d','e','s',' ','\x25','-','3','6','0','0',
/* 0x1939d = "AVerTV DVB-T Volar X (A815)" */
    'A','V','e','r','\xda','\xa7','T',' ','V','o','l','a','r',' ','X',' ','(','A','8','1','5',')',
/* 0x193b3 = "Wireless Adapter Bootloader Download" */
    '\x01','\x02',' ','B','o','o','t','l','o','a','d','e','r',' ','D','o','w','n','l','o','a','d',
/* 0x193c9 = "Maxwell Compact Pc PM3" */
    'M','a','x','w','e','l','l',' ','C','o','m','p','a','c','t',' ','P','c',' ','P','M','3',
/* 0x193df = "Gravis Destroyer TiltPad" */
    'G','r','a','v','i','s',' ','D','e','s','t','r','o','y','e','r',' ','T','i','l','t','\xfa',
/* 0x193f5 = "ME 340 Series/Stylus NX130 Series" */
    'M','E',' ','3','4','0',' ','S','e','r','i','e','s','/','\xb1','N','X','1','3','0',' ','\xbf',
/* 0x1940b = "Comotron C3310 MP3 player" */
    'C','o','m','o','t','r','o','n',' ','C','3','3','1','0',' ','\x8e','p','l','a','y','e','r',
/* 0x19421 = "DTK-1300 [Cintiq 13HD]" */
    'D','T','K','-','1','3','0','0',' ','[','C','i','n','t','i','q',' ','1','3','H','D',']',
/* 0x19437 = "Blackwire C310 headset" */
    'B','l','a','c','k','w','i','r','e',' ','C','3','1','0',' ','h','e','a','d','s','e','t',
/* 0x1944d = "Creative Nomad Jukebox" */
    'C','r','e','a','t','i','v','e',' ','N','o','m','a','d',' ','J','u','k','e','b','o','x',
/* 0x19463 = "LaserJet Professional P 1102w" */
    '\x82','\x80','P','r','o','f','e','s','s','i','o','n','a','l',' ','P',' ','1','1','0','2','w',
/* 0x19479 = "shared ID for use with libusb" */
    's','h','a','r','e','d',' ','I','D',' ','\xcc','u','s','e',' ','\x98','l','i','b','u','s','b',
/* 0x1948f = "HOTAS Warthog Throttle" */
    'H','O','T','A','S',' ','W','a','r','t','h','o','g',' ','T','h','r','o','t','t','l','e',
/* 0x194a5 = "iPod Nano 4.Gen (DFU mode)" */
    'i','P','o','d',' ','N','a','n','o',' ','4','.','G','e','n',' ','(','D','F','U',' ','\x1a',
/* 0x194bb = "Cisco Virtual Mass Storage" */
    'C','i','s','c','o',' ','V','i','r','t','u','a','l',' ','\x7c','S','t','o','r','a','g','e',
/* 0x194d1 = "QL-570 P-touch Label Printer" */
    'Q','L','-','5','7','0',' ','P','-','t','o','u','c','h',' ','L','a','b','e','l',' ','\x0c',
/* 0x194e7 = "CompactFlash+MMC/SD+MemoryStick Card Reader" */
    'C','o','m','p','a','c','t','\x3c','+','M','M','C','/','S','D','+','\xd2','\xb3',' ','\x15',' ','\x08',
/* 0x194fd = "Metrologic Instruments" */
    'M','e','t','r','o','l','o','g','i','c',' ','I','n','s','t','r','u','m','e','n','t','s',
/* 0x19513 = "PowerShot A400 / PowerShot A400 (PTP mode)" */
    '\x24','\x84','A','4','0','0',' ','/',' ','\x24','\x84','A','4','0','0',' ','(','P','T','P',' ','\x1a',
/* 0x19529 = "KU-8933 Keyboard with PS/2 Mouse port" */
    'K','U','-','8','9','3','3',' ','\x05',' ','\x98','P','S','/','2',' ','\x0b',' ','p','o','r','t',
/* 0x1953f = "GD-0608 [Intuos (6x8)]" */
    'G','D','-','0','6','0','8',' ','[','I','n','t','u','o','s',' ','(','6','x','8',')',']',
/* 0x19555 = "TA HSING Industries, Ltd" */
    'T','A',' ','H','S','I','N','G',' ','I','n','d','u','s','t','r','i','e','s',',',' ','\x16',
/* 0x1956b = "COMpact 4406 DSL (PBX)" */
    'C','O','M','p','a','c','t',' ','4','4','0','6',' ','D','S','L',' ','(','P','B','X',')',
/* 0x19581 = "Megapixel Auto Focus Webcam" */
    'M','e','g','a','p','i','x','e','l',' ','A','u','t','o',' ','F','o','c','u','s',' ','\x11',
/* 0x19597 = "Genius iSlim 2000AF V2" */
    'G','e','n','i','u','s',' ','i','S','l','i','m',' ','2','0','0','0','A','F',' ','V','2',
/* 0x195ad = "Dell 03R874 KVM dongle" */
    'D','e','l','l',' ','0','3','R','8','7','4',' ','K','V','M',' ','d','o','n','g','l','e',
/* 0x195c3 = "Pocket CAM 3 Mega (storage)" */
    '\x17',' ','C','A','M',' ','3',' ','M','e','g','a',' ','(','s','t','o','r','a','g','e',')',
/* 0x195d9 = "iSight in LED Cinema Display" */
    'i','S','i','g','h','t',' ','i','n',' ','L','E','D',' ','C','i','n','e','m','a',' ','\xcf',
/* 0x195ef = "KeikaiDenwa 8 with charger" */
    'K','e','i','k','a','i','D','e','n','w','a',' ','8',' ','\x98','c','h','a','r','g','e','r',
/* 0x19605 = "Compact Flash R/W with MP3 player" */
    'C','o','m','p','a','c','t',' ','\x3c',' ','R','/','W',' ','\x98','\x8e','p','l','a','y','e','r',
/* 0x1961b = "Technotrend/Hauppauge DEC2540-t" */
    'T','e','c','h','n','o','t','r','e','n','d','/','\xfb','D','E','C','2','5','4','0','-','t',
/* 0x19631 = "AF9015 DVB-T USB2.0 stick" */
    'A','F','9','0','1','5',' ','\xa7','T',' ','U','S','B','2','.','0',' ','s','t','i','c','k',
/* 0x19647 = "Nomad Jukebox Zen Xtra" */
    'N','o','m','a','d',' ','J','u','k','e','b','o','x',' ','Z','e','n',' ','X','t','r','a',
/* 0x1965d = "SAU510-USB [no firmware]" */
    'S','A','U','5','1','0','-','\x0a',' ','[','n','o',' ','f','i','r','m','w','a','r','e',']',
/* 0x19673 = "Dual Mode Camera (8006 VGA)" */
    'D','u','a','l',' ','M','o','d','e',' ','\x04',' ','(','8','0','0','6',' ','V','G','A',')',
/* 0x19689 = "Cyberview High Speed Scanner" */
    'C','y','b','e','r','v','i','e','w',' ','H','i','g','h',' ','S','p','e','e','d',' ','\x25',
/* 0x1969f = "Control Panel for Leica TCS SP5" */
    '\xc9',' ','P','a','n','e','l',' ','\xcc','L','e','i','c','a',' ','T','C','S',' ','S','P','5',
/* 0x196b5 = "MT5634ZBA-USB MultiModemUSB (old firmware)" */
    'M','T','5','6','3','4','Z','B','A','-','\x0a',' ','\xd6','\x1c','\x0a',' ','(','o','l','d',' ','\xdb',
/* 0x196cb = "Built-in Bluetooth 2.0+EDR HCI" */
    'B','u','i','l','t','-','i','n',' ','\x06',' ','2','.','0','+','E','D','R',' ','H','C','I',
/* 0x196e1 = "USB to IrDA adapter [ARK3116T]" */
    '\x0a',' ','t','o',' ','I','r','D','A',' ','\xd0',' ','[','A','R','K','3','1','1','6','T',']',
/* 0x196f7 = "Fujitsu Pocket Loox 600 PDA" */
    'F','u','j','i','t','s','u',' ','\x17',' ','L','o','o','x',' ','6','0','0',' ','P','D','A',
/* 0x1970d = "GL827L SD/MMC/MS Flash Card Reader" */
    'G','L','8','2','7','L',' ','S','D','/','M','M','C','/','M','S',' ','\x3c',' ','\x15',' ','\x08',
/* 0x19723 = "i.Tech Dynamic Limited" */
    'i','.','T','e','c','h',' ','D','y','n','a','m','i','c',' ','L','i','m','i','t','e','d',
/* 0x19739 = "Entropy Key [UDEKEY01]" */
    'E','n','t','r','o','p','y',' ','K','e','y',' ','[','U','D','E','K','E','Y','0','1',']',
/* 0x1974f = "Jump Zone Network Products, Inc." */
    'J','u','m','p',' ','Z','o','n','e',' ','\x8d','P','r','o','d','u','c','t','s',',',' ','\x07',
/* 0x19765 = "Syntech Information Co., Ltd" */
    'S','y','n','t','e','c','h',' ','I','n','f','o','r','m','a','t','i','o','n',' ','\x0e','\x16',
/* 0x1977b = "WinTV NOVA-T USB2 (warm)" */
    'W','i','n','\xda','N','O','V','A','-','T',' ','U','S','B','2',' ','(','w','a','r','m',')',
/* 0x19791 = "DVD Multi-plus unit iU-CD2" */
    'D','V','D',' ','\xd6','-','p','l','u','s',' ','u','n','i','t',' ','i','U','-','C','D','2',
/* 0x197a7 = "ThinkPad Mini Dock Plus Series 3" */
    'T','h','i','n','k','\xfa',' ','\xb9',' ','D','o','c','k',' ','P','l','u','s',' ','\xbf',' ','3',
/* 0x197bd = "LN-031 10/100/1000 Ethernet Adapter" */
    'L','N','-','0','3','1',' ','1','0','/','1','0','0','/','1','0','0','0',' ','\x7f',' ','\x02',
/* 0x197d3 = "Technotrend/Hauppauge DEC3000-s" */
    'T','e','c','h','n','o','t','r','e','n','d','/','\xfb','D','E','C','3','0','0','0','-','s',
/* 0x197e9 = "BD Consumer Healthcare" */
    'B','D',' ','C','o','n','s','u','m','e','r',' ','H','e','a','l','t','h','c','a','r','e',
/* 0x197ff = "NFC and Smartcard Module (NSM)" */
    'N','F','C',' ','\xe4','S','m','a','r','t','c','a','r','d',' ','\xe5',' ','(','N','S','M',')',
/* 0x19815 = "BenQ-Siemens EF82/SL91" */
    'B','e','n','Q','-','S','i','e','m','e','n','s',' ','E','F','8','2','/','S','L','9','1',
/* 0x1982b = "DF-UT-06 Hama MMC/SD Reader" */
    'D','F','-','U','T','-','0','6',' ','H','a','m','a',' ','M','M','C','/','S','D',' ','\x08',
/* 0x19841 = "PowerShot ELPH 350HS / IXUS 275 HS" */
    '\x24','\x84','E','L','P','H',' ','3','5','0','H','S',' ','/',' ','\xfd','2','7','5',' ','H','S',
/* 0x19857 = "Portstation Paraller Port" */
    'P','o','r','t','s','t','a','t','i','o','n',' ','P','a','r','a','l','l','e','r',' ','\x87',
/* 0x1986d = "WinFast TV - NTSC Japan + FM" */
    'W','i','n','\xec','\xda','-',' ','N','T','S','C',' ','J','a','p','a','n',' ','+',' ','F','M',
/* 0x19883 = "Opera1 DVB-S (warm state)" */
    'O','p','e','r','a','1',' ','\xa7','S',' ','(','w','a','r','m',' ','s','t','a','t','e',')',
/* 0x19899 = "Paparazzi Lisa/M (DFU)" */
    'P','a','p','a','r','a','z','z','i',' ','L','i','s','a','/','M',' ','(','D','F','U',')',
/* 0x198af = "Electronics For Imaging, Inc. [hex]" */
    '\x1b',' ','F','o','r',' ','I','m','a','g','i','n','g',',',' ','\x07',' ','[','h','e','x',']',
/* 0x198c5 = "WLAN Adapter(SWL-2300)" */
    'W','L','A','N',' ','A','d','a','p','t','e','r','(','S','W','L','-','2','3','0','0',')',
/* 0x198db = "Pocket Media Assistant - PMA400" */
    '\x17',' ','\xa1',' ','A','s','s','i','s','t','a','n','t',' ','-',' ','P','M','A','4','0','0',
/* 0x198f1 = "Chu Yuen Enterprise Co., Ltd" */
    'C','h','u',' ','Y','u','e','n',' ','E','n','t','e','r','p','r','i','s','e',' ','\x0e','\x16',
/* 0x19907 = "BT Virtual Bus for Helium" */
    'B','T',' ','V','i','r','t','u','a','l',' ','B','u','s',' ','\xcc','H','e','l','i','u','m',
/* 0x1991d = "Sweetray Industrial, Ltd" */
    'S','w','e','e','t','r','a','y',' ','I','n','d','u','s','t','r','i','a','l',',',' ','\x16',
/* 0x19933 = "Wireless Rechargeable Optical Mouse (HID)" */
    '\x01','R','e','c','h','a','r','g','e','a','b','l','e',' ','\x7b','\x0b',' ','(','H','I','D',')',
/* 0x19949 = "Lake Communications, Ltd" */
    'L','a','k','e',' ','C','o','m','m','u','n','i','c','a','t','i','o','n','s',',',' ','\x16',
/* 0x1995f = "Focusrite Scarlett 2i2" */
    'F','o','c','u','s','r','i','t','e',' ','S','c','a','r','l','e','t','t',' ','2','i','2',
/* 0x19975 = "FinePix A202, A200 Zoom (PC CAM)" */
    '\xca','i','x',' ','A','2','0','2',',',' ','A','2','0','0',' ','\xe6','(','\x1f','C','A','M',')',
/* 0x1998b = "WLAN Adapter(SWL-2350)" */
    'W','L','A','N',' ','A','d','a','p','t','e','r','(','S','W','L','-','2','3','5','0',')',
/* 0x199a1 = "ATECH FLASH TECHNOLOGY" */
    'A','T','E','C','H',' ','F','L','A','S','H',' ','T','E','C','H','N','O','L','O','G','Y',
/* 0x199b7 = "Silicon Motion SM371 Camera" */
    'S','i','l','i','c','o','n',' ','M','o','t','i','o','n',' ','S','M','3','7','1',' ','\x04',
/* 0x199cd = "HCL Technologies India Private, Ltd" */
    'H','C','L',' ','\x88',' ','I','n','d','i','a',' ','P','r','i','v','a','t','e',',',' ','\x16',
/* 0x199e3 = "cyberJack go / go plus" */
    'c','y','b','e','r','J','a','c','k',' ','g','o',' ','/',' ','g','o',' ','p','l','u','s',
/* 0x199f9 = "Jabra UC VOICE 550a MS" */
    'J','a','b','r','a',' ','U','C',' ','V','O','I','C','E',' ','5','5','0','a',' ','M','S',
/* 0x19a0f = "ConvertX M402U XLOADER" */
    'C','o','n','v','e','r','t','X',' ','M','4','0','2','U',' ','X','L','O','A','D','E','R',
/* 0x19a25 = "WN4501F 802.11g Wireless Adapter [Intersil ISL3887]" */
    'W','N','4','5','0','1','F',' ','\x94','\x01','\x02',' ','[','\xb0','I','S','L','3','8','8','7',']',
/* 0x19a3b = "PC-CAM 550 (Composite)" */
    'P','C','-','C','A','M',' ','5','5','0',' ','(','C','o','m','p','o','s','i','t','e',')',
/* 0x19a51 = "ADU130 Data Acquisition Interface" */
    'A','D','U','1','3','0',' ','\xe7',' ','A','c','q','u','i','s','i','t','i','o','n',' ','\x81',
/* 0x19a67 = "Vreelin Engineering, Inc." */
    'V','r','e','e','l','i','n',' ','E','n','g','i','n','e','e','r','i','n','g',',',' ','\x07',
/* 0x19a7d = "Mass Storage Device (Multicard Reader)" */
    '\x7c','\x0f','\x03',' ','(','M','u','l','t','i','c','a','r','d',' ','R','e','a','d','e','r',')',
/* 0x19a93 = "Vengeance K65 Gaming Keyboard" */
    'V','e','n','g','e','a','n','c','e',' ','K','6','5',' ','G','a','m','i','n','g',' ','\x05',
/* 0x19aa9 = "Vision Shape Europe SA" */
    'V','i','s','i','o','n',' ','S','h','a','p','e',' ','E','u','r','o','p','e',' ','S','A',
/* 0x19abf = "DSS350 Digital Speaker System" */
    'D','S','S','3','5','0',' ','\x09','S','p','e','a','k','e','r',' ','S','y','s','t','e','m',
/* 0x19ad5 = "Visual Communication Camera (PCGA-UVC11)" */
    'V','i','s','u','a','l',' ','\xe9','\x04',' ','(','P','C','G','A','-','U','V','C','1','1',')',
/* 0x19aeb = "cyberJack e-com/pinpad" */
    'c','y','b','e','r','J','a','c','k',' ','e','-','c','o','m','/','p','i','n','p','a','d',
/* 0x19b01 = "HTC (High Tech Computer Corp.)" */
    'H','T','C',' ','(','H','i','g','h',' ','T','e','c','h',' ','\xcd','C','o','r','p','.',')',
/* 0x19b17 = "QL-560 P-touch Label Printer" */
    'Q','L','-','5','6','0',' ','P','-','t','o','u','c','h',' ','L','a','b','e','l',' ','\x0c',
/* 0x19b2d = "WLM-10U1 802.11abgn Wireless Adapter [Ralink RT3572]" */
    'W','L','M','-','1','0','U','1',' ','\xea','\x01','\x02',' ','[','\x93','R','T','3','5','7','2',']',
/* 0x19b43 = "Sanwa Supply Inc. Small Keyboard" */
    'S','a','n','w','a',' ','S','u','p','p','l','y',' ','\x07',' ','S','m','a','l','l',' ','\x05',
/* 0x19b59 = "APX Series Radio (Portable)" */
    'A','P','X',' ','\xbf',' ','R','a','d','i','o',' ','(','P','o','r','t','a','b','l','e',')',
/* 0x19b6f = "Orbotron 9000 (Serial)" */
    'O','r','b','o','t','r','o','n',' ','9','0','0','0',' ','(','S','e','r','i','a','l',')',
/* 0x19b85 = "SmartMedia Card Reader Firmware Loader" */
    '\x12','\xa1',' ','\x15',' ','\x08',' ','F','i','r','m','w','a','r','e',' ','L','o','a','d','e','r',
/* 0x19b9b = "WM168g 802.11bg Wireless Adapter [Intersil ISL3886]" */
    'W','M','1','6','8','g',' ','\xad',' ','\x01','\x02',' ','[','\xb0','I','S','L','3','8','8','6',']',
/* 0x19bb1 = "Paparazzi (bootloader)" */
    'P','a','p','a','r','a','z','z','i',' ','(','b','o','o','t','l','o','a','d','e','r',')',
/* 0x19bc7 = "G2 Android Phone [tethering mode]" */
    'G','2',' ','\xce','\x19',' ','[','t','e','t','h','e','r','i','n','g',' ','m','o','d','e',']',
/* 0x19bdd = "UB11B/MS-6823 802.11b Wi-Fi adapter" */
    'U','B','1','1','B','/','M','S','-','6','8','2','3',' ','\x9b','W','i','-','F','i',' ','\xd0',
/* 0x19bf3 = "Arduino Micro (bootloader)" */
    'A','r','d','u','i','n','o',' ','\xc4',' ','(','b','o','o','t','l','o','a','d','e','r',')',
/* 0x19c09 = "LPC2378 [Robotino-Arm]" */
    'L','P','C','2','3','7','8',' ','[','R','o','b','o','t','i','n','o','-','A','r','m',']',
/* 0x19c1f = "MA i-gotU Travel Logger GPS" */
    'M','A',' ','i','-','g','o','t','U',' ','\xd9',' ','L','o','g','g','e','r',' ','G','P','S',
/* 0x19c35 = "Velleman Components, Inc." */
    'V','e','l','l','e','m','a','n',' ','C','o','m','p','o','n','e','n','t','s',',',' ','\x07',
/* 0x19c4b = "WNDA3100v2 802.11abgn [Broadcom BCM4323]" */
    'W','N','D','A','3','1','0','0','v','2',' ','\xea','[','\xeb','B','C','M','4','3','2','3',']',
/* 0x19c61 = "quanton flight control" */
    'q','u','a','n','t','o','n',' ','f','l','i','g','h','t',' ','c','o','n','t','r','o','l',
/* 0x19c77 = "IBM Infoprint 1410 MFP" */
    'I','B','M',' ','I','n','f','o','p','r','i','n','t',' ','1','4','1','0',' ','M','F','P',
/* 0x19c8d = "K-Series K61P MIDI studio controller" */
    'K','-','\xbf',' ','K','6','1','P',' ','M','I','D','I',' ','s','t','u','d','i','o',' ','\x9e',
/* 0x19ca3 = "W580i Phone (mass storage)" */
    'W','5','8','0','i',' ','\x19',' ','(','m','a','s','s',' ','s','t','o','r','a','g','e',')',
/* 0x19cb9 = "WinFast TV Audio - PHP PAL DK+TXT" */
    'W','i','n','\xec','\xda','\x8b','-',' ','P','H','P',' ','P','A','L',' ','D','K','+','T','X','T',
/* 0x19ccf = "PhidgetTextLED Ver 1.0" */
    'P','h','i','d','g','e','t','T','e','x','t','L','E','D',' ','V','e','r',' ','1','.','0',
/* 0x19ce5 = "ISDN-Connector FRITZ!X" */
    'I','S','D','N','-','C','o','n','n','e','c','t','o','r',' ','F','R','I','T','Z','!','X',
/* 0x19cfb = "15901 802.11bg Wireless Adapter [Realtek RTL8187L]" */
    '1','5','9','0','1',' ','\xad',' ','\x01','\x02',' ','[','\xbe','R','T','L','8','1','8','7','L',']',
/* 0x19d11 = "SideWinder Precision 2" */
    'S','i','d','e','W','i','n','d','e','r',' ','P','r','e','c','i','s','i','o','n',' ','2',
/* 0x19d27 = "i2c-tiny-usb interface" */
    'i','2','c','-','t','i','n','y','-','u','s','b',' ','i','n','t','e','r','f','a','c','e',
/* 0x19d3d = "PoPo Mini Pointer Mouse (HID)" */
    'P','o','P','o',' ','\xb9',' ','P','o','i','n','t','e','r',' ','\x0b',' ','(','H','I','D',')',
/* 0x19d53 = "RayComposer - R. Adams" */
    'R','a','y','C','o','m','p','o','s','e','r',' ','-',' ','R','.',' ','A','d','a','m','s',
/* 0x19d69 = "DTK-2100 [Cintiq 21UX]" */
    'D','T','K','-','2','1','0','0',' ','[','C','i','n','t','i','q',' ','2','1','U','X',']',
/* 0x19d7f = "CG-WLUSB10 Corega Wireless USB Adapter" */
    'C','G','-','W','L','U','S','B','1','0',' ','C','o','r','e','g','a',' ','\x01','\x0a',' ','\x02',
/* 0x19d95 = "802.11n/b/g Wireless LAN USB2.0 Adapter" */
    '8','0','2','.','1','1','n','/','b','/','g',' ','\x01','\xf3','U','S','B','2','.','0',' ','\x02',
/* 0x19dab = "Pro Flight Rudder Pedals" */
    '\x8f',' ','F','l','i','g','h','t',' ','R','u','d','d','e','r',' ','P','e','d','a','l','s',
/* 0x19dc1 = "DCP1000 Port(FaxModem)" */
    'D','C','P','1','0','0','0',' ','P','o','r','t','(','F','a','x','M','o','d','e','m',')',
/* 0x19dd7 = "MFC-8860DN Port(FaxModem)" */
    '\x7d','8','8','6','0','D','N',' ','P','o','r','t','(','F','a','x','M','o','d','e','m',')',
/* 0x19ded = "2N TELEKOMUNIKACE a.s." */
    '2','N',' ','T','E','L','E','K','O','M','U','N','I','K','A','C','E',' ','a','.','s','.',
/* 0x19e03 = "RM-203 USB Nest [mode 4]" */
    'R','M','-','2','0','3',' ','\x0a',' ','N','e','s','t',' ','[','m','o','d','e',' ','4',']',
/* 0x19e19 = "MFC-3820JN Port(FaxModem)" */
    '\x7d','3','8','2','0','J','N',' ','P','o','r','t','(','F','a','x','M','o','d','e','m',')',
/* 0x19e2f = "raphnet.net usb_game12" */
    'r','a','p','h','n','e','t','.','n','e','t',' ','u','s','b','_','g','a','m','e','1','2',
/* 0x19e45 = "Todos Argos Mini II Smart Card Reader" */
    'T','o','d','o','s',' ','A','r','g','o','s',' ','\xb9',' ','I','I',' ','\x12',' ','\x15',' ','\x08',
/* 0x19e5b = "Silicon Motion SM370 Camera" */
    'S','i','l','i','c','o','n',' ','M','o','t','i','o','n',' ','S','M','3','7','0',' ','\x04',
/* 0x19e71 = "National Instruments Corp." */
    'N','a','t','i','o','n','a','l',' ','I','n','s','t','r','u','m','e','n','t','s',' ','\x10',
/* 0x19e87 = "eBookman Palm Computer" */
    'e','B','o','o','k','m','a','n',' ','P','a','l','m',' ','C','o','m','p','u','t','e','r',
/* 0x19e9d = "Honda Tsushin Kogyo Co., Ltd" */
    'H','o','n','d','a',' ','T','s','u','s','h','i','n',' ','K','o','g','y','o',' ','\x0e','\x16',
/* 0x19eb3 = "MN-510 802.11b Wireless Adapter [Intersil ISL3873B]" */
    'M','N','-','5','1','0',' ','\x9b','\x01','\x02',' ','[','\xb0','I','S','L','3','8','7','3','B',']',
/* 0x19ec9 = "Airprime, Incorporated" */
    'A','i','r','p','r','i','m','e',',',' ','I','n','c','o','r','p','o','r','a','t','e','d',
/* 0x19edf = "RadioShack Corporation" */
    'R','a','d','i','o','S','h','a','c','k',' ','C','o','r','p','o','r','a','t','i','o','n',
/* 0x19ef5 = "VistaScan Astra 3600(ENG)" */
    'V','i','s','t','a','\x8a',' ','A','s','t','r','a',' ','3','6','0','0','(','E','N','G',')',
/* 0x19f0b = "PM-A850 [Stylus Photo RX600/610]" */
    'P','M','-','A','8','5','0',' ','[','\xb1','\x86',' ','R','X','6','0','0','/','6','1','0',']',
/* 0x19f21 = "Mouse*in*a*Box Optical" */
    'M','o','u','s','e','*','i','n','*','a','*','B','o','x',' ','O','p','t','i','c','a','l',
/* 0x19f37 = "FreeAgent XTreme 640GB" */
    'F','r','e','e','A','g','e','n','t',' ','X','T','r','e','m','e',' ','6','4','0','G','B',
/* 0x19f4d = "Himalaya GSM/GPRS Pocket PC" */
    'H','i','m','a','l','a','y','a',' ','G','S','M','/','G','P','R','S',' ','\x17',' ','P','C',
/* 0x19f63 = "USB-IDE Bridge: DUB-PxxG" */
    '\x0a','-','I','D','E',' ','B','r','i','d','g','e',':',' ','D','U','B','-','P','x','x','G',
/* 0x19f79 = "mmO2 XDA GSM/GPRS Pocket PC" */
    'm','m','O','2',' ','X','D','A',' ','G','S','M','/','G','P','R','S',' ','\x17',' ','P','C',
/* 0X19f8f = "Connect2Air E-5400 802.11g Wireless Adapter" */
    'o','n','n','e','c','t','2','A','i','r',' ','E','-','5','4','0','0',' ','\x94','\x01','\x02',
/* 0x19fa4 = "Transformer Pad TF300TG" */
    'T','r','a','n','s','f','o','r','m','e','r',' ','\xfa',' ','T','F','3','0','0','T','G',
/* 0x19fb9 = "OneTouch II 300GB External Hard Disk" */
    'O','n','e','\x9d',' ','I','I',' ','3','0','0','G','B',' ','\xe3','H','a','r','d',' ','\xe8',
/* 0x19fce = "Microtek ArtixScan 1800f" */
    'M','i','c','r','o','t','e','k',' ','A','r','t','i','x','\x8a',' ','1','8','0','0','f',
/* 0x19fe3 = "Plugable UD-160-A (M)" */
    'P','l','u','g','a','b','l','e',' ','U','D','-','1','6','0','-','A',' ','(','M',')',
/* 0x19ff8 = "AB-1.x UAC2 [Audio Widget]" */
    'A','B','-','1','.','x',' ','U','A','C','2',' ','[','\x8b','W','i','d','g','e','t',']',
/* 0x1a00d = "DVC-800 (PAL) Grabber" */
    'D','V','C','-','8','0','0',' ','(','P','A','L',')',' ','G','r','a','b','b','e','r',
/* 0x1a022 = "ML-6060 laser printer" */
    'M','L','-','6','0','6','0',' ','l','a','s','e','r',' ','p','r','i','n','t','e','r',
/* 0x1a037 = "MS single card reader" */
    'M','S',' ','s','i','n','g','l','e',' ','c','a','r','d',' ','r','e','a','d','e','r',
/* 0x1a04c = "TrackMan Marble Wheel" */
    'T','r','a','c','k','M','a','n',' ','M','a','r','b','l','e',' ','W','h','e','e','l',
/* 0x1a061 = "Casira with BlueCore4-Multimedia Module" */
    'C','a','s','i','r','a',' ','\x98','B','l','u','e','C','o','r','e','4','-','\xe2',' ','\xe5',
/* 0x1a076 = "Jumpdrive Secure 64MB" */
    'J','u','m','p','d','r','i','v','e',' ','S','e','c','u','r','e',' ','6','4','M','B',
/* 0x1a08b = "nanoKEY MIDI keyboard" */
    'n','a','n','o','K','E','Y',' ','M','I','D','I',' ','k','e','y','b','o','a','r','d',
/* 0x1a0a0 = "Eumex 704PC DSL (FlashLoad)" */
    'E','u','m','e','x',' ','7','0','4','\x1f','D','S','L',' ','(','\x3c','L','o','a','d',')',
/* 0x1a0b5 = "MF 195E (HSPA+ Modem)" */
    'M','F',' ','1','9','5','E',' ','(','H','S','P','A','+',' ','M','o','d','e','m',')',
/* 0x1a0ca = "3CP4218 ADSL Modem (pre-init)" */
    '3','C','P','4','2','1','8',' ','\xf1','\x1c',' ','(','p','r','e','-','i','n','i','t',')',
/* 0x1a0df = "Semiconductors CICT Hub" */
    'S','e','m','i','c','o','n','d','u','c','t','o','r','s',' ','C','I','C','T',' ','\xa4',
/* 0x1a0f4 = "MSM6025 chipset flash" */
    'M','S','M','6','0','2','5',' ','c','h','i','p','s','e','t',' ','f','l','a','s','h',
/* 0x1a109 = "Alpermann+Velte TCC70" */
    'A','l','p','e','r','m','a','n','n','+','V','e','l','t','e',' ','T','C','C','7','0',
/* 0x1a11e = "Harmony 785/880/885 Remote" */
    'H','a','r','m','o','n','y',' ','7','8','5','/','8','8','0','/','8','8','5',' ','\xcb',
/* 0x1a133 = "V800-Vodafone 802SE Phone" */
    'V','8','0','0','-','V','o','d','a','f','o','n','e',' ','8','0','2','S','E',' ','\x19',
/* 0x1a148 = "Axon CNS, MultiClamp 700B" */
    'A','x','o','n',' ','C','N','S',',',' ','\xd6','C','l','a','m','p',' ','7','0','0','B',
/* 0x1a15d = "Phantom 336CX/C3 (#2)" */
    'P','h','a','n','t','o','m',' ','3','3','6','C','X','/','C','3',' ','(','#','2',')',
/* 0x1a172 = "Targus Mini Trackball Optical Mouse" */
    'T','a','r','g','u','s',' ','\xb9',' ','T','r','a','c','k','b','a','l','l',' ','\x7b','\x0b',
/* 0x1a187 = "Mustek BearPaw 2400 Scanner" */
    'M','u','s','t','e','k',' ','B','e','a','r','P','a','w',' ','2','4','0','0',' ','\x25',
/* 0x1a19c = "Micro Innovations IC50C Webcam" */
    '\xc4',' ','I','n','n','o','v','a','t','i','o','n','s',' ','I','C','5','0','C',' ','\x11',
/* 0x1a1b1 = "Trifid Camera without code" */
    'T','r','i','f','i','d',' ','\x04',' ','w','i','t','h','o','u','t',' ','c','o','d','e',
/* 0x1a1c6 = "ANYCOM Blue USB-200/250" */
    'A','N','Y','C','O','M',' ','B','l','u','e',' ','\x0a','-','2','0','0','/','2','5','0',
/* 0x1a1db = "Bluetooth Headset in DFU mode" */
    '\x06',' ','H','e','a','d','s','e','t',' ','i','n',' ','D','F','U',' ','m','o','d','e',
/* 0x1a1f0 = "WKB-2000 Wireless Keyboard with Touchpad" */
    'W','K','B','-','2','0','0','0',' ','\x01','\x05',' ','\x98','T','o','u','c','h','p','a','d',
/* 0x1a205 = "10.1 Touch screen overlay" */
    '1','0','.','1',' ','\x9d',' ','s','c','r','e','e','n',' ','o','v','e','r','l','a','y',
/* 0x1a21a = "Mustek BearPaw 1200 Scanner" */
    'M','u','s','t','e','k',' ','B','e','a','r','P','a','w',' ','1','2','0','0',' ','\x25',
/* 0x1a22f = "Efficient Networks, Inc." */
    'E','f','f','i','c','i','e','n','t',' ','N','e','t','w','o','r','k','s',',',' ','\x07',
/* 0x1a244 = "6700 Classic (PC Suite)" */
    '6','7','0','0',' ','C','l','a','s','s','i','c',' ','(','\x1f','S','u','i','t','e',')',
/* 0x1a259 = "INIC-1608 SATA bridge" */
    'I','N','I','C','-','1','6','0','8',' ','S','A','T','A',' ','b','r','i','d','g','e',
/* 0x1a26e = "EOS 300D / EOS Digital Rebel" */
    'E','O','S',' ','3','0','0','D',' ','/',' ','E','O','S',' ','\x09','R','e','b','e','l',
/* 0x1a283 = "Stargate Solutions, Inc." */
    'S','t','a','r','g','a','t','e',' ','S','o','l','u','t','i','o','n','s',',',' ','\x07',
/* 0x1a298 = "BC106 Camera Beam Profiler" */
    'B','C','1','0','6',' ','\x04',' ','B','e','a','m',' ','P','r','o','f','i','l','e','r',
/* 0x1a2ad = "Xbox DVD Playback Kit" */
    'X','b','o','x',' ','D','V','D',' ','P','l','a','y','b','a','c','k',' ','K','i','t',
/* 0x1a2c2 = "Mimaki Engineering Co., Ltd" */
    'M','i','m','a','k','i',' ','E','n','g','i','n','e','e','r','i','n','g',' ','\x0e','\x16',
/* 0x1a2d7 = "PC Camera (SN9C201 + OV9655)" */
    '\x1f','\x04',' ','(','S','N','9','C','2','0','1',' ','+',' ','O','V','9','6','5','5',')',
/* 0x1a2ec = "DCP-7057 scanner/printer" */
    '\xaa','7','0','5','7',' ','s','c','a','n','n','e','r','/','p','r','i','n','t','e','r',
/* 0x1a301 = "Mouse/Keyboard 2.4GHz Transceiver V2.0" */
    'M','o','u','s','e','/','\x05',' ','2','.','4','G','H','z',' ','\xc8',' ','V','2','.','0',
/* 0x1a316 = "DY-WL10 802.11abgn Adapter [Broadcom BCM4323]" */
    'D','Y','-','W','L','1','0',' ','\xea','\x02',' ','[','\xeb','B','C','M','4','3','2','3',']',
/* 0x1a32b = "PC Camera (SN9C325 + OM6802)" */
    '\x1f','\x04',' ','(','S','N','9','C','3','2','5',' ','+',' ','O','M','6','8','0','2',')',
/* 0x1a340 = "DWM-156 3.75G HSUPA Adapter" */
    'D','W','M','-','1','5','6',' ','3','.','7','5','G',' ','H','S','U','P','A',' ','\x02',
/* 0x1a355 = "FinePix A202, A200 Zoom (DSC)" */
    '\xca','i','x',' ','A','2','0','2',',',' ','A','2','0','0',' ','\xe6','(','D','S','C',')',
/* 0x1a36a = "CanoScan FS4000US Film Scanner" */
    'C','a','n','o','\x8a',' ','F','S','4','0','0','0','U','S',' ','F','i','l','m',' ','\x25',
/* 0x1a37f = "TV Wonder, Edition (FQ)" */
    '\xda','W','o','n','d','e','r',',',' ','E','d','i','t','i','o','n',' ','(','F','Q',')',
/* 0x1a394 = "TT-connect CT-3650 CI" */
    'T','T','-','c','o','n','n','e','c','t',' ','C','T','-','3','6','5','0',' ','C','I',
/* 0x1a3a9 = "Phogenix Imaging, LLC" */
    'P','h','o','g','e','n','i','x',' ','I','m','a','g','i','n','g',',',' ','L','L','C',
/* 0x1a3be = "I/O Development Board" */
    'I','/','O',' ','D','e','v','e','l','o','p','m','e','n','t',' ','B','o','a','r','d',
/* 0x1a3d3 = "UR054g 802.11g Wireless Adapter [Intersil ISL3887]" */
    'U','R','0','5','4','g',' ','\x94','\x01','\x02',' ','[','\xb0','I','S','L','3','8','8','7',']',
/* 0x1a3e8 = "Integrated Touchpad [Synaptics]" */
    '\x18','T','o','u','c','h','p','a','d',' ','[','S','y','n','a','p','t','i','c','s',']',
/* 0x1a3fd = "PhidgetMotorControl Ver 1.0" */
    'P','h','i','d','g','e','t','M','o','t','o','r','\xc9',' ','V','e','r',' ','1','.','0',
/* 0x1a412 = "WinFast TV Audio - PHP PAL I+TXT" */
    'W','i','n','\xec','\xda','\x8b','-',' ','P','H','P',' ','P','A','L',' ','I','+','T','X','T',
/* 0x1a427 = "Bachrus Speedometer Interface" */
    'B','a','c','h','r','u','s',' ','S','p','e','e','d','o','m','e','t','e','r',' ','\x81',
/* 0x1a43c = "CVT Electronics.Co.,Ltd" */
    'C','V','T',' ','E','l','e','c','t','r','o','n','i','c','s','.','C','o','.',',','\x16',
/* 0x1a451 = "ME 320/330 Series [Stylus SX125]" */
    'M','E',' ','3','2','0','/','3','3','0',' ','\xbf',' ','[','\xb1','S','X','1','2','5',']',
/* 0x1a466 = "GT-X800 [Perfection 4990 PHOTO]" */
    'G','T','-','X','8','0','0',' ','[','\xf0','4','9','9','0',' ','P','H','O','T','O',']',
/* 0x1a47b = "CTF-221 [PenPartner2]" */
    'C','T','F','-','2','2','1',' ','[','P','e','n','P','a','r','t','n','e','r','2',']',
/* 0x1a490 = "TTP Communications, Ltd" */
    'T','T','P',' ','C','o','m','m','u','n','i','c','a','t','i','o','n','s',',',' ','\x16',
/* 0x1a4a5 = "Formosa Industrial Computing, Inc." */
    'F','o','r','m','o','s','a',' ','\xef','C','o','m','p','u','t','i','n','g',',',' ','\x07',
/* 0x1a4ba = "NetVista Full Width Keyboard" */
    'N','e','t','V','i','s','t','a',' ','F','u','l','l',' ','W','i','d','t','h',' ','\x05',
/* 0x1a4cf = "CH34x printer adapter cable" */
    'C','H','3','4','x',' ','p','r','i','n','t','e','r',' ','\xd0',' ','c','a','b','l','e',
/* 0x1a4e4 = "PC Camera (SN9C201 + OV7660)" */
    '\x1f','\x04',' ','(','S','N','9','C','2','0','1',' ','+',' ','O','V','7','6','6','0',')',
/* 0x1a4f9 = "Coolpix 8400 (mass storage mode)" */
    '\xdc','8','4','0','0',' ','(','m','a','s','s',' ','s','t','o','r','a','g','e',' ','\x1a',
/* 0x1a50e = "DVBSky S960 DVB-S2 tuner" */
    'D','V','B','S','k','y',' ','S','9','6','0',' ','\xa7','S','2',' ','t','u','n','e','r',
/* 0x1a523 = "Empeg-Car Mark I/II Player" */
    'E','m','p','e','g','-','C','a','r',' ','M','a','r','k',' ','I','/','I','I',' ','\x1e',
/* 0x1a538 = "CMOS 100K-R Rev. 1.90" */
    'C','M','O','S',' ','1','0','0','K','-','R',' ','R','e','v','.',' ','1','.','9','0',
/* 0x1a54d = "Toshiba Thrive tablet" */
    'T','o','s','h','i','b','a',' ','T','h','r','i','v','e',' ','t','a','b','l','e','t',
/* 0x1a562 = "ScanExpress 1200 CU Plus" */
    '\x8a','E','x','p','r','e','s','s',' ','1','2','0','0',' ','C','U',' ','P','l','u','s',
/* 0x1a577 = "NV-GS11/230/250 (DV mode)" */
    'N','V','-','G','S','1','1','/','2','3','0','/','2','5','0',' ','(','D','V',' ','\x1a',
/* 0x1a58c = "GT-X820 [Perfection V600 Photo]" */
    'G','T','-','X','8','2','0',' ','[','\xf0','V','6','0','0',' ','P','h','o','t','o',']',
/* 0x1a5a1 = "Diva ISDN 4.0 [HFC-S]" */
    'D','i','v','a',' ','I','S','D','N',' ','4','.','0',' ','[','H','F','C','-','S',']',
/* 0x1a5b6 = "MFC-8460N Port(FaxModem)" */
    '\x7d','8','4','6','0','N',' ','P','o','r','t','(','F','a','x','M','o','d','e','m',')',
/* 0x1a5cb = "Mega ADK R3 (CDC ACM)" */
    'M','e','g','a',' ','A','D','K',' ','R','3',' ','(','C','D','C',' ','A','C','M',')',
/* 0x1a5e0 = "Xbox360 Wireless Networking Adapter" */
    'X','b','o','x','3','6','0',' ','\x01','N','e','t','w','o','r','k','i','n','g',' ','\x02',
/* 0x1a5f5 = "Stylus CX4100/CX4200/DX4200" */
    '\xb1','C','X','4','1','0','0','/','C','X','4','2','0','0','/','D','X','4','2','0','0',
/* 0x1a60a = "6288 GSM Smartphone (imaging mode)" */
    '6','2','8','8',' ','G','S','M',' ','\xd4',' ','(','i','m','a','g','i','n','g',' ','\x1a',
/* 0x1a61f = "FHA-3510 2.4GHz Wireless Optical Mobile Mouse" */
    'F','H','A','-','3','5','1','0',' ','2','.','4','G','H','z',' ','\x01','\x7b','\x96',' ','\x0b',
/* 0x1a634 = "Digital TV USB Receiver (DVB-S/T/C / ATSC)" */
    '\x09','\xda','\x0a',' ','\x8c',' ','(','\xa7','S','/','T','/','C',' ','/',' ','A','T','S','C',')',
/* 0x1a649 = "Casira with BlueCore2-Flash Module" */
    'C','a','s','i','r','a',' ','\x98','B','l','u','e','C','o','r','e','2','-','\x3c',' ','\xe5',
/* 0x1a65e = "SD single card reader" */
    'S','D',' ','s','i','n','g','l','e',' ','c','a','r','d',' ','r','e','a','d','e','r',
/* 0x1a673 = "COMpact 2104 ISDN PBX" */
    'C','O','M','p','a','c','t',' ','2','1','0','4',' ','I','S','D','N',' ','P','B','X',
/* 0x1a688 = "Rainbow chipset flash" */
    'R','a','i','n','b','o','w',' ','c','h','i','p','s','e','t',' ','f','l','a','s','h',
/* 0x1a69d = "Asus 720p CMOS webcam" */
    'A','s','u','s',' ','7','2','0','p',' ','C','M','O','S',' ','w','e','b','c','a','m',
/* 0x1a6b2 = "Giesecke & Devrient GmbH" */
    'G','i','e','s','e','c','k','e',' ','&',' ','D','e','v','r','i','e','n','t',' ','\xfc',
/* 0x1a6c7 = "Pocket CAM 3 Mega (webcam)" */
    '\x17',' ','C','A','M',' ','3',' ','M','e','g','a',' ','(','w','e','b','c','a','m',')',
/* 0x1a6dc = "Braintechnology USB-LPS" */
    'B','r','a','i','n','t','e','c','h','n','o','l','o','g','y',' ','\x0a','-','L','P','S',
/* 0x1a6f1 = "Tatung Co. Of America" */
    'T','a','t','u','n','g',' ','C','o','.',' ','O','f',' ','A','m','e','r','i','c','a',
/* 0x1a706 = "Precision Squared Technology Corp." */
    'P','r','e','c','i','s','i','o','n',' ','S','q','u','a','r','e','d',' ','\x0d',' ','\x10',
/* 0x1a71b = "USB to CF+SD Drive(LC1)" */
    '\x0a',' ','t','o',' ','C','F','+','S','D',' ','D','r','i','v','e','(','L','C','1',')',
/* 0x1a730 = "Hercules Scan@home 48" */
    'H','e','r','c','u','l','e','s',' ','S','c','a','n','@','h','o','m','e',' ','4','8',
/* 0x1a745 = "POS Keyboard, TA85P-USB" */
    'P','O','S',' ','K','e','y','b','o','a','r','d',',',' ','T','A','8','5','P','-','\x0a',
/* 0x1a75a = "AND Serial Cable [AND Smart Cable]" */
    'A','N','D',' ','\x90',' ','\xa5',' ','[','A','N','D',' ','\x12',' ','C','a','b','l','e',']',
/* 0x1a76f = "ANT Development Board" */
    'A','N','T',' ','D','e','v','e','l','o','p','m','e','n','t',' ','B','o','a','r','d',
/* 0x1a784 = "PC Camera (SN9C201 + OM6802)" */
    '\x1f','\x04',' ','(','S','N','9','C','2','0','1',' ','+',' ','O','M','6','8','0','2',')',
/* 0x1a799 = "Series 2000 Combo Acceptor" */
    '\xbf',' ','2','0','0','0',' ','C','o','m','b','o',' ','A','c','c','e','p','t','o','r',
/* 0x1a7ae = "WGU-210 802.11g Adapter [Intersil ISL3886]" */
    'W','G','U','-','2','1','0',' ','\x94','\x02',' ','[','\xb0','I','S','L','3','8','8','6',']',
/* 0x1a7c3 = "Energizer Holdings, Inc." */
    'E','n','e','r','g','i','z','e','r',' ','H','o','l','d','i','n','g','s',',',' ','\x07',
/* 0x1a7d8 = "ATerm IT75DSU ISDN TA" */
    'A','T','e','r','m',' ','I','T','7','5','D','S','U',' ','I','S','D','N',' ','T','A',
/* 0x1a7ed = "FTDI232 [Netzteil-GL]" */
    'F','T','D','I','2','3','2',' ','[','N','e','t','z','t','e','i','l','-','G','L',']',
/* 0x1a802 = "AMP/Tycoelectronics Corp." */
    'A','M','P','/','T','y','c','o','e','l','e','c','t','r','o','n','i','c','s',' ','\x10',
/* 0x1a817 = "Meilu Electronics (Shenzhen) Co., Ltd" */
    'M','e','i','l','u',' ','\x1b',' ','(','S','h','e','n','z','h','e','n',')',' ','\x0e','\x16',
/* 0x1a82c = "Pro Flight Switch Panel" */
    '\x8f',' ','F','l','i','g','h','t',' ','S','w','i','t','c','h',' ','P','a','n','e','l',
/* 0x1a841 = "USB2.0-SCSI Bridge USB2-SC" */
    'U','S','B','2','.','0','-','S','C','S','I',' ','\x9f',' ','U','S','B','2','-','S','C',
/* 0X1a856 = "CopperJet 821 RouterPlus" */
    'o','p','p','e','r','\x80','8','2','1',' ','R','o','u','t','e','r','P','l','u','s',
/* 0x1a86a = "ZW-N290 802.11n [Realtek RTL8192SU]" */
    'Z','W','-','N','2','9','0',' ','\x99','[','\xbe','R','T','L','8','1','9','2','S','U',']',
/* 0x1a87f = "Bludrive Family Smart Card Reader" */
    'B','l','u','d','r','i','v','e',' ','F','a','m','i','l','y',' ','\x12',' ','\x15',' ','\x08',
/* 0x1a894 = "G-270S 802.11bg Wireless Adapter [Atheros AR5523]" */
    'G','-','2','7','0','S',' ','\xad',' ','\x01','\x02',' ','[','\xaf','A','R','5','5','2','3',']',
/* 0x1a8a9 = "Essential Reality LLC" */
    'E','s','s','e','n','t','i','a','l',' ','R','e','a','l','i','t','y',' ','L','L','C',
/* 0x1a8be = "SlimBlade Presenter Mouse" */
    'S','l','i','m','B','l','a','d','e',' ','P','r','e','s','e','n','t','e','r',' ','\x0b',
/* 0x1a8d3 = "Advance Multimedia Internet Technology Inc. (AMIT)" */
    'A','d','v','a','n','c','e',' ','\xe2',' ','\xb6','\x0d',' ','\x07',' ','(','A','M','I','T',')',
/* 0x1a8e8 = "PowerSure Interactive UPS" */
    '\x24','S','u','r','e',' ','I','n','t','e','r','a','c','t','i','v','e',' ','U','P','S',
/* 0x1a8fd = "Binatone ADSL500 Modem Network Interface" */
    'B','i','n','a','t','o','n','e',' ','A','D','S','L','5','0','0',' ','\x1c',' ','\x8d','\x81',
/* 0x1a912 = "Harting Elektronik, Inc." */
    'H','a','r','t','i','n','g',' ','E','l','e','k','t','r','o','n','i','k',',',' ','\x07',
/* 0x1a927 = "Flash Drive 2 GB [ICIDU 2 GB]" */
    '\x3c',' ','\x14',' ','2',' ','G','B',' ','[','I','C','I','D','U',' ','2',' ','G','B',']',
/* 0x1a93c = "NEC Viewtechnology, Ltd" */
    'N','E','C',' ','V','i','e','w','t','e','c','h','n','o','l','o','g','y',',',' ','\x16',
/* 0x1a951 = "Azurewave 43228+20702" */
    'A','z','u','r','e','w','a','v','e',' ','4','3','2','2','8','+','2','0','7','0','2',
/* 0x1a966 = "Konica Minolta SC-110" */
    'K','o','n','i','c','a',' ','M','i','n','o','l','t','a',' ','S','C','-','1','1','0',
/* 0x1a97b = "TT-connect S2-3650 CI" */
    'T','T','-','c','o','n','n','e','c','t',' ','S','2','-','3','6','5','0',' ','C','I',
/* 0x1a990 = "Gamtec.,Ltd SmartJoy PLUS Adapter" */
    'G','a','m','t','e','c','.',',','\x16',' ','\x12','J','o','y',' ','P','L','U','S',' ','\x02',
/* 0x1a9a5 = "Plastron Precision Co., Ltd." */
    'P','l','a','s','t','r','o','n',' ','P','r','e','c','i','s','i','o','n',' ','\x0e','\xab',
/* 0x1a9ba = "HCF V90 Data Fax Voice Modem" */
    'H','C','F',' ','V','9','0',' ','\xe7',' ','F','a','x',' ','V','o','i','c','e',' ','\x1c',
/* 0x1a9cf = "Infinite Data Storage, Ltd" */
    'I','n','f','i','n','i','t','e',' ','\xe7',' ','S','t','o','r','a','g','e',',',' ','\x16',
/* 0x1a9e4 = "Alienware Corporation" */
    'A','l','i','e','n','w','a','r','e',' ','C','o','r','p','o','r','a','t','i','o','n',
/* 0x1a9f9 = "Genius TVGo DVB-T02Q MCE" */
    'G','e','n','i','u','s',' ','T','V','G','o',' ','\xa7','T','0','2','Q',' ','M','C','E',
/* 0x1aa0e = "Mag Turbo Force Wheel" */
    'M','a','g',' ','T','u','r','b','o',' ','F','o','r','c','e',' ','W','h','e','e','l',
/* 0x1aa23 = "GT-E2370 mobile phone" */
    'G','T','-','E','2','3','7','0',' ','m','o','b','i','l','e',' ','p','h','o','n','e',
/* 0x1aa38 = "Ericsson Austrian, AG" */
    'E','r','i','c','s','s','o','n',' ','A','u','s','t','r','i','a','n',',',' ','A','G',
/* 0x1aa4d = "ConvertX PX-TV402U/NA" */
    'C','o','n','v','e','r','t','X',' ','P','X','-','T','V','4','0','2','U','/','N','A',
/* 0x1aa62 = "MFC580 Port(FaxModem)" */
    'M','F','C','5','8','0',' ','P','o','r','t','(','F','a','x','M','o','d','e','m',')',
/* 0x1aa77 = "MFC-7820N Port(FaxModem)" */
    '\x7d','7','8','2','0','N',' ','P','o','r','t','(','F','a','x','M','o','d','e','m',')',
/* 0x1aa8c = "Greatlink Electronics Taiwan, Ltd" */
    'G','r','e','a','t','l','i','n','k',' ','\x1b',' ','T','a','i','w','a','n',',',' ','\x16',
/* 0x1aaa1 = "CECT M800 memory card" */
    'C','E','C','T',' ','M','8','0','0',' ','m','e','m','o','r','y',' ','c','a','r','d',
/* 0x1aab6 = "NCM (Ethernet) Gadget" */
    'N','C','M',' ','(','E','t','h','e','r','n','e','t',')',' ','G','a','d','g','e','t',
/* 0x1aacb = "EUB9801 802.11abgn Wireless Adapter [Ralink RT3572]" */
    'E','U','B','9','8','0','1',' ','\xea','\x01','\x02',' ','[','\x93','R','T','3','5','7','2',']',
/* 0x1aae0 = "Geniatech T220 DVB-T2 TV Stick" */
    'G','e','n','i','a','t','e','c','h',' ','T','2','2','0',' ','\xa7','T','2',' ','\xda','\xb3',
/* 0x1aaf5 = "EP-9001-g 802.11g 54M WLAN Adapter" */
    'E','P','-','9','0','0','1','-','g',' ','\x94','5','4','M',' ','W','L','A','N',' ','\x02',
/* 0x1ab0a = "Consumer Infrared Transceiver (SRM5100)" */
    'C','o','n','s','u','m','e','r',' ','\xa8','\xc8',' ','(','S','R','M','5','1','0','0',')',
/* 0x1ab1f = "Sansa E200 series v2 (mtp)" */
    'S','a','n','s','a',' ','E','2','0','0',' ','\x1d',' ','v','2',' ','(','m','t','p',')',
/* 0x1ab34 = "R205 Mobile WiFi (CD-ROM mode)" */
    'R','2','0','5',' ','\x96',' ','W','i','F','i',' ','(','C','D','-','R','O','M',' ','\x1a',
/* 0x1ab49 = "Jess-Link Products Co., Ltd" */
    'J','e','s','s','-','L','i','n','k',' ','P','r','o','d','u','c','t','s',' ','\x0e','\x16',
/* 0x1ab5e = "Xerox Phaser 3635MFPX" */
    'X','e','r','o','x',' ','P','h','a','s','e','r',' ','3','6','3','5','M','F','P','X',
/* 0x1ab73 = "Kingston Technology Company, Inc." */
    'K','i','n','g','s','t','o','n',' ','\x0d',' ','C','o','m','p','a','n','y',',',' ','\x07',
/* 0x1ab88 = "Greenconn (U.S.A.), Inc." */
    'G','r','e','e','n','c','o','n','n',' ','(','U','.','S','.','A','.',')',',',' ','\x07',
/* 0x1ab9d = "Mouseman Dual Optical" */
    'M','o','u','s','e','m','a','n',' ','D','u','a','l',' ','O','p','t','i','c','a','l',
/* 0x1abb2 = "Hauppauge WinTV-USB UK with FM Radio" */
    '\xfb','W','i','n','T','V','-','\x0a',' ','U','K',' ','\x98','F','M',' ','R','a','d','i','o',
/* 0x1abc7 = "Aosta CX100 Webcam Storage" */
    'A','o','s','t','a',' ','C','X','1','0','0',' ','\x11',' ','S','t','o','r','a','g','e',
/* 0x1abdc = "UPort 1410 4-Port RS-232" */
    'U','P','o','r','t',' ','1','4','1','0',' ','4','-','\x87',' ','R','S','-','2','3','2',
/* 0X1abf1 = "2 port to Serial Converter" */
    ' ','p','o','r','t',' ','t','o',' ','\x90',' ','C','o','n','v','e','r','t','e','r',
/* 0x1ac05 = "PC Camera (SN9C201 + MI1310)" */
    '\x1f','\x04',' ','(','S','N','9','C','2','0','1',' ','+',' ','M','I','1','3','1','0',')',
/* 0x1ac1a = "Brother Industries, Ltd" */
    'B','r','o','t','h','e','r',' ','I','n','d','u','s','t','r','i','e','s',',',' ','\x16',
/* 0x1ac2f = "MSM6500 chipset flash" */
    'M','S','M','6','5','0','0',' ','c','h','i','p','s','e','t',' ','f','l','a','s','h',
/* 0x1ac44 = "Eumex 504 SE (Flash-Mode)" */
    'E','u','m','e','x',' ','5','0','4',' ','S','E',' ','(','\x3c','-','M','o','d','e',')',
/* 0x1ac59 = "Nogatech TV! (PAL-I-)" */
    'N','o','g','a','t','e','c','h',' ','T','V','!',' ','(','P','A','L','-','I','-',')',
/* 0x1ac6e = "POS Keyboard, TA58P-USB" */
    'P','O','S',' ','K','e','y','b','o','a','r','d',',',' ','T','A','5','8','P','-','\x0a',
/* 0x1ac83 = "IntelliMouse Explorer 3.0" */
    'I','n','t','e','l','l','i','\x0b',' ','E','x','p','l','o','r','e','r',' ','3','.','0',
/* 0x1ac98 = "Xerox Phaser 3117 Laser Printer" */
    'X','e','r','o','x',' ','P','h','a','s','e','r',' ','3','1','1','7',' ','\x82',' ','\x0c',
/* 0x1acad = "thinkpad t430s camera" */
    't','h','i','n','k','p','a','d',' ','t','4','3','0','s',' ','c','a','m','e','r','a',
/* 0x1acc2 = "Stylus CX5200/CX5300/CX5400" */
    '\xb1','C','X','5','2','0','0','/','C','X','5','3','0','0','/','C','X','5','4','0','0',
/* 0x1acd7 = "DWM-152 3.75G HSUPA Adapter" */
    'D','W','M','-','1','5','2',' ','3','.','7','5','G',' ','H','S','U','P','A',' ','\x02',
/* 0x1acec = "PC Camera (SN9C201 + CX1332)" */
    '\x1f','\x04',' ','(','S','N','9','C','2','0','1',' ','+',' ','C','X','1','3','3','2',')',
/* 0x1ad01 = "LUFA USB to Serial Adapter Project" */
    'L','U','F','A',' ','\x0a',' ','t','o',' ','\x90',' ','\x02',' ','P','r','o','j','e','c','t',
/* 0x1ad16 = "UFD MP3 player (model 1)" */
    'U','F','D',' ','\x8e','p','l','a','y','e','r',' ','(','m','o','d','e','l',' ','1',')',
/* 0x1ad2b = "Perception Digital, Ltd" */
    'P','e','r','c','e','p','t','i','o','n',' ','D','i','g','i','t','a','l',',',' ','\x16',
/* 0x1ad40 = "Berkshire Products, Inc." */
    'B','e','r','k','s','h','i','r','e',' ','P','r','o','d','u','c','t','s',',',' ','\x07',
/* 0x1ad55 = "UMAX AstraSlim 1200 Scanner" */
    'U','M','A','X',' ','A','s','t','r','a','S','l','i','m',' ','1','2','0','0',' ','\x25',
/* 0x1ad6a = "QuickCam Deluxe for Notebooks" */
    '\xc7','a','m',' ','D','e','l','u','x','e',' ','\xcc','N','o','t','e','b','o','o','k','s',
/* 0x1ad7f = "EOS 1D Mark II (PTP mode)" */
    'E','O','S',' ','1','D',' ','M','a','r','k',' ','I','I',' ','(','P','T','P',' ','\x1a',
/* 0x1ad94 = "Trimble Navigation, Ltd" */
    'T','r','i','m','b','l','e',' ','N','a','v','i','g','a','t','i','o','n',',',' ','\x16',
/* 0x1ada9 = "Bayer Health Care LLC" */
    'B','a','y','e','r',' ','H','e','a','l','t','h',' ','C','a','r','e',' ','L','L','C',
/* 0x1adbe = "Gemalto (was Gemplus)" */
    'G','e','m','a','l','t','o',' ','(','w','a','s',' ','G','e','m','p','l','u','s',')',
/* 0x1add3 = "PTK-650 [Intuos5 (M)]" */
    'P','T','K','-','6','5','0',' ','[','I','n','t','u','o','s','5',' ','(','M',')',']',
/* 0x1ade8 = "Japan Cash Machine Co., Ltd." */
    'J','a','p','a','n',' ','C','a','s','h',' ','M','a','c','h','i','n','e',' ','\x0e','\xab',
/* 0x1adfd = "Research In Motion, Ltd." */
    'R','e','s','e','a','r','c','h',' ','I','n',' ','M','o','t','i','o','n',',',' ','\xab',
/* 0x1ae12 = "FinePix A204/2650 Zoom (PC CAM)" */
    '\xca','i','x',' ','A','2','0','4','/','2','6','5','0',' ','\xe6','(','\x1f','C','A','M',')',
/* 0x1ae27 = "SDDR-113 MicroMate SDHC Reader" */
    'S','D','D','R','-','1','1','3',' ','\xc4','M','a','t','e',' ','S','D','H','C',' ','\x08',
/* 0x1ae3c = "FITEL PHS U Cable Adaptor" */
    'F','I','T','E','L',' ','P','H','S',' ','U',' ','\xa5',' ','A','d','a','p','t','o','r',
/* 0x1ae51 = "Dalhart EZX config 17" */
    'D','a','l','h','a','r','t',' ','E','Z','X',' ','c','o','n','f','i','g',' ','1','7',
/* 0x1ae66 = "Dalhart EZX config 18" */
    'D','a','l','h','a','r','t',' ','E','Z','X',' ','c','o','n','f','i','g',' ','1','8',
/* 0x1ae7b = "Multifunction Composite Gadget" */
    'M','u','l','t','i','f','u','n','c','t','i','o','n',' ','\x60','G','a','d','g','e','t',
/* 0x1ae90 = "Cyborg Command Pad Unit" */
    'C','y','b','o','r','g',' ','C','o','m','m','a','n','d',' ','\xfa',' ','U','n','i','t',
/* 0x1aea5 = "Huan Hsin Holdings, Ltd" */
    'H','u','a','n',' ','H','s','i','n',' ','H','o','l','d','i','n','g','s',',',' ','\x16',
/* 0x1aeba = "Zyla 5.5 sCMOS camera" */
    'Z','y','l','a',' ','5','.','5',' ','s','C','M','O','S',' ','c','a','m','e','r','a',
/* 0x1aecf = "FDM 2xxx Flash-OFDM modem" */
    'F','D','M',' ','2','x','x','x',' ','\x3c','-','O','F','D','M',' ','m','o','d','e','m',
/* 0x1aee4 = "Memorystick MSC-U03 Reader" */
    'M','e','m','o','r','y','s','t','i','c','k',' ','M','S','C','-','U','0','3',' ','\x08',
/* 0x1aef9 = "Sansa M200 series V4 (msc)" */
    'S','a','n','s','a',' ','M','2','0','0',' ','\x1d',' ','V','4',' ','(','m','s','c',')',
/* 0x1af0e = "Tremon Enterprises Co., Ltd" */
    'T','r','e','m','o','n',' ','E','n','t','e','r','p','r','i','s','e','s',' ','\x0e','\x16',
/* 0x1af23 = "4 Axis 12 button +POV" */
    '4',' ','A','x','i','s',' ','1','2',' ','b','u','t','t','o','n',' ','+','P','O','V',
/* 0x1af38 = "WL-353 Wireless USB Adapter 150N Nano" */
    'W','L','-','3','5','3',' ','\x01','\x0a',' ','\x02',' ','1','5','0','N',' ','N','a','n','o',
/* 0x1af4d = "Advanced Connectek, Inc." */
    'A','d','v','a','n','c','e','d',' ','C','o','n','n','e','c','t','e','k',',',' ','\x07',
/* 0x1af62 = "Wireless 360 Bluetooth 2.0 + EDR module." */
    '\x01','3','6','0',' ','\x06',' ','\xc1','+',' ','E','D','R',' ','m','o','d','u','l','e','.',
/* 0x1af77 = "multimedia keyboard controller" */
    'm','u','l','t','i','m','e','d','i','a',' ','k','e','y','b','o','a','r','d',' ','\x9e',
/* 0x1af8c = "Sansa Connect (in recovery mode)" */
    'S','a','n','s','a',' ','\xee','(','i','n',' ','r','e','c','o','v','e','r','y',' ','\x1a',
/* 0x1afa1 = "Coolpix 4200 (mass storage mode)" */
    '\xdc','4','2','0','0',' ','(','m','a','s','s',' ','s','t','o','r','a','g','e',' ','\x1a',
/* 0x1afb6 = "Jenoptik jdc 21 LCD Camera" */
    'J','e','n','o','p','t','i','k',' ','j','d','c',' ','2','1',' ','L','C','D',' ','\x04',
/* 0x1afcb = "Contemporary Controls" */
    'C','o','n','t','e','m','p','o','r','a','r','y',' ','C','o','n','t','r','o','l','s',
/* 0x1afe0 = "Sound Vision Stream Driver" */
    'S','o','u','n','d',' ','V','i','s','i','o','n',' ','S','t','r','e','a','m',' ','\xde',
/* 0x1aff5 = "StreamSmart 400 [F2235AA]" */
    'S','t','r','e','a','m','\x12',' ','4','0','0',' ','[','F','2','2','3','5','A','A',']',
/* 0x1b00a = "Top Shot Pegasus Joystick" */
    'T','o','p',' ','\x84','P','e','g','a','s','u','s',' ','J','o','y','s','t','i','c','k',
/* 0x1b01f = "Eumex 724PC DSL (FlashLoad)" */
    'E','u','m','e','x',' ','7','2','4','\x1f','D','S','L',' ','(','\x3c','L','o','a','d',')',
/* 0x1b034 = "YARD Stick One bootloader" */
    'Y','A','R','D',' ','\xb3',' ','O','n','e',' ','b','o','o','t','l','o','a','d','e','r',
/* 0x1b049 = "LG Electronics Scanworks 600U Scanner" */
    'L','G',' ','\x1b',' ','S','c','a','n','w','o','r','k','s',' ','6','0','0','U',' ','\x25',
/* 0x1b05e = "WL-323 Wireless-N USB Adapter" */
    'W','L','-','3','2','3',' ','W','i','r','e','l','e','s','s','-','N',' ','\x0a',' ','\x02',
/* 0x1b073 = "FinePix S304/3800 Zoom (PC CAM)" */
    '\xca','i','x',' ','S','3','0','4','/','3','8','0','0',' ','\xe6','(','\x1f','C','A','M',')',
/* 0x1b088 = "TT-connect S2-4650 CI" */
    'T','T','-','c','o','n','n','e','c','t',' ','S','2','-','4','6','5','0',' ','C','I',
/* 0x1b09d = "FSU304 USB 2.0 - 4 Ports Hub" */
    'F','S','U','3','0','4',' ','\x0a',' ','\xc1','-',' ','4',' ','P','o','r','t','s',' ','\xa4',
/* 0x1b0b2 = "DVC USB-SERIAL Driver for WinXP" */
    'D','V','C',' ','\x0a','-','S','E','R','I','A','L',' ','\xde',' ','\xcc','W','i','n','X','P',
/* 0x1b0c7 = "Nogatech TV! Pro (NTSC)" */
    'N','o','g','a','t','e','c','h',' ','T','V','!',' ','\x8f',' ','(','N','T','S','C',')',
/* 0x1b0dc = "iAPP CR-e500 Card reader" */
    'i','A','P','P',' ','C','R','-','e','5','0','0',' ','\x15',' ','r','e','a','d','e','r',
/* 0x1b0f1 = "Xbox360 HD-DVD Memory Unit" */
    'X','b','o','x','3','6','0',' ','H','D','-','D','V','D',' ','\xd2',' ','U','n','i','t',
/* 0x1b106 = "PG-FP5 Flash Memory Programmer" */
    'P','G','-','F','P','5',' ','\x3c',' ','\xd2',' ','P','r','o','g','r','a','m','m','e','r',
/* 0x1b11b = "Frontier Design Group" */
    'F','r','o','n','t','i','e','r',' ','D','e','s','i','g','n',' ','G','r','o','u','p',
/* 0x1b130 = "Magicolor 2350EN/3300" */
    'M','a','g','i','c','o','l','o','r',' ','2','3','5','0','E','N','/','3','3','0','0',
/* 0x1b145 = "Wireless Presenter with Laser Pointer" */
    '\x01','P','r','e','s','e','n','t','e','r',' ','\x98','\x82',' ','P','o','i','n','t','e','r',
/* 0x1b15a = "Dreamcast (Joystick mode)" */
    'D','r','e','a','m','c','a','s','t',' ','(','J','o','y','s','t','i','c','k',' ','\x1a',
/* 0x1b16f = "Nagano Japan Radio Co., Ltd" */
    'N','a','g','a','n','o',' ','J','a','p','a','n',' ','R','a','d','i','o',' ','\x0e','\x16',
/* 0x1b184 = "EUB9706 802.11n Wireless Adapter [Ralink RT3072]" */
    'E','U','B','9','7','0','6',' ','\x99','\x01','\x02',' ','[','\x93','R','T','3','0','7','2',']',
/* 0x1b199 = "ST 330 Rumble Force Stick" */
    'S','T',' ','3','3','0',' ','R','u','m','b','l','e',' ','F','o','r','c','e',' ','\xb3',
/* 0x1b1ae = "Fujitsu-ICL Computers" */
    'F','u','j','i','t','s','u','-','I','C','L',' ','C','o','m','p','u','t','e','r','s',
/* 0x1b1c3 = "Kensington Mouse-in-a-box" */
    'K','e','n','s','i','n','g','t','o','n',' ','\x0b','-','i','n','-','a','-','b','o','x',
/* 0x1b1d8 = "LC1 CompactFlash & SmartMedia Card Reader" */
    'L','C','1',' ','C','o','m','p','a','c','t','\x3c',' ','&',' ','\x12','\xa1',' ','\x15',' ','\x08',
/* 0x1b1ed = "DSB-650TX Ethernet [pegasus]" */
    'D','S','B','-','6','5','0','T','X',' ','\x7f',' ','[','p','e','g','a','s','u','s',']',
/* 0x1b202 = "LPC2378 [Robotino XT]" */
    'L','P','C','2','3','7','8',' ','[','R','o','b','o','t','i','n','o',' ','X','T',']',
/* 0x1b217 = "HP ScanJet 4300c Parallel Port" */
    'H','P',' ','\x8a','\x80','4','3','0','0','c',' ','P','a','r','a','l','l','e','l',' ','\x87',
/* 0x1b22c = "DataTraveler Ultimate G2" */
    '\xe7','T','r','a','v','e','l','e','r',' ','U','l','t','i','m','a','t','e',' ','G','2',
/* 0x1b241 = "1 port to Serial Converter" */
    '1',' ','p','o','r','t',' ','t','o',' ','\x90',' ','C','o','n','v','e','r','t','e','r',
/* 0x1b256 = "UFD MP3 player (model 2)" */
    'U','F','D',' ','\x8e','p','l','a','y','e','r',' ','(','m','o','d','e','l',' ','2',')',
/* 0x1b26b = "Eumex 704PC DSL [FlashLoad]" */
    'E','u','m','e','x',' ','7','0','4','\x1f','D','S','L',' ','[','\x3c','L','o','a','d',']',
/* 0x1b280 = "PC Camera (SN9C201 + MI1300)" */
    '\x1f','\x04',' ','(','S','N','9','C','2','0','1',' ','+',' ','M','I','1','3','0','0',')',
/* 0x1b295 = "GL3310 SATA 3Gb/s Bridge Controller" */
    'G','L','3','3','1','0',' ','S','A','T','A',' ','3','G','b','/','s',' ','\x9f',' ','\x13',
/* 0x1b2aa = "/Dev or SlashDev /Net" */
    '/','D','e','v',' ','o','r',' ','S','l','a','s','h','D','e','v',' ','/','N','e','t',
/* 0x1b2bf = "Biostar Microtech International Corp." */
    'B','i','o','s','t','a','r',' ','M','i','c','r','o','t','e','c','h',' ','\x9c',' ','\x10',
/* 0x1b2d4 = "DeLorme Publishing, Inc." */
    'D','e','L','o','r','m','e',' ','P','u','b','l','i','s','h','i','n','g',',',' ','\x07',
/* 0x1b2e9 = "5800 XpressMusic (Multimedia mode)" */
    '5','8','0','0',' ','X','p','r','e','s','s','M','u','s','i','c',' ','(','\xe2',' ','\x1a',
/* 0x1b2fe = "Sansa E200 series v2 (msc)" */
    'S','a','n','s','a',' ','E','2','0','0',' ','\x1d',' ','v','2',' ','(','m','s','c',')',
/* 0x1b313 = "RfCat Dons bootloader" */
    'R','f','C','a','t',' ','D','o','n','s',' ','b','o','o','t','l','o','a','d','e','r',
/* 0x1b328 = "GT-X750 [Perfection 4490 Photo]" */
    'G','T','-','X','7','5','0',' ','[','\xf0','4','4','9','0',' ','P','h','o','t','o',']',
/* 0x1b33d = "Integrated Module with Bluetooth 2.1 Wireless technology" */
    '\x18','\xe5',' ','\x98','\x06',' ','2','.','1',' ','\x01','t','e','c','h','n','o','l','o','g','y',
/* 0x1b352 = "Priva Design Services" */
    'P','r','i','v','a',' ','D','e','s','i','g','n',' ','S','e','r','v','i','c','e','s',
/* 0x1b367 = "Milkymist JTAG/serial" */
    'M','i','l','k','y','m','i','s','t',' ','J','T','A','G','/','s','e','r','i','a','l',
/* 0x1b37c = "un2400 Gobi Wireless Modem (QDL mode)" */
    'u','n','2','4','0','0',' ','G','o','b','i',' ','\x01','\x1c',' ','(','Q','D','L',' ','\x1a',
/* 0x1b391 = "Logic3 / SpectraVideo plc" */
    'L','o','g','i','c','3',' ','/',' ','S','p','e','c','t','r','a','\xa3',' ','p','l','c',
/* 0x1b3a6 = "Alco Digital Devices Limited" */
    'A','l','c','o',' ','\x09','D','e','v','i','c','e','s',' ','L','i','m','i','t','e','d',
/* 0x1b3bb = "MeMO Pad HD 7 (CD-ROM mode)" */
    'M','e','M','O',' ','\xfa',' ','H','D',' ','7',' ','(','C','D','-','R','O','M',' ','\x1a',
/* 0x1b3d0 = "BCM20703A1 Bluetooth 4.1 + LE" */
    'B','C','M','2','0','7','0','3','A','1',' ','\x06',' ','4','.','1',' ','+',' ','L','E',
/* 0x1b3e5 = "PX-673F [Stylus Office BX925FWD]" */
    'P','X','-','6','7','3','F',' ','[','\xb1','\xd3',' ','B','X','9','2','5','F','W','D',']',
/* 0x1b3fa = "Galaxy Portal/Spica/S" */
    'G','a','l','a','x','y',' ','P','o','r','t','a','l','/','S','p','i','c','a','/','S',
/* 0x1b40f = "MN-710 802.11g Wireless Adapter [Intersil ISL3886]" */
    'M','N','-','7','1','0',' ','\x94','\x01','\x02',' ','[','\xb0','I','S','L','3','8','8','6',']',
/* 0x1b424 = "A0001 Phone [OnePlus One]" */
    'A','0','0','0','1',' ','\x19',' ','[','O','n','e','P','l','u','s',' ','O','n','e',']',
/* 0x1b439 = "MCS7780 4Mbps Fast IrDA Adapter" */
    'M','C','S','7','7','8','0',' ','4','M','b','p','s',' ','\xec','I','r','D','A',' ','\x02',
/* 0x1b44e = "Jabra UC Voice 750 MS" */
    'J','a','b','r','a',' ','U','C',' ','V','o','i','c','e',' ','7','5','0',' ','M','S',
/* 0x1b463 = "Micro Innovations IC200 Webcam" */
    '\xc4',' ','I','n','n','o','v','a','t','i','o','n','s',' ','I','C','2','0','0',' ','\x11',
/* 0x1b478 = "SHIELD Tablet (debug)" */
    'S','H','I','E','L','D',' ','T','a','b','l','e','t',' ','(','d','e','b','u','g',')',
/* 0x1b48d = "Dimage A1 Camera [storage]" */
    'D','i','m','a','g','e',' ','A','1',' ','\x04',' ','[','s','t','o','r','a','g','e',']',
/* 0x1b4a2 = "CDRW55292EXT CD-RW External Drive" */
    'C','D','R','W','5','5','2','9','2','E','X','T',' ','C','D','-','R','W',' ','\xe3','\x14',
/* 0x1b4b7 = "WL-315 Wireless-N USB Adapter" */
    'W','L','-','3','1','5',' ','W','i','r','e','l','e','s','s','-','N',' ','\x0a',' ','\x02',
/* 0x1b4cc = "echoFX InterView Lite" */
    'e','c','h','o','F','X',' ','I','n','t','e','r','V','i','e','w',' ','L','i','t','e',
/* 0x1b4e1 = "DUB-AV300 A/V Capture" */
    'D','U','B','-','A','V','3','0','0',' ','A','/','V',' ','C','a','p','t','u','r','e',
/* 0x1b4f6 = "TI-84 Plus Calculator" */
    'T','I','-','8','4',' ','P','l','u','s',' ','C','a','l','c','u','l','a','t','o','r',
/* 0x1b50b = "OCZ Rally2/ATV USB 2.0 Flash Drive" */
    'O','C','Z',' ','R','a','l','l','y','2','/','A','T','V',' ','\x0a',' ','\xc1','\x3c',' ','\x14',
/* 0x1b520 = "802.11bgn 1T1R Mini Card Wireless Adapter" */
    '8','0','2','.','1','1','b','g','n',' ','1','T','1','R',' ','\xb9',' ','\x15',' ','\x01','\x02',
/* 0x1b535 = "PIC16F145x bootloader" */
    'P','I','C','1','6','F','1','4','5','x',' ','b','o','o','t','l','o','a','d','e','r',
/* 0x1b54a = "Select RW-200 CDMA Wireless Modem" */
    'S','e','l','e','c','t',' ','R','W','-','2','0','0',' ','C','D','M','A',' ','\x01','\x1c',
/* 0x1b55f = "Hi-Speed USB-to-IDE Bridge Controller" */
    'H','i','-','S','p','e','e','d',' ','\x0a','-','t','o','-','I','D','E',' ','\x9f',' ','\x13',
/* 0x1b574 = "DWA-126 802.11n Wireless Adapter [Atheros AR9271]" */
    'D','W','A','-','1','2','6',' ','\x99','\x01','\x02',' ','[','\xaf','A','R','9','2','7','1',']',
/* 0x1b589 = "PowerShot N Facebook(R) Ready" */
    '\x24','\x84','N',' ','F','a','c','e','b','o','o','k','(','R',')',' ','R','e','a','d','y',
/* 0x1b59e = "USBEL-100 Ethernet [pegasus]" */
    'U','S','B','E','L','-','1','0','0',' ','\x7f',' ','[','p','e','g','a','s','u','s',']',
/* 0x1b5b3 = "Utilux South China, Ltd" */
    'U','t','i','l','u','x',' ','S','o','u','t','h',' ','C','h','i','n','a',',',' ','\x16',
/* 0x1b5c8 = "Konica Minolta SC-215" */
    'K','o','n','i','c','a',' ','M','i','n','o','l','t','a',' ','S','C','-','2','1','5',
/* 0x1b5dd = "Apacer 6-in-1 Card Reader 2.0" */
    'A','p','a','c','e','r',' ','6','-','i','n','-','1',' ','\x15',' ','\x08',' ','2','.','0',
/* 0x1b5f2 = "MSM6300 chipset flash" */
    'M','S','M','6','3','0','0',' ','c','h','i','p','s','e','t',' ','f','l','a','s','h',
/* 0x1b607 = "Digital Voice Recorder DW-90" */
    '\x09','V','o','i','c','e',' ','R','e','c','o','r','d','e','r',' ','D','W','-','9','0',
/* 0x1b61c = "SUP-SFR400(A) BioMini Fingerprint Reader" */
    'S','U','P','-','S','F','R','4','0','0','(','A',')',' ','B','i','o','\xb9',' ','\x92','\x08',
/* 0x1b631 = "CT-S310 Label printer" */
    'C','T','-','S','3','1','0',' ','L','a','b','e','l',' ','p','r','i','n','t','e','r',
/* 0x1b646 = "5310 Xpress music (Storage mode)" */
    '5','3','1','0',' ','X','p','r','e','s','s',' ','m','u','s','i','c',' ','(','\x0f','\x1a',
/* 0x1b65b = "SM single card reader" */
    'S','M',' ','s','i','n','g','l','e',' ','c','a','r','d',' ','r','e','a','d','e','r',
/* 0x1b670 = "Precision Clock MSF USB" */
    'P','r','e','c','i','s','i','o','n',' ','C','l','o','c','k',' ','M','S','F',' ','\x0a',
/* 0x1b685 = "Tux Droid fish dongle" */
    'T','u','x',' ','D','r','o','i','d',' ','f','i','s','h',' ','d','o','n','g','l','e',
/* 0x1b69a = "3Dconnexion Space Mouse Pro" */
    '3','D','c','o','n','n','e','x','i','o','n',' ','S','p','a','c','e',' ','\x0b',' ','\x8f',
/* 0x1b6af = "Linux-USB "Gadget Zero"" */
    'L','i','n','u','x','-','\x0a',' ','"','G','a','d','g','e','t',' ','Z','e','r','o','"',
/* 0x1b6c4 = "Casira with BlueCore3-Multimedia Module" */
    'C','a','s','i','r','a',' ','\x98','B','l','u','e','C','o','r','e','3','-','\xe2',' ','\xe5',
/* 0x1b6d9 = "DeskJet F2492 All-in-One" */
    'D','e','s','k','\x80','F','2','4','9','2',' ','A','l','l','-','i','n','-','O','n','e',
/* 0x1b6ee = "QuickCam OEM Cisco VT Camera II" */
    '\xc7','a','m',' ','O','E','M',' ','C','i','s','c','o',' ','V','T',' ','\x04',' ','I','I',
/* 0x1b703 = "Advanced Silicon S.A." */
    'A','d','v','a','n','c','e','d',' ','S','i','l','i','c','o','n',' ','S','.','A','.',
/* 0x1b718 = "Barcode Module - Virtual Keyboard" */
    'B','a','r','c','o','d','e',' ','\xe5',' ','-',' ','V','i','r','t','u','a','l',' ','\x05',
/* 0x1b72d = "Ovation MC930D/MC950D" */
    'O','v','a','t','i','o','n',' ','M','C','9','3','0','D','/','M','C','9','5','0','D',
/* 0x1b742 = "BAY-3U1S1P Parallel Port" */
    'B','A','Y','-','3','U','1','S','1','P',' ','P','a','r','a','l','l','e','l',' ','\x87',
/* 0x1b757 = "Xperia Ion [Mass Storage]" */
    'X','p','e','r','i','a',' ','I','o','n',' ','[','\x7c','S','t','o','r','a','g','e',']',
/* 0x1b76c = "Industrial Technology Research Institute" */
    '\xef','\x0d',' ','R','e','s','e','a','r','c','h',' ','I','n','s','t','i','t','u','t','e',
/* 0x1b781 = "DLink 7 port USB2.0 Hub" */
    'D','L','i','n','k',' ','7',' ','p','o','r','t',' ','U','S','B','2','.','0',' ','\xa4',
/* 0x1b796 = "MSM6050 chipset flash" */
    'M','S','M','6','0','5','0',' ','c','h','i','p','s','e','t',' ','f','l','a','s','h',
/* 0x1b7ab = "Infotronic America, Inc." */
    'I','n','f','o','t','r','o','n','i','c',' ','A','m','e','r','i','c','a',',',' ','\x07',
/* 0x1b7c0 = "Cordless Desktop S510" */
    'C','o','r','d','l','e','s','s',' ','D','e','s','k','t','o','p',' ','S','5','1','0',
/* 0x1b7d5 = "Stylus CX3700/CX3800/DX3800" */
    '\xb1','C','X','3','7','0','0','/','C','X','3','8','0','0','/','D','X','3','8','0','0',
/* 0x1b7ea = "Shanghai Haiying Electronics Co., Ltd." */
    'S','h','a','n','g','h','a','i',' ','H','a','i','y','i','n','g',' ','\x1b',' ','\x0e','\xab',
/* 0x1b7ff = "AB-1.x UAC1 [Audio Widget]" */
    'A','B','-','1','.','x',' ','U','A','C','1',' ','[','\x8b','W','i','d','g','e','t',']',
/* 0x1b814 = "PC Camera (SN9C201 + MI1320)" */
    '\x1f','\x04',' ','(','S','N','9','C','2','0','1',' ','+',' ','M','I','1','3','2','0',')',
/* 0x1b829 = "HEXA Media Drive 6-in-1 Card Reader Writer" */
    'H','E','X','A',' ','\xa1',' ','\x14',' ','6','-','i','n','-','1',' ','\x15',' ','\x08',' ','\xdf',
/* 0x1b83e = "All-in-One Cardreader" */
    'A','l','l','-','i','n','-','O','n','e',' ','C','a','r','d','r','e','a','d','e','r',
/* 0x1b853 = "Nogatech TV! Pro (PAL+)" */
    'N','o','g','a','t','e','c','h',' ','T','V','!',' ','\x8f',' ','(','P','A','L','+',')',
/* 0x1b868 = "PC Camera (SN9C103 + OV7630)" */
    '\x1f','\x04',' ','(','S','N','9','C','1','0','3',' ','+',' ','O','V','7','6','3','0',')',
/* 0x1b87d = "Agere Systems Netherland BV" */
    'A','g','e','r','e',' ','\xa6',' ','N','e','t','h','e','r','l','a','n','d',' ','B','V',
/* 0x1b892 = "PCTV Sat HDTV Pro BDA Device" */
    'P','C','T','V',' ','S','a','t',' ','H','D','T','V',' ','\x8f',' ','B','D','A',' ','\x03',
/* 0x1b8a7 = "Elements SE Portable (WDBPCK)" */
    'E','l','e','m','e','n','t','s',' ','S','E',' ','\xa9','(','W','D','B','P','C','K',')',
/* 0x1b8bc = "FinePix S602 (Pro) Zoom (DSC)" */
    '\xca','i','x',' ','S','6','0','2',' ','(','P','r','o',')',' ','\xe6','(','D','S','C',')',
/* 0x1b8d1 = "Extending Wire & Cable Co., Ltd." */
    'E','x','t','e','n','d','i','n','g',' ','W','i','r','e',' ','&',' ','\xa5',' ','\x0e','\xab',
/* 0x1b8e6 = "iAUDIO U5 / iAUDIO G2" */
    'i','A','U','D','I','O',' ','U','5',' ','/',' ','i','A','U','D','I','O',' ','G','2',
/* 0x1b8fb = "Thales E-Transactions" */
    'T','h','a','l','e','s',' ','E','-','T','r','a','n','s','a','c','t','i','o','n','s',
/* 0x1b910 = "MyBook Essential External HDD" */
    'M','y','B','o','o','k',' ','E','s','s','e','n','t','i','a','l',' ','\xe3','H','D','D',
/* 0x1b925 = "Century USB Disk Enclosure" */
    'C','e','n','t','u','r','y',' ','\x0a',' ','\xe8',' ','E','n','c','l','o','s','u','r','e',
/* 0x1b93a = "Cyborg Force Rumble Pad" */
    'C','y','b','o','r','g',' ','F','o','r','c','e',' ','R','u','m','b','l','e',' ','\xfa',
/* 0x1b94f = "naturaSign Pad Standard" */
    'n','a','t','u','r','a','S','i','g','n',' ','\xfa',' ','S','t','a','n','d','a','r','d',
/* 0x1b964 = "AmScope MD1900 camera" */
    'A','m','S','c','o','p','e',' ','M','D','1','9','0','0',' ','c','a','m','e','r','a',
/* 0x1b979 = "WL-161 802.11b Wireless Adapter [SiS 162U]" */
    'W','L','-','1','6','1',' ','\x9b','\x01','\x02',' ','[','S','i','S',' ','1','6','2','U',']',
/* 0x1b98e = "Chrysalis Development" */
    'C','h','r','y','s','a','l','i','s',' ','D','e','v','e','l','o','p','m','e','n','t',
/* 0x1b9a3 = "Arris Interactive LLC" */
    'A','r','r','i','s',' ','I','n','t','e','r','a','c','t','i','v','e',' ','L','L','C',
/* 0x1b9b8 = "Pleo robotic dinosaur" */
    'P','l','e','o',' ','r','o','b','o','t','i','c',' ','d','i','n','o','s','a','u','r',
/* 0x1b9cd = "USB-1616FS internal hub" */
    '\x0a','-','1','6','1','6','F','S',' ','i','n','t','e','r','n','a','l',' ','h','u','b',
/* 0x1b9e2 = "SonyEricsson DCU-11 Cable" */
    'S','o','n','y','E','r','i','c','s','s','o','n',' ','D','C','U','-','1','1',' ','\xa5',
/* 0x1b9f7 = "Casira with BlueCore3-Flash Module" */
    'C','a','s','i','r','a',' ','\x98','B','l','u','e','C','o','r','e','3','-','\x3c',' ','\xe5',
/* 0x1ba0c = "A789 (Mass Storage mode, with debug)" */
    'A','7','8','9',' ','(','\x7c','\x0f','m','o','d','e',',',' ','\x98','d','e','b','u','g',')',
/* 0x1ba21 = "E-Mu Xboard 25 MIDI Controller" */
    'E','-','M','u',' ','X','b','o','a','r','d',' ','2','5',' ','M','I','D','I',' ','\x13',
/* 0x1ba36 = "Freecom Classic SL Network Drive" */
    'F','r','e','e','c','o','m',' ','C','l','a','s','s','i','c',' ','S','L',' ','\x8d','\x14',
/* 0x1ba4b = "keyboard (bootloader)" */
    'k','e','y','b','o','a','r','d',' ','(','b','o','o','t','l','o','a','d','e','r',')',
/* 0x1ba60 = "Arduino Yun (CDC ACM)" */
    'A','r','d','u','i','n','o',' ','Y','u','n',' ','(','C','D','C',' ','A','C','M',')',
/* 0x1ba75 = "WLA3310 Wireless Adapter [Intersil ISL3887]" */
    'W','L','A','3','3','1','0',' ','\x01','\x02',' ','[','\xb0','I','S','L','3','8','8','7',']',
/* 0x1ba8a = "TV Wonder, Edition (FI)" */
    '\xda','W','o','n','d','e','r',',',' ','E','d','i','t','i','o','n',' ','(','F','I',')',
/* 0x1ba9f = "CY7C63x0x Thermometer" */
    'C','Y','7','C','6','3','x','0','x',' ','T','h','e','r','m','o','m','e','t','e','r',
/* 0x1bab4 = "GW Instek GDS-1000A Oscilloscope" */
    'G','W',' ','I','n','s','t','e','k',' ','G','D','S','-','1','0','0','0','A',' ','\xfe',
/* 0x1bac9 = "USB2LPT with 2 interfaces" */
    'U','S','B','2','L','P','T',' ','\x98','2',' ','i','n','t','e','r','f','a','c','e','s',
/* 0x1bade = "Dimage XT Camera [storage]" */
    'D','i','m','a','g','e',' ','X','T',' ','\x04',' ','[','s','t','o','r','a','g','e',']',
/* 0x1baf3 = "Advanced Micro Devices, Inc." */
    'A','d','v','a','n','c','e','d',' ','\xc4',' ','D','e','v','i','c','e','s',',',' ','\x07',
/* 0x1bb08 = "Performance Monitor 3" */
    'P','e','r','f','o','r','m','a','n','c','e',' ','M','o','n','i','t','o','r',' ','3',
/* 0x1bb1d = "Acer Advanced Labs, Inc." */
    'A','c','e','r',' ','A','d','v','a','n','c','e','d',' ','L','a','b','s',',',' ','\x07',
/* 0x1bb32 = "Wolverine SixPac 6000" */
    'W','o','l','v','e','r','i','n','e',' ','S','i','x','P','a','c',' ','6','0','0','0',
/* 0x1bb47 = "AVM FRITZ!Box Fon ata" */
    'A','V','M',' ','F','R','I','T','Z','!','B','o','x',' ','F','o','n',' ','a','t','a',
/* 0x1bb5c = "OpticBook 3600 Plus Scanner" */
    'O','p','t','i','c','B','o','o','k',' ','3','6','0','0',' ','P','l','u','s',' ','\x25',
/* 0x1bb71 = "Performance Monitor 4" */
    'P','e','r','f','o','r','m','a','n','c','e',' ','M','o','n','i','t','o','r',' ','4',
/* 0x1bb86 = "Touptek UCMOS05100KPA" */
    'T','o','u','p','t','e','k',' ','U','C','M','O','S','0','5','1','0','0','K','P','A',
/* 0x1bb9b = "MSM6100 chipset flash" */
    'M','S','M','6','1','0','0',' ','c','h','i','p','s','e','t',' ','f','l','a','s','h',
/* 0x1bbb0 = "SDR-H85 Camcorder (PC mode)" */
    'S','D','R','-','H','8','5',' ','C','a','m','c','o','r','d','e','r',' ','(','\x1f','\x1a',
/* 0x1bbc5 = "Eclipse 1200U/Episode" */
    'E','c','l','i','p','s','e',' ','1','2','0','0','U','/','E','p','i','s','o','d','e',
/* 0x1bbda = "E-125 Cassiopeia Pocket PC" */
    'E','-','1','2','5',' ','C','a','s','s','i','o','p','e','i','a',' ','\x17',' ','P','C',
/* 0x1bbef = "Drinkbot (processing)" */
    'D','r','i','n','k','b','o','t',' ','(','p','r','o','c','e','s','s','i','n','g',')',
/* 0x1bc04 = "Chloride Power Protection" */
    'C','h','l','o','r','i','d','e',' ','\x24',' ','P','r','o','t','e','c','t','i','o','n',
/* 0x1bc19 = "Xbox360 Big Button IR" */
    'X','b','o','x','3','6','0',' ','B','i','g',' ','B','u','t','t','o','n',' ','I','R',
/* 0x1bc2e = "PTK-450 [Intuos5 (S)]" */
    'P','T','K','-','4','5','0',' ','[','I','n','t','u','o','s','5',' ','(','S',')',']',
/* 0x1bc43 = "Greatland Electronics Taiwan, Ltd" */
    'G','r','e','a','t','l','a','n','d',' ','\x1b',' ','T','a','i','w','a','n',',',' ','\x16',
/* 0x1bc58 = "Earthmate GPS (PN-40)" */
    'E','a','r','t','h','m','a','t','e',' ','G','P','S',' ','(','P','N','-','4','0',')',
/* 0x1bc6d = "raphnet.net 4nes4snes" */
    'r','a','p','h','n','e','t','.','n','e','t',' ','4','n','e','s','4','s','n','e','s',
/* 0x1bc82 = "Q2U handheld mic with XLR" */
    'Q','2','U',' ','h','a','n','d','h','e','l','d',' ','m','i','c',' ','\x98','X','L','R',
/* 0x1bc97 = "PL512 Power Supply System" */
    'P','L','5','1','2',' ','\x24',' ','S','u','p','p','l','y',' ','S','y','s','t','e','m',
/* 0x1bcac = "Geniatech T230 DVB-T2 TV Stick" */
    'G','e','n','i','a','t','e','c','h',' ','T','2','3','0',' ','\xa7','T','2',' ','\xda','\xb3',
/* 0x1bcc1 = "Digital Voice Recorder DM-20" */
    '\x09','V','o','i','c','e',' ','R','e','c','o','r','d','e','r',' ','D','M','-','2','0',
/* 0x1bcd6 = "Foxlink Optical touch sensor" */
    'F','o','x','l','i','n','k',' ','\x7b','t','o','u','c','h',' ','s','e','n','s','o','r',
/* 0x1bceb = "CyMotion Expert Combo" */
    'C','y','M','o','t','i','o','n',' ','E','x','p','e','r','t',' ','C','o','m','b','o',
/* 0x1bd00 = "GT-F670 [Perfection V200 Photo]" */
    'G','T','-','F','6','7','0',' ','[','\xf0','V','2','0','0',' ','P','h','o','t','o',']',
/* 0x1bd15 = "Bluetooth 2.0 adapter 10m CN-512v2 001" */
    '\x06',' ','\xc1','\xd0',' ','1','0','m',' ','C','N','-','5','1','2','v','2',' ','0','0','1',
/* 0x1bd2a = "HD44780 LCD interface" */
    'H','D','4','4','7','8','0',' ','L','C','D',' ','i','n','t','e','r','f','a','c','e',
/* 0x1bd3f = "DCP-7055 scanner/printer" */
    '\xaa','7','0','5','5',' ','s','c','a','n','n','e','r','/','p','r','i','n','t','e','r',
/* 0x1bd54 = "AirPlus G DWL-G122 Wireless Adapter" */
    'A','i','r','P','l','u','s',' ','G',' ','D','W','L','-','G','1','2','2',' ','\x01','\x02',
/* 0x1bd69 = "PC Camera (SN9C201 + SOI968)" */
    '\x1f','\x04',' ','(','S','N','9','C','2','0','1',' ','+',' ','S','O','I','9','6','8',')',
/* 0x1bd7e = "Vega Technologies Industrial (Austria) Co." */
    'V','e','g','a',' ','\x88',' ','\xef','(','A','u','s','t','r','i','a',')',' ','C','o','.',
/* 0x1bd93 = "Guntermann & Drunck GmbH" */
    'G','u','n','t','e','r','m','a','n','n',' ','&',' ','D','r','u','n','c','k',' ','\xfc',
/* 0x1bda8 = "BC206 Camera Beam Profiler" */
    'B','C','2','0','6',' ','\x04',' ','B','e','a','m',' ','P','r','o','f','i','l','e','r',
/* 0x1bdbd = "3,5\'\' HDD case MD-231" */
    '3',',','5','\'','\'',' ','H','D','D',' ','c','a','s','e',' ','M','D','-','2','3','1',
/* 0x1bdd2 = "MDM166A Fluorescent Display" */
    'M','D','M','1','6','6','A',' ','F','l','u','o','r','e','s','c','e','n','t',' ','\xcf',
/* 0x1bde7 = "Topcom 802.11bg Wireless Adapter [Atheros AR5523]" */
    'T','o','p','c','o','m',' ','\xad',' ','\x01','\x02',' ','[','\xaf','A','R','5','5','2','3',']',
/* 0x1bdfc = "Alpermann+Velte TCI70" */
    'A','l','p','e','r','m','a','n','n','+','V','e','l','t','e',' ','T','C','I','7','0',
/* 0x1be11 = "Finet Technology Palmpix DC-85" */
    'F','i','n','e','t',' ','\x0d',' ','P','a','l','m','p','i','x',' ','D','C','-','8','5',
/* 0x1be26 = "Studio PCTV USB (SECAM)" */
    'S','t','u','d','i','o',' ','P','C','T','V',' ','\x0a',' ','(','S','E','C','A','M',')',
/* 0x1be3b = "ImageMate CF/MMC/SD Reader" */
    'I','m','a','g','e','M','a','t','e',' ','C','F','/','M','M','C','/','S','D',' ','\x08',
/* 0x1be50 = "FreeAgent GoFlex dock" */
    'F','r','e','e','A','g','e','n','t',' ','G','o','F','l','e','x',' ','d','o','c','k',
/* 0x1be65 = "4N-GALAXY Serial Converter" */
    '4','N','-','G','A','L','A','X','Y',' ','\x90',' ','C','o','n','v','e','r','t','e','r',
/* 0x1be7a = "Micro Vault 1.0G Mass Storage" */
    '\xc4',' ','V','a','u','l','t',' ','1','.','0','G',' ','\x7c','S','t','o','r','a','g','e',
/* 0x1be8f = "EASYSHARE Z1485 IS Digital Camera" */
    'E','A','S','Y','S','H','A','R','E',' ','Z','1','4','8','5',' ','I','S',' ','\x09','\x04',
/* 0x1bea4 = "A835/E1000 GSM Phone (AT)" */
    'A','8','3','5','/','E','1','0','0','0',' ','G','S','M',' ','\x19',' ','(','A','T',')',
/* 0x1beb9 = "Prox-DU Contactless Interface" */
    'P','r','o','x','-','D','U',' ','C','o','n','t','a','c','t','l','e','s','s',' ','\x81',
/* 0x1bece = "S2 Portable [JMicron] (500GB)" */
    'S','2',' ','\xa9','[','J','M','i','c','r','o','n',']',' ','(','5','0','0','G','B',')',
/* 0x1bee3 = "EasyShare G600 Printer Dock" */
    'E','a','s','y','S','h','a','r','e',' ','G','6','0','0',' ','\x0c',' ','D','o','c','k',
/* 0x1bef8 = "SideWinder Game Voice" */
    'S','i','d','e','W','i','n','d','e','r',' ','G','a','m','e',' ','V','o','i','c','e',
/* 0x1bf0d = "ImageMate CF Reader/Writer" */
    'I','m','a','g','e','M','a','t','e',' ','C','F',' ','R','e','a','d','e','r','/','\xdf',
/* 0x1bf22 = "CompuLink Research, Inc." */
    'C','o','m','p','u','L','i','n','k',' ','R','e','s','e','a','r','c','h',',',' ','\x07',
/* 0x1bf37 = "American Power Conversion" */
    'A','m','e','r','i','c','a','n',' ','\x24',' ','C','o','n','v','e','r','s','i','o','n',
/* 0x1bf4c = "EP-1427X-2 Ethernet Adapter [Acer]" */
    'E','P','-','1','4','2','7','X','-','2',' ','\x7f',' ','\x02',' ','[','A','c','e','r',']',
/* 0x1bf61 = "Logitech USB Microphone" */
    'L','o','g','i','t','e','c','h',' ','\x0a',' ','M','i','c','r','o','p','h','o','n','e',
/* 0x1bf76 = "EVER Sinline XL Series UPS" */
    'E','V','E','R',' ','S','i','n','l','i','n','e',' ','X','L',' ','\xbf',' ','U','P','S',
/* 0X1bf8b = "Scientific Atlanta, Inc." */
    'c','i','e','n','t','i','f','i','c',' ','A','t','l','a','n','t','a',',',' ','\x07',
/* 0x1bf9f = "In-Win Development, Inc." */
    'I','n','-','W','i','n',' ','D','e','v','e','l','o','p','m','e','n','t',',',' ','\x07',
/* 0x1bfb4 = "Trust 738AV LCD PV Digital Camera" */
    'T','r','u','s','t',' ','7','3','8','A','V',' ','L','C','D',' ','P','V',' ','\x09','\x04',
/* 0x1bfc9 = "Edu-Science (H.K.), Ltd" */
    'E','d','u','-','S','c','i','e','n','c','e',' ','(','H','.','K','.',')',',',' ','\x16',
/* 0x1bfde = "Elements SE Portable (WDBABV)" */
    'E','l','e','m','e','n','t','s',' ','S','E',' ','\xa9','(','W','D','B','A','B','V',')',
/* 0x1bff3 = "REC-ADPT-USB (recorder)" */
    'R','E','C','-','A','D','P','T','-','\x0a',' ','(','r','e','c','o','r','d','e','r',')',
/* 0x1c008 = "Ace Cad Enterprise Co., Ltd" */
    'A','c','e',' ','C','a','d',' ','E','n','t','e','r','p','r','i','s','e',' ','\x0e','\x16',
/* 0x1c01d = "Xperia Mini Pro Bootloader" */
    'X','p','e','r','i','a',' ','\xb9',' ','\x8f',' ','B','o','o','t','l','o','a','d','e','r',
/* 0x1c032 = "USBE-100 Ethernet [pegasus2]" */
    'U','S','B','E','-','1','0','0',' ','\x7f',' ','[','p','e','g','a','s','u','s','2',']',
/* 0x1c047 = "PC Camera (SN9C201 + OV9650)" */
    '\x1f','\x04',' ','(','S','N','9','C','2','0','1',' ','+',' ','O','V','9','6','5','0',')',
/* 0x1c05c = "JumpDrive trade; Pro 40-501" */
    'J','u','m','p','\x14',' ','t','r','a','d','e',';',' ','\x8f',' ','4','0','-','5','0','1',
/* 0x1c071 = "Kingston DataTraveler U3" */
    'K','i','n','g','s','t','o','n',' ','\xe7','T','r','a','v','e','l','e','r',' ','U','3',
/* 0x1c086 = "BandLuxe 3.5G HSDPA Adapter" */
    'B','a','n','d','L','u','x','e',' ','3','.','5','G',' ','H','S','D','P','A',' ','\x02',
/* 0x1c09b = "Digitex Container Flash Disk" */
    'D','i','g','i','t','e','x',' ','C','o','n','t','a','i','n','e','r',' ','\x3c',' ','\xe8',
/* 0x1c0b0 = "Mitsubishi Electric Corp." */
    'M','i','t','s','u','b','i','s','h','i',' ','E','l','e','c','t','r','i','c',' ','\x10',
/* 0x1c0c5 = "Integrated Consumer Infrared Receiver/Transceiver" */
    '\x18','C','o','n','s','u','m','e','r',' ','\xa8','R','e','c','e','i','v','e','r','/','\xc8',
/* 0x1c0da = "GZ-MG30AA/MC500E Digital Video Camera" */
    'G','Z','-','M','G','3','0','A','A','/','M','C','5','0','0','E',' ','\x09','\xa3',' ','\x04',
/* 0x1c0ef = "In-Target Probe (ITP)" */
    'I','n','-','T','a','r','g','e','t',' ','P','r','o','b','e',' ','(','I','T','P',')',
/* 0x1c104 = "GT-S5670 [Galaxy Fit]" */
    'G','T','-','S','5','6','7','0',' ','[','G','a','l','a','x','y',' ','F','i','t',']',
/* 0x1c119 = "Momentum Microsystems" */
    'M','o','m','e','n','t','u','m',' ','M','i','c','r','o','s','y','s','t','e','m','s',
/* 0x1c12e = "Beijing STONE Technology Co. Ltd." */
    'B','e','i','j','i','n','g',' ','S','T','O','N','E',' ','\x0d',' ','C','o','.',' ','\xab',
/* 0x1c143 = "IKALOGIC SCANALOGIC 2" */
    'I','K','A','L','O','G','I','C',' ','S','C','A','N','A','L','O','G','I','C',' ','2',
/* 0x1c158 = "Skywalker-1 DVB-S tuner" */
    'S','k','y','w','a','l','k','e','r','-','1',' ','\xa7','S',' ','t','u','n','e','r',
/* 0x1c16c = "Hang Zhou Silan Electronics Co., Ltd" */
    'H','a','n','g',' ','Z','h','o','u',' ','S','i','l','a','n',' ','\x1b',' ','\x0e','\x16',
/* 0x1c180 = "Pro Gamer Command Unit" */
    '\x8f',' ','G','a','m','e','r',' ','C','o','m','m','a','n','d',' ','U','n','i','t',
/* 0x1c194 = "M-Audio Keystation Loader" */
    'M','-','\x8b','K','e','y','s','t','a','t','i','o','n',' ','L','o','a','d','e','r',
/* 0x1c1a8 = "Medtronic Physio Control Corp." */
    'M','e','d','t','r','o','n','i','c',' ','P','h','y','s','i','o',' ','\xc9',' ','\x10',
/* 0x1c1bc = "LP3065 30" Monitor Hub" */
    'L','P','3','0','6','5',' ','3','0','"',' ','M','o','n','i','t','o','r',' ','\xa4',
/* 0x1c1d0 = "ViewSonic G773 Control (?)" */
    'V','i','e','w','S','o','n','i','c',' ','G','7','7','3',' ','\xc9',' ','(','?',')',
/* 0x1c1e4 = "Archos 2 8GB EM184RB" */
    'A','r','c','h','o','s',' ','2',' ','8','G','B',' ','E','M','1','8','4','R','B',
/* 0x1c1f8 = "Globespan Virata ADSL LAN Modem" */
    'G','l','o','b','e','s','p','a','n',' ','V','i','r','a','t','a',' ','\xf1','\xf3','\x1c',
/* 0x1c20c = "Pro Flight Radio Panel" */
    '\x8f',' ','F','l','i','g','h','t',' ','R','a','d','i','o',' ','P','a','n','e','l',
/* 0x1c220 = "My Passport (WDBKXH, WDBY8L)" */
    'M','y',' ','\xd5','(','W','D','B','K','X','H',',',' ','W','D','B','Y','8','L',')',
/* 0x1c234 = "Live! Cam Sync HD [VF0770]" */
    'L','i','v','e','!',' ','\x9a','\x91',' ','H','D',' ','[','V','F','0','7','7','0',']',
/* 0x1c248 = "VRD-VC10 [Video Capture]" */
    'V','R','D','-','V','C','1','0',' ','[','\xa3',' ','C','a','p','t','u','r','e',']',
/* 0x1c25c = "BearPaw 2448 TA Plus" */
    'B','e','a','r','P','a','w',' ','2','4','4','8',' ','T','A',' ','P','l','u','s',
/* 0x1c270 = "ASRock Incorporation" */
    'A','S','R','o','c','k',' ','I','n','c','o','r','p','o','r','a','t','i','o','n',
/* 0x1c284 = "Dane Elec zMate CF Reader" */
    'D','a','n','e',' ','E','l','e','c',' ','z','M','a','t','e',' ','C','F',' ','\x08',
/* 0x1c298 = "Compaq Bluetooth Multiport Module" */
    'C','o','m','p','a','q',' ','\x06',' ','M','u','l','t','i','p','o','r','t',' ','\xe5',
/* 0x1c2ac = "Blinky Light Controller (DFU)" */
    'B','l','i','n','k','y',' ','L','i','g','h','t',' ','\x13',' ','(','D','F','U',')',
/* 0x1c2c0 = "Dazzle DVC130/DVC170" */
    'D','a','z','z','l','e',' ','D','V','C','1','3','0','/','D','V','C','1','7','0',
/* 0x1c2d4 = "UC-232A Serial Port [pl2303]" */
    'U','C','-','2','3','2','A',' ','\x90',' ','\x87',' ','[','p','l','2','3','0','3',']',
/* 0x1c2e8 = "Terratec Cinergy 200" */
    'T','e','r','r','a','t','e','c',' ','C','i','n','e','r','g','y',' ','2','0','0',
/* 0x1c2fc = "G19 Gaming Keyboard Macro Interface" */
    'G','1','9',' ','G','a','m','i','n','g',' ','\x05',' ','M','a','c','r','o',' ','\x81',
/* 0x1c310 = "814 Sample Processor" */
    '8','1','4',' ','S','a','m','p','l','e',' ','P','r','o','c','e','s','s','o','r',
/* 0x1c324 = "model 01 Bluetooth interface" */
    'm','o','d','e','l',' ','0','1',' ','\x06',' ','i','n','t','e','r','f','a','c','e',
/* 0x1c338 = "Dane Elec zMate SD Reader" */
    'D','a','n','e',' ','E','l','e','c',' ','z','M','a','t','e',' ','S','D',' ','\x08',
/* 0x1c34c = "Canon Information Systems, Inc." */
    'C','a','n','o','n',' ','I','n','f','o','r','m','a','t','i','o','n',' ','\xb8','\x07',
/* 0x1c360 = "C1-01 Ovi Suite Mode" */
    'C','1','-','0','1',' ','O','v','i',' ','S','u','i','t','e',' ','M','o','d','e',
/* 0x1c374 = "PCTV Deluxe (NTSC) Device" */
    'P','C','T','V',' ','D','e','l','u','x','e',' ','(','N','T','S','C',')',' ','\x03',
/* 0x1c388 = "Backpack 40GB Hard Drive" */
    'B','a','c','k','p','a','c','k',' ','4','0','G','B',' ','H','a','r','d',' ','\x14',
/* 0x1c39c = "Xsens Awinda Station" */
    'X','s','e','n','s',' ','A','w','i','n','d','a',' ','S','t','a','t','i','o','n',
/* 0x1c3b0 = "Colorado MicroDisplay, Inc." */
    'C','o','l','o','r','a','d','o',' ','\xc4','D','i','s','p','l','a','y',',',' ','\x07',
/* 0x1c3c4 = "Cassidian SSDC Adapter III" */
    'C','a','s','s','i','d','i','a','n',' ','S','S','D','C',' ','\x02',' ','I','I','I',
/* 0x1c3d8 = "D200 (mass storage mode)" */
    'D','2','0','0',' ','(','m','a','s','s',' ','s','t','o','r','a','g','e',' ','\x1a',
/* 0x1c3ec = "CP-D70DW / CP-D707DW" */
    'C','P','-','D','7','0','D','W',' ','/',' ','C','P','-','D','7','0','7','D','W',
/* 0x1c400 = "OMAP 1.0 chipset RDL" */
    'O','M','A','P',' ','1','.','0',' ','c','h','i','p','s','e','t',' ','R','D','L',
/* 0x1c414 = "SurfBoard SB4100 Cable Modem" */
    'S','u','r','f','B','o','a','r','d',' ','S','B','4','1','0','0',' ','\xa5',' ','\x1c',
/* 0x1c428 = "Volex (Asia) Pte., Ltd" */
    'V','o','l','e','x',' ','(','A','s','i','a',')',' ','P','t','e','.',',',' ','\x16',
/* 0x1c43c = "California Micro Devices" */
    'C','a','l','i','f','o','r','n','i','a',' ','\xc4',' ','D','e','v','i','c','e','s',
/* 0x1c450 = "2386C-HT820 [Flash Mode]" */
    '2','3','8','6','C','-','H','T','8','2','0',' ','[','\x3c',' ','M','o','d','e',']',
/* 0x1c464 = "PureDigital Ritz Disposable" */
    'P','u','r','e','\x09','R','i','t','z',' ','D','i','s','p','o','s','a','b','l','e',
/* 0x1c478 = "FreeLaserTag Big Brother" */
    'F','r','e','e','\x82','T','a','g',' ','B','i','g',' ','B','r','o','t','h','e','r',
/* 0x1c48c = "PicoScope 4000A series PC Oscilloscope" */
    'P','i','c','o','S','c','o','p','e',' ','4','0','0','0','A',' ','\x1d',' ','\x1f','\xfe',
/* 0x1c4a0 = "Combi Keyboard-Hub (Keyboard)" */
    'C','o','m','b','i',' ','\x05','-','\xa4',' ','(','K','e','y','b','o','a','r','d',')',
/* 0x1c4b4 = "POS Keyboard, TA59-USB" */
    'P','O','S',' ','K','e','y','b','o','a','r','d',',',' ','T','A','5','9','-','\x0a',
/* 0x1c4c8 = "LeapFrog Enterprises" */
    'L','e','a','p','F','r','o','g',' ','E','n','t','e','r','p','r','i','s','e','s',
/* 0x1c4dc = "Aterm WL300NU-GS 802.11n Wireless Adapter" */
    'A','t','e','r','m',' ','W','L','3','0','0','N','U','-','G','S',' ','\x99','\x01','\x02',
/* 0x1c4f0 = "PRO/DSL 3220 Modem - WAN" */
    'P','R','O','/','D','S','L',' ','3','2','2','0',' ','\x1c',' ','-',' ','W','A','N',
/* 0x1c504 = "HCF V90 Data Fax RTAD Modem" */
    'H','C','F',' ','V','9','0',' ','\xe7',' ','F','a','x',' ','R','T','A','D',' ','\x1c',
/* 0x1c518 = "smiths spirobank G-USB" */
    's','m','i','t','h','s',' ','s','p','i','r','o','b','a','n','k',' ','G','-','\x0a',
/* 0x1c52c = "My Book 3.0 (WDBABP)" */
    'M','y',' ','B','o','o','k',' ','3','.','0',' ','(','W','D','B','A','B','P',')',
/* 0x1c540 = "Android Fastboot Bootloader" */
    '\xce','F','a','s','t','b','o','o','t',' ','B','o','o','t','l','o','a','d','e','r',
/* 0x1c554 = "Bantam Interactive Technologies" */
    'B','a','n','t','a','m',' ','I','n','t','e','r','a','c','t','i','v','e',' ','\x88',
/* 0x1c568 = "DELL XPS touchscreen" */
    'D','E','L','L',' ','X','P','S',' ','t','o','u','c','h','s','c','r','e','e','n',
/* 0x1c57c = "EVER EV-W100/EV-W250" */
    'E','V','E','R',' ','E','V','-','W','1','0','0','/','E','V','-','W','2','5','0',
/* 0x1c590 = "Memorex Maxx 6136u Scanner" */
    'M','e','m','o','r','e','x',' ','M','a','x','x',' ','6','1','3','6','u',' ','\x25',
/* 0x1c5a4 = "Logitech/Storm PageScan" */
    'L','o','g','i','t','e','c','h','/','S','t','o','r','m',' ','P','a','g','e','\x8a',
/* 0x1c5b8 = "Realtek RTL8187 Wireless 802.11g 54Mbps Network Adapter" */
    '\xbe','R','T','L','8','1','8','7',' ','\x01','\x94','5','4','M','b','p','s',' ','\x8d','\x02',
/* 0x1c5cc = "BAFO USB-ATA/ATAPI Bridge Controller" */
    'B','A','F','O',' ','\x0a','-','A','T','A','/','A','T','A','P','I',' ','\x9f',' ','\x13',
/* 0x1c5e0 = "DECT Data - Gigaset M34" */
    'D','E','C','T',' ','\xe7',' ','-',' ','G','i','g','a','s','e','t',' ','M','3','4',
/* 0x1c5f4 = "Intensity 3 (Mass Storage Mode)" */
    'I','n','t','e','n','s','i','t','y',' ','3',' ','(','\x7c','\x0f','M','o','d','e',')',
/* 0x1c608 = "KNU101TX 100baseTX Ethernet" */
    'K','N','U','1','0','1','T','X',' ','1','0','0','b','a','s','e','T','X',' ','\x7f',
/* 0x1c61c = "FinePix A204/2650 Zoom (DSC)" */
    '\xca','i','x',' ','A','2','0','4','/','2','6','5','0',' ','\xe6','(','D','S','C',')',
/* 0x1c630 = "Vanguard International Semiconductor-America" */
    'V','a','n','g','u','a','r','d',' ','\x9c',' ','\xc0','-','A','m','e','r','i','c','a',
/* 0x1c644 = "OL 700-30 Goniometer" */
    'O','L',' ','7','0','0','-','3','0',' ','G','o','n','i','o','m','e','t','e','r',
/* 0x1c658 = "FeliCa S310 [PaSoRi]" */
    'F','e','l','i','C','a',' ','S','3','1','0',' ','[','P','a','S','o','R','i',']',
/* 0x1c66c = "WPN111 802.11g Wireless Adapter [Atheros AR5523]" */
    'W','P','N','1','1','1',' ','\x94','\x01','\x02',' ','[','\xaf','A','R','5','5','2','3',']',
/* 0x1c680 = "SPIF215A SATA bridge" */
    'S','P','I','F','2','1','5','A',' ','S','A','T','A',' ','b','r','i','d','g','e',
/* 0x1c694 = "Iomega Micro Mini 128MB Flash Drive" */
    'I','o','m','e','g','a',' ','\xc4',' ','\xb9',' ','1','2','8','M','B',' ','\x3c',' ','\x14',
/* 0x1c6a8 = "Comfort Curve Keyboard 3000" */
    'C','o','m','f','o','r','t',' ','C','u','r','v','e',' ','\x05',' ','3','0','0','0',
/* 0x1c6bc = "Motorola Bluetooth 2.1+EDR Device" */
    'M','o','t','o','r','o','l','a',' ','\x06',' ','2','.','1','+','E','D','R',' ','\x03',
/* 0x1c6d0 = "MSO1350-E3 Fingerprint Sensor & SmartCard Reader" */
    'M','S','O','1','3','5','0','-','E','3',' ','\x92','\xac',' ','&',' ','\x12','\x15',' ','\x08',
/* 0x1c6e4 = "Tulip Computers B.V." */
    'T','u','l','i','p',' ','C','o','m','p','u','t','e','r','s',' ','B','.','V','.',
/* 0x1c6f8 = "High Bandwidth Codec" */
    'H','i','g','h',' ','B','a','n','d','w','i','d','t','h',' ','C','o','d','e','c',
/* 0x1c70c = "SURFboard SB4220 Cable Modem" */
    'S','U','R','F','b','o','a','r','d',' ','S','B','4','2','2','0',' ','\xa5',' ','\x1c',
/* 0x1c720 = "model 01 Ethernet interface" */
    'm','o','d','e','l',' ','0','1',' ','\x7f',' ','i','n','t','e','r','f','a','c','e',
/* 0x1c734 = "Trigem Mobile SmartDisplay121" */
    'T','r','i','g','e','m',' ','\x96',' ','\x12','D','i','s','p','l','a','y','1','2','1',
/* 0x1c748 = "Cellex Power Products, Inc." */
    'C','e','l','l','e','x',' ','\x24',' ','P','r','o','d','u','c','t','s',',',' ','\x07',
/* 0x1c75c = "SIMCom SIM5218 modem" */
    'S','I','M','C','o','m',' ','S','I','M','5','2','1','8',' ','m','o','d','e','m',
/* 0x1c770 = "SIIG 4-to-2 Printer Switch" */
    'S','I','I','G',' ','4','-','t','o','-','2',' ','\x0c',' ','S','w','i','t','c','h',
/* 0x1c784 = "Young Generation International Corp." */
    'Y','o','u','n','g',' ','G','e','n','e','r','a','t','i','o','n',' ','\x9c',' ','\x10',
/* 0x1c798 = "AverTV Red HD+ (A850T)" */
    'A','v','e','r','\xda','R','e','d',' ','H','D','+',' ','(','A','8','5','0','T',')',
/* 0x1c7ac = "APX Series Radio (Mobile)" */
    'A','P','X',' ','\xbf',' ','R','a','d','i','o',' ','(','M','o','b','i','l','e',')',
/* 0x1c7c0 = "Linino ONE (CDC ACM)" */
    'L','i','n','i','n','o',' ','O','N','E',' ','(','C','D','C',' ','A','C','M',')',
/* 0x1c7d4 = "63-in-1 Multi-Card Reader/Writer" */
    '6','3','-','i','n','-','1',' ','\xd6','-','\x15',' ','R','e','a','d','e','r','/','\xdf',
/* 0x1c7e8 = "FTDI232 [EasyPort Mini]" */
    'F','T','D','I','2','3','2',' ','[','E','a','s','y','\x87',' ','M','i','n','i',']',
/* 0x1c7fc = "J108i Cedar (modem mode)" */
    'J','1','0','8','i',' ','C','e','d','a','r',' ','(','m','o','d','e','m',' ','\x1a',
/* 0x1c810 = "DataTraveler 200 (32GB)" */
    '\xe7','T','r','a','v','e','l','e','r',' ','2','0','0',' ','(','3','2','G','B',')',
/* 0x1c824 = "SpeedStream Wireless" */
    'S','p','e','e','d','S','t','r','e','a','m',' ','W','i','r','e','l','e','s','s',
/* 0x1c838 = "ET/TX-S Ethernet [pegasus2]" */
    'E','T','/','T','X','-','S',' ','\x7f',' ','[','p','e','g','a','s','u','s','2',']',
/* 0x1c84c = "BCC950 ConferenceCam" */
    'B','C','C','9','5','0',' ','C','o','n','f','e','r','e','n','c','e','C','a','m',
/* 0x1c860 = "Sankyo Seiki Mfg. Co., Ltd" */
    'S','a','n','k','y','o',' ','S','e','i','k','i',' ','M','f','g','.',' ','\x0e','\x16',
/* 0x1c874 = "Toshiba Stor.E Alu 2" */
    'T','o','s','h','i','b','a',' ','S','t','o','r','.','E',' ','A','l','u',' ','2',
/* 0x1c888 = "OnSpec Electronic, Inc." */
    'O','n','S','p','e','c',' ','E','l','e','c','t','r','o','n','i','c',',',' ','\x07',
/* 0x1c89c = "eTrex Vista HCx (Mass Storage mode)" */
    'e','T','r','e','x',' ','V','i','s','t','a',' ','H','C','x',' ','(','\x7c','\x0f','\x1a',
/* 0x1c8b0 = "System Connection, Inc." */
    'S','y','s','t','e','m',' ','C','o','n','n','e','c','t','i','o','n',',',' ','\x07',
/* 0x1c8c4 = "Nogatech TV! Pro (PAL)" */
    'N','o','g','a','t','e','c','h',' ','T','V','!',' ','\x8f',' ','(','P','A','L',')',
/* 0x1c8d8 = "Wiener, Plein & Baus" */
    'W','i','e','n','e','r',',',' ','P','l','e','i','n',' ','&',' ','B','a','u','s',
/* 0x1c8ec = "C8051F34x Bootloader" */
    'C','8','0','5','1','F','3','4','x',' ','B','o','o','t','l','o','a','d','e','r',
/* 0x1c900 = "Omnidirectional Control Technology, Inc." */
    'O','m','n','i','d','i','r','e','c','t','i','o','n','a','l',' ','\xc9',' ','\x95','\x07',
/* 0x1c914 = "Hauppauge WinTV-USB France 4D23" */
    '\xfb','W','i','n','T','V','-','\x0a',' ','F','r','a','n','c','e',' ','4','D','2','3',
/* 0x1c928 = "Bodega Wireless Access Point" */
    'B','o','d','e','g','a',' ','\x01','A','c','c','e','s','s',' ','P','o','i','n','t',
/* 0x1c93c = "D900e/B2100 Mass Storage" */
    'D','9','0','0','e','/','B','2','1','0','0',' ','\x7c','S','t','o','r','a','g','e',
/* 0x1c950 = "USBAT-2 CompactFlash Card Reader" */
    'U','S','B','A','T','-','2',' ','C','o','m','p','a','c','t','\x3c',' ','\x15',' ','\x08',
/* 0x1c964 = "Keithley Instruments" */
    'K','e','i','t','h','l','e','y',' ','I','n','s','t','r','u','m','e','n','t','s',
/* 0x1c978 = "Hi-Speed USB to SATA Bridge" */
    'H','i','-','S','p','e','e','d',' ','\x0a',' ','t','o',' ','S','A','T','A',' ','\x9f',
/* 0x1c98c = "Ex-Series RNDIS interface" */
    'E','x','-','\xbf',' ','R','N','D','I','S',' ','i','n','t','e','r','f','a','c','e',
/* 0x1c9a0 = "NOMAD MuVo^2 (Flash)" */
    'N','O','M','A','D',' ','M','u','V','o','^','2',' ','(','F','l','a','s','h',')',
/* 0x1c9b4 = "Corded Workstation Mouse" */
    'C','o','r','d','e','d',' ','W','o','r','k','s','t','a','t','i','o','n',' ','\x0b',
/* 0x1c9c8 = "Sony Playstation Eye" */
    'S','o','n','y',' ','P','l','a','y','s','t','a','t','i','o','n',' ','E','y','e',
/* 0x1c9dc = "Bluetooth Controller from (Intel/CSR)" */
    '\x06',' ','\x13',' ','f','r','o','m',' ','(','I','n','t','e','l','/','C','S','R',')',
/* 0x1c9f0 = "Micro Vault 64M Mass Storage" */
    '\xc4',' ','V','a','u','l','t',' ','6','4','M',' ','\x7c','S','t','o','r','a','g','e',
/* 0x1ca04 = "Xbox 360 Wireless Receiver for Windows" */
    'X','b','o','x',' ','3','6','0',' ','\x01','\x8c',' ','\xcc','W','i','n','d','o','w','s',
/* 0x1ca18 = "FR-300USB 802.11bgn Wireless Adapter" */
    'F','R','-','3','0','0','\x0a',' ','8','0','2','.','1','1','b','g','n',' ','\x01','\x02',
/* 0x1ca2c = "Xperia Pro [Tethering]" */
    'X','p','e','r','i','a',' ','\x8f',' ','[','T','e','t','h','e','r','i','n','g',']',
/* 0x1ca40 = "SPIF30x Serial-ATA bridge" */
    'S','P','I','F','3','0','x',' ','\x90','-','A','T','A',' ','b','r','i','d','g','e',
/* 0x1ca54 = "Fujitsu Media Devices, Ltd" */
    'F','u','j','i','t','s','u',' ','\xa1',' ','D','e','v','i','c','e','s',',',' ','\x16',
/* 0x1ca68 = "NANO BIOS Programmer" */
    'N','A','N','O',' ','B','I','O','S',' ','P','r','o','g','r','a','m','m','e','r',
/* 0x1ca7c = "WinFast TV - PAL I/DK + FM" */
    'W','i','n','\xec','\xda','-',' ','P','A','L',' ','I','/','D','K',' ','+',' ','F','M',
/* 0x1ca90 = "arcin arcade controller (DFU)" */
    'a','r','c','i','n',' ','a','r','c','a','d','e',' ','\x9e',' ','(','D','F','U',')',
/* 0x1caa4 = "P2600 Rumble Force Pad" */
    'P','2','6','0','0',' ','R','u','m','b','l','e',' ','F','o','r','c','e',' ','\xfa',
/* 0x1cab8 = "Survivor Stealth Flash Drive" */
    'S','u','r','v','i','v','o','r',' ','S','t','e','a','l','t','h',' ','\x3c',' ','\x14',
/* 0x1cacc = "Skywalker-2 DVB-S tuner" */
    'S','k','y','w','a','l','k','e','r','-','2',' ','\xa7','S',' ','t','u','n','e','r',
/* 0x1cae0 = "USR5637 56K Faxmodem" */
    'U','S','R','5','6','3','7',' ','5','6','K',' ','F','a','x','m','o','d','e','m',
/* 0x1caf4 = "BandLuxe 3.5G HSPA Adapter" */
    'B','a','n','d','L','u','x','e',' ','3','.','5','G',' ','H','S','P','A',' ','\x02',
/* 0x1cb08 = "5610 XpressMusic (Storage mode)" */
    '5','6','1','0',' ','X','p','r','e','s','s','M','u','s','i','c',' ','(','\x0f','\x1a',
/* 0x1cb1c = "IMT-0521 Smartcard Reader" */
    'I','M','T','-','0','5','2','1',' ','S','m','a','r','t','c','a','r','d',' ','\x08',
/* 0x1cb30 = "Cyborg Gold Joystick" */
    'C','y','b','o','r','g',' ','G','o','l','d',' ','J','o','y','s','t','i','c','k',
/* 0x1cb44 = "ToolHouse LoopBack Adapter" */
    'T','o','o','l','H','o','u','s','e',' ','L','o','o','p','B','a','c','k',' ','\x02',
/* 0x1cb58 = "AE1000 v1 802.11n [Ralink RT3572]" */
    'A','E','1','0','0','0',' ','v','1',' ','\x99','[','\x93','R','T','3','5','7','2',']',
/* 0x1cb6c = "QuickCam for Notebook Deluxe" */
    '\xc7','a','m',' ','\xcc','N','o','t','e','b','o','o','k',' ','D','e','l','u','x','e',
/* 0x1cb80 = "IRTOUCHSYSTEMS Co. Ltd." */
    'I','R','T','O','U','C','H','S','Y','S','T','E','M','S',' ','C','o','.',' ','\xab',
/* 0x1cb94 = "Ubertooth Zero (DFU)" */
    'U','b','e','r','t','o','o','t','h',' ','Z','e','r','o',' ','(','D','F','U',')',
/* 0x1cba8 = "TST-Touchless Sensor Technology AG" */
    'T','S','T','-','T','o','u','c','h','l','e','s','s',' ','\xac',' ','\x0d',' ','A','G',
/* 0x1cbbc = "BAYI Printer Class Support" */
    'B','A','Y','I',' ','\x0c',' ','C','l','a','s','s',' ','S','u','p','p','o','r','t',
/* 0x1cbd0 = "Stylus Photo RX420/RX425/RX430" */
    '\xb1','\x86',' ','R','X','4','2','0','/','R','X','4','2','5','/','R','X','4','3','0',
/* 0x1cbe4 = "Gaming Keyboard G110 G-keys" */
    'G','a','m','i','n','g',' ','\x05',' ','G','1','1','0',' ','G','-','k','e','y','s',
/* 0x1cbf8 = "UVC 1.3MPixel WebCam" */
    'U','V','C',' ','1','.','3','M','P','i','x','e','l',' ','W','e','b','C','a','m',
/* 0x1cc0c = "Texas Instruments, Inc." */
    'T','e','x','a','s',' ','I','n','s','t','r','u','m','e','n','t','s',',',' ','\x07',
/* 0x1cc20 = "force feedback Wheel" */
    'f','o','r','c','e',' ','f','e','e','d','b','a','c','k',' ','W','h','e','e','l',
/* 0x1cc34 = "Applied Microsystems" */
    'A','p','p','l','i','e','d',' ','M','i','c','r','o','s','y','s','t','e','m','s',
/* 0x1cc48 = "Gabotronics Xminilab" */
    'G','a','b','o','t','r','o','n','i','c','s',' ','X','m','i','n','i','l','a','b',
/* 0x1cc5c = "ACC Microelectronics" */
    'A','C','C',' ','M','i','c','r','o','e','l','e','c','t','r','o','n','i','c','s',
/* 0x1cc70 = "USB Pro (24/96 playback)" */
    '\x0a',' ','\x8f',' ','(','2','4','/','9','6',' ','p','l','a','y','b','a','c','k',')',
/* 0x1cc84 = "Stellaris ICDI Board" */
    'S','t','e','l','l','a','r','i','s',' ','I','C','D','I',' ','B','o','a','r','d',
/* 0x1cc98 = "Connectivity Cable DKU-5" */
    'C','o','n','n','e','c','t','i','v','i','t','y',' ','\xa5',' ','D','K','U','-','5',
/* 0x1ccac = "SurfBoard SB4200 Cable Modem" */
    'S','u','r','f','B','o','a','r','d',' ','S','B','4','2','0','0',' ','\xa5',' ','\x1c',
/* 0x1ccc0 = "2500H Tracer Trainer" */
    '2','5','0','0','H',' ','T','r','a','c','e','r',' ','T','r','a','i','n','e','r',
/* 0x1ccd4 = "MHS-PM5 HD camcorder" */
    'M','H','S','-','P','M','5',' ','H','D',' ','c','a','m','c','o','r','d','e','r',
/* 0x1cce8 = "Xbox360 DVD Emulator" */
    'X','b','o','x','3','6','0',' ','D','V','D',' ','E','m','u','l','a','t','o','r',
/* 0x1ccfc = "Dual Analog Rumble Pad" */
    'D','u','a','l',' ','A','n','a','l','o','g',' ','R','u','m','b','l','e',' ','\xfa',
/* 0x1cd10 = "Advanced Analogic Technologies, Inc." */
    'A','d','v','a','n','c','e','d',' ','A','n','a','l','o','g','i','c',' ','\x89','\x07',
/* 0x1cd24 = "U2SCX SCSI Converter" */
    'U','2','S','C','X',' ','S','C','S','I',' ','C','o','n','v','e','r','t','e','r',
/* 0x1cd38 = "Integrated Circuit Solution, Inc." */
    '\x18','C','i','r','c','u','i','t',' ','S','o','l','u','t','i','o','n',',',' ','\x07',
/* 0x1cd4c = "Casira with BlueCore4-External Module" */
    'C','a','s','i','r','a',' ','\x98','B','l','u','e','C','o','r','e','4','-','\xe3','\xe5',
/* 0x1cd60 = "GDP-04 desktop phone" */
    'G','D','P','-','0','4',' ','d','e','s','k','t','o','p',' ','p','h','o','n','e',
/* 0x1cd74 = "DTH-2242 touchscreen" */
    'D','T','H','-','2','2','4','2',' ','t','o','u','c','h','s','c','r','e','e','n',
/* 0x1cd88 = "Rocketfish Wireless 2.4G Laser Mouse" */
    'R','o','c','k','e','t','f','i','s','h',' ','\x01','2','.','4','G',' ','\x82',' ','\x0b',
/* 0x1cd9c = "2.0M UVC Webcam / CNF7129" */
    '2','.','0','M',' ','U','V','C',' ','\x11',' ','/',' ','C','N','F','7','1','2','9',
/* 0x1cdb0 = "AES4000 TruePrint Sensor." */
    'A','E','S','4','0','0','0',' ','T','r','u','e','\xbd','S','e','n','s','o','r','.',
/* 0x1cdc4 = "Orbit TrackBall for Mac" */
    'O','r','b','i','t',' ','T','r','a','c','k','B','a','l','l',' ','\xcc','M','a','c',
/* 0x1cdd8 = "SYS WaveTerminal U2A" */
    'S','Y','S',' ','W','a','v','e','T','e','r','m','i','n','a','l',' ','U','2','A',
/* 0x1cdec = "Shanghai Darong Electronics Co., Ltd" */
    'S','h','a','n','g','h','a','i',' ','D','a','r','o','n','g',' ','\x1b',' ','\x0e','\x16',
/* 0x1ce00 = "Miditech Play\'n Roll" */
    'M','i','d','i','t','e','c','h',' ','P','l','a','y','\'','n',' ','R','o','l','l',
/* 0x1ce14 = "Shin An Wire & Cable Co." */
    'S','h','i','n',' ','A','n',' ','W','i','r','e',' ','&',' ','\xa5',' ','C','o','.',
/* 0x1ce28 = "Smart Card Reader/JSTU-9700" */
    '\x12',' ','\x15',' ','R','e','a','d','e','r','/','J','S','T','U','-','9','7','0','0',
/* 0x1ce3c = "Casira with BlueCore2-External Module" */
    'C','a','s','i','r','a',' ','\x98','B','l','u','e','C','o','r','e','2','-','\xe3','\xe5',
/* 0x1ce50 = "DocuPrint M760 (X760_USB)" */
    'D','o','c','u','\xbd','M','7','6','0',' ','(','X','7','6','0','_','U','S','B',')',
/* 0x1ce64 = "Ubiquiti Networks, Inc." */
    'U','b','i','q','u','i','t','i',' ','N','e','t','w','o','r','k','s',',',' ','\x07',
/* 0x1ce78 = "AMI Semiconductor, Inc." */
    'A','M','I',' ','S','e','m','i','c','o','n','d','u','c','t','o','r',',',' ','\x07',
/* 0x1ce8c = "Trust Electronic (Shanghai) Co., Ltd" */
    'T','r','u','s','t',' ','\xba','(','S','h','a','n','g','h','a','i',')',' ','\x0e','\x16',
/* 0x1cea0 = "C7-00 (Nokia Suite mode)" */
    'C','7','-','0','0',' ','(','N','o','k','i','a',' ','S','u','i','t','e',' ','\x1a',
/* 0x1ceb4 = "SDDR-103 MobileMate SD+ Reader" */
    'S','D','D','R','-','1','0','3',' ','\x96','M','a','t','e',' ','S','D','+',' ','\x08',
/* 0x1cec8 = "Infineon WildCard-USB Wireless LAN Adapter" */
    'I','n','f','i','n','e','o','n',' ','W','i','l','d','\x15','-','\x0a',' ','\x01','\xf3','\x02',
/* 0x1cedc = "Storage device (8gB thumb drive)" */
    '\x0f','\xf9',' ','(','8','g','B',' ','t','h','u','m','b',' ','d','r','i','v','e',')',
/* 0x1cef0 = "Develop D 2050iD PCL" */
    'D','e','v','e','l','o','p',' ','D',' ','2','0','5','0','i','D',' ','P','C','L',
/* 0x1cf04 = "Jabra GN9330 Headset" */
    'J','a','b','r','a',' ','G','N','9','3','3','0',' ','H','e','a','d','s','e','t',
/* 0x1cf18 = "ADT VvBus for CopperJet" */
    'A','D','T',' ','V','v','B','u','s',' ','\xcc','C','o','p','p','e','r','J','e','t',
/* 0x1cf2c = "BearPaw 1200 CU Plus" */
    'B','e','a','r','P','a','w',' ','1','2','0','0',' ','C','U',' ','P','l','u','s',
/* 0x1cf40 = "telavivmakers attami" */
    't','e','l','a','v','i','v','m','a','k','e','r','s',' ','a','t','t','a','m','i',
/* 0x1cf54 = "Kingston Technology Company Inc." */
    'K','i','n','g','s','t','o','n',' ','\x0d',' ','C','o','m','p','a','n','y',' ','\x07',
/* 0x1cf68 = "BearPaw 2400 TA Plus" */
    'B','e','a','r','P','a','w',' ','2','4','0','0',' ','T','A',' ','P','l','u','s',
/* 0x1cf7c = "Ovation U720/MCD3000" */
    'O','v','a','t','i','o','n',' ','U','7','2','0','/','M','C','D','3','0','0','0',
/* 0x1cf90 = "KL5KUSB101B Ethernet [klsi]" */
    'K','L','5','K','U','S','B','1','0','1','B',' ','\x7f',' ','[','k','l','s','i',']',
/* 0x1cfa4 = "ColorPage-Slim 1200 USB2" */
    '\xa2','P','a','g','e','-','S','l','i','m',' ','1','2','0','0',' ','U','S','B','2',
/* 0x1cfb8 = "Nippon Systemware Co., Ltd" */
    'N','i','p','p','o','n',' ','S','y','s','t','e','m','w','a','r','e',' ','\x0e','\x16',
/* 0x1cfcc = "Storage device (2gB thumb drive)" */
    '\x0f','\xf9',' ','(','2','g','B',' ','t','h','u','m','b',' ','d','r','i','v','e',')',
/* 0x1cfe0 = "U.S. Robotics (3Com)" */
    'U','.','S','.',' ','R','o','b','o','t','i','c','s',' ','(','3','C','o','m',')',
/* 0x1cff4 = "PRS-500 eBook reader" */
    'P','R','S','-','5','0','0',' ','e','B','o','o','k',' ','r','e','a','d','e','r',
/* 0x1d008 = "802.11 n/g/b Wireless LAN USB Mini-Card" */
    '8','0','2','.','1','1',' ','n','/','g','/','b',' ','\x01','\xf3','\x0a',' ','\xb9','-','\x15',
/* 0x1d01c = "WUBR-177G [Ralink RT2571W]" */
    'W','U','B','R','-','1','7','7','G',' ','[','\x93','R','T','2','5','7','1','W',']',
/* 0x1d030 = "Sony Ericsson Mobile Communications AB" */
    'S','o','n','y',' ','E','r','i','c','s','s','o','n',' ','\x96',' ','\xd1',' ','A','B',
/* 0x1d044 = "K590 Printer, Self-Service" */
    'K','5','9','0',' ','P','r','i','n','t','e','r',',',' ','S','e','l','f','-','\xd7',
/* 0x1d058 = "Yubikey NEO(-N) CCID" */
    'Y','u','b','i','k','e','y',' ','N','E','O','(','-','N',')',' ','C','C','I','D',
/* 0x1d06c = "CMOTECH CDMA Technologies modem" */
    'C','M','O','T','E','C','H',' ','C','D','M','A',' ','\x88',' ','m','o','d','e','m',
/* 0x1d080 = "DMVC 2000K Video Capture" */
    'D','M','V','C',' ','2','0','0','0','K',' ','\xa3',' ','C','a','p','t','u','r','e',
/* 0x1d094 = "TL-WN320G 1.0 WLAN Adapter" */
    'T','L','-','W','N','3','2','0','G',' ','1','.','0',' ','W','L','A','N',' ','\x02',
/* 0x1d0a8 = "UMAX Astra 3000/3600" */
    'U','M','A','X',' ','A','s','t','r','a',' ','3','0','0','0','/','3','6','0','0',
/* 0x1d0bc = "raphnet.net USBTenki" */
    'r','a','p','h','n','e','t','.','n','e','t',' ','U','S','B','T','e','n','k','i',
/* 0x1d0d0 = "Vivitar Vivicam3350B" */
    'V','i','v','i','t','a','r',' ','V','i','v','i','c','a','m','3','3','5','0','B',
/* 0x1d0e4 = "Abbott Diabetes Care" */
    'A','b','b','o','t','t',' ','D','i','a','b','e','t','e','s',' ','C','a','r','e',
/* 0x1d0f8 = "TT-connect T-3650 CI" */
    'T','T','-','c','o','n','n','e','c','t',' ','T','-','3','6','5','0',' ','C','I',
/* 0x1d10c = "BearPaw 2400 CU Plus" */
    'B','e','a','r','P','a','w',' ','2','4','0','0',' ','C','U',' ','P','l','u','s',
/* 0x1d120 = "Attache 256MB USB 2.0 Flash Drive" */
    'A','t','t','a','c','h','e',' ','2','5','6','M','B',' ','\x0a',' ','\xc1','\x3c',' ','\x14',
/* 0x1d134 = "nanoKONTROL studio controller" */
    'n','a','n','o','K','O','N','T','R','O','L',' ','s','t','u','d','i','o',' ','\x9e',
/* 0x1d148 = "Scriptel Corporation" */
    'S','c','r','i','p','t','e','l',' ','C','o','r','p','o','r','a','t','i','o','n',
/* 0x1d15c = "MediaTV Analog/FM/DVB-T MiniPCIe" */
    '\xa1','\xda','A','n','a','l','o','g','/','F','M','/','\xa7','T',' ','\xb9','P','C','I','e',
/* 0x1d170 = "PEGATRON CORPORATION" */
    'P','E','G','A','T','R','O','N',' ','C','O','R','P','O','R','A','T','I','O','N',
/* 0x1d184 = "VCP, Barcode scanner" */
    'V','C','P',',',' ','B','a','r','c','o','d','e',' ','s','c','a','n','n','e','r',
/* 0x1d198 = "Gemlight Computer, Ltd" */
    'G','e','m','l','i','g','h','t',' ','C','o','m','p','u','t','e','r',',',' ','\x16',
/* 0x1d1ac = "Kingston Flash Drive (128MB)" */
    'K','i','n','g','s','t','o','n',' ','\x3c',' ','\x14',' ','(','1','2','8','M','B',')',
/* 0x1d1c0 = "Super Talent 1GB Flash Drive" */
    'S','u','p','e','r',' ','T','a','l','e','n','t',' ','1','G','B',' ','\x3c',' ','\x14',
/* 0x1d1d4 = "Omega Technology of Taiwan, Inc." */
    'O','m','e','g','a',' ','\x0d',' ','o','f',' ','T','a','i','w','a','n',',',' ','\x07',
/* 0x1d1e8 = "PowerShot ELPH 150 IS / IXUS 155" */
    '\x24','\x84','E','L','P','H',' ','1','5','0',' ','I','S',' ','/',' ','\xfd','1','5','5',
/* 0x1d1fc = "Unknown Manufacturer" */
    'U','n','k','n','o','w','n',' ','M','a','n','u','f','a','c','t','u','r','e','r',
/* 0x1d210 = "H837 Hybrid ATSC/QAM" */
    'H','8','3','7',' ','H','y','b','r','i','d',' ','A','T','S','C','/','Q','A','M',
/* 0x1d224 = "Keychain photo frame" */
    'K','e','y','c','h','a','i','n',' ','p','h','o','t','o',' ','f','r','a','m','e',
/* 0x1d238 = "iPod Touch 5.Gen [A1421]" */
    'i','P','o','d',' ','\x9d',' ','5','.','G','e','n',' ','[','A','1','4','2','1',']',
/* 0x1d24c = "Huey PRO Colorimeter" */
    'H','u','e','y',' ','P','R','O',' ','C','o','l','o','r','i','m','e','t','e','r',
/* 0x1d260 = "WUSB200 802.11g Adapter [Ralink RT2671]" */
    'W','U','S','B','2','0','0',' ','\x94','\x02',' ','[','\x93','R','T','2','6','7','1',']',
/* 0x1d274 = "My Passport Ultra (WD10JMVW)" */
    'M','y',' ','\xd5','U','l','t','r','a',' ','(','W','D','1','0','J','M','V','W',')',
/* 0x1d288 = "LPC2378 [Robotino 3]" */
    'L','P','C','2','3','7','8',' ','[','R','o','b','o','t','i','n','o',' ','3',']',
/* 0x1d29c = "TI-Nspire Calculator" */
    'T','I','-','N','s','p','i','r','e',' ','C','a','l','c','u','l','a','t','o','r',
/* 0x1d2b0 = "Speedstream Ethernet Adapter E240" */
    'S','p','e','e','d','s','t','r','e','a','m',' ','\x7f',' ','\x02',' ','E','2','4','0',
/* 0x1d2c4 = "TT TV-Stick (8kB EEPROM)" */
    'T','T',' ','T','V','-','\xb3',' ','(','8','k','B',' ','E','E','P','R','O','M',')',
/* 0x1d2d8 = "FeliCa S330 [PaSoRi]" */
    'F','e','l','i','C','a',' ','S','3','3','0',' ','[','P','a','S','o','R','i',']',
/* 0x1d2ec = "Open Pinball Project" */
    'O','p','e','n',' ','P','i','n','b','a','l','l',' ','P','r','o','j','e','c','t',
/* 0x1d300 = "ADM8511 Pegasus II Ethernet" */
    'A','D','M','8','5','1','1',' ','P','e','g','a','s','u','s',' ','I','I',' ','\x7f',
/* 0x1d314 = "Amphenol East Asia Ltd." */
    'A','m','p','h','e','n','o','l',' ','E','a','s','t',' ','A','s','i','a',' ','\xab',
/* 0x1d328 = "DUB-H7 7-port USB 2.0 hub" */
    'D','U','B','-','H','7',' ','7','-','p','o','r','t',' ','\x0a',' ','\xc1','h','u','b',
/* 0x1d33c = "PS2232 flash drive controller" */
    'P','S','2','2','3','2',' ','f','l','a','s','h',' ','d','r','i','v','e',' ','\x9e',
/* 0x1d350 = "TechFaith Wireless Technology Limited" */
    'T','e','c','h','F','a','i','t','h',' ','\x01','\x0d',' ','L','i','m','i','t','e','d',
/* 0x1d364 = "L & K Precision Technology Co., Ltd." */
    'L',' ','&',' ','K',' ','P','r','e','c','i','s','i','o','n',' ','\x0d',' ','\x0e','\xab',
/* 0x1d378 = "A. Eberle GmbH & Co. KG" */
    'A','.',' ','E','b','e','r','l','e',' ','\xfc',' ','&',' ','C','o','.',' ','K','G',
/* 0x1d38c = "Extended Keyboard [Mitsumi]" */
    'E','x','t','e','n','d','e','d',' ','\x05',' ','[','M','i','t','s','u','m','i',']',
/* 0x1d3a0 = "USB Mouse [Mitsumi, M4848]" */
    '\x0a',' ','\x0b',' ','[','M','i','t','s','u','m','i',',',' ','M','4','8','4','8',']',
/* 0x1d3b4 = "LightUp (bootloader)" */
    'L','i','g','h','t','U','p',' ','(','b','o','o','t','l','o','a','d','e','r',')',
/* 0x1d3c8 = "Ch Throttle Quadrant" */
    'C','h',' ','T','h','r','o','t','t','l','e',' ','Q','u','a','d','r','a','n','t',
/* 0x1d3dc = "Stylus Office BX320FW/TX525FW Series" */
    '\xb1','\xd3',' ','B','X','3','2','0','F','W','/','T','X','5','2','5','F','W',' ','\xbf',
/* 0x1d3f0 = "CTX M730V built in Camera" */
    'C','T','X',' ','M','7','3','0','V',' ','b','u','i','l','t',' ','i','n',' ','\x04',
/* 0x1d404 = "BCM4319 802.11bgn Wireless Adapter" */
    'B','C','M','4','3','1','9',' ','8','0','2','.','1','1','b','g','n',' ','\x01','\x02',
/* 0x1d418 = "TUSB9260 Boot Loader" */
    'T','U','S','B','9','2','6','0',' ','B','o','o','t',' ','L','o','a','d','e','r',
/* 0x1d42c = "NWD-270N Wireless N-lite USB Adapter" */
    'N','W','D','-','2','7','0','N',' ','\x01','N','-','l','i','t','e',' ','\x0a',' ','\x02',
/* 0x1d440 = "PicoScope 3000A series PC Oscilloscope" */
    'P','i','c','o','S','c','o','p','e',' ','3','0','0','0','A',' ','\x1d',' ','\x1f','\xfe',
/* 0x1d454 = "Guidance Software, Inc." */
    'G','u','i','d','a','n','c','e',' ','S','o','f','t','w','a','r','e',',',' ','\x07',
/* 0x1d468 = "GLUSB98PT Parallel Port" */
    'G','L','U','S','B','9','8','P','T',' ','P','a','r','a','l','l','e','l',' ','\x87',
/* 0x1d47c = "Wireless Keyboard/Mouse Combo [MK1152WC]" */
    '\x01','\xc6','\x0b',' ','C','o','m','b','o',' ','[','M','K','1','1','5','2','W','C',']',
/* 0x1d490 = "Movado Enterprise Co., Ltd" */
    'M','o','v','a','d','o',' ','E','n','t','e','r','p','r','i','s','e',' ','\x0e','\x16',
/* 0x1d4a4 = "EasyShare Printer Dock Series 3" */
    'E','a','s','y','S','h','a','r','e',' ','\x0c',' ','D','o','c','k',' ','\xbf',' ','3',
/* 0x1d4b8 = "CanoScan N1240U/LiDE 30" */
    'C','a','n','o','\x8a',' ','N','1','2','4','0','U','/','L','i','D','E',' ','3','0',
/* 0x1d4cc = "My Passport Essential (WDME)" */
    'M','y',' ','\xd5','E','s','s','e','n','t','i','a','l',' ','(','W','D','M','E',')',
/* 0x1d4e0 = "CTE-631 [Bamboo One]" */
    'C','T','E','-','6','3','1',' ','[','B','a','m','b','o','o',' ','O','n','e',']',
/* 0x1d4f4 = "Shenzhen Xianhe Technology Co., Ltd." */
    'S','h','e','n','z','h','e','n',' ','X','i','a','n','h','e',' ','\x0d',' ','\x0e','\xab',
/* 0x1d508 = "TT-connect C-3650 CI" */
    'T','T','-','c','o','n','n','e','c','t',' ','C','-','3','6','5','0',' ','C','I',
/* 0x1d51c = "EDIROL UA-25EX (Advanced mode)" */
    '\xf8','U','A','-','2','5','E','X',' ','(','A','d','v','a','n','c','e','d',' ','\x1a',
/* 0x1d530 = "ScanExpress 1200 USB Plus" */
    '\x8a','E','x','p','r','e','s','s',' ','1','2','0','0',' ','\x0a',' ','P','l','u','s',
/* 0x1d544 = "Haurtian Wire & Cable Co., Ltd" */
    'H','a','u','r','t','i','a','n',' ','W','i','r','e',' ','&',' ','\xa5',' ','\x0e','\x16',
/* 0x1d558 = "Develop D 1650iD PCL" */
    'D','e','v','e','l','o','p',' ','D',' ','1','6','5','0','i','D',' ','P','C','L',
/* 0x1d56c = "Ambit Microsystems Corp." */
    'A','m','b','i','t',' ','M','i','c','r','o','s','y','s','t','e','m','s',' ','\x10',
/* 0x1d580 = "Digital TV Tuner Card [RTL2832U]" */
    '\x09','\xda','T','u','n','e','r',' ','\x15',' ','[','R','T','L','2','8','3','2','U',']',
/* 0x1d594 = "PowerShot ELPH 170 IS / IXUS 170" */
    '\x24','\x84','E','L','P','H',' ','1','7','0',' ','I','S',' ','/',' ','\xfd','1','7','0',
/* 0x1d5a8 = "WN Central Special Electronics" */
    'W','N',' ','C','e','n','t','r','a','l',' ','S','p','e','c','i','a','l',' ','\x1b',
/* 0x1d5bc = "DocuPrint M750 (X750_USB)" */
    'D','o','c','u','\xbd','M','7','5','0',' ','(','X','7','5','0','_','U','S','B',')',
/* 0x1d5d0 = "Geniality Maple Technology Co., Ltd" */
    'G','e','n','i','a','l','i','t','y',' ','M','a','p','l','e',' ','\x0d',' ','\x0e','\x16',
/* 0x1d5e4 = "CDM-751 CD organizer" */
    'C','D','M','-','7','5','1',' ','C','D',' ','o','r','g','a','n','i','z','e','r',
/* 0x1d5f8 = "PilotMouse Mini Retractable" */
    'P','i','l','o','t','\x0b',' ','\xb9',' ','R','e','t','r','a','c','t','a','b','l','e',
/* 0x1d60c = "Zebra GC420d Label Printer" */
    'Z','e','b','r','a',' ','G','C','4','2','0','d',' ','L','a','b','e','l',' ','\x0c',
/* 0x1d620 = "Paparazzi (Mass Storage)" */
    'P','a','p','a','r','a','z','z','i',' ','(','\x7c','S','t','o','r','a','g','e',')',
/* 0x1d634 = "DataTraveler DT101C Flash Drive" */
    '\xe7','T','r','a','v','e','l','e','r',' ','D','T','1','0','1','C',' ','\x3c',' ','\x14',
/* 0x1d648 = "Nexus 4 (bootloader)" */
    'N','e','x','u','s',' ','4',' ','(','b','o','o','t','l','o','a','d','e','r',')',
/* 0x1d65c = "Digital Blue QX5 Microscope" */
    '\x09','B','l','u','e',' ','Q','X','5',' ','M','i','c','r','o','s','c','o','p','e',
/* 0x1d670 = "FinePix S304/3800 Zoom (DSC)" */
    '\xca','i','x',' ','S','3','0','4','/','3','8','0','0',' ','\xe6','(','D','S','C',')',
/* 0x1d684 = "N900 (PC-Suite Mode)" */
    'N','9','0','0',' ','(','P','C','-','S','u','i','t','e',' ','M','o','d','e',')',
/* 0x1d698 = "CTF-430 [Bamboo One]" */
    'C','T','F','-','4','3','0',' ','[','B','a','m','b','o','o',' ','O','n','e',']',
/* 0x1d6ac = "Keyboard TRACER Gamma Ivory" */
    '\x05',' ','T','R','A','C','E','R',' ','G','a','m','m','a',' ','I','v','o','r','y',
/* 0x1d6c0 = "Portstation Dual Serial Port" */
    'P','o','r','t','s','t','a','t','i','o','n',' ','D','u','a','l',' ','\x90',' ','\x87',
/* 0x1d6d4 = "Lumberg Connect  GmbH & Co. KG" */
    'L','u','m','b','e','r','g',' ','\xee',' ','\xfc',' ','&',' ','C','o','.',' ','K','G',
/* 0x1d6e8 = "C-Bus Black and White Touchscreen" */
    'C','-','B','u','s',' ','B','l','a','c','k',' ','\xe4','W','h','i','t','e',' ','\xb5',
/* 0x1d6fc = "UPStation GXT 2U UPS" */
    'U','P','S','t','a','t','i','o','n',' ','G','X','T',' ','2','U',' ','U','P','S',
/* 0x1d710 = "DataTraveler 150 (32GB)" */
    '\xe7','T','r','a','v','e','l','e','r',' ','1','5','0',' ','(','3','2','G','B',')',
/* 0x1d724 = "Genius iLook 1321 V2" */
    'G','e','n','i','u','s',' ','i','L','o','o','k',' ','1','3','2','1',' ','V','2',
/* 0x1d738 = "LC1 Linear Camera (Jungo)" */
    'L','C','1',' ','L','i','n','e','a','r',' ','\x04',' ','(','J','u','n','g','o',')',
/* 0x1d74c = "Senior Industries, Inc." */
    'S','e','n','i','o','r',' ','I','n','d','u','s','t','r','i','e','s',',',' ','\x07',
/* 0x1d760 = "AVC-1410 GameBridge TV NTSC" */
    'A','V','C','-','1','4','1','0',' ','G','a','m','e','\x9f',' ','\xda','N','T','S','C',
/* 0x1d774 = "Seiko Instruments, Inc." */
    'S','e','i','k','o',' ','I','n','s','t','r','u','m','e','n','t','s',',',' ','\x07',
/* 0x1d788 = "SideWinder PnP GamePad" */
    'S','i','d','e','W','i','n','d','e','r',' ','P','n','P',' ','G','a','m','e','\xfa',
/* 0x1d79c = "Prime Wireless Kit [FOK65AA]" */
    'P','r','i','m','e',' ','\x01','K','i','t',' ','[','F','O','K','6','5','A','A',']',
/* 0x1d7b0 = "Earthmate GPS (orig)" */
    'E','a','r','t','h','m','a','t','e',' ','G','P','S',' ','(','o','r','i','g',')',
/* 0x1d7c4 = "CASIO HITACHI Mobile Communications Co., Ltd." */
    'C','A','S','I','O',' ','H','I','T','A','C','H','I',' ','\x96',' ','\xd1',' ','\x0e','\xab',
/* 0x1d7d8 = "Auerswald GmbH & Co. KG" */
    'A','u','e','r','s','w','a','l','d',' ','\xfc',' ','&',' ','C','o','.',' ','K','G',
/* 0x1d7ec = "FeliCa S320 [PaSoRi]" */
    'F','e','l','i','C','a',' ','S','3','2','0',' ','[','P','a','S','o','R','i',']',
/* 0x1d800 = "M035 Compact Web Cam" */
    'M','0','3','5',' ','C','o','m','p','a','c','t',' ','W','e','b',' ','C','a','m',
/* 0x1d814 = "TIME Interconnect, Ltd" */
    'T','I','M','E',' ','I','n','t','e','r','c','o','n','n','e','c','t',',',' ','\x16',
/* 0x1d828 = "Yankee Robotics, LLC" */
    'Y','a','n','k','e','e',' ','R','o','b','o','t','i','c','s',',',' ','L','L','C',
/* 0x1d83c = "GL-UPC822 UVC WebCam" */
    'G','L','-','U','P','C','8','2','2',' ','U','V','C',' ','W','e','b','C','a','m',
/* 0x1d850 = "Play audio soundcard" */
    'P','l','a','y',' ','a','u','d','i','o',' ','s','o','u','n','d','c','a','r','d',
/* 0x1d864 = "BladeRF (bootloader)" */
    'B','l','a','d','e','R','F',' ','(','b','o','o','t','l','o','a','d','e','r',')',
/* 0x1d878 = "MFC-8220 Port(FaxModem)" */
    '\x7d','8','2','2','0',' ','P','o','r','t','(','F','a','x','M','o','d','e','m',')',
/* 0x1d88c = "RNIS ISDN TA [HFC-S]" */
    'R','N','I','S',' ','I','S','D','N',' ','T','A',' ','[','H','F','C','-','S',']',
/* 0x1d8a0 = "GW Instek GDS-1000 Oscilloscope" */
    'G','W',' ','I','n','s','t','e','k',' ','G','D','S','-','1','0','0','0',' ','\xfe',
/* 0x1d8b4 = "Nostromo n40 Gamepad" */
    'N','o','s','t','r','o','m','o',' ','n','4','0',' ','G','a','m','e','p','a','d',
/* 0x1d8c8 = "GPS (various models)" */
    'G','P','S',' ','(','v','a','r','i','o','u','s',' ','m','o','d','e','l','s',')',
/* 0x1d8dc = "PowerShot SD100 / Digital IXUS II (ptp)" */
    '\x24','\x84','S','D','1','0','0',' ','/',' ','\x09','\xfd','I','I',' ','(','p','t','p',')',
/* 0x1d8f0 = "Pertech Resources, Inc." */
    'P','e','r','t','e','c','h',' ','R','e','s','o','u','r','c','e','s',',',' ','\x07',
/* 0x1d904 = "CVTouch Screen (HID)" */
    'C','V','T','o','u','c','h',' ','S','c','r','e','e','n',' ','(','H','I','D',')',
/* 0x1d918 = "TerraTec MIDI MASTER" */
    'T','e','r','r','a','T','e','c',' ','M','I','D','I',' ','M','A','S','T','E','R',
/* 0x1d92c = "Unknown manufacturer" */
    'U','n','k','n','o','w','n',' ','m','a','n','u','f','a','c','t','u','r','e','r',
/* 0x1d940 = "Golden Bridge Electech, Inc." */
    'G','o','l','d','e','n',' ','\x9f',' ','E','l','e','c','t','e','c','h',',',' ','\x07',
/* 0x1d954 = "Inland Pro 4500/5000 Mouse" */
    'I','n','l','a','n','d',' ','\x8f',' ','4','5','0','0','/','5','0','0','0',' ','\x0b',
/* 0x1d968 = "J. Gordon Electronic Design, Inc." */
    'J','.',' ','G','o','r','d','o','n',' ','\xba','D','e','s','i','g','n',',',' ','\x07',
/* 0x1d97c = "2-port low-power hub" */
    '2','-','p','o','r','t',' ','l','o','w','-','p','o','w','e','r',' ','h','u','b',
/* 0x1d990 = "Midoriya Electric Co., Ltd" */
    'M','i','d','o','r','i','y','a',' ','E','l','e','c','t','r','i','c',' ','\x0e','\x16',
/* 0x1d9a4 = "Y-UF49 [Internet Pro Keyboard]" */
    'Y','-','U','F','4','9',' ','[','\xb6','\x8f',' ','K','e','y','b','o','a','r','d',']',
/* 0x1d9b8 = "Sony SingStar USBMIC" */
    'S','o','n','y',' ','S','i','n','g','S','t','a','r',' ','U','S','B','M','I','C',
/* 0x1d9cc = "USB,12-Button  Wheel" */
    'U','S','B',',','1','2','-','B','u','t','t','o','n',' ',' ','W','h','e','e','l',
/* 0x1d9e0 = "Finch [Ambit3 Sport]" */
    'F','i','n','c','h',' ','[','A','m','b','i','t','3',' ','S','p','o','r','t',']',
/* 0x1d9f4 = "Yubikey plus OTP+U2F" */
    'Y','u','b','i','k','e','y',' ','p','l','u','s',' ','O','T','P','+','U','2','F',
/* 0x1da08 = "Bullet Line Photo Viewer" */
    'B','u','l','l','e','t',' ','L','i','n','e',' ','\x86',' ','V','i','e','w','e','r',
/* 0x1da1c = "Papenmeier Braille-Display" */
    'P','a','p','e','n','m','e','i','e','r',' ','B','r','a','i','l','l','e','-','\xcf',
/* 0x1da30 = "Solomon Microtech, Ltd" */
    'S','o','l','o','m','o','n',' ','M','i','c','r','o','t','e','c','h',',',' ','\x16',
/* 0x1da44 = "Bio-Rad Laboratories" */
    'B','i','o','-','R','a','d',' ','L','a','b','o','r','a','t','o','r','i','e','s',
/* 0x1da58 = "Ultra II SD Plus 2GB" */
    'U','l','t','r','a',' ','I','I',' ','S','D',' ','P','l','u','s',' ','2','G','B',
/* 0x1da6c = "Cordless Mouse & iTouch Keys" */
    'C','o','r','d','l','e','s','s',' ','\x0b',' ','&',' ','i','\x9d',' ','K','e','y','s',
/* 0x1da80 = "WinFast TV Audio - PHP SECAM DK" */
    'W','i','n','\xec','\xda','\x8b','-',' ','P','H','P',' ','S','E','C','A','M',' ','D','K',
/* 0x1da94 = "DataTraveler Locker 4GB" */
    '\xe7','T','r','a','v','e','l','e','r',' ','L','o','c','k','e','r',' ','4','G','B',
/* 0x1daa8 = "Panache Surf ISDN TA" */
    'P','a','n','a','c','h','e',' ','S','u','r','f',' ','I','S','D','N',' ','T','A',
/* 0x1dabc = "Medion Flash XL V2.0 Card Reader" */
    'M','e','d','i','o','n',' ','\x3c',' ','X','L',' ','V','2','.','0',' ','\x15',' ','\x08',
/* 0x1dad0 = "Litto Version USB2.0" */
    'L','i','t','t','o',' ','V','e','r','s','i','o','n',' ','U','S','B','2','.','0',
/* 0x1dae4 = "Logitech RumblePad 2 USB" */
    'L','o','g','i','t','e','c','h',' ','R','u','m','b','l','e','\xfa',' ','2',' ','\x0a',
/* 0x1daf8 = "libusb-bound devices" */
    'l','i','b','u','s','b','-','b','o','u','n','d',' ','d','e','v','i','c','e','s',
/* 0x1db0c = "Portable Headphone Amplifier" */
    '\xa9','H','e','a','d','p','h','o','n','e',' ','A','m','p','l','i','f','i','e','r',
/* 0x1db20 = "E90 Communicator (Storage mode)" */
    'E','9','0',' ','C','o','m','m','u','n','i','c','a','t','o','r',' ','(','\x0f','\x1a',
/* 0x1db34 = "cyberJack pinpad(a2)" */
    'c','y','b','e','r','J','a','c','k',' ','p','i','n','p','a','d','(','a','2',')',
/* 0x1db48 = "Usb Com Port Enumerator" */
    'U','s','b',' ','C','o','m',' ','\x87',' ','E','n','u','m','e','r','a','t','o','r',
/* 0x1db5c = "Prism GT 802.11b/g Adapter" */
    'P','r','i','s','m',' ','G','T',' ','8','0','2','.','1','1','b','/','g',' ','\x02',
/* 0x1db70 = "Key Mouse Electronic Enterprise Co., Ltd" */
    'K','e','y',' ','\x0b',' ','\xba','E','n','t','e','r','p','r','i','s','e',' ','\x0e','\x16',
/* 0x1db84 = "Ta Yun Terminals Industrial Co., Ltd" */
    'T','a',' ','Y','u','n',' ','T','e','r','m','i','n','a','l','s',' ','\xef','\x0e','\x16',
/* 0x1db98 = "EeePC 701 integrated Webcam" */
    'E','e','e','\x1f','7','0','1',' ','i','n','t','e','g','r','a','t','e','d',' ','\x11',
/* 0x1dbac = "PicoScope 2000A series PC Oscilloscope" */
    'P','i','c','o','S','c','o','p','e',' ','2','0','0','0','A',' ','\x1d',' ','\x1f','\xfe',
/* 0x1dbc0 = "VerticalMouse 3 Wireless" */
    'V','e','r','t','i','c','a','l','\x0b',' ','3',' ','W','i','r','e','l','e','s','s',
/* 0x1dbd4 = "Fuji Electric Device Technology Co., Ltd." */
    'F','u','j','i',' ','E','l','e','c','t','r','i','c',' ','\x03',' ','\x0d',' ','\x0e','\xab',
/* 0x1dbe8 = "MetaGeek Wi-Spy 2.4x" */
    'M','e','t','a','G','e','e','k',' ','W','i','-','S','p','y',' ','2','.','4','x',
/* 0x1dbfc = "Zhejiang Xinya Electronic Technology Co., Ltd." */
    'Z','h','e','j','i','a','n','g',' ','X','i','n','y','a',' ','\xba','\x0d',' ','\x0e','\xab',
/* 0x1dc10 = "Alpen Clack keyboard" */
    'A','l','p','e','n',' ','C','l','a','c','k',' ','k','e','y','b','o','a','r','d',
/* 0x1dc24 = "JyeTai Precision Industrial Co., Ltd." */
    'J','y','e','T','a','i',' ','P','r','e','c','i','s','i','o','n',' ','\xef','\x0e','\xab',
/* 0x1dc38 = "1.3M pixel "Tinycam"" */
    '1','.','3','M',' ','p','i','x','e','l',' ','"','T','i','n','y','c','a','m','"',
/* 0x1dc4c = "Sonix 1.3MPixel USB 2.0 Camera" */
    'S','o','n','i','x',' ','1','.','3','M','P','i','x','e','l',' ','\x0a',' ','\xc1','\x04',
/* 0x1dc60 = "OKIPOS 411/412 POS Printer" */
    'O','K','I','P','O','S',' ','4','1','1','/','4','1','2',' ','P','O','S',' ','\x0c',
/* 0x1dc74 = "ThinkPad Keyboard with TrackPoint" */
    'T','h','i','n','k','\xfa',' ','\x05',' ','\x98','T','r','a','c','k','P','o','i','n','t',
/* 0x1dc88 = "Elitegroup ECS-C11 Camera" */
    'E','l','i','t','e','g','r','o','u','p',' ','E','C','S','-','C','1','1',' ','\x04',
/* 0x1dc9c = "Infowave Software, Inc." */
    'I','n','f','o','w','a','v','e',' ','S','o','f','t','w','a','r','e',',',' ','\x07',
/* 0x1dcb0 = "Digital Dream l\'espion xtra" */
    '\x09','D','r','e','a','m',' ','l','\'','e','s','p','i','o','n',' ','x','t','r','a',
/* 0x1dcc4 = "CDMA/UMTS/GPRS modem" */
    'C','D','M','A','/','U','M','T','S','/','G','P','R','S',' ','m','o','d','e','m',
/* 0x1dcd8 = "SurfBoard SB5101 Cable Modem" */
    'S','u','r','f','B','o','a','r','d',' ','S','B','5','1','0','1',' ','\xa5',' ','\x1c',
/* 0x1dcec = "PhidgetInterface Kit 0-16-16" */
    'P','h','i','d','g','e','t','\x81',' ','K','i','t',' ','0','-','1','6','-','1','6',
/* 0x1dd00 = "Mitac Internatinal Corp." */
    'M','i','t','a','c',' ','I','n','t','e','r','n','a','t','i','n','a','l',' ','\x10',
/* 0x1dd14 = "USB100TX Ethernet [pegasus]" */
    'U','S','B','1','0','0','T','X',' ','\x7f',' ','[','p','e','g','a','s','u','s',']',
/* 0x1dd28 = "5800 XpressMusic (Storage mode)" */
    '5','8','0','0',' ','X','p','r','e','s','s','M','u','s','i','c',' ','(','\x0f','\x1a',
/* 0x1dd3c = "NB 802.11g Wireless LAN Adapter(3887A)" */
    'N','B',' ','\x94','\x01','\xf3','A','d','a','p','t','e','r','(','3','8','8','7','A',')',
/* 0x1dd50 = "My Passport Ultra (WD40NMZW)" */
    'M','y',' ','\xd5','U','l','t','r','a',' ','(','W','D','4','0','N','M','Z','W',')',
/* 0x1dd64 = "Globetrotter HSDPA Modem" */
    'G','l','o','b','e','t','r','o','t','t','e','r',' ','H','S','D','P','A',' ','\x1c',
/* 0x1dd78 = "RTL8187B Wireless 802.11g 54Mbps Network Adapter" */
    'R','T','L','8','1','8','7','B',' ','\x01','\x94','5','4','M','b','p','s',' ','\x8d','\x02',
/* 0x1dd8c = "Moravian Instruments" */
    'M','o','r','a','v','i','a','n',' ','I','n','s','t','r','u','m','e','n','t','s',
/* 0x1dda0 = "UC-100KM PS/2 Mouse and Keyboard adapter" */
    'U','C','-','1','0','0','K','M',' ','P','S','/','2',' ','\x0b',' ','\xe4','\x05',' ','\xd0',
/* 0x1ddb4 = "SMK Manufacturing, Inc." */
    'S','M','K',' ','M','a','n','u','f','a','c','t','u','r','i','n','g',',',' ','\x07',
/* 0x1ddc8 = "myPad110 PC/SC Smart Card Reader" */
    'm','y','P','a','d','1','1','0',' ','P','C','/','S','C',' ','\x12',' ','\x15',' ','\x08',
/* 0x1dddc = "W9967CF/W9968CF Webcam IC" */
    'W','9','9','6','7','C','F','/','W','9','9','6','8','C','F',' ','\x11',' ','I','C',
/* 0X1ddf0 = "Cruzer Micro Mini 256MB Flash Drive" */
    'r','u','z','e','r',' ','\xc4',' ','\xb9',' ','2','5','6','M','B',' ','\x3c',' ','\x14',
/* 0x1de03 = "13.56Mhz RFID Card Reader and Writer" */
    '1','3','.','5','6','M','h','z',' ','R','F','I','D',' ','\x15',' ','\x08',' ','\xe4','\xdf',
/* 0x1de17 = "MX900 Bluetooth Wireless Hub (C-UJ16A)" */
    'M','X','9','0','0',' ','\x06',' ','\x01','\xa4',' ','(','C','-','U','J','1','6','A',')',
/* 0x1de2b = "Cisco 7920 WiFi IP Phone" */
    'C','i','s','c','o',' ','7','9','2','0',' ','W','i','F','i',' ','I','P',' ','\x19',
/* 0x1de3f = "Smart Cam Deluxe(composite)" */
    '\x12',' ','\x9a','D','e','l','u','x','e','(','c','o','m','p','o','s','i','t','e',')',
/* 0x1de53 = "PowerShot ELPH 140 IS / IXUS 150" */
    '\x24','\x84','E','L','P','H',' ','1','4','0',' ','I','S',' ','/',' ','\xfd','1','5','0',
/* 0x1de67 = "Portable Hard Drive (Store\'n\'Go)" */
    '\xa9','H','a','r','d',' ','\x14',' ','(','S','t','o','r','e','\'','n','\'','G','o',')',
/* 0x1de7b = "VGP-UVC100 Visual Communication Camera" */
    'V','G','P','-','U','V','C','1','0','0',' ','V','i','s','u','a','l',' ','\xe9','\x04',
/* 0x1de8f = "PL2501 USB-USB Bridge (USB 2.0)" */
    'P','L','2','5','0','1',' ','\x0a','-','\x0a',' ','\x9f',' ','(','\x0a',' ','2','.','0',')',
/* 0x1dea3 = "F5U120-PC Parallel Printer Port" */
    'F','5','U','1','2','0','-','\x1f','P','a','r','a','l','l','e','l',' ','\x0c',' ','\x87',
/* 0x1deb7 = "M-Bus Master MultiPort 250D" */
    'M','-','B','u','s',' ','M','a','s','t','e','r',' ','\xd6','\x87',' ','2','5','0','D',
/* 0X1decb = "Dolby Laboratories Inc." */
    'o','l','b','y',' ','L','a','b','o','r','a','t','o','r','i','e','s',' ','\x07',
/* 0x1dede = "ORITE CCD Webcam [PC370R]" */
    'O','R','I','T','E',' ','C','C','D',' ','\x11',' ','[','P','C','3','7','0','R',']',
/* 0x1def2 = "Primex Aerospace Co." */
    'P','r','i','m','e','x',' ','A','e','r','o','s','p','a','c','e',' ','C','o','.',
/* 0x1df06 = "National Technical Systems" */
    'N','a','t','i','o','n','a','l',' ','T','e','c','h','n','i','c','a','l',' ','\xa6',
/* 0x1df1a = "Nomad Jukebox Zen NX" */
    'N','o','m','a','d',' ','J','u','k','e','b','o','x',' ','Z','e','n',' ','N','X',
/* 0x1df2e = "AudioVox 8900 Cell Phone" */
    'A','u','d','i','o','V','o','x',' ','8','9','0','0',' ','C','e','l','l',' ','\x19',
/* 0x1df42 = "Guardant Stealth/Net" */
    'G','u','a','r','d','a','n','t',' ','S','t','e','a','l','t','h','/','N','e','t',
/* 0x1df56 = "Spacelabs Medical, Inc." */
    'S','p','a','c','e','l','a','b','s',' ','M','e','d','i','c','a','l',',',' ','\x07',
/* 0x1df6a = "SurfBoard SB5100 Cable Modem" */
    'S','u','r','f','B','o','a','r','d',' ','S','B','5','1','0','0',' ','\xa5',' ','\x1c',
/* 0x1df7e = "V640i Phone [PictBridge]" */
    'V','6','4','0','i',' ','\x19',' ','[','P','i','c','t','B','r','i','d','g','e',']',
/* 0x1df92 = "Jenoptik JD350 video" */
    'J','e','n','o','p','t','i','k',' ','J','D','3','5','0',' ','v','i','d','e','o',
/* 0x1dfa6 = "iAudio X5, subpack USB port" */
    'i','\x8b','X','5',',',' ','s','u','b','p','a','c','k',' ','\x0a',' ','p','o','r','t',
/* 0x1dfba = "RadioShack Corp. (Tandy)" */
    'R','a','d','i','o','S','h','a','c','k',' ','\x10',' ','(','T','a','n','d','y',')',
/* 0x1dfce = "Dataplus Supplies, Inc." */
    'D','a','t','a','p','l','u','s',' ','S','u','p','p','l','i','e','s',',',' ','\x07',
/* 0x1dfe2 = "Huizhou Shenghua Industrial Co., Ltd." */
    'H','u','i','z','h','o','u',' ','S','h','e','n','g','h','u','a',' ','\xef','\x0e','\xab',
/* 0x1dff6 = "GW Instek GDS-2000 Oscilloscope" */
    'G','W',' ','I','n','s','t','e','k',' ','G','D','S','-','2','0','0','0',' ','\xfe',
/* 0x1e00a = "TEMPer Temperature Sensor" */
    'T','E','M','P','e','r',' ','T','e','m','p','e','r','a','t','u','r','e',' ','\xac',
/* 0x1e01e = "GCT Semiconductor, Inc." */
    'G','C','T',' ','S','e','m','i','c','o','n','d','u','c','t','o','r',',',' ','\x07',
/* 0x1e032 = "V640i Phone [PTP Camera]" */
    'V','6','4','0','i',' ','\x19',' ','[','P','T','P',' ','C','a','m','e','r','a',']',
/* 0x1e046 = "National Registry, Inc." */
    'N','a','t','i','o','n','a','l',' ','R','e','g','i','s','t','r','y',',',' ','\x07',
/* 0x1e05a = "Handycam DCR-DVD306E" */
    'H','a','n','d','y','c','a','m',' ','D','C','R','-','D','V','D','3','0','6','E',
/* 0x1e06e = "POS Keyboard, TA60-USB" */
    'P','O','S',' ','K','e','y','b','o','a','r','d',',',' ','T','A','6','0','-','\x0a',
/* 0x1e082 = "G2CCD USB 1.1 obsolete" */
    'G','2','C','C','D',' ','\x0a',' ','1','.','1',' ','o','b','s','o','l','e','t','e',
/* 0x1e096 = "Digital Voice Recorder R200" */
    '\x09','V','o','i','c','e',' ','R','e','c','o','r','d','e','r',' ','R','2','0','0',
/* 0x1e0aa = "LP1965 19" Monitor Hub" */
    'L','P','1','9','6','5',' ','1','9','"',' ','M','o','n','i','t','o','r',' ','\xa4',
/* 0x1e0be = "business inkjet 3000" */
    'b','u','s','i','n','e','s','s',' ','i','n','k','j','e','t',' ','3','0','0','0',
/* 0x1e0d2 = "Alphatrack Control Surface" */
    'A','l','p','h','a','t','r','a','c','k',' ','\xc9',' ','S','u','r','f','a','c','e',
/* 0x1e0e6 = "Singing Electrons, Inc." */
    'S','i','n','g','i','n','g',' ','E','l','e','c','t','r','o','n','s',',',' ','\x07',
/* 0x1e0fa = "Quabbin Wire & Cable Co., Inc." */
    'Q','u','a','b','b','i','n',' ','W','i','r','e',' ','&',' ','\xa5',' ','\x0e','\x07',
/* 0x1e10d = "ELCON Systemtechnik" */
    'E','L','C','O','N',' ','S','y','s','t','e','m','t','e','c','h','n','i','k',
/* 0x1e120 = "Libra-Q11 IR remote" */
    'L','i','b','r','a','-','Q','1','1',' ','I','R',' ','r','e','m','o','t','e',
/* 0x1e133 = "Tasking Software, Inc." */
    'T','a','s','k','i','n','g',' ','S','o','f','t','w','a','r','e',',',' ','\x07',
/* 0x1e146 = "Sansa Fuze V2 (msc)" */
    'S','a','n','s','a',' ','F','u','z','e',' ','V','2',' ','(','m','s','c',')',
/* 0x1e159 = "Voyager 205 ADSL Router" */
    'V','o','y','a','g','e','r',' ','2','0','5',' ','\xf1','R','o','u','t','e','r',
/* 0x1e16c = "CryptoIdentity CCID" */
    'C','r','y','p','t','o','I','d','e','n','t','i','t','y',' ','C','C','I','D',
/* 0x1e17f = "Arcadyan 802.11N Wireless Adapter" */
    'A','r','c','a','d','y','a','n',' ','8','0','2','.','1','1','N',' ','\x01','\x02',
/* 0x1e192 = "DCCX38/P data cable" */
    'D','C','C','X','3','8','/','P',' ','d','a','t','a',' ','c','a','b','l','e',
/* 0x1e1a5 = "ColorPage-Vivid 1200 XE" */
    '\xa2','P','a','g','e','-','V','i','v','i','d',' ','1','2','0','0',' ','X','E',
/* 0x1e1b8 = "Dell Digital Jukebox 2.Gen" */
    'D','e','l','l',' ','\x09','J','u','k','e','b','o','x',' ','2','.','G','e','n',
/* 0x1e1cb = "X83 Scan/Print/Copy" */
    'X','8','3',' ','S','c','a','n','/','P','r','i','n','t','/','C','o','p','y',
/* 0x1e1de = "SeaPORT+4/485 (Port 1)" */
    'S','e','a','P','O','R','T','+','4','/','4','8','5',' ','(','\x87',' ','1',')',
/* 0x1e1f1 = "Mouse (Boot Interface Subclass)" */
    '\x0b',' ','(','B','o','o','t',' ','\x81',' ','S','u','b','c','l','a','s','s',')',
/* 0x1e204 = "SeaLINK+8/485 (Port 1)" */
    'S','e','a','L','I','N','K','+','8','/','4','8','5',' ','(','\x87',' ','1',')',
/* 0x1e217 = "Interval Research Corp." */
    'I','n','t','e','r','v','a','l',' ','R','e','s','e','a','r','c','h',' ','\x10',
/* 0x1e22a = "CTF-220 [BizTablet]" */
    'C','T','F','-','2','2','0',' ','[','B','i','z','T','a','b','l','e','t',']',
/* 0x1e23d = "Newport Corporation" */
    'N','e','w','p','o','r','t',' ','C','o','r','p','o','r','a','t','i','o','n',
/* 0x1e250 = "DataTraveler II+ Pen Drive" */
    '\xe7','T','r','a','v','e','l','e','r',' ','I','I','+',' ','P','e','n',' ','\x14',
/* 0x1e263 = "Microphone (Pro 4000)" */
    'M','i','c','r','o','p','h','o','n','e',' ','(','\x8f',' ','4','0','0','0',')',
/* 0x1e276 = "ML-3050/ML-3051 Laser Printer" */
    'M','L','-','3','0','5','0','/','M','L','-','3','0','5','1',' ','\x82',' ','\x0c',
/* 0x1e289 = "Taicang T&W Electronics Co. Ltd" */
    'T','a','i','c','a','n','g',' ','T','&','W',' ','\x1b',' ','C','o','.',' ','\x16',
/* 0x1e29c = "SDHC Reader [RW047-7000]" */
    'S','D','H','C',' ','\x08',' ','[','R','W','0','4','7','-','7','0','0','0',']',
/* 0x1e2af = "ZyXEL ZyAIR B200 802.11b Adapter" */
    'Z','y','X','E','L',' ','Z','y','A','I','R',' ','B','2','0','0',' ','\x9b','\x02',
/* 0x1e2c2 = "Linux-USB Midi Gadget" */
    'L','i','n','u','x','-','\x0a',' ','M','i','d','i',' ','G','a','d','g','e','t',
/* 0x1e2d5 = "Linear Spectrograph" */
    'L','i','n','e','a','r',' ','S','p','e','c','t','r','o','g','r','a','p','h',
/* 0x1e2e8 = "Sitecom Europe B.V." */
    'S','i','t','e','c','o','m',' ','E','u','r','o','p','e',' ','B','.','V','.',
/* 0x1e2fb = "Cassidian NH90 STTE" */
    'C','a','s','s','i','d','i','a','n',' ','N','H','9','0',' ','S','T','T','E',
/* 0x1e30e = "PicoScope 4000 series PC Oscilloscope" */
    'P','i','c','o','S','c','o','p','e',' ','4','0','0','0',' ','\x1d',' ','\x1f','\xfe',
/* 0x1e321 = "Logitech M-UAL-96 Mouse" */
    'L','o','g','i','t','e','c','h',' ','M','-','U','A','L','-','9','6',' ','\x0b',
/* 0x1e334 = "HID-compliant mouse" */
    'H','I','D','-','c','o','m','p','l','i','a','n','t',' ','m','o','u','s','e',
/* 0x1e347 = "Digital DataTraveler SE9 64GB" */
    '\x09','\xe7','T','r','a','v','e','l','e','r',' ','S','E','9',' ','6','4','G','B',
/* 0x1e35a = "Enhanced Microphone" */
    'E','n','h','a','n','c','e','d',' ','M','i','c','r','o','p','h','o','n','e',
/* 0x1e36d = "DVB-T UB383-T [af9015]" */
    '\xa7','T',' ','U','B','3','8','3','-','T',' ','[','a','f','9','0','1','5',']',
/* 0x1e380 = "Xlive Bluetooth XBM-100S MP3 Player" */
    'X','l','i','v','e',' ','\x06',' ','X','B','M','-','1','0','0','S',' ','\x8e','\x1e',
/* 0x1e393 = "Future Technology Devices International, Ltd" */
    'F','u','t','u','r','e',' ','\x0d',' ','D','e','v','i','c','e','s',' ','\xed','\x16',
/* 0x1e3a6 = "SeaLINK+8/485 (Port 8)" */
    'S','e','a','L','I','N','K','+','8','/','4','8','5',' ','(','\x87',' ','8',')',
/* 0x1e3b9 = "SeaLINK+8/485 (Port 6)" */
    'S','e','a','L','I','N','K','+','8','/','4','8','5',' ','(','\x87',' ','6',')',
/* 0x1e3cc = "Mic (Notebooks Pro)" */
    'M','i','c',' ','(','N','o','t','e','b','o','o','k','s',' ','P','r','o',')',
/* 0x1e3df = "KV-300H Isolation Keyboard" */
    'K','V','-','3','0','0','H',' ','I','s','o','l','a','t','i','o','n',' ','\x05',
/* 0x1e3f2 = "QuickCam for DELL Notebooks" */
    '\xc7','a','m',' ','\xcc','D','E','L','L',' ','N','o','t','e','b','o','o','k','s',
/* 0x1e405 = "Askey VC010 Webcam [pwc]" */
    'A','s','k','e','y',' ','V','C','0','1','0',' ','\x11',' ','[','p','w','c',']',
/* 0x1e418 = "Expert Mouse Pro Wireless" */
    'E','x','p','e','r','t',' ','\x0b',' ','\x8f',' ','W','i','r','e','l','e','s','s',
/* 0x1e42b = "Siam United Hi-Tech" */
    'S','i','a','m',' ','U','n','i','t','e','d',' ','H','i','-','T','e','c','h',
/* 0x1e43e = "STMP3410 D-Major MP3 Player" */
    'S','T','M','P','3','4','1','0',' ','D','-','M','a','j','o','r',' ','\x8e','\x1e',
/* 0x1e451 = "Wireless Transceiver (ACPI-compliant)" */
    '\x01','\xc8',' ','(','A','C','P','I','-','c','o','m','p','l','i','a','n','t',')',
/* 0x1e464 = "Trigem Mobile SmartDisplay84" */
    'T','r','i','g','e','m',' ','\x96',' ','\x12','D','i','s','p','l','a','y','8','4',
/* 0x1e477 = "SeaLINK+8/232 (Port 4)" */
    'S','e','a','L','I','N','K','+','8','/','2','3','2',' ','(','\x87',' ','4',')',
/* 0x1e48a = "MN128mini-J ISDN TA" */
    'M','N','1','2','8','m','i','n','i','-','J',' ','I','S','D','N',' ','T','A',
/* 0x1e49d = "smiths spirobank II" */
    's','m','i','t','h','s',' ','s','p','i','r','o','b','a','n','k',' ','I','I',
/* 0x1e4b0 = "Creatix Polymedia GmbH" */
    'C','r','e','a','t','i','x',' ','P','o','l','y','m','e','d','i','a',' ','\xfc',
/* 0x1e4c3 = "USB-Temp2 Thermometer" */
    '\x0a','-','T','e','m','p','2',' ','T','h','e','r','m','o','m','e','t','e','r',
/* 0x1e4d6 = "United Computer Accessories" */
    'U','n','i','t','e','d',' ','\xcd','A','c','c','e','s','s','o','r','i','e','s',
/* 0x1e4e9 = "LabConnect Signalgenerator" */
    'L','a','b','\xee','S','i','g','n','a','l','g','e','n','e','r','a','t','o','r',
/* 0x1e4fc = "Weltrend Bar Code Reader" */
    'W','e','l','t','r','e','n','d',' ','B','a','r',' ','C','o','d','e',' ','\x08',
/* 0x1e50f = "D70 (mass storage mode)" */
    'D','7','0',' ','(','m','a','s','s',' ','s','t','o','r','a','g','e',' ','\x1a',
/* 0x1e522 = "nanoKONTROL2 MIDI Controller" */
    'n','a','n','o','K','O','N','T','R','O','L','2',' ','M','I','D','I',' ','\x13',
/* 0x1e535 = "Japan Distributor Corp." */
    'J','a','p','a','n',' ','D','i','s','t','r','i','b','u','t','o','r',' ','\x10',
/* 0x1e548 = "USB2-IDE IDE bridge" */
    'U','S','B','2','-','I','D','E',' ','I','D','E',' ','b','r','i','d','g','e',
/* 0x1e55b = "Acer MP-120 MP3 player" */
    'A','c','e','r',' ','M','P','-','1','2','0',' ','\x8e','p','l','a','y','e','r',
/* 0x1e56e = "HCF V.90 Data/Fax Modem" */
    'H','C','F',' ','V','.','9','0',' ','D','a','t','a','/','F','a','x',' ','\x1c',
/* 0x1e581 = "Electronics VCS Camera II(LPC-U20)" */
    '\x1b',' ','V','C','S',' ','\x04',' ','I','I','(','L','P','C','-','U','2','0',')',
/* 0x1e594 = "Dream Cheeky button" */
    'D','r','e','a','m',' ','C','h','e','e','k','y',' ','b','u','t','t','o','n',
/* 0x1e5a7 = "USB-N53 802.11abgn Network Adapter [Ralink RT3572]" */
    '\x0a','-','N','5','3',' ','\xea','\x8d','\x02',' ','[','\x93','R','T','3','5','7','2',']',
/* 0x1e5ba = "Ecomo 19H99 Monitor" */
    'E','c','o','m','o',' ','1','9','H','9','9',' ','M','o','n','i','t','o','r',
/* 0x1e5cd = "NW-MS7 Walkman MemoryStick Reader" */
    'N','W','-','M','S','7',' ','W','a','l','k','m','a','n',' ','\xd2','\xb3',' ','\x08',
/* 0x1e5e0 = "SDDR-05 Compact Flash Reader" */
    'S','D','D','R','-','0','5',' ','C','o','m','p','a','c','t',' ','\x3c',' ','\x08',
/* 0x1e5f3 = "Cinergy HT PVR (EU)" */
    'C','i','n','e','r','g','y',' ','H','T',' ','P','V','R',' ','(','E','U',')',
/* 0x1e606 = "MVX100i / Optura 10" */
    'M','V','X','1','0','0','i',' ','/',' ','O','p','t','u','r','a',' ','1','0',
/* 0x1e619 = "Magicolor 5450/5550" */
    'M','a','g','i','c','o','l','o','r',' ','5','4','5','0','/','5','5','5','0',
/* 0x1e62c = "BTM200B BlueTooth Adapter" */
    'B','T','M','2','0','0','B',' ','B','l','u','e','T','o','o','t','h',' ','\x02',
/* 0x1e63f = "Atten Electronics / Siglent Technologies" */
    'A','t','t','e','n',' ','\x1b',' ','/',' ','S','i','g','l','e','n','t',' ','\x88',
/* 0x1e652 = "DepthSense 311 (3D)" */
    'D','e','p','t','h','S','e','n','s','e',' ','3','1','1',' ','(','3','D',')',
/* 0x1e665 = "Hauppauge WinTV Pro (PAL D/K FM)" */
    '\xfb','W','i','n','\xda','\x8f',' ','(','P','A','L',' ','D','/','K',' ','F','M',')',
/* 0x1e678 = "Systems MovieBox Deluxe Device" */
    '\xa6',' ','M','o','v','i','e','B','o','x',' ','D','e','l','u','x','e',' ','\x03',
/* 0x1e68b = "ISDN-Controller FRITZ!Card v2.0" */
    'I','S','D','N','-','\x13',' ','F','R','I','T','Z','!','\x15',' ','v','2','.','0',
/* 0x1e69e = "C7-00 (Media transfer mode)" */
    'C','7','-','0','0',' ','(','\xa1',' ','t','r','a','n','s','f','e','r',' ','\x1a',
/* 0x1e6b1 = "ISDN-Controller FRITZ!Card v2.1" */
    'I','S','D','N','-','\x13',' ','F','R','I','T','Z','!','\x15',' ','v','2','.','1',
/* 0x1e6c4 = "C5 Digital Media Camera (PC control mode)" */
    'C','5',' ','\x09','\xa1',' ','\x04',' ','(','\x1f','c','o','n','t','r','o','l',' ','\x1a',
/* 0x1e6d7 = "Mini Magnetic Stripe Reader" */
    '\xb9',' ','M','a','g','n','e','t','i','c',' ','S','t','r','i','p','e',' ','\x08',
/* 0x1e6ea = "Digistump DigiSpark" */
    'D','i','g','i','s','t','u','m','p',' ','D','i','g','i','S','p','a','r','k',
/* 0x1e6fd = "Sansa Fuze V2 (mtp)" */
    'S','a','n','s','a',' ','F','u','z','e',' ','V','2',' ','(','m','t','p',')',
/* 0x1e710 = "SeaPORT+2/485 (Port 1)" */
    'S','e','a','P','O','R','T','+','2','/','4','8','5',' ','(','\x87',' ','1',')',
/* 0x1e723 = "ES-7000H [GT-15000]" */
    'E','S','-','7','0','0','0','H',' ','[','G','T','-','1','5','0','0','0',']',
/* 0x1e736 = "Camera with CMOS sensor [MQ]" */
    '\x04',' ','\x98','C','M','O','S',' ','s','e','n','s','o','r',' ','[','M','Q',']',
/* 0x1e749 = "Lodestar autoguider" */
    'L','o','d','e','s','t','a','r',' ','a','u','t','o','g','u','i','d','e','r',
/* 0x1e75c = "TrekStor i.Beat fun" */
    'T','r','e','k','S','t','o','r',' ','i','.','B','e','a','t',' ','f','u','n',
/* 0x1e76f = "WinFast PalmTop/Novo TV Video" */
    'W','i','n','\xec','P','a','l','m','T','o','p','/','N','o','v','o',' ','\xda','\xa3',
/* 0x1e782 = "WL-345 Wireless USB adapter 300N X3" */
    'W','L','-','3','4','5',' ','\x01','\x0a',' ','\xd0',' ','3','0','0','N',' ','X','3',
/* 0x1e795 = "OnlyDisk U222 Pendrive" */
    'O','n','l','y','\xe8',' ','U','2','2','2',' ','P','e','n','d','r','i','v','e',
/* 0x1e7a8 = "SeaLINK+8/232 (Port 1)" */
    'S','e','a','L','I','N','K','+','8','/','2','3','2',' ','(','\x87',' ','1',')',
/* 0x1e7bb = "SeaPORT+4/485 (Port 3)" */
    'S','e','a','P','O','R','T','+','4','/','4','8','5',' ','(','\x87',' ','3',')',
/* 0x1e7ce = "CS-15 (Internet Stick 3G modem)" */
    'C','S','-','1','5',' ','(','\xb6','\xb3',' ','3','G',' ','m','o','d','e','m',')',
/* 0x1e7e1 = "Xbox360 Memory Unit 64MB" */
    'X','b','o','x','3','6','0',' ','\xd2',' ','U','n','i','t',' ','6','4','M','B',
/* 0x1e7f4 = "Aladdin Knowledge Systems" */
    'A','l','a','d','d','i','n',' ','K','n','o','w','l','e','d','g','e',' ','\xa6',
/* 0x1e807 = "DVD+RW External Drive DRU-800UL" */
    'D','V','D','+','R','W',' ','\xe3','\x14',' ','D','R','U','-','8','0','0','U','L',
/* 0x1e81a = "integrated USB webcam" */
    'i','n','t','e','g','r','a','t','e','d',' ','\x0a',' ','w','e','b','c','a','m',
/* 0x1e82d = "ACR1222 1SAM PICC Reader" */
    'A','C','R','1','2','2','2',' ','1','S','A','M',' ','P','I','C','C',' ','\x08',
/* 0x1e840 = "Python2 WDM Encoder" */
    'P','y','t','h','o','n','2',' ','W','D','M',' ','E','n','c','o','d','e','r',
/* 0x1e853 = "SCM Microsystems, Inc." */
    'S','C','M',' ','M','i','c','r','o','s','y','s','t','e','m','s',',',' ','\x07',
/* 0x1e866 = "SeaLINK+8/232 (Port 8)" */
    'S','e','a','L','I','N','K','+','8','/','2','3','2',' ','(','\x87',' ','8',')',
/* 0x1e879 = "GoGear SA60xx (mtp)" */
    'G','o','G','e','a','r',' ','S','A','6','0','x','x',' ','(','m','t','p',')',
/* 0x1e88c = "Spectrum Digital, Inc." */
    'S','p','e','c','t','r','u','m',' ','D','i','g','i','t','a','l',',',' ','\x07',
/* 0x1e89f = "WLI-U2-KG54-AI WLAN" */
    'W','L','I','-','U','2','-','K','G','5','4','-','A','I',' ','W','L','A','N',
/* 0x1e8b2 = "SeaLINK+8/485 (Port 3)" */
    'S','e','a','L','I','N','K','+','8','/','4','8','5',' ','(','\x87',' ','3',')',
/* 0x1e8c5 = "SeaPORT+4/232 (Port 2)" */
    'S','e','a','P','O','R','T','+','4','/','2','3','2',' ','(','\x87',' ','2',')',
/* 0x1e8d8 = "Marble Mouse (4-button)" */
    'M','a','r','b','l','e',' ','\x0b',' ','(','4','-','b','u','t','t','o','n',')',
/* 0x1e8eb = "ROHM LSI Systems USA, LLC" */
    'R','O','H','M',' ','L','S','I',' ','\xa6',' ','U','S','A',',',' ','L','L','C',
/* 0x1e8fe = "BioMV with TruePrint AES3400" */
    'B','i','o','M','V',' ','\x98','T','r','u','e','\xbd','A','E','S','3','4','0','0',
/* 0x1e911 = "WLI-U2-KG54-YB WLAN" */
    'W','L','I','-','U','2','-','K','G','5','4','-','Y','B',' ','W','L','A','N',
/* 0x1e924 = "Air2310 150 Mbps Wireless Adapter" */
    'A','i','r','2','3','1','0',' ','1','5','0',' ','M','b','p','s',' ','\x01','\x02',
/* 0x1e937 = "Technotrend/Hauppauge USB-Nova" */
    'T','e','c','h','n','o','t','r','e','n','d','/','\xfb','\x0a','-','N','o','v','a',
/* 0x1e94a = "IDBG in normal mode" */
    'I','D','B','G',' ','i','n',' ','n','o','r','m','a','l',' ','m','o','d','e',
/* 0x1e95d = "YST-MS55D USB Speaker" */
    'Y','S','T','-','M','S','5','5','D',' ','\x0a',' ','S','p','e','a','k','e','r',
/* 0x1e970 = "STOR.E BASICS 500GB" */
    'S','T','O','R','.','E',' ','B','A','S','I','C','S',' ','5','0','0','G','B',
/* 0x1e983 = "Orbotron 9000 (HID)" */
    'O','r','b','o','t','r','o','n',' ','9','0','0','0',' ','(','H','I','D',')',
/* 0x1e996 = "Handheld Digital Microscope 44302" */
    '\xc5',' ','\x09','M','i','c','r','o','s','c','o','p','e',' ','4','4','3','0','2',
/* 0x1e9a9 = "Gamecube DOL Viewer" */
    'G','a','m','e','c','u','b','e',' ','D','O','L',' ','V','i','e','w','e','r',
/* 0x1e9bc = "Santa Electronic, Inc." */
    'S','a','n','t','a',' ','E','l','e','c','t','r','o','n','i','c',',',' ','\x07',
/* 0x1e9cf = "PCTV Deluxe (PAL) Device" */
    'P','C','T','V',' ','D','e','l','u','x','e',' ','(','P','A','L',')',' ','\x03',
/* 0x1e9e2 = "Storage device (SD card reader)" */
    '\x0f','\xf9',' ','(','S','D',' ','c','a','r','d',' ','r','e','a','d','e','r',')',
/* 0x1e9f5 = "IEEE 802.11g USB2.0 Wireless Network Adapter-PN" */
    'I','E','E','E',' ','\x94','U','S','B','2','.','0',' ','\x01','\x8d','\x02','-','P','N',
/* 0x1ea08 = "Greentit [Ambit2 R]" */
    'G','r','e','e','n','t','i','t',' ','[','A','m','b','i','t','2',' ','R',']',
/* 0x1ea1b = "raphnet.net MultiDB9joy" */
    'r','a','p','h','n','e','t','.','n','e','t',' ','\xd6','D','B','9','j','o','y',
/* 0x1ea2e = "AU5 ADSL Modem (pre-reenum)" */
    'A','U','5',' ','\xf1','\x1c',' ','(','p','r','e','-','r','e','e','n','u','m',')',
/* 0x1ea41 = "CanoScan 9000F Mark II" */
    'C','a','n','o','\x8a',' ','9','0','0','0','F',' ','M','a','r','k',' ','I','I',
/* 0x1ea54 = "PicoScope 2000 series PC Oscilloscope" */
    'P','i','c','o','S','c','o','p','e',' ','2','0','0','0',' ','\x1d',' ','\x1f','\xfe',
/* 0x1ea67 = "Bluetooth UltraPort Module from IBM" */
    '\x06',' ','U','l','t','r','a','\x87',' ','\xe5',' ','f','r','o','m',' ','I','B','M',
/* 0x1ea7a = "2U4S serial/usb hub" */
    '2','U','4','S',' ','s','e','r','i','a','l','/','u','s','b',' ','h','u','b',
/* 0x1ea8d = "PicoScope 3000 series PC Oscilloscope" */
    'P','i','c','o','S','c','o','p','e',' ','3','0','0','0',' ','\x1d',' ','\x1f','\xfe',
/* 0x1eaa0 = "Barcode PCP-BCG4209" */
    'B','a','r','c','o','d','e',' ','P','C','P','-','B','C','G','4','2','0','9',
/* 0x1eab3 = "Genius Look 1320 V2" */
    'G','e','n','i','u','s',' ','L','o','o','k',' ','1','3','2','0',' ','V','2',
/* 0x1eac6 = "Dual Mode Still Camera Device" */
    'D','u','a','l',' ','M','o','d','e',' ','S','t','i','l','l',' ','\x04',' ','\x03',
/* 0x1ead9 = "Mega 2560 (CDC ACM)" */
    'M','e','g','a',' ','2','5','6','0',' ','(','C','D','C',' ','A','C','M',')',
/* 0x1eaec = "instadose dosimeter" */
    'i','n','s','t','a','d','o','s','e',' ','d','o','s','i','m','e','t','e','r',
/* 0x1eaff = "Gallant Computer, Inc." */
    'G','a','l','l','a','n','t',' ','C','o','m','p','u','t','e','r',',',' ','\x07',
/* 0x1eb12 = "OpticPro UT12/16/24 Scanner" */
    'O','p','t','i','c','\x8f',' ','U','T','1','2','/','1','6','/','2','4',' ','\x25',
/* 0x1eb25 = "USB-N11 802.11n Network Adapter [Ralink RT2870]" */
    '\x0a','-','N','1','1',' ','\x99','\x8d','\x02',' ','[','\x93','R','T','2','8','7','0',']',
/* 0x1eb38 = "Fujitsu Personal Systems, Inc." */
    'F','u','j','i','t','s','u',' ','P','e','r','s','o','n','a','l',' ','\xb8','\x07',
/* 0x1eb4b = "Bluetooth 4.0 [Broadcom BCM20702A0]" */
    '\x06',' ','4','.','0',' ','[','\xeb','B','C','M','2','0','7','0','2','A','0',']',
/* 0x1eb5e = "USB,12-Button Wheel" */
    'U','S','B',',','1','2','-','B','u','t','t','o','n',' ','W','h','e','e','l',
/* 0x1eb71 = "SeaLINK+8/232 (Port 6)" */
    'S','e','a','L','I','N','K','+','8','/','2','3','2',' ','(','\x87',' ','6',')',
/* 0x1eb84 = "Savi Office Base Station" */
    'S','a','v','i',' ','\xd3',' ','B','a','s','e',' ','S','t','a','t','i','o','n',
/* 0x1eb97 = "USB10TX Ethernet [pegasus]" */
    'U','S','B','1','0','T','X',' ','\x7f',' ','[','p','e','g','a','s','u','s',']',
/* 0x1ebaa = "Veo Stingray/Connect Web Camera" */
    'V','e','o',' ','S','t','i','n','g','r','a','y','/','\xee','W','e','b',' ','\x04',
/* 0x1ebbd = "MICOMSOFT CO., LTD." */
    'M','I','C','O','M','S','O','F','T',' ','C','O','.',',',' ','L','T','D','.',
/* 0x1ebd0 = "SMC8013WG Broadband Remote NDIS Device" */
    'S','M','C','8','0','1','3','W','G',' ','\xb7','\xcb',' ','N','D','I','S',' ','\x03',
/* 0x1ebe3 = "Packet-Master USB12" */
    'P','a','c','k','e','t','-','M','a','s','t','e','r',' ','U','S','B','1','2',
/* 0x1ebf6 = "LIH TZU Electric Co., Ltd" */
    'L','I','H',' ','T','Z','U',' ','E','l','e','c','t','r','i','c',' ','\x0e','\x16',
/* 0x1ec09 = "Xperia X12 (debug mode)" */
    'X','p','e','r','i','a',' ','X','1','2',' ','(','d','e','b','u','g',' ','\x1a',
/* 0x1ec1c = "LabConnect Digitalnetzteil" */
    'L','a','b','\xee','D','i','g','i','t','a','l','n','e','t','z','t','e','i','l',
/* 0x1ec2f = "HID Keyboard/Mouse PS/2 Translator" */
    '\xf2','\xc6','\x0b',' ','P','S','/','2',' ','T','r','a','n','s','l','a','t','o','r',
/* 0x1ec42 = "Peracom Networks, Inc." */
    'P','e','r','a','c','o','m',' ','N','e','t','w','o','r','k','s',',',' ','\x07',
/* 0x1ec55 = "Genius Traveler 350" */
    'G','e','n','i','u','s',' ','T','r','a','v','e','l','e','r',' ','3','5','0',
/* 0x1ec68 = "Bar Code Scanner (CS1504)" */
    'B','a','r',' ','C','o','d','e',' ','\x25',' ','(','C','S','1','5','0','4',')',
/* 0x1ec7b = "Unicore Software, Inc." */
    'U','n','i','c','o','r','e',' ','S','o','f','t','w','a','r','e',',',' ','\x07',
/* 0x1ec8e = "Teensy RawHID+Debug" */
    'T','e','e','n','s','y',' ','R','a','w','H','I','D','+','D','e','b','u','g',
/* 0x1eca1 = "NDS Emulator (Lite)" */
    'N','D','S',' ','E','m','u','l','a','t','o','r',' ','(','L','i','t','e',')',
/* 0x1ecb4 = "Dream Cheeky Fidget" */
    'D','r','e','a','m',' ','C','h','e','e','k','y',' ','F','i','d','g','e','t',
/* 0x1ecc7 = "WLA-5000 802.11abgn [Ralink RT3572]" */
    'W','L','A','-','5','0','0','0',' ','\xea','[','\x93','R','T','3','5','7','2',']',
/* 0x1ecda = "Toshiba America Inc" */
    'T','o','s','h','i','b','a',' ','A','m','e','r','i','c','a',' ','I','n','c',
/* 0x1eced = "DTI-56362-USB Digital Interface Unit" */
    'D','T','I','-','5','6','3','6','2','-','\x0a',' ','\x09','\x81',' ','U','n','i','t',
/* 0x1ed00 = "Xircom PGUNET USB-USB Bridge" */
    'X','i','r','c','o','m',' ','P','G','U','N','E','T',' ','\x0a','-','\x0a',' ','\x9f',
/* 0x1ed13 = "WL-117 Hi-Speed USB Adapter" */
    'W','L','-','1','1','7',' ','H','i','-','S','p','e','e','d',' ','\x0a',' ','\x02',
/* 0x1ed26 = "MCT Elektronikladen" */
    'M','C','T',' ','E','l','e','k','t','r','o','n','i','k','l','a','d','e','n',
/* 0x1ed39 = "Raritan Computer, Inc." */
    'R','a','r','i','t','a','n',' ','C','o','m','p','u','t','e','r',',',' ','\x07',
/* 0x1ed4c = "Jenoptik JD-4100z3s" */
    'J','e','n','o','p','t','i','k',' ','J','D','-','4','1','0','0','z','3','s',
/* 0x1ed5f = "Sansa Clip V2 (msc)" */
    'S','a','n','s','a',' ','C','l','i','p',' ','V','2',' ','(','m','s','c',')',
/* 0x1ed72 = "Hollister Mobile Monitor" */
    'H','o','l','l','i','s','t','e','r',' ','\x96',' ','M','o','n','i','t','o','r',
/* 0x1ed85 = "HS-COMBO Cardreader" */
    'H','S','-','C','O','M','B','O',' ','C','a','r','d','r','e','a','d','e','r',
/* 0x1ed98 = "cyberJack pinpad(a)" */
    'c','y','b','e','r','J','a','c','k',' ','p','i','n','p','a','d','(','a',')',
/* 0x1edab = "Keyboard [87 Francium Pro]" */
    '\x05',' ','[','8','7',' ','F','r','a','n','c','i','u','m',' ','P','r','o',']',
/* 0x1edbe = "BCM2070 Bluetooth 2.1 + EDR" */
    'B','C','M','2','0','7','0',' ','\x06',' ','2','.','1',' ','+',' ','E','D','R',
/* 0x1edd1 = "PC TWIN SHOCK Gamepad" */
    '\x1f','T','W','I','N',' ','S','H','O','C','K',' ','G','a','m','e','p','a','d',
/* 0x1ede4 = "Galaxy (debugging mode)" */
    'G','a','l','a','x','y',' ','(','d','e','b','u','g','g','i','n','g',' ','\x1a',
/* 0x1edf7 = "Jolla charging only" */
    'J','o','l','l','a',' ','c','h','a','r','g','i','n','g',' ','o','n','l','y',
/* 0x1ee0a = "SecureMate SD/MMC Reader" */
    'S','e','c','u','r','e','M','a','t','e',' ','S','D','/','M','M','C',' ','\x08',
/* 0x1ee1d = "BioMV with TruePrint AES3500" */
    'B','i','o','M','V',' ','\x98','T','r','u','e','\xbd','A','E','S','3','5','0','0',
/* 0x1ee30 = "GrabBeeX+ Video Encoder" */
    'G','r','a','b','B','e','e','X','+',' ','\xa3',' ','E','n','c','o','d','e','r',
/* 0x1ee43 = "Coolpix 3500 (Sierra Mode)" */
    '\xdc','3','5','0','0',' ','(','S','i','e','r','r','a',' ','M','o','d','e',')',
/* 0x1ee56 = "Alpermann+Velte TCD" */
    'A','l','p','e','r','m','a','n','n','+','V','e','l','t','e',' ','T','C','D',
/* 0x1ee69 = "Machine Test System" */
    'M','a','c','h','i','n','e',' ','T','e','s','t',' ','S','y','s','t','e','m',
/* 0x1ee7c = "Air2410 300 Mbps Wireless Adapter" */
    'A','i','r','2','4','1','0',' ','3','0','0',' ','M','b','p','s',' ','\x01','\x02',
/* 0x1ee8f = "U421 interface card" */
    'U','4','2','1',' ','i','n','t','e','r','f','a','c','e',' ','c','a','r','d',
/* 0x1eea2 = "SeaLINK+8/485 (Port 5)" */
    'S','e','a','L','I','N','K','+','8','/','4','8','5',' ','(','\x87',' ','5',')',
/* 0x1eeb5 = "DWL-AG132 [Atheros AR5523]" */
    'D','W','L','-','A','G','1','3','2',' ','[','\xaf','A','R','5','5','2','3',']',
/* 0x1eec8 = "Terminal Bike Key Reader" */
    'T','e','r','m','i','n','a','l',' ','B','i','k','e',' ','K','e','y',' ','\x08',
/* 0x1eedb = "Cherry MiniatureCard Keyboard" */
    'C','h','e','r','r','y',' ','M','i','n','i','a','t','u','r','e','\x15',' ','\x05',
/* 0x1eeee = "Argon chipset flash" */
    'A','r','g','o','n',' ','c','h','i','p','s','e','t',' ','f','l','a','s','h',
/* 0x1ef01 = "Cruzer Force (64GB)" */
    'C','r','u','z','e','r',' ','F','o','r','c','e',' ','(','6','4','G','B',')',
/* 0x1ef14 = "Pavilion Webcam [R5U870]" */
    'P','a','v','i','l','i','o','n',' ','\x11',' ','[','R','5','U','8','7','0',']',
/* 0x1ef27 = "Contech Research, Inc." */
    'C','o','n','t','e','c','h',' ','R','e','s','e','a','r','c','h',',',' ','\x07',
/* 0x1ef3a = "SeaPORT+4/232 (Port 4)" */
    'S','e','a','P','O','R','T','+','4','/','2','3','2',' ','(','\x87',' ','4',')',
/* 0x1ef4d = "Princeton Graphic Systems" */
    'P','r','i','n','c','e','t','o','n',' ','G','r','a','p','h','i','c',' ','\xa6',
/* 0x1ef60 = "Xionics Document Technologies, Inc." */
    'X','i','o','n','i','c','s',' ','D','o','c','u','m','e','n','t',' ','\x89','\x07',
/* 0x1ef73 = "WorkCentre 6015N/NI" */
    'W','o','r','k','C','e','n','t','r','e',' ','6','0','1','5','N','/','N','I',
/* 0x1ef86 = "ARC Inspectrum Mono" */
    'A','R','C',' ','I','n','s','p','e','c','t','r','u','m',' ','M','o','n','o',
/* 0x1ef99 = "Hagiwara Sys-Com Co., Ltd" */
    'H','a','g','i','w','a','r','a',' ','S','y','s','-','C','o','m',' ','\x0e','\x16',
/* 0x1efac = "SeaLINK+8/232 (Port 7)" */
    'S','e','a','L','I','N','K','+','8','/','2','3','2',' ','(','\x87',' ','7',')',
/* 0x1efbf = "Cinergy Hybrid T XS" */
    'C','i','n','e','r','g','y',' ','H','y','b','r','i','d',' ','T',' ','X','S',
/* 0X1efd2 = "SDCard/MMC Reader/Writer" */
    'D','C','a','r','d','/','M','M','C',' ','R','e','a','d','e','r','/','\xdf',
/* 0x1efe4 = "Tegra 3 (recovery mode)" */
    'T','e','g','r','a',' ','3',' ','(','r','e','c','o','v','e','r','y',' ','\x1a',
/* 0x1eff7 = "Dimage X50 Camera [p2p?]" */
    'D','i','m','a','g','e',' ','X','5','0',' ','\x04',' ','[','p','2','p','?',']',
/* 0x1f00a = "Quantum Corporation" */
    'Q','u','a','n','t','u','m',' ','C','o','r','p','o','r','a','t','i','o','n',
/* 0x1f01d = "Ubertooth One (DFU)" */
    'U','b','e','r','t','o','o','t','h',' ','O','n','e',' ','(','D','F','U',')',
/* 0x1f030 = "TechniSat DVB-PC TV Star 2" */
    'T','e','c','h','n','i','S','a','t',' ','\xa7','\x1f','\xda','S','t','a','r',' ','2',
/* 0x1f043 = "Woods Industries, Inc." */
    'W','o','o','d','s',' ','I','n','d','u','s','t','r','i','e','s',',',' ','\x07',
/* 0x1f056 = "SeaPORT+4/232 (Port 1)" */
    'S','e','a','P','O','R','T','+','4','/','2','3','2',' ','(','\x87',' ','1',')',
/* 0x1f069 = "MA100 [USB-UART Bridge IC]" */
    'M','A','1','0','0',' ','[','\x0a','-','U','A','R','T',' ','\x9f',' ','I','C',']',
/* 0x1f07c = "Altius Solutions, Inc." */
    'A','l','t','i','u','s',' ','S','o','l','u','t','i','o','n','s',',',' ','\x07',
/* 0x1f08f = "OCT To Fast Ethernet Converter" */
    'O','C','T',' ','T','o',' ','\xec','\x7f',' ','C','o','n','v','e','r','t','e','r',
/* 0x1f0a2 = "HP TrueVision HD Integrated Webcam" */
    'H','P',' ','T','r','u','e','V','i','s','i','o','n',' ','H','D',' ','\x18','\x11',
/* 0x1f0b5 = "Elitegroup Computer Systems (ECS)" */
    'E','l','i','t','e','g','r','o','u','p',' ','\xcd','\xa6',' ','(','E','C','S',')',
/* 0x1f0c8 = "Walex Electronic, Ltd" */
    'W','a','l','e','x',' ','E','l','e','c','t','r','o','n','i','c',',',' ','\x16',
/* 0x1f0db = "Litronic Fortezza Reader" */
    'L','i','t','r','o','n','i','c',' ','F','o','r','t','e','z','z','a',' ','\x08',
/* 0x1f0ee = "Mark of the Unicorn" */
    'M','a','r','k',' ','o','f',' ','t','h','e',' ','U','n','i','c','o','r','n',
/* 0x1f101 = "Classic Attache Flash Drive" */
    'C','l','a','s','s','i','c',' ','A','t','t','a','c','h','e',' ','\x3c',' ','\x14',
/* 0x1f114 = "TT-TVStick CT2-4400" */
    'T','T','-','T','V','S','t','i','c','k',' ','C','T','2','-','4','4','0','0',
/* 0x1f127 = "PicoScope 6000 series PC Oscilloscope" */
    'P','i','c','o','S','c','o','p','e',' ','6','0','0','0',' ','\x1d',' ','\x1f','\xfe',
/* 0x1f13a = "RCA Kazoo RD1000 MP3 Player" */
    'R','C','A',' ','K','a','z','o','o',' ','R','D','1','0','0','0',' ','\x8e','\x1e',
/* 0x1f14d = "Blaster GamePad Cobra" */
    'B','l','a','s','t','e','r',' ','G','a','m','e','\xfa',' ','C','o','b','r','a',
/* 0x1f160 = "N300 WLAN N Adapter [ISY]" */
    'N','3','0','0',' ','W','L','A','N',' ','N',' ','\x02',' ','[','I','S','Y',']',
/* 0x1f173 = "Xerox 2400 Onetouch" */
    'X','e','r','o','x',' ','2','4','0','0',' ','O','n','e','t','o','u','c','h',
/* 0x1f186 = "Instand VCD Capture" */
    'I','n','s','t','a','n','d',' ','V','C','D',' ','C','a','p','t','u','r','e',
/* 0x1f199 = "SeaLINK+8/485 (Port 2)" */
    'S','e','a','L','I','N','K','+','8','/','4','8','5',' ','(','\x87',' ','2',')',
/* 0x1f1ac = "WhiteHeat (fake ID)" */
    'W','h','i','t','e','H','e','a','t',' ','(','f','a','k','e',' ','I','D',')',
/* 0x1f1bf = "F5U109/F5U409 PDA Adapter" */
    'F','5','U','1','0','9','/','F','5','U','4','0','9',' ','P','D','A',' ','\x02',
/* 0x1f1d2 = "SeaPORT+4/485 (Port 2)" */
    'S','e','a','P','O','R','T','+','4','/','4','8','5',' ','(','\x87',' ','2',')',
/* 0x1f1e5 = "F3 V-Track Gaming Mouse" */
    'F','3',' ','V','-','T','r','a','c','k',' ','G','a','m','i','n','g',' ','\x0b',
/* 0x1f1f8 = "Wonderful Wire Cable Co., Ltd" */
    'W','o','n','d','e','r','f','u','l',' ','W','i','r','e',' ','\xa5',' ','\x0e','\x16',
/* 0x1f20b = "MCK-600W/MCK-800USB Keyboard" */
    'M','C','K','-','6','0','0','W','/','M','C','K','-','8','0','0','\x0a',' ','\x05',
/* 0x1f21e = "Validity Sensors, Inc." */
    'V','a','l','i','d','i','t','y',' ','S','e','n','s','o','r','s',',',' ','\x07',
/* 0x1f231 = "Mju 500 / Stylus Digital Camera (PTP)" */
    'M','j','u',' ','5','0','0',' ','/',' ','\xb1','\x09','\x04',' ','(','P','T','P',')',
/* 0x1f244 = "BCM43142A0 Bluetooth module" */
    'B','C','M','4','3','1','4','2','A','0',' ','\x06',' ','m','o','d','u','l','e',
/* 0x1f257 = "4pi 5 axis motion controller" */
    '4','p','i',' ','5',' ','a','x','i','s',' ','m','o','t','i','o','n',' ','\x9e',
/* 0x1f26a = "Modular Smartcard Keyboard" */
    'M','o','d','u','l','a','r',' ','S','m','a','r','t','c','a','r','d',' ','\x05',
/* 0x1f27d = "Memorex Products, Inc." */
    'M','e','m','o','r','e','x',' ','P','r','o','d','u','c','t','s',',',' ','\x07',
/* 0x1f290 = "SMC WSKP100 Wi-Fi Phone" */
    'S','M','C',' ','W','S','K','P','1','0','0',' ','W','i','-','F','i',' ','\x19',
/* 0x1f2a3 = "Hercules DJ Console" */
    'H','e','r','c','u','l','e','s',' ','D','J',' ','C','o','n','s','o','l','e',
/* 0x1f2b6 = "WAVE/MP3 RECORDER R-05" */
    'W','A','V','E','/','\x8e','R','E','C','O','R','D','E','R',' ','R','-','0','5',
/* 0x1f2c9 = "PilotBoard Wireless" */
    'P','i','l','o','t','B','o','a','r','d',' ','W','i','r','e','l','e','s','s',
/* 0x1f2dc = "K3770 3G Modem (Mass Storage Mode)" */
    'K','3','7','7','0',' ','3','G',' ','\x1c',' ','(','\x7c','\x0f','M','o','d','e',')',
/* 0x1f2ef = "D40 (mass storage mode)" */
    'D','4','0',' ','(','m','a','s','s',' ','s','t','o','r','a','g','e',' ','\x1a',
/* 0x1f302 = "Sun Microsystems, Inc." */
    'S','u','n',' ','M','i','c','r','o','s','y','s','t','e','m','s',',',' ','\x07',
/* 0x1f315 = "SoundCanvas SC-8820" */
    'S','o','u','n','d','C','a','n','v','a','s',' ','S','C','-','8','8','2','0',
/* 0x1f328 = "SeaPORT+2/232 (Port 2)" */
    'S','e','a','P','O','R','T','+','2','/','2','3','2',' ','(','\x87',' ','2',')',
/* 0x1f33b = "Golden Bridge Electech Inc." */
    'G','o','l','d','e','n',' ','\x9f',' ','E','l','e','c','t','e','c','h',' ','\x07',
/* 0x1f34e = "Sphairon Access Systems GmbH" */
    'S','p','h','a','i','r','o','n',' ','A','c','c','e','s','s',' ','\xa6',' ','\xfc',
/* 0x1f361 = "LC1 Linear Camera (VISA)" */
    'L','C','1',' ','L','i','n','e','a','r',' ','\x04',' ','(','V','I','S','A',')',
/* 0x1f374 = "Gotop Information Inc." */
    'G','o','t','o','p',' ','I','n','f','o','r','m','a','t','i','o','n',' ','\x07',
/* 0x1f387 = "QuickCam Orbit/Sphere AF" */
    '\xc7','a','m',' ','O','r','b','i','t','/','S','p','h','e','r','e',' ','A','F',
/* 0x1f39a = "deltaX 5 BT (D) PDA" */
    'd','e','l','t','a','X',' ','5',' ','B','T',' ','(','D',')',' ','P','D','A',
/* 0x1f3ad = "W1M100 HSPA/WCDMA Module" */
    'W','1','M','1','0','0',' ','H','S','P','A','/','W','C','D','M','A',' ','\xe5',
/* 0x1f3c0 = "FusionRemote IR receiver" */
    'F','u','s','i','o','n','\xcb',' ','I','R',' ','r','e','c','e','i','v','e','r',
/* 0x1f3d3 = "XV-2020 Synthesizer" */
    'X','V','-','2','0','2','0',' ','S','y','n','t','h','e','s','i','z','e','r',
/* 0x1f3e6 = "PicoScope 5000 series PC Oscilloscope" */
    'P','i','c','o','S','c','o','p','e',' ','5','0','0','0',' ','\x1d',' ','\x1f','\xfe',
/* 0x1f3f9 = "Japan Radio Company" */
    'J','a','p','a','n',' ','R','a','d','i','o',' ','C','o','m','p','a','n','y',
/* 0x1f40c = "DRAC 5 Virtual Keyboard and Mouse" */
    'D','R','A','C',' ','5',' ','V','i','r','t','u','a','l',' ','\x05',' ','\xe4','\x0b',
/* 0x1f41f = "Thunderbolt Display Audio" */
    'T','h','u','n','d','e','r','b','o','l','t',' ','\xcf',' ','A','u','d','i','o',
/* 0x1f432 = "Dazzle DPVM! (1005)" */
    'D','a','z','z','l','e',' ','D','P','V','M','!',' ','(','1','0','0','5',')',
/* 0x1f445 = "SeaLINK+8/232 (Port 3)" */
    'S','e','a','L','I','N','K','+','8','/','2','3','2',' ','(','\x87',' ','3',')',
/* 0x1f458 = "ISDN TA 128 [HFC-S]" */
    'I','S','D','N',' ','T','A',' ','1','2','8',' ','[','H','F','C','-','S',']',
/* 0x1f46b = "DSB-650 Ethernet [pegasus]" */
    'D','S','B','-','6','5','0',' ','\x7f',' ','[','p','e','g','a','s','u','s',']',
/* 0x1f47e = "Enhanced Laser Gaming Device" */
    'E','n','h','a','n','c','e','d',' ','\x82',' ','G','a','m','i','n','g',' ','\x03',
/* 0x1f491 = "MT5634ZBA-USB-V92 MultiModemUSB" */
    'M','T','5','6','3','4','Z','B','A','-','\x0a','-','V','9','2',' ','\xd6','\x1c','\x0a',
/* 0x1f4a4 = "USB,real VibrationPad" */
    'U','S','B',',','r','e','a','l',' ','V','i','b','r','a','t','i','o','n','\xfa',
/* 0x1f4b7 = "Nokia N95 (PC Suite mode)" */
    'N','o','k','i','a',' ','N','9','5',' ','(','\x1f','S','u','i','t','e',' ','\x1a',
/* 0x1f4ca = "Land Instruments International, Ltd" */
    'L','a','n','d',' ','I','n','s','t','r','u','m','e','n','t','s',' ','\xed','\x16',
/* 0x1f4dd = "USB-cdmaOne Adapter UCA1464" */
    '\x0a','-','c','d','m','a','O','n','e',' ','\x02',' ','U','C','A','1','4','6','4',
/* 0x1f4f0 = "Webbie HD - MHS-CM1" */
    'W','e','b','b','i','e',' ','H','D',' ','-',' ','M','H','S','-','C','M','1',
/* 0x1f503 = "Advanced RC Servo Controller" */
    'A','d','v','a','n','c','e','d',' ','R','C',' ','S','e','r','v','o',' ','\x13',
/* 0x1f516 = "RTL8153 Gigabit Ethernet Adapter" */
    'R','T','L','8','1','5','3',' ','G','i','g','a','b','i','t',' ','\x7f',' ','\x02',
/* 0x1f529 = "NHJ Che-ez! Kiss Digital Camera" */
    'N','H','J',' ','C','h','e','-','e','z','!',' ','K','i','s','s',' ','\x09','\x04',
/* 0x1f53c = "SoundCanvas SC-8850" */
    'S','o','u','n','d','C','a','n','v','a','s',' ','S','C','-','8','8','5','0',
/* 0x1f54f = "DataStation maxi light" */
    '\xe7','S','t','a','t','i','o','n',' ','m','a','x','i',' ','l','i','g','h','t',
/* 0x1f562 = "Yokogawa Electric Corp." */
    'Y','o','k','o','g','a','w','a',' ','E','l','e','c','t','r','i','c',' ','\x10',
/* 0x1f575 = "Hank Connection Industrial Co., Ltd" */
    'H','a','n','k',' ','C','o','n','n','e','c','t','i','o','n',' ','\xef','\x0e','\x16',
/* 0x1f588 = "Acron Precision Industrial Co., Ltd." */
    'A','c','r','o','n',' ','P','r','e','c','i','s','i','o','n',' ','\xef','\x0e','\xab',
/* 0x1f59b = "FRITZ!Box (Annex A)" */
    'F','R','I','T','Z','!','B','o','x',' ','(','A','n','n','e','x',' ','A',')',
/* 0x1f5ae = "LPCXpresso LPC-Link" */
    'L','P','C','X','p','r','e','s','s','o',' ','L','P','C','-','L','i','n','k',
/* 0x1f5c1 = "WL-343 Wireless USB Adapter 150N X1" */
    'W','L','-','3','4','3',' ','\x01','\x0a',' ','\x02',' ','1','5','0','N',' ','X','1',
/* 0x1f5d4 = "Arduino Micro (CDC ACM)" */
    'A','r','d','u','i','n','o',' ','\xc4',' ','(','C','D','C',' ','A','C','M',')',
/* 0x1f5e7 = "Gamecube/N64 controller v2.2" */
    'G','a','m','e','c','u','b','e','/','N','6','4',' ','\x9e',' ','v','2','.','2',
/* 0x1f5fa = "Gamecube/N64 controller v2.3" */
    'G','a','m','e','c','u','b','e','/','N','6','4',' ','\x9e',' ','v','2','.','3',
/* 0x1f60d = "Yakumo MegaImage IV" */
    'Y','a','k','u','m','o',' ','M','e','g','a','I','m','a','g','e',' ','I','V',
/* 0x1f620 = "PilotMouse Laser - 3 Button" */
    'P','i','l','o','t','\x0b',' ','\x82',' ','-',' ','3',' ','B','u','t','t','o','n',
/* 0x1f633 = "Westover Scientific" */
    'W','e','s','t','o','v','e','r',' ','S','c','i','e','n','t','i','f','i','c',
/* 0x1f646 = "NetScroll+ Superior" */
    'N','e','t','S','c','r','o','l','l','+',' ','S','u','p','e','r','i','o','r',
/* 0x1f659 = "Triplet GSM Phone (P2K)" */
    'T','r','i','p','l','e','t',' ','G','S','M',' ','\x19',' ','(','P','2','K',')',
/* 0x1f66c = "Precision barometer" */
    'P','r','e','c','i','s','i','o','n',' ','b','a','r','o','m','e','t','e','r',
/* 0x1f67f = "First International Computer, Inc." */
    'F','i','r','s','t',' ','\x9c',' ','C','o','m','p','u','t','e','r',',',' ','\x07',
/* 0x1f692 = "AR5523 driver (no firmware)" */
    'A','R','5','5','2','3',' ','d','r','i','v','e','r',' ','(','n','o',' ','\xdb',
/* 0x1f6a5 = "Shenzhen Siglent Co., Ltd." */
    'S','h','e','n','z','h','e','n',' ','S','i','g','l','e','n','t',' ','\x0e','\xab',
/* 0x1f6b8 = "My Passport Studio (WDBALG)" */
    'M','y',' ','\xd5','S','t','u','d','i','o',' ','(','W','D','B','A','L','G',')',
/* 0x1f6cb = "TrekStor GmbH & Co. KG" */
    'T','r','e','k','S','t','o','r',' ','\xfc',' ','&',' ','C','o','.',' ','K','G',
/* 0x1f6de = "ZyAIR B-220 IEEE 802.11b Adapter" */
    'Z','y','A','I','R',' ','B','-','2','2','0',' ','I','E','E','E',' ','\x9b','\x02',
/* 0x1f6f1 = "Cybex Computer Products Co." */
    'C','y','b','e','x',' ','\xcd','P','r','o','d','u','c','t','s',' ','C','o','.',
/* 0x1f704 = "100 MC FingerPrint and SmartCard Reader" */
    '1','0','0',' ','M','C',' ','F','i','n','g','e','r','\xbd','\xe4','\x12','\x15',' ','\x08',
/* 0x1f717 = "POS Printer, TH200B" */
    'P','O','S',' ','P','r','i','n','t','e','r',',',' ','T','H','2','0','0','B',
/* 0x1f72a = "NOXON DAB/DAB+ Stick V2" */
    'N','O','X','O','N',' ','D','A','B','/','D','A','B','+',' ','\xb3',' ','V','2',
/* 0x1f73d = "jumpSHOT CompactFlash Reader" */
    'j','u','m','p','S','H','O','T',' ','C','o','m','p','a','c','t','\x3c',' ','\x08',
/* 0x1f750 = "MuVo N200 with FM radio" */
    'M','u','V','o',' ','N','2','0','0',' ','\x98','F','M',' ','r','a','d','i','o',
/* 0x1f763 = "Nogatech Live! (BT)" */
    'N','o','g','a','t','e','c','h',' ','L','i','v','e','!',' ','(','B','T',')',
/* 0x1f776 = "STMP3400 D-Major MP3 Player" */
    'S','T','M','P','3','4','0','0',' ','D','-','M','a','j','o','r',' ','\x8e','\x1e',
/* 0x1f789 = "Corded Tilt-Wheel Mouse" */
    'C','o','r','d','e','d',' ','T','i','l','t','-','W','h','e','e','l',' ','\x0b',
/* 0x1f79c = "Clie PEG-TJ35 PDA Serial" */
    'C','l','i','e',' ','P','E','G','-','T','J','3','5',' ','P','D','A',' ','\x90',
/* 0x1f7af = "Storage Device (SD card reader)" */
    '\x0f','\x03',' ','(','S','D',' ','c','a','r','d',' ','r','e','a','d','e','r',')',
/* 0x1f7c2 = "SeaPORT+2/232 (Port 1)" */
    'S','e','a','P','O','R','T','+','2','/','2','3','2',' ','(','\x87',' ','1',')',
/* 0x1f7d5 = "Padix Co., Ltd (Rockfire)" */
    'P','a','d','i','x',' ','\x0e','\x16',' ','(','R','o','c','k','f','i','r','e',')',
/* 0x1f7e8 = "silex technology, Inc." */
    's','i','l','e','x',' ','t','e','c','h','n','o','l','o','g','y',',',' ','\x07',
/* 0x1f7fb = "Cygnal Integrated Products, Inc." */
    'C','y','g','n','a','l',' ','\x18','P','r','o','d','u','c','t','s',',',' ','\x07',
/* 0x1f80e = "USB Design by Example" */
    '\x0a',' ','D','e','s','i','g','n',' ','b','y',' ','E','x','a','m','p','l','e',
/* 0x1f821 = "ION VCR 2 PC / Video 2 PC" */
    'I','O','N',' ','V','C','R',' ','2',' ','\x1f','/',' ','\xa3',' ','2',' ','P','C',
/* 0x1f834 = "iL3-TP [AT90USB646]" */
    'i','L','3','-','T','P',' ','[','A','T','9','0','U','S','B','6','4','6',']',
/* 0x1f847 = "Rapid Access IIIe Keyboard" */
    'R','a','p','i','d',' ','A','c','c','e','s','s',' ','I','I','I','e',' ','\x05',
/* 0x1f85a = "Sound Blaster Play!" */
    'S','o','u','n','d',' ','B','l','a','s','t','e','r',' ','P','l','a','y','!',
/* 0x1f86d = "ES-H7200 [GT-20000]" */
    'E','S','-','H','7','2','0','0',' ','[','G','T','-','2','0','0','0','0',']',
/* 0x1f880 = "Siri A9 UVC chipset" */
    'S','i','r','i',' ','A','9',' ','U','V','C',' ','c','h','i','p','s','e','t',
/* 0x1f893 = "2.4GHz Receiver (Keyboard and Mouse)" */
    '2','.','4','G','H','z',' ','\x8c',' ','(','\x05',' ','\xe4','M','o','u','s','e',')',
/* 0x1f8a6 = "SeaPORT+4/485 (Port 4)" */
    'S','e','a','P','O','R','T','+','4','/','4','8','5',' ','(','\x87',' ','4',')',
/* 0x1f8b9 = "Lifetime Memory Products" */
    'L','i','f','e','t','i','m','e',' ','\xd2',' ','P','r','o','d','u','c','t','s',
/* 0x1f8cc = "Marble Mouse (2-button)" */
    'M','a','r','b','l','e',' ','\x0b',' ','(','2','-','b','u','t','t','o','n',')',
/* 0x1f8df = "SofTec Microsystems" */
    'S','o','f','T','e','c',' ','M','i','c','r','o','s','y','s','t','e','m','s',
/* 0x1f8f2 = "DWL-AG122 [Atheros AR5523]" */
    'D','W','L','-','A','G','1','2','2',' ','[','\xaf','A','R','5','5','2','3',']',
/* 0x1f905 = "Panstrong Company Ltd." */
    'P','a','n','s','t','r','o','n','g',' ','C','o','m','p','a','n','y',' ','\xab',
/* 0x1f918 = "SIMATIC NET CP 5711" */
    'S','I','M','A','T','I','C',' ','N','E','T',' ','C','P',' ','5','7','1','1',
/* 0x1f92b = "Taiwan Line Tek Electronic Co., Ltd" */
    'T','a','i','w','a','n',' ','L','i','n','e',' ','T','e','k',' ','\xba','\x0e','\x16',
/* 0x1f93e = "SeaPORT+2/485 (Port 2)" */
    'S','e','a','P','O','R','T','+','2','/','4','8','5',' ','(','\x87',' ','2',')',
/* 0x1f951 = "Webcam Notebook [PD1171]" */
    '\x11',' ','N','o','t','e','b','o','o','k',' ','[','P','D','1','1','7','1',']',
/* 0x1f964 = "256MB/512MB/1GB Flash Drive" */
    '2','5','6','M','B','/','5','1','2','M','B','/','1','G','B',' ','\x3c',' ','\x14',
/* 0x1f977 = "Dell Wireless 1802 Bluetooth 4.0 LE" */
    'D','e','l','l',' ','\x01','1','8','0','2',' ','\x06',' ','4','.','0',' ','L','E',
/* 0x1f98a = "Fujitsu Full HD Pro Webcam" */
    'F','u','j','i','t','s','u',' ','F','u','l','l',' ','H','D',' ','\x8f',' ','\x11',
/* 0x1f99d = "D2H (mass storage mode)" */
    'D','2','H',' ','(','m','a','s','s',' ','s','t','o','r','a','g','e',' ','\x1a',
/* 0x1f9b0 = "Linux-USB OBEX Gadget" */
    'L','i','n','u','x','-','\x0a',' ','O','B','E','X',' ','G','a','d','g','e','t',
/* 0x1f9c3 = "SignatureGem 1X5-HID Pad" */
    'S','i','g','n','a','t','u','r','e','G','e','m',' ','1','X','5','-','\xf2','\xfa',
/* 0x1f9d6 = "U2702A oscilloscope" */
    'U','2','7','0','2','A',' ','o','s','c','i','l','l','o','s','c','o','p','e',
/* 0x1f9e9 = "SeaLINK+8/232 (Port 2)" */
    'S','e','a','L','I','N','K','+','8','/','2','3','2',' ','(','\x87',' ','2',')',
/* 0x1f9fc = "Freebird wireless Controller" */
    'F','r','e','e','b','i','r','d',' ','w','i','r','e','l','e','s','s',' ','\x13',
/* 0x1fa0f = "Ugobe Life Forms, Inc." */
    'U','g','o','b','e',' ','L','i','f','e',' ','F','o','r','m','s',',',' ','\x07',
/* 0x1fa22 = "SeaPORT+4/232 (Port 3)" */
    'S','e','a','P','O','R','T','+','4','/','2','3','2',' ','(','\x87',' ','3',')',
/* 0x1fa35 = "Mass Storage (UID4/5A & UID7A)" */
    '\x7c','\x0f','(','U','I','D','4','/','5','A',' ','&',' ','U','I','D','7','A',')',
/* 0x1fa48 = "USB200M 100baseTX Adapter" */
    'U','S','B','2','0','0','M',' ','1','0','0','b','a','s','e','T','X',' ','\x02',
/* 0x1fa5b = "EZX GSM Phone (CDC Net)" */
    'E','Z','X',' ','G','S','M',' ','\x19',' ','(','C','D','C',' ','N','e','t',')',
/* 0x1fa6e = "DU-E100 Ethernet [pegasus]" */
    'D','U','-','E','1','0','0',' ','\x7f',' ','[','p','e','g','a','s','u','s',']',
/* 0x1fa81 = "SlimBlade Trackball" */
    'S','l','i','m','B','l','a','d','e',' ','T','r','a','c','k','b','a','l','l',
/* 0x1fa94 = "FinePix A205(S) Zoom (PC CAM)" */
    '\xca','i','x',' ','A','2','0','5','(','S',')',' ','\xe6','(','\x1f','C','A','M',')',
/* 0x1faa7 = "MPD16 MIDI Pad Controller Unit" */
    'M','P','D','1','6',' ','M','I','D','I',' ','\xfa',' ','\x13',' ','U','n','i','t',
/* 0x1faba = "SeaLINK+8/485 (Port 4)" */
    'S','e','a','L','I','N','K','+','8','/','4','8','5',' ','(','\x87',' ','4',')',
/* 0x1facd = "C902 Phone [PictBridge]" */
    'C','9','0','2',' ','\x19',' ','[','P','i','c','t','B','r','i','d','g','e',']',
/* 0x1fae0 = "Store \'n\' Go Micro Plus" */
    'S','t','o','r','e',' ','\'','n','\'',' ','G','o',' ','\xc4',' ','P','l','u','s',
/* 0x1faf3 = "Olivetti Techcenter" */
    'O','l','i','v','e','t','t','i',' ','T','e','c','h','c','e','n','t','e','r',
/* 0x1fb06 = "EZX GSM Phone (Storage)" */
    'E','Z','X',' ','G','S','M',' ','\x19',' ','(','S','t','o','r','a','g','e',')',
/* 0x1fb19 = "Nostromo 1745 GamePad" */
    'N','o','s','t','r','o','m','o',' ','1','7','4','5',' ','G','a','m','e','\xfa',
/* 0x1fb2c = "200 MC FingerPrint and SmartCard Reader" */
    '2','0','0',' ','M','C',' ','F','i','n','g','e','r','\xbd','\xe4','\x12','\x15',' ','\x08',
/* 0x1fb3f = "ACR1281U-C2 (qPBOC)" */
    'A','C','R','1','2','8','1','U','-','C','2',' ','(','q','P','B','O','C',')',
/* 0x1fb52 = "EC1260 Wireless Data Modem HSD USB Card" */
    'E','C','1','2','6','0',' ','\x01','\xe7',' ','\x1c',' ','H','S','D',' ','\x0a',' ','\x15',
/* 0x1fb65 = "Graphtec America, Inc." */
    'G','r','a','p','h','t','e','c',' ','A','m','e','r','i','c','a',',',' ','\x07',
/* 0x1fb78 = "PIC32 Starter Board" */
    'P','I','C','3','2',' ','S','t','a','r','t','e','r',' ','B','o','a','r','d',
/* 0x1fb8b = "3340z/Rollei DC3100" */
    '3','3','4','0','z','/','R','o','l','l','e','i',' ','D','C','3','1','0','0',
/* 0x1fb9e = "ZD1211 802.11b/g Wireless Adapter" */
    'Z','D','1','2','1','1',' ','8','0','2','.','1','1','b','/','g',' ','\x01','\x02',
/* 0x1fbb1 = "Allnet ALL0298 v2 802.11bg" */
    'A','l','l','n','e','t',' ','A','L','L','0','2','9','8',' ','v','2',' ','\xad',
/* 0x1fbc4 = "Integrated Telecom Express, Inc." */
    '\x18','T','e','l','e','c','o','m',' ','E','x','p','r','e','s','s',',',' ','\x07',
/* 0x1fbd7 = "GW Instek GDS-8x0 Oscilloscope" */
    'G','W',' ','I','n','s','t','e','k',' ','G','D','S','-','8','x','0',' ','\xfe',
/* 0x1fbea = "USB 2.0 multicard reader" */
    '\x0a',' ','\xc1','m','u','l','t','i','c','a','r','d',' ','r','e','a','d','e','r',
/* 0x1fbfd = "Adirondack Wire & Cable" */
    'A','d','i','r','o','n','d','a','c','k',' ','W','i','r','e',' ','&',' ','\xa5',
/* 0x1fc10 = "TVGo DVB-T03 [RTL2832]" */
    'T','V','G','o',' ','\xa7','T','0','3',' ','[','R','T','L','2','8','3','2',']',
/* 0x1fc23 = "Marx CryptoBox v1.2" */
    'M','a','r','x',' ','C','r','y','p','t','o','B','o','x',' ','v','1','.','2',
/* 0x1fc36 = "Valence Semiconductor Design, Ltd" */
    'V','a','l','e','n','c','e',' ','\xc0',' ','D','e','s','i','g','n',',',' ','\x16',
/* 0x1fc49 = "On-Tech Industry Co., Ltd" */
    'O','n','-','T','e','c','h',' ','I','n','d','u','s','t','r','y',' ','\x0e','\x16',
/* 0x1fc5c = "CE700A KVM Extender" */
    'C','E','7','0','0','A',' ','K','V','M',' ','E','x','t','e','n','d','e','r',
/* 0x1fc6f = "Keyboard (Boot Interface Subclass)" */
    '\x05',' ','(','B','o','o','t',' ','\x81',' ','S','u','b','c','l','a','s','s',')',
/* 0x1fc82 = "ST15i (Xperia mini)" */
    'S','T','1','5','i',' ','(','X','p','e','r','i','a',' ','m','i','n','i',')',
/* 0x1fc95 = "Expresscard SIM Card Reader" */
    'E','x','p','r','e','s','s','c','a','r','d',' ','S','I','M',' ','\x15',' ','\x08',
/* 0x1fca8 = "SDDR-31 Compact Flash Reader" */
    'S','D','D','R','-','3','1',' ','C','o','m','p','a','c','t',' ','\x3c',' ','\x08',
/* 0x1fcbb = "DWL-122 802.11b [Intersil Prism 3]" */
    'D','W','L','-','1','2','2',' ','\x9b','[','\xb0','P','r','i','s','m',' ','3',']',
/* 0x1fcce = "Guardant Sign Pro HID" */
    'G','u','a','r','d','a','n','t',' ','S','i','g','n',' ','\x8f',' ','H','I','D',
/* 0x1fce1 = "PalmSecure Sensor Device - MP" */
    'P','a','l','m','S','e','c','u','r','e',' ','\xac',' ','\x03',' ','-',' ','M','P',
/* 0x1fcf4 = "SDDR-01 Compact Flash Reader" */
    'S','D','D','R','-','0','1',' ','C','o','m','p','a','c','t',' ','\x3c',' ','\x08',
/* 0x1fd07 = "PS/2 to USB Converter" */
    'P','S','/','2',' ','t','o',' ','\x0a',' ','C','o','n','v','e','r','t','e','r',
/* 0x1fd1a = "INTELLIGENT SYSTEMS" */
    'I','N','T','E','L','L','I','G','E','N','T',' ','S','Y','S','T','E','M','S',
/* 0x1fd2d = "Propox JTAGcable II" */
    'P','r','o','p','o','x',' ','J','T','A','G','c','a','b','l','e',' ','I','I',
/* 0x1fd40 = "PilotMouse Laser - 6 Button" */
    'P','i','l','o','t','\x0b',' ','\x82',' ','-',' ','6',' ','B','u','t','t','o','n',
/* 0x1fd53 = "KYE Systems Corp. (Mouse Systems)" */
    'K','Y','E',' ','\xa6',' ','\x10',' ','(','\x0b',' ','S','y','s','t','e','m','s',')',
/* 0x1fd66 = "Joystick in FS Mode" */
    'J','o','y','s','t','i','c','k',' ','i','n',' ','F','S',' ','M','o','d','e',
/* 0x1fd79 = "I Tech Solutions Co., Ltd" */
    'I',' ','T','e','c','h',' ','S','o','l','u','t','i','o','n','s',' ','\x0e','\x16',
/* 0x1fd8c = "Cyborg Evo Wireless" */
    'C','y','b','o','r','g',' ','E','v','o',' ','W','i','r','e','l','e','s','s',
/* 0x1fd9f = "Acer/HP Integrated Webcam [CN0314]" */
    'A','c','e','r','/','H','P',' ','\x18','\x11',' ','[','C','N','0','3','1','4',']',
/* 0x1fdb2 = "Shark Multimedia, Inc." */
    'S','h','a','r','k',' ','M','u','l','t','i','m','e','d','i','a',',',' ','\x07',
/* 0x1fdc5 = "Acer Gobi Wireless Modem (QDL mode)" */
    'A','c','e','r',' ','G','o','b','i',' ','\x01','\x1c',' ','(','Q','D','L',' ','\x1a',
/* 0x1fdd8 = "D-WAV Scientific Co., Ltd" */
    'D','-','W','A','V',' ','S','c','i','e','n','t','i','f','i','c',' ','\x0e','\x16',
/* 0x1fdeb = "CR10x Coin Recycler" */
    'C','R','1','0','x',' ','C','o','i','n',' ','R','e','c','y','c','l','e','r',
/* 0x1fdfe = "Tranzport Control Surface" */
    'T','r','a','n','z','p','o','r','t',' ','\xc9',' ','S','u','r','f','a','c','e',
/* 0x1fe11 = "Aluminum Mini Keyboard (ANSI)" */
    'A','l','u','m','i','n','u','m',' ','\xb9',' ','\x05',' ','(','A','N','S','I',')',
/* 0x1fe24 = "DVB-T UB385-T [af9015]" */
    '\xa7','T',' ','U','B','3','8','5','-','T',' ','[','a','f','9','0','1','5',']',
/* 0x1fe37 = "PoPo Elixir Mouse (HID)" */
    'P','o','P','o',' ','E','l','i','x','i','r',' ','\x0b',' ','(','H','I','D',')',
/* 0x1fe4a = "ML-191x/ML-252x Laser Printer" */
    'M','L','-','1','9','1','x','/','M','L','-','2','5','2','x',' ','\x82',' ','\x0c',
/* 0x1fe5d = "Xonar U3 sound card" */
    'X','o','n','a','r',' ','U','3',' ','s','o','u','n','d',' ','c','a','r','d',
/* 0x1fe70 = "QuickCam Communicate STX" */
    '\xc7','a','m',' ','C','o','m','m','u','n','i','c','a','t','e',' ','S','T','X',
/* 0x1fe83 = "WIS09ABGN LinkStick Wireless LAN Adapter" */
    'W','I','S','0','9','A','B','G','N',' ','L','i','n','k','\xb3',' ','\x01','\xf3','\x02',
/* 0x1fe96 = "PlayStation Gamepad" */
    'P','l','a','y','S','t','a','t','i','o','n',' ','G','a','m','e','p','a','d',
/* 0x1fea9 = "SeaLINK+8/232 (Port 5)" */
    'S','e','a','L','I','N','K','+','8','/','2','3','2',' ','(','\x87',' ','5',')',
/* 0x1febc = "802.11a/b/g/n USB Wireless LAN Card" */
    '8','0','2','.','1','1','a','/','b','/','g','/','n',' ','\x0a',' ','\x01','\xf3','\x15',
/* 0x1fecf = "808 Camera #9 (web-cam mode)" */
    '8','0','8',' ','\x04',' ','#','9',' ','(','w','e','b','-','c','a','m',' ','\x1a',
/* 0x1fee2 = "Hauppauge WinTV Pro (PAL B/G FM)" */
    '\xfb','W','i','n','\xda','\x8f',' ','(','P','A','L',' ','B','/','G',' ','F','M',')',
/* 0x1fef5 = "MN128mini-V ISDN TA" */
    'M','N','1','2','8','m','i','n','i','-','V',' ','I','S','D','N',' ','T','A',
/* 0x1ff08 = "MAUSB-10 xD and SmartMedia Card Reader" */
    'M','A','U','S','B','-','1','0',' ','x','D',' ','\xe4','\x12','\xa1',' ','\x15',' ','\x08',
/* 0x1ff1b = "Beijing HanwangTechnology Co., Ltd" */
    'B','e','i','j','i','n','g',' ','H','a','n','w','a','n','g','\x0d',' ','\x0e','\x16',
/* 0x1ff2e = "STK1160 Video Capture Device" */
    'S','T','K','1','1','6','0',' ','\xa3',' ','C','a','p','t','u','r','e',' ','\x03',
/* 0x1ff41 = "smiths spirolab III" */
    's','m','i','t','h','s',' ','s','p','i','r','o','l','a','b',' ','I','I','I',
/* 0x1ff54 = "MARX Datentechnik GmbH" */
    'M','A','R','X',' ','D','a','t','e','n','t','e','c','h','n','i','k',' ','\xfc',
/* 0x1ff67 = "My Passport Studio (WDBAAE)" */
    'M','y',' ','\xd5','S','t','u','d','i','o',' ','(','W','D','B','A','A','E',')',
/* 0x1ff7a = "USB2.0 to ATAPI Bridge Controller" */
    'U','S','B','2','.','0',' ','t','o',' ','A','T','A','P','I',' ','\x9f',' ','\x13',
/* 0x1ff8d = "Shima Seiki Mfg., Ltd" */
    'S','h','i','m','a',' ','S','e','i','k','i',' ','M','f','g','.',',',' ','\x16',
/* 0x1ffa0 = "Dolphin Peripherals" */
    'D','o','l','p','h','i','n',' ','P','e','r','i','p','h','e','r','a','l','s',
/* 0x1ffb3 = "Mass Storage (UIM4/5S & UIM7S)" */
    '\x7c','\x0f','(','U','I','M','4','/','5','S',' ','&',' ','U','I','M','7','S',')',
/* 0x1ffc6 = "EasiDock 200 Keyboard and Mouse Port" */
    'E','a','s','i','D','o','c','k',' ','2','0','0',' ','\x05',' ','\xe4','\x0b',' ','\x87',
/* 0x1ffd9 = "Nissei Electric Co." */
    'N','i','s','s','e','i',' ','E','l','e','c','t','r','i','c',' ','C','o','.',
/* 0x1ffec = "Dual Action Gamepad" */
    'D','u','a','l',' ','A','c','t','i','o','n',' ','G','a','m','e','p','a','d',
/* 0x1ffff = "AnyDATA Corporation" */
    'A','n','y','D','A','T','A',' ','C','o','r','p','o','r','a','t','i','o','n',
/* 0x20012 = "SeaLINK+8/485 (Port 7)" */
    'S','e','a','L','I','N','K','+','8','/','4','8','5',' ','(','\x87',' ','7',')',
/* 0x20025 = "Mass Storage (UIS4/5S & UIS7S)" */
    '\x7c','\x0f','(','U','I','S','4','/','5','S',' ','&',' ','U','I','S','7','S',')',
/* 0x20038 = "STM32F103 [EasyKit]" */
    'S','T','M','3','2','F','1','0','3',' ','[','E','a','s','y','K','i','t',']',
/* 0x2004b = "XR21V1410 USB-UART IC" */
    'X','R','2','1','V','1','4','1','0',' ','\x0a','-','U','A','R','T',' ','I','C',
/* 0x2005e = "LabJack Corporation" */
    'L','a','b','J','a','c','k',' ','C','o','r','p','o','r','a','t','i','o','n',
/* 0x20071 = "Propox ISPcable III" */
    'P','r','o','p','o','x',' ','I','S','P','c','a','b','l','e',' ','I','I','I',
/* 0x20084 = "lt4112 Gobi 4G Module Network Device" */
    'l','t','4','1','1','2',' ','G','o','b','i',' ','4','G',' ','\xe5',' ','\x8d','\x03',
/* 0x20097 = "WingMan Extreme Digital 3D" */
    'W','i','n','g','M','a','n',' ','E','x','t','r','e','m','e',' ','\x09','3','D',
/* 0x200aa = "SideWinder Joystick" */
    'S','i','d','e','W','i','n','d','e','r',' ','J','o','y','s','t','i','c','k',
/* 0x200bd = "Yakumo MegaImage 37" */
    'Y','a','k','u','m','o',' ','M','e','g','a','I','m','a','g','e',' ','3','7',
/* 0x200d0 = "Link-5 micro dongle" */
    'L','i','n','k','-','5',' ','m','i','c','r','o',' ','d','o','n','g','l','e',
/* 0x200e3 = "Sansa Clip V2 (mtp)" */
    'S','a','n','s','a',' ','C','l','i','p',' ','V','2',' ','(','m','t','p',')',
/* 0x200f6 = "P&E Microcomputer Systems" */
    'P','&','E',' ','M','i','c','r','o','c','o','m','p','u','t','e','r',' ','\xa6',
/* 0x20109 = "File-backed Storage Gadget" */
    'F','i','l','e','-','b','a','c','k','e','d',' ','\x0f','G','a','d','g','e','t',
/* 0x2011c = "SoundBlaster Extigy" */
    'S','o','u','n','d','B','l','a','s','t','e','r',' ','E','x','t','i','g','y',
/* 0x2012f = "LifeTouch Note (debug mode)" */
    'L','i','f','e','\x9d',' ','N','o','t','e',' ','(','d','e','b','u','g',' ','\x1a',
/* 0x20142 = "MRW62E Multi-Card Reader/Writer" */
    'M','R','W','6','2','E',' ','\xd6','-','\x15',' ','R','e','a','d','e','r','/','\xdf',
/* 0x20155 = "Ether USB-T Ethernet [klsi]" */
    'E','t','h','e','r',' ','\x0a','-','T',' ','\x7f',' ','[','k','l','s','i',']',
/* 0x20167 = "Totoku Electric Co., Ltd" */
    'T','o','t','o','k','u',' ','E','l','e','c','t','r','i','c',' ','\x0e','\x16',
/* 0x20179 = "FTDI232 [EasyPort]" */
    'F','T','D','I','2','3','2',' ','[','E','a','s','y','P','o','r','t',']',
/* 0x2018b = "Aluminum Mini Keyboard (JIS)" */
    'A','l','u','m','i','n','u','m',' ','\xb9',' ','\x05',' ','(','J','I','S',')',
/* 0x2019d = "PDR-M2300/PDR-M700" */
    'P','D','R','-','M','2','3','0','0','/','P','D','R','-','M','7','0','0',
/* 0x201af = "My Passport Ultra (WDBBKD)" */
    'M','y',' ','\xd5','U','l','t','r','a',' ','(','W','D','B','B','K','D',')',
/* 0x201c1 = "Atheros AR9285 Malbec Bluetooth Adapter" */
    '\xaf','A','R','9','2','8','5',' ','M','a','l','b','e','c',' ','\x06',' ','\x02',
/* 0x201d3 = "Quanta Computer, Inc." */
    'Q','u','a','n','t','a',' ','C','o','m','p','u','t','e','r',',',' ','\x07',
/* 0x201e5 = "WLI-U2-AMG54HP Wireless LAN Adapter" */
    'W','L','I','-','U','2','-','A','M','G','5','4','H','P',' ','\x01','\xf3','\x02',
/* 0x201f7 = "SignatureGem 1X5 Pad" */
    'S','i','g','n','a','t','u','r','e','G','e','m',' ','1','X','5',' ','\xfa',
/* 0x20209 = "3Dconnexion CADman" */
    '3','D','c','o','n','n','e','x','i','o','n',' ','C','A','D','m','a','n',
/* 0x2021b = "Cruzer Titanium U3" */
    'C','r','u','z','e','r',' ','T','i','t','a','n','i','u','m',' ','U','3',
/* 0x2022d = "Ci65m Wireless Notebook Optical Mouse" */
    'C','i','6','5','m',' ','\x01','N','o','t','e','b','o','o','k',' ','\x7b','\x0b',
/* 0x2023f = "Dazzle TV! Pro Audio (P+)" */
    'D','a','z','z','l','e',' ','T','V','!',' ','\x8f',' ','\x8b','(','P','+',')',
/* 0x20251 = "Marlin 2.0 (Mass Storage)" */
    'M','a','r','l','i','n',' ','\xc1','(','\x7c','S','t','o','r','a','g','e',')',
/* 0x20263 = "Intelligent Usb Dmx Interface SIUDI7A" */
    '\xe0','U','s','b',' ','D','m','x',' ','\x81',' ','S','I','U','D','I','7','A',
/* 0x20275 = "J108i Cedar (MTP mode)" */
    'J','1','0','8','i',' ','C','e','d','a','r',' ','(','M','T','P',' ','\x1a',
/* 0x20287 = "Plugable USB-VGA-165" */
    'P','l','u','g','a','b','l','e',' ','\x0a','-','V','G','A','-','1','6','5',
/* 0x20299 = "SUNTAC U-Cable type A4" */
    'S','U','N','T','A','C',' ','U','-','\xa5',' ','t','y','p','e',' ','A','4',
/* 0x202ab = "SUNTAC U-Cable type A3" */
    'S','U','N','T','A','C',' ','U','-','\xa5',' ','t','y','p','e',' ','A','3',
/* 0x202bd = "Document Processor" */
    'D','o','c','u','m','e','n','t',' ','P','r','o','c','e','s','s','o','r',
/* 0x202cf = "USB 1.1 10/100M Fast Ethernet Adapter" */
    '\x0a',' ','1','.','1',' ','1','0','/','1','0','0','M',' ','\xec','\x7f',' ','\x02',
/* 0x202e1 = "PhidgetInterface Kit 8-8-8" */
    'P','h','i','d','g','e','t','\x81',' ','K','i','t',' ','8','-','8','-','8',
/* 0x202f3 = "SPC 610NC Laptop Camera" */
    'S','P','C',' ','6','1','0','N','C',' ','L','a','p','t','o','p',' ','\x04',
/* 0x20305 = "Cinergy T\u00b2  DVB-T Receiver" */
    'C','i','n','e','r','g','y',' ','T','\xff','\xc2','\xb2',' ',' ','\xa7','T',' ','\x8c',
/* 0x20317 = "PowerShot SD1300 IS / IXUS 105" */
    '\x24','\x84','S','D','1','3','0','0',' ','I','S',' ','/',' ','\xfd','1','0','5',
/* 0x20329 = "Nostromo N50 GamePad" */
    'N','o','s','t','r','o','m','o',' ','N','5','0',' ','G','a','m','e','\xfa',
/* 0x2033b = "Cordless Keyboard for Wii HID Receiver" */
    'C','o','r','d','l','e','s','s',' ','\x05',' ','\xcc','W','i','i',' ','\xf2','\x8c',
/* 0x2034d = "TriGem Computer, Inc." */
    'T','r','i','G','e','m',' ','C','o','m','p','u','t','e','r',',',' ','\x07',
/* 0x2035f = "PL25A1 Host-Host Bridge" */
    'P','L','2','5','A','1',' ','H','o','s','t','-','H','o','s','t',' ','\x9f',
/* 0x20371 = "ET-0405 [Graphire]" */
    'E','T','-','0','4','0','5',' ','[','G','r','a','p','h','i','r','e',']',
/* 0x20383 = "EeePC T91MT HID Touch Panel" */
    'E','e','e','\x1f','T','9','1','M','T',' ','\xf2','\x9d',' ','P','a','n','e','l',
/* 0x20395 = "VASCO Data Security International" */
    'V','A','S','C','O',' ','\xe7',' ','S','e','c','u','r','i','t','y',' ','\x9c',
/* 0x203a7 = "glcd2usb interface" */
    'g','l','c','d','2','u','s','b',' ','i','n','t','e','r','f','a','c','e',
/* 0x203b9 = "SB-USB JTAG Emulator" */
    'S','B','-','\x0a',' ','J','T','A','G',' ','E','m','u','l','a','t','o','r',
/* 0x203cb = "HuiYang D & S Cable Co., Ltd." */
    'H','u','i','Y','a','n','g',' ','D',' ','&',' ','S',' ','\xa5',' ','\x0e','\xab',
/* 0x203dd = "Handycam DCR-SR55E" */
    'H','a','n','d','y','c','a','m',' ','D','C','R','-','S','R','5','5','E',
/* 0x203ef = "Microchip REAL ICE" */
    'M','i','c','r','o','c','h','i','p',' ','R','E','A','L',' ','I','C','E',
/* 0x20401 = "USB Bluetooth Device in DFU State" */
    '\x0a',' ','\x06',' ','\x03',' ','i','n',' ','D','F','U',' ','S','t','a','t','e',
/* 0x20413 = "Periboard 717 Mini Wireless Keyboard" */
    'P','e','r','i','b','o','a','r','d',' ','7','1','7',' ','\xb9',' ','\x01','\x05',
/* 0x20425 = "WebCam SC-13HDL11939N" */
    'W','e','b','\x9a','S','C','-','1','3','H','D','L','1','1','9','3','9','N',
/* 0x20437 = "TACOMA Fingerprint Mouse V1.06.01" */
    'T','A','C','O','M','A',' ','\x92','\x0b',' ','V','1','.','0','6','.','0','1',
/* 0x20449 = "Nogatech TV! (MF-)" */
    'N','o','g','a','t','e','c','h',' ','T','V','!',' ','(','M','F','-',')',
/* 0x2045b = "SCL011 RFID reader" */
    'S','C','L','0','1','1',' ','R','F','I','D',' ','r','e','a','d','e','r',
/* 0x2046d = "Iguanaworks USB IR Transceiver" */
    'I','g','u','a','n','a','w','o','r','k','s',' ','\x0a',' ','I','R',' ','\xc8',
/* 0x2047f = "GE Medical Systems Lunar" */
    'G','E',' ','M','e','d','i','c','a','l',' ','\xa6',' ','L','u','n','a','r',
/* 0x20491 = "Samsung Techwin Co., Ltd" */
    'S','a','m','s','u','n','g',' ','T','e','c','h','w','i','n',' ','\x0e','\x16',
/* 0x204a3 = "Optoelectronics Co., Ltd" */
    'O','p','t','o','e','l','e','c','t','r','o','n','i','c','s',' ','\x0e','\x16',
/* 0x204b5 = "MediaTV Pro III MiniPCIe (EU)" */
    '\xa1','\xda','\x8f',' ','I','I','I',' ','\xb9','P','C','I','e',' ','(','E','U',')',
/* 0x204c7 = "Lansing HID Audio Controls" */
    'L','a','n','s','i','n','g',' ','\xf2','\x8b','C','o','n','t','r','o','l','s',
/* 0x204d9 = "MTi-G 7xx GNSS/INS" */
    'M','T','i','-','G',' ','7','x','x',' ','G','N','S','S','/','I','N','S',
/* 0x204eb = "TNT DVB-T/DAB/DAB+/FM" */
    'T','N','T',' ','\xa7','T','/','D','A','B','/','D','A','B','+','/','F','M',
/* 0x204fd = "LPC2378 [Robotino]" */
    'L','P','C','2','3','7','8',' ','[','R','o','b','o','t','i','n','o',']',
/* 0x2050f = "Microcosm Ltd Dinkey" */
    'M','i','c','r','o','c','o','s','m',' ','\x16',' ','D','i','n','k','e','y',
/* 0x20521 = "SUNTAC U-Cable type P1" */
    'S','U','N','T','A','C',' ','U','-','\xa5',' ','t','y','p','e',' ','P','1',
/* 0x20533 = "8x931Hx Customer Hub" */
    '8','x','9','3','1','H','x',' ','C','u','s','t','o','m','e','r',' ','\xa4',
/* 0x20545 = "WebCam SC-03FFM12339N" */
    'W','e','b','\x9a','S','C','-','0','3','F','F','M','1','2','3','3','9','N',
/* 0x20557 = "Lenovo Integrated Webcam [R5U877]" */
    'L','e','n','o','v','o',' ','\x18','\x11',' ','[','R','5','U','8','7','7',']',
/* 0x20569 = "Xerox DocuMate 272" */
    'X','e','r','o','x',' ','D','o','c','u','M','a','t','e',' ','2','7','2',
/* 0x2057b = "My Passport Elite (WDBAAC)" */
    'M','y',' ','\xd5','E','l','i','t','e',' ','(','W','D','B','A','A','C',')',
/* 0x2058d = "MIDI class devices" */
    'M','I','D','I',' ','c','l','a','s','s',' ','d','e','v','i','c','e','s',
/* 0x2059f = "802.11 n/g/b Wireless LAN USB Adapter" */
    '8','0','2','.','1','1',' ','n','/','g','/','b',' ','\x01','\xf3','\x0a',' ','\x02',
/* 0x205b1 = "GN-WB31N 802.11n USB WLAN Card" */
    'G','N','-','W','B','3','1','N',' ','\x99','\x0a',' ','W','L','A','N',' ','\x15',
/* 0x205c3 = "TiePie engineering" */
    'T','i','e','P','i','e',' ','e','n','g','i','n','e','e','r','i','n','g',
/* 0x205d5 = "eToken R1 v3.3.3.x" */
    'e','T','o','k','e','n',' ','R','1',' ','v','3','.','3','.','3','.','x',
/* 0x205e7 = "Voyager Slider Flash Drive" */
    'V','o','y','a','g','e','r',' ','S','l','i','d','e','r',' ','\x3c',' ','\x14',
/* 0x205f9 = "AnMo Electronics Corporation" */
    'A','n','M','o',' ','\x1b',' ','C','o','r','p','o','r','a','t','i','o','n',
/* 0x2060b = "Marvell JTAG Probe" */
    'M','a','r','v','e','l','l',' ','J','T','A','G',' ','P','r','o','b','e',
/* 0x2061d = "Fujitsu Devices, Inc." */
    'F','u','j','i','t','s','u',' ','D','e','v','i','c','e','s',',',' ','\x07',
/* 0x2062f = "SurfBoard 4210 Cable Modem" */
    'S','u','r','f','B','o','a','r','d',' ','4','2','1','0',' ','\xa5',' ','\x1c',
/* 0x20641 = "MX700 Cordless Mouse Receiver" */
    'M','X','7','0','0',' ','C','o','r','d','l','e','s','s',' ','\x0b',' ','\x8c',
/* 0x20653 = "HC100 wristbands Printer" */
    'H','C','1','0','0',' ','w','r','i','s','t','b','a','n','d','s',' ','\x0c',
/* 0x20665 = "WebCam SC-03FFL11939N" */
    'W','e','b','\x9a','S','C','-','0','3','F','F','L','1','1','9','3','9','N',
/* 0x20677 = "TT-connect S2-4600" */
    'T','T','-','c','o','n','n','e','c','t',' ','S','2','-','4','6','0','0',
/* 0x20689 = "SM Tech Co., Ltd (Tulip)" */
    'S','M',' ','T','e','c','h',' ','\x0e','\x16',' ','(','T','u','l','i','p',')',
/* 0x2069b = "Kinect for Windows NUI Motor" */
    'K','i','n','e','c','t',' ','\xcc','\x83','N','U','I',' ','M','o','t','o','r',
/* 0x206ad = "Digital-TV Receiver." */
    'D','i','g','i','t','a','l','-','\xda','R','e','c','e','i','v','e','r','.',
/* 0x206bf = "Unigen Corporation" */
    'U','n','i','g','e','n',' ','C','o','r','p','o','r','a','t','i','o','n',
/* 0x206d1 = "WorldWide Cable Opto Corp." */
    'W','o','r','l','d','W','i','d','e',' ','\xa5',' ','O','p','t','o',' ','\x10',
/* 0x206e3 = "FinePix A205(S) Zoom (DSC)" */
    '\xca','i','x',' ','A','2','0','5','(','S',')',' ','\xe6','(','D','S','C',')',
/* 0x206f5 = "OpenBeacon USB stick" */
    'O','p','e','n','B','e','a','c','o','n',' ','\x0a',' ','s','t','i','c','k',
/* 0x20707 = "Hantek DSO-2100 UF" */
    'H','a','n','t','e','k',' ','D','S','O','-','2','1','0','0',' ','U','F',
/* 0x20719 = "Sunplus Generic Digital Camera" */
    'S','u','n','p','l','u','s',' ','G','e','n','e','r','i','c',' ','\x09','\x04',
/* 0x2072b = "F8T065BF Mini Bluetooth 4.0 Adapter" */
    'F','8','T','0','6','5','B','F',' ','\xb9',' ','\x06',' ','4','.','0',' ','\x02',
/* 0x2073d = "Vivitar Vivicam 10" */
    'V','i','v','i','t','a','r',' ','V','i','v','i','c','a','m',' ','1','0',
/* 0x2074f = "IXXAT Automation GmbH" */
    'I','X','X','A','T',' ','A','u','t','o','m','a','t','i','o','n',' ','\xfc',
/* 0x20761 = "NXP Semiconductors" */
    'N','X','P',' ','S','e','m','i','c','o','n','d','u','c','t','o','r','s',
/* 0x20773 = "iPod Touch 3.Gen (8GB)" */
    'i','P','o','d',' ','\x9d',' ','3','.','G','e','n',' ','(','8','G','B',')',
/* 0x20785 = "G2/G3CCD-I KAI CCD" */
    'G','2','/','G','3','C','C','D','-','I',' ','K','A','I',' ','C','C','D',
/* 0x20797 = "OpenCom 40 (FlashLoad)" */
    'O','p','e','n','C','o','m',' ','4','0',' ','(','\x3c','L','o','a','d',')',
/* 0x207a9 = "P990 Dual Analog Pad" */
    'P','9','9','0',' ','D','u','a','l',' ','A','n','a','l','o','g',' ','\xfa',
/* 0x207bb = "Elements Portable (WDBAAR)" */
    'E','l','e','m','e','n','t','s',' ','\xa9','(','W','D','B','A','A','R',')',
/* 0x207cd = "RDX External dock (redbud)" */
    'R','D','X',' ','\xe3','d','o','c','k',' ','(','r','e','d','b','u','d',')',
/* 0x207df = "Power Debug/Power Debug II" */
    '\x24',' ','D','e','b','u','g','/','\x24',' ','D','e','b','u','g',' ','I','I',
/* 0x207f1 = "Cheetah SPI Host Adapter" */
    'C','h','e','e','t','a','h',' ','S','P','I',' ','H','o','s','t',' ','\x02',
/* 0x20803 = "Sansa M200 series (msc)" */
    'S','a','n','s','a',' ','M','2','0','0',' ','\x1d',' ','(','m','s','c',')',
/* 0x20815 = "Cisco Virtual Keyboard and Mouse" */
    'C','i','s','c','o',' ','V','i','r','t','u','a','l',' ','\x05',' ','\xe4','\x0b',
/* 0x20827 = "VTech Computers, Ltd" */
    'V','T','e','c','h',' ','C','o','m','p','u','t','e','r','s',',',' ','\x16',
/* 0x20839 = "Coby Electronics Corporation" */
    'C','o','b','y',' ','\x1b',' ','C','o','r','p','o','r','a','t','i','o','n',
/* 0x2084b = "Kansai Electric Co., Ltd" */
    'K','a','n','s','a','i',' ','E','l','e','c','t','r','i','c',' ','\x0e','\x16',
/* 0x2085d = "SM-MS/Pro-MMC-XD Card Reader" */
    'S','M','-','M','S','/','\x8f','-','M','M','C','-','X','D',' ','\x15',' ','\x08',
/* 0x2086f = "Shanghai Jujo Electronics Co., Ltd" */
    'S','h','a','n','g','h','a','i',' ','J','u','j','o',' ','\x1b',' ','\x0e','\x16',
/* 0x20881 = "Toyo Communication Equipment Co., Ltd" */
    'T','o','y','o',' ','\xe9','E','q','u','i','p','m','e','n','t',' ','\x0e','\x16',
/* 0x20893 = "SG Intec Ltd & Co KG" */
    'S','G',' ','I','n','t','e','c',' ','\x16',' ','&',' ','C','o',' ','K','G',
/* 0x208a5 = "Triplet GSM Phone (AT)" */
    'T','r','i','p','l','e','t',' ','G','S','M',' ','\x19',' ','(','A','T',')',
/* 0x208b7 = "RTL8188CUS 802.11n WLAN Adapter" */
    'R','T','L','8','1','8','8','C','U','S',' ','\x99','W','L','A','N',' ','\x02',
/* 0x208c9 = "EADS Deutschland GmbH" */
    'E','A','D','S',' ','D','e','u','t','s','c','h','l','a','n','d',' ','\xfc',
/* 0x208db = "USB2LPT Cable Release2" */
    'U','S','B','2','L','P','T',' ','\xa5',' ','R','e','l','e','a','s','e','2',
/* 0x208ed = "Nexus S (fastboot)" */
    'N','e','x','u','s',' ','S',' ','(','f','a','s','t','b','o','o','t',')',
/* 0x208ff = "Pantech Android composite" */
    'P','a','n','t','e','c','h',' ','\xce','c','o','m','p','o','s','i','t','e',
/* 0x20911 = "SUNTAC U-Cable type D2" */
    'S','U','N','T','A','C',' ','U','-','\xa5',' ','t','y','p','e',' ','D','2',
/* 0x20923 = "eQ-3 Entwicklung GmbH" */
    'e','Q','-','3',' ','E','n','t','w','i','c','k','l','u','n','g',' ','\xfc',
/* 0x20935 = "open-usb-can (DFU)" */
    'o','p','e','n','-','u','s','b','-','c','a','n',' ','(','D','F','U',')',
/* 0x20947 = "Hangzhou Riyue Electronic Co., Ltd." */
    'H','a','n','g','z','h','o','u',' ','R','i','y','u','e',' ','\xba','\x0e','\xab',
/* 0x20959 = "TG 11Mbps WLAN Mini Adapter" */
    'T','G',' ','1','1','M','b','p','s',' ','W','L','A','N',' ','\xb9',' ','\x02',
/* 0x2096b = "N97 (mass storage)" */
    'N','9','7',' ','(','m','a','s','s',' ','s','t','o','r','a','g','e',')',
/* 0x2097d = "LUA-TX Ethernet [pegasus]" */
    'L','U','A','-','T','X',' ','\x7f',' ','[','p','e','g','a','s','u','s',']',
/* 0x2098f = "WorkCentre PE220 Series" */
    'W','o','r','k','C','e','n','t','r','e',' ','P','E','2','2','0',' ','\xbf',
/* 0x209a1 = "Acer Crystal Eye Webcam" */
    'A','c','e','r',' ','C','r','y','s','t','a','l',' ','E','y','e',' ','\x11',
/* 0x209b3 = "Nexus 7 (fastboot)" */
    'N','e','x','u','s',' ','7',' ','(','f','a','s','t','b','o','o','t',')',
/* 0x209c5 = "ADMtek ADM8515 NIC" */
    'A','D','M','t','e','k',' ','A','D','M','8','5','1','5',' ','N','I','C',
/* 0x209d7 = "Sansa e100 series (msc)" */
    'S','a','n','s','a',' ','e','1','0','0',' ','\x1d',' ','(','m','s','c',')',
/* 0x209e9 = "LP-A500 [AcuLaser CX1]" */
    'L','P','-','A','5','0','0',' ','[','A','c','u','\x82',' ','C','X','1',']',
/* 0x209fb = "Your data Our Care" */
    'Y','o','u','r',' ','d','a','t','a',' ','O','u','r',' ','C','a','r','e',
/* 0x20a0d = "PM-A900 [Stylus Photo RX700]" */
    'P','M','-','A','9','0','0',' ','[','\xb1','\x86',' ','R','X','7','0','0',']',
/* 0x20a1f = "WingMan Formula GP" */
    'W','i','n','g','M','a','n',' ','F','o','r','m','u','l','a',' ','G','P',
/* 0x20a31 = "QuickCam Messenger Plus" */
    '\xc7','a','m',' ','M','e','s','s','e','n','g','e','r',' ','P','l','u','s',
/* 0x20a43 = "Papilio Duo (FPGA)" */
    'P','a','p','i','l','i','o',' ','D','u','o',' ','(','F','P','G','A',')',
/* 0x20a55 = "Nexus 4 (fastboot)" */
    'N','e','x','u','s',' ','4',' ','(','f','a','s','t','b','o','o','t',')',
/* 0x20a67 = "COMpact 2204 (PBX)" */
    'C','O','M','p','a','c','t',' ','2','2','0','4',' ','(','P','B','X',')',
/* 0x20a79 = "DVD+RW External Drive DRU-700A" */
    'D','V','D','+','R','W',' ','\xe3','\x14',' ','D','R','U','-','7','0','0','A',
/* 0X20a8b = "Acer Aspire 5672 Webcam" */
    'c','e','r',' ','A','s','p','i','r','e',' ','5','6','7','2',' ','\x11',
/* 0x20a9c = "6120 Phone (PC-Suite mode)" */
    '6','1','2','0',' ','\x19',' ','(','P','C','-','S','u','i','t','e',' ','\x1a',
/* 0x20aae = "Promethean Limited" */
    'P','r','o','m','e','t','h','e','a','n',' ','L','i','m','i','t','e','d',
/* 0x20ac0 = "MeMO Pad HD 7 (MTP mode)" */
    'M','e','M','O',' ','\xfa',' ','H','D',' ','7',' ','(','M','T','P',' ','\x1a',
/* 0x20ad2 = "Ultra Max USB/1394" */
    'U','l','t','r','a',' ','M','a','x',' ','U','S','B','/','1','3','9','4',
/* 0x20ae4 = "ScanMaker V6UL/SpicyU" */
    '\x8a','M','a','k','e','r',' ','V','6','U','L','/','S','p','i','c','y','U',
/* 0x20af6 = "Hewlett Packard Digital Camera" */
    'H','e','w','l','e','t','t',' ','P','a','c','k','a','r','d',' ','\x09','\x04',
/* 0x20b08 = "Paparazzi (Serial)" */
    'P','a','p','a','r','a','z','z','i',' ','(','S','e','r','i','a','l',')',
/* 0x20b1a = "Hybrid Networks, Inc." */
    'H','y','b','r','i','d',' ','N','e','t','w','o','r','k','s',',',' ','\x07',
/* 0x20b2c = "Integrated System Solution Corp." */
    '\x18','S','y','s','t','e','m',' ','S','o','l','u','t','i','o','n',' ','\x10',
/* 0x20b3e = "4820 LCD w/ MSR/KB" */
    '4','8','2','0',' ','L','C','D',' ','w','/',' ','M','S','R','/','K','B',
/* 0x20b50 = "Eclipse wireless Controller" */
    'E','c','l','i','p','s','e',' ','w','i','r','e','l','e','s','s',' ','\x13',
/* 0x20b62 = "BearPaw 1200 TA/CS" */
    'B','e','a','r','P','a','w',' ','1','2','0','0',' ','T','A','/','C','S',
/* 0x20b74 = "iPod Shuffle 3.Gen" */
    'i','P','o','d',' ','S','h','u','f','f','l','e',' ','3','.','G','e','n',
/* 0x20b86 = "U8120 3G Cellphone" */
    'U','8','1','2','0',' ','3','G',' ','C','e','l','l','p','h','o','n','e',
/* 0x20b98 = "FT-IR Spectrometer" */
    'F','T','-','I','R',' ','S','p','e','c','t','r','o','m','e','t','e','r',
/* 0x20baa = "TT-connect S2-3600" */
    'T','T','-','c','o','n','n','e','c','t',' ','S','2','-','3','6','0','0',
/* 0x20bbc = "Xerox DocuMate 252" */
    'X','e','r','o','x',' ','D','o','c','u','M','a','t','e',' ','2','5','2',
/* 0x20bce = "(OME) PocketZip 40 MP3 Player Driver" */
    '(','O','M','E',')',' ','\x17','Z','i','p',' ','4','0',' ','\x8e','\x1e',' ','\xde',
/* 0x20be0 = "Iconia tablet A500" */
    'I','c','o','n','i','a',' ','t','a','b','l','e','t',' ','A','5','0','0',
/* 0x20bf2 = "Benica Corporation" */
    'B','e','n','i','c','a',' ','C','o','r','p','o','r','a','t','i','o','n',
/* 0x20c04 = "ME-6100ISLE/16/DIO" */
    'M','E','-','6','1','0','0','I','S','L','E','/','1','6','/','D','I','O',
/* 0x20c16 = "Desire HD (debug mode)" */
    'D','e','s','i','r','e',' ','H','D',' ','(','d','e','b','u','g',' ','\x1a',
/* 0x20c28 = "Photosmart C4500 series" */
    'P','h','o','t','o','s','m','a','r','t',' ','C','4','5','0','0',' ','\x1d',
/* 0x20c3a = "Cino FuzzyScan F760-B" */
    'C','i','n','o',' ','F','u','z','z','y','\x8a',' ','F','7','6','0','-','B',
/* 0x20c4c = "Cool Icam Digi-MP3" */
    'C','o','o','l',' ','I','c','a','m',' ','D','i','g','i','-','M','P','3',
/* 0x20c5e = "SD/MMC card reader" */
    'S','D','/','M','M','C',' ','c','a','r','d',' ','r','e','a','d','e','r',
/* 0x20c70 = "ScrollPoint Optical (HID)" */
    'S','c','r','o','l','l','P','o','i','n','t',' ','\x7b','(','H','I','D',')',
/* 0x20c82 = "Sansa E200 series (mtp)" */
    'S','a','n','s','a',' ','E','2','0','0',' ','\x1d',' ','(','m','t','p',')',
/* 0x20c94 = "D3 Station External Hard Drive" */
    'D','3',' ','S','t','a','t','i','o','n',' ','\xe3','H','a','r','d',' ','\x14',
/* 0x20ca6 = "Matrox Graphics, Inc." */
    'M','a','t','r','o','x',' ','G','r','a','p','h','i','c','s',',',' ','\x07',
/* 0x20cb8 = "PIC24F Starter Kit" */
    'P','I','C','2','4','F',' ','S','t','a','r','t','e','r',' ','K','i','t',
/* 0x20cca = "6120 Phone (Mass storage mode)" */
    '6','1','2','0',' ','\x19',' ','(','\x7c','s','t','o','r','a','g','e',' ','\x1a',
/* 0x20cdc = "OpenDCC (Throttle)" */
    'O','p','e','n','D','C','C',' ','(','T','h','r','o','t','t','l','e',')',
/* 0x20cee = "Cordless RumblePad 2" */
    'C','o','r','d','l','e','s','s',' ','R','u','m','b','l','e','\xfa',' ','2',
/* 0x20d00 = "TOSHIBA Web Camera - HD" */
    'T','O','S','H','I','B','A',' ','W','e','b',' ','\x04',' ','-',' ','H','D',
/* 0x20d12 = "Visual Communication Camera VGP-VCC1" */
    'V','i','s','u','a','l',' ','\xe9','\x04',' ','V','G','P','-','V','C','C','1',
/* 0x20d24 = "Dynamic System Electronics Corp." */
    'D','y','n','a','m','i','c',' ','S','y','s','t','e','m',' ','\x1b',' ','\x10',
/* 0x20d36 = "Joinsoon Electronics Mfg. Co., Ltd" */
    'J','o','i','n','s','o','o','n',' ','\x1b',' ','M','f','g','.',' ','\x0e','\x16',
/* 0x20d48 = "Kick-off! Watchdog" */
    'K','i','c','k','-','o','f','f','!',' ','W','a','t','c','h','d','o','g',
/* 0x20d5a = "Kinect for Windows NUI Audio" */
    'K','i','n','e','c','t',' ','\xcc','\x83','N','U','I',' ','A','u','d','i','o',
/* 0x20d6c = "KWorld DVB-T 355U Digital TV Dongle" */
    'K','W','o','r','l','d',' ','\xa7','T',' ','3','5','5','U',' ','\x09','\xda','\xf4',
/* 0x20d7e = "Tokyo Electronic Industry Co., Ltd" */
    'T','o','k','y','o',' ','\xba','I','n','d','u','s','t','r','y',' ','\x0e','\x16',
/* 0x20d90 = "P880 / USB tethering" */
    'P','8','8','0',' ','/',' ','\x0a',' ','t','e','t','h','e','r','i','n','g',
/* 0x20da2 = "Prototype Reader/Writer" */
    'P','r','o','t','o','t','y','p','e',' ','R','e','a','d','e','r','/','\xdf',
/* 0x20db4 = "Sundtek HD Capture" */
    'S','u','n','d','t','e','k',' ','H','D',' ','C','a','p','t','u','r','e',
/* 0x20dc6 = "DU-E10 Ethernet [pegasus]" */
    'D','U','-','E','1','0',' ','\x7f',' ','[','p','e','g','a','s','u','s',']',
/* 0x20dd8 = "Colibri [Ambit2 S]" */
    'C','o','l','i','b','r','i',' ','[','A','m','b','i','t','2',' ','S',']',
/* 0x20dea = "GN-WB32L 802.11n USB WLAN Card" */
    'G','N','-','W','B','3','2','L',' ','\x99','\x0a',' ','W','L','A','N',' ','\x15',
/* 0x20dfc = "AudioTrak Optoplay" */
    'A','u','d','i','o','T','r','a','k',' ','O','p','t','o','p','l','a','y',
/* 0x20e0e = "Ex-Series UVC interface" */
    'E','x','-','\xbf',' ','U','V','C',' ','i','n','t','e','r','f','a','c','e',
/* 0x20e20 = "Wincor Nixdorf International GmbH" */
    'W','i','n','c','o','r',' ','N','i','x','d','o','r','f',' ','\x9c',' ','\xfc',
/* 0x20e32 = "A-Tec Subsystem, Inc." */
    'A','-','T','e','c',' ','S','u','b','s','y','s','t','e','m',',',' ','\x07',
/* 0x20e44 = "Nexus 7 2012 (PTP)" */
    'N','e','x','u','s',' ','7',' ','2','0','1','2',' ','(','P','T','P',')',
/* 0x20e56 = "In-Circuit Debug Interface" */
    'I','n','-','C','i','r','c','u','i','t',' ','D','e','b','u','g',' ','\x81',
/* 0x20e68 = "UB396-T [RTL2832U]" */
    'U','B','3','9','6','-','T',' ','[','R','T','L','2','8','3','2','U',']',
/* 0x20e7a = "SDXC and microSDXC CardReader" */
    'S','D','X','C',' ','\xe4','m','i','c','r','o','S','D','X','C',' ','\x15','\x08',
/* 0x20e8c = "Porsche Design Mobile Drive" */
    'P','o','r','s','c','h','e',' ','D','e','s','i','g','n',' ','\x96',' ','\x14',
/* 0x20e9e = "Airborn Connectors" */
    'A','i','r','b','o','r','n',' ','C','o','n','n','e','c','t','o','r','s',
/* 0x20eb0 = "ALECTRONIC LIMITED" */
    'A','L','E','C','T','R','O','N','I','C',' ','L','I','M','I','T','E','D',
/* 0x20ec2 = "Intelligent Usb Dmx Interface SIUDI5C" */
    '\xe0','U','s','b',' ','D','m','x',' ','\x81',' ','S','I','U','D','I','5','C',
/* 0x20ed4 = "Intelligent Usb Dmx Interface SIUDI5A" */
    '\xe0','U','s','b',' ','D','m','x',' ','\x81',' ','S','I','U','D','I','5','A',
/* 0x20ee6 = "Luxya WC-1200 USB 2.0 Webcam" */
    'L','u','x','y','a',' ','W','C','-','1','2','0','0',' ','\x0a',' ','\xc1','\x11',
/* 0x20ef8 = "XEROX DocuMate 250" */
    'X','E','R','O','X',' ','D','o','c','u','M','a','t','e',' ','2','5','0',
/* 0x20f0a = "Scheidt & Bachmann" */
    'S','c','h','e','i','d','t',' ','&',' ','B','a','c','h','m','a','n','n',
/* 0x20f1c = "Rocksmith Guitar Adapter" */
    'R','o','c','k','s','m','i','t','h',' ','G','u','i','t','a','r',' ','\x02',
/* 0x20f2e = "ME-6000ISLE/16/DIO" */
    'M','E','-','6','0','0','0','I','S','L','E','/','1','6','/','D','I','O',
/* 0x20f40 = "Genius i-Look 1321" */
    'G','e','n','i','u','s',' ','i','-','L','o','o','k',' ','1','3','2','1',
/* 0x20f52 = "Japanese Keyboard - 600HM" */
    'J','a','p','a','n','e','s','e',' ','\x05',' ','-',' ','6','0','0','H','M',
/* 0x20f64 = "Freedom Scientific" */
    'F','r','e','e','d','o','m',' ','S','c','i','e','n','t','i','f','i','c',
/* 0x20f76 = "Dresden Elektronik" */
    'D','r','e','s','d','e','n',' ','E','l','e','k','t','r','o','n','i','k',
/* 0x20f88 = "Rapid Access III Keyboard" */
    'R','a','p','i','d',' ','A','c','c','e','s','s',' ','I','I','I',' ','\x05',
/* 0x20f9a = "Zolid HD DVD Maker" */
    'Z','o','l','i','d',' ','H','D',' ','D','V','D',' ','M','a','k','e','r',
/* 0x20fac = "Bluetooth 1.2 Interface [Broadcom BCM2035]" */
    '\x06',' ','1','.','2',' ','\x81',' ','[','\xeb','B','C','M','2','0','3','5',']',
/* 0x20fbe = "Quantec Networks GmbH" */
    'Q','u','a','n','t','e','c',' ','N','e','t','w','o','r','k','s',' ','\xfc',
/* 0x20fd0 = "RNDIS/BeWAN ADSL2+" */
    'R','N','D','I','S','/','B','e','W','A','N',' ','A','D','S','L','2','+',
/* 0x20fe2 = "Kunshan Guoji Electronics Co., Ltd." */
    'K','u','n','s','h','a','n',' ','G','u','o','j','i',' ','\x1b',' ','\x0e','\xab',
/* 0x20ff4 = "AV-836 Video Capture Device" */
    'A','V','-','8','3','6',' ','\xa3',' ','C','a','p','t','u','r','e',' ','\x03',
/* 0x21006 = "BioniQ 1001 Tablet" */
    'B','i','o','n','i','Q',' ','1','0','0','1',' ','T','a','b','l','e','t',
/* 0x21018 = "Softronics Pty., Ltd" */
    'S','o','f','t','r','o','n','i','c','s',' ','P','t','y','.',',',' ','\x16',
/* 0x2102a = "YM ELECTRIC CO., Ltd" */
    'Y','M',' ','E','L','E','C','T','R','I','C',' ','C','O','.',',',' ','\x16',
/* 0x2103c = "Xperia Pro [Mass Storage Class]" */
    'X','p','e','r','i','a',' ','\x8f',' ','[','\x7c','\x0f','C','l','a','s','s',']',
/* 0x2104e = "Hanwool Robotics Corp." */
    'H','a','n','w','o','o','l',' ','R','o','b','o','t','i','c','s',' ','\x10',
/* 0x21060 = "MFC-3340CN RemovableDisk" */
    '\x7d','3','3','4','0','C','N',' ','R','e','m','o','v','a','b','l','e','\xe8',
/* 0x21072 = "MeMO Pad HD 7 (PTP mode)" */
    'M','e','M','O',' ','\xfa',' ','H','D',' ','7',' ','(','P','T','P',' ','\x1a',
/* 0x21084 = "USB-Module for Spider8, CP32" */
    '\x0a','-','\xe5',' ','\xcc','S','p','i','d','e','r','8',',',' ','C','P','3','2',
/* 0x21096 = "3dfx HammerHead FX" */
    '3','d','f','x',' ','H','a','m','m','e','r','H','e','a','d',' ','F','X',
/* 0x210a8 = "PhidgetInterface Kit 0-0-4" */
    'P','h','i','d','g','e','t','\x81',' ','K','i','t',' ','0','-','0','-','4',
/* 0x210ba = "PC VGA Camera (Vesta Fun)" */
    '\x1f','V','G','A',' ','\x04',' ','(','V','e','s','t','a',' ','F','u','n',')',
/* 0x210cc = "Argosy Research, Inc." */
    'A','r','g','o','s','y',' ','R','e','s','e','a','r','c','h',',',' ','\x07',
/* 0x210de = "Serial Adapter [for Palm III]" */
    '\x90',' ','\x02',' ','[','f','o','r',' ','P','a','l','m',' ','I','I','I',']',
/* 0x210f0 = "LaserJet 400 color M451dn" */
    '\x82','\x80','4','0','0',' ','c','o','l','o','r',' ','M','4','5','1','d','n',
/* 0x21102 = "PCTV Dual DVB-T 2001e" */
    'P','C','T','V',' ','D','u','a','l',' ','\xa7','T',' ','2','0','0','1','e',
/* 0x21114 = "FlashGate CompactFlash Card Reader" */
    '\x3c','G','a','t','e',' ','C','o','m','p','a','c','t','\x3c',' ','\x15',' ','\x08',
/* 0x21126 = "Circuit Assembly Corp." */
    'C','i','r','c','u','i','t',' ','A','s','s','e','m','b','l','y',' ','\x10',
/* 0x21138 = "WinFast WalkieTV TV Loader" */
    'W','i','n','\xec','W','a','l','k','i','e','\xda','\xda','L','o','a','d','e','r',
/* 0x2114a = "Genius eFace 1325R" */
    'G','e','n','i','u','s',' ','e','F','a','c','e',' ','1','3','2','5','R',
/* 0x2115c = "TEW-444UB EU (no firmware)" */
    'T','E','W','-','4','4','4','U','B',' ','E','U',' ','(','n','o',' ','\xdb',
/* 0x2116e = "G11/G15 Keyboard / G keys" */
    'G','1','1','/','G','1','5',' ','\x05',' ','/',' ','G',' ','k','e','y','s',
/* 0x21180 = "SMA Technologie AG" */
    'S','M','A',' ','T','e','c','h','n','o','l','o','g','i','e',' ','A','G',
/* 0x21192 = "eToken R1 v3.2.3.x" */
    'e','T','o','k','e','n',' ','R','1',' ','v','3','.','2','.','3','.','x',
/* 0x211a4 = "GlobalMedia Group, LLC" */
    'G','l','o','b','a','l','\xa1',' ','G','r','o','u','p',',',' ','L','L','C',
/* 0x211b6 = "D50 digital camera" */
    'D','5','0',' ','d','i','g','i','t','a','l',' ','c','a','m','e','r','a',
/* 0x211c8 = "FotoShow Zip 250 Driver" */
    'F','o','t','o','S','h','o','w',' ','Z','i','p',' ','2','5','0',' ','\xde',
/* 0x211da = "eToken Pro 64k (4.2)" */
    'e','T','o','k','e','n',' ','\x8f',' ','6','4','k',' ','(','4','.','2',')',
/* 0x211ec = "Sansa e100 series (mtp)" */
    'S','a','n','s','a',' ','e','1','0','0',' ','\x1d',' ','(','m','t','p',')',
/* 0x211fe = "BCM2070 Bluetooth 3.0 + HS" */
    'B','C','M','2','0','7','0',' ','\x06',' ','3','.','0',' ','+',' ','H','S',
/* 0x21210 = "AME Optimedia Technology Co., Ltd" */
    'A','M','E',' ','O','p','t','i','m','e','d','i','a',' ','\x0d',' ','\x0e','\x16',
/* 0x21222 = "M-BA47 [MouseMan Plus]" */
    'M','-','B','A','4','7',' ','[','\x0b','M','a','n',' ','P','l','u','s',']',
/* 0x21234 = "Physik Instrumente" */
    'P','h','y','s','i','k',' ','I','n','s','t','r','u','m','e','n','t','e',
/* 0x21246 = "Initio Corporation" */
    'I','n','i','t','i','o',' ','C','o','r','p','o','r','a','t','i','o','n',
/* 0x21258 = "I2C/SPI Adapter - U2C-12" */
    'I','2','C','/','S','P','I',' ','\x02',' ','-',' ','U','2','C','-','1','2',
/* 0x2126a = "FreeAgent Desk 1TB" */
    'F','r','e','e','A','g','e','n','t',' ','D','e','s','k',' ','1','T','B',
/* 0x2127c = "Cordless Trackball" */
    'C','o','r','d','l','e','s','s',' ','T','r','a','c','k','b','a','l','l',
/* 0x2128e = "Laser Pro Monochrome MFP" */
    '\x82',' ','\x8f',' ','M','o','n','o','c','h','r','o','m','e',' ','M','F','P',
/* 0x212a0 = "Hirakawa Hewtech Corp." */
    'H','i','r','a','k','a','w','a',' ','H','e','w','t','e','c','h',' ','\x10',
/* 0x212b2 = "eHealth Keyboard G87 1504" */
    'e','H','e','a','l','t','h',' ','\x05',' ','G','8','7',' ','1','5','0','4',
/* 0x212c4 = "Ultimate 2 Android Phone L41C" */
    'U','l','t','i','m','a','t','e',' ','2',' ','\xce','\x19',' ','L','4','1','C',
/* 0x212d6 = "Surfboard 5121 Cable Modem" */
    'S','u','r','f','b','o','a','r','d',' ','5','1','2','1',' ','\xa5',' ','\x1c',
/* 0x212e8 = "Eumex 704PC LAN (FlashLoad)" */
    'E','u','m','e','x',' ','7','0','4','\x1f','\xf3','(','\x3c','L','o','a','d',')',
/* 0x212fa = "ZyAIR AG-225H v2 802.11bg" */
    'Z','y','A','I','R',' ','A','G','-','2','2','5','H',' ','v','2',' ','\xad',
/* 0x2130c = "Gigaset SX353 ISDN" */
    'G','i','g','a','s','e','t',' ','S','X','3','5','3',' ','I','S','D','N',
/* 0x2131e = "eToken R2 v2.4.4.x" */
    'e','T','o','k','e','n',' ','R','2',' ','v','2','.','4','.','4','.','x',
/* 0x21330 = "iR1510-1670 CAPT Printer" */
    'i','R','1','5','1','0','-','1','6','7','0',' ','C','A','P','T',' ','\x0c',
/* 0x21342 = "AGP LIN Serial Analyzer" */
    'A','G','P',' ','L','I','N',' ','\x90',' ','A','n','a','l','y','z','e','r',
/* 0x21354 = "PhidgetLED Ver 1.0" */
    'P','h','i','d','g','e','t','L','E','D',' ','V','e','r',' ','1','.','0',
/* 0x21366 = "Camera with CCD sensor [MD]" */
    '\x04',' ','\x98','C','C','D',' ','s','e','n','s','o','r',' ','[','M','D',']',
/* 0x21378 = "TVGo DVB-T03 [AF9015]" */
    'T','V','G','o',' ','\xa7','T','0','3',' ','[','A','F','9','0','1','5',']',
/* 0x2138a = "Precise Biometrics" */
    'P','r','e','c','i','s','e',' ','B','i','o','m','e','t','r','i','c','s',
/* 0x2139c = "KU-0418 Tactical Pad" */
    'K','U','-','0','4','1','8',' ','T','a','c','t','i','c','a','l',' ','\xfa',
/* 0x213ae = "Desire 610 Via MTP" */
    'D','e','s','i','r','e',' ','6','1','0',' ','V','i','a',' ','M','T','P',
/* 0x213c0 = "USB Wireless 2.4GHz Wheelpad" */
    '\x0a',' ','\x01','2','.','4','G','H','z',' ','W','h','e','e','l','p','a','d',
/* 0x213d2 = "SM PCCard R/W and SPD" */
    'S','M',' ','P','C','C','a','r','d',' ','R','/','W',' ','\xe4','S','P','D',
/* 0x213e4 = "MXI - Memory Experts International, Inc." */
    'M','X','I',' ','-',' ','\xd2',' ','E','x','p','e','r','t','s',' ','\xed','\x07',
/* 0x213f6 = "YST-M45D USB Speaker" */
    'Y','S','T','-','M','4','5','D',' ','\x0a',' ','S','p','e','a','k','e','r',
/* 0x21408 = "Wondereye CP-115 Webcam" */
    'W','o','n','d','e','r','e','y','e',' ','C','P','-','1','1','5',' ','\x11',
/* 0x2141a = "Cordless Presenter" */
    'C','o','r','d','l','e','s','s',' ','P','r','e','s','e','n','t','e','r',
/* 0x2142c = "CP210x to UART Bridge Controller" */
    'C','P','2','1','0','x',' ','t','o',' ','U','A','R','T',' ','\x9f',' ','\x13',
/* 0x2143e = "Comda Enterprise Corp." */
    'C','o','m','d','a',' ','E','n','t','e','r','p','r','i','s','e',' ','\x10',
/* 0x21450 = "GameBoy Color Emulator" */
    'G','a','m','e','B','o','y',' ','\xa2',' ','E','m','u','l','a','t','o','r',
/* 0x21462 = "Passport Reader PRM extension device" */
    '\xd5','\x08',' ','P','R','M',' ','e','x','t','e','n','s','i','o','n',' ','\xf9',
/* 0x21474 = "RCA Lyra RD1071 MP3 Player" */
    'R','C','A',' ','L','y','r','a',' ','R','D','1','0','7','1',' ','\x8e','\x1e',
/* 0x21486 = "NONIN MEDICAL INC." */
    'N','O','N','I','N',' ','M','E','D','I','C','A','L',' ','I','N','C','.',
/* 0x21498 = "Evertop Wire Cable Co." */
    'E','v','e','r','t','o','p',' ','W','i','r','e',' ','\xa5',' ','C','o','.',
/* 0x214aa = "Yubikey 4 OTP+CCID" */
    'Y','u','b','i','k','e','y',' ','4',' ','O','T','P','+','C','C','I','D',
/* 0x214bc = "WALKMAN [NWZ-E345]" */
    'W','A','L','K','M','A','N',' ','[','N','W','Z','-','E','3','4','5',']',
/* 0x214ce = "WL-113 rev 2 Wireless Network USB Adapter" */
    'W','L','-','1','1','3',' ','r','e','v',' ','2',' ','\x01','\x8d','\x0a',' ','\x02',
/* 0x214e0 = "Actiontec Electronics, Inc. [hex]" */
    'A','c','t','i','o','n','t','e','c',' ','\xf7','\x07',' ','[','h','e','x',']',
/* 0x214f2 = "PC Microscope camera" */
    '\x1f','M','i','c','r','o','s','c','o','p','e',' ','c','a','m','e','r','a',
/* 0x21504 = "BeWAN ADSL USB ST (grey)" */
    'B','e','W','A','N',' ','\xf1','\x0a',' ','S','T',' ','(','g','r','e','y',')',
/* 0x21516 = "SiS163U 802.11 Wireless LAN Adapter" */
    'S','i','S','1','6','3','U',' ','8','0','2','.','1','1',' ','\x01','\xf3','\x02',
/* 0x21528 = "deRFnode / gateway" */
    'd','e','R','F','n','o','d','e',' ','/',' ','g','a','t','e','w','a','y',
/* 0x2153a = "Bluetooth HCI MacBookPro (HID mode)" */
    '\x06',' ','H','C','I',' ','M','a','c','B','o','o','k','\x8f',' ','(','\xf2','\x1a',
/* 0x2154c = "MediaTV Pro III MiniPCIe (US)" */
    '\xa1','\xda','\x8f',' ','I','I','I',' ','\xb9','P','C','I','e',' ','(','U','S',')',
/* 0x2155e = "External CD-RW Drive Enclosure" */
    '\xe3','C','D','-','R','W',' ','\x14',' ','E','n','c','l','o','s','u','r','e',
/* 0x21570 = "Slim 2020AF camera" */
    'S','l','i','m',' ','2','0','2','0','A','F',' ','c','a','m','e','r','a',
/* 0x21582 = "SpaceBall 4000 FLX" */
    'S','p','a','c','e','B','a','l','l',' ','4','0','0','0',' ','F','L','X',
/* 0x21594 = "Nortel Networks, Ltd" */
    'N','o','r','t','e','l',' ','N','e','t','w','o','r','k','s',',',' ','\x16',
/* 0x215a6 = "Asus laptop camera" */
    'A','s','u','s',' ','l','a','p','t','o','p',' ','c','a','m','e','r','a',
/* 0x215b8 = "Traktor Kontrol S4" */
    'T','r','a','k','t','o','r',' ','K','o','n','t','r','o','l',' ','S','4',
/* 0x215ca = "V640i Phone [Mass Storage]" */
    'V','6','4','0','i',' ','\x19',' ','[','\x7c','S','t','o','r','a','g','e',']',
/* 0x215dc = "WR-G528e \'CHEETAH\'" */
    'W','R','-','G','5','2','8','e',' ','\'','C','H','E','E','T','A','H','\'',
/* 0x215ee = "eToken R1 v3.1.3.x" */
    'e','T','o','k','e','n',' ','R','1',' ','v','3','.','1','.','3','.','x',
/* 0x21600 = "Siemens Nixdorf AG" */
    'S','i','e','m','e','n','s',' ','N','i','x','d','o','r','f',' ','A','G',
/* 0x21612 = "ForceFeedbackWheel" */
    'F','o','r','c','e','F','e','e','d','b','a','c','k','W','h','e','e','l',
/* 0x21624 = "DMHS1B Rev 3 DFU Adapter" */
    'D','M','H','S','1','B',' ','R','e','v',' ','3',' ','D','F','U',' ','\x02',
/* 0x21636 = "Matrix Orbital USB Serial" */
    'M','a','t','r','i','x',' ','O','r','b','i','t','a','l',' ','\x0a',' ','\x90',
/* 0x21648 = "Zen Vision:M (mtp)" */
    'Z','e','n',' ','V','i','s','i','o','n',':','M',' ','(','m','t','p',')',
/* 0x2165a = "Desire HD (modem mode)" */
    'D','e','s','i','r','e',' ','H','D',' ','(','m','o','d','e','m',' ','\x1a',
/* 0x2166c = "SmartMedia+CompactFlash+MemoryStick Card Reader" */
    '\x12','\xa1','+','C','o','m','p','a','c','t','\x3c','+','\xd2','\xb3',' ','\x15',' ','\x08',
/* 0x2167e = "eXtreme Feedback Device" */
    'e','X','t','r','e','m','e',' ','F','e','e','d','b','a','c','k',' ','\x03',
/* 0x21690 = "Matrixlock Dongle (HID)" */
    'M','a','t','r','i','x','l','o','c','k',' ','\xf4',' ','(','H','I','D',')',
/* 0x216a2 = "Lumension Security" */
    'L','u','m','e','n','s','i','o','n',' ','S','e','c','u','r','i','t','y',
/* 0x216b4 = "Hub in Thunderbolt Display" */
    '\xa4',' ','i','n',' ','T','h','u','n','d','e','r','b','o','l','t',' ','\xcf',
/* 0x216c6 = "USB Wireless 2.4GHz Joystick" */
    '\x0a',' ','\x01','2','.','4','G','H','z',' ','J','o','y','s','t','i','c','k',
/* 0x216d8 = "Hitachi America, Ltd" */
    'H','i','t','a','c','h','i',' ','A','m','e','r','i','c','a',',',' ','\x16',
/* 0x216ea = "RSA SecurID ComboReader" */
    'R','S','A',' ','S','e','c','u','r','I','D',' ','C','o','m','b','o','\x08',
/* 0x216fc = "Denali Software, Inc." */
    'D','e','n','a','l','i',' ','S','o','f','t','w','a','r','e',',',' ','\x07',
/* 0x2170e = "Sorenson Vision, Inc." */
    'S','o','r','e','n','s','o','n',' ','V','i','s','i','o','n',',',' ','\x07',
/* 0x21720 = "6700 Classic (mtp)" */
    '6','7','0','0',' ','C','l','a','s','s','i','c',' ','(','m','t','p',')',
/* 0x21732 = "Maxtor M3 Portable" */
    'M','a','x','t','o','r',' ','M','3',' ','P','o','r','t','a','b','l','e',
/* 0x21744 = "AlienFX Mobile lighting" */
    'A','l','i','e','n','F','X',' ','\x96',' ','l','i','g','h','t','i','n','g',
/* 0x21756 = "C902 Phone [Mass Storage] " */
    'C','9','0','2',' ','\x19',' ','[','\x7c','S','t','o','r','a','g','e',']',' ',
/* 0x21768 = "Buttons and Lights HID device" */
    'B','u','t','t','o','n','s',' ','\xe4','L','i','g','h','t','s',' ','\xf2','\xf9',
/* 0x2177a = "WebCam Vista (VF0330)" */
    'W','e','b','\x9a','V','i','s','t','a',' ','(','V','F','0','3','3','0',')',
/* 0x2178c = "nissei 128DE-PNA -" */
    'n','i','s','s','e','i',' ','1','2','8','D','E','-','P','N','A',' ','-',
/* 0x2179e = "Gadmei UTV330 TV Box" */
    'G','a','d','m','e','i',' ','U','T','V','3','3','0',' ','\xda','B','o','x',
/* 0x217b0 = "Chicony TwinkleCam" */
    'C','h','i','c','o','n','y',' ','T','w','i','n','k','l','e','C','a','m',
/* 0x217c2 = "Peracom Remote NDIS Ethernet Adapter" */
    'P','e','r','a','c','o','m',' ','\xcb',' ','N','D','I','S',' ','\x7f',' ','\x02',
/* 0x217d4 = "Trust Wireless Optical Mouse MI-4150K" */
    'T','r','u','s','t',' ','\x01','\x7b','\x0b',' ','M','I','-','4','1','5','0','K',
/* 0x217e6 = "LI-3100 Area Meter" */
    'L','I','-','3','1','0','0',' ','A','r','e','a',' ','M','e','t','e','r',
/* 0x217f8 = "Xbox360 Bluetooth Wireless Headset" */
    'X','b','o','x','3','6','0',' ','\x06',' ','\x01','H','e','a','d','s','e','t',
/* 0x2180a = "V5 camera [R5U870]" */
    'V','5',' ','c','a','m','e','r','a',' ','[','R','5','U','8','7','0',']',
/* 0x2181c = "raphnet.net DB9Joy" */
    'r','a','p','h','n','e','t','.','n','e','t',' ','D','B','9','J','o','y',
/* 0x2182e = "Wireless IntelliMouse Explorer" */
    '\x01','I','n','t','e','l','l','i','\x0b',' ','E','x','p','l','o','r','e','r',
/* 0x21840 = "OpenCom 30 (FlashLoad)" */
    'O','p','e','n','C','o','m',' ','3','0',' ','(','\x3c','L','o','a','d',')',
/* 0x21852 = "Concept Telecom, Ltd" */
    'C','o','n','c','e','p','t',' ','T','e','l','e','c','o','m',',',' ','\x16',
/* 0x21864 = "Chromatic Research" */
    'C','h','r','o','m','a','t','i','c',' ','R','e','s','e','a','r','c','h',
/* 0x21876 = "ThinkPad 800dpi Optical Travel Mouse" */
    'T','h','i','n','k','\xfa',' ','8','0','0','d','p','i',' ','\x7b','\xd9',' ','\x0b',
/* 0x21888 = "iPod Shuffle 2.Gen" */
    'i','P','o','d',' ','S','h','u','f','f','l','e',' ','2','.','G','e','n',
/* 0x2189a = "Marantz RC9001 Remote Control" */
    'M','a','r','a','n','t','z',' ','R','C','9','0','0','1',' ','\xcb',' ','\xc9',
/* 0x218ac = "Stonestreet One, Inc." */
    'S','t','o','n','e','s','t','r','e','e','t',' ','O','n','e',',',' ','\x07',
/* 0x218be = "Air2210 54 Mbps Wireless Adapter" */
    'A','i','r','2','2','1','0',' ','5','4',' ','M','b','p','s',' ','\x01','\x02',
/* 0x218d0 = "Teensyduino RawHID" */
    'T','e','e','n','s','y','d','u','i','n','o',' ','R','a','w','H','I','D',
/* 0x218e2 = "ADU208 Relay I/O Interface" */
    'A','D','U','2','0','8',' ','R','e','l','a','y',' ','I','/','O',' ','\x81',
/* 0x218f4 = "Bowe Bell & Howell" */
    'B','o','w','e',' ','B','e','l','l',' ','&',' ','H','o','w','e','l','l',
/* 0x21906 = "Acer/Sweex Flash drive" */
    'A','c','e','r','/','S','w','e','e','x',' ','\x3c',' ','d','r','i','v','e',
/* 0x21918 = "My Passport Ultra (WDBZFP)" */
    'M','y',' ','\xd5','U','l','t','r','a',' ','(','W','D','B','Z','F','P',')',
/* 0x2192a = "Serial & Parallel Ports" */
    '\x90',' ','&',' ','P','a','r','a','l','l','e','l',' ','P','o','r','t','s',
/* 0x2193c = "FUSB200 mp3 player" */
    'F','U','S','B','2','0','0',' ','m','p','3',' ','p','l','a','y','e','r',
/* 0x2194e = "LCD and Temperature Interface" */
    'L','C','D',' ','\xe4','T','e','m','p','e','r','a','t','u','r','e',' ','\x81',
/* 0x21960 = "Sansa E200 Series (msc)" */
    'S','a','n','s','a',' ','E','2','0','0',' ','\xbf',' ','(','m','s','c',')',
/* 0x21972 = "Soundcraft Si Multi Digital Card" */
    'S','o','u','n','d','c','r','a','f','t',' ','S','i',' ','\xd6',' ','\x09','\x15',
/* 0x21984 = "PX-B750F/WP-4525 Series" */
    'P','X','-','B','7','5','0','F','/','W','P','-','4','5','2','5',' ','\xbf',
/* 0x21996 = "Hauppauge WinTV Pro (PAL/SECAM)" */
    '\xfb','W','i','n','\xda','\x8f',' ','(','P','A','L','/','S','E','C','A','M',')',
/* 0x219a8 = "CM106 Like Sound Device" */
    'C','M','1','0','6',' ','L','i','k','e',' ','S','o','u','n','d',' ','\x03',
/* 0x219ba = "DigiLife DDV-5120A" */
    'D','i','g','i','L','i','f','e',' ','D','D','V','-','5','1','2','0','A',
/* 0x219cc = "DigimapSP USB (cold)" */
    'D','i','g','i','m','a','p','S','P',' ','\x0a',' ','(','c','o','l','d',')',
/* 0x219de = "OpenCom 45 (FlashLoad)" */
    'O','p','e','n','C','o','m',' ','4','5',' ','(','\x3c','L','o','a','d',')',
/* 0x219f0 = "Allion Computer, Inc." */
    'A','l','l','i','o','n',' ','C','o','m','p','u','t','e','r',',',' ','\x07',
/* 0x21a02 = "Infinity CryptoKey" */
    'I','n','f','i','n','i','t','y',' ','C','r','y','p','t','o','K','e','y',
/* 0x21a14 = "Dazzle EmMe (2001)" */
    'D','a','z','z','l','e',' ','E','m','M','e',' ','(','2','0','0','1',')',
/* 0x21a26 = "cyberJack e-com(a)" */
    'c','y','b','e','r','J','a','c','k',' ','e','-','c','o','m','(','a',')',
/* 0x21a38 = "DT110P/1GB Capless" */
    'D','T','1','1','0','P','/','1','G','B',' ','C','a','p','l','e','s','s',
/* 0x21a4a = "MA-730/MA-730G Bluetooth Adapter" */
    'M','A','-','7','3','0','/','M','A','-','7','3','0','G',' ','\x06',' ','\x02',
/* 0x21a5c = "My Passport Ultra (WDBBUZ)" */
    'M','y',' ','\xd5','U','l','t','r','a',' ','(','W','D','B','B','U','Z',')',
/* 0x21a6e = "Seatay ATA/ATAPI Bridge" */
    'S','e','a','t','a','y',' ','A','T','A','/','A','T','A','P','I',' ','\x9f',
/* 0x21a80 = "Wireless Optical Mouse (IntelliPoint)" */
    '\x01','\x7b','\x0b',' ','(','I','n','t','e','l','l','i','P','o','i','n','t',')',
/* 0x21a92 = "UM-4/MPU-64 MIDI Interface" */
    'U','M','-','4','/','M','P','U','-','6','4',' ','M','I','D','I',' ','\x81',
/* 0x21aa4 = "802.11b/g Turbo Wireless Adapter" */
    '8','0','2','.','1','1','b','/','g',' ','T','u','r','b','o',' ','\x01','\x02',
/* 0x21ab6 = "Yubikey (v1 or v2)" */
    'Y','u','b','i','k','e','y',' ','(','v','1',' ','o','r',' ','v','2',')',
/* 0x21ac8 = "Resistive Touch Screen" */
    'R','e','s','i','s','t','i','v','e',' ','\x9d',' ','S','c','r','e','e','n',
/* 0x21ada = "SideWinder GamePad Pro" */
    'S','i','d','e','W','i','n','d','e','r',' ','G','a','m','e','\xfa',' ','\x8f',
/* 0x21aec = "ACT-IR2000U IrDA Dongle" */
    'A','C','T','-','I','R','2','0','0','0','U',' ','I','r','D','A',' ','\xf4',
/* 0x21afe = "Elements Portable (WDBU6Y)" */
    'E','l','e','m','e','n','t','s',' ','\xa9','(','W','D','B','U','6','Y',')',
/* 0x21b10 = "Questra Consulting" */
    'Q','u','e','s','t','r','a',' ','C','o','n','s','u','l','t','i','n','g',
/* 0x21b22 = "Iwatsu Electric Co., Ltd" */
    'I','w','a','t','s','u',' ','E','l','e','c','t','r','i','c',' ','\x0e','\x16',
/* 0x21b34 = "Sierra Wireless, Inc." */
    'S','i','e','r','r','a',' ','W','i','r','e','l','e','s','s',',',' ','\x07',
/* 0x21b46 = "BT Voyager 1010 802.11b Adapter" */
    'B','T',' ','V','o','y','a','g','e','r',' ','1','0','1','0',' ','\x9b','\x02',
/* 0x21b58 = "USB 2.0 Hub (Avocent KVM)" */
    '\x0a',' ','\xc1','\xa4',' ','(','A','v','o','c','e','n','t',' ','K','V','M',')',
/* 0x21b6a = "eToken R2 v2.2.4.x" */
    'e','T','o','k','e','n',' ','R','2',' ','v','2','.','2','.','4','.','x',
/* 0x21b7c = "Expert Mouse Trackball" */
    'E','x','p','e','r','t',' ','\x0b',' ','T','r','a','c','k','b','a','l','l',
/* 0x21b8e = "iPod Mini 1.Gen/2.Gen" */
    'i','P','o','d',' ','\xb9',' ','1','.','G','e','n','/','2','.','G','e','n',
/* 0x21ba0 = "Ideos (tethering mode)" */
    'I','d','e','o','s',' ','(','t','e','t','h','e','r','i','n','g',' ','\x1a',
/* 0x21bb2 = "Focusrite-Novation" */
    'F','o','c','u','s','r','i','t','e','-','N','o','v','a','t','i','o','n',
/* 0x21bc4 = "LG G2x MTP (debug)" */
    'L','G',' ','G','2','x',' ','M','T','P',' ','(','d','e','b','u','g',')',
/* 0x21bd6 = "Raritan KVM dongle" */
    'R','a','r','i','t','a','n',' ','K','V','M',' ','d','o','n','g','l','e',
/* 0x21be8 = "Sunrise Telecom, Inc." */
    'S','u','n','r','i','s','e',' ','T','e','l','e','c','o','m',',',' ','\x07',
/* 0x21bfa = "Sansa M200 series (mtp)" */
    'S','a','n','s','a',' ','M','2','0','0',' ','\x1d',' ','(','m','t','p',')',
/* 0x21c0c = "Foxlink Image Technology Co., Ltd" */
    'F','o','x','l','i','n','k',' ','I','m','a','g','e',' ','\x0d',' ','\x0e','\x16',
/* 0x21c1e = "M-Audio Keystation 88es" */
    'M','-','\x8b','K','e','y','s','t','a','t','i','o','n',' ','8','8','e','s',
/* 0x21c30 = "AM10 v1 802.11n [Ralink RT3072]" */
    'A','M','1','0',' ','v','1',' ','\x99','[','\x93','R','T','3','0','7','2',']',
/* 0x21c42 = "NuConnex Technologies Pte., Ltd" */
    'N','u','C','o','n','n','e','x',' ','\x88',' ','P','t','e','.',',',' ','\x16',
/* 0x21c54 = "Native Instruments" */
    'N','a','t','i','v','e',' ','I','n','s','t','r','u','m','e','n','t','s',
/* 0x21c66 = "designjet 30/130 series" */
    'd','e','s','i','g','n','j','e','t',' ','3','0','/','1','3','0',' ','\x1d',
/* 0x21c78 = "TrackerPod Camera Stand" */
    'T','r','a','c','k','e','r','P','o','d',' ','\x04',' ','S','t','a','n','d',
/* 0x21c8a = "Hi-Speed USB-IDE Bridge Controller" */
    'H','i','-','S','p','e','e','d',' ','\x0a','-','I','D','E',' ','\x9f',' ','\x13',
/* 0x21c9c = "SpYder USBSPYDER08" */
    'S','p','Y','d','e','r',' ','U','S','B','S','P','Y','D','E','R','0','8',
/* 0x21cae = "Arlec Australia, Ltd" */
    'A','r','l','e','c',' ','A','u','s','t','r','a','l','i','a',',',' ','\x16',
/* 0x21cc0 = "BT-183 Bluetooth 2.0+EDR adapter" */
    'B','T','-','1','8','3',' ','\x06',' ','2','.','0','+','E','D','R',' ','\xd0',
/* 0x21cd2 = "MX610 Laser Cordless Mouse" */
    'M','X','6','1','0',' ','\x82',' ','C','o','r','d','l','e','s','s',' ','\x0b',
/* 0x21ce4 = "Develco Elektronik" */
    'D','e','v','e','l','c','o',' ','E','l','e','k','t','r','o','n','i','k',
/* 0x21cf6 = "IMPRES Battery Data Reader" */
    'I','M','P','R','E','S',' ','B','a','t','t','e','r','y',' ','\xe7',' ','\x08',
/* 0x21d08 = "Digital Photo Frame Mini Monitor" */
    '\x09','\x86',' ','F','r','a','m','e',' ','\xb9',' ','M','o','n','i','t','o','r',
/* 0x21d1a = "EZX GSM Phone (USBLAN)" */
    'E','Z','X',' ','G','S','M',' ','\x19',' ','(','U','S','B','L','A','N',')',
/* 0x21d2c = "Cruzer Contour Flash Drive" */
    'C','r','u','z','e','r',' ','C','o','n','t','o','u','r',' ','\x3c',' ','\x14',
/* 0x21d3e = "Mars Engineering Corp." */
    'M','a','r','s',' ','E','n','g','i','n','e','e','r','i','n','g',' ','\x10',
/* 0x21d50 = "Cummins Engine Co." */
    'C','u','m','m','i','n','s',' ','E','n','g','i','n','e',' ','C','o','.',
/* 0x21d62 = "Cruzer Micro 256MB Flash Drive" */
    'C','r','u','z','e','r',' ','\xc4',' ','2','5','6','M','B',' ','\x3c',' ','\x14',
/* 0x21d74 = "Leica Microsystems" */
    'L','e','i','c','a',' ','M','i','c','r','o','s','y','s','t','e','m','s',
/* 0x21d86 = "Xerox DocuMate 262" */
    'X','e','r','o','x',' ','D','o','c','u','M','a','t','e',' ','2','6','2',
/* 0x21d98 = "Flight System G940" */
    'F','l','i','g','h','t',' ','S','y','s','t','e','m',' ','G','9','4','0',
/* 0x21daa = "Freecom HD Classic" */
    'F','r','e','e','c','o','m',' ','H','D',' ','C','l','a','s','s','i','c',
/* 0x21dbc = "airpanel V150 Wireless Smart Display" */
    'a','i','r','p','a','n','e','l',' ','V','1','5','0',' ','\x01','\x12',' ','\xcf',
/* 0x21dce = "XEROX DocuMate 520" */
    'X','E','R','O','X',' ','D','o','c','u','M','a','t','e',' ','5','2','0',
/* 0x21de0 = "CC-550L [1000 ICS]" */
    'C','C','-','5','5','0','L',' ','[','1','0','0','0',' ','I','C','S',']',
/* 0x21df2 = "Pirelli Broadband Solutions" */
    'P','i','r','e','l','l','i',' ','\xb7','S','o','l','u','t','i','o','n','s',
/* 0x21e04 = "Wireless adapter for Bamboo tablets" */
    '\x01','\xd0',' ','\xcc','B','a','m','b','o','o',' ','t','a','b','l','e','t','s',
/* 0x21e16 = "USB-100N Ethernet [pegasus]" */
    '\x0a','-','1','0','0','N',' ','\x7f',' ','[','p','e','g','a','s','u','s',']',
/* 0x21e28 = "VideoBus II Adapter, Video" */
    '\xa3','B','u','s',' ','I','I',' ','A','d','a','p','t','e','r',',',' ','\xa3',
/* 0x21e3a = "Thymio-II Wireless" */
    'T','h','y','m','i','o','-','I','I',' ','W','i','r','e','l','e','s','s',
/* 0x21e4c = "UF100 Ethernet [pegasus2]" */
    'U','F','1','0','0',' ','\x7f',' ','[','p','e','g','a','s','u','s','2',']',
/* 0x21e5e = "Spirotel converter" */
    'S','p','i','r','o','t','e','l',' ','c','o','n','v','e','r','t','e','r',
/* 0x21e70 = "Delcom Engineering" */
    'D','e','l','c','o','m',' ','E','n','g','i','n','e','e','r','i','n','g',
/* 0x21e82 = "NWZ-A726/A728/A729" */
    'N','W','Z','-','A','7','2','6','/','A','7','2','8','/','A','7','2','9',
/* 0x21e94 = "WinFast TV - PAL BG + FM" */
    'W','i','n','\xec','\xda','-',' ','P','A','L',' ','B','G',' ','+',' ','F','M',
/* 0x21ea6 = "Cruzer Micro 128MB Flash Drive" */
    'C','r','u','z','e','r',' ','\xc4',' ','1','2','8','M','B',' ','\x3c',' ','\x14',
/* 0x21eb8 = "Series 3xxx Cash Drawer" */
    '\xbf',' ','3','x','x','x',' ','C','a','s','h',' ','D','r','a','w','e','r',
/* 0x21eca = "Claritel-i750 - vp" */
    'C','l','a','r','i','t','e','l','-','i','7','5','0',' ','-',' ','v','p',
/* 0x21edc = "X-Rite Pantone Color Sensor" */
    'X','-','R','i','t','e',' ','P','a','n','t','o','n','e',' ','\xa2',' ','\xac',
/* 0x21eee = "USB2-IDE/ATAPI Bridge Adapter" */
    'U','S','B','2','-','I','D','E','/','A','T','A','P','I',' ','\x9f',' ','\x02',
/* 0x21f00 = "Mega ADK (CDC ACM)" */
    'M','e','g','a',' ','A','D','K',' ','(','C','D','C',' ','A','C','M',')',
/* 0x21f12 = "MFC-610CLN RemovableDisk" */
    '\x7d','6','1','0','C','L','N',' ','R','e','m','o','v','a','b','l','e','\xe8',
/* 0x21f24 = "Expansion Portable" */
    'E','x','p','a','n','s','i','o','n',' ','P','o','r','t','a','b','l','e',
/* 0x21f36 = "Drum Kit for Xbox 360" */
    'D','r','u','m',' ','K','i','t',' ','\xcc','X','b','o','x',' ','3','6','0',
/* 0x21f48 = "Bluetooth Mouse M336/M337/M535" */
    '\x06',' ','\x0b',' ','M','3','3','6','/','M','3','3','7','/','M','5','3','5',
/* 0x21f5a = "PC-OP-RS1 RemoteStation" */
    'P','C','-','O','P','-','R','S','1',' ','\xcb','S','t','a','t','i','o','n',
/* 0x21f6c = "Nexus One (tether)" */
    'N','e','x','u','s',' ','O','n','e',' ','(','t','e','t','h','e','r',')',
/* 0x21f7e = "SA2111/02 1GB Flash Audio Player" */
    'S','A','2','1','1','1','/','0','2',' ','1','G','B',' ','\x3c',' ','\x8b','\x1e',
/* 0x21f90 = "EasyShare CX4230 Camera" */
    'E','a','s','y','S','h','a','r','e',' ','C','X','4','2','3','0',' ','\x04',
/* 0x21fa2 = "Gem e-Seal Pro Token" */
    'G','e','m',' ','e','-','S','e','a','l',' ','\x8f',' ','T','o','k','e','n',
/* 0x21fb4 = "POS Printer, TH230" */
    'P','O','S',' ','P','r','i','n','t','e','r',',',' ','T','H','2','3','0',
/* 0x21fc6 = "USB200M 10/100 Ethernet Adapter" */
    'U','S','B','2','0','0','M',' ','1','0','/','1','0','0',' ','\x7f',' ','\x02',
/* 0x21fd8 = "Yubikey 4 U2F+CCID" */
    'Y','u','b','i','k','e','y',' ','4',' ','U','2','F','+','C','C','I','D',
/* 0x21fea = "eToken R1 v3.4.3.x" */
    'e','T','o','k','e','n',' ','R','1',' ','v','3','.','4','.','3','.','x',
/* 0x21ffc = "Network Everywhere NWU11B" */
    '\x8d','E','v','e','r','y','w','h','e','r','e',' ','N','W','U','1','1','B',
/* 0x2200e = "DigimapSP USB (warm)" */
    'D','i','g','i','m','a','p','S','P',' ','\x0a',' ','(','w','a','r','m',')',
/* 0x22020 = "Niigata Canotec Co., Inc." */
    'N','i','i','g','a','t','a',' ','C','a','n','o','t','e','c',' ','\x0e','\x07',
/* 0x22032 = "to CF/SM/SD/MS Card Reader" */
    't','o',' ','C','F','/','S','M','/','S','D','/','M','S',' ','\x15',' ','\x08',
/* 0x22044 = "NUB100 Ethernet [pegasus]" */
    'N','U','B','1','0','0',' ','\x7f',' ','[','p','e','g','a','s','u','s',']',
/* 0x22056 = "PicoScope3000 series PC Oscilloscope" */
    'P','i','c','o','S','c','o','p','e','3','0','0','0',' ','\x1d',' ','\x1f','\xfe',
/* 0x22068 = "Data capturing system" */
    '\xe7',' ','c','a','p','t','u','r','i','n','g',' ','s','y','s','t','e','m',
/* 0x2207a = "Expert Magnetics Corp." */
    'E','x','p','e','r','t',' ','M','a','g','n','e','t','i','c','s',' ','\x10',
/* 0x2208c = "Droid X (Mass storage)" */
    'D','r','o','i','d',' ','X',' ','(','\x7c','s','t','o','r','a','g','e',')',
/* 0x2209e = "Multivideo Labs, Inc." */
    'M','u','l','t','i','v','i','d','e','o',' ','L','a','b','s',',',' ','\x07',
/* 0x220b0 = "EADS Airbus France" */
    'E','A','D','S',' ','A','i','r','b','u','s',' ','F','r','a','n','c','e',
/* 0x220c2 = "DataTraveler II Pen Drive" */
    '\xe7','T','r','a','v','e','l','e','r',' ','I','I',' ','P','e','n',' ','\x14',
/* 0x220d4 = "9300 GSM Smartphone (RNDIS)" */
    '9','3','0','0',' ','G','S','M',' ','\xd4',' ','(','R','N','D','I','S',')',
/* 0x220e6 = "ACR1283 Bootloader" */
    'A','C','R','1','2','8','3',' ','B','o','o','t','l','o','a','d','e','r',
/* 0x220f8 = "Toshiba Electronics Taiwan Corp." */
    'T','o','s','h','i','b','a',' ','\x1b',' ','T','a','i','w','a','n',' ','\x10',
/* 0x2210a = "TT1280DA DVB-T TV Tuner" */
    'T','T','1','2','8','0','D','A',' ','\xa7','T',' ','\xda','T','u','n','e','r',
/* 0x2211c = "GT-1500 [GT-D1000]" */
    'G','T','-','1','5','0','0',' ','[','G','T','-','D','1','0','0','0',']',
/* 0x2212e = "Raptor Gaming Keyboard Integrated Hub" */
    'R','a','p','t','o','r',' ','G','a','m','i','n','g',' ','\x05',' ','\x18','\xa4',
/* 0x22140 = "SiLabs Cypress EVB" */
    'S','i','L','a','b','s',' ','C','y','p','r','e','s','s',' ','E','V','B',
/* 0x22152 = "USB Pro (24/96 record)" */
    '\x0a',' ','\x8f',' ','(','2','4','/','9','6',' ','r','e','c','o','r','d',')',
/* 0x22164 = "SyncMaster HID Monitor Control" */
    '\x91','M','a','s','t','e','r',' ','\xf2','M','o','n','i','t','o','r',' ','\xc9',
/* 0x22176 = "Elura 50 (normal mode)" */
    'E','l','u','r','a',' ','5','0',' ','(','n','o','r','m','a','l',' ','\x1a',
/* 0x22188 = "Xerox DocuMate 510" */
    'X','e','r','o','x',' ','D','o','c','u','M','a','t','e',' ','5','1','0',
/* 0x2219a = "SuperScript 1400 Series" */
    'S','u','p','e','r','S','c','r','i','p','t',' ','1','4','0','0',' ','\xbf',
/* 0x221ac = "SMSC9512/9514 Fast Ethernet Adapter" */
    'S','M','S','C','9','5','1','2','/','9','5','1','4',' ','\xec','\x7f',' ','\x02',
/* 0x221be = "Trackball Explorer" */
    'T','r','a','c','k','b','a','l','l',' ','E','x','p','l','o','r','e','r',
/* 0x221d0 = "Gadmei UTV380 TV Box" */
    'G','a','d','m','e','i',' ','U','T','V','3','8','0',' ','\xda','B','o','x',
/* 0x221e2 = "Saturn (Joystick mode)" */
    'S','a','t','u','r','n',' ','(','J','o','y','s','t','i','c','k',' ','\x1a',
/* 0x221f4 = "Prox\'N\'Roll RFID Scanner" */
    'P','r','o','x','\'','N','\'','R','o','l','l',' ','R','F','I','D',' ','\x25',
/* 0x22206 = "ADU200 Relay I/O Interface" */
    'A','D','U','2','0','0',' ','R','e','l','a','y',' ','I','/','O',' ','\x81',
/* 0x22218 = "LP-M5500/LP-M5500F" */
    'L','P','-','M','5','5','0','0','/','L','P','-','M','5','5','0','0','F',
/* 0x2222a = "Kreton Corporation" */
    'K','r','e','t','o','n',' ','C','o','r','p','o','r','a','t','i','o','n',
/* 0x2223c = "Traktor Kontrol X1" */
    'T','r','a','k','t','o','r',' ','K','o','n','t','r','o','l',' ','X','1',
/* 0x2224e = "Onext EG210U MODEM" */
    'O','n','e','x','t',' ','E','G','2','1','0','U',' ','M','O','D','E','M',
/* 0x22260 = "AR3012 Bluetooth 4.0 (no firmware)" */
    'A','R','3','0','1','2',' ','\x06',' ','4','.','0',' ','(','n','o',' ','\xdb',
/* 0x22272 = "Uniden Corporation" */
    'U','n','i','d','e','n',' ','C','o','r','p','o','r','a','t','i','o','n',
/* 0x22284 = "V630i Phone [Mass Storage]" */
    'V','6','3','0','i',' ','\x19',' ','[','\x7c','S','t','o','r','a','g','e',']',
/* 0x22296 = "iPod Shuffle 4.Gen" */
    'i','P','o','d',' ','S','h','u','f','f','l','e',' ','4','.','G','e','n',
/* 0x222a8 = "Cameo Grabster 200" */
    'C','a','m','e','o',' ','G','r','a','b','s','t','e','r',' ','2','0','0',
/* 0x222ba = "SCP-4900 Cellphone" */
    'S','C','P','-','4','9','0','0',' ','C','e','l','l','p','h','o','n','e',
/* 0x222cc = "TSP100ECO/TSP100II" */
    'T','S','P','1','0','0','E','C','O','/','T','S','P','1','0','0','I','I',
/* 0x222de = "360 Modena Pro Wheel" */
    '3','6','0',' ','M','o','d','e','n','a',' ','\x8f',' ','W','h','e','e','l',
/* 0x222f0 = "Infinity Unlimited" */
    'I','n','f','i','n','i','t','y',' ','U','n','l','i','m','i','t','e','d',
/* 0x22302 = "DAQPad-6020E (BNC)" */
    'D','A','Q','P','a','d','-','6','0','2','0','E',' ','(','B','N','C',')',
/* 0x22314 = "PFU-65 Keyboard [Chicony]" */
    'P','F','U','-','6','5',' ','\x05',' ','[','C','h','i','c','o','n','y',']',
/* 0x22326 = "Meade Binoculars/Camera" */
    'M','e','a','d','e',' ','B','i','n','o','c','u','l','a','r','s','/','\x04',
/* 0x22338 = "Vehicle Explorer Interface" */
    'V','e','h','i','c','l','e',' ','E','x','p','l','o','r','e','r',' ','\x81',
/* 0x2234a = "PCX1100U Cable Modem (WDM)" */
    'P','C','X','1','1','0','0','U',' ','\xa5',' ','\x1c',' ','(','W','D','M',')',
/* 0x2235c = "Guardant Stealth 2" */
    'G','u','a','r','d','a','n','t',' ','S','t','e','a','l','t','h',' ','2',
/* 0x2236e = "Elements Portable (WDBUZG)" */
    'E','l','e','m','e','n','t','s',' ','\xa9','(','W','D','B','U','Z','G',')',
/* 0x22380 = "Mimi WiFi speakers" */
    'M','i','m','i',' ','W','i','F','i',' ','s','p','e','a','k','e','r','s',
/* 0x22392 = "Anysee E30 USB 2.0 DVB-T Receiver" */
    'A','n','y','s','e','e',' ','E','3','0',' ','\x0a',' ','\xc1','\xa7','T',' ','\x8c',
/* 0x223a4 = "WL-113 rev 1 Wireless Network USB Adapter" */
    'W','L','-','1','1','3',' ','r','e','v',' ','1',' ','\x01','\x8d','\x0a',' ','\x02',
/* 0x223b6 = "eToken R2 v2.5.4.x" */
    'e','T','o','k','e','n',' ','R','2',' ','v','2','.','5','.','4','.','x',
/* 0x223c8 = "Intelligent Usb Dmx Interface SIUDI6A" */
    '\xe0','U','s','b',' ','D','m','x',' ','\x81',' ','S','I','U','D','I','6','A',
/* 0x223da = "Intelligent Usb Dmx Interface SIUDI6C" */
    '\xe0','U','s','b',' ','D','m','x',' ','\x81',' ','S','I','U','D','I','6','C',
/* 0x223ec = "Intelligent Usb Dmx Interface SIUDI6D" */
    '\xe0','U','s','b',' ','D','m','x',' ','\x81',' ','S','I','U','D','I','6','D',
/* 0X223fe = "DWL-G132 [Atheros AR5523]" */
    'W','L','-','G','1','3','2',' ','[','\xaf','A','R','5','5','2','3',']',
/* 0x2240f = "JUIX chipset flash" */
    'J','U','I','X',' ','c','h','i','p','s','e','t',' ','f','l','a','s','h',
/* 0x22421 = "OpenCom 40 [FlashLoad]" */
    'O','p','e','n','C','o','m',' ','4','0',' ','[','\x3c','L','o','a','d',']',
/* 0x22433 = "AU9540 Smartcard Reader" */
    'A','U','9','5','4','0',' ','S','m','a','r','t','c','a','r','d',' ','\x08',
/* 0x22445 = "Magstripe Insert Reader" */
    'M','a','g','s','t','r','i','p','e',' ','I','n','s','e','r','t',' ','\x08',
/* 0x22457 = "Airflo EX Joystick" */
    'A','i','r','f','l','o',' ','E','X',' ','J','o','y','s','t','i','c','k',
/* 0x22469 = "P880 / Charge only" */
    'P','8','8','0',' ','/',' ','C','h','a','r','g','e',' ','o','n','l','y',
/* 0x2247b = "6700 Classic (msc)" */
    '6','7','0','0',' ','C','l','a','s','s','i','c',' ','(','m','s','c',')',
/* 0x2248d = "Harmony 900/1100 Remote" */
    'H','a','r','m','o','n','y',' ','9','0','0','/','1','1','0','0',' ','\xcb',
/* 0x2249f = "Aluminum Mini Keyboard (ISO)" */
    'A','l','u','m','i','n','u','m',' ','\xb9',' ','\x05',' ','(','I','S','O',')',
/* 0x224b1 = "MT9234ZBA-USB MultiModem ZBA" */
    'M','T','9','2','3','4','Z','B','A','-','\x0a',' ','\xd6','\x1c',' ','Z','B','A',
/* 0x224c3 = "airpanel V110 Wireless Smart Display" */
    'a','i','r','p','a','n','e','l',' ','V','1','1','0',' ','\x01','\x12',' ','\xcf',
/* 0x224d5 = "Bvtech Industry, Inc." */
    'B','v','t','e','c','h',' ','I','n','d','u','s','t','r','y',',',' ','\x07',
/* 0x224e7 = "ActiveJet K-2024 Multimedia Keyboard" */
    'A','c','t','i','v','e','\x80','K','-','2','0','2','4',' ','\xe2',' ','\x05',
/* 0x224f8 = "ISD-V4 Tablet Pen" */
    'I','S','D','-','V','4',' ','T','a','b','l','e','t',' ','P','e','n',
/* 0x22509 = "AOL Photocam Plus" */
    'A','O','L',' ','P','h','o','t','o','c','a','m',' ','P','l','u','s',
/* 0x2251a = "UBS-10BT Ethernet [klsi]" */
    'U','B','S','-','1','0','B','T',' ','\x7f',' ','[','k','l','s','i',']',
/* 0x2252b = "Gobi 3000 HSPA+ Modem" */
    'G','o','b','i',' ','3','0','0','0',' ','H','S','P','A','+',' ','\x1c',
/* 0x2253c = "Arrow Strong Electronics Co., Ltd" */
    'A','r','r','o','w',' ','S','t','r','o','n','g',' ','\x1b',' ','\x0e','\x16',
/* 0x2254d = "Digipass 905 SmartCard Reader" */
    'D','i','g','i','p','a','s','s',' ','9','0','5',' ','\x12','\x15',' ','\x08',
/* 0x2255e = "Hyundai Electronics America" */
    'H','y','u','n','d','a','i',' ','\x1b',' ','A','m','e','r','i','c','a',
/* 0x2256f = "USA-19hs serial adapter" */
    'U','S','A','-','1','9','h','s',' ','s','e','r','i','a','l',' ','\xd0',
/* 0x22580 = "Keystation Pro 88 Driver" */
    'K','e','y','s','t','a','t','i','o','n',' ','\x8f',' ','8','8',' ','\xde',
/* 0x22591 = "Slim Tablet 12.1"" */
    'S','l','i','m',' ','T','a','b','l','e','t',' ','1','2','.','1','"',
/* 0x225a2 = "TASCAM US-122mkII" */
    'T','A','S','C','A','M',' ','U','S','-','1','2','2','m','k','I','I',
/* 0x225b3 = "AVIXE Technology (China) Ltd." */
    'A','V','I','X','E',' ','\x0d',' ','(','C','h','i','n','a',')',' ','\xab',
/* 0x225c4 = "PhotoSmart P1100 Printer w/ Card Reader" */
    '\x86','\x12',' ','P','1','1','0','0',' ','\x0c',' ','w','/',' ','\x15',' ','\x08',
/* 0x225d5 = "Trackball Optical" */
    'T','r','a','c','k','b','a','l','l',' ','O','p','t','i','c','a','l',
/* 0x225e6 = "Agere Systems, Inc. (Lucent)" */
    'A','g','e','r','e',' ','\xb8','\x07',' ','(','L','u','c','e','n','t',')',
/* 0x225f7 = "King Billion Electronics Co., Ltd." */
    'K','i','n','g',' ','B','i','l','l','i','o','n',' ','\x1b',' ','\x0e','\xab',
/* 0x22608 = "DigitalPersona, Inc." */
    'D','i','g','i','t','a','l','P','e','r','s','o','n','a',',',' ','\x07',
/* 0x22619 = "FinePix S5000 Zoom (PC CAM)" */
    '\xca','i','x',' ','S','5','0','0','0',' ','\xe6','(','\x1f','C','A','M',')',
/* 0x2262a = "Store \'n\' Go HD Drive" */
    'S','t','o','r','e',' ','\'','n','\'',' ','G','o',' ','H','D',' ','\x14',
/* 0x2263b = "WLI-U2-KAMG54 Wireless LAN Adapter" */
    'W','L','I','-','U','2','-','K','A','M','G','5','4',' ','\x01','\xf3','\x02',
/* 0x2264c = "Finepix F10 (PTP)" */
    'F','i','n','e','p','i','x',' ','F','1','0',' ','(','P','T','P',')',
/* 0x2265d = "DataStation maxi g.u" */
    '\xe7','S','t','a','t','i','o','n',' ','m','a','x','i',' ','g','.','u',
/* 0x2266e = "SD/MMC Cardreader" */
    'S','D','/','M','M','C',' ','C','a','r','d','r','e','a','d','e','r',
/* 0x2267f = "AIR.Mate 2@net 802.11b Adapter" */
    'A','I','R','.','M','a','t','e',' ','2','@','n','e','t',' ','\x9b','\x02',
/* 0x22690 = "Contac Cable Industrial Limited" */
    'C','o','n','t','a','c',' ','\xa5',' ','\xef','L','i','m','i','t','e','d',
/* 0x226a1 = "LCD Tablet (12x9)" */
    'L','C','D',' ','T','a','b','l','e','t',' ','(','1','2','x','9',')',
/* 0x226b2 = "M5606 Video Camera Controller [UVC]" */
    'M','5','6','0','6',' ','\xa3',' ','\x04',' ','\x13',' ','[','U','V','C',']',
/* 0x226c3 = "Caplio GX 8 (ptp)" */
    'C','a','p','l','i','o',' ','G','X',' ','8',' ','(','p','t','p',')',
/* 0x226d4 = "N220 802.11bgn Wireless Adapter" */
    'N','2','2','0',' ','8','0','2','.','1','1','b','g','n',' ','\x01','\x02',
/* 0x226e5 = "PCX5000 Cable Modem (WDM)" */
    'P','C','X','5','0','0','0',' ','\xa5',' ','\x1c',' ','(','W','D','M',')',
/* 0x226f6 = "CPC FPGA (Serial)" */
    'C','P','C',' ','F','P','G','A',' ','(','S','e','r','i','a','l',')',
/* 0x22707 = "LP2275w Monitor Hub" */
    'L','P','2','2','7','5','w',' ','M','o','n','i','t','o','r',' ','\xa4',
/* 0x22718 = "Village Center, Inc." */
    'V','i','l','l','a','g','e',' ','C','e','n','t','e','r',',',' ','\x07',
/* 0x22729 = "Trillium Technology Pty. Ltd." */
    'T','r','i','l','l','i','u','m',' ','\x0d',' ','P','t','y','.',' ','\xab',
/* 0x2273a = "Bluetooth in DFU mode - Driver" */
    '\x06',' ','i','n',' ','D','F','U',' ','m','o','d','e',' ','-',' ','\xde',
/* 0x2274b = "AirLive WN-360USB adapter" */
    'A','i','r','L','i','v','e',' ','W','N','-','3','6','0','\x0a',' ','\xd0',
/* 0x2275c = "FXMC Neural Network Controller V2" */
    'F','X','M','C',' ','N','e','u','r','a','l',' ','\x8d','\x13',' ','V','2',
/* 0x2276d = "Uniti ARC motor controller" */
    'U','n','i','t','i',' ','A','R','C',' ','m','o','t','o','r',' ','\x9e',
/* 0x2277e = "ME-6000ISLE/4/DIO" */
    'M','E','-','6','0','0','0','I','S','L','E','/','4','/','D','I','O',
/* 0x2278f = "Digital Dream Enigma 1.3" */
    '\x09','D','r','e','a','m',' ','E','n','i','g','m','a',' ','1','.','3',
/* 0x227a0 = "HID Monitor Controls" */
    '\xf2','M','o','n','i','t','o','r',' ','C','o','n','t','r','o','l','s',
/* 0x227b1 = "Palladio USB V.92 Modem" */
    'P','a','l','l','a','d','i','o',' ','\x0a',' ','V','.','9','2',' ','\x1c',
/* 0x227c2 = "MC5727 CDMA modem" */
    'M','C','5','7','2','7',' ','C','D','M','A',' ','m','o','d','e','m',
/* 0x227d3 = "Hitachi Maxell, Ltd" */
    'H','i','t','a','c','h','i',' ','M','a','x','e','l','l',',',' ','\x16',
/* 0x227e4 = "DSB-560 Modem [atlas]" */
    'D','S','B','-','5','6','0',' ','\x1c',' ','[','a','t','l','a','s',']',
/* 0x227f5 = "MFC-840CLN Remote Setup Port" */
    '\x7d','8','4','0','C','L','N',' ','\xcb',' ','S','e','t','u','p',' ','\x87',
/* 0x22806 = "Praktica DPix3000" */
    'P','r','a','k','t','i','c','a',' ','D','P','i','x','3','0','0','0',
/* 0x22817 = "Genius NetScroll+" */
    'G','e','n','i','u','s',' ','N','e','t','S','c','r','o','l','l','+',
/* 0x22828 = "LTK Industries, Ltd" */
    'L','T','K',' ','I','n','d','u','s','t','r','i','e','s',',',' ','\x16',
/* 0x22839 = "Genius WebScroll+" */
    'G','e','n','i','u','s',' ','W','e','b','S','c','r','o','l','l','+',
/* 0x2284a = "RTL8191SU 802.11n WLAN Adapter" */
    'R','T','L','8','1','9','1','S','U',' ','\x99','W','L','A','N',' ','\x02',
/* 0x2285b = "Tuner\'s Dashboard" */
    'T','u','n','e','r','\'','s',' ','D','a','s','h','b','o','a','r','d',
/* 0x2286c = "PCX2200 Cable Modem (WDM)" */
    'P','C','X','2','2','0','0',' ','\xa5',' ','\x1c',' ','(','W','D','M',')',
/* 0x2287d = "Studio Mouse Wireless" */
    'S','t','u','d','i','o',' ','\x0b',' ','W','i','r','e','l','e','s','s',
/* 0x2288e = "TiePieSCOPE HS801" */
    'T','i','e','P','i','e','S','C','O','P','E',' ','H','S','8','0','1',
/* 0x2289f = "Sierra Imaging, Inc." */
    'S','i','e','r','r','a',' ','I','m','a','g','i','n','g',',',' ','\x07',
/* 0x228b0 = "Kingsun SF-620 Infrared Adapter" */
    'K','i','n','g','s','u','n',' ','S','F','-','6','2','0',' ','\xa8','\x02',
/* 0x228c1 = "WFS10 Wavefront Sensor" */
    'W','F','S','1','0',' ','W','a','v','e','f','r','o','n','t',' ','\xac',
/* 0x228d2 = "Rigol Technologies DS1000USB Oscilloscope" */
    'R','i','g','o','l',' ','\x88',' ','D','S','1','0','0','0','\x0a',' ','\xfe',
/* 0x228e3 = "Expert Mouse Wireless" */
    'E','x','p','e','r','t',' ','\x0b',' ','W','i','r','e','l','e','s','s',
/* 0x228f4 = "Enhanced Gaming Device" */
    'E','n','h','a','n','c','e','d',' ','G','a','m','i','n','g',' ','\x03',
/* 0x22905 = "Shin-Etsukaken Co., Ltd" */
    'S','h','i','n','-','E','t','s','u','k','a','k','e','n',' ','\x0e','\x16',
/* 0x22916 = "Cadence Design Systems, Inc." */
    'C','a','d','e','n','c','e',' ','D','e','s','i','g','n',' ','\xb8','\x07',
/* 0x22927 = "VE-CG40U Digital Still Camera" */
    'V','E','-','C','G','4','0','U',' ','\x09','S','t','i','l','l',' ','\x04',
/* 0x22938 = "Guardant Mass Storage" */
    'G','u','a','r','d','a','n','t',' ','\x7c','S','t','o','r','a','g','e',
/* 0x22949 = "AET63 BioTRUSTKey" */
    'A','E','T','6','3',' ','B','i','o','T','R','U','S','T','K','e','y',
/* 0x2295a = "Smartdio Reader/Writer" */
    'S','m','a','r','t','d','i','o',' ','R','e','a','d','e','r','/','\xdf',
/* 0x2296b = "MFC-5840CN Remote Setup Port" */
    '\x7d','5','8','4','0','C','N',' ','\xcb',' ','S','e','t','u','p',' ','\x87',
/* 0x2297c = "FunctionFS Gadget" */
    'F','u','n','c','t','i','o','n','F','S',' ','G','a','d','g','e','t',
/* 0x2298d = "5932-USB Enhanced Keyboard" */
    '5','9','3','2','-','\x0a',' ','E','n','h','a','n','c','e','d',' ','\x05',
/* 0x2299e = "Wireless Optical Mouse 2.4G [Bright]" */
    '\x01','\x7b','\x0b',' ','2','.','4','G',' ','[','B','r','i','g','h','t',']',
/* 0x229af = "DSB-650C Ethernet [klsi]" */
    'D','S','B','-','6','5','0','C',' ','\x7f',' ','[','k','l','s','i',']',
/* 0x229c0 = "ST&T Instrument Corp." */
    'S','T','&','T',' ','I','n','s','t','r','u','m','e','n','t',' ','\x10',
/* 0x229d1 = "My Passport Slim (WDBPDZ)" */
    'M','y',' ','\xd5','S','l','i','m',' ','(','W','D','B','P','D','Z',')',
/* 0x229e2 = "SIMATIC NET PC Adapter A2" */
    'S','I','M','A','T','I','C',' ','N','E','T',' ','\x1f','\x02',' ','A','2',
/* 0x229f3 = "CBM209x Flash Drive (OEM)" */
    'C','B','M','2','0','9','x',' ','\x3c',' ','\x14',' ','(','O','E','M',')',
/* 0x22a04 = "ACR1281 1S Dual Reader" */
    'A','C','R','1','2','8','1',' ','1','S',' ','D','u','a','l',' ','\x08',
/* 0x22a15 = "Sansa Clip+ (mtp)" */
    'S','a','n','s','a',' ','C','l','i','p','+',' ','(','m','t','p',')',
/* 0x22a26 = "Live! Cam Sync [VF0520]" */
    'L','i','v','e','!',' ','\x9a','\x91',' ','[','V','F','0','5','2','0',']',
/* 0x22a37 = "Coactive Networks" */
    'C','o','a','c','t','i','v','e',' ','N','e','t','w','o','r','k','s',
/* 0x22a48 = "WL-72B 3.5G MODEM" */
    'W','L','-','7','2','B',' ','3','.','5','G',' ','M','O','D','E','M',
/* 0x22a59 = "ImageMate SDDR-12" */
    'I','m','a','g','e','M','a','t','e',' ','S','D','D','R','-','1','2',
/* 0x22a6a = "SoftGate 802.11 Adapter" */
    'S','o','f','t','G','a','t','e',' ','8','0','2','.','1','1',' ','\x02',
/* 0x22a7b = "Personal PhoneGateway" */
    'P','e','r','s','o','n','a','l',' ','\x19','G','a','t','e','w','a','y',
/* 0x22a8c = "ASUS Computers, Inc." */
    'A','S','U','S',' ','C','o','m','p','u','t','e','r','s',',',' ','\x07',
/* 0x22a9d = "MDP-123 [Inkling]" */
    'M','D','P','-','1','2','3',' ','[','I','n','k','l','i','n','g',']',
/* 0x22aae = "MX Phone (BICR & ADB)" */
    'M','X',' ','\x19',' ','(','B','I','C','R',' ','&',' ','A','D','B',')',
/* 0x22abf = "ACR1251 1S Dual Reader" */
    'A','C','R','1','2','5','1',' ','1','S',' ','D','u','a','l',' ','\x08',
/* 0x22ad0 = "SpeedTouch ISDN or ADSL Modem" */
    'S','p','e','e','d','\x9d',' ','I','S','D','N',' ','o','r',' ','\xf1','\x1c',
/* 0x22ae1 = "Nike psa[128max Player" */
    'N','i','k','e',' ','p','s','a','[','1','2','8','m','a','x',' ','\x1e',
/* 0x22af2 = "STM Device in DFU Mode" */
    'S','T','M',' ','\x03',' ','i','n',' ','D','F','U',' ','M','o','d','e',
/* 0x22b03 = "OTi-6858 serial adapter" */
    'O','T','i','-','6','8','5','8',' ','s','e','r','i','a','l',' ','\xd0',
/* 0x22b14 = "Altek Corporation" */
    'A','l','t','e','k',' ','C','o','r','p','o','r','a','t','i','o','n',
/* 0x22b25 = "IDE-to-USB2.0 PCA" */
    'I','D','E','-','t','o','-','U','S','B','2','.','0',' ','P','C','A',
/* 0x22b36 = "Link Cooling Node" */
    'L','i','n','k',' ','C','o','o','l','i','n','g',' ','N','o','d','e',
/* 0x22b47 = "KU-2971/KU-0325 Keyboard" */
    'K','U','-','2','9','7','1','/','K','U','-','0','3','2','5',' ','\x05',
/* 0x22b58 = "802.11b/g/n USB Wireless LAN Card" */
    '8','0','2','.','1','1','b','/','g','/','n',' ','\x0a',' ','\x01','\xf3','\x15',
/* 0x22b69 = "Music Player HDR-1(tm)" */
    'M','u','s','i','c',' ','\x1e',' ','H','D','R','-','1','(','t','m',')',
/* 0x22b7a = "INIC-1511L PATA Bridge" */
    'I','N','I','C','-','1','5','1','1','L',' ','P','A','T','A',' ','\x9f',
/* 0x22b8b = "ND3050 8-in-1 Card Reader" */
    'N','D','3','0','5','0',' ','8','-','i','n','-','1',' ','\x15',' ','\x08',
/* 0x22b9c = "DCP-310CN RemovableDisk" */
    '\xaa','3','1','0','C','N',' ','R','e','m','o','v','a','b','l','e','\xe8',
/* 0x22bad = "Digital Photo Frame Mass Storage" */
    '\x09','\x86',' ','F','r','a','m','e',' ','\x7c','S','t','o','r','a','g','e',
/* 0x22bbe = "SURFboard Gateway" */
    'S','U','R','F','b','o','a','r','d',' ','G','a','t','e','w','a','y',
/* 0x22bcf = "Craig 2GB MP3/Video Player" */
    'C','r','a','i','g',' ','2','G','B',' ','M','P','3','/','\xa3',' ','\x1e',
/* 0x22be0 = "PC Camera with Mic (SN9C105)" */
    '\x1f','\x04',' ','\x98','M','i','c',' ','(','S','N','9','C','1','0','5',')',
/* 0x22bf1 = "DCP-4020C RemovableDisk" */
    '\xaa','4','0','2','0','C',' ','R','e','m','o','v','a','b','l','e','\xe8',
/* 0x22c02 = "BearPaw 2400 TA Pro" */
    'B','e','a','r','P','a','w',' ','2','4','0','0',' ','T','A',' ','\x8f',
/* 0x22c13 = "Pyra Mouse (wireless)" */
    'P','y','r','a',' ','\x0b',' ','(','w','i','r','e','l','e','s','s',')',
/* 0x22c24 = "Genius G-Pen F509" */
    'G','e','n','i','u','s',' ','G','-','P','e','n',' ','F','5','0','9',
/* 0x22c35 = "Reader (UISC6SE-FLASH)" */
    '\x08',' ','(','U','I','S','C','6','S','E','-','F','L','A','S','H',')',
/* 0x22c46 = "CBM1180 Flash drive controller" */
    'C','B','M','1','1','8','0',' ','\x3c',' ','d','r','i','v','e',' ','\x9e',
/* 0x22c57 = "SeaLINK+8 (Port 7+8)" */
    'S','e','a','L','I','N','K','+','8',' ','(','\x87',' ','7','+','8',')',
/* 0x22c68 = "IBM Bluetooth Ultraport Module" */
    'I','B','M',' ','\x06',' ','U','l','t','r','a','p','o','r','t',' ','\xe5',
/* 0x22c79 = "Blackmagic design" */
    'B','l','a','c','k','m','a','g','i','c',' ','d','e','s','i','g','n',
/* 0x22c8a = "Acer CrystalEye Webcam" */
    'A','c','e','r',' ','C','r','y','s','t','a','l','E','y','e',' ','\x11',
/* 0x22c9b = "DigistimSP (cold)" */
    'D','i','g','i','s','t','i','m','S','P',' ','(','c','o','l','d',')',
/* 0x22cac = "Behavior Tech. Computer Corp." */
    'B','e','h','a','v','i','o','r',' ','T','e','c','h','.',' ','\xcd','\x10',
/* 0x22cbd = "Imagistics sx2100" */
    'I','m','a','g','i','s','t','i','c','s',' ','s','x','2','1','0','0',
/* 0x22cce = "RTL8187SU 802.11g WLAN Adapter" */
    'R','T','L','8','1','8','7','S','U',' ','\x94','W','L','A','N',' ','\x02',
/* 0x22cdf = "Powershot SX30 IS" */
    'P','o','w','e','r','s','h','o','t',' ','S','X','3','0',' ','I','S',
/* 0x22cf0 = "Logitech Keyboard + Mice" */
    'L','o','g','i','t','e','c','h',' ','\x05',' ','+',' ','M','i','c','e',
/* 0x22d01 = "Pilot Optical Pro Wireless" */
    'P','i','l','o','t',' ','\x7b','\x8f',' ','W','i','r','e','l','e','s','s',
/* 0x22d12 = "Plugable UGA-2K-A" */
    'P','l','u','g','a','b','l','e',' ','U','G','A','-','2','K','-','A',
/* 0x22d23 = "Nanosira4-EDR-ROM" */
    'N','a','n','o','s','i','r','a','4','-','E','D','R','-','R','O','M',
/* 0x22d34 = "TIAO Multi-Protocol Adapter" */
    'T','I','A','O',' ','\xd6','-','P','r','o','t','o','c','o','l',' ','\x02',
/* 0x22d45 = "Cinergy 250 Audio" */
    'C','i','n','e','r','g','y',' ','2','5','0',' ','A','u','d','i','o',
/* 0x22d56 = "TT-connect C-2400" */
    'T','T','-','c','o','n','n','e','c','t',' ','C','-','2','4','0','0',
/* 0x22d67 = "MF110/MF627/MF636" */
    'M','F','1','1','0','/','M','F','6','2','7','/','M','F','6','3','6',
/* 0x22d78 = "Wally 2.4 chipset" */
    'W','a','l','l','y',' ','2','.','4',' ','c','h','i','p','s','e','t',
/* 0x22d89 = "The Glitch RawHID" */
    'T','h','e',' ','G','l','i','t','c','h',' ','R','a','w','H','I','D',
/* 0x22d9a = "Billion Bright, Ltd" */
    'B','i','l','l','i','o','n',' ','B','r','i','g','h','t',',',' ','\x16',
/* 0x22dab = "Voyager ADSL Modem Loader" */
    'V','o','y','a','g','e','r',' ','\xf1','\x1c',' ','L','o','a','d','e','r',
/* 0x22dbc = "Laserjet CP1525nw" */
    'L','a','s','e','r','j','e','t',' ','C','P','1','5','2','5','n','w',
/* 0x22dcd = "Qstarz BT-Q1000XT" */
    'Q','s','t','a','r','z',' ','B','T','-','Q','1','0','0','0','X','T',
/* 0x22dde = "Eumex 220PC (FlashMode)" */
    'E','u','m','e','x',' ','2','2','0','\x1f','(','\x3c','M','o','d','e',')',
/* 0x22def = "OKI ES4140 Mono Printer" */
    'O','K','I',' ','E','S','4','1','4','0',' ','M','o','n','o',' ','\x0c',
/* 0x22e00 = "ML-2580N Mono Laser Printer" */
    'M','L','-','2','5','8','0','N',' ','M','o','n','o',' ','\x82',' ','\x0c',
/* 0x22e11 = "AudioBox 1818 VSL" */
    'A','u','d','i','o','B','o','x',' ','1','8','1','8',' ','V','S','L',
/* 0x22e22 = "SeaLINK+8 (Port 3+4)" */
    'S','e','a','L','I','N','K','+','8',' ','(','\x87',' ','3','+','4',')',
/* 0x22e33 = "1.3MPixel Web Cam" */
    '1','.','3','M','P','i','x','e','l',' ','W','e','b',' ','C','a','m',
/* 0x22e44 = "P!cty 900 [HP DJ]" */
    'P','!','c','t','y',' ','9','0','0',' ','[','H','P',' ','D','J',']',
/* 0x22e55 = "Jeilin Technology Corp., Ltd" */
    'J','e','i','l','i','n',' ','\x0d',' ','C','o','r','p','.',',',' ','\x16',
/* 0x22e66 = "Xbox Memory Unit (8MB)" */
    'X','b','o','x',' ','\xd2',' ','U','n','i','t',' ','(','8','M','B',')',
/* 0x22e77 = "IEEE802.15.4 RF Dongle" */
    'I','E','E','E','8','0','2','.','1','5','.','4',' ','R','F',' ','\xf4',
/* 0x22e88 = "OpticPro 1248U Scanner #2" */
    'O','p','t','i','c','\x8f',' ','1','2','4','8','U',' ','\x25',' ','#','2',
/* 0x22e99 = "Fiberbyte USB-inSync Device" */
    'F','i','b','e','r','b','y','t','e',' ','\x0a','-','i','n','\x91',' ','\x03',
/* 0x22eaa = "Harmony 650/700 Remote" */
    'H','a','r','m','o','n','y',' ','6','5','0','/','7','0','0',' ','\xcb',
/* 0x22ebb = "Bluetooth Device with trace filter" */
    '\x06',' ','\x03',' ','\x98','t','r','a','c','e',' ','f','i','l','t','e','r',
/* 0x22ecc = "TDK Trans-It 16GB" */
    'T','D','K',' ','T','r','a','n','s','-','I','t',' ','1','6','G','B',
/* 0x22edd = "Sanei Electric, Inc." */
    'S','a','n','e','i',' ','E','l','e','c','t','r','i','c',',',' ','\x07',
/* 0x22eee = "Sky Vega IM-A650S" */
    'S','k','y',' ','V','e','g','a',' ','I','M','-','A','6','5','0','S',
/* 0x22eff = "ML-2010P Mono Laser Printer" */
    'M','L','-','2','0','1','0','P',' ','M','o','n','o',' ','\x82',' ','\x0c',
/* 0x22f10 = "MFC-4820C RemovableDisk" */
    '\x7d','4','8','2','0','C',' ','R','e','m','o','v','a','b','l','e','\xe8',
/* 0x22f21 = "N43 [Pilot Mouse]" */
    'N','4','3',' ','[','P','i','l','o','t',' ','M','o','u','s','e',']',
/* 0x22f32 = "Acer Semiconductor America, Inc." */
    'A','c','e','r',' ','\xc0',' ','A','m','e','r','i','c','a',',',' ','\x07',
/* 0x22f43 = "WLI2-USB2-G54 Wireless LAN Adapter" */
    'W','L','I','2','-','U','S','B','2','-','G','5','4',' ','\x01','\xf3','\x02',
/* 0x22f54 = "OpenOCD JTAG TINY" */
    'O','p','e','n','O','C','D',' ','J','T','A','G',' ','T','I','N','Y',
/* 0x22f65 = "E1701 Modular Controller Card" */
    'E','1','7','0','1',' ','M','o','d','u','l','a','r',' ','\x13',' ','\x15',
/* 0x22f76 = "PSC-1315/PSC-1317" */
    'P','S','C','-','1','3','1','5','/','P','S','C','-','1','3','1','7',
/* 0x22f87 = "STORY Station 1TB" */
    'S','T','O','R','Y',' ','S','t','a','t','i','o','n',' ','1','T','B',
/* 0x22f98 = "A300 DVB-T TV receiver" */
    'A','3','0','0',' ','\xa7','T',' ','\xda','r','e','c','e','i','v','e','r',
/* 0x22fa9 = "USB to Memory Stick(LC1)" */
    '\x0a',' ','t','o',' ','\xd2',' ','S','t','i','c','k','(','L','C','1',')',
/* 0x22fba = "Telldus TellStick Duo" */
    'T','e','l','l','d','u','s',' ','T','e','l','l','\xb3',' ','D','u','o',
/* 0x22fcb = "Headset MDR-1000X" */
    'H','e','a','d','s','e','t',' ','M','D','R','-','1','0','0','0','X',
/* 0x22fdc = "DCP-750CW RemovableDisk" */
    '\xaa','7','5','0','C','W',' ','R','e','m','o','v','a','b','l','e','\xe8',
/* 0x22fed = "Plus-One I & T, Inc." */
    'P','l','u','s','-','O','n','e',' ','I',' ','&',' ','T',',',' ','\x07',
/* 0x22ffe = "Dual-mode Camera0" */
    'D','u','a','l','-','m','o','d','e',' ','C','a','m','e','r','a','0',
/* 0x2300f = "Dual-mode Camera1" */
    'D','u','a','l','-','m','o','d','e',' ','C','a','m','e','r','a','1',
/* 0x23020 = "UT2000/UT3000 Digital Storage Oscilloscope" */
    'U','T','2','0','0','0','/','U','T','3','0','0','0',' ','\x09','\x0f','\xfe',
/* 0x23031 = "Graphtec CC200-20" */
    'G','r','a','p','h','t','e','c',' ','C','C','2','0','0','-','2','0',
/* 0x23042 = "Hi-Touch Imaging Technologies Co., Ltd" */
    'H','i','-','\x9d',' ','I','m','a','g','i','n','g',' ','\x88',' ','\x0e','\x16',
/* 0x23053 = "C7-00 (Mass storage mode)" */
    'C','7','-','0','0',' ','(','\x7c','s','t','o','r','a','g','e',' ','\x1a',
/* 0x23064 = "MI-2540D [Optical mouse]" */
    'M','I','-','2','5','4','0','D',' ','[','\x7b','m','o','u','s','e',']',
/* 0x23075 = "WLI-USB-L11G-WR Wireless LAN Adapter" */
    'W','L','I','-','\x0a','-','L','1','1','G','-','W','R',' ','\x01','\xf3','\x02',
/* 0x23086 = "Sansa Clip+ (msc)" */
    'S','a','n','s','a',' ','C','l','i','p','+',' ','(','m','s','c',')',
/* 0x23097 = "eToken Pro v4.2.5.4" */
    'e','T','o','k','e','n',' ','\x8f',' ','v','4','.','2','.','5','.','4',
/* 0x230a8 = "PowerShot ELPH 180 / IXUS 175" */
    '\x24','\x84','E','L','P','H',' ','1','8','0',' ','/',' ','\xfd','1','7','5',
/* 0x230b9 = "Communicator Pocket PC" */
    'C','o','m','m','u','n','i','c','a','t','o','r',' ','\x17',' ','P','C',
/* 0X230ca = "Clie PEG-TH55 PDA" */
    'l','i','e',' ','P','E','G','-','T','H','5','5',' ','P','D','A',
/* 0X230da = "AC1030-based SmartCard Reader" */
    'C','1','0','3','0','-','b','a','s','e','d',' ','\x12','\x15',' ','\x08',
/* 0x230ea = "M-Audio Sonica Theater" */
    'M','-','\x8b','S','o','n','i','c','a',' ','T','h','e','a','t','e','r',
/* 0x230fb = "WinFast TV - PAL N + FM" */
    'W','i','n','\xec','\xda','-',' ','P','A','L',' ','N',' ','+',' ','F','M',
/* 0x2310c = "Astra 4800/4850 Scanner" */
    'A','s','t','r','a',' ','4','8','0','0','/','4','8','5','0',' ','\x25',
/* 0x2311d = "LG LDP-7024D(LD)USB" */
    'L','G',' ','L','D','P','-','7','0','2','4','D','(','L','D',')','\x0a',
/* 0x2312e = "SGH-E720/SGH-E840" */
    'S','G','H','-','E','7','2','0','/','S','G','H','-','E','8','4','0',
/* 0x2313f = "Ozone Mobile Broadband" */
    'O','z','o','n','e',' ','\x96',' ','B','r','o','a','d','b','a','n','d',
/* 0x23150 = "SHIN-EI Sangyo Co., Ltd" */
    'S','H','I','N','-','E','I',' ','S','a','n','g','y','o',' ','\x0e','\x16',
/* 0x23161 = "PhidgetInterfaceKit 0-8-8" */
    'P','h','i','d','g','e','t','\x81','K','i','t',' ','0','-','8','-','8',
/* 0x23172 = "Accesio USB-COM-4SM" */
    'A','c','c','e','s','i','o',' ','\x0a','-','C','O','M','-','4','S','M',
/* 0x23183 = "Kingsun KS-959 Infrared Adapter" */
    'K','i','n','g','s','u','n',' ','K','S','-','9','5','9',' ','\xa8','\x02',
/* 0x23194 = "SmartTerminal ST-2xxx" */
    '\x12','T','e','r','m','i','n','a','l',' ','S','T','-','2','x','x','x',
/* 0x231a5 = "Triplex i-mini PC Camera" */
    'T','r','i','p','l','e','x',' ','i','-','m','i','n','i',' ','\x1f','\x04',
/* 0x231b6 = "PilotMouse Laser - Gaming" */
    'P','i','l','o','t','\x0b',' ','\x82',' ','-',' ','G','a','m','i','n','g',
/* 0x231c7 = "Eumex 504PC ISDN TA" */
    'E','u','m','e','x',' ','5','0','4','\x1f','I','S','D','N',' ','T','A',
/* 0x231d8 = "LAN DOCK Serial Converter" */
    '\xf3','D','O','C','K',' ','\x90',' ','C','o','n','v','e','r','t','e','r',
/* 0x231e9 = "Likom Technology Sdn. Bhd." */
    'L','i','k','o','m',' ','\x0d',' ','S','d','n','.',' ','B','h','d','.',
/* 0x231fa = "Hub in 30" Cinema Display" */
    '\xa4',' ','i','n',' ','3','0','"',' ','C','i','n','e','m','a',' ','\xcf',
/* 0x2320b = "BMS International Beheer N.V." */
    'B','M','S',' ','\x9c',' ','B','e','h','e','e','r',' ','N','.','V','.',
/* 0x2321c = "UPS Tower 500W LV" */
    'U','P','S',' ','T','o','w','e','r',' ','5','0','0','W',' ','L','V',
/* 0x2322d = "Walkman NWZ-B173F" */
    'W','a','l','k','m','a','n',' ','N','W','Z','-','B','1','7','3','F',
/* 0x2323e = "Walkman NWZ-E436F" */
    'W','a','l','k','m','a','n',' ','N','W','Z','-','E','4','3','6','F',
/* 0x2324f = "UPS35110/UPS25110" */
    'U','P','S','3','5','1','1','0','/','U','P','S','2','5','1','1','0',
/* 0x23260 = "ISDN-Connector TA" */
    'I','S','D','N','-','C','o','n','n','e','c','t','o','r',' ','T','A',
/* 0x23271 = "Pixart Imaging, Inc." */
    'P','i','x','a','r','t',' ','I','m','a','g','i','n','g',',',' ','\x07',
/* 0x23282 = "Qualcomm / Option" */
    'Q','u','a','l','c','o','m','m',' ','/',' ','O','p','t','i','o','n',
/* 0x23293 = "My Book Studio II" */
    'M','y',' ','B','o','o','k',' ','S','t','u','d','i','o',' ','I','I',
/* 0x232a4 = "VCC-U01 Visual Communication Camera" */
    'V','C','C','-','U','0','1',' ','V','i','s','u','a','l',' ','\xe9','\x04',
/* 0x232b5 = "ZR45MC Digital Camcorder" */
    'Z','R','4','5','M','C',' ','\x09','C','a','m','c','o','r','d','e','r',
/* 0x232c6 = "CG4500E Communications Gateway" */
    'C','G','4','5','0','0','E',' ','\xd1',' ','G','a','t','e','w','a','y',
/* 0x232d7 = "ACR1261 1S Dual Reader" */
    'A','C','R','1','2','6','1',' ','1','S',' ','D','u','a','l',' ','\x08',
/* 0x232e8 = "Firmware uploader" */
    'F','i','r','m','w','a','r','e',' ','u','p','l','o','a','d','e','r',
/* 0x232f9 = "iAudio X5, side USB port" */
    'i','\x8b','X','5',',',' ','s','i','d','e',' ','\x0a',' ','p','o','r','t',
/* 0x2330a = "Deskjet 2050 J510" */
    'D','e','s','k','j','e','t',' ','2','0','5','0',' ','J','5','1','0',
/* 0x2331b = "Inclose Design, Inc." */
    'I','n','c','l','o','s','e',' ','D','e','s','i','g','n',',',' ','\x07',
/* 0x2332c = "USB-IF non-workshop" */
    '\x0a','-','I','F',' ','n','o','n','-','w','o','r','k','s','h','o','p',
/* 0x2333d = "Festo AG & Co. KG" */
    'F','e','s','t','o',' ','A','G',' ','&',' ','C','o','.',' ','K','G',
/* 0x2334e = "E61 (Data Exchange mode)" */
    'E','6','1',' ','(','\xe7',' ','E','x','c','h','a','n','g','e',' ','\x1a',
/* 0x2335f = "Elkat Electronics, Sdn., Bhd." */
    'E','l','k','a','t',' ','\xf7','S','d','n','.',',',' ','B','h','d','.',
/* 0x23370 = "PC98 Series Layout Keyboard Mouse" */
    'P','C','9','8',' ','\xbf',' ','L','a','y','o','u','t',' ','\x05',' ','\x0b',
/* 0x23381 = "EasyShare C180 Digital Camera" */
    'E','a','s','y','S','h','a','r','e',' ','C','1','8','0',' ','\x09','\x04',
/* 0x23392 = "DigistimSP (warm)" */
    'D','i','g','i','s','t','i','m','S','P',' ','(','w','a','r','m',')',
/* 0x233a3 = "MSL Enterprises Corp." */
    'M','S','L',' ','E','n','t','e','r','p','r','i','s','e','s',' ','\x10',
/* 0x233b4 = "SAMWOO Enterprise" */
    'S','A','M','W','O','O',' ','E','n','t','e','r','p','r','i','s','e',
/* 0x233c5 = "Xperia X8 (debug)" */
    'X','p','e','r','i','a',' ','X','8',' ','(','d','e','b','u','g',')',
/* 0x233d6 = "Optical 5-Button Wheel Mouse" */
    '\x7b','5','-','B','u','t','t','o','n',' ','W','h','e','e','l',' ','\x0b',
/* 0x233e7 = "Emu [Ambit3 Peak]" */
    'E','m','u',' ','[','A','m','b','i','t','3',' ','P','e','a','k',']',
/* 0x233f8 = "D6603 [Xperia Z3]" */
    'D','6','6','0','3',' ','[','X','p','e','r','i','a',' ','Z','3',']',
/* 0x23409 = "CD-R Drive KXL-RW32AN" */
    'C','D','-','R',' ','\x14',' ','K','X','L','-','R','W','3','2','A','N',
/* 0x2341a = "M110E PATA bridge" */
    'M','1','1','0','E',' ','P','A','T','A',' ','b','r','i','d','g','e',
/* 0x2342b = "INIC-1610L SATA Bridge" */
    'I','N','I','C','-','1','6','1','0','L',' ','S','A','T','A',' ','\x9f',
/* 0x2343c = "Wireless Presenter Mouse 8000" */
    '\x01','P','r','e','s','e','n','t','e','r',' ','\x0b',' ','8','0','0','0',
/* 0x2344d = "ISDN TA128 Deluxe" */
    'I','S','D','N',' ','T','A','1','2','8',' ','D','e','l','u','x','e',
/* 0x2345e = "Washington CDMA Phone" */
    'W','a','s','h','i','n','g','t','o','n',' ','C','D','M','A',' ','\x19',
/* 0x2346f = "integrated camera" */
    'i','n','t','e','g','r','a','t','e','d',' ','c','a','m','e','r','a',
/* 0x23480 = "Aptio Products, Inc." */
    'A','p','t','i','o',' ','P','r','o','d','u','c','t','s',',',' ','\x07',
/* 0x23491 = "Trust K56 V92 USB Modem" */
    'T','r','u','s','t',' ','K','5','6',' ','V','9','2',' ','\x0a',' ','\x1c',
/* 0x234a2 = "MF5530 Scanner Device V1.9.1" */
    'M','F','5','5','3','0',' ','\x25',' ','\x03',' ','V','1','.','9','.','1',
/* 0x234b3 = "OneTouch 8100 EPP/USB Scanner" */
    'O','n','e','\x9d',' ','8','1','0','0',' ','E','P','P','/','\x0a',' ','\x25',
/* 0x234c4 = "Taxan (Europe), Ltd" */
    'T','a','x','a','n',' ','(','E','u','r','o','p','e',')',',',' ','\x16',
/* 0x234d5 = "HighSpeed Surfing" */
    'H','i','g','h','S','p','e','e','d',' ','S','u','r','f','i','n','g',
/* 0x234e6 = "microSD CardReader SY-T18" */
    'm','i','c','r','o','S','D',' ','\x15','\x08',' ','S','Y','-','T','1','8',
/* 0x234f7 = "Dell DJ (2nd gen)" */
    'D','e','l','l',' ','D','J',' ','(','2','n','d',' ','g','e','n',')',
/* 0x23508 = "Japan Storage Battery Co., Ltd" */
    'J','a','p','a','n',' ','\x0f','B','a','t','t','e','r','y',' ','\x0e','\x16',
/* 0x23519 = "VC500 Video Capture Dongle" */
    'V','C','5','0','0',' ','\xa3',' ','C','a','p','t','u','r','e',' ','\xf4',
/* 0x2352a = "Cinergy T RC MKII" */
    'C','i','n','e','r','g','y',' ','T',' ','R','C',' ','M','K','I','I',
/* 0x2353b = "ReMOTE SL Compact" */
    'R','e','M','O','T','E',' ','S','L',' ','C','o','m','p','a','c','t',
/* 0x2354c = "EZUSB PC/SC Smart Card Reader" */
    'E','Z','U','S','B',' ','P','C','/','S','C',' ','\x12',' ','\x15',' ','\x08',
/* 0x2355d = "Silicon Architect" */
    'S','i','l','i','c','o','n',' ','A','r','c','h','i','t','e','c','t',
/* 0x2356e = "TransDimension, Inc." */
    'T','r','a','n','s','D','i','m','e','n','s','i','o','n',',',' ','\x07',
/* 0x2357f = "Dual Mode Digital Camera 1.3M" */
    'D','u','a','l',' ','M','o','d','e',' ','\x09','\x04',' ','1','.','3','M',
/* 0x23590 = "Topre Corporation" */
    'T','o','p','r','e',' ','C','o','r','p','o','r','a','t','i','o','n',
/* 0x235a1 = "FEIG ELECTRONIC GmbH" */
    'F','E','I','G',' ','E','L','E','C','T','R','O','N','I','C',' ','\xfc',
/* 0x235b2 = "Jolla PC connection" */
    'J','o','l','l','a',' ','\x1f','c','o','n','n','e','c','t','i','o','n',
/* 0x235c3 = "HHKB Professional" */
    'H','H','K','B',' ','P','r','o','f','e','s','s','i','o','n','a','l',
/* 0x235d4 = "Japanese Keyboard - 260U" */
    'J','a','p','a','n','e','s','e',' ','\x05',' ','-',' ','2','6','0','U',
/* 0x235e5 = "RISO KAGAKU CORP." */
    'R','I','S','O',' ','K','A','G','A','K','U',' ','C','O','R','P','.',
/* 0x235f6 = "EyeTV DTT Deluxe v2" */
    'E','y','e','\xda','D','T','T',' ','D','e','l','u','x','e',' ','v','2',
/* 0x23607 = "BearPaw 2448 TA Pro" */
    'B','e','a','r','P','a','w',' ','2','4','4','8',' ','T','A',' ','\x8f',
/* 0x23618 = "9S08JS Bootloader" */
    '9','S','0','8','J','S',' ','B','o','o','t','l','o','a','d','e','r',
/* 0x23629 = "FreeAgent Desktop" */
    'F','r','e','e','A','g','e','n','t',' ','D','e','s','k','t','o','p',
/* 0x2363a = "Magicolor 2430 DL" */
    'M','a','g','i','c','o','l','o','r',' ','2','4','3','0',' ','D','L',
/* 0x2364b = "ADSL Modem Prestige 600 series" */
    '\xf1','\x1c',' ','P','r','e','s','t','i','g','e',' ','6','0','0',' ','\x1d',
/* 0x2365c = "Alpha Imaging Technology Corp." */
    'A','l','p','h','a',' ','I','m','a','g','i','n','g',' ','\x0d',' ','\x10',
/* 0x2366d = "UPStation GXT UPS" */
    'U','P','S','t','a','t','i','o','n',' ','G','X','T',' ','U','P','S',
/* 0x2367e = "Myriad-RF LimeSDR" */
    'M','y','r','i','a','d','-','R','F',' ','L','i','m','e','S','D','R',
/* 0x2368f = "Medion MD 6242 MP3 Player" */
    'M','e','d','i','o','n',' ','M','D',' ','6','2','4','2',' ','\x8e','\x1e',
/* 0x236a0 = "Sanyo Electric Co., Ltd" */
    'S','a','n','y','o',' ','E','l','e','c','t','r','i','c',' ','\x0e','\x16',
/* 0x236b1 = "Contour Design, Inc." */
    'C','o','n','t','o','u','r',' ','D','e','s','i','g','n',',',' ','\x07',
/* 0x236c2 = "RTL8188SU 802.11n WLAN Adapter" */
    'R','T','L','8','1','8','8','S','U',' ','\x99','W','L','A','N',' ','\x02',
/* 0x236d3 = "Audio Advantage Roadie" */
    '\x8b','A','d','v','a','n','t','a','g','e',' ','R','o','a','d','i','e',
/* 0x236e4 = "F5U103 Serial Adapter [etek]" */
    'F','5','U','1','0','3',' ','\x90',' ','\x02',' ','[','e','t','e','k',']',
/* 0x236f5 = "Velper (UISDMC4S)" */
    'V','e','l','p','e','r',' ','(','U','I','S','D','M','C','4','S',')',
/* 0x23706 = "Papilio Duo (AVR)" */
    'P','a','p','i','l','i','o',' ','D','u','o',' ','(','A','V','R',')',
/* 0x23717 = "SCard R/W CSR-145" */
    'S','C','a','r','d',' ','R','/','W',' ','C','S','R','-','1','4','5',
/* 0x23728 = "PICkit Serial Analyzer" */
    'P','I','C','k','i','t',' ','\x90',' ','A','n','a','l','y','z','e','r',
/* 0x23739 = "Martin Maxxyz DMX" */
    'M','a','r','t','i','n',' ','M','a','x','x','y','z',' ','D','M','X',
/* 0X2374a = "Xbox Communicator" */
    'b','o','x',' ','C','o','m','m','u','n','i','c','a','t','o','r',
/* 0x2375a = "AirTies Wireless Networks" */
    'A','i','r','T','i','e','s',' ','\x01','N','e','t','w','o','r','k','s',
/* 0x2376b = "AES3500-BZ TruePrint Sensor" */
    'A','E','S','3','5','0','0','-','B','Z',' ','T','r','u','e','\xbd','\xac',
/* 0x2377c = "Wireless Mouse (Battery Free)" */
    '\x01','\x0b',' ','(','B','a','t','t','e','r','y',' ','F','r','e','e',')',
/* 0x2378d = "Lakeview Research" */
    'L','a','k','e','v','i','e','w',' ','R','e','s','e','a','r','c','h',
/* 0x2379e = "VIPColor Technologies USA, Inc." */
    'V','I','P','C','o','l','o','r',' ','\x88',' ','U','S','A',',',' ','\x07',
/* 0x237af = "PowerShot Digital ELPH SD1400 IS" */
    '\x24','\x84','\x09','E','L','P','H',' ','S','D','1','4','0','0',' ','I','S',
/* 0x237c0 = "UPS Manufacturing" */
    'U','P','S',' ','M','a','n','u','f','a','c','t','u','r','i','n','g',
/* 0x237d1 = "TechnoData Interware" */
    'T','e','c','h','n','o','\xe7',' ','I','n','t','e','r','w','a','r','e',
/* 0x237e2 = "SeaLINK+8 (Port 5+6)" */
    'S','e','a','L','I','N','K','+','8',' ','(','\x87',' ','5','+','6',')',
/* 0x237f3 = "WLI-UC-AG300N Wireless LAN Adapter" */
    'W','L','I','-','U','C','-','A','G','3','0','0','N',' ','\x01','\xf3','\x02',
/* 0x23804 = "Sejin Electron, Inc." */
    'S','e','j','i','n',' ','E','l','e','c','t','r','o','n',',',' ','\x07',
/* 0x23815 = "UltraX Keyboard (Y-BL49)" */
    'U','l','t','r','a','X',' ','\x05',' ','(','Y','-','B','L','4','9',')',
/* 0x23826 = "Ticket Printer TTP 2030" */
    'T','i','c','k','e','t',' ','\x0c',' ','T','T','P',' ','2','0','3','0',
/* 0x23837 = "SONY Communicator" */
    'S','O','N','Y',' ','C','o','m','m','u','n','i','c','a','t','o','r',
/* 0x23848 = "ME-6100ISLE/8/DIO" */
    'M','E','-','6','1','0','0','I','S','L','E','/','8','/','D','I','O',
/* 0x23859 = "MF-PD100 Soul Digital MP3 Player" */
    'M','F','-','P','D','1','0','0',' ','S','o','u','l',' ','\x09','\x8e','\x1e',
/* 0x2386a = "PICoPLC [APStech]" */
    'P','I','C','o','P','L','C',' ','[','A','P','S','t','e','c','h',']',
/* 0x2387b = "CNF9055 Toshiba Webcam" */
    'C','N','F','9','0','5','5',' ','T','o','s','h','i','b','a',' ','\x11',
/* 0x2388c = "Ethernet adapter [U2L 100P-Y1]" */
    '\x7f',' ','\xd0',' ','[','U','2','L',' ','1','0','0','P','-','Y','1',']',
/* 0x2389d = "GP-K7000 keyboard" */
    'G','P','-','K','7','0','0','0',' ','k','e','y','b','o','a','r','d',
/* 0x238ae = "Cyborg 3D Force Stick" */
    'C','y','b','o','r','g',' ','3','D',' ','F','o','r','c','e',' ','\xb3',
/* 0x238bf = "CP22 - Communication Processor" */
    'C','P','2','2',' ','-',' ','\xe9','P','r','o','c','e','s','s','o','r',
/* 0x238d0 = "Coolscan LS 40 ED" */
    'C','o','o','l','s','c','a','n',' ','L','S',' ','4','0',' ','E','D',
/* 0x238e1 = "iAudio M5, side USB port" */
    'i','\x8b','M','5',',',' ','s','i','d','e',' ','\x0a',' ','p','o','r','t',
/* 0x238f2 = "Sanyo Semiconductor Company Micro" */
    'S','a','n','y','o',' ','\xc0',' ','C','o','m','p','a','n','y',' ','\xc4',
/* 0x23903 = "CP42 - Communication Processor" */
    'C','P','4','2',' ','-',' ','\xe9','P','r','o','c','e','s','s','o','r',
/* 0x23914 = "Ascom Business Systems, Ltd" */
    'A','s','c','o','m',' ','B','u','s','i','n','e','s','s',' ','\xb8','\x16',
/* 0x23925 = "Tiger Jet Network, Inc." */
    'T','i','g','e','r',' ','\x80','N','e','t','w','o','r','k',',',' ','\x07',
/* 0x23936 = "Cyber Power System, Inc." */
    'C','y','b','e','r',' ','\x24',' ','S','y','s','t','e','m',',',' ','\x07',
/* 0x23947 = "Keystation 61es Driver" */
    'K','e','y','s','t','a','t','i','o','n',' ','6','1','e','s',' ','\xde',
/* 0x23958 = "Genius MaxFire MiniPad" */
    'G','e','n','i','u','s',' ','M','a','x','F','i','r','e',' ','\xb9','\xfa',
/* 0x23969 = "Aluminum Keyboard (ANSI)" */
    'A','l','u','m','i','n','u','m',' ','\x05',' ','(','A','N','S','I',')',
/* 0x2397a = "FinePix S7000 Zoom (PC CAM)" */
    '\xca','i','x',' ','S','7','0','0','0',' ','\xe6','(','\x1f','C','A','M',')',
/* 0x2398b = "D-Link DSB-C310 Webcam" */
    'D','-','L','i','n','k',' ','D','S','B','-','C','3','1','0',' ','\x11',
/* 0x2399c = "MFC-5200C RemovableDisk" */
    '\x7d','5','2','0','0','C',' ','R','e','m','o','v','a','b','l','e','\xe8',
/* 0x239ad = "Stor.E Slim USB 3.0" */
    'S','t','o','r','.','E',' ','S','l','i','m',' ','\x0a',' ','3','.','0',
/* 0x239be = "ACR1281U-C4 (BSI)" */
    'A','C','R','1','2','8','1','U','-','C','4',' ','(','B','S','I',')',
/* 0x239cf = "MSI Starcam Racer" */
    'M','S','I',' ','S','t','a','r','c','a','m',' ','R','a','c','e','r',
/* 0x239e0 = "Android Phone [Evo Shift 4G]" */
    '\xce','\x19',' ','[','E','v','o',' ','S','h','i','f','t',' ','4','G',']',
/* 0x239f1 = "WingMan Precision" */
    'W','i','n','g','M','a','n',' ','P','r','e','c','i','s','i','o','n',
/* 0x23a02 = "Peripheral Switch" */
    'P','e','r','i','p','h','e','r','a','l',' ','S','w','i','t','c','h',
/* 0x23a13 = "Funai Electric Co., Ltd" */
    'F','u','n','a','i',' ','E','l','e','c','t','r','i','c',' ','\x0e','\x16',
/* 0x23a24 = "Officejet Pro 8500A" */
    'O','f','f','i','c','e','j','e','t',' ','\x8f',' ','8','5','0','0','A',
/* 0x23a35 = "Canvio Basics HDD" */
    'C','a','n','v','i','o',' ','B','a','s','i','c','s',' ','H','D','D',
/* 0x23a46 = "MS-6970 BToes Bluetooth adapter" */
    'M','S','-','6','9','7','0',' ','B','T','o','e','s',' ','\x06',' ','\xd0',
/* 0x23a57 = "VTech Holdings, Ltd" */
    'V','T','e','c','h',' ','H','o','l','d','i','n','g','s',',',' ','\x16',
/* 0x23a68 = "Elecom UCAM-DLQ30" */
    'E','l','e','c','o','m',' ','U','C','A','M','-','D','L','Q','3','0',
/* 0x23a79 = "Magicolor 2300 DL" */
    'M','a','g','i','c','o','l','o','r',' ','2','3','0','0',' ','D','L',
/* 0x23a8a = "BK-7m/VIMA JM-5/8" */
    'B','K','-','7','m','/','V','I','M','A',' ','J','M','-','5','/','8',
/* 0x23a9b = "Optical Wheel Mouse (OMS3CH)" */
    '\x7b','W','h','e','e','l',' ','\x0b',' ','(','O','M','S','3','C','H',')',
/* 0x23aac = "SeaLINK+8 (Port 1+2)" */
    'S','e','a','L','I','N','K','+','8',' ','(','\x87',' ','1','+','2',')',
/* 0x23abd = "Cinergy Hybrid XE" */
    'C','i','n','e','r','g','y',' ','H','y','b','r','i','d',' ','X','E',
/* 0x23ace = "TOUCHSTONE DEVICE" */
    'T','O','U','C','H','S','T','O','N','E',' ','D','E','V','I','C','E',
/* 0x23adf = "Chee Chen Hi-Technology Co., Ltd" */
    'C','h','e','e',' ','C','h','e','n',' ','H','i','-','\x0d',' ','\x0e','\x16',
/* 0x23af0 = "USB Wireless 2.4GHz Gamepad" */
    '\x0a',' ','\x01','2','.','4','G','H','z',' ','G','a','m','e','p','a','d',
/* 0x23b01 = "E71 (Media transfer mode)" */
    'E','7','1',' ','(','\xa1',' ','t','r','a','n','s','f','e','r',' ','\x1a',
/* 0x23b12 = "Jolla Phone Developer" */
    'J','o','l','l','a',' ','\x19',' ','D','e','v','e','l','o','p','e','r',
/* 0x23b23 = "Wireless Missile Launcher" */
    '\x01','M','i','s','s','i','l','e',' ','L','a','u','n','c','h','e','r',
/* 0x23b34 = "Intensity Shuttle" */
    'I','n','t','e','n','s','i','t','y',' ','S','h','u','t','t','l','e',
/* 0x23b45 = "RTL8192SU 802.11n WLAN Adapter" */
    'R','T','L','8','1','9','2','S','U',' ','\x99','W','L','A','N',' ','\x02',
/* 0x23b56 = "PR1500LCDRT2U UPS" */
    'P','R','1','5','0','0','L','C','D','R','T','2','U',' ','U','P','S',
/* 0x23b67 = "ATI Remote Wonder II Controller" */
    'A','T','I',' ','\xcb',' ','W','o','n','d','e','r',' ','I','I',' ','\x13',
/* 0x23b78 = "JAF Mobile Phone Flasher Interface" */
    'J','A','F',' ','\x96',' ','\x19',' ','F','l','a','s','h','e','r',' ','\x81',
/* 0x23b89 = "Infinity Smart module" */
    'I','n','f','i','n','i','t','y',' ','\x12',' ','m','o','d','u','l','e',
/* 0x23b9a = "OneTouch 8600 EPP/USB Scanner" */
    'O','n','e','\x9d',' ','8','6','0','0',' ','E','P','P','/','\x0a',' ','\x25',
/* 0x23bab = "Iwatsu America, Inc." */
    'I','w','a','t','s','u',' ','A','m','e','r','i','c','a',',',' ','\x07',
/* 0x23bbc = "AR9170+AR9104 802.11abgn Wireless Adapter" */
    'A','R','9','1','7','0','+','A','R','9','1','0','4',' ','\xea','\x01','\x02',
/* 0x23bcd = "eToken Pro v4.1.5.x" */
    'e','T','o','k','e','n',' ','\x8f',' ','v','4','.','1','.','5','.','x',
/* 0x23bde = "Camera (Notebooks Pro)" */
    '\x04',' ','(','N','o','t','e','b','o','o','k','s',' ','P','r','o',')',
/* 0x23bef = "Pro Flight Quadrant" */
    '\x8f',' ','F','l','i','g','h','t',' ','Q','u','a','d','r','a','n','t',
/* 0x23c00 = "34411A Multimeter" */
    '3','4','4','1','1','A',' ','M','u','l','t','i','m','e','t','e','r',
/* 0x23c11 = "Agilent Technologies (E6473)" */
    'A','g','i','l','e','n','t',' ','\x88',' ','(','E','6','4','7','3',')',
/* 0x23c22 = "Power Sentry/Newpoint" */
    '\x24',' ','S','e','n','t','r','y','/','N','e','w','p','o','i','n','t',
/* 0x23c33 = "Eumex 504PC (FlashLoad)" */
    'E','u','m','e','x',' ','5','0','4','\x1f','(','\x3c','L','o','a','d',')',
/* 0x23c44 = "IR-2510 usb phone" */
    'I','R','-','2','5','1','0',' ','u','s','b',' ','p','h','o','n','e',
/* 0x23c55 = "Broadband stick (modem on)" */
    '\xb7','s','t','i','c','k',' ','(','m','o','d','e','m',' ','o','n',')',
/* 0x23c66 = "Oregon Scientific" */
    'O','r','e','g','o','n',' ','S','c','i','e','n','t','i','f','i','c',
/* 0x23c77 = "G-Shot G312 Still Camera Device" */
    'G','-','\x84','G','3','1','2',' ','S','t','i','l','l',' ','\x04',' ','\x03',
/* 0x23c88 = "Stewart Connector" */
    'S','t','e','w','a','r','t',' ','C','o','n','n','e','c','t','o','r',
/* 0x23c99 = "PenMount 5000 Touch Controller" */
    'P','e','n','M','o','u','n','t',' ','5','0','0','0',' ','\x9d',' ','\x13',
/* 0x23caa = "Delkin Devices, Inc." */
    'D','e','l','k','i','n',' ','D','e','v','i','c','e','s',',',' ','\x07',
/* 0x23cbb = "FXMC Neural Network Controller V3" */
    'F','X','M','C',' ','N','e','u','r','a','l',' ','\x8d','\x13',' ','V','3',
/* 0x23ccc = "USBee AX-Standard" */
    'U','S','B','e','e',' ','A','X','-','S','t','a','n','d','a','r','d',
/* 0x23cdd = "Leapster Explorer" */
    'L','e','a','p','s','t','e','r',' ','E','x','p','l','o','r','e','r',
/* 0x23cee = "Shamrock Tech. Co., Ltd" */
    'S','h','a','m','r','o','c','k',' ','T','e','c','h','.',' ','\x0e','\x16',
/* 0x23cff = "Wally 2.2 chipset" */
    'W','a','l','l','y',' ','2','.','2',' ','c','h','i','p','s','e','t',
/* 0x23d10 = "StudioGT monitors" */
    'S','t','u','d','i','o','G','T',' ','m','o','n','i','t','o','r','s',
/* 0x23d21 = "Tiger Minicard R2" */
    'T','i','g','e','r',' ','M','i','n','i','c','a','r','d',' ','R','2',
/* 0x23d32 = "RTL8188RU 802.11n WLAN Adapter" */
    'R','T','L','8','1','8','8','R','U',' ','\x99','W','L','A','N',' ','\x02',
/* 0x23d43 = "Foot Switch RS-26" */
    'F','o','o','t',' ','S','w','i','t','c','h',' ','R','S','-','2','6',
/* 0x23d54 = "Foot Switch RS-28" */
    'F','o','o','t',' ','S','w','i','t','c','h',' ','R','S','-','2','8',
/* 0x23d65 = "Aluminium Keyboard (ISO)" */
    'A','l','u','m','i','n','i','u','m',' ','\x05',' ','(','I','S','O',')',
/* 0x23d76 = "System Support Co., Ltd" */
    'S','y','s','t','e','m',' ','S','u','p','p','o','r','t',' ','\x0e','\x16',
/* 0x23d87 = "PCT Multitouch HID Controller" */
    'P','C','T',' ','M','u','l','t','i','t','o','u','c','h',' ','\xf2','\x13',
/* 0x23d98 = "CTF-420 [Volito2]" */
    'C','T','F','-','4','2','0',' ','[','V','o','l','i','t','o','2',']',
/* 0x23da9 = "Data Transmission Network Corp." */
    '\xe7',' ','T','r','a','n','s','m','i','s','s','i','o','n',' ','\x8d','\x10',
/* 0x23dba = "M-Audio Audiophile DFU" */
    'M','-','\x8b','A','u','d','i','o','p','h','i','l','e',' ','D','F','U',
/* 0x23dcb = "USB to ATAPI bridge" */
    '\x0a',' ','t','o',' ','A','T','A','P','I',' ','b','r','i','d','g','e',
/* 0x23ddc = "Nexus One (debug)" */
    'N','e','x','u','s',' ','O','n','e',' ','(','d','e','b','u','g',')',
/* 0x23ded = "BearPaw 4800 TA Pro" */
    'B','e','a','r','P','a','w',' ','4','8','0','0',' ','T','A',' ','\x8f',
/* 0x23dfe = "C905 Phone [Mass Storage]" */
    'C','9','0','5',' ','\x19',' ','[','\x7c','S','t','o','r','a','g','e',']',
/* 0x23e0f = "Quartz Ingenierie" */
    'Q','u','a','r','t','z',' ','I','n','g','e','n','i','e','r','i','e',
/* 0x23e20 = "LAN-W300AN/U2 Wireless LAN Adapter" */
    'L','A','N','-','W','3','0','0','A','N','/','U','2',' ','\x01','\xf3','\x02',
/* 0x23e31 = "BearPaw 2448 CU Pro" */
    'B','e','a','r','P','a','w',' ','2','4','4','8',' ','C','U',' ','\x8f',
/* 0x23e42 = "9FF2 [Digital Photo Display]" */
    '9','F','F','2',' ','[','\x09','\x86',' ','D','i','s','p','l','a','y',']',
/* 0x23e53 = "Telia Research AB" */
    'T','e','l','i','a',' ','R','e','s','e','a','r','c','h',' ','A','B',
/* 0x23e64 = "SUNTAC Ir-Trinity" */
    'S','U','N','T','A','C',' ','I','r','-','T','r','i','n','i','t','y',
/* 0x23e75 = "OpenDCC (Sniffer)" */
    'O','p','e','n','D','C','C',' ','(','S','n','i','f','f','e','r',')',
/* 0x23e86 = "JL2005B/C/D Toy Camera" */
    'J','L','2','0','0','5','B','/','C','/','D',' ','T','o','y',' ','\x04',
/* 0x23e97 = "Astra 2200/2200SU" */
    'A','s','t','r','a',' ','2','2','0','0','/','2','2','0','0','S','U',
/* 0x23ea8 = "WireSpeed Dual Connect Modem" */
    'W','i','r','e','S','p','e','e','d',' ','D','u','a','l',' ','\xee','\x1c',
/* 0x23eb9 = "OpenSDA - CDC Serial Port" */
    'O','p','e','n','S','D','A',' ','-',' ','C','D','C',' ','\x90',' ','\x87',
/* 0x23eca = "MFC-410CN RemovableDisk" */
    '\x7d','4','1','0','C','N',' ','R','e','m','o','v','a','b','l','e','\xe8',
/* 0x23edb = "DaeWoo Telecom, Ltd" */
    'D','a','e','W','o','o',' ','T','e','l','e','c','o','m',',',' ','\x16',
/* 0x23eec = "WLI-UC-G300HP Wireless LAN Adapter" */
    'W','L','I','-','U','C','-','G','3','0','0','H','P',' ','\x01','\xf3','\x02',
/* 0x23efd = "USB 2.0 IDE Adapter [GL811E]" */
    '\x0a',' ','\xc1','I','D','E',' ','\x02',' ','[','G','L','8','1','1','E',']',
/* 0x23f0e = "Droid X (Windows media mode)" */
    'D','r','o','i','d',' ','X',' ','(','\x83','m','e','d','i','a',' ','\x1a',
/* 0x23f1f = "ErgoFit Wireless Optical Mouse (HID)" */
    'E','r','g','o','F','i','t',' ','\x01','\x7b','\x0b',' ','(','H','I','D',')',
/* 0x23f30 = "Japanese Keyboard - 595U" */
    'J','a','p','a','n','e','s','e',' ','\x05',' ','-',' ','5','9','5','U',
/* 0x23f41 = "Premium Starter Webcam" */
    'P','r','e','m','i','u','m',' ','S','t','a','r','t','e','r',' ','\x11',
/* 0x23f52 = "Take-it Still Camera Device" */
    'T','a','k','e','-','i','t',' ','S','t','i','l','l',' ','\x04',' ','\x03',
/* 0x23f63 = "CableStar Combo HD CI" */
    '\xa5','S','t','a','r',' ','C','o','m','b','o',' ','H','D',' ','C','I',
/* 0x23f74 = "NCP engineering GmbH" */
    'N','C','P',' ','e','n','g','i','n','e','e','r','i','n','g',' ','\xfc',
/* 0x23f85 = "Gretag-Macbeth AG" */
    'G','r','e','t','a','g','-','M','a','c','b','e','t','h',' ','A','G',
/* 0x23f96 = "ZR70MC Digital Camcorder" */
    'Z','R','7','0','M','C',' ','\x09','C','a','m','c','o','r','d','e','r',
/* 0x23fa7 = "APOLLO P2500/2600" */
    'A','P','O','L','L','O',' ','P','2','5','0','0','/','2','6','0','0',
/* 0x23fb8 = "FreeAgent External Hard Drive" */
    'F','r','e','e','A','g','e','n','t',' ','\xe3','H','a','r','d',' ','\x14',
/* 0x23fc9 = "Mouse*in*a*Box Optical Pro" */
    'M','o','u','s','e','*','i','n','*','a','*','B','o','x',' ','\x7b','\x8f',
/* 0x23fda = "Discovery Kids Digital Camera" */
    'D','i','s','c','o','v','e','r','y',' ','K','i','d','s',' ','\x09','\x04',
/* 0x23feb = "PCX2000 Cable Modem (WDM)" */
    'P','C','X','2','0','0','0',' ','\xa5',' ','\x1c',' ','(','W','D','M',')',
/* 0x23ffc = "PL2305 Parallel Port" */
    'P','L','2','3','0','5',' ','P','a','r','a','l','l','e','l',' ','\x87',
/* 0x2400d = "Hauppauge WinTV (PAL D/K FM)" */
    '\xfb','W','i','n','\xda','(','P','A','L',' ','D','/','K',' ','F','M',')',
/* 0x2401e = "SideWinder Game Pad" */
    'S','i','d','e','W','i','n','d','e','r',' ','G','a','m','e',' ','\xfa',
/* 0x2402f = "802.11b/g/n USB Wireless Network Adapter" */
    '8','0','2','.','1','1','b','/','g','/','n',' ','\x0a',' ','\x01','\x8d','\x02',
/* 0x24040 = "API Generic K/B Mouse" */
    'A','P','I',' ','G','e','n','e','r','i','c',' ','K','/','B',' ','\x0b',
/* 0x24051 = "Walkman NWD-B103F" */
    'W','a','l','k','m','a','n',' ','N','W','D','-','B','1','0','3','F',
/* 0x24062 = "3C460B 10/100 Ethernet Adapter" */
    '3','C','4','6','0','B',' ','1','0','/','1','0','0',' ','\x7f',' ','\x02',
/* 0x24073 = "USB to CompactFlash Card Reader" */
    '\x0a',' ','t','o',' ','C','o','m','p','a','c','t','\x3c',' ','\x15',' ','\x08',
/* 0x24084 = "ET/TX Ethernet [pegasus]" */
    'E','T','/','T','X',' ','\x7f',' ','[','p','e','g','a','s','u','s',']',
/* 0x24095 = "MicroLink 56k (V.250)" */
    '\xc4','L','i','n','k',' ','5','6','k',' ','(','V','.','2','5','0',')',
/* 0x240a6 = "WL-301 Wireless Network 300N USB Adapter" */
    'W','L','-','3','0','1',' ','\x01','\x8d','3','0','0','N',' ','\x0a',' ','\x02',
/* 0x240b7 = "Tamagawa Seiki Co., Ltd" */
    'T','a','m','a','g','a','w','a',' ','S','e','i','k','i',' ','\x0e','\x16',
/* 0x240c8 = "Vuzix Corporation" */
    'V','u','z','i','x',' ','C','o','r','p','o','r','a','t','i','o','n',
/* 0x240d9 = "Korea Techtron Co., Ltd." */
    'K','o','r','e','a',' ','T','e','c','h','t','r','o','n',' ','\x0e','\xab',
/* 0x240ea = "M-Audio Ozone Academic" */
    'M','-','\x8b','O','z','o','n','e',' ','A','c','a','d','e','m','i','c',
/* 0x240fb = "USBAT ATA/ATAPI Adapter" */
    'U','S','B','A','T',' ','A','T','A','/','A','T','A','P','I',' ','\x02',
/* 0x2410c = "Astra 1600U/2000U" */
    'A','s','t','r','a',' ','1','6','0','0','U','/','2','0','0','0','U',
/* 0x2411d = "VvBus for Helium 2xx" */
    'V','v','B','u','s',' ','\xcc','H','e','l','i','u','m',' ','2','x','x',
/* 0x2412e = "Cyborg Graphite Stick" */
    'C','y','b','o','r','g',' ','G','r','a','p','h','i','t','e',' ','\xb3',
/* 0x2413f = "LP2475w Monitor Hub" */
    'L','P','2','4','7','5','w',' ','M','o','n','i','t','o','r',' ','\xa4',
/* 0x24150 = "9000 Phone [Mass Storage]" */
    '9','0','0','0',' ','\x19',' ','[','\x7c','S','t','o','r','a','g','e',']',
/* 0x24161 = "10 inch Mobile Monitor" */
    '1','0',' ','i','n','c','h',' ','\x96',' ','M','o','n','i','t','o','r',
/* 0x24172 = "Winbond Electronics Corp. [hex]" */
    'W','i','n','b','o','n','d',' ','\x1b',' ','\x10',' ','[','h','e','x',']',
/* 0x24183 = "Trust Office Scan USB 19200" */
    'T','r','u','s','t',' ','\xd3',' ','\x8a',' ','\x0a',' ','1','9','2','0','0',
/* 0x24194 = "R100 Sports Wheel" */
    'R','1','0','0',' ','S','p','o','r','t','s',' ','W','h','e','e','l',
/* 0x241a5 = "WL-188 Wireless Network 300N USB Adapter" */
    'W','L','-','1','8','8',' ','\x01','\x8d','3','0','0','N',' ','\x0a',' ','\x02',
/* 0x241b6 = "XTNDAccess IrDA Dongle" */
    'X','T','N','D','A','c','c','e','s','s',' ','I','r','D','A',' ','\xf4',
/* 0x241c7 = "USS720 Parallel Port" */
    'U','S','S','7','2','0',' ','P','a','r','a','l','l','e','l',' ','\x87',
/* 0x241d8 = "CM102-A+/102S+ Audio Controller" */
    'C','M','1','0','2','-','A','+','/','1','0','2','S','+',' ','\x8b','\x13',
/* 0x241e9 = "F5D5050 100Mbps Ethernet" */
    'F','5','D','5','0','5','0',' ','1','0','0','M','b','p','s',' ','\x7f',
/* 0x241fa = "GT-9400UF [Perfection 3170]" */
    'G','T','-','9','4','0','0','U','F',' ','[','\xf0','3','1','7','0',']',
/* 0x2420b = "Logic Controls, Inc." */
    'L','o','g','i','c',' ','C','o','n','t','r','o','l','s',',',' ','\x07',
/* 0x2421c = "UMAX Astra 6700 Scanner" */
    'U','M','A','X',' ','A','s','t','r','a',' ','6','7','0','0',' ','\x25',
/* 0x2422d = "Rio Karma Music Player" */
    'R','i','o',' ','K','a','r','m','a',' ','M','u','s','i','c',' ','\x1e',
/* 0x2423e = "CD-R Drive KXL-CB20AN" */
    'C','D','-','R',' ','\x14',' ','K','X','L','-','C','B','2','0','A','N',
/* 0x2424f = "DCP-750CN RemovableDisk" */
    '\xaa','7','5','0','C','N',' ','R','e','m','o','v','a','b','l','e','\xe8',
/* 0x24260 = "PI Engineering, Inc." */
    'P','I',' ','E','n','g','i','n','e','e','r','i','n','g',',',' ','\x07',
/* 0x24271 = "Minds At Work LLC" */
    'M','i','n','d','s',' ','A','t',' ','W','o','r','k',' ','L','L','C',
/* 0x24282 = "SolidTek USB 2p HUB" */
    'S','o','l','i','d','T','e','k',' ','\x0a',' ','2','p',' ','H','U','B',
/* 0x24293 = "SynerTek Korea, Inc." */
    'S','y','n','e','r','T','e','k',' ','K','o','r','e','a',',',' ','\x07',
/* 0x242a4 = "V.60c/V.60i GSM Phone" */
    'V','.','6','0','c','/','V','.','6','0','i',' ','G','S','M',' ','\x19',
/* 0x242b5 = "W200 Phone (Mass Storage)" */
    'W','2','0','0',' ','\x19',' ','(','\x7c','S','t','o','r','a','g','e',')',
/* 0x242c6 = "ScanMaker V6USL (#2)" */
    '\x8a','M','a','k','e','r',' ','V','6','U','S','L',' ','(','#','2',')',
/* 0x242d7 = "PX-502A [Stylus SX515W]" */
    'P','X','-','5','0','2','A',' ','[','\xb1','S','X','5','1','5','W',']',
/* 0x242e8 = "deUSB level shifter" */
    'd','e','\x0a',' ','l','e','v','e','l',' ','s','h','i','f','t','e','r',
/* 0x242f9 = "cyberJack compact" */
    'c','y','b','e','r','J','a','c','k',' ','c','o','m','p','a','c','t',
/* 0x2430a = "Meade ETX-105EC Camera" */
    'M','e','a','d','e',' ','E','T','X','-','1','0','5','E','C',' ','\x04',
/* 0x2431b = "Motorola 802.11n 5G USB Wireless Adapter" */
    'M','o','t','o','r','o','l','a',' ','\x99','5','G',' ','\x0a',' ','\x01','\x02',
/* 0x2432c = "MFC-4420C RemovableDisk" */
    '\x7d','4','4','2','0','C',' ','R','e','m','o','v','a','b','l','e','\xe8',
/* 0x2433d = "Trek Technology (S) PTE, Ltd" */
    'T','r','e','k',' ','\x0d',' ','(','S',')',' ','P','T','E',',',' ','\x16',
/* 0x2434e = "Samsung Electronics America" */
    'S','a','m','s','u','n','g',' ','\x1b',' ','A','m','e','r','i','c','a',
/* 0x2435f = "DVD-ROM & CD-R/RW" */
    'D','V','D','-','R','O','M',' ','&',' ','C','D','-','R','/','R','W',
/* 0x24370 = "Star Micronics Co., Ltd" */
    'S','t','a','r',' ','M','i','c','r','o','n','i','c','s',' ','\x0e','\x16',
/* 0x24381 = "Strobe Pro Scanner (1.01)" */
    'S','t','r','o','b','e',' ','\x8f',' ','\x25',' ','(','1','.','0','1',')',
/* 0x24392 = "NV-GS15 (webcam mode)" */
    'N','V','-','G','S','1','5',' ','(','w','e','b','c','a','m',' ','\x1a',
/* 0x243a3 = "Mach4/200 Label Printer" */
    'M','a','c','h','4','/','2','0','0',' ','L','a','b','e','l',' ','\x0c',
/* 0x243b4 = "W995 Phone (Mass Storage)" */
    'W','9','9','5',' ','\x19',' ','(','\x7c','S','t','o','r','a','g','e',')',
/* 0x243c5 = "ME-6000ISLE/8/DIO" */
    'M','E','-','6','0','0','0','I','S','L','E','/','8','/','D','I','O',
/* 0x243d6 = "Delkin eFilm Reader-32" */
    'D','e','l','k','i','n',' ','e','F','i','l','m',' ','\x08','-','3','2',
/* 0x243e7 = "Precision Gamepad" */
    'P','r','e','c','i','s','i','o','n',' ','G','a','m','e','p','a','d',
/* 0x243f8 = "Deskjet 1050 J410" */
    'D','e','s','k','j','e','t',' ','1','0','5','0',' ','J','4','1','0',
/* 0x24409 = "VL-Z7S Digital Camcorder" */
    'V','L','-','Z','7','S',' ','\x09','C','a','m','c','o','r','d','e','r',
/* 0x2441a = "IDT1221U RS-232 Adapter" */
    'I','D','T','1','2','2','1','U',' ','R','S','-','2','3','2',' ','\x02',
/* 0x2442b = "AVC-1100 Audio Capture" */
    'A','V','C','-','1','1','0','0',' ','\x8b','C','a','p','t','u','r','e',
/* 0x2443c = "Lenovo Integrated Camera (0.3MP)" */
    'L','e','n','o','v','o',' ','\x18','\x04',' ','(','0','.','3','M','P',')',
/* 0x2444d = "Harmony 300/350 Remote" */
    'H','a','r','m','o','n','y',' ','3','0','0','/','3','5','0',' ','\xcb',
/* 0x2445e = "WT-220U DVB-T dongle" */
    'W','T','-','2','2','0','U',' ','\xa7','T',' ','d','o','n','g','l','e',
/* 0x2446f = "SSS Headphone Set" */
    'S','S','S',' ','H','e','a','d','p','h','o','n','e',' ','S','e','t',
/* 0x24480 = "Zephyr BioHarness" */
    'Z','e','p','h','y','r',' ','B','i','o','H','a','r','n','e','s','s',
/* 0x24491 = "StarTAC III MS900" */
    'S','t','a','r','T','A','C',' ','I','I','I',' ','M','S','9','0','0',
/* 0x244a2 = "Jam Studio Tablet" */
    'J','a','m',' ','S','t','u','d','i','o',' ','T','a','b','l','e','t',
/* 0x244b3 = "SATALink SPIF225A" */
    'S','A','T','A','L','i','n','k',' ','S','P','I','F','2','2','5','A',
/* 0x244c4 = "Onda (unverified)" */
    'O','n','d','a',' ','(','u','n','v','e','r','i','f','i','e','d',')',
/* 0x244d5 = "Rigol Technologies DS5000USB Oscilloscope" */
    'R','i','g','o','l',' ','\x88',' ','D','S','5','0','0','0','\x0a',' ','\xfe',
/* 0x244e6 = "Playmates Toys, Inc." */
    'P','l','a','y','m','a','t','e','s',' ','T','o','y','s',',',' ','\x07',
/* 0x244f7 = "PL2307 USB-ATAPI4 Bridge" */
    'P','L','2','3','0','7',' ','\x0a','-','A','T','A','P','I','4',' ','\x9f',
/* 0x24508 = "Silicon Vision, Inc." */
    'S','i','l','i','c','o','n',' ','V','i','s','i','o','n',',',' ','\x07',
/* 0x24519 = "Standalone HSPA device" */
    'S','t','a','n','d','a','l','o','n','e',' ','H','S','P','A',' ','\xf9',
/* 0x2452a = "BMC Messsysteme GmbH" */
    'B','M','C',' ','M','e','s','s','s','y','s','t','e','m','e',' ','\xfc',
/* 0x2453b = "GT-7700U [Perfection 1240U]" */
    'G','T','-','7','7','0','0','U',' ','[','\xf0','1','2','4','0','U',']',
/* 0x2454c = "Guardant Code HID" */
    'G','u','a','r','d','a','n','t',' ','C','o','d','e',' ','H','I','D',
/* 0X2455d = "DeltaCo TB-106U Keyboard" */
    'e','l','t','a','C','o',' ','T','B','-','1','0','6','U',' ','\x05',
/* 0x2456d = "Ember Corporation" */
    'E','m','b','e','r',' ','C','o','r','p','o','r','a','t','i','o','n',
/* 0x2457e = "Cinergy Analog XS" */
    'C','i','n','e','r','g','y',' ','A','n','a','l','o','g',' ','X','S',
/* 0x2458f = "WRITECHIP II CCID" */
    'W','R','I','T','E','C','H','I','P',' ','I','I',' ','C','C','I','D',
/* 0x245a0 = "Wireless Receiver (RC Laser Pointer)" */
    '\x01','\x8c',' ','(','R','C',' ','\x82',' ','P','o','i','n','t','e','r',')',
/* 0x245b1 = "FinePix S3000 Zoom (PC CAM)" */
    '\xca','i','x',' ','S','3','0','0','0',' ','\xe6','(','\x1f','C','A','M',')',
/* 0x245c2 = "M25 Digital Postal Scale" */
    'M','2','5',' ','\x09','P','o','s','t','a','l',' ','S','c','a','l','e',
/* 0x245d3 = "CKF7037 HP webcam" */
    'C','K','F','7','0','3','7',' ','H','P',' ','w','e','b','c','a','m',
/* 0x245e4 = "Cayman 3352 DSL Modem" */
    'C','a','y','m','a','n',' ','3','3','5','2',' ','D','S','L',' ','\x1c',
/* 0x245f5 = "Magic Keys (boot)" */
    'M','a','g','i','c',' ','K','e','y','s',' ','(','b','o','o','t',')',
/* 0x24606 = "Optical dual-touch panel" */
    '\x7b','d','u','a','l','-','t','o','u','c','h',' ','p','a','n','e','l',
/* 0x24617 = "Point of Sale Handheld Scanner" */
    'P','o','i','n','t',' ','o','f',' ','S','a','l','e',' ','\xc5',' ','\x25',
/* 0x24628 = "LUFA Datalogger Device" */
    'L','U','F','A',' ','D','a','t','a','l','o','g','g','e','r',' ','\x03',
/* 0x24639 = "smartNIC Ethernet [catc]" */
    's','m','a','r','t','N','I','C',' ','\x7f',' ','[','c','a','t','c',']',
/* 0x2464a = "Cytronix 6in1 Card Reader" */
    'C','y','t','r','o','n','i','x',' ','6','i','n','1',' ','\x15',' ','\x08',
/* 0x2465b = "CanoScan N650U/N656U" */
    'C','a','n','o','\x8a',' ','N','6','5','0','U','/','N','6','5','6','U',
/* 0x2466c = "ADSL Modem HM120dp Loader" */
    '\xf1','\x1c',' ','H','M','1','2','0','d','p',' ','L','o','a','d','e','r',
/* 0x2467d = "BenQ-Siemens SF71" */
    'B','e','n','Q','-','S','i','e','m','e','n','s',' ','S','F','7','1',
/* 0x2468e = "Lernout + Hauspie" */
    'L','e','r','n','o','u','t',' ','+',' ','H','a','u','s','p','i','e',
/* 0x2469f = "Flight Sim Pedals" */
    'F','l','i','g','h','t',' ','S','i','m',' ','P','e','d','a','l','s',
/* 0x246b0 = "Bresser Biolux NV" */
    'B','r','e','s','s','e','r',' ','B','i','o','l','u','x',' ','N','V',
/* 0x246c1 = "JumpDrive 128MB/256MB" */
    'J','u','m','p','\x14',' ','1','2','8','M','B','/','2','5','6','M','B',
/* 0x246d2 = "Hitachi ULSI Systems Co., Ltd" */
    'H','i','t','a','c','h','i',' ','U','L','S','I',' ','\xa6',' ','\x0e','\x16',
/* 0x246e3 = "SoundBlaster MP3+" */
    'S','o','u','n','d','B','l','a','s','t','e','r',' ','M','P','3','+',
/* 0x246f4 = "OpenDCC (Gateway)" */
    'O','p','e','n','D','C','C',' ','(','G','a','t','e','w','a','y',')',
/* 0x24705 = "BLUTRONICS S.r.l." */
    'B','L','U','T','R','O','N','I','C','S',' ','S','.','r','.','l','.',
/* 0x24716 = "Cactus RF60 (DFU)" */
    'C','a','c','t','u','s',' ','R','F','6','0',' ','(','D','F','U',')',
/* 0x24727 = "Thales Norway A/S" */
    'T','h','a','l','e','s',' ','N','o','r','w','a','y',' ','A','/','S',
/* 0x24738 = "RTL8723AU 802.11n WLAN Adapter" */
    'R','T','L','8','7','2','3','A','U',' ','\x99','W','L','A','N',' ','\x02',
/* 0x24749 = "SD/MMC/RS-MMC Card Reader" */
    'S','D','/','M','M','C','/','R','S','-','M','M','C',' ','\x15',' ','\x08',
/* 0x2475a = "Foxconn / Hon Hai" */
    'F','o','x','c','o','n','n',' ','/',' ','H','o','n',' ','H','a','i',
/* 0x2476b = "ACR1281U-C5 (BSI)" */
    'A','C','R','1','2','8','1','U','-','C','5',' ','(','B','S','I',')',
/* 0x2477c = "Storage Adapter ISD-300LP (CY)" */
    '\x0f','\x02',' ','I','S','D','-','3','0','0','L','P',' ','(','C','Y',')',
/* 0x2478d = "N\'Able (DataBook) Technologies, Inc." */
    'N','\'','A','b','l','e',' ','(','\xe7','B','o','o','k',')',' ','\x89','\x07',
/* 0x2479e = "Libra-Q26 / 1.0 Remote" */
    'L','i','b','r','a','-','Q','2','6',' ','/',' ','1','.','0',' ','\xcb',
/* 0x247af = "ME-6100ISLE/4/DIO" */
    'M','E','-','6','1','0','0','I','S','L','E','/','4','/','D','I','O',
/* 0x247c0 = "Hauppauge USB-Live Model 600" */
    '\xfb','\x0a','-','L','i','v','e',' ','M','o','d','e','l',' ','6','0','0',
/* 0x247d1 = "Xonar U1 Audio Station" */
    'X','o','n','a','r',' ','U','1',' ','\x8b','S','t','a','t','i','o','n',
/* 0x247e2 = "ES-H300 [GT-2500]" */
    'E','S','-','H','3','0','0',' ','[','G','T','-','2','5','0','0',']',
/* 0x247f3 = "Insyde Software Corp." */
    'I','n','s','y','d','e',' ','S','o','f','t','w','a','r','e',' ','\x10',
/* 0x24804 = "T.16000M Joystick" */
    'T','.','1','6','0','0','0','M',' ','J','o','y','s','t','i','c','k',
/* 0x24815 = "FSK Electronics Super GSM Reader" */
    'F','S','K',' ','\x1b',' ','S','u','p','e','r',' ','G','S','M',' ','\x08',
/* 0x24826 = "CTH-301 [Bamboo]" */
    'C','T','H','-','3','0','1',' ','[','B','a','m','b','o','o',']',
/* 0x24836 = "ZFG-9800-AC SmartCard Reader" */
    'Z','F','G','-','9','8','0','0','-','A','C',' ','\x12','\x15',' ','\x08',
/* 0x24846 = "VE-CG30 Digital Still Camera" */
    'V','E','-','C','G','3','0',' ','\x09','S','t','i','l','l',' ','\x04',
/* 0x24856 = "CS8819A2-114 Mass Storage Device" */
    'C','S','8','8','1','9','A','2','-','1','1','4',' ','\x7c','\x0f','\x03',
/* 0x24866 = "C5 Digital Media Camera (PictBridge mode)" */
    'C','5',' ','\x09','\xa1',' ','\x04',' ','(','P','i','c','t','\x9f',' ','\x1a',
/* 0x24876 = "Nomad MuVo TX FM" */
    'N','o','m','a','d',' ','M','u','V','o',' ','T','X',' ','F','M',
/* 0x24886 = "Syntek USB 2.0 UVC PC Camera" */
    'S','y','n','t','e','k',' ','\x0a',' ','\xc1','U','V','C',' ','\x1f','\x04',
/* 0x24896 = "Zip 100 (Type 3)" */
    'Z','i','p',' ','1','0','0',' ','(','T','y','p','e',' ','3',')',
/* 0x248a6 = "Flash Drive (Store\'n\'Go)" */
    '\x3c',' ','\x14',' ','(','S','t','o','r','e','\'','n','\'','G','o',')',
/* 0x248b6 = "Integrated Bluetooth (Taiyo Yuden)" */
    '\x18','\x06',' ','(','T','a','i','y','o',' ','Y','u','d','e','n',')',
/* 0x248c6 = "Hsin Chen Ent Co., Ltd" */
    'H','s','i','n',' ','C','h','e','n',' ','E','n','t',' ','\x0e','\x16',
/* 0x248d6 = "SmartMedia+MMC/SD+MemoryStick Card Reader" */
    '\x12','\xa1','+','M','M','C','/','S','D','+','\xd2','\xb3',' ','\x15',' ','\x08',
/* 0x248e6 = "Hercules Webcam EC300" */
    'H','e','r','c','u','l','e','s',' ','\x11',' ','E','C','3','0','0',
/* 0x248f6 = "SM/CF/PCMCIA Card Reader" */
    'S','M','/','C','F','/','P','C','M','C','I','A',' ','\x15',' ','\x08',
/* 0x24906 = "RfCat YARD Stick One" */
    'R','f','C','a','t',' ','Y','A','R','D',' ','\xb3',' ','O','n','e',
/* 0x24916 = "OMEGA TECHNOLOGY" */
    'O','M','E','G','A',' ','T','E','C','H','N','O','L','O','G','Y',
/* 0x24926 = "AH-F401U Air H device" */
    'A','H','-','F','4','0','1','U',' ','A','i','r',' ','H',' ','\xf9',
/* 0x24936 = "My Passport Air (WDBBLW)" */
    'M','y',' ','\xd5','A','i','r',' ','(','W','D','B','B','L','W',')',
/* 0x24946 = "Pirelli Remote NDIS Device" */
    'P','i','r','e','l','l','i',' ','\xcb',' ','N','D','I','S',' ','\x03',
/* 0x24956 = "MFC-820CN Remote Setup Port" */
    '\x7d','8','2','0','C','N',' ','\xcb',' ','S','e','t','u','p',' ','\x87',
/* 0x24966 = "OpticBook 3600 Scanner" */
    'O','p','t','i','c','B','o','o','k',' ','3','6','0','0',' ','\x25',
/* 0x24976 = "MFC-3240C Remote Setup Port" */
    '\x7d','3','2','4','0','C',' ','\xcb',' ','S','e','t','u','p',' ','\x87',
/* 0x24986 = "56k Voice FaxModem Pro" */
    '5','6','k',' ','V','o','i','c','e',' ','F','a','x','\x1c',' ','\x8f',
/* 0x24996 = "Programming Unit" */
    'P','r','o','g','r','a','m','m','i','n','g',' ','U','n','i','t',
/* 0x249a6 = "FinePix S5000 Zoom (DSC)" */
    '\xca','i','x',' ','S','5','0','0','0',' ','\xe6','(','D','S','C',')',
/* 0x249b6 = "BT Mini-Receiver (HID proxy mode)" */
    'B','T',' ','\xb9','-','\x8c',' ','(','\xf2','p','r','o','x','y',' ','\x1a',
/* 0x249c6 = "104-key keyboard" */
    '1','0','4','-','k','e','y',' ','k','e','y','b','o','a','r','d',
/* 0x249d6 = "SPC 520/525NC PC Camera" */
    'S','P','C',' ','5','2','0','/','5','2','5','N','C',' ','\x1f','\x04',
/* 0x249e6 = "GemPC433 SL SmartCard Reader" */
    'G','e','m','P','C','4','3','3',' ','S','L',' ','\x12','\x15',' ','\x08',
/* 0x249f6 = "XI-735 Prism3 802.11b Adapter" */
    'X','I','-','7','3','5',' ','P','r','i','s','m','3',' ','\x9b','\x02',
/* 0x24a06 = "KU-0420 keyboard" */
    'K','U','-','0','4','2','0',' ','k','e','y','b','o','a','r','d',
/* 0x24a16 = "Allied Telesyn International" */
    'A','l','l','i','e','d',' ','T','e','l','e','s','y','n',' ','\x9c',
/* 0x24a26 = "NW-E405 Network Walkman" */
    'N','W','-','E','4','0','5',' ','\x8d','W','a','l','k','m','a','n',
/* 0x24a36 = "Linux-USB Printer Gadget" */
    'L','i','n','u','x','-','\x0a',' ','\x0c',' ','G','a','d','g','e','t',
/* 0x24a46 = "FM Transmitter/Receiver" */
    'F','M',' ','T','r','a','n','s','m','i','t','t','e','r','/','\x8c',
/* 0x24a56 = "Nike Psa/Play MP3 Player" */
    'N','i','k','e',' ','P','s','a','/','P','l','a','y',' ','\x8e','\x1e',
/* 0x24a66 = "WL-324 Wireless USB Adapter 300N" */
    'W','L','-','3','2','4',' ','\x01','\x0a',' ','\x02',' ','3','0','0','N',
/* 0x24a76 = "Multiple Vendors" */
    'M','u','l','t','i','p','l','e',' ','V','e','n','d','o','r','s',
/* 0x24a86 = "SUNTAC Slipper U" */
    'S','U','N','T','A','C',' ','S','l','i','p','p','e','r',' ','U',
/* 0x24a96 = "Trust PowerC@m 350FT" */
    'T','r','u','s','t',' ','\x24','C','@','m',' ','3','5','0','F','T',
/* 0X24aa6 = "Trust PowerC@m 350FS" */
    'r','u','s','t',' ','\x24','C','@','m',' ','3','5','0','F','S',
/* 0X24ab5 = "Sun-Riseful Technology Co., Ltd." */
    'u','n','-','R','i','s','e','f','u','l',' ','\x0d',' ','\x0e','\xab',
/* 0x24ac4 = "Dual PCS Adaptor" */
    'D','u','a','l',' ','P','C','S',' ','A','d','a','p','t','o','r',
/* 0x24ad4 = "Bluetooth 2.0+EDR dongle" */
    '\x06',' ','2','.','0','+','E','D','R',' ','d','o','n','g','l','e',
/* 0x24ae4 = "WLP-UC-AG300 Wireless LAN Adapter" */
    'W','L','P','-','U','C','-','A','G','3','0','0',' ','\x01','\xf3','\x02',
/* 0x24af4 = "Genesys Logic, Inc." */
    'G','e','n','e','s','y','s',' ','L','o','g','i','c',',',' ','\x07',
/* 0x24b04 = "Alps Electric, Inc." */
    'A','l','p','s',' ','E','l','e','c','t','r','i','c',',',' ','\x07',
/* 0x24b14 = "FinePix S5500 Zoom (UVC)" */
    '\xca','i','x',' ','S','5','5','0','0',' ','\xe6','(','U','V','C',')',
/* 0x24b24 = "Legend Silicon Corp." */
    'L','e','g','e','n','d',' ','S','i','l','i','c','o','n',' ','\x10',
/* 0x24b34 = "K.S. Terminals Inc." */
    'K','.','S','.',' ','T','e','r','m','i','n','a','l','s',' ','\x07',
/* 0x24b44 = "Webcam Notebook Ultra" */
    '\x11',' ','N','o','t','e','b','o','o','k',' ','U','l','t','r','a',
/* 0x24b54 = "Medion MD 5345 Scanner" */
    'M','e','d','i','o','n',' ','M','D',' ','5','3','4','5',' ','\x25',
/* 0x24b64 = "NuLOOQ navigator" */
    'N','u','L','O','O','Q',' ','n','a','v','i','g','a','t','o','r',
/* 0x24b74 = "Hitachi Cable, Ltd" */
    'H','i','t','a','c','h','i',' ','C','a','b','l','e',',',' ','\x16',
/* 0x24b84 = "Boca Research, Inc." */
    'B','o','c','a',' ','R','e','s','e','a','r','c','h',',',' ','\x07',
/* 0x24b94 = "Union Genius Computer Co., Ltd" */
    'U','n','i','o','n',' ','G','e','n','i','u','s',' ','\xcd','\x0e','\x16',
/* 0x24ba4 = "ikari_01 sd2snes" */
    'i','k','a','r','i','_','0','1',' ','s','d','2','s','n','e','s',
/* 0x24bb4 = "FinePix F601 Zoom (PC CAM)" */
    '\xca','i','x',' ','F','6','0','1',' ','\xe6','(','\x1f','C','A','M',')',
/* 0x24bc4 = "5nes5snes (4x12)" */
    '5','n','e','s','5','s','n','e','s',' ','(','4','x','1','2',')',
/* 0x24bd4 = "PCTV Sat Pro BDA Device" */
    'P','C','T','V',' ','S','a','t',' ','\x8f',' ','B','D','A',' ','\x03',
/* 0x24be4 = "CameraMate (DPCM_USB)" */
    '\x04','M','a','t','e',' ','(','D','P','C','M','_','U','S','B',')',
/* 0x24bf4 = "Prestige Portable Hard Drive" */
    'P','r','e','s','t','i','g','e',' ','\xa9','H','a','r','d',' ','\x14',
/* 0x24c04 = "DCP-110C RemovableDisk" */
    '\xaa','1','1','0','C',' ','R','e','m','o','v','a','b','l','e','\xe8',
/* 0x24c14 = "FinePix S3500 Zoom (DSC)" */
    '\xca','i','x',' ','S','3','5','0','0',' ','\xe6','(','D','S','C',')',
/* 0x24c24 = "Flight Pro Multi Panel" */
    'F','l','i','g','h','t',' ','\x8f',' ','\xd6',' ','P','a','n','e','l',
/* 0x24c34 = "STM32 Audio Streaming" */
    'S','T','M','3','2',' ','\x8b','S','t','r','e','a','m','i','n','g',
/* 0x24c44 = "MS3303H USB-to-Serial Bridge" */
    'M','S','3','3','0','3','H',' ','\x0a','-','t','o','-','\x90',' ','\x9f',
/* 0x24c54 = "Telit Wireless Solutions" */
    'T','e','l','i','t',' ','\x01','S','o','l','u','t','i','o','n','s',
/* 0x24c64 = "F32x USBXpress Device" */
    'F','3','2','x',' ','U','S','B','X','p','r','e','s','s',' ','\x03',
/* 0x24c74 = "Futronic Technology Co. Ltd." */
    'F','u','t','r','o','n','i','c',' ','\x0d',' ','C','o','.',' ','\xab',
/* 0x24c84 = "PNY USB-TV (NTSC) FM" */
    'P','N','Y',' ','\x0a','-','\xda','(','N','T','S','C',')',' ','F','M',
/* 0x24c94 = "I-PAC Arcade Control Interface" */
    'I','-','P','A','C',' ','A','r','c','a','d','e',' ','\xc9',' ','\x81',
/* 0x24ca4 = "Waveterminal U24" */
    'W','a','v','e','t','e','r','m','i','n','a','l',' ','U','2','4',
/* 0x24cb4 = "USB->Din 4 Adaptor" */
    '\x0a','-','>','D','i','n',' ','4',' ','A','d','a','p','t','o','r',
/* 0x24cc4 = "TSC Auto ID Technology Co., Ltd" */
    'T','S','C',' ','A','u','t','o',' ','I','D',' ','\x0d',' ','\x0e','\x16',
/* 0x24cd4 = "Wireless Optical Mouse ACT-MUSW-002" */
    '\x01','\x7b','\x0b',' ','A','C','T','-','M','U','S','W','-','0','0','2',
/* 0x24ce4 = "LCS Telegraphics" */
    'L','C','S',' ','T','e','l','e','g','r','a','p','h','i','c','s',
/* 0x24cf4 = "ColorHug2 bootloader" */
    '\xa2','H','u','g','2',' ','b','o','o','t','l','o','a','d','e','r',
/* 0x24d04 = "WALKMAN NWZ-E354" */
    'W','A','L','K','M','A','N',' ','N','W','Z','-','E','3','5','4',
/* 0x24d14 = "ARCUS digma PC-Interface" */
    'A','R','C','U','S',' ','d','i','g','m','a',' ','P','C','-','\x81',
/* 0x24d24 = "ES-D200 [GT-S50]" */
    'E','S','-','D','2','0','0',' ','[','G','T','-','S','5','0',']',
/* 0x24d34 = "Comfort Wave 450" */
    'C','o','m','f','o','r','t',' ','W','a','v','e',' ','4','5','0',
/* 0x24d44 = "Jornada 568 Pocket PC" */
    'J','o','r','n','a','d','a',' ','5','6','8',' ','\x17',' ','P','C',
/* 0x24d54 = "Mini-PAC Arcade Control Interface" */
    '\xb9','-','P','A','C',' ','A','r','c','a','d','e',' ','\xc9',' ','\x81',
/* 0x24d64 = "MP705-8G MP3 player" */
    'M','P','7','0','5','-','8','G',' ','\x8e','p','l','a','y','e','r',
/* 0x24d74 = "CG4500 Communications Gateway" */
    'C','G','4','5','0','0',' ','\xd1',' ','G','a','t','e','w','a','y',
/* 0x24d84 = "XAC Automation Corp." */
    'X','A','C',' ','A','u','t','o','m','a','t','i','o','n',' ','\x10',
/* 0x24d94 = "Pocket DV5100M (Disk)" */
    '\x17',' ','D','V','5','1','0','0','M',' ','(','D','i','s','k',')',
/* 0x24da4 = "eHome Remote Control Keyboard keys" */
    'e','H','o','m','e',' ','\xcb',' ','\xc9',' ','\x05',' ','k','e','y','s',
/* 0x24db4 = "SKYDATA SKD-U100" */
    'S','K','Y','D','A','T','A',' ','S','K','D','-','U','1','0','0',
/* 0x24dc4 = "W910i (Mass storage)" */
    'W','9','1','0','i',' ','(','\x7c','s','t','o','r','a','g','e',')',
/* 0x24dd4 = "IC Recorder (ST)" */
    'I','C',' ','R','e','c','o','r','d','e','r',' ','(','S','T',')',
/* 0x24de4 = "General Meters Corp." */
    'G','e','n','e','r','a','l',' ','M','e','t','e','r','s',' ','\x10',
/* 0x24df4 = "X36F Flightstick" */
    'X','3','6','F',' ','F','l','i','g','h','t','s','t','i','c','k',
/* 0x24e04 = "Non-Compliant Audio Device" */
    'N','o','n','-','C','o','m','p','l','i','a','n','t',' ','\x8b','\x03',
/* 0x24e14 = "Eicon Networks Corp." */
    'E','i','c','o','n',' ','N','e','t','w','o','r','k','s',' ','\x10',
/* 0x24e24 = "UTECH Electronic (D.G.) Co., Ltd." */
    'U','T','E','C','H',' ','\xba','(','D','.','G','.',')',' ','\x0e','\xab',
/* 0x24e34 = "N97 (Multimedia)" */
    'N','9','7',' ','(','M','u','l','t','i','m','e','d','i','a',')',
/* 0x24e44 = "OPEN NT1 Plus II" */
    'O','P','E','N',' ','N','T','1',' ','P','l','u','s',' ','I','I',
/* 0x24e54 = "2202 Ethernet [pegasus]" */
    '2','2','0','2',' ','\x7f',' ','[','p','e','g','a','s','u','s',']',
/* 0x24e64 = "OpticBook 4800 Scanner" */
    'O','p','t','i','c','B','o','o','k',' ','4','8','0','0',' ','\x25',
/* 0x24e74 = "iFlash SM-Direct Card Reader" */
    'i','\x3c',' ','S','M','-','D','i','r','e','c','t',' ','\x15',' ','\x08',
/* 0x24e84 = "FO13FF-65 PC-CAM" */
    'F','O','1','3','F','F','-','6','5',' ','P','C','-','C','A','M',
/* 0x24e94 = "QualCore Logic Inc." */
    'Q','u','a','l','C','o','r','e',' ','L','o','g','i','c',' ','\x07',
/* 0x24ea4 = "DSC WIA Device (3310)" */
    'D','S','C',' ','W','I','A',' ','\x03',' ','(','3','3','1','0',')',
/* 0x24eb4 = "FinePix S3000 Zoom (DSC)" */
    '\xca','i','x',' ','S','3','0','0','0',' ','\xe6','(','D','S','C',')',
/* 0x24ec4 = "Bluetooth 2.0+eDR dongle" */
    '\x06',' ','2','.','0','+','e','D','R',' ','d','o','n','g','l','e',
/* 0x24ed4 = "Broadband Blaster 8012U-V" */
    '\xb7','B','l','a','s','t','e','r',' ','8','0','1','2','U','-','V',
/* 0x24ee4 = "ISP5200 Debugger" */
    'I','S','P','5','2','0','0',' ','D','e','b','u','g','g','e','r',
/* 0x24ef4 = "Color Filter Wheel 4" */
    '\xa2',' ','F','i','l','t','e','r',' ','W','h','e','e','l',' ','4',
/* 0x24f04 = "Targus PAKP003 Mouse" */
    'T','a','r','g','u','s',' ','P','A','K','P','0','0','3',' ','\x0b',
/* 0x24f14 = "FinePix A203 Zoom (PC CAM)" */
    '\xca','i','x',' ','A','2','0','3',' ','\xe6','(','\x1f','C','A','M',')',
/* 0x24f24 = "Bluetooth Device(SAMPLE)" */
    '\x06',' ','D','e','v','i','c','e','(','S','A','M','P','L','E',')',
/* 0x24f34 = "Silicon Motion Camera" */
    'S','i','l','i','c','o','n',' ','M','o','t','i','o','n',' ','\x04',
/* 0x24f44 = "Sansa Fuze (mtp)" */
    'S','a','n','s','a',' ','F','u','z','e',' ','(','m','t','p',')',
/* 0x24f54 = "DRAC 5 Virtual Media" */
    'D','R','A','C',' ','5',' ','V','i','r','t','u','a','l',' ','\xa1',
/* 0x24f64 = "Clavinova CLP535" */
    'C','l','a','v','i','n','o','v','a',' ','C','L','P','5','3','5',
/* 0x24f74 = "ImageMate MS-PRO" */
    'I','m','a','g','e','M','a','t','e',' ','M','S','-','P','R','O',
/* 0x24f84 = "Hauppauge WinTV Pro (PAL D/K)" */
    '\xfb','W','i','n','\xda','\x8f',' ','(','P','A','L',' ','D','/','K',')',
/* 0x24f94 = "I/O Interconnect" */
    'I','/','O',' ','I','n','t','e','r','c','o','n','n','e','c','t',
/* 0x24fa4 = "IC Recorder (MS)" */
    'I','C',' ','R','e','c','o','r','d','e','r',' ','(','M','S',')',
/* 0x24fb4 = "Memory Stick Hi-Fi System" */
    '\xd2',' ','\xb3',' ','H','i','-','F','i',' ','S','y','s','t','e','m',
/* 0x24fc4 = "USB to MMC Class Drive" */
    '\x0a',' ','t','o',' ','M','M','C',' ','C','l','a','s','s',' ','\x14',
/* 0x24fd4 = "Link Instruments" */
    'L','i','n','k',' ','I','n','s','t','r','u','m','e','n','t','s',
/* 0x24fe4 = "Fukuda Denshi Co., Ltd" */
    'F','u','k','u','d','a',' ','D','e','n','s','h','i',' ','\x0e','\x16',
/* 0x24ff4 = "Logitech Harmony" */
    'L','o','g','i','t','e','c','h',' ','H','a','r','m','o','n','y',
/* 0x25004 = "Genius iSlim 330" */
    'G','e','n','i','u','s',' ','i','S','l','i','m',' ','3','3','0',
/* 0x25014 = "FinePix E510 Zoom (PC CAM)" */
    '\xca','i','x',' ','E','5','1','0',' ','\xe6','(','\x1f','C','A','M',')',
/* 0x25024 = "SigmaTel MSCN Audio Player" */
    'S','i','g','m','a','T','e','l',' ','M','S','C','N',' ','\x8b','\x1e',
/* 0x25034 = "Aiptek Mini PenCam 1.3" */
    'A','i','p','t','e','k',' ','\xb9',' ','P','e','n','\x9a','1','.','3',
/* 0x25044 = "PCMCIA PocketZip Dock" */
    'P','C','M','C','I','A',' ','\x17','Z','i','p',' ','D','o','c','k',
/* 0x25054 = "Officejet Pro 8600" */
    'O','f','f','i','c','e','j','e','t',' ','\x8f',' ','8','6','0','0',
/* 0x25064 = "LBP3010B printer" */
    'L','B','P','3','0','1','0','B',' ','p','r','i','n','t','e','r',
/* 0x25074 = "FinePix A310 Zoom (PC CAM)" */
    '\xca','i','x',' ','A','3','1','0',' ','\xe6','(','\x1f','C','A','M',')',
/* 0x25084 = "Thomas & Betts Corp." */
    'T','h','o','m','a','s',' ','&',' ','B','e','t','t','s',' ','\x10',
/* 0x25094 = "ColorHug+ Bootloader" */
    '\xa2','H','u','g','+',' ','B','o','o','t','l','o','a','d','e','r',
/* 0x250a4 = "Fuji Electric Co., Ltd" */
    'F','u','j','i',' ','E','l','e','c','t','r','i','c',' ','\x0e','\x16',
/* 0x250b4 = "CoPilot System Cable" */
    'C','o','P','i','l','o','t',' ','S','y','s','t','e','m',' ','\xa5',
/* 0x250c4 = "Officejet Pro 8100" */
    'O','f','f','i','c','e','j','e','t',' ','\x8f',' ','8','1','0','0',
/* 0x250d4 = "FinePix S5700 Zoom (PTP)" */
    '\xca','i','x',' ','S','5','7','0','0',' ','\xe6','(','P','T','P',')',
/* 0x250e4 = "Blackberry Pearl" */
    'B','l','a','c','k','b','e','r','r','y',' ','P','e','a','r','l',
/* 0x250f4 = "Myson Century, Inc." */
    'M','y','s','o','n',' ','C','e','n','t','u','r','y',',',' ','\x07',
/* 0x25104 = "Linux Foundation" */
    'L','i','n','u','x',' ','F','o','u','n','d','a','t','i','o','n',
/* 0x25114 = "Aiptek, MP315 MP3 Player" */
    'A','i','p','t','e','k',',',' ','M','P','3','1','5',' ','\x8e','\x1e',
/* 0x25124 = "PAC7311 SnakeCam" */
    'P','A','C','7','3','1','1',' ','S','n','a','k','e','C','a','m',
/* 0x25134 = "FinePix F410 Zoom (PC CAM)" */
    '\xca','i','x',' ','F','4','1','0',' ','\xe6','(','\x1f','C','A','M',')',
/* 0x25144 = "Teledat X130 DSL" */
    'T','e','l','e','d','a','t',' ','X','1','3','0',' ','D','S','L',
/* 0x25154 = "Music Mediatouch" */
    'M','u','s','i','c',' ','M','e','d','i','a','t','o','u','c','h',
/* 0x25164 = "Y.C. Cable U.S.A., Inc." */
    'Y','.','C','.',' ','\xa5',' ','U','.','S','.','A','.',',',' ','\x07',
/* 0x25174 = "IDBG in DFU mode" */
    'I','D','B','G',' ','i','n',' ','D','F','U',' ','m','o','d','e',
/* 0x25184 = "Labtec Notebooks" */
    'L','a','b','t','e','c',' ','N','o','t','e','b','o','o','k','s',
/* 0x25194 = "HID->COM RS232 Adapter" */
    'H','I','D','-','>','C','O','M',' ','R','S','2','3','2',' ','\x02',
/* 0x251a4 = "USB Chief Analyzer" */
    '\x0a',' ','C','h','i','e','f',' ','A','n','a','l','y','z','e','r',
/* 0x251b4 = "RTL8188ETV Wireless LAN 802.11n Network Adapter" */
    'R','T','L','8','1','8','8','E','T','V',' ','\x01','\xf3','\x99','\x8d','\x02',
/* 0x251c4 = "Ant8 Logic Probe" */
    'A','n','t','8',' ','L','o','g','i','c',' ','P','r','o','b','e',
/* 0x251d4 = "Linux-USB Ethernet Gadget" */
    'L','i','n','u','x','-','\x0a',' ','\x7f',' ','G','a','d','g','e','t',
/* 0x251e4 = "Philips Monitors" */
    'P','h','i','l','i','p','s',' ','M','o','n','i','t','o','r','s',
/* 0x251f4 = "Arduino Uno Rev3" */
    'A','r','d','u','i','n','o',' ','U','n','o',' ','R','e','v','3',
/* 0x25204 = "V710 GSM Phone (P2K)" */
    'V','7','1','0',' ','G','S','M',' ','\x19',' ','(','P','2','K',')',
/* 0x25214 = "IntelliMouse Optical" */
    'I','n','t','e','l','l','i','\x0b',' ','O','p','t','i','c','a','l',
/* 0x25224 = "TravelDrive Intuix U3 2GB" */
    '\xd9','\x14',' ','I','n','t','u','i','x',' ','U','3',' ','2','G','B',
/* 0x25234 = "Fitipower Integrated Technology Inc" */
    'F','i','t','i','p','o','w','e','r',' ','\x18','\x0d',' ','I','n','c',
/* 0x25244 = "Happ Controls, Inc." */
    'H','a','p','p',' ','C','o','n','t','r','o','l','s',',',' ','\x07',
/* 0x25254 = "Digital Sound System 80" */
    '\x09','S','o','u','n','d',' ','S','y','s','t','e','m',' ','8','0',
/* 0x25264 = "StudioMouse Wireless" */
    'S','t','u','d','i','o','\x0b',' ','W','i','r','e','l','e','s','s',
/* 0x25274 = "Caplio 400G wide" */
    'C','a','p','l','i','o',' ','4','0','0','G',' ','w','i','d','e',
/* 0x25284 = "SM Media-Shuttle Card Reader" */
    'S','M',' ','\xa1','-','S','h','u','t','t','l','e',' ','\x15',' ','\x08',
/* 0x25294 = "MPP Spectrograph" */
    'M','P','P',' ','S','p','e','c','t','r','o','g','r','a','p','h',
/* 0x252a4 = "JumpDrive Expression" */
    'J','u','m','p','\x14',' ','E','x','p','r','e','s','s','i','o','n',
/* 0x252b4 = "Visioneer 6200 Scanner" */
    'V','i','s','i','o','n','e','e','r',' ','6','2','0','0',' ','\x25',
/* 0x252c4 = "1.3 MPixel UVC Webcam" */
    '1','.','3',' ','M','P','i','x','e','l',' ','U','V','C',' ','\x11',
/* 0x252d4 = "Secure Pen drive" */
    'S','e','c','u','r','e',' ','P','e','n',' ','d','r','i','v','e',
/* 0x252e4 = "RODE Microphones" */
    'R','O','D','E',' ','M','i','c','r','o','p','h','o','n','e','s',
/* 0x252f4 = "Uno R3 (CDC ACM)" */
    'U','n','o',' ','R','3',' ','(','C','D','C',' ','A','C','M',')',
/* 0x25304 = "CPWUE001 USB/Ethernet Adapter" */
    'C','P','W','U','E','0','0','1',' ','U','S','B','/','\x7f',' ','\x02',
/* 0x25314 = "ChipsBnk 2GB USB Stick" */
    'C','h','i','p','s','B','n','k',' ','2','G','B',' ','\x0a',' ','\xb3',
/* 0x25324 = "Rugged 16 and 32 GB" */
    'R','u','g','g','e','d',' ','1','6',' ','\xe4','3','2',' ','G','B',
/* 0x25334 = "933A Portable Power Sentinel" */
    '9','3','3','A',' ','\xa9','\x24',' ','S','e','n','t','i','n','e','l',
/* 0x25344 = "Personal Audio Player 3000" */
    'P','e','r','s','o','n','a','l',' ','\x8b','\x1e',' ','3','0','0','0',
/* 0x25354 = "Vista Imaging, Inc." */
    'V','i','s','t','a',' ','I','m','a','g','i','n','g',',',' ','\x07',
/* 0x25364 = "nissei 128DE-USB -" */
    'n','i','s','s','e','i',' ','1','2','8','D','E','-','\x0a',' ','-',
/* 0x25374 = "PCVC730K Webcam [pwc]" */
    'P','C','V','C','7','3','0','K',' ','\x11',' ','[','p','w','c',']',
/* 0x25384 = "FinePix S7000 Zoom (DSC)" */
    '\xca','i','x',' ','S','7','0','0','0',' ','\xe6','(','D','S','C',')',
/* 0x25394 = "Polestar Tech. Corp." */
    'P','o','l','e','s','t','a','r',' ','T','e','c','h','.',' ','\x10',
/* 0x253a4 = "Bluebird [Ambit]" */
    'B','l','u','e','b','i','r','d',' ','[','A','m','b','i','t',']',
/* 0x253b4 = "Walkman NWZ-E443" */
    'W','a','l','k','m','a','n',' ','N','W','Z','-','E','4','4','3',
/* 0x253c4 = "Dazzle DM-SD/MMC" */
    'D','a','z','z','l','e',' ','D','M','-','S','D','/','M','M','C',
/* 0x253d4 = "M-Audio MIDISPORT 8x8" */
    'M','-','\x8b','M','I','D','I','S','P','O','R','T',' ','8','x','8',
/* 0x253e4 = "USB,GameBoard II" */
    'U','S','B',',','G','a','m','e','B','o','a','r','d',' ','I','I',
/* 0x253f4 = "DSC WIA Device (3320)" */
    'D','S','C',' ','W','I','A',' ','\x03',' ','(','3','3','2','0',')',
/* 0x25404 = "Webcam Vista [PD1100]" */
    '\x11',' ','V','i','s','t','a',' ','[','P','D','1','1','0','0',']',
/* 0x25414 = "Xbox Adrenalin Hub" */
    'X','b','o','x',' ','A','d','r','e','n','a','l','i','n',' ','\xa4',
/* 0x25424 = "Q-TEC WEBCAM 100" */
    'Q','-','T','E','C',' ','W','E','B','C','A','M',' ','1','0','0',
/* 0x25434 = "OpticBook A300 Scanner" */
    'O','p','t','i','c','B','o','o','k',' ','A','3','0','0',' ','\x25',
/* 0x25444 = "F5U240 USB 2.0 CF Card Reader" */
    'F','5','U','2','4','0',' ','\x0a',' ','\xc1','C','F',' ','\x15',' ','\x08',
/* 0x25454 = "Nomad MuVo USB 2.0" */
    'N','o','m','a','d',' ','M','u','V','o',' ','\x0a',' ','2','.','0',
/* 0x25464 = "Silicon Systems, Ltd (SSL)" */
    'S','i','l','i','c','o','n',' ','\xb8','\x16',' ','(','S','S','L',')',
/* 0x25474 = "GoGear SA1110/02" */
    'G','o','G','e','a','r',' ','S','A','1','1','1','0','/','0','2',
/* 0x25484 = "Label Printer KL-P1000" */
    'L','a','b','e','l',' ','\x0c',' ','K','L','-','P','1','0','0','0',
/* 0x25494 = "Composite USB PS2 Converter" */
    '\x60','\x0a',' ','P','S','2',' ','C','o','n','v','e','r','t','e','r',
/* 0x254a4 = "antiAFK keyboard" */
    'a','n','t','i','A','F','K',' ','k','e','y','b','o','a','r','d',
/* 0x254b4 = "Zip 100 (Type 2)" */
    'Z','i','p',' ','1','0','0',' ','(','T','y','p','e',' ','2',')',
/* 0x254c4 = "DSC WIA Device (2320)" */
    'D','S','C',' ','W','I','A',' ','\x03',' ','(','2','3','2','0',')',
/* 0x254d4 = "Plugable UGA-165" */
    'P','l','u','g','a','b','l','e',' ','U','G','A','-','1','6','5',
/* 0x254e4 = "Rexon Technology Corp., Ltd" */
    'R','e','x','o','n',' ','\x0d',' ','C','o','r','p','.',',',' ','\x16',
/* 0x254f4 = "Aterm WL300NU-AG" */
    'A','t','e','r','m',' ','W','L','3','0','0','N','U','-','A','G',
/* 0x25504 = "FinePix F402 Zoom (PC CAM)" */
    '\xca','i','x',' ','F','4','0','2',' ','\xe6','(','\x1f','C','A','M',')',
/* 0x25514 = "WALKMAN NWZ-F805" */
    'W','A','L','K','M','A','N',' ','N','W','Z','-','F','8','0','5',
/* 0x25524 = "MF5550 Composite" */
    'M','F','5','5','5','0',' ','C','o','m','p','o','s','i','t','e',
/* 0x25534 = "Pasco Scientific" */
    'P','a','s','c','o',' ','S','c','i','e','n','t','i','f','i','c',
/* 0x25544 = "G-pen 560 Tablet" */
    'G','-','p','e','n',' ','5','6','0',' ','T','a','b','l','e','t',
/* 0x25554 = "Nexus S (tether)" */
    'N','e','x','u','s',' ','S',' ','(','t','e','t','h','e','r',')',
/* 0x25564 = "IM-DR80 Portable NetMD Player" */
    'I','M','-','D','R','8','0',' ','\xa9','N','e','t','M','D',' ','\x1e',
/* 0x25574 = "Nyko (Honey Bee)" */
    'N','y','k','o',' ','(','H','o','n','e','y',' ','B','e','e',')',
/* 0x25584 = "G500s Laser Gaming Mouse" */
    'G','5','0','0','s',' ','\x82',' ','G','a','m','i','n','g',' ','\x0b',
/* 0x25594 = "Airgo Networks Inc." */
    'A','i','r','g','o',' ','N','e','t','w','o','r','k','s',' ','\x07',
/* 0x255a4 = "LAN-W300N/U2 Wireless LAN Adapter" */
    'L','A','N','-','W','3','0','0','N','/','U','2',' ','\x01','\xf3','\x02',
/* 0x255b4 = "Forerunner 735XT" */
    'F','o','r','e','r','u','n','n','e','r',' ','7','3','5','X','T',
/* 0x255c4 = "ME OFFICE 560W Series" */
    'M','E',' ','O','F','F','I','C','E',' ','5','6','0','W',' ','\xbf',
/* 0x255d4 = "Joule and Wattmeter" */
    'J','o','u','l','e',' ','\xe4','W','a','t','t','m','e','t','e','r',
/* 0x255e4 = "OpticBook 4600 Scanner" */
    'O','p','t','i','c','B','o','o','k',' ','4','6','0','0',' ','\x25',
/* 0x255f4 = "Sharp 3G GSM USB Control" */
    'S','h','a','r','p',' ','3','G',' ','G','S','M',' ','\x0a',' ','\xc9',
/* 0x25604 = "SDDR-99 5-in-1 Reader" */
    'S','D','D','R','-','9','9',' ','5','-','i','n','-','1',' ','\x08',
/* 0x25614 = "QuickCam Ultra Vision" */
    '\xc7','a','m',' ','U','l','t','r','a',' ','V','i','s','i','o','n',
/* 0x25624 = "MSI-6861 802.11g WiFi adapter" */
    'M','S','I','-','6','8','6','1',' ','\x94','W','i','F','i',' ','\xd0',
/* 0x25634 = "P5 Glove glove controller" */
    'P','5',' ','G','l','o','v','e',' ','g','l','o','v','e',' ','\x9e',
/* 0x25644 = "Chant Sincere Co., Ltd" */
    'C','h','a','n','t',' ','S','i','n','c','e','r','e',' ','\x0e','\x16',
/* 0x25654 = "SMCWUSBT-G (no firmware)" */
    'S','M','C','W','U','S','B','T','-','G',' ','(','n','o',' ','\xdb',
/* 0x25664 = "Lynn Products, Inc." */
    'L','y','n','n',' ','P','r','o','d','u','c','t','s',',',' ','\x07',
/* 0x25674 = "Zaurus C-700 PDA" */
    'Z','a','u','r','u','s',' ','C','-','7','0','0',' ','P','D','A',
/* 0x25684 = "Dual-relay board" */
    'D','u','a','l','-','r','e','l','a','y',' ','b','o','a','r','d',
/* 0x25694 = "Sensor Terminal Board" */
    '\xac',' ','T','e','r','m','i','n','a','l',' ','B','o','a','r','d',
/* 0x256a4 = "MTE-450 [Bamboo]" */
    'M','T','E','-','4','5','0',' ','[','B','a','m','b','o','o',']',
/* 0x256b4 = "SMC9512/9514 USB Hub" */
    'S','M','C','9','5','1','2','/','9','5','1','4',' ','\x0a',' ','\xa4',
/* 0x256c4 = "Rosetta Token V1" */
    'R','o','s','e','t','t','a',' ','T','o','k','e','n',' ','V','1',
/* 0x256d4 = "Rosetta Token V2" */
    'R','o','s','e','t','t','a',' ','T','o','k','e','n',' ','V','2',
/* 0x256e4 = "WLI-U2-KG54 WLAN" */
    'W','L','I','-','U','2','-','K','G','5','4',' ','W','L','A','N',
/* 0x256f4 = "Rosetta Token V3" */
    'R','o','s','e','t','t','a',' ','T','o','k','e','n',' ','V','3',
/* 0x25704 = "FinePix F420 Zoom (PC CAM)" */
    '\xca','i','x',' ','F','4','2','0',' ','\xe6','(','\x1f','C','A','M',')',
/* 0x25714 = "ES-D400 [GT-S80]" */
    'E','S','-','D','4','0','0',' ','[','G','T','-','S','8','0',']',
/* 0x25724 = "Studio PCTV USB2" */
    'S','t','u','d','i','o',' ','P','C','T','V',' ','U','S','B','2',
/* 0x25734 = "3DeMon USB Capture" */
    '3','D','e','M','o','n',' ','\x0a',' ','C','a','p','t','u','r','e',
/* 0x25744 = "Endoscope camera" */
    'E','n','d','o','s','c','o','p','e',' ','c','a','m','e','r','a',
/* 0x25754 = "Stylus CX5700F/CX5800F" */
    '\xb1','C','X','5','7','0','0','F','/','C','X','5','8','0','0','F',
/* 0x25764 = "OpticSlim 1200 Scanner" */
    'O','p','t','i','c','S','l','i','m',' ','1','2','0','0',' ','\x25',
/* 0x25774 = "MFC-420CN Remote Setup Port" */
    '\x7d','4','2','0','C','N',' ','\xcb',' ','S','e','t','u','p',' ','\x87',
/* 0x25784 = "LAN-W150N/U2 Wireless LAN Adapter" */
    'L','A','N','-','W','1','5','0','N','/','U','2',' ','\x01','\xf3','\x02',
/* 0x25794 = "Smart Display Version 9973" */
    '\x12',' ','\xcf',' ','V','e','r','s','i','o','n',' ','9','9','7','3',
/* 0x257a4 = "Anycall SCH-W580" */
    'A','n','y','c','a','l','l',' ','S','C','H','-','W','5','8','0',
/* 0x257b4 = "Colorado 1200u Scanner" */
    'C','o','l','o','r','a','d','o',' ','1','2','0','0','u',' ','\x25',
/* 0x257c4 = "Silicon Graphics" */
    'S','i','l','i','c','o','n',' ','G','r','a','p','h','i','c','s',
/* 0x257d4 = "Magicolor 5430DL" */
    'M','a','g','i','c','o','l','o','r',' ','5','4','3','0','D','L',
/* 0X257e4 = "Leuze electronic" */
    'e','u','z','e',' ','e','l','e','c','t','r','o','n','i','c',
/* 0x257f3 = "3C19250 Ethernet [klsi]" */
    '3','C','1','9','2','5','0',' ','\x7f',' ','[','k','l','s','i',']',
/* 0x25803 = "FireWire USB Combo" */
    'F','i','r','e','W','i','r','e',' ','\x0a',' ','C','o','m','b','o',
/* 0x25813 = "DSC WIA Device (1300)" */
    'D','S','C',' ','W','I','A',' ','\x03',' ','(','1','3','0','0',')',
/* 0x25823 = "WingMan Attack 2" */
    'W','i','n','g','M','a','n',' ','A','t','t','a','c','k',' ','2',
/* 0x25833 = "Bluetooth Controller (ALPS/UGPZ6)" */
    '\x06',' ','\x13',' ','(','A','L','P','S','/','U','G','P','Z','6',')',
/* 0x25843 = "Blue Microphones" */
    'B','l','u','e',' ','M','i','c','r','o','p','h','o','n','e','s',
/* 0x25853 = "USB OpticalWheel Mouse" */
    '\x0a',' ','O','p','t','i','c','a','l','W','h','e','e','l',' ','\x0b',
/* 0x25863 = "Aluminum Keyboard (JIS)" */
    'A','l','u','m','i','n','u','m',' ','\x05',' ','(','J','I','S',')',
/* 0x25873 = "BigDisk Extreme 500" */
    'B','i','g','\xe8',' ','E','x','t','r','e','m','e',' ','5','0','0',
/* 0x25883 = "Global Unichip Corp." */
    'G','l','o','b','a','l',' ','U','n','i','c','h','i','p',' ','\x10',
/* 0x25893 = "SPCP825 RS232C Adapter" */
    'S','P','C','P','8','2','5',' ','R','S','2','3','2','C',' ','\x02',
/* 0x258a3 = "FinePix M603 Zoom (PC CAM)" */
    '\xca','i','x',' ','M','6','0','3',' ','\xe6','(','\x1f','C','A','M',')',
/* 0x258b3 = "HFX OEM Joystick" */
    'H','F','X',' ','O','E','M',' ','J','o','y','s','t','i','c','k',
/* 0x258c3 = "SD/MS Single Card Reader" */
    'S','D','/','M','S',' ','S','i','n','g','l','e',' ','\x15',' ','\x08',
/* 0x258d3 = "Cinch Connectors" */
    'C','i','n','c','h',' ','C','o','n','n','e','c','t','o','r','s',
/* 0x258e3 = "W960i Phone (PC Suite)" */
    'W','9','6','0','i',' ','\x19',' ','(','\x1f','S','u','i','t','e',')',
/* 0x258f3 = "5-point Touch Screen" */
    '5','-','p','o','i','n','t',' ','\x9d',' ','S','c','r','e','e','n',
/* 0x25903 = "Dual PSX Adaptor" */
    'D','u','a','l',' ','P','S','X',' ','A','d','a','p','t','o','r',
/* 0x25913 = "Tateno Dennou, Inc." */
    'T','a','t','e','n','o',' ','D','e','n','n','o','u',',',' ','\x07',
/* 0x25923 = "GameCube Adaptor" */
    'G','a','m','e','C','u','b','e',' ','A','d','a','p','t','o','r',
/* 0x25933 = "SATA Adapter [HD-LBU3]" */
    'S','A','T','A',' ','\x02',' ','[','H','D','-','L','B','U','3',']',
/* 0x25943 = "Service & Quality Technology Co., Ltd" */
    '\xd7',' ','&',' ','Q','u','a','l','i','t','y',' ','\x0d',' ','\x0e','\x16',
/* 0x25953 = "KN-W510U 1.0 Wireless LAN Adapter" */
    'K','N','-','W','5','1','0','U',' ','1','.','0',' ','\x01','\xf3','\x02',
/* 0x25963 = "MuVo^2 FM (uHDD)" */
    'M','u','V','o','^','2',' ','F','M',' ','(','u','H','D','D',')',
/* 0x25973 = "Given Imaging, Ltd" */
    'G','i','v','e','n',' ','I','m','a','g','i','n','g',',',' ','\x16',
/* 0x25983 = "E815 GSM Phone (P2K)" */
    'E','8','1','5',' ','G','S','M',' ','\x19',' ','(','P','2','K',')',
/* 0x25993 = "RF Receiver and G6-20D Wireless Optical Mouse" */
    'R','F',' ','\x8c',' ','\xe4','G','6','-','2','0','D',' ','\x01','\x7b','\x0b',
/* 0x259a3 = "microSD Reader/Writer" */
    'm','i','c','r','o','S','D',' ','R','e','a','d','e','r','/','\xdf',
/* 0x259b3 = "Transcend Flash disk" */
    'T','r','a','n','s','c','e','n','d',' ','\x3c',' ','d','i','s','k',
/* 0x259c3 = "Photosmart C4480" */
    'P','h','o','t','o','s','m','a','r','t',' ','C','4','4','8','0',
/* 0x259d3 = "M-BT96a Pilot Optical Mouse" */
    'M','-','B','T','9','6','a',' ','P','i','l','o','t',' ','\x7b','\x0b',
/* 0x259e3 = "APT-6000U Tablet" */
    'A','P','T','-','6','0','0','0','U',' ','T','a','b','l','e','t',
/* 0x259f3 = "ISDN-Controller B1 Family" */
    'I','S','D','N','-','\x13',' ','B','1',' ','F','a','m','i','l','y',
/* 0x25a03 = "Sansa View (msc)" */
    'S','a','n','s','a',' ','V','i','e','w',' ','(','m','s','c',')',
/* 0x25a13 = "Guitar for Xbox 360" */
    'G','u','i','t','a','r',' ','\xcc','X','b','o','x',' ','3','6','0',
/* 0x25a23 = "My Book (WDBFJK)" */
    'M','y',' ','B','o','o','k',' ','(','W','D','B','F','J','K',')',
/* 0x25a33 = "MAUSB-100 xD Card Reader" */
    'M','A','U','S','B','-','1','0','0',' ','x','D',' ','\x15',' ','\x08',
/* 0x25a43 = "MV650i (normal mode)" */
    'M','V','6','5','0','i',' ','(','n','o','r','m','a','l',' ','\x1a',
/* 0x25a53 = "RT2870/RT3070 Wireless Adapter" */
    'R','T','2','8','7','0','/','R','T','3','0','7','0',' ','\x01','\x02',
/* 0x25a63 = "Cruzer Crossfire" */
    'C','r','u','z','e','r',' ','C','r','o','s','s','f','i','r','e',
/* 0x25a73 = "In-System Design" */
    'I','n','-','S','y','s','t','e','m',' ','D','e','s','i','g','n',
/* 0x25a83 = "LHI Technology (China) Co., Ltd" */
    'L','H','I',' ','\x0d',' ','(','C','h','i','n','a',')',' ','\x0e','\x16',
/* 0x25a93 = "Pocketbook Pro 903" */
    'P','o','c','k','e','t','b','o','o','k',' ','\x8f',' ','9','0','3',
/* 0x25aa3 = "Keil Software, Inc." */
    'K','e','i','l',' ','S','o','f','t','w','a','r','e',',',' ','\x07',
/* 0x25ab3 = "Magicolor 2490MF" */
    'M','a','g','i','c','o','l','o','r',' ','2','4','9','0','M','F',
/* 0x25ac3 = "OneRNG entropy device" */
    'O','n','e','R','N','G',' ','e','n','t','r','o','p','y',' ','\xf9',
/* 0x25ad3 = "Mindstorms Tower" */
    'M','i','n','d','s','t','o','r','m','s',' ','T','o','w','e','r',
/* 0x25ae3 = "PertoSmart EMV - Card Reader" */
    'P','e','r','t','o','\x12',' ','E','M','V',' ','-',' ','\x15',' ','\x08',
/* 0x25af3 = "USB to Memory Stick (LC1) Drive" */
    '\x0a',' ','t','o',' ','\xd2',' ','\xb3',' ','(','L','C','1',')',' ','\x14',
/* 0x25b03 = "ExMFE5 Simulator" */
    'E','x','M','F','E','5',' ','S','i','m','u','l','a','t','o','r',
/* 0x25b13 = "FlashBuster-U Floppy" */
    '\x3c','B','u','s','t','e','r','-','U',' ','F','l','o','p','p','y',
/* 0x25b23 = "Polar Electro Oy" */
    'P','o','l','a','r',' ','E','l','e','c','t','r','o',' ','O','y',
/* 0x25b33 = "Yepp YP-K3 (msc)" */
    'Y','e','p','p',' ','Y','P','-','K','3',' ','(','m','s','c',')',
/* 0x25b43 = "Plugable UGA-125" */
    'P','l','u','g','a','b','l','e',' ','U','G','A','-','1','2','5',
/* 0x25b53 = "OBID classic-pro" */
    'O','B','I','D',' ','c','l','a','s','s','i','c','-','p','r','o',
/* 0x25b63 = "Micro Audiometrics Corp." */
    '\xc4',' ','A','u','d','i','o','m','e','t','r','i','c','s',' ','\x10',
/* 0x25b73 = "OPEX CORPORATION" */
    'O','P','E','X',' ','C','O','R','P','O','R','A','T','I','O','N',
/* 0x25b83 = "zebris Medical GmbH" */
    'z','e','b','r','i','s',' ','M','e','d','i','c','a','l',' ','\xfc',
/* 0x25b93 = "Century Semiconductor USA, Inc." */
    'C','e','n','t','u','r','y',' ','\xc0',' ','U','S','A',',',' ','\x07',
/* 0x25ba3 = "USB 2.0-IDE bridge" */
    '\x0a',' ','2','.','0','-','I','D','E',' ','b','r','i','d','g','e',
/* 0x25bb3 = "ZOOM Corporation" */
    'Z','O','O','M',' ','C','o','r','p','o','r','a','t','i','o','n',
/* 0x25bc3 = "802.11 n/g/b Wireless LAN Adapter" */
    '8','0','2','.','1','1',' ','n','/','g','/','b',' ','\x01','\xf3','\x02',
/* 0x25bd3 = "OneTouch Pro 8800/8820" */
    'O','n','e','\x9d',' ','\x8f',' ','8','8','0','0','/','8','8','2','0',
/* 0x25be3 = "Taugagreining HF" */
    'T','a','u','g','a','g','r','e','i','n','i','n','g',' ','H','F',
/* 0x25bf3 = "BCM43142A0 Bluetooth 4.0" */
    'B','C','M','4','3','1','4','2','A','0',' ','\x06',' ','4','.','0',
/* 0x25c03 = "LabelWriter 400 Turbo" */
    'L','a','b','e','l','\xdf',' ','4','0','0',' ','T','u','r','b','o',
/* 0x25c13 = "Xbox One Digital TV Tuner" */
    'X','b','o','x',' ','O','n','e',' ','\x09','\xda','T','u','n','e','r',
/* 0x25c23 = "SK-2885 keyboard" */
    'S','K','-','2','8','8','5',' ','k','e','y','b','o','a','r','d',
/* 0x25c33 = "Innovative Technology LTD" */
    'I','n','n','o','v','a','t','i','v','e',' ','\x0d',' ','L','T','D',
/* 0x25c43 = "Think Outside, Inc." */
    'T','h','i','n','k',' ','O','u','t','s','i','d','e',',',' ','\x07',
/* 0x25c53 = "Mylex / Buslogic" */
    'M','y','l','e','x',' ','/',' ','B','u','s','l','o','g','i','c',
/* 0x25c63 = "Various Mobile Phones" */
    'V','a','r','i','o','u','s',' ','\x96',' ','P','h','o','n','e','s',
/* 0x25c73 = "G27 Racing Wheel" */
    'G','2','7',' ','R','a','c','i','n','g',' ','W','h','e','e','l',
/* 0x25c83 = "Cruzer Pop (8GB)" */
    'C','r','u','z','e','r',' ','P','o','p',' ','(','8','G','B',')',
/* 0x25c93 = "Direct Access Technology, Inc." */
    'D','i','r','e','c','t',' ','A','c','c','e','s','s',' ','\x95','\x07',
/* 0x25ca3 = "R440 Force Wheel" */
    'R','4','4','0',' ','F','o','r','c','e',' ','W','h','e','e','l',
/* 0x25cb3 = "EasyShare Z710 Camera" */
    'E','a','s','y','S','h','a','r','e',' ','Z','7','1','0',' ','\x04',
/* 0x25cc3 = "Novatel Wireless" */
    'N','o','v','a','t','e','l',' ','W','i','r','e','l','e','s','s',
/* 0x25cd3 = "MP957 Music and Video Player" */
    'M','P','9','5','7',' ','M','u','s','i','c',' ','\xe4','\xa3',' ','\x1e',
/* 0x25ce3 = "RT2501/RT2573 Wireless Adapter" */
    'R','T','2','5','0','1','/','R','T','2','5','7','3',' ','\x01','\x02',
/* 0x25cf3 = "airsync Wi-Fi Wireless Adapter" */
    'a','i','r','s','y','n','c',' ','W','i','-','F','i',' ','\x01','\x02',
/* 0x25d03 = "Aluminum Keyboard (ISO)" */
    'A','l','u','m','i','n','u','m',' ','\x05',' ','(','I','S','O',')',
/* 0x25d13 = "CD-R Drive KXL-840AN" */
    'C','D','-','R',' ','\x14',' ','K','X','L','-','8','4','0','A','N',
/* 0x25d23 = "SK-9020 keyboard" */
    'S','K','-','9','0','2','0',' ','k','e','y','b','o','a','r','d',
/* 0x25d33 = "USB-to-CAN compact" */
    '\x0a','-','t','o','-','C','A','N',' ','c','o','m','p','a','c','t',
/* 0x25d43 = "Magicolor 5440DL" */
    'M','a','g','i','c','o','l','o','r',' ','5','4','4','0','D','L',
/* 0x25d53 = "NovaTech NV-902W" */
    'N','o','v','a','T','e','c','h',' ','N','V','-','9','0','2','W',
/* 0x25d63 = "FlashPro3 Programmer" */
    '\x3c','P','r','o','3',' ','P','r','o','g','r','a','m','m','e','r',
/* 0x25d73 = "GBM Connector Co., Ltd" */
    'G','B','M',' ','C','o','n','n','e','c','t','o','r',' ','\x0e','\x16',
/* 0x25d83 = "Bar Code Scanner (CDC)" */
    'B','a','r',' ','C','o','d','e',' ','\x25',' ','(','C','D','C',')',
/* 0x25d93 = "moonglow OpenXHC" */
    'm','o','o','n','g','l','o','w',' ','O','p','e','n','X','H','C',
/* 0x25da3 = "NM850iG Phone Parent" */
    'N','M','8','5','0','i','G',' ','\x19',' ','P','a','r','e','n','t',
/* 0x25db3 = "Hercules Jukebox" */
    'H','e','r','c','u','l','e','s',' ','J','u','k','e','b','o','x',
/* 0x25dc3 = "VEHO Filmscanner" */
    'V','E','H','O',' ','F','i','l','m','s','c','a','n','n','e','r',
/* 0x25dd3 = "OK1ZIA Davac 4.x" */
    'O','K','1','Z','I','A',' ','D','a','v','a','c',' ','4','.','x',
/* 0x25de3 = "Z12 Color Jetprinter" */
    'Z','1','2',' ','\xa2',' ','J','e','t','p','r','i','n','t','e','r',
/* 0x25df3 = "DE5771 Modem Blaster" */
    'D','E','5','7','7','1',' ','\x1c',' ','B','l','a','s','t','e','r',
/* 0x25e03 = "Gaming Keyboard KPD0250" */
    'G','a','m','i','n','g',' ','\x05',' ','K','P','D','0','2','5','0',
/* 0x25e13 = "smartNIC 2 PnP Ethernet" */
    's','m','a','r','t','N','I','C',' ','2',' ','P','n','P',' ','\x7f',
/* 0x25e23 = "Acton Research Corp." */
    'A','c','t','o','n',' ','R','e','s','e','a','r','c','h',' ','\x10',
/* 0x25e33 = "PhidgetGyroscope" */
    'P','h','i','d','g','e','t','G','y','r','o','s','c','o','p','e',
/* 0x25e43 = "OKI B4600 Mono Printer" */
    'O','K','I',' ','B','4','6','0','0',' ','M','o','n','o',' ','\x0c',
/* 0x25e53 = "FinePix A210 Zoom (PC CAM)" */
    '\xca','i','x',' ','A','2','1','0',' ','\xe6','(','\x1f','C','A','M',')',
/* 0x25e63 = "MX Phone (MTP & ACM)" */
    'M','X',' ','\x19',' ','(','M','T','P',' ','&',' ','A','C','M',')',
/* 0x25e73 = "5530 XpressMusic" */
    '5','5','3','0',' ','X','p','r','e','s','s','M','u','s','i','c',
/* 0x25e83 = "Venture Corp., Ltd" */
    'V','e','n','t','u','r','e',' ','C','o','r','p','.',',',' ','\x16',
/* 0x25e93 = "4 GB flash drive" */
    '4',' ','G','B',' ','f','l','a','s','h',' ','d','r','i','v','e',
/* 0x25ea3 = "PilotMouse Laser - Wired" */
    'P','i','l','o','t','\x0b',' ','\x82',' ','-',' ','W','i','r','e','d',
/* 0x25eb3 = "Cinergy Hybrid Stick" */
    'C','i','n','e','r','g','y',' ','H','y','b','r','i','d',' ','\xb3',
/* 0x25ec3 = "Usb Modem Enumerator" */
    'U','s','b',' ','\x1c',' ','E','n','u','m','e','r','a','t','o','r',
/* 0x25ed3 = "TDK Trans-It 4GB" */
    'T','D','K',' ','T','r','a','n','s','-','I','t',' ','4','G','B',
/* 0x25ee3 = "Optical ScrollPoint Pro Mouse" */
    '\x7b','S','c','r','o','l','l','P','o','i','n','t',' ','\x8f',' ','\x0b',
/* 0x25ef3 = "QuickCam Express / Go" */
    '\xc7','a','m',' ','E','x','p','r','e','s','s',' ','/',' ','G','o',
/* 0x25f03 = "Laboratoires MXM" */
    'L','a','b','o','r','a','t','o','i','r','e','s',' ','M','X','M',
/* 0x25f13 = "Asus Integrated Webcam [CN031B]" */
    'A','s','u','s',' ','\x18','\x11',' ','[','C','N','0','3','1','B',']',
/* 0x25f23 = "Sansa Clip (mtp)" */
    'S','a','n','s','a',' ','C','l','i','p',' ','(','m','t','p',')',
/* 0x25f33 = "P910 series Human Interface Device" */
    'P','9','1','0',' ','\x1d',' ','H','u','m','a','n',' ','\x81',' ','\x03',
/* 0x25f43 = "Dual Mode Camera Plus" */
    'D','u','a','l',' ','M','o','d','e',' ','\x04',' ','P','l','u','s',
/* 0x25f53 = "FinePix S7000 Zoom (PTP)" */
    '\xca','i','x',' ','S','7','0','0','0',' ','\xe6','(','P','T','P',')',
/* 0x25f63 = "unethi PERswitch" */
    'u','n','e','t','h','i',' ','P','E','R','s','w','i','t','c','h',
/* 0x25f73 = "SATA Wire (2.5")" */
    'S','A','T','A',' ','W','i','r','e',' ','(','2','.','5','"',')',
/* 0x25f83 = "LAN-W150/U2M Wireless LAN Adapter" */
    'L','A','N','-','W','1','5','0','/','U','2','M',' ','\x01','\xf3','\x02',
/* 0x25f93 = "Philips (or NXP)" */
    'P','h','i','l','i','p','s',' ','(','o','r',' ','N','X','P',')',
/* 0x25fa3 = "Dazzle DVC100 Audio Device" */
    'D','a','z','z','l','e',' ','D','V','C','1','0','0',' ','\x8b','\x03',
/* 0x25fb3 = "VLxxxx Monitor+Hub" */
    'V','L','x','x','x','x',' ','M','o','n','i','t','o','r','+','\xa4',
/* 0x25fc3 = "Intelligent Instrumentation" */
    '\xe0','I','n','s','t','r','u','m','e','n','t','a','t','i','o','n',
/* 0x25fd3 = "Typhoon StyloCam" */
    'T','y','p','h','o','o','n',' ','S','t','y','l','o','C','a','m',
/* 0x25fe3 = "Rockfire X-Force" */
    'R','o','c','k','f','i','r','e',' ','X','-','F','o','r','c','e',
/* 0x25ff3 = "Consumer Infrared Transceiver (HP)" */
    'C','o','n','s','u','m','e','r',' ','\xa8','\xc8',' ','(','H','P',')',
/* 0x26003 = "DataTraveler 2.0 (2GB)" */
    '\xe7','T','r','a','v','e','l','e','r',' ','\xc1','(','2','G','B',')',
/* 0x26013 = "Asus Integrated 0.3M UVC Webcam" */
    'A','s','u','s',' ','\x18','0','.','3','M',' ','U','V','C',' ','\x11',
/* 0x26023 = "TwinkleCam USB camera" */
    'T','w','i','n','k','l','e','\x9a','\x0a',' ','c','a','m','e','r','a',
/* 0x26033 = "MFC-820CW Remote Setup Port" */
    '\x7d','8','2','0','C','W',' ','\xcb',' ','S','e','t','u','p',' ','\x87',
/* 0x26043 = "Data Translation, Inc." */
    '\xe7',' ','T','r','a','n','s','l','a','t','i','o','n',',',' ','\x07',
/* 0x26053 = "WingMan Gaming Mouse" */
    'W','i','n','g','M','a','n',' ','G','a','m','i','n','g',' ','\x0b',
/* 0x26063 = "QuickCam Pro for Notebooks" */
    '\xc7','a','m',' ','\x8f',' ','\xcc','N','o','t','e','b','o','o','k','s',
/* 0x26073 = "BLUDRIVE II CCID" */
    'B','L','U','D','R','I','V','E',' ','I','I',' ','C','C','I','D',
/* 0x26083 = "T280e GSM/GPRS Phone" */
    'T','2','8','0','e',' ','G','S','M','/','G','P','R','S',' ','\x19',
/* 0x26093 = "Alps Electric Co., Ltd" */
    'A','l','p','s',' ','E','l','e','c','t','r','i','c',' ','\x0e','\x16',
/* 0x260a3 = "Converter Control Unit" */
    'C','o','n','v','e','r','t','e','r',' ','\xc9',' ','U','n','i','t',
/* 0x260b3 = "G25 Racing Wheel" */
    'G','2','5',' ','R','a','c','i','n','g',' ','W','h','e','e','l',
/* 0x260c3 = "MD-Port DG2 MiniDisc Interface" */
    'M','D','-','\x87',' ','D','G','2',' ','\xb9','D','i','s','c',' ','\x81',
/* 0x260d3 = "Starlight Xpress" */
    'S','t','a','r','l','i','g','h','t',' ','X','p','r','e','s','s',
/* 0x260e3 = "Datalogic S.p.A." */
    'D','a','t','a','l','o','g','i','c',' ','S','.','p','.','A','.',
/* 0x260f3 = "Miniature Card Slot" */
    'M','i','n','i','a','t','u','r','e',' ','\x15',' ','S','l','o','t',
/* 0x26103 = "MX Phone (PTP & ADB)" */
    'M','X',' ','\x19',' ','(','P','T','P',' ','&',' ','A','D','B',')',
/* 0x26113 = "Joystick/Gamepad" */
    'J','o','y','s','t','i','c','k','/','G','a','m','e','p','a','d',
/* 0x26123 = "Virtual media for 802.11bg" */
    'V','i','r','t','u','a','l',' ','m','e','d','i','a',' ','\xcc','\xad',
/* 0x26133 = "PC Expert Tech. Co., Ltd" */
    '\x1f','E','x','p','e','r','t',' ','T','e','c','h','.',' ','\x0e','\x16',
/* 0x26143 = "PCA646VC Webcam [pwc]" */
    'P','C','A','6','4','6','V','C',' ','\x11',' ','[','p','w','c',']',
/* 0x26153 = "FinePix S5500 Zoom (DSC)" */
    '\xca','i','x',' ','S','5','5','0','0',' ','\xe6','(','D','S','C',')',
/* 0x26163 = "Rutoken Mass Storage" */
    'R','u','t','o','k','e','n',' ','\x7c','S','t','o','r','a','g','e',
/* 0x26173 = "LightUp (sketch)" */
    'L','i','g','h','t','U','p',' ','(','s','k','e','t','c','h',')',
/* 0x26183 = "ADA-305 Speakers" */
    'A','D','A','-','3','0','5',' ','S','p','e','a','k','e','r','s',
/* 0x26193 = "Fairbanks Scales" */
    'F','a','i','r','b','a','n','k','s',' ','S','c','a','l','e','s',
/* 0x261a3 = "Dazzle DVC90 Video Device" */
    'D','a','z','z','l','e',' ','D','V','C','9','0',' ','\xa3',' ','\x03',
/* 0x261b3 = "Colorado 19200 Scanner" */
    'C','o','l','o','r','a','d','o',' ','1','9','2','0','0',' ','\x25',
/* 0x261c3 = "My Passport Elite (WDML)" */
    'M','y',' ','\xd5','E','l','i','t','e',' ','(','W','D','M','L',')',
/* 0x261d3 = "Patriot 2.0 chipset" */
    'P','a','t','r','i','o','t',' ','\xc1','c','h','i','p','s','e','t',
/* 0x261e3 = "Mikkon Technology Limited" */
    'M','i','k','k','o','n',' ','\x0d',' ','L','i','m','i','t','e','d',
/* 0x261f3 = "ColorPage-HR6/Vivid3" */
    '\xa2','P','a','g','e','-','H','R','6','/','V','i','v','i','d','3',
/* 0x26203 = "TSI Incorporated" */
    'T','S','I',' ','I','n','c','o','r','p','o','r','a','t','e','d',
/* 0x26213 = "rikiki Harddrive" */
    'r','i','k','i','k','i',' ','H','a','r','d','d','r','i','v','e',
/* 0x26223 = "BCM20702A0 Bluetooth 4.0" */
    'B','C','M','2','0','7','0','2','A','0',' ','\x06',' ','4','.','0',
/* 0x26233 = "ADA-310 Speakers" */
    'A','D','A','-','3','1','0',' ','S','p','e','a','k','e','r','s',
/* 0x26243 = "Magicolor 2530DL" */
    'M','a','g','i','c','o','l','o','r',' ','2','5','3','0','D','L',
/* 0x26253 = "Olivetti PG L12L" */
    'O','l','i','v','e','t','t','i',' ','P','G',' ','L','1','2','L',
/* 0x26263 = "CARD STAR/medic2" */
    'C','A','R','D',' ','S','T','A','R','/','m','e','d','i','c','2',
/* 0x26273 = "EasiDock 200 Printer Port" */
    'E','a','s','i','D','o','c','k',' ','2','0','0',' ','\x0c',' ','\x87',
/* 0x26283 = "GF-46 Multi-Mode Display Module" */
    'G','F','-','4','6',' ','\xd6','-','M','o','d','e',' ','\xcf',' ','\xe5',
/* 0x26293 = "Alcatel Mobile Phones" */
    'A','l','c','a','t','e','l',' ','\x96',' ','P','h','o','n','e','s',
/* 0x262a3 = "M2 Portable Hard Drive USB 3.0" */
    'M','2',' ','\xa9','H','a','r','d',' ','\x14',' ','\x0a',' ','3','.','0',
/* 0x262b3 = "LabelManager PnP" */
    'L','a','b','e','l','M','a','n','a','g','e','r',' ','P','n','P',
/* 0x262c3 = "Tyco Electronics (Raychem)" */
    'T','y','c','o',' ','\x1b',' ','(','R','a','y','c','h','e','m',')',
/* 0x262d3 = "82930 Test Board" */
    '8','2','9','3','0',' ','T','e','s','t',' ','B','o','a','r','d',
/* 0x262e3 = "GT-7400U [Perfection 1270]" */
    'G','T','-','7','4','0','0','U',' ','[','\xf0','1','2','7','0',']',
/* 0x262f3 = "MSO300/MSO301 Fingerprint Sensor" */
    'M','S','O','3','0','0','/','M','S','O','3','0','1',' ','\x92','\xac',
/* 0x26303 = "Xbox360 HD-DVD Drive" */
    'X','b','o','x','3','6','0',' ','H','D','-','D','V','D',' ','\x14',
/* 0x26313 = "Post-Op Video, Inc." */
    'P','o','s','t','-','O','p',' ','V','i','d','e','o',',',' ','\x07',
/* 0x26323 = "Access Solutions" */
    'A','c','c','e','s','s',' ','S','o','l','u','t','i','o','n','s',
/* 0x26333 = "EasiDock 200 Serial Port" */
    'E','a','s','i','D','o','c','k',' ','2','0','0',' ','\x90',' ','\x87',
/* 0x26343 = "GYROCOM C&C Co., LTD" */
    'G','Y','R','O','C','O','M',' ','C','&','C',' ','\x0e','L','T','D',
/* 0X26353 = "DeskJet 970c/970cse" */
    'e','s','k','\x80','9','7','0','c','/','9','7','0','c','s','e',
/* 0x26362 = "Zip 100 (Type 1)" */
    'Z','i','p',' ','1','0','0',' ','(','T','y','p','e',' ','1',')',
/* 0x26372 = "Prisa 620U+/640U" */
    'P','r','i','s','a',' ','6','2','0','U','+','/','6','4','0','U',
/* 0x26382 = "Mobile Hard Disk Drive (1TB)" */
    '\x96',' ','H','a','r','d',' ','\xe8',' ','\x14',' ','(','1','T','B',')',
/* 0x26392 = "Elastic Networks" */
    'E','l','a','s','t','i','c',' ','N','e','t','w','o','r','k','s',
/* 0x263a2 = "Data Encryption Systems Ltd." */
    '\xe7',' ','E','n','c','r','y','p','t','i','o','n',' ','\xa6',' ','\xab',
/* 0x263b2 = "M-Systems Flash Disk Pioneers" */
    'M','-','\xa6',' ','\x3c',' ','\xe8',' ','P','i','o','n','e','e','r','s',
/* 0x263c2 = "BenQ-Siemens E81" */
    'B','e','n','Q','-','S','i','e','m','e','n','s',' ','E','8','1',
/* 0x263d2 = "GN-WB30N 802.11n WLAN Card" */
    'G','N','-','W','B','3','0','N',' ','\x99','W','L','A','N',' ','\x15',
/* 0x263e2 = "A920/A925 UMTS Phone" */
    'A','9','2','0','/','A','9','2','5',' ','U','M','T','S',' ','\x19',
/* 0x263f2 = "FinePix F700 Zoom (PC CAM)" */
    '\xca','i','x',' ','F','7','0','0',' ','\xe6','(','\x1f','C','A','M',')',
/* 0x26402 = "NET Gmbh iCube Camera" */
    'N','E','T',' ','G','m','b','h',' ','i','C','u','b','e',' ','\x04',
/* 0x26412 = "ruwido austria GmbH" */
    'r','u','w','i','d','o',' ','a','u','s','t','r','i','a',' ','\xfc',
/* 0x26422 = "So., Show 301 Digital Camera" */
    'S','o','.',',',' ','S','h','o','w',' ','3','0','1',' ','\x09','\x04',
/* 0x26432 = "Xerox 4800 One Touch" */
    'X','e','r','o','x',' ','4','8','0','0',' ','O','n','e',' ','\x9d',
/* 0x26442 = "Musical Fidelity" */
    'M','u','s','i','c','a','l',' ','F','i','d','e','l','i','t','y',
/* 0x26452 = "DFC-365FX camera" */
    'D','F','C','-','3','6','5','F','X',' ','c','a','m','e','r','a',
/* 0x26462 = "PhidgetHumiditySensor" */
    'P','h','i','d','g','e','t','H','u','m','i','d','i','t','y','\xac',
/* 0x26472 = "QuickCam Express Plus" */
    '\xc7','a','m',' ','E','x','p','r','e','s','s',' ','P','l','u','s',
/* 0x26482 = "FID irock! 100 Series" */
    'F','I','D',' ','i','r','o','c','k','!',' ','1','0','0',' ','\xbf',
/* 0x26492 = "FinePix A303 Zoom (PC CAM)" */
    '\xca','i','x',' ','A','3','0','3',' ','\xe6','(','\x1f','C','A','M',')',
/* 0x264a2 = "Firestorm Dual Power" */
    'F','i','r','e','s','t','o','r','m',' ','D','u','a','l',' ','\x24',
/* 0x264b2 = "Boston Acoustics" */
    'B','o','s','t','o','n',' ','A','c','o','u','s','t','i','c','s',
/* 0x264c2 = "C350L/C450 (P2K)" */
    'C','3','5','0','L','/','C','4','5','0',' ','(','P','2','K',')',
/* 0x264d2 = "WiMAX USB modem(s)" */
    'W','i','M','A','X',' ','\x0a',' ','m','o','d','e','m','(