/** @file
 * VirtualBox API class wrapper code for INvramStore.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2025 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_NVRAMSTORE

#include "NvramStoreWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(NvramStoreWrap)

//
// INvramStore properties
//

STDMETHODIMP NvramStoreWrap::COMGETTER(NonVolatileStorageFile)(BSTR *aNonVolatileStorageFile)
{
    LogRelFlow(("{%p} %s: enter aNonVolatileStorageFile=%p\n", this, "NvramStore::getNonVolatileStorageFile", aNonVolatileStorageFile));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aNonVolatileStorageFile);
        BSTROutConverter TmpNonVolatileStorageFile(aNonVolatileStorageFile);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NVRAMSTORE_GET_NONVOLATILESTORAGEFILE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getNonVolatileStorageFile(TmpNonVolatileStorageFile.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NVRAMSTORE_GET_NONVOLATILESTORAGEFILE_RETURN(this, hrc, 0 /*normal*/,TmpNonVolatileStorageFile.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NVRAMSTORE_GET_NONVOLATILESTORAGEFILE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NVRAMSTORE_GET_NONVOLATILESTORAGEFILE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aNonVolatileStorageFile=%ls hrc=%Rhrc\n", this, "NvramStore::getNonVolatileStorageFile", *aNonVolatileStorageFile, hrc));
    return hrc;
}

STDMETHODIMP NvramStoreWrap::COMGETTER(UefiVariableStore)(IUefiVariableStore **aUefiVariableStore)
{
    LogRelFlow(("{%p} %s: enter aUefiVariableStore=%p\n", this, "NvramStore::getUefiVariableStore", aUefiVariableStore));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aUefiVariableStore);
        ComTypeOutConverter<IUefiVariableStore> TmpUefiVariableStore(aUefiVariableStore);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NVRAMSTORE_GET_UEFIVARIABLESTORE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getUefiVariableStore(TmpUefiVariableStore.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NVRAMSTORE_GET_UEFIVARIABLESTORE_RETURN(this, hrc, 0 /*normal*/,(void *)TmpUefiVariableStore.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NVRAMSTORE_GET_UEFIVARIABLESTORE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NVRAMSTORE_GET_UEFIVARIABLESTORE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aUefiVariableStore=%p hrc=%Rhrc\n", this, "NvramStore::getUefiVariableStore", *aUefiVariableStore, hrc));
    return hrc;
}

STDMETHODIMP NvramStoreWrap::COMGETTER(KeyId)(BSTR *aKeyId)
{
    LogRelFlow(("{%p} %s: enter aKeyId=%p\n", this, "NvramStore::getKeyId", aKeyId));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aKeyId);
        BSTROutConverter TmpKeyId(aKeyId);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NVRAMSTORE_GET_KEYID_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getKeyId(TmpKeyId.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NVRAMSTORE_GET_KEYID_RETURN(this, hrc, 0 /*normal*/,TmpKeyId.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NVRAMSTORE_GET_KEYID_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NVRAMSTORE_GET_KEYID_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aKeyId=%ls hrc=%Rhrc\n", this, "NvramStore::getKeyId", *aKeyId, hrc));
    return hrc;
}

STDMETHODIMP NvramStoreWrap::COMGETTER(KeyStore)(BSTR *aKeyStore)
{
    LogRelFlow(("{%p} %s: enter aKeyStore=%p\n", this, "NvramStore::getKeyStore", aKeyStore));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aKeyStore);
        BSTROutConverter TmpKeyStore(aKeyStore);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NVRAMSTORE_GET_KEYSTORE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getKeyStore(TmpKeyStore.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NVRAMSTORE_GET_KEYSTORE_RETURN(this, hrc, 0 /*normal*/,TmpKeyStore.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NVRAMSTORE_GET_KEYSTORE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NVRAMSTORE_GET_KEYSTORE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aKeyStore=%ls hrc=%Rhrc\n", this, "NvramStore::getKeyStore", *aKeyStore, hrc));
    return hrc;
}


//
// INvramStore methods
//

STDMETHODIMP NvramStoreWrap::InitUefiVariableStore(ULONG aSize)
{
    LogRelFlow(("{%p} %s: enter aSize=%RU32\n", this, "NvramStore::initUefiVariableStore", aSize));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NVRAMSTORE_INITUEFIVARIABLESTORE_ENTER(this, aSize);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = initUefiVariableStore(aSize);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NVRAMSTORE_INITUEFIVARIABLESTORE_RETURN(this, hrc, 0 /*normal*/, aSize);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NVRAMSTORE_INITUEFIVARIABLESTORE_RETURN(this, hrc, 1 /*hrc exception*/, aSize);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NVRAMSTORE_INITUEFIVARIABLESTORE_RETURN(this, hrc, 9 /*unhandled exception*/, aSize);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "NvramStore::initUefiVariableStore", hrc));
    return hrc;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(NvramStoreWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(NvramStoreWrap, INvramStore)
#endif // VBOX_WITH_XPCOM
