package kms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RotateSecret invokes the kms.RotateSecret API synchronously
func (client *Client) RotateSecret(request *RotateSecretRequest) (response *RotateSecretResponse, err error) {
	response = CreateRotateSecretResponse()
	err = client.DoAction(request, response)
	return
}

// RotateSecretWithChan invokes the kms.RotateSecret API asynchronously
func (client *Client) RotateSecretWithChan(request *RotateSecretRequest) (<-chan *RotateSecretResponse, <-chan error) {
	responseChan := make(chan *RotateSecretResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RotateSecret(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RotateSecretWithCallback invokes the kms.RotateSecret API asynchronously
func (client *Client) RotateSecretWithCallback(request *RotateSecretRequest, callback func(response *RotateSecretResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RotateSecretResponse
		var err error
		defer close(result)
		response, err = client.RotateSecret(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RotateSecretRequest is the request struct for api RotateSecret
type RotateSecretRequest struct {
	*requests.RpcRequest
	VersionId  string `position:"Query" name:"VersionId"`
	SecretName string `position:"Query" name:"SecretName"`
}

// RotateSecretResponse is the response struct for api RotateSecret
type RotateSecretResponse struct {
	*responses.BaseResponse
	VersionId  string `json:"VersionId" xml:"VersionId"`
	SecretName string `json:"SecretName" xml:"SecretName"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
	Arn        string `json:"Arn" xml:"Arn"`
}

// CreateRotateSecretRequest creates a request to invoke RotateSecret API
func CreateRotateSecretRequest() (request *RotateSecretRequest) {
	request = &RotateSecretRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Kms", "2016-01-20", "RotateSecret", "kms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRotateSecretResponse creates a response to parse from RotateSecret response
func CreateRotateSecretResponse() (response *RotateSecretResponse) {
	response = &RotateSecretResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
