/*
Okta Admin Management

Allows customers to easily access the Okta Management APIs

Copyright 2018 - Present Okta, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

API version: 2024.06.1
Contact: devex-public@okta.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.
package okta

import (
	"encoding/json"
)

// EventHookChannelConfigHeader struct for EventHookChannelConfigHeader
type EventHookChannelConfigHeader struct {
	// The optional field or header name
	Key *string `json:"key,omitempty"`
	// The value for the key
	Value *string `json:"value,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _EventHookChannelConfigHeader EventHookChannelConfigHeader

// NewEventHookChannelConfigHeader instantiates a new EventHookChannelConfigHeader object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewEventHookChannelConfigHeader() *EventHookChannelConfigHeader {
	this := EventHookChannelConfigHeader{}
	return &this
}

// NewEventHookChannelConfigHeaderWithDefaults instantiates a new EventHookChannelConfigHeader object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewEventHookChannelConfigHeaderWithDefaults() *EventHookChannelConfigHeader {
	this := EventHookChannelConfigHeader{}
	return &this
}

// GetKey returns the Key field value if set, zero value otherwise.
func (o *EventHookChannelConfigHeader) GetKey() string {
	if o == nil || o.Key == nil {
		var ret string
		return ret
	}
	return *o.Key
}

// GetKeyOk returns a tuple with the Key field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EventHookChannelConfigHeader) GetKeyOk() (*string, bool) {
	if o == nil || o.Key == nil {
		return nil, false
	}
	return o.Key, true
}

// HasKey returns a boolean if a field has been set.
func (o *EventHookChannelConfigHeader) HasKey() bool {
	if o != nil && o.Key != nil {
		return true
	}

	return false
}

// SetKey gets a reference to the given string and assigns it to the Key field.
func (o *EventHookChannelConfigHeader) SetKey(v string) {
	o.Key = &v
}

// GetValue returns the Value field value if set, zero value otherwise.
func (o *EventHookChannelConfigHeader) GetValue() string {
	if o == nil || o.Value == nil {
		var ret string
		return ret
	}
	return *o.Value
}

// GetValueOk returns a tuple with the Value field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EventHookChannelConfigHeader) GetValueOk() (*string, bool) {
	if o == nil || o.Value == nil {
		return nil, false
	}
	return o.Value, true
}

// HasValue returns a boolean if a field has been set.
func (o *EventHookChannelConfigHeader) HasValue() bool {
	if o != nil && o.Value != nil {
		return true
	}

	return false
}

// SetValue gets a reference to the given string and assigns it to the Value field.
func (o *EventHookChannelConfigHeader) SetValue(v string) {
	o.Value = &v
}

func (o EventHookChannelConfigHeader) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Key != nil {
		toSerialize["key"] = o.Key
	}
	if o.Value != nil {
		toSerialize["value"] = o.Value
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return json.Marshal(toSerialize)
}

func (o *EventHookChannelConfigHeader) UnmarshalJSON(bytes []byte) (err error) {
	varEventHookChannelConfigHeader := _EventHookChannelConfigHeader{}

	err = json.Unmarshal(bytes, &varEventHookChannelConfigHeader)
	if err == nil {
		*o = EventHookChannelConfigHeader(varEventHookChannelConfigHeader)
	} else {
		return err
	}

	additionalProperties := make(map[string]interface{})

	err = json.Unmarshal(bytes, &additionalProperties)
	if err == nil {
		delete(additionalProperties, "key")
		delete(additionalProperties, "value")
		o.AdditionalProperties = additionalProperties
	} else {
		return err
	}

	return err
}

type NullableEventHookChannelConfigHeader struct {
	value *EventHookChannelConfigHeader
	isSet bool
}

func (v NullableEventHookChannelConfigHeader) Get() *EventHookChannelConfigHeader {
	return v.value
}

func (v *NullableEventHookChannelConfigHeader) Set(val *EventHookChannelConfigHeader) {
	v.value = val
	v.isSet = true
}

func (v NullableEventHookChannelConfigHeader) IsSet() bool {
	return v.isSet
}

func (v *NullableEventHookChannelConfigHeader) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableEventHookChannelConfigHeader(val *EventHookChannelConfigHeader) *NullableEventHookChannelConfigHeader {
	return &NullableEventHookChannelConfigHeader{value: val, isSet: true}
}

func (v NullableEventHookChannelConfigHeader) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableEventHookChannelConfigHeader) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}

