/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	apisv1 "sigs.k8s.io/gateway-api/apis/v1"
)

// SessionPersistenceApplyConfiguration represents a declarative configuration of the SessionPersistence type for use
// with apply.
type SessionPersistenceApplyConfiguration struct {
	SessionName     *string                         `json:"sessionName,omitempty"`
	AbsoluteTimeout *apisv1.Duration                `json:"absoluteTimeout,omitempty"`
	IdleTimeout     *apisv1.Duration                `json:"idleTimeout,omitempty"`
	Type            *apisv1.SessionPersistenceType  `json:"type,omitempty"`
	CookieConfig    *CookieConfigApplyConfiguration `json:"cookieConfig,omitempty"`
}

// SessionPersistenceApplyConfiguration constructs a declarative configuration of the SessionPersistence type for use with
// apply.
func SessionPersistence() *SessionPersistenceApplyConfiguration {
	return &SessionPersistenceApplyConfiguration{}
}

// WithSessionName sets the SessionName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the SessionName field is set to the value of the last call.
func (b *SessionPersistenceApplyConfiguration) WithSessionName(value string) *SessionPersistenceApplyConfiguration {
	b.SessionName = &value
	return b
}

// WithAbsoluteTimeout sets the AbsoluteTimeout field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the AbsoluteTimeout field is set to the value of the last call.
func (b *SessionPersistenceApplyConfiguration) WithAbsoluteTimeout(value apisv1.Duration) *SessionPersistenceApplyConfiguration {
	b.AbsoluteTimeout = &value
	return b
}

// WithIdleTimeout sets the IdleTimeout field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the IdleTimeout field is set to the value of the last call.
func (b *SessionPersistenceApplyConfiguration) WithIdleTimeout(value apisv1.Duration) *SessionPersistenceApplyConfiguration {
	b.IdleTimeout = &value
	return b
}

// WithType sets the Type field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Type field is set to the value of the last call.
func (b *SessionPersistenceApplyConfiguration) WithType(value apisv1.SessionPersistenceType) *SessionPersistenceApplyConfiguration {
	b.Type = &value
	return b
}

// WithCookieConfig sets the CookieConfig field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the CookieConfig field is set to the value of the last call.
func (b *SessionPersistenceApplyConfiguration) WithCookieConfig(value *CookieConfigApplyConfiguration) *SessionPersistenceApplyConfiguration {
	b.CookieConfig = value
	return b
}
