// services/device/public/mojom/hid.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_HID_MOJOM_BLINK_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_HID_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/device/public/mojom/hid.mojom-features.h"  // IWYU pragma: export
#include "services/device/public/mojom/hid.mojom-shared.h"  // IWYU pragma: export
#include "services/device/public/mojom/hid.mojom-blink-forward.h"  // IWYU pragma: export

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "base/token.h"
#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace device::mojom::blink {

class HidManagerClientProxy;

template <typename ImplRefTraits>
class HidManagerClientStub;

class HidManagerClientRequestValidator;


class BLINK_PLATFORM_EXPORT HidManagerClient
    : public HidManagerClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr base::Token Uuid_{ 1989324435969231918ULL,
                                      11342538021778458647ULL };
  static constexpr uint32_t Version_ = 2;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = HidManagerClientInterfaceBase;
  using Proxy_ = HidManagerClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = HidManagerClientStub<ImplRefTraits>;

  using RequestValidator_ = HidManagerClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kDeviceAddedMinVersion = 0,
    kDeviceRemovedMinVersion = 0,
    kDeviceChangedMinVersion = 2,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct DeviceAdded_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DeviceRemoved_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DeviceChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~HidManagerClient() = default;

  
  virtual void DeviceAdded(HidDeviceInfoPtr device_info) = 0;

  
  virtual void DeviceRemoved(HidDeviceInfoPtr device_info) = 0;

  
  virtual void DeviceChanged(HidDeviceInfoPtr device_info) = 0;
};

class HidManagerProxy;

template <typename ImplRefTraits>
class HidManagerStub;

class HidManagerRequestValidator;
class HidManagerResponseValidator;


class BLINK_PLATFORM_EXPORT HidManager
    : public HidManagerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr base::Token Uuid_{ 11426502403248704253ULL,
                                      11368651741212670902ULL };
  static constexpr uint32_t Version_ = 2;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = HidManagerInterfaceBase;
  using Proxy_ = HidManagerProxy;

  template <typename ImplRefTraits>
  using Stub_ = HidManagerStub<ImplRefTraits>;

  using RequestValidator_ = HidManagerRequestValidator;
  using ResponseValidator_ = HidManagerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetDevicesAndSetClientMinVersion = 0,
    kGetDevicesMinVersion = 0,
    kConnectMinVersion = 0,
    kAddReceiverMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetDevicesAndSetClient_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetDevices_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Connect_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AddReceiver_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~HidManager() = default;


  using GetDevicesAndSetClientCallback = base::OnceCallback<void(WTF::Vector<HidDeviceInfoPtr>)>;
  
  virtual void GetDevicesAndSetClient(::mojo::PendingAssociatedRemote<HidManagerClient> client, GetDevicesAndSetClientCallback callback) = 0;


  using GetDevicesCallback = base::OnceCallback<void(WTF::Vector<HidDeviceInfoPtr>)>;
  
  virtual void GetDevices(GetDevicesCallback callback) = 0;


  using ConnectCallback = base::OnceCallback<void(::mojo::PendingRemote<HidConnection>)>;
  
  virtual void Connect(const WTF::String& device_guid, ::mojo::PendingRemote<HidConnectionClient> connection_client, ::mojo::PendingRemote<HidConnectionWatcher> watcher, bool allow_protected_reports, bool allow_fido_reports, ConnectCallback callback) = 0;

  
  virtual void AddReceiver(::mojo::PendingReceiver<HidManager> receiver) = 0;
};

class HidConnectionProxy;

template <typename ImplRefTraits>
class HidConnectionStub;

class HidConnectionRequestValidator;
class HidConnectionResponseValidator;


class BLINK_PLATFORM_EXPORT HidConnection
    : public HidConnectionInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr base::Token Uuid_{ 1989324435969231918ULL,
                                      11342538021778458647ULL };
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = HidConnectionInterfaceBase;
  using Proxy_ = HidConnectionProxy;

  template <typename ImplRefTraits>
  using Stub_ = HidConnectionStub<ImplRefTraits>;

  using RequestValidator_ = HidConnectionRequestValidator;
  using ResponseValidator_ = HidConnectionResponseValidator;
  enum MethodMinVersions : uint32_t {
    kReadMinVersion = 0,
    kWriteMinVersion = 0,
    kGetFeatureReportMinVersion = 0,
    kSendFeatureReportMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Read_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Write_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetFeatureReport_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SendFeatureReport_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~HidConnection() = default;


  using ReadCallback = base::OnceCallback<void(bool, uint8_t, const std::optional<WTF::Vector<uint8_t>>&)>;
  
  virtual void Read(ReadCallback callback) = 0;


  using WriteCallback = base::OnceCallback<void(bool)>;
  
  virtual void Write(uint8_t report_id, const WTF::Vector<uint8_t>& buffer, WriteCallback callback) = 0;


  using GetFeatureReportCallback = base::OnceCallback<void(bool, const std::optional<WTF::Vector<uint8_t>>&)>;
  
  virtual void GetFeatureReport(uint8_t report_id, GetFeatureReportCallback callback) = 0;


  using SendFeatureReportCallback = base::OnceCallback<void(bool)>;
  
  virtual void SendFeatureReport(uint8_t report_id, const WTF::Vector<uint8_t>& buffer, SendFeatureReportCallback callback) = 0;
};

class HidConnectionClientProxy;

template <typename ImplRefTraits>
class HidConnectionClientStub;

class HidConnectionClientRequestValidator;


class BLINK_PLATFORM_EXPORT HidConnectionClient
    : public HidConnectionClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr base::Token Uuid_{ 1295147654301829780ULL,
                                      11831959762393443171ULL };
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = HidConnectionClientInterfaceBase;
  using Proxy_ = HidConnectionClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = HidConnectionClientStub<ImplRefTraits>;

  using RequestValidator_ = HidConnectionClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnInputReportMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnInputReport_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~HidConnectionClient() = default;

  
  virtual void OnInputReport(uint8_t report_id, const WTF::Vector<uint8_t>& buffer) = 0;
};

class HidConnectionWatcherProxy;

template <typename ImplRefTraits>
class HidConnectionWatcherStub;

class HidConnectionWatcherRequestValidator;


class BLINK_PLATFORM_EXPORT HidConnectionWatcher
    : public HidConnectionWatcherInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr base::Token Uuid_{ 10011626994008345335ULL,
                                      11258823309103065552ULL };
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = HidConnectionWatcherInterfaceBase;
  using Proxy_ = HidConnectionWatcherProxy;

  template <typename ImplRefTraits>
  using Stub_ = HidConnectionWatcherStub<ImplRefTraits>;

  using RequestValidator_ = HidConnectionWatcherRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~HidConnectionWatcher() = default;
};



class BLINK_PLATFORM_EXPORT HidManagerClientProxy
    : public HidManagerClient {
 public:
  using InterfaceType = HidManagerClient;

  explicit HidManagerClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void DeviceAdded(HidDeviceInfoPtr device_info) final;
  
  void DeviceRemoved(HidDeviceInfoPtr device_info) final;
  
  void DeviceChanged(HidDeviceInfoPtr device_info) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_PLATFORM_EXPORT HidManagerProxy
    : public HidManager {
 public:
  using InterfaceType = HidManager;

  explicit HidManagerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetDevicesAndSetClient(::mojo::PendingAssociatedRemote<HidManagerClient> client, GetDevicesAndSetClientCallback callback) final;
  
  void GetDevices(GetDevicesCallback callback) final;
  
  void Connect(const WTF::String& device_guid, ::mojo::PendingRemote<HidConnectionClient> connection_client, ::mojo::PendingRemote<HidConnectionWatcher> watcher, bool allow_protected_reports, bool allow_fido_reports, ConnectCallback callback) final;
  
  void AddReceiver(::mojo::PendingReceiver<HidManager> receiver) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_PLATFORM_EXPORT HidConnectionProxy
    : public HidConnection {
 public:
  using InterfaceType = HidConnection;

  explicit HidConnectionProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Read(ReadCallback callback) final;
  
  void Write(uint8_t report_id, const WTF::Vector<uint8_t>& buffer, WriteCallback callback) final;
  
  void GetFeatureReport(uint8_t report_id, GetFeatureReportCallback callback) final;
  
  void SendFeatureReport(uint8_t report_id, const WTF::Vector<uint8_t>& buffer, SendFeatureReportCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_PLATFORM_EXPORT HidConnectionClientProxy
    : public HidConnectionClient {
 public:
  using InterfaceType = HidConnectionClient;

  explicit HidConnectionClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnInputReport(uint8_t report_id, const WTF::Vector<uint8_t>& buffer) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_PLATFORM_EXPORT HidConnectionWatcherProxy
    : public HidConnectionWatcher {
 public:
  using InterfaceType = HidConnectionWatcher;

  explicit HidConnectionWatcherProxy(mojo::MessageReceiverWithResponder* receiver);

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_PLATFORM_EXPORT HidManagerClientStubDispatch {
 public:
  static bool Accept(HidManagerClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      HidManagerClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<HidManagerClient>>
class HidManagerClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  HidManagerClientStub() = default;
  ~HidManagerClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return HidManagerClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return HidManagerClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT HidManagerStubDispatch {
 public:
  static bool Accept(HidManager* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      HidManager* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<HidManager>>
class HidManagerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  HidManagerStub() = default;
  ~HidManagerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return HidManagerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return HidManagerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT HidConnectionStubDispatch {
 public:
  static bool Accept(HidConnection* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      HidConnection* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<HidConnection>>
class HidConnectionStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  HidConnectionStub() = default;
  ~HidConnectionStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return HidConnectionStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return HidConnectionStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT HidConnectionClientStubDispatch {
 public:
  static bool Accept(HidConnectionClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      HidConnectionClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<HidConnectionClient>>
class HidConnectionClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  HidConnectionClientStub() = default;
  ~HidConnectionClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return HidConnectionClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return HidConnectionClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT HidConnectionWatcherStubDispatch {
 public:
  static bool Accept(HidConnectionWatcher* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      HidConnectionWatcher* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<HidConnectionWatcher>>
class HidConnectionWatcherStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  HidConnectionWatcherStub() = default;
  ~HidConnectionWatcherStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return HidConnectionWatcherStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return HidConnectionWatcherStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT HidManagerClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT HidManagerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT HidConnectionRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT HidConnectionClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT HidConnectionWatcherRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT HidManagerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT HidConnectionResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class BLINK_PLATFORM_EXPORT HidUsageAndPage {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<HidUsageAndPage, T>::value>;
  using DataView = HidUsageAndPageDataView;
  using Data_ = internal::HidUsageAndPage_Data;

  template <typename... Args>
  static HidUsageAndPagePtr New(Args&&... args) {
    return HidUsageAndPagePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static HidUsageAndPagePtr From(const U& u) {
    return mojo::TypeConverter<HidUsageAndPagePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, HidUsageAndPage>::Convert(*this);
  }


  HidUsageAndPage();

  HidUsageAndPage(
      uint16_t usage,
      uint16_t usage_page);


  ~HidUsageAndPage();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = HidUsageAndPagePtr>
  HidUsageAndPagePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, HidUsageAndPage::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, HidUsageAndPage::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, HidUsageAndPage::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HidUsageAndPage::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        HidUsageAndPage::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::HidUsageAndPage_UnserializedMessageContext<
            UserType, HidUsageAndPage::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<HidUsageAndPage::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return HidUsageAndPage::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::HidUsageAndPage_UnserializedMessageContext<
            UserType, HidUsageAndPage::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<HidUsageAndPage::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint16_t usage;
  
  uint16_t usage_page;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, HidUsageAndPage::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, HidUsageAndPage::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, HidUsageAndPage::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, HidUsageAndPage::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}












class BLINK_PLATFORM_EXPORT HidReportItem {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<HidReportItem, T>::value>;
  using DataView = HidReportItemDataView;
  using Data_ = internal::HidReportItem_Data;

  template <typename... Args>
  static HidReportItemPtr New(Args&&... args) {
    return HidReportItemPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static HidReportItemPtr From(const U& u) {
    return mojo::TypeConverter<HidReportItemPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, HidReportItem>::Convert(*this);
  }


  HidReportItem();

  HidReportItem(
      bool is_range,
      bool is_constant,
      bool is_variable,
      bool is_relative,
      bool wrap,
      bool is_non_linear,
      bool no_preferred_state,
      bool has_null_position,
      bool is_volatile,
      bool is_buffered_bytes,
      WTF::Vector<HidUsageAndPagePtr> usages,
      HidUsageAndPagePtr usage_minimum,
      HidUsageAndPagePtr usage_maximum,
      uint32_t designator_minimum,
      uint32_t designator_maximum,
      uint32_t string_minimum,
      uint32_t string_maximum,
      int32_t logical_minimum,
      int32_t logical_maximum,
      int32_t physical_minimum,
      int32_t physical_maximum,
      uint32_t unit_exponent,
      uint32_t unit,
      uint32_t report_size,
      uint32_t report_count);

HidReportItem(const HidReportItem&) = delete;
HidReportItem& operator=(const HidReportItem&) = delete;

  ~HidReportItem();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = HidReportItemPtr>
  HidReportItemPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, HidReportItem::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, HidReportItem::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, HidReportItem::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HidReportItem::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        HidReportItem::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::HidReportItem_UnserializedMessageContext<
            UserType, HidReportItem::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<HidReportItem::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return HidReportItem::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::HidReportItem_UnserializedMessageContext<
            UserType, HidReportItem::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<HidReportItem::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool is_range;
  
  bool is_constant;
  
  bool is_variable;
  
  bool is_relative;
  
  bool wrap;
  
  bool is_non_linear;
  
  bool no_preferred_state;
  
  bool has_null_position;
  
  bool is_volatile;
  
  bool is_buffered_bytes;
  
  WTF::Vector<HidUsageAndPagePtr> usages;
  
  HidUsageAndPagePtr usage_minimum;
  
  HidUsageAndPagePtr usage_maximum;
  
  uint32_t designator_minimum;
  
  uint32_t designator_maximum;
  
  uint32_t string_minimum;
  
  uint32_t string_maximum;
  
  int32_t logical_minimum;
  
  int32_t logical_maximum;
  
  int32_t physical_minimum;
  
  int32_t physical_maximum;
  
  uint32_t unit_exponent;
  
  uint32_t unit;
  
  uint32_t report_size;
  
  uint32_t report_count;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, HidReportItem::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, HidReportItem::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, HidReportItem::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, HidReportItem::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT HidReportDescription {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<HidReportDescription, T>::value>;
  using DataView = HidReportDescriptionDataView;
  using Data_ = internal::HidReportDescription_Data;

  template <typename... Args>
  static HidReportDescriptionPtr New(Args&&... args) {
    return HidReportDescriptionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static HidReportDescriptionPtr From(const U& u) {
    return mojo::TypeConverter<HidReportDescriptionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, HidReportDescription>::Convert(*this);
  }


  HidReportDescription();

  HidReportDescription(
      uint8_t report_id,
      WTF::Vector<HidReportItemPtr> items);

HidReportDescription(const HidReportDescription&) = delete;
HidReportDescription& operator=(const HidReportDescription&) = delete;

  ~HidReportDescription();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = HidReportDescriptionPtr>
  HidReportDescriptionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, HidReportDescription::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, HidReportDescription::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, HidReportDescription::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HidReportDescription::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        HidReportDescription::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::HidReportDescription_UnserializedMessageContext<
            UserType, HidReportDescription::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<HidReportDescription::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return HidReportDescription::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::HidReportDescription_UnserializedMessageContext<
            UserType, HidReportDescription::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<HidReportDescription::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint8_t report_id;
  
  WTF::Vector<HidReportItemPtr> items;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, HidReportDescription::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, HidReportDescription::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, HidReportDescription::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, HidReportDescription::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT HidCollectionInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<HidCollectionInfo, T>::value>;
  using DataView = HidCollectionInfoDataView;
  using Data_ = internal::HidCollectionInfo_Data;

  template <typename... Args>
  static HidCollectionInfoPtr New(Args&&... args) {
    return HidCollectionInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static HidCollectionInfoPtr From(const U& u) {
    return mojo::TypeConverter<HidCollectionInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, HidCollectionInfo>::Convert(*this);
  }


  HidCollectionInfo();

  HidCollectionInfo(
      HidUsageAndPagePtr usage,
      WTF::Vector<uint8_t> report_ids,
      uint32_t collection_type,
      WTF::Vector<HidReportDescriptionPtr> input_reports,
      WTF::Vector<HidReportDescriptionPtr> output_reports,
      WTF::Vector<HidReportDescriptionPtr> feature_reports,
      WTF::Vector<HidCollectionInfoPtr> children);

HidCollectionInfo(const HidCollectionInfo&) = delete;
HidCollectionInfo& operator=(const HidCollectionInfo&) = delete;

  ~HidCollectionInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = HidCollectionInfoPtr>
  HidCollectionInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, HidCollectionInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, HidCollectionInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, HidCollectionInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HidCollectionInfo::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        HidCollectionInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::HidCollectionInfo_UnserializedMessageContext<
            UserType, HidCollectionInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<HidCollectionInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return HidCollectionInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::HidCollectionInfo_UnserializedMessageContext<
            UserType, HidCollectionInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<HidCollectionInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  HidUsageAndPagePtr usage;
  
  WTF::Vector<uint8_t> report_ids;
  
  uint32_t collection_type;
  
  WTF::Vector<HidReportDescriptionPtr> input_reports;
  
  WTF::Vector<HidReportDescriptionPtr> output_reports;
  
  WTF::Vector<HidReportDescriptionPtr> feature_reports;
  
  WTF::Vector<HidCollectionInfoPtr> children;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, HidCollectionInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, HidCollectionInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, HidCollectionInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, HidCollectionInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT HidDeviceInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<HidDeviceInfo, T>::value>;
  using DataView = HidDeviceInfoDataView;
  using Data_ = internal::HidDeviceInfo_Data;

  template <typename... Args>
  static HidDeviceInfoPtr New(Args&&... args) {
    return HidDeviceInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static HidDeviceInfoPtr From(const U& u) {
    return mojo::TypeConverter<HidDeviceInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, HidDeviceInfo>::Convert(*this);
  }


  HidDeviceInfo();

  HidDeviceInfo(
      const WTF::String& guid,
      const WTF::String& physical_device_id,
      uint16_t vendor_id,
      uint16_t product_id,
      const WTF::String& product_name,
      const WTF::String& serial_number,
      HidBusType bus_type,
      WTF::Vector<uint8_t> report_descriptor,
      WTF::Vector<HidCollectionInfoPtr> collections,
      bool has_report_id,
      uint64_t max_input_report_size,
      uint64_t max_output_report_size,
      uint64_t max_feature_report_size,
      const WTF::String& device_node);

  HidDeviceInfo(
      const WTF::String& guid,
      const WTF::String& physical_device_id,
      uint16_t vendor_id,
      uint16_t product_id,
      const WTF::String& product_name,
      const WTF::String& serial_number,
      HidBusType bus_type,
      WTF::Vector<uint8_t> report_descriptor,
      WTF::Vector<HidCollectionInfoPtr> collections,
      bool has_report_id,
      uint64_t max_input_report_size,
      uint64_t max_output_report_size,
      uint64_t max_feature_report_size,
      const WTF::String& device_node,
      std::optional<WTF::Vector<uint8_t>> protected_input_report_ids,
      std::optional<WTF::Vector<uint8_t>> protected_output_report_ids,
      std::optional<WTF::Vector<uint8_t>> protected_feature_report_ids);

  HidDeviceInfo(
      const WTF::String& guid,
      const WTF::String& physical_device_id,
      uint16_t vendor_id,
      uint16_t product_id,
      const WTF::String& product_name,
      const WTF::String& serial_number,
      HidBusType bus_type,
      WTF::Vector<uint8_t> report_descriptor,
      WTF::Vector<HidCollectionInfoPtr> collections,
      bool has_report_id,
      uint64_t max_input_report_size,
      uint64_t max_output_report_size,
      uint64_t max_feature_report_size,
      const WTF::String& device_node,
      std::optional<WTF::Vector<uint8_t>> protected_input_report_ids,
      std::optional<WTF::Vector<uint8_t>> protected_output_report_ids,
      std::optional<WTF::Vector<uint8_t>> protected_feature_report_ids,
      bool is_excluded_by_blocklist);

HidDeviceInfo(const HidDeviceInfo&) = delete;
HidDeviceInfo& operator=(const HidDeviceInfo&) = delete;

  ~HidDeviceInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = HidDeviceInfoPtr>
  HidDeviceInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, HidDeviceInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, HidDeviceInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, HidDeviceInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HidDeviceInfo::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        HidDeviceInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::HidDeviceInfo_UnserializedMessageContext<
            UserType, HidDeviceInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<HidDeviceInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return HidDeviceInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::HidDeviceInfo_UnserializedMessageContext<
            UserType, HidDeviceInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<HidDeviceInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  WTF::String guid;
  
  WTF::String physical_device_id;
  
  uint16_t vendor_id;
  
  uint16_t product_id;
  
  WTF::String product_name;
  
  WTF::String serial_number;
  
  HidBusType bus_type;
  
  WTF::Vector<uint8_t> report_descriptor;
  
  WTF::Vector<HidCollectionInfoPtr> collections;
  
  bool has_report_id;
  
  uint64_t max_input_report_size;
  
  uint64_t max_output_report_size;
  
  uint64_t max_feature_report_size;
  
  WTF::String device_node;
  
  std::optional<WTF::Vector<uint8_t>> protected_input_report_ids;
  
  std::optional<WTF::Vector<uint8_t>> protected_output_report_ids;
  
  std::optional<WTF::Vector<uint8_t>> protected_feature_report_ids;
  
  bool is_excluded_by_blocklist;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, HidDeviceInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, HidDeviceInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, HidDeviceInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, HidDeviceInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
HidUsageAndPagePtr HidUsageAndPage::Clone() const {
  return New(
      mojo::Clone(usage),
      mojo::Clone(usage_page)
  );
}

template <typename T, HidUsageAndPage::EnableIfSame<T>*>
bool HidUsageAndPage::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->usage, other_struct.usage))
    return false;
  if (!mojo::Equals(this->usage_page, other_struct.usage_page))
    return false;
  return true;
}

template <typename T, HidUsageAndPage::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.usage < rhs.usage)
    return true;
  if (rhs.usage < lhs.usage)
    return false;
  if (lhs.usage_page < rhs.usage_page)
    return true;
  if (rhs.usage_page < lhs.usage_page)
    return false;
  return false;
}
template <typename StructPtrType>
HidReportItemPtr HidReportItem::Clone() const {
  return New(
      mojo::Clone(is_range),
      mojo::Clone(is_constant),
      mojo::Clone(is_variable),
      mojo::Clone(is_relative),
      mojo::Clone(wrap),
      mojo::Clone(is_non_linear),
      mojo::Clone(no_preferred_state),
      mojo::Clone(has_null_position),
      mojo::Clone(is_volatile),
      mojo::Clone(is_buffered_bytes),
      mojo::Clone(usages),
      mojo::Clone(usage_minimum),
      mojo::Clone(usage_maximum),
      mojo::Clone(designator_minimum),
      mojo::Clone(designator_maximum),
      mojo::Clone(string_minimum),
      mojo::Clone(string_maximum),
      mojo::Clone(logical_minimum),
      mojo::Clone(logical_maximum),
      mojo::Clone(physical_minimum),
      mojo::Clone(physical_maximum),
      mojo::Clone(unit_exponent),
      mojo::Clone(unit),
      mojo::Clone(report_size),
      mojo::Clone(report_count)
  );
}

template <typename T, HidReportItem::EnableIfSame<T>*>
bool HidReportItem::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->is_range, other_struct.is_range))
    return false;
  if (!mojo::Equals(this->is_constant, other_struct.is_constant))
    return false;
  if (!mojo::Equals(this->is_variable, other_struct.is_variable))
    return false;
  if (!mojo::Equals(this->is_relative, other_struct.is_relative))
    return false;
  if (!mojo::Equals(this->wrap, other_struct.wrap))
    return false;
  if (!mojo::Equals(this->is_non_linear, other_struct.is_non_linear))
    return false;
  if (!mojo::Equals(this->no_preferred_state, other_struct.no_preferred_state))
    return false;
  if (!mojo::Equals(this->has_null_position, other_struct.has_null_position))
    return false;
  if (!mojo::Equals(this->is_volatile, other_struct.is_volatile))
    return false;
  if (!mojo::Equals(this->is_buffered_bytes, other_struct.is_buffered_bytes))
    return false;
  if (!mojo::Equals(this->usages, other_struct.usages))
    return false;
  if (!mojo::Equals(this->usage_minimum, other_struct.usage_minimum))
    return false;
  if (!mojo::Equals(this->usage_maximum, other_struct.usage_maximum))
    return false;
  if (!mojo::Equals(this->designator_minimum, other_struct.designator_minimum))
    return false;
  if (!mojo::Equals(this->designator_maximum, other_struct.designator_maximum))
    return false;
  if (!mojo::Equals(this->string_minimum, other_struct.string_minimum))
    return false;
  if (!mojo::Equals(this->string_maximum, other_struct.string_maximum))
    return false;
  if (!mojo::Equals(this->logical_minimum, other_struct.logical_minimum))
    return false;
  if (!mojo::Equals(this->logical_maximum, other_struct.logical_maximum))
    return false;
  if (!mojo::Equals(this->physical_minimum, other_struct.physical_minimum))
    return false;
  if (!mojo::Equals(this->physical_maximum, other_struct.physical_maximum))
    return false;
  if (!mojo::Equals(this->unit_exponent, other_struct.unit_exponent))
    return false;
  if (!mojo::Equals(this->unit, other_struct.unit))
    return false;
  if (!mojo::Equals(this->report_size, other_struct.report_size))
    return false;
  if (!mojo::Equals(this->report_count, other_struct.report_count))
    return false;
  return true;
}

template <typename T, HidReportItem::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.is_range < rhs.is_range)
    return true;
  if (rhs.is_range < lhs.is_range)
    return false;
  if (lhs.is_constant < rhs.is_constant)
    return true;
  if (rhs.is_constant < lhs.is_constant)
    return false;
  if (lhs.is_variable < rhs.is_variable)
    return true;
  if (rhs.is_variable < lhs.is_variable)
    return false;
  if (lhs.is_relative < rhs.is_relative)
    return true;
  if (rhs.is_relative < lhs.is_relative)
    return false;
  if (lhs.wrap < rhs.wrap)
    return true;
  if (rhs.wrap < lhs.wrap)
    return false;
  if (lhs.is_non_linear < rhs.is_non_linear)
    return true;
  if (rhs.is_non_linear < lhs.is_non_linear)
    return false;
  if (lhs.no_preferred_state < rhs.no_preferred_state)
    return true;
  if (rhs.no_preferred_state < lhs.no_preferred_state)
    return false;
  if (lhs.has_null_position < rhs.has_null_position)
    return true;
  if (rhs.has_null_position < lhs.has_null_position)
    return false;
  if (lhs.is_volatile < rhs.is_volatile)
    return true;
  if (rhs.is_volatile < lhs.is_volatile)
    return false;
  if (lhs.is_buffered_bytes < rhs.is_buffered_bytes)
    return true;
  if (rhs.is_buffered_bytes < lhs.is_buffered_bytes)
    return false;
  if (lhs.usages < rhs.usages)
    return true;
  if (rhs.usages < lhs.usages)
    return false;
  if (lhs.usage_minimum < rhs.usage_minimum)
    return true;
  if (rhs.usage_minimum < lhs.usage_minimum)
    return false;
  if (lhs.usage_maximum < rhs.usage_maximum)
    return true;
  if (rhs.usage_maximum < lhs.usage_maximum)
    return false;
  if (lhs.designator_minimum < rhs.designator_minimum)
    return true;
  if (rhs.designator_minimum < lhs.designator_minimum)
    return false;
  if (lhs.designator_maximum < rhs.designator_maximum)
    return true;
  if (rhs.designator_maximum < lhs.designator_maximum)
    return false;
  if (lhs.string_minimum < rhs.string_minimum)
    return true;
  if (rhs.string_minimum < lhs.string_minimum)
    return false;
  if (lhs.string_maximum < rhs.string_maximum)
    return true;
  if (rhs.string_maximum < lhs.string_maximum)
    return false;
  if (lhs.logical_minimum < rhs.logical_minimum)
    return true;
  if (rhs.logical_minimum < lhs.logical_minimum)
    return false;
  if (lhs.logical_maximum < rhs.logical_maximum)
    return true;
  if (rhs.logical_maximum < lhs.logical_maximum)
    return false;
  if (lhs.physical_minimum < rhs.physical_minimum)
    return true;
  if (rhs.physical_minimum < lhs.physical_minimum)
    return false;
  if (lhs.physical_maximum < rhs.physical_maximum)
    return true;
  if (rhs.physical_maximum < lhs.physical_maximum)
    return false;
  if (lhs.unit_exponent < rhs.unit_exponent)
    return true;
  if (rhs.unit_exponent < lhs.unit_exponent)
    return false;
  if (lhs.unit < rhs.unit)
    return true;
  if (rhs.unit < lhs.unit)
    return false;
  if (lhs.report_size < rhs.report_size)
    return true;
  if (rhs.report_size < lhs.report_size)
    return false;
  if (lhs.report_count < rhs.report_count)
    return true;
  if (rhs.report_count < lhs.report_count)
    return false;
  return false;
}
template <typename StructPtrType>
HidReportDescriptionPtr HidReportDescription::Clone() const {
  return New(
      mojo::Clone(report_id),
      mojo::Clone(items)
  );
}

template <typename T, HidReportDescription::EnableIfSame<T>*>
bool HidReportDescription::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->report_id, other_struct.report_id))
    return false;
  if (!mojo::Equals(this->items, other_struct.items))
    return false;
  return true;
}

template <typename T, HidReportDescription::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.report_id < rhs.report_id)
    return true;
  if (rhs.report_id < lhs.report_id)
    return false;
  if (lhs.items < rhs.items)
    return true;
  if (rhs.items < lhs.items)
    return false;
  return false;
}
template <typename StructPtrType>
HidCollectionInfoPtr HidCollectionInfo::Clone() const {
  return New(
      mojo::Clone(usage),
      mojo::Clone(report_ids),
      mojo::Clone(collection_type),
      mojo::Clone(input_reports),
      mojo::Clone(output_reports),
      mojo::Clone(feature_reports),
      mojo::Clone(children)
  );
}

template <typename T, HidCollectionInfo::EnableIfSame<T>*>
bool HidCollectionInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->usage, other_struct.usage))
    return false;
  if (!mojo::Equals(this->report_ids, other_struct.report_ids))
    return false;
  if (!mojo::Equals(this->collection_type, other_struct.collection_type))
    return false;
  if (!mojo::Equals(this->input_reports, other_struct.input_reports))
    return false;
  if (!mojo::Equals(this->output_reports, other_struct.output_reports))
    return false;
  if (!mojo::Equals(this->feature_reports, other_struct.feature_reports))
    return false;
  if (!mojo::Equals(this->children, other_struct.children))
    return false;
  return true;
}

template <typename T, HidCollectionInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.usage < rhs.usage)
    return true;
  if (rhs.usage < lhs.usage)
    return false;
  if (lhs.report_ids < rhs.report_ids)
    return true;
  if (rhs.report_ids < lhs.report_ids)
    return false;
  if (lhs.collection_type < rhs.collection_type)
    return true;
  if (rhs.collection_type < lhs.collection_type)
    return false;
  if (lhs.input_reports < rhs.input_reports)
    return true;
  if (rhs.input_reports < lhs.input_reports)
    return false;
  if (lhs.output_reports < rhs.output_reports)
    return true;
  if (rhs.output_reports < lhs.output_reports)
    return false;
  if (lhs.feature_reports < rhs.feature_reports)
    return true;
  if (rhs.feature_reports < lhs.feature_reports)
    return false;
  if (lhs.children < rhs.children)
    return true;
  if (rhs.children < lhs.children)
    return false;
  return false;
}
template <typename StructPtrType>
HidDeviceInfoPtr HidDeviceInfo::Clone() const {
  return New(
      mojo::Clone(guid),
      mojo::Clone(physical_device_id),
      mojo::Clone(vendor_id),
      mojo::Clone(product_id),
      mojo::Clone(product_name),
      mojo::Clone(serial_number),
      mojo::Clone(bus_type),
      mojo::Clone(report_descriptor),
      mojo::Clone(collections),
      mojo::Clone(has_report_id),
      mojo::Clone(max_input_report_size),
      mojo::Clone(max_output_report_size),
      mojo::Clone(max_feature_report_size),
      mojo::Clone(device_node),
      mojo::Clone(protected_input_report_ids),
      mojo::Clone(protected_output_report_ids),
      mojo::Clone(protected_feature_report_ids),
      mojo::Clone(is_excluded_by_blocklist)
  );
}

template <typename T, HidDeviceInfo::EnableIfSame<T>*>
bool HidDeviceInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->guid, other_struct.guid))
    return false;
  if (!mojo::Equals(this->physical_device_id, other_struct.physical_device_id))
    return false;
  if (!mojo::Equals(this->vendor_id, other_struct.vendor_id))
    return false;
  if (!mojo::Equals(this->product_id, other_struct.product_id))
    return false;
  if (!mojo::Equals(this->product_name, other_struct.product_name))
    return false;
  if (!mojo::Equals(this->serial_number, other_struct.serial_number))
    return false;
  if (!mojo::Equals(this->bus_type, other_struct.bus_type))
    return false;
  if (!mojo::Equals(this->report_descriptor, other_struct.report_descriptor))
    return false;
  if (!mojo::Equals(this->collections, other_struct.collections))
    return false;
  if (!mojo::Equals(this->has_report_id, other_struct.has_report_id))
    return false;
  if (!mojo::Equals(this->max_input_report_size, other_struct.max_input_report_size))
    return false;
  if (!mojo::Equals(this->max_output_report_size, other_struct.max_output_report_size))
    return false;
  if (!mojo::Equals(this->max_feature_report_size, other_struct.max_feature_report_size))
    return false;
  if (!mojo::Equals(this->device_node, other_struct.device_node))
    return false;
  if (!mojo::Equals(this->protected_input_report_ids, other_struct.protected_input_report_ids))
    return false;
  if (!mojo::Equals(this->protected_output_report_ids, other_struct.protected_output_report_ids))
    return false;
  if (!mojo::Equals(this->protected_feature_report_ids, other_struct.protected_feature_report_ids))
    return false;
  if (!mojo::Equals(this->is_excluded_by_blocklist, other_struct.is_excluded_by_blocklist))
    return false;
  return true;
}

template <typename T, HidDeviceInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.guid < rhs.guid)
    return true;
  if (rhs.guid < lhs.guid)
    return false;
  if (lhs.physical_device_id < rhs.physical_device_id)
    return true;
  if (rhs.physical_device_id < lhs.physical_device_id)
    return false;
  if (lhs.vendor_id < rhs.vendor_id)
    return true;
  if (rhs.vendor_id < lhs.vendor_id)
    return false;
  if (lhs.product_id < rhs.product_id)
    return true;
  if (rhs.product_id < lhs.product_id)
    return false;
  if (lhs.product_name < rhs.product_name)
    return true;
  if (rhs.product_name < lhs.product_name)
    return false;
  if (lhs.serial_number < rhs.serial_number)
    return true;
  if (rhs.serial_number < lhs.serial_number)
    return false;
  if (lhs.bus_type < rhs.bus_type)
    return true;
  if (rhs.bus_type < lhs.bus_type)
    return false;
  if (lhs.report_descriptor < rhs.report_descriptor)
    return true;
  if (rhs.report_descriptor < lhs.report_descriptor)
    return false;
  if (lhs.collections < rhs.collections)
    return true;
  if (rhs.collections < lhs.collections)
    return false;
  if (lhs.has_report_id < rhs.has_report_id)
    return true;
  if (rhs.has_report_id < lhs.has_report_id)
    return false;
  if (lhs.max_input_report_size < rhs.max_input_report_size)
    return true;
  if (rhs.max_input_report_size < lhs.max_input_report_size)
    return false;
  if (lhs.max_output_report_size < rhs.max_output_report_size)
    return true;
  if (rhs.max_output_report_size < lhs.max_output_report_size)
    return false;
  if (lhs.max_feature_report_size < rhs.max_feature_report_size)
    return true;
  if (rhs.max_feature_report_size < lhs.max_feature_report_size)
    return false;
  if (lhs.device_node < rhs.device_node)
    return true;
  if (rhs.device_node < lhs.device_node)
    return false;
  if (lhs.protected_input_report_ids < rhs.protected_input_report_ids)
    return true;
  if (rhs.protected_input_report_ids < lhs.protected_input_report_ids)
    return false;
  if (lhs.protected_output_report_ids < rhs.protected_output_report_ids)
    return true;
  if (rhs.protected_output_report_ids < lhs.protected_output_report_ids)
    return false;
  if (lhs.protected_feature_report_ids < rhs.protected_feature_report_ids)
    return true;
  if (rhs.protected_feature_report_ids < lhs.protected_feature_report_ids)
    return false;
  if (lhs.is_excluded_by_blocklist < rhs.is_excluded_by_blocklist)
    return true;
  if (rhs.is_excluded_by_blocklist < lhs.is_excluded_by_blocklist)
    return false;
  return false;
}


}  // device::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::device::mojom::blink::HidUsageAndPage::DataView,
                                         ::device::mojom::blink::HidUsageAndPagePtr> {
  static bool IsNull(const ::device::mojom::blink::HidUsageAndPagePtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::HidUsageAndPagePtr* output) { output->reset(); }

  static decltype(::device::mojom::blink::HidUsageAndPage::usage) usage(
      const ::device::mojom::blink::HidUsageAndPagePtr& input) {
    return input->usage;
  }

  static decltype(::device::mojom::blink::HidUsageAndPage::usage_page) usage_page(
      const ::device::mojom::blink::HidUsageAndPagePtr& input) {
    return input->usage_page;
  }

  static bool Read(::device::mojom::blink::HidUsageAndPage::DataView input, ::device::mojom::blink::HidUsageAndPagePtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::device::mojom::blink::HidReportItem::DataView,
                                         ::device::mojom::blink::HidReportItemPtr> {
  static bool IsNull(const ::device::mojom::blink::HidReportItemPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::HidReportItemPtr* output) { output->reset(); }

  static decltype(::device::mojom::blink::HidReportItem::is_range) is_range(
      const ::device::mojom::blink::HidReportItemPtr& input) {
    return input->is_range;
  }

  static decltype(::device::mojom::blink::HidReportItem::is_constant) is_constant(
      const ::device::mojom::blink::HidReportItemPtr& input) {
    return input->is_constant;
  }

  static decltype(::device::mojom::blink::HidReportItem::is_variable) is_variable(
      const ::device::mojom::blink::HidReportItemPtr& input) {
    return input->is_variable;
  }

  static decltype(::device::mojom::blink::HidReportItem::is_relative) is_relative(
      const ::device::mojom::blink::HidReportItemPtr& input) {
    return input->is_relative;
  }

  static decltype(::device::mojom::blink::HidReportItem::wrap) wrap(
      const ::device::mojom::blink::HidReportItemPtr& input) {
    return input->wrap;
  }

  static decltype(::device::mojom::blink::HidReportItem::is_non_linear) is_non_linear(
      const ::device::mojom::blink::HidReportItemPtr& input) {
    return input->is_non_linear;
  }

  static decltype(::device::mojom::blink::HidReportItem::no_preferred_state) no_preferred_state(
      const ::device::mojom::blink::HidReportItemPtr& input) {
    return input->no_preferred_state;
  }

  static decltype(::device::mojom::blink::HidReportItem::has_null_position) has_null_position(
      const ::device::mojom::blink::HidReportItemPtr& input) {
    return input->has_null_position;
  }

  static decltype(::device::mojom::blink::HidReportItem::is_volatile) is_volatile(
      const ::device::mojom::blink::HidReportItemPtr& input) {
    return input->is_volatile;
  }

  static decltype(::device::mojom::blink::HidReportItem::is_buffered_bytes) is_buffered_bytes(
      const ::device::mojom::blink::HidReportItemPtr& input) {
    return input->is_buffered_bytes;
  }

  static const decltype(::device::mojom::blink::HidReportItem::usages)& usages(
      const ::device::mojom::blink::HidReportItemPtr& input) {
    return input->usages;
  }

  static const decltype(::device::mojom::blink::HidReportItem::usage_minimum)& usage_minimum(
      const ::device::mojom::blink::HidReportItemPtr& input) {
    return input->usage_minimum;
  }

  static const decltype(::device::mojom::blink::HidReportItem::usage_maximum)& usage_maximum(
      const ::device::mojom::blink::HidReportItemPtr& input) {
    return input->usage_maximum;
  }

  static decltype(::device::mojom::blink::HidReportItem::designator_minimum) designator_minimum(
      const ::device::mojom::blink::HidReportItemPtr& input) {
    return input->designator_minimum;
  }

  static decltype(::device::mojom::blink::HidReportItem::designator_maximum) designator_maximum(
      const ::device::mojom::blink::HidReportItemPtr& input) {
    return input->designator_maximum;
  }

  static decltype(::device::mojom::blink::HidReportItem::string_minimum) string_minimum(
      const ::device::mojom::blink::HidReportItemPtr& input) {
    return input->string_minimum;
  }

  static decltype(::device::mojom::blink::HidReportItem::string_maximum) string_maximum(
      const ::device::mojom::blink::HidReportItemPtr& input) {
    return input->string_maximum;
  }

  static decltype(::device::mojom::blink::HidReportItem::logical_minimum) logical_minimum(
      const ::device::mojom::blink::HidReportItemPtr& input) {
    return input->logical_minimum;
  }

  static decltype(::device::mojom::blink::HidReportItem::logical_maximum) logical_maximum(
      const ::device::mojom::blink::HidReportItemPtr& input) {
    return input->logical_maximum;
  }

  static decltype(::device::mojom::blink::HidReportItem::physical_minimum) physical_minimum(
      const ::device::mojom::blink::HidReportItemPtr& input) {
    return input->physical_minimum;
  }

  static decltype(::device::mojom::blink::HidReportItem::physical_maximum) physical_maximum(
      const ::device::mojom::blink::HidReportItemPtr& input) {
    return input->physical_maximum;
  }

  static decltype(::device::mojom::blink::HidReportItem::unit_exponent) unit_exponent(
      const ::device::mojom::blink::HidReportItemPtr& input) {
    return input->unit_exponent;
  }

  static decltype(::device::mojom::blink::HidReportItem::unit) unit(
      const ::device::mojom::blink::HidReportItemPtr& input) {
    return input->unit;
  }

  static decltype(::device::mojom::blink::HidReportItem::report_size) report_size(
      const ::device::mojom::blink::HidReportItemPtr& input) {
    return input->report_size;
  }

  static decltype(::device::mojom::blink::HidReportItem::report_count) report_count(
      const ::device::mojom::blink::HidReportItemPtr& input) {
    return input->report_count;
  }

  static bool Read(::device::mojom::blink::HidReportItem::DataView input, ::device::mojom::blink::HidReportItemPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::device::mojom::blink::HidReportDescription::DataView,
                                         ::device::mojom::blink::HidReportDescriptionPtr> {
  static bool IsNull(const ::device::mojom::blink::HidReportDescriptionPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::HidReportDescriptionPtr* output) { output->reset(); }

  static decltype(::device::mojom::blink::HidReportDescription::report_id) report_id(
      const ::device::mojom::blink::HidReportDescriptionPtr& input) {
    return input->report_id;
  }

  static const decltype(::device::mojom::blink::HidReportDescription::items)& items(
      const ::device::mojom::blink::HidReportDescriptionPtr& input) {
    return input->items;
  }

  static bool Read(::device::mojom::blink::HidReportDescription::DataView input, ::device::mojom::blink::HidReportDescriptionPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::device::mojom::blink::HidCollectionInfo::DataView,
                                         ::device::mojom::blink::HidCollectionInfoPtr> {
  static bool IsNull(const ::device::mojom::blink::HidCollectionInfoPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::HidCollectionInfoPtr* output) { output->reset(); }

  static const decltype(::device::mojom::blink::HidCollectionInfo::usage)& usage(
      const ::device::mojom::blink::HidCollectionInfoPtr& input) {
    return input->usage;
  }

  static const decltype(::device::mojom::blink::HidCollectionInfo::report_ids)& report_ids(
      const ::device::mojom::blink::HidCollectionInfoPtr& input) {
    return input->report_ids;
  }

  static decltype(::device::mojom::blink::HidCollectionInfo::collection_type) collection_type(
      const ::device::mojom::blink::HidCollectionInfoPtr& input) {
    return input->collection_type;
  }

  static const decltype(::device::mojom::blink::HidCollectionInfo::input_reports)& input_reports(
      const ::device::mojom::blink::HidCollectionInfoPtr& input) {
    return input->input_reports;
  }

  static const decltype(::device::mojom::blink::HidCollectionInfo::output_reports)& output_reports(
      const ::device::mojom::blink::HidCollectionInfoPtr& input) {
    return input->output_reports;
  }

  static const decltype(::device::mojom::blink::HidCollectionInfo::feature_reports)& feature_reports(
      const ::device::mojom::blink::HidCollectionInfoPtr& input) {
    return input->feature_reports;
  }

  static const decltype(::device::mojom::blink::HidCollectionInfo::children)& children(
      const ::device::mojom::blink::HidCollectionInfoPtr& input) {
    return input->children;
  }

  static bool Read(::device::mojom::blink::HidCollectionInfo::DataView input, ::device::mojom::blink::HidCollectionInfoPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::device::mojom::blink::HidDeviceInfo::DataView,
                                         ::device::mojom::blink::HidDeviceInfoPtr> {
  static bool IsNull(const ::device::mojom::blink::HidDeviceInfoPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::HidDeviceInfoPtr* output) { output->reset(); }

  static const decltype(::device::mojom::blink::HidDeviceInfo::guid)& guid(
      const ::device::mojom::blink::HidDeviceInfoPtr& input) {
    return input->guid;
  }

  static const decltype(::device::mojom::blink::HidDeviceInfo::physical_device_id)& physical_device_id(
      const ::device::mojom::blink::HidDeviceInfoPtr& input) {
    return input->physical_device_id;
  }

  static decltype(::device::mojom::blink::HidDeviceInfo::vendor_id) vendor_id(
      const ::device::mojom::blink::HidDeviceInfoPtr& input) {
    return input->vendor_id;
  }

  static decltype(::device::mojom::blink::HidDeviceInfo::product_id) product_id(
      const ::device::mojom::blink::HidDeviceInfoPtr& input) {
    return input->product_id;
  }

  static const decltype(::device::mojom::blink::HidDeviceInfo::product_name)& product_name(
      const ::device::mojom::blink::HidDeviceInfoPtr& input) {
    return input->product_name;
  }

  static const decltype(::device::mojom::blink::HidDeviceInfo::serial_number)& serial_number(
      const ::device::mojom::blink::HidDeviceInfoPtr& input) {
    return input->serial_number;
  }

  static decltype(::device::mojom::blink::HidDeviceInfo::bus_type) bus_type(
      const ::device::mojom::blink::HidDeviceInfoPtr& input) {
    return input->bus_type;
  }

  static const decltype(::device::mojom::blink::HidDeviceInfo::report_descriptor)& report_descriptor(
      const ::device::mojom::blink::HidDeviceInfoPtr& input) {
    return input->report_descriptor;
  }

  static const decltype(::device::mojom::blink::HidDeviceInfo::collections)& collections(
      const ::device::mojom::blink::HidDeviceInfoPtr& input) {
    return input->collections;
  }

  static decltype(::device::mojom::blink::HidDeviceInfo::has_report_id) has_report_id(
      const ::device::mojom::blink::HidDeviceInfoPtr& input) {
    return input->has_report_id;
  }

  static decltype(::device::mojom::blink::HidDeviceInfo::max_input_report_size) max_input_report_size(
      const ::device::mojom::blink::HidDeviceInfoPtr& input) {
    return input->max_input_report_size;
  }

  static decltype(::device::mojom::blink::HidDeviceInfo::max_output_report_size) max_output_report_size(
      const ::device::mojom::blink::HidDeviceInfoPtr& input) {
    return input->max_output_report_size;
  }

  static decltype(::device::mojom::blink::HidDeviceInfo::max_feature_report_size) max_feature_report_size(
      const ::device::mojom::blink::HidDeviceInfoPtr& input) {
    return input->max_feature_report_size;
  }

  static const decltype(::device::mojom::blink::HidDeviceInfo::device_node)& device_node(
      const ::device::mojom::blink::HidDeviceInfoPtr& input) {
    return input->device_node;
  }

  static const decltype(::device::mojom::blink::HidDeviceInfo::protected_input_report_ids)& protected_input_report_ids(
      const ::device::mojom::blink::HidDeviceInfoPtr& input) {
    return input->protected_input_report_ids;
  }

  static const decltype(::device::mojom::blink::HidDeviceInfo::protected_output_report_ids)& protected_output_report_ids(
      const ::device::mojom::blink::HidDeviceInfoPtr& input) {
    return input->protected_output_report_ids;
  }

  static const decltype(::device::mojom::blink::HidDeviceInfo::protected_feature_report_ids)& protected_feature_report_ids(
      const ::device::mojom::blink::HidDeviceInfoPtr& input) {
    return input->protected_feature_report_ids;
  }

  static decltype(::device::mojom::blink::HidDeviceInfo::is_excluded_by_blocklist) is_excluded_by_blocklist(
      const ::device::mojom::blink::HidDeviceInfoPtr& input) {
    return input->is_excluded_by_blocklist;
  }

  static bool Read(::device::mojom::blink::HidDeviceInfo::DataView input, ::device::mojom::blink::HidDeviceInfoPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_DEVICE_PUBLIC_MOJOM_HID_MOJOM_BLINK_H_