// third_party/blink/public/mojom/worker/worker_options.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WORKER_WORKER_OPTIONS_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WORKER_WORKER_OPTIONS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/worker/worker_options.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/worker/worker_options.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/worker/worker_options.mojom-forward.h"  // IWYU pragma: export
#include "services/network/public/mojom/fetch_api.mojom-forward.h"
#include "third_party/blink/public/mojom/script/script_type.mojom-forward.h"
#include <string>
#include <vector>




#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {





class BLINK_COMMON_EXPORT WorkerOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WorkerOptions, T>::value>;
  using DataView = WorkerOptionsDataView;
  using Data_ = internal::WorkerOptions_Data;

  template <typename... Args>
  static WorkerOptionsPtr New(Args&&... args) {
    return WorkerOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WorkerOptionsPtr From(const U& u) {
    return mojo::TypeConverter<WorkerOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WorkerOptions>::Convert(*this);
  }


  WorkerOptions();

  WorkerOptions(
      ::blink::mojom::ScriptType type,
      ::network::mojom::CredentialsMode credentials,
      const std::string& name);


  ~WorkerOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WorkerOptionsPtr>
  WorkerOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WorkerOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WorkerOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WorkerOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WorkerOptions::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WorkerOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WorkerOptions_UnserializedMessageContext<
            UserType, WorkerOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WorkerOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WorkerOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WorkerOptions_UnserializedMessageContext<
            UserType, WorkerOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WorkerOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::mojom::ScriptType type;
  
  ::network::mojom::CredentialsMode credentials;
  
  std::string name;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WorkerOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WorkerOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WorkerOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WorkerOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}




template <typename StructPtrType>
WorkerOptionsPtr WorkerOptions::Clone() const {
  return New(
      mojo::Clone(type),
      mojo::Clone(credentials),
      mojo::Clone(name)
  );
}

template <typename T, WorkerOptions::EnableIfSame<T>*>
bool WorkerOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->credentials, other_struct.credentials))
    return false;
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  return true;
}

template <typename T, WorkerOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.credentials < rhs.credentials)
    return true;
  if (rhs.credentials < lhs.credentials)
    return false;
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::WorkerOptions::DataView,
                                         ::blink::mojom::WorkerOptionsPtr> {
  static bool IsNull(const ::blink::mojom::WorkerOptionsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::WorkerOptionsPtr* output) { output->reset(); }

  static decltype(::blink::mojom::WorkerOptions::type) type(
      const ::blink::mojom::WorkerOptionsPtr& input) {
    return input->type;
  }

  static decltype(::blink::mojom::WorkerOptions::credentials) credentials(
      const ::blink::mojom::WorkerOptionsPtr& input) {
    return input->credentials;
  }

  static const decltype(::blink::mojom::WorkerOptions::name)& name(
      const ::blink::mojom::WorkerOptionsPtr& input) {
    return input->name;
  }

  static bool Read(::blink::mojom::WorkerOptions::DataView input, ::blink::mojom::WorkerOptionsPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_WORKER_WORKER_OPTIONS_MOJOM_H_