// ui/ozone/public/mojom/gesture_properties_service.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "ui/ozone/public/mojom/gesture_properties_service.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/ozone/public/mojom/gesture_properties_service.mojom-params-data.h"
#include "ui/ozone/public/mojom/gesture_properties_service.mojom-shared-message-ids.h"

#include "ui/ozone/public/mojom/gesture_properties_service.mojom-import-headers.h"
#include "ui/ozone/public/mojom/gesture_properties_service.mojom-test-utils.h"


namespace ui::ozone::mojom {
GesturePropValue::GesturePropValue() : tag_(Tag::kInts) {
  data_.ints = new std::vector<int32_t>;
}

GesturePropValue::~GesturePropValue() {
  DestroyActive();
}


void GesturePropValue::set_ints(
    std::vector<int32_t> ints) {
  if (tag_ == Tag::kInts) {
    *(data_.ints) = std::move(ints);
  } else {
    DestroyActive();
    tag_ = Tag::kInts;
    data_.ints = new std::vector<int32_t>(
        std::move(ints));
  }
}
void GesturePropValue::set_shorts(
    std::vector<int16_t> shorts) {
  if (tag_ == Tag::kShorts) {
    *(data_.shorts) = std::move(shorts);
  } else {
    DestroyActive();
    tag_ = Tag::kShorts;
    data_.shorts = new std::vector<int16_t>(
        std::move(shorts));
  }
}
void GesturePropValue::set_bools(
    std::vector<bool> bools) {
  if (tag_ == Tag::kBools) {
    *(data_.bools) = std::move(bools);
  } else {
    DestroyActive();
    tag_ = Tag::kBools;
    data_.bools = new std::vector<bool>(
        std::move(bools));
  }
}
void GesturePropValue::set_str(
    const std::string& str) {
  if (tag_ == Tag::kStr) {
    *(data_.str) = std::move(str);
  } else {
    DestroyActive();
    tag_ = Tag::kStr;
    data_.str = new std::string(
        std::move(str));
  }
}
void GesturePropValue::set_reals(
    std::vector<double> reals) {
  if (tag_ == Tag::kReals) {
    *(data_.reals) = std::move(reals);
  } else {
    DestroyActive();
    tag_ = Tag::kReals;
    data_.reals = new std::vector<double>(
        std::move(reals));
  }
}

void GesturePropValue::DestroyActive() {
  switch (tag_) {

    case Tag::kInts:

      delete data_.ints;
      break;
    case Tag::kShorts:

      delete data_.shorts;
      break;
    case Tag::kBools:

      delete data_.bools;
      break;
    case Tag::kStr:

      delete data_.str;
      break;
    case Tag::kReals:

      delete data_.reals;
      break;
  }
}

bool GesturePropValue::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
const char GesturePropertiesService::Name_[] = "ui.ozone.mojom.GesturePropertiesService";

GesturePropertiesService::IPCStableHashFunction GesturePropertiesService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::GesturePropertiesService>(message.name())) {
    case messages::GesturePropertiesService::kListDevices: {
      return &GesturePropertiesService::ListDevices_Sym::IPCStableHash;
    }
    case messages::GesturePropertiesService::kListProperties: {
      return &GesturePropertiesService::ListProperties_Sym::IPCStableHash;
    }
    case messages::GesturePropertiesService::kGetProperty: {
      return &GesturePropertiesService::GetProperty_Sym::IPCStableHash;
    }
    case messages::GesturePropertiesService::kSetProperty: {
      return &GesturePropertiesService::SetProperty_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* GesturePropertiesService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::GesturePropertiesService>(message.name())) {
      case messages::GesturePropertiesService::kListDevices:
            return "Receive ui::ozone::mojom::GesturePropertiesService::ListDevices";
      case messages::GesturePropertiesService::kListProperties:
            return "Receive ui::ozone::mojom::GesturePropertiesService::ListProperties";
      case messages::GesturePropertiesService::kGetProperty:
            return "Receive ui::ozone::mojom::GesturePropertiesService::GetProperty";
      case messages::GesturePropertiesService::kSetProperty:
            return "Receive ui::ozone::mojom::GesturePropertiesService::SetProperty";
    }
  } else {
    switch (static_cast<messages::GesturePropertiesService>(message.name())) {
      case messages::GesturePropertiesService::kListDevices:
            return "Receive reply ui::ozone::mojom::GesturePropertiesService::ListDevices";
      case messages::GesturePropertiesService::kListProperties:
            return "Receive reply ui::ozone::mojom::GesturePropertiesService::ListProperties";
      case messages::GesturePropertiesService::kGetProperty:
            return "Receive reply ui::ozone::mojom::GesturePropertiesService::GetProperty";
      case messages::GesturePropertiesService::kSetProperty:
            return "Receive reply ui::ozone::mojom::GesturePropertiesService::SetProperty";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t GesturePropertiesService::ListDevices_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)ui::ozone::mojom::GesturePropertiesService::ListDevices");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GesturePropertiesService::ListProperties_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)ui::ozone::mojom::GesturePropertiesService::ListProperties");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GesturePropertiesService::GetProperty_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)ui::ozone::mojom::GesturePropertiesService::GetProperty");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GesturePropertiesService::SetProperty_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)ui::ozone::mojom::GesturePropertiesService::SetProperty");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class GesturePropertiesService_ListDevices_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GesturePropertiesService_ListDevices_ForwardToCallback(
      GesturePropertiesService::ListDevicesCallback callback
      ) : callback_(std::move(callback)) {
  }

  GesturePropertiesService_ListDevices_ForwardToCallback(const GesturePropertiesService_ListDevices_ForwardToCallback&) = delete;
  GesturePropertiesService_ListDevices_ForwardToCallback& operator=(const GesturePropertiesService_ListDevices_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  GesturePropertiesService::ListDevicesCallback callback_;
};

class GesturePropertiesService_ListProperties_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GesturePropertiesService_ListProperties_ForwardToCallback(
      GesturePropertiesService::ListPropertiesCallback callback
      ) : callback_(std::move(callback)) {
  }

  GesturePropertiesService_ListProperties_ForwardToCallback(const GesturePropertiesService_ListProperties_ForwardToCallback&) = delete;
  GesturePropertiesService_ListProperties_ForwardToCallback& operator=(const GesturePropertiesService_ListProperties_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  GesturePropertiesService::ListPropertiesCallback callback_;
};

class GesturePropertiesService_GetProperty_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GesturePropertiesService_GetProperty_ForwardToCallback(
      GesturePropertiesService::GetPropertyCallback callback
      ) : callback_(std::move(callback)) {
  }

  GesturePropertiesService_GetProperty_ForwardToCallback(const GesturePropertiesService_GetProperty_ForwardToCallback&) = delete;
  GesturePropertiesService_GetProperty_ForwardToCallback& operator=(const GesturePropertiesService_GetProperty_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  GesturePropertiesService::GetPropertyCallback callback_;
};

class GesturePropertiesService_SetProperty_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GesturePropertiesService_SetProperty_ForwardToCallback(
      GesturePropertiesService::SetPropertyCallback callback
      ) : callback_(std::move(callback)) {
  }

  GesturePropertiesService_SetProperty_ForwardToCallback(const GesturePropertiesService_SetProperty_ForwardToCallback&) = delete;
  GesturePropertiesService_SetProperty_ForwardToCallback& operator=(const GesturePropertiesService_SetProperty_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  GesturePropertiesService::SetPropertyCallback callback_;
};

GesturePropertiesServiceProxy::GesturePropertiesServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void GesturePropertiesServiceProxy::ListDevices(
    ListDevicesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send ui::ozone::mojom::GesturePropertiesService::ListDevices");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GesturePropertiesService::kListDevices), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::ui::ozone::mojom::internal::GesturePropertiesService_ListDevices_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GesturePropertiesService::Name_);
  message.set_method_name("ListDevices");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GesturePropertiesService_ListDevices_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void GesturePropertiesServiceProxy::ListProperties(
    int32_t in_device_id, ListPropertiesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send ui::ozone::mojom::GesturePropertiesService::ListProperties", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_id"), in_device_id,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GesturePropertiesService::kListProperties), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::ui::ozone::mojom::internal::GesturePropertiesService_ListProperties_Params_Data> params(
          message);
  params.Allocate();
  params->device_id = in_device_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GesturePropertiesService::Name_);
  message.set_method_name("ListProperties");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GesturePropertiesService_ListProperties_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void GesturePropertiesServiceProxy::GetProperty(
    int32_t in_device_id, const std::string& in_name, GetPropertyCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send ui::ozone::mojom::GesturePropertiesService::GetProperty", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_id"), in_device_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), in_name,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GesturePropertiesService::kGetProperty), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::ui::ozone::mojom::internal::GesturePropertiesService_GetProperty_Params_Data> params(
          message);
  params.Allocate();
  params->device_id = in_device_id;
  mojo::internal::MessageFragment<
      typename decltype(params->name)::BaseType> name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_name, name_fragment);
  params->name.Set(
      name_fragment.is_null() ? nullptr : name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in GesturePropertiesService.GetProperty request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GesturePropertiesService::Name_);
  message.set_method_name("GetProperty");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GesturePropertiesService_GetProperty_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void GesturePropertiesServiceProxy::SetProperty(
    int32_t in_device_id, const std::string& in_name, GesturePropValuePtr in_value, SetPropertyCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send ui::ozone::mojom::GesturePropertiesService::SetProperty", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_id"), in_device_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), in_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value"), in_value,
                        "<value of type GesturePropValuePtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GesturePropertiesService::kSetProperty), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::ui::ozone::mojom::internal::GesturePropertiesService_SetProperty_Params_Data> params(
          message);
  params.Allocate();
  params->device_id = in_device_id;
  mojo::internal::MessageFragment<
      typename decltype(params->name)::BaseType> name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_name, name_fragment);
  params->name.Set(
      name_fragment.is_null() ? nullptr : name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in GesturePropertiesService.SetProperty request");
  mojo::internal::MessageFragment<decltype(params->value)>
      value_fragment(params.message());
  value_fragment.Claim(&params->value);
  mojo::internal::Serialize<::ui::ozone::mojom::GesturePropValueDataView>(
      in_value, value_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->value.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null value in GesturePropertiesService.SetProperty request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GesturePropertiesService::Name_);
  message.set_method_name("SetProperty");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GesturePropertiesService_SetProperty_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class GesturePropertiesService_ListDevices_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static GesturePropertiesService::ListDevicesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<GesturePropertiesService_ListDevices_ProxyToResponder> proxy(
        new GesturePropertiesService_ListDevices_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&GesturePropertiesService_ListDevices_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GesturePropertiesService_ListDevices_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  GesturePropertiesService_ListDevices_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "GesturePropertiesService::ListDevicesCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const base::flat_map<int32_t, std::string>& in_result);
};

bool GesturePropertiesService_ListDevices_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::GesturePropertiesService_ListDevices_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GesturePropertiesService_ListDevices_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for GesturePropertiesService.0
  bool success = true;
  base::flat_map<int32_t, std::string> p_result{};
  GesturePropertiesService_ListDevices_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GesturePropertiesService::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void GesturePropertiesService_ListDevices_ProxyToResponder::Run(
    const base::flat_map<int32_t, std::string>& in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply ui::ozone::mojom::GesturePropertiesService::ListDevices", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type const base::flat_map<int32_t, std::string>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GesturePropertiesService::kListDevices), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::ui::ozone::mojom::internal::GesturePropertiesService_ListDevices_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType>
      result_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& result_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
  mojo::internal::Serialize<mojo::MapDataView<int32_t, mojo::StringDataView>>(
      in_result, result_fragment, &result_validate_params);
  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GesturePropertiesService::Name_);
  message.set_method_name("ListDevices");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class GesturePropertiesService_ListProperties_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static GesturePropertiesService::ListPropertiesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<GesturePropertiesService_ListProperties_ProxyToResponder> proxy(
        new GesturePropertiesService_ListProperties_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&GesturePropertiesService_ListProperties_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GesturePropertiesService_ListProperties_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  GesturePropertiesService_ListProperties_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "GesturePropertiesService::ListPropertiesCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<std::string>& in_properties);
};

bool GesturePropertiesService_ListProperties_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::GesturePropertiesService_ListProperties_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GesturePropertiesService_ListProperties_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for GesturePropertiesService.1
  bool success = true;
  std::vector<std::string> p_properties{};
  GesturePropertiesService_ListProperties_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadProperties(&p_properties))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GesturePropertiesService::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_properties));
  return true;
}

void GesturePropertiesService_ListProperties_ProxyToResponder::Run(
    const std::vector<std::string>& in_properties) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply ui::ozone::mojom::GesturePropertiesService::ListProperties", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("properties"), in_properties,
                        "<value of type const std::vector<std::string>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GesturePropertiesService::kListProperties), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::ui::ozone::mojom::internal::GesturePropertiesService_ListProperties_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->properties)::BaseType>
      properties_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& properties_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_properties, properties_fragment, &properties_validate_params);
  params->properties.Set(
      properties_fragment.is_null() ? nullptr : properties_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->properties.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null properties in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GesturePropertiesService::Name_);
  message.set_method_name("ListProperties");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class GesturePropertiesService_GetProperty_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static GesturePropertiesService::GetPropertyCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<GesturePropertiesService_GetProperty_ProxyToResponder> proxy(
        new GesturePropertiesService_GetProperty_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&GesturePropertiesService_GetProperty_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GesturePropertiesService_GetProperty_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  GesturePropertiesService_GetProperty_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "GesturePropertiesService::GetPropertyCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_is_read_only, GesturePropValuePtr in_value);
};

bool GesturePropertiesService_GetProperty_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::GesturePropertiesService_GetProperty_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GesturePropertiesService_GetProperty_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for GesturePropertiesService.2
  bool success = true;
  bool p_is_read_only{};
  GesturePropValuePtr p_value{};
  GesturePropertiesService_GetProperty_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_is_read_only = input_data_view.is_read_only();
  if (success && !input_data_view.ReadValue(&p_value))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GesturePropertiesService::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_is_read_only), 
std::move(p_value));
  return true;
}

void GesturePropertiesService_GetProperty_ProxyToResponder::Run(
    bool in_is_read_only, GesturePropValuePtr in_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply ui::ozone::mojom::GesturePropertiesService::GetProperty", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_read_only"), in_is_read_only,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("value"), in_value,
                        "<value of type GesturePropValuePtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GesturePropertiesService::kGetProperty), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::ui::ozone::mojom::internal::GesturePropertiesService_GetProperty_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->is_read_only = in_is_read_only;
  mojo::internal::MessageFragment<decltype(params->value)>
      value_fragment(params.message());
  value_fragment.Claim(&params->value);
  mojo::internal::Serialize<::ui::ozone::mojom::GesturePropValueDataView>(
      in_value, value_fragment, true);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GesturePropertiesService::Name_);
  message.set_method_name("GetProperty");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class GesturePropertiesService_SetProperty_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static GesturePropertiesService::SetPropertyCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<GesturePropertiesService_SetProperty_ProxyToResponder> proxy(
        new GesturePropertiesService_SetProperty_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&GesturePropertiesService_SetProperty_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GesturePropertiesService_SetProperty_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  GesturePropertiesService_SetProperty_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "GesturePropertiesService::SetPropertyCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      SetGesturePropErrorCode in_error);
};

bool GesturePropertiesService_SetProperty_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::GesturePropertiesService_SetProperty_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GesturePropertiesService_SetProperty_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for GesturePropertiesService.3
  bool success = true;
  SetGesturePropErrorCode p_error{};
  GesturePropertiesService_SetProperty_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GesturePropertiesService::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_error));
  return true;
}

void GesturePropertiesService_SetProperty_ProxyToResponder::Run(
    SetGesturePropErrorCode in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply ui::ozone::mojom::GesturePropertiesService::SetProperty", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type SetGesturePropErrorCode>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GesturePropertiesService::kSetProperty), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::ui::ozone::mojom::internal::GesturePropertiesService_SetProperty_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::ui::ozone::mojom::SetGesturePropErrorCode>(
      in_error, &params->error);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GesturePropertiesService::Name_);
  message.set_method_name("SetProperty");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool GesturePropertiesServiceStubDispatch::Accept(
    GesturePropertiesService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::GesturePropertiesService>(message->header()->name)) {
    case messages::GesturePropertiesService::kListDevices: {
      break;
    }
    case messages::GesturePropertiesService::kListProperties: {
      break;
    }
    case messages::GesturePropertiesService::kGetProperty: {
      break;
    }
    case messages::GesturePropertiesService::kSetProperty: {
      break;
    }
  }
  return false;
}

// static
bool GesturePropertiesServiceStubDispatch::AcceptWithResponder(
    GesturePropertiesService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::GesturePropertiesService>(message->header()->name)) {
    case messages::GesturePropertiesService::kListDevices: {
      internal::GesturePropertiesService_ListDevices_Params_Data* params =
          reinterpret_cast<
              internal::GesturePropertiesService_ListDevices_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for GesturePropertiesService.0
      bool success = true;
      GesturePropertiesService_ListDevices_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GesturePropertiesService::Name_, 0, false);
        return false;
      }
      GesturePropertiesService::ListDevicesCallback callback =
          GesturePropertiesService_ListDevices_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ListDevices(std::move(callback));
      return true;
    }
    case messages::GesturePropertiesService::kListProperties: {
      internal::GesturePropertiesService_ListProperties_Params_Data* params =
          reinterpret_cast<
              internal::GesturePropertiesService_ListProperties_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for GesturePropertiesService.1
      bool success = true;
      int32_t p_device_id{};
      GesturePropertiesService_ListProperties_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_device_id = input_data_view.device_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GesturePropertiesService::Name_, 1, false);
        return false;
      }
      GesturePropertiesService::ListPropertiesCallback callback =
          GesturePropertiesService_ListProperties_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ListProperties(        
        std::move(p_device_id), std::move(callback));
      return true;
    }
    case messages::GesturePropertiesService::kGetProperty: {
      internal::GesturePropertiesService_GetProperty_Params_Data* params =
          reinterpret_cast<
              internal::GesturePropertiesService_GetProperty_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for GesturePropertiesService.2
      bool success = true;
      int32_t p_device_id{};
      std::string p_name{};
      GesturePropertiesService_GetProperty_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_device_id = input_data_view.device_id();
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GesturePropertiesService::Name_, 2, false);
        return false;
      }
      GesturePropertiesService::GetPropertyCallback callback =
          GesturePropertiesService_GetProperty_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetProperty(        
        std::move(p_device_id), 
        std::move(p_name), std::move(callback));
      return true;
    }
    case messages::GesturePropertiesService::kSetProperty: {
      internal::GesturePropertiesService_SetProperty_Params_Data* params =
          reinterpret_cast<
              internal::GesturePropertiesService_SetProperty_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for GesturePropertiesService.3
      bool success = true;
      int32_t p_device_id{};
      std::string p_name{};
      GesturePropValuePtr p_value{};
      GesturePropertiesService_SetProperty_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_device_id = input_data_view.device_id();
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (success && !input_data_view.ReadValue(&p_value))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GesturePropertiesService::Name_, 3, false);
        return false;
      }
      GesturePropertiesService::SetPropertyCallback callback =
          GesturePropertiesService_SetProperty_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetProperty(        
        std::move(p_device_id), 
        std::move(p_name), 
        std::move(p_value), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kGesturePropertiesServiceValidationInfo[] = {
    {base::to_underlying(messages::GesturePropertiesService::kListDevices),
     { &internal::GesturePropertiesService_ListDevices_Params_Data::Validate,
      &internal::GesturePropertiesService_ListDevices_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::GesturePropertiesService::kListProperties),
     { &internal::GesturePropertiesService_ListProperties_Params_Data::Validate,
      &internal::GesturePropertiesService_ListProperties_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::GesturePropertiesService::kGetProperty),
     { &internal::GesturePropertiesService_GetProperty_Params_Data::Validate,
      &internal::GesturePropertiesService_GetProperty_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::GesturePropertiesService::kSetProperty),
     { &internal::GesturePropertiesService_SetProperty_Params_Data::Validate,
      &internal::GesturePropertiesService_SetProperty_ResponseParams_Data::Validate}},
};

bool GesturePropertiesServiceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::ui::ozone::mojom::GesturePropertiesService::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kGesturePropertiesServiceValidationInfo);
}

bool GesturePropertiesServiceResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::ui::ozone::mojom::GesturePropertiesService::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kGesturePropertiesServiceValidationInfo);

}


}  // ui::ozone::mojom


namespace mojo {

// static
bool UnionTraits<::ui::ozone::mojom::GesturePropValue::DataView, ::ui::ozone::mojom::GesturePropValuePtr>::Read(
    ::ui::ozone::mojom::GesturePropValue::DataView input,
    ::ui::ozone::mojom::GesturePropValuePtr* output) {
  using UnionType = ::ui::ozone::mojom::GesturePropValue;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kInts: {
      std::vector<int32_t> result_ints;
      if (!input.ReadInts(&result_ints))
        return false;

      *output = UnionType::NewInts(
          std::move(result_ints));
      break;
    }
    case Tag::kShorts: {
      std::vector<int16_t> result_shorts;
      if (!input.ReadShorts(&result_shorts))
        return false;

      *output = UnionType::NewShorts(
          std::move(result_shorts));
      break;
    }
    case Tag::kBools: {
      std::vector<bool> result_bools;
      if (!input.ReadBools(&result_bools))
        return false;

      *output = UnionType::NewBools(
          std::move(result_bools));
      break;
    }
    case Tag::kStr: {
      std::string result_str;
      if (!input.ReadStr(&result_str))
        return false;

      *output = UnionType::NewStr(
          std::move(result_str));
      break;
    }
    case Tag::kReals: {
      std::vector<double> result_reals;
      if (!input.ReadReals(&result_reals))
        return false;

      *output = UnionType::NewReals(
          std::move(result_reals));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace ui::ozone::mojom {


void GesturePropertiesServiceInterceptorForTesting::ListDevices(ListDevicesCallback callback) {
  GetForwardingInterface()->ListDevices(std::move(callback));
}
void GesturePropertiesServiceInterceptorForTesting::ListProperties(int32_t device_id, ListPropertiesCallback callback) {
  GetForwardingInterface()->ListProperties(
    std::move(device_id)
    , std::move(callback));
}
void GesturePropertiesServiceInterceptorForTesting::GetProperty(int32_t device_id, const std::string& name, GetPropertyCallback callback) {
  GetForwardingInterface()->GetProperty(
    std::move(device_id)
    , 
    std::move(name)
    , std::move(callback));
}
void GesturePropertiesServiceInterceptorForTesting::SetProperty(int32_t device_id, const std::string& name, GesturePropValuePtr value, SetPropertyCallback callback) {
  GetForwardingInterface()->SetProperty(
    std::move(device_id)
    , 
    std::move(name)
    , 
    std::move(value)
    , std::move(callback));
}
GesturePropertiesServiceAsyncWaiter::GesturePropertiesServiceAsyncWaiter(
    GesturePropertiesService* proxy) : proxy_(proxy) {}

GesturePropertiesServiceAsyncWaiter::~GesturePropertiesServiceAsyncWaiter() = default;

void GesturePropertiesServiceAsyncWaiter::ListDevices(
    base::flat_map<int32_t, std::string>* out_result) {
  base::RunLoop loop;
  proxy_->ListDevices(
      base::BindOnce(
          [](base::RunLoop* loop,
             base::flat_map<int32_t, std::string>* out_result
,
             const base::flat_map<int32_t, std::string>& result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

base::flat_map<int32_t, std::string> GesturePropertiesServiceAsyncWaiter::ListDevices(
    ) {
  base::flat_map<int32_t, std::string> async_wait_result;
  ListDevices(&async_wait_result);
  return async_wait_result;
}

void GesturePropertiesServiceAsyncWaiter::ListProperties(
    int32_t device_id, std::vector<std::string>* out_properties) {
  base::RunLoop loop;
  proxy_->ListProperties(
      std::move(device_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<std::string>* out_properties
,
             const std::vector<std::string>& properties) {*out_properties = std::move(properties);
            loop->Quit();
          },
          &loop,
          out_properties));
  loop.Run();
}

std::vector<std::string> GesturePropertiesServiceAsyncWaiter::ListProperties(
    int32_t device_id) {
  std::vector<std::string> async_wait_result;
  ListProperties(std::move(device_id),&async_wait_result);
  return async_wait_result;
}

void GesturePropertiesServiceAsyncWaiter::GetProperty(
    int32_t device_id, const std::string& name, bool* out_is_read_only, GesturePropValuePtr* out_value) {
  base::RunLoop loop;
  proxy_->GetProperty(
      std::move(device_id),
      std::move(name),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_is_read_only
,
             GesturePropValuePtr* out_value
,
             bool is_read_only,
             GesturePropValuePtr value) {*out_is_read_only = std::move(is_read_only);*out_value = std::move(value);
            loop->Quit();
          },
          &loop,
          out_is_read_only,
          out_value));
  loop.Run();
}



void GesturePropertiesServiceAsyncWaiter::SetProperty(
    int32_t device_id, const std::string& name, GesturePropValuePtr value, SetGesturePropErrorCode* out_error) {
  base::RunLoop loop;
  proxy_->SetProperty(
      std::move(device_id),
      std::move(name),
      std::move(value),
      base::BindOnce(
          [](base::RunLoop* loop,
             SetGesturePropErrorCode* out_error
,
             SetGesturePropErrorCode error) {*out_error = std::move(error);
            loop->Quit();
          },
          &loop,
          out_error));
  loop.Run();
}

SetGesturePropErrorCode GesturePropertiesServiceAsyncWaiter::SetProperty(
    int32_t device_id, const std::string& name, GesturePropValuePtr value) {
  SetGesturePropErrorCode async_wait_result;
  SetProperty(std::move(device_id),std::move(name),std::move(value),&async_wait_result);
  return async_wait_result;
}






}  // ui::ozone::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif