// third_party/blink/public/mojom/webid/digital_identity_request.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBID_DIGITAL_IDENTITY_REQUEST_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBID_DIGITAL_IDENTITY_REQUEST_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/webid/digital_identity_request.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/webid/digital_identity_request.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/webid/digital_identity_request.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class DigitalIdentityRequestProxy;

template <typename ImplRefTraits>
class DigitalIdentityRequestStub;

class DigitalIdentityRequestRequestValidator;
class DigitalIdentityRequestResponseValidator;


class BLINK_COMMON_EXPORT DigitalIdentityRequest
    : public DigitalIdentityRequestInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = DigitalIdentityRequestInterfaceBase;
  using Proxy_ = DigitalIdentityRequestProxy;

  template <typename ImplRefTraits>
  using Stub_ = DigitalIdentityRequestStub<ImplRefTraits>;

  using RequestValidator_ = DigitalIdentityRequestRequestValidator;
  using ResponseValidator_ = DigitalIdentityRequestResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetMinVersion = 0,
    kCreateMinVersion = 0,
    kAbortMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Get_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Create_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Abort_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~DigitalIdentityRequest() = default;


  using GetCallback = base::OnceCallback<void(RequestDigitalIdentityStatus, const std::optional<std::string>&, const std::optional<std::string>&)>;
  
  virtual void Get(std::vector<DigitalCredentialRequestPtr> digital_credential_requests, GetRequestFormat format, GetCallback callback) = 0;


  using CreateCallback = base::OnceCallback<void(RequestDigitalIdentityStatus, const std::optional<std::string>&, const std::optional<std::string>&)>;
  
  virtual void Create(DigitalCredentialRequestPtr digital_credential_request, CreateCallback callback) = 0;

  
  virtual void Abort() = 0;
};



class BLINK_COMMON_EXPORT DigitalIdentityRequestProxy
    : public DigitalIdentityRequest {
 public:
  using InterfaceType = DigitalIdentityRequest;

  explicit DigitalIdentityRequestProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Get(std::vector<DigitalCredentialRequestPtr> digital_credential_requests, GetRequestFormat format, GetCallback callback) final;
  
  void Create(DigitalCredentialRequestPtr digital_credential_request, CreateCallback callback) final;
  
  void Abort() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT DigitalIdentityRequestStubDispatch {
 public:
  static bool Accept(DigitalIdentityRequest* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      DigitalIdentityRequest* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<DigitalIdentityRequest>>
class DigitalIdentityRequestStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DigitalIdentityRequestStub() = default;
  ~DigitalIdentityRequestStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DigitalIdentityRequestStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DigitalIdentityRequestStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT DigitalIdentityRequestRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT DigitalIdentityRequestResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class BLINK_COMMON_EXPORT DigitalCredentialRequest {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DigitalCredentialRequest, T>::value>;
  using DataView = DigitalCredentialRequestDataView;
  using Data_ = internal::DigitalCredentialRequest_Data;

  template <typename... Args>
  static DigitalCredentialRequestPtr New(Args&&... args) {
    return DigitalCredentialRequestPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DigitalCredentialRequestPtr From(const U& u) {
    return mojo::TypeConverter<DigitalCredentialRequestPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DigitalCredentialRequest>::Convert(*this);
  }


  DigitalCredentialRequest();

  DigitalCredentialRequest(
      const std::string& protocol,
      const std::string& data);


  ~DigitalCredentialRequest();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DigitalCredentialRequestPtr>
  DigitalCredentialRequestPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DigitalCredentialRequest::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DigitalCredentialRequest::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DigitalCredentialRequest::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DigitalCredentialRequest::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DigitalCredentialRequest::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DigitalCredentialRequest_UnserializedMessageContext<
            UserType, DigitalCredentialRequest::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DigitalCredentialRequest::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DigitalCredentialRequest::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DigitalCredentialRequest_UnserializedMessageContext<
            UserType, DigitalCredentialRequest::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DigitalCredentialRequest::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string protocol;
  
  std::string data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DigitalCredentialRequest::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DigitalCredentialRequest::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DigitalCredentialRequest::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DigitalCredentialRequest::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}




template <typename StructPtrType>
DigitalCredentialRequestPtr DigitalCredentialRequest::Clone() const {
  return New(
      mojo::Clone(protocol),
      mojo::Clone(data)
  );
}

template <typename T, DigitalCredentialRequest::EnableIfSame<T>*>
bool DigitalCredentialRequest::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->protocol, other_struct.protocol))
    return false;
  if (!mojo::Equals(this->data, other_struct.data))
    return false;
  return true;
}

template <typename T, DigitalCredentialRequest::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.protocol < rhs.protocol)
    return true;
  if (rhs.protocol < lhs.protocol)
    return false;
  if (lhs.data < rhs.data)
    return true;
  if (rhs.data < lhs.data)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::DigitalCredentialRequest::DataView,
                                         ::blink::mojom::DigitalCredentialRequestPtr> {
  static bool IsNull(const ::blink::mojom::DigitalCredentialRequestPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::DigitalCredentialRequestPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::DigitalCredentialRequest::protocol)& protocol(
      const ::blink::mojom::DigitalCredentialRequestPtr& input) {
    return input->protocol;
  }

  static const decltype(::blink::mojom::DigitalCredentialRequest::data)& data(
      const ::blink::mojom::DigitalCredentialRequestPtr& input) {
    return input->data;
  }

  static bool Read(::blink::mojom::DigitalCredentialRequest::DataView input, ::blink::mojom::DigitalCredentialRequestPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBID_DIGITAL_IDENTITY_REQUEST_MOJOM_H_