// third_party/blink/public/mojom/safe_url_pattern.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/safe_url_pattern.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/safe_url_pattern.mojom-params-data.h"
namespace blink {
namespace mojom {

NOINLINE static const char* ModifierToStringHelper(Modifier value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case Modifier::kZeroOrMore:
      return "kZeroOrMore";
    case Modifier::kOptional:
      return "kOptional";
    case Modifier::kOneOrMore:
      return "kOneOrMore";
    case Modifier::kNone:
      return "kNone";
    default:
      return nullptr;
  }
}

std::string ModifierToString(Modifier value) {
  const char *str = ModifierToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown Modifier value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, Modifier value) {
  return os << ModifierToString(value);
}

namespace internal {
// static
bool PatternTemplate_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const PatternTemplate_Data* object = static_cast<const PatternTemplate_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case PatternTemplate_Tag::kFixed: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_fixed, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_fixed, validation_context))
        return false;
      return true;
    }
    case PatternTemplate_Tag::kFullWildcard: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_full_wildcard, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_full_wildcard, validation_context))
        return false;
      return true;
    }
    case PatternTemplate_Tag::kSegmentWildcard: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_segment_wildcard, 3, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_segment_wildcard, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in PatternTemplate");
      return false;
    }
  }
}


// static
bool SafeUrlPattern_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 80, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SafeUrlPattern_Data* object =
      static_cast<const SafeUrlPattern_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->protocol, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& protocol_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->protocol, validation_context,
                                         &protocol_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->username, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& username_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->username, validation_context,
                                         &username_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->password, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& password_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->password, validation_context,
                                         &password_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->hostname, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& hostname_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->hostname, validation_context,
                                         &hostname_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->port, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& port_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->port, validation_context,
                                         &port_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->pathname, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& pathname_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->pathname, validation_context,
                                         &pathname_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->search, 7, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& search_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->search, validation_context,
                                         &search_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->hash, 8, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& hash_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->hash, validation_context,
                                         &hash_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->options, 9, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  return true;
}

SafeUrlPattern_Data::SafeUrlPattern_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FixedPattern_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FixedPattern_Data* object =
      static_cast<const FixedPattern_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& value_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->value, validation_context,
                                         &value_validate_params)) {
    return false;
  }

  return true;
}

FixedPattern_Data::FixedPattern_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool WildcardPattern_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const WildcardPattern_Data* object =
      static_cast<const WildcardPattern_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->prefix, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& prefix_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->prefix, validation_context,
                                         &prefix_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& value_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->value, validation_context,
                                         &value_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->suffix, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& suffix_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->suffix, validation_context,
                                         &suffix_validate_params)) {
    return false;
  }

  return true;
}

WildcardPattern_Data::WildcardPattern_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SafeUrlPatternPart_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SafeUrlPatternPart_Data* object =
      static_cast<const SafeUrlPatternPart_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->pattern, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->pattern, validation_context))
    return false;


  if (!::blink::mojom::internal::Modifier_Data
        ::Validate(object->modifier, validation_context))
    return false;

  return true;
}

SafeUrlPatternPart_Data::SafeUrlPatternPart_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SafeUrlPatternOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SafeUrlPatternOptions_Data* object =
      static_cast<const SafeUrlPatternOptions_Data*>(data);

  return true;
}

SafeUrlPatternOptions_Data::SafeUrlPatternOptions_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::Modifier>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::Modifier value) {
  return std::move(context).WriteString(::blink::mojom::ModifierToString(value));
}

} // namespace perfetto