// third_party/blink/public/mojom/loader/fetch_client_settings_object.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/loader/fetch_client_settings_object.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/loader/fetch_client_settings_object.mojom-params-data.h"
namespace blink {
namespace mojom {

NOINLINE static const char* InsecureRequestsPolicyToStringHelper(InsecureRequestsPolicy value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case InsecureRequestsPolicy::kDoNotUpgrade:
      return "kDoNotUpgrade";
    case InsecureRequestsPolicy::kUpgrade:
      return "kUpgrade";
    default:
      return nullptr;
  }
}

std::string InsecureRequestsPolicyToString(InsecureRequestsPolicy value) {
  const char *str = InsecureRequestsPolicyToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown InsecureRequestsPolicy value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, InsecureRequestsPolicy value) {
  return os << InsecureRequestsPolicyToString(value);
}

namespace internal {


// static
bool FetchClientSettingsObject_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FetchClientSettingsObject_Data* object =
      static_cast<const FetchClientSettingsObject_Data*>(data);


  if (!::network::mojom::internal::ReferrerPolicy_Data
        ::Validate(object->referrer_policy, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->outgoing_referrer, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->outgoing_referrer, validation_context))
    return false;


  if (!::blink::mojom::internal::InsecureRequestsPolicy_Data
        ::Validate(object->insecure_requests_policy, validation_context))
    return false;

  return true;
}

FetchClientSettingsObject_Data::FetchClientSettingsObject_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::InsecureRequestsPolicy>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::InsecureRequestsPolicy value) {
  return std::move(context).WriteString(::blink::mojom::InsecureRequestsPolicyToString(value));
}

} // namespace perfetto