// third_party/blink/public/mojom/ai/ai_rewriter.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/ai/ai_rewriter.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/ai/ai_rewriter.mojom-params-data.h"
namespace blink {
namespace mojom {

NOINLINE static const char* AIRewriterToneToStringHelper(AIRewriterTone value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AIRewriterTone::kAsIs:
      return "kAsIs";
    case AIRewriterTone::kMoreFormal:
      return "kMoreFormal";
    case AIRewriterTone::kMoreCasual:
      return "kMoreCasual";
    default:
      return nullptr;
  }
}

std::string AIRewriterToneToString(AIRewriterTone value) {
  const char *str = AIRewriterToneToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AIRewriterTone value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AIRewriterTone value) {
  return os << AIRewriterToneToString(value);
}

NOINLINE static const char* AIRewriterFormatToStringHelper(AIRewriterFormat value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AIRewriterFormat::kAsIs:
      return "kAsIs";
    case AIRewriterFormat::kPlainText:
      return "kPlainText";
    case AIRewriterFormat::kMarkdown:
      return "kMarkdown";
    default:
      return nullptr;
  }
}

std::string AIRewriterFormatToString(AIRewriterFormat value) {
  const char *str = AIRewriterFormatToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AIRewriterFormat value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AIRewriterFormat value) {
  return os << AIRewriterFormatToString(value);
}

NOINLINE static const char* AIRewriterLengthToStringHelper(AIRewriterLength value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AIRewriterLength::kAsIs:
      return "kAsIs";
    case AIRewriterLength::kShorter:
      return "kShorter";
    case AIRewriterLength::kLonger:
      return "kLonger";
    default:
      return nullptr;
  }
}

std::string AIRewriterLengthToString(AIRewriterLength value) {
  const char *str = AIRewriterLengthToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AIRewriterLength value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AIRewriterLength value) {
  return os << AIRewriterLengthToString(value);
}

namespace internal {


// static
bool AIRewriterCreateOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AIRewriterCreateOptions_Data* object =
      static_cast<const AIRewriterCreateOptions_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& shared_context_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->shared_context, validation_context,
                                         &shared_context_validate_params)) {
    return false;
  }


  if (!::blink::mojom::internal::AIRewriterTone_Data
        ::Validate(object->tone, validation_context))
    return false;


  if (!::blink::mojom::internal::AIRewriterFormat_Data
        ::Validate(object->format, validation_context))
    return false;


  if (!::blink::mojom::internal::AIRewriterLength_Data
        ::Validate(object->length, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->expected_input_languages, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& expected_input_languages_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->expected_input_languages, validation_context,
                                         &expected_input_languages_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->expected_context_languages, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& expected_context_languages_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->expected_context_languages, validation_context,
                                         &expected_context_languages_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->output_language, 7, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& output_language_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->output_language, validation_context,
                                         &output_language_validate_params)) {
    return false;
  }

  return true;
}

AIRewriterCreateOptions_Data::AIRewriterCreateOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AIRewriter_Rewrite_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AIRewriter_Rewrite_Params_Data* object =
      static_cast<const AIRewriter_Rewrite_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& input_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->input, validation_context,
                                         &input_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& context_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->context, validation_context,
                                         &context_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->pending_responder, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->pending_responder,
                                                 validation_context)) {
    return false;
  }

  return true;
}

AIRewriter_Rewrite_Params_Data::AIRewriter_Rewrite_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::AIRewriterTone>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::AIRewriterTone value) {
  return std::move(context).WriteString(::blink::mojom::AIRewriterToneToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::AIRewriterFormat>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::AIRewriterFormat value) {
  return std::move(context).WriteString(::blink::mojom::AIRewriterFormatToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::AIRewriterLength>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::AIRewriterLength value) {
  return std::move(context).WriteString(::blink::mojom::AIRewriterLengthToString(value));
}

} // namespace perfetto