// services/viz/public/mojom/compositing/shared_quad_state.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/viz/public/mojom/compositing/shared_quad_state.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/public/mojom/compositing/shared_quad_state.mojom-params-data.h"
#include "services/viz/public/mojom/compositing/shared_quad_state.mojom-shared-message-ids.h"

#include "services/viz/public/mojom/compositing/shared_quad_state.mojom-import-headers.h"
#include "services/viz/public/mojom/compositing/shared_quad_state.mojom-test-utils.h"


namespace viz::mojom {
SharedQuadState::SharedQuadState()
    : quad_to_target_transform(),
      quad_layer_rect(),
      visible_quad_layer_rect(),
      mask_filter_info(),
      clip_rect(),
      are_contents_opaque(),
      opacity(),
      blend_mode(),
      sorting_context_id(),
      layer_id(),
      is_fast_rounded_corner(),
      offset_tag() {}

SharedQuadState::SharedQuadState(
    const ::gfx::Transform& quad_to_target_transform_in,
    const ::gfx::Rect& quad_layer_rect_in,
    const ::gfx::Rect& visible_quad_layer_rect_in,
    const std::optional<::gfx::MaskFilterInfo>& mask_filter_info_in,
    const std::optional<::gfx::Rect>& clip_rect_in,
    bool are_contents_opaque_in,
    float opacity_in,
    uint32_t blend_mode_in,
    int32_t sorting_context_id_in,
    uint32_t layer_id_in,
    bool is_fast_rounded_corner_in,
    const ::viz::OffsetTag& offset_tag_in)
    : quad_to_target_transform(std::move(quad_to_target_transform_in)),
      quad_layer_rect(std::move(quad_layer_rect_in)),
      visible_quad_layer_rect(std::move(visible_quad_layer_rect_in)),
      mask_filter_info(std::move(mask_filter_info_in)),
      clip_rect(std::move(clip_rect_in)),
      are_contents_opaque(std::move(are_contents_opaque_in)),
      opacity(std::move(opacity_in)),
      blend_mode(std::move(blend_mode_in)),
      sorting_context_id(std::move(sorting_context_id_in)),
      layer_id(std::move(layer_id_in)),
      is_fast_rounded_corner(std::move(is_fast_rounded_corner_in)),
      offset_tag(std::move(offset_tag_in)) {}

SharedQuadState::~SharedQuadState() = default;

void SharedQuadState::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "quad_to_target_transform"), this->quad_to_target_transform,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Transform&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "quad_layer_rect"), this->quad_layer_rect,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Rect&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "visible_quad_layer_rect"), this->visible_quad_layer_rect,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Rect&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mask_filter_info"), this->mask_filter_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::gfx::MaskFilterInfo>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "clip_rect"), this->clip_rect,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::gfx::Rect>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "are_contents_opaque"), this->are_contents_opaque,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "opacity"), this->opacity,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "blend_mode"), this->blend_mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sorting_context_id"), this->sorting_context_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "layer_id"), this->layer_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_fast_rounded_corner"), this->is_fast_rounded_corner,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "offset_tag"), this->offset_tag,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::viz::OffsetTag&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SharedQuadState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // viz::mojom


namespace mojo {


// static
bool StructTraits<::viz::mojom::SharedQuadState::DataView, ::viz::mojom::SharedQuadStatePtr>::Read(
    ::viz::mojom::SharedQuadState::DataView input,
    ::viz::mojom::SharedQuadStatePtr* output) {
  bool success = true;
  ::viz::mojom::SharedQuadStatePtr result(::viz::mojom::SharedQuadState::New());
  
      if (success && !input.ReadQuadToTargetTransform(&result->quad_to_target_transform))
        success = false;
      if (success && !input.ReadQuadLayerRect(&result->quad_layer_rect))
        success = false;
      if (success && !input.ReadVisibleQuadLayerRect(&result->visible_quad_layer_rect))
        success = false;
      if (success && !input.ReadMaskFilterInfo(&result->mask_filter_info))
        success = false;
      if (success && !input.ReadClipRect(&result->clip_rect))
        success = false;
      if (success)
        result->are_contents_opaque = input.are_contents_opaque();
      if (success)
        result->opacity = input.opacity();
      if (success)
        result->blend_mode = input.blend_mode();
      if (success)
        result->sorting_context_id = input.sorting_context_id();
      if (success)
        result->layer_id = input.layer_id();
      if (success)
        result->is_fast_rounded_corner = input.is_fast_rounded_corner();
      if (success && !input.ReadOffsetTag(&result->offset_tag))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace viz::mojom {




}  // viz::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif