// services/viz/public/mojom/compositing/compositor_frame_transition_directive.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_FRAME_TRANSITION_DIRECTIVE_MOJOM_SHARED_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_FRAME_TRANSITION_DIRECTIVE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/compositor_frame_transition_directive.mojom-shared-internal.h"
#include "services/viz/public/mojom/compositing/compositor_render_pass_id.mojom-shared.h"
#include "services/viz/public/mojom/compositing/view_transition_element_resource_id.mojom-shared.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-shared.h"
#include "ui/gfx/mojom/display_color_spaces.mojom-shared.h"







namespace viz::mojom {
class CompositorFrameTransitionDirectiveSharedElementDataView;

class CompositorFrameTransitionDirectiveDataView;



}  // viz::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::viz::mojom::CompositorFrameTransitionDirectiveSharedElementDataView> {
  using Data = ::viz::mojom::internal::CompositorFrameTransitionDirectiveSharedElement_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::CompositorFrameTransitionDirectiveDataView> {
  using Data = ::viz::mojom::internal::CompositorFrameTransitionDirective_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace viz::mojom {


enum class CompositorFrameTransitionDirectiveType : int32_t {
  
  kSave = 0,
  
  kAnimateRenderer = 1,
  
  kRelease = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, CompositorFrameTransitionDirectiveType value);
inline bool IsKnownEnumValue(CompositorFrameTransitionDirectiveType value) {
  return internal::CompositorFrameTransitionDirectiveType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class CompositorFrameTransitionDirectiveSharedElementDataView {
 public:
  CompositorFrameTransitionDirectiveSharedElementDataView() = default;

  CompositorFrameTransitionDirectiveSharedElementDataView(
      internal::CompositorFrameTransitionDirectiveSharedElement_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRenderPassIdDataView(
      ::viz::mojom::CompositorRenderPassIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRenderPassId(UserType* output) {
    
    auto* pointer = data_->render_pass_id.Get();
    return mojo::internal::Deserialize<::viz::mojom::CompositorRenderPassIdDataView>(
        pointer, output, message_);
  }
  inline void GetViewTransitionElementResourceIdDataView(
      ::viz::mojom::ViewTransitionElementResourceIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadViewTransitionElementResourceId(UserType* output) {
    
    auto* pointer = data_->view_transition_element_resource_id.Get();
    return mojo::internal::Deserialize<::viz::mojom::ViewTransitionElementResourceIdDataView>(
        pointer, output, message_);
  }
 private:
  internal::CompositorFrameTransitionDirectiveSharedElement_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CompositorFrameTransitionDirectiveDataView {
 public:
  CompositorFrameTransitionDirectiveDataView() = default;

  CompositorFrameTransitionDirectiveDataView(
      internal::CompositorFrameTransitionDirective_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTransitionTokenDataView(
      ::blink::mojom::ViewTransitionTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTransitionToken(UserType* output) {
    
    auto* pointer = data_->transition_token.Get();
    return mojo::internal::Deserialize<::blink::mojom::ViewTransitionTokenDataView>(
        pointer, output, message_);
  }
  bool maybe_cross_frame_sink() const {
    return data_->maybe_cross_frame_sink;
  }
  uint32_t sequence_id() const {
    return data_->sequence_id;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::viz::mojom::CompositorFrameTransitionDirectiveType>(
        data_value, output);
  }
  CompositorFrameTransitionDirectiveType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::viz::mojom::CompositorFrameTransitionDirectiveType>(data_->type));
  }
  inline void GetSharedElementsDataView(
      mojo::ArrayDataView<CompositorFrameTransitionDirectiveSharedElementDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSharedElements(UserType* output) {
    
    auto* pointer = data_->shared_elements.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::viz::mojom::CompositorFrameTransitionDirectiveSharedElementDataView>>(
        pointer, output, message_);
  }
  inline void GetDisplayColorSpacesDataView(
      ::gfx::mojom::DisplayColorSpacesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDisplayColorSpaces(UserType* output) {
    
    auto* pointer = data_->display_color_spaces.Get();
    return mojo::internal::Deserialize<::gfx::mojom::DisplayColorSpacesDataView>(
        pointer, output, message_);
  }
 private:
  internal::CompositorFrameTransitionDirective_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // viz::mojom

namespace std {

template <>
struct hash<::viz::mojom::CompositorFrameTransitionDirectiveType>
    : public mojo::internal::EnumHashImpl<::viz::mojom::CompositorFrameTransitionDirectiveType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::CompositorFrameTransitionDirectiveType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::viz::mojom::CompositorFrameTransitionDirectiveType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::viz::mojom::CompositorFrameTransitionDirectiveType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::CompositorFrameTransitionDirectiveSharedElementDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::CompositorFrameTransitionDirectiveSharedElementDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::CompositorFrameTransitionDirectiveSharedElement_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::render_pass_id(input)) in_render_pass_id = Traits::render_pass_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->render_pass_id)::BaseType> render_pass_id_fragment(
            fragment.message());
    mojo::internal::Serialize<::viz::mojom::CompositorRenderPassIdDataView>(
        in_render_pass_id, render_pass_id_fragment);
    fragment->render_pass_id.Set(
        render_pass_id_fragment.is_null() ? nullptr : render_pass_id_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->render_pass_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null render_pass_id in CompositorFrameTransitionDirectiveSharedElement struct");
    decltype(Traits::view_transition_element_resource_id(input)) in_view_transition_element_resource_id = Traits::view_transition_element_resource_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->view_transition_element_resource_id)::BaseType> view_transition_element_resource_id_fragment(
            fragment.message());
    mojo::internal::Serialize<::viz::mojom::ViewTransitionElementResourceIdDataView>(
        in_view_transition_element_resource_id, view_transition_element_resource_id_fragment);
    fragment->view_transition_element_resource_id.Set(
        view_transition_element_resource_id_fragment.is_null() ? nullptr : view_transition_element_resource_id_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->view_transition_element_resource_id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null view_transition_element_resource_id in CompositorFrameTransitionDirectiveSharedElement struct");
  }

  static bool Deserialize(::viz::mojom::internal::CompositorFrameTransitionDirectiveSharedElement_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::CompositorFrameTransitionDirectiveSharedElementDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::CompositorFrameTransitionDirectiveDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::CompositorFrameTransitionDirectiveDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::viz::mojom::internal::CompositorFrameTransitionDirective_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::transition_token(input)) in_transition_token = Traits::transition_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->transition_token)::BaseType> transition_token_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::ViewTransitionTokenDataView>(
        in_transition_token, transition_token_fragment);
    fragment->transition_token.Set(
        transition_token_fragment.is_null() ? nullptr : transition_token_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->transition_token.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null transition_token in CompositorFrameTransitionDirective struct");
    fragment->maybe_cross_frame_sink = Traits::maybe_cross_frame_sink(input);
    fragment->sequence_id = Traits::sequence_id(input);
    mojo::internal::Serialize<::viz::mojom::CompositorFrameTransitionDirectiveType>(
        Traits::type(input), &fragment->type);
    decltype(Traits::shared_elements(input)) in_shared_elements = Traits::shared_elements(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->shared_elements)::BaseType>
        shared_elements_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& shared_elements_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::viz::mojom::CompositorFrameTransitionDirectiveSharedElementDataView>>(
        in_shared_elements, shared_elements_fragment, &shared_elements_validate_params);
    fragment->shared_elements.Set(
        shared_elements_fragment.is_null() ? nullptr : shared_elements_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->shared_elements.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null shared_elements in CompositorFrameTransitionDirective struct");
    decltype(Traits::display_color_spaces(input)) in_display_color_spaces = Traits::display_color_spaces(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->display_color_spaces)::BaseType> display_color_spaces_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::DisplayColorSpacesDataView>(
        in_display_color_spaces, display_color_spaces_fragment);
    fragment->display_color_spaces.Set(
        display_color_spaces_fragment.is_null() ? nullptr : display_color_spaces_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->display_color_spaces.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null display_color_spaces in CompositorFrameTransitionDirective struct");
  }

  static bool Deserialize(::viz::mojom::internal::CompositorFrameTransitionDirective_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::CompositorFrameTransitionDirectiveDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace viz::mojom {

inline void CompositorFrameTransitionDirectiveSharedElementDataView::GetRenderPassIdDataView(
    ::viz::mojom::CompositorRenderPassIdDataView* output) {
  auto pointer = data_->render_pass_id.Get();
  *output = ::viz::mojom::CompositorRenderPassIdDataView(pointer, message_);
}
inline void CompositorFrameTransitionDirectiveSharedElementDataView::GetViewTransitionElementResourceIdDataView(
    ::viz::mojom::ViewTransitionElementResourceIdDataView* output) {
  auto pointer = data_->view_transition_element_resource_id.Get();
  *output = ::viz::mojom::ViewTransitionElementResourceIdDataView(pointer, message_);
}


inline void CompositorFrameTransitionDirectiveDataView::GetTransitionTokenDataView(
    ::blink::mojom::ViewTransitionTokenDataView* output) {
  auto pointer = data_->transition_token.Get();
  *output = ::blink::mojom::ViewTransitionTokenDataView(pointer, message_);
}
inline void CompositorFrameTransitionDirectiveDataView::GetSharedElementsDataView(
    mojo::ArrayDataView<CompositorFrameTransitionDirectiveSharedElementDataView>* output) {
  auto pointer = data_->shared_elements.Get();
  *output = mojo::ArrayDataView<CompositorFrameTransitionDirectiveSharedElementDataView>(pointer, message_);
}
inline void CompositorFrameTransitionDirectiveDataView::GetDisplayColorSpacesDataView(
    ::gfx::mojom::DisplayColorSpacesDataView* output) {
  auto pointer = data_->display_color_spaces.Get();
  *output = ::gfx::mojom::DisplayColorSpacesDataView(pointer, message_);
}



}  // viz::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::viz::mojom::CompositorFrameTransitionDirectiveType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::viz::mojom::CompositorFrameTransitionDirectiveType value);
};

} // namespace perfetto

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITOR_FRAME_TRANSITION_DIRECTIVE_MOJOM_SHARED_H_