// services/network/public/mojom/url_request.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_URL_REQUEST_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_URL_REQUEST_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/url_request.mojom-shared-internal.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "services/network/public/mojom/accept_ch_frame_observer.mojom-shared.h"
#include "services/network/public/mojom/attribution.mojom-shared.h"
#include "services/network/public/mojom/chunked_data_pipe_getter.mojom-shared.h"
#include "services/network/public/mojom/client_security_state.mojom-shared.h"
#include "services/network/public/mojom/cookie_access_observer.mojom-shared.h"
#include "services/network/public/mojom/cookie_manager.mojom-shared.h"
#include "services/network/public/mojom/cors.mojom-shared.h"
#include "services/network/public/mojom/data_pipe_getter.mojom-shared.h"
#include "services/network/public/mojom/device_bound_sessions.mojom-shared.h"
#include "services/network/public/mojom/devtools_observer.mojom-shared.h"
#include "services/network/public/mojom/fetch_api.mojom-shared.h"
#include "services/network/public/mojom/http_raw_headers.mojom-shared.h"
#include "services/network/public/mojom/http_request_headers.mojom-shared.h"
#include "services/network/public/mojom/ip_address_space.mojom-shared.h"
#include "services/network/public/mojom/isolation_info.mojom-shared.h"
#include "services/network/public/mojom/network_param.mojom-shared.h"
#include "services/network/public/mojom/referrer_policy.mojom-shared.h"
#include "services/network/public/mojom/request_priority.mojom-shared.h"
#include "services/network/public/mojom/shared_dictionary_access_observer.mojom-shared.h"
#include "services/network/public/mojom/site_for_cookies.mojom-shared.h"
#include "services/network/public/mojom/source_type.mojom-shared.h"
#include "services/network/public/mojom/storage_access_api.mojom-shared.h"
#include "services/network/public/mojom/trust_token_access_observer.mojom-shared.h"
#include "services/network/public/mojom/trust_tokens.mojom-shared.h"
#include "services/network/public/mojom/url_loader_network_service_observer.mojom-shared.h"
#include "services/network/public/mojom/url_response_head.mojom-shared.h"
#include "services/network/public/mojom/web_bundle_handle.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"






namespace network::mojom {
class TrustedUrlRequestParamsDataView;

class WebBundleTokenParamsDataView;

class URLRequestDataView;

class URLRequestBodyDataView;

class DataElementBytesDataView;

class DataElementFileDataView;

class DataElementDataPipeDataView;

class DataElementChunkedDataPipeDataView;

class SocketTagDataView;

class DataElementDataView;


}  // network::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::TrustedUrlRequestParamsDataView> {
  using Data = ::network::mojom::internal::TrustedUrlRequestParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::WebBundleTokenParamsDataView> {
  using Data = ::network::mojom::internal::WebBundleTokenParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::URLRequestDataView> {
  using Data = ::network::mojom::internal::URLRequest_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::URLRequestBodyDataView> {
  using Data = ::network::mojom::internal::URLRequestBody_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::DataElementBytesDataView> {
  using Data = ::network::mojom::internal::DataElementBytes_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::DataElementFileDataView> {
  using Data = ::network::mojom::internal::DataElementFile_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::DataElementDataPipeDataView> {
  using Data = ::network::mojom::internal::DataElementDataPipe_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::DataElementChunkedDataPipeDataView> {
  using Data = ::network::mojom::internal::DataElementChunkedDataPipe_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::SocketTagDataView> {
  using Data = ::network::mojom::internal::SocketTag_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::DataElementDataView> {
  using Data = ::network::mojom::internal::DataElement_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


class TrustedUrlRequestParamsDataView {
 public:
  TrustedUrlRequestParamsDataView() = default;

  TrustedUrlRequestParamsDataView(
      internal::TrustedUrlRequestParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIsolationInfoDataView(
      ::network::mojom::IsolationInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIsolationInfo(UserType* output) {
    
    auto* pointer = data_->isolation_info.Get();
    return mojo::internal::Deserialize<::network::mojom::IsolationInfoDataView>(
        pointer, output, message_);
  }
  bool disable_secure_dns() const {
    return data_->disable_secure_dns;
  }
  bool has_user_activation() const {
    return data_->has_user_activation;
  }
  bool allow_cookies_from_browser() const {
    return data_->allow_cookies_from_browser;
  }
  bool include_request_cookies_with_response() const {
    return data_->include_request_cookies_with_response;
  }
  template <typename UserType>
  UserType TakeCookieObserver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::CookieAccessObserverInterfaceBase>>(
            &data_->cookie_observer, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeTrustTokenObserver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::TrustTokenAccessObserverInterfaceBase>>(
            &data_->trust_token_observer, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeUrlLoaderNetworkObserver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::URLLoaderNetworkServiceObserverInterfaceBase>>(
            &data_->url_loader_network_observer, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeDevtoolsObserver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::DevToolsObserverInterfaceBase>>(
            &data_->devtools_observer, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeDeviceBoundSessionObserver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::DeviceBoundSessionAccessObserverInterfaceBase>>(
            &data_->device_bound_session_observer, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetClientSecurityStateDataView(
      ::network::mojom::ClientSecurityStateDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadClientSecurityState(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::ClientSecurityStateDataView, UserType>(),
    "Attempting to read the optional `client_security_state` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadClientSecurityState` instead "
    "of `ReadClientSecurityState if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->client_security_state.Get();
    return mojo::internal::Deserialize<::network::mojom::ClientSecurityStateDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeAcceptChFrameObserver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::AcceptCHFrameObserverInterfaceBase>>(
            &data_->accept_ch_frame_observer, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeSharedDictionaryObserver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::SharedDictionaryAccessObserverInterfaceBase>>(
            &data_->shared_dictionary_observer, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::TrustedUrlRequestParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebBundleTokenParamsDataView {
 public:
  WebBundleTokenParamsDataView() = default;

  WebBundleTokenParamsDataView(
      internal::WebBundleTokenParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetBundleUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBundleUrl(UserType* output) {
    
    auto* pointer = data_->bundle_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadToken(UserType* output) {
    
    auto* pointer = data_->token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeWebBundleHandle() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::WebBundleHandleInterfaceBase>>(
            &data_->web_bundle_handle, &result, message_);
    DCHECK(ret);
    return result;
  }
  int32_t render_process_id() const {
    return data_->render_process_id;
  }
 private:
  internal::WebBundleTokenParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class URLRequestDataView {
 public:
  URLRequestDataView() = default;

  URLRequestDataView(
      internal::URLRequest_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMethodDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMethod(UserType* output) {
    
    auto* pointer = data_->method.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetSiteForCookiesDataView(
      ::network::mojom::SiteForCookiesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSiteForCookies(UserType* output) {
    
    auto* pointer = data_->site_for_cookies.Get();
    return mojo::internal::Deserialize<::network::mojom::SiteForCookiesDataView>(
        pointer, output, message_);
  }
  bool update_first_party_url_on_redirect() const {
    return data_->update_first_party_url_on_redirect;
  }
  inline void GetRequestInitiatorDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequestInitiator(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::OriginDataView, UserType>(),
    "Attempting to read the optional `request_initiator` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRequestInitiator` instead "
    "of `ReadRequestInitiator if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->request_initiator.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetNavigationRedirectChainDataView(
      mojo::ArrayDataView<::url::mojom::UrlDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNavigationRedirectChain(UserType* output) {
    
    auto* pointer = data_->navigation_redirect_chain.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
        pointer, output, message_);
  }
  inline void GetIsolatedWorldOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIsolatedWorldOrigin(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::OriginDataView, UserType>(),
    "Attempting to read the optional `isolated_world_origin` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadIsolatedWorldOrigin` instead "
    "of `ReadIsolatedWorldOrigin if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->isolated_world_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetReferrerDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReferrer(UserType* output) {
    
    auto* pointer = data_->referrer.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadReferrerPolicy(UserType* output) const {
    auto data_value = data_->referrer_policy;
    return mojo::internal::Deserialize<::network::mojom::URLRequestReferrerPolicy>(
        data_value, output);
  }
  ::network::mojom::URLRequestReferrerPolicy referrer_policy() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::URLRequestReferrerPolicy>(data_->referrer_policy));
  }
  inline void GetHeadersDataView(
      ::network::mojom::HttpRequestHeadersDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHeaders(UserType* output) {
    
    auto* pointer = data_->headers.Get();
    return mojo::internal::Deserialize<::network::mojom::HttpRequestHeadersDataView>(
        pointer, output, message_);
  }
  inline void GetCorsExemptHeadersDataView(
      ::network::mojom::HttpRequestHeadersDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCorsExemptHeaders(UserType* output) {
    
    auto* pointer = data_->cors_exempt_headers.Get();
    return mojo::internal::Deserialize<::network::mojom::HttpRequestHeadersDataView>(
        pointer, output, message_);
  }
  int32_t load_flags() const {
    return data_->load_flags;
  }
  int32_t resource_type() const {
    return data_->resource_type;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPriority(UserType* output) const {
    auto data_value = data_->priority;
    return mojo::internal::Deserialize<::network::mojom::RequestPriority>(
        data_value, output);
  }
  ::network::mojom::RequestPriority priority() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::RequestPriority>(data_->priority));
  }
  bool priority_incremental() const {
    return data_->priority_incremental;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadCorsPreflightPolicy(UserType* output) const {
    auto data_value = data_->cors_preflight_policy;
    return mojo::internal::Deserialize<::network::mojom::CorsPreflightPolicy>(
        data_value, output);
  }
  ::network::mojom::CorsPreflightPolicy cors_preflight_policy() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::CorsPreflightPolicy>(data_->cors_preflight_policy));
  }
  bool originated_from_service_worker() const {
    return data_->originated_from_service_worker;
  }
  bool skip_service_worker() const {
    return data_->skip_service_worker;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadMode(UserType* output) const {
    auto data_value = data_->mode;
    return mojo::internal::Deserialize<::network::mojom::RequestMode>(
        data_value, output);
  }
  ::network::mojom::RequestMode mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::RequestMode>(data_->mode));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadCredentialsMode(UserType* output) const {
    auto data_value = data_->credentials_mode;
    return mojo::internal::Deserialize<::network::mojom::CredentialsMode>(
        data_value, output);
  }
  ::network::mojom::CredentialsMode credentials_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::CredentialsMode>(data_->credentials_mode));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadRedirectMode(UserType* output) const {
    auto data_value = data_->redirect_mode;
    return mojo::internal::Deserialize<::network::mojom::RedirectMode>(
        data_value, output);
  }
  ::network::mojom::RedirectMode redirect_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::RedirectMode>(data_->redirect_mode));
  }
  inline void GetFetchIntegrityDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFetchIntegrity(UserType* output) {
    
    auto* pointer = data_->fetch_integrity.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetExpectedSignaturesDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExpectedSignatures(UserType* output) {
    
    auto* pointer = data_->expected_signatures.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadDestination(UserType* output) const {
    auto data_value = data_->destination;
    return mojo::internal::Deserialize<::network::mojom::RequestDestination>(
        data_value, output);
  }
  ::network::mojom::RequestDestination destination() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::RequestDestination>(data_->destination));
  }
  inline void GetRequestBodyDataView(
      URLRequestBodyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequestBody(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::URLRequestBodyDataView, UserType>(),
    "Attempting to read the optional `request_body` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRequestBody` instead "
    "of `ReadRequestBody if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->request_body.Get();
    return mojo::internal::Deserialize<::network::mojom::URLRequestBodyDataView>(
        pointer, output, message_);
  }
  bool keepalive() const {
    return data_->keepalive;
  }
  bool browsing_topics() const {
    return data_->browsing_topics;
  }
  bool ad_auction_headers() const {
    return data_->ad_auction_headers;
  }
  bool shared_storage_writable_eligible() const {
    return data_->shared_storage_writable_eligible;
  }
  bool has_user_gesture() const {
    return data_->has_user_gesture;
  }
  bool enable_load_timing() const {
    return data_->enable_load_timing;
  }
  bool enable_upload_progress() const {
    return data_->enable_upload_progress;
  }
  bool do_not_prompt_for_login() const {
    return data_->do_not_prompt_for_login;
  }
  bool is_outermost_main_frame() const {
    return data_->is_outermost_main_frame;
  }
  int32_t transition_type() const {
    return data_->transition_type;
  }
  int32_t previews_state() const {
    return data_->previews_state;
  }
  bool upgrade_if_insecure() const {
    return data_->upgrade_if_insecure;
  }
  bool is_revalidating() const {
    return data_->is_revalidating;
  }
  inline void GetThrottlingProfileIdDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadThrottlingProfileId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnguessableTokenDataView, UserType>(),
    "Attempting to read the optional `throttling_profile_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadThrottlingProfileId` instead "
    "of `ReadThrottlingProfileId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->throttling_profile_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  inline void GetFetchWindowIdDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFetchWindowId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnguessableTokenDataView, UserType>(),
    "Attempting to read the optional `fetch_window_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFetchWindowId` instead "
    "of `ReadFetchWindowId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->fetch_window_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  inline void GetDevtoolsRequestIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDevtoolsRequestId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `devtools_request_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDevtoolsRequestId` instead "
    "of `ReadDevtoolsRequestId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->devtools_request_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDevtoolsStackIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDevtoolsStackId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `devtools_stack_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDevtoolsStackId` instead "
    "of `ReadDevtoolsStackId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->devtools_stack_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool is_fetch_like_api() const {
    return data_->is_fetch_like_api;
  }
  bool is_fetch_later_api() const {
    return data_->is_fetch_later_api;
  }
  bool is_favicon() const {
    return data_->is_favicon;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadOriginalDestination(UserType* output) const {
    auto data_value = data_->original_destination;
    return mojo::internal::Deserialize<::network::mojom::RequestDestination>(
        data_value, output);
  }
  ::network::mojom::RequestDestination original_destination() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::RequestDestination>(data_->original_destination));
  }
  inline void GetTrustedParamsDataView(
      TrustedUrlRequestParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTrustedParams(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::TrustedUrlRequestParamsDataView, UserType>(),
    "Attempting to read the optional `trusted_params` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTrustedParams` instead "
    "of `ReadTrustedParams if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->trusted_params.Get();
    return mojo::internal::Deserialize<::network::mojom::TrustedUrlRequestParamsDataView>(
        pointer, output, message_);
  }
  inline void GetRecursivePrefetchTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRecursivePrefetchToken(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnguessableTokenDataView, UserType>(),
    "Attempting to read the optional `recursive_prefetch_token` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRecursivePrefetchToken` instead "
    "of `ReadRecursivePrefetchToken if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->recursive_prefetch_token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  inline void GetTrustTokenParamsDataView(
      ::network::mojom::TrustTokenParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTrustTokenParams(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::TrustTokenParamsDataView, UserType>(),
    "Attempting to read the optional `trust_token_params` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTrustTokenParams` instead "
    "of `ReadTrustTokenParams if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->trust_token_params.Get();
    return mojo::internal::Deserialize<::network::mojom::TrustTokenParamsDataView>(
        pointer, output, message_);
  }
  inline void GetWebBundleTokenParamsDataView(
      WebBundleTokenParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWebBundleTokenParams(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::WebBundleTokenParamsDataView, UserType>(),
    "Attempting to read the optional `web_bundle_token_params` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadWebBundleTokenParams` instead "
    "of `ReadWebBundleTokenParams if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->web_bundle_token_params.Get();
    return mojo::internal::Deserialize<::network::mojom::WebBundleTokenParamsDataView>(
        pointer, output, message_);
  }
  inline void GetDevtoolsAcceptedStreamTypesDataView(
      mojo::ArrayDataView<::network::mojom::SourceType>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDevtoolsAcceptedStreamTypes(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::network::mojom::SourceType>, UserType>(),
    "Attempting to read the optional `devtools_accepted_stream_types` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDevtoolsAcceptedStreamTypes` instead "
    "of `ReadDevtoolsAcceptedStreamTypes if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->devtools_accepted_stream_types.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::SourceType>>(
        pointer, output, message_);
  }
  inline void GetNetLogCreateInfoDataView(
      ::network::mojom::NetLogSourceDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNetLogCreateInfo(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::NetLogSourceDataView, UserType>(),
    "Attempting to read the optional `net_log_create_info` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadNetLogCreateInfo` instead "
    "of `ReadNetLogCreateInfo if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->net_log_create_info.Get();
    return mojo::internal::Deserialize<::network::mojom::NetLogSourceDataView>(
        pointer, output, message_);
  }
  inline void GetNetLogReferenceInfoDataView(
      ::network::mojom::NetLogSourceDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNetLogReferenceInfo(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::NetLogSourceDataView, UserType>(),
    "Attempting to read the optional `net_log_reference_info` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadNetLogReferenceInfo` instead "
    "of `ReadNetLogReferenceInfo if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->net_log_reference_info.Get();
    return mojo::internal::Deserialize<::network::mojom::NetLogSourceDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadTargetIpAddressSpace(UserType* output) const {
    auto data_value = data_->target_ip_address_space;
    return mojo::internal::Deserialize<::network::mojom::IPAddressSpace>(
        data_value, output);
  }
  ::network::mojom::IPAddressSpace target_ip_address_space() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::IPAddressSpace>(data_->target_ip_address_space));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadRequiredIpAddressSpace(UserType* output) const {
    auto data_value = data_->required_ip_address_space;
    return mojo::internal::Deserialize<::network::mojom::IPAddressSpace>(
        data_value, output);
  }
  ::network::mojom::IPAddressSpace required_ip_address_space() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::IPAddressSpace>(data_->required_ip_address_space));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadStorageAccessApiStatus(UserType* output) const {
    auto data_value = data_->storage_access_api_status;
    return mojo::internal::Deserialize<::network::mojom::StorageAccessApiStatus>(
        data_value, output);
  }
  ::network::mojom::StorageAccessApiStatus storage_access_api_status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::StorageAccessApiStatus>(data_->storage_access_api_status));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAttributionReportingSupport(UserType* output) const {
    auto data_value = data_->attribution_reporting_support;
    return mojo::internal::Deserialize<::network::mojom::AttributionSupport>(
        data_value, output);
  }
  ::network::mojom::AttributionSupport attribution_reporting_support() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::AttributionSupport>(data_->attribution_reporting_support));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAttributionReportingEligibility(UserType* output) const {
    auto data_value = data_->attribution_reporting_eligibility;
    return mojo::internal::Deserialize<::network::mojom::AttributionReportingEligibility>(
        data_value, output);
  }
  ::network::mojom::AttributionReportingEligibility attribution_reporting_eligibility() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::AttributionReportingEligibility>(data_->attribution_reporting_eligibility));
  }
  inline void GetAttributionReportingSrcTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAttributionReportingSrcToken(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnguessableTokenDataView, UserType>(),
    "Attempting to read the optional `attribution_reporting_src_token` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAttributionReportingSrcToken` instead "
    "of `ReadAttributionReportingSrcToken if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->attribution_reporting_src_token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  inline void GetKeepaliveTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadKeepaliveToken(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnguessableTokenDataView, UserType>(),
    "Attempting to read the optional `keepalive_token` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadKeepaliveToken` instead "
    "of `ReadKeepaliveToken if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->keepalive_token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  bool is_ad_tagged() const {
    return data_->is_ad_tagged;
  }
  bool shared_dictionary_writer_enabled() const {
    return data_->shared_dictionary_writer_enabled;
  }
  inline void GetSocketTagDataView(
      SocketTagDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSocketTag(UserType* output) {
    
    auto* pointer = data_->socket_tag.Get();
    return mojo::internal::Deserialize<::network::mojom::SocketTagDataView>(
        pointer, output, message_);
  }
 private:
  internal::URLRequest_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class URLRequestBodyDataView {
 public:
  URLRequestBodyDataView() = default;

  URLRequestBodyDataView(
      internal::URLRequestBody_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetElementsDataView(
      mojo::ArrayDataView<DataElementDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadElements(UserType* output) {
    
    auto* pointer = data_->elements.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::DataElementDataView>>(
        pointer, output, message_);
  }
  uint64_t identifier() const {
    return data_->identifier;
  }
  bool contains_sensitive_info() const {
    return data_->contains_sensitive_info;
  }
  bool allow_http1_for_streaming_upload() const {
    return data_->allow_http1_for_streaming_upload;
  }
 private:
  internal::URLRequestBody_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DataElementBytesDataView {
 public:
  DataElementBytesDataView() = default;

  DataElementBytesDataView(
      internal::DataElementBytes_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDataDataView(
      ::mojo_base::mojom::BigBufferDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
    auto* pointer = !data_->data.is_null() ? &data_->data : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::BigBufferDataView>(
        pointer, output, message_);
  }
 private:
  internal::DataElementBytes_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DataElementFileDataView {
 public:
  DataElementFileDataView() = default;

  DataElementFileDataView(
      internal::DataElementFile_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPathDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, message_);
  }
  uint64_t offset() const {
    return data_->offset;
  }
  uint64_t length() const {
    return data_->length;
  }
  inline void GetExpectedModificationTimeDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExpectedModificationTime(UserType* output) {
    
    auto* pointer = data_->expected_modification_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
 private:
  internal::DataElementFile_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DataElementDataPipeDataView {
 public:
  DataElementDataPipeDataView() = default;

  DataElementDataPipeDataView(
      internal::DataElementDataPipe_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeDataPipeGetter() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::DataPipeGetterInterfaceBase>>(
            &data_->data_pipe_getter, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::DataElementDataPipe_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DataElementChunkedDataPipeDataView {
 public:
  DataElementChunkedDataPipeDataView() = default;

  DataElementChunkedDataPipeDataView(
      internal::DataElementChunkedDataPipe_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeDataPipeGetter() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::ChunkedDataPipeGetterInterfaceBase>>(
            &data_->data_pipe_getter, &result, message_);
    DCHECK(ret);
    return result;
  }
  bool read_only_once() const {
    return data_->read_only_once;
  }
 private:
  internal::DataElementChunkedDataPipe_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SocketTagDataView {
 public:
  SocketTagDataView() = default;

  SocketTagDataView(
      internal::SocketTag_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::SocketTag_Data* data_ = nullptr;
};


class DataElementDataView {
 public:
  using Tag = internal::DataElement_Data::DataElement_Tag;

  DataElementDataView() = default;

  DataElementDataView(
      internal::DataElement_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_bytes() const { return data_->tag == Tag::kBytes; }
  inline void GetBytesDataView(
      DataElementBytesDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadBytes(UserType* output) const {
    
    CHECK(is_bytes());
    return mojo::internal::Deserialize<::network::mojom::DataElementBytesDataView>(
        data_->data.f_bytes.Get(), output, message_);
  }
  bool is_file() const { return data_->tag == Tag::kFile; }
  inline void GetFileDataView(
      DataElementFileDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadFile(UserType* output) const {
    
    CHECK(is_file());
    return mojo::internal::Deserialize<::network::mojom::DataElementFileDataView>(
        data_->data.f_file.Get(), output, message_);
  }
  bool is_data_pipe() const { return data_->tag == Tag::kDataPipe; }
  inline void GetDataPipeDataView(
      DataElementDataPipeDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadDataPipe(UserType* output) const {
    
    CHECK(is_data_pipe());
    return mojo::internal::Deserialize<::network::mojom::DataElementDataPipeDataView>(
        data_->data.f_data_pipe.Get(), output, message_);
  }
  bool is_chunked_data_pipe() const { return data_->tag == Tag::kChunkedDataPipe; }
  inline void GetChunkedDataPipeDataView(
      DataElementChunkedDataPipeDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadChunkedDataPipe(UserType* output) const {
    
    CHECK(is_chunked_data_pipe());
    return mojo::internal::Deserialize<::network::mojom::DataElementChunkedDataPipeDataView>(
        data_->data.f_chunked_data_pipe.Get(), output, message_);
  }

 private:
  internal::DataElement_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // network::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::TrustedUrlRequestParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::TrustedUrlRequestParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::TrustedUrlRequestParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::isolation_info(input)) in_isolation_info = Traits::isolation_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->isolation_info)::BaseType> isolation_info_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::IsolationInfoDataView>(
        in_isolation_info, isolation_info_fragment);
    fragment->isolation_info.Set(
        isolation_info_fragment.is_null() ? nullptr : isolation_info_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->isolation_info.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null isolation_info in TrustedUrlRequestParams struct");
    fragment->disable_secure_dns = Traits::disable_secure_dns(input);
    fragment->has_user_activation = Traits::has_user_activation(input);
    fragment->allow_cookies_from_browser = Traits::allow_cookies_from_browser(input);
    fragment->include_request_cookies_with_response = Traits::include_request_cookies_with_response(input);
    decltype(Traits::cookie_observer(input)) in_cookie_observer = Traits::cookie_observer(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::CookieAccessObserverInterfaceBase>>(
        in_cookie_observer, &fragment->cookie_observer, &fragment.message());
    decltype(Traits::trust_token_observer(input)) in_trust_token_observer = Traits::trust_token_observer(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::TrustTokenAccessObserverInterfaceBase>>(
        in_trust_token_observer, &fragment->trust_token_observer, &fragment.message());
    decltype(Traits::url_loader_network_observer(input)) in_url_loader_network_observer = Traits::url_loader_network_observer(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::URLLoaderNetworkServiceObserverInterfaceBase>>(
        in_url_loader_network_observer, &fragment->url_loader_network_observer, &fragment.message());
    decltype(Traits::devtools_observer(input)) in_devtools_observer = Traits::devtools_observer(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::DevToolsObserverInterfaceBase>>(
        in_devtools_observer, &fragment->devtools_observer, &fragment.message());
    decltype(Traits::device_bound_session_observer(input)) in_device_bound_session_observer = Traits::device_bound_session_observer(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::DeviceBoundSessionAccessObserverInterfaceBase>>(
        in_device_bound_session_observer, &fragment->device_bound_session_observer, &fragment.message());
    decltype(Traits::client_security_state(input)) in_client_security_state = Traits::client_security_state(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->client_security_state)::BaseType> client_security_state_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::ClientSecurityStateDataView>(
        in_client_security_state, client_security_state_fragment);
    fragment->client_security_state.Set(
        client_security_state_fragment.is_null() ? nullptr : client_security_state_fragment.data());
    decltype(Traits::accept_ch_frame_observer(input)) in_accept_ch_frame_observer = Traits::accept_ch_frame_observer(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::AcceptCHFrameObserverInterfaceBase>>(
        in_accept_ch_frame_observer, &fragment->accept_ch_frame_observer, &fragment.message());
    decltype(Traits::shared_dictionary_observer(input)) in_shared_dictionary_observer = Traits::shared_dictionary_observer(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::SharedDictionaryAccessObserverInterfaceBase>>(
        in_shared_dictionary_observer, &fragment->shared_dictionary_observer, &fragment.message());
  }

  static bool Deserialize(::network::mojom::internal::TrustedUrlRequestParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::TrustedUrlRequestParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::WebBundleTokenParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::WebBundleTokenParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::WebBundleTokenParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::bundle_url(input)) in_bundle_url = Traits::bundle_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->bundle_url)::BaseType> bundle_url_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_bundle_url, bundle_url_fragment);
    fragment->bundle_url.Set(
        bundle_url_fragment.is_null() ? nullptr : bundle_url_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->bundle_url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null bundle_url in WebBundleTokenParams struct");
    decltype(Traits::token(input)) in_token = Traits::token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->token)::BaseType> token_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
        in_token, token_fragment);
    fragment->token.Set(
        token_fragment.is_null() ? nullptr : token_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->token.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null token in WebBundleTokenParams struct");
    decltype(Traits::web_bundle_handle(input)) in_web_bundle_handle = Traits::web_bundle_handle(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::WebBundleHandleInterfaceBase>>(
        in_web_bundle_handle, &fragment->web_bundle_handle, &fragment.message());
    fragment->render_process_id = Traits::render_process_id(input);
  }

  static bool Deserialize(::network::mojom::internal::WebBundleTokenParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::WebBundleTokenParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::URLRequestDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::URLRequestDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::URLRequest_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::method(input)) in_method = Traits::method(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->method)::BaseType> method_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_method, method_fragment);
    fragment->method.Set(
        method_fragment.is_null() ? nullptr : method_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->method.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null method in URLRequest struct");
    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_url, url_fragment);
    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in URLRequest struct");
    decltype(Traits::site_for_cookies(input)) in_site_for_cookies = Traits::site_for_cookies(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->site_for_cookies)::BaseType> site_for_cookies_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::SiteForCookiesDataView>(
        in_site_for_cookies, site_for_cookies_fragment);
    fragment->site_for_cookies.Set(
        site_for_cookies_fragment.is_null() ? nullptr : site_for_cookies_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->site_for_cookies.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null site_for_cookies in URLRequest struct");
    fragment->update_first_party_url_on_redirect = Traits::update_first_party_url_on_redirect(input);
    decltype(Traits::request_initiator(input)) in_request_initiator = Traits::request_initiator(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->request_initiator)::BaseType> request_initiator_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
        in_request_initiator, request_initiator_fragment);
    fragment->request_initiator.Set(
        request_initiator_fragment.is_null() ? nullptr : request_initiator_fragment.data());
    decltype(Traits::navigation_redirect_chain(input)) in_navigation_redirect_chain = Traits::navigation_redirect_chain(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->navigation_redirect_chain)::BaseType>
        navigation_redirect_chain_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& navigation_redirect_chain_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
        in_navigation_redirect_chain, navigation_redirect_chain_fragment, &navigation_redirect_chain_validate_params);
    fragment->navigation_redirect_chain.Set(
        navigation_redirect_chain_fragment.is_null() ? nullptr : navigation_redirect_chain_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->navigation_redirect_chain.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null navigation_redirect_chain in URLRequest struct");
    decltype(Traits::isolated_world_origin(input)) in_isolated_world_origin = Traits::isolated_world_origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->isolated_world_origin)::BaseType> isolated_world_origin_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
        in_isolated_world_origin, isolated_world_origin_fragment);
    fragment->isolated_world_origin.Set(
        isolated_world_origin_fragment.is_null() ? nullptr : isolated_world_origin_fragment.data());
    decltype(Traits::referrer(input)) in_referrer = Traits::referrer(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->referrer)::BaseType> referrer_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_referrer, referrer_fragment);
    fragment->referrer.Set(
        referrer_fragment.is_null() ? nullptr : referrer_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->referrer.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null referrer in URLRequest struct");
    mojo::internal::Serialize<::network::mojom::URLRequestReferrerPolicy>(
        Traits::referrer_policy(input), &fragment->referrer_policy);
    decltype(Traits::headers(input)) in_headers = Traits::headers(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->headers)::BaseType> headers_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::HttpRequestHeadersDataView>(
        in_headers, headers_fragment);
    fragment->headers.Set(
        headers_fragment.is_null() ? nullptr : headers_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->headers.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null headers in URLRequest struct");
    decltype(Traits::cors_exempt_headers(input)) in_cors_exempt_headers = Traits::cors_exempt_headers(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->cors_exempt_headers)::BaseType> cors_exempt_headers_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::HttpRequestHeadersDataView>(
        in_cors_exempt_headers, cors_exempt_headers_fragment);
    fragment->cors_exempt_headers.Set(
        cors_exempt_headers_fragment.is_null() ? nullptr : cors_exempt_headers_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->cors_exempt_headers.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null cors_exempt_headers in URLRequest struct");
    fragment->load_flags = Traits::load_flags(input);
    fragment->resource_type = Traits::resource_type(input);
    mojo::internal::Serialize<::network::mojom::RequestPriority>(
        Traits::priority(input), &fragment->priority);
    fragment->priority_incremental = Traits::priority_incremental(input);
    mojo::internal::Serialize<::network::mojom::CorsPreflightPolicy>(
        Traits::cors_preflight_policy(input), &fragment->cors_preflight_policy);
    fragment->originated_from_service_worker = Traits::originated_from_service_worker(input);
    fragment->skip_service_worker = Traits::skip_service_worker(input);
    mojo::internal::Serialize<::network::mojom::RequestMode>(
        Traits::mode(input), &fragment->mode);
    mojo::internal::Serialize<::network::mojom::CredentialsMode>(
        Traits::credentials_mode(input), &fragment->credentials_mode);
    mojo::internal::Serialize<::network::mojom::RedirectMode>(
        Traits::redirect_mode(input), &fragment->redirect_mode);
    decltype(Traits::fetch_integrity(input)) in_fetch_integrity = Traits::fetch_integrity(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->fetch_integrity)::BaseType> fetch_integrity_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_fetch_integrity, fetch_integrity_fragment);
    fragment->fetch_integrity.Set(
        fetch_integrity_fragment.is_null() ? nullptr : fetch_integrity_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->fetch_integrity.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null fetch_integrity in URLRequest struct");
    decltype(Traits::expected_signatures(input)) in_expected_signatures = Traits::expected_signatures(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->expected_signatures)::BaseType>
        expected_signatures_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& expected_signatures_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
        in_expected_signatures, expected_signatures_fragment, &expected_signatures_validate_params);
    fragment->expected_signatures.Set(
        expected_signatures_fragment.is_null() ? nullptr : expected_signatures_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->expected_signatures.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null expected_signatures in URLRequest struct");
    mojo::internal::Serialize<::network::mojom::RequestDestination>(
        Traits::destination(input), &fragment->destination);
    decltype(Traits::request_body(input)) in_request_body = Traits::request_body(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->request_body)::BaseType> request_body_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::URLRequestBodyDataView>(
        in_request_body, request_body_fragment);
    fragment->request_body.Set(
        request_body_fragment.is_null() ? nullptr : request_body_fragment.data());
    fragment->keepalive = Traits::keepalive(input);
    fragment->browsing_topics = Traits::browsing_topics(input);
    fragment->ad_auction_headers = Traits::ad_auction_headers(input);
    fragment->shared_storage_writable_eligible = Traits::shared_storage_writable_eligible(input);
    fragment->has_user_gesture = Traits::has_user_gesture(input);
    fragment->enable_load_timing = Traits::enable_load_timing(input);
    fragment->enable_upload_progress = Traits::enable_upload_progress(input);
    fragment->do_not_prompt_for_login = Traits::do_not_prompt_for_login(input);
    fragment->is_outermost_main_frame = Traits::is_outermost_main_frame(input);
    fragment->transition_type = Traits::transition_type(input);
    fragment->previews_state = Traits::previews_state(input);
    fragment->upgrade_if_insecure = Traits::upgrade_if_insecure(input);
    fragment->is_revalidating = Traits::is_revalidating(input);
    decltype(Traits::throttling_profile_id(input)) in_throttling_profile_id = Traits::throttling_profile_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->throttling_profile_id)::BaseType> throttling_profile_id_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
        in_throttling_profile_id, throttling_profile_id_fragment);
    fragment->throttling_profile_id.Set(
        throttling_profile_id_fragment.is_null() ? nullptr : throttling_profile_id_fragment.data());
    decltype(Traits::fetch_window_id(input)) in_fetch_window_id = Traits::fetch_window_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->fetch_window_id)::BaseType> fetch_window_id_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
        in_fetch_window_id, fetch_window_id_fragment);
    fragment->fetch_window_id.Set(
        fetch_window_id_fragment.is_null() ? nullptr : fetch_window_id_fragment.data());
    decltype(Traits::devtools_request_id(input)) in_devtools_request_id = Traits::devtools_request_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->devtools_request_id)::BaseType> devtools_request_id_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_devtools_request_id, devtools_request_id_fragment);
    fragment->devtools_request_id.Set(
        devtools_request_id_fragment.is_null() ? nullptr : devtools_request_id_fragment.data());
    decltype(Traits::devtools_stack_id(input)) in_devtools_stack_id = Traits::devtools_stack_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->devtools_stack_id)::BaseType> devtools_stack_id_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_devtools_stack_id, devtools_stack_id_fragment);
    fragment->devtools_stack_id.Set(
        devtools_stack_id_fragment.is_null() ? nullptr : devtools_stack_id_fragment.data());
    fragment->is_fetch_like_api = Traits::is_fetch_like_api(input);
    fragment->is_fetch_later_api = Traits::is_fetch_later_api(input);
    fragment->is_favicon = Traits::is_favicon(input);
    mojo::internal::Serialize<::network::mojom::RequestDestination>(
        Traits::original_destination(input), &fragment->original_destination);
    decltype(Traits::trusted_params(input)) in_trusted_params = Traits::trusted_params(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->trusted_params)::BaseType> trusted_params_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::TrustedUrlRequestParamsDataView>(
        in_trusted_params, trusted_params_fragment);
    fragment->trusted_params.Set(
        trusted_params_fragment.is_null() ? nullptr : trusted_params_fragment.data());
    decltype(Traits::recursive_prefetch_token(input)) in_recursive_prefetch_token = Traits::recursive_prefetch_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->recursive_prefetch_token)::BaseType> recursive_prefetch_token_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
        in_recursive_prefetch_token, recursive_prefetch_token_fragment);
    fragment->recursive_prefetch_token.Set(
        recursive_prefetch_token_fragment.is_null() ? nullptr : recursive_prefetch_token_fragment.data());
    decltype(Traits::trust_token_params(input)) in_trust_token_params = Traits::trust_token_params(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->trust_token_params)::BaseType> trust_token_params_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::TrustTokenParamsDataView>(
        in_trust_token_params, trust_token_params_fragment);
    fragment->trust_token_params.Set(
        trust_token_params_fragment.is_null() ? nullptr : trust_token_params_fragment.data());
    decltype(Traits::web_bundle_token_params(input)) in_web_bundle_token_params = Traits::web_bundle_token_params(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->web_bundle_token_params)::BaseType> web_bundle_token_params_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::WebBundleTokenParamsDataView>(
        in_web_bundle_token_params, web_bundle_token_params_fragment);
    fragment->web_bundle_token_params.Set(
        web_bundle_token_params_fragment.is_null() ? nullptr : web_bundle_token_params_fragment.data());
    decltype(Traits::devtools_accepted_stream_types(input)) in_devtools_accepted_stream_types = Traits::devtools_accepted_stream_types(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->devtools_accepted_stream_types)::BaseType>
        devtools_accepted_stream_types_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& devtools_accepted_stream_types_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::network::mojom::internal::SourceType_Data::Validate>();
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::SourceType>>(
        in_devtools_accepted_stream_types, devtools_accepted_stream_types_fragment, &devtools_accepted_stream_types_validate_params);
    fragment->devtools_accepted_stream_types.Set(
        devtools_accepted_stream_types_fragment.is_null() ? nullptr : devtools_accepted_stream_types_fragment.data());
    decltype(Traits::net_log_create_info(input)) in_net_log_create_info = Traits::net_log_create_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->net_log_create_info)::BaseType> net_log_create_info_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::NetLogSourceDataView>(
        in_net_log_create_info, net_log_create_info_fragment);
    fragment->net_log_create_info.Set(
        net_log_create_info_fragment.is_null() ? nullptr : net_log_create_info_fragment.data());
    decltype(Traits::net_log_reference_info(input)) in_net_log_reference_info = Traits::net_log_reference_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->net_log_reference_info)::BaseType> net_log_reference_info_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::NetLogSourceDataView>(
        in_net_log_reference_info, net_log_reference_info_fragment);
    fragment->net_log_reference_info.Set(
        net_log_reference_info_fragment.is_null() ? nullptr : net_log_reference_info_fragment.data());
    mojo::internal::Serialize<::network::mojom::IPAddressSpace>(
        Traits::target_ip_address_space(input), &fragment->target_ip_address_space);
    mojo::internal::Serialize<::network::mojom::IPAddressSpace>(
        Traits::required_ip_address_space(input), &fragment->required_ip_address_space);
    mojo::internal::Serialize<::network::mojom::StorageAccessApiStatus>(
        Traits::storage_access_api_status(input), &fragment->storage_access_api_status);
    mojo::internal::Serialize<::network::mojom::AttributionSupport>(
        Traits::attribution_reporting_support(input), &fragment->attribution_reporting_support);
    mojo::internal::Serialize<::network::mojom::AttributionReportingEligibility>(
        Traits::attribution_reporting_eligibility(input), &fragment->attribution_reporting_eligibility);
    decltype(Traits::attribution_reporting_src_token(input)) in_attribution_reporting_src_token = Traits::attribution_reporting_src_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->attribution_reporting_src_token)::BaseType> attribution_reporting_src_token_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
        in_attribution_reporting_src_token, attribution_reporting_src_token_fragment);
    fragment->attribution_reporting_src_token.Set(
        attribution_reporting_src_token_fragment.is_null() ? nullptr : attribution_reporting_src_token_fragment.data());
    decltype(Traits::keepalive_token(input)) in_keepalive_token = Traits::keepalive_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->keepalive_token)::BaseType> keepalive_token_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
        in_keepalive_token, keepalive_token_fragment);
    fragment->keepalive_token.Set(
        keepalive_token_fragment.is_null() ? nullptr : keepalive_token_fragment.data());
    fragment->is_ad_tagged = Traits::is_ad_tagged(input);
    fragment->shared_dictionary_writer_enabled = Traits::shared_dictionary_writer_enabled(input);
    decltype(Traits::socket_tag(input)) in_socket_tag = Traits::socket_tag(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->socket_tag)::BaseType> socket_tag_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::SocketTagDataView>(
        in_socket_tag, socket_tag_fragment);
    fragment->socket_tag.Set(
        socket_tag_fragment.is_null() ? nullptr : socket_tag_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->socket_tag.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null socket_tag in URLRequest struct");
  }

  static bool Deserialize(::network::mojom::internal::URLRequest_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::URLRequestDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::URLRequestBodyDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::URLRequestBodyDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::URLRequestBody_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::elements(input)) in_elements = Traits::elements(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->elements)::BaseType>
        elements_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& elements_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::DataElementDataView>>(
        in_elements, elements_fragment, &elements_validate_params);
    fragment->elements.Set(
        elements_fragment.is_null() ? nullptr : elements_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->elements.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null elements in URLRequestBody struct");
    fragment->identifier = Traits::identifier(input);
    fragment->contains_sensitive_info = Traits::contains_sensitive_info(input);
    fragment->allow_http1_for_streaming_upload = Traits::allow_http1_for_streaming_upload(input);
  }

  static bool Deserialize(::network::mojom::internal::URLRequestBody_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::URLRequestBodyDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::DataElementBytesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::DataElementBytesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::DataElementBytes_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::data(input)) in_data = Traits::data(input);
    mojo::internal::MessageFragment<decltype(fragment->data)>
        data_fragment(fragment.message());
    data_fragment.Claim(&fragment->data);
    mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
        in_data, data_fragment, true);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->data.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null data in DataElementBytes struct");
  }

  static bool Deserialize(::network::mojom::internal::DataElementBytes_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::DataElementBytesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::DataElementFileDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::DataElementFileDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::DataElementFile_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::path(input)) in_path = Traits::path(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->path)::BaseType> path_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
        in_path, path_fragment);
    fragment->path.Set(
        path_fragment.is_null() ? nullptr : path_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->path.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null path in DataElementFile struct");
    fragment->offset = Traits::offset(input);
    fragment->length = Traits::length(input);
    decltype(Traits::expected_modification_time(input)) in_expected_modification_time = Traits::expected_modification_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->expected_modification_time)::BaseType> expected_modification_time_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
        in_expected_modification_time, expected_modification_time_fragment);
    fragment->expected_modification_time.Set(
        expected_modification_time_fragment.is_null() ? nullptr : expected_modification_time_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->expected_modification_time.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null expected_modification_time in DataElementFile struct");
  }

  static bool Deserialize(::network::mojom::internal::DataElementFile_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::DataElementFileDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::DataElementDataPipeDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::DataElementDataPipeDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::DataElementDataPipe_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::data_pipe_getter(input)) in_data_pipe_getter = Traits::data_pipe_getter(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::DataPipeGetterInterfaceBase>>(
        in_data_pipe_getter, &fragment->data_pipe_getter, &fragment.message());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid(fragment->data_pipe_getter),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid data_pipe_getter in DataElementDataPipe struct");
  }

  static bool Deserialize(::network::mojom::internal::DataElementDataPipe_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::DataElementDataPipeDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::DataElementChunkedDataPipeDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::DataElementChunkedDataPipeDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::DataElementChunkedDataPipe_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::data_pipe_getter(input)) in_data_pipe_getter = Traits::data_pipe_getter(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::ChunkedDataPipeGetterInterfaceBase>>(
        in_data_pipe_getter, &fragment->data_pipe_getter, &fragment.message());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid(fragment->data_pipe_getter),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid data_pipe_getter in DataElementChunkedDataPipe struct");
    fragment->read_only_once = Traits::read_only_once(input);
  }

  static bool Deserialize(::network::mojom::internal::DataElementChunkedDataPipe_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::DataElementChunkedDataPipeDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::SocketTagDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::SocketTagDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::SocketTag_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
  }

  static bool Deserialize(::network::mojom::internal::SocketTag_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::SocketTagDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::DataElementDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::network::mojom::DataElementDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::network::mojom::internal::DataElement_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::network::mojom::DataElementDataView::Tag::kBytes: {
        decltype(Traits::bytes(input))
            in_bytes = Traits::bytes(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_bytes)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::network::mojom::DataElementBytesDataView>(
            in_bytes, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null bytes in DataElement union");
        fragment->data.f_bytes.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::network::mojom::DataElementDataView::Tag::kFile: {
        decltype(Traits::file(input))
            in_file = Traits::file(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_file)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::network::mojom::DataElementFileDataView>(
            in_file, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null file in DataElement union");
        fragment->data.f_file.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::network::mojom::DataElementDataView::Tag::kDataPipe: {
        decltype(Traits::data_pipe(input))
            in_data_pipe = Traits::data_pipe(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_data_pipe)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::network::mojom::DataElementDataPipeDataView>(
            in_data_pipe, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null data_pipe in DataElement union");
        fragment->data.f_data_pipe.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::network::mojom::DataElementDataView::Tag::kChunkedDataPipe: {
        decltype(Traits::chunked_data_pipe(input))
            in_chunked_data_pipe = Traits::chunked_data_pipe(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_chunked_data_pipe)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::network::mojom::DataElementChunkedDataPipeDataView>(
            in_chunked_data_pipe, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null chunked_data_pipe in DataElement union");
        fragment->data.f_chunked_data_pipe.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
    }
  }

  static bool Deserialize(::network::mojom::internal::DataElement_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::DataElementDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void TrustedUrlRequestParamsDataView::GetIsolationInfoDataView(
    ::network::mojom::IsolationInfoDataView* output) {
  auto pointer = data_->isolation_info.Get();
  *output = ::network::mojom::IsolationInfoDataView(pointer, message_);
}
inline void TrustedUrlRequestParamsDataView::GetClientSecurityStateDataView(
    ::network::mojom::ClientSecurityStateDataView* output) {
  auto pointer = data_->client_security_state.Get();
  *output = ::network::mojom::ClientSecurityStateDataView(pointer, message_);
}


inline void WebBundleTokenParamsDataView::GetBundleUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->bundle_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void WebBundleTokenParamsDataView::GetTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->token.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}


inline void URLRequestDataView::GetMethodDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->method.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void URLRequestDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void URLRequestDataView::GetSiteForCookiesDataView(
    ::network::mojom::SiteForCookiesDataView* output) {
  auto pointer = data_->site_for_cookies.Get();
  *output = ::network::mojom::SiteForCookiesDataView(pointer, message_);
}
inline void URLRequestDataView::GetRequestInitiatorDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->request_initiator.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void URLRequestDataView::GetNavigationRedirectChainDataView(
    mojo::ArrayDataView<::url::mojom::UrlDataView>* output) {
  auto pointer = data_->navigation_redirect_chain.Get();
  *output = mojo::ArrayDataView<::url::mojom::UrlDataView>(pointer, message_);
}
inline void URLRequestDataView::GetIsolatedWorldOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->isolated_world_origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void URLRequestDataView::GetReferrerDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->referrer.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void URLRequestDataView::GetHeadersDataView(
    ::network::mojom::HttpRequestHeadersDataView* output) {
  auto pointer = data_->headers.Get();
  *output = ::network::mojom::HttpRequestHeadersDataView(pointer, message_);
}
inline void URLRequestDataView::GetCorsExemptHeadersDataView(
    ::network::mojom::HttpRequestHeadersDataView* output) {
  auto pointer = data_->cors_exempt_headers.Get();
  *output = ::network::mojom::HttpRequestHeadersDataView(pointer, message_);
}
inline void URLRequestDataView::GetFetchIntegrityDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->fetch_integrity.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void URLRequestDataView::GetExpectedSignaturesDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->expected_signatures.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}
inline void URLRequestDataView::GetRequestBodyDataView(
    URLRequestBodyDataView* output) {
  auto pointer = data_->request_body.Get();
  *output = URLRequestBodyDataView(pointer, message_);
}
inline void URLRequestDataView::GetThrottlingProfileIdDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->throttling_profile_id.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}
inline void URLRequestDataView::GetFetchWindowIdDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->fetch_window_id.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}
inline void URLRequestDataView::GetDevtoolsRequestIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->devtools_request_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void URLRequestDataView::GetDevtoolsStackIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->devtools_stack_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void URLRequestDataView::GetTrustedParamsDataView(
    TrustedUrlRequestParamsDataView* output) {
  auto pointer = data_->trusted_params.Get();
  *output = TrustedUrlRequestParamsDataView(pointer, message_);
}
inline void URLRequestDataView::GetRecursivePrefetchTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->recursive_prefetch_token.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}
inline void URLRequestDataView::GetTrustTokenParamsDataView(
    ::network::mojom::TrustTokenParamsDataView* output) {
  auto pointer = data_->trust_token_params.Get();
  *output = ::network::mojom::TrustTokenParamsDataView(pointer, message_);
}
inline void URLRequestDataView::GetWebBundleTokenParamsDataView(
    WebBundleTokenParamsDataView* output) {
  auto pointer = data_->web_bundle_token_params.Get();
  *output = WebBundleTokenParamsDataView(pointer, message_);
}
inline void URLRequestDataView::GetDevtoolsAcceptedStreamTypesDataView(
    mojo::ArrayDataView<::network::mojom::SourceType>* output) {
  auto pointer = data_->devtools_accepted_stream_types.Get();
  *output = mojo::ArrayDataView<::network::mojom::SourceType>(pointer, message_);
}
inline void URLRequestDataView::GetNetLogCreateInfoDataView(
    ::network::mojom::NetLogSourceDataView* output) {
  auto pointer = data_->net_log_create_info.Get();
  *output = ::network::mojom::NetLogSourceDataView(pointer, message_);
}
inline void URLRequestDataView::GetNetLogReferenceInfoDataView(
    ::network::mojom::NetLogSourceDataView* output) {
  auto pointer = data_->net_log_reference_info.Get();
  *output = ::network::mojom::NetLogSourceDataView(pointer, message_);
}
inline void URLRequestDataView::GetAttributionReportingSrcTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->attribution_reporting_src_token.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}
inline void URLRequestDataView::GetKeepaliveTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->keepalive_token.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}
inline void URLRequestDataView::GetSocketTagDataView(
    SocketTagDataView* output) {
  auto pointer = data_->socket_tag.Get();
  *output = SocketTagDataView(pointer, message_);
}


inline void URLRequestBodyDataView::GetElementsDataView(
    mojo::ArrayDataView<DataElementDataView>* output) {
  auto pointer = data_->elements.Get();
  *output = mojo::ArrayDataView<DataElementDataView>(pointer, message_);
}


inline void DataElementBytesDataView::GetDataDataView(
    ::mojo_base::mojom::BigBufferDataView* output) {
  auto pointer = &data_->data;
  *output = ::mojo_base::mojom::BigBufferDataView(pointer, message_);
}


inline void DataElementFileDataView::GetPathDataView(
    ::mojo_base::mojom::FilePathDataView* output) {
  auto pointer = data_->path.Get();
  *output = ::mojo_base::mojom::FilePathDataView(pointer, message_);
}
inline void DataElementFileDataView::GetExpectedModificationTimeDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->expected_modification_time.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}








inline void DataElementDataView::GetBytesDataView(
    DataElementBytesDataView* output) const {
  CHECK(is_bytes());
  *output = DataElementBytesDataView(data_->data.f_bytes.Get(), message_);
}
inline void DataElementDataView::GetFileDataView(
    DataElementFileDataView* output) const {
  CHECK(is_file());
  *output = DataElementFileDataView(data_->data.f_file.Get(), message_);
}
inline void DataElementDataView::GetDataPipeDataView(
    DataElementDataPipeDataView* output) const {
  CHECK(is_data_pipe());
  *output = DataElementDataPipeDataView(data_->data.f_data_pipe.Get(), message_);
}
inline void DataElementDataView::GetChunkedDataPipeDataView(
    DataElementChunkedDataPipeDataView* output) const {
  CHECK(is_chunked_data_pipe());
  *output = DataElementChunkedDataPipeDataView(data_->data.f_chunked_data_pipe.Get(), message_);
}


}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_URL_REQUEST_MOJOM_SHARED_H_