// services/network/public/mojom/sri_message_signature.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_SRI_MESSAGE_SIGNATURE_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_SRI_MESSAGE_SIGNATURE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/sri_message_signature.mojom-shared-internal.h"







namespace network::mojom {
class SRIMessageSignatureComponentDataView;

class SRIMessageSignatureDataView;

class SRIMessageSignaturesDataView;



}  // network::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::SRIMessageSignatureComponentDataView> {
  using Data = ::network::mojom::internal::SRIMessageSignatureComponent_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::SRIMessageSignatureDataView> {
  using Data = ::network::mojom::internal::SRIMessageSignature_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::SRIMessageSignaturesDataView> {
  using Data = ::network::mojom::internal::SRIMessageSignatures_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


enum class SRIMessageSignatureError : int32_t {
  
  kMissingSignatureHeader = 0,
  
  kMissingSignatureInputHeader = 1,
  
  kInvalidSignatureHeader = 2,
  
  kInvalidSignatureInputHeader = 3,
  
  kSignatureHeaderValueIsNotByteSequence = 4,
  
  kSignatureHeaderValueIsParameterized = 5,
  
  kSignatureHeaderValueIsIncorrectLength = 6,
  
  kSignatureInputHeaderMissingLabel = 7,
  
  kSignatureInputHeaderValueNotInnerList = 8,
  
  kSignatureInputHeaderValueMissingComponents = 9,
  
  kSignatureInputHeaderInvalidComponentType = 10,
  
  kSignatureInputHeaderInvalidComponentName = 11,
  
  kSignatureInputHeaderInvalidHeaderComponentParameter = 12,
  
  kSignatureInputHeaderInvalidDerivedComponentParameter = 13,
  
  kSignatureInputHeaderKeyIdLength = 14,
  
  kSignatureInputHeaderInvalidParameter = 15,
  
  kSignatureInputHeaderMissingRequiredParameters = 16,
  
  kValidationFailedSignatureExpired = 17,
  
  kValidationFailedInvalidLength = 18,
  
  kValidationFailedSignatureMismatch = 19,
  kMinValue = 0,
  kMaxValue = 19,
};

 std::ostream& operator<<(std::ostream& os, SRIMessageSignatureError value);
inline bool IsKnownEnumValue(SRIMessageSignatureError value) {
  return internal::SRIMessageSignatureError_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SRIMessageSignatureComponent_Parameter : int32_t {
  
  kRequest = 0,
  
  kStrictStructuredFieldSerialization = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, SRIMessageSignatureComponent_Parameter value);
inline bool IsKnownEnumValue(SRIMessageSignatureComponent_Parameter value) {
  return internal::SRIMessageSignatureComponent_Parameter_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class SRIMessageSignatureComponentDataView {
 public:
  SRIMessageSignatureComponentDataView() = default;

  SRIMessageSignatureComponentDataView(
      internal::SRIMessageSignatureComponent_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetParamsDataView(
      mojo::ArrayDataView<SRIMessageSignatureComponent_Parameter>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParams(UserType* output) {
    
    auto* pointer = data_->params.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::SRIMessageSignatureComponent_Parameter>>(
        pointer, output, message_);
  }
 private:
  internal::SRIMessageSignatureComponent_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SRIMessageSignatureDataView {
 public:
  SRIMessageSignatureDataView() = default;

  SRIMessageSignatureDataView(
      internal::SRIMessageSignature_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSignatureDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSignature(UserType* output) {
    
    auto* pointer = data_->signature.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  inline void GetComponentsDataView(
      mojo::ArrayDataView<SRIMessageSignatureComponentDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadComponents(UserType* output) {
    
    auto* pointer = data_->components.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::SRIMessageSignatureComponentDataView>>(
        pointer, output, message_);
  }
  std::optional<int64_t> created() const {

    return data_->created_$flag
        ? std::make_optional(data_->created_$value)
        : std::nullopt;
  }
  std::optional<int64_t> expires() const {

    return data_->expires_$flag
        ? std::make_optional(data_->expires_$value)
        : std::nullopt;
  }
  inline void GetKeyidDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadKeyid(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `keyid` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadKeyid` instead "
    "of `ReadKeyid if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->keyid.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetNonceDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNonce(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `nonce` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadNonce` instead "
    "of `ReadNonce if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->nonce.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetTagDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTag(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `tag` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTag` instead "
    "of `ReadTag if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->tag.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSerializedSignatureParamsDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSerializedSignatureParams(UserType* output) {
    
    auto* pointer = data_->serialized_signature_params.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::SRIMessageSignature_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SRIMessageSignaturesDataView {
 public:
  SRIMessageSignaturesDataView() = default;

  SRIMessageSignaturesDataView(
      internal::SRIMessageSignatures_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSignaturesDataView(
      mojo::ArrayDataView<SRIMessageSignatureDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSignatures(UserType* output) {
    
    auto* pointer = data_->signatures.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::SRIMessageSignatureDataView>>(
        pointer, output, message_);
  }
  inline void GetErrorsDataView(
      mojo::ArrayDataView<SRIMessageSignatureError>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadErrors(UserType* output) {
    
    auto* pointer = data_->errors.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::SRIMessageSignatureError>>(
        pointer, output, message_);
  }
 private:
  internal::SRIMessageSignatures_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // network::mojom

namespace std {

template <>
struct hash<::network::mojom::SRIMessageSignatureError>
    : public mojo::internal::EnumHashImpl<::network::mojom::SRIMessageSignatureError> {};

template <>
struct hash<::network::mojom::SRIMessageSignatureComponent_Parameter>
    : public mojo::internal::EnumHashImpl<::network::mojom::SRIMessageSignatureComponent_Parameter> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::SRIMessageSignatureError, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::SRIMessageSignatureError, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::SRIMessageSignatureError>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::SRIMessageSignatureComponent_Parameter, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::SRIMessageSignatureComponent_Parameter, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::SRIMessageSignatureComponent_Parameter>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::SRIMessageSignatureComponentDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::SRIMessageSignatureComponentDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::SRIMessageSignatureComponent_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_name, name_fragment);
    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->name.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in SRIMessageSignatureComponent struct");
    decltype(Traits::params(input)) in_params = Traits::params(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->params)::BaseType>
        params_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& params_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::network::mojom::internal::SRIMessageSignatureComponent_Parameter_Data::Validate>();
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::SRIMessageSignatureComponent_Parameter>>(
        in_params, params_fragment, &params_validate_params);
    fragment->params.Set(
        params_fragment.is_null() ? nullptr : params_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->params.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null params in SRIMessageSignatureComponent struct");
  }

  static bool Deserialize(::network::mojom::internal::SRIMessageSignatureComponent_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::SRIMessageSignatureComponentDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::SRIMessageSignatureDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::SRIMessageSignatureDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::SRIMessageSignature_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_label, label_fragment);
    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->label.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null label in SRIMessageSignature struct");
    decltype(Traits::signature(input)) in_signature = Traits::signature(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->signature)::BaseType>
        signature_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& signature_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
        in_signature, signature_fragment, &signature_validate_params);
    fragment->signature.Set(
        signature_fragment.is_null() ? nullptr : signature_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->signature.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null signature in SRIMessageSignature struct");
    decltype(Traits::components(input)) in_components = Traits::components(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->components)::BaseType>
        components_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& components_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::SRIMessageSignatureComponentDataView>>(
        in_components, components_fragment, &components_validate_params);
    fragment->components.Set(
        components_fragment.is_null() ? nullptr : components_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->components.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null components in SRIMessageSignature struct");
    fragment->created_$flag = Traits::created(input).has_value();
    if (Traits::created(input).has_value()) {
      fragment->created_$value = Traits::created(input).value();
    }
    fragment->expires_$flag = Traits::expires(input).has_value();
    if (Traits::expires(input).has_value()) {
      fragment->expires_$value = Traits::expires(input).value();
    }
    decltype(Traits::keyid(input)) in_keyid = Traits::keyid(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->keyid)::BaseType> keyid_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_keyid, keyid_fragment);
    fragment->keyid.Set(
        keyid_fragment.is_null() ? nullptr : keyid_fragment.data());
    decltype(Traits::nonce(input)) in_nonce = Traits::nonce(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->nonce)::BaseType> nonce_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_nonce, nonce_fragment);
    fragment->nonce.Set(
        nonce_fragment.is_null() ? nullptr : nonce_fragment.data());
    decltype(Traits::tag(input)) in_tag = Traits::tag(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->tag)::BaseType> tag_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_tag, tag_fragment);
    fragment->tag.Set(
        tag_fragment.is_null() ? nullptr : tag_fragment.data());
    decltype(Traits::serialized_signature_params(input)) in_serialized_signature_params = Traits::serialized_signature_params(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->serialized_signature_params)::BaseType> serialized_signature_params_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_serialized_signature_params, serialized_signature_params_fragment);
    fragment->serialized_signature_params.Set(
        serialized_signature_params_fragment.is_null() ? nullptr : serialized_signature_params_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->serialized_signature_params.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null serialized_signature_params in SRIMessageSignature struct");
  }

  static bool Deserialize(::network::mojom::internal::SRIMessageSignature_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::SRIMessageSignatureDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::SRIMessageSignaturesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::SRIMessageSignaturesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::SRIMessageSignatures_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::signatures(input)) in_signatures = Traits::signatures(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->signatures)::BaseType>
        signatures_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& signatures_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::SRIMessageSignatureDataView>>(
        in_signatures, signatures_fragment, &signatures_validate_params);
    fragment->signatures.Set(
        signatures_fragment.is_null() ? nullptr : signatures_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->signatures.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null signatures in SRIMessageSignatures struct");
    decltype(Traits::errors(input)) in_errors = Traits::errors(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->errors)::BaseType>
        errors_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& errors_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::network::mojom::internal::SRIMessageSignatureError_Data::Validate>();
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::SRIMessageSignatureError>>(
        in_errors, errors_fragment, &errors_validate_params);
    fragment->errors.Set(
        errors_fragment.is_null() ? nullptr : errors_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->errors.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null errors in SRIMessageSignatures struct");
  }

  static bool Deserialize(::network::mojom::internal::SRIMessageSignatures_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::SRIMessageSignaturesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void SRIMessageSignatureComponentDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SRIMessageSignatureComponentDataView::GetParamsDataView(
    mojo::ArrayDataView<SRIMessageSignatureComponent_Parameter>* output) {
  auto pointer = data_->params.Get();
  *output = mojo::ArrayDataView<SRIMessageSignatureComponent_Parameter>(pointer, message_);
}


inline void SRIMessageSignatureDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SRIMessageSignatureDataView::GetSignatureDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->signature.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void SRIMessageSignatureDataView::GetComponentsDataView(
    mojo::ArrayDataView<SRIMessageSignatureComponentDataView>* output) {
  auto pointer = data_->components.Get();
  *output = mojo::ArrayDataView<SRIMessageSignatureComponentDataView>(pointer, message_);
}
inline void SRIMessageSignatureDataView::GetKeyidDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->keyid.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SRIMessageSignatureDataView::GetNonceDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->nonce.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SRIMessageSignatureDataView::GetTagDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->tag.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SRIMessageSignatureDataView::GetSerializedSignatureParamsDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->serialized_signature_params.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void SRIMessageSignaturesDataView::GetSignaturesDataView(
    mojo::ArrayDataView<SRIMessageSignatureDataView>* output) {
  auto pointer = data_->signatures.Get();
  *output = mojo::ArrayDataView<SRIMessageSignatureDataView>(pointer, message_);
}
inline void SRIMessageSignaturesDataView::GetErrorsDataView(
    mojo::ArrayDataView<SRIMessageSignatureError>* output) {
  auto pointer = data_->errors.Get();
  *output = mojo::ArrayDataView<SRIMessageSignatureError>(pointer, message_);
}



}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::SRIMessageSignatureError> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::SRIMessageSignatureError value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::SRIMessageSignatureComponent_Parameter> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::SRIMessageSignatureComponent_Parameter value);
};

} // namespace perfetto

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_SRI_MESSAGE_SIGNATURE_MOJOM_SHARED_H_