// services/network/public/mojom/shared_storage.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_SHARED_STORAGE_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_SHARED_STORAGE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/shared_storage.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"







namespace network::mojom {
class SharedStorageKeyArgumentDataView;

class SharedStorageValueArgumentDataView;

class LockNameDataView;

class SharedStorageSetMethodDataView;

class SharedStorageAppendMethodDataView;

class SharedStorageDeleteMethodDataView;

class SharedStorageClearMethodDataView;

class SharedStorageModifierMethodWithOptionsDataView;

class SharedStorageModifierMethodDataView;


}  // network::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::SharedStorageKeyArgumentDataView> {
  using Data = ::network::mojom::internal::SharedStorageKeyArgument_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::SharedStorageValueArgumentDataView> {
  using Data = ::network::mojom::internal::SharedStorageValueArgument_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::LockNameDataView> {
  using Data = ::network::mojom::internal::LockName_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::SharedStorageSetMethodDataView> {
  using Data = ::network::mojom::internal::SharedStorageSetMethod_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::SharedStorageAppendMethodDataView> {
  using Data = ::network::mojom::internal::SharedStorageAppendMethod_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::SharedStorageDeleteMethodDataView> {
  using Data = ::network::mojom::internal::SharedStorageDeleteMethod_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::SharedStorageClearMethodDataView> {
  using Data = ::network::mojom::internal::SharedStorageClearMethod_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::SharedStorageModifierMethodWithOptionsDataView> {
  using Data = ::network::mojom::internal::SharedStorageModifierMethodWithOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::SharedStorageModifierMethodDataView> {
  using Data = ::network::mojom::internal::SharedStorageModifierMethod_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


class SharedStorageKeyArgumentDataView {
 public:
  SharedStorageKeyArgumentDataView() = default;

  SharedStorageKeyArgumentDataView(
      internal::SharedStorageKeyArgument_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDataDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
    auto* pointer = data_->data.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
 private:
  internal::SharedStorageKeyArgument_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SharedStorageValueArgumentDataView {
 public:
  SharedStorageValueArgumentDataView() = default;

  SharedStorageValueArgumentDataView(
      internal::SharedStorageValueArgument_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDataDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
    auto* pointer = data_->data.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
 private:
  internal::SharedStorageValueArgument_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class LockNameDataView {
 public:
  LockNameDataView() = default;

  LockNameDataView(
      internal::LockName_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDataDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
    auto* pointer = data_->data.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::LockName_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SharedStorageSetMethodDataView {
 public:
  SharedStorageSetMethodDataView() = default;

  SharedStorageSetMethodDataView(
      internal::SharedStorageSetMethod_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetKeyDataView(
      SharedStorageKeyArgumentDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadKey(UserType* output) {
    
    auto* pointer = data_->key.Get();
    return mojo::internal::Deserialize<::network::mojom::SharedStorageKeyArgumentDataView>(
        pointer, output, message_);
  }
  inline void GetValueDataView(
      SharedStorageValueArgumentDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) {
    
    auto* pointer = data_->value.Get();
    return mojo::internal::Deserialize<::network::mojom::SharedStorageValueArgumentDataView>(
        pointer, output, message_);
  }
  bool ignore_if_present() const {
    return data_->ignore_if_present;
  }
 private:
  internal::SharedStorageSetMethod_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SharedStorageAppendMethodDataView {
 public:
  SharedStorageAppendMethodDataView() = default;

  SharedStorageAppendMethodDataView(
      internal::SharedStorageAppendMethod_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetKeyDataView(
      SharedStorageKeyArgumentDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadKey(UserType* output) {
    
    auto* pointer = data_->key.Get();
    return mojo::internal::Deserialize<::network::mojom::SharedStorageKeyArgumentDataView>(
        pointer, output, message_);
  }
  inline void GetValueDataView(
      SharedStorageValueArgumentDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) {
    
    auto* pointer = data_->value.Get();
    return mojo::internal::Deserialize<::network::mojom::SharedStorageValueArgumentDataView>(
        pointer, output, message_);
  }
 private:
  internal::SharedStorageAppendMethod_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SharedStorageDeleteMethodDataView {
 public:
  SharedStorageDeleteMethodDataView() = default;

  SharedStorageDeleteMethodDataView(
      internal::SharedStorageDeleteMethod_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetKeyDataView(
      SharedStorageKeyArgumentDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadKey(UserType* output) {
    
    auto* pointer = data_->key.Get();
    return mojo::internal::Deserialize<::network::mojom::SharedStorageKeyArgumentDataView>(
        pointer, output, message_);
  }
 private:
  internal::SharedStorageDeleteMethod_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SharedStorageClearMethodDataView {
 public:
  SharedStorageClearMethodDataView() = default;

  SharedStorageClearMethodDataView(
      internal::SharedStorageClearMethod_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::SharedStorageClearMethod_Data* data_ = nullptr;
};


class SharedStorageModifierMethodWithOptionsDataView {
 public:
  SharedStorageModifierMethodWithOptionsDataView() = default;

  SharedStorageModifierMethodWithOptionsDataView(
      internal::SharedStorageModifierMethodWithOptions_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMethodDataView(
      SharedStorageModifierMethodDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMethod(UserType* output) {
    
    auto* pointer = !data_->method.is_null() ? &data_->method : nullptr;
    return mojo::internal::Deserialize<::network::mojom::SharedStorageModifierMethodDataView>(
        pointer, output, message_);
  }
  inline void GetWithLockDataView(
      LockNameDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWithLock(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::LockNameDataView, UserType>(),
    "Attempting to read the optional `with_lock` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadWithLock` instead "
    "of `ReadWithLock if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->with_lock.Get();
    return mojo::internal::Deserialize<::network::mojom::LockNameDataView>(
        pointer, output, message_);
  }
 private:
  internal::SharedStorageModifierMethodWithOptions_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SharedStorageModifierMethodDataView {
 public:
  using Tag = internal::SharedStorageModifierMethod_Data::SharedStorageModifierMethod_Tag;

  SharedStorageModifierMethodDataView() = default;

  SharedStorageModifierMethodDataView(
      internal::SharedStorageModifierMethod_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_set_method() const { return data_->tag == Tag::kSetMethod; }
  inline void GetSetMethodDataView(
      SharedStorageSetMethodDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSetMethod(UserType* output) const {
    
    CHECK(is_set_method());
    return mojo::internal::Deserialize<::network::mojom::SharedStorageSetMethodDataView>(
        data_->data.f_set_method.Get(), output, message_);
  }
  bool is_append_method() const { return data_->tag == Tag::kAppendMethod; }
  inline void GetAppendMethodDataView(
      SharedStorageAppendMethodDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadAppendMethod(UserType* output) const {
    
    CHECK(is_append_method());
    return mojo::internal::Deserialize<::network::mojom::SharedStorageAppendMethodDataView>(
        data_->data.f_append_method.Get(), output, message_);
  }
  bool is_delete_method() const { return data_->tag == Tag::kDeleteMethod; }
  inline void GetDeleteMethodDataView(
      SharedStorageDeleteMethodDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadDeleteMethod(UserType* output) const {
    
    CHECK(is_delete_method());
    return mojo::internal::Deserialize<::network::mojom::SharedStorageDeleteMethodDataView>(
        data_->data.f_delete_method.Get(), output, message_);
  }
  bool is_clear_method() const { return data_->tag == Tag::kClearMethod; }
  inline void GetClearMethodDataView(
      SharedStorageClearMethodDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadClearMethod(UserType* output) const {
    
    CHECK(is_clear_method());
    return mojo::internal::Deserialize<::network::mojom::SharedStorageClearMethodDataView>(
        data_->data.f_clear_method.Get(), output, message_);
  }

 private:
  internal::SharedStorageModifierMethod_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // network::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::SharedStorageKeyArgumentDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::SharedStorageKeyArgumentDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::SharedStorageKeyArgument_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::data(input)) in_data = Traits::data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->data)::BaseType> data_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_data, data_fragment);
    fragment->data.Set(
        data_fragment.is_null() ? nullptr : data_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->data.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null data in SharedStorageKeyArgument struct");
  }

  static bool Deserialize(::network::mojom::internal::SharedStorageKeyArgument_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::SharedStorageKeyArgumentDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::SharedStorageValueArgumentDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::SharedStorageValueArgumentDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::SharedStorageValueArgument_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::data(input)) in_data = Traits::data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->data)::BaseType> data_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_data, data_fragment);
    fragment->data.Set(
        data_fragment.is_null() ? nullptr : data_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->data.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null data in SharedStorageValueArgument struct");
  }

  static bool Deserialize(::network::mojom::internal::SharedStorageValueArgument_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::SharedStorageValueArgumentDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::LockNameDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::LockNameDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::LockName_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::data(input)) in_data = Traits::data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->data)::BaseType> data_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_data, data_fragment);
    fragment->data.Set(
        data_fragment.is_null() ? nullptr : data_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->data.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null data in LockName struct");
  }

  static bool Deserialize(::network::mojom::internal::LockName_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::LockNameDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::SharedStorageSetMethodDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::SharedStorageSetMethodDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::SharedStorageSetMethod_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::key(input)) in_key = Traits::key(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->key)::BaseType> key_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::SharedStorageKeyArgumentDataView>(
        in_key, key_fragment);
    fragment->key.Set(
        key_fragment.is_null() ? nullptr : key_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->key.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null key in SharedStorageSetMethod struct");
    decltype(Traits::value(input)) in_value = Traits::value(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->value)::BaseType> value_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::SharedStorageValueArgumentDataView>(
        in_value, value_fragment);
    fragment->value.Set(
        value_fragment.is_null() ? nullptr : value_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->value.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null value in SharedStorageSetMethod struct");
    fragment->ignore_if_present = Traits::ignore_if_present(input);
  }

  static bool Deserialize(::network::mojom::internal::SharedStorageSetMethod_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::SharedStorageSetMethodDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::SharedStorageAppendMethodDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::SharedStorageAppendMethodDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::SharedStorageAppendMethod_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::key(input)) in_key = Traits::key(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->key)::BaseType> key_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::SharedStorageKeyArgumentDataView>(
        in_key, key_fragment);
    fragment->key.Set(
        key_fragment.is_null() ? nullptr : key_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->key.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null key in SharedStorageAppendMethod struct");
    decltype(Traits::value(input)) in_value = Traits::value(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->value)::BaseType> value_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::SharedStorageValueArgumentDataView>(
        in_value, value_fragment);
    fragment->value.Set(
        value_fragment.is_null() ? nullptr : value_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->value.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null value in SharedStorageAppendMethod struct");
  }

  static bool Deserialize(::network::mojom::internal::SharedStorageAppendMethod_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::SharedStorageAppendMethodDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::SharedStorageDeleteMethodDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::SharedStorageDeleteMethodDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::SharedStorageDeleteMethod_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::key(input)) in_key = Traits::key(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->key)::BaseType> key_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::SharedStorageKeyArgumentDataView>(
        in_key, key_fragment);
    fragment->key.Set(
        key_fragment.is_null() ? nullptr : key_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->key.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null key in SharedStorageDeleteMethod struct");
  }

  static bool Deserialize(::network::mojom::internal::SharedStorageDeleteMethod_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::SharedStorageDeleteMethodDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::SharedStorageClearMethodDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::SharedStorageClearMethodDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::SharedStorageClearMethod_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
  }

  static bool Deserialize(::network::mojom::internal::SharedStorageClearMethod_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::SharedStorageClearMethodDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::SharedStorageModifierMethodWithOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::SharedStorageModifierMethodWithOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::SharedStorageModifierMethodWithOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::method(input)) in_method = Traits::method(input);
    mojo::internal::MessageFragment<decltype(fragment->method)>
        method_fragment(fragment.message());
    method_fragment.Claim(&fragment->method);
    mojo::internal::Serialize<::network::mojom::SharedStorageModifierMethodDataView>(
        in_method, method_fragment, true);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->method.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null method in SharedStorageModifierMethodWithOptions struct");
    decltype(Traits::with_lock(input)) in_with_lock = Traits::with_lock(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->with_lock)::BaseType> with_lock_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::LockNameDataView>(
        in_with_lock, with_lock_fragment);
    fragment->with_lock.Set(
        with_lock_fragment.is_null() ? nullptr : with_lock_fragment.data());
  }

  static bool Deserialize(::network::mojom::internal::SharedStorageModifierMethodWithOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::SharedStorageModifierMethodWithOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::SharedStorageModifierMethodDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::network::mojom::SharedStorageModifierMethodDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::network::mojom::internal::SharedStorageModifierMethod_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::network::mojom::SharedStorageModifierMethodDataView::Tag::kSetMethod: {
        decltype(Traits::set_method(input))
            in_set_method = Traits::set_method(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_set_method)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::network::mojom::SharedStorageSetMethodDataView>(
            in_set_method, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null set_method in SharedStorageModifierMethod union");
        fragment->data.f_set_method.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::network::mojom::SharedStorageModifierMethodDataView::Tag::kAppendMethod: {
        decltype(Traits::append_method(input))
            in_append_method = Traits::append_method(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_append_method)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::network::mojom::SharedStorageAppendMethodDataView>(
            in_append_method, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null append_method in SharedStorageModifierMethod union");
        fragment->data.f_append_method.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::network::mojom::SharedStorageModifierMethodDataView::Tag::kDeleteMethod: {
        decltype(Traits::delete_method(input))
            in_delete_method = Traits::delete_method(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_delete_method)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::network::mojom::SharedStorageDeleteMethodDataView>(
            in_delete_method, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null delete_method in SharedStorageModifierMethod union");
        fragment->data.f_delete_method.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::network::mojom::SharedStorageModifierMethodDataView::Tag::kClearMethod: {
        decltype(Traits::clear_method(input))
            in_clear_method = Traits::clear_method(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_clear_method)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::network::mojom::SharedStorageClearMethodDataView>(
            in_clear_method, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null clear_method in SharedStorageModifierMethod union");
        fragment->data.f_clear_method.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
    }
  }

  static bool Deserialize(::network::mojom::internal::SharedStorageModifierMethod_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::SharedStorageModifierMethodDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void SharedStorageKeyArgumentDataView::GetDataDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->data.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}


inline void SharedStorageValueArgumentDataView::GetDataDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->data.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}


inline void LockNameDataView::GetDataDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->data.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void SharedStorageSetMethodDataView::GetKeyDataView(
    SharedStorageKeyArgumentDataView* output) {
  auto pointer = data_->key.Get();
  *output = SharedStorageKeyArgumentDataView(pointer, message_);
}
inline void SharedStorageSetMethodDataView::GetValueDataView(
    SharedStorageValueArgumentDataView* output) {
  auto pointer = data_->value.Get();
  *output = SharedStorageValueArgumentDataView(pointer, message_);
}


inline void SharedStorageAppendMethodDataView::GetKeyDataView(
    SharedStorageKeyArgumentDataView* output) {
  auto pointer = data_->key.Get();
  *output = SharedStorageKeyArgumentDataView(pointer, message_);
}
inline void SharedStorageAppendMethodDataView::GetValueDataView(
    SharedStorageValueArgumentDataView* output) {
  auto pointer = data_->value.Get();
  *output = SharedStorageValueArgumentDataView(pointer, message_);
}


inline void SharedStorageDeleteMethodDataView::GetKeyDataView(
    SharedStorageKeyArgumentDataView* output) {
  auto pointer = data_->key.Get();
  *output = SharedStorageKeyArgumentDataView(pointer, message_);
}




inline void SharedStorageModifierMethodWithOptionsDataView::GetMethodDataView(
    SharedStorageModifierMethodDataView* output) {
  auto pointer = &data_->method;
  *output = SharedStorageModifierMethodDataView(pointer, message_);
}
inline void SharedStorageModifierMethodWithOptionsDataView::GetWithLockDataView(
    LockNameDataView* output) {
  auto pointer = data_->with_lock.Get();
  *output = LockNameDataView(pointer, message_);
}


inline void SharedStorageModifierMethodDataView::GetSetMethodDataView(
    SharedStorageSetMethodDataView* output) const {
  CHECK(is_set_method());
  *output = SharedStorageSetMethodDataView(data_->data.f_set_method.Get(), message_);
}
inline void SharedStorageModifierMethodDataView::GetAppendMethodDataView(
    SharedStorageAppendMethodDataView* output) const {
  CHECK(is_append_method());
  *output = SharedStorageAppendMethodDataView(data_->data.f_append_method.Get(), message_);
}
inline void SharedStorageModifierMethodDataView::GetDeleteMethodDataView(
    SharedStorageDeleteMethodDataView* output) const {
  CHECK(is_delete_method());
  *output = SharedStorageDeleteMethodDataView(data_->data.f_delete_method.Get(), message_);
}
inline void SharedStorageModifierMethodDataView::GetClearMethodDataView(
    SharedStorageClearMethodDataView* output) const {
  CHECK(is_clear_method());
  *output = SharedStorageClearMethodDataView(data_->data.f_clear_method.Get(), message_);
}


}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_SHARED_STORAGE_MOJOM_SHARED_H_