// services/network/public/mojom/chunked_data_pipe_getter.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/chunked_data_pipe_getter.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/chunked_data_pipe_getter.mojom-params-data.h"
#include "services/network/public/mojom/chunked_data_pipe_getter.mojom-shared-message-ids.h"

#include "services/network/public/mojom/chunked_data_pipe_getter.mojom-import-headers.h"
#include "services/network/public/mojom/chunked_data_pipe_getter.mojom-test-utils.h"


namespace network::mojom {
const char ChunkedDataPipeGetter::Name_[] = "network.mojom.ChunkedDataPipeGetter";

ChunkedDataPipeGetter::IPCStableHashFunction ChunkedDataPipeGetter::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ChunkedDataPipeGetter>(message.name())) {
    case messages::ChunkedDataPipeGetter::kGetSize: {
      return &ChunkedDataPipeGetter::GetSize_Sym::IPCStableHash;
    }
    case messages::ChunkedDataPipeGetter::kStartReading: {
      return &ChunkedDataPipeGetter::StartReading_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ChunkedDataPipeGetter::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ChunkedDataPipeGetter>(message.name())) {
      case messages::ChunkedDataPipeGetter::kGetSize:
            return "Receive network::mojom::ChunkedDataPipeGetter::GetSize";
      case messages::ChunkedDataPipeGetter::kStartReading:
            return "Receive network::mojom::ChunkedDataPipeGetter::StartReading";
    }
  } else {
    switch (static_cast<messages::ChunkedDataPipeGetter>(message.name())) {
      case messages::ChunkedDataPipeGetter::kGetSize:
            return "Receive reply network::mojom::ChunkedDataPipeGetter::GetSize";
      case messages::ChunkedDataPipeGetter::kStartReading:
            return "Receive reply network::mojom::ChunkedDataPipeGetter::StartReading";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ChunkedDataPipeGetter::GetSize_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::ChunkedDataPipeGetter::GetSize");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ChunkedDataPipeGetter::StartReading_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::ChunkedDataPipeGetter::StartReading");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class ChunkedDataPipeGetter_GetSize_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ChunkedDataPipeGetter_GetSize_ForwardToCallback(
      ChunkedDataPipeGetter::GetSizeCallback callback
      ) : callback_(std::move(callback)) {
  }

  ChunkedDataPipeGetter_GetSize_ForwardToCallback(const ChunkedDataPipeGetter_GetSize_ForwardToCallback&) = delete;
  ChunkedDataPipeGetter_GetSize_ForwardToCallback& operator=(const ChunkedDataPipeGetter_GetSize_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ChunkedDataPipeGetter::GetSizeCallback callback_;
};

ChunkedDataPipeGetterProxy::ChunkedDataPipeGetterProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ChunkedDataPipeGetterProxy::GetSize(
    GetSizeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send network::mojom::ChunkedDataPipeGetter::GetSize");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ChunkedDataPipeGetter::kGetSize), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::ChunkedDataPipeGetter_GetSize_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ChunkedDataPipeGetter::Name_);
  message.set_method_name("GetSize");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ChunkedDataPipeGetter_GetSize_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ChunkedDataPipeGetterProxy::StartReading(
    ::mojo::ScopedDataPipeProducerHandle in_pipe) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::ChunkedDataPipeGetter::StartReading", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pipe"), in_pipe,
                        "<value of type ::mojo::ScopedDataPipeProducerHandle>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ChunkedDataPipeGetter::kStartReading), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::ChunkedDataPipeGetter_StartReading_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::ScopedDataPipeProducerHandle>(
      in_pipe, &params->pipe, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->pipe),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid pipe in ChunkedDataPipeGetter.StartReading request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ChunkedDataPipeGetter::Name_);
  message.set_method_name("StartReading");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class ChunkedDataPipeGetter_GetSize_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ChunkedDataPipeGetter::GetSizeCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ChunkedDataPipeGetter_GetSize_ProxyToResponder> proxy(
        new ChunkedDataPipeGetter_GetSize_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ChunkedDataPipeGetter_GetSize_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ChunkedDataPipeGetter_GetSize_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ChunkedDataPipeGetter_GetSize_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ChunkedDataPipeGetter::GetSizeCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_status, uint64_t in_size);
};

bool ChunkedDataPipeGetter_GetSize_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ChunkedDataPipeGetter_GetSize_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ChunkedDataPipeGetter_GetSize_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for ChunkedDataPipeGetter.0
  bool success = true;
  int32_t p_status{};
  uint64_t p_size{};
  ChunkedDataPipeGetter_GetSize_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_status = input_data_view.status();
  if (success)
    p_size = input_data_view.size();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ChunkedDataPipeGetter::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_size));
  return true;
}

void ChunkedDataPipeGetter_GetSize_ProxyToResponder::Run(
    int32_t in_status, uint64_t in_size) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::ChunkedDataPipeGetter::GetSize", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("size"), in_size,
                        "<value of type uint64_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ChunkedDataPipeGetter::kGetSize), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::ChunkedDataPipeGetter_GetSize_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->status = in_status;
  params->size = in_size;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ChunkedDataPipeGetter::Name_);
  message.set_method_name("GetSize");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ChunkedDataPipeGetterStubDispatch::Accept(
    ChunkedDataPipeGetter* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ChunkedDataPipeGetter>(message->header()->name)) {
    case messages::ChunkedDataPipeGetter::kGetSize: {
      break;
    }
    case messages::ChunkedDataPipeGetter::kStartReading: {
      DCHECK(message->is_serialized());
      internal::ChunkedDataPipeGetter_StartReading_Params_Data* params =
          reinterpret_cast<internal::ChunkedDataPipeGetter_StartReading_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for ChunkedDataPipeGetter.1
      bool success = true;
      ::mojo::ScopedDataPipeProducerHandle p_pipe{};
      ChunkedDataPipeGetter_StartReading_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_pipe = input_data_view.TakePipe();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ChunkedDataPipeGetter::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartReading(        
        std::move(p_pipe));
      return true;
    }
  }
  return false;
}

// static
bool ChunkedDataPipeGetterStubDispatch::AcceptWithResponder(
    ChunkedDataPipeGetter* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ChunkedDataPipeGetter>(message->header()->name)) {
    case messages::ChunkedDataPipeGetter::kGetSize: {
      internal::ChunkedDataPipeGetter_GetSize_Params_Data* params =
          reinterpret_cast<
              internal::ChunkedDataPipeGetter_GetSize_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for ChunkedDataPipeGetter.0
      bool success = true;
      ChunkedDataPipeGetter_GetSize_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ChunkedDataPipeGetter::Name_, 0, false);
        return false;
      }
      ChunkedDataPipeGetter::GetSizeCallback callback =
          ChunkedDataPipeGetter_GetSize_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetSize(std::move(callback));
      return true;
    }
    case messages::ChunkedDataPipeGetter::kStartReading: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kChunkedDataPipeGetterValidationInfo[] = {
    {base::to_underlying(messages::ChunkedDataPipeGetter::kGetSize),
     { &internal::ChunkedDataPipeGetter_GetSize_Params_Data::Validate,
      &internal::ChunkedDataPipeGetter_GetSize_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::ChunkedDataPipeGetter::kStartReading),
     { &internal::ChunkedDataPipeGetter_StartReading_Params_Data::Validate,
      nullptr /* no response */}},
};

bool ChunkedDataPipeGetterRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::ChunkedDataPipeGetter::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kChunkedDataPipeGetterValidationInfo);
}

bool ChunkedDataPipeGetterResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::ChunkedDataPipeGetter::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kChunkedDataPipeGetterValidationInfo);

}


}  // network::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom {


void ChunkedDataPipeGetterInterceptorForTesting::GetSize(GetSizeCallback callback) {
  GetForwardingInterface()->GetSize(std::move(callback));
}
void ChunkedDataPipeGetterInterceptorForTesting::StartReading(::mojo::ScopedDataPipeProducerHandle pipe) {
  GetForwardingInterface()->StartReading(
    std::move(pipe)
    );
}
ChunkedDataPipeGetterAsyncWaiter::ChunkedDataPipeGetterAsyncWaiter(
    ChunkedDataPipeGetter* proxy) : proxy_(proxy) {}

ChunkedDataPipeGetterAsyncWaiter::~ChunkedDataPipeGetterAsyncWaiter() = default;

void ChunkedDataPipeGetterAsyncWaiter::GetSize(
    int32_t* out_status, uint64_t* out_size) {
  base::RunLoop loop;
  proxy_->GetSize(
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_status
,
             uint64_t* out_size
,
             int32_t status,
             uint64_t size) {*out_status = std::move(status);*out_size = std::move(size);
            loop->Quit();
          },
          &loop,
          out_status,
          out_size));
  loop.Run();
}








}  // network::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif