// printing/mojom/print.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef PRINTING_MOJOM_PRINT_MOJOM_SHARED_H_
#define PRINTING_MOJOM_PRINT_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "printing/mojom/print.mojom-shared-internal.h"







namespace printing::mojom {
class PageSizeMarginsDataView;

class PageRangeDataView;



}  // printing::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::printing::mojom::PageSizeMarginsDataView> {
  using Data = ::printing::mojom::internal::PageSizeMargins_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::printing::mojom::PageRangeDataView> {
  using Data = ::printing::mojom::internal::PageRange_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace printing::mojom {


enum class ColorModel : int32_t {
  
  kUnknownColorModel = 0,
  
  kGray = 1,
  
  kColor = 2,
  
  kCMYK = 3,
  
  kCMY = 4,
  
  kKCMY = 5,
  
  kCMYPlusK = 6,
  
  kBlack = 7,
  
  kGrayscale = 8,
  
  kRGB = 9,
  
  kRGB16 = 10,
  
  kRGBA = 11,
  
  kColorModeColor = 12,
  
  kColorModeMonochrome = 13,
  
  kHPColorColor = 14,
  
  kHPColorBlack = 15,
  
  kPrintoutModeNormal = 16,
  
  kPrintoutModeNormalGray = 17,
  
  kProcessColorModelCMYK = 18,
  
  kProcessColorModelGreyscale = 19,
  
  kProcessColorModelRGB = 20,
  
  kBrotherCUPSColor = 21,
  
  kBrotherCUPSMono = 22,
  
  kBrotherBRScript3Color = 23,
  
  kBrotherBRScript3Black = 24,
  
  kEpsonInkColor = 25,
  
  kEpsonInkMono = 26,
  
  kSharpARCModeCMColor = 27,
  
  kSharpARCModeCMBW = 28,
  
  kXeroxXRXColorAutomatic = 29,
  
  kXeroxXRXColorBW = 30,
  
  kColorModelLast = 30,
  
  kCanonCNColorModeColor = 31,
  
  kCanonCNColorModeMono = 32,
  
  kCanonCNIJGrayScaleOne = 33,
  
  kCanonCNIJGrayScaleZero = 34,
  
  kKonicaMinoltaSelectColorColor = 35,
  
  kKonicaMinoltaSelectColorGrayscale = 36,
  
  kOkiOKControlColor = 37,
  
  kOkiOKControlGray = 38,
  
  kXeroxXROutputColorPrintAsColor = 39,
  
  kXeroxXROutputColorPrintAsGrayscale = 40,
  
  kHpPjlColorAsGrayNo = 41,
  
  kHpPjlColorAsGrayYes = 42,
  kMinValue = 0,
  kMaxValue = 42,
  kDefaultValue = 0
};

 std::ostream& operator<<(std::ostream& os, ColorModel value);
inline bool IsKnownEnumValue(ColorModel value) {
  return internal::ColorModel_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline ColorModel ToKnownEnumValue(ColorModel value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return ColorModel::kDefaultValue;
}


enum class DuplexMode : int32_t {
  
  kUnknownDuplexMode = -1,
  
  kSimplex = 0,
  
  kLongEdge = 1,
  
  kShortEdge = 2,
  kMinValue = -1,
  kMaxValue = 2,
  kDefaultValue = -1
};

 std::ostream& operator<<(std::ostream& os, DuplexMode value);
inline bool IsKnownEnumValue(DuplexMode value) {
  return internal::DuplexMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline DuplexMode ToKnownEnumValue(DuplexMode value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return DuplexMode::kDefaultValue;
}


enum class PageOrientation : int32_t {
  
  kUpright = 0,
  
  kRotateLeft = 1,
  
  kRotateRight = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, PageOrientation value);
inline bool IsKnownEnumValue(PageOrientation value) {
  return internal::PageOrientation_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class PrintScalingOption : int32_t {
  
  kNone = 0,
  
  kFitToPrintableArea = 1,
  
  kSourceSize = 2,
  
  kFitToPaper = 3,
  
  kCenterShrinkToFitPaper = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

 std::ostream& operator<<(std::ostream& os, PrintScalingOption value);
inline bool IsKnownEnumValue(PrintScalingOption value) {
  return internal::PrintScalingOption_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SkiaDocumentType : int32_t {
  
  kPDF = 0,
  
  kMSKP = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, SkiaDocumentType value);
inline bool IsKnownEnumValue(SkiaDocumentType value) {
  return internal::SkiaDocumentType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class MetafileDataType : int32_t {
  
  kPDF = 0,
  kMinValue = 0,
  kMaxValue = 0,
};

 std::ostream& operator<<(std::ostream& os, MetafileDataType value);
inline bool IsKnownEnumValue(MetafileDataType value) {
  return internal::MetafileDataType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class GenerateDocumentOutline : int32_t {
  
  kNone = 0,
  
  kFromAccessibilityTreeHeaders = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, GenerateDocumentOutline value);
inline bool IsKnownEnumValue(GenerateDocumentOutline value) {
  return internal::GenerateDocumentOutline_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class MarginType : int32_t {
  
  kDefaultMargins = 0,
  
  kNoMargins = 1,
  
  kPrintableAreaMargins = 2,
  
  kCustomMargins = 3,
  kMinValue = 0,
  kMaxValue = 3,
  kDefaultValue = 0
};

 std::ostream& operator<<(std::ostream& os, MarginType value);
inline bool IsKnownEnumValue(MarginType value) {
  return internal::MarginType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline MarginType ToKnownEnumValue(MarginType value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return MarginType::kDefaultValue;
}


enum class ResultCode : int32_t {
  
  kSuccess = 0,
  
  kFailed = 1,
  
  kAccessDenied = 2,
  
  kCanceled = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, ResultCode value);
inline bool IsKnownEnumValue(ResultCode value) {
  return internal::ResultCode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class PrinterType : int32_t {
  
  kPrivetDeprecated = 0,
  
  kExtension = 1,
  
  kPdf = 2,
  
  kLocal = 3,
  
  kCloudDeprecated = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

 std::ostream& operator<<(std::ostream& os, PrinterType value);
inline bool IsKnownEnumValue(PrinterType value) {
  return internal::PrinterType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class PageSizeMarginsDataView {
 public:
  PageSizeMarginsDataView() = default;

  PageSizeMarginsDataView(
      internal::PageSizeMargins_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  double content_width() const {
    return data_->content_width;
  }
  double content_height() const {
    return data_->content_height;
  }
  double margin_top() const {
    return data_->margin_top;
  }
  double margin_right() const {
    return data_->margin_right;
  }
  double margin_bottom() const {
    return data_->margin_bottom;
  }
  double margin_left() const {
    return data_->margin_left;
  }
 private:
  internal::PageSizeMargins_Data* data_ = nullptr;
};


class PageRangeDataView {
 public:
  PageRangeDataView() = default;

  PageRangeDataView(
      internal::PageRange_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t from() const {
    return data_->from;
  }
  uint32_t to() const {
    return data_->to;
  }
 private:
  internal::PageRange_Data* data_ = nullptr;
};


}  // printing::mojom

namespace std {

template <>
struct hash<::printing::mojom::ColorModel>
    : public mojo::internal::EnumHashImpl<::printing::mojom::ColorModel> {};

template <>
struct hash<::printing::mojom::DuplexMode>
    : public mojo::internal::EnumHashImpl<::printing::mojom::DuplexMode> {};

template <>
struct hash<::printing::mojom::PageOrientation>
    : public mojo::internal::EnumHashImpl<::printing::mojom::PageOrientation> {};

template <>
struct hash<::printing::mojom::PrintScalingOption>
    : public mojo::internal::EnumHashImpl<::printing::mojom::PrintScalingOption> {};

template <>
struct hash<::printing::mojom::SkiaDocumentType>
    : public mojo::internal::EnumHashImpl<::printing::mojom::SkiaDocumentType> {};

template <>
struct hash<::printing::mojom::MetafileDataType>
    : public mojo::internal::EnumHashImpl<::printing::mojom::MetafileDataType> {};

template <>
struct hash<::printing::mojom::GenerateDocumentOutline>
    : public mojo::internal::EnumHashImpl<::printing::mojom::GenerateDocumentOutline> {};

template <>
struct hash<::printing::mojom::MarginType>
    : public mojo::internal::EnumHashImpl<::printing::mojom::MarginType> {};

template <>
struct hash<::printing::mojom::ResultCode>
    : public mojo::internal::EnumHashImpl<::printing::mojom::ResultCode> {};

template <>
struct hash<::printing::mojom::PrinterType>
    : public mojo::internal::EnumHashImpl<::printing::mojom::PrinterType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::ColorModel, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::printing::mojom::ColorModel, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::printing::mojom::ColorModel>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::DuplexMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::printing::mojom::DuplexMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::printing::mojom::DuplexMode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::PageOrientation, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::printing::mojom::PageOrientation, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::printing::mojom::PageOrientation>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::PrintScalingOption, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::printing::mojom::PrintScalingOption, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::printing::mojom::PrintScalingOption>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::SkiaDocumentType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::printing::mojom::SkiaDocumentType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::printing::mojom::SkiaDocumentType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::MetafileDataType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::printing::mojom::MetafileDataType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::printing::mojom::MetafileDataType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::GenerateDocumentOutline, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::printing::mojom::GenerateDocumentOutline, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::printing::mojom::GenerateDocumentOutline>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::MarginType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::printing::mojom::MarginType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::printing::mojom::MarginType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::ResultCode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::printing::mojom::ResultCode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::printing::mojom::ResultCode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::PrinterType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::printing::mojom::PrinterType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::printing::mojom::PrinterType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::PageSizeMarginsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::printing::mojom::PageSizeMarginsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::printing::mojom::internal::PageSizeMargins_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->content_width = Traits::content_width(input);
    fragment->content_height = Traits::content_height(input);
    fragment->margin_top = Traits::margin_top(input);
    fragment->margin_right = Traits::margin_right(input);
    fragment->margin_bottom = Traits::margin_bottom(input);
    fragment->margin_left = Traits::margin_left(input);
  }

  static bool Deserialize(::printing::mojom::internal::PageSizeMargins_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::printing::mojom::PageSizeMarginsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::printing::mojom::PageRangeDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::printing::mojom::PageRangeDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::printing::mojom::internal::PageRange_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->from = Traits::from(input);
    fragment->to = Traits::to(input);
  }

  static bool Deserialize(::printing::mojom::internal::PageRange_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::printing::mojom::PageRangeDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace printing::mojom {






}  // printing::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::printing::mojom::ColorModel> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::printing::mojom::ColorModel value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::printing::mojom::DuplexMode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::printing::mojom::DuplexMode value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::printing::mojom::PageOrientation> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::printing::mojom::PageOrientation value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::printing::mojom::PrintScalingOption> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::printing::mojom::PrintScalingOption value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::printing::mojom::SkiaDocumentType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::printing::mojom::SkiaDocumentType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::printing::mojom::MetafileDataType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::printing::mojom::MetafileDataType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::printing::mojom::GenerateDocumentOutline> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::printing::mojom::GenerateDocumentOutline value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::printing::mojom::MarginType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::printing::mojom::MarginType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::printing::mojom::ResultCode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::printing::mojom::ResultCode value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::printing::mojom::PrinterType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::printing::mojom::PrinterType value);
};

} // namespace perfetto

#endif  // PRINTING_MOJOM_PRINT_MOJOM_SHARED_H_