// Copyright 2020 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/cpp/quic_transport_error_mojom_traits.h"

namespace mojo {

bool StructTraits<network::mojom::QuicTransportErrorDataView,
                  net::QuicTransportError>::
    Read(network::mojom::QuicTransportErrorDataView in,
         net::QuicTransportError* out) {
  if (in.net_error() > 0) {
    return false;
  }
  if (in.quic_error() < 0 || in.quic_error() >= quic::QUIC_LAST_ERROR) {
    return false;
  }
  std::string details;
  if (!in.ReadDetails(&details)) {
    return false;
  }

  *out = net::QuicTransportError(
      in.net_error(), static_cast<quic::QuicErrorCode>(in.quic_error()),
      std::move(details), in.safe_to_report_details());
  return true;
}

}  // namespace mojo
