// ui/gfx/mojom/selection_bound.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ui/gfx/mojom/selection_bound.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"

#include "ui/gfx/mojom/selection_bound.mojom-params-data.h"
namespace gfx {
namespace mojom {

std::ostream& operator<<(std::ostream& os, SelectionBoundType value) {
  switch(value) {
    case SelectionBoundType::LEFT:
      return os << "SelectionBoundType::LEFT";
    case SelectionBoundType::RIGHT:
      return os << "SelectionBoundType::RIGHT";
    case SelectionBoundType::CENTER:
      return os << "SelectionBoundType::CENTER";
    case SelectionBoundType::EMPTY:
      return os << "SelectionBoundType::{EMPTY, LAST}";
    default:
      return os << "Unknown SelectionBoundType value: " << static_cast<int32_t>(value);
  }
}

namespace internal {


// static
bool SelectionBound_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const SelectionBound_Data* object = static_cast<const SelectionBound_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 48 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }


  if (!::gfx::mojom::internal::SelectionBoundType_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->edge_start, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->edge_start, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->edge_end, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->edge_end, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->visible_edge_start, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->visible_edge_start, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->visible_edge_end, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->visible_edge_end, validation_context))
    return false;

  return true;
}

SelectionBound_Data::SelectionBound_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace gfx