// third_party/blink/public/mojom/payments/payment_handler_host.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_PAYMENT_HANDLER_HOST_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_PAYMENT_HANDLER_HOST_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "third_party/blink/public/mojom/payments/payment_handler_host.mojom-shared.h"
#include "third_party/blink/public/mojom/payments/payment_handler_host.mojom-blink-forward.h"
#include "components/payments/mojom/payment_request_data.mojom-blink.h"
#include "third_party/blink/public/mojom/payments/payment_request.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "third_party/blink/renderer/platform/platform_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace payments {
namespace mojom {
namespace blink {

class PaymentHandlerHostProxy;

template <typename ImplRefTraits>
class PaymentHandlerHostStub;

class PaymentHandlerHostRequestValidator;
class PaymentHandlerHostResponseValidator;


class PLATFORM_EXPORT PaymentHandlerHost
    : public PaymentHandlerHostInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = PaymentHandlerHostInterfaceBase;
  using Proxy_ = PaymentHandlerHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = PaymentHandlerHostStub<ImplRefTraits>;

  using RequestValidator_ = PaymentHandlerHostRequestValidator;
  using ResponseValidator_ = PaymentHandlerHostResponseValidator;
  enum MethodMinVersions : uint32_t {
    kChangePaymentMethodMinVersion = 0,
    kChangeShippingOptionMinVersion = 0,
    kChangeShippingAddressMinVersion = 0,
  };
  virtual ~PaymentHandlerHost() {}


  using ChangePaymentMethodCallback = base::OnceCallback<void(PaymentRequestDetailsUpdatePtr)>;
  
  virtual void ChangePaymentMethod(PaymentHandlerMethodDataPtr method_data, ChangePaymentMethodCallback callback) = 0;


  using ChangeShippingOptionCallback = base::OnceCallback<void(PaymentRequestDetailsUpdatePtr)>;
  
  virtual void ChangeShippingOption(const WTF::String& shipping_option_id, ChangeShippingOptionCallback callback) = 0;


  using ChangeShippingAddressCallback = base::OnceCallback<void(PaymentRequestDetailsUpdatePtr)>;
  
  virtual void ChangeShippingAddress(::payments::mojom::blink::PaymentAddressPtr shipping_address, ChangeShippingAddressCallback callback) = 0;
};



class PLATFORM_EXPORT PaymentHandlerHostProxy
    : public PaymentHandlerHost {
 public:
  using InterfaceType = PaymentHandlerHost;

  explicit PaymentHandlerHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ChangePaymentMethod(PaymentHandlerMethodDataPtr method_data, ChangePaymentMethodCallback callback) final;
  
  void ChangeShippingOption(const WTF::String& shipping_option_id, ChangeShippingOptionCallback callback) final;
  
  void ChangeShippingAddress(::payments::mojom::blink::PaymentAddressPtr shipping_address, ChangeShippingAddressCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class PLATFORM_EXPORT PaymentHandlerHostStubDispatch {
 public:
  static bool Accept(PaymentHandlerHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PaymentHandlerHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PaymentHandlerHost>>
class PaymentHandlerHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PaymentHandlerHostStub() {}
  ~PaymentHandlerHostStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PaymentHandlerHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PaymentHandlerHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT PaymentHandlerHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT PaymentHandlerHostResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class PLATFORM_EXPORT PaymentHandlerMethodData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PaymentHandlerMethodData, T>::value>;
  using DataView = PaymentHandlerMethodDataDataView;
  using Data_ = internal::PaymentHandlerMethodData_Data;

  template <typename... Args>
  static PaymentHandlerMethodDataPtr New(Args&&... args) {
    return PaymentHandlerMethodDataPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PaymentHandlerMethodDataPtr From(const U& u) {
    return mojo::TypeConverter<PaymentHandlerMethodDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PaymentHandlerMethodData>::Convert(*this);
  }


  PaymentHandlerMethodData();

  PaymentHandlerMethodData(
      const WTF::String& method_name,
      const WTF::String& stringified_data);

  ~PaymentHandlerMethodData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PaymentHandlerMethodDataPtr>
  PaymentHandlerMethodDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PaymentHandlerMethodData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PaymentHandlerMethodData::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PaymentHandlerMethodData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PaymentHandlerMethodData_UnserializedMessageContext<
            UserType, PaymentHandlerMethodData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<PaymentHandlerMethodData::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return PaymentHandlerMethodData::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PaymentHandlerMethodData_UnserializedMessageContext<
            UserType, PaymentHandlerMethodData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PaymentHandlerMethodData::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  WTF::String method_name;
  
  WTF::String stringified_data;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PaymentHandlerMethodData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PaymentHandlerMethodData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PaymentHandlerMethodData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PaymentHandlerMethodData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}










class PLATFORM_EXPORT PaymentHandlerModifier {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PaymentHandlerModifier, T>::value>;
  using DataView = PaymentHandlerModifierDataView;
  using Data_ = internal::PaymentHandlerModifier_Data;

  template <typename... Args>
  static PaymentHandlerModifierPtr New(Args&&... args) {
    return PaymentHandlerModifierPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PaymentHandlerModifierPtr From(const U& u) {
    return mojo::TypeConverter<PaymentHandlerModifierPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PaymentHandlerModifier>::Convert(*this);
  }


  PaymentHandlerModifier();

  PaymentHandlerModifier(
      ::payments::mojom::blink::PaymentCurrencyAmountPtr total,
      PaymentHandlerMethodDataPtr method_data);

  ~PaymentHandlerModifier();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PaymentHandlerModifierPtr>
  PaymentHandlerModifierPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PaymentHandlerModifier::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PaymentHandlerModifier::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PaymentHandlerModifier::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PaymentHandlerModifier_UnserializedMessageContext<
            UserType, PaymentHandlerModifier::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<PaymentHandlerModifier::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return PaymentHandlerModifier::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PaymentHandlerModifier_UnserializedMessageContext<
            UserType, PaymentHandlerModifier::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PaymentHandlerModifier::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::payments::mojom::blink::PaymentCurrencyAmountPtr total;
  
  PaymentHandlerMethodDataPtr method_data;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(PaymentHandlerModifier);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PaymentHandlerModifier::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PaymentHandlerModifier::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PaymentHandlerModifier::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PaymentHandlerModifier::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT PaymentRequestDetailsUpdate {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PaymentRequestDetailsUpdate, T>::value>;
  using DataView = PaymentRequestDetailsUpdateDataView;
  using Data_ = internal::PaymentRequestDetailsUpdate_Data;

  template <typename... Args>
  static PaymentRequestDetailsUpdatePtr New(Args&&... args) {
    return PaymentRequestDetailsUpdatePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PaymentRequestDetailsUpdatePtr From(const U& u) {
    return mojo::TypeConverter<PaymentRequestDetailsUpdatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PaymentRequestDetailsUpdate>::Convert(*this);
  }


  PaymentRequestDetailsUpdate();

  PaymentRequestDetailsUpdate(
      ::payments::mojom::blink::PaymentCurrencyAmountPtr total,
      base::Optional<WTF::Vector<::payments::mojom::blink::PaymentShippingOptionPtr>> shipping_options,
      base::Optional<WTF::Vector<PaymentHandlerModifierPtr>> modifiers,
      const WTF::String& error,
      const WTF::String& stringified_payment_method_errors,
      ::payments::mojom::blink::AddressErrorsPtr shipping_address_errors);

  ~PaymentRequestDetailsUpdate();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PaymentRequestDetailsUpdatePtr>
  PaymentRequestDetailsUpdatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PaymentRequestDetailsUpdate::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PaymentRequestDetailsUpdate::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PaymentRequestDetailsUpdate::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PaymentRequestDetailsUpdate_UnserializedMessageContext<
            UserType, PaymentRequestDetailsUpdate::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<PaymentRequestDetailsUpdate::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return PaymentRequestDetailsUpdate::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PaymentRequestDetailsUpdate_UnserializedMessageContext<
            UserType, PaymentRequestDetailsUpdate::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PaymentRequestDetailsUpdate::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::payments::mojom::blink::PaymentCurrencyAmountPtr total;
  
  base::Optional<WTF::Vector<::payments::mojom::blink::PaymentShippingOptionPtr>> shipping_options;
  
  base::Optional<WTF::Vector<PaymentHandlerModifierPtr>> modifiers;
  
  WTF::String error;
  
  WTF::String stringified_payment_method_errors;
  
  ::payments::mojom::blink::AddressErrorsPtr shipping_address_errors;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(PaymentRequestDetailsUpdate);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PaymentRequestDetailsUpdate::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PaymentRequestDetailsUpdate::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PaymentRequestDetailsUpdate::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PaymentRequestDetailsUpdate::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
PaymentHandlerMethodDataPtr PaymentHandlerMethodData::Clone() const {
  return New(
      mojo::Clone(method_name),
      mojo::Clone(stringified_data)
  );
}

template <typename T, PaymentHandlerMethodData::EnableIfSame<T>*>
bool PaymentHandlerMethodData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->method_name, other_struct.method_name))
    return false;
  if (!mojo::Equals(this->stringified_data, other_struct.stringified_data))
    return false;
  return true;
}

template <typename T, PaymentHandlerMethodData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.method_name, rhs.method_name))
    return true;
  if (std::less<>{}(rhs.method_name, lhs.method_name))
    return false;
  if (std::less<>{}(lhs.stringified_data, rhs.stringified_data))
    return true;
  if (std::less<>{}(rhs.stringified_data, lhs.stringified_data))
    return false;
  return false;
}
template <typename StructPtrType>
PaymentHandlerModifierPtr PaymentHandlerModifier::Clone() const {
  return New(
      mojo::Clone(total),
      mojo::Clone(method_data)
  );
}

template <typename T, PaymentHandlerModifier::EnableIfSame<T>*>
bool PaymentHandlerModifier::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->total, other_struct.total))
    return false;
  if (!mojo::Equals(this->method_data, other_struct.method_data))
    return false;
  return true;
}

template <typename T, PaymentHandlerModifier::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.total, rhs.total))
    return true;
  if (std::less<>{}(rhs.total, lhs.total))
    return false;
  if (std::less<>{}(lhs.method_data, rhs.method_data))
    return true;
  if (std::less<>{}(rhs.method_data, lhs.method_data))
    return false;
  return false;
}
template <typename StructPtrType>
PaymentRequestDetailsUpdatePtr PaymentRequestDetailsUpdate::Clone() const {
  return New(
      mojo::Clone(total),
      mojo::Clone(shipping_options),
      mojo::Clone(modifiers),
      mojo::Clone(error),
      mojo::Clone(stringified_payment_method_errors),
      mojo::Clone(shipping_address_errors)
  );
}

template <typename T, PaymentRequestDetailsUpdate::EnableIfSame<T>*>
bool PaymentRequestDetailsUpdate::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->total, other_struct.total))
    return false;
  if (!mojo::Equals(this->shipping_options, other_struct.shipping_options))
    return false;
  if (!mojo::Equals(this->modifiers, other_struct.modifiers))
    return false;
  if (!mojo::Equals(this->error, other_struct.error))
    return false;
  if (!mojo::Equals(this->stringified_payment_method_errors, other_struct.stringified_payment_method_errors))
    return false;
  if (!mojo::Equals(this->shipping_address_errors, other_struct.shipping_address_errors))
    return false;
  return true;
}

template <typename T, PaymentRequestDetailsUpdate::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.total, rhs.total))
    return true;
  if (std::less<>{}(rhs.total, lhs.total))
    return false;
  if (std::less<>{}(lhs.shipping_options, rhs.shipping_options))
    return true;
  if (std::less<>{}(rhs.shipping_options, lhs.shipping_options))
    return false;
  if (std::less<>{}(lhs.modifiers, rhs.modifiers))
    return true;
  if (std::less<>{}(rhs.modifiers, lhs.modifiers))
    return false;
  if (std::less<>{}(lhs.error, rhs.error))
    return true;
  if (std::less<>{}(rhs.error, lhs.error))
    return false;
  if (std::less<>{}(lhs.stringified_payment_method_errors, rhs.stringified_payment_method_errors))
    return true;
  if (std::less<>{}(rhs.stringified_payment_method_errors, lhs.stringified_payment_method_errors))
    return false;
  if (std::less<>{}(lhs.shipping_address_errors, rhs.shipping_address_errors))
    return true;
  if (std::less<>{}(rhs.shipping_address_errors, lhs.shipping_address_errors))
    return false;
  return false;
}


}  // namespace blink
}  // namespace mojom
}  // namespace payments

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::payments::mojom::blink::PaymentHandlerMethodData::DataView,
                                         ::payments::mojom::blink::PaymentHandlerMethodDataPtr> {
  static bool IsNull(const ::payments::mojom::blink::PaymentHandlerMethodDataPtr& input) { return !input; }
  static void SetToNull(::payments::mojom::blink::PaymentHandlerMethodDataPtr* output) { output->reset(); }

  static const decltype(::payments::mojom::blink::PaymentHandlerMethodData::method_name)& method_name(
      const ::payments::mojom::blink::PaymentHandlerMethodDataPtr& input) {
    return input->method_name;
  }

  static const decltype(::payments::mojom::blink::PaymentHandlerMethodData::stringified_data)& stringified_data(
      const ::payments::mojom::blink::PaymentHandlerMethodDataPtr& input) {
    return input->stringified_data;
  }

  static bool Read(::payments::mojom::blink::PaymentHandlerMethodData::DataView input, ::payments::mojom::blink::PaymentHandlerMethodDataPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::payments::mojom::blink::PaymentHandlerModifier::DataView,
                                         ::payments::mojom::blink::PaymentHandlerModifierPtr> {
  static bool IsNull(const ::payments::mojom::blink::PaymentHandlerModifierPtr& input) { return !input; }
  static void SetToNull(::payments::mojom::blink::PaymentHandlerModifierPtr* output) { output->reset(); }

  static const decltype(::payments::mojom::blink::PaymentHandlerModifier::total)& total(
      const ::payments::mojom::blink::PaymentHandlerModifierPtr& input) {
    return input->total;
  }

  static const decltype(::payments::mojom::blink::PaymentHandlerModifier::method_data)& method_data(
      const ::payments::mojom::blink::PaymentHandlerModifierPtr& input) {
    return input->method_data;
  }

  static bool Read(::payments::mojom::blink::PaymentHandlerModifier::DataView input, ::payments::mojom::blink::PaymentHandlerModifierPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::payments::mojom::blink::PaymentRequestDetailsUpdate::DataView,
                                         ::payments::mojom::blink::PaymentRequestDetailsUpdatePtr> {
  static bool IsNull(const ::payments::mojom::blink::PaymentRequestDetailsUpdatePtr& input) { return !input; }
  static void SetToNull(::payments::mojom::blink::PaymentRequestDetailsUpdatePtr* output) { output->reset(); }

  static const decltype(::payments::mojom::blink::PaymentRequestDetailsUpdate::total)& total(
      const ::payments::mojom::blink::PaymentRequestDetailsUpdatePtr& input) {
    return input->total;
  }

  static const decltype(::payments::mojom::blink::PaymentRequestDetailsUpdate::shipping_options)& shipping_options(
      const ::payments::mojom::blink::PaymentRequestDetailsUpdatePtr& input) {
    return input->shipping_options;
  }

  static const decltype(::payments::mojom::blink::PaymentRequestDetailsUpdate::modifiers)& modifiers(
      const ::payments::mojom::blink::PaymentRequestDetailsUpdatePtr& input) {
    return input->modifiers;
  }

  static const decltype(::payments::mojom::blink::PaymentRequestDetailsUpdate::error)& error(
      const ::payments::mojom::blink::PaymentRequestDetailsUpdatePtr& input) {
    return input->error;
  }

  static const decltype(::payments::mojom::blink::PaymentRequestDetailsUpdate::stringified_payment_method_errors)& stringified_payment_method_errors(
      const ::payments::mojom::blink::PaymentRequestDetailsUpdatePtr& input) {
    return input->stringified_payment_method_errors;
  }

  static const decltype(::payments::mojom::blink::PaymentRequestDetailsUpdate::shipping_address_errors)& shipping_address_errors(
      const ::payments::mojom::blink::PaymentRequestDetailsUpdatePtr& input) {
    return input->shipping_address_errors;
  }

  static bool Read(::payments::mojom::blink::PaymentRequestDetailsUpdate::DataView input, ::payments::mojom::blink::PaymentRequestDetailsUpdatePtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAYMENTS_PAYMENT_HANDLER_HOST_MOJOM_BLINK_H_