// third_party/blink/public/mojom/loader/resource_load_info.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/loader/resource_load_info.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"

#include "third_party/blink/public/mojom/loader/resource_load_info.mojom-params-data.h"
namespace blink {
namespace mojom {

std::ostream& operator<<(std::ostream& os, ResourceType value) {
  switch(value) {
    case ResourceType::kMainFrame:
      return os << "ResourceType::kMainFrame";
    case ResourceType::kSubFrame:
      return os << "ResourceType::kSubFrame";
    case ResourceType::kStylesheet:
      return os << "ResourceType::kStylesheet";
    case ResourceType::kScript:
      return os << "ResourceType::kScript";
    case ResourceType::kImage:
      return os << "ResourceType::kImage";
    case ResourceType::kFontResource:
      return os << "ResourceType::kFontResource";
    case ResourceType::kSubResource:
      return os << "ResourceType::kSubResource";
    case ResourceType::kObject:
      return os << "ResourceType::kObject";
    case ResourceType::kMedia:
      return os << "ResourceType::kMedia";
    case ResourceType::kWorker:
      return os << "ResourceType::kWorker";
    case ResourceType::kSharedWorker:
      return os << "ResourceType::kSharedWorker";
    case ResourceType::kPrefetch:
      return os << "ResourceType::kPrefetch";
    case ResourceType::kFavicon:
      return os << "ResourceType::kFavicon";
    case ResourceType::kXhr:
      return os << "ResourceType::kXhr";
    case ResourceType::kPing:
      return os << "ResourceType::kPing";
    case ResourceType::kServiceWorker:
      return os << "ResourceType::kServiceWorker";
    case ResourceType::kCspReport:
      return os << "ResourceType::kCspReport";
    case ResourceType::kPluginResource:
      return os << "ResourceType::kPluginResource";
    case ResourceType::kNavigationPreloadMainFrame:
      return os << "ResourceType::kNavigationPreloadMainFrame";
    case ResourceType::kNavigationPreloadSubFrame:
      return os << "ResourceType::kNavigationPreloadSubFrame";
    default:
      return os << "Unknown ResourceType value: " << static_cast<int32_t>(value);
  }
}

namespace internal {


// static
bool CommonNetworkInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CommonNetworkInfo_Data* object = static_cast<const CommonNetworkInfo_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 24 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->remote_endpoint, validation_context))
    return false;

  return true;
}

CommonNetworkInfo_Data::CommonNetworkInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RedirectInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RedirectInfo_Data* object = static_cast<const RedirectInfo_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 24 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origin_of_new_url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->origin_of_new_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->network_info, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->network_info, validation_context))
    return false;

  return true;
}

RedirectInfo_Data::RedirectInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ResourceLoadInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const ResourceLoadInfo_Data* object = static_cast<const ResourceLoadInfo_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 112 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->final_url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->final_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->referrer, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->referrer, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->original_url, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->original_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->method, 5, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams method_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->method, validation_context,
                                         &method_validate_params)) {
    return false;
  }


  if (!::network::mojom::internal::RequestDestination_Data
        ::Validate(object->request_destination, validation_context))
    return false;


  if (!::network::mojom::internal::RequestPriority_Data
        ::Validate(object->request_priority, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->mime_type, 8, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams mime_type_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->mime_type, validation_context,
                                         &mime_type_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->network_info, 10, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->network_info, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->load_timing_info, 12, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->load_timing_info, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->redirect_info_chain, 15, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams redirect_info_chain_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->redirect_info_chain, validation_context,
                                         &redirect_info_chain_validate_params)) {
    return false;
  }

  return true;
}

ResourceLoadInfo_Data::ResourceLoadInfo_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink