// third_party/blink/public/mojom/input/synchronous_compositor.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_SYNCHRONOUS_COMPOSITOR_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_SYNCHRONOUS_COMPOSITOR_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "third_party/blink/public/mojom/input/synchronous_compositor.mojom-shared-internal.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/viz/public/mojom/compositing/begin_frame_args.mojom-shared.h"
#include "services/viz/public/mojom/compositing/compositor_frame.mojom-shared.h"
#include "services/viz/public/mojom/compositing/compositor_frame_metadata.mojom-shared.h"
#include "services/viz/public/mojom/compositing/frame_timing_details.mojom-shared.h"
#include "services/viz/public/mojom/compositing/returned_resource.mojom-shared.h"
#include "services/viz/public/mojom/hit_test/hit_test_region_list.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/transform.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"


#include "base/component_export.h"




namespace blink {
namespace mojom {
class SyncCompositorDemandDrawHwParamsDataView;

class SyncCompositorDemandDrawSwParamsDataView;

class SyncCompositorCommonRendererParamsDataView;



}  // namespace mojom
}  // namespace blink

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::SyncCompositorDemandDrawHwParamsDataView> {
  using Data = ::blink::mojom::internal::SyncCompositorDemandDrawHwParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::SyncCompositorDemandDrawSwParamsDataView> {
  using Data = ::blink::mojom::internal::SyncCompositorDemandDrawSwParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::SyncCompositorCommonRendererParamsDataView> {
  using Data = ::blink::mojom::internal::SyncCompositorCommonRendererParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink {
namespace mojom {
// Interface base classes. They are used for type safety check.
class SynchronousCompositorInterfaceBase {};

using SynchronousCompositorPtrDataView =
    mojo::InterfacePtrDataView<SynchronousCompositorInterfaceBase>;
using SynchronousCompositorRequestDataView =
    mojo::InterfaceRequestDataView<SynchronousCompositorInterfaceBase>;
using SynchronousCompositorAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SynchronousCompositorInterfaceBase>;
using SynchronousCompositorAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SynchronousCompositorInterfaceBase>;
class SynchronousCompositorHostInterfaceBase {};

using SynchronousCompositorHostPtrDataView =
    mojo::InterfacePtrDataView<SynchronousCompositorHostInterfaceBase>;
using SynchronousCompositorHostRequestDataView =
    mojo::InterfaceRequestDataView<SynchronousCompositorHostInterfaceBase>;
using SynchronousCompositorHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SynchronousCompositorHostInterfaceBase>;
using SynchronousCompositorHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SynchronousCompositorHostInterfaceBase>;
class SynchronousCompositorControlHostInterfaceBase {};

using SynchronousCompositorControlHostPtrDataView =
    mojo::InterfacePtrDataView<SynchronousCompositorControlHostInterfaceBase>;
using SynchronousCompositorControlHostRequestDataView =
    mojo::InterfaceRequestDataView<SynchronousCompositorControlHostInterfaceBase>;
using SynchronousCompositorControlHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SynchronousCompositorControlHostInterfaceBase>;
using SynchronousCompositorControlHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SynchronousCompositorControlHostInterfaceBase>;


class SyncCompositorDemandDrawHwParamsDataView {
 public:
  SyncCompositorDemandDrawHwParamsDataView() {}

  SyncCompositorDemandDrawHwParamsDataView(
      internal::SyncCompositorDemandDrawHwParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetViewportSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadViewportSize(UserType* output) {
    
    auto* pointer = data_->viewport_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, context_);
  }
  inline void GetViewportRectForTilePriorityDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadViewportRectForTilePriority(UserType* output) {
    
    auto* pointer = data_->viewport_rect_for_tile_priority.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, context_);
  }
  inline void GetTransformForTilePriorityDataView(
      ::gfx::mojom::TransformDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadTransformForTilePriority(UserType* output) {
    
    auto* pointer = data_->transform_for_tile_priority.Get();
    return mojo::internal::Deserialize<::gfx::mojom::TransformDataView>(
        pointer, output, context_);
  }
 private:
  internal::SyncCompositorDemandDrawHwParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class SyncCompositorDemandDrawSwParamsDataView {
 public:
  SyncCompositorDemandDrawSwParamsDataView() {}

  SyncCompositorDemandDrawSwParamsDataView(
      internal::SyncCompositorDemandDrawSwParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSize(UserType* output) {
    
    auto* pointer = data_->size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, context_);
  }
  inline void GetClipDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadClip(UserType* output) {
    
    auto* pointer = data_->clip.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, context_);
  }
  inline void GetTransformDataView(
      ::gfx::mojom::TransformDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadTransform(UserType* output) {
    
    auto* pointer = data_->transform.Get();
    return mojo::internal::Deserialize<::gfx::mojom::TransformDataView>(
        pointer, output, context_);
  }
 private:
  internal::SyncCompositorDemandDrawSwParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class SyncCompositorCommonRendererParamsDataView {
 public:
  SyncCompositorCommonRendererParamsDataView() {}

  SyncCompositorCommonRendererParamsDataView(
      internal::SyncCompositorCommonRendererParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  uint32_t version() const {
    return data_->version;
  }
  inline void GetTotalScrollOffsetDataView(
      ::gfx::mojom::ScrollOffsetDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadTotalScrollOffset(UserType* output) {
    
    auto* pointer = data_->total_scroll_offset.Get();
    return mojo::internal::Deserialize<::gfx::mojom::ScrollOffsetDataView>(
        pointer, output, context_);
  }
  inline void GetMaxScrollOffsetDataView(
      ::gfx::mojom::ScrollOffsetDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadMaxScrollOffset(UserType* output) {
    
    auto* pointer = data_->max_scroll_offset.Get();
    return mojo::internal::Deserialize<::gfx::mojom::ScrollOffsetDataView>(
        pointer, output, context_);
  }
  inline void GetScrollableSizeDataView(
      ::gfx::mojom::SizeFDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadScrollableSize(UserType* output) {
    
    auto* pointer = data_->scrollable_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeFDataView>(
        pointer, output, context_);
  }
  float page_scale_factor() const {
    return data_->page_scale_factor;
  }
  float min_page_scale_factor() const {
    return data_->min_page_scale_factor;
  }
  float max_page_scale_factor() const {
    return data_->max_page_scale_factor;
  }
  uint32_t need_invalidate_count() const {
    return data_->need_invalidate_count;
  }
  bool invalidate_needs_draw() const {
    return data_->invalidate_needs_draw;
  }
  uint32_t did_activate_pending_tree_count() const {
    return data_->did_activate_pending_tree_count;
  }
 private:
  internal::SyncCompositorCommonRendererParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace blink

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::SyncCompositorDemandDrawHwParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::SyncCompositorDemandDrawHwParamsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::SyncCompositorDemandDrawHwParams_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::viewport_size(input)) in_viewport_size = Traits::viewport_size(input);
    typename decltype((*output)->viewport_size)::BaseType::BufferWriter
        viewport_size_writer;
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
        in_viewport_size, buffer, &viewport_size_writer, context);
    (*output)->viewport_size.Set(
        viewport_size_writer.is_null() ? nullptr : viewport_size_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->viewport_size.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null viewport_size in SyncCompositorDemandDrawHwParams struct");
    decltype(Traits::viewport_rect_for_tile_priority(input)) in_viewport_rect_for_tile_priority = Traits::viewport_rect_for_tile_priority(input);
    typename decltype((*output)->viewport_rect_for_tile_priority)::BaseType::BufferWriter
        viewport_rect_for_tile_priority_writer;
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
        in_viewport_rect_for_tile_priority, buffer, &viewport_rect_for_tile_priority_writer, context);
    (*output)->viewport_rect_for_tile_priority.Set(
        viewport_rect_for_tile_priority_writer.is_null() ? nullptr : viewport_rect_for_tile_priority_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->viewport_rect_for_tile_priority.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null viewport_rect_for_tile_priority in SyncCompositorDemandDrawHwParams struct");
    decltype(Traits::transform_for_tile_priority(input)) in_transform_for_tile_priority = Traits::transform_for_tile_priority(input);
    typename decltype((*output)->transform_for_tile_priority)::BaseType::BufferWriter
        transform_for_tile_priority_writer;
    mojo::internal::Serialize<::gfx::mojom::TransformDataView>(
        in_transform_for_tile_priority, buffer, &transform_for_tile_priority_writer, context);
    (*output)->transform_for_tile_priority.Set(
        transform_for_tile_priority_writer.is_null() ? nullptr : transform_for_tile_priority_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->transform_for_tile_priority.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null transform_for_tile_priority in SyncCompositorDemandDrawHwParams struct");
  }

  static bool Deserialize(::blink::mojom::internal::SyncCompositorDemandDrawHwParams_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::SyncCompositorDemandDrawHwParamsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::SyncCompositorDemandDrawSwParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::SyncCompositorDemandDrawSwParamsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::SyncCompositorDemandDrawSwParams_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::size(input)) in_size = Traits::size(input);
    typename decltype((*output)->size)::BaseType::BufferWriter
        size_writer;
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
        in_size, buffer, &size_writer, context);
    (*output)->size.Set(
        size_writer.is_null() ? nullptr : size_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->size.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null size in SyncCompositorDemandDrawSwParams struct");
    decltype(Traits::clip(input)) in_clip = Traits::clip(input);
    typename decltype((*output)->clip)::BaseType::BufferWriter
        clip_writer;
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
        in_clip, buffer, &clip_writer, context);
    (*output)->clip.Set(
        clip_writer.is_null() ? nullptr : clip_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->clip.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null clip in SyncCompositorDemandDrawSwParams struct");
    decltype(Traits::transform(input)) in_transform = Traits::transform(input);
    typename decltype((*output)->transform)::BaseType::BufferWriter
        transform_writer;
    mojo::internal::Serialize<::gfx::mojom::TransformDataView>(
        in_transform, buffer, &transform_writer, context);
    (*output)->transform.Set(
        transform_writer.is_null() ? nullptr : transform_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->transform.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null transform in SyncCompositorDemandDrawSwParams struct");
  }

  static bool Deserialize(::blink::mojom::internal::SyncCompositorDemandDrawSwParams_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::SyncCompositorDemandDrawSwParamsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::SyncCompositorCommonRendererParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::SyncCompositorCommonRendererParamsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::SyncCompositorCommonRendererParams_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->version = Traits::version(input);
    decltype(Traits::total_scroll_offset(input)) in_total_scroll_offset = Traits::total_scroll_offset(input);
    typename decltype((*output)->total_scroll_offset)::BaseType::BufferWriter
        total_scroll_offset_writer;
    mojo::internal::Serialize<::gfx::mojom::ScrollOffsetDataView>(
        in_total_scroll_offset, buffer, &total_scroll_offset_writer, context);
    (*output)->total_scroll_offset.Set(
        total_scroll_offset_writer.is_null() ? nullptr : total_scroll_offset_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->total_scroll_offset.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null total_scroll_offset in SyncCompositorCommonRendererParams struct");
    decltype(Traits::max_scroll_offset(input)) in_max_scroll_offset = Traits::max_scroll_offset(input);
    typename decltype((*output)->max_scroll_offset)::BaseType::BufferWriter
        max_scroll_offset_writer;
    mojo::internal::Serialize<::gfx::mojom::ScrollOffsetDataView>(
        in_max_scroll_offset, buffer, &max_scroll_offset_writer, context);
    (*output)->max_scroll_offset.Set(
        max_scroll_offset_writer.is_null() ? nullptr : max_scroll_offset_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->max_scroll_offset.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null max_scroll_offset in SyncCompositorCommonRendererParams struct");
    decltype(Traits::scrollable_size(input)) in_scrollable_size = Traits::scrollable_size(input);
    typename decltype((*output)->scrollable_size)::BaseType::BufferWriter
        scrollable_size_writer;
    mojo::internal::Serialize<::gfx::mojom::SizeFDataView>(
        in_scrollable_size, buffer, &scrollable_size_writer, context);
    (*output)->scrollable_size.Set(
        scrollable_size_writer.is_null() ? nullptr : scrollable_size_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->scrollable_size.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null scrollable_size in SyncCompositorCommonRendererParams struct");
    (*output)->page_scale_factor = Traits::page_scale_factor(input);
    (*output)->min_page_scale_factor = Traits::min_page_scale_factor(input);
    (*output)->max_page_scale_factor = Traits::max_page_scale_factor(input);
    (*output)->need_invalidate_count = Traits::need_invalidate_count(input);
    (*output)->invalidate_needs_draw = Traits::invalidate_needs_draw(input);
    (*output)->did_activate_pending_tree_count = Traits::did_activate_pending_tree_count(input);
  }

  static bool Deserialize(::blink::mojom::internal::SyncCompositorCommonRendererParams_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::SyncCompositorCommonRendererParamsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink {
namespace mojom {

inline void SyncCompositorDemandDrawHwParamsDataView::GetViewportSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->viewport_size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, context_);
}
inline void SyncCompositorDemandDrawHwParamsDataView::GetViewportRectForTilePriorityDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->viewport_rect_for_tile_priority.Get();
  *output = ::gfx::mojom::RectDataView(pointer, context_);
}
inline void SyncCompositorDemandDrawHwParamsDataView::GetTransformForTilePriorityDataView(
    ::gfx::mojom::TransformDataView* output) {
  auto pointer = data_->transform_for_tile_priority.Get();
  *output = ::gfx::mojom::TransformDataView(pointer, context_);
}


inline void SyncCompositorDemandDrawSwParamsDataView::GetSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, context_);
}
inline void SyncCompositorDemandDrawSwParamsDataView::GetClipDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->clip.Get();
  *output = ::gfx::mojom::RectDataView(pointer, context_);
}
inline void SyncCompositorDemandDrawSwParamsDataView::GetTransformDataView(
    ::gfx::mojom::TransformDataView* output) {
  auto pointer = data_->transform.Get();
  *output = ::gfx::mojom::TransformDataView(pointer, context_);
}


inline void SyncCompositorCommonRendererParamsDataView::GetTotalScrollOffsetDataView(
    ::gfx::mojom::ScrollOffsetDataView* output) {
  auto pointer = data_->total_scroll_offset.Get();
  *output = ::gfx::mojom::ScrollOffsetDataView(pointer, context_);
}
inline void SyncCompositorCommonRendererParamsDataView::GetMaxScrollOffsetDataView(
    ::gfx::mojom::ScrollOffsetDataView* output) {
  auto pointer = data_->max_scroll_offset.Get();
  *output = ::gfx::mojom::ScrollOffsetDataView(pointer, context_);
}
inline void SyncCompositorCommonRendererParamsDataView::GetScrollableSizeDataView(
    ::gfx::mojom::SizeFDataView* output) {
  auto pointer = data_->scrollable_size.Get();
  *output = ::gfx::mojom::SizeFDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace blink

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_SYNCHRONOUS_COMPOSITOR_MOJOM_SHARED_H_