// third_party/blink/public/mojom/choosers/popup_menu.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_CHOOSERS_POPUP_MENU_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_CHOOSERS_POPUP_MENU_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "third_party/blink/public/mojom/choosers/popup_menu.mojom-shared-internal.h"
#include "mojo/public/mojom/base/text_direction.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"


#include "base/component_export.h"




namespace blink {
namespace mojom {
class MenuItemDataView;



}  // namespace mojom
}  // namespace blink

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::MenuItemDataView> {
  using Data = ::blink::mojom::internal::MenuItem_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink {
namespace mojom {


enum class MenuItem_Type : int32_t {
  
  kOption = 0,
  
  kCheckableOption = 1,
  
  kGroup = 2,
  
  kSeparator = 3,
  
  kSubMenu = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, MenuItem_Type value);
inline bool IsKnownEnumValue(MenuItem_Type value) {
  return internal::MenuItem_Type_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class PopupMenuClientInterfaceBase {};

using PopupMenuClientPtrDataView =
    mojo::InterfacePtrDataView<PopupMenuClientInterfaceBase>;
using PopupMenuClientRequestDataView =
    mojo::InterfaceRequestDataView<PopupMenuClientInterfaceBase>;
using PopupMenuClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PopupMenuClientInterfaceBase>;
using PopupMenuClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PopupMenuClientInterfaceBase>;


class MenuItemDataView {
 public:
  MenuItemDataView() {}

  MenuItemDataView(
      internal::MenuItem_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadLabel(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `label` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLabel` instead "
    "of `ReadLabel if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetToolTipDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadToolTip(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `tool_tip` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadToolTip` instead "
    "of `ReadToolTip if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->tool_tip.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::blink::mojom::MenuItem_Type>(
        data_value, output);
  }

  MenuItem_Type type() const {
    return static_cast<MenuItem_Type>(data_->type);
  }
  uint32_t action() const {
    return data_->action;
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadTextDirection(UserType* output) const {
    auto data_value = data_->text_direction;
    return mojo::internal::Deserialize<::mojo_base::mojom::TextDirection>(
        data_value, output);
  }

  ::mojo_base::mojom::TextDirection text_direction() const {
    return static_cast<::mojo_base::mojom::TextDirection>(data_->text_direction);
  }
  bool has_text_direction_override() const {
    return data_->has_text_direction_override;
  }
  bool enabled() const {
    return data_->enabled;
  }
  bool checked() const {
    return data_->checked;
  }
 private:
  internal::MenuItem_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace blink

namespace std {

template <>
struct hash<::blink::mojom::MenuItem_Type>
    : public mojo::internal::EnumHashImpl<::blink::mojom::MenuItem_Type> {};

}  // namespace std

namespace mojo {


template <>
struct EnumTraits<::blink::mojom::MenuItem_Type, ::blink::mojom::MenuItem_Type> {
  static ::blink::mojom::MenuItem_Type ToMojom(::blink::mojom::MenuItem_Type input) { return input; }
  static bool FromMojom(::blink::mojom::MenuItem_Type input, ::blink::mojom::MenuItem_Type* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::MenuItem_Type, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::MenuItem_Type, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::blink::mojom::MenuItem_Type>(input), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::MenuItemDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::MenuItemDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::MenuItem_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::label(input)) in_label = Traits::label(input);
    typename decltype((*output)->label)::BaseType::BufferWriter
        label_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_label, buffer, &label_writer, context);
    (*output)->label.Set(
        label_writer.is_null() ? nullptr : label_writer.data());
    decltype(Traits::tool_tip(input)) in_tool_tip = Traits::tool_tip(input);
    typename decltype((*output)->tool_tip)::BaseType::BufferWriter
        tool_tip_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_tool_tip, buffer, &tool_tip_writer, context);
    (*output)->tool_tip.Set(
        tool_tip_writer.is_null() ? nullptr : tool_tip_writer.data());
    mojo::internal::Serialize<::blink::mojom::MenuItem_Type>(
        Traits::type(input), &(*output)->type);
    (*output)->action = Traits::action(input);
    mojo::internal::Serialize<::mojo_base::mojom::TextDirection>(
        Traits::text_direction(input), &(*output)->text_direction);
    (*output)->has_text_direction_override = Traits::has_text_direction_override(input);
    (*output)->enabled = Traits::enabled(input);
    (*output)->checked = Traits::checked(input);
  }

  static bool Deserialize(::blink::mojom::internal::MenuItem_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::MenuItemDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink {
namespace mojom {

inline void MenuItemDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void MenuItemDataView::GetToolTipDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->tool_tip.Get();
  *output = mojo::StringDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace blink

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_CHOOSERS_POPUP_MENU_MOJOM_SHARED_H_