// services/viz/privileged/mojom/viz_main.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PRIVILEGED_MOJOM_VIZ_MAIN_MOJOM_SHARED_H_
#define SERVICES_VIZ_PRIVILEGED_MOJOM_VIZ_MAIN_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "services/viz/privileged/mojom/viz_main.mojom-shared-internal.h"
#include "components/discardable_memory/public/mojom/discardable_shared_memory_manager.mojom-shared.h"
#include "services/network/public/mojom/tcp_socket.mojom-shared.h"
#include "services/viz/public/mojom/compositing/compositing_mode_watcher.mojom-shared.h"
#include "services/viz/privileged/mojom/compositing/frame_sink_manager.mojom-shared.h"
#include "services/viz/privileged/mojom/compositing/renderer_settings.mojom-shared.h"
#include "services/viz/privileged/mojom/gl/gpu_host.mojom-shared.h"
#include "services/viz/privileged/mojom/gl/gpu_service.mojom-shared.h"
#include "ui/gfx/mojom/font_render_params.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"






namespace viz {
namespace mojom {
class FrameSinkManagerParamsDataView;

class VizDevToolsParamsDataView;



}  // namespace mojom
}  // namespace viz

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::viz::mojom::FrameSinkManagerParamsDataView> {
  using Data = ::viz::mojom::internal::FrameSinkManagerParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::viz::mojom::VizDevToolsParamsDataView> {
  using Data = ::viz::mojom::internal::VizDevToolsParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace viz {
namespace mojom {
// Interface base classes. They are used for type safety check.
class VizMainInterfaceBase {};

using VizMainPtrDataView =
    mojo::InterfacePtrDataView<VizMainInterfaceBase>;
using VizMainRequestDataView =
    mojo::InterfaceRequestDataView<VizMainInterfaceBase>;
using VizMainAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<VizMainInterfaceBase>;
using VizMainAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<VizMainInterfaceBase>;


class FrameSinkManagerParamsDataView {
 public:
  FrameSinkManagerParamsDataView() {}

  FrameSinkManagerParamsDataView(
      internal::FrameSinkManagerParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  uint32_t restart_id() const {
    return data_->restart_id;
  }
  bool use_activation_deadline() const {
    return data_->use_activation_deadline;
  }
  uint32_t activation_deadline_in_frames() const {
    return data_->activation_deadline_in_frames;
  }
  template <typename UserType>
  UserType TakeFrameSinkManager() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::viz::mojom::FrameSinkManagerInterfaceBase>>(
            &data_->frame_sink_manager, &result, context_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeFrameSinkManagerClient() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::viz::mojom::FrameSinkManagerClientInterfaceBase>>(
            &data_->frame_sink_manager_client, &result, context_);
    DCHECK(ret);
    return result;
  }
  inline void GetDebugRendererSettingsDataView(
      ::viz::mojom::DebugRendererSettingsDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDebugRendererSettings(UserType* output) {
    
    auto* pointer = data_->debug_renderer_settings.Get();
    return mojo::internal::Deserialize<::viz::mojom::DebugRendererSettingsDataView>(
        pointer, output, context_);
  }
 private:
  internal::FrameSinkManagerParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class VizDevToolsParamsDataView {
 public:
  VizDevToolsParamsDataView() {}

  VizDevToolsParamsDataView(
      internal::VizDevToolsParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeServerSocket() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::TCPServerSocketInterfaceBase>>(
            &data_->server_socket, &result, context_);
    DCHECK(ret);
    return result;
  }
  uint16_t server_port() const {
    return data_->server_port;
  }
 private:
  internal::VizDevToolsParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace viz

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::FrameSinkManagerParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::FrameSinkManagerParamsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::viz::mojom::internal::FrameSinkManagerParams_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->restart_id = Traits::restart_id(input);
    (*output)->use_activation_deadline = Traits::use_activation_deadline(input);
    (*output)->activation_deadline_in_frames = Traits::activation_deadline_in_frames(input);
    decltype(Traits::frame_sink_manager(input)) in_frame_sink_manager = Traits::frame_sink_manager(input);
    mojo::internal::Serialize<mojo::InterfaceRequestDataView<::viz::mojom::FrameSinkManagerInterfaceBase>>(
        in_frame_sink_manager, &(*output)->frame_sink_manager, context);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid((*output)->frame_sink_manager),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid frame_sink_manager in FrameSinkManagerParams struct");
    decltype(Traits::frame_sink_manager_client(input)) in_frame_sink_manager_client = Traits::frame_sink_manager_client(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::viz::mojom::FrameSinkManagerClientInterfaceBase>>(
        in_frame_sink_manager_client, &(*output)->frame_sink_manager_client, context);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid((*output)->frame_sink_manager_client),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid frame_sink_manager_client in FrameSinkManagerParams struct");
    decltype(Traits::debug_renderer_settings(input)) in_debug_renderer_settings = Traits::debug_renderer_settings(input);
    typename decltype((*output)->debug_renderer_settings)::BaseType::BufferWriter
        debug_renderer_settings_writer;
    mojo::internal::Serialize<::viz::mojom::DebugRendererSettingsDataView>(
        in_debug_renderer_settings, buffer, &debug_renderer_settings_writer, context);
    (*output)->debug_renderer_settings.Set(
        debug_renderer_settings_writer.is_null() ? nullptr : debug_renderer_settings_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->debug_renderer_settings.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null debug_renderer_settings in FrameSinkManagerParams struct");
  }

  static bool Deserialize(::viz::mojom::internal::FrameSinkManagerParams_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::FrameSinkManagerParamsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::viz::mojom::VizDevToolsParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::viz::mojom::VizDevToolsParamsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::viz::mojom::internal::VizDevToolsParams_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::server_socket(input)) in_server_socket = Traits::server_socket(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::TCPServerSocketInterfaceBase>>(
        in_server_socket, &(*output)->server_socket, context);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid((*output)->server_socket),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid server_socket in VizDevToolsParams struct");
    (*output)->server_port = Traits::server_port(input);
  }

  static bool Deserialize(::viz::mojom::internal::VizDevToolsParams_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::viz::mojom::VizDevToolsParamsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace viz {
namespace mojom {

inline void FrameSinkManagerParamsDataView::GetDebugRendererSettingsDataView(
    ::viz::mojom::DebugRendererSettingsDataView* output) {
  auto pointer = data_->debug_renderer_settings.Get();
  *output = ::viz::mojom::DebugRendererSettingsDataView(pointer, context_);
}





}  // namespace mojom
}  // namespace viz

#endif  // SERVICES_VIZ_PRIVILEGED_MOJOM_VIZ_MAIN_MOJOM_SHARED_H_