// services/viz/privileged/mojom/gl/gpu_host.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PRIVILEGED_MOJOM_GL_GPU_HOST_MOJOM_PARAMS_DATA_H_
#define SERVICES_VIZ_PRIVILEGED_MOJOM_GL_GPU_HOST_MOJOM_PARAMS_DATA_H_

#include "base/macros.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif
namespace viz {
namespace mojom {
namespace internal {
class  GpuHost_DidInitialize_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(GpuHost_DidInitialize_Params_Data));
      new (data()) GpuHost_DidInitialize_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    GpuHost_DidInitialize_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<GpuHost_DidInitialize_Params_Data>(index_);
    }
    GpuHost_DidInitialize_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::gpu::mojom::internal::GpuInfo_Data> gpu_info;
  mojo::internal::Pointer<::gpu::mojom::internal::GpuFeatureInfo_Data> gpu_feature_info;
  mojo::internal::Pointer<::gpu::mojom::internal::GpuInfo_Data> gpu_info_for_hardware_gpu;
  mojo::internal::Pointer<::gpu::mojom::internal::GpuFeatureInfo_Data> gpu_feature_info_for_hardware_gpu;
  mojo::internal::Pointer<::gpu::mojom::internal::GpuExtraInfo_Data> gpu_extra_info;

 private:
  GpuHost_DidInitialize_Params_Data();
  ~GpuHost_DidInitialize_Params_Data() = delete;
};
static_assert(sizeof(GpuHost_DidInitialize_Params_Data) == 48,
              "Bad sizeof(GpuHost_DidInitialize_Params_Data)");
class  GpuHost_DidFailInitialize_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(GpuHost_DidFailInitialize_Params_Data));
      new (data()) GpuHost_DidFailInitialize_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    GpuHost_DidFailInitialize_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<GpuHost_DidFailInitialize_Params_Data>(index_);
    }
    GpuHost_DidFailInitialize_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  GpuHost_DidFailInitialize_Params_Data();
  ~GpuHost_DidFailInitialize_Params_Data() = delete;
};
static_assert(sizeof(GpuHost_DidFailInitialize_Params_Data) == 8,
              "Bad sizeof(GpuHost_DidFailInitialize_Params_Data)");
class  GpuHost_DidCreateContextSuccessfully_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(GpuHost_DidCreateContextSuccessfully_Params_Data));
      new (data()) GpuHost_DidCreateContextSuccessfully_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    GpuHost_DidCreateContextSuccessfully_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<GpuHost_DidCreateContextSuccessfully_Params_Data>(index_);
    }
    GpuHost_DidCreateContextSuccessfully_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  GpuHost_DidCreateContextSuccessfully_Params_Data();
  ~GpuHost_DidCreateContextSuccessfully_Params_Data() = delete;
};
static_assert(sizeof(GpuHost_DidCreateContextSuccessfully_Params_Data) == 8,
              "Bad sizeof(GpuHost_DidCreateContextSuccessfully_Params_Data)");
class  GpuHost_DidCreateOffscreenContext_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(GpuHost_DidCreateOffscreenContext_Params_Data));
      new (data()) GpuHost_DidCreateOffscreenContext_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    GpuHost_DidCreateOffscreenContext_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<GpuHost_DidCreateOffscreenContext_Params_Data>(index_);
    }
    GpuHost_DidCreateOffscreenContext_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> url;

 private:
  GpuHost_DidCreateOffscreenContext_Params_Data();
  ~GpuHost_DidCreateOffscreenContext_Params_Data() = delete;
};
static_assert(sizeof(GpuHost_DidCreateOffscreenContext_Params_Data) == 16,
              "Bad sizeof(GpuHost_DidCreateOffscreenContext_Params_Data)");
class  GpuHost_DidDestroyOffscreenContext_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(GpuHost_DidDestroyOffscreenContext_Params_Data));
      new (data()) GpuHost_DidDestroyOffscreenContext_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    GpuHost_DidDestroyOffscreenContext_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<GpuHost_DidDestroyOffscreenContext_Params_Data>(index_);
    }
    GpuHost_DidDestroyOffscreenContext_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> url;

 private:
  GpuHost_DidDestroyOffscreenContext_Params_Data();
  ~GpuHost_DidDestroyOffscreenContext_Params_Data() = delete;
};
static_assert(sizeof(GpuHost_DidDestroyOffscreenContext_Params_Data) == 16,
              "Bad sizeof(GpuHost_DidDestroyOffscreenContext_Params_Data)");
class  GpuHost_DidDestroyChannel_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(GpuHost_DidDestroyChannel_Params_Data));
      new (data()) GpuHost_DidDestroyChannel_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    GpuHost_DidDestroyChannel_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<GpuHost_DidDestroyChannel_Params_Data>(index_);
    }
    GpuHost_DidDestroyChannel_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t client_id;
  uint8_t padfinal_[4];

 private:
  GpuHost_DidDestroyChannel_Params_Data();
  ~GpuHost_DidDestroyChannel_Params_Data() = delete;
};
static_assert(sizeof(GpuHost_DidDestroyChannel_Params_Data) == 16,
              "Bad sizeof(GpuHost_DidDestroyChannel_Params_Data)");
class  GpuHost_DidDestroyAllChannels_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(GpuHost_DidDestroyAllChannels_Params_Data));
      new (data()) GpuHost_DidDestroyAllChannels_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    GpuHost_DidDestroyAllChannels_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<GpuHost_DidDestroyAllChannels_Params_Data>(index_);
    }
    GpuHost_DidDestroyAllChannels_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  GpuHost_DidDestroyAllChannels_Params_Data();
  ~GpuHost_DidDestroyAllChannels_Params_Data() = delete;
};
static_assert(sizeof(GpuHost_DidDestroyAllChannels_Params_Data) == 8,
              "Bad sizeof(GpuHost_DidDestroyAllChannels_Params_Data)");
class  GpuHost_DidLoseContext_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(GpuHost_DidLoseContext_Params_Data));
      new (data()) GpuHost_DidLoseContext_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    GpuHost_DidLoseContext_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<GpuHost_DidLoseContext_Params_Data>(index_);
    }
    GpuHost_DidLoseContext_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t offscreen : 1;
  uint8_t pad0_[3];
  int32_t reason;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> active_url;

 private:
  GpuHost_DidLoseContext_Params_Data();
  ~GpuHost_DidLoseContext_Params_Data() = delete;
};
static_assert(sizeof(GpuHost_DidLoseContext_Params_Data) == 24,
              "Bad sizeof(GpuHost_DidLoseContext_Params_Data)");
class  GpuHost_DisableGpuCompositing_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(GpuHost_DisableGpuCompositing_Params_Data));
      new (data()) GpuHost_DisableGpuCompositing_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    GpuHost_DisableGpuCompositing_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<GpuHost_DisableGpuCompositing_Params_Data>(index_);
    }
    GpuHost_DisableGpuCompositing_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  GpuHost_DisableGpuCompositing_Params_Data();
  ~GpuHost_DisableGpuCompositing_Params_Data() = delete;
};
static_assert(sizeof(GpuHost_DisableGpuCompositing_Params_Data) == 8,
              "Bad sizeof(GpuHost_DisableGpuCompositing_Params_Data)");
class  GpuHost_StoreShaderToDisk_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(GpuHost_StoreShaderToDisk_Params_Data));
      new (data()) GpuHost_StoreShaderToDisk_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    GpuHost_StoreShaderToDisk_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<GpuHost_StoreShaderToDisk_Params_Data>(index_);
    }
    GpuHost_StoreShaderToDisk_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t client_id;
  uint8_t pad0_[4];
  mojo::internal::Pointer<mojo::internal::String_Data> key;
  mojo::internal::Pointer<mojo::internal::String_Data> shader;

 private:
  GpuHost_StoreShaderToDisk_Params_Data();
  ~GpuHost_StoreShaderToDisk_Params_Data() = delete;
};
static_assert(sizeof(GpuHost_StoreShaderToDisk_Params_Data) == 32,
              "Bad sizeof(GpuHost_StoreShaderToDisk_Params_Data)");
class  GpuHost_RecordLogMessage_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(GpuHost_RecordLogMessage_Params_Data));
      new (data()) GpuHost_RecordLogMessage_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    GpuHost_RecordLogMessage_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<GpuHost_RecordLogMessage_Params_Data>(index_);
    }
    GpuHost_RecordLogMessage_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t severity;
  uint8_t pad0_[4];
  mojo::internal::Pointer<mojo::internal::String_Data> header;
  mojo::internal::Pointer<mojo::internal::String_Data> message;

 private:
  GpuHost_RecordLogMessage_Params_Data();
  ~GpuHost_RecordLogMessage_Params_Data() = delete;
};
static_assert(sizeof(GpuHost_RecordLogMessage_Params_Data) == 32,
              "Bad sizeof(GpuHost_RecordLogMessage_Params_Data)");

}  // namespace internal


class GpuHost_DidInitialize_ParamsDataView {
 public:
  GpuHost_DidInitialize_ParamsDataView() {}

  GpuHost_DidInitialize_ParamsDataView(
      internal::GpuHost_DidInitialize_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetGpuInfoDataView(
      ::gpu::mojom::GpuInfoDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadGpuInfo(UserType* output) {
    
    auto* pointer = data_->gpu_info.Get();
    return mojo::internal::Deserialize<::gpu::mojom::GpuInfoDataView>(
        pointer, output, context_);
  }
  inline void GetGpuFeatureInfoDataView(
      ::gpu::mojom::GpuFeatureInfoDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadGpuFeatureInfo(UserType* output) {
    
    auto* pointer = data_->gpu_feature_info.Get();
    return mojo::internal::Deserialize<::gpu::mojom::GpuFeatureInfoDataView>(
        pointer, output, context_);
  }
  inline void GetGpuInfoForHardwareGpuDataView(
      ::gpu::mojom::GpuInfoDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadGpuInfoForHardwareGpu(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gpu::mojom::GpuInfoDataView, UserType>(),
    "Attempting to read the optional `gpu_info_for_hardware_gpu` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadGpuInfoForHardwareGpu` instead "
    "of `ReadGpuInfoForHardwareGpu if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->gpu_info_for_hardware_gpu.Get();
    return mojo::internal::Deserialize<::gpu::mojom::GpuInfoDataView>(
        pointer, output, context_);
  }
  inline void GetGpuFeatureInfoForHardwareGpuDataView(
      ::gpu::mojom::GpuFeatureInfoDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadGpuFeatureInfoForHardwareGpu(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gpu::mojom::GpuFeatureInfoDataView, UserType>(),
    "Attempting to read the optional `gpu_feature_info_for_hardware_gpu` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadGpuFeatureInfoForHardwareGpu` instead "
    "of `ReadGpuFeatureInfoForHardwareGpu if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->gpu_feature_info_for_hardware_gpu.Get();
    return mojo::internal::Deserialize<::gpu::mojom::GpuFeatureInfoDataView>(
        pointer, output, context_);
  }
  inline void GetGpuExtraInfoDataView(
      ::gpu::mojom::GpuExtraInfoDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadGpuExtraInfo(UserType* output) {
    
    auto* pointer = data_->gpu_extra_info.Get();
    return mojo::internal::Deserialize<::gpu::mojom::GpuExtraInfoDataView>(
        pointer, output, context_);
  }
 private:
  internal::GpuHost_DidInitialize_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class GpuHost_DidFailInitialize_ParamsDataView {
 public:
  GpuHost_DidFailInitialize_ParamsDataView() {}

  GpuHost_DidFailInitialize_ParamsDataView(
      internal::GpuHost_DidFailInitialize_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::GpuHost_DidFailInitialize_Params_Data* data_ = nullptr;
};



class GpuHost_DidCreateContextSuccessfully_ParamsDataView {
 public:
  GpuHost_DidCreateContextSuccessfully_ParamsDataView() {}

  GpuHost_DidCreateContextSuccessfully_ParamsDataView(
      internal::GpuHost_DidCreateContextSuccessfully_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::GpuHost_DidCreateContextSuccessfully_Params_Data* data_ = nullptr;
};



class GpuHost_DidCreateOffscreenContext_ParamsDataView {
 public:
  GpuHost_DidCreateOffscreenContext_ParamsDataView() {}

  GpuHost_DidCreateOffscreenContext_ParamsDataView(
      internal::GpuHost_DidCreateOffscreenContext_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, context_);
  }
 private:
  internal::GpuHost_DidCreateOffscreenContext_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class GpuHost_DidDestroyOffscreenContext_ParamsDataView {
 public:
  GpuHost_DidDestroyOffscreenContext_ParamsDataView() {}

  GpuHost_DidDestroyOffscreenContext_ParamsDataView(
      internal::GpuHost_DidDestroyOffscreenContext_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, context_);
  }
 private:
  internal::GpuHost_DidDestroyOffscreenContext_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class GpuHost_DidDestroyChannel_ParamsDataView {
 public:
  GpuHost_DidDestroyChannel_ParamsDataView() {}

  GpuHost_DidDestroyChannel_ParamsDataView(
      internal::GpuHost_DidDestroyChannel_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t client_id() const {
    return data_->client_id;
  }
 private:
  internal::GpuHost_DidDestroyChannel_Params_Data* data_ = nullptr;
};



class GpuHost_DidDestroyAllChannels_ParamsDataView {
 public:
  GpuHost_DidDestroyAllChannels_ParamsDataView() {}

  GpuHost_DidDestroyAllChannels_ParamsDataView(
      internal::GpuHost_DidDestroyAllChannels_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::GpuHost_DidDestroyAllChannels_Params_Data* data_ = nullptr;
};



class GpuHost_DidLoseContext_ParamsDataView {
 public:
  GpuHost_DidLoseContext_ParamsDataView() {}

  GpuHost_DidLoseContext_ParamsDataView(
      internal::GpuHost_DidLoseContext_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  bool offscreen() const {
    return data_->offscreen;
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadReason(UserType* output) const {
    auto data_value = data_->reason;
    return mojo::internal::Deserialize<::viz::mojom::ContextLostReason>(
        data_value, output);
  }

  ::viz::mojom::ContextLostReason reason() const {
    return static_cast<::viz::mojom::ContextLostReason>(data_->reason);
  }
  inline void GetActiveUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadActiveUrl(UserType* output) {
    
    auto* pointer = data_->active_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, context_);
  }
 private:
  internal::GpuHost_DidLoseContext_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class GpuHost_DisableGpuCompositing_ParamsDataView {
 public:
  GpuHost_DisableGpuCompositing_ParamsDataView() {}

  GpuHost_DisableGpuCompositing_ParamsDataView(
      internal::GpuHost_DisableGpuCompositing_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::GpuHost_DisableGpuCompositing_Params_Data* data_ = nullptr;
};



class GpuHost_StoreShaderToDisk_ParamsDataView {
 public:
  GpuHost_StoreShaderToDisk_ParamsDataView() {}

  GpuHost_StoreShaderToDisk_ParamsDataView(
      internal::GpuHost_StoreShaderToDisk_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  int32_t client_id() const {
    return data_->client_id;
  }
  inline void GetKeyDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadKey(UserType* output) {
    
    auto* pointer = data_->key.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetShaderDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadShader(UserType* output) {
    
    auto* pointer = data_->shader.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
 private:
  internal::GpuHost_StoreShaderToDisk_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class GpuHost_RecordLogMessage_ParamsDataView {
 public:
  GpuHost_RecordLogMessage_ParamsDataView() {}

  GpuHost_RecordLogMessage_ParamsDataView(
      internal::GpuHost_RecordLogMessage_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  int32_t severity() const {
    return data_->severity;
  }
  inline void GetHeaderDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadHeader(UserType* output) {
    
    auto* pointer = data_->header.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetMessageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadMessage(UserType* output) {
    
    auto* pointer = data_->message.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
 private:
  internal::GpuHost_RecordLogMessage_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};


inline void GpuHost_DidInitialize_ParamsDataView::GetGpuInfoDataView(
    ::gpu::mojom::GpuInfoDataView* output) {
  auto pointer = data_->gpu_info.Get();
  *output = ::gpu::mojom::GpuInfoDataView(pointer, context_);
}
inline void GpuHost_DidInitialize_ParamsDataView::GetGpuFeatureInfoDataView(
    ::gpu::mojom::GpuFeatureInfoDataView* output) {
  auto pointer = data_->gpu_feature_info.Get();
  *output = ::gpu::mojom::GpuFeatureInfoDataView(pointer, context_);
}
inline void GpuHost_DidInitialize_ParamsDataView::GetGpuInfoForHardwareGpuDataView(
    ::gpu::mojom::GpuInfoDataView* output) {
  auto pointer = data_->gpu_info_for_hardware_gpu.Get();
  *output = ::gpu::mojom::GpuInfoDataView(pointer, context_);
}
inline void GpuHost_DidInitialize_ParamsDataView::GetGpuFeatureInfoForHardwareGpuDataView(
    ::gpu::mojom::GpuFeatureInfoDataView* output) {
  auto pointer = data_->gpu_feature_info_for_hardware_gpu.Get();
  *output = ::gpu::mojom::GpuFeatureInfoDataView(pointer, context_);
}
inline void GpuHost_DidInitialize_ParamsDataView::GetGpuExtraInfoDataView(
    ::gpu::mojom::GpuExtraInfoDataView* output) {
  auto pointer = data_->gpu_extra_info.Get();
  *output = ::gpu::mojom::GpuExtraInfoDataView(pointer, context_);
}






inline void GpuHost_DidCreateOffscreenContext_ParamsDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, context_);
}


inline void GpuHost_DidDestroyOffscreenContext_ParamsDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, context_);
}






inline void GpuHost_DidLoseContext_ParamsDataView::GetActiveUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->active_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, context_);
}




inline void GpuHost_StoreShaderToDisk_ParamsDataView::GetKeyDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->key.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void GpuHost_StoreShaderToDisk_ParamsDataView::GetShaderDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->shader.Get();
  *output = mojo::StringDataView(pointer, context_);
}


inline void GpuHost_RecordLogMessage_ParamsDataView::GetHeaderDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->header.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void GpuHost_RecordLogMessage_ParamsDataView::GetMessageDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->message.Get();
  *output = mojo::StringDataView(pointer, context_);
}

}  // namespace mojom
}  // namespace viz

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // SERVICES_VIZ_PRIVILEGED_MOJOM_GL_GPU_HOST_MOJOM_PARAMS_DATA_H_