// services/network/public/mojom/trust_tokens.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/trust_tokens.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/network/public/mojom/trust_tokens.mojom-params-data.h"
#include "services/network/public/mojom/trust_tokens.mojom-shared-message-ids.h"

#include "services/network/public/mojom/trust_tokens.mojom-import-headers.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_TRUST_TOKENS_MOJOM_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_TRUST_TOKENS_MOJOM_JUMBO_H_
#endif
namespace network {
namespace mojom {
TrustTokenParams::TrustTokenParams()
    : type(),
      refresh_policy(TrustTokenRefreshPolicy::kUseCached),
      sign_request_data(TrustTokenSignRequestData::kOmit),
      include_timestamp_header(false),
      issuers(),
      additional_signed_headers(),
      possibly_unsafe_additional_signing_data() {}

TrustTokenParams::TrustTokenParams(
    TrustTokenOperationType type_in,
    TrustTokenRefreshPolicy refresh_policy_in,
    TrustTokenSignRequestData sign_request_data_in,
    bool include_timestamp_header_in,
    std::vector<::url::Origin> issuers_in,
    std::vector<std::string> additional_signed_headers_in,
    const base::Optional<std::string>& possibly_unsafe_additional_signing_data_in)
    : type(std::move(type_in)),
      refresh_policy(std::move(refresh_policy_in)),
      sign_request_data(std::move(sign_request_data_in)),
      include_timestamp_header(std::move(include_timestamp_header_in)),
      issuers(std::move(issuers_in)),
      additional_signed_headers(std::move(additional_signed_headers_in)),
      possibly_unsafe_additional_signing_data(std::move(possibly_unsafe_additional_signing_data_in)) {}

TrustTokenParams::~TrustTokenParams() = default;

void TrustTokenParams::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("type", base::trace_event::ValueToString(this->type));
  value->SetString("refresh_policy", base::trace_event::ValueToString(this->refresh_policy));
  value->SetString("sign_request_data", base::trace_event::ValueToString(this->sign_request_data));
  value->SetBoolean("include_timestamp_header", this->include_timestamp_header);
  value->BeginArray("issuers");
  for (const auto& item0 : this->issuers) {
    value->AppendString(base::trace_event::ValueToString(item0, "<value of type const ::url::Origin&>"));
  }
  value->EndArray();
  value->BeginArray("additional_signed_headers");
  for (const auto& item0 : this->additional_signed_headers) {
    value->AppendString(item0);
  }
  value->EndArray();
  if (this->possibly_unsafe_additional_signing_data.has_value()) {
    value->SetString("possibly_unsafe_additional_signing_data", this->possibly_unsafe_additional_signing_data.value());
  } else {
    value->SetString("possibly_unsafe_additional_signing_data", "base::nullopt");
  }
}

bool TrustTokenParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
HasTrustTokensResult::HasTrustTokensResult()
    : status(),
      has_trust_tokens() {}

HasTrustTokensResult::HasTrustTokensResult(
    TrustTokenOperationStatus status_in,
    bool has_trust_tokens_in)
    : status(std::move(status_in)),
      has_trust_tokens(std::move(has_trust_tokens_in)) {}

HasTrustTokensResult::~HasTrustTokensResult() = default;
size_t HasTrustTokensResult::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->status);
  seed = mojo::internal::Hash(seed, this->has_trust_tokens);
  return seed;
}

void HasTrustTokensResult::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("status", base::trace_event::ValueToString(this->status));
  value->SetBoolean("has_trust_tokens", this->has_trust_tokens);
}

bool HasTrustTokensResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TrustTokenVerificationKey::TrustTokenVerificationKey()
    : body(),
      expiry() {}

TrustTokenVerificationKey::TrustTokenVerificationKey(
    const std::string& body_in,
    ::base::Time expiry_in)
    : body(std::move(body_in)),
      expiry(std::move(expiry_in)) {}

TrustTokenVerificationKey::~TrustTokenVerificationKey() = default;

void TrustTokenVerificationKey::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("body", this->body);
  value->SetString("expiry", base::trace_event::ValueToString(this->expiry, "<value of type ::base::Time>"));
}

bool TrustTokenVerificationKey::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TrustTokenKeyCommitmentResult::TrustTokenKeyCommitmentResult()
    : batch_size(),
      keys(),
      signed_redemption_record_verification_key() {}

TrustTokenKeyCommitmentResult::TrustTokenKeyCommitmentResult(
    int32_t batch_size_in,
    std::vector<TrustTokenVerificationKeyPtr> keys_in,
    const std::string& signed_redemption_record_verification_key_in)
    : batch_size(std::move(batch_size_in)),
      keys(std::move(keys_in)),
      signed_redemption_record_verification_key(std::move(signed_redemption_record_verification_key_in)) {}

TrustTokenKeyCommitmentResult::~TrustTokenKeyCommitmentResult() = default;

void TrustTokenKeyCommitmentResult::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetInteger("batch_size", this->batch_size);
  value->BeginArray("keys");
  for (const auto& item0 : this->keys) {
    if (item0.is_null()) {
      value->AppendString("nullptr");
    } else {
      value->BeginDictionary();
      item0->AsValueInto(value);
      value->EndDictionary();
    }
  }
  value->EndArray();
  value->SetString("signed_redemption_record_verification_key", this->signed_redemption_record_verification_key);
}

bool TrustTokenKeyCommitmentResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char HasTrustTokensAnswerer::Name_[] = "network.mojom.HasTrustTokensAnswerer";

class HasTrustTokensAnswerer_HasTrustTokens_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  HasTrustTokensAnswerer_HasTrustTokens_ForwardToCallback(
      HasTrustTokensAnswerer::HasTrustTokensCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  HasTrustTokensAnswerer::HasTrustTokensCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(HasTrustTokensAnswerer_HasTrustTokens_ForwardToCallback);
};

HasTrustTokensAnswererProxy::HasTrustTokensAnswererProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void HasTrustTokensAnswererProxy::HasTrustTokens(
    const ::url::Origin& in_issuer, HasTrustTokensCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::HasTrustTokensAnswerer::HasTrustTokens", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("issuer", base::trace_event::ValueToString(in_issuer, "<value of type const ::url::Origin&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kHasTrustTokensAnswerer_HasTrustTokens_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::HasTrustTokensAnswerer_HasTrustTokens_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->issuer)::BaseType::BufferWriter
      issuer_writer;
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_issuer, buffer, &issuer_writer, &serialization_context);
  params->issuer.Set(
      issuer_writer.is_null() ? nullptr : issuer_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->issuer.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null issuer in HasTrustTokensAnswerer.HasTrustTokens request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HasTrustTokensAnswerer::Name_);
  message.set_method_name("HasTrustTokens");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new HasTrustTokensAnswerer_HasTrustTokens_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class HasTrustTokensAnswerer_HasTrustTokens_ProxyToResponder {
 public:
  static HasTrustTokensAnswerer::HasTrustTokensCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<HasTrustTokensAnswerer_HasTrustTokens_ProxyToResponder> proxy(
        new HasTrustTokensAnswerer_HasTrustTokens_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&HasTrustTokensAnswerer_HasTrustTokens_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~HasTrustTokensAnswerer_HasTrustTokens_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  HasTrustTokensAnswerer_HasTrustTokens_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "HasTrustTokensAnswerer::HasTrustTokensCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      HasTrustTokensResultPtr in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(HasTrustTokensAnswerer_HasTrustTokens_ProxyToResponder);
};

bool HasTrustTokensAnswerer_HasTrustTokens_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::HasTrustTokensAnswerer::HasTrustTokensCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::HasTrustTokensAnswerer_HasTrustTokens_ResponseParams_Data* params =
      reinterpret_cast<
          internal::HasTrustTokensAnswerer_HasTrustTokens_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  HasTrustTokensResultPtr p_result{};
  HasTrustTokensAnswerer_HasTrustTokens_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        HasTrustTokensAnswerer::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void HasTrustTokensAnswerer_HasTrustTokens_ProxyToResponder::Run(
    HasTrustTokensResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::HasTrustTokensAnswerer::HasTrustTokensCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_result.is_null()) {
        raw_value->SetString("result", "nullptr");
      } else {
        raw_value->BeginDictionary("result");
        in_result->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kHasTrustTokensAnswerer_HasTrustTokens_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::HasTrustTokensAnswerer_HasTrustTokens_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->result)::BaseType::BufferWriter
      result_writer;
  mojo::internal::Serialize<::network::mojom::HasTrustTokensResultDataView>(
      in_result, buffer, &result_writer, &serialization_context);
  params->result.Set(
      result_writer.is_null() ? nullptr : result_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::HasTrustTokensAnswerer::HasTrustTokensCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HasTrustTokensAnswerer::Name_);
  message.set_method_name("HasTrustTokens");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool HasTrustTokensAnswererStubDispatch::Accept(
    HasTrustTokensAnswerer* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kHasTrustTokensAnswerer_HasTrustTokens_Name: {
      break;
    }
  }
  return false;
}

// static
bool HasTrustTokensAnswererStubDispatch::AcceptWithResponder(
    HasTrustTokensAnswerer* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kHasTrustTokensAnswerer_HasTrustTokens_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::HasTrustTokensAnswerer::HasTrustTokens",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::HasTrustTokensAnswerer::HasTrustTokens");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::HasTrustTokensAnswerer_HasTrustTokens_Params_Data* params =
          reinterpret_cast<
              internal::HasTrustTokensAnswerer_HasTrustTokens_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::url::Origin p_issuer{};
      HasTrustTokensAnswerer_HasTrustTokens_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadIssuer(&p_issuer))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            HasTrustTokensAnswerer::Name_, 0, false);
        return false;
      }
      HasTrustTokensAnswerer::HasTrustTokensCallback callback =
          HasTrustTokensAnswerer_HasTrustTokens_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HasTrustTokens(
std::move(p_issuer), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kHasTrustTokensAnswererValidationInfo[] = {
    {internal::kHasTrustTokensAnswerer_HasTrustTokens_Name,
     {&internal::HasTrustTokensAnswerer_HasTrustTokens_Params_Data::Validate,
      &internal::HasTrustTokensAnswerer_HasTrustTokens_ResponseParams_Data::Validate}},
};

bool HasTrustTokensAnswererRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::HasTrustTokensAnswerer::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kHasTrustTokensAnswererValidationInfo);
}

bool HasTrustTokensAnswererResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::HasTrustTokensAnswerer::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kHasTrustTokensAnswererValidationInfo);

}
}  // namespace mojom
}  // namespace network

namespace mojo {


// static
bool StructTraits<::network::mojom::TrustTokenParams::DataView, ::network::mojom::TrustTokenParamsPtr>::Read(
    ::network::mojom::TrustTokenParams::DataView input,
    ::network::mojom::TrustTokenParamsPtr* output) {
  bool success = true;
  ::network::mojom::TrustTokenParamsPtr result(::network::mojom::TrustTokenParams::New());
  
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadRefreshPolicy(&result->refresh_policy))
        success = false;
      if (success && !input.ReadSignRequestData(&result->sign_request_data))
        success = false;
      if (success)
        result->include_timestamp_header = input.include_timestamp_header();
      if (success && !input.ReadIssuers(&result->issuers))
        success = false;
      if (success && !input.ReadAdditionalSignedHeaders(&result->additional_signed_headers))
        success = false;
      if (success && !input.ReadPossiblyUnsafeAdditionalSigningData(&result->possibly_unsafe_additional_signing_data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::HasTrustTokensResult::DataView, ::network::mojom::HasTrustTokensResultPtr>::Read(
    ::network::mojom::HasTrustTokensResult::DataView input,
    ::network::mojom::HasTrustTokensResultPtr* output) {
  bool success = true;
  ::network::mojom::HasTrustTokensResultPtr result(::network::mojom::HasTrustTokensResult::New());
  
      if (success && !input.ReadStatus(&result->status))
        success = false;
      if (success)
        result->has_trust_tokens = input.has_trust_tokens();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::TrustTokenVerificationKey::DataView, ::network::mojom::TrustTokenVerificationKeyPtr>::Read(
    ::network::mojom::TrustTokenVerificationKey::DataView input,
    ::network::mojom::TrustTokenVerificationKeyPtr* output) {
  bool success = true;
  ::network::mojom::TrustTokenVerificationKeyPtr result(::network::mojom::TrustTokenVerificationKey::New());
  
      if (success && !input.ReadBody(&result->body))
        success = false;
      if (success && !input.ReadExpiry(&result->expiry))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::TrustTokenKeyCommitmentResult::DataView, ::network::mojom::TrustTokenKeyCommitmentResultPtr>::Read(
    ::network::mojom::TrustTokenKeyCommitmentResult::DataView input,
    ::network::mojom::TrustTokenKeyCommitmentResultPtr* output) {
  bool success = true;
  ::network::mojom::TrustTokenKeyCommitmentResultPtr result(::network::mojom::TrustTokenKeyCommitmentResult::New());
  
      if (success)
        result->batch_size = input.batch_size();
      if (success && !input.ReadKeys(&result->keys))
        success = false;
      if (success && !input.ReadSignedRedemptionRecordVerificationKey(&result->signed_redemption_record_verification_key))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif