// content/common/render_message_filter.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_RENDER_MESSAGE_FILTER_MOJOM_PARAMS_DATA_H_
#define CONTENT_COMMON_RENDER_MESSAGE_FILTER_MOJOM_PARAMS_DATA_H_

#include "base/macros.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif
namespace content {
namespace mojom {
namespace internal {
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) RenderMessageFilter_GenerateRoutingID_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(RenderMessageFilter_GenerateRoutingID_Params_Data));
      new (data()) RenderMessageFilter_GenerateRoutingID_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    RenderMessageFilter_GenerateRoutingID_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<RenderMessageFilter_GenerateRoutingID_Params_Data>(index_);
    }
    RenderMessageFilter_GenerateRoutingID_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  RenderMessageFilter_GenerateRoutingID_Params_Data();
  ~RenderMessageFilter_GenerateRoutingID_Params_Data() = delete;
};
static_assert(sizeof(RenderMessageFilter_GenerateRoutingID_Params_Data) == 8,
              "Bad sizeof(RenderMessageFilter_GenerateRoutingID_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) RenderMessageFilter_GenerateRoutingID_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(RenderMessageFilter_GenerateRoutingID_ResponseParams_Data));
      new (data()) RenderMessageFilter_GenerateRoutingID_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    RenderMessageFilter_GenerateRoutingID_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<RenderMessageFilter_GenerateRoutingID_ResponseParams_Data>(index_);
    }
    RenderMessageFilter_GenerateRoutingID_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t routing_id;
  uint8_t padfinal_[4];

 private:
  RenderMessageFilter_GenerateRoutingID_ResponseParams_Data();
  ~RenderMessageFilter_GenerateRoutingID_ResponseParams_Data() = delete;
};
static_assert(sizeof(RenderMessageFilter_GenerateRoutingID_ResponseParams_Data) == 16,
              "Bad sizeof(RenderMessageFilter_GenerateRoutingID_ResponseParams_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) RenderMessageFilter_HasGpuProcess_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(RenderMessageFilter_HasGpuProcess_Params_Data));
      new (data()) RenderMessageFilter_HasGpuProcess_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    RenderMessageFilter_HasGpuProcess_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<RenderMessageFilter_HasGpuProcess_Params_Data>(index_);
    }
    RenderMessageFilter_HasGpuProcess_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  RenderMessageFilter_HasGpuProcess_Params_Data();
  ~RenderMessageFilter_HasGpuProcess_Params_Data() = delete;
};
static_assert(sizeof(RenderMessageFilter_HasGpuProcess_Params_Data) == 8,
              "Bad sizeof(RenderMessageFilter_HasGpuProcess_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) RenderMessageFilter_HasGpuProcess_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(RenderMessageFilter_HasGpuProcess_ResponseParams_Data));
      new (data()) RenderMessageFilter_HasGpuProcess_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    RenderMessageFilter_HasGpuProcess_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<RenderMessageFilter_HasGpuProcess_ResponseParams_Data>(index_);
    }
    RenderMessageFilter_HasGpuProcess_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t has_gpu_process : 1;
  uint8_t padfinal_[7];

 private:
  RenderMessageFilter_HasGpuProcess_ResponseParams_Data();
  ~RenderMessageFilter_HasGpuProcess_ResponseParams_Data() = delete;
};
static_assert(sizeof(RenderMessageFilter_HasGpuProcess_ResponseParams_Data) == 16,
              "Bad sizeof(RenderMessageFilter_HasGpuProcess_ResponseParams_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) RenderMessageFilter_SetThreadPriority_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(RenderMessageFilter_SetThreadPriority_Params_Data));
      new (data()) RenderMessageFilter_SetThreadPriority_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    RenderMessageFilter_SetThreadPriority_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<RenderMessageFilter_SetThreadPriority_Params_Data>(index_);
    }
    RenderMessageFilter_SetThreadPriority_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t platform_thread_id;
  int32_t thread_priority;

 private:
  RenderMessageFilter_SetThreadPriority_Params_Data();
  ~RenderMessageFilter_SetThreadPriority_Params_Data() = delete;
};
static_assert(sizeof(RenderMessageFilter_SetThreadPriority_Params_Data) == 16,
              "Bad sizeof(RenderMessageFilter_SetThreadPriority_Params_Data)");

}  // namespace internal


class RenderMessageFilter_GenerateRoutingID_ParamsDataView {
 public:
  RenderMessageFilter_GenerateRoutingID_ParamsDataView() {}

  RenderMessageFilter_GenerateRoutingID_ParamsDataView(
      internal::RenderMessageFilter_GenerateRoutingID_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::RenderMessageFilter_GenerateRoutingID_Params_Data* data_ = nullptr;
};



class RenderMessageFilter_GenerateRoutingID_ResponseParamsDataView {
 public:
  RenderMessageFilter_GenerateRoutingID_ResponseParamsDataView() {}

  RenderMessageFilter_GenerateRoutingID_ResponseParamsDataView(
      internal::RenderMessageFilter_GenerateRoutingID_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t routing_id() const {
    return data_->routing_id;
  }
 private:
  internal::RenderMessageFilter_GenerateRoutingID_ResponseParams_Data* data_ = nullptr;
};



class RenderMessageFilter_HasGpuProcess_ParamsDataView {
 public:
  RenderMessageFilter_HasGpuProcess_ParamsDataView() {}

  RenderMessageFilter_HasGpuProcess_ParamsDataView(
      internal::RenderMessageFilter_HasGpuProcess_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::RenderMessageFilter_HasGpuProcess_Params_Data* data_ = nullptr;
};



class RenderMessageFilter_HasGpuProcess_ResponseParamsDataView {
 public:
  RenderMessageFilter_HasGpuProcess_ResponseParamsDataView() {}

  RenderMessageFilter_HasGpuProcess_ResponseParamsDataView(
      internal::RenderMessageFilter_HasGpuProcess_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool has_gpu_process() const {
    return data_->has_gpu_process;
  }
 private:
  internal::RenderMessageFilter_HasGpuProcess_ResponseParams_Data* data_ = nullptr;
};



class RenderMessageFilter_SetThreadPriority_ParamsDataView {
 public:
  RenderMessageFilter_SetThreadPriority_ParamsDataView() {}

  RenderMessageFilter_SetThreadPriority_ParamsDataView(
      internal::RenderMessageFilter_SetThreadPriority_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t platform_thread_id() const {
    return data_->platform_thread_id;
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadThreadPriority(UserType* output) const {
    auto data_value = data_->thread_priority;
    return mojo::internal::Deserialize<::mojo_base::mojom::ThreadPriority>(
        data_value, output);
  }

  ::mojo_base::mojom::ThreadPriority thread_priority() const {
    return static_cast<::mojo_base::mojom::ThreadPriority>(data_->thread_priority);
  }
 private:
  internal::RenderMessageFilter_SetThreadPriority_Params_Data* data_ = nullptr;
};











}  // namespace mojom
}  // namespace content

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // CONTENT_COMMON_RENDER_MESSAGE_FILTER_MOJOM_PARAMS_DATA_H_