#include "qemu/osdep.h"
#include "exec/gdbstub.h"

const GDBFeature gdb_static_features[] = {
    {
        "aarch64-core.xml",
        "<?xml version=\"1.0\"?>\n"
        "<!-- Copyright (C) 2009-2025 Free Software Foundation, Inc.\n"
        "     Contributed by ARM Ltd.\n"
        "\n"
        "     Copying and distribution of this file, with or without modification,\n"
        "     are permitted in any medium without royalty provided the copyright\n"
        "     notice and this notice are preserved.  -->\n"
        "\n"
        "<!DOCTYPE feature SYSTEM \"gdb-target.dtd\">\n"
        "<feature name=\"org.gnu.gdb.aarch64.core\">\n"
        "  <reg name=\"x0\" bitsize=\"64\"/>\n"
        "  <reg name=\"x1\" bitsize=\"64\"/>\n"
        "  <reg name=\"x2\" bitsize=\"64\"/>\n"
        "  <reg name=\"x3\" bitsize=\"64\"/>\n"
        "  <reg name=\"x4\" bitsize=\"64\"/>\n"
        "  <reg name=\"x5\" bitsize=\"64\"/>\n"
        "  <reg name=\"x6\" bitsize=\"64\"/>\n"
        "  <reg name=\"x7\" bitsize=\"64\"/>\n"
        "  <reg name=\"x8\" bitsize=\"64\"/>\n"
        "  <reg name=\"x9\" bitsize=\"64\"/>\n"
        "  <reg name=\"x10\" bitsize=\"64\"/>\n"
        "  <reg name=\"x11\" bitsize=\"64\"/>\n"
        "  <reg name=\"x12\" bitsize=\"64\"/>\n"
        "  <reg name=\"x13\" bitsize=\"64\"/>\n"
        "  <reg name=\"x14\" bitsize=\"64\"/>\n"
        "  <reg name=\"x15\" bitsize=\"64\"/>\n"
        "  <reg name=\"x16\" bitsize=\"64\"/>\n"
        "  <reg name=\"x17\" bitsize=\"64\"/>\n"
        "  <reg name=\"x18\" bitsize=\"64\"/>\n"
        "  <reg name=\"x19\" bitsize=\"64\"/>\n"
        "  <reg name=\"x20\" bitsize=\"64\"/>\n"
        "  <reg name=\"x21\" bitsize=\"64\"/>\n"
        "  <reg name=\"x22\" bitsize=\"64\"/>\n"
        "  <reg name=\"x23\" bitsize=\"64\"/>\n"
        "  <reg name=\"x24\" bitsize=\"64\"/>\n"
        "  <reg name=\"x25\" bitsize=\"64\"/>\n"
        "  <reg name=\"x26\" bitsize=\"64\"/>\n"
        "  <reg name=\"x27\" bitsize=\"64\"/>\n"
        "  <reg name=\"x28\" bitsize=\"64\"/>\n"
        "  <reg name=\"x29\" bitsize=\"64\"/>\n"
        "  <reg name=\"x30\" bitsize=\"64\"/>\n"
        "  <reg name=\"sp\" bitsize=\"64\" type=\"data_ptr\"/>\n"
        "\n"
        "  <reg name=\"pc\" bitsize=\"64\" type=\"code_ptr\"/>\n"
        "\n"
        "  <flags id=\"cpsr_flags\" size=\"4\">\n"
        "    <!-- Stack Pointer.  -->\n"
        "    <field name=\"SP\" start=\"0\" end=\"0\"/>\n"
        "\n"
        "    <!-- Exception Level.  -->\n"
        "    <field name=\"EL\" start=\"2\" end=\"3\"/>\n"
        "    <!-- Execution state.  -->\n"
        "    <field name=\"nRW\" start=\"4\" end=\"4\"/>\n"
        "\n"
        "    <!-- FIQ interrupt mask.  -->\n"
        "    <field name=\"F\" start=\"6\" end=\"6\"/>\n"
        "    <!-- IRQ interrupt mask.  -->\n"
        "    <field name=\"I\" start=\"7\" end=\"7\"/>\n"
        "    <!-- SError interrupt mask.  -->\n"
        "    <field name=\"A\" start=\"8\" end=\"8\"/>\n"
        "    <!-- Debug exception mask.  -->\n"
        "    <field name=\"D\" start=\"9\" end=\"9\"/>\n"
        "\n"
        "    <!-- ARMv8.5-A: Branch Target Identification BTYPE.  -->\n"
        "    <field name=\"BTYPE\" start=\"10\" end=\"11\"/>\n"
        "\n"
        "    <!-- ARMv8.0-A: Speculative Store Bypass.  -->\n"
        "    <field name=\"SSBS\" start=\"12\" end=\"12\"/>\n"
        "\n"
        "    <!-- Illegal Execution state.  -->\n"
        "    <field name=\"IL\" start=\"20\" end=\"20\"/>\n"
        "    <!-- Software Step.  -->\n"
        "    <field name=\"SS\" start=\"21\" end=\"21\"/>\n"
        "    <!-- ARMv8.1-A: Privileged Access Never.  -->\n"
        "    <field name=\"PAN\" start=\"22\" end=\"22\"/>\n"
        "    <!-- ARMv8.2-A: User Access Override.  -->\n"
        "    <field name=\"UAO\" start=\"23\" end=\"23\"/>\n"
        "    <!-- ARMv8.4-A: Data Independent Timing.  -->\n"
        "    <field name=\"DIT\" start=\"24\" end=\"24\"/>\n"
        "    <!-- ARMv8.5-A: Tag Check Override.  -->\n"
        "    <field name=\"TCO\" start=\"25\" end=\"25\"/>\n"
        "\n"
        "    <!-- Overflow Condition flag.  -->\n"
        "    <field name=\"V\" start=\"28\" end=\"28\"/>\n"
        "    <!-- Carry Condition flag.  -->\n"
        "    <field name=\"C\" start=\"29\" end=\"29\"/>\n"
        "    <!-- Zero Condition flag.  -->\n"
        "    <field name=\"Z\" start=\"30\" end=\"30\"/>\n"
        "    <!-- Negative Condition flag.  -->\n"
        "    <field name=\"N\" start=\"31\" end=\"31\"/>\n"
        "  </flags>\n"
        "  <reg name=\"cpsr\" bitsize=\"32\" type=\"cpsr_flags\"/>\n"
        "\n"
        "</feature>\n",
        "org.gnu.gdb.aarch64.core",
        (const char * const []) {
            [0] =
                "x0",
            [1] =
                "x1",
            [2] =
                "x2",
            [3] =
                "x3",
            [4] =
                "x4",
            [5] =
                "x5",
            [6] =
                "x6",
            [7] =
                "x7",
            [8] =
                "x8",
            [9] =
                "x9",
            [10] =
                "x10",
            [11] =
                "x11",
            [12] =
                "x12",
            [13] =
                "x13",
            [14] =
                "x14",
            [15] =
                "x15",
            [16] =
                "x16",
            [17] =
                "x17",
            [18] =
                "x18",
            [19] =
                "x19",
            [20] =
                "x20",
            [21] =
                "x21",
            [22] =
                "x22",
            [23] =
                "x23",
            [24] =
                "x24",
            [25] =
                "x25",
            [26] =
                "x26",
            [27] =
                "x27",
            [28] =
                "x28",
            [29] =
                "x29",
            [30] =
                "x30",
            [31] =
                "sp",
            [32] =
                "pc",
            [33] =
                "cpsr",
        },
        34,
    },
    {
        "aarch64-fpu.xml",
        "<?xml version=\"1.0\"?>\n"
        "<!-- Copyright (C) 2009-2012 Free Software Foundation, Inc.\n"
        "     Contributed by ARM Ltd.\n"
        "\n"
        "     Copying and distribution of this file, with or without modification,\n"
        "     are permitted in any medium without royalty provided the copyright\n"
        "     notice and this notice are preserved.  -->\n"
        "\n"
        "<!DOCTYPE feature SYSTEM \"gdb-target.dtd\">\n"
        "<feature name=\"org.gnu.gdb.aarch64.fpu\">\n"
        "  <vector id=\"v2d\" type=\"ieee_double\" count=\"2\"/>\n"
        "  <vector id=\"v2u\" type=\"uint64\" count=\"2\"/>\n"
        "  <vector id=\"v2i\" type=\"int64\" count=\"2\"/>\n"
        "  <vector id=\"v4f\" type=\"ieee_single\" count=\"4\"/>\n"
        "  <vector id=\"v4u\" type=\"uint32\" count=\"4\"/>\n"
        "  <vector id=\"v4i\" type=\"int32\" count=\"4\"/>\n"
        "  <vector id=\"v8u\" type=\"uint16\" count=\"8\"/>\n"
        "  <vector id=\"v8i\" type=\"int16\" count=\"8\"/>\n"
        "  <vector id=\"v16u\" type=\"uint8\" count=\"16\"/>\n"
        "  <vector id=\"v16i\" type=\"int8\" count=\"16\"/>\n"
        "  <vector id=\"v1u\" type=\"uint128\" count=\"1\"/>\n"
        "  <vector id=\"v1i\" type=\"int128\" count=\"1\"/>\n"
        "  <union id=\"vnd\">\n"
        "    <field name=\"f\" type=\"v2d\"/>\n"
        "    <field name=\"u\" type=\"v2u\"/>\n"
        "    <field name=\"s\" type=\"v2i\"/>\n"
        "  </union>\n"
        "  <union id=\"vns\">\n"
        "    <field name=\"f\" type=\"v4f\"/>\n"
        "    <field name=\"u\" type=\"v4u\"/>\n"
        "    <field name=\"s\" type=\"v4i\"/>\n"
        "  </union>\n"
        "  <union id=\"vnh\">\n"
        "    <field name=\"u\" type=\"v8u\"/>\n"
        "    <field name=\"s\" type=\"v8i\"/>\n"
        "  </union>\n"
        "  <union id=\"vnb\">\n"
        "    <field name=\"u\" type=\"v16u\"/>\n"
        "    <field name=\"s\" type=\"v16i\"/>\n"
        "  </union>\n"
        "  <union id=\"vnq\">\n"
        "    <field name=\"u\" type=\"v1u\"/>\n"
        "    <field name=\"s\" type=\"v1i\"/>\n"
        "  </union>\n"
        "  <union id=\"aarch64v\">\n"
        "    <field name=\"d\" type=\"vnd\"/>\n"
        "    <field name=\"s\" type=\"vns\"/>\n"
        "    <field name=\"h\" type=\"vnh\"/>\n"
        "    <field name=\"b\" type=\"vnb\"/>\n"
        "    <field name=\"q\" type=\"vnq\"/>\n"
        "  </union>\n"
        "  <reg name=\"v0\" bitsize=\"128\" type=\"aarch64v\" regnum=\"34\"/>\n"
        "  <reg name=\"v1\" bitsize=\"128\" type=\"aarch64v\" />\n"
        "  <reg name=\"v2\" bitsize=\"128\" type=\"aarch64v\" />\n"
        "  <reg name=\"v3\" bitsize=\"128\" type=\"aarch64v\" />\n"
        "  <reg name=\"v4\" bitsize=\"128\" type=\"aarch64v\" />\n"
        "  <reg name=\"v5\" bitsize=\"128\" type=\"aarch64v\" />\n"
        "  <reg name=\"v6\" bitsize=\"128\" type=\"aarch64v\" />\n"
        "  <reg name=\"v7\" bitsize=\"128\" type=\"aarch64v\" />\n"
        "  <reg name=\"v8\" bitsize=\"128\" type=\"aarch64v\" />\n"
        "  <reg name=\"v9\" bitsize=\"128\" type=\"aarch64v\" />\n"
        "  <reg name=\"v10\" bitsize=\"128\" type=\"aarch64v\"/>\n"
        "  <reg name=\"v11\" bitsize=\"128\" type=\"aarch64v\"/>\n"
        "  <reg name=\"v12\" bitsize=\"128\" type=\"aarch64v\"/>\n"
        "  <reg name=\"v13\" bitsize=\"128\" type=\"aarch64v\"/>\n"
        "  <reg name=\"v14\" bitsize=\"128\" type=\"aarch64v\"/>\n"
        "  <reg name=\"v15\" bitsize=\"128\" type=\"aarch64v\"/>\n"
        "  <reg name=\"v16\" bitsize=\"128\" type=\"aarch64v\"/>\n"
        "  <reg name=\"v17\" bitsize=\"128\" type=\"aarch64v\"/>\n"
        "  <reg name=\"v18\" bitsize=\"128\" type=\"aarch64v\"/>\n"
        "  <reg name=\"v19\" bitsize=\"128\" type=\"aarch64v\"/>\n"
        "  <reg name=\"v20\" bitsize=\"128\" type=\"aarch64v\"/>\n"
        "  <reg name=\"v21\" bitsize=\"128\" type=\"aarch64v\"/>\n"
        "  <reg name=\"v22\" bitsize=\"128\" type=\"aarch64v\"/>\n"
        "  <reg name=\"v23\" bitsize=\"128\" type=\"aarch64v\"/>\n"
        "  <reg name=\"v24\" bitsize=\"128\" type=\"aarch64v\"/>\n"
        "  <reg name=\"v25\" bitsize=\"128\" type=\"aarch64v\"/>\n"
        "  <reg name=\"v26\" bitsize=\"128\" type=\"aarch64v\"/>\n"
        "  <reg name=\"v27\" bitsize=\"128\" type=\"aarch64v\"/>\n"
        "  <reg name=\"v28\" bitsize=\"128\" type=\"aarch64v\"/>\n"
        "  <reg name=\"v29\" bitsize=\"128\" type=\"aarch64v\"/>\n"
        "  <reg name=\"v30\" bitsize=\"128\" type=\"aarch64v\"/>\n"
        "  <reg name=\"v31\" bitsize=\"128\" type=\"aarch64v\"/>\n"
        "  <reg name=\"fpsr\" bitsize=\"32\"/>\n"
        "  <reg name=\"fpcr\" bitsize=\"32\"/>\n"
        "</feature>\n",
        "org.gnu.gdb.aarch64.fpu",
        (const char * const []) {
            [0] =
                "v0",
            [1] =
                "v1",
            [2] =
                "v2",
            [3] =
                "v3",
            [4] =
                "v4",
            [5] =
                "v5",
            [6] =
                "v6",
            [7] =
                "v7",
            [8] =
                "v8",
            [9] =
                "v9",
            [10] =
                "v10",
            [11] =
                "v11",
            [12] =
                "v12",
            [13] =
                "v13",
            [14] =
                "v14",
            [15] =
                "v15",
            [16] =
                "v16",
            [17] =
                "v17",
            [18] =
                "v18",
            [19] =
                "v19",
            [20] =
                "v20",
            [21] =
                "v21",
            [22] =
                "v22",
            [23] =
                "v23",
            [24] =
                "v24",
            [25] =
                "v25",
            [26] =
                "v26",
            [27] =
                "v27",
            [28] =
                "v28",
            [29] =
                "v29",
            [30] =
                "v30",
            [31] =
                "v31",
            [32] =
                "fpsr",
            [33] =
                "fpcr",
        },
        34,
    },
    {
        "aarch64-pauth.xml",
        "<?xml version=\"1.0\"?>\n"
        "<!-- Copyright (C) 2018-2022 Free Software Foundation, Inc.\n"
        "\n"
        "     Copying and distribution of this file, with or without modification,\n"
        "     are permitted in any medium without royalty provided the copyright\n"
        "     notice and this notice are preserved.  -->\n"
        "\n"
        "<!DOCTYPE feature SYSTEM \"gdb-target.dtd\">\n"
        "<feature name=\"org.gnu.gdb.aarch64.pauth_v2\">\n"
        "  <reg name=\"pauth_dmask\" bitsize=\"64\"/>\n"
        "  <reg name=\"pauth_cmask\" bitsize=\"64\"/>\n"
        "  <reg name=\"pauth_dmask_high\" bitsize=\"64\"/>\n"
        "  <reg name=\"pauth_cmask_high\" bitsize=\"64\"/>\n"
        "</feature>\n"
        "\n",
        "org.gnu.gdb.aarch64.pauth_v2",
        (const char * const []) {
            [0] =
                "pauth_dmask",
            [1] =
                "pauth_cmask",
            [2] =
                "pauth_dmask_high",
            [3] =
                "pauth_cmask_high",
        },
        4,
    },
    {
        "aarch64-mte.xml",
        "<?xml version=\"1.0\"?>\n"
        "<!-- Copyright (C) 2021-2023 Free Software Foundation, Inc.\n"
        "\n"
        "     Copying and distribution of this file, with or without modification,\n"
        "     are permitted in any medium without royalty provided the copyright\n"
        "     notice and this notice are preserved.  -->\n"
        "\n"
        "<!DOCTYPE feature SYSTEM \"gdb-target.dtd\">\n"
        "<feature name=\"org.gnu.gdb.aarch64.mte\">\n"
        "  <reg name=\"tag_ctl\" bitsize=\"64\" type=\"uint64\" group=\"system\" save-restore=\"no\"/>\n"
        "</feature>\n",
        "org.gnu.gdb.aarch64.mte",
        (const char * const []) {
            [0] =
                "tag_ctl",
        },
        1,
    },
    { NULL }
};
