/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.12.0
 *
 * Copyright (c) 2025 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt6.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtGui.h"

#line 30 "/build/pyqt6/src/pyqt6-6.9.1/sip/QtGui/qvectornd.sip"
#include <qvectornd.h>
#line 29 "/build/pyqt6/src/pyqt6-6.9.1/build/QtGui/sipQtGuiQVector2D.cpp"

#line 30 "/build/pyqt6/src/pyqt6-6.9.1/sip/QtCore/qpoint.sip"
#include <qpoint.h>
#line 33 "/build/pyqt6/src/pyqt6-6.9.1/build/QtGui/sipQtGuiQVector2D.cpp"
#line 110 "/build/pyqt6/src/pyqt6-6.9.1/sip/QtCore/qpoint.sip"
#include <qpoint.h>
#line 36 "/build/pyqt6/src/pyqt6-6.9.1/build/QtGui/sipQtGuiQVector2D.cpp"
#line 81 "/build/pyqt6/src/pyqt6-6.9.1/sip/QtGui/qvectornd.sip"
#include <qvectornd.h>
#line 39 "/build/pyqt6/src/pyqt6-6.9.1/build/QtGui/sipQtGuiQVector2D.cpp"
#line 149 "/build/pyqt6/src/pyqt6-6.9.1/sip/QtGui/qvectornd.sip"
#include <qvectornd.h>
#line 42 "/build/pyqt6/src/pyqt6-6.9.1/build/QtGui/sipQtGuiQVector2D.cpp"


PyDoc_STRVAR(doc_QVector2D_isNull, "isNull(self) -> bool");

extern "C" {static PyObject *meth_QVector2D_isNull(PyObject *, PyObject *);}
static PyObject *meth_QVector2D_isNull(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVector2D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVector2D, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isNull();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVector2D, sipName_isNull, doc_QVector2D_isNull);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVector2D_x, "x(self) -> float");

extern "C" {static PyObject *meth_QVector2D_x(PyObject *, PyObject *);}
static PyObject *meth_QVector2D_x(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVector2D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVector2D, &sipCpp))
        {
            float sipRes;

            sipRes = sipCpp->x();

            return PyFloat_FromDouble((double)sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVector2D, sipName_x, doc_QVector2D_x);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVector2D_y, "y(self) -> float");

extern "C" {static PyObject *meth_QVector2D_y(PyObject *, PyObject *);}
static PyObject *meth_QVector2D_y(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVector2D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVector2D, &sipCpp))
        {
            float sipRes;

            sipRes = sipCpp->y();

            return PyFloat_FromDouble((double)sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVector2D, sipName_y, doc_QVector2D_y);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVector2D_setX, "setX(self, x: float)");

extern "C" {static PyObject *meth_QVector2D_setX(PyObject *, PyObject *);}
static PyObject *meth_QVector2D_setX(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        float a0;
        ::QVector2D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bf", &sipSelf, sipType_QVector2D, &sipCpp, &a0))
        {
            sipCpp->setX(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QVector2D, sipName_setX, doc_QVector2D_setX);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVector2D_setY, "setY(self, y: float)");

extern "C" {static PyObject *meth_QVector2D_setY(PyObject *, PyObject *);}
static PyObject *meth_QVector2D_setY(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        float a0;
        ::QVector2D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bf", &sipSelf, sipType_QVector2D, &sipCpp, &a0))
        {
            sipCpp->setY(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QVector2D, sipName_setY, doc_QVector2D_setY);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVector2D_length, "length(self) -> float");

extern "C" {static PyObject *meth_QVector2D_length(PyObject *, PyObject *);}
static PyObject *meth_QVector2D_length(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVector2D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVector2D, &sipCpp))
        {
            float sipRes;

            sipRes = sipCpp->length();

            return PyFloat_FromDouble((double)sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVector2D, sipName_length, doc_QVector2D_length);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVector2D_lengthSquared, "lengthSquared(self) -> float");

extern "C" {static PyObject *meth_QVector2D_lengthSquared(PyObject *, PyObject *);}
static PyObject *meth_QVector2D_lengthSquared(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVector2D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVector2D, &sipCpp))
        {
            float sipRes;

            sipRes = sipCpp->lengthSquared();

            return PyFloat_FromDouble((double)sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVector2D, sipName_lengthSquared, doc_QVector2D_lengthSquared);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVector2D_normalized, "normalized(self) -> QVector2D");

extern "C" {static PyObject *meth_QVector2D_normalized(PyObject *, PyObject *);}
static PyObject *meth_QVector2D_normalized(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVector2D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVector2D, &sipCpp))
        {
            ::QVector2D*sipRes;

            sipRes = new ::QVector2D(sipCpp->normalized());

            return sipConvertFromNewType(sipRes, sipType_QVector2D, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVector2D, sipName_normalized, doc_QVector2D_normalized);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVector2D_normalize, "normalize(self)");

extern "C" {static PyObject *meth_QVector2D_normalize(PyObject *, PyObject *);}
static PyObject *meth_QVector2D_normalize(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QVector2D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVector2D, &sipCpp))
        {
            sipCpp->normalize();

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QVector2D, sipName_normalize, doc_QVector2D_normalize);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVector2D_distanceToPoint, "distanceToPoint(self, point: QVector2D) -> float");

extern "C" {static PyObject *meth_QVector2D_distanceToPoint(PyObject *, PyObject *);}
static PyObject *meth_QVector2D_distanceToPoint(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QVector2D* a0;
        const ::QVector2D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QVector2D, &sipCpp, sipType_QVector2D, &a0))
        {
            float sipRes;

            sipRes = sipCpp->distanceToPoint(*a0);

            return PyFloat_FromDouble((double)sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVector2D, sipName_distanceToPoint, doc_QVector2D_distanceToPoint);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVector2D_distanceToLine, "distanceToLine(self, point: QVector2D, direction: QVector2D) -> float");

extern "C" {static PyObject *meth_QVector2D_distanceToLine(PyObject *, PyObject *);}
static PyObject *meth_QVector2D_distanceToLine(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QVector2D* a0;
        ::QVector2D* a1;
        const ::QVector2D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9J9", &sipSelf, sipType_QVector2D, &sipCpp, sipType_QVector2D, &a0, sipType_QVector2D, &a1))
        {
            float sipRes;

            sipRes = sipCpp->distanceToLine(*a0, *a1);

            return PyFloat_FromDouble((double)sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVector2D, sipName_distanceToLine, doc_QVector2D_distanceToLine);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVector2D_dotProduct, "dotProduct(v1: QVector2D, v2: QVector2D) -> float");

extern "C" {static PyObject *meth_QVector2D_dotProduct(PyObject *, PyObject *);}
static PyObject *meth_QVector2D_dotProduct(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QVector2D* a0;
        ::QVector2D* a1;

        if (sipParseArgs(&sipParseErr, sipArgs, "CJ9J9", &sipSelf, sipType_QVector2D, &a0, sipType_QVector2D, &a1))
        {
            float sipRes;

            sipRes = ::QVector2D::dotProduct(*a0, *a1);

            return PyFloat_FromDouble((double)sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVector2D, sipName_dotProduct, doc_QVector2D_dotProduct);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVector2D_toVector3D, "toVector3D(self) -> QVector3D");

extern "C" {static PyObject *meth_QVector2D_toVector3D(PyObject *, PyObject *);}
static PyObject *meth_QVector2D_toVector3D(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVector2D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVector2D, &sipCpp))
        {
            ::QVector3D*sipRes;

            sipRes = new ::QVector3D(sipCpp->toVector3D());

            return sipConvertFromNewType(sipRes, sipType_QVector3D, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVector2D, sipName_toVector3D, doc_QVector2D_toVector3D);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVector2D_toVector4D, "toVector4D(self) -> QVector4D");

extern "C" {static PyObject *meth_QVector2D_toVector4D(PyObject *, PyObject *);}
static PyObject *meth_QVector2D_toVector4D(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVector2D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVector2D, &sipCpp))
        {
            ::QVector4D*sipRes;

            sipRes = new ::QVector4D(sipCpp->toVector4D());

            return sipConvertFromNewType(sipRes, sipType_QVector4D, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVector2D, sipName_toVector4D, doc_QVector2D_toVector4D);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVector2D_toPoint, "toPoint(self) -> QPoint");

extern "C" {static PyObject *meth_QVector2D_toPoint(PyObject *, PyObject *);}
static PyObject *meth_QVector2D_toPoint(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVector2D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVector2D, &sipCpp))
        {
            ::QPoint*sipRes;

            sipRes = new ::QPoint(sipCpp->toPoint());

            return sipConvertFromNewType(sipRes, sipType_QPoint, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVector2D, sipName_toPoint, doc_QVector2D_toPoint);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QVector2D_toPointF, "toPointF(self) -> QPointF");

extern "C" {static PyObject *meth_QVector2D_toPointF(PyObject *, PyObject *);}
static PyObject *meth_QVector2D_toPointF(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QVector2D *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QVector2D, &sipCpp))
        {
            ::QPointF*sipRes;

            sipRes = new ::QPointF(sipCpp->toPointF());

            return sipConvertFromNewType(sipRes, sipType_QPointF, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVector2D, sipName_toPointF, doc_QVector2D_toPointF);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *slot_QVector2D___ne__(PyObject *, PyObject *);}
static PyObject *slot_QVector2D___ne__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QVector2D *sipCpp = reinterpret_cast< ::QVector2D *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QVector2D));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QVector2D* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QVector2D, &a0))
        {
            bool sipRes;

            sipRes = operator!=((*sipCpp), *a0);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI_QtGui, ne_slot, sipType_QVector2D, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QVector2D___eq__(PyObject *, PyObject *);}
static PyObject *slot_QVector2D___eq__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QVector2D *sipCpp = reinterpret_cast< ::QVector2D *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QVector2D));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QVector2D* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QVector2D, &a0))
        {
            bool sipRes;

            sipRes = operator==((*sipCpp), *a0);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI_QtGui, eq_slot, sipType_QVector2D, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QVector2D___truediv__(PyObject *, PyObject *);}
static PyObject *slot_QVector2D___truediv__(PyObject *sipArg0, PyObject *sipArg1)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QVector2D* a0;
        ::QVector2D* a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9J9", sipType_QVector2D, &a0, sipType_QVector2D, &a1))
        {
            ::QVector2D*sipRes;

            sipRes = new ::QVector2D((*a0 / *a1));

            return sipConvertFromNewType(sipRes, sipType_QVector2D, SIP_NULLPTR);
        }
    }

    {
        ::QVector2D* a0;
        float a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9f", sipType_QVector2D, &a0, &a1))
        {
            ::QVector2D*sipRes;

            sipRes = new ::QVector2D((*a0 / a1));

            return sipConvertFromNewType(sipRes, sipType_QVector2D, SIP_NULLPTR);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtGui, truediv_slot, SIP_NULLPTR, sipArg0, sipArg1);
}


extern "C" {static PyObject *slot_QVector2D___add__(PyObject *, PyObject *);}
static PyObject *slot_QVector2D___add__(PyObject *sipArg0, PyObject *sipArg1)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QVector2D* a0;
        ::QVector2D* a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9J9", sipType_QVector2D, &a0, sipType_QVector2D, &a1))
        {
            ::QVector2D*sipRes;

            sipRes = new ::QVector2D((*a0 + *a1));

            return sipConvertFromNewType(sipRes, sipType_QVector2D, SIP_NULLPTR);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtGui, add_slot, SIP_NULLPTR, sipArg0, sipArg1);
}


extern "C" {static PyObject *slot_QVector2D___sub__(PyObject *, PyObject *);}
static PyObject *slot_QVector2D___sub__(PyObject *sipArg0, PyObject *sipArg1)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QVector2D* a0;
        ::QVector2D* a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9J9", sipType_QVector2D, &a0, sipType_QVector2D, &a1))
        {
            ::QVector2D*sipRes;

            sipRes = new ::QVector2D((*a0 - *a1));

            return sipConvertFromNewType(sipRes, sipType_QVector2D, SIP_NULLPTR);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtGui, sub_slot, SIP_NULLPTR, sipArg0, sipArg1);
}


extern "C" {static PyObject *slot_QVector2D___mul__(PyObject *, PyObject *);}
static PyObject *slot_QVector2D___mul__(PyObject *sipArg0, PyObject *sipArg1)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QVector2D* a0;
        ::QVector2D* a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9J9", sipType_QVector2D, &a0, sipType_QVector2D, &a1))
        {
            ::QVector2D*sipRes;

            sipRes = new ::QVector2D((*a0 * *a1));

            return sipConvertFromNewType(sipRes, sipType_QVector2D, SIP_NULLPTR);
        }
    }

    {
        ::QVector2D* a0;
        float a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "J9f", sipType_QVector2D, &a0, &a1))
        {
            ::QVector2D*sipRes;

            sipRes = new ::QVector2D((*a0 * a1));

            return sipConvertFromNewType(sipRes, sipType_QVector2D, SIP_NULLPTR);
        }
    }

    {
        float a0;
        ::QVector2D* a1;

        if (sipParsePair(&sipParseErr, sipArg0, sipArg1, "fJ9", &a0, sipType_QVector2D, &a1))
        {
            ::QVector2D*sipRes;

            sipRes = new ::QVector2D((a0 * *a1));

            return sipConvertFromNewType(sipRes, sipType_QVector2D, SIP_NULLPTR);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI_QtGui, mul_slot, SIP_NULLPTR, sipArg0, sipArg1);
}


extern "C" {static PyObject *slot_QVector2D___neg__(PyObject *);}
static PyObject *slot_QVector2D___neg__(PyObject *sipSelf)
{
    ::QVector2D *sipCpp = reinterpret_cast< ::QVector2D *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QVector2D));

    if (!sipCpp)
        return SIP_NULLPTR;


    {
        {
            ::QVector2D*sipRes;

            sipRes = new ::QVector2D(-(*sipCpp));

            return sipConvertFromNewType(sipRes, sipType_QVector2D, SIP_NULLPTR);
        }
    }

    return 0;
}


extern "C" {static PyObject *slot_QVector2D___itruediv__(PyObject *, PyObject *);}
static PyObject *slot_QVector2D___itruediv__(PyObject *sipSelf, PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf, sipTypeAsPyTypeObject(sipType_QVector2D)))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    ::QVector2D *sipCpp = reinterpret_cast< ::QVector2D *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QVector2D));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        float a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1f", &a0))
        {
            sipCpp->::QVector2D::operator/=(a0);

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    {
        ::QVector2D* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QVector2D, &a0))
        {
            sipCpp->::QVector2D::operator/=(*a0);

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static PyObject *slot_QVector2D___imul__(PyObject *, PyObject *);}
static PyObject *slot_QVector2D___imul__(PyObject *sipSelf, PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf, sipTypeAsPyTypeObject(sipType_QVector2D)))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    ::QVector2D *sipCpp = reinterpret_cast< ::QVector2D *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QVector2D));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        float a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1f", &a0))
        {
            sipCpp->::QVector2D::operator*=(a0);

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    {
        ::QVector2D* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QVector2D, &a0))
        {
            sipCpp->::QVector2D::operator*=(*a0);

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static PyObject *slot_QVector2D___isub__(PyObject *, PyObject *);}
static PyObject *slot_QVector2D___isub__(PyObject *sipSelf, PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf, sipTypeAsPyTypeObject(sipType_QVector2D)))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    ::QVector2D *sipCpp = reinterpret_cast< ::QVector2D *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QVector2D));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QVector2D* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QVector2D, &a0))
        {
            sipCpp->::QVector2D::operator-=(*a0);

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static PyObject *slot_QVector2D___iadd__(PyObject *, PyObject *);}
static PyObject *slot_QVector2D___iadd__(PyObject *sipSelf, PyObject *sipArg)
{
    if (!PyObject_TypeCheck(sipSelf, sipTypeAsPyTypeObject(sipType_QVector2D)))
    {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }

    ::QVector2D *sipCpp = reinterpret_cast< ::QVector2D *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QVector2D));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QVector2D* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QVector2D, &a0))
        {
            sipCpp->::QVector2D::operator+=(*a0);

            Py_INCREF(sipSelf);
            return sipSelf;
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    PyErr_Clear();

    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}


extern "C" {static PyObject *slot_QVector2D___getitem__(PyObject *, PyObject *);}
static PyObject *slot_QVector2D___getitem__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QVector2D *sipCpp = reinterpret_cast< ::QVector2D *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QVector2D));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1i", &a0))
        {
            float sipRes;

            sipRes = (*sipCpp)[a0];

            return PyFloat_FromDouble((double)sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QVector2D, sipName___getitem__, SIP_NULLPTR);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *slot_QVector2D___repr__(PyObject *);}
static PyObject *slot_QVector2D___repr__(PyObject *sipSelf)
{
    ::QVector2D *sipCpp = reinterpret_cast< ::QVector2D *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QVector2D));

    if (!sipCpp)
        return SIP_NULLPTR;


    {
        {
            PyObject * sipRes = SIP_NULLPTR;

#line 42 "/build/pyqt6/src/pyqt6-6.9.1/sip/QtGui/qvectornd.sip"
        PyObject *x = PyFloat_FromDouble(sipCpp->x());
        PyObject *y = PyFloat_FromDouble(sipCpp->y());
        
        if (x && y)
            sipRes = PyUnicode_FromFormat("PyQt6.QtGui.QVector2D(%R, %R)",
                    x, y);
        
        Py_XDECREF(x);
        Py_XDECREF(y);
#line 935 "/build/pyqt6/src/pyqt6-6.9.1/build/QtGui/sipQtGuiQVector2D.cpp"

            return sipRes;
        }
    }

    return 0;
}


/* Call the instance's destructor. */
extern "C" {static void release_QVector2D(void *, int);}
static void release_QVector2D(void *sipCppV, int)
{
    delete reinterpret_cast< ::QVector2D *>(sipCppV);
}


extern "C" {static void *array_QVector2D(Py_ssize_t);}
static void *array_QVector2D(Py_ssize_t sipNrElem)
{
    return new ::QVector2D[sipNrElem];
}


extern "C" {static void array_delete_QVector2D(void *);}
static void array_delete_QVector2D(void *sipCpp)
{
    delete[] reinterpret_cast< ::QVector2D *>(sipCpp);
}


extern "C" {static void assign_QVector2D(void *, Py_ssize_t, void *);}
static void assign_QVector2D(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QVector2D *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QVector2D *>(sipSrc);
}


extern "C" {static void *copy_QVector2D(const void *, Py_ssize_t);}
static void *copy_QVector2D(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::QVector2D(reinterpret_cast<const ::QVector2D *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QVector2D(sipSimpleWrapper *);}
static void dealloc_QVector2D(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QVector2D(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QVector2D(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QVector2D(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::QVector2D *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            sipCpp = new ::QVector2D();

            return sipCpp;
        }
    }

    {
        float a0;
        float a1;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "ff", &a0, &a1))
        {
            sipCpp = new ::QVector2D(a0, a1);

            return sipCpp;
        }
    }

    {
        ::QPoint* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QPoint, &a0))
        {
            sipCpp = new ::QVector2D(*a0);

            return sipCpp;
        }
    }

    {
        ::QPointF* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QPointF, &a0))
        {
            sipCpp = new ::QVector2D(*a0);

            return sipCpp;
        }
    }

    {
        ::QVector3D* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QVector3D, &a0))
        {
            sipCpp = new ::QVector2D(*a0);

            return sipCpp;
        }
    }

    {
        ::QVector4D* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QVector4D, &a0))
        {
            sipCpp = new ::QVector2D(*a0);

            return sipCpp;
        }
    }

    {
        const ::QVector2D* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QVector2D, &a0))
        {
            sipCpp = new ::QVector2D(*a0);

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_QVector2D[] = {
    {(void *)slot_QVector2D___ne__, ne_slot},
    {(void *)slot_QVector2D___eq__, eq_slot},
    {(void *)slot_QVector2D___truediv__, truediv_slot},
    {(void *)slot_QVector2D___add__, add_slot},
    {(void *)slot_QVector2D___sub__, sub_slot},
    {(void *)slot_QVector2D___mul__, mul_slot},
    {(void *)slot_QVector2D___neg__, neg_slot},
    {(void *)slot_QVector2D___itruediv__, itruediv_slot},
    {(void *)slot_QVector2D___imul__, imul_slot},
    {(void *)slot_QVector2D___isub__, isub_slot},
    {(void *)slot_QVector2D___iadd__, iadd_slot},
    {(void *)slot_QVector2D___getitem__, getitem_slot},
    {(void *)slot_QVector2D___repr__, repr_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_QVector2D[] = {
    {sipName_distanceToLine, meth_QVector2D_distanceToLine, METH_VARARGS, doc_QVector2D_distanceToLine},
    {sipName_distanceToPoint, meth_QVector2D_distanceToPoint, METH_VARARGS, doc_QVector2D_distanceToPoint},
    {sipName_dotProduct, meth_QVector2D_dotProduct, METH_VARARGS, doc_QVector2D_dotProduct},
    {sipName_isNull, meth_QVector2D_isNull, METH_VARARGS, doc_QVector2D_isNull},
    {sipName_length, meth_QVector2D_length, METH_VARARGS, doc_QVector2D_length},
    {sipName_lengthSquared, meth_QVector2D_lengthSquared, METH_VARARGS, doc_QVector2D_lengthSquared},
    {sipName_normalize, meth_QVector2D_normalize, METH_VARARGS, doc_QVector2D_normalize},
    {sipName_normalized, meth_QVector2D_normalized, METH_VARARGS, doc_QVector2D_normalized},
    {sipName_setX, meth_QVector2D_setX, METH_VARARGS, doc_QVector2D_setX},
    {sipName_setY, meth_QVector2D_setY, METH_VARARGS, doc_QVector2D_setY},
    {sipName_toPoint, meth_QVector2D_toPoint, METH_VARARGS, doc_QVector2D_toPoint},
    {sipName_toPointF, meth_QVector2D_toPointF, METH_VARARGS, doc_QVector2D_toPointF},
    {sipName_toVector3D, meth_QVector2D_toVector3D, METH_VARARGS, doc_QVector2D_toVector3D},
    {sipName_toVector4D, meth_QVector2D_toVector4D, METH_VARARGS, doc_QVector2D_toVector4D},
    {sipName_x, meth_QVector2D_x, METH_VARARGS, doc_QVector2D_x},
    {sipName_y, meth_QVector2D_y, METH_VARARGS, doc_QVector2D_y}
};

PyDoc_STRVAR(doc_QVector2D, "\1QVector2D()\n"
"QVector2D(xpos: float, ypos: float)\n"
"QVector2D(point: QPoint)\n"
"QVector2D(point: QPointF)\n"
"QVector2D(vector: QVector3D)\n"
"QVector2D(vector: QVector4D)\n"
"QVector2D(a0: QVector2D)");


sipClassTypeDef sipTypeDef_QtGui_QVector2D = {
    {
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_LIMITED_API|SIP_TYPE_CLASS,
        sipNameNr_QVector2D,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_QVector2D,
        {0, 0, 1},
        16, methods_QVector2D,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QVector2D,
    -1,
    sipNameNr_PyQt6_sip_simplewrapper,
    SIP_NULLPTR,
    slots_QVector2D,
    init_type_QVector2D,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QVector2D,
    assign_QVector2D,
    array_QVector2D,
    copy_QVector2D,
    release_QVector2D,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_QVector2D,
    sizeof (::QVector2D),
};
