// python wrapper for vtkSMSelectionHelper
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkSMSelectionHelper.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkSMSelectionHelper(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkSMSelectionHelper_ClassNew(); }

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkSMSelectionHelper_CombineOperation_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkSMSelectionHelper.CombineOperation", // tp_name
  sizeof(PyLongObject), // tp_basicsize
  0, // tp_itemsize
  nullptr, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  nullptr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  nullptr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT
#if PY_VERSION_HEX >= 0x030A0000
    | Py_TPFLAGS_DISALLOW_INSTANTIATION
#endif
  , // tp_flags
  nullptr, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  &PyLong_Type, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  nullptr, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

template<class T>
static PyObject *PyvtkSMSelectionHelper_CombineOperation_FromEnum(T val)
{
  return PyVTKEnum_New(&PyvtkSMSelectionHelper_CombineOperation_Type, static_cast<int>(val));
}


static PyObject *
PyvtkSMSelectionHelper_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkSMSelectionHelper::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMSelectionHelper_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMSelectionHelper *op = static_cast<vtkSMSelectionHelper *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkSMSelectionHelper::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMSelectionHelper_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkSMSelectionHelper *tempr = vtkSMSelectionHelper::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMSelectionHelper_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMSelectionHelper *op = static_cast<vtkSMSelectionHelper *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSMSelectionHelper *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkSMSelectionHelper::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMSelectionHelper_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkSMSelectionHelper::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMSelectionHelper_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMSelectionHelper *op = static_cast<vtkSMSelectionHelper *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkSMSelectionHelper::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMSelectionHelper_NewAppendSelectionsFromSelectionSource(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "NewAppendSelectionsFromSelectionSource");

  vtkSMSourceProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMSourceProxy"))
  {
    vtkSMProxy *tempr = vtkSMSelectionHelper::NewAppendSelectionsFromSelectionSource(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMSelectionHelper_CombineSelection(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "CombineSelection");

  vtkSMSourceProxy *temp0 = nullptr;
  vtkSMSourceProxy *temp1 = nullptr;
  typedef vtkSMSelectionHelper::CombineOperation temp2_type;
  temp2_type temp2;
  bool temp3 = false;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(3, 4) &&
      ap.GetVTKObject(temp0, "vtkSMSourceProxy") &&
      ap.GetVTKObject(temp1, "vtkSMSourceProxy") &&
      ap.GetEnumValue(temp2, "vtkSMSelectionHelper.CombineOperation") &&
      (ap.NoArgsLeft() || ap.GetValue(temp3)))
  {
    bool tempr = vtkSMSelectionHelper::CombineSelection(temp0, temp1, temp2, temp3);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMSelectionHelper_IgnoreSelection(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IgnoreSelection");

  vtkSMSourceProxy *temp0 = nullptr;
  vtkSMSourceProxy *temp1 = nullptr;
  bool temp2 = false;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2, 3) &&
      ap.GetVTKObject(temp0, "vtkSMSourceProxy") &&
      ap.GetVTKObject(temp1, "vtkSMSourceProxy") &&
      (ap.NoArgsLeft() || ap.GetValue(temp2)))
  {
    bool tempr = vtkSMSelectionHelper::IgnoreSelection(temp0, temp1, temp2);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMSelectionHelper_AddSelection(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "AddSelection");

  vtkSMSourceProxy *temp0 = nullptr;
  vtkSMSourceProxy *temp1 = nullptr;
  bool temp2 = false;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2, 3) &&
      ap.GetVTKObject(temp0, "vtkSMSourceProxy") &&
      ap.GetVTKObject(temp1, "vtkSMSourceProxy") &&
      (ap.NoArgsLeft() || ap.GetValue(temp2)))
  {
    bool tempr = vtkSMSelectionHelper::AddSelection(temp0, temp1, temp2);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMSelectionHelper_SubtractSelection(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SubtractSelection");

  vtkSMSourceProxy *temp0 = nullptr;
  vtkSMSourceProxy *temp1 = nullptr;
  bool temp2 = false;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2, 3) &&
      ap.GetVTKObject(temp0, "vtkSMSourceProxy") &&
      ap.GetVTKObject(temp1, "vtkSMSourceProxy") &&
      (ap.NoArgsLeft() || ap.GetValue(temp2)))
  {
    bool tempr = vtkSMSelectionHelper::SubtractSelection(temp0, temp1, temp2);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMSelectionHelper_ToggleSelection(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "ToggleSelection");

  vtkSMSourceProxy *temp0 = nullptr;
  vtkSMSourceProxy *temp1 = nullptr;
  bool temp2 = false;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2, 3) &&
      ap.GetVTKObject(temp0, "vtkSMSourceProxy") &&
      ap.GetVTKObject(temp1, "vtkSMSourceProxy") &&
      (ap.NoArgsLeft() || ap.GetValue(temp2)))
  {
    bool tempr = vtkSMSelectionHelper::ToggleSelection(temp0, temp1, temp2);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMSelectionHelper_NewSelectionSourceFromSelection(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "NewSelectionSourceFromSelection");

  vtkSMSession *temp0 = nullptr;
  vtkSelection *temp1 = nullptr;
  bool temp2 = false;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2, 3) &&
      ap.GetVTKObject(temp0, "vtkSMSession") &&
      ap.GetVTKObject(temp1, "vtkSelection") &&
      (ap.NoArgsLeft() || ap.GetValue(temp2)))
  {
    vtkSMProxy *tempr = vtkSMSelectionHelper::NewSelectionSourceFromSelection(temp0, temp1, temp2);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMSelectionHelper_NewSelectionSourcesFromSelection(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "NewSelectionSourcesFromSelection");

  vtkSelection *temp0 = nullptr;
  vtkSMProxy *temp1 = nullptr;
  vtkCollection *temp2 = nullptr;
  vtkCollection *temp3 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(4) &&
      ap.GetVTKObject(temp0, "vtkSelection") &&
      ap.GetVTKObject(temp1, "vtkSMProxy") &&
      ap.GetVTKObject(temp2, "vtkCollection") &&
      ap.GetVTKObject(temp3, "vtkCollection"))
  {
    vtkSMSelectionHelper::NewSelectionSourcesFromSelection(temp0, temp1, temp2, temp3);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMSelectionHelper_ConvertAppendSelections(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "ConvertAppendSelections");

  int temp0;
  vtkSMSourceProxy *temp1 = nullptr;
  vtkSMSourceProxy *temp2 = nullptr;
  int temp3;
  bool temp4;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(5) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkSMSourceProxy") &&
      ap.GetVTKObject(temp2, "vtkSMSourceProxy") &&
      ap.GetValue(temp3) &&
      ap.GetValue(temp4))
  {
    vtkSMProxy *tempr = vtkSMSelectionHelper::ConvertAppendSelections(temp0, temp1, temp2, temp3, temp4);

    if (!ap.ErrorOccurred())
    {
      ap.SetArgValue(4, temp4);
    }
    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMSelectionHelper_ConvertSelectionSource(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "ConvertSelectionSource");

  int temp0;
  vtkSMSourceProxy *temp1 = nullptr;
  vtkSMSourceProxy *temp2 = nullptr;
  int temp3;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkSMSourceProxy") &&
      ap.GetVTKObject(temp2, "vtkSMSourceProxy") &&
      ap.GetValue(temp3))
  {
    vtkSMProxy *tempr = vtkSMSelectionHelper::ConvertSelectionSource(temp0, temp1, temp2, temp3);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkSMSelectionHelper_Methods[] = {
  {"IsTypeOf", PyvtkSMSelectionHelper_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkSMSelectionHelper_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkSMSelectionHelper_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkSMSelectionHelper\nC++: static vtkSMSelectionHelper *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkSMSelectionHelper_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkSMSelectionHelper\nC++: vtkSMSelectionHelper *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkSMSelectionHelper_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkSMSelectionHelper_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"NewAppendSelectionsFromSelectionSource", PyvtkSMSelectionHelper_NewAppendSelectionsFromSelectionSource, METH_VARARGS,
   "NewAppendSelectionsFromSelectionSource(\n    selectionSource:vtkSMSourceProxy) -> vtkSMProxy\nC++: static vtkSMProxy *NewAppendSelectionsFromSelectionSource(\n    vtkSMSourceProxy *selectionSource)\n\nCreate an append selection proxy from a selection source.\n"},
  {"CombineSelection", PyvtkSMSelectionHelper_CombineSelection, METH_VARARGS,
   "CombineSelection(appendSelections1:vtkSMSourceProxy,\n    appendSelections2:vtkSMSourceProxy,\n    operation:CombineOperation, deepCopy:bool=False) -> bool\nC++: static bool CombineSelection(\n    vtkSMSourceProxy *appendSelections1,\n    vtkSMSourceProxy *appendSelections2,\n    CombineOperation operation, bool deepCopy=false)\n\nCombine appendSelections1 with appendSelections2 using a combine\noperation and store the result into appendSelections2.\nappendSelections1 and appendSelections2 can be combined if they\nhave the same fieldType and containing cells qualifiers. The\nreturned value indicates if the selections could/have be\ncombined.\n\nIf operation is DEFAULT,     appendSelections2 =\nappendSelections2 if operation is ADDITION,    appendSelections2\n= appendSelections1 | appendSelections2 if operation is\nSUBTRACTION, appendSelections2 = appendSelections1 &\n!appendSelections2 if operation is TOGGLE,      appendSelections2\n= appendSelections1 ^ appendSelections2\n\nNote: appendSelections2 must have at least one selection source,\nbut appendSelections1 can be empty (but valid).\n"},
  {"IgnoreSelection", PyvtkSMSelectionHelper_IgnoreSelection, METH_VARARGS,
   "IgnoreSelection(appendSelections1:vtkSMSourceProxy,\n    appendSelections2:vtkSMSourceProxy, deepCopy:bool=False)\n    -> bool\nC++: static bool IgnoreSelection(\n    vtkSMSourceProxy *appendSelections1,\n    vtkSMSourceProxy *appendSelections2, bool deepCopy=false)\n\n"},
  {"AddSelection", PyvtkSMSelectionHelper_AddSelection, METH_VARARGS,
   "AddSelection(appendSelections1:vtkSMSourceProxy,\n    appendSelections2:vtkSMSourceProxy, deepCopy:bool=False)\n    -> bool\nC++: static bool AddSelection(vtkSMSourceProxy *appendSelections1,\n     vtkSMSourceProxy *appendSelections2, bool deepCopy=false)\n\n"},
  {"SubtractSelection", PyvtkSMSelectionHelper_SubtractSelection, METH_VARARGS,
   "SubtractSelection(appendSelections1:vtkSMSourceProxy,\n    appendSelections2:vtkSMSourceProxy, deepCopy:bool=False)\n    -> bool\nC++: static bool SubtractSelection(\n    vtkSMSourceProxy *appendSelections1,\n    vtkSMSourceProxy *appendSelections2, bool deepCopy=false)\n\n"},
  {"ToggleSelection", PyvtkSMSelectionHelper_ToggleSelection, METH_VARARGS,
   "ToggleSelection(appendSelections1:vtkSMSourceProxy,\n    appendSelections2:vtkSMSourceProxy, deepCopy:bool=False)\n    -> bool\nC++: static bool ToggleSelection(\n    vtkSMSourceProxy *appendSelections1,\n    vtkSMSourceProxy *appendSelections2, bool deepCopy=false)\n\n"},
  {"NewSelectionSourceFromSelection", PyvtkSMSelectionHelper_NewSelectionSourceFromSelection, METH_VARARGS,
   "NewSelectionSourceFromSelection(session:vtkSMSession,\n    selection:vtkSelection, ignore_composite_keys:bool=False)\n    -> vtkSMProxy\nC++: static vtkSMProxy *NewSelectionSourceFromSelection(\n    vtkSMSession *session, vtkSelection *selection,\n    bool ignore_composite_keys=false)\n\nGiven a selection, returns a proxy for a selection source that\nhas the ids specified by it. This source can then be used as\ninput to a vtkExtractSelection filter. CAVEAT: Make sure to\nspecify the connection id for the server on which the selection\nwas performed. This method can only handle 3 types of selection\nFRUSTUM, INDICES and GLOBALIDS. We can easily change this to\nhandle all other types of selection but that's not required\ncurrently and hence we not adding that code.\n"},
  {"NewSelectionSourcesFromSelection", PyvtkSMSelectionHelper_NewSelectionSourcesFromSelection, METH_VARARGS,
   "NewSelectionSourcesFromSelection(selection:vtkSelection,\n    view:vtkSMProxy, selSources:vtkCollection,\n    selRepresentations:vtkCollection) -> None\nC++: static void NewSelectionSourcesFromSelection(\n    vtkSelection *selection, vtkSMProxy *view,\n    vtkCollection *selSources, vtkCollection *selRepresentations)\n\n"},
  {"ConvertAppendSelections", PyvtkSMSelectionHelper_ConvertAppendSelections, METH_VARARGS,
   "ConvertAppendSelections(outputType:int,\n    appendSelections:vtkSMSourceProxy,\n    dataSource:vtkSMSourceProxy, dataPort:int,\n    selectionChanged:bool) -> vtkSMProxy\nC++: static vtkSMProxy *ConvertAppendSelections(int outputType,\n    vtkSMSourceProxy *appendSelections,\n    vtkSMSourceProxy *dataSource, int dataPort,\n    bool &selectionChanged)\n\nGiven the ContentType for an output vtkSelection, this create a\nnew append selections proxy generating the selection, the input\nappendSelections is used to fill the default values for created\nselection source.\n"},
  {"ConvertSelectionSource", PyvtkSMSelectionHelper_ConvertSelectionSource, METH_VARARGS,
   "ConvertSelectionSource(outputType:int,\n    selectionSourceProxy:vtkSMSourceProxy,\n    dataSource:vtkSMSourceProxy, dataPort:int) -> vtkSMProxy\nC++: static vtkSMProxy *ConvertSelectionSource(int outputType,\n    vtkSMSourceProxy *selectionSourceProxy,\n    vtkSMSourceProxy *dataSource, int dataPort)\n\nGiven the ContentType for an output vtkSelection, this create a\nnew source proxy generating the selection, the input\nselectionSourceProxy is used to fill the default values for\ncreated selection source.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkSMSelectionHelper_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkSMSelectionHelper_Doc =
  "vtkSMSelectionHelper - Utility class to help with selection tasks\n\n"
  "Superclass: vtkSMObject\n\n"
  "This class contains several static methods that help with the\n"
  "complicated selection task.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkSMSelectionHelper_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkSMSelectionHelper", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkSMSelectionHelper_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkSMSelectionHelper_StaticNew()
{
  return vtkSMSelectionHelper::New();
}

PyObject *PyvtkSMSelectionHelper_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkSMSelectionHelper_Type, PyvtkSMSelectionHelper_Methods,
    "vtkSMSelectionHelper",
 &PyvtkSMSelectionHelper_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkSMObject");

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  PyType_Ready(&PyvtkSMSelectionHelper_CombineOperation_Type);
  // members of vtkSMSelectionHelper::CombineOperation
  {
    PyObject *enumval;
    PyObject *enumdict = PyDict_New();
    PyvtkSMSelectionHelper_CombineOperation_Type.tp_dict = enumdict;

    typedef vtkSMSelectionHelper::CombineOperation cxx_enum_type;
    static const struct {
      const char *name; cxx_enum_type value;
    } constants[4] = {
      { "DEFAULT", cxx_enum_type::DEFAULT },
      { "ADDITION", cxx_enum_type::ADDITION },
      { "SUBTRACTION", cxx_enum_type::SUBTRACTION },
      { "TOGGLE", cxx_enum_type::TOGGLE },
    };

    for (int c = 0; c < 4; c++)
    {
      enumval = PyvtkSMSelectionHelper_CombineOperation_FromEnum(constants[c].value);
      if (enumval)
      {
        PyDict_SetItemString(enumdict, constants[c].name, enumval);
        Py_DECREF(enumval);
      }
    }
  }

  PyVTKEnum_Add(&PyvtkSMSelectionHelper_CombineOperation_Type, "vtkSMSelectionHelper.CombineOperation");

  o = (PyObject *)&PyvtkSMSelectionHelper_CombineOperation_Type;
  if (PyDict_SetItemString(d, "CombineOperation", o) != 0)
  {
    Py_DECREF(o);
  }

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkSMSelectionHelper_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkSMSelectionHelper(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkSMSelectionHelper_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkSMSelectionHelper", o) != 0)
  {
    Py_DECREF(o);
  }

}

