#include "vtkABI.h"
#include "vtkClientServerInterpreter.h"

extern "C" { void vtkBlueObeliskData_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkBlueObeliskDataParser_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkMoleculeMapper_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkMoleculeToAtomBallFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkMoleculeToBondStickFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkMoleculeToLinesFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkMoleculeToPolyDataFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPeriodicTable_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPointSetToMoleculeFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkProgrammableElectronicData_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkProteinRibbonFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkSimpleBondPerceiver_Init(vtkClientServerInterpreter*); }

extern "C" VTK_ABI_EXPORT void vtkDomainsChemistryCS_Initialize(vtkClientServerInterpreter* csi)
{
  (void)csi;
  vtkBlueObeliskData_Init(csi);
  vtkBlueObeliskDataParser_Init(csi);
  vtkMoleculeMapper_Init(csi);
  vtkMoleculeToAtomBallFilter_Init(csi);
  vtkMoleculeToBondStickFilter_Init(csi);
  vtkMoleculeToLinesFilter_Init(csi);
  vtkMoleculeToPolyDataFilter_Init(csi);
  vtkPeriodicTable_Init(csi);
  vtkPointSetToMoleculeFilter_Init(csi);
  vtkProgrammableElectronicData_Init(csi);
  vtkProteinRibbonFilter_Init(csi);
  vtkSimpleBondPerceiver_Init(csi);
}
