/* Alias.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Alias.vala, do not modify */

/*
* Copyright (c) 2017-2023 elementary, Inc. (https://elementary.io)
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program. If not, see <http://www.gnu.org/licenses/>
*
* Authored by: Leonhard Kargl <leo.kargl@proton.me>
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <granite.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define MAIL_TYPE_ALIAS (mail_alias_get_type ())
#define MAIL_ALIAS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_TYPE_ALIAS, MailAlias))
#define MAIL_ALIAS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_TYPE_ALIAS, MailAliasClass))
#define MAIL_IS_ALIAS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_TYPE_ALIAS))
#define MAIL_IS_ALIAS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_TYPE_ALIAS))
#define MAIL_ALIAS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_TYPE_ALIAS, MailAliasClass))

typedef struct _MailAlias MailAlias;
typedef struct _MailAliasClass MailAliasClass;
typedef struct _MailAliasPrivate MailAliasPrivate;
enum  {
	MAIL_ALIAS_0_PROPERTY,
	MAIL_ALIAS_ADDRESS_PROPERTY,
	MAIL_ALIAS_ALIAS_NAME_PROPERTY,
	MAIL_ALIAS_IS_DELETED_PROPERTY,
	MAIL_ALIAS_NUM_PROPERTIES
};
static GParamSpec* mail_alias_properties[MAIL_ALIAS_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block36Data Block36Data;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	MAIL_ALIAS_SAVE_SIGNAL,
	MAIL_ALIAS_FINISH_DELETE_SIGNAL,
	MAIL_ALIAS_START_DELETE_SIGNAL,
	MAIL_ALIAS_NUM_SIGNALS
};
static guint mail_alias_signals[MAIL_ALIAS_NUM_SIGNALS] = {0};

struct _MailAlias {
	GtkListBoxRow parent_instance;
	MailAliasPrivate * priv;
};

struct _MailAliasClass {
	GtkListBoxRowClass parent_class;
};

struct _MailAliasPrivate {
	gchar* _address;
	gchar* _alias_name;
	GtkLabel* label;
	gchar* old_address;
	guint timeout_id;
};

struct _Block36Data {
	int _ref_count_;
	MailAlias* self;
	GtkEntry* name_entry;
	GraniteValidatedEntry* address_entry;
	GtkPopover* edit_popover;
	GtkMenuButton* edit_button;
};

static gint MailAlias_private_offset;
static gpointer mail_alias_parent_class = NULL;

VALA_EXTERN GType mail_alias_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailAlias, g_object_unref)
VALA_EXTERN MailAlias* mail_alias_new (const gchar* address,
                           const gchar* alias_name);
VALA_EXTERN MailAlias* mail_alias_construct (GType object_type,
                                 const gchar* address,
                                 const gchar* alias_name);
static void mail_alias_update_label (MailAlias* self);
VALA_EXTERN const gchar* mail_alias_get_alias_name (MailAlias* self);
VALA_EXTERN const gchar* mail_alias_get_address (MailAlias* self);
VALA_EXTERN void mail_alias_undo_delete (MailAlias* self);
VALA_EXTERN void mail_alias_set_address (MailAlias* self,
                             const gchar* value);
VALA_EXTERN void mail_alias_set_alias_name (MailAlias* self,
                                const gchar* value);
VALA_EXTERN gboolean mail_alias_get_is_deleted (MailAlias* self);
static GObject * mail_alias_constructor (GType type,
                                  guint n_construct_properties,
                                  GObjectConstructParam * construct_properties);
static Block36Data* block36_data_ref (Block36Data* _data36_);
static void block36_data_unref (void * _userdata_);
static void _mail_alias___lambda18_ (Block36Data* _data36_);
static void __mail_alias___lambda18__gtk_widget_map (GtkWidget* _sender,
                                              gpointer self);
static void _mail_alias___lambda19_ (Block36Data* _data36_);
static gboolean __lambda20_ (Block36Data* _data36_);
static gboolean ___lambda20__gsource_func (gpointer self);
static void __mail_alias___lambda19__gtk_widget_map (GtkWidget* _sender,
                                              gpointer self);
static void _mail_alias___lambda21_ (Block36Data* _data36_);
static void __mail_alias___lambda21__gtk_popover_closed (GtkPopover* _sender,
                                                  gpointer self);
static void _mail_alias_update_label_g_object_notify (GObject* _sender,
                                               GParamSpec* pspec,
                                               gpointer self);
static void _mail_alias___lambda22_ (MailAlias* self);
static void __mail_alias___lambda22__mail_alias_save (MailAlias* _sender,
                                               const gchar* old_address,
                                               gpointer self);
static void _gtk_popover_popdown_gtk_entry_activate (GtkEntry* _sender,
                                              gpointer self);
static void _mail_alias___lambda23_ (Block36Data* _data36_);
static gboolean __lambda24_ (Block36Data* _data36_);
static gboolean ___lambda24__gsource_func (gpointer self);
static void __mail_alias___lambda23__gtk_entry_activate (GtkEntry* _sender,
                                                  gpointer self);
static void _mail_alias___lambda25_ (Block36Data* _data36_);
static gboolean __lambda26_ (MailAlias* self);
static gboolean ___lambda26__gsource_func (gpointer self);
static void __mail_alias___lambda25__gtk_button_clicked (GtkButton* _sender,
                                                  gpointer self);
static void mail_alias_finalize (GObject * obj);
static GType mail_alias_get_type_once (void);
static void _vala_mail_alias_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec);
static void _vala_mail_alias_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec);

static inline gpointer
mail_alias_get_instance_private (MailAlias* self)
{
	return G_STRUCT_MEMBER_P (self, MailAlias_private_offset);
}

MailAlias*
mail_alias_construct (GType object_type,
                      const gchar* address,
                      const gchar* alias_name)
{
	MailAlias * self = NULL;
	g_return_val_if_fail (address != NULL, NULL);
	g_return_val_if_fail (alias_name != NULL, NULL);
	self = (MailAlias*) g_object_new (object_type, "address", address, "alias-name", alias_name, NULL);
	return self;
}

MailAlias*
mail_alias_new (const gchar* address,
                const gchar* alias_name)
{
	return mail_alias_construct (MAIL_TYPE_ALIAS, address, alias_name);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static void
mail_alias_update_label (MailAlias* self)
{
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	gchar* name = NULL;
	gchar* _tmp6_;
	GtkLabel* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->_alias_name;
	_tmp2_ = string_strip (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strcmp0 (_tmp3_, "") != 0;
	_g_free0 (_tmp3_);
	if (_tmp4_) {
		const gchar* _tmp5_;
		_tmp5_ = self->priv->_alias_name;
		_tmp0_ = _tmp5_;
	} else {
		_tmp0_ = _ ("Name not set");
	}
	_tmp6_ = g_strdup (_tmp0_);
	name = _tmp6_;
	_tmp7_ = self->priv->label;
	_tmp8_ = self->priv->_address;
	_tmp9_ = g_strdup_printf ("%s — %s", _tmp8_, name);
	_tmp10_ = _tmp9_;
	gtk_label_set_label (_tmp7_, _tmp10_);
	_g_free0 (_tmp10_);
	_g_free0 (name);
}

void
mail_alias_undo_delete (MailAlias* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->timeout_id != ((guint) 0)) {
		g_source_remove (self->priv->timeout_id);
		self->priv->timeout_id = (guint) 0;
	}
}

const gchar*
mail_alias_get_address (MailAlias* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_address;
	result = _tmp0_;
	return result;
}

void
mail_alias_set_address (MailAlias* self,
                        const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = mail_alias_get_address (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_address);
		self->priv->_address = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, mail_alias_properties[MAIL_ALIAS_ADDRESS_PROPERTY]);
	}
}

const gchar*
mail_alias_get_alias_name (MailAlias* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_alias_name;
	result = _tmp0_;
	return result;
}

void
mail_alias_set_alias_name (MailAlias* self,
                           const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = mail_alias_get_alias_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_alias_name);
		self->priv->_alias_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, mail_alias_properties[MAIL_ALIAS_ALIAS_NAME_PROPERTY]);
	}
}

gboolean
mail_alias_get_is_deleted (MailAlias* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->timeout_id != ((guint) 0);
	return result;
}

static Block36Data*
block36_data_ref (Block36Data* _data36_)
{
	g_atomic_int_inc (&_data36_->_ref_count_);
	return _data36_;
}

static void
block36_data_unref (void * _userdata_)
{
	Block36Data* _data36_;
	_data36_ = (Block36Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data36_->_ref_count_)) {
		MailAlias* self;
		self = _data36_->self;
		_g_object_unref0 (_data36_->edit_button);
		_g_object_unref0 (_data36_->edit_popover);
		_g_object_unref0 (_data36_->address_entry);
		_g_object_unref0 (_data36_->name_entry);
		_g_object_unref0 (self);
		g_slice_free (Block36Data, _data36_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_mail_alias___lambda18_ (Block36Data* _data36_)
{
	MailAlias* self;
	const gchar* _tmp0_;
	self = _data36_->self;
	_tmp0_ = self->priv->_address;
	if (g_strcmp0 (_tmp0_, "") == 0) {
		GtkMenuButton* _tmp1_;
		_tmp1_ = _data36_->edit_button;
		gtk_toggle_button_set_active ((GtkToggleButton*) _tmp1_, TRUE);
	}
}

static void
__mail_alias___lambda18__gtk_widget_map (GtkWidget* _sender,
                                         gpointer self)
{
	_mail_alias___lambda18_ (self);
}

static gboolean
__lambda20_ (Block36Data* _data36_)
{
	MailAlias* self;
	const gchar* _tmp0_;
	gboolean result;
	self = _data36_->self;
	_tmp0_ = self->priv->_address;
	if (g_strcmp0 (_tmp0_, "") == 0) {
		GraniteValidatedEntry* _tmp1_;
		_tmp1_ = _data36_->address_entry;
		gtk_widget_grab_focus ((GtkWidget*) _tmp1_);
	} else {
		GtkEntry* _tmp2_;
		_tmp2_ = _data36_->name_entry;
		gtk_widget_grab_focus ((GtkWidget*) _tmp2_);
	}
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda20__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda20_ (self);
	return result;
}

static void
_mail_alias___lambda19_ (Block36Data* _data36_)
{
	MailAlias* self;
	self = _data36_->self;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda20__gsource_func, block36_data_ref (_data36_), block36_data_unref);
}

static void
__mail_alias___lambda19__gtk_widget_map (GtkWidget* _sender,
                                         gpointer self)
{
	_mail_alias___lambda19_ (self);
}

static void
_mail_alias___lambda21_ (Block36Data* _data36_)
{
	MailAlias* self;
	GraniteValidatedEntry* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	self = _data36_->self;
	_tmp0_ = _data36_->address_entry;
	_tmp1_ = granite_validated_entry_get_is_valid (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		const gchar* _tmp3_;
		_tmp3_ = self->priv->old_address;
		g_signal_emit (self, mail_alias_signals[MAIL_ALIAS_SAVE_SIGNAL], 0, _tmp3_);
	} else {
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gboolean _tmp8_;
		_tmp4_ = self->priv->old_address;
		mail_alias_set_address (self, _tmp4_);
		_tmp5_ = self->priv->_address;
		_tmp6_ = string_strip (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strcmp0 (_tmp7_, "") == 0;
		_g_free0 (_tmp7_);
		if (_tmp8_) {
			g_signal_emit (self, mail_alias_signals[MAIL_ALIAS_FINISH_DELETE_SIGNAL], 0);
		}
	}
}

static void
__mail_alias___lambda21__gtk_popover_closed (GtkPopover* _sender,
                                             gpointer self)
{
	_mail_alias___lambda21_ (self);
}

static void
_mail_alias_update_label_g_object_notify (GObject* _sender,
                                          GParamSpec* pspec,
                                          gpointer self)
{
	mail_alias_update_label ((MailAlias*) self);
}

static void
_mail_alias___lambda22_ (MailAlias* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = self->priv->_address;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->old_address);
	self->priv->old_address = _tmp1_;
}

static void
__mail_alias___lambda22__mail_alias_save (MailAlias* _sender,
                                          const gchar* old_address,
                                          gpointer self)
{
	_mail_alias___lambda22_ ((MailAlias*) self);
}

static void
_gtk_popover_popdown_gtk_entry_activate (GtkEntry* _sender,
                                         gpointer self)
{
	gtk_popover_popdown ((GtkPopover*) self);
}

static gboolean
__lambda24_ (Block36Data* _data36_)
{
	MailAlias* self;
	GtkPopover* _tmp0_;
	gboolean result;
	self = _data36_->self;
	_tmp0_ = _data36_->edit_popover;
	gtk_popover_popdown (_tmp0_);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda24__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda24_ (self);
	return result;
}

static void
_mail_alias___lambda23_ (Block36Data* _data36_)
{
	MailAlias* self;
	self = _data36_->self;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda24__gsource_func, block36_data_ref (_data36_), block36_data_unref);
}

static void
__mail_alias___lambda23__gtk_entry_activate (GtkEntry* _sender,
                                             gpointer self)
{
	_mail_alias___lambda23_ (self);
}

static gboolean
__lambda26_ (MailAlias* self)
{
	gboolean result;
	g_signal_emit (self, mail_alias_signals[MAIL_ALIAS_FINISH_DELETE_SIGNAL], 0);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda26__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda26_ ((MailAlias*) self);
	return result;
}

static void
_mail_alias___lambda25_ (Block36Data* _data36_)
{
	MailAlias* self;
	GtkPopover* _tmp0_;
	const gchar* _tmp1_;
	self = _data36_->self;
	_tmp0_ = _data36_->edit_popover;
	gtk_popover_popdown (_tmp0_);
	_tmp1_ = self->priv->old_address;
	if (g_strcmp0 (_tmp1_, "") == 0) {
		return;
	}
	self->priv->timeout_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 5, ___lambda26__gsource_func, g_object_ref (self), g_object_unref);
	g_signal_emit (self, mail_alias_signals[MAIL_ALIAS_START_DELETE_SIGNAL], 0);
}

static void
__mail_alias___lambda25__gtk_button_clicked (GtkButton* _sender,
                                             gpointer self)
{
	_mail_alias___lambda25_ (self);
}

static GObject *
mail_alias_constructor (GType type,
                        guint n_construct_properties,
                        GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	MailAlias * self;
	Block36Data* _data36_;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GtkLabel* _tmp2_ = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GtkEntry* _tmp6_ = NULL;
	GtkEntry* _tmp7_;
	GraniteHeaderLabel* edit_name_label = NULL;
	GtkEntry* _tmp8_;
	GtkWidget* _tmp9_;
	GraniteHeaderLabel* _tmp10_ = NULL;
	GRegex* regex = NULL;
	GRegex* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	GraniteValidatedEntry* _tmp20_ = NULL;
	GraniteValidatedEntry* _tmp21_;
	GraniteHeaderLabel* edit_address_label = NULL;
	GraniteValidatedEntry* _tmp22_;
	GtkWidget* _tmp23_;
	GraniteHeaderLabel* _tmp24_ = NULL;
	GtkButton* delete_button = NULL;
	gchar* _tmp25_;
	GtkButton* _tmp26_ = NULL;
	GtkBox* edit_popover_content = NULL;
	GtkBox* _tmp27_ = NULL;
	GtkBox* _tmp28_;
	GraniteHeaderLabel* _tmp29_;
	GtkBox* _tmp30_;
	GtkEntry* _tmp31_;
	GtkBox* _tmp32_;
	GraniteHeaderLabel* _tmp33_;
	GtkBox* _tmp34_;
	GraniteValidatedEntry* _tmp35_;
	GtkBox* _tmp36_;
	GtkBox* _tmp37_;
	GtkWidget* _tmp38_;
	GtkPopover* _tmp39_ = NULL;
	GtkImage* _tmp40_;
	GtkPopover* _tmp41_;
	GtkPopover* _tmp42_;
	gchar* _tmp43_;
	GtkMenuButton* _tmp44_ = NULL;
	GtkBox* box = NULL;
	GtkBox* _tmp45_ = NULL;
	GtkBox* _tmp46_;
	GtkLabel* _tmp47_;
	GtkBox* _tmp48_;
	GtkMenuButton* _tmp49_;
	GtkBox* _tmp50_;
	GtkButton* _tmp51_;
	GtkBox* _tmp52_;
	GtkPopover* _tmp53_;
	GtkPopover* _tmp54_;
	GtkEntry* _tmp55_;
	GtkPopover* _tmp56_;
	GraniteValidatedEntry* _tmp57_;
	GtkButton* _tmp58_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (mail_alias_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAIL_TYPE_ALIAS, MailAlias);
	_data36_ = g_slice_new0 (Block36Data);
	_data36_->_ref_count_ = 1;
	_data36_->self = g_object_ref (self);
	_tmp0_ = self->priv->_address;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->old_address);
	self->priv->old_address = _tmp1_;
	_tmp2_ = (GtkLabel*) gtk_label_new ("");
	gtk_widget_set_hexpand ((GtkWidget*) _tmp2_, TRUE);
	gtk_label_set_xalign (_tmp2_, (gfloat) 0);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->label);
	self->priv->label = _tmp2_;
	_tmp3_ = self->priv->_alias_name;
	_tmp4_ = g_strdup (_tmp3_);
	_tmp5_ = g_strdup (_ ("John Doe"));
	_tmp6_ = (GtkEntry*) gtk_entry_new ();
	gtk_widget_set_margin_start ((GtkWidget*) _tmp6_, 12);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp6_, 12);
	gtk_entry_set_text (_tmp6_, _tmp4_);
	_g_free0 (_tmp4_);
	gtk_entry_set_placeholder_text (_tmp6_, _tmp5_);
	_g_free0 (_tmp5_);
	g_object_ref_sink (_tmp6_);
	_data36_->name_entry = _tmp6_;
	_tmp7_ = _data36_->name_entry;
	g_object_bind_property_with_closures ((GObject*) _tmp7_, "text", (GObject*) self, "alias-name", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp8_ = _data36_->name_entry;
	_tmp9_ = _g_object_ref0 ((GtkWidget*) _tmp8_);
	_tmp10_ = granite_header_label_new (_ ("Name"));
	gtk_label_set_mnemonic_widget ((GtkLabel*) _tmp10_, _tmp9_);
	_g_object_unref0 (_tmp9_);
	g_object_ref_sink (_tmp10_);
	edit_name_label = _tmp10_;
	regex = NULL;
	{
		GRegex* _tmp11_ = NULL;
		GRegex* _tmp12_;
		GRegex* _tmp13_;
		_tmp12_ = g_regex_new ("(?:[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*|\"" \
"(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21\\x23-\\x5b\\x5d-\\x7f]|\\\\[" \
"\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])*\")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z" \
"0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\\[(?:(?:(2(5[0-5]|[0-4][0-" \
"9])|1[0-9][0-9]|[1-9]?[0-9]))\\.){3}(?:(2(5[0-5]|[0-4][0-9])|1[0-9][0-" \
"9]|[1-9]?[0-9])|[a-z0-9-]*[a-z0-9]:(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1" \
"f\\x21-\\x5a\\x53-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])+)\\])", 0, 0, &_inner_error0_);
		_tmp11_ = _tmp12_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp13_ = _tmp11_;
		_tmp11_ = NULL;
		_g_regex_unref0 (regex);
		regex = _tmp13_;
		_g_regex_unref0 (_tmp11_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp14_;
		const gchar* _tmp15_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		g_warning ("Alias.vala:64: Failed to create regex: %s", _tmp15_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_regex_unref0 (regex);
		_g_object_unref0 (edit_name_label);
		block36_data_unref (_data36_);
		_data36_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	_tmp16_ = regex;
	_tmp17_ = self->priv->_address;
	_tmp18_ = g_strdup (_tmp17_);
	_tmp19_ = g_strdup (_ ("Email@example.com"));
	_tmp20_ = granite_validated_entry_new_from_regex (_tmp16_);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp20_, 12);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp20_, 12);
	gtk_entry_set_text ((GtkEntry*) _tmp20_, _tmp18_);
	_g_free0 (_tmp18_);
	gtk_entry_set_placeholder_text ((GtkEntry*) _tmp20_, _tmp19_);
	_g_free0 (_tmp19_);
	g_object_ref_sink (_tmp20_);
	_data36_->address_entry = _tmp20_;
	_tmp21_ = _data36_->address_entry;
	g_object_bind_property_with_closures ((GObject*) _tmp21_, "text", (GObject*) self, "address", G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp22_ = _data36_->address_entry;
	_tmp23_ = _g_object_ref0 ((GtkWidget*) _tmp22_);
	_tmp24_ = granite_header_label_new (_ ("E-mail Address"));
	gtk_label_set_mnemonic_widget ((GtkLabel*) _tmp24_, _tmp23_);
	_g_object_unref0 (_tmp23_);
	g_object_ref_sink (_tmp24_);
	edit_address_label = _tmp24_;
	_tmp25_ = g_strdup (_ ("Delete alias"));
	_tmp26_ = (GtkButton*) gtk_button_new_from_icon_name ("edit-delete-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp26_, _tmp25_);
	_g_free0 (_tmp25_);
	g_object_ref_sink (_tmp26_);
	delete_button = _tmp26_;
	_tmp27_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp27_, 6);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp27_, 12);
	g_object_ref_sink (_tmp27_);
	edit_popover_content = _tmp27_;
	_tmp28_ = edit_popover_content;
	_tmp29_ = edit_name_label;
	gtk_container_add ((GtkContainer*) _tmp28_, (GtkWidget*) _tmp29_);
	_tmp30_ = edit_popover_content;
	_tmp31_ = _data36_->name_entry;
	gtk_container_add ((GtkContainer*) _tmp30_, (GtkWidget*) _tmp31_);
	_tmp32_ = edit_popover_content;
	_tmp33_ = edit_address_label;
	gtk_container_add ((GtkContainer*) _tmp32_, (GtkWidget*) _tmp33_);
	_tmp34_ = edit_popover_content;
	_tmp35_ = _data36_->address_entry;
	gtk_container_add ((GtkContainer*) _tmp34_, (GtkWidget*) _tmp35_);
	_tmp36_ = edit_popover_content;
	gtk_widget_show_all ((GtkWidget*) _tmp36_);
	_tmp37_ = edit_popover_content;
	_tmp38_ = _g_object_ref0 ((GtkWidget*) _tmp37_);
	_tmp39_ = (GtkPopover*) gtk_popover_new (NULL);
	g_object_set ((GtkContainer*) _tmp39_, "child", _tmp38_, NULL);
	_g_object_unref0 (_tmp38_);
	g_object_ref_sink (_tmp39_);
	_data36_->edit_popover = _tmp39_;
	_tmp40_ = (GtkImage*) gtk_image_new_from_icon_name ("document-edit-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp40_);
	_tmp41_ = _data36_->edit_popover;
	_tmp42_ = _g_object_ref0 (_tmp41_);
	_tmp43_ = g_strdup (_ ("Edit alias"));
	_tmp44_ = (GtkMenuButton*) gtk_menu_button_new ();
	gtk_button_set_image ((GtkButton*) _tmp44_, (GtkWidget*) _tmp40_);
	_g_object_unref0 (_tmp40_);
	gtk_menu_button_set_popover (_tmp44_, _tmp42_);
	_g_object_unref0 (_tmp42_);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp44_, _tmp43_);
	_g_free0 (_tmp43_);
	g_object_ref_sink (_tmp44_);
	_data36_->edit_button = _tmp44_;
	_tmp45_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp45_, 6);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp45_, 6);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp45_, 6);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp45_, 6);
	g_object_ref_sink (_tmp45_);
	box = _tmp45_;
	_tmp46_ = box;
	_tmp47_ = self->priv->label;
	gtk_container_add ((GtkContainer*) _tmp46_, (GtkWidget*) _tmp47_);
	_tmp48_ = box;
	_tmp49_ = _data36_->edit_button;
	gtk_container_add ((GtkContainer*) _tmp48_, (GtkWidget*) _tmp49_);
	_tmp50_ = box;
	_tmp51_ = delete_button;
	gtk_container_add ((GtkContainer*) _tmp50_, (GtkWidget*) _tmp51_);
	_tmp52_ = box;
	g_object_set ((GtkContainer*) self, "child", (GtkWidget*) _tmp52_, NULL);
	gtk_widget_show_all ((GtkWidget*) self);
	g_signal_connect_data ((GtkWidget*) self, "map", (GCallback) __mail_alias___lambda18__gtk_widget_map, block36_data_ref (_data36_), (GClosureNotify) block36_data_unref, 0);
	_tmp53_ = _data36_->edit_popover;
	g_signal_connect_data ((GtkWidget*) _tmp53_, "map", (GCallback) __mail_alias___lambda19__gtk_widget_map, block36_data_ref (_data36_), (GClosureNotify) block36_data_unref, 0);
	_tmp54_ = _data36_->edit_popover;
	g_signal_connect_data (_tmp54_, "closed", (GCallback) __mail_alias___lambda21__gtk_popover_closed, block36_data_ref (_data36_), (GClosureNotify) block36_data_unref, 0);
	g_signal_connect_object ((GObject*) self, "notify::alias-name", (GCallback) _mail_alias_update_label_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::address", (GCallback) _mail_alias_update_label_g_object_notify, self, 0);
	mail_alias_update_label (self);
	g_signal_connect_object (self, "save", (GCallback) __mail_alias___lambda22__mail_alias_save, self, 0);
	_tmp55_ = _data36_->name_entry;
	_tmp56_ = _data36_->edit_popover;
	g_signal_connect_object (_tmp55_, "activate", (GCallback) _gtk_popover_popdown_gtk_entry_activate, _tmp56_, 0);
	_tmp57_ = _data36_->address_entry;
	g_signal_connect_data ((GtkEntry*) _tmp57_, "activate", (GCallback) __mail_alias___lambda23__gtk_entry_activate, block36_data_ref (_data36_), (GClosureNotify) block36_data_unref, 0);
	_tmp58_ = delete_button;
	g_signal_connect_data (_tmp58_, "clicked", (GCallback) __mail_alias___lambda25__gtk_button_clicked, block36_data_ref (_data36_), (GClosureNotify) block36_data_unref, 0);
	_g_object_unref0 (box);
	_g_object_unref0 (edit_popover_content);
	_g_object_unref0 (delete_button);
	_g_object_unref0 (edit_address_label);
	_g_regex_unref0 (regex);
	_g_object_unref0 (edit_name_label);
	block36_data_unref (_data36_);
	_data36_ = NULL;
	return obj;
}

static void
mail_alias_class_init (MailAliasClass * klass,
                       gpointer klass_data)
{
	mail_alias_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MailAlias_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_mail_alias_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_mail_alias_set_property;
	G_OBJECT_CLASS (klass)->constructor = mail_alias_constructor;
	G_OBJECT_CLASS (klass)->finalize = mail_alias_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIL_ALIAS_ADDRESS_PROPERTY, mail_alias_properties[MAIL_ALIAS_ADDRESS_PROPERTY] = g_param_spec_string ("address", "address", "address", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIL_ALIAS_ALIAS_NAME_PROPERTY, mail_alias_properties[MAIL_ALIAS_ALIAS_NAME_PROPERTY] = g_param_spec_string ("alias-name", "alias-name", "alias-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIL_ALIAS_IS_DELETED_PROPERTY, mail_alias_properties[MAIL_ALIAS_IS_DELETED_PROPERTY] = g_param_spec_boolean ("is-deleted", "is-deleted", "is-deleted", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	mail_alias_signals[MAIL_ALIAS_SAVE_SIGNAL] = g_signal_new ("save", MAIL_TYPE_ALIAS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	mail_alias_signals[MAIL_ALIAS_FINISH_DELETE_SIGNAL] = g_signal_new ("finish-delete", MAIL_TYPE_ALIAS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	mail_alias_signals[MAIL_ALIAS_START_DELETE_SIGNAL] = g_signal_new ("start-delete", MAIL_TYPE_ALIAS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
mail_alias_instance_init (MailAlias * self,
                          gpointer klass)
{
	self->priv = mail_alias_get_instance_private (self);
	self->priv->timeout_id = (guint) 0;
}

static void
mail_alias_finalize (GObject * obj)
{
	MailAlias * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAIL_TYPE_ALIAS, MailAlias);
	_g_free0 (self->priv->_address);
	_g_free0 (self->priv->_alias_name);
	_g_object_unref0 (self->priv->label);
	_g_free0 (self->priv->old_address);
	G_OBJECT_CLASS (mail_alias_parent_class)->finalize (obj);
}

static GType
mail_alias_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MailAliasClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mail_alias_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MailAlias), 0, (GInstanceInitFunc) mail_alias_instance_init, NULL };
	GType mail_alias_type_id;
	mail_alias_type_id = g_type_register_static (gtk_list_box_row_get_type (), "MailAlias", &g_define_type_info, 0);
	MailAlias_private_offset = g_type_add_instance_private (mail_alias_type_id, sizeof (MailAliasPrivate));
	return mail_alias_type_id;
}

GType
mail_alias_get_type (void)
{
	static volatile gsize mail_alias_type_id__once = 0;
	if (g_once_init_enter (&mail_alias_type_id__once)) {
		GType mail_alias_type_id;
		mail_alias_type_id = mail_alias_get_type_once ();
		g_once_init_leave (&mail_alias_type_id__once, mail_alias_type_id);
	}
	return mail_alias_type_id__once;
}

static void
_vala_mail_alias_get_property (GObject * object,
                               guint property_id,
                               GValue * value,
                               GParamSpec * pspec)
{
	MailAlias * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MAIL_TYPE_ALIAS, MailAlias);
	switch (property_id) {
		case MAIL_ALIAS_ADDRESS_PROPERTY:
		g_value_set_string (value, mail_alias_get_address (self));
		break;
		case MAIL_ALIAS_ALIAS_NAME_PROPERTY:
		g_value_set_string (value, mail_alias_get_alias_name (self));
		break;
		case MAIL_ALIAS_IS_DELETED_PROPERTY:
		g_value_set_boolean (value, mail_alias_get_is_deleted (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_mail_alias_set_property (GObject * object,
                               guint property_id,
                               const GValue * value,
                               GParamSpec * pspec)
{
	MailAlias * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MAIL_TYPE_ALIAS, MailAlias);
	switch (property_id) {
		case MAIL_ALIAS_ADDRESS_PROPERTY:
		mail_alias_set_address (self, g_value_get_string (value));
		break;
		case MAIL_ALIAS_ALIAS_NAME_PROPERTY:
		mail_alias_set_alias_name (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

