/* Window.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Window.vala, do not modify */

/*
* Copyright (c) 2010 Mathijs Henquet <mathijs.henquet@gmail.com>
*               2017-2020 elementary, Inc. <https://elementary.io>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 3 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Mathijs Henquet <mathijs.henquet@gmail.com>
*              ammonkey <am.monkeyd@gmail.com>
*/

#include <handy.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "pantheon-files-core.h"
#include <glib.h>
#include <gio/gio.h>
#include <granite.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define FILES_VIEW_TYPE_WINDOW (files_view_window_get_type ())
#define FILES_VIEW_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_VIEW_TYPE_WINDOW, FilesViewWindow))
#define FILES_VIEW_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_VIEW_TYPE_WINDOW, FilesViewWindowClass))
#define FILES_VIEW_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_VIEW_TYPE_WINDOW))
#define FILES_VIEW_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_VIEW_TYPE_WINDOW))
#define FILES_VIEW_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_VIEW_TYPE_WINDOW, FilesViewWindowClass))

typedef struct _FilesViewWindow FilesViewWindow;
typedef struct _FilesViewWindowClass FilesViewWindowClass;
typedef struct _FilesViewWindowPrivate FilesViewWindowPrivate;

#define FILES_TYPE_APPLICATION (files_application_get_type ())
#define FILES_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_APPLICATION, FilesApplication))
#define FILES_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_APPLICATION, FilesApplicationClass))
#define FILES_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_APPLICATION))
#define FILES_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_APPLICATION))
#define FILES_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_APPLICATION, FilesApplicationClass))

typedef struct _FilesApplication FilesApplication;
typedef struct _FilesApplicationClass FilesApplicationClass;

#define FILES_VIEW_CHROME_TYPE_LOCATION_BAR (files_view_chrome_location_bar_get_type ())
#define FILES_VIEW_CHROME_LOCATION_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_VIEW_CHROME_TYPE_LOCATION_BAR, FilesViewChromeLocationBar))
#define FILES_VIEW_CHROME_LOCATION_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_VIEW_CHROME_TYPE_LOCATION_BAR, FilesViewChromeLocationBarClass))
#define FILES_VIEW_CHROME_IS_LOCATION_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_VIEW_CHROME_TYPE_LOCATION_BAR))
#define FILES_VIEW_CHROME_IS_LOCATION_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_VIEW_CHROME_TYPE_LOCATION_BAR))
#define FILES_VIEW_CHROME_LOCATION_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_VIEW_CHROME_TYPE_LOCATION_BAR, FilesViewChromeLocationBarClass))

typedef struct _FilesViewChromeLocationBar FilesViewChromeLocationBar;
typedef struct _FilesViewChromeLocationBarClass FilesViewChromeLocationBarClass;
enum  {
	FILES_VIEW_WINDOW_0_PROPERTY,
	FILES_VIEW_WINDOW_WINDOW_NUMBER_PROPERTY,
	FILES_VIEW_WINDOW_IS_FIRST_WINDOW_PROPERTY,
	FILES_VIEW_WINDOW_DEFAULT_MODE_PROPERTY,
	FILES_VIEW_WINDOW_DEFAULT_LOCATION_PROPERTY,
	FILES_VIEW_WINDOW_MARLIN_APP_PROPERTY,
	FILES_VIEW_WINDOW_NUM_PROPERTIES
};
static GParamSpec* files_view_window_properties[FILES_VIEW_WINDOW_NUM_PROPERTIES];
typedef void (*GSimpleActionActivateCallback) (GSimpleAction* action, GVariant* parameter, gpointer user_data);
typedef void (*GSimpleActionChangeStateCallback) (GSimpleAction* action, GVariant* value, gpointer user_data);
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define FILES_TYPE_APP_MENU (files_app_menu_get_type ())
#define FILES_APP_MENU(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_APP_MENU, FilesAppMenu))
#define FILES_APP_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_APP_MENU, FilesAppMenuClass))
#define FILES_IS_APP_MENU(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_APP_MENU))
#define FILES_IS_APP_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_APP_MENU))
#define FILES_APP_MENU_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_APP_MENU, FilesAppMenuClass))

typedef struct _FilesAppMenu FilesAppMenu;
typedef struct _FilesAppMenuClass FilesAppMenuClass;
typedef struct _Block49Data Block49Data;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

#define SIDEBAR_TYPE_SIDEBAR_WINDOW (sidebar_sidebar_window_get_type ())
#define SIDEBAR_SIDEBAR_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIDEBAR_TYPE_SIDEBAR_WINDOW, SidebarSidebarWindow))
#define SIDEBAR_SIDEBAR_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIDEBAR_TYPE_SIDEBAR_WINDOW, SidebarSidebarWindowClass))
#define SIDEBAR_IS_SIDEBAR_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIDEBAR_TYPE_SIDEBAR_WINDOW))
#define SIDEBAR_IS_SIDEBAR_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIDEBAR_TYPE_SIDEBAR_WINDOW))
#define SIDEBAR_SIDEBAR_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIDEBAR_TYPE_SIDEBAR_WINDOW, SidebarSidebarWindowClass))

typedef struct _SidebarSidebarWindow SidebarSidebarWindow;
typedef struct _SidebarSidebarWindowClass SidebarSidebarWindowClass;
typedef struct _Block50Data Block50Data;

#define FILES_VIEW_TYPE_VIEW_CONTAINER (files_view_view_container_get_type ())
#define FILES_VIEW_VIEW_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_VIEW_TYPE_VIEW_CONTAINER, FilesViewViewContainer))
#define FILES_VIEW_VIEW_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_VIEW_TYPE_VIEW_CONTAINER, FilesViewViewContainerClass))
#define FILES_VIEW_IS_VIEW_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_VIEW_TYPE_VIEW_CONTAINER))
#define FILES_VIEW_IS_VIEW_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_VIEW_TYPE_VIEW_CONTAINER))
#define FILES_VIEW_VIEW_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_VIEW_TYPE_VIEW_CONTAINER, FilesViewViewContainerClass))

typedef struct _FilesViewViewContainer FilesViewViewContainer;
typedef struct _FilesViewViewContainerClass FilesViewViewContainerClass;
typedef struct _Block51Data Block51Data;
typedef struct _FilesViewViewContainerPrivate FilesViewViewContainerPrivate;
typedef struct _FilesViewWindowOpenTabsData FilesViewWindowOpenTabsData;
typedef struct _FilesViewWindowAddTabByUriData FilesViewWindowAddTabByUriData;
typedef struct _FilesViewWindowAddTabData FilesViewWindowAddTabData;
typedef struct _Block52Data Block52Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block53Data Block53Data;
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))

#define FILES_VIEW_TYPE_MILLER (files_view_miller_get_type ())
#define FILES_VIEW_MILLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_VIEW_TYPE_MILLER, FilesViewMiller))
#define FILES_VIEW_MILLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_VIEW_TYPE_MILLER, FilesViewMillerClass))
#define FILES_VIEW_IS_MILLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_VIEW_TYPE_MILLER))
#define FILES_VIEW_IS_MILLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_VIEW_TYPE_MILLER))
#define FILES_VIEW_MILLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_VIEW_TYPE_MILLER, FilesViewMillerClass))

typedef struct _FilesViewMiller FilesViewMiller;
typedef struct _FilesViewMillerClass FilesViewMillerClass;
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
typedef struct _FilesViewWindowRestoreTabsData FilesViewWindowRestoreTabsData;

#define FILES_VIEW_TYPE_SLOT (files_view_slot_get_type ())
#define FILES_VIEW_SLOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_VIEW_TYPE_SLOT, FilesViewSlot))
#define FILES_VIEW_SLOT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_VIEW_TYPE_SLOT, FilesViewSlotClass))
#define FILES_VIEW_IS_SLOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_VIEW_TYPE_SLOT))
#define FILES_VIEW_IS_SLOT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_VIEW_TYPE_SLOT))
#define FILES_VIEW_SLOT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_VIEW_TYPE_SLOT, FilesViewSlotClass))

typedef struct _FilesViewSlot FilesViewSlot;
typedef struct _FilesViewSlotClass FilesViewSlotClass;
typedef struct _FilesViewMillerPrivate FilesViewMillerPrivate;
enum  {
	FILES_VIEW_WINDOW_LOADING_URI_SIGNAL,
	FILES_VIEW_WINDOW_FOLDER_DELETED_SIGNAL,
	FILES_VIEW_WINDOW_FREE_SPACE_CHANGE_SIGNAL,
	FILES_VIEW_WINDOW_NUM_SIGNALS
};
static guint files_view_window_signals[FILES_VIEW_WINDOW_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _FilesViewWindow {
	HdyApplicationWindow parent_instance;
	FilesViewWindowPrivate * priv;
	GtkBuilder* ui;
	HdyHeaderBar* headerbar;
	FilesViewChromeViewSwitcher* view_switcher;
	HdyTabView* tab_view;
	HdyTabBar* tab_bar;
	FilesSidebarInterface* sidebar;
};

struct _FilesViewWindowClass {
	HdyApplicationWindowClass parent_class;
};

struct _FilesViewWindowPrivate {
	guint _window_number;
	FilesApplication* _marlin_app;
	FilesUndoManager* undo_manager;
	GtkPaned* lside_pane;
	FilesViewChromeButtonWithMenu* button_forward;
	FilesViewChromeButtonWithMenu* button_back;
	FilesViewChromeLocationBar* location_bar;
	GtkMenuButton* tab_history_button;
	gboolean _locked_focus;
	gboolean tabs_restored;
	gint restoring_tabs;
	gboolean doing_undo_redo;
	GtkEventControllerKey* key_controller;
	gboolean adding_window;
};

struct _Block49Data {
	int _ref_count_;
	FilesViewWindow* self;
	FilesAppMenu* app_menu;
};

struct _Block50Data {
	int _ref_count_;
	FilesViewWindow* self;
	gchar* path;
	FilesOpenFlag flag;
};

struct _Block51Data {
	int _ref_count_;
	FilesViewWindow* self;
	gint tab_position;
	HdyTabPage* page;
};

struct _FilesViewViewContainer {
	GtkBox parent_instance;
	FilesViewViewContainerPrivate * priv;
	GtkWidget* content_item;
	FilesAbstractSlot* view;
	FilesViewMode view_mode;
};

struct _FilesViewViewContainerClass {
	GtkBoxClass parent_class;
};

struct _FilesViewWindowOpenTabsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FilesViewWindow* self;
	GFile** files;
	gint files_length1;
	FilesViewMode mode;
	gboolean ignore_duplicate;
	guint n_tabs_restored;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	GFile** file_collection;
	gint file_collection_length1;
	gint _file_collection_size_;
	gint file_it;
	GFile* _tmp7_;
	GFile* file;
	GFile* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GFile* _tmp11_;
	GFile* _tmp12_;
};

struct _FilesViewWindowAddTabByUriData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FilesViewWindow* self;
	gchar* uri;
	FilesViewMode mode;
	gboolean result;
	GFile* file;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	gboolean _tmp6_;
};

struct _FilesViewWindowAddTabData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FilesViewWindow* self;
	GFile* _location;
	FilesViewMode mode;
	gboolean ignore_duplicate;
	gboolean result;
	GFile* location;
	GFileType ftype;
	GFileInfo* info;
	GFileInfo* _tmp0_;
	GFileInfo* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	gboolean is_child;
	gint existing_tab_position;
	GFile* _tmp4_;
	gboolean _tmp5_;
	gint _tmp6_;
	HdyTabView* _tmp7_;
	HdyTabView* _tmp8_;
	HdyTabPage* _tmp9_;
	FilesViewViewContainer* _tmp10_;
	FilesViewViewContainer* _tmp11_;
	FilesViewViewContainer* content;
	FilesViewViewContainer* _tmp12_;
	GFile* _tmp13_;
	FilesViewViewContainer* _tmp14_;
	GFile* _tmp15_;
	GFile* _tmp16_;
	GFile** _tmp17_;
	GFile** _tmp18_;
	gint _tmp18__length1;
	FilesViewViewContainer* _tmp19_;
	GFile* _tmp20_;
	HdyTabPage* page;
	HdyTabView* _tmp21_;
	FilesViewViewContainer* _tmp22_;
	HdyTabPage* _tmp23_;
	HdyTabPage* _tmp24_;
	HdyTabView* _tmp25_;
	HdyTabPage* _tmp26_;
	FilesViewViewContainer* _tmp27_;
	GError* _inner_error0_;
};

struct _Block52Data {
	int _ref_count_;
	FilesViewWindow* self;
	HdyTabPage* tab;
};

struct _Block53Data {
	int _ref_count_;
	FilesViewWindow* self;
	PFConnectServerDialog* dialog;
	gchar* server_uri;
};

struct _FilesViewWindowRestoreTabsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FilesViewWindow* self;
	guint result;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	FilesPreferences* _tmp6_;
	FilesPreferences* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	GSettings* _tmp10_;
	GVariant* tab_info_array;
	GSettings* _tmp11_;
	GVariant* _tmp12_;
	GVariantIter* iter;
	GVariant* _tmp13_;
	GVariantIter* _tmp14_;
	FilesViewMode mode;
	gchar* root_uri;
	gchar* tip_uri;
	GVariantIter* _tmp15_;
	FilesViewMode _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp20_;
	gboolean _tmp21_;
	gboolean _tmp22_;
	gboolean _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	gint _tmp28_;
	HdyTabPage* tab;
	HdyTabView* _tmp29_;
	HdyTabPage* _tmp30_;
	HdyTabPage* _tmp31_;
	HdyTabPage* _tmp32_;
	gboolean _tmp33_;
	gboolean _tmp34_;
	HdyTabPage* _tmp35_;
	HdyTabPage* _tmp36_;
	GtkWidget* _tmp37_;
	GtkWidget* _tmp38_;
	const gchar* _tmp39_;
	const gchar* _tmp40_;
	FilesAbstractSlot* view;
	HdyTabPage* _tmp41_;
	GtkWidget* _tmp42_;
	GtkWidget* _tmp43_;
	FilesAbstractSlot* _tmp44_;
	FilesAbstractSlot* _tmp45_;
	gboolean _tmp46_;
	FilesAbstractSlot* _tmp47_;
	FilesAbstractSlot* _tmp48_;
	FilesAbstractSlot* _tmp49_;
	const gchar* _tmp50_;
	const gchar* _tmp51_;
	const gchar* _tmp52_;
	gint active_tab_position;
	GSettings* _tmp53_;
	gboolean _tmp54_;
	gchar* path;
	gchar* _tmp55_;
	FilesViewViewContainer* _tmp56_;
	FilesViewViewContainer* _tmp57_;
	FilesViewViewContainer* _tmp58_;
	FilesViewViewContainer* _tmp59_;
	gchar* _tmp60_;
	gboolean _tmp61_;
	const gchar* _tmp62_;
	const gchar* _tmp63_;
	FilesViewViewContainer* _tmp64_;
	FilesViewViewContainer* _tmp65_;
	gchar* _tmp66_;
	const gchar* _tmp67_;
};

struct _FilesViewMiller {
	FilesAbstractSlot parent_instance;
	FilesViewMillerPrivate * priv;
	GtkAdjustment* hadj;
	FilesViewSlot* current_slot;
	GList* slot_list;
	gint total_width;
};

struct _FilesViewMillerClass {
	FilesAbstractSlotClass parent_class;
};

static gint FilesViewWindow_private_offset;
static gpointer files_view_window_parent_class = NULL;
static guint files_view_window_window_id;
static guint files_view_window_window_id = (guint) 0;
VALA_EXTERN GSettings* files_app_settings;
VALA_EXTERN GSettings* files_icon_view_settings;
VALA_EXTERN GSettings* files_list_view_settings;
VALA_EXTERN GSettings* files_column_view_settings;

VALA_EXTERN GType files_view_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesViewWindow, g_object_unref)
VALA_EXTERN GType files_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesApplication, g_object_unref)
VALA_EXTERN GType files_view_chrome_location_bar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesViewChromeLocationBar, g_object_unref)
static void files_view_window_action_new_window (FilesViewWindow* self,
                                          GSimpleAction* action,
                                          GVariant* param);
static void _files_view_window_action_new_window_gsimple_action_activate_callback (GSimpleAction* action,
                                                                            GVariant* parameter,
                                                                            gpointer self);
static void files_view_window_action_reload (FilesViewWindow* self);
static void _files_view_window_action_reload_gsimple_action_activate_callback (GSimpleAction* action,
                                                                        GVariant* parameter,
                                                                        gpointer self);
static void files_view_window_action_undo (FilesViewWindow* self,
                                    GSimpleAction* action,
                                    GVariant* param);
static void _files_view_window_action_undo_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self);
static void files_view_window_action_redo (FilesViewWindow* self,
                                    GSimpleAction* action,
                                    GVariant* param);
static void _files_view_window_action_redo_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self);
static void files_view_window_action_bookmark (FilesViewWindow* self,
                                        GSimpleAction* action,
                                        GVariant* param);
static void _files_view_window_action_bookmark_gsimple_action_activate_callback (GSimpleAction* action,
                                                                          GVariant* parameter,
                                                                          gpointer self);
static void files_view_window_action_find (FilesViewWindow* self,
                                    GSimpleAction* action,
                                    GVariant* param);
static void _files_view_window_action_find_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self);
static void files_view_window_action_edit_path (FilesViewWindow* self);
static void _files_view_window_action_edit_path_gsimple_action_activate_callback (GSimpleAction* action,
                                                                           GVariant* parameter,
                                                                           gpointer self);
static void files_view_window_action_tab (FilesViewWindow* self,
                                   GSimpleAction* action,
                                   GVariant* param);
static void _files_view_window_action_tab_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self);
static void files_view_window_action_go_to (FilesViewWindow* self,
                                     GSimpleAction* action,
                                     GVariant* param);
static void _files_view_window_action_go_to_gsimple_action_activate_callback (GSimpleAction* action,
                                                                       GVariant* parameter,
                                                                       gpointer self);
static void files_view_window_action_zoom (FilesViewWindow* self,
                                    GSimpleAction* action,
                                    GVariant* param);
static void _files_view_window_action_zoom_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self);
static void files_view_window_action_info (FilesViewWindow* self,
                                    GSimpleAction* action,
                                    GVariant* param);
static void _files_view_window_action_info_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self);
static void files_view_window_action_view_mode (FilesViewWindow* self,
                                         GSimpleAction* action,
                                         GVariant* param);
static void _files_view_window_action_view_mode_gsimple_action_activate_callback (GSimpleAction* action,
                                                                           GVariant* parameter,
                                                                           gpointer self);
VALA_EXTERN void files_view_window_change_state_show_hidden (FilesViewWindow* self,
                                                 GSimpleAction* action);
static void _files_view_window_change_state_show_hidden_gsimple_action_change_state_callback (GSimpleAction* action,
                                                                                       GVariant* value,
                                                                                       gpointer self);
VALA_EXTERN void files_view_window_change_state_single_click_select (FilesViewWindow* self,
                                                         GSimpleAction* action);
static void _files_view_window_change_state_single_click_select_gsimple_action_change_state_callback (GSimpleAction* action,
                                                                                               GVariant* value,
                                                                                               gpointer self);
VALA_EXTERN void files_view_window_change_state_show_remote_thumbnails (FilesViewWindow* self,
                                                            GSimpleAction* action);
static void _files_view_window_change_state_show_remote_thumbnails_gsimple_action_change_state_callback (GSimpleAction* action,
                                                                                                  GVariant* value,
                                                                                                  gpointer self);
VALA_EXTERN void files_view_window_change_state_show_local_thumbnails (FilesViewWindow* self,
                                                           GSimpleAction* action);
static void _files_view_window_change_state_show_local_thumbnails_gsimple_action_change_state_callback (GSimpleAction* action,
                                                                                                 GVariant* value,
                                                                                                 gpointer self);
static void files_view_window_action_tabhistory_restore (FilesViewWindow* self,
                                                  GSimpleAction* action,
                                                  GVariant* parameter);
static void _files_view_window_action_tabhistory_restore_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                    GVariant* parameter,
                                                                                    gpointer self);
VALA_EXTERN void files_view_window_change_state_folders_before_files (FilesViewWindow* self,
                                                          GSimpleAction* action);
static void _files_view_window_change_state_folders_before_files_gsimple_action_change_state_callback (GSimpleAction* action,
                                                                                                GVariant* value,
                                                                                                gpointer self);
VALA_EXTERN void files_view_window_change_state_restore_tabs_on_startup (FilesViewWindow* self,
                                                             GSimpleAction* action);
static void _files_view_window_change_state_restore_tabs_on_startup_gsimple_action_change_state_callback (GSimpleAction* action,
                                                                                                   GVariant* value,
                                                                                                   gpointer self);
static void files_view_window_action_forward (FilesViewWindow* self,
                                       GSimpleAction* action,
                                       GVariant* param);
static void _files_view_window_action_forward_gsimple_action_activate_callback (GSimpleAction* action,
                                                                         GVariant* parameter,
                                                                         gpointer self);
static void files_view_window_action_back (FilesViewWindow* self,
                                    GSimpleAction* action,
                                    GVariant* param);
static void _files_view_window_action_back_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self);
static void files_view_window_action_focus_sidebar (FilesViewWindow* self);
static void _files_view_window_action_focus_sidebar_gsimple_action_activate_callback (GSimpleAction* action,
                                                                               GVariant* parameter,
                                                                               gpointer self);
VALA_EXTERN FilesViewWindow* files_view_window_new (FilesApplication* _application);
VALA_EXTERN FilesViewWindow* files_view_window_construct (GType object_type,
                                              FilesApplication* _application);
static void files_view_window_build_window (FilesViewWindow* self);
VALA_EXTERN GType files_app_menu_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesAppMenu, g_object_unref)
static Block49Data* block49_data_ref (Block49Data* _data49_);
static void block49_data_unref (void * _userdata_);
VALA_EXTERN FilesViewChromeLocationBar* files_view_chrome_location_bar_new (void);
VALA_EXTERN FilesViewChromeLocationBar* files_view_chrome_location_bar_construct (GType object_type);
VALA_EXTERN FilesAppMenu* files_app_menu_new (void);
VALA_EXTERN FilesAppMenu* files_app_menu_construct (GType object_type);
VALA_EXTERN SidebarSidebarWindow* sidebar_sidebar_window_new (void);
VALA_EXTERN SidebarSidebarWindow* sidebar_sidebar_window_construct (GType object_type);
VALA_EXTERN GType sidebar_sidebar_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SidebarSidebarWindow, g_object_unref)
static void _files_sidebar_interface_on_free_space_change_files_view_window_free_space_change (FilesViewWindow* _sender,
                                                                                        gpointer self);
VALA_EXTERN GSimpleAction* files_view_window_get_action (FilesViewWindow* self,
                                             const gchar* action_name);
static GVariant* _variant_new11 (gboolean value);
static GVariant* _variant_new12 (gboolean value);
static GVariant* _variant_new13 (gboolean value);
static GVariant* _variant_new14 (gboolean value);
static GVariant* _variant_new15 (gboolean value);
static GVariant* _variant_new16 (gboolean value);
static void __lambda189_ (Block49Data* _data49_,
                   GVariant* id);
VALA_EXTERN void files_app_menu_on_zoom_setting_changed (FilesAppMenu* self,
                                             GSettings* settings,
                                             const gchar* key);
static void ___lambda189__g_simple_action_activate (GSimpleAction* _sender,
                                             GVariant* parameter,
                                             gpointer self);
static void __lambda190_ (FilesViewWindow* self);
static void ___lambda190__files_view_chrome_button_with_menu_slow_press (FilesViewChromeButtonWithMenu* _sender,
                                                                  gpointer self);
static void __lambda191_ (FilesViewWindow* self);
static void ___lambda191__files_view_chrome_button_with_menu_slow_press (FilesViewChromeButtonWithMenu* _sender,
                                                                  gpointer self);
VALA_EXTERN void files_view_window_grab_focus (FilesViewWindow* self);
static void _files_view_window_grab_focus_files_view_chrome_location_bar_escape (FilesViewChromeLocationBar* _sender,
                                                                          gpointer self);
static void __lambda192_ (FilesViewWindow* self,
                   const gchar* path,
                   FilesOpenFlag flag);
static Block50Data* block50_data_ref (Block50Data* _data50_);
static void block50_data_unref (void * _userdata_);
VALA_EXTERN GType files_view_view_container_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesViewViewContainer, g_object_unref)
static FilesViewViewContainer* files_view_window_get_current_container (FilesViewWindow* self);
VALA_EXTERN void files_view_view_container_set_is_frozen (FilesViewViewContainer* self,
                                              gboolean value);
static gboolean __lambda193_ (Block50Data* _data50_);
VALA_EXTERN void files_view_window_uri_path_change_request (FilesViewWindow* self,
                                                const gchar* p,
                                                FilesOpenFlag flag);
static gboolean ___lambda193__gsource_func (gpointer self);
static void ___lambda192__files_view_chrome_locatable_path_change_request (FilesViewChromeLocatable* _sender,
                                                                    const gchar* path,
                                                                    FilesOpenFlag flag,
                                                                    gpointer self);
static void __lambda194_ (FilesViewWindow* self,
                   GFile* loc);
VALA_EXTERN void files_view_view_container_focus_location_if_in_current_directory (FilesViewViewContainer* self,
                                                                       GFile* loc,
                                                                       gboolean unselect_others);
static void ___lambda194__files_view_chrome_location_bar_focus_file_request (FilesViewChromeLocationBar* _sender,
                                                                      GFile* file,
                                                                      gpointer self);
static gboolean __lambda195_ (FilesViewWindow* self,
                       GdkEventFocus* event);
static void files_view_window_set_locked_focus (FilesViewWindow* self,
                                         gboolean value);
static gboolean ___lambda195__gtk_widget_focus_in_event (GtkWidget* _sender,
                                                  GdkEventFocus* event,
                                                  gpointer self);
static gboolean __lambda196_ (FilesViewWindow* self,
                       GdkEventFocus* event);
static gboolean ___lambda196__gtk_widget_focus_out_event (GtkWidget* _sender,
                                                   GdkEventFocus* event,
                                                   gpointer self);
static void files_view_window_update_undo_actions (FilesViewWindow* self);
static void _files_view_window_update_undo_actions_files_undo_manager_request_menu_update (FilesUndoManager* _sender,
                                                                                    gpointer self);
static gboolean __lambda197_ (FilesViewWindow* self,
                       guint keyval,
                       guint keycode,
                       GdkModifierType state);
VALA_EXTERN gboolean files_view_view_container_get_locked_focus (FilesViewViewContainer* self);
static GVariant* _variant_new17 (gchar* value);
static gboolean ___lambda197__gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                             guint keyval,
                                                             guint keycode,
                                                             GdkModifierType state,
                                                             gpointer self);
static gboolean __lambda198_ (FilesViewWindow* self,
                       GdkEventWindowState* event);
VALA_EXTERN void files_view_chrome_location_bar_cancel (FilesViewChromeLocationBar* self);
static gboolean ___lambda198__gtk_widget_window_state_event (GtkWidget* _sender,
                                                      GdkEventWindowState* event,
                                                      gpointer self);
static gboolean __lambda199_ (FilesViewWindow* self);
VALA_EXTERN void files_view_window_quit (FilesViewWindow* self);
static gboolean ___lambda199__gtk_widget_delete_event (GtkWidget* _sender,
                                                GdkEventAny* event,
                                                gpointer self);
static void files_view_window_tab_view_setup_menu (FilesViewWindow* self,
                                            HdyTabPage* page);
static void _files_view_window_tab_view_setup_menu_hdy_tab_view_setup_menu (HdyTabView* _sender,
                                                                     HdyTabPage* page,
                                                                     gpointer self);
static gboolean files_view_window_tab_view_close_page (FilesViewWindow* self,
                                                HdyTabPage* page);
static gboolean _files_view_window_tab_view_close_page_hdy_tab_view_close_page (HdyTabView* _sender,
                                                                         HdyTabPage* page,
                                                                         gpointer self);
static void files_view_window_change_tab (FilesViewWindow* self);
static void _files_view_window_change_tab_g_object_notify (GObject* _sender,
                                                    GParamSpec* pspec,
                                                    gpointer self);
static HdyTabView* __lambda205_ (FilesViewWindow* self);
VALA_EXTERN FilesApplication* files_view_window_get_marlin_app (FilesViewWindow* self);
static HdyTabView* ___lambda205__hdy_tab_view_create_window (HdyTabView* _sender,
                                                      gpointer self);
static void __lambda206_ (FilesViewWindow* self,
                   HdyTabPage* tab,
                   gint pos);
VALA_EXTERN void files_view_view_container_set_window (FilesViewViewContainer* self,
                                           FilesViewWindow* value);
static void ___lambda206__hdy_tab_view_page_attached (HdyTabView* _sender,
                                               HdyTabPage* page,
                                               gint position,
                                               gpointer self);
static gboolean __lambda207_ (FilesViewWindow* self);
static gboolean files_view_window_get_locked_focus (FilesViewWindow* self);
static gboolean ___lambda207__files_sidebar_interface_request_focus (FilesSidebarInterface* _sender,
                                                              gpointer self);
static void __lambda208_ (FilesViewWindow* self);
VALA_EXTERN const gchar* files_view_view_container_get_uri (FilesViewViewContainer* self);
static void ___lambda208__files_sidebar_interface_sync_needed (FilesSidebarInterface* _sender,
                                                        gpointer self);
static void _files_view_window_uri_path_change_request_files_sidebar_interface_path_change_request (FilesSidebarInterface* _sender,
                                                                                             const gchar* uri,
                                                                                             FilesOpenFlag flag,
                                                                                             gpointer self);
VALA_EXTERN GFile* files_view_view_container_get_location (FilesViewViewContainer* self);
VALA_EXTERN void files_view_view_container_close (FilesViewViewContainer* self);
static void files_view_window_add_tab (FilesViewWindow* self,
                                GFile* _location,
                                FilesViewMode mode,
                                gboolean ignore_duplicate,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_);
static gboolean files_view_window_add_tab_finish (FilesViewWindow* self,
                                           GAsyncResult* _res_);
VALA_EXTERN GFile* files_view_window_get_default_location (FilesViewWindow* self);
VALA_EXTERN FilesViewMode files_view_window_get_default_mode (FilesViewWindow* self);
static Block51Data* block51_data_ref (Block51Data* _data51_);
static void block51_data_unref (void * _userdata_);
static void __lambda200_ (Block51Data* _data51_);
static void files_view_window_remove_tab (FilesViewWindow* self,
                                   HdyTabPage* tab);
static void ___lambda200__g_simple_action_activate (GSimpleAction* _sender,
                                             GVariant* parameter,
                                             gpointer self);
static void ___lambda201_ (Block51Data* _data51_);
static void ____lambda201__g_simple_action_activate (GSimpleAction* _sender,
                                              GVariant* parameter,
                                              gpointer self);
static void ___lambda202_ (Block51Data* _data51_);
static void ____lambda202__g_simple_action_activate (GSimpleAction* _sender,
                                              GVariant* parameter,
                                              gpointer self);
static void __lambda203_ (Block51Data* _data51_);
static void ___lambda203__g_simple_action_activate (GSimpleAction* _sender,
                                             GVariant* parameter,
                                             gpointer self);
static void __lambda204_ (Block51Data* _data51_);
static void files_view_window_move_content_to_new_window (FilesViewWindow* self,
                                                   FilesViewViewContainer* view_container);
static void ___lambda204__g_simple_action_activate (GSimpleAction* _sender,
                                             GVariant* parameter,
                                             gpointer self);
VALA_EXTERN void files_view_window_set_title (FilesViewWindow* self,
                                  const gchar* title);
VALA_EXTERN void files_view_view_container_set_active_state (FilesViewViewContainer* self,
                                                 gboolean is_active,
                                                 gboolean animate);
VALA_EXTERN gboolean files_view_view_container_get_is_frozen (FilesViewViewContainer* self);
VALA_EXTERN void files_view_chrome_location_bar_set_sensitive (FilesViewChromeLocationBar* self,
                                                   gboolean value);
static void files_view_window_save_active_tab_position (FilesViewWindow* self);
static void files_view_window_open_tabs_data_free (gpointer _data);
VALA_EXTERN void files_view_window_open_tabs (FilesViewWindow* self,
                                  GFile** files,
                                  gint files_length1,
                                  FilesViewMode mode,
                                  gboolean ignore_duplicate,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_);
VALA_EXTERN void files_view_window_open_tabs_finish (FilesViewWindow* self,
                                         GAsyncResult* _res_);
static gboolean files_view_window_open_tabs_co (FilesViewWindowOpenTabsData* _data_);
static void files_view_window_restore_tabs (FilesViewWindow* self,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
static guint files_view_window_restore_tabs_finish (FilesViewWindow* self,
                                             GAsyncResult* _res_);
static void files_view_window_open_tabs_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_);
static void ___lambda209_ (FilesViewWindow* self);
static void ____lambda209__gasync_ready_callback (GObject* source_object,
                                           GAsyncResult* res,
                                           gpointer self);
static GFile* files_view_window_get_file_from_uri (FilesViewWindow* self,
                                            const gchar* uri);
static void files_view_window_add_tab_by_uri_data_free (gpointer _data);
static void files_view_window_add_tab_by_uri (FilesViewWindow* self,
                                       const gchar* uri,
                                       FilesViewMode mode,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_);
static gboolean files_view_window_add_tab_by_uri_finish (FilesViewWindow* self,
                                                  GAsyncResult* _res_);
static gboolean files_view_window_add_tab_by_uri_co (FilesViewWindowAddTabByUriData* _data_);
static void files_view_window_add_tab_by_uri_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_);
static void files_view_window_add_tab_data_free (gpointer _data);
static gboolean files_view_window_add_tab_co (FilesViewWindowAddTabData* _data_);
static void files_view_window_add_tab_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_);
static gint files_view_window_location_is_duplicate (FilesViewWindow* self,
                                              GFile* location,
                                              gboolean is_folder,
                                              gboolean* is_child);
static FilesViewMode files_view_window_real_mode (FilesViewWindow* self,
                                           FilesViewMode mode);
VALA_EXTERN FilesViewViewContainer* files_view_view_container_new (void);
VALA_EXTERN FilesViewViewContainer* files_view_view_container_construct (GType object_type);
VALA_EXTERN void files_view_view_container_add_view (FilesViewViewContainer* self,
                                         FilesViewMode mode,
                                         GFile* loc,
                                         GFile** to_select,
                                         gint to_select_length1);
VALA_EXTERN void files_view_window_connect_content_signals (FilesViewWindow* self,
                                                FilesViewViewContainer* content);
static void files_view_window_check_for_tabs_with_same_name (FilesViewWindow* self);
static void _files_view_window_check_for_tabs_with_same_name_files_view_view_container_tab_name_changed (FilesViewViewContainer* _sender,
                                                                                                  const gchar* tab_name,
                                                                                                  gpointer self);
static void files_view_window_on_content_loading (FilesViewWindow* self,
                                           FilesViewViewContainer* content,
                                           gboolean is_loading);
static void _files_view_window_on_content_loading_files_view_view_container_loading (FilesViewViewContainer* _sender,
                                                                              gboolean is_loading,
                                                                              gpointer self);
static void files_view_window_update_headerbar (FilesViewWindow* self);
static void _files_view_window_update_headerbar_files_view_view_container_active (FilesViewViewContainer* _sender,
                                                                           gpointer self);
VALA_EXTERN void files_view_window_disconnect_content_signals (FilesViewWindow* self,
                                                   FilesViewViewContainer* content);
VALA_EXTERN gboolean files_view_view_container_get_can_show_folder (FilesViewViewContainer* self);
VALA_EXTERN void files_view_window_remove_content (FilesViewWindow* self,
                                       FilesViewViewContainer* view_container);
static void files_view_window_save_tabs (FilesViewWindow* self);
VALA_EXTERN const gchar* files_view_view_container_get_tab_name (FilesViewViewContainer* self);
static void files_view_window_set_tab_label (FilesViewWindow* self,
                                      const gchar* label,
                                      HdyTabPage* tab,
                                      const gchar* tooltip);
VALA_EXTERN gboolean files_is_admin (void);
VALA_EXTERN void files_view_window_bookmark_uri (FilesViewWindow* self,
                                     const gchar* uri,
                                     const gchar* custom_name);
VALA_EXTERN gboolean files_view_window_can_bookmark_uri (FilesViewWindow* self,
                                             const gchar* uri);
static void files_view_window_add_window (FilesViewWindow* self,
                                   GFile* location,
                                   FilesViewMode mode);
static Block52Data* block52_data_ref (Block52Data* _data52_);
static void block52_data_unref (void * _userdata_);
static gboolean ___lambda74_ (Block52Data* _data52_);
static gboolean ____lambda74__gsource_func (gpointer self);
static void files_view_window_undo_actions_set_insensitive (FilesViewWindow* self);
VALA_EXTERN gboolean files_view_chrome_location_bar_enter_navigate_mode (FilesViewChromeLocationBar* self,
                                                             const gchar* current);
VALA_EXTERN gboolean files_view_chrome_location_bar_enter_search_mode (FilesViewChromeLocationBar* self,
                                                           const gchar* term);
static gboolean ___lambda146_ (FilesViewWindow* self);
static gboolean ____lambda146__gsource_func (gpointer self);
VALA_EXTERN FilesAbstractSlot* files_view_view_container_prepare_reload (FilesViewViewContainer* self);
VALA_EXTERN void files_view_view_container_change_view_mode (FilesViewViewContainer* self,
                                                 FilesViewMode mode,
                                                 GFile* loc);
VALA_EXTERN void files_view_view_container_go_back (FilesViewViewContainer* self,
                                        gint n);
VALA_EXTERN void files_view_view_container_go_forward (FilesViewViewContainer* self,
                                           gint n);
static void files_view_window_connect_to_server (FilesViewWindow* self);
VALA_EXTERN gboolean files_view_view_container_go_up (FilesViewViewContainer* self);
static void files_view_window_show_app_help (FilesViewWindow* self);
static void files_view_window_before_undo_redo (FilesViewWindow* self);
static void __lambda147_ (FilesViewWindow* self,
                   GObject* obj,
                   GAsyncResult* res);
VALA_EXTERN void files_view_window_after_undo_redo (FilesViewWindow* self);
static void ___lambda147__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static void __lambda148_ (FilesViewWindow* self,
                   GObject* obj,
                   GAsyncResult* res);
static void ___lambda148__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
VALA_EXTERN FilesAbstractSlot* files_view_view_container_get_slot (FilesViewViewContainer* self);
static Block53Data* block53_data_ref (Block53Data* _data53_);
static void block53_data_unref (void * _userdata_);
static void __lambda149_ (Block53Data* _data53_,
                   gint res);
static void ___lambda149__gtk_dialog_response (GtkDialog* _sender,
                                        gint response_id,
                                        gpointer self);
static void __lambda150_ (FilesViewWindow* self,
                   GObject* obj,
                   GAsyncResult* res);
static void ___lambda150__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static void files_view_window_save_geometries (FilesViewWindow* self);
VALA_EXTERN gboolean files_view_window_get_is_first_window (FilesViewWindow* self);
VALA_EXTERN gchar* files_view_view_container_get_root_uri (FilesViewViewContainer* self);
VALA_EXTERN gchar* files_view_view_container_get_tip_uri (FilesViewViewContainer* self);
static void files_view_window_restore_tabs_data_free (gpointer _data);
static gboolean files_view_window_restore_tabs_co (FilesViewWindowRestoreTabsData* _data_);
static void files_view_window_restore_tabs_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_);
VALA_EXTERN GType files_view_miller_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesViewMiller, g_object_unref)
static void files_view_window_expand_miller_view (FilesViewWindow* self,
                                           FilesViewMiller* miller_view,
                                           const gchar* tip_uri,
                                           const gchar* unescaped_root_uri);
static void files_view_window_update_location_bar (FilesViewWindow* self,
                                            const gchar* new_path,
                                            gboolean with_animation);
VALA_EXTERN GType files_view_slot_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesViewSlot, g_object_unref)
VALA_EXTERN void files_view_miller_add_location (FilesViewMiller* self,
                                     GFile* loc,
                                     FilesViewSlot* host);
static void files_view_window_set_back_menu (FilesViewWindow* self,
                                      GeeList* path_list);
VALA_EXTERN GeeList* files_view_view_container_get_go_back_path_list (FilesViewViewContainer* self);
static void files_view_window_set_forward_menu (FilesViewWindow* self,
                                         GeeList* path_list);
VALA_EXTERN GeeList* files_view_view_container_get_go_forward_path_list (FilesViewViewContainer* self);
VALA_EXTERN gboolean files_view_view_container_get_can_go_back (FilesViewViewContainer* self);
VALA_EXTERN gboolean files_view_view_container_get_can_go_forward (FilesViewViewContainer* self);
VALA_EXTERN gboolean files_view_view_container_get_is_loading (FilesViewViewContainer* self);
static void files_view_window_update_labels (FilesViewWindow* self,
                                      const gchar* uri);
VALA_EXTERN void files_view_window_mount_removed (FilesViewWindow* self,
                                      GMount* mount);
VALA_EXTERN void files_view_view_container_focus_location (FilesViewViewContainer* self,
                                               GFile* loc,
                                               gboolean no_path_change,
                                               gboolean unselect_others);
VALA_EXTERN void files_view_view_container_grab_focus (FilesViewViewContainer* self);
VALA_EXTERN guint files_view_window_get_window_number (FilesViewWindow* self);
static void files_view_window_set_window_number (FilesViewWindow* self,
                                          guint value);
static void files_view_window_set_marlin_app (FilesViewWindow* self,
                                       FilesApplication* value);
static GObject * files_view_window_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
static void _files_view_window_update_labels_files_view_window_loading_uri (FilesViewWindow* _sender,
                                                                     const gchar* location,
                                                                     gpointer self);
static void files_view_window_finalize (GObject * obj);
static GType files_view_window_get_type_once (void);
static void _vala_files_view_window_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_files_view_window_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static const GActionEntry FILES_VIEW_WINDOW_WIN_ENTRIES[22] = {{"new-window", _files_view_window_action_new_window_gsimple_action_activate_callback}, {"refresh", _files_view_window_action_reload_gsimple_action_activate_callback}, {"undo", _files_view_window_action_undo_gsimple_action_activate_callback}, {"redo", _files_view_window_action_redo_gsimple_action_activate_callback}, {"bookmark", _files_view_window_action_bookmark_gsimple_action_activate_callback}, {"find", _files_view_window_action_find_gsimple_action_activate_callback, "s"}, {"edit-path", _files_view_window_action_edit_path_gsimple_action_activate_callback}, {"tab", _files_view_window_action_tab_gsimple_action_activate_callback, "s"}, {"go-to", _files_view_window_action_go_to_gsimple_action_activate_callback, "s"}, {"zoom", _files_view_window_action_zoom_gsimple_action_activate_callback, "s"}, {"info", _files_view_window_action_info_gsimple_action_activate_callback, "s"}, {"view-mode", _files_view_window_action_view_mode_gsimple_action_activate_callback, "u", "0"}, {"show-hidden", NULL, NULL, "false", _files_view_window_change_state_show_hidden_gsimple_action_change_state_callback}, {"singleclick-select", NULL, NULL, "false", _files_view_window_change_state_single_click_select_gsimple_action_change_state_callback}, {"show-remote-thumbnails", NULL, NULL, "true", _files_view_window_change_state_show_remote_thumbnails_gsimple_action_change_state_callback}, {"show-local-thumbnails", NULL, NULL, "false", _files_view_window_change_state_show_local_thumbnails_gsimple_action_change_state_callback}, {"tabhistory-restore", _files_view_window_action_tabhistory_restore_gsimple_action_activate_callback, "s"}, {"folders-before-files", NULL, NULL, "true", _files_view_window_change_state_folders_before_files_gsimple_action_change_state_callback}, {"restore-tabs-on-startup", NULL, NULL, "true", _files_view_window_change_state_restore_tabs_on_startup_gsimple_action_change_state_callback}, {"forward", _files_view_window_action_forward_gsimple_action_activate_callback, "i"}, {"back", _files_view_window_action_back_gsimple_action_activate_callback, "i"}, {"focus-sidebar", _files_view_window_action_focus_sidebar_gsimple_action_activate_callback}};

static inline gpointer
files_view_window_get_instance_private (FilesViewWindow* self)
{
	return G_STRUCT_MEMBER_P (self, FilesViewWindow_private_offset);
}

static void
_files_view_window_action_new_window_gsimple_action_activate_callback (GSimpleAction* action,
                                                                       GVariant* parameter,
                                                                       gpointer self)
{
	files_view_window_action_new_window ((FilesViewWindow*) self, action, parameter);
}

static void
_files_view_window_action_reload_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self)
{
	files_view_window_action_reload ((FilesViewWindow*) self);
}

static void
_files_view_window_action_undo_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self)
{
	files_view_window_action_undo ((FilesViewWindow*) self, action, parameter);
}

static void
_files_view_window_action_redo_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self)
{
	files_view_window_action_redo ((FilesViewWindow*) self, action, parameter);
}

static void
_files_view_window_action_bookmark_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self)
{
	files_view_window_action_bookmark ((FilesViewWindow*) self, action, parameter);
}

static void
_files_view_window_action_find_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self)
{
	files_view_window_action_find ((FilesViewWindow*) self, action, parameter);
}

static void
_files_view_window_action_edit_path_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self)
{
	files_view_window_action_edit_path ((FilesViewWindow*) self);
}

static void
_files_view_window_action_tab_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self)
{
	files_view_window_action_tab ((FilesViewWindow*) self, action, parameter);
}

static void
_files_view_window_action_go_to_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self)
{
	files_view_window_action_go_to ((FilesViewWindow*) self, action, parameter);
}

static void
_files_view_window_action_zoom_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self)
{
	files_view_window_action_zoom ((FilesViewWindow*) self, action, parameter);
}

static void
_files_view_window_action_info_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self)
{
	files_view_window_action_info ((FilesViewWindow*) self, action, parameter);
}

static void
_files_view_window_action_view_mode_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self)
{
	files_view_window_action_view_mode ((FilesViewWindow*) self, action, parameter);
}

static void
_files_view_window_change_state_show_hidden_gsimple_action_change_state_callback (GSimpleAction* action,
                                                                                  GVariant* value,
                                                                                  gpointer self)
{
	files_view_window_change_state_show_hidden ((FilesViewWindow*) self, action);
}

static void
_files_view_window_change_state_single_click_select_gsimple_action_change_state_callback (GSimpleAction* action,
                                                                                          GVariant* value,
                                                                                          gpointer self)
{
	files_view_window_change_state_single_click_select ((FilesViewWindow*) self, action);
}

static void
_files_view_window_change_state_show_remote_thumbnails_gsimple_action_change_state_callback (GSimpleAction* action,
                                                                                             GVariant* value,
                                                                                             gpointer self)
{
	files_view_window_change_state_show_remote_thumbnails ((FilesViewWindow*) self, action);
}

static void
_files_view_window_change_state_show_local_thumbnails_gsimple_action_change_state_callback (GSimpleAction* action,
                                                                                            GVariant* value,
                                                                                            gpointer self)
{
	files_view_window_change_state_show_local_thumbnails ((FilesViewWindow*) self, action);
}

static void
_files_view_window_action_tabhistory_restore_gsimple_action_activate_callback (GSimpleAction* action,
                                                                               GVariant* parameter,
                                                                               gpointer self)
{
	files_view_window_action_tabhistory_restore ((FilesViewWindow*) self, action, parameter);
}

static void
_files_view_window_change_state_folders_before_files_gsimple_action_change_state_callback (GSimpleAction* action,
                                                                                           GVariant* value,
                                                                                           gpointer self)
{
	files_view_window_change_state_folders_before_files ((FilesViewWindow*) self, action);
}

static void
_files_view_window_change_state_restore_tabs_on_startup_gsimple_action_change_state_callback (GSimpleAction* action,
                                                                                              GVariant* value,
                                                                                              gpointer self)
{
	files_view_window_change_state_restore_tabs_on_startup ((FilesViewWindow*) self, action);
}

static void
_files_view_window_action_forward_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self)
{
	files_view_window_action_forward ((FilesViewWindow*) self, action, parameter);
}

static void
_files_view_window_action_back_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self)
{
	files_view_window_action_back ((FilesViewWindow*) self, action, parameter);
}

static void
_files_view_window_action_focus_sidebar_gsimple_action_activate_callback (GSimpleAction* action,
                                                                          GVariant* parameter,
                                                                          gpointer self)
{
	files_view_window_action_focus_sidebar ((FilesViewWindow*) self);
}

FilesViewWindow*
files_view_window_construct (GType object_type,
                             FilesApplication* _application)
{
	FilesViewWindow * self = NULL;
	guint _tmp0_;
	g_return_val_if_fail (_application != NULL, NULL);
	_tmp0_ = files_view_window_window_id;
	files_view_window_window_id = _tmp0_ + 1;
	self = (FilesViewWindow*) g_object_new (object_type, "application", G_TYPE_CHECK_INSTANCE_CAST (_application, gtk_application_get_type (), GtkApplication), "marlin-app", _application, "window-number", _tmp0_, NULL);
	return self;
}

FilesViewWindow*
files_view_window_new (FilesApplication* _application)
{
	return files_view_window_construct (FILES_VIEW_TYPE_WINDOW, _application);
}

static Block49Data*
block49_data_ref (Block49Data* _data49_)
{
	g_atomic_int_inc (&_data49_->_ref_count_);
	return _data49_;
}

static void
block49_data_unref (void * _userdata_)
{
	Block49Data* _data49_;
	_data49_ = (Block49Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data49_->_ref_count_)) {
		FilesViewWindow* self;
		self = _data49_->self;
		_g_object_unref0 (_data49_->app_menu);
		_g_object_unref0 (self);
		g_slice_free (Block49Data, _data49_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_files_sidebar_interface_on_free_space_change_files_view_window_free_space_change (FilesViewWindow* _sender,
                                                                                   gpointer self)
{
	files_sidebar_interface_on_free_space_change ((FilesSidebarInterface*) self);
}

static GVariant*
_variant_new11 (gboolean value)
{
	return g_variant_ref_sink (g_variant_new_boolean (value));
}

static GVariant*
_variant_new12 (gboolean value)
{
	return g_variant_ref_sink (g_variant_new_boolean (value));
}

static GVariant*
_variant_new13 (gboolean value)
{
	return g_variant_ref_sink (g_variant_new_boolean (value));
}

static GVariant*
_variant_new14 (gboolean value)
{
	return g_variant_ref_sink (g_variant_new_boolean (value));
}

static GVariant*
_variant_new15 (gboolean value)
{
	return g_variant_ref_sink (g_variant_new_boolean (value));
}

static GVariant*
_variant_new16 (gboolean value)
{
	return g_variant_ref_sink (g_variant_new_boolean (value));
}

static void
__lambda189_ (Block49Data* _data49_,
              GVariant* id)
{
	FilesViewWindow* self;
	self = _data49_->self;
	switch ((FilesViewMode) g_variant_get_uint32 (id)) {
		case FILES_VIEW_MODE_ICON:
		{
			GSettings* _tmp0_;
			_tmp0_ = files_icon_view_settings;
			files_app_menu_on_zoom_setting_changed (_data49_->app_menu, _tmp0_, "zoom-level");
			break;
		}
		case FILES_VIEW_MODE_LIST:
		{
			GSettings* _tmp1_;
			_tmp1_ = files_list_view_settings;
			files_app_menu_on_zoom_setting_changed (_data49_->app_menu, _tmp1_, "zoom-level");
			break;
		}
		case FILES_VIEW_MODE_MILLER_COLUMNS:
		{
			GSettings* _tmp2_;
			_tmp2_ = files_column_view_settings;
			files_app_menu_on_zoom_setting_changed (_data49_->app_menu, _tmp2_, "zoom-level");
			break;
		}
		case FILES_VIEW_MODE_PREFERRED:
		case FILES_VIEW_MODE_CURRENT:
		case FILES_VIEW_MODE_INVALID:
		{
			g_assert_not_reached ();
		}
		default:
		break;
	}
}

static void
___lambda189__g_simple_action_activate (GSimpleAction* _sender,
                                        GVariant* parameter,
                                        gpointer self)
{
	__lambda189_ (self, parameter);
}

static void
__lambda190_ (FilesViewWindow* self)
{
	GActionGroup* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	_tmp0_ = gtk_widget_get_action_group ((GtkWidget*) self, "win");
	_tmp1_ = g_variant_new_int32 ((gint32) 1);
	g_variant_ref_sink (_tmp1_);
	_tmp2_ = _tmp1_;
	g_action_group_activate_action (_tmp0_, "forward", _tmp2_);
	_g_variant_unref0 (_tmp2_);
}

static void
___lambda190__files_view_chrome_button_with_menu_slow_press (FilesViewChromeButtonWithMenu* _sender,
                                                             gpointer self)
{
	__lambda190_ ((FilesViewWindow*) self);
}

static void
__lambda191_ (FilesViewWindow* self)
{
	GActionGroup* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	_tmp0_ = gtk_widget_get_action_group ((GtkWidget*) self, "win");
	_tmp1_ = g_variant_new_int32 ((gint32) 1);
	g_variant_ref_sink (_tmp1_);
	_tmp2_ = _tmp1_;
	g_action_group_activate_action (_tmp0_, "back", _tmp2_);
	_g_variant_unref0 (_tmp2_);
}

static void
___lambda191__files_view_chrome_button_with_menu_slow_press (FilesViewChromeButtonWithMenu* _sender,
                                                             gpointer self)
{
	__lambda191_ ((FilesViewWindow*) self);
}

static void
_files_view_window_grab_focus_files_view_chrome_location_bar_escape (FilesViewChromeLocationBar* _sender,
                                                                     gpointer self)
{
	files_view_window_grab_focus ((FilesViewWindow*) self);
}

static Block50Data*
block50_data_ref (Block50Data* _data50_)
{
	g_atomic_int_inc (&_data50_->_ref_count_);
	return _data50_;
}

static void
block50_data_unref (void * _userdata_)
{
	Block50Data* _data50_;
	_data50_ = (Block50Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data50_->_ref_count_)) {
		FilesViewWindow* self;
		self = _data50_->self;
		_g_free0 (_data50_->path);
		_g_object_unref0 (self);
		g_slice_free (Block50Data, _data50_);
	}
}

static gboolean
__lambda193_ (Block50Data* _data50_)
{
	FilesViewWindow* self;
	gboolean result;
	self = _data50_->self;
	files_view_window_uri_path_change_request (self, _data50_->path, _data50_->flag);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda193__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda193_ (self);
	return result;
}

static void
__lambda192_ (FilesViewWindow* self,
              const gchar* path,
              FilesOpenFlag flag)
{
	Block50Data* _data50_;
	gchar* _tmp0_;
	FilesViewViewContainer* _tmp1_;
	FilesViewViewContainer* _tmp2_;
	g_return_if_fail (path != NULL);
	_data50_ = g_slice_new0 (Block50Data);
	_data50_->_ref_count_ = 1;
	_data50_->self = g_object_ref (self);
	_tmp0_ = g_strdup (path);
	_g_free0 (_data50_->path);
	_data50_->path = _tmp0_;
	_data50_->flag = flag;
	_tmp1_ = files_view_window_get_current_container (self);
	_tmp2_ = _tmp1_;
	files_view_view_container_set_is_frozen (_tmp2_, FALSE);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda193__gsource_func, block50_data_ref (_data50_), block50_data_unref);
	block50_data_unref (_data50_);
	_data50_ = NULL;
}

static void
___lambda192__files_view_chrome_locatable_path_change_request (FilesViewChromeLocatable* _sender,
                                                               const gchar* path,
                                                               FilesOpenFlag flag,
                                                               gpointer self)
{
	__lambda192_ ((FilesViewWindow*) self, path, flag);
}

static void
__lambda194_ (FilesViewWindow* self,
              GFile* loc)
{
	FilesViewViewContainer* _tmp0_;
	FilesViewViewContainer* _tmp1_;
	_tmp0_ = files_view_window_get_current_container (self);
	_tmp1_ = _tmp0_;
	files_view_view_container_focus_location_if_in_current_directory (_tmp1_, loc, TRUE);
}

static void
___lambda194__files_view_chrome_location_bar_focus_file_request (FilesViewChromeLocationBar* _sender,
                                                                 GFile* file,
                                                                 gpointer self)
{
	__lambda194_ ((FilesViewWindow*) self, file);
}

static gboolean
__lambda195_ (FilesViewWindow* self,
              GdkEventFocus* event)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (event != NULL, FALSE);
	files_view_window_set_locked_focus (self, TRUE);
	g_signal_emit_by_name ((GtkWidget*) self, "focus-in-event", event, &_tmp0_);
	result = _tmp0_;
	return result;
}

static gboolean
___lambda195__gtk_widget_focus_in_event (GtkWidget* _sender,
                                         GdkEventFocus* event,
                                         gpointer self)
{
	gboolean result;
	result = __lambda195_ ((FilesViewWindow*) self, event);
	return result;
}

static gboolean
__lambda196_ (FilesViewWindow* self,
              GdkEventFocus* event)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (event != NULL, FALSE);
	files_view_window_set_locked_focus (self, FALSE);
	g_signal_emit_by_name ((GtkWidget*) self, "focus-out-event", event, &_tmp0_);
	result = _tmp0_;
	return result;
}

static gboolean
___lambda196__gtk_widget_focus_out_event (GtkWidget* _sender,
                                          GdkEventFocus* event,
                                          gpointer self)
{
	gboolean result;
	result = __lambda196_ ((FilesViewWindow*) self, event);
	return result;
}

static void
_files_view_window_update_undo_actions_files_undo_manager_request_menu_update (FilesUndoManager* _sender,
                                                                               gpointer self)
{
	files_view_window_update_undo_actions ((FilesViewWindow*) self);
}

static gchar*
g_unichar_to_string (gunichar self)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	g_unichar_to_utf8 (self, str);
	result = str;
	return result;
}

static GVariant*
_variant_new17 (gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static gboolean
__lambda197_ (FilesViewWindow* self,
              guint keyval,
              guint keycode,
              GdkModifierType state)
{
	GtkWidget* focus_widget = NULL;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	FilesViewViewContainer* _tmp5_;
	FilesViewViewContainer* _tmp6_;
	gboolean result;
	_tmp0_ = gtk_window_get_focus ((GtkWindow*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	focus_widget = _tmp1_;
	_tmp5_ = files_view_window_get_current_container (self);
	_tmp6_ = _tmp5_;
	if (_tmp6_ != NULL) {
		FilesViewViewContainer* _tmp7_;
		FilesViewViewContainer* _tmp8_;
		gboolean _tmp9_;
		gboolean _tmp10_;
		_tmp7_ = files_view_window_get_current_container (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = files_view_view_container_get_locked_focus (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp4_ = !_tmp10_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		GtkWidget* _tmp11_;
		_tmp11_ = focus_widget;
		_tmp3_ = _tmp11_ != NULL;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		GtkWidget* _tmp12_;
		FilesViewViewContainer* _tmp13_;
		FilesViewViewContainer* _tmp14_;
		_tmp12_ = focus_widget;
		_tmp13_ = files_view_window_get_current_container (self);
		_tmp14_ = _tmp13_;
		_tmp2_ = gtk_widget_is_ancestor (_tmp12_, (GtkWidget*) _tmp14_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GdkModifierType mods = 0U;
		gboolean _tmp15_ = FALSE;
		mods = state & gtk_accelerator_get_default_mod_mask ();
		if (mods == 0) {
			_tmp15_ = TRUE;
		} else {
			_tmp15_ = mods == GDK_SHIFT_MASK;
		}
		if (_tmp15_) {
			gunichar uc = 0U;
			gboolean _tmp16_ = FALSE;
			uc = (gunichar) gdk_keyval_to_unicode (keyval);
			if (g_unichar_isprint (uc)) {
				_tmp16_ = !g_unichar_isspace (uc);
			} else {
				_tmp16_ = FALSE;
			}
			if (_tmp16_) {
				gchar* _tmp17_;
				gchar* _tmp18_;
				GVariant* _tmp19_;
				_tmp17_ = g_unichar_to_string (uc);
				_tmp18_ = _tmp17_;
				_tmp19_ = _variant_new17 (_tmp18_);
				g_action_group_activate_action ((GActionGroup*) self, "find", _tmp19_);
				_g_variant_unref0 (_tmp19_);
				_g_free0 (_tmp18_);
				result = GDK_EVENT_STOP;
				_g_object_unref0 (focus_widget);
				return result;
			}
		}
	}
	result = GDK_EVENT_PROPAGATE;
	_g_object_unref0 (focus_widget);
	return result;
}

static gboolean
___lambda197__gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                    guint keyval,
                                                    guint keycode,
                                                    GdkModifierType state,
                                                    gpointer self)
{
	gboolean result;
	result = __lambda197_ ((FilesViewWindow*) self, keyval, keycode, state);
	return result;
}

static gboolean
__lambda198_ (FilesViewWindow* self,
              GdkEventWindowState* event)
{
	gboolean result;
	g_return_val_if_fail (event != NULL, FALSE);
	if ((event->changed_mask & GDK_WINDOW_STATE_ICONIFIED) == GDK_WINDOW_STATE_ICONIFIED) {
		FilesViewChromeLocationBar* _tmp0_;
		_tmp0_ = self->priv->location_bar;
		files_view_chrome_location_bar_cancel (_tmp0_);
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda198__gtk_widget_window_state_event (GtkWidget* _sender,
                                             GdkEventWindowState* event,
                                             gpointer self)
{
	gboolean result;
	result = __lambda198_ ((FilesViewWindow*) self, event);
	return result;
}

static gboolean
__lambda199_ (FilesViewWindow* self)
{
	gboolean result;
	files_view_window_quit (self);
	result = FALSE;
	return result;
}

static gboolean
___lambda199__gtk_widget_delete_event (GtkWidget* _sender,
                                       GdkEventAny* event,
                                       gpointer self)
{
	gboolean result;
	result = __lambda199_ ((FilesViewWindow*) self);
	return result;
}

static void
_files_view_window_tab_view_setup_menu_hdy_tab_view_setup_menu (HdyTabView* _sender,
                                                                HdyTabPage* page,
                                                                gpointer self)
{
	files_view_window_tab_view_setup_menu ((FilesViewWindow*) self, page);
}

static gboolean
_files_view_window_tab_view_close_page_hdy_tab_view_close_page (HdyTabView* _sender,
                                                                HdyTabPage* page,
                                                                gpointer self)
{
	gboolean result;
	result = files_view_window_tab_view_close_page ((FilesViewWindow*) self, page);
	return result;
}

static void
_files_view_window_change_tab_g_object_notify (GObject* _sender,
                                               GParamSpec* pspec,
                                               gpointer self)
{
	files_view_window_change_tab ((FilesViewWindow*) self);
}

static HdyTabView*
__lambda205_ (FilesViewWindow* self)
{
	FilesApplication* _tmp0_;
	FilesViewWindow* _tmp1_;
	FilesViewWindow* _tmp2_;
	HdyTabView* _tmp3_;
	HdyTabView* _tmp4_;
	HdyTabView* result;
	_tmp0_ = self->priv->_marlin_app;
	_tmp1_ = files_view_window_new (_tmp0_);
	g_object_ref_sink (_tmp1_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_->tab_view;
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	result = _tmp4_;
	return result;
}

static HdyTabView*
___lambda205__hdy_tab_view_create_window (HdyTabView* _sender,
                                          gpointer self)
{
	HdyTabView* result;
	result = __lambda205_ ((FilesViewWindow*) self);
	return result;
}

static void
__lambda206_ (FilesViewWindow* self,
              HdyTabPage* tab,
              gint pos)
{
	FilesViewViewContainer* view_container = NULL;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	FilesViewViewContainer* _tmp2_;
	g_return_if_fail (tab != NULL);
	_tmp0_ = hdy_tab_page_get_child (tab);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, FILES_VIEW_TYPE_VIEW_CONTAINER, FilesViewViewContainer));
	view_container = _tmp2_;
	files_view_view_container_set_window (view_container, self);
	_g_object_unref0 (view_container);
}

static void
___lambda206__hdy_tab_view_page_attached (HdyTabView* _sender,
                                          HdyTabPage* page,
                                          gint position,
                                          gpointer self)
{
	__lambda206_ ((FilesViewWindow*) self, page, position);
}

static gboolean
__lambda207_ (FilesViewWindow* self)
{
	gboolean _tmp0_ = FALSE;
	FilesViewViewContainer* _tmp1_;
	FilesViewViewContainer* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean result;
	_tmp1_ = files_view_window_get_current_container (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = files_view_view_container_get_locked_focus (_tmp2_);
	_tmp4_ = _tmp3_;
	if (!_tmp4_) {
		gboolean _tmp5_;
		_tmp5_ = self->priv->_locked_focus;
		_tmp0_ = !_tmp5_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
___lambda207__files_sidebar_interface_request_focus (FilesSidebarInterface* _sender,
                                                     gpointer self)
{
	gboolean result;
	result = __lambda207_ ((FilesViewWindow*) self);
	return result;
}

static void
__lambda208_ (FilesViewWindow* self)
{
	FilesViewViewContainer* _tmp0_;
	FilesViewViewContainer* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	_tmp0_ = files_view_window_get_current_container (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = files_view_view_container_get_uri (_tmp1_);
	_tmp3_ = _tmp2_;
	g_signal_emit (self, files_view_window_signals[FILES_VIEW_WINDOW_LOADING_URI_SIGNAL], 0, _tmp3_);
}

static void
___lambda208__files_sidebar_interface_sync_needed (FilesSidebarInterface* _sender,
                                                   gpointer self)
{
	__lambda208_ ((FilesViewWindow*) self);
}

static void
_files_view_window_uri_path_change_request_files_sidebar_interface_path_change_request (FilesSidebarInterface* _sender,
                                                                                        const gchar* uri,
                                                                                        FilesOpenFlag flag,
                                                                                        gpointer self)
{
	files_view_window_uri_path_change_request ((FilesViewWindow*) self, uri, flag);
}

static void
files_view_window_build_window (FilesViewWindow* self)
{
	Block49Data* _data49_;
	FilesViewChromeButtonWithMenu* _tmp0_;
	FilesViewChromeButtonWithMenu* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar* _tmp5_;
	gchar* _tmp6_;
	FilesViewChromeButtonWithMenu* _tmp7_;
	GtkStyleContext* _tmp8_;
	FilesViewChromeButtonWithMenu* _tmp9_;
	FilesViewChromeButtonWithMenu* _tmp10_;
	gchar* _tmp11_;
	gchar** _tmp12_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	gchar* _tmp14_;
	gchar* _tmp15_;
	FilesViewChromeButtonWithMenu* _tmp16_;
	GtkStyleContext* _tmp17_;
	GAction* _tmp18_;
	FilesViewChromeViewSwitcher* _tmp19_ = NULL;
	FilesViewChromeViewSwitcher* _tmp20_;
	GSettings* _tmp21_;
	FilesViewChromeLocationBar* _tmp22_;
	FilesAppMenu* _tmp23_;
	GtkMenuButton* menu_button = NULL;
	GtkImage* _tmp24_;
	GtkPopover* _tmp25_;
	gchar* _tmp26_;
	GtkMenuButton* _tmp27_ = NULL;
	GtkLabel* _tmp28_;
	HdyHeaderBar* _tmp29_ = NULL;
	HdyHeaderBar* _tmp30_;
	FilesViewChromeButtonWithMenu* _tmp31_;
	HdyHeaderBar* _tmp32_;
	FilesViewChromeButtonWithMenu* _tmp33_;
	HdyHeaderBar* _tmp34_;
	FilesViewChromeViewSwitcher* _tmp35_;
	HdyHeaderBar* _tmp36_;
	FilesViewChromeLocationBar* _tmp37_;
	HdyHeaderBar* _tmp38_;
	GMenu* _tmp39_;
	HdyTabView* _tmp40_ = NULL;
	GtkApplication* app_instance = NULL;
	GApplication* _tmp41_;
	GtkApplication* _tmp42_;
	GtkButton* new_tab_button = NULL;
	gchar* _tmp43_;
	GVariant* _tmp44_;
	GtkButton* _tmp45_ = NULL;
	gchar** _tmp46_;
	gchar** _tmp47_;
	gchar** _tmp48_;
	gint _tmp48__length1;
	gchar* _tmp49_;
	gchar* _tmp50_;
	GtkImage* _tmp51_;
	gchar* _tmp52_;
	GtkMenuButton* _tmp53_ = NULL;
	GtkWidget* _tmp54_;
	GtkMenuButton* _tmp55_;
	GtkWidget* _tmp56_;
	HdyTabView* _tmp57_;
	HdyTabView* _tmp58_;
	HdyTabBar* _tmp59_ = NULL;
	GtkBox* tab_box = NULL;
	GtkBox* _tmp60_;
	HdyTabBar* _tmp61_;
	HdyTabView* _tmp62_;
	SidebarSidebarWindow* _tmp63_;
	FilesSidebarInterface* _tmp64_;
	GSettings* _tmp65_;
	GtkPaned* _tmp66_ = NULL;
	GtkPaned* _tmp67_;
	FilesSidebarInterface* _tmp68_;
	GtkPaned* _tmp69_;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp70_;
	HdyHeaderBar* _tmp71_;
	GtkPaned* _tmp72_;
	FilesPreferences* prefs = NULL;
	FilesPreferences* _tmp73_;
	GSimpleAction* _tmp74_;
	GSimpleAction* _tmp75_;
	gboolean _tmp76_;
	gboolean _tmp77_;
	GVariant* _tmp78_;
	GSimpleAction* _tmp79_;
	GSimpleAction* _tmp80_;
	gboolean _tmp81_;
	gboolean _tmp82_;
	GVariant* _tmp83_;
	GSimpleAction* _tmp84_;
	GSimpleAction* _tmp85_;
	gboolean _tmp86_;
	gboolean _tmp87_;
	GVariant* _tmp88_;
	GSimpleAction* _tmp89_;
	GSimpleAction* _tmp90_;
	gboolean _tmp91_;
	gboolean _tmp92_;
	GVariant* _tmp93_;
	GSimpleAction* _tmp94_;
	GSimpleAction* _tmp95_;
	gboolean _tmp96_;
	gboolean _tmp97_;
	GVariant* _tmp98_;
	GSimpleAction* _tmp99_;
	GSimpleAction* _tmp100_;
	GSettings* _tmp101_;
	GVariant* _tmp102_;
	FilesViewChromeViewSwitcher* _tmp103_;
	GSimpleAction* _tmp104_;
	GSimpleAction* _tmp105_;
	FilesViewChromeButtonWithMenu* _tmp106_;
	FilesViewChromeButtonWithMenu* _tmp107_;
	FilesViewChromeLocationBar* _tmp108_;
	FilesViewChromeLocationBar* _tmp109_;
	FilesViewChromeLocationBar* _tmp110_;
	HdyHeaderBar* _tmp111_;
	HdyHeaderBar* _tmp112_;
	FilesUndoManager* _tmp113_;
	GtkEventControllerKey* _tmp114_ = NULL;
	GtkEventControllerKey* _tmp115_;
	HdyTabView* _tmp116_;
	HdyTabView* _tmp117_;
	HdyTabView* _tmp118_;
	HdyTabView* _tmp119_;
	HdyTabView* _tmp120_;
	FilesSidebarInterface* _tmp121_;
	FilesSidebarInterface* _tmp122_;
	FilesSidebarInterface* _tmp123_;
	g_return_if_fail (self != NULL);
	_data49_ = g_slice_new0 (Block49Data);
	_data49_->_ref_count_ = 1;
	_data49_->self = g_object_ref (self);
	_tmp0_ = files_view_chrome_button_with_menu_new ("go-previous-symbolic");
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->button_back);
	self->priv->button_back = _tmp0_;
	_tmp1_ = self->priv->button_back;
	_tmp2_ = g_strdup ("<Alt>Left");
	_tmp3_ = g_new0 (gchar*, 1 + 1);
	_tmp3_[0] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 1;
	_tmp5_ = granite_markup_accel_tooltip (_tmp4_, (gint) 1, _ ("Previous"));
	_tmp6_ = _tmp5_;
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp1_, _tmp6_);
	_g_free0 (_tmp6_);
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
	_tmp7_ = self->priv->button_back;
	_tmp8_ = gtk_widget_get_style_context ((GtkWidget*) _tmp7_);
	gtk_style_context_add_class (_tmp8_, GTK_STYLE_CLASS_FLAT);
	_tmp9_ = files_view_chrome_button_with_menu_new ("go-next-symbolic");
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->button_forward);
	self->priv->button_forward = _tmp9_;
	_tmp10_ = self->priv->button_forward;
	_tmp11_ = g_strdup ("<Alt>Right");
	_tmp12_ = g_new0 (gchar*, 1 + 1);
	_tmp12_[0] = _tmp11_;
	_tmp13_ = _tmp12_;
	_tmp13__length1 = 1;
	_tmp14_ = granite_markup_accel_tooltip (_tmp13_, (gint) 1, _ ("Next"));
	_tmp15_ = _tmp14_;
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp10_, _tmp15_);
	_g_free0 (_tmp15_);
	_tmp13_ = (_vala_array_free (_tmp13_, _tmp13__length1, (GDestroyNotify) g_free), NULL);
	_tmp16_ = self->priv->button_forward;
	_tmp17_ = gtk_widget_get_style_context ((GtkWidget*) _tmp16_);
	gtk_style_context_add_class (_tmp17_, GTK_STYLE_CLASS_FLAT);
	_tmp18_ = g_action_map_lookup_action ((GActionMap*) self, "view-mode");
	_tmp19_ = files_view_chrome_view_switcher_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, g_simple_action_get_type (), GSimpleAction));
	gtk_widget_set_margin_end ((GtkWidget*) _tmp19_, 20);
	g_object_ref_sink (_tmp19_);
	_g_object_unref0 (self->view_switcher);
	self->view_switcher = _tmp19_;
	_tmp20_ = self->view_switcher;
	_tmp21_ = files_app_settings;
	files_view_chrome_view_switcher_set_mode (_tmp20_, (guint32) g_settings_get_enum (_tmp21_, "default-viewmode"));
	_tmp22_ = files_view_chrome_location_bar_new ();
	g_object_ref_sink (_tmp22_);
	_g_object_unref0 (self->priv->location_bar);
	self->priv->location_bar = _tmp22_;
	_tmp23_ = files_app_menu_new ();
	g_object_ref_sink (_tmp23_);
	_data49_->app_menu = _tmp23_;
	_tmp24_ = (GtkImage*) gtk_image_new_from_icon_name ("open-menu", (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
	g_object_ref_sink (_tmp24_);
	_tmp25_ = _g_object_ref0 ((GtkPopover*) _data49_->app_menu);
	_tmp26_ = g_strdup (_ ("Menu"));
	_tmp27_ = (GtkMenuButton*) gtk_menu_button_new ();
	gtk_button_set_image ((GtkButton*) _tmp27_, (GtkWidget*) _tmp24_);
	_g_object_unref0 (_tmp24_);
	gtk_menu_button_set_popover (_tmp27_, _tmp25_);
	_g_object_unref0 (_tmp25_);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp27_, _tmp26_);
	_g_free0 (_tmp26_);
	g_object_ref_sink (_tmp27_);
	menu_button = _tmp27_;
	_tmp28_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp28_);
	_tmp29_ = (HdyHeaderBar*) hdy_header_bar_new ();
	hdy_header_bar_set_show_close_button (_tmp29_, TRUE);
	hdy_header_bar_set_custom_title (_tmp29_, (GtkWidget*) _tmp28_);
	_g_object_unref0 (_tmp28_);
	g_object_ref_sink (_tmp29_);
	_g_object_unref0 (self->headerbar);
	self->headerbar = _tmp29_;
	_tmp30_ = self->headerbar;
	_tmp31_ = self->priv->button_back;
	hdy_header_bar_pack_start (_tmp30_, (GtkWidget*) _tmp31_);
	_tmp32_ = self->headerbar;
	_tmp33_ = self->priv->button_forward;
	hdy_header_bar_pack_start (_tmp32_, (GtkWidget*) _tmp33_);
	_tmp34_ = self->headerbar;
	_tmp35_ = self->view_switcher;
	hdy_header_bar_pack_start (_tmp34_, (GtkWidget*) _tmp35_);
	_tmp36_ = self->headerbar;
	_tmp37_ = self->priv->location_bar;
	hdy_header_bar_pack_start (_tmp36_, (GtkWidget*) _tmp37_);
	_tmp38_ = self->headerbar;
	hdy_header_bar_pack_end (_tmp38_, (GtkWidget*) menu_button);
	_tmp39_ = g_menu_new ();
	_tmp40_ = hdy_tab_view_new ();
	hdy_tab_view_set_menu_model (_tmp40_, (GMenuModel*) _tmp39_);
	_g_object_unref0 (_tmp39_);
	g_object_ref_sink (_tmp40_);
	_g_object_unref0 (self->tab_view);
	self->tab_view = _tmp40_;
	_tmp41_ = g_application_get_default ();
	_tmp42_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, gtk_application_get_type (), GtkApplication));
	app_instance = _tmp42_;
	_tmp43_ = g_strdup ("win.tab");
	_tmp44_ = g_variant_new_string ("NEW");
	g_variant_ref_sink (_tmp44_);
	_tmp45_ = (GtkButton*) gtk_button_new_from_icon_name ("list-add-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	gtk_actionable_set_action_name ((GtkActionable*) _tmp45_, _tmp43_);
	_g_free0 (_tmp43_);
	g_object_set ((GtkActionable*) _tmp45_, "action-target", _tmp44_, NULL);
	_g_variant_unref0 (_tmp44_);
	g_object_ref_sink (_tmp45_);
	new_tab_button = _tmp45_;
	_tmp47_ = _tmp46_ = gtk_application_get_accels_for_action (app_instance, "win.tab::NEW");
	_tmp48_ = _tmp47_;
	_tmp48__length1 = _vala_array_length (_tmp46_);
	_tmp49_ = granite_markup_accel_tooltip (_tmp48_, (gint) _vala_array_length (_tmp46_), _ ("New Tab"));
	_tmp50_ = _tmp49_;
	gtk_widget_set_tooltip_markup ((GtkWidget*) new_tab_button, _tmp50_);
	_g_free0 (_tmp50_);
	_tmp48_ = (_vala_array_free (_tmp48_, _tmp48__length1, (GDestroyNotify) g_free), NULL);
	_tmp51_ = (GtkImage*) gtk_image_new_from_icon_name ("document-open-recent-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp51_);
	_tmp52_ = g_strdup (_ ("Closed Tabs"));
	_tmp53_ = (GtkMenuButton*) gtk_menu_button_new ();
	gtk_button_set_image ((GtkButton*) _tmp53_, (GtkWidget*) _tmp51_);
	_g_object_unref0 (_tmp51_);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp53_, _tmp52_);
	_g_free0 (_tmp52_);
	gtk_menu_button_set_use_popover (_tmp53_, FALSE);
	g_object_ref_sink (_tmp53_);
	_g_object_unref0 (self->priv->tab_history_button);
	self->priv->tab_history_button = _tmp53_;
	_tmp54_ = _g_object_ref0 ((GtkWidget*) new_tab_button);
	_tmp55_ = self->priv->tab_history_button;
	_tmp56_ = _g_object_ref0 ((GtkWidget*) _tmp55_);
	_tmp57_ = self->tab_view;
	_tmp58_ = _g_object_ref0 (_tmp57_);
	_tmp59_ = hdy_tab_bar_new ();
	hdy_tab_bar_set_autohide (_tmp59_, FALSE);
	hdy_tab_bar_set_expand_tabs (_tmp59_, FALSE);
	hdy_tab_bar_set_inverted (_tmp59_, TRUE);
	hdy_tab_bar_set_start_action_widget (_tmp59_, _tmp54_);
	_g_object_unref0 (_tmp54_);
	hdy_tab_bar_set_end_action_widget (_tmp59_, _tmp56_);
	_g_object_unref0 (_tmp56_);
	hdy_tab_bar_set_view (_tmp59_, _tmp58_);
	_g_object_unref0 (_tmp58_);
	g_object_ref_sink (_tmp59_);
	_g_object_unref0 (self->tab_bar);
	self->tab_bar = _tmp59_;
	_tmp60_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp60_);
	tab_box = _tmp60_;
	_tmp61_ = self->tab_bar;
	gtk_container_add ((GtkContainer*) tab_box, (GtkWidget*) _tmp61_);
	_tmp62_ = self->tab_view;
	gtk_container_add ((GtkContainer*) tab_box, (GtkWidget*) _tmp62_);
	_tmp63_ = sidebar_sidebar_window_new ();
	g_object_ref_sink (_tmp63_);
	_g_object_unref0 (self->sidebar);
	self->sidebar = (FilesSidebarInterface*) _tmp63_;
	_tmp64_ = self->sidebar;
	g_signal_connect_object (self, "free-space-change", (GCallback) _files_sidebar_interface_on_free_space_change_files_view_window_free_space_change, _tmp64_, 0);
	_tmp65_ = files_app_settings;
	_tmp66_ = (GtkPaned*) gtk_paned_new (GTK_ORIENTATION_HORIZONTAL);
	g_object_set ((GtkWidget*) _tmp66_, "expand", TRUE, NULL);
	gtk_paned_set_position (_tmp66_, g_settings_get_int (_tmp65_, "sidebar-width"));
	g_object_ref_sink (_tmp66_);
	_g_object_unref0 (self->priv->lside_pane);
	self->priv->lside_pane = _tmp66_;
	_tmp67_ = self->priv->lside_pane;
	_tmp68_ = self->sidebar;
	gtk_paned_pack1 (_tmp67_, (GtkWidget*) _tmp68_, FALSE, FALSE);
	_tmp69_ = self->priv->lside_pane;
	gtk_paned_pack2 (_tmp69_, (GtkWidget*) tab_box, TRUE, TRUE);
	_tmp70_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp70_);
	grid = _tmp70_;
	_tmp71_ = self->headerbar;
	gtk_grid_attach (grid, (GtkWidget*) _tmp71_, 0, 0, 1, 1);
	_tmp72_ = self->priv->lside_pane;
	gtk_grid_attach (grid, (GtkWidget*) _tmp72_, 0, 1, 1, 1);
	gtk_widget_show_all ((GtkWidget*) grid);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) grid);
	_tmp73_ = files_preferences_get_default ();
	prefs = _tmp73_;
	_tmp74_ = files_view_window_get_action (self, "show-hidden");
	_tmp75_ = _tmp74_;
	_tmp76_ = files_preferences_get_show_hidden_files (prefs);
	_tmp77_ = _tmp76_;
	_tmp78_ = _variant_new11 (_tmp77_);
	g_simple_action_set_state (_tmp75_, _tmp78_);
	_g_variant_unref0 (_tmp78_);
	_g_object_unref0 (_tmp75_);
	_tmp79_ = files_view_window_get_action (self, "show-local-thumbnails");
	_tmp80_ = _tmp79_;
	_tmp81_ = files_preferences_get_show_local_thumbnails (prefs);
	_tmp82_ = _tmp81_;
	_tmp83_ = _variant_new12 (_tmp82_);
	g_simple_action_set_state (_tmp80_, _tmp83_);
	_g_variant_unref0 (_tmp83_);
	_g_object_unref0 (_tmp80_);
	_tmp84_ = files_view_window_get_action (self, "show-remote-thumbnails");
	_tmp85_ = _tmp84_;
	_tmp86_ = files_preferences_get_show_remote_thumbnails (prefs);
	_tmp87_ = _tmp86_;
	_tmp88_ = _variant_new13 (_tmp87_);
	g_simple_action_set_state (_tmp85_, _tmp88_);
	_g_variant_unref0 (_tmp88_);
	_g_object_unref0 (_tmp85_);
	_tmp89_ = files_view_window_get_action (self, "singleclick-select");
	_tmp90_ = _tmp89_;
	_tmp91_ = files_preferences_get_singleclick_select (prefs);
	_tmp92_ = _tmp91_;
	_tmp93_ = _variant_new14 (_tmp92_);
	g_simple_action_set_state (_tmp90_, _tmp93_);
	_g_variant_unref0 (_tmp93_);
	_g_object_unref0 (_tmp90_);
	_tmp94_ = files_view_window_get_action (self, "folders-before-files");
	_tmp95_ = _tmp94_;
	_tmp96_ = files_preferences_get_sort_directories_first (prefs);
	_tmp97_ = _tmp96_;
	_tmp98_ = _variant_new15 (_tmp97_);
	g_simple_action_set_state (_tmp95_, _tmp98_);
	_g_variant_unref0 (_tmp98_);
	_g_object_unref0 (_tmp95_);
	_tmp99_ = files_view_window_get_action (self, "restore-tabs-on-startup");
	_tmp100_ = _tmp99_;
	_tmp101_ = files_app_settings;
	_tmp102_ = _variant_new16 (g_settings_get_boolean (_tmp101_, "restore-tabs"));
	g_simple_action_set_state (_tmp100_, _tmp102_);
	_g_variant_unref0 (_tmp102_);
	_g_object_unref0 (_tmp100_);
	_tmp103_ = self->view_switcher;
	_tmp104_ = files_view_chrome_view_switcher_get_action (_tmp103_);
	_tmp105_ = _tmp104_;
	g_signal_connect_data (_tmp105_, "activate", (GCallback) ___lambda189__g_simple_action_activate, block49_data_ref (_data49_), (GClosureNotify) block49_data_unref, 0);
	_tmp106_ = self->priv->button_forward;
	g_signal_connect_object (_tmp106_, "slow-press", (GCallback) ___lambda190__files_view_chrome_button_with_menu_slow_press, self, 0);
	_tmp107_ = self->priv->button_back;
	g_signal_connect_object (_tmp107_, "slow-press", (GCallback) ___lambda191__files_view_chrome_button_with_menu_slow_press, self, 0);
	_tmp108_ = self->priv->location_bar;
	g_signal_connect_object (_tmp108_, "escape", (GCallback) _files_view_window_grab_focus_files_view_chrome_location_bar_escape, self, 0);
	_tmp109_ = self->priv->location_bar;
	g_signal_connect_object ((FilesViewChromeLocatable*) _tmp109_, "path-change-request", (GCallback) ___lambda192__files_view_chrome_locatable_path_change_request, self, 0);
	_tmp110_ = self->priv->location_bar;
	g_signal_connect_object (_tmp110_, "focus-file-request", (GCallback) ___lambda194__files_view_chrome_location_bar_focus_file_request, self, 0);
	_tmp111_ = self->headerbar;
	g_signal_connect_object ((GtkWidget*) _tmp111_, "focus-in-event", (GCallback) ___lambda195__gtk_widget_focus_in_event, self, 0);
	_tmp112_ = self->headerbar;
	g_signal_connect_object ((GtkWidget*) _tmp112_, "focus-out-event", (GCallback) ___lambda196__gtk_widget_focus_out_event, self, 0);
	_tmp113_ = self->priv->undo_manager;
	g_signal_connect_object (_tmp113_, "request-menu-update", (GCallback) _files_view_window_update_undo_actions_files_undo_manager_request_menu_update, self, 0);
	_tmp114_ = (GtkEventControllerKey*) gtk_event_controller_key_new ((GtkWidget*) self);
	gtk_event_controller_set_propagation_phase ((GtkEventController*) _tmp114_, GTK_PHASE_CAPTURE);
	_g_object_unref0 (self->priv->key_controller);
	self->priv->key_controller = _tmp114_;
	_tmp115_ = self->priv->key_controller;
	g_signal_connect_object (_tmp115_, "key-pressed", (GCallback) ___lambda197__gtk_event_controller_key_key_pressed, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "window-state-event", (GCallback) ___lambda198__gtk_widget_window_state_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "delete-event", (GCallback) ___lambda199__gtk_widget_delete_event, self, 0);
	_tmp116_ = self->tab_view;
	g_signal_connect_object (_tmp116_, "setup-menu", (GCallback) _files_view_window_tab_view_setup_menu_hdy_tab_view_setup_menu, self, 0);
	_tmp117_ = self->tab_view;
	g_signal_connect_object (_tmp117_, "close-page", (GCallback) _files_view_window_tab_view_close_page_hdy_tab_view_close_page, self, 0);
	_tmp118_ = self->tab_view;
	g_signal_connect_object ((GObject*) _tmp118_, "notify::selected-page", (GCallback) _files_view_window_change_tab_g_object_notify, self, 0);
	_tmp119_ = self->tab_view;
	g_signal_connect_object (_tmp119_, "create-window", (GCallback) ___lambda205__hdy_tab_view_create_window, self, 0);
	_tmp120_ = self->tab_view;
	g_signal_connect_object (_tmp120_, "page-attached", (GCallback) ___lambda206__hdy_tab_view_page_attached, self, 0);
	_tmp121_ = self->sidebar;
	g_signal_connect_object (_tmp121_, "request-focus", (GCallback) ___lambda207__files_sidebar_interface_request_focus, self, 0);
	_tmp122_ = self->sidebar;
	g_signal_connect_object (_tmp122_, "sync-needed", (GCallback) ___lambda208__files_sidebar_interface_sync_needed, self, 0);
	_tmp123_ = self->sidebar;
	g_signal_connect_object (_tmp123_, "path-change-request", (GCallback) _files_view_window_uri_path_change_request_files_sidebar_interface_path_change_request, self, 0);
	_g_object_unref0 (prefs);
	_g_object_unref0 (grid);
	_g_object_unref0 (tab_box);
	_g_object_unref0 (new_tab_button);
	_g_object_unref0 (app_instance);
	_g_object_unref0 (menu_button);
	block49_data_unref (_data49_);
	_data49_ = NULL;
}

static gboolean
files_view_window_tab_view_close_page (FilesViewWindow* self,
                                       HdyTabPage* page)
{
	FilesViewViewContainer* view_container = NULL;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	FilesViewViewContainer* _tmp2_;
	GtkMenuButton* _tmp3_;
	GMenuModel* _tmp4_;
	GMenuModel* _tmp5_;
	gchar* path = NULL;
	FilesViewViewContainer* _tmp9_;
	GFile* _tmp10_;
	GFile* _tmp11_;
	gchar* _tmp12_;
	gboolean path_in_menu = FALSE;
	GMenu* menu = NULL;
	GtkMenuButton* _tmp13_;
	GMenuModel* _tmp14_;
	GMenuModel* _tmp15_;
	GMenu* _tmp16_;
	FilesViewViewContainer* _tmp34_;
	HdyTabView* _tmp35_;
	HdyTabView* _tmp36_;
	gint _tmp37_;
	gint _tmp38_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (page != NULL, FALSE);
	_tmp0_ = hdy_tab_page_get_child (page);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, FILES_VIEW_TYPE_VIEW_CONTAINER, FilesViewViewContainer));
	view_container = _tmp2_;
	_tmp3_ = self->priv->tab_history_button;
	_tmp4_ = gtk_menu_button_get_menu_model (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == NULL) {
		GtkMenuButton* _tmp6_;
		GMenu* _tmp7_;
		GMenu* _tmp8_;
		_tmp6_ = self->priv->tab_history_button;
		_tmp7_ = g_menu_new ();
		_tmp8_ = _tmp7_;
		gtk_menu_button_set_menu_model (_tmp6_, (GMenuModel*) _tmp8_);
		_g_object_unref0 (_tmp8_);
	}
	_tmp9_ = view_container;
	_tmp10_ = files_view_view_container_get_location (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_file_get_uri (_tmp11_);
	path = _tmp12_;
	path_in_menu = FALSE;
	_tmp13_ = self->priv->tab_history_button;
	_tmp14_ = gtk_menu_button_get_menu_model (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, g_menu_get_type (), GMenu));
	menu = _tmp16_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp17_ = FALSE;
			_tmp17_ = TRUE;
			while (TRUE) {
				GMenu* _tmp19_;
				const gchar* _tmp20_;
				GMenu* _tmp21_;
				const GVariantType* _tmp22_;
				GVariant* _tmp23_;
				GVariant* _tmp24_;
				const gchar* _tmp25_;
				gboolean _tmp26_;
				if (!_tmp17_) {
					gint _tmp18_;
					_tmp18_ = i;
					i = _tmp18_ + 1;
				}
				_tmp17_ = FALSE;
				_tmp19_ = menu;
				if (!(i < g_menu_model_get_n_items ((GMenuModel*) _tmp19_))) {
					break;
				}
				_tmp20_ = path;
				_tmp21_ = menu;
				_tmp22_ = G_VARIANT_TYPE_STRING;
				_tmp23_ = g_menu_model_get_item_attribute_value ((GMenuModel*) _tmp21_, i, G_MENU_ATTRIBUTE_TARGET, _tmp22_);
				_tmp24_ = _tmp23_;
				_tmp25_ = g_variant_get_string (_tmp24_, NULL);
				_tmp26_ = g_strcmp0 (_tmp20_, _tmp25_) == 0;
				_g_variant_unref0 (_tmp24_);
				if (_tmp26_) {
					path_in_menu = TRUE;
					break;
				}
			}
		}
	}
	if (!path_in_menu) {
		GMenu* _tmp27_;
		const gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		const gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		_tmp27_ = menu;
		_tmp28_ = path;
		_tmp29_ = files_file_utils_sanitize_path (_tmp28_, NULL, FALSE);
		_tmp30_ = _tmp29_;
		_tmp31_ = path;
		_tmp32_ = g_strdup_printf ("win.tabhistory-restore::%s", _tmp31_);
		_tmp33_ = _tmp32_;
		g_menu_append (_tmp27_, _tmp30_, _tmp33_);
		_g_free0 (_tmp33_);
		_g_free0 (_tmp30_);
	}
	_tmp34_ = view_container;
	files_view_view_container_close (_tmp34_);
	_tmp35_ = self->tab_view;
	hdy_tab_view_close_page_finish (_tmp35_, page, TRUE);
	_tmp36_ = self->tab_view;
	_tmp37_ = hdy_tab_view_get_n_pages (_tmp36_);
	_tmp38_ = _tmp37_;
	if (_tmp38_ == 0) {
		GFile* _tmp39_;
		GFile* _tmp40_;
		GFile* _tmp41_;
		FilesViewMode _tmp42_;
		FilesViewMode _tmp43_;
		_tmp39_ = files_view_window_get_default_location (self);
		_tmp40_ = _tmp39_;
		_tmp41_ = _tmp40_;
		_tmp42_ = files_view_window_get_default_mode (self);
		_tmp43_ = _tmp42_;
		files_view_window_add_tab (self, _tmp41_, _tmp43_, FALSE, NULL, NULL);
		_g_object_unref0 (_tmp41_);
	}
	result = GDK_EVENT_STOP;
	_g_object_unref0 (menu);
	_g_free0 (path);
	_g_object_unref0 (view_container);
	return result;
}

static Block51Data*
block51_data_ref (Block51Data* _data51_)
{
	g_atomic_int_inc (&_data51_->_ref_count_);
	return _data51_;
}

static void
block51_data_unref (void * _userdata_)
{
	Block51Data* _data51_;
	_data51_ = (Block51Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data51_->_ref_count_)) {
		FilesViewWindow* self;
		self = _data51_->self;
		_g_object_unref0 (_data51_->page);
		_g_object_unref0 (self);
		g_slice_free (Block51Data, _data51_);
	}
}

static void
__lambda200_ (Block51Data* _data51_)
{
	FilesViewWindow* self;
	self = _data51_->self;
	files_view_window_remove_tab (self, _data51_->page);
}

static void
___lambda200__g_simple_action_activate (GSimpleAction* _sender,
                                        GVariant* parameter,
                                        gpointer self)
{
	__lambda200_ (self);
}

static void
___lambda201_ (Block51Data* _data51_)
{
	FilesViewWindow* self;
	self = _data51_->self;
	{
		gint i = 0;
		i = _data51_->tab_position;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				HdyTabView* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				HdyTabView* _tmp5_;
				HdyTabPage* _tmp6_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->tab_view;
				_tmp3_ = hdy_tab_view_get_n_pages (_tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->tab_view;
				_tmp6_ = hdy_tab_view_get_nth_page (_tmp5_, i);
				files_view_window_remove_tab (self, _tmp6_);
			}
		}
	}
}

static void
____lambda201__g_simple_action_activate (GSimpleAction* _sender,
                                         GVariant* parameter,
                                         gpointer self)
{
	___lambda201_ (self);
}

static void
___lambda202_ (Block51Data* _data51_)
{
	FilesViewWindow* self;
	self = _data51_->self;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				HdyTabView* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				HdyTabView* _tmp5_;
				HdyTabPage* _tmp6_;
				HdyTabView* _tmp7_;
				HdyTabPage* _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->tab_view;
				_tmp3_ = hdy_tab_view_get_n_pages (_tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->tab_view;
				_tmp6_ = hdy_tab_view_get_nth_page (_tmp5_, i);
				if (_tmp6_ == _data51_->page) {
					continue;
				}
				_tmp7_ = self->tab_view;
				_tmp8_ = hdy_tab_view_get_nth_page (_tmp7_, i);
				files_view_window_remove_tab (self, _tmp8_);
			}
		}
	}
}

static void
____lambda202__g_simple_action_activate (GSimpleAction* _sender,
                                         GVariant* parameter,
                                         gpointer self)
{
	___lambda202_ (self);
}

static void
__lambda203_ (Block51Data* _data51_)
{
	FilesViewWindow* self;
	FilesViewViewContainer* view_container = NULL;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	FilesViewViewContainer* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	self = _data51_->self;
	_tmp0_ = hdy_tab_page_get_child (_data51_->page);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, FILES_VIEW_TYPE_VIEW_CONTAINER, FilesViewViewContainer));
	view_container = _tmp2_;
	_tmp3_ = files_view_view_container_get_location (view_container);
	_tmp4_ = _tmp3_;
	files_view_window_add_tab (self, _tmp4_, view_container->view_mode, FALSE, NULL, NULL);
	_g_object_unref0 (view_container);
}

static void
___lambda203__g_simple_action_activate (GSimpleAction* _sender,
                                        GVariant* parameter,
                                        gpointer self)
{
	__lambda203_ (self);
}

static void
__lambda204_ (Block51Data* _data51_)
{
	FilesViewWindow* self;
	FilesViewViewContainer* view_container = NULL;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	FilesViewViewContainer* _tmp2_;
	self = _data51_->self;
	_tmp0_ = hdy_tab_page_get_child (_data51_->page);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, FILES_VIEW_TYPE_VIEW_CONTAINER, FilesViewViewContainer));
	view_container = _tmp2_;
	files_view_window_move_content_to_new_window (self, view_container);
	_g_object_unref0 (view_container);
}

static void
___lambda204__g_simple_action_activate (GSimpleAction* _sender,
                                        GVariant* parameter,
                                        gpointer self)
{
	__lambda204_ (self);
}

static void
files_view_window_tab_view_setup_menu (FilesViewWindow* self,
                                       HdyTabPage* page)
{
	Block51Data* _data51_;
	HdyTabPage* _tmp0_;
	GSimpleAction* action_close = NULL;
	GSimpleAction* _tmp1_;
	GSimpleAction* action_close_end = NULL;
	GSimpleAction* _tmp2_;
	GSimpleAction* action_close_others = NULL;
	GSimpleAction* _tmp3_;
	GSimpleAction* action_duplicate = NULL;
	GSimpleAction* _tmp4_;
	GSimpleAction* action_move_to_new_window = NULL;
	GSimpleAction* _tmp5_;
	GSimpleAction* _tmp6_;
	GSimpleAction* _tmp7_;
	GSimpleAction* _tmp8_;
	GSimpleAction* _tmp9_;
	GSimpleAction* _tmp10_;
	FilesApplication* _tmp11_;
	gchar* _tmp12_;
	gchar** _tmp13_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	FilesApplication* _tmp15_;
	gchar* _tmp16_;
	gchar** _tmp17_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	FilesApplication* _tmp19_;
	gchar* _tmp20_;
	gchar** _tmp21_;
	gchar** _tmp22_;
	gint _tmp22__length1;
	GMenu* tab_menu = NULL;
	HdyTabView* _tmp23_;
	GMenuModel* _tmp24_;
	GMenuModel* _tmp25_;
	GMenu* _tmp26_;
	GMenu* _tmp27_;
	GMenu* open_tab_section = NULL;
	GMenu* _tmp28_;
	GMenu* _tmp29_;
	GMenu* _tmp30_;
	GMenu* close_tab_section = NULL;
	GMenu* _tmp31_;
	GMenu* _tmp32_;
	GMenu* _tmp33_;
	GMenu* _tmp34_;
	GMenu* _tmp35_;
	GMenu* _tmp36_;
	GMenu* _tmp37_;
	GMenu* _tmp38_;
	GSimpleAction* _tmp39_;
	HdyTabView* _tmp40_;
	HdyTabView* _tmp41_;
	gint _tmp42_;
	gint _tmp43_;
	HdyTabView* _tmp46_;
	gint _tmp47_;
	gint _tmp48_;
	GSimpleAction* _tmp51_;
	GSimpleAction* _tmp52_;
	g_return_if_fail (self != NULL);
	_data51_ = g_slice_new0 (Block51Data);
	_data51_->_ref_count_ = 1;
	_data51_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (page);
	_g_object_unref0 (_data51_->page);
	_data51_->page = _tmp0_;
	if (_data51_->page == NULL) {
		block51_data_unref (_data51_);
		_data51_ = NULL;
		return;
	}
	_tmp1_ = g_simple_action_new ("tabmenu-close", NULL);
	action_close = _tmp1_;
	_tmp2_ = g_simple_action_new ("tabmenu-close-end", NULL);
	action_close_end = _tmp2_;
	_tmp3_ = g_simple_action_new ("tabmenu-close-others", NULL);
	action_close_others = _tmp3_;
	_tmp4_ = g_simple_action_new ("tabmenu-duplicate", NULL);
	action_duplicate = _tmp4_;
	_tmp5_ = g_simple_action_new ("tabmenu-move-to-window", NULL);
	action_move_to_new_window = _tmp5_;
	_tmp6_ = action_close;
	g_action_map_add_action ((GActionMap*) self, (GAction*) _tmp6_);
	_tmp7_ = action_close_end;
	g_action_map_add_action ((GActionMap*) self, (GAction*) _tmp7_);
	_tmp8_ = action_close_others;
	g_action_map_add_action ((GActionMap*) self, (GAction*) _tmp8_);
	_tmp9_ = action_duplicate;
	g_action_map_add_action ((GActionMap*) self, (GAction*) _tmp9_);
	_tmp10_ = action_move_to_new_window;
	g_action_map_add_action ((GActionMap*) self, (GAction*) _tmp10_);
	_tmp11_ = self->priv->_marlin_app;
	_tmp12_ = g_strdup ("<Ctrl>W");
	_tmp13_ = g_new0 (gchar*, 1 + 1);
	_tmp13_[0] = _tmp12_;
	_tmp14_ = _tmp13_;
	_tmp14__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) _tmp11_, "win.tabmenu-close", _tmp14_);
	_tmp14_ = (_vala_array_free (_tmp14_, _tmp14__length1, (GDestroyNotify) g_free), NULL);
	_tmp15_ = self->priv->_marlin_app;
	_tmp16_ = g_strdup ("<Shift><Ctrl>K");
	_tmp17_ = g_new0 (gchar*, 1 + 1);
	_tmp17_[0] = _tmp16_;
	_tmp18_ = _tmp17_;
	_tmp18__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) _tmp15_, "win.tabmenu-duplicate", _tmp18_);
	_tmp18_ = (_vala_array_free (_tmp18_, _tmp18__length1, (GDestroyNotify) g_free), NULL);
	_tmp19_ = self->priv->_marlin_app;
	_tmp20_ = g_strdup ("<Ctrl><Alt>N");
	_tmp21_ = g_new0 (gchar*, 1 + 1);
	_tmp21_[0] = _tmp20_;
	_tmp22_ = _tmp21_;
	_tmp22__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) _tmp19_, "win.tabmenu-move-to-window", _tmp22_);
	_tmp22_ = (_vala_array_free (_tmp22_, _tmp22__length1, (GDestroyNotify) g_free), NULL);
	_tmp23_ = self->tab_view;
	_tmp24_ = hdy_tab_view_get_menu_model (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, g_menu_get_type (), GMenu));
	tab_menu = _tmp26_;
	_tmp27_ = tab_menu;
	g_menu_remove_all (_tmp27_);
	_tmp28_ = g_menu_new ();
	open_tab_section = _tmp28_;
	_tmp29_ = open_tab_section;
	g_menu_append (_tmp29_, _ ("Open in New Window"), "win.tabmenu-move-to-window");
	_tmp30_ = open_tab_section;
	g_menu_append (_tmp30_, _ ("Duplicate Tab"), "win.tabmenu-duplicate");
	_tmp31_ = g_menu_new ();
	close_tab_section = _tmp31_;
	_tmp32_ = close_tab_section;
	g_menu_append (_tmp32_, _ ("Close Tabs to the Right"), "win.tabmenu-close-end");
	_tmp33_ = close_tab_section;
	g_menu_append (_tmp33_, _ ("Close Other Tabs"), "win.tabmenu-close-others");
	_tmp34_ = close_tab_section;
	g_menu_append (_tmp34_, _ ("Close Tab"), "win.tabmenu-close");
	_tmp35_ = tab_menu;
	_tmp36_ = open_tab_section;
	g_menu_append_section (_tmp35_, NULL, (GMenuModel*) _tmp36_);
	_tmp37_ = tab_menu;
	_tmp38_ = close_tab_section;
	g_menu_append_section (_tmp37_, NULL, (GMenuModel*) _tmp38_);
	_tmp39_ = action_close;
	g_signal_connect_data (_tmp39_, "activate", (GCallback) ___lambda200__g_simple_action_activate, block51_data_ref (_data51_), (GClosureNotify) block51_data_unref, 0);
	_tmp40_ = self->tab_view;
	_data51_->tab_position = hdy_tab_view_get_page_position (_tmp40_, _data51_->page) + 1;
	_tmp41_ = self->tab_view;
	_tmp42_ = hdy_tab_view_get_n_pages (_tmp41_);
	_tmp43_ = _tmp42_;
	if (_data51_->tab_position == _tmp43_) {
		GSimpleAction* _tmp44_;
		_tmp44_ = action_close_end;
		g_simple_action_set_enabled (_tmp44_, FALSE);
	} else {
		GSimpleAction* _tmp45_;
		_tmp45_ = action_close_end;
		g_signal_connect_data (_tmp45_, "activate", (GCallback) ____lambda201__g_simple_action_activate, block51_data_ref (_data51_), (GClosureNotify) block51_data_unref, 0);
	}
	_tmp46_ = self->tab_view;
	_tmp47_ = hdy_tab_view_get_n_pages (_tmp46_);
	_tmp48_ = _tmp47_;
	if (_tmp48_ == 1) {
		GSimpleAction* _tmp49_;
		_tmp49_ = action_close_others;
		g_simple_action_set_enabled (_tmp49_, FALSE);
	} else {
		GSimpleAction* _tmp50_;
		_tmp50_ = action_close_others;
		g_signal_connect_data (_tmp50_, "activate", (GCallback) ____lambda202__g_simple_action_activate, block51_data_ref (_data51_), (GClosureNotify) block51_data_unref, 0);
	}
	_tmp51_ = action_duplicate;
	g_signal_connect_data (_tmp51_, "activate", (GCallback) ___lambda203__g_simple_action_activate, block51_data_ref (_data51_), (GClosureNotify) block51_data_unref, 0);
	_tmp52_ = action_move_to_new_window;
	g_signal_connect_data (_tmp52_, "activate", (GCallback) ___lambda204__g_simple_action_activate, block51_data_ref (_data51_), (GClosureNotify) block51_data_unref, 0);
	_g_object_unref0 (close_tab_section);
	_g_object_unref0 (open_tab_section);
	_g_object_unref0 (tab_menu);
	_g_object_unref0 (action_move_to_new_window);
	_g_object_unref0 (action_duplicate);
	_g_object_unref0 (action_close_others);
	_g_object_unref0 (action_close_end);
	_g_object_unref0 (action_close);
	block51_data_unref (_data51_);
	_data51_ = NULL;
}

void
files_view_window_set_title (FilesViewWindow* self,
                             const gchar* title)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (title != NULL);
	gtk_window_set_title ((GtkWindow*) self, title);
}

static void
files_view_window_change_tab (FilesViewWindow* self)
{
	FilesViewViewContainer* _tmp0_;
	FilesViewViewContainer* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	FilesViewViewContainer* _tmp4_;
	FilesViewViewContainer* _tmp5_;
	FilesSidebarInterface* _tmp6_;
	FilesViewViewContainer* _tmp7_;
	FilesViewViewContainer* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	FilesViewChromeLocationBar* _tmp11_;
	FilesViewViewContainer* _tmp12_;
	FilesViewViewContainer* _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	g_return_if_fail (self != NULL);
	if (self->priv->restoring_tabs > 0) {
		return;
	}
	_tmp0_ = files_view_window_get_current_container (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = files_view_view_container_get_uri (_tmp1_);
	_tmp3_ = _tmp2_;
	g_signal_emit (self, files_view_window_signals[FILES_VIEW_WINDOW_LOADING_URI_SIGNAL], 0, _tmp3_);
	_tmp4_ = files_view_window_get_current_container (self);
	_tmp5_ = _tmp4_;
	files_view_view_container_set_active_state (_tmp5_, TRUE, FALSE);
	_tmp6_ = self->sidebar;
	_tmp7_ = files_view_window_get_current_container (self);
	_tmp8_ = _tmp7_;
	_tmp9_ = files_view_view_container_get_uri (_tmp8_);
	_tmp10_ = _tmp9_;
	files_sidebar_interface_sync_uri (_tmp6_, _tmp10_);
	_tmp11_ = self->priv->location_bar;
	_tmp12_ = files_view_window_get_current_container (self);
	_tmp13_ = _tmp12_;
	_tmp14_ = files_view_view_container_get_is_frozen (_tmp13_);
	_tmp15_ = _tmp14_;
	files_view_chrome_location_bar_set_sensitive (_tmp11_, !_tmp15_);
	files_view_window_save_active_tab_position (self);
}

static void
files_view_window_open_tabs_data_free (gpointer _data)
{
	FilesViewWindowOpenTabsData* _data_;
	_data_ = _data;
	_data_->files = (_vala_array_free (_data_->files, _data_->files_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (_data_->self);
	g_slice_free (FilesViewWindowOpenTabsData, _data_);
}

void
files_view_window_open_tabs (FilesViewWindow* self,
                             GFile** files,
                             gint files_length1,
                             FilesViewMode mode,
                             gboolean ignore_duplicate,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_)
{
	FilesViewWindowOpenTabsData* _data_;
	FilesViewWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (FilesViewWindowOpenTabsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, files_view_window_open_tabs_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->files = (_vala_array_free (_data_->files, _data_->files_length1, (GDestroyNotify) g_object_unref), NULL);
	_data_->files = files;
	_data_->files_length1 = files_length1;
	_data_->mode = mode;
	_data_->ignore_duplicate = ignore_duplicate;
	files_view_window_open_tabs_co (_data_);
}

void
files_view_window_open_tabs_finish (FilesViewWindow* self,
                                    GAsyncResult* _res_)
{
	FilesViewWindowOpenTabsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
files_view_window_open_tabs_ready (GObject* source_object,
                                   GAsyncResult* _res_,
                                   gpointer _user_data_)
{
	FilesViewWindowOpenTabsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	files_view_window_open_tabs_co (_data_);
}

static void
___lambda209_ (FilesViewWindow* self)
{
	FilesViewViewContainer* _tmp0_;
	FilesViewViewContainer* _tmp1_;
	_tmp0_ = files_view_window_get_current_container (self);
	_tmp1_ = _tmp0_;
	files_view_view_container_set_active_state (_tmp1_, TRUE, FALSE);
}

static void
____lambda209__gasync_ready_callback (GObject* source_object,
                                      GAsyncResult* res,
                                      gpointer self)
{
	___lambda209_ ((FilesViewWindow*) self);
	g_object_unref (self);
}

static gboolean
files_view_window_open_tabs_co (FilesViewWindowOpenTabsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	files_view_window_restore_tabs (_data_->self, files_view_window_open_tabs_ready, _data_);
	return FALSE;
	_state_1:
	_data_->n_tabs_restored = files_view_window_restore_tabs_finish (_data_->self, _data_->_res_);
	if (_data_->n_tabs_restored < ((guint) 1)) {
		if (_data_->files == NULL) {
			_data_->_tmp2_ = TRUE;
		} else {
			_data_->_tmp2_ = _data_->files_length1 == 0;
		}
		if (_data_->_tmp2_) {
			_data_->_tmp1_ = TRUE;
		} else {
			_data_->_tmp3_ = _data_->files[0];
			_data_->_tmp1_ = _data_->_tmp3_ == NULL;
		}
		_data_->_tmp0_ = _data_->_tmp1_;
	} else {
		_data_->_tmp0_ = FALSE;
	}
	if (_data_->_tmp0_) {
		_data_->_tmp4_ = files_view_window_get_default_location (_data_->self);
		_data_->_tmp5_ = _data_->_tmp4_;
		_data_->_tmp6_ = _data_->_tmp5_;
		files_view_window_add_tab (_data_->self, _data_->_tmp6_, _data_->mode, FALSE, ____lambda209__gasync_ready_callback, g_object_ref (_data_->self));
		_g_object_unref0 (_data_->_tmp6_);
	} else {
		{
			_data_->file_collection_length1 = 0;
			_data_->_file_collection_size_ = 0;
			_data_->file_collection = _data_->files;
			_data_->file_collection_length1 = _data_->files_length1;
			for (_data_->file_it = 0; _data_->file_it < _data_->file_collection_length1; _data_->file_it = _data_->file_it + 1) {
				_data_->_tmp7_ = _g_object_ref0 (_data_->file_collection[_data_->file_it]);
				_data_->file = _data_->_tmp7_;
				{
					_data_->_tmp8_ = _data_->file;
					_data_->_tmp9_ = g_file_get_uri (_data_->_tmp8_);
					_data_->_tmp10_ = _data_->_tmp9_;
					_data_->_tmp11_ = files_view_window_get_file_from_uri (_data_->self, _data_->_tmp10_);
					_data_->_tmp12_ = _data_->_tmp11_;
					files_view_window_add_tab (_data_->self, _data_->_tmp12_, _data_->mode, _data_->ignore_duplicate, NULL, NULL);
					_g_object_unref0 (_data_->_tmp12_);
					_g_free0 (_data_->_tmp10_);
					_g_object_unref0 (_data_->file);
				}
			}
		}
	}
	_data_->files = (_vala_array_free (_data_->files, _data_->files_length1, (GDestroyNotify) g_object_unref), NULL);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
files_view_window_add_tab_by_uri_data_free (gpointer _data)
{
	FilesViewWindowAddTabByUriData* _data_;
	_data_ = _data;
	_g_free0 (_data_->uri);
	_g_object_unref0 (_data_->self);
	g_slice_free (FilesViewWindowAddTabByUriData, _data_);
}

static void
files_view_window_add_tab_by_uri (FilesViewWindow* self,
                                  const gchar* uri,
                                  FilesViewMode mode,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_)
{
	FilesViewWindowAddTabByUriData* _data_;
	FilesViewWindow* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	_data_ = g_slice_new0 (FilesViewWindowAddTabByUriData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, files_view_window_add_tab_by_uri_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (uri);
	_g_free0 (_data_->uri);
	_data_->uri = _tmp1_;
	_data_->mode = mode;
	files_view_window_add_tab_by_uri_co (_data_);
}

static gboolean
files_view_window_add_tab_by_uri_finish (FilesViewWindow* self,
                                         GAsyncResult* _res_)
{
	gboolean result;
	FilesViewWindowAddTabByUriData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static void
files_view_window_add_tab_by_uri_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_)
{
	FilesViewWindowAddTabByUriData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	files_view_window_add_tab_by_uri_co (_data_);
}

static gboolean
files_view_window_add_tab_by_uri_co (FilesViewWindowAddTabByUriData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = files_view_window_get_file_from_uri (_data_->self, _data_->uri);
	_data_->file = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->file;
	if (_data_->_tmp1_ != NULL) {
		_data_->_tmp2_ = _data_->file;
		_data_->_state_ = 1;
		files_view_window_add_tab (_data_->self, _data_->_tmp2_, _data_->mode, FALSE, files_view_window_add_tab_by_uri_ready, _data_);
		return FALSE;
		_state_1:
		_data_->result = files_view_window_add_tab_finish (_data_->self, _data_->_res_);
		_g_object_unref0 (_data_->file);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_data_->_tmp3_ = files_view_window_get_default_location (_data_->self);
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_tmp5_ = _data_->_tmp4_;
		_data_->_state_ = 2;
		files_view_window_add_tab (_data_->self, _data_->_tmp5_, _data_->mode, FALSE, files_view_window_add_tab_by_uri_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp6_ = files_view_window_add_tab_finish (_data_->self, _data_->_res_);
		_g_object_unref0 (_data_->_tmp5_);
		_data_->result = _data_->_tmp6_;
		_g_object_unref0 (_data_->file);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
}

static void
files_view_window_add_tab_data_free (gpointer _data)
{
	FilesViewWindowAddTabData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->_location);
	_g_object_unref0 (_data_->self);
	g_slice_free (FilesViewWindowAddTabData, _data_);
}

static void
files_view_window_add_tab (FilesViewWindow* self,
                           GFile* _location,
                           FilesViewMode mode,
                           gboolean ignore_duplicate,
                           GAsyncReadyCallback _callback_,
                           gpointer _user_data_)
{
	FilesViewWindowAddTabData* _data_;
	FilesViewWindow* _tmp0_;
	GFile* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_location != NULL);
	_data_ = g_slice_new0 (FilesViewWindowAddTabData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, files_view_window_add_tab_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (_location);
	_g_object_unref0 (_data_->_location);
	_data_->_location = _tmp1_;
	_data_->mode = mode;
	_data_->ignore_duplicate = ignore_duplicate;
	files_view_window_add_tab_co (_data_);
}

static gboolean
files_view_window_add_tab_finish (FilesViewWindow* self,
                                  GAsyncResult* _res_)
{
	gboolean result;
	FilesViewWindowAddTabData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static void
files_view_window_add_tab_ready (GObject* source_object,
                                 GAsyncResult* _res_,
                                 gpointer _user_data_)
{
	FilesViewWindowAddTabData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	files_view_window_add_tab_co (_data_);
}

static gboolean
files_view_window_add_tab_co (FilesViewWindowAddTabData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_state_ = 1;
		g_file_query_info_async (_data_->_location, G_FILE_ATTRIBUTE_STANDARD_TYPE, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, NULL, files_view_window_add_tab_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp0_ = g_file_query_info_finish (_data_->_location, _data_->_res_, &_data_->_inner_error0_);
		_data_->info = _data_->_tmp0_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp1_ = _data_->info;
		_data_->ftype = g_file_info_get_file_type (_data_->_tmp1_);
		_g_object_unref0 (_data_->info);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_data_->_inner_error0_);
		g_debug ("Window.vala:600: No info for requested location - abandon loading");
		_data_->result = FALSE;
		_g_object_unref0 (_data_->location);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->location);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (_data_->ftype == G_FILE_TYPE_REGULAR) {
		_data_->_tmp2_ = g_file_get_parent (_data_->_location);
		_g_object_unref0 (_data_->location);
		_data_->location = _data_->_tmp2_;
	} else {
		_data_->_tmp3_ = g_file_dup (_data_->_location);
		_g_object_unref0 (_data_->location);
		_data_->location = _data_->_tmp3_;
	}
	if (_data_->ignore_duplicate) {
		_data_->_tmp4_ = _data_->location;
		_data_->_tmp5_ = FALSE;
		_data_->_tmp6_ = files_view_window_location_is_duplicate (_data_->self, _data_->_tmp4_, _data_->ftype == G_FILE_TYPE_DIRECTORY, &_data_->_tmp5_);
		_data_->is_child = _data_->_tmp5_;
		_data_->existing_tab_position = _data_->_tmp6_;
		if (_data_->existing_tab_position >= 0) {
			_data_->_tmp7_ = _data_->self->tab_view;
			_data_->_tmp8_ = _data_->self->tab_view;
			_data_->_tmp9_ = hdy_tab_view_get_nth_page (_data_->_tmp8_, _data_->existing_tab_position);
			hdy_tab_view_set_selected_page (_data_->_tmp7_, _data_->_tmp9_);
			if (_data_->is_child) {
				_data_->_tmp10_ = files_view_window_get_current_container (_data_->self);
				_data_->_tmp11_ = _data_->_tmp10_;
				files_view_view_container_focus_location_if_in_current_directory (_data_->_tmp11_, _data_->_location, FALSE);
			}
			_data_->result = FALSE;
			_g_object_unref0 (_data_->location);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->mode = files_view_window_real_mode (_data_->self, _data_->mode);
	_data_->_tmp12_ = files_view_view_container_new ();
	g_object_ref_sink (_data_->_tmp12_);
	_data_->content = _data_->_tmp12_;
	_data_->_tmp13_ = _data_->location;
	if (!g_file_equal (_data_->_tmp13_, _data_->_location)) {
		_data_->_tmp14_ = _data_->content;
		_data_->_tmp15_ = _data_->location;
		_data_->_tmp16_ = _g_object_ref0 (_data_->_location);
		_data_->_tmp17_ = g_new0 (GFile*, 1 + 1);
		_data_->_tmp17_[0] = _data_->_tmp16_;
		_data_->_tmp18_ = _data_->_tmp17_;
		_data_->_tmp18__length1 = 1;
		files_view_view_container_add_view (_data_->_tmp14_, _data_->mode, _data_->_tmp15_, _data_->_tmp18_, (gint) 1);
		_data_->_tmp18_ = (_vala_array_free (_data_->_tmp18_, _data_->_tmp18__length1, (GDestroyNotify) g_object_unref), NULL);
	} else {
		_data_->_tmp19_ = _data_->content;
		_data_->_tmp20_ = _data_->location;
		files_view_view_container_add_view (_data_->_tmp19_, _data_->mode, _data_->_tmp20_, NULL, (gint) 0);
	}
	_data_->_tmp21_ = _data_->self->tab_view;
	_data_->_tmp22_ = _data_->content;
	_data_->_tmp23_ = hdy_tab_view_append (_data_->_tmp21_, (GtkWidget*) _data_->_tmp22_);
	_data_->_tmp24_ = _g_object_ref0 (_data_->_tmp23_);
	_data_->page = _data_->_tmp24_;
	_data_->_tmp25_ = _data_->self->tab_view;
	_data_->_tmp26_ = _data_->page;
	hdy_tab_view_set_selected_page (_data_->_tmp25_, _data_->_tmp26_);
	_data_->_tmp27_ = _data_->content;
	files_view_window_connect_content_signals (_data_->self, _data_->_tmp27_);
	_data_->result = TRUE;
	_g_object_unref0 (_data_->page);
	_g_object_unref0 (_data_->content);
	_g_object_unref0 (_data_->location);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
_files_view_window_check_for_tabs_with_same_name_files_view_view_container_tab_name_changed (FilesViewViewContainer* _sender,
                                                                                             const gchar* tab_name,
                                                                                             gpointer self)
{
	files_view_window_check_for_tabs_with_same_name ((FilesViewWindow*) self);
}

static void
_files_view_window_on_content_loading_files_view_view_container_loading (FilesViewViewContainer* _sender,
                                                                         gboolean is_loading,
                                                                         gpointer self)
{
	files_view_window_on_content_loading ((FilesViewWindow*) self, _sender, is_loading);
}

static void
_files_view_window_update_headerbar_files_view_view_container_active (FilesViewViewContainer* _sender,
                                                                      gpointer self)
{
	files_view_window_update_headerbar ((FilesViewWindow*) self);
}

void
files_view_window_connect_content_signals (FilesViewWindow* self,
                                           FilesViewViewContainer* content)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (content != NULL);
	g_signal_connect_object (content, "tab-name-changed", (GCallback) _files_view_window_check_for_tabs_with_same_name_files_view_view_container_tab_name_changed, self, 0);
	g_signal_connect_object (content, "loading", (GCallback) _files_view_window_on_content_loading_files_view_view_container_loading, self, 0);
	g_signal_connect_object (content, "active", (GCallback) _files_view_window_update_headerbar_files_view_view_container_active, self, 0);
}

void
files_view_window_disconnect_content_signals (FilesViewWindow* self,
                                              FilesViewViewContainer* content)
{
	guint _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (content != NULL);
	g_signal_parse_name ("tab-name-changed", FILES_VIEW_TYPE_VIEW_CONTAINER, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (content, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _files_view_window_check_for_tabs_with_same_name_files_view_view_container_tab_name_changed, self);
	g_signal_parse_name ("loading", FILES_VIEW_TYPE_VIEW_CONTAINER, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (content, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _files_view_window_on_content_loading_files_view_view_container_loading, self);
	g_signal_parse_name ("active", FILES_VIEW_TYPE_VIEW_CONTAINER, &_tmp2_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (content, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _files_view_window_update_headerbar_files_view_view_container_active, self);
}

static void
files_view_window_on_content_loading (FilesViewWindow* self,
                                      FilesViewViewContainer* content,
                                      gboolean is_loading)
{
	gboolean _tmp0_ = FALSE;
	HdyTabView* _tmp6_;
	HdyTabPage* _tmp7_;
	gboolean _tmp8_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (content != NULL);
	if (self->priv->restoring_tabs > 0) {
		_tmp0_ = !is_loading;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint _tmp1_;
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = self->priv->restoring_tabs;
		self->priv->restoring_tabs = _tmp1_ - 1;
		_vala_assert (self->priv->restoring_tabs >= 0, "restoring_tabs >= 0");
		_tmp2_ = files_view_view_container_get_can_show_folder (content);
		_tmp3_ = _tmp2_;
		if (!_tmp3_) {
			const gchar* _tmp4_;
			const gchar* _tmp5_;
			_tmp4_ = files_view_view_container_get_uri (content);
			_tmp5_ = _tmp4_;
			g_warning ("Window.vala:666: Cannot restore %s, ignoring", _tmp5_);
			files_view_window_remove_content (self, content);
		}
	}
	_tmp6_ = self->tab_view;
	_tmp7_ = hdy_tab_view_get_page (_tmp6_, (GtkWidget*) content);
	hdy_tab_page_set_loading (_tmp7_, is_loading);
	files_view_window_check_for_tabs_with_same_name (self);
	files_view_window_update_headerbar (self);
	if (self->priv->restoring_tabs == 0) {
		_tmp8_ = !is_loading;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		files_view_window_save_tabs (self);
	}
}

static gint
files_view_window_location_is_duplicate (FilesViewWindow* self,
                                         GFile* location,
                                         gboolean is_folder,
                                         gboolean* is_child)
{
	gboolean _vala_is_child = FALSE;
	gchar* parent_path = NULL;
	gchar* _tmp0_;
	gchar* uri = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gint existing_position = 0;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (location != NULL, 0);
	_vala_is_child = FALSE;
	_tmp0_ = g_strdup ("");
	parent_path = _tmp0_;
	_tmp1_ = g_file_get_uri (location);
	uri = _tmp1_;
	_tmp2_ = g_file_get_path (location);
	_tmp3_ = _tmp2_;
	_tmp4_ = files_file_utils_get_parent_path_from_path (_tmp3_, TRUE);
	_g_free0 (parent_path);
	parent_path = _tmp4_;
	_g_free0 (_tmp3_);
	existing_position = 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				HdyTabView* _tmp7_;
				gint _tmp8_;
				gint _tmp9_;
				HdyTabPage* tab = NULL;
				HdyTabView* _tmp10_;
				HdyTabPage* _tmp11_;
				HdyTabPage* _tmp12_;
				GFile* tab_location = NULL;
				HdyTabPage* _tmp13_;
				GtkWidget* _tmp14_;
				GtkWidget* _tmp15_;
				GFile* _tmp16_;
				GFile* _tmp17_;
				GFile* _tmp18_;
				gchar* tab_uri = NULL;
				GFile* _tmp19_;
				gchar* _tmp20_;
				const gchar* _tmp21_;
				const gchar* _tmp22_;
				gint _tmp23_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = self->tab_view;
				_tmp8_ = hdy_tab_view_get_n_pages (_tmp7_);
				_tmp9_ = _tmp8_;
				if (!(i < _tmp9_)) {
					break;
				}
				_tmp10_ = self->tab_view;
				_tmp11_ = hdy_tab_view_get_nth_page (_tmp10_, i);
				_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, hdy_tab_page_get_type (), HdyTabPage));
				tab = _tmp12_;
				_tmp13_ = tab;
				_tmp14_ = hdy_tab_page_get_child (_tmp13_);
				_tmp15_ = _tmp14_;
				_tmp16_ = files_view_view_container_get_location (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, FILES_VIEW_TYPE_VIEW_CONTAINER, FilesViewViewContainer));
				_tmp17_ = _tmp16_;
				_tmp18_ = _g_object_ref0 (_tmp17_);
				tab_location = _tmp18_;
				_tmp19_ = tab_location;
				_tmp20_ = g_file_get_uri (_tmp19_);
				tab_uri = _tmp20_;
				_tmp21_ = uri;
				_tmp22_ = tab_uri;
				if (files_file_utils_same_location (_tmp21_, _tmp22_)) {
					_vala_is_child = !is_folder;
					result = existing_position;
					_g_free0 (tab_uri);
					_g_object_unref0 (tab_location);
					_g_object_unref0 (tab);
					_g_free0 (uri);
					_g_free0 (parent_path);
					if (is_child) {
						*is_child = _vala_is_child;
					}
					return result;
				}
				_tmp23_ = existing_position;
				existing_position = _tmp23_ + 1;
				_g_free0 (tab_uri);
				_g_object_unref0 (tab_location);
				_g_object_unref0 (tab);
			}
		}
	}
	result = -1;
	_g_free0 (uri);
	_g_free0 (parent_path);
	if (is_child) {
		*is_child = _vala_is_child;
	}
	return result;
}

/** Compare every tab label with every other and resolve ambiguities **/
static void
files_view_window_check_for_tabs_with_same_name (FilesViewWindow* self)
{
	g_return_if_fail (self != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				HdyTabView* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				HdyTabPage* tab = NULL;
				HdyTabView* _tmp5_;
				HdyTabPage* _tmp6_;
				HdyTabPage* _tmp7_;
				FilesViewViewContainer* content = NULL;
				HdyTabPage* _tmp8_;
				GtkWidget* _tmp9_;
				GtkWidget* _tmp10_;
				FilesViewViewContainer* _tmp11_;
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				gchar* path = NULL;
				FilesViewViewContainer* _tmp21_;
				GFile* _tmp22_;
				GFile* _tmp23_;
				gchar* _tmp24_;
				const gchar* _tmp25_;
				gchar* basename = NULL;
				const gchar* _tmp33_;
				gchar* _tmp34_;
				FilesViewViewContainer* _tmp35_;
				const gchar* _tmp36_;
				const gchar* _tmp37_;
				const gchar* _tmp38_;
				const gchar* _tmp46_;
				HdyTabPage* _tmp47_;
				FilesViewViewContainer* _tmp48_;
				const gchar* _tmp49_;
				const gchar* _tmp50_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->tab_view;
				_tmp3_ = hdy_tab_view_get_n_pages (_tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->tab_view;
				_tmp6_ = hdy_tab_view_get_nth_page (_tmp5_, i);
				_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, hdy_tab_page_get_type (), HdyTabPage));
				tab = _tmp7_;
				_tmp8_ = tab;
				_tmp9_ = hdy_tab_page_get_child (_tmp8_);
				_tmp10_ = _tmp9_;
				content = G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, FILES_VIEW_TYPE_VIEW_CONTAINER, FilesViewViewContainer);
				_tmp11_ = content;
				_tmp12_ = files_view_view_container_get_tab_name (_tmp11_);
				_tmp13_ = _tmp12_;
				if (g_strcmp0 (_tmp13_, FILES_INVALID_TAB_NAME) == 0) {
					FilesViewViewContainer* _tmp14_;
					const gchar* _tmp15_;
					const gchar* _tmp16_;
					HdyTabPage* _tmp17_;
					FilesViewViewContainer* _tmp18_;
					const gchar* _tmp19_;
					const gchar* _tmp20_;
					_tmp14_ = content;
					_tmp15_ = files_view_view_container_get_tab_name (_tmp14_);
					_tmp16_ = _tmp15_;
					_tmp17_ = tab;
					_tmp18_ = content;
					_tmp19_ = files_view_view_container_get_tab_name (_tmp18_);
					_tmp20_ = _tmp19_;
					files_view_window_set_tab_label (self, _tmp16_, _tmp17_, _tmp20_);
					_g_object_unref0 (tab);
					continue;
				}
				_tmp21_ = content;
				_tmp22_ = files_view_view_container_get_location (_tmp21_);
				_tmp23_ = _tmp22_;
				_tmp24_ = g_file_get_path (_tmp23_);
				path = _tmp24_;
				_tmp25_ = path;
				if (_tmp25_ == NULL) {
					FilesViewViewContainer* _tmp26_;
					const gchar* _tmp27_;
					const gchar* _tmp28_;
					HdyTabPage* _tmp29_;
					FilesViewViewContainer* _tmp30_;
					const gchar* _tmp31_;
					const gchar* _tmp32_;
					_tmp26_ = content;
					_tmp27_ = files_view_view_container_get_tab_name (_tmp26_);
					_tmp28_ = _tmp27_;
					_tmp29_ = tab;
					_tmp30_ = content;
					_tmp31_ = files_view_view_container_get_tab_name (_tmp30_);
					_tmp32_ = _tmp31_;
					files_view_window_set_tab_label (self, _tmp28_, _tmp29_, _tmp32_);
					_g_free0 (path);
					_g_object_unref0 (tab);
					continue;
				}
				_tmp33_ = path;
				_tmp34_ = g_path_get_basename (_tmp33_);
				basename = _tmp34_;
				_tmp35_ = content;
				_tmp36_ = files_view_view_container_get_tab_name (_tmp35_);
				_tmp37_ = _tmp36_;
				_tmp38_ = basename;
				if (!g_str_has_suffix (_tmp37_, _tmp38_)) {
					FilesViewViewContainer* _tmp39_;
					const gchar* _tmp40_;
					const gchar* _tmp41_;
					HdyTabPage* _tmp42_;
					FilesViewViewContainer* _tmp43_;
					const gchar* _tmp44_;
					const gchar* _tmp45_;
					_tmp39_ = content;
					_tmp40_ = files_view_view_container_get_tab_name (_tmp39_);
					_tmp41_ = _tmp40_;
					_tmp42_ = tab;
					_tmp43_ = content;
					_tmp44_ = files_view_view_container_get_tab_name (_tmp43_);
					_tmp45_ = _tmp44_;
					files_view_window_set_tab_label (self, _tmp41_, _tmp42_, _tmp45_);
					_g_free0 (basename);
					_g_free0 (path);
					_g_object_unref0 (tab);
					continue;
				}
				_tmp46_ = basename;
				_tmp47_ = tab;
				_tmp48_ = content;
				_tmp49_ = files_view_view_container_get_tab_name (_tmp48_);
				_tmp50_ = _tmp49_;
				files_view_window_set_tab_label (self, _tmp46_, _tmp47_, _tmp50_);
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp51_ = FALSE;
						_tmp51_ = TRUE;
						while (TRUE) {
							HdyTabView* _tmp53_;
							gint _tmp54_;
							gint _tmp55_;
							HdyTabPage* tab2 = NULL;
							HdyTabView* _tmp56_;
							HdyTabPage* _tmp57_;
							HdyTabPage* _tmp58_;
							FilesViewViewContainer* content2 = NULL;
							HdyTabPage* _tmp59_;
							GtkWidget* _tmp60_;
							GtkWidget* _tmp61_;
							gboolean _tmp62_ = FALSE;
							FilesViewViewContainer* _tmp63_;
							FilesViewViewContainer* _tmp64_;
							gchar* path2 = NULL;
							FilesViewViewContainer* _tmp68_;
							GFile* _tmp69_;
							GFile* _tmp70_;
							gchar* _tmp71_;
							const gchar* _tmp72_;
							gchar* basename2 = NULL;
							const gchar* _tmp73_;
							gchar* _tmp74_;
							FilesViewViewContainer* _tmp75_;
							const gchar* _tmp76_;
							const gchar* _tmp77_;
							const gchar* _tmp78_;
							gboolean _tmp79_ = FALSE;
							const gchar* _tmp80_;
							const gchar* _tmp81_;
							if (!_tmp51_) {
								gint _tmp52_;
								_tmp52_ = j;
								j = _tmp52_ + 1;
							}
							_tmp51_ = FALSE;
							_tmp53_ = self->tab_view;
							_tmp54_ = hdy_tab_view_get_n_pages (_tmp53_);
							_tmp55_ = _tmp54_;
							if (!(j < _tmp55_)) {
								break;
							}
							_tmp56_ = self->tab_view;
							_tmp57_ = hdy_tab_view_get_nth_page (_tmp56_, j);
							_tmp58_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp57_, hdy_tab_page_get_type (), HdyTabPage));
							tab2 = _tmp58_;
							_tmp59_ = tab2;
							_tmp60_ = hdy_tab_page_get_child (_tmp59_);
							_tmp61_ = _tmp60_;
							content2 = G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, FILES_VIEW_TYPE_VIEW_CONTAINER, FilesViewViewContainer);
							_tmp63_ = content2;
							_tmp64_ = content;
							if (_tmp63_ == _tmp64_) {
								_tmp62_ = TRUE;
							} else {
								FilesViewViewContainer* _tmp65_;
								const gchar* _tmp66_;
								const gchar* _tmp67_;
								_tmp65_ = content2;
								_tmp66_ = files_view_view_container_get_tab_name (_tmp65_);
								_tmp67_ = _tmp66_;
								_tmp62_ = g_strcmp0 (_tmp67_, FILES_INVALID_TAB_NAME) == 0;
							}
							if (_tmp62_) {
								_g_object_unref0 (tab2);
								continue;
							}
							_tmp68_ = content2;
							_tmp69_ = files_view_view_container_get_location (_tmp68_);
							_tmp70_ = _tmp69_;
							_tmp71_ = g_file_get_path (_tmp70_);
							path2 = _tmp71_;
							_tmp72_ = path2;
							if (_tmp72_ == NULL) {
								_g_free0 (path2);
								_g_object_unref0 (tab2);
								continue;
							}
							_tmp73_ = path2;
							_tmp74_ = g_path_get_basename (_tmp73_);
							basename2 = _tmp74_;
							_tmp75_ = content2;
							_tmp76_ = files_view_view_container_get_tab_name (_tmp75_);
							_tmp77_ = _tmp76_;
							_tmp78_ = basename2;
							if (!g_str_has_suffix (_tmp77_, _tmp78_)) {
								_g_free0 (basename2);
								_g_free0 (path2);
								_g_object_unref0 (tab2);
								continue;
							}
							_tmp80_ = basename2;
							_tmp81_ = basename;
							if (g_strcmp0 (_tmp80_, _tmp81_) == 0) {
								const gchar* _tmp82_;
								const gchar* _tmp83_;
								_tmp82_ = path2;
								_tmp83_ = path;
								_tmp79_ = g_strcmp0 (_tmp82_, _tmp83_) != 0;
							} else {
								_tmp79_ = FALSE;
							}
							if (_tmp79_) {
								const gchar* _tmp84_;
								const gchar* _tmp85_;
								gchar* _tmp86_;
								gchar* _tmp87_;
								HdyTabPage* _tmp88_;
								FilesViewViewContainer* _tmp89_;
								const gchar* _tmp90_;
								const gchar* _tmp91_;
								const gchar* _tmp92_;
								const gchar* _tmp93_;
								gchar* _tmp94_;
								gchar* _tmp95_;
								HdyTabPage* _tmp96_;
								FilesViewViewContainer* _tmp97_;
								const gchar* _tmp98_;
								const gchar* _tmp99_;
								_tmp84_ = path2;
								_tmp85_ = path;
								_tmp86_ = files_file_utils_disambiguate_uri (_tmp84_, _tmp85_);
								_tmp87_ = _tmp86_;
								_tmp88_ = tab2;
								_tmp89_ = content2;
								_tmp90_ = files_view_view_container_get_tab_name (_tmp89_);
								_tmp91_ = _tmp90_;
								files_view_window_set_tab_label (self, _tmp87_, _tmp88_, _tmp91_);
								_g_free0 (_tmp87_);
								_tmp92_ = path;
								_tmp93_ = path2;
								_tmp94_ = files_file_utils_disambiguate_uri (_tmp92_, _tmp93_);
								_tmp95_ = _tmp94_;
								_tmp96_ = tab;
								_tmp97_ = content;
								_tmp98_ = files_view_view_container_get_tab_name (_tmp97_);
								_tmp99_ = _tmp98_;
								files_view_window_set_tab_label (self, _tmp95_, _tmp96_, _tmp99_);
								_g_free0 (_tmp95_);
							}
							_g_free0 (basename2);
							_g_free0 (path2);
							_g_object_unref0 (tab2);
						}
					}
				}
				_g_free0 (basename);
				_g_free0 (path);
				_g_object_unref0 (tab);
			}
		}
	}
	return;
}

static void
files_view_window_set_tab_label (FilesViewWindow* self,
                                 const gchar* label,
                                 HdyTabPage* tab,
                                 const gchar* tooltip)
{
	gchar* lab = NULL;
	gchar* _tmp0_;
	const gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (label != NULL);
	g_return_if_fail (tab != NULL);
	_tmp0_ = g_strdup (label);
	lab = _tmp0_;
	if (files_is_admin ()) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp1_ = lab;
		_tmp2_ = g_strconcat (" ", _ ("(as Administrator)"), NULL);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strconcat (_tmp1_, _tmp3_, NULL);
		_g_free0 (lab);
		lab = _tmp4_;
		_g_free0 (_tmp3_);
	}
	_tmp5_ = lab;
	hdy_tab_page_set_title (tab, _tmp5_);
	if (tooltip != NULL) {
		gchar* tt = NULL;
		gchar* _tmp6_;
		const gchar* _tmp11_;
		_tmp6_ = g_strdup (tooltip);
		tt = _tmp6_;
		if (files_is_admin ()) {
			const gchar* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp7_ = tt;
			_tmp8_ = g_strconcat (" ", _ ("(as Administrator)"), NULL);
			_tmp9_ = _tmp8_;
			_tmp10_ = g_strconcat (_tmp7_, _tmp9_, NULL);
			_g_free0 (tt);
			tt = _tmp10_;
			_g_free0 (_tmp9_);
		}
		_tmp11_ = tt;
		hdy_tab_page_set_tooltip (tab, _tmp11_);
		_g_free0 (tt);
	}
	_g_free0 (lab);
}

void
files_view_window_bookmark_uri (FilesViewWindow* self,
                                const gchar* uri,
                                const gchar* custom_name)
{
	FilesSidebarInterface* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	g_return_if_fail (custom_name != NULL);
	_tmp0_ = self->sidebar;
	files_sidebar_interface_add_favorite_uri (_tmp0_, uri, custom_name);
}

gboolean
files_view_window_can_bookmark_uri (FilesViewWindow* self,
                                    const gchar* uri)
{
	FilesSidebarInterface* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (uri != NULL, FALSE);
	_tmp0_ = self->sidebar;
	result = !files_sidebar_interface_has_favorite_uri (_tmp0_, uri);
	return result;
}

static void
files_view_window_move_content_to_new_window (FilesViewWindow* self,
                                              FilesViewViewContainer* view_container)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (view_container != NULL);
	_tmp0_ = files_view_view_container_get_location (view_container);
	_tmp1_ = _tmp0_;
	files_view_window_add_window (self, _tmp1_, view_container->view_mode);
	files_view_window_remove_content (self, view_container);
}

void
files_view_window_remove_content (FilesViewWindow* self,
                                  FilesViewViewContainer* view_container)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (view_container != NULL);
	{
		gint n = 0;
		n = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				HdyTabView* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				HdyTabPage* tab = NULL;
				HdyTabView* _tmp5_;
				HdyTabPage* _tmp6_;
				HdyTabPage* _tmp7_;
				HdyTabPage* _tmp8_;
				GtkWidget* _tmp9_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = n;
					n = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->tab_view;
				_tmp3_ = hdy_tab_view_get_n_pages (_tmp2_);
				_tmp4_ = _tmp3_;
				if (!(n < _tmp4_)) {
					break;
				}
				_tmp5_ = self->tab_view;
				_tmp6_ = hdy_tab_view_get_nth_page (_tmp5_, n);
				_tmp7_ = _g_object_ref0 (_tmp6_);
				tab = _tmp7_;
				_tmp8_ = tab;
				_tmp9_ = hdy_tab_page_get_child (_tmp8_);
				if (_tmp9_ == G_TYPE_CHECK_INSTANCE_CAST (view_container, gtk_widget_get_type (), GtkWidget)) {
					HdyTabPage* _tmp10_;
					_tmp10_ = tab;
					files_view_window_remove_tab (self, _tmp10_);
					_g_object_unref0 (tab);
					return;
				}
				_g_object_unref0 (tab);
			}
		}
	}
}

static Block52Data*
block52_data_ref (Block52Data* _data52_)
{
	g_atomic_int_inc (&_data52_->_ref_count_);
	return _data52_;
}

static void
block52_data_unref (void * _userdata_)
{
	Block52Data* _data52_;
	_data52_ = (Block52Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data52_->_ref_count_)) {
		FilesViewWindow* self;
		self = _data52_->self;
		_g_object_unref0 (_data52_->tab);
		_g_object_unref0 (self);
		g_slice_free (Block52Data, _data52_);
	}
}

static gboolean
___lambda74_ (Block52Data* _data52_)
{
	FilesViewWindow* self;
	HdyTabView* _tmp0_;
	gboolean result;
	self = _data52_->self;
	_tmp0_ = self->tab_view;
	hdy_tab_view_close_page (_tmp0_, _data52_->tab);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
____lambda74__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda74_ (self);
	return result;
}

static void
files_view_window_remove_tab (FilesViewWindow* self,
                              HdyTabPage* tab)
{
	Block52Data* _data52_;
	HdyTabPage* _tmp0_;
	g_return_if_fail (self != NULL);
	_data52_ = g_slice_new0 (Block52Data);
	_data52_->_ref_count_ = 1;
	_data52_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (tab);
	_g_object_unref0 (_data52_->tab);
	_data52_->tab = _tmp0_;
	if (_data52_->tab != NULL) {
		g_idle_add_full (G_PRIORITY_LOW, ____lambda74__gsource_func, block52_data_ref (_data52_), block52_data_unref);
	}
	block52_data_unref (_data52_);
	_data52_ = NULL;
}

static void
files_view_window_add_window (FilesViewWindow* self,
                              GFile* location,
                              FilesViewMode mode)
{
	FilesViewWindow* new_window = NULL;
	FilesApplication* _tmp0_;
	FilesViewWindow* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (location != NULL);
	_tmp0_ = self->priv->_marlin_app;
	_tmp1_ = files_view_window_new (_tmp0_);
	g_object_ref_sink (_tmp1_);
	new_window = _tmp1_;
	files_view_window_add_tab (new_window, location, files_view_window_real_mode (self, mode), FALSE, NULL, NULL);
	gtk_window_present ((GtkWindow*) new_window);
	_g_object_unref0 (new_window);
}

static void
files_view_window_undo_actions_set_insensitive (FilesViewWindow* self)
{
	GSimpleAction* action = NULL;
	GSimpleAction* _tmp0_;
	GSimpleAction* _tmp1_;
	GSimpleAction* _tmp2_;
	GSimpleAction* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = files_view_window_get_action (self, "undo");
	_g_object_unref0 (action);
	action = _tmp0_;
	_tmp1_ = action;
	g_simple_action_set_enabled (_tmp1_, FALSE);
	_tmp2_ = files_view_window_get_action (self, "redo");
	_g_object_unref0 (action);
	action = _tmp2_;
	_tmp3_ = action;
	g_simple_action_set_enabled (_tmp3_, FALSE);
	_g_object_unref0 (action);
}

static void
files_view_window_update_undo_actions (FilesViewWindow* self)
{
	GSimpleAction* action = NULL;
	GSimpleAction* _tmp0_;
	GSimpleAction* _tmp1_;
	FilesUndoManager* _tmp2_;
	GSimpleAction* _tmp3_;
	GSimpleAction* _tmp4_;
	FilesUndoManager* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = files_view_window_get_action (self, "undo");
	_g_object_unref0 (action);
	action = _tmp0_;
	_tmp1_ = action;
	_tmp2_ = self->priv->undo_manager;
	g_simple_action_set_enabled (_tmp1_, files_undo_manager_can_undo (_tmp2_));
	_tmp3_ = files_view_window_get_action (self, "redo");
	_g_object_unref0 (action);
	action = _tmp3_;
	_tmp4_ = action;
	_tmp5_ = self->priv->undo_manager;
	g_simple_action_set_enabled (_tmp4_, files_undo_manager_can_redo (_tmp5_));
	_g_object_unref0 (action);
}

static void
files_view_window_action_edit_path (FilesViewWindow* self)
{
	FilesViewChromeLocationBar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->location_bar;
	files_view_chrome_location_bar_enter_navigate_mode (_tmp0_, NULL);
}

static void
files_view_window_action_bookmark (FilesViewWindow* self,
                                   GSimpleAction* action,
                                   GVariant* param)
{
	GList* selected_files = NULL;
	FilesViewViewContainer* _tmp0_;
	FilesViewViewContainer* _tmp1_;
	FilesAbstractSlot* _tmp2_;
	GList* _tmp3_;
	GList* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = files_view_window_get_current_container (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->view;
	_tmp3_ = files_abstract_slot_get_selected_files (_tmp2_);
	selected_files = _tmp3_;
	_tmp4_ = selected_files;
	if (_tmp4_ == NULL) {
		FilesSidebarInterface* _tmp5_;
		FilesViewViewContainer* _tmp6_;
		FilesViewViewContainer* _tmp7_;
		GFile* _tmp8_;
		GFile* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp5_ = self->sidebar;
		_tmp6_ = files_view_window_get_current_container (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = files_view_view_container_get_location (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_file_get_uri (_tmp9_);
		_tmp11_ = _tmp10_;
		files_sidebar_interface_add_favorite_uri (_tmp5_, _tmp11_, "");
		_g_free0 (_tmp11_);
	} else {
		GList* _tmp12_;
		GList* _tmp13_;
		GList* _tmp14_;
		_tmp12_ = selected_files;
		_tmp13_ = g_list_first (_tmp12_);
		_tmp14_ = _tmp13_->next;
		if (_tmp14_ == NULL) {
			FilesSidebarInterface* _tmp15_;
			GList* _tmp16_;
			GList* _tmp17_;
			gconstpointer _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			_tmp15_ = self->sidebar;
			_tmp16_ = selected_files;
			_tmp17_ = g_list_first (_tmp16_);
			_tmp18_ = _tmp17_->data;
			_tmp19_ = files_file_get_uri ((FilesFile*) _tmp18_);
			_tmp20_ = _tmp19_;
			files_sidebar_interface_add_favorite_uri (_tmp15_, _tmp20_, "");
		}
	}
}

static void
files_view_window_action_find (FilesViewWindow* self,
                               GSimpleAction* action,
                               GVariant* param)
{
	gboolean _tmp0_ = FALSE;
	FilesViewViewContainer* _tmp1_;
	FilesViewViewContainer* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp1_ = files_view_window_get_current_container (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		FilesViewViewContainer* _tmp3_;
		FilesViewViewContainer* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp3_ = files_view_window_get_current_container (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = files_view_view_container_get_is_frozen (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_;
	}
	if (_tmp0_) {
		return;
	}
	if (param == NULL) {
		FilesViewChromeLocationBar* _tmp7_;
		_tmp7_ = self->priv->location_bar;
		files_view_chrome_location_bar_enter_search_mode (_tmp7_, "");
	} else {
		FilesViewChromeLocationBar* _tmp8_;
		const gchar* _tmp9_;
		_tmp8_ = self->priv->location_bar;
		_tmp9_ = g_variant_get_string (param, NULL);
		files_view_chrome_location_bar_enter_search_mode (_tmp8_, _tmp9_);
	}
}

static gboolean
___lambda146_ (FilesViewWindow* self)
{
	gboolean result;
	self->priv->adding_window = FALSE;
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
____lambda146__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda146_ ((FilesViewWindow*) self);
	return result;
}

static void
files_view_window_action_new_window (FilesViewWindow* self,
                                     GSimpleAction* action,
                                     GVariant* param)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	if (self->priv->adding_window) {
		return;
	} else {
		GFile* _tmp0_;
		GFile* _tmp1_;
		GFile* _tmp2_;
		FilesViewMode _tmp3_;
		FilesViewMode _tmp4_;
		self->priv->adding_window = TRUE;
		_tmp0_ = files_view_window_get_default_location (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = _tmp1_;
		_tmp3_ = files_view_window_get_default_mode (self);
		_tmp4_ = _tmp3_;
		files_view_window_add_window (self, _tmp2_, _tmp4_);
		_g_object_unref0 (_tmp2_);
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 500, ____lambda146__gsource_func, g_object_ref (self), g_object_unref);
	}
}

static void
files_view_window_action_reload (FilesViewWindow* self)
{
	HdyTabView* _tmp0_;
	HdyTabPage* _tmp1_;
	HdyTabPage* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	FilesAbstractSlot* slot = NULL;
	FilesViewViewContainer* _tmp5_;
	FilesViewViewContainer* _tmp6_;
	FilesAbstractSlot* _tmp7_;
	FilesAbstractSlot* _tmp8_;
	FilesSidebarInterface* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->tab_view;
	_tmp1_ = hdy_tab_view_get_selected_page (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = hdy_tab_page_get_loading (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		g_warning ("Window.vala:883: Too rapid reloading suppressed");
		return;
	}
	_tmp5_ = files_view_window_get_current_container (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = files_view_view_container_prepare_reload (_tmp6_);
	slot = _tmp7_;
	_tmp8_ = slot;
	if (_tmp8_ != NULL) {
		FilesAbstractSlot* _tmp9_;
		_tmp9_ = slot;
		files_abstract_slot_reload (_tmp9_, FALSE);
	}
	_tmp10_ = self->sidebar;
	files_sidebar_interface_reload (_tmp10_);
	_g_object_unref0 (slot);
}

static void
files_view_window_action_tabhistory_restore (FilesViewWindow* self,
                                             GSimpleAction* action,
                                             GVariant* parameter)
{
	const gchar* _tmp0_;
	FilesViewMode _tmp1_;
	FilesViewMode _tmp2_;
	GMenu* menu = NULL;
	GtkMenuButton* _tmp3_;
	GMenuModel* _tmp4_;
	GMenuModel* _tmp5_;
	GMenu* _tmp6_;
	GMenu* _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = g_variant_get_string (parameter, NULL);
	_tmp1_ = files_view_window_get_default_mode (self);
	_tmp2_ = _tmp1_;
	files_view_window_add_tab_by_uri (self, _tmp0_, _tmp2_, NULL, NULL);
	_tmp3_ = self->priv->tab_history_button;
	_tmp4_ = gtk_menu_button_get_menu_model (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, g_menu_get_type (), GMenu));
	menu = _tmp6_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				GMenu* _tmp9_;
				GMenu* _tmp10_;
				const GVariantType* _tmp11_;
				GVariant* _tmp12_;
				GVariant* _tmp13_;
				gboolean _tmp14_;
				if (!_tmp7_) {
					gint _tmp8_;
					_tmp8_ = i;
					i = _tmp8_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp9_ = menu;
				if (!(i < g_menu_model_get_n_items ((GMenuModel*) _tmp9_))) {
					break;
				}
				_tmp10_ = menu;
				_tmp11_ = G_VARIANT_TYPE_STRING;
				_tmp12_ = g_menu_model_get_item_attribute_value ((GMenuModel*) _tmp10_, i, G_MENU_ATTRIBUTE_TARGET, _tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = parameter == _tmp13_;
				_g_variant_unref0 (_tmp13_);
				if (_tmp14_) {
					GMenu* _tmp15_;
					_tmp15_ = menu;
					g_menu_remove (_tmp15_, i);
					break;
				}
			}
		}
	}
	_tmp16_ = menu;
	if (g_menu_model_get_n_items ((GMenuModel*) _tmp16_) == 0) {
		GtkMenuButton* _tmp17_;
		_tmp17_ = self->priv->tab_history_button;
		gtk_menu_button_set_menu_model (_tmp17_, NULL);
	}
	_g_object_unref0 (menu);
}

static void
files_view_window_action_view_mode (FilesViewWindow* self,
                                    GSimpleAction* action,
                                    GVariant* param)
{
	gboolean _tmp0_ = FALSE;
	HdyTabView* _tmp1_;
	FilesViewMode mode = 0;
	FilesViewViewContainer* _tmp4_;
	FilesViewViewContainer* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp1_ = self->tab_view;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		FilesViewViewContainer* _tmp2_;
		FilesViewViewContainer* _tmp3_;
		_tmp2_ = files_view_window_get_current_container (self);
		_tmp3_ = _tmp2_;
		_tmp0_ = _tmp3_ == NULL;
	}
	if (_tmp0_) {
		return;
	}
	mode = files_view_window_real_mode (self, (FilesViewMode) g_variant_get_uint32 (param));
	_tmp4_ = files_view_window_get_current_container (self);
	_tmp5_ = _tmp4_;
	files_view_view_container_change_view_mode (_tmp5_, mode, NULL);
}

static void
files_view_window_action_back (FilesViewWindow* self,
                               GSimpleAction* action,
                               GVariant* param)
{
	FilesViewViewContainer* _tmp0_;
	FilesViewViewContainer* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = files_view_window_get_current_container (self);
	_tmp1_ = _tmp0_;
	files_view_view_container_go_back (_tmp1_, (gint) g_variant_get_int32 (param));
}

static void
files_view_window_action_forward (FilesViewWindow* self,
                                  GSimpleAction* action,
                                  GVariant* param)
{
	FilesViewViewContainer* _tmp0_;
	FilesViewViewContainer* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = files_view_window_get_current_container (self);
	_tmp1_ = _tmp0_;
	files_view_view_container_go_forward (_tmp1_, (gint) g_variant_get_int32 (param));
}

static void
files_view_window_action_go_to (FilesViewWindow* self,
                                GSimpleAction* action,
                                GVariant* param)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	static GQuark _tmp2_label4 = 0;
	static GQuark _tmp2_label5 = 0;
	static GQuark _tmp2_label6 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = g_variant_get_string (param, NULL);
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("RECENT")))) {
		switch (0) {
			default:
			{
				files_view_window_uri_path_change_request (self, FILES_RECENT_URI, FILES_OPEN_FLAG_DEFAULT);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("HOME")))) {
		switch (0) {
			default:
			{
				gchar* _tmp4_;
				gchar* _tmp5_;
				gchar* _tmp6_;
				gchar* _tmp7_;
				_tmp4_ = pf_user_utils_get_real_user_home ();
				_tmp5_ = _tmp4_;
				_tmp6_ = g_strconcat ("file://", _tmp5_, NULL);
				_tmp7_ = _tmp6_;
				files_view_window_uri_path_change_request (self, _tmp7_, FILES_OPEN_FLAG_DEFAULT);
				_g_free0 (_tmp7_);
				_g_free0 (_tmp5_);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("TRASH")))) {
		switch (0) {
			default:
			{
				files_view_window_uri_path_change_request (self, FILES_TRASH_URI, FILES_OPEN_FLAG_DEFAULT);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("ROOT")))) {
		switch (0) {
			default:
			{
				files_view_window_uri_path_change_request (self, FILES_ROOT_FS_URI, FILES_OPEN_FLAG_DEFAULT);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("NETWORK")))) {
		switch (0) {
			default:
			{
				files_view_window_uri_path_change_request (self, FILES_NETWORK_URI, FILES_OPEN_FLAG_DEFAULT);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("SERVER")))) {
		switch (0) {
			default:
			{
				files_view_window_connect_to_server (self);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label6) ? _tmp2_label6 : (_tmp2_label6 = g_quark_from_static_string ("UP")))) {
		switch (0) {
			default:
			{
				FilesViewViewContainer* _tmp8_;
				FilesViewViewContainer* _tmp9_;
				_tmp8_ = files_view_window_get_current_container (self);
				_tmp9_ = _tmp8_;
				files_view_view_container_go_up (_tmp9_);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				break;
			}
		}
	}
}

static void
files_view_window_action_zoom (FilesViewWindow* self,
                               GSimpleAction* action,
                               GVariant* param)
{
	FilesViewViewContainer* _tmp0_;
	FilesViewViewContainer* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = files_view_window_get_current_container (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		FilesViewViewContainer* _tmp2_;
		FilesViewViewContainer* _tmp3_;
		FilesAbstractSlot* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		GQuark _tmp8_ = 0U;
		static GQuark _tmp7_label0 = 0;
		static GQuark _tmp7_label1 = 0;
		static GQuark _tmp7_label2 = 0;
		_tmp2_ = files_view_window_get_current_container (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_->view;
		_vala_assert (_tmp4_ != NULL, "current_container.view != null");
		_tmp5_ = g_variant_get_string (param, NULL);
		_tmp6_ = _tmp5_;
		_tmp8_ = (NULL == _tmp6_) ? 0 : g_quark_from_string (_tmp6_);
		if (_tmp8_ == ((0 != _tmp7_label0) ? _tmp7_label0 : (_tmp7_label0 = g_quark_from_static_string ("ZOOM_IN")))) {
			switch (0) {
				default:
				{
					FilesViewViewContainer* _tmp9_;
					FilesViewViewContainer* _tmp10_;
					FilesAbstractSlot* _tmp11_;
					_tmp9_ = files_view_window_get_current_container (self);
					_tmp10_ = _tmp9_;
					_tmp11_ = _tmp10_->view;
					files_abstract_slot_zoom_in (_tmp11_);
					break;
				}
			}
		} else if (_tmp8_ == ((0 != _tmp7_label1) ? _tmp7_label1 : (_tmp7_label1 = g_quark_from_static_string ("ZOOM_OUT")))) {
			switch (0) {
				default:
				{
					FilesViewViewContainer* _tmp12_;
					FilesViewViewContainer* _tmp13_;
					FilesAbstractSlot* _tmp14_;
					_tmp12_ = files_view_window_get_current_container (self);
					_tmp13_ = _tmp12_;
					_tmp14_ = _tmp13_->view;
					files_abstract_slot_zoom_out (_tmp14_);
					break;
				}
			}
		} else if (_tmp8_ == ((0 != _tmp7_label2) ? _tmp7_label2 : (_tmp7_label2 = g_quark_from_static_string ("ZOOM_NORMAL")))) {
			switch (0) {
				default:
				{
					FilesViewViewContainer* _tmp15_;
					FilesViewViewContainer* _tmp16_;
					FilesAbstractSlot* _tmp17_;
					_tmp15_ = files_view_window_get_current_container (self);
					_tmp16_ = _tmp15_;
					_tmp17_ = _tmp16_->view;
					files_abstract_slot_zoom_normal (_tmp17_);
					break;
				}
			}
		} else {
			switch (0) {
				default:
				{
					break;
				}
			}
		}
	}
}

static void
files_view_window_action_tab (FilesViewWindow* self,
                              GSimpleAction* action,
                              GVariant* param)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	static GQuark _tmp2_label4 = 0;
	static GQuark _tmp2_label5 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = g_variant_get_string (param, NULL);
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("NEW")))) {
		switch (0) {
			default:
			{
				GFile* _tmp4_;
				GFile* _tmp5_;
				GFile* _tmp6_;
				FilesViewMode _tmp7_;
				FilesViewMode _tmp8_;
				_tmp4_ = files_view_window_get_default_location (self);
				_tmp5_ = _tmp4_;
				_tmp6_ = _tmp5_;
				_tmp7_ = files_view_window_get_default_mode (self);
				_tmp8_ = _tmp7_;
				files_view_window_add_tab (self, _tmp6_, _tmp8_, FALSE, NULL, NULL);
				_g_object_unref0 (_tmp6_);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("CLOSE")))) {
		switch (0) {
			default:
			{
				HdyTabView* _tmp9_;
				HdyTabPage* _tmp10_;
				HdyTabPage* _tmp11_;
				_tmp9_ = self->tab_view;
				_tmp10_ = hdy_tab_view_get_selected_page (_tmp9_);
				_tmp11_ = _tmp10_;
				files_view_window_remove_tab (self, _tmp11_);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("NEXT")))) {
		switch (0) {
			default:
			{
				HdyTabView* _tmp12_;
				_tmp12_ = self->tab_view;
				hdy_tab_view_select_next_page (_tmp12_);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("PREVIOUS")))) {
		switch (0) {
			default:
			{
				HdyTabView* _tmp13_;
				_tmp13_ = self->tab_view;
				hdy_tab_view_select_previous_page (_tmp13_);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("TAB")))) {
		switch (0) {
			default:
			{
				FilesViewViewContainer* _tmp14_;
				FilesViewViewContainer* _tmp15_;
				GFile* _tmp16_;
				GFile* _tmp17_;
				FilesViewViewContainer* _tmp18_;
				FilesViewViewContainer* _tmp19_;
				_tmp14_ = files_view_window_get_current_container (self);
				_tmp15_ = _tmp14_;
				_tmp16_ = files_view_view_container_get_location (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = files_view_window_get_current_container (self);
				_tmp19_ = _tmp18_;
				files_view_window_add_tab (self, _tmp17_, _tmp19_->view_mode, FALSE, NULL, NULL);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("WINDOW")))) {
		switch (0) {
			default:
			{
				FilesViewViewContainer* _tmp20_;
				FilesViewViewContainer* _tmp21_;
				_tmp20_ = files_view_window_get_current_container (self);
				_tmp21_ = _tmp20_;
				files_view_window_move_content_to_new_window (self, _tmp21_);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				break;
			}
		}
	}
}

static void
files_view_window_action_info (FilesViewWindow* self,
                               GSimpleAction* action,
                               GVariant* param)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = g_variant_get_string (param, NULL);
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("HELP")))) {
		switch (0) {
			default:
			{
				files_view_window_show_app_help (self);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				break;
			}
		}
	}
}

static void
__lambda147_ (FilesViewWindow* self,
              GObject* obj,
              GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		FilesUndoManager* _tmp0_;
		_tmp0_ = self->priv->undo_manager;
		files_undo_manager_undo_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		files_view_window_after_undo_redo (self);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_critical ("Window.vala:1039: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda147__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	__lambda147_ ((FilesViewWindow*) self, source_object, res);
	g_object_unref (self);
}

static void
files_view_window_action_undo (FilesViewWindow* self,
                               GSimpleAction* action,
                               GVariant* param)
{
	FilesUndoManager* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	if (self->priv->doing_undo_redo) {
		return;
	}
	files_view_window_before_undo_redo (self);
	_tmp0_ = self->priv->undo_manager;
	files_undo_manager_undo (_tmp0_, (GtkWidget*) self, NULL, ___lambda147__gasync_ready_callback, g_object_ref (self));
}

static void
__lambda148_ (FilesViewWindow* self,
              GObject* obj,
              GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		FilesUndoManager* _tmp0_;
		_tmp0_ = self->priv->undo_manager;
		files_undo_manager_redo_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		files_view_window_after_undo_redo (self);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_critical ("Window.vala:1054: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda148__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	__lambda148_ ((FilesViewWindow*) self, source_object, res);
	g_object_unref (self);
}

static void
files_view_window_action_redo (FilesViewWindow* self,
                               GSimpleAction* action,
                               GVariant* param)
{
	FilesUndoManager* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	if (self->priv->doing_undo_redo) {
		return;
	}
	files_view_window_before_undo_redo (self);
	_tmp0_ = self->priv->undo_manager;
	files_undo_manager_redo (_tmp0_, (GtkWidget*) self, NULL, ___lambda148__gasync_ready_callback, g_object_ref (self));
}

static void
files_view_window_action_focus_sidebar (FilesViewWindow* self)
{
	FilesSidebarInterface* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->sidebar;
	files_sidebar_interface_focus (_tmp0_);
}

static void
files_view_window_before_undo_redo (FilesViewWindow* self)
{
	g_return_if_fail (self != NULL);
	self->priv->doing_undo_redo = TRUE;
	files_view_window_update_undo_actions (self);
}

void
files_view_window_after_undo_redo (FilesViewWindow* self)
{
	FilesViewViewContainer* _tmp0_;
	FilesViewViewContainer* _tmp1_;
	FilesAbstractSlot* _tmp2_;
	FilesAbstractSlot* _tmp3_;
	FilesDirectory* _tmp4_;
	FilesDirectory* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = files_view_window_get_current_container (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = files_view_view_container_get_slot (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = files_abstract_slot_get_directory (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = files_directory_get_is_recent (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_) {
		GActionGroup* _tmp8_;
		_tmp8_ = gtk_widget_get_action_group ((GtkWidget*) self, "win");
		g_action_group_activate_action (_tmp8_, "refresh", NULL);
	}
	self->priv->doing_undo_redo = FALSE;
}

void
files_view_window_change_state_show_hidden (FilesViewWindow* self,
                                            GSimpleAction* action)
{
	gboolean state = FALSE;
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	gboolean _tmp3_;
	GVariant* _tmp4_;
	GVariant* _tmp5_;
	GSettings* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = g_action_get_state ((GAction*) action);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = !g_variant_get_boolean (_tmp2_);
	_g_variant_unref0 (_tmp2_);
	state = _tmp3_;
	_tmp4_ = g_variant_new_boolean (state);
	g_variant_ref_sink (_tmp4_);
	_tmp5_ = _tmp4_;
	g_simple_action_set_state (action, _tmp5_);
	_g_variant_unref0 (_tmp5_);
	_tmp6_ = files_app_settings;
	g_settings_set_boolean (_tmp6_, "show-hiddenfiles", state);
}

void
files_view_window_change_state_single_click_select (FilesViewWindow* self,
                                                    GSimpleAction* action)
{
	gboolean state = FALSE;
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	gboolean _tmp3_;
	GVariant* _tmp4_;
	GVariant* _tmp5_;
	FilesPreferences* _tmp6_;
	FilesPreferences* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = g_action_get_state ((GAction*) action);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = !g_variant_get_boolean (_tmp2_);
	_g_variant_unref0 (_tmp2_);
	state = _tmp3_;
	_tmp4_ = g_variant_new_boolean (state);
	g_variant_ref_sink (_tmp4_);
	_tmp5_ = _tmp4_;
	g_simple_action_set_state (action, _tmp5_);
	_g_variant_unref0 (_tmp5_);
	_tmp6_ = files_preferences_get_default ();
	_tmp7_ = _tmp6_;
	files_preferences_set_singleclick_select (_tmp7_, state);
	_g_object_unref0 (_tmp7_);
}

void
files_view_window_change_state_show_remote_thumbnails (FilesViewWindow* self,
                                                       GSimpleAction* action)
{
	gboolean state = FALSE;
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	gboolean _tmp3_;
	GVariant* _tmp4_;
	GVariant* _tmp5_;
	GSettings* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = g_action_get_state ((GAction*) action);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = !g_variant_get_boolean (_tmp2_);
	_g_variant_unref0 (_tmp2_);
	state = _tmp3_;
	_tmp4_ = g_variant_new_boolean (state);
	g_variant_ref_sink (_tmp4_);
	_tmp5_ = _tmp4_;
	g_simple_action_set_state (action, _tmp5_);
	_g_variant_unref0 (_tmp5_);
	_tmp6_ = files_app_settings;
	g_settings_set_boolean (_tmp6_, "show-remote-thumbnails", state);
}

void
files_view_window_change_state_show_local_thumbnails (FilesViewWindow* self,
                                                      GSimpleAction* action)
{
	gboolean state = FALSE;
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	gboolean _tmp3_;
	GVariant* _tmp4_;
	GVariant* _tmp5_;
	GSettings* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = g_action_get_state ((GAction*) action);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = !g_variant_get_boolean (_tmp2_);
	_g_variant_unref0 (_tmp2_);
	state = _tmp3_;
	_tmp4_ = g_variant_new_boolean (state);
	g_variant_ref_sink (_tmp4_);
	_tmp5_ = _tmp4_;
	g_simple_action_set_state (action, _tmp5_);
	_g_variant_unref0 (_tmp5_);
	_tmp6_ = files_app_settings;
	g_settings_set_boolean (_tmp6_, "show-local-thumbnails", state);
}

void
files_view_window_change_state_folders_before_files (FilesViewWindow* self,
                                                     GSimpleAction* action)
{
	gboolean state = FALSE;
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	gboolean _tmp3_;
	GVariant* _tmp4_;
	GVariant* _tmp5_;
	FilesPreferences* _tmp6_;
	FilesPreferences* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = g_action_get_state ((GAction*) action);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = !g_variant_get_boolean (_tmp2_);
	_g_variant_unref0 (_tmp2_);
	state = _tmp3_;
	_tmp4_ = g_variant_new_boolean (state);
	g_variant_ref_sink (_tmp4_);
	_tmp5_ = _tmp4_;
	g_simple_action_set_state (action, _tmp5_);
	_g_variant_unref0 (_tmp5_);
	_tmp6_ = files_preferences_get_default ();
	_tmp7_ = _tmp6_;
	files_preferences_set_sort_directories_first (_tmp7_, state);
	_g_object_unref0 (_tmp7_);
}

void
files_view_window_change_state_restore_tabs_on_startup (FilesViewWindow* self,
                                                        GSimpleAction* action)
{
	gboolean state = FALSE;
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	gboolean _tmp3_;
	GVariant* _tmp4_;
	GVariant* _tmp5_;
	GSettings* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = g_action_get_state ((GAction*) action);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = !g_variant_get_boolean (_tmp2_);
	_g_variant_unref0 (_tmp2_);
	state = _tmp3_;
	_tmp4_ = g_variant_new_boolean (state);
	g_variant_ref_sink (_tmp4_);
	_tmp5_ = _tmp4_;
	g_simple_action_set_state (action, _tmp5_);
	_g_variant_unref0 (_tmp5_);
	_tmp6_ = files_app_settings;
	g_settings_set_boolean (_tmp6_, "restore-tabs", state);
}

static Block53Data*
block53_data_ref (Block53Data* _data53_)
{
	g_atomic_int_inc (&_data53_->_ref_count_);
	return _data53_;
}

static void
block53_data_unref (void * _userdata_)
{
	Block53Data* _data53_;
	_data53_ = (Block53Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data53_->_ref_count_)) {
		FilesViewWindow* self;
		self = _data53_->self;
		_g_free0 (_data53_->server_uri);
		_g_object_unref0 (_data53_->dialog);
		_g_object_unref0 (self);
		g_slice_free (Block53Data, _data53_);
	}
}

static void
__lambda149_ (Block53Data* _data53_,
              gint res)
{
	FilesViewWindow* self;
	self = _data53_->self;
	if (res == ((gint) GTK_RESPONSE_OK)) {
		const gchar* _tmp0_;
		const gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp0_ = pf_connect_server_dialog_get_server_uri (_data53_->dialog);
		_tmp1_ = _tmp0_;
		_tmp2_ = g_strdup (_tmp1_);
		_g_free0 (_data53_->server_uri);
		_data53_->server_uri = _tmp2_;
		if (g_strcmp0 (_data53_->server_uri, "") != 0) {
			const gchar* _tmp3_;
			const gchar* _tmp4_;
			_tmp3_ = pf_connect_server_dialog_get_server_uri (_data53_->dialog);
			_tmp4_ = _tmp3_;
			files_view_window_uri_path_change_request (self, _tmp4_, FILES_OPEN_FLAG_DEFAULT);
		}
	}
	gtk_widget_destroy ((GtkWidget*) _data53_->dialog);
}

static void
___lambda149__gtk_dialog_response (GtkDialog* _sender,
                                   gint response_id,
                                   gpointer self)
{
	__lambda149_ (self, response_id);
}

static void
files_view_window_connect_to_server (FilesViewWindow* self)
{
	Block53Data* _data53_;
	PFConnectServerDialog* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_data53_ = g_slice_new0 (Block53Data);
	_data53_->_ref_count_ = 1;
	_data53_->self = g_object_ref (self);
	_tmp0_ = pf_connect_server_dialog_new (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow));
	g_object_ref_sink (_tmp0_);
	_data53_->dialog = _tmp0_;
	_tmp1_ = g_strdup ("");
	_data53_->server_uri = _tmp1_;
	g_signal_connect_data ((GtkDialog*) _data53_->dialog, "response", (GCallback) ___lambda149__gtk_dialog_response, block53_data_ref (_data53_), (GClosureNotify) block53_data_unref, 0);
	gtk_window_present ((GtkWindow*) _data53_->dialog);
	block53_data_unref (_data53_);
	_data53_ = NULL;
}

static void
__lambda150_ (FilesViewWindow* self,
              GObject* obj,
              GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		g_app_info_launch_default_for_uri_finish (res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = e;
		_tmp1_ = _tmp0_->message;
		g_warning ("Window.vala:1135: Could not open help: %s", _tmp1_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda150__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	__lambda150_ ((FilesViewWindow*) self, source_object, res);
	g_object_unref (self);
}

static void
files_view_window_show_app_help (FilesViewWindow* self)
{
	g_return_if_fail (self != NULL);
	g_app_info_launch_default_for_uri_async (FILES_HELP_URL, NULL, NULL, ___lambda150__gasync_ready_callback, g_object_ref (self));
}

GSimpleAction*
files_view_window_get_action (FilesViewWindow* self,
                              const gchar* action_name)
{
	GAction* _tmp0_;
	GSimpleAction* _tmp1_;
	GSimpleAction* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (action_name != NULL, NULL);
	_tmp0_ = g_action_map_lookup_action ((GActionMap*) self, action_name);
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_simple_action_get_type (), GSimpleAction));
	result = _tmp1_;
	return result;
}

static FilesViewMode
files_view_window_real_mode (FilesViewWindow* self,
                             FilesViewMode mode)
{
	GSettings* _tmp2_;
	FilesViewMode result;
	g_return_val_if_fail (self != NULL, 0);
	switch (mode) {
		case FILES_VIEW_MODE_ICON:
		case FILES_VIEW_MODE_LIST:
		case FILES_VIEW_MODE_MILLER_COLUMNS:
		{
			result = mode;
			return result;
		}
		case FILES_VIEW_MODE_CURRENT:
		{
			FilesViewViewContainer* _tmp0_;
			FilesViewViewContainer* _tmp1_;
			_tmp0_ = files_view_window_get_current_container (self);
			_tmp1_ = _tmp0_;
			result = _tmp1_->view_mode;
			return result;
		}
		default:
		{
			break;
		}
	}
	_tmp2_ = files_app_settings;
	result = (FilesViewMode) g_settings_get_enum (_tmp2_, "default-viewmode");
	return result;
}

void
files_view_window_quit (FilesViewWindow* self)
{
	HdyHeaderBar* _tmp0_;
	HdyTabView* _tmp1_;
	guint _tmp2_;
	GQuark _tmp3_;
	g_return_if_fail (self != NULL);
	files_view_window_save_geometries (self);
	files_view_window_save_tabs (self);
	_tmp0_ = self->headerbar;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
	_tmp1_ = self->tab_view;
	g_signal_parse_name ("notify::selected-page", G_TYPE_OBJECT, &_tmp2_, &_tmp3_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, _tmp3_, NULL, (GCallback) _files_view_window_change_tab_g_object_notify, self);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				HdyTabView* _tmp6_;
				gint _tmp7_;
				gint _tmp8_;
				HdyTabPage* tab_page = NULL;
				HdyTabView* _tmp9_;
				HdyTabPage* _tmp10_;
				HdyTabPage* _tmp11_;
				HdyTabPage* _tmp12_;
				GtkWidget* _tmp13_;
				GtkWidget* _tmp14_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = self->tab_view;
				_tmp7_ = hdy_tab_view_get_n_pages (_tmp6_);
				_tmp8_ = _tmp7_;
				if (!(i < _tmp8_)) {
					break;
				}
				_tmp9_ = self->tab_view;
				_tmp10_ = hdy_tab_view_get_nth_page (_tmp9_, i);
				_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, hdy_tab_page_get_type (), HdyTabPage));
				tab_page = _tmp11_;
				_tmp12_ = tab_page;
				_tmp13_ = hdy_tab_page_get_child (_tmp12_);
				_tmp14_ = _tmp13_;
				files_view_view_container_close (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, FILES_VIEW_TYPE_VIEW_CONTAINER, FilesViewViewContainer));
				_g_object_unref0 (tab_page);
			}
		}
	}
	gtk_widget_destroy ((GtkWidget*) self);
}

static void
files_view_window_save_geometries (FilesViewWindow* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gint sidebar_width = 0;
	GtkPaned* _tmp2_;
	gint min_width = 0;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	GdkWindowState state = 0U;
	GdkWindow* _tmp5_;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_;
	gboolean _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = files_view_window_get_is_first_window (self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = self->priv->lside_pane;
	sidebar_width = gtk_paned_get_position (_tmp2_);
	_tmp3_ = files_app_settings;
	min_width = g_settings_get_int (_tmp3_, "minimum-sidebar-width");
	sidebar_width = MAX (sidebar_width, min_width);
	_tmp4_ = files_app_settings;
	g_settings_set_int (_tmp4_, "sidebar-width", sidebar_width);
	_tmp5_ = gtk_widget_get_window ((GtkWidget*) self);
	state = gdk_window_get_state (_tmp5_);
	g_object_get ((GtkWindow*) self, "is-maximized", &_tmp7_, NULL);
	_tmp8_ = _tmp7_;
	if (_tmp8_) {
		_tmp6_ = TRUE;
	} else {
		_tmp6_ = (state & GDK_WINDOW_STATE_FULLSCREEN) == GDK_WINDOW_STATE_FULLSCREEN;
	}
	if (_tmp6_) {
		GSettings* _tmp9_;
		_tmp9_ = files_app_settings;
		g_settings_set_enum (_tmp9_, "window-state", (gint) FILES_WINDOW_STATE_MAXIMIZED);
	} else {
		GSettings* _tmp10_;
		_tmp10_ = files_app_settings;
		g_settings_set_enum (_tmp10_, "window-state", (gint) FILES_WINDOW_STATE_NORMAL);
		if (!((state & GDK_WINDOW_STATE_TILED) == GDK_WINDOW_STATE_TILED)) {
			gint width = 0;
			gint height = 0;
			gint _tmp11_ = 0;
			gint _tmp12_ = 0;
			GSettings* _tmp13_;
			gtk_window_get_size ((GtkWindow*) self, &_tmp11_, &_tmp12_);
			width = _tmp11_;
			height = _tmp12_;
			_tmp13_ = files_app_settings;
			g_settings_set (_tmp13_, "window-size", "(ii)", width, height);
		}
	}
}

static void
files_view_window_save_tabs (FilesViewWindow* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	FilesPreferences* _tmp2_;
	FilesPreferences* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	GVariantBuilder* vb = NULL;
	GVariantType* _tmp8_;
	GVariantType* _tmp9_;
	GVariantBuilder* _tmp10_;
	GVariantBuilder* _tmp11_;
	GSettings* _tmp37_;
	GVariantBuilder* _tmp38_;
	GVariant* _tmp39_;
	GVariant* _tmp40_;
	g_return_if_fail (self != NULL);
	_tmp2_ = files_preferences_get_default ();
	_tmp3_ = _tmp2_;
	_tmp4_ = files_preferences_get_remember_history (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = !_tmp5_;
	_g_object_unref0 (_tmp3_);
	if (_tmp6_) {
		_tmp1_ = TRUE;
	} else {
		GSettings* _tmp7_;
		_tmp7_ = files_app_settings;
		_tmp1_ = !g_settings_get_boolean (_tmp7_, "restore-tabs");
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = files_is_admin ();
	}
	if (_tmp0_) {
		return;
	}
	_tmp8_ = g_variant_type_new ("a(uss)");
	_tmp9_ = _tmp8_;
	_tmp10_ = g_variant_builder_new (_tmp9_);
	_tmp11_ = _tmp10_;
	_g_variant_type_free0 (_tmp9_);
	vb = _tmp11_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp12_ = FALSE;
			_tmp12_ = TRUE;
			while (TRUE) {
				HdyTabView* _tmp14_;
				gint _tmp15_;
				gint _tmp16_;
				HdyTabPage* tab = NULL;
				HdyTabView* _tmp17_;
				HdyTabPage* _tmp18_;
				HdyTabPage* _tmp19_;
				FilesViewViewContainer* view_container = NULL;
				HdyTabPage* _tmp20_;
				GtkWidget* _tmp21_;
				GtkWidget* _tmp22_;
				FilesViewViewContainer* _tmp23_;
				FilesViewViewContainer* _tmp24_;
				gboolean _tmp25_;
				gboolean _tmp26_;
				gchar* _tmp27_ = NULL;
				FilesViewViewContainer* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp31_ = NULL;
				FilesViewViewContainer* _tmp32_;
				gchar* _tmp33_;
				GVariantBuilder* _tmp35_;
				FilesViewViewContainer* _tmp36_;
				if (!_tmp12_) {
					gint _tmp13_;
					_tmp13_ = i;
					i = _tmp13_ + 1;
				}
				_tmp12_ = FALSE;
				_tmp14_ = self->tab_view;
				_tmp15_ = hdy_tab_view_get_n_pages (_tmp14_);
				_tmp16_ = _tmp15_;
				if (!(i < _tmp16_)) {
					break;
				}
				_tmp17_ = self->tab_view;
				_tmp18_ = hdy_tab_view_get_nth_page (_tmp17_, i);
				_tmp19_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, hdy_tab_page_get_type (), HdyTabPage));
				tab = _tmp19_;
				_tmp20_ = tab;
				_tmp21_ = hdy_tab_page_get_child (_tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, FILES_VIEW_TYPE_VIEW_CONTAINER, FilesViewViewContainer));
				view_container = _tmp23_;
				_tmp24_ = view_container;
				_tmp25_ = files_view_view_container_get_can_show_folder (_tmp24_);
				_tmp26_ = _tmp25_;
				if (!_tmp26_) {
					_g_object_unref0 (view_container);
					_g_object_unref0 (tab);
					continue;
				}
				_tmp28_ = view_container;
				_tmp29_ = files_view_view_container_get_root_uri (_tmp28_);
				_tmp27_ = _tmp29_;
				if (_tmp27_ == NULL) {
					gchar* _tmp30_;
					_tmp30_ = pf_user_utils_get_real_user_home ();
					_g_free0 (_tmp27_);
					_tmp27_ = _tmp30_;
				}
				_tmp32_ = view_container;
				_tmp33_ = files_view_view_container_get_tip_uri (_tmp32_);
				_tmp31_ = _tmp33_;
				if (_tmp31_ == NULL) {
					gchar* _tmp34_;
					_tmp34_ = g_strdup ("");
					_g_free0 (_tmp31_);
					_tmp31_ = _tmp34_;
				}
				_tmp35_ = vb;
				_tmp36_ = view_container;
				g_variant_builder_add (_tmp35_, "(uss)", _tmp36_->view_mode, _tmp27_, _tmp31_, NULL);
				_g_free0 (_tmp31_);
				_g_free0 (_tmp27_);
				_g_object_unref0 (view_container);
				_g_object_unref0 (tab);
			}
		}
	}
	_tmp37_ = files_app_settings;
	_tmp38_ = vb;
	_tmp39_ = g_variant_builder_end (_tmp38_);
	g_variant_ref_sink (_tmp39_);
	_tmp40_ = _tmp39_;
	g_settings_set_value (_tmp37_, "tab-info-list", _tmp40_);
	_g_variant_unref0 (_tmp40_);
	files_view_window_save_active_tab_position (self);
	_g_variant_builder_unref0 (vb);
}

static void
files_view_window_save_active_tab_position (FilesViewWindow* self)
{
	HdyTabView* _tmp0_;
	HdyTabPage* _tmp1_;
	HdyTabPage* _tmp2_;
	GSettings* _tmp3_;
	HdyTabView* _tmp4_;
	HdyTabView* _tmp5_;
	HdyTabPage* _tmp6_;
	HdyTabPage* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->tab_view;
	_tmp1_ = hdy_tab_view_get_selected_page (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		return;
	}
	_tmp3_ = files_app_settings;
	_tmp4_ = self->tab_view;
	_tmp5_ = self->tab_view;
	_tmp6_ = hdy_tab_view_get_selected_page (_tmp5_);
	_tmp7_ = _tmp6_;
	g_settings_set_int (_tmp3_, "active-tab-position", hdy_tab_view_get_page_position (_tmp4_, _tmp7_));
}

static void
files_view_window_restore_tabs_data_free (gpointer _data)
{
	FilesViewWindowRestoreTabsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FilesViewWindowRestoreTabsData, _data_);
}

static void
files_view_window_restore_tabs (FilesViewWindow* self,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	FilesViewWindowRestoreTabsData* _data_;
	FilesViewWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (FilesViewWindowRestoreTabsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, files_view_window_restore_tabs_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	files_view_window_restore_tabs_co (_data_);
}

static guint
files_view_window_restore_tabs_finish (FilesViewWindow* self,
                                       GAsyncResult* _res_)
{
	guint result;
	FilesViewWindowRestoreTabsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static void
files_view_window_restore_tabs_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_)
{
	FilesViewWindowRestoreTabsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	files_view_window_restore_tabs_co (_data_);
}

static gboolean
files_view_window_restore_tabs_co (FilesViewWindowRestoreTabsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->self->priv->tabs_restored) {
		_data_->_tmp3_ = TRUE;
	} else {
		_data_->_tmp4_ = files_view_window_get_is_first_window (_data_->self);
		_data_->_tmp5_ = _data_->_tmp4_;
		_data_->_tmp3_ = !_data_->_tmp5_;
	}
	if (_data_->_tmp3_) {
		_data_->_tmp2_ = TRUE;
	} else {
		_data_->_tmp6_ = files_preferences_get_default ();
		_data_->_tmp7_ = _data_->_tmp6_;
		_data_->_tmp8_ = files_preferences_get_remember_history (_data_->_tmp7_);
		_data_->_tmp9_ = _data_->_tmp8_;
		_data_->_tmp2_ = !_data_->_tmp9_;
		_g_object_unref0 (_data_->_tmp7_);
	}
	if (_data_->_tmp2_) {
		_data_->_tmp1_ = TRUE;
	} else {
		_data_->_tmp10_ = files_app_settings;
		_data_->_tmp1_ = !g_settings_get_boolean (_data_->_tmp10_, "restore-tabs");
	}
	if (_data_->_tmp1_) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp0_ = files_is_admin ();
	}
	if (_data_->_tmp0_) {
		_data_->result = (guint) 0;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_data_->self->priv->tabs_restored = TRUE;
	}
	_data_->_tmp11_ = files_app_settings;
	_data_->_tmp12_ = g_settings_get_value (_data_->_tmp11_, "tab-info-list");
	_data_->tab_info_array = _data_->_tmp12_;
	_data_->_tmp13_ = _data_->tab_info_array;
	_data_->_tmp14_ = g_variant_iter_new (_data_->_tmp13_);
	_data_->iter = _data_->_tmp14_;
	_data_->mode = FILES_VIEW_MODE_INVALID;
	_data_->root_uri = NULL;
	_data_->tip_uri = NULL;
	_data_->self->priv->restoring_tabs = 0;
	while (TRUE) {
		_data_->_tmp15_ = _data_->iter;
		_data_->_tmp16_ = 0;
		_data_->_tmp17_ = NULL;
		_data_->_tmp18_ = NULL;
		_data_->_tmp19_ = g_variant_iter_next (_data_->_tmp15_, "(uss)", &_data_->_tmp16_, &_data_->_tmp17_, &_data_->_tmp18_, NULL);
		_data_->mode = _data_->_tmp16_;
		_g_free0 (_data_->root_uri);
		_data_->root_uri = _data_->_tmp17_;
		_g_free0 (_data_->tip_uri);
		_data_->tip_uri = _data_->_tmp18_;
		if (!_data_->_tmp19_) {
			break;
		}
		if (_data_->mode < 0) {
			_data_->_tmp23_ = TRUE;
		} else {
			_data_->_tmp23_ = _data_->mode >= FILES_VIEW_MODE_INVALID;
		}
		if (_data_->_tmp23_) {
			_data_->_tmp22_ = TRUE;
		} else {
			_data_->_tmp24_ = _data_->root_uri;
			_data_->_tmp22_ = _data_->_tmp24_ == NULL;
		}
		if (_data_->_tmp22_) {
			_data_->_tmp21_ = TRUE;
		} else {
			_data_->_tmp25_ = _data_->root_uri;
			_data_->_tmp21_ = g_strcmp0 (_data_->_tmp25_, "") == 0;
		}
		if (_data_->_tmp21_) {
			_data_->_tmp20_ = TRUE;
		} else {
			_data_->_tmp26_ = _data_->tip_uri;
			_data_->_tmp20_ = _data_->_tmp26_ == NULL;
		}
		if (_data_->_tmp20_) {
			continue;
		}
		_data_->_tmp27_ = _data_->root_uri;
		_data_->_state_ = 1;
		files_view_window_add_tab_by_uri (_data_->self, _data_->_tmp27_, _data_->mode, files_view_window_restore_tabs_ready, _data_);
		return FALSE;
		_state_1:
		if (files_view_window_add_tab_by_uri_finish (_data_->self, _data_->_res_)) {
			_data_->_tmp28_ = _data_->self->priv->restoring_tabs;
			_data_->self->priv->restoring_tabs = _data_->_tmp28_ + 1;
			_data_->_tmp29_ = _data_->self->tab_view;
			_data_->_tmp30_ = hdy_tab_view_get_selected_page (_data_->_tmp29_);
			_data_->_tmp31_ = _data_->_tmp30_;
			_data_->_tmp32_ = _g_object_ref0 (_data_->_tmp31_);
			_data_->tab = _data_->_tmp32_;
			_data_->_tmp35_ = _data_->tab;
			if (_data_->_tmp35_ != NULL) {
				_data_->_tmp36_ = _data_->tab;
				_data_->_tmp37_ = hdy_tab_page_get_child (_data_->_tmp36_);
				_data_->_tmp38_ = _data_->_tmp37_;
				_data_->_tmp34_ = _data_->_tmp38_ != NULL;
			} else {
				_data_->_tmp34_ = FALSE;
			}
			if (_data_->_tmp34_) {
				_data_->_tmp39_ = _data_->tip_uri;
				_data_->_tmp40_ = _data_->root_uri;
				_data_->_tmp33_ = g_strcmp0 (_data_->_tmp39_, _data_->_tmp40_) != 0;
			} else {
				_data_->_tmp33_ = FALSE;
			}
			if (_data_->_tmp33_) {
				_data_->_tmp41_ = _data_->tab;
				_data_->_tmp42_ = hdy_tab_page_get_child (_data_->_tmp41_);
				_data_->_tmp43_ = _data_->_tmp42_;
				_data_->_tmp44_ = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp43_, FILES_VIEW_TYPE_VIEW_CONTAINER, FilesViewViewContainer)->view;
				_data_->_tmp45_ = _g_object_ref0 (_data_->_tmp44_);
				_data_->view = _data_->_tmp45_;
				_data_->_tmp47_ = _data_->view;
				if (_data_->_tmp47_ != NULL) {
					_data_->_tmp48_ = _data_->view;
					_data_->_tmp46_ = FILES_VIEW_IS_MILLER (_data_->_tmp48_);
				} else {
					_data_->_tmp46_ = FALSE;
				}
				if (_data_->_tmp46_) {
					_data_->_tmp49_ = _data_->view;
					_data_->_tmp50_ = _data_->tip_uri;
					_data_->_tmp51_ = _data_->root_uri;
					files_view_window_expand_miller_view (_data_->self, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp49_, FILES_VIEW_TYPE_MILLER, FilesViewMiller), _data_->_tmp50_, _data_->_tmp51_);
				}
				_g_object_unref0 (_data_->view);
			}
			_g_object_unref0 (_data_->tab);
		} else {
			_data_->_tmp52_ = _data_->root_uri;
			g_debug ("Window.vala:1296: Failed to restore tab %s", _data_->_tmp52_);
		}
		_data_->mode = FILES_VIEW_MODE_INVALID;
		_g_free0 (_data_->root_uri);
		_data_->root_uri = NULL;
		_g_free0 (_data_->tip_uri);
		_data_->tip_uri = NULL;
	}
	if (_data_->self->priv->restoring_tabs < 1) {
		_data_->result = (guint) 0;
		_g_free0 (_data_->tip_uri);
		_g_free0 (_data_->root_uri);
		_g_variant_iter_free0 (_data_->iter);
		_g_variant_unref0 (_data_->tab_info_array);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp53_ = files_app_settings;
	_data_->active_tab_position = g_settings_get_int (_data_->_tmp53_, "active-tab-position");
	if (_data_->active_tab_position < 0) {
		_data_->_tmp54_ = TRUE;
	} else {
		_data_->_tmp54_ = _data_->active_tab_position >= _data_->self->priv->restoring_tabs;
	}
	if (_data_->_tmp54_) {
		_data_->active_tab_position = 0;
	}
	_data_->_tmp55_ = g_strdup ("");
	_data_->path = _data_->_tmp55_;
	_data_->_tmp56_ = files_view_window_get_current_container (_data_->self);
	_data_->_tmp57_ = _data_->_tmp56_;
	if (_data_->_tmp57_ != NULL) {
		_data_->_tmp58_ = files_view_window_get_current_container (_data_->self);
		_data_->_tmp59_ = _data_->_tmp58_;
		_data_->_tmp60_ = files_view_view_container_get_tip_uri (_data_->_tmp59_);
		_g_free0 (_data_->path);
		_data_->path = _data_->_tmp60_;
		_data_->_tmp62_ = _data_->path;
		if (_data_->_tmp62_ == NULL) {
			_data_->_tmp61_ = TRUE;
		} else {
			_data_->_tmp63_ = _data_->path;
			_data_->_tmp61_ = g_strcmp0 (_data_->_tmp63_, "") == 0;
		}
		if (_data_->_tmp61_) {
			_data_->_tmp64_ = files_view_window_get_current_container (_data_->self);
			_data_->_tmp65_ = _data_->_tmp64_;
			_data_->_tmp66_ = files_view_view_container_get_root_uri (_data_->_tmp65_);
			_g_free0 (_data_->path);
			_data_->path = _data_->_tmp66_;
		}
	}
	_data_->_tmp67_ = _data_->path;
	files_view_window_update_location_bar (_data_->self, _data_->_tmp67_, FALSE);
	_data_->result = (guint) _data_->self->priv->restoring_tabs;
	_g_free0 (_data_->path);
	_g_free0 (_data_->tip_uri);
	_g_free0 (_data_->root_uri);
	_g_variant_iter_free0 (_data_->iter);
	_g_variant_unref0 (_data_->tab_info_array);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
files_view_window_expand_miller_view (FilesViewWindow* self,
                                      FilesViewMiller* miller_view,
                                      const gchar* tip_uri,
                                      const gchar* unescaped_root_uri)
{
	gchar* unescaped_tip_uri = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	GFile* tip_location = NULL;
	const gchar* _tmp2_;
	GFile* _tmp3_;
	GFile* root_location = NULL;
	GFile* _tmp4_;
	GFile* _tmp5_;
	gchar* relative_path = NULL;
	GFile* _tmp15_;
	GFile* _tmp16_;
	gchar* _tmp17_;
	GFile* gfile = NULL;
	const gchar* _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (miller_view != NULL);
	g_return_if_fail (tip_uri != NULL);
	g_return_if_fail (unescaped_root_uri != NULL);
	_tmp0_ = files_file_utils_sanitize_path (tip_uri, NULL, TRUE);
	unescaped_tip_uri = _tmp0_;
	_tmp1_ = unescaped_tip_uri;
	if (_tmp1_ == NULL) {
		g_warning ("Window.vala:1338: Invalid tip uri for Miller View");
		_g_free0 (unescaped_tip_uri);
		return;
	}
	_tmp2_ = unescaped_tip_uri;
	_tmp3_ = files_file_utils_get_file_for_path (_tmp2_);
	tip_location = _tmp3_;
	_tmp4_ = files_file_utils_get_file_for_path (unescaped_root_uri);
	root_location = _tmp4_;
	_tmp5_ = root_location;
	if (!g_file_query_exists (_tmp5_, NULL)) {
		g_warning ("Window.vala:1347: Invalid root uri for Miller View");
		_g_object_unref0 (root_location);
		_g_object_unref0 (tip_location);
		_g_free0 (unescaped_tip_uri);
		return;
	}
	while (TRUE) {
		gboolean _tmp6_ = FALSE;
		GFile* _tmp7_;
		GFile* _tmp8_;
		GFile* _tmp10_;
		GFile* _tmp11_;
		GFile* _tmp12_;
		_tmp7_ = tip_location;
		_tmp8_ = root_location;
		if (!g_file_equal (_tmp7_, _tmp8_)) {
			GFile* _tmp9_;
			_tmp9_ = tip_location;
			_tmp6_ = !g_file_query_exists (_tmp9_, NULL);
		} else {
			_tmp6_ = FALSE;
		}
		if (!_tmp6_) {
			break;
		}
		_tmp10_ = tip_location;
		_tmp11_ = g_file_get_parent (_tmp10_);
		_g_object_unref0 (tip_location);
		tip_location = _tmp11_;
		g_warning ("Window.vala:1354: Invalid tip uri for Miller View - trying parent");
		_tmp12_ = tip_location;
		if (_tmp12_ == NULL) {
			GFile* _tmp13_;
			GFile* _tmp14_;
			_tmp13_ = root_location;
			_tmp14_ = g_file_dup (_tmp13_);
			_g_object_unref0 (tip_location);
			tip_location = _tmp14_;
		}
	}
	_tmp15_ = root_location;
	_tmp16_ = tip_location;
	_tmp17_ = g_file_get_relative_path (_tmp15_, _tmp16_);
	relative_path = _tmp17_;
	_tmp18_ = relative_path;
	if (_tmp18_ != NULL) {
		gchar** dirs = NULL;
		const gchar* _tmp19_;
		gchar** _tmp20_;
		gchar** _tmp21_;
		gint dirs_length1;
		gint _dirs_size_;
		gchar* uri = NULL;
		GFile* _tmp22_;
		gchar* _tmp23_;
		gchar** _tmp24_;
		gint _tmp24__length1;
		_tmp19_ = relative_path;
		_tmp21_ = _tmp20_ = g_strsplit (_tmp19_, G_DIR_SEPARATOR_S, 0);
		dirs = _tmp21_;
		dirs_length1 = _vala_array_length (_tmp20_);
		_dirs_size_ = dirs_length1;
		_tmp22_ = root_location;
		_tmp23_ = g_file_get_uri (_tmp22_);
		uri = _tmp23_;
		_tmp24_ = dirs;
		_tmp24__length1 = dirs_length1;
		{
			gchar** dir_collection = NULL;
			gint dir_collection_length1 = 0;
			gint _dir_collection_size_ = 0;
			gint dir_it = 0;
			dir_collection = _tmp24_;
			dir_collection_length1 = _tmp24__length1;
			for (dir_it = 0; dir_it < dir_collection_length1; dir_it = dir_it + 1) {
				gchar* _tmp25_;
				gchar* dir = NULL;
				_tmp25_ = g_strdup (dir_collection[dir_it]);
				dir = _tmp25_;
				{
					const gchar* _tmp26_;
					const gchar* _tmp27_;
					gchar* _tmp28_;
					gchar* _tmp29_;
					gchar* _tmp30_;
					const gchar* _tmp31_;
					GFile* _tmp32_;
					GFile* _tmp33_;
					FilesViewSlot* _tmp34_;
					_tmp26_ = uri;
					_tmp27_ = dir;
					_tmp28_ = g_strconcat (G_DIR_SEPARATOR_S, _tmp27_, NULL);
					_tmp29_ = _tmp28_;
					_tmp30_ = g_strconcat (_tmp26_, _tmp29_, NULL);
					_g_free0 (uri);
					uri = _tmp30_;
					_g_free0 (_tmp29_);
					_tmp31_ = uri;
					_tmp32_ = files_view_window_get_file_from_uri (self, _tmp31_);
					_g_object_unref0 (gfile);
					gfile = _tmp32_;
					_tmp33_ = gfile;
					_tmp34_ = miller_view->current_slot;
					files_view_miller_add_location (miller_view, _tmp33_, _tmp34_);
					_g_free0 (dir);
				}
			}
		}
		_g_free0 (uri);
		dirs = (_vala_array_free (dirs, dirs_length1, (GDestroyNotify) g_free), NULL);
	} else {
		const gchar* _tmp35_;
		_tmp35_ = unescaped_tip_uri;
		g_warning ("Window.vala:1374: Invalid tip uri for Miller View %s", _tmp35_);
	}
	_g_object_unref0 (gfile);
	_g_free0 (relative_path);
	_g_object_unref0 (root_location);
	_g_object_unref0 (tip_location);
	_g_free0 (unescaped_tip_uri);
}

static void
files_view_window_update_headerbar (FilesViewWindow* self)
{
	gboolean _tmp0_ = FALSE;
	FilesViewViewContainer* _tmp3_;
	FilesViewViewContainer* _tmp4_;
	GeeList* _tmp5_;
	GeeList* _tmp6_;
	FilesViewViewContainer* _tmp7_;
	FilesViewViewContainer* _tmp8_;
	GeeList* _tmp9_;
	GeeList* _tmp10_;
	FilesViewChromeButtonWithMenu* _tmp11_;
	FilesViewViewContainer* _tmp12_;
	FilesViewViewContainer* _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	gboolean _tmp16_ = FALSE;
	FilesViewViewContainer* _tmp17_;
	FilesViewViewContainer* _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp20_;
	FilesViewChromeButtonWithMenu* _tmp25_;
	FilesViewChromeLocationBar* _tmp26_;
	FilesViewViewContainer* _tmp27_;
	FilesViewViewContainer* _tmp28_;
	gboolean _tmp29_;
	gboolean _tmp30_;
	FilesViewMode mode = 0;
	FilesViewViewContainer* _tmp31_;
	FilesViewViewContainer* _tmp32_;
	FilesViewChromeViewSwitcher* _tmp33_;
	FilesViewChromeViewSwitcher* _tmp34_;
	FilesViewViewContainer* _tmp35_;
	FilesViewViewContainer* _tmp36_;
	gboolean _tmp37_;
	gboolean _tmp38_;
	GSimpleAction* _tmp39_;
	GSimpleAction* _tmp40_;
	GVariant* _tmp41_;
	GVariant* _tmp42_;
	GSettings* _tmp43_;
	g_return_if_fail (self != NULL);
	if (self->priv->restoring_tabs > 0) {
		_tmp0_ = TRUE;
	} else {
		FilesViewViewContainer* _tmp1_;
		FilesViewViewContainer* _tmp2_;
		_tmp1_ = files_view_window_get_current_container (self);
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == NULL;
	}
	if (_tmp0_) {
		return;
	}
	_tmp3_ = files_view_window_get_current_container (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = files_view_view_container_get_go_back_path_list (_tmp4_);
	_tmp6_ = _tmp5_;
	files_view_window_set_back_menu (self, _tmp6_);
	_g_object_unref0 (_tmp6_);
	_tmp7_ = files_view_window_get_current_container (self);
	_tmp8_ = _tmp7_;
	_tmp9_ = files_view_view_container_get_go_forward_path_list (_tmp8_);
	_tmp10_ = _tmp9_;
	files_view_window_set_forward_menu (self, _tmp10_);
	_g_object_unref0 (_tmp10_);
	_tmp11_ = self->priv->button_back;
	_tmp12_ = files_view_window_get_current_container (self);
	_tmp13_ = _tmp12_;
	_tmp14_ = files_view_view_container_get_can_go_back (_tmp13_);
	_tmp15_ = _tmp14_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp11_, _tmp15_);
	_tmp17_ = files_view_window_get_current_container (self);
	_tmp18_ = _tmp17_;
	_tmp19_ = files_view_view_container_get_can_show_folder (_tmp18_);
	_tmp20_ = _tmp19_;
	if (_tmp20_) {
		FilesViewViewContainer* _tmp21_;
		FilesViewViewContainer* _tmp22_;
		gboolean _tmp23_;
		gboolean _tmp24_;
		_tmp21_ = files_view_window_get_current_container (self);
		_tmp22_ = _tmp21_;
		_tmp23_ = files_view_view_container_get_can_go_forward (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp16_ = _tmp24_;
	} else {
		_tmp16_ = FALSE;
	}
	_tmp25_ = self->priv->button_forward;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp25_, _tmp16_);
	_tmp26_ = self->priv->location_bar;
	_tmp27_ = files_view_window_get_current_container (self);
	_tmp28_ = _tmp27_;
	_tmp29_ = files_view_view_container_get_is_loading (_tmp28_);
	_tmp30_ = _tmp29_;
	files_view_chrome_location_bar_set_sensitive (_tmp26_, !_tmp30_);
	_tmp31_ = files_view_window_get_current_container (self);
	_tmp32_ = _tmp31_;
	mode = _tmp32_->view_mode;
	_tmp33_ = self->view_switcher;
	files_view_chrome_view_switcher_set_mode (_tmp33_, (guint32) mode);
	_tmp34_ = self->view_switcher;
	_tmp35_ = files_view_window_get_current_container (self);
	_tmp36_ = _tmp35_;
	_tmp37_ = files_view_view_container_get_can_show_folder (_tmp36_);
	_tmp38_ = _tmp37_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp34_, _tmp38_);
	_tmp39_ = files_view_window_get_action (self, "view-mode");
	_tmp40_ = _tmp39_;
	_tmp41_ = g_variant_new_uint32 ((guint32) mode);
	g_variant_ref_sink (_tmp41_);
	_tmp42_ = _tmp41_;
	g_signal_emit_by_name (_tmp40_, "change-state", _tmp42_);
	_g_variant_unref0 (_tmp42_);
	_g_object_unref0 (_tmp40_);
	_tmp43_ = files_app_settings;
	g_settings_set_enum (_tmp43_, "default-viewmode", (gint) mode);
}

static void
files_view_window_set_back_menu (FilesViewWindow* self,
                                 GeeList* path_list)
{
	GMenu* back_menu = NULL;
	GMenu* _tmp0_;
	FilesViewChromeButtonWithMenu* _tmp17_;
	GMenu* _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path_list != NULL);
	_tmp0_ = g_menu_new ();
	back_menu = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_;
				gint _tmp4_;
				gchar* path = NULL;
				gpointer _tmp5_;
				GMenuItem* item = NULL;
				const gchar* _tmp6_;
				gchar* _tmp7_;
				gchar* _tmp8_;
				GVariant* _tmp9_;
				GVariant* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				GMenuItem* _tmp13_;
				GMenuItem* _tmp14_;
				GMenu* _tmp15_;
				GMenuItem* _tmp16_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = gee_collection_get_size ((GeeCollection*) path_list);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = gee_list_get (path_list, i);
				path = (gchar*) _tmp5_;
				_tmp6_ = path;
				_tmp7_ = files_file_utils_sanitize_path (_tmp6_, NULL, FALSE);
				_tmp8_ = _tmp7_;
				_tmp9_ = g_variant_new_int32 ((gint32) (i + 1));
				g_variant_ref_sink (_tmp9_);
				_tmp10_ = _tmp9_;
				_tmp11_ = g_action_print_detailed_name ("win.back", _tmp10_);
				_tmp12_ = _tmp11_;
				_tmp13_ = g_menu_item_new (_tmp8_, _tmp12_);
				_tmp14_ = _tmp13_;
				_g_free0 (_tmp12_);
				_g_variant_unref0 (_tmp10_);
				_g_free0 (_tmp8_);
				item = _tmp14_;
				_tmp15_ = back_menu;
				_tmp16_ = item;
				g_menu_append_item (_tmp15_, _tmp16_);
				_g_object_unref0 (item);
				_g_free0 (path);
			}
		}
	}
	_tmp17_ = self->priv->button_back;
	_tmp18_ = back_menu;
	files_view_chrome_button_with_menu_set_menu (_tmp17_, _tmp18_);
	_g_object_unref0 (back_menu);
}

static void
files_view_window_set_forward_menu (FilesViewWindow* self,
                                    GeeList* path_list)
{
	GMenu* forward_menu = NULL;
	GMenu* _tmp0_;
	FilesViewChromeButtonWithMenu* _tmp17_;
	GMenu* _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path_list != NULL);
	_tmp0_ = g_menu_new ();
	forward_menu = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_;
				gint _tmp4_;
				gchar* path = NULL;
				gpointer _tmp5_;
				GMenuItem* item = NULL;
				const gchar* _tmp6_;
				gchar* _tmp7_;
				gchar* _tmp8_;
				GVariant* _tmp9_;
				GVariant* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				GMenuItem* _tmp13_;
				GMenuItem* _tmp14_;
				GMenu* _tmp15_;
				GMenuItem* _tmp16_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = gee_collection_get_size ((GeeCollection*) path_list);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = gee_list_get (path_list, i);
				path = (gchar*) _tmp5_;
				_tmp6_ = path;
				_tmp7_ = files_file_utils_sanitize_path (_tmp6_, NULL, FALSE);
				_tmp8_ = _tmp7_;
				_tmp9_ = g_variant_new_int32 ((gint32) (i + 1));
				g_variant_ref_sink (_tmp9_);
				_tmp10_ = _tmp9_;
				_tmp11_ = g_action_print_detailed_name ("win.forward", _tmp10_);
				_tmp12_ = _tmp11_;
				_tmp13_ = g_menu_item_new (_tmp8_, _tmp12_);
				_tmp14_ = _tmp13_;
				_g_free0 (_tmp12_);
				_g_variant_unref0 (_tmp10_);
				_g_free0 (_tmp8_);
				item = _tmp14_;
				_tmp15_ = forward_menu;
				_tmp16_ = item;
				g_menu_append_item (_tmp15_, _tmp16_);
				_g_object_unref0 (item);
				_g_free0 (path);
			}
		}
	}
	_tmp17_ = self->priv->button_forward;
	_tmp18_ = forward_menu;
	files_view_chrome_button_with_menu_set_menu (_tmp17_, _tmp18_);
	_g_object_unref0 (forward_menu);
}

static void
files_view_window_update_location_bar (FilesViewWindow* self,
                                       const gchar* new_path,
                                       gboolean with_animation)
{
	FilesViewChromeLocationBar* _tmp0_;
	FilesViewChromeLocationBar* _tmp1_;
	FilesViewChromeLocationBar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (new_path != NULL);
	_tmp0_ = self->priv->location_bar;
	files_view_chrome_basic_location_bar_set_with_animation ((FilesViewChromeBasicLocationBar*) _tmp0_, with_animation);
	_tmp1_ = self->priv->location_bar;
	files_view_chrome_basic_location_bar_set_display_path ((FilesViewChromeBasicLocationBar*) _tmp1_, new_path);
	_tmp2_ = self->priv->location_bar;
	files_view_chrome_basic_location_bar_set_with_animation ((FilesViewChromeBasicLocationBar*) _tmp2_, TRUE);
}

static void
files_view_window_update_labels (FilesViewWindow* self,
                                 const gchar* uri)
{
	FilesViewViewContainer* _tmp0_;
	FilesViewViewContainer* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	_tmp0_ = files_view_window_get_current_container (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		FilesViewViewContainer* _tmp2_;
		FilesViewViewContainer* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		FilesSidebarInterface* _tmp6_;
		_tmp2_ = files_view_window_get_current_container (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = files_view_view_container_get_tab_name (_tmp3_);
		_tmp5_ = _tmp4_;
		files_view_window_set_title (self, _tmp5_);
		files_view_window_update_location_bar (self, uri, TRUE);
		_tmp6_ = self->sidebar;
		files_sidebar_interface_sync_uri (_tmp6_, uri);
	}
}

void
files_view_window_mount_removed (FilesViewWindow* self,
                                 GMount* mount)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GFile* root = NULL;
	GFile* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (mount != NULL);
	_tmp0_ = g_mount_get_name (mount);
	_tmp1_ = _tmp0_;
	g_debug ("Window.vala:1443: Mount %s removed", _tmp1_);
	_g_free0 (_tmp1_);
	_tmp2_ = g_mount_get_root (mount);
	root = _tmp2_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				HdyTabView* _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
				FilesViewViewContainer* view_container = NULL;
				HdyTabView* _tmp8_;
				HdyTabPage* _tmp9_;
				GtkWidget* _tmp10_;
				GtkWidget* _tmp11_;
				FilesViewViewContainer* _tmp12_;
				GFile* location = NULL;
				FilesViewViewContainer* _tmp13_;
				GFile* _tmp14_;
				GFile* _tmp15_;
				GFile* _tmp16_;
				gboolean _tmp17_ = FALSE;
				gboolean _tmp18_ = FALSE;
				GFile* _tmp19_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = self->tab_view;
				_tmp6_ = hdy_tab_view_get_n_pages (_tmp5_);
				_tmp7_ = _tmp6_;
				if (!(i < _tmp7_)) {
					break;
				}
				_tmp8_ = self->tab_view;
				_tmp9_ = hdy_tab_view_get_nth_page (_tmp8_, i);
				_tmp10_ = hdy_tab_page_get_child (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, FILES_VIEW_TYPE_VIEW_CONTAINER, FilesViewViewContainer));
				view_container = _tmp12_;
				_tmp13_ = view_container;
				_tmp14_ = files_view_view_container_get_location (_tmp13_);
				_tmp15_ = _tmp14_;
				_tmp16_ = _g_object_ref0 (_tmp15_);
				location = _tmp16_;
				_tmp19_ = location;
				if (_tmp19_ == NULL) {
					_tmp18_ = TRUE;
				} else {
					GFile* _tmp20_;
					GFile* _tmp21_;
					_tmp20_ = location;
					_tmp21_ = root;
					_tmp18_ = g_file_has_prefix (_tmp20_, _tmp21_);
				}
				if (_tmp18_) {
					_tmp17_ = TRUE;
				} else {
					GFile* _tmp22_;
					GFile* _tmp23_;
					_tmp22_ = location;
					_tmp23_ = root;
					_tmp17_ = g_file_equal (_tmp22_, _tmp23_);
				}
				if (_tmp17_) {
					FilesViewViewContainer* _tmp24_;
					FilesViewViewContainer* _tmp25_;
					FilesViewViewContainer* _tmp26_;
					_tmp24_ = view_container;
					_tmp25_ = files_view_window_get_current_container (self);
					_tmp26_ = _tmp25_;
					if (_tmp24_ == _tmp26_) {
						FilesViewViewContainer* _tmp27_;
						gchar* _tmp28_;
						gchar* _tmp29_;
						GFile* _tmp30_;
						GFile* _tmp31_;
						_tmp27_ = view_container;
						_tmp28_ = pf_user_utils_get_real_user_home ();
						_tmp29_ = _tmp28_;
						_tmp30_ = g_file_new_for_path (_tmp29_);
						_tmp31_ = _tmp30_;
						files_view_view_container_focus_location (_tmp27_, _tmp31_, FALSE, FALSE);
						_g_object_unref0 (_tmp31_);
						_g_free0 (_tmp29_);
					} else {
						FilesViewViewContainer* _tmp32_;
						_tmp32_ = view_container;
						files_view_window_remove_content (self, _tmp32_);
					}
				}
				_g_object_unref0 (location);
				_g_object_unref0 (view_container);
			}
		}
	}
	_g_object_unref0 (root);
}

void
files_view_window_uri_path_change_request (FilesViewWindow* self,
                                           const gchar* p,
                                           FilesOpenFlag flag)
{
	GFile* file = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = files_view_window_get_file_from_uri (self, p);
	file = _tmp0_;
	_tmp1_ = file;
	if (_tmp1_ != NULL) {
		switch (flag) {
			case FILES_OPEN_FLAG_NEW_TAB:
			{
				GFile* _tmp2_;
				FilesViewViewContainer* _tmp3_;
				FilesViewViewContainer* _tmp4_;
				_tmp2_ = file;
				_tmp3_ = files_view_window_get_current_container (self);
				_tmp4_ = _tmp3_;
				files_view_window_add_tab (self, _tmp2_, _tmp4_->view_mode, FALSE, NULL, NULL);
				break;
			}
			case FILES_OPEN_FLAG_NEW_WINDOW:
			{
				GFile* _tmp5_;
				FilesViewViewContainer* _tmp6_;
				FilesViewViewContainer* _tmp7_;
				_tmp5_ = file;
				_tmp6_ = files_view_window_get_current_container (self);
				_tmp7_ = _tmp6_;
				files_view_window_add_window (self, _tmp5_, _tmp7_->view_mode);
				break;
			}
			default:
			{
				FilesViewViewContainer* _tmp8_;
				FilesViewViewContainer* _tmp9_;
				GFile* _tmp10_;
				files_view_window_grab_focus (self);
				_tmp8_ = files_view_window_get_current_container (self);
				_tmp9_ = _tmp8_;
				_tmp10_ = file;
				files_view_view_container_focus_location (_tmp9_, _tmp10_, FALSE, FALSE);
				break;
			}
		}
	} else {
		g_warning ("Window.vala:1477: Cannot browse %s", p);
	}
	_g_object_unref0 (file);
}

/** Use this function to standardise how locations are generated from uris **/
static GFile*
files_view_window_get_file_from_uri (FilesViewWindow* self,
                                     const gchar* uri)
{
	gchar* current_uri = NULL;
	gboolean _tmp0_ = FALSE;
	FilesViewViewContainer* _tmp1_;
	FilesViewViewContainer* _tmp2_;
	gchar* path = NULL;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	current_uri = NULL;
	_tmp1_ = files_view_window_get_current_container (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		FilesViewViewContainer* _tmp3_;
		FilesViewViewContainer* _tmp4_;
		GFile* _tmp5_;
		GFile* _tmp6_;
		_tmp3_ = files_view_window_get_current_container (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = files_view_view_container_get_location (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		FilesViewViewContainer* _tmp7_;
		FilesViewViewContainer* _tmp8_;
		GFile* _tmp9_;
		GFile* _tmp10_;
		gchar* _tmp11_;
		_tmp7_ = files_view_window_get_current_container (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = files_view_view_container_get_location (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_file_get_uri (_tmp10_);
		_g_free0 (current_uri);
		current_uri = _tmp11_;
	}
	_tmp12_ = current_uri;
	_tmp13_ = files_file_utils_sanitize_path (uri, _tmp12_, TRUE);
	path = _tmp13_;
	_tmp14_ = path;
	_tmp15_ = strlen (_tmp14_);
	_tmp16_ = _tmp15_;
	if (_tmp16_ > 0) {
		const gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		GFile* _tmp20_;
		GFile* _tmp21_;
		_tmp17_ = path;
		_tmp18_ = files_file_utils_escape_uri (_tmp17_, TRUE, TRUE);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_file_new_for_uri (_tmp19_);
		_tmp21_ = _tmp20_;
		_g_free0 (_tmp19_);
		result = _tmp21_;
		_g_free0 (path);
		_g_free0 (current_uri);
		return result;
	} else {
		result = NULL;
		_g_free0 (path);
		_g_free0 (current_uri);
		return result;
	}
}

void
files_view_window_grab_focus (FilesViewWindow* self)
{
	FilesViewViewContainer* _tmp0_;
	FilesViewViewContainer* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = files_view_window_get_current_container (self);
	_tmp1_ = _tmp0_;
	files_view_view_container_grab_focus (_tmp1_);
}

guint
files_view_window_get_window_number (FilesViewWindow* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_window_number;
	return result;
}

static void
files_view_window_set_window_number (FilesViewWindow* self,
                                     guint value)
{
	guint old_value;
	g_return_if_fail (self != NULL);
	old_value = files_view_window_get_window_number (self);
	if (old_value != value) {
		self->priv->_window_number = value;
		g_object_notify_by_pspec ((GObject *) self, files_view_window_properties[FILES_VIEW_WINDOW_WINDOW_NUMBER_PROPERTY]);
	}
}

gboolean
files_view_window_get_is_first_window (FilesViewWindow* self)
{
	gboolean result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_window_number;
	result = _tmp0_ == ((guint) 0);
	return result;
}

static FilesViewViewContainer*
files_view_window_get_current_container (FilesViewWindow* self)
{
	FilesViewViewContainer* result;
	HdyTabView* _tmp0_;
	HdyTabPage* _tmp1_;
	HdyTabPage* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->tab_view;
	_tmp1_ = hdy_tab_view_get_selected_page (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		HdyTabView* _tmp3_;
		HdyTabPage* _tmp4_;
		HdyTabPage* _tmp5_;
		GtkWidget* _tmp6_;
		GtkWidget* _tmp7_;
		_tmp3_ = self->tab_view;
		_tmp4_ = hdy_tab_view_get_selected_page (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = hdy_tab_page_get_child (_tmp5_);
		_tmp7_ = _tmp6_;
		result = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, FILES_VIEW_TYPE_VIEW_CONTAINER, FilesViewViewContainer);
		return result;
	}
	result = NULL;
	return result;
}

FilesViewMode
files_view_window_get_default_mode (FilesViewWindow* self)
{
	FilesViewMode result;
	g_return_val_if_fail (self != NULL, 0);
	result = FILES_VIEW_MODE_PREFERRED;
	return result;
}

GFile*
files_view_window_get_default_location (FilesViewWindow* self)
{
	GFile* result;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = pf_user_utils_get_real_user_home ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_new_for_path (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

FilesApplication*
files_view_window_get_marlin_app (FilesViewWindow* self)
{
	FilesApplication* result;
	FilesApplication* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_marlin_app;
	result = _tmp0_;
	return result;
}

static void
files_view_window_set_marlin_app (FilesViewWindow* self,
                                  FilesApplication* value)
{
	FilesApplication* old_value;
	g_return_if_fail (self != NULL);
	old_value = files_view_window_get_marlin_app (self);
	if (old_value != value) {
		FilesApplication* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_marlin_app);
		self->priv->_marlin_app = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, files_view_window_properties[FILES_VIEW_WINDOW_MARLIN_APP_PROPERTY]);
	}
}

static gboolean
files_view_window_get_locked_focus (FilesViewWindow* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_locked_focus;
	return result;
}

static void
files_view_window_set_locked_focus (FilesViewWindow* self,
                                    gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_locked_focus = value;
}

static void
_files_view_window_update_labels_files_view_window_loading_uri (FilesViewWindow* _sender,
                                                                const gchar* location,
                                                                gpointer self)
{
	files_view_window_update_labels ((FilesViewWindow*) self, location);
}

static GObject *
files_view_window_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	FilesViewWindow * self;
	FilesUndoManager* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gint width = 0;
	gint height = 0;
	GSettings* _tmp145_;
	gint _tmp146_ = 0;
	gint _tmp147_ = 0;
	gboolean _tmp148_;
	gboolean _tmp149_;
	parent_class = G_OBJECT_CLASS (files_view_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_VIEW_TYPE_WINDOW, FilesViewWindow);
	g_object_set ((GtkWidget*) self, "height-request", 300, NULL);
	g_object_set ((GtkWidget*) self, "width-request", 500, NULL);
	gtk_window_set_icon_name ((GtkWindow*) self, "system-file-manager");
	gtk_window_set_title ((GtkWindow*) self, _ (FILES_APP_TITLE));
	g_action_map_add_action_entries ((GActionMap*) self, FILES_VIEW_WINDOW_WIN_ENTRIES, (gint) G_N_ELEMENTS (FILES_VIEW_WINDOW_WIN_ENTRIES), self);
	files_view_window_undo_actions_set_insensitive (self);
	_tmp0_ = files_undo_manager_instance ();
	self->priv->undo_manager = _tmp0_;
	_tmp1_ = files_view_window_get_is_first_window (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		FilesApplication* _tmp3_;
		gchar* _tmp4_;
		gchar** _tmp5_;
		gchar** _tmp6_;
		gint _tmp6__length1;
		FilesApplication* _tmp7_;
		gchar* _tmp8_;
		gchar** _tmp9_;
		gchar** _tmp10_;
		gint _tmp10__length1;
		FilesApplication* _tmp11_;
		gchar* _tmp12_;
		gchar** _tmp13_;
		gchar** _tmp14_;
		gint _tmp14__length1;
		FilesApplication* _tmp15_;
		gchar* _tmp16_;
		gchar** _tmp17_;
		gchar** _tmp18_;
		gint _tmp18__length1;
		FilesApplication* _tmp19_;
		gchar* _tmp20_;
		gchar** _tmp21_;
		gchar** _tmp22_;
		gint _tmp22__length1;
		FilesApplication* _tmp23_;
		gchar* _tmp24_;
		gchar** _tmp25_;
		gchar** _tmp26_;
		gint _tmp26__length1;
		FilesApplication* _tmp27_;
		gchar* _tmp28_;
		gchar** _tmp29_;
		gchar** _tmp30_;
		gint _tmp30__length1;
		FilesApplication* _tmp31_;
		gchar* _tmp32_;
		gchar** _tmp33_;
		gchar** _tmp34_;
		gint _tmp34__length1;
		FilesApplication* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		gchar** _tmp38_;
		gchar** _tmp39_;
		gint _tmp39__length1;
		FilesApplication* _tmp40_;
		gchar* _tmp41_;
		gchar* _tmp42_;
		gchar** _tmp43_;
		gchar** _tmp44_;
		gint _tmp44__length1;
		FilesApplication* _tmp45_;
		GVariant* _tmp46_;
		GVariant* _tmp47_;
		gchar* _tmp48_;
		gchar* _tmp49_;
		gchar* _tmp50_;
		gchar** _tmp51_;
		gchar** _tmp52_;
		gint _tmp52__length1;
		FilesApplication* _tmp53_;
		GVariant* _tmp54_;
		GVariant* _tmp55_;
		gchar* _tmp56_;
		gchar* _tmp57_;
		gchar* _tmp58_;
		gchar** _tmp59_;
		gchar** _tmp60_;
		gint _tmp60__length1;
		FilesApplication* _tmp61_;
		GVariant* _tmp62_;
		GVariant* _tmp63_;
		gchar* _tmp64_;
		gchar* _tmp65_;
		gchar* _tmp66_;
		gchar** _tmp67_;
		gchar** _tmp68_;
		gint _tmp68__length1;
		FilesApplication* _tmp69_;
		gchar* _tmp70_;
		gchar* _tmp71_;
		gchar** _tmp72_;
		gchar** _tmp73_;
		gint _tmp73__length1;
		FilesApplication* _tmp74_;
		gchar* _tmp75_;
		gchar** _tmp76_;
		gchar** _tmp77_;
		gint _tmp77__length1;
		FilesApplication* _tmp78_;
		gchar* _tmp79_;
		gchar** _tmp80_;
		gchar** _tmp81_;
		gint _tmp81__length1;
		FilesApplication* _tmp82_;
		gchar* _tmp83_;
		gchar** _tmp84_;
		gchar** _tmp85_;
		gint _tmp85__length1;
		FilesApplication* _tmp86_;
		gchar* _tmp87_;
		gchar* _tmp88_;
		gchar** _tmp89_;
		gchar** _tmp90_;
		gint _tmp90__length1;
		FilesApplication* _tmp91_;
		gchar* _tmp92_;
		gchar** _tmp93_;
		gchar** _tmp94_;
		gint _tmp94__length1;
		FilesApplication* _tmp95_;
		gchar* _tmp96_;
		gchar** _tmp97_;
		gchar** _tmp98_;
		gint _tmp98__length1;
		FilesApplication* _tmp99_;
		gchar* _tmp100_;
		gchar** _tmp101_;
		gchar** _tmp102_;
		gint _tmp102__length1;
		FilesApplication* _tmp103_;
		gchar* _tmp104_;
		gchar** _tmp105_;
		gchar** _tmp106_;
		gint _tmp106__length1;
		FilesApplication* _tmp107_;
		gchar* _tmp108_;
		gchar** _tmp109_;
		gchar** _tmp110_;
		gint _tmp110__length1;
		FilesApplication* _tmp111_;
		gchar* _tmp112_;
		gchar** _tmp113_;
		gchar** _tmp114_;
		gint _tmp114__length1;
		FilesApplication* _tmp115_;
		gchar* _tmp116_;
		gchar** _tmp117_;
		gchar** _tmp118_;
		gint _tmp118__length1;
		FilesApplication* _tmp119_;
		gchar* _tmp120_;
		gchar* _tmp121_;
		gchar** _tmp122_;
		gchar** _tmp123_;
		gint _tmp123__length1;
		FilesApplication* _tmp124_;
		gchar* _tmp125_;
		gchar* _tmp126_;
		gchar** _tmp127_;
		gchar** _tmp128_;
		gint _tmp128__length1;
		FilesApplication* _tmp129_;
		gchar* _tmp130_;
		gchar** _tmp131_;
		gchar** _tmp132_;
		gint _tmp132__length1;
		FilesApplication* _tmp133_;
		gchar* _tmp134_;
		gchar** _tmp135_;
		gchar** _tmp136_;
		gint _tmp136__length1;
		FilesApplication* _tmp137_;
		gchar* _tmp138_;
		gchar** _tmp139_;
		gchar** _tmp140_;
		gint _tmp140__length1;
		FilesApplication* _tmp141_;
		gchar* _tmp142_;
		gchar** _tmp143_;
		gchar** _tmp144_;
		gint _tmp144__length1;
		_tmp3_ = self->priv->_marlin_app;
		_tmp4_ = g_strdup ("<Ctrl>N");
		_tmp5_ = g_new0 (gchar*, 1 + 1);
		_tmp5_[0] = _tmp4_;
		_tmp6_ = _tmp5_;
		_tmp6__length1 = 1;
		gtk_application_set_accels_for_action ((GtkApplication*) _tmp3_, "win.new-window", _tmp6_);
		_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_free), NULL);
		_tmp7_ = self->priv->_marlin_app;
		_tmp8_ = g_strdup ("<Ctrl>Z");
		_tmp9_ = g_new0 (gchar*, 1 + 1);
		_tmp9_[0] = _tmp8_;
		_tmp10_ = _tmp9_;
		_tmp10__length1 = 1;
		gtk_application_set_accels_for_action ((GtkApplication*) _tmp7_, "win.undo", _tmp10_);
		_tmp10_ = (_vala_array_free (_tmp10_, _tmp10__length1, (GDestroyNotify) g_free), NULL);
		_tmp11_ = self->priv->_marlin_app;
		_tmp12_ = g_strdup ("<Ctrl><Shift>Z");
		_tmp13_ = g_new0 (gchar*, 1 + 1);
		_tmp13_[0] = _tmp12_;
		_tmp14_ = _tmp13_;
		_tmp14__length1 = 1;
		gtk_application_set_accels_for_action ((GtkApplication*) _tmp11_, "win.redo", _tmp14_);
		_tmp14_ = (_vala_array_free (_tmp14_, _tmp14__length1, (GDestroyNotify) g_free), NULL);
		_tmp15_ = self->priv->_marlin_app;
		_tmp16_ = g_strdup ("<Ctrl>D");
		_tmp17_ = g_new0 (gchar*, 1 + 1);
		_tmp17_[0] = _tmp16_;
		_tmp18_ = _tmp17_;
		_tmp18__length1 = 1;
		gtk_application_set_accels_for_action ((GtkApplication*) _tmp15_, "win.bookmark", _tmp18_);
		_tmp18_ = (_vala_array_free (_tmp18_, _tmp18__length1, (GDestroyNotify) g_free), NULL);
		_tmp19_ = self->priv->_marlin_app;
		_tmp20_ = g_strdup ("<Ctrl>F");
		_tmp21_ = g_new0 (gchar*, 1 + 1);
		_tmp21_[0] = _tmp20_;
		_tmp22_ = _tmp21_;
		_tmp22__length1 = 1;
		gtk_application_set_accels_for_action ((GtkApplication*) _tmp19_, "win.find::", _tmp22_);
		_tmp22_ = (_vala_array_free (_tmp22_, _tmp22__length1, (GDestroyNotify) g_free), NULL);
		_tmp23_ = self->priv->_marlin_app;
		_tmp24_ = g_strdup ("<Ctrl>L");
		_tmp25_ = g_new0 (gchar*, 1 + 1);
		_tmp25_[0] = _tmp24_;
		_tmp26_ = _tmp25_;
		_tmp26__length1 = 1;
		gtk_application_set_accels_for_action ((GtkApplication*) _tmp23_, "win.edit-path", _tmp26_);
		_tmp26_ = (_vala_array_free (_tmp26_, _tmp26__length1, (GDestroyNotify) g_free), NULL);
		_tmp27_ = self->priv->_marlin_app;
		_tmp28_ = g_strdup ("<Ctrl>T");
		_tmp29_ = g_new0 (gchar*, 1 + 1);
		_tmp29_[0] = _tmp28_;
		_tmp30_ = _tmp29_;
		_tmp30__length1 = 1;
		gtk_application_set_accels_for_action ((GtkApplication*) _tmp27_, "win.tab::NEW", _tmp30_);
		_tmp30_ = (_vala_array_free (_tmp30_, _tmp30__length1, (GDestroyNotify) g_free), NULL);
		_tmp31_ = self->priv->_marlin_app;
		_tmp32_ = g_strdup ("<Ctrl>W");
		_tmp33_ = g_new0 (gchar*, 1 + 1);
		_tmp33_[0] = _tmp32_;
		_tmp34_ = _tmp33_;
		_tmp34__length1 = 1;
		gtk_application_set_accels_for_action ((GtkApplication*) _tmp31_, "win.tab::CLOSE", _tmp34_);
		_tmp34_ = (_vala_array_free (_tmp34_, _tmp34__length1, (GDestroyNotify) g_free), NULL);
		_tmp35_ = self->priv->_marlin_app;
		_tmp36_ = g_strdup ("<Ctrl>Page_Down");
		_tmp37_ = g_strdup ("<Ctrl>Tab");
		_tmp38_ = g_new0 (gchar*, 2 + 1);
		_tmp38_[0] = _tmp36_;
		_tmp38_[1] = _tmp37_;
		_tmp39_ = _tmp38_;
		_tmp39__length1 = 2;
		gtk_application_set_accels_for_action ((GtkApplication*) _tmp35_, "win.tab::NEXT", _tmp39_);
		_tmp39_ = (_vala_array_free (_tmp39_, _tmp39__length1, (GDestroyNotify) g_free), NULL);
		_tmp40_ = self->priv->_marlin_app;
		_tmp41_ = g_strdup ("<Ctrl>Page_Up");
		_tmp42_ = g_strdup ("<Shift><Ctrl>Tab");
		_tmp43_ = g_new0 (gchar*, 2 + 1);
		_tmp43_[0] = _tmp41_;
		_tmp43_[1] = _tmp42_;
		_tmp44_ = _tmp43_;
		_tmp44__length1 = 2;
		gtk_application_set_accels_for_action ((GtkApplication*) _tmp40_, "win.tab::PREVIOUS", _tmp44_);
		_tmp44_ = (_vala_array_free (_tmp44_, _tmp44__length1, (GDestroyNotify) g_free), NULL);
		_tmp45_ = self->priv->_marlin_app;
		_tmp46_ = g_variant_new_uint32 ((guint32) 0);
		g_variant_ref_sink (_tmp46_);
		_tmp47_ = _tmp46_;
		_tmp48_ = g_action_print_detailed_name ("win.view-mode", _tmp47_);
		_tmp49_ = _tmp48_;
		_tmp50_ = g_strdup ("<Ctrl>1");
		_tmp51_ = g_new0 (gchar*, 1 + 1);
		_tmp51_[0] = _tmp50_;
		_tmp52_ = _tmp51_;
		_tmp52__length1 = 1;
		gtk_application_set_accels_for_action ((GtkApplication*) _tmp45_, _tmp49_, _tmp52_);
		_tmp52_ = (_vala_array_free (_tmp52_, _tmp52__length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (_tmp49_);
		_g_variant_unref0 (_tmp47_);
		_tmp53_ = self->priv->_marlin_app;
		_tmp54_ = g_variant_new_uint32 ((guint32) 1);
		g_variant_ref_sink (_tmp54_);
		_tmp55_ = _tmp54_;
		_tmp56_ = g_action_print_detailed_name ("win.view-mode", _tmp55_);
		_tmp57_ = _tmp56_;
		_tmp58_ = g_strdup ("<Ctrl>2");
		_tmp59_ = g_new0 (gchar*, 1 + 1);
		_tmp59_[0] = _tmp58_;
		_tmp60_ = _tmp59_;
		_tmp60__length1 = 1;
		gtk_application_set_accels_for_action ((GtkApplication*) _tmp53_, _tmp57_, _tmp60_);
		_tmp60_ = (_vala_array_free (_tmp60_, _tmp60__length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (_tmp57_);
		_g_variant_unref0 (_tmp55_);
		_tmp61_ = self->priv->_marlin_app;
		_tmp62_ = g_variant_new_uint32 ((guint32) 2);
		g_variant_ref_sink (_tmp62_);
		_tmp63_ = _tmp62_;
		_tmp64_ = g_action_print_detailed_name ("win.view-mode", _tmp63_);
		_tmp65_ = _tmp64_;
		_tmp66_ = g_strdup ("<Ctrl>3");
		_tmp67_ = g_new0 (gchar*, 1 + 1);
		_tmp67_[0] = _tmp66_;
		_tmp68_ = _tmp67_;
		_tmp68__length1 = 1;
		gtk_application_set_accels_for_action ((GtkApplication*) _tmp61_, _tmp65_, _tmp68_);
		_tmp68_ = (_vala_array_free (_tmp68_, _tmp68__length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (_tmp65_);
		_g_variant_unref0 (_tmp63_);
		_tmp69_ = self->priv->_marlin_app;
		_tmp70_ = g_strdup ("<Ctrl>plus");
		_tmp71_ = g_strdup ("<Ctrl>equal");
		_tmp72_ = g_new0 (gchar*, 2 + 1);
		_tmp72_[0] = _tmp70_;
		_tmp72_[1] = _tmp71_;
		_tmp73_ = _tmp72_;
		_tmp73__length1 = 2;
		gtk_application_set_accels_for_action ((GtkApplication*) _tmp69_, "win.zoom::ZOOM_IN", _tmp73_);
		_tmp73_ = (_vala_array_free (_tmp73_, _tmp73__length1, (GDestroyNotify) g_free), NULL);
		_tmp74_ = self->priv->_marlin_app;
		_tmp75_ = g_strdup ("<Ctrl>minus");
		_tmp76_ = g_new0 (gchar*, 1 + 1);
		_tmp76_[0] = _tmp75_;
		_tmp77_ = _tmp76_;
		_tmp77__length1 = 1;
		gtk_application_set_accels_for_action ((GtkApplication*) _tmp74_, "win.zoom::ZOOM_OUT", _tmp77_);
		_tmp77_ = (_vala_array_free (_tmp77_, _tmp77__length1, (GDestroyNotify) g_free), NULL);
		_tmp78_ = self->priv->_marlin_app;
		_tmp79_ = g_strdup ("<Ctrl>0");
		_tmp80_ = g_new0 (gchar*, 1 + 1);
		_tmp80_[0] = _tmp79_;
		_tmp81_ = _tmp80_;
		_tmp81__length1 = 1;
		gtk_application_set_accels_for_action ((GtkApplication*) _tmp78_, "win.zoom::ZOOM_NORMAL", _tmp81_);
		_tmp81_ = (_vala_array_free (_tmp81_, _tmp81__length1, (GDestroyNotify) g_free), NULL);
		_tmp82_ = self->priv->_marlin_app;
		_tmp83_ = g_strdup ("<Ctrl>H");
		_tmp84_ = g_new0 (gchar*, 1 + 1);
		_tmp84_[0] = _tmp83_;
		_tmp85_ = _tmp84_;
		_tmp85__length1 = 1;
		gtk_application_set_accels_for_action ((GtkApplication*) _tmp82_, "win.show-hidden", _tmp85_);
		_tmp85_ = (_vala_array_free (_tmp85_, _tmp85__length1, (GDestroyNotify) g_free), NULL);
		_tmp86_ = self->priv->_marlin_app;
		_tmp87_ = g_strdup ("<Ctrl>R");
		_tmp88_ = g_strdup ("F5");
		_tmp89_ = g_new0 (gchar*, 2 + 1);
		_tmp89_[0] = _tmp87_;
		_tmp89_[1] = _tmp88_;
		_tmp90_ = _tmp89_;
		_tmp90__length1 = 2;
		gtk_application_set_accels_for_action ((GtkApplication*) _tmp86_, "win.refresh", _tmp90_);
		_tmp90_ = (_vala_array_free (_tmp90_, _tmp90__length1, (GDestroyNotify) g_free), NULL);
		_tmp91_ = self->priv->_marlin_app;
		_tmp92_ = g_strdup ("<Alt>Home");
		_tmp93_ = g_new0 (gchar*, 1 + 1);
		_tmp93_[0] = _tmp92_;
		_tmp94_ = _tmp93_;
		_tmp94__length1 = 1;
		gtk_application_set_accels_for_action ((GtkApplication*) _tmp91_, "win.go-to::HOME", _tmp94_);
		_tmp94_ = (_vala_array_free (_tmp94_, _tmp94__length1, (GDestroyNotify) g_free), NULL);
		_tmp95_ = self->priv->_marlin_app;
		_tmp96_ = g_strdup ("<Alt>R");
		_tmp97_ = g_new0 (gchar*, 1 + 1);
		_tmp97_[0] = _tmp96_;
		_tmp98_ = _tmp97_;
		_tmp98__length1 = 1;
		gtk_application_set_accels_for_action ((GtkApplication*) _tmp95_, "win.go-to::RECENT", _tmp98_);
		_tmp98_ = (_vala_array_free (_tmp98_, _tmp98__length1, (GDestroyNotify) g_free), NULL);
		_tmp99_ = self->priv->_marlin_app;
		_tmp100_ = g_strdup ("<Alt>T");
		_tmp101_ = g_new0 (gchar*, 1 + 1);
		_tmp101_[0] = _tmp100_;
		_tmp102_ = _tmp101_;
		_tmp102__length1 = 1;
		gtk_application_set_accels_for_action ((GtkApplication*) _tmp99_, "win.go-to::TRASH", _tmp102_);
		_tmp102_ = (_vala_array_free (_tmp102_, _tmp102__length1, (GDestroyNotify) g_free), NULL);
		_tmp103_ = self->priv->_marlin_app;
		_tmp104_ = g_strdup ("<Alt>slash");
		_tmp105_ = g_new0 (gchar*, 1 + 1);
		_tmp105_[0] = _tmp104_;
		_tmp106_ = _tmp105_;
		_tmp106__length1 = 1;
		gtk_application_set_accels_for_action ((GtkApplication*) _tmp103_, "win.go-to::ROOT", _tmp106_);
		_tmp106_ = (_vala_array_free (_tmp106_, _tmp106__length1, (GDestroyNotify) g_free), NULL);
		_tmp107_ = self->priv->_marlin_app;
		_tmp108_ = g_strdup ("<Alt>N");
		_tmp109_ = g_new0 (gchar*, 1 + 1);
		_tmp109_[0] = _tmp108_;
		_tmp110_ = _tmp109_;
		_tmp110__length1 = 1;
		gtk_application_set_accels_for_action ((GtkApplication*) _tmp107_, "win.go-to::NETWORK", _tmp110_);
		_tmp110_ = (_vala_array_free (_tmp110_, _tmp110__length1, (GDestroyNotify) g_free), NULL);
		_tmp111_ = self->priv->_marlin_app;
		_tmp112_ = g_strdup ("<Alt>C");
		_tmp113_ = g_new0 (gchar*, 1 + 1);
		_tmp113_[0] = _tmp112_;
		_tmp114_ = _tmp113_;
		_tmp114__length1 = 1;
		gtk_application_set_accels_for_action ((GtkApplication*) _tmp111_, "win.go-to::SERVER", _tmp114_);
		_tmp114_ = (_vala_array_free (_tmp114_, _tmp114__length1, (GDestroyNotify) g_free), NULL);
		_tmp115_ = self->priv->_marlin_app;
		_tmp116_ = g_strdup ("<Alt>Up");
		_tmp117_ = g_new0 (gchar*, 1 + 1);
		_tmp117_[0] = _tmp116_;
		_tmp118_ = _tmp117_;
		_tmp118__length1 = 1;
		gtk_application_set_accels_for_action ((GtkApplication*) _tmp115_, "win.go-to::UP", _tmp118_);
		_tmp118_ = (_vala_array_free (_tmp118_, _tmp118__length1, (GDestroyNotify) g_free), NULL);
		_tmp119_ = self->priv->_marlin_app;
		_tmp120_ = g_strdup ("<Alt>Right");
		_tmp121_ = g_strdup ("XF86Forward");
		_tmp122_ = g_new0 (gchar*, 2 + 1);
		_tmp122_[0] = _tmp120_;
		_tmp122_[1] = _tmp121_;
		_tmp123_ = _tmp122_;
		_tmp123__length1 = 2;
		gtk_application_set_accels_for_action ((GtkApplication*) _tmp119_, "win.forward(1)", _tmp123_);
		_tmp123_ = (_vala_array_free (_tmp123_, _tmp123__length1, (GDestroyNotify) g_free), NULL);
		_tmp124_ = self->priv->_marlin_app;
		_tmp125_ = g_strdup ("<Alt>Left");
		_tmp126_ = g_strdup ("XF86Back");
		_tmp127_ = g_new0 (gchar*, 2 + 1);
		_tmp127_[0] = _tmp125_;
		_tmp127_[1] = _tmp126_;
		_tmp128_ = _tmp127_;
		_tmp128__length1 = 2;
		gtk_application_set_accels_for_action ((GtkApplication*) _tmp124_, "win.back(1)", _tmp128_);
		_tmp128_ = (_vala_array_free (_tmp128_, _tmp128__length1, (GDestroyNotify) g_free), NULL);
		_tmp129_ = self->priv->_marlin_app;
		_tmp130_ = g_strdup ("F1");
		_tmp131_ = g_new0 (gchar*, 1 + 1);
		_tmp131_[0] = _tmp130_;
		_tmp132_ = _tmp131_;
		_tmp132__length1 = 1;
		gtk_application_set_accels_for_action ((GtkApplication*) _tmp129_, "win.info::HELP", _tmp132_);
		_tmp132_ = (_vala_array_free (_tmp132_, _tmp132__length1, (GDestroyNotify) g_free), NULL);
		_tmp133_ = self->priv->_marlin_app;
		_tmp134_ = g_strdup ("<Shift><Ctrl>K");
		_tmp135_ = g_new0 (gchar*, 1 + 1);
		_tmp135_[0] = _tmp134_;
		_tmp136_ = _tmp135_;
		_tmp136__length1 = 1;
		gtk_application_set_accels_for_action ((GtkApplication*) _tmp133_, "win.tab::TAB", _tmp136_);
		_tmp136_ = (_vala_array_free (_tmp136_, _tmp136__length1, (GDestroyNotify) g_free), NULL);
		_tmp137_ = self->priv->_marlin_app;
		_tmp138_ = g_strdup ("<Ctrl><Alt>N");
		_tmp139_ = g_new0 (gchar*, 1 + 1);
		_tmp139_[0] = _tmp138_;
		_tmp140_ = _tmp139_;
		_tmp140__length1 = 1;
		gtk_application_set_accels_for_action ((GtkApplication*) _tmp137_, "win.tab::WINDOW", _tmp140_);
		_tmp140_ = (_vala_array_free (_tmp140_, _tmp140__length1, (GDestroyNotify) g_free), NULL);
		_tmp141_ = self->priv->_marlin_app;
		_tmp142_ = g_strdup ("<Ctrl>Left");
		_tmp143_ = g_new0 (gchar*, 1 + 1);
		_tmp143_[0] = _tmp142_;
		_tmp144_ = _tmp143_;
		_tmp144__length1 = 1;
		gtk_application_set_accels_for_action ((GtkApplication*) _tmp141_, "win.focus-sidebar", _tmp144_);
		_tmp144_ = (_vala_array_free (_tmp144_, _tmp144__length1, (GDestroyNotify) g_free), NULL);
	}
	files_view_window_build_window (self);
	_tmp145_ = files_app_settings;
	g_settings_get (_tmp145_, "window-size", "(ii)", &_tmp146_, &_tmp147_);
	width = _tmp146_;
	height = _tmp147_;
	g_object_set ((GtkWindow*) self, "default-width", width, NULL);
	g_object_set ((GtkWindow*) self, "default-height", height, NULL);
	_tmp148_ = files_view_window_get_is_first_window (self);
	_tmp149_ = _tmp148_;
	if (_tmp149_) {
		GSettings* _tmp150_;
		GtkPaned* _tmp151_;
		FilesWindowState state = 0;
		GSettings* _tmp152_;
		_tmp150_ = files_app_settings;
		_tmp151_ = self->priv->lside_pane;
		g_settings_bind (_tmp150_, "sidebar-width", (GObject*) _tmp151_, "position", G_SETTINGS_BIND_DEFAULT);
		_tmp152_ = files_app_settings;
		state = (FilesWindowState) g_settings_get_enum (_tmp152_, "window-state");
		if (state == FILES_WINDOW_STATE_MAXIMIZED) {
			gtk_window_maximize ((GtkWindow*) self);
		}
	}
	g_signal_connect_object (self, "loading-uri", (GCallback) _files_view_window_update_labels_files_view_window_loading_uri, self, 0);
	gtk_window_present ((GtkWindow*) self);
	return obj;
}

static void
files_view_window_class_init (FilesViewWindowClass * klass,
                              gpointer klass_data)
{
	files_view_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FilesViewWindow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_files_view_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_files_view_window_set_property;
	G_OBJECT_CLASS (klass)->constructor = files_view_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = files_view_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_VIEW_WINDOW_WINDOW_NUMBER_PROPERTY, files_view_window_properties[FILES_VIEW_WINDOW_WINDOW_NUMBER_PROPERTY] = g_param_spec_uint ("window-number", "window-number", "window-number", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_VIEW_WINDOW_IS_FIRST_WINDOW_PROPERTY, files_view_window_properties[FILES_VIEW_WINDOW_IS_FIRST_WINDOW_PROPERTY] = g_param_spec_boolean ("is-first-window", "is-first-window", "is-first-window", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_VIEW_WINDOW_DEFAULT_MODE_PROPERTY, files_view_window_properties[FILES_VIEW_WINDOW_DEFAULT_MODE_PROPERTY] = g_param_spec_enum ("default-mode", "default-mode", "default-mode", FILES_TYPE_VIEW_MODE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_VIEW_WINDOW_DEFAULT_LOCATION_PROPERTY, files_view_window_properties[FILES_VIEW_WINDOW_DEFAULT_LOCATION_PROPERTY] = g_param_spec_object ("default-location", "default-location", "default-location", g_file_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_VIEW_WINDOW_MARLIN_APP_PROPERTY, files_view_window_properties[FILES_VIEW_WINDOW_MARLIN_APP_PROPERTY] = g_param_spec_object ("marlin-app", "marlin-app", "marlin-app", FILES_TYPE_APPLICATION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	files_view_window_signals[FILES_VIEW_WINDOW_LOADING_URI_SIGNAL] = g_signal_new ("loading-uri", FILES_VIEW_TYPE_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	files_view_window_signals[FILES_VIEW_WINDOW_FOLDER_DELETED_SIGNAL] = g_signal_new ("folder-deleted", FILES_VIEW_TYPE_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, g_file_get_type ());
	files_view_window_signals[FILES_VIEW_WINDOW_FREE_SPACE_CHANGE_SIGNAL] = g_signal_new ("free-space-change", FILES_VIEW_TYPE_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	hdy_init ();
}

static void
files_view_window_instance_init (FilesViewWindow * self,
                                 gpointer klass)
{
	self->priv = files_view_window_get_instance_private (self);
	self->priv->_locked_focus = FALSE;
	self->priv->tabs_restored = FALSE;
	self->priv->restoring_tabs = 0;
	self->priv->doing_undo_redo = FALSE;
	self->priv->adding_window = FALSE;
}

static void
files_view_window_finalize (GObject * obj)
{
	FilesViewWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_VIEW_TYPE_WINDOW, FilesViewWindow);
	_g_object_unref0 (self->ui);
	_g_object_unref0 (self->priv->_marlin_app);
	_g_object_unref0 (self->headerbar);
	_g_object_unref0 (self->view_switcher);
	_g_object_unref0 (self->tab_view);
	_g_object_unref0 (self->tab_bar);
	_g_object_unref0 (self->priv->lside_pane);
	_g_object_unref0 (self->sidebar);
	_g_object_unref0 (self->priv->button_forward);
	_g_object_unref0 (self->priv->button_back);
	_g_object_unref0 (self->priv->location_bar);
	_g_object_unref0 (self->priv->tab_history_button);
	_g_object_unref0 (self->priv->key_controller);
	G_OBJECT_CLASS (files_view_window_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
files_view_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FilesViewWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) files_view_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FilesViewWindow), 0, (GInstanceInitFunc) files_view_window_instance_init, NULL };
	GType files_view_window_type_id;
	files_view_window_type_id = g_type_register_static (hdy_application_window_get_type (), "FilesViewWindow", &g_define_type_info, 0);
	FilesViewWindow_private_offset = g_type_add_instance_private (files_view_window_type_id, sizeof (FilesViewWindowPrivate));
	return files_view_window_type_id;
}

GType
files_view_window_get_type (void)
{
	static volatile gsize files_view_window_type_id__once = 0;
	if (g_once_init_enter (&files_view_window_type_id__once)) {
		GType files_view_window_type_id;
		files_view_window_type_id = files_view_window_get_type_once ();
		g_once_init_leave (&files_view_window_type_id__once, files_view_window_type_id);
	}
	return files_view_window_type_id__once;
}

static void
_vala_files_view_window_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	FilesViewWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FILES_VIEW_TYPE_WINDOW, FilesViewWindow);
	switch (property_id) {
		case FILES_VIEW_WINDOW_WINDOW_NUMBER_PROPERTY:
		g_value_set_uint (value, files_view_window_get_window_number (self));
		break;
		case FILES_VIEW_WINDOW_IS_FIRST_WINDOW_PROPERTY:
		g_value_set_boolean (value, files_view_window_get_is_first_window (self));
		break;
		case FILES_VIEW_WINDOW_DEFAULT_MODE_PROPERTY:
		g_value_set_enum (value, files_view_window_get_default_mode (self));
		break;
		case FILES_VIEW_WINDOW_DEFAULT_LOCATION_PROPERTY:
		g_value_take_object (value, files_view_window_get_default_location (self));
		break;
		case FILES_VIEW_WINDOW_MARLIN_APP_PROPERTY:
		g_value_set_object (value, files_view_window_get_marlin_app (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_files_view_window_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	FilesViewWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FILES_VIEW_TYPE_WINDOW, FilesViewWindow);
	switch (property_id) {
		case FILES_VIEW_WINDOW_WINDOW_NUMBER_PROPERTY:
		files_view_window_set_window_number (self, g_value_get_uint (value));
		break;
		case FILES_VIEW_WINDOW_MARLIN_APP_PROPERTY:
		files_view_window_set_marlin_app (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

