#include <sal/types.h>


#include <rtl/ustring.hxx>


extern "C" {

static constexpr OUStringLiteral langID = u"\x0070\x0061\x0070";
static constexpr OUStringLiteral langDefaultName = u"\x0050\x0061\x0070\x0069\x0061\x006d\x0065\x006e\x0074\x006f";
static constexpr OUStringLiteral countryID = u"\x0042\x0051";
static constexpr OUStringLiteral countryDefaultName = u"\x0042\x006f\x006e\x0061\x0069\x0072\x0065";
static constexpr OUStringLiteral Variant = u"";

static constexpr OUString LCInfoArray[] = {
	langID,
	langDefaultName,
	countryID,
	countryDefaultName,
	Variant
};

SAL_DLLPUBLIC_EXPORT OUString const *  getLCInfo_pap_BQ(sal_Int16& count)
{
	count = std::size(LCInfoArray);
	return (OUString const *)LCInfoArray;
}
extern const OUString *  getLocaleItem_pap_CW(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getLocaleItem_pap_BQ(sal_Int16& count)
{
	return getLocaleItem_pap_CW(count);
}
static const sal_Unicode replaceTo0[] = {0x5b, 0x24, 0x24, 0x2d, 0x38, 0x38, 0x37, 0x39, 0x5d, 0x0};
extern OUString const * getAllFormats0_pap_CW(sal_Int16& count, const sal_Unicode*& from, const sal_Unicode*& to);
SAL_DLLPUBLIC_EXPORT OUString const * getAllFormats0_pap_BQ(sal_Int16& count, const sal_Unicode*& from, const sal_Unicode*& to)
{
	to = replaceTo0;
	const sal_Unicode* tmp;
	return getAllFormats0_pap_CW(count, from, tmp);
}
extern const OUString *  getDateAcceptancePatterns_pap_CW(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getDateAcceptancePatterns_pap_BQ(sal_Int16& count)
{
	return getDateAcceptancePatterns_pap_CW(count);
}
extern const OUString *  getCollatorImplementation_pap_CW(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getCollatorImplementation_pap_BQ(sal_Int16& count)
{
	return getCollatorImplementation_pap_CW(count);
}
extern const OUString *  getCollationOptions_pap_CW(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getCollationOptions_pap_BQ(sal_Int16& count)
{
	return getCollationOptions_pap_CW(count);
}
extern const OUString *  getSearchOptions_pap_CW(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getSearchOptions_pap_BQ(sal_Int16& count)
{
	return getSearchOptions_pap_CW(count);
}
extern const OUString *  getIndexAlgorithm_pap_CW(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getIndexAlgorithm_pap_BQ(sal_Int16& count)
{
	return getIndexAlgorithm_pap_CW(count);
}
extern const OUString *  getUnicodeScripts_pap_CW(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getUnicodeScripts_pap_BQ(sal_Int16& count)
{
	return getUnicodeScripts_pap_CW(count);
}
extern const OUString *  getFollowPageWords_pap_CW(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getFollowPageWords_pap_BQ(sal_Int16& count)
{
	return getFollowPageWords_pap_CW(count);
}
extern const OUString *  getAllCalendars_pap_CW(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getAllCalendars_pap_BQ(sal_Int16& count)
{
	return getAllCalendars_pap_CW(count);
}
static constexpr OUStringLiteral defaultCurrency0 = u"\x1";
static constexpr OUStringLiteral defaultCurrencyUsedInCompatibleFormatCodes0 = u"\x1";
static constexpr OUStringLiteral defaultCurrencyLegacyOnly0 = u"\x0";
static constexpr OUStringLiteral currencyID0 = u"\x0055\x0053\x0044";
static constexpr OUStringLiteral currencySymbol0 = u"\x0024";
static constexpr OUStringLiteral bankSymbol0 = u"\x0055\x0053\x0044";
static constexpr OUStringLiteral currencyName0 = u"\x0055\x0053\x0020\x0044\x006f\x006c\x006c\x0061\x0072";
static constexpr OUStringLiteral currencyDecimalPlaces0 = u"\x2";

static const sal_Int16 currencyCount = 1;

static constexpr OUString currencies[] = {
	currencyID0,
	currencySymbol0,
	bankSymbol0,
	currencyName0,
	defaultCurrency0,
	defaultCurrencyUsedInCompatibleFormatCodes0,
	currencyDecimalPlaces0,
	defaultCurrencyLegacyOnly0,
};

SAL_DLLPUBLIC_EXPORT OUString const *  getAllCurrencies_pap_BQ(sal_Int16& count)
{
	count = currencyCount;
	return (OUString const *)currencies;
}
extern const OUString *  getTransliterations_pap_CW(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getTransliterations_pap_BQ(sal_Int16& count)
{
	return getTransliterations_pap_CW(count);
}
extern const OUString *  getForbiddenCharacters_pap_CW(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getForbiddenCharacters_pap_BQ(sal_Int16& count)
{
	return getForbiddenCharacters_pap_CW(count);
}
extern const OUString *  getBreakIteratorRules_pap_CW(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getBreakIteratorRules_pap_BQ(sal_Int16& count)
{
	return getBreakIteratorRules_pap_CW(count);
}
extern const OUString *  getReservedWords_pap_CW(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getReservedWords_pap_BQ(sal_Int16& count)
{
	return getReservedWords_pap_CW(count);
}
// ---> ContinuousNumbering
extern const OUString **  getContinuousNumberingLevels_pap_CW(sal_Int16& nStyles, sal_Int16& nAttributes);
SAL_DLLPUBLIC_EXPORT const OUString **  getContinuousNumberingLevels_pap_BQ(sal_Int16& nStyles, sal_Int16& nAttributes)
{
	return getContinuousNumberingLevels_pap_CW(nStyles, nAttributes);
}
// ---> OutlineNumbering
extern const OUString ***  getOutlineNumberingLevels_pap_CW(sal_Int16& nStyles, sal_Int16& nLevels, sal_Int16& nAttributes);
SAL_DLLPUBLIC_EXPORT const OUString ***  getOutlineNumberingLevels_pap_BQ(sal_Int16& nStyles, sal_Int16& nLevels, sal_Int16& nAttributes)
{
	return getOutlineNumberingLevels_pap_CW(nStyles, nLevels, nAttributes);
}
} // extern "C"

