#ifndef itkInterpolateImageFunctionSwigInterface_h
#define itkInterpolateImageFunctionSwigInterface_h
#include "itkCommand.h"
#include "itkOffset.h"
#include "itkVector.h"
#include "itkCovariantVector.h"
#include "itkContinuousIndex.h"
#include "itkArray.h"
#include "itkFixedArray.h"
#include "itkRGBPixel.h"
#include "itkRGBAPixel.h"
#include "complex"
#include "itkSymmetricSecondRankTensor.h"
#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkVariableLengthVector.h"
#include "itkPoint.h"
#include "itkPhasedArray3DSpecialCoordinatesImage.h"
#include "itkInterpolateImageFunction.h"

using itkInterpolateImageFunctionISC2D = itk::InterpolateImageFunction< itk::Image< signed char,2 >,double >;
using itkInterpolateImageFunctionISC2D_Pointer = itk::InterpolateImageFunction< itk::Image< signed char,2 >,double >::Pointer;
using itkInterpolateImageFunctionISC2F = itk::InterpolateImageFunction< itk::Image< signed char,2 >,float >;
using itkInterpolateImageFunctionISC2F_Pointer = itk::InterpolateImageFunction< itk::Image< signed char,2 >,float >::Pointer;
using itkInterpolateImageFunctionISS2D = itk::InterpolateImageFunction< itk::Image< signed short,2 >,double >;
using itkInterpolateImageFunctionISS2D_Pointer = itk::InterpolateImageFunction< itk::Image< signed short,2 >,double >::Pointer;
using itkInterpolateImageFunctionISS2F = itk::InterpolateImageFunction< itk::Image< signed short,2 >,float >;
using itkInterpolateImageFunctionISS2F_Pointer = itk::InterpolateImageFunction< itk::Image< signed short,2 >,float >::Pointer;
using itkInterpolateImageFunctionIUC2D = itk::InterpolateImageFunction< itk::Image< unsigned char,2 >,double >;
using itkInterpolateImageFunctionIUC2D_Pointer = itk::InterpolateImageFunction< itk::Image< unsigned char,2 >,double >::Pointer;
using itkInterpolateImageFunctionIUC2F = itk::InterpolateImageFunction< itk::Image< unsigned char,2 >,float >;
using itkInterpolateImageFunctionIUC2F_Pointer = itk::InterpolateImageFunction< itk::Image< unsigned char,2 >,float >::Pointer;
using itkInterpolateImageFunctionIULL2D = itk::InterpolateImageFunction< itk::Image< unsigned long long,2 >,double >;
using itkInterpolateImageFunctionIULL2D_Pointer = itk::InterpolateImageFunction< itk::Image< unsigned long long,2 >,double >::Pointer;
using itkInterpolateImageFunctionIULL2F = itk::InterpolateImageFunction< itk::Image< unsigned long long,2 >,float >;
using itkInterpolateImageFunctionIULL2F_Pointer = itk::InterpolateImageFunction< itk::Image< unsigned long long,2 >,float >::Pointer;
using itkInterpolateImageFunctionIUS2D = itk::InterpolateImageFunction< itk::Image< unsigned short,2 >,double >;
using itkInterpolateImageFunctionIUS2D_Pointer = itk::InterpolateImageFunction< itk::Image< unsigned short,2 >,double >::Pointer;
using itkInterpolateImageFunctionIUS2F = itk::InterpolateImageFunction< itk::Image< unsigned short,2 >,float >;
using itkInterpolateImageFunctionIUS2F_Pointer = itk::InterpolateImageFunction< itk::Image< unsigned short,2 >,float >::Pointer;
using itkInterpolateImageFunctionIF2D = itk::InterpolateImageFunction< itk::Image< float,2 >,double >;
using itkInterpolateImageFunctionIF2D_Pointer = itk::InterpolateImageFunction< itk::Image< float,2 >,double >::Pointer;
using itkInterpolateImageFunctionIF2F = itk::InterpolateImageFunction< itk::Image< float,2 >,float >;
using itkInterpolateImageFunctionIF2F_Pointer = itk::InterpolateImageFunction< itk::Image< float,2 >,float >::Pointer;
using itkInterpolateImageFunctionID2D = itk::InterpolateImageFunction< itk::Image< double,2 >,double >;
using itkInterpolateImageFunctionID2D_Pointer = itk::InterpolateImageFunction< itk::Image< double,2 >,double >::Pointer;
using itkInterpolateImageFunctionID2F = itk::InterpolateImageFunction< itk::Image< double,2 >,float >;
using itkInterpolateImageFunctionID2F_Pointer = itk::InterpolateImageFunction< itk::Image< double,2 >,float >::Pointer;
using itkInterpolateImageFunctionIVD22D = itk::InterpolateImageFunction< itk::Image< itk::Vector< double,2 >,2 >,double >;
using itkInterpolateImageFunctionIVD22D_Pointer = itk::InterpolateImageFunction< itk::Image< itk::Vector< double,2 >,2 >,double >::Pointer;
using itkInterpolateImageFunctionIVF22D = itk::InterpolateImageFunction< itk::Image< itk::Vector< float,2 >,2 >,double >;
using itkInterpolateImageFunctionIVF22D_Pointer = itk::InterpolateImageFunction< itk::Image< itk::Vector< float,2 >,2 >,double >::Pointer;
using itkInterpolateImageFunctionICVD22D = itk::InterpolateImageFunction< itk::Image< itk::CovariantVector< double,2 >,2 >,double >;
using itkInterpolateImageFunctionICVD22D_Pointer = itk::InterpolateImageFunction< itk::Image< itk::CovariantVector< double,2 >,2 >,double >::Pointer;
using itkInterpolateImageFunctionICVF22D = itk::InterpolateImageFunction< itk::Image< itk::CovariantVector< float,2 >,2 >,double >;
using itkInterpolateImageFunctionICVF22D_Pointer = itk::InterpolateImageFunction< itk::Image< itk::CovariantVector< float,2 >,2 >,double >::Pointer;
using itkInterpolateImageFunctionIRGBUC2D = itk::InterpolateImageFunction< itk::Image< itk::RGBPixel< unsigned char >,2 >,double >;
using itkInterpolateImageFunctionIRGBUC2D_Pointer = itk::InterpolateImageFunction< itk::Image< itk::RGBPixel< unsigned char >,2 >,double >::Pointer;
using itkInterpolateImageFunctionIRGBUS2D = itk::InterpolateImageFunction< itk::Image< itk::RGBPixel< unsigned short >,2 >,double >;
using itkInterpolateImageFunctionIRGBUS2D_Pointer = itk::InterpolateImageFunction< itk::Image< itk::RGBPixel< unsigned short >,2 >,double >::Pointer;
using itkInterpolateImageFunctionIRGBAUC2D = itk::InterpolateImageFunction< itk::Image< itk::RGBAPixel< unsigned char >,2 >,double >;
using itkInterpolateImageFunctionIRGBAUC2D_Pointer = itk::InterpolateImageFunction< itk::Image< itk::RGBAPixel< unsigned char >,2 >,double >::Pointer;
using itkInterpolateImageFunctionIRGBAUS2D = itk::InterpolateImageFunction< itk::Image< itk::RGBAPixel< unsigned short >,2 >,double >;
using itkInterpolateImageFunctionIRGBAUS2D_Pointer = itk::InterpolateImageFunction< itk::Image< itk::RGBAPixel< unsigned short >,2 >,double >::Pointer;
using itkInterpolateImageFunctionISC3D = itk::InterpolateImageFunction< itk::Image< signed char,3 >,double >;
using itkInterpolateImageFunctionISC3D_Pointer = itk::InterpolateImageFunction< itk::Image< signed char,3 >,double >::Pointer;
using itkInterpolateImageFunctionISC3F = itk::InterpolateImageFunction< itk::Image< signed char,3 >,float >;
using itkInterpolateImageFunctionISC3F_Pointer = itk::InterpolateImageFunction< itk::Image< signed char,3 >,float >::Pointer;
using itkInterpolateImageFunctionISS3D = itk::InterpolateImageFunction< itk::Image< signed short,3 >,double >;
using itkInterpolateImageFunctionISS3D_Pointer = itk::InterpolateImageFunction< itk::Image< signed short,3 >,double >::Pointer;
using itkInterpolateImageFunctionISS3F = itk::InterpolateImageFunction< itk::Image< signed short,3 >,float >;
using itkInterpolateImageFunctionISS3F_Pointer = itk::InterpolateImageFunction< itk::Image< signed short,3 >,float >::Pointer;
using itkInterpolateImageFunctionIUC3D = itk::InterpolateImageFunction< itk::Image< unsigned char,3 >,double >;
using itkInterpolateImageFunctionIUC3D_Pointer = itk::InterpolateImageFunction< itk::Image< unsigned char,3 >,double >::Pointer;
using itkInterpolateImageFunctionIUC3F = itk::InterpolateImageFunction< itk::Image< unsigned char,3 >,float >;
using itkInterpolateImageFunctionIUC3F_Pointer = itk::InterpolateImageFunction< itk::Image< unsigned char,3 >,float >::Pointer;
using itkInterpolateImageFunctionIULL3D = itk::InterpolateImageFunction< itk::Image< unsigned long long,3 >,double >;
using itkInterpolateImageFunctionIULL3D_Pointer = itk::InterpolateImageFunction< itk::Image< unsigned long long,3 >,double >::Pointer;
using itkInterpolateImageFunctionIULL3F = itk::InterpolateImageFunction< itk::Image< unsigned long long,3 >,float >;
using itkInterpolateImageFunctionIULL3F_Pointer = itk::InterpolateImageFunction< itk::Image< unsigned long long,3 >,float >::Pointer;
using itkInterpolateImageFunctionIUS3D = itk::InterpolateImageFunction< itk::Image< unsigned short,3 >,double >;
using itkInterpolateImageFunctionIUS3D_Pointer = itk::InterpolateImageFunction< itk::Image< unsigned short,3 >,double >::Pointer;
using itkInterpolateImageFunctionIUS3F = itk::InterpolateImageFunction< itk::Image< unsigned short,3 >,float >;
using itkInterpolateImageFunctionIUS3F_Pointer = itk::InterpolateImageFunction< itk::Image< unsigned short,3 >,float >::Pointer;
using itkInterpolateImageFunctionIF3D = itk::InterpolateImageFunction< itk::Image< float,3 >,double >;
using itkInterpolateImageFunctionIF3D_Pointer = itk::InterpolateImageFunction< itk::Image< float,3 >,double >::Pointer;
using itkInterpolateImageFunctionIF3F = itk::InterpolateImageFunction< itk::Image< float,3 >,float >;
using itkInterpolateImageFunctionIF3F_Pointer = itk::InterpolateImageFunction< itk::Image< float,3 >,float >::Pointer;
using itkInterpolateImageFunctionID3D = itk::InterpolateImageFunction< itk::Image< double,3 >,double >;
using itkInterpolateImageFunctionID3D_Pointer = itk::InterpolateImageFunction< itk::Image< double,3 >,double >::Pointer;
using itkInterpolateImageFunctionID3F = itk::InterpolateImageFunction< itk::Image< double,3 >,float >;
using itkInterpolateImageFunctionID3F_Pointer = itk::InterpolateImageFunction< itk::Image< double,3 >,float >::Pointer;
using itkInterpolateImageFunctionIVD33D = itk::InterpolateImageFunction< itk::Image< itk::Vector< double,3 >,3 >,double >;
using itkInterpolateImageFunctionIVD33D_Pointer = itk::InterpolateImageFunction< itk::Image< itk::Vector< double,3 >,3 >,double >::Pointer;
using itkInterpolateImageFunctionIVF33D = itk::InterpolateImageFunction< itk::Image< itk::Vector< float,3 >,3 >,double >;
using itkInterpolateImageFunctionIVF33D_Pointer = itk::InterpolateImageFunction< itk::Image< itk::Vector< float,3 >,3 >,double >::Pointer;
using itkInterpolateImageFunctionICVD33D = itk::InterpolateImageFunction< itk::Image< itk::CovariantVector< double,3 >,3 >,double >;
using itkInterpolateImageFunctionICVD33D_Pointer = itk::InterpolateImageFunction< itk::Image< itk::CovariantVector< double,3 >,3 >,double >::Pointer;
using itkInterpolateImageFunctionICVF33D = itk::InterpolateImageFunction< itk::Image< itk::CovariantVector< float,3 >,3 >,double >;
using itkInterpolateImageFunctionICVF33D_Pointer = itk::InterpolateImageFunction< itk::Image< itk::CovariantVector< float,3 >,3 >,double >::Pointer;
using itkInterpolateImageFunctionIRGBUC3D = itk::InterpolateImageFunction< itk::Image< itk::RGBPixel< unsigned char >,3 >,double >;
using itkInterpolateImageFunctionIRGBUC3D_Pointer = itk::InterpolateImageFunction< itk::Image< itk::RGBPixel< unsigned char >,3 >,double >::Pointer;
using itkInterpolateImageFunctionIRGBUS3D = itk::InterpolateImageFunction< itk::Image< itk::RGBPixel< unsigned short >,3 >,double >;
using itkInterpolateImageFunctionIRGBUS3D_Pointer = itk::InterpolateImageFunction< itk::Image< itk::RGBPixel< unsigned short >,3 >,double >::Pointer;
using itkInterpolateImageFunctionIRGBAUC3D = itk::InterpolateImageFunction< itk::Image< itk::RGBAPixel< unsigned char >,3 >,double >;
using itkInterpolateImageFunctionIRGBAUC3D_Pointer = itk::InterpolateImageFunction< itk::Image< itk::RGBAPixel< unsigned char >,3 >,double >::Pointer;
using itkInterpolateImageFunctionIRGBAUS3D = itk::InterpolateImageFunction< itk::Image< itk::RGBAPixel< unsigned short >,3 >,double >;
using itkInterpolateImageFunctionIRGBAUS3D_Pointer = itk::InterpolateImageFunction< itk::Image< itk::RGBAPixel< unsigned short >,3 >,double >::Pointer;
using itkInterpolateImageFunctionISC4D = itk::InterpolateImageFunction< itk::Image< signed char,4 >,double >;
using itkInterpolateImageFunctionISC4D_Pointer = itk::InterpolateImageFunction< itk::Image< signed char,4 >,double >::Pointer;
using itkInterpolateImageFunctionISC4F = itk::InterpolateImageFunction< itk::Image< signed char,4 >,float >;
using itkInterpolateImageFunctionISC4F_Pointer = itk::InterpolateImageFunction< itk::Image< signed char,4 >,float >::Pointer;
using itkInterpolateImageFunctionISS4D = itk::InterpolateImageFunction< itk::Image< signed short,4 >,double >;
using itkInterpolateImageFunctionISS4D_Pointer = itk::InterpolateImageFunction< itk::Image< signed short,4 >,double >::Pointer;
using itkInterpolateImageFunctionISS4F = itk::InterpolateImageFunction< itk::Image< signed short,4 >,float >;
using itkInterpolateImageFunctionISS4F_Pointer = itk::InterpolateImageFunction< itk::Image< signed short,4 >,float >::Pointer;
using itkInterpolateImageFunctionIUC4D = itk::InterpolateImageFunction< itk::Image< unsigned char,4 >,double >;
using itkInterpolateImageFunctionIUC4D_Pointer = itk::InterpolateImageFunction< itk::Image< unsigned char,4 >,double >::Pointer;
using itkInterpolateImageFunctionIUC4F = itk::InterpolateImageFunction< itk::Image< unsigned char,4 >,float >;
using itkInterpolateImageFunctionIUC4F_Pointer = itk::InterpolateImageFunction< itk::Image< unsigned char,4 >,float >::Pointer;
using itkInterpolateImageFunctionIULL4D = itk::InterpolateImageFunction< itk::Image< unsigned long long,4 >,double >;
using itkInterpolateImageFunctionIULL4D_Pointer = itk::InterpolateImageFunction< itk::Image< unsigned long long,4 >,double >::Pointer;
using itkInterpolateImageFunctionIULL4F = itk::InterpolateImageFunction< itk::Image< unsigned long long,4 >,float >;
using itkInterpolateImageFunctionIULL4F_Pointer = itk::InterpolateImageFunction< itk::Image< unsigned long long,4 >,float >::Pointer;
using itkInterpolateImageFunctionIUS4D = itk::InterpolateImageFunction< itk::Image< unsigned short,4 >,double >;
using itkInterpolateImageFunctionIUS4D_Pointer = itk::InterpolateImageFunction< itk::Image< unsigned short,4 >,double >::Pointer;
using itkInterpolateImageFunctionIUS4F = itk::InterpolateImageFunction< itk::Image< unsigned short,4 >,float >;
using itkInterpolateImageFunctionIUS4F_Pointer = itk::InterpolateImageFunction< itk::Image< unsigned short,4 >,float >::Pointer;
using itkInterpolateImageFunctionIF4D = itk::InterpolateImageFunction< itk::Image< float,4 >,double >;
using itkInterpolateImageFunctionIF4D_Pointer = itk::InterpolateImageFunction< itk::Image< float,4 >,double >::Pointer;
using itkInterpolateImageFunctionIF4F = itk::InterpolateImageFunction< itk::Image< float,4 >,float >;
using itkInterpolateImageFunctionIF4F_Pointer = itk::InterpolateImageFunction< itk::Image< float,4 >,float >::Pointer;
using itkInterpolateImageFunctionID4D = itk::InterpolateImageFunction< itk::Image< double,4 >,double >;
using itkInterpolateImageFunctionID4D_Pointer = itk::InterpolateImageFunction< itk::Image< double,4 >,double >::Pointer;
using itkInterpolateImageFunctionID4F = itk::InterpolateImageFunction< itk::Image< double,4 >,float >;
using itkInterpolateImageFunctionID4F_Pointer = itk::InterpolateImageFunction< itk::Image< double,4 >,float >::Pointer;
using itkInterpolateImageFunctionIVD44D = itk::InterpolateImageFunction< itk::Image< itk::Vector< double,4 >,4 >,double >;
using itkInterpolateImageFunctionIVD44D_Pointer = itk::InterpolateImageFunction< itk::Image< itk::Vector< double,4 >,4 >,double >::Pointer;
using itkInterpolateImageFunctionIVF44D = itk::InterpolateImageFunction< itk::Image< itk::Vector< float,4 >,4 >,double >;
using itkInterpolateImageFunctionIVF44D_Pointer = itk::InterpolateImageFunction< itk::Image< itk::Vector< float,4 >,4 >,double >::Pointer;
using itkInterpolateImageFunctionICVD44D = itk::InterpolateImageFunction< itk::Image< itk::CovariantVector< double,4 >,4 >,double >;
using itkInterpolateImageFunctionICVD44D_Pointer = itk::InterpolateImageFunction< itk::Image< itk::CovariantVector< double,4 >,4 >,double >::Pointer;
using itkInterpolateImageFunctionICVF44D = itk::InterpolateImageFunction< itk::Image< itk::CovariantVector< float,4 >,4 >,double >;
using itkInterpolateImageFunctionICVF44D_Pointer = itk::InterpolateImageFunction< itk::Image< itk::CovariantVector< float,4 >,4 >,double >::Pointer;
using itkInterpolateImageFunctionIRGBUC4D = itk::InterpolateImageFunction< itk::Image< itk::RGBPixel< unsigned char >,4 >,double >;
using itkInterpolateImageFunctionIRGBUC4D_Pointer = itk::InterpolateImageFunction< itk::Image< itk::RGBPixel< unsigned char >,4 >,double >::Pointer;
using itkInterpolateImageFunctionIRGBUS4D = itk::InterpolateImageFunction< itk::Image< itk::RGBPixel< unsigned short >,4 >,double >;
using itkInterpolateImageFunctionIRGBUS4D_Pointer = itk::InterpolateImageFunction< itk::Image< itk::RGBPixel< unsigned short >,4 >,double >::Pointer;
using itkInterpolateImageFunctionIRGBAUC4D = itk::InterpolateImageFunction< itk::Image< itk::RGBAPixel< unsigned char >,4 >,double >;
using itkInterpolateImageFunctionIRGBAUC4D_Pointer = itk::InterpolateImageFunction< itk::Image< itk::RGBAPixel< unsigned char >,4 >,double >::Pointer;
using itkInterpolateImageFunctionIRGBAUS4D = itk::InterpolateImageFunction< itk::Image< itk::RGBAPixel< unsigned short >,4 >,double >;
using itkInterpolateImageFunctionIRGBAUS4D_Pointer = itk::InterpolateImageFunction< itk::Image< itk::RGBAPixel< unsigned short >,4 >,double >::Pointer;
using itkInterpolateImageFunctionPA3DSCIFD = itk::InterpolateImageFunction< itk::PhasedArray3DSpecialCoordinatesImage< float >, double >;
using itkInterpolateImageFunctionPA3DSCIFD_Pointer = itk::InterpolateImageFunction< itk::PhasedArray3DSpecialCoordinatesImage< float >, double >::Pointer;
using itkInterpolateImageFunctionPA3DSCIUCD = itk::InterpolateImageFunction< itk::PhasedArray3DSpecialCoordinatesImage< unsigned char >, double >;
using itkInterpolateImageFunctionPA3DSCIUCD_Pointer = itk::InterpolateImageFunction< itk::PhasedArray3DSpecialCoordinatesImage< unsigned char >, double >::Pointer;


#include "itkImageFunctionBaseSwigInterface.h"
#include "ITKCommonBaseSwigInterface.h"
#include "itkInterpolateImageFunctionSwigInterface.h"
#include "itkRGBPixelSwigInterface.h"
#include "itkSizeSwigInterface.h"
#include "itkCovariantVectorSwigInterface.h"
#include "itkPointSwigInterface.h"
#include "itkContinuousIndexSwigInterface.h"
#include "itkIndexSwigInterface.h"
#include "itkRGBAPixelSwigInterface.h"
#endif
