{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Recognizes 2-finger pinch\/zoom gestures.
-- 
-- Whenever the distance between both tracked sequences changes, the
-- [GestureZoom::scaleChanged]("GI.Gtk.Objects.GestureZoom#g:signal:scaleChanged") signal is emitted to report
-- the scale factor.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.GestureZoom
    ( 

-- * Exported types
    GestureZoom(..)                         ,
    IsGestureZoom                           ,
    toGestureZoom                           ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [group]("GI.Gtk.Objects.Gesture#g:method:group"), [handlesSequence]("GI.Gtk.Objects.Gesture#g:method:handlesSequence"), [isActive]("GI.Gtk.Objects.Gesture#g:method:isActive"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isGroupedWith]("GI.Gtk.Objects.Gesture#g:method:isGroupedWith"), [isRecognized]("GI.Gtk.Objects.Gesture#g:method:isRecognized"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [reset]("GI.Gtk.Objects.EventController#g:method:reset"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [ungroup]("GI.Gtk.Objects.Gesture#g:method:ungroup"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getBoundingBox]("GI.Gtk.Objects.Gesture#g:method:getBoundingBox"), [getBoundingBoxCenter]("GI.Gtk.Objects.Gesture#g:method:getBoundingBoxCenter"), [getCurrentEvent]("GI.Gtk.Objects.EventController#g:method:getCurrentEvent"), [getCurrentEventDevice]("GI.Gtk.Objects.EventController#g:method:getCurrentEventDevice"), [getCurrentEventState]("GI.Gtk.Objects.EventController#g:method:getCurrentEventState"), [getCurrentEventTime]("GI.Gtk.Objects.EventController#g:method:getCurrentEventTime"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDevice]("GI.Gtk.Objects.Gesture#g:method:getDevice"), [getGroup]("GI.Gtk.Objects.Gesture#g:method:getGroup"), [getLastEvent]("GI.Gtk.Objects.Gesture#g:method:getLastEvent"), [getLastUpdatedSequence]("GI.Gtk.Objects.Gesture#g:method:getLastUpdatedSequence"), [getName]("GI.Gtk.Objects.EventController#g:method:getName"), [getPoint]("GI.Gtk.Objects.Gesture#g:method:getPoint"), [getPropagationLimit]("GI.Gtk.Objects.EventController#g:method:getPropagationLimit"), [getPropagationPhase]("GI.Gtk.Objects.EventController#g:method:getPropagationPhase"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getScaleDelta]("GI.Gtk.Objects.GestureZoom#g:method:getScaleDelta"), [getSequenceState]("GI.Gtk.Objects.Gesture#g:method:getSequenceState"), [getSequences]("GI.Gtk.Objects.Gesture#g:method:getSequences"), [getWidget]("GI.Gtk.Objects.EventController#g:method:getWidget").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setName]("GI.Gtk.Objects.EventController#g:method:setName"), [setPropagationLimit]("GI.Gtk.Objects.EventController#g:method:setPropagationLimit"), [setPropagationPhase]("GI.Gtk.Objects.EventController#g:method:setPropagationPhase"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setSequenceState]("GI.Gtk.Objects.Gesture#g:method:setSequenceState"), [setState]("GI.Gtk.Objects.Gesture#g:method:setState"), [setStaticName]("GI.Gtk.Objects.EventController#g:method:setStaticName").

#if defined(ENABLE_OVERLOADING)
    ResolveGestureZoomMethod                ,
#endif

-- ** getScaleDelta #method:getScaleDelta#

#if defined(ENABLE_OVERLOADING)
    GestureZoomGetScaleDeltaMethodInfo      ,
#endif
    gestureZoomGetScaleDelta                ,


-- ** new #method:new#

    gestureZoomNew                          ,




 -- * Signals


-- ** scaleChanged #signal:scaleChanged#

    GestureZoomScaleChangedCallback         ,
#if defined(ENABLE_OVERLOADING)
    GestureZoomScaleChangedSignalInfo       ,
#endif
    afterGestureZoomScaleChanged            ,
    onGestureZoomScaleChanged               ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.EventSequence as Gdk.EventSequence
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.ComponentTransfer as Gsk.ComponentTransfer
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.Gesture as Gtk.Gesture
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.Gesture as Gtk.Gesture

#endif

-- | Memory-managed wrapper type.
newtype GestureZoom = GestureZoom (SP.ManagedPtr GestureZoom)
    deriving (Eq)

instance SP.ManagedPtrNewtype GestureZoom where
    toManagedPtr (GestureZoom p) = p

foreign import ccall "gtk_gesture_zoom_get_type"
    c_gtk_gesture_zoom_get_type :: IO B.Types.GType

instance B.Types.TypedObject GestureZoom where
    glibType = c_gtk_gesture_zoom_get_type

instance B.Types.GObject GestureZoom

-- | Type class for types which can be safely cast to t'GestureZoom', for instance with `toGestureZoom`.
class (SP.GObject o, O.IsDescendantOf GestureZoom o) => IsGestureZoom o
instance (SP.GObject o, O.IsDescendantOf GestureZoom o) => IsGestureZoom o

instance O.HasParentTypes GestureZoom
type instance O.ParentTypes GestureZoom = '[Gtk.Gesture.Gesture, Gtk.EventController.EventController, GObject.Object.Object]

-- | Cast to t'GestureZoom', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toGestureZoom :: (MIO.MonadIO m, IsGestureZoom o) => o -> m GestureZoom
toGestureZoom = MIO.liftIO . B.ManagedPtr.unsafeCastTo GestureZoom

-- | Convert t'GestureZoom' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe GestureZoom) where
    gvalueGType_ = c_gtk_gesture_zoom_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr GestureZoom)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr GestureZoom)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject GestureZoom ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveGestureZoomMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveGestureZoomMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveGestureZoomMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveGestureZoomMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveGestureZoomMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveGestureZoomMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveGestureZoomMethod "group" o = Gtk.Gesture.GestureGroupMethodInfo
    ResolveGestureZoomMethod "handlesSequence" o = Gtk.Gesture.GestureHandlesSequenceMethodInfo
    ResolveGestureZoomMethod "isActive" o = Gtk.Gesture.GestureIsActiveMethodInfo
    ResolveGestureZoomMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveGestureZoomMethod "isGroupedWith" o = Gtk.Gesture.GestureIsGroupedWithMethodInfo
    ResolveGestureZoomMethod "isRecognized" o = Gtk.Gesture.GestureIsRecognizedMethodInfo
    ResolveGestureZoomMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveGestureZoomMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveGestureZoomMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveGestureZoomMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveGestureZoomMethod "reset" o = Gtk.EventController.EventControllerResetMethodInfo
    ResolveGestureZoomMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveGestureZoomMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveGestureZoomMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveGestureZoomMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveGestureZoomMethod "ungroup" o = Gtk.Gesture.GestureUngroupMethodInfo
    ResolveGestureZoomMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveGestureZoomMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveGestureZoomMethod "getBoundingBox" o = Gtk.Gesture.GestureGetBoundingBoxMethodInfo
    ResolveGestureZoomMethod "getBoundingBoxCenter" o = Gtk.Gesture.GestureGetBoundingBoxCenterMethodInfo
    ResolveGestureZoomMethod "getCurrentEvent" o = Gtk.EventController.EventControllerGetCurrentEventMethodInfo
    ResolveGestureZoomMethod "getCurrentEventDevice" o = Gtk.EventController.EventControllerGetCurrentEventDeviceMethodInfo
    ResolveGestureZoomMethod "getCurrentEventState" o = Gtk.EventController.EventControllerGetCurrentEventStateMethodInfo
    ResolveGestureZoomMethod "getCurrentEventTime" o = Gtk.EventController.EventControllerGetCurrentEventTimeMethodInfo
    ResolveGestureZoomMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveGestureZoomMethod "getDevice" o = Gtk.Gesture.GestureGetDeviceMethodInfo
    ResolveGestureZoomMethod "getGroup" o = Gtk.Gesture.GestureGetGroupMethodInfo
    ResolveGestureZoomMethod "getLastEvent" o = Gtk.Gesture.GestureGetLastEventMethodInfo
    ResolveGestureZoomMethod "getLastUpdatedSequence" o = Gtk.Gesture.GestureGetLastUpdatedSequenceMethodInfo
    ResolveGestureZoomMethod "getName" o = Gtk.EventController.EventControllerGetNameMethodInfo
    ResolveGestureZoomMethod "getPoint" o = Gtk.Gesture.GestureGetPointMethodInfo
    ResolveGestureZoomMethod "getPropagationLimit" o = Gtk.EventController.EventControllerGetPropagationLimitMethodInfo
    ResolveGestureZoomMethod "getPropagationPhase" o = Gtk.EventController.EventControllerGetPropagationPhaseMethodInfo
    ResolveGestureZoomMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveGestureZoomMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveGestureZoomMethod "getScaleDelta" o = GestureZoomGetScaleDeltaMethodInfo
    ResolveGestureZoomMethod "getSequenceState" o = Gtk.Gesture.GestureGetSequenceStateMethodInfo
    ResolveGestureZoomMethod "getSequences" o = Gtk.Gesture.GestureGetSequencesMethodInfo
    ResolveGestureZoomMethod "getWidget" o = Gtk.EventController.EventControllerGetWidgetMethodInfo
    ResolveGestureZoomMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveGestureZoomMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveGestureZoomMethod "setName" o = Gtk.EventController.EventControllerSetNameMethodInfo
    ResolveGestureZoomMethod "setPropagationLimit" o = Gtk.EventController.EventControllerSetPropagationLimitMethodInfo
    ResolveGestureZoomMethod "setPropagationPhase" o = Gtk.EventController.EventControllerSetPropagationPhaseMethodInfo
    ResolveGestureZoomMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveGestureZoomMethod "setSequenceState" o = Gtk.Gesture.GestureSetSequenceStateMethodInfo
    ResolveGestureZoomMethod "setState" o = Gtk.Gesture.GestureSetStateMethodInfo
    ResolveGestureZoomMethod "setStaticName" o = Gtk.EventController.EventControllerSetStaticNameMethodInfo
    ResolveGestureZoomMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveGestureZoomMethod t GestureZoom, O.OverloadedMethod info GestureZoom p) => OL.IsLabel t (GestureZoom -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveGestureZoomMethod t GestureZoom, O.OverloadedMethod info GestureZoom p, R.HasField t GestureZoom p) => R.HasField t GestureZoom p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveGestureZoomMethod t GestureZoom, O.OverloadedMethodInfo info GestureZoom) => OL.IsLabel t (O.MethodProxy info GestureZoom) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal GestureZoom::scale-changed
-- | Emitted whenever the distance between both tracked sequences changes.
type GestureZoomScaleChangedCallback =
    Double
    -- ^ /@scale@/: Scale delta, taking the initial state as 1:1
    -> IO ()

type C_GestureZoomScaleChangedCallback =
    Ptr GestureZoom ->                      -- object
    CDouble ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_GestureZoomScaleChangedCallback`.
foreign import ccall "wrapper"
    mk_GestureZoomScaleChangedCallback :: C_GestureZoomScaleChangedCallback -> IO (FunPtr C_GestureZoomScaleChangedCallback)

wrap_GestureZoomScaleChangedCallback :: 
    GObject a => (a -> GestureZoomScaleChangedCallback) ->
    C_GestureZoomScaleChangedCallback
wrap_GestureZoomScaleChangedCallback gi'cb gi'selfPtr scale _ = do
    let scale' = realToFrac scale
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  scale'


-- | Connect a signal handler for the [scaleChanged](#signal:scaleChanged) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' gestureZoom #scaleChanged callback
-- @
-- 
-- 
onGestureZoomScaleChanged :: (IsGestureZoom a, MonadIO m) => a -> ((?self :: a) => GestureZoomScaleChangedCallback) -> m SignalHandlerId
onGestureZoomScaleChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_GestureZoomScaleChangedCallback wrapped
    wrapped'' <- mk_GestureZoomScaleChangedCallback wrapped'
    connectSignalFunPtr obj "scale-changed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [scaleChanged](#signal:scaleChanged) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' gestureZoom #scaleChanged callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterGestureZoomScaleChanged :: (IsGestureZoom a, MonadIO m) => a -> ((?self :: a) => GestureZoomScaleChangedCallback) -> m SignalHandlerId
afterGestureZoomScaleChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_GestureZoomScaleChangedCallback wrapped
    wrapped'' <- mk_GestureZoomScaleChangedCallback wrapped'
    connectSignalFunPtr obj "scale-changed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data GestureZoomScaleChangedSignalInfo
instance SignalInfo GestureZoomScaleChangedSignalInfo where
    type HaskellCallbackType GestureZoomScaleChangedSignalInfo = GestureZoomScaleChangedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_GestureZoomScaleChangedCallback cb
        cb'' <- mk_GestureZoomScaleChangedCallback cb'
        connectSignalFunPtr obj "scale-changed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.GestureZoom::scale-changed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-GestureZoom.html#g:signal:scaleChanged"})

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList GestureZoom
type instance O.AttributeList GestureZoom = GestureZoomAttributeList
type GestureZoomAttributeList = ('[ '("nPoints", Gtk.Gesture.GestureNPointsPropertyInfo), '("name", Gtk.EventController.EventControllerNamePropertyInfo), '("propagationLimit", Gtk.EventController.EventControllerPropagationLimitPropertyInfo), '("propagationPhase", Gtk.EventController.EventControllerPropagationPhasePropertyInfo), '("widget", Gtk.EventController.EventControllerWidgetPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList GestureZoom = GestureZoomSignalList
type GestureZoomSignalList = ('[ '("begin", Gtk.Gesture.GestureBeginSignalInfo), '("cancel", Gtk.Gesture.GestureCancelSignalInfo), '("end", Gtk.Gesture.GestureEndSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("scaleChanged", GestureZoomScaleChangedSignalInfo), '("sequenceStateChanged", Gtk.Gesture.GestureSequenceStateChangedSignalInfo), '("update", Gtk.Gesture.GestureUpdateSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method GestureZoom::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "GestureZoom" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_gesture_zoom_new" gtk_gesture_zoom_new :: 
    IO (Ptr GestureZoom)

-- | Returns a newly created @GtkGesture@ that recognizes
-- pinch\/zoom gestures.
gestureZoomNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m GestureZoom
    -- ^ __Returns:__ a newly created @GtkGestureZoom@
gestureZoomNew  = liftIO $ do
    result <- gtk_gesture_zoom_new
    checkUnexpectedReturnNULL "gestureZoomNew" result
    result' <- (wrapObject GestureZoom) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method GestureZoom::get_scale_delta
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "gesture"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "GestureZoom" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkGestureZoom`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TDouble)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_gesture_zoom_get_scale_delta" gtk_gesture_zoom_get_scale_delta :: 
    Ptr GestureZoom ->                      -- gesture : TInterface (Name {namespace = "Gtk", name = "GestureZoom"})
    IO CDouble

-- | Gets the scale delta.
-- 
-- If /@gesture@/ is active, this function returns the zooming
-- difference since the gesture was recognized (hence the
-- starting point is considered 1:1). If /@gesture@/ is not
-- active, 1 is returned.
gestureZoomGetScaleDelta ::
    (B.CallStack.HasCallStack, MonadIO m, IsGestureZoom a) =>
    a
    -- ^ /@gesture@/: a @GtkGestureZoom@
    -> m Double
    -- ^ __Returns:__ the scale delta
gestureZoomGetScaleDelta gesture = liftIO $ do
    gesture' <- unsafeManagedPtrCastPtr gesture
    result <- gtk_gesture_zoom_get_scale_delta gesture'
    let result' = realToFrac result
    touchManagedPtr gesture
    return result'

#if defined(ENABLE_OVERLOADING)
data GestureZoomGetScaleDeltaMethodInfo
instance (signature ~ (m Double), MonadIO m, IsGestureZoom a) => O.OverloadedMethod GestureZoomGetScaleDeltaMethodInfo a signature where
    overloadedMethod = gestureZoomGetScaleDelta

instance O.OverloadedMethodInfo GestureZoomGetScaleDeltaMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.GestureZoom.gestureZoomGetScaleDelta",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-GestureZoom.html#v:gestureZoomGetScaleDelta"
        })


#endif


